       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA634.                                          
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *                 CUSTOMER INFORMATION SYSTEM                   *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M   S U M M A R Y                 *         
      *                                                               *         
      * PROCESSES WMS INPUT FILES FOR CREATING FEED FILE FOR SERVICE  *         
      * INTERRUPTION CARDS.                                           *         
      *                                                               *         
      *****************************************************************         
      *                                                               *         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE    INITIALS     REASON                              *         
      *    ________  ________     __________________________________  *         
      *    07/2009   SDHAL        INITIAL VERSION.                    *         
P00599*    09/2012   SDHAL        CREDIT SIMPLIFICATION               *         
P00599*    02/2013   DMS          MOVE COMMON DATE TO STATEMENT DATE  *         
P00599*    02/2013   DMS          MOVE COMMON DATE TO HDR STMT DATE   *         
A04518*    03/2013   RAJ          Add alternate date.                 *         
A04127**  01/16/15  SV95326       ADD WS-ALOC-ITPA-PROCESS PARAMETER  *         
      **                          WHILE CALLING SCSCA184.             *         
      *****************************************************************         
      *                                                               *         
      *         -----    BASIC SEQUENCE STRUCTURE   -----             *         
      * 0000         MODULE CONTROL                                   *         
      * 0100 - 0999  INITIALIZATION                                   *         
      * 1000 - 1999  FUNCTIONAL CONTROL                               *         
      * 2000 - 4999  DETAIL LOGIC                                     *         
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               *         
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     *         
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    *         
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    *         
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSWMSHD.                                                           
       COPY CSSWMSDT.                                                           
      *                                                                         
P00599     SELECT FCSCOEXT-FILE                                         
P00599        ASSIGN UT-S-FCSCOEXT                                      
P00599        FILE STATUS IS WS-COEXT-STATUS.                           
                                                                        
       COPY CSSWMSFB.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDWMSHD.                                                           
       COPY FIOWMSHD.                                                           
       COPY CFDWMSDT.                                                           
       COPY FIOWMSDT.                                                           
                                                                        
P00599 FD  FCSCOEXT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
P00599 01  FCSCOEXT.                                                    
P00599     02  CO-DATA-REC.                                             
P00599         05  E-CO-SORT-KEY              PIC X(59).                
P00599         05  E-CO-DATA                  PIC X(1316).              
      *                                                                         
       COPY CFDWMSFB.                                                           
       01  FIOWMSFB.                                                    
           05  FIOCAFB-DATA             PIC X(80) VALUE SPACES.         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA634'.
MSQ017     COPY MFASQLM.
      *                                                                         
P00599 01  WS-NAME-ADDR-TABLE.                                          
           05  WS-NAME-ADDR-ENTRY         OCCURS 6                      
                                         INDEXED BY WS-NM-ADDR-INDX.    
               10 WS-NAME-ADDR-TYPE          PIC X(02).                 
               10 WS-NAME-ADDR-LINE          PIC X(50).                 
      *                                                                 00293900
P00599 01  WS-MAILING-ADDR.                                             
           05  WS-MAILING-ADDRESS            PIC X(50) OCCURS 6 TIMES.  
      *                                                                 00293900
P00599 01  WS-PREMISE-ADDR.                                             
           05  WS-PR-STREET                     PIC X(79).              
           05  WS-PR-ADDR-OVERFLOW              PIC X(26).              
           05  WS-PR-ADDR-CITY-STATE            PIC X(30).              
           05  WS-PR-ADDR-CITY-STATE-ZIP        PIC X(41).              
           05  WS-PR-ADDR-ZIP.                                          
               10  WS-PR-ADDR-ZIP-CODE          PIC X(05).              
               10  WS-PR-ADDR-ZIP-PLUS-4        PIC X(04).              
               10  WS-PR-ADDR-USPS-DELIV-PT-CD  PIC X(02).              
      *                                                                 00025400
      *                                                                 00293900
       01  WS-MISC.                                                     
           05  WS-FB-STATUS             PIC X(02).                      
               88  FB-SUCCESSFUL           VALUE '00'.                  
P00599     05  WS-COEXT-STATUS          PIC X(02).                      
               88  COEXT-SUCCESSFUL        VALUE '00'.                  
           05  WS-WMSHD-STATUS          PIC X(02).                      
               88  WMSHD-SUCCESSFUL        VALUE '00'.                  
           05  WS-END-OF-WMSHD          PIC X VALUE 'N'.                
               88  END-OF-WMSHD            VALUE 'Y'.                   
           05  WS-WMSDT-STATUS          PIC X(02).                      
               88  WMSDT-SUCCESSFUL        VALUE '00'.                  
           05  WS-END-OF-WMSDT          PIC X VALUE 'N'.                
               88  END-OF-WMSDT            VALUE 'Y'.                   
                                                                        
           05  WS-RED-FL-NULL-IND       PIC S9(4) COMP  VALUE 0.        
           05  WS-END-NULL-IND          PIC S9(4) COMP  VALUE 0.        
           05  WS-REC-CNT               PIC 9(9)  VALUE 0.              
           05  WS-REC-WREMAIL           PIC 9(9)  VALUE 0.              
           05  WS-REC-WRPOST            PIC 9(9)  VALUE 0.              
           05  WS-REC-SKIPPED           PIC 9(9)  VALUE 0.              
           05  WS-FIRST-TIME            PIC X(01) VALUE 'Y'.            
P00599     05  WS-PCARD-COMM-TYPE-CD    PIC X(2)  VALUE '41'.           
P00599     05  WS-PCARD-COMM-SUBTYPE-CD PIC X(2)  VALUE '09'.           
P00599     05  WS-COMMON-DATE              PIC X(10) VALUE 'COMMONDATE'.
P00599     05  WS-DATE-BILLED-1.                                        
P00599         10 WS-DATE-YY-1               PIC X(02).                 
P00599         10 WS-DATE-MM-1               PIC X(02).                 
P00599         10 WS-DATE-DD-1               PIC X(02).                 
P00599     05  WS-DATE-BILLED.                                          
P00599         10 WS-DATE-CC                 PIC X(02).                 
P00599         10 WS-DATE-YY                 PIC X(02).                 
P00599         10 FILLER                     PIC X(01).                 
P00599         10 WS-DATE-MM                 PIC X(02).                 
P00599         10 FILLER                     PIC X(01).                 
P00599         10 WS-DATE-DD                 PIC X(02).                 
                                                                        
P00599     05  WS-SUB                   PIC 9(02)  VALUE ZEROS.         
P00599     05  WS-SUB1                  PIC 9(02)  VALUE ZEROS.         
           05  SUB-HDR                  PIC 9(03)  VALUE ZEROS.         
           05  SUB-HOLD                 PIC 9(03)  VALUE ZEROS.         
           05  WS-IS-EBILL              PIC X(01)  VALUE 'N'.           
           05  WS-HDR-COUNT             PIC 9(04) COMP VALUE 0.         
P00599     05  WS-DISPLAY-SCSCA         PIC X(8).                       
P00599     05  WS-DISPLAY-SQLCODE       PIC -ZZZZZZZZ9.                 
           05  HOLD-ACCOUNT-NO          PIC X(13).                      
           05  HOLD-REQUEST-NO          PIC X(10).                      
           05  HOLD-EMAIL-ADDR.                                         
               49 HOLD-EMAIL-ADDR-LEN   PIC S9(4) USAGE COMP.           
               49 HOLD-EMAIL-ADDR-TX    PIC X(100).                     
           05  HOLD-EMAIL               PIC X(100).                     
           05  HOLD-EMAIL-2PARTS        REDEFINES HOLD-EMAIL.           
               10 EMAIL-PART1           PIC X(50).                      
               10 EMAIL-PART2           PIC X(50).                      
           05  WS-TMP-PHONE             PIC X(10) VALUE SPACES.         
           05  WS-DURATION-NUM          PIC Z(5)9.                      
                                                                        
           05  WS-WMSHDR-ARRAY OCCURS 1 TO 9999 TIMES                   
                      DEPENDING ON WS-HDR-COUNT                         
                      INDEXED BY WS-WMSHD-INX.                          
               10  WS-REQUEST-NO        PIC X(10).                      
               10  WS-MESSAGE-NO        PIC X(05).                      
               10  WS-DATE              PIC X(10).                      
               10  WS-START-TIME        PIC X(08).                      
               10  WS-DURATION          PIC X(06).                      
               10  WS-CONTACT-NAME      PIC X(50).                      
               10  WS-CONTACT-PHONE     PIC X(10).                      
               10  WS-WK-COMPANY-NM     PIC X(50).                      
A04518         10  WS-ALT-DATE          PIC X(10).                      
A04518         10  FILLER               PIC X(41).                      
A04127     05  WS-ALOC-ITPA-PROCESS     PIC X(01).                      
      *                                                                         
       01  WS-REQUEST-LINE1.                                            
           05  FILLER                   PIC X(34) VALUE                 
                     'Request IDs processed in this run:'.              
           05  FILLER                   PIC X(46) VALUE SPACES.         
       01  WS-REQUEST-LINE2.                                            
           05  WS-WRITE-REQ-ID          PIC X(10) VALUE SPACES.         
           05  FILLER                   PIC X(70) VALUE SPACES.         
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                   PIC X(28) VALUE                 
                     '** NO REJECTS IN THIS RUN **'.                    
           05  FILLER                   PIC X(52) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-HEADER-LINE1.                                         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     'SCE&G      RUN DATE : '.                          
           05  FILLER                   PIC X(43) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-HEADER-LINE2.                                         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(37) VALUE                 
                     'LIST OF ACCOUNTS REJECTED BY PCSCA634'.           
           05  FILLER                   PIC X(38) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-HEADER-LINE3.                                         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(38) VALUE                 
                     'SERVICE INTERRUPTION LETTER PROCESSING'.          
           05  FILLER                   PIC X(37) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-HEADER-LINE4.                                         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(52) VALUE                 
                '----------------------------------------------------'. 
           05  FILLER                   PIC X(23) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-FOOTER-LINE.                                          
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(22) VALUE                 
                     'TOTAL ACCTS SKIPPED : '.                          
           05  WS-ACCT-SKIPPED          PIC 9(09).                      
           05  FILLER                   PIC X(44) VALUE SPACES.         
      *                                                                         
       01  WS-RPT-DETAIL-LINE.                                          
           05  FILLER                   PIC X(15) VALUE                 
                     '     ACCOUNT # '.                                 
           05  WS-ACCT-NO               PIC X(13).                      
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  WS-REASON                PIC X(03) VALUE SPACES.         
           05  FILLER                   PIC X(05) VALUE SPACES.         
           05  FILLER                   PIC X(06) VALUE                 
                     'REQ # '.                                          
           05  WS-WMSREQ-NO             PIC X(10) VALUE SPACES.         
           05  FILLER                   PIC X(23) VALUE SPACES.         
      *                                                                         
P00599********WS FOR CO-LAYOUTS**********************************               
P00599 COPY FIOCOID.                                                            
P00599 COPY FIOCOINF.                                                           
P00599 COPY FIOCOKEY.                                                           
      *                                                                         
P00599*** COPYBOOKS FOR WORKING STORAGE FOR SCSCA184                            
P00599 COPY CWSCA184.                                                           
P00599 COPY CWS00010.                                                           
      *                                                                         
       01 WS-MST-SUB-ACCT-IND-AT         PIC X(01).                     
       01 WS-CODE-PRNT-BLL-MST-AT        PIC X(01).                     
       01 WS-CODE-TEMP-BILL-AT           PIC X(01).                     
P00599 01 WS-SCSCA-RETURN-CODE           PIC S9(4) COMP.                
       01 LS-CURR-WQ-ITEM                PIC S9(4) COMP.                
       01 WS-HOLD-BARCODE-ZIP            PIC X(11).                     
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF         PIC S9(04)  COMP.          
               10  WS-PRIORITY-WF            PIC X(1).                  
               10  WS-ROUTE-CATEGORY-WF      PIC X(01).                 
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF    PIC S9(04)  COMP.          
                   15  WS-COMMENTS-TEXT-WF   PIC X(250).                
               10  FILLER                    PIC X(244).                
      *                                                                         
      ********WS FOR DB2 & CICS ERROR PROCESSING*****************               
       COPY CWS00303.                                                           
      ********WS-ABEND-SWITCH************************************               
       COPY CWS09900.                                                           
      ********SQLCA**********************************************               
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ACCOUNT (AT)                                                     
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_STATS (CE)                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_EMAIL (NE)                                                  
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_COMM_DATA (KO)                                                   
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
      *                                                                         
P00599*****************************************************************         
P00599*  DCLGEN FOR CSS_JOB_PARM.                                     *         
P00599*****************************************************************         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBJBPARM                                                 
P00599     END-EXEC.                                                            
                                                                        
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA634 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *****************************************************************         
      *   CONTROLS MAIN PROCESSING FLOW                                         
      *****************************************************************         
                                                                        
            PERFORM 0100-INITIALIZE          THRU 0100-EXIT.            
            PERFORM 7000-READ-INPUT-FILE1    THRU 7000-EXIT.            
            PERFORM 1000-LOAD-HDR            THRU 1000-EXIT             
                    UNTIL END-OF-WMSHD.                                 
            MOVE SUB-HDR                     TO WS-HDR-COUNT.           
            PERFORM 7200-READ-INPUT-FILE2    THRU 7200-EXIT.            
            PERFORM 1100-PROCESS-DTL         THRU 1100-EXIT             
                    UNTIL END-OF-WMSDT.                                 
            PERFORM 8110-WRITE-FB-FOOTER     THRU 8110-EXIT.            
            PERFORM 9000-TERMINATE           THRU  9000-EXIT.           
            DISPLAY '**************************'.                       
            DISPLAY '***     END OF RUN     ***'.                       
            DISPLAY '**************************'.                       
            DISPLAY '***  ACCOUNTS READ = ' WS-REC-CNT.                 
            DISPLAY '***  ACCOUNTS WRIT (EMAIL) = ' WS-REC-WREMAIL.     
            DISPLAY '***  ACCOUNTS WRIT (POST)  = ' WS-REC-WRPOST.      
            DISPLAY '***  ACCOUNTS SKIP = ' WS-REC-SKIPPED.             
            STOP RUN.                                                   
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0100-INITIALIZE.                                                 
      *****************************************************************         
      * INITIALIZE RUN                                                          
      * OPEN FILES FOR READ AND WRITE.                                          
      *****************************************************************         
      *                                                                         
           INITIALIZE                  WS-FB-STATUS                     
P00599                                 WS-COEXT-STATUS                  
                                       WS-WMSHD-STATUS                  
                                       WS-WMSDT-STATUS                  
                                       WS-END-OF-WMSHD                  
                                       WS-END-OF-WMSDT.                 
                                                                        
P00599     OPEN OUTPUT FCSCOEXT-FILE.                                   
P00599     IF NOT COEXT-SUCCESSFUL                                      
                MOVE +0012 TO RETURN-CODE                               
                DISPLAY '**************************************'        
P00599          DISPLAY '**  ERROR OPENING FCSCOEXT          **'        
P00599          DISPLAY '**  FILE STATUS = ' WS-COEXT-STATUS            
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSWMSFB-FILE.                                   
           IF NOT FB-SUCCESSFUL                                         
                MOVE +0012 TO RETURN-CODE                               
                DISPLAY '**************************************'        
                DISPLAY '**  ERROR OPENING FCSWMSFB          **'        
                DISPLAY '**  FILE STATUS = ' WS-FB-STATUS               
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
           OPEN INPUT  FCSWMSHD-FILE.                                   
           IF NOT WMSHD-SUCCESSFUL                                      
                MOVE +0012 TO RETURN-CODE                               
                DISPLAY '**************************************'        
                DISPLAY '**  ERROR OPENING FCSWMSHD          **'        
                DISPLAY '**  FILE STATUS = ' WS-WMSHD-STATUS            
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
           OPEN INPUT  FCSWMSDT-FILE.                                   
           IF NOT WMSDT-SUCCESSFUL                                      
                MOVE +0012 TO RETURN-CODE                               
                DISPLAY '**************************************'        
                DISPLAY '**  ERROR OPENING FCSWMSDT          **'        
                DISPLAY '**  FILE STATUS = ' WS-WMSDT-STATUS            
                DISPLAY '**************************************'        
                PERFORM 9900-ABEND THRU 9900-EXIT                       
           END-IF.                                                      
                                                                        
P00599     PERFORM 7700-GET-COMMON-DATE      THRU 7700-EXIT.            
P00599     MOVE G6-PARM-DATA              TO WS-DATE-BILLED.            
P00599     MOVE WS-DATE-YY                TO WS-DATE-YY-1.              
P00599     MOVE WS-DATE-MM                TO WS-DATE-MM-1.              
P00599     MOVE WS-DATE-DD                TO WS-DATE-DD-1.              
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * LOAD WMS REQUEST HEADERS                                                
      *****************************************************************         
       1000-LOAD-HDR.                                                   
      *                                                                         
           INITIALIZE                   WS-DURATION-NUM.                
           ADD +1                    TO SUB-HDR.                        
           MOVE FIOWMSHD-DATA-REC    TO WS-WMSHDR-ARRAY(SUB-HDR).       
           MOVE WS-DURATION(SUB-HDR) TO WS-DURATION-NUM.                
           MOVE WS-DURATION-NUM      TO WS-DURATION(SUB-HDR).           
                                                                        
           INITIALIZE                          FIOWMSHD-DATA.           
           PERFORM 7000-READ-INPUT-FILE1       THRU 7000-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * PROCESS WMS REQUEST DETAILS                                             
      *****************************************************************         
       1100-PROCESS-DTL.                                                
      *                                                                         
           ADD +1                                TO WS-REC-CNT.         
                                                                        
           INITIALIZE                            HOLD-EMAIL-ADDR        
                                                 HOLD-EMAIL             
                                                 DCLCSS-CUST-EMAIL.     
           MOVE E-FWMSDT-REQUEST-NO              TO HOLD-REQUEST-NO.    
           MOVE E-FWMSDT-ACCOUNT-NO              TO HOLD-ACCOUNT-NO.    
           MOVE HOLD-ACCOUNT-NO                  TO AT-ACCOUNT-NO.      
                                                                        
           PERFORM 7500-GET-ACCOUNT-DATA         THRU 7500-EXIT.        
           MOVE AT-CUSTOMER-NO                   TO NE-CUSTOMER-NO.     
                                                                        
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'B'                                                 
                   ADD 1                            TO WS-REC-SKIPPED   
                   MOVE 'FB '                       TO WS-REASON        
                   PERFORM 8100-WRITE-FB-FILE       THRU 8100-EXIT      
               WHEN 'A'                                                 
                   PERFORM 7600-GET-CUST-EMAIL      THRU 7600-EXIT      
                   PERFORM 2000-FETCH-HEADER-DATA   THRU 2000-EXIT      
                   IF WS-IS-EBILL = 'Y'                                 
                       MOVE NE-EMAIL-ADDRESS-TX     TO HOLD-EMAIL-ADDR  
                       MOVE HOLD-EMAIL-ADDR-TX      TO HOLD-EMAIL       
                   END-IF                                               
P00599             PERFORM 2100-GET-MAIL-NAME-ADDRESS                   
                                                    THRU 2100-EXIT      
                   PERFORM 6000-LOAD-COMM-DATA      THRU 6000-EXIT      
P00599             PERFORM 8000-WRITE-CO-FILE    THRU 8000-EXIT         
               WHEN OTHER                                               
                   ADD 1                            TO WS-REC-SKIPPED   
                   MOVE 'OTH'                       TO WS-REASON        
                   PERFORM 8100-WRITE-FB-FILE       THRU 8100-EXIT      
           END-EVALUATE.                                                
                                                                        
           INITIALIZE                            FIOWMSDT-DATA          
                                                 FIOCAFB-DATA           
                                                 WS-IS-EBILL.           
           PERFORM 7200-READ-INPUT-FILE2         THRU 7200-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** FETCH MATCHING REQUEST HEADER DATA                          **         
      *****************************************************************         
       2000-FETCH-HEADER-DATA.                                          
      *                                                                         
            MOVE 0                        TO SUB-HOLD.                  
            PERFORM VARYING WS-WMSHD-INX FROM 1 BY 1                    
            UNTIL (SUB-HOLD > 0) OR (WS-WMSHD-INX > WS-HDR-COUNT)       
                IF HOLD-REQUEST-NO = WS-REQUEST-NO(WS-WMSHD-INX)        
                   SET  SUB-HOLD          TO WS-WMSHD-INX               
                END-IF                                                  
            END-PERFORM.                                                
            IF SUB-HOLD = 0                                             
                DISPLAY '************ PCSCA634 *******************'     
                DISPLAY '**   ERROR - COULD NOT LOCATE HEADER   **'     
                DISPLAY '**   FOR REQUEST NO = ' HOLD-REQUEST-NO        
                DISPLAY '**       ACCOUNT NO = ' HOLD-ACCOUNT-NO        
                DISPLAY '********* FATAL ERROR - ABEND ***********'     
                PERFORM 9000-TERMINATE THRU 9000-EXIT                   
            END-IF.                                                     
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
P00599*  THIS ROUTINE WILL CALL SCSCA184 TO OBTAIN MAIL NAME ADDRESS. *         
      *****************************************************************         
      *                                                                         
P00599 2100-GET-MAIL-NAME-ADDRESS.                                      
                                                                        
           INITIALIZE WS-NAME-ADDR-TABLE                                
                      WS-PREMISE-ADDR.                                  
           MOVE HOLD-ACCOUNT-NO          TO WS-ACCOUNT-NO-AS.           
           MOVE 'A'                      TO WS-ADDRESS-FLAG.            
           MOVE AT-CUSTOMER-NO           TO WS-CUSTOMER-NO-AS.          
           MOVE AT-ADDRESS-ID            TO WS-ADDRESS-ID-AS.           
           MOVE AT-ADDRESS-FORMAT        TO WS-ADDRESS-FORMAT-AS.       
                                                                        
           DISPLAY 'CALLING SCSCA184 FROM PCSCA634 FOR 'AT-ACCOUNT-NO.  
                                                                        
           CALL 'SCSCA184' USING WS-SCSCA184-PARMS                      
                               WS-MST-SUB-ACCT-IND-AT                   
                               WS-CODE-PRNT-BLL-MST-AT                  
                               WS-CODE-TEMP-BILL-AT                     
                               WS-SCSCA-RETURN-CODE                     
                               LS-CURR-WQ-ITEM                          
                               WS-BILLING-WQ-ITEMS-WF                   
A04127                         WS-ALOC-ITPA-PROCESS.                    
                                                                        
           MOVE 'SCSCA184'               TO WS-DISPLAY-SCSCA.           
                                                                        
           IF WS-SCSCA-RETURN-CODE NOT = 0                              
              MOVE 12 TO RETURN-CODE                                    
              DISPLAY ' '                                               
              DISPLAY '********************************************'    
              DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA             
              DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE         
              DISPLAY '**  ACCOUNT     = ' HOLD-ACCOUNT-NO              
              DISPLAY '********************************************'    
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
                                                                        
           MOVE WS-NAME-ADDRESS-TABLE     TO WS-NAME-ADDR-TABLE.        
           MOVE WS-PREMISE-ADDRESS        TO WS-PREMISE-ADDR.           
           MOVE WS-BARCODE-ZIP            TO WS-HOLD-BARCODE-ZIP.       
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                                         UNTIL WS-SUB > 6               
            MOVE WS-NAME-ADDR-LINE(WS-SUB) TO                           
                                        WS-MAILING-ADDRESS(WS-SUB)      
           END-PERFORM.                                                 
                                                                        
           PERFORM 5100-FORMAT-MAIL-ADDR         THRU 5100-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00599* FORMATS THE MAILING ADDRESS MOVING THE SPACES TO BACK          *        
      ******************************************************************        
P00599 5100-FORMAT-MAIL-ADDR.                                           
      *                                                                 00195700
           PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 6          
             IF WS-MAILING-ADDRESS(WS-SUB) EQUAL TO SPACES              
                COMPUTE WS-SUB1 = WS-SUB + 1                            
                PERFORM VARYING WS-SUB1 FROM WS-SUB1 BY 1               
                                        UNTIL WS-SUB1 > 6               
                   IF WS-MAILING-ADDRESS(WS-SUB1) NOT                   
                                      EQUAL TO SPACES                   
                        MOVE WS-MAILING-ADDRESS(WS-SUB1) TO             
                             WS-MAILING-ADDRESS(WS-SUB)                 
                        MOVE SPACES                           TO        
                                        WS-MAILING-ADDRESS(WS-SUB1)     
                        ADD  +1                   TO WS-SUB             
                   END-IF                                               
                END-PERFORM                                             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 00195700
       5100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00195700
      *****************************************************************         
      ** PREPARE TO INSERT INTO CSS_COMM_DATA                                   
      *****************************************************************         
       6000-LOAD-COMM-DATA.                                             
      *                                                                         
            MOVE AT-COMPANY-NO            TO KO-COMPANY-NO.             
            MOVE AT-ACCOUNT-NO            TO KO-ACCOUNT-NO.             
            MOVE AT-CUSTOMER-NO           TO KO-CUSTOMER-NO.            
            MOVE SPACES                   TO KO-CONTACT-NAME.           
            MOVE AT-PREMISE-NO            TO KO-PREMISE-NO.             
            MOVE 'N'                      TO KO-RED-FLAG-IND.           
            MOVE SPACES                   TO KO-RED-FLAG-EXPIRE-DT.     
            MOVE -1                       TO WS-RED-FL-NULL-IND.        
            MOVE 'L'                      TO KO-COMM-METHOD.            
            MOVE 'O'                      TO KO-COMM-DIRECTION.         
P00599      MOVE WS-PCARD-COMM-TYPE-CD    TO KO-COMM-TYPE-CD.           
P00599      MOVE WS-PCARD-COMM-SUBTYPE-CD TO KO-COMM-SUBTYPE-CODE.      
            MOVE 18                       TO KO-INITIAL-COMMENT-TX-LEN. 
            MOVE 'POSTCARD OR E-CARD'     TO KO-INITIAL-COMMENT-TX-TEXT.
            MOVE 'SYSTEM'                 TO KO-USER-ID-ORIG.           
            MOVE SPACES                   TO KO-PROMOTION-ID.           
            MOVE 'N'                      TO KO-PSC-COMPLIANCE-IND.     
            MOVE SPACES                   TO KO-CALL-END-TIME.          
            MOVE 0                        TO KO-CALL-ORIGIN-ID          
                                             KO-NUMBER-TRANSFERS        
                                             KO-HOLD-TIME               
                                             KO-QUEUE-TIME              
                                             KO-TOTAL-CALL-TIME.        
            MOVE 'N'                      TO KO-SCREEN-POP-IND.         
            MOVE SPACES                   TO KO-RESPONSE-REASON-CD.     
            MOVE -1                       TO WS-END-NULL-IND.           
            MOVE SPACES                   TO KO-RESPONSE-TYPE-CD.       
            MOVE SPACES                   TO KO-SOLICITATION-CD.        
            MOVE 'A'                      TO KO-COMM-ASSOC-CD.          
            MOVE 'N'                      TO KO-COMPLAINT-FL.           
            MOVE SPACES                   TO KO-DISCOVERY-MTHD-CD.      
            MOVE SPACES                   TO KO-PREV-MARKETER-CD.       
                                                                        
            PERFORM 8500-INSERT-COMM-DATA THRU 8500-EXIT.               
      *                                                                         
       6000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** THIS ROUTINE READS THE INPUT HEADER FILE.                   **         
      *****************************************************************         
       7000-READ-INPUT-FILE1.                                           
      *                                                                         
            READ FCSWMSHD-FILE                                          
                AT END MOVE 'Y' TO WS-END-OF-WMSHD.                     
            IF WMSHD-SUCCESSFUL OR END-OF-WMSHD                         
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '************ PCSCA634 *******************'     
                DISPLAY '**       ERROR READING FCSWMSHD       **'      
                DISPLAY '**       FILE STATUS = ' WS-WMSHD-STATUS       
                DISPLAY '********* FATAL ERROR - ABEND ***********'     
                PERFORM 9000-TERMINATE THRU 9000-EXIT
            END-IF.                  
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** THIS ROUTINE READS THE INPUT DETAIL FILE.                   **         
      *****************************************************************         
       7200-READ-INPUT-FILE2.                                           
      *                                                                         
            READ FCSWMSDT-FILE                                          
                AT END MOVE 'Y' TO WS-END-OF-WMSDT.                     
            IF WMSDT-SUCCESSFUL OR END-OF-WMSDT                         
                NEXT SENTENCE                                           
            ELSE                                                        
                DISPLAY '************ PCSCA634 *******************'     
                DISPLAY '**       ERROR READING FCSWMSDT       **'      
                DISPLAY '**       FILE STATUS = ' WS-WMSDT-STATUS       
                DISPLAY '********* FATAL ERROR - ABEND ***********'     
                PERFORM 9000-TERMINATE THRU 9000-EXIT
            END-IF.                  
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * GET RELEVANT DATA FROM CSS_ACCOUNT                                      
      *****************************************************************         
       7500-GET-ACCOUNT-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT AT.CUSTOMER_NO,                                  
                       AT.PREMISE_NO,                                   
                       AT.COMPANY_NO,                                   
                       AT.CODE_ACCT_STAT,                               
                       AT.ADDRESS_ID,                                   
                       AT.ADDRESS_FORMAT                                
                INTO   :AT-CUSTOMER-NO,                                 
                       :AT-PREMISE-NO,                                  
                       :AT-COMPANY-NO,                                  
                       :AT-CODE-ACCT-STAT,                              
                       :AT-ADDRESS-ID,                                  
                       :AT-ADDRESS-FORMAT                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AT.CUSTOMER_NO,                                          
MFA-TR*                AT.PREMISE_NO,                                           
MFA-TR*                AT.COMPANY_NO,                                           
MFA-TR*                AT.CODE_ACCT_STAT,                                       
MFA-TR*                AT.ADDRESS_ID,                                           
MFA-TR*                AT.ADDRESS_FORMAT                                        
MFA-TR*         INTO   :AT-CUSTOMER-NO,                                         
MFA-TR*                :AT-PREMISE-NO,                                          
MFA-TR*                :AT-COMPANY-NO,                                          
MFA-TR*                :AT-CODE-ACCT-STAT,                                      
MFA-TR*                :AT-ADDRESS-ID,                                          
MFA-TR*                :AT-ADDRESS-FORMAT                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RETURN-CODE              
              DISPLAY '************ PCSCA634 *******************'       
              DISPLAY '**  ERROR ON 7500-GET-ACCOUNT-DATA    **'        
              DISPLAY '**  SELECT FROM CSS_ACCOUNT           **'        
              DISPLAY '**  ACCOUNT_NO = ' AT-ACCOUNT-NO                 
              DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '********* FATAL ERROR - ABEND ***********'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * GET EMAIL FROM CSS_CUST_STATS                                           
      *****************************************************************         
       7600-GET-CUST-EMAIL.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT NE.EMAIL_ADDRESS_TX,                             
                       NE.EMAIL_DISP_PREF_CD                            
                INTO   :NE-EMAIL-ADDRESS-TX,                            
                       :NE-EMAIL-DISP-PREF-CD                           
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)                    
                WHERE CE.CUSTOMER_NO = NE.CUSTOMER_NO  AND              
                      NE.CUSTOMER_NO = :NE-CUSTOMER-NO AND              
                      CE.CUSTOMER_TYPE = 'C'           AND              
                      CE.EBILL_REGISTER_IND = 'Y'      AND              
                      NE.EMAIL_TYPE_CD = 'P1'                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT NE.EMAIL_ADDRESS_TX,                                     
MFA-TR*                NE.EMAIL_DISP_PREF_CD                                    
MFA-TR*         INTO   :NE-EMAIL-ADDRESS-TX,                                    
MFA-TR*                :NE-EMAIL-DISP-PREF-CD                                   
MFA-TR*         FROM CSS_CUST_STATS CE,                                         
MFA-TR*              CSS_CUST_EMAIL NE                                          
MFA-TR*         WHERE CE.CUSTOMER_NO = NE.CUSTOMER_NO  AND                      
MFA-TR*               NE.CUSTOMER_NO = :NE-CUSTOMER-NO AND                      
MFA-TR*               CE.CUSTOMER_TYPE = 'C'           AND                      
MFA-TR*               CE.EBILL_REGISTER_IND = 'Y'      AND                      
MFA-TR*               NE.EMAIL_TYPE_CD = 'P1'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  MOVE 'Y'                      TO WS-IS-EBILL          
              WHEN NOT-FOUND                                            
                  MOVE 'N'                      TO WS-IS-EBILL          
              WHEN OTHER                                                
                  MOVE WS-ACTIVE-RETURN-CODE    TO RETURN-CODE          
                  DISPLAY '************ PCSCA634 *******************'   
                  DISPLAY '**  ERROR ON 7600-CUST-EMAIL          **'    
                  DISPLAY '**  SELECT FROM CSS_CUST_EMAIL        **'    
                  DISPLAY '**  CUSTOMER_NO = ' CE-CUSTOMER-NO           
                  DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE 
                  DISPLAY '********* FATAL ERROR - ABEND ***********'   
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00599******************************************************************        
      *  EXTRACT COMMON DATE.                                          *        
      ******************************************************************        
       7700-GET-COMMON-DATE.                                            
                                                                        
           MOVE WS-COMMON-DATE      TO G6-PROGRAM-NAME.                 
           MOVE '01'                TO G6-COMPANY-NO.                   
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*       WITH  UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                       WS-DISPLAY-SQLCODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 7700-GET-COMMON-DATE   '                      
               DISPLAY '* TABLE-1 CSS_JOB_PARM'                         
               DISPLAY '* PROGRAM NAME ' G6-PROGRAM-NAME                
               DISPLAY '* SQL RETURN CODE = ' WS-DISPLAY-SQLCODE        
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
P00599** THIS ROUTINE WRITES TO THE OUTPUT FILE.                     **         
      *****************************************************************         
P00599 8000-WRITE-CO-FILE.                                              
      *                                                                         
           INITIALIZE                      WS-EXT-SORT-KEY              
                                           WS-EXT-HDR                   
                                           WS-EXT-POSTCARD-INFO.        
           MOVE WS-CORR-HDR-REC            TO WS-EXT-KEY-REC-SEQ.       
           MOVE WS-CORR-HDR-ID             TO WS-EXT-KEY-RECORD-ID.     
           MOVE HOLD-ACCOUNT-NO            TO WS-EXT-KEY-ACCOUNT-NO     
                                              WS-EXT-ACCOUNT-NO.        
           MOVE WS-MESSAGE-NO(SUB-HOLD)    TO WS-EXT-KEY-MESSAGE-ID     
                                              WS-EXT-MESSAGE-ID.        
P00599     MOVE WS-DATE-BILLED-1           TO WS-EXT-KEY-STMT-DATE.     
P00599     MOVE WS-DATE-BILLED             TO WS-EXT-STMT-DATE.         
           MOVE AT-CUSTOMER-NO             TO WS-EXT-KEY-CUSTOMER-NO    
                                              WS-EXT-CUSTOMER-NO.       
           MOVE AT-COMPANY-NO              TO WS-EXT-COMPANY-NO.        
           MOVE WS-PCARD-COMM-TYPE-CD      TO WS-EXT-COMM-TYPE-CD.      
           MOVE WS-PCARD-COMM-SUBTYPE-CD   TO WS-EXT-COMM-SUBTYPE-CD.   
P00599     IF WS-IS-EBILL = 'Y'                                         
P00599          IF HOLD-EMAIL <= SPACES                                 
P00599             MOVE 'NE'                TO WS-EXT-KEY-FILE-SORT     
P00599          ELSE                                                    
P00599             MOVE 'EB'                TO WS-EXT-KEY-FILE-SORT     
P00599          END-IF                                                  
P00599     ELSE                                                         
P00599          MOVE 'CN'                  TO WS-EXT-KEY-FILE-SORT      
P00599     END-IF.                                                      
           MOVE SPACES                     TO E-CO-SORT-KEY.            
           MOVE WS-EXT-SORT-KEY            TO E-CO-SORT-KEY.            
           MOVE SPACES                     TO E-CO-DATA.                
           MOVE WS-EXT-HDR                 TO E-CO-DATA.                
           WRITE FCSCOEXT.                                              
      *                                                                         
           INITIALIZE WS-EXT-MAILING-DTL.                               
           MOVE WS-MAILING-DTL-REC         TO WS-EXT-KEY-REC-SEQ.       
           MOVE WS-MAILING-DTL-ID          TO WS-EXT-KEY-RECORD-ID.     
           MOVE WS-MAILING-ADDRESS(1)      TO WS-EXT-MAILING-ADDR(1).   
           MOVE WS-MAILING-ADDRESS(2)      TO WS-EXT-MAILING-ADDR(2).   
           MOVE WS-MAILING-ADDRESS(3)      TO WS-EXT-MAILING-ADDR(3).   
           MOVE WS-MAILING-ADDRESS(4)      TO WS-EXT-MAILING-ADDR(4).   
           MOVE WS-MAILING-ADDRESS(5)      TO WS-EXT-MAILING-ADDR(5).   
           MOVE WS-MAILING-ADDRESS(6)      TO WS-EXT-MAILING-ADDR(6).   
           MOVE WS-PR-STREET               TO WS-EXT-SERVICE-ADDRESS(1) 
                                              WS-EXT-PCARD-SERV-ADDR(1).
           IF WS-PR-ADDR-OVERFLOW > SPACES                              
              MOVE WS-PR-ADDR-OVERFLOW    TO                            
                                          WS-EXT-SERVICE-ADDRESS(2)     
                                          WS-EXT-PCARD-SERV-ADDR(2)     
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
                                          WS-EXT-SERVICE-ADDRESS(3)     
                                          WS-EXT-PCARD-SERV-ADDR(3)     
           ELSE                                                         
              MOVE WS-PR-ADDR-CITY-STATE-ZIP TO                         
                                          WS-EXT-SERVICE-ADDRESS(2)     
                                          WS-EXT-PCARD-SERV-ADDR(2)     
           END-IF.                                                      
           MOVE SPACES                     TO E-CO-SORT-KEY.            
           MOVE WS-EXT-SORT-KEY            TO E-CO-SORT-KEY.            
           MOVE SPACES                     TO E-CO-DATA.                
           MOVE WS-EXT-MAILING-DTL         TO E-CO-DATA.                
           WRITE FCSCOEXT.                                              
      *                                                                         
           INITIALIZE WS-EXT-ALPHA-VARIABLE-DTL.                        
           MOVE WS-VAR-DTL-REC             TO WS-EXT-KEY-REC-SEQ.       
           MOVE WS-VAR-DTL-ID              TO WS-EXT-KEY-RECORD-ID.     
           MOVE WS-DATE(SUB-HOLD)          TO WS-EXT-ALPHA-VARIABLE(1)  
                                              WS-EXT-PCARD-DATE.        
A04518     MOVE WS-ALT-DATE(SUB-HOLD)      TO WS-EXT-PCARD-ALT-DATE.    
           MOVE WS-START-TIME(SUB-HOLD)    TO WS-EXT-ALPHA-VARIABLE(2)  
                                              WS-EXT-PCARD-START-TIME.  
           MOVE WS-DURATION(SUB-HOLD)      TO WS-EXT-ALPHA-VARIABLE(3)  
                                              WS-EXT-PCARD-DURATION.    
           MOVE WS-CONTACT-PHONE(SUB-HOLD) TO WS-TMP-PHONE.             
           STRING                          '('                          
                                              WS-TMP-PHONE(1:3)         
                                              ')'                       
                                              WS-TMP-PHONE(4:3)         
                                              '-'                       
                                              WS-TMP-PHONE(7:4)         
                                              DELIMITED BY SIZE INTO    
                                              WS-EXT-ALPHA-VARIABLE(4). 
           MOVE WS-EXT-ALPHA-VARIABLE(4)   TO WS-EXT-PCARD-CONTACT-PH.  
                                                                        
           MOVE WS-CONTACT-NAME(SUB-HOLD)  TO WS-EXT-ALPHA-VARIABLE(6)  
                                              WS-EXT-PCARD-CONTACT-NM.  
           MOVE WS-WK-COMPANY-NM(SUB-HOLD) TO WS-EXT-ALPHA-VARIABLE(7)  
                                              WS-EXT-PCARD-COMPANY.     
           IF WS-IS-EBILL = 'Y'                                         
                MOVE 'Y'                    TO WS-EXT-ALPHA-VARIABLE(5) 
                                               WS-EXT-PCARD-EBILL       
                MOVE NE-EMAIL-DISP-PREF-CD  TO WS-EXT-ALPHA-VARIABLE(10)
                                               WS-EXT-PCARD-EMAIL-PREF  
                MOVE EMAIL-PART1            TO WS-EXT-ALPHA-VARIABLE(8) 
                MOVE EMAIL-PART2            TO WS-EXT-ALPHA-VARIABLE(9) 
                MOVE HOLD-EMAIL-2PARTS      TO WS-EXT-PCARD-EMAIL       
                ADD 1                       TO WS-REC-WREMAIL           
           ELSE                                                         
                ADD 1                       TO WS-REC-WRPOST            
           END-IF.                                                      
                                                                        
           MOVE SPACES                     TO E-CO-SORT-KEY.            
           MOVE WS-EXT-SORT-KEY            TO E-CO-SORT-KEY.            
           MOVE SPACES                     TO E-CO-DATA.                
           MOVE WS-EXT-ALPHA-VARIABLE-DTL  TO E-CO-DATA.                
           WRITE FCSCOEXT.                                              
      *                                                                         
           MOVE WS-POSTCARD-DTL-REC        TO WS-EXT-KEY-REC-SEQ.       
           MOVE WS-POSTCARD-DTL-ID         TO WS-EXT-KEY-RECORD-ID.     
           MOVE SPACES                     TO E-CO-SORT-KEY.            
           MOVE WS-EXT-SORT-KEY            TO E-CO-SORT-KEY.            
           MOVE SPACES                     TO E-CO-DATA.                
           MOVE WS-EXT-POSTCARD-INFO       TO E-CO-DATA.                
           WRITE FCSCOEXT.                                              
                                                                        
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** THIS ROUTINE WRITES TO THE SKIPPED ACOUNTS REPORT FILE.     **         
      *****************************************************************         
       8100-WRITE-FB-FILE.                                              
      *                                                                         
           IF WS-FIRST-TIME = 'Y'                                       
              MOVE WS-RPT-HEADER-LINE1    TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE SPACES                 TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE WS-REQUEST-LINE1       TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              PERFORM VARYING SUB-HDR FROM 1 BY 1                       
              UNTIL (SUB-HDR > WS-HDR-COUNT)                            
                  MOVE WS-REQUEST-NO(SUB-HDR)  TO WS-WRITE-REQ-ID       
                  MOVE WS-REQUEST-LINE2        TO FIOCAFB-DATA          
                  WRITE FIOWMSFB                                        
              END-PERFORM                                               
              MOVE SPACES                 TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE WS-RPT-HEADER-LINE2    TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE WS-RPT-HEADER-LINE3    TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE WS-RPT-HEADER-LINE4    TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE 'N'                   TO WS-FIRST-TIME               
           END-IF.                                                      
                                                                        
           MOVE  HOLD-REQUEST-NO         TO WS-WMSREQ-NO.               
           MOVE  AT-ACCOUNT-NO           TO WS-ACCT-NO.                 
           MOVE  WS-RPT-DETAIL-LINE      TO FIOCAFB-DATA.               
           WRITE FIOWMSFB.                                              
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** THIS ROUTINE WRITES THE SKIPPED ACCOUNTS FOOTER             **         
      *****************************************************************         
       8110-WRITE-FB-FOOTER.                                            
      *                                                                         
           IF  WS-REC-SKIPPED = 0                                       
              MOVE WS-REQUEST-LINE1       TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              PERFORM VARYING SUB-HDR FROM 1 BY 1                       
              UNTIL (SUB-HDR > WS-HDR-COUNT)                            
                  MOVE WS-REQUEST-NO(SUB-HDR)  TO WS-WRITE-REQ-ID       
                  MOVE WS-REQUEST-LINE2        TO FIOCAFB-DATA          
                  WRITE FIOWMSFB                                        
              END-PERFORM                                               
              MOVE SPACES                 TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE WS-NO-DATA-LINE        TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
           ELSE                                                         
              MOVE  WS-RPT-HEADER-LINE4   TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
              MOVE  WS-REC-SKIPPED        TO WS-ACCT-SKIPPED            
              MOVE  WS-RPT-FOOTER-LINE    TO FIOCAFB-DATA               
              WRITE FIOWMSFB                                            
           END-IF.                                                      
      *                                                                         
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * INSERT CSS_COMM_DATA ROW FOR EBILL ACCOUNTS                             
      *****************************************************************         
       8500-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES (CIS.CURRENT$TIMESTAMP(),                              
                        :KO-ACCOUNT-NO,                                 
                        :KO-CUSTOMER-NO,                                
                        :KO-PREMISE-NO,                                 
                        :KO-COMPANY-NO,                                 
                        :KO-RED-FLAG-IND,                               
                        CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                           :WS-RED-FL-NULL-IND),      
                        :KO-COMM-METHOD,                                
                        :KO-COMM-DIRECTION,                             
                        :KO-COMM-TYPE-CD,                               
                        :KO-COMM-SUBTYPE-CODE,                          
                        :KO-USER-ID-ORIG,                               
                        :KO-CONTACT-NAME,                               
                        :KO-PROMOTION-ID,                               
                        :KO-PSC-COMPLIANCE-IND,                         
                        :KO-CALL-ORIGIN-ID,                             
                        CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                           :WS-END-NULL-IND),              
                        :KO-NUMBER-TRANSFERS,                           
                        :KO-HOLD-TIME,                                  
                        :KO-QUEUE-TIME,                                 
                        :KO-SCREEN-POP-IND,                             
                        :KO-TOTAL-CALL-TIME,                            
                        :KO-INITIAL-COMMENT-TX,                         
                        :KO-RESPONSE-REASON-CD,                         
                        :KO-RESPONSE-TYPE-CD,                           
                        :KO-SOLICITATION-CD,                            
                        :KO-COMM-ASSOC-CD,                              
                        :KO-COMPLAINT-FL,                               
                        :KO-DISCOVERY-MTHD-CD,                          
                        :KO-PREV-MARKETER-CD                            
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES (CURRENT TIMESTAMP,                                      
MFA-TR*                 :KO-ACCOUNT-NO,                                         
MFA-TR*                 :KO-CUSTOMER-NO,                                        
MFA-TR*                 :KO-PREMISE-NO,                                         
MFA-TR*                 :KO-COMPANY-NO,                                         
MFA-TR*                 :KO-RED-FLAG-IND,                                       
MFA-TR*                 :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,              
MFA-TR*                 :KO-COMM-METHOD,                                        
MFA-TR*                 :KO-COMM-DIRECTION,                                     
MFA-TR*                 :KO-COMM-TYPE-CD,                                       
MFA-TR*                 :KO-COMM-SUBTYPE-CODE,                                  
MFA-TR*                 :KO-USER-ID-ORIG,                                       
MFA-TR*                 :KO-CONTACT-NAME,                                       
MFA-TR*                 :KO-PROMOTION-ID,                                       
MFA-TR*                 :KO-PSC-COMPLIANCE-IND,                                 
MFA-TR*                 :KO-CALL-ORIGIN-ID,                                     
MFA-TR*                 :KO-CALL-END-TIME:WS-END-NULL-IND,                      
MFA-TR*                 :KO-NUMBER-TRANSFERS,                                   
MFA-TR*                 :KO-HOLD-TIME,                                          
MFA-TR*                 :KO-QUEUE-TIME,                                         
MFA-TR*                 :KO-SCREEN-POP-IND,                                     
MFA-TR*                 :KO-TOTAL-CALL-TIME,                                    
MFA-TR*                 :KO-INITIAL-COMMENT-TX,                                 
MFA-TR*                 :KO-RESPONSE-REASON-CD,                                 
MFA-TR*                 :KO-RESPONSE-TYPE-CD,                                   
MFA-TR*                 :KO-SOLICITATION-CD,                                    
MFA-TR*                 :KO-COMM-ASSOC-CD,                                      
MFA-TR*                 :KO-COMPLAINT-FL,                                       
MFA-TR*                 :KO-DISCOVERY-MTHD-CD,                                  
MFA-TR*                 :KO-PREV-MARKETER-CD                                    
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RETURN-CODE              
              DISPLAY '************ PCSCA634 *******************'       
              DISPLAY '**  ERROR ON 8500-INSERT-COMM-DATA    **'        
              DISPLAY '**  INSERT INTO CSS_COMM_DATA         **'        
              DISPLAY '**  ACCOUNT_NO  = ' KO-ACCOUNT-NO                
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '********* FATAL ERROR - ABEND ***********'       
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              MOVE WS-ACTIVE-RETURN-CODE    TO RETURN-CODE              
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** TERMINATION ROUTINE. CLOSES ALL THE FILES.                  **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
P00599      CLOSE FCSCOEXT-FILE,                                        
                  FCSWMSHD-FILE,                                        
                  FCSWMSDT-FILE,                                        
                  FCSWMSFB-FILE.                                        
            IF WS-REC-CNT < 1                                           
                IF RETURN-CODE < 8                                      
                    DISPLAY                                             
                      '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
                    DISPLAY                                             
                      '! INPUT FILE IS EMPTY OR CONTAINS INVALID DATA !'
                    DISPLAY                                             
                      '!*!*                 ***                    *!*!'
                    DISPLAY                                             
                      '!****         NOTIFY PROGRAMMER             ***!'
                    DISPLAY                                             
                      '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
                    MOVE +8 TO RETURN-CODE                              
                END-IF                                                  
            END-IF.                                                     
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** 9900-ABEND.                                                 **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
