       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA629.                                         
       DATE-WRITTEN.   1 FEBRUARY 2012.                                 
       DATE-COMPILED.                                                   
      *****************************************************************         
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **              COMPLETE BUSINESS SOLUTIONS INC.               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **            PROGRAM    MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **                                                             **         
      **   2 FEB 2012 RDF     PCSCA629 SETS CODE ON THE OUTPUT FILE  **         
      **                      FOR USE IN PROGRAM PCSCA658.           **         
      **                      SIGNIFYING WHETHER TO                  **         
      **                      C = CREATE A SERVICE ORDER             **         
      **                      U = UPDATE SPCL_INSTRUCTIONS ON THE    **         
      **                          PREMISE TABLE                      **         
      **                      B = DO BOTH                            **         
      **                      THE DETERMINING FACTOR IN PCSCA629     **         
      **                      IS (JOB PARM ) UTIL TYPE PARM.         **         
      **                      PCSCA658 READS THE INPUT FILE AND      **         
      **                      DOES WHATEVER THE CODE IS ON THE       **         
      **                      FILE.                                  **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA629 NARRATIVE                        
            THIS PROGRAM EXTRACTS THE DETAILS OF ALL THE ACCOUNTS       
            BASED ON THE USER SPECIFIED ROUTE/SEQ# COMBINATION. SUCH    
            EXTRACTED FILE WILL BE SENT AS INPUT TO THE PCSCA658        
            APPLICATION WHICH WILL CREATE SERVICE WORK ORDERS           
      *                                                                         
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA629.                                                           
      *                                                                         
       COPY CSSPT32.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA629.                                                           
      *                                                                         
       COPY FIOCA629.                                                           
      *                                                                         
       COPY CFDPT32.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA629'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-PARM-COMP-NO             PIC XX VALUE SPACES.           
          05 WS-RATE-PLAN-WANTED         PIC X  VALUE 'N'.              
          05 WS-RATE-PLAN-SW             PIC X  VALUE 'N'.              
          05 WS-LEAK-FREQ-WANTED         PIC X  VALUE 'N'.              
          05 WS-LEAK-FREQ-SW             PIC X  VALUE 'N'.              
          05 WS-WORKTYPE-OK              PIC X  VALUE 'N'.              
          05 WS-YES                      PIC X  VALUE 'Y'.              
          05 WS-R                        PIC X  VALUE 'R'.              
          05 WS-SCEG                     PIC X  VALUE 'N'.              
          05 WS-PSNC                     PIC X  VALUE 'N'.              
          05 WS-LO-UTIL                  PIC X.                         
          05 WS-HI-UTIL                  PIC X.                         
          05 WS-LO-DATA                  PIC X.                         
          05 WS-HI-DATA                  PIC X.                         
      *                                                                         
          05 RS-RETURN-CODE              PIC S9(4) COMP.                
          05 RS-RETURN-CODE-DISP         PIC +Z(4).                     
          05 PROGRAM-NAME                PIC X(8)  VALUE 'PCSCA629'.    
          05 WS-PGRMNAME                 PIC X(8)  VALUE 'PCSCA629'.    
          05 WS-NO-MORE-DATA             PIC X  VALUE 'N'.              
          05 WS-FCA629-STATUS            PIC XX.                        
             88 FCA629-SUCCESSFUL  VALUE '00'.                          
          05 WS-FCA32-STATUS             PIC XX.                        
             88 FCA32-SUCCESSFUL  VALUE '00'.                           
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
          05 WS-ELEC-SPEC-CODE           PIC X(03) VALUE SPACES.        
          05 WS-SPEC-CODE-RCVD-SW        PIC X(01) VALUE ' '.           
             88 SPEC-CODE-RECEIVED                 VALUE 'Y'.           
             88 SPEC-CODE-NOT-RCVD                 VALUE ' '.           
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-LINE-COUNT               PIC S9(3) COMP-3 VALUE +66.    
          05 WS-LINE-COUNTX REDEFINES WS-LINE-COUNT PIC X(2).           
          05 WS-PAGE-COUNT               PIC S9(3) COMP-3 VALUE ZEROS.  
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-LIT1                     PIC X(29)                      
             VALUE 'CURRENT METER IS AN AMR METER'.                     
          05 WS-LIT2                     PIC X(29)                      
             VALUE 'PROBED METER                 '.                     
          05 WS-LIT3                     PIC X(29)                      
             VALUE 'MULTI-REGISTER METER         '.                     
          05 WS-LIT4                     PIC X(29)                      
             VALUE 'METER CONSTANT > 1           '.                     
          05 WS-LIT5                     PIC X(29)                      
             VALUE 'POLYPHASE BOLT-IN METER      '.                     
          05 WS-K                        PIC X  VALUE 'K'.              
          05 WS-N                        PIC X  VALUE 'N'.              
          05 WS-U                        PIC X  VALUE 'U'.              
      *                                                                         
       01 WS-PARM-UTIL-DATA.                                            
          05 WS-PARM-UTIL-LITERAL        PIC X(10).                     
          05 WS-PARM-UTIL-TYPE           PIC X.                         
             88 ELECTRIC       VALUE 'E'.                               
             88 GAS            VALUE 'G'.                               
             88 BOTH           VALUE 'B'.                               
          05 FILLER                      PIC X.                         
          05 WS-PARM-METER-LITERAL       PIC X(11).                     
          05 WS-PARM-METER-TYPE          PIC X.                         
             88 SINGLE         VALUE 'S'.                               
             88 BOTH           VALUE 'B'.                               
          05 FILLER                      PIC X.                         
          05 WS-RUN-TYPE-LITERAL         PIC X(9).                      
          05 WS-RUN-TYPE                 PIC X.                         
             88 DO-SERV-ODER     VALUE 'C'.                             
             88 UPDATE-PREMISE   VALUE 'U'.                             
             88 DO-BOTH          VALUE 'B'.                             
          05 FILLER                      PIC X(45).                     
      *                                                                         
       01 WS-ELE-PARM-ORDER-TYPE-DATA.                                  
          05 WS-PARM-ELEC-ORDER-LITERAL  PIC X(14).                     
          05 WS-PARM-ELEC-ORDER          PIC X(5).                      
          05 FILLER                      PIC X.                         
          05 WS-PARM-ELEC-WORK-LITERAL   PIC X(10).                     
          05 WS-PARM-ELEC-WORK           PIC X(3).                      
          05 FILLER                      PIC X(47).                     
      *                                                                         
       01 WS-GAS-PARM-ORDER-TYPE-DATA.                                  
          05 WS-PARM-GAS-ORDER-LITERAL   PIC X(13).                     
          05 WS-PARM-GAS-ORDER           PIC X(5).                      
          05 FILLER                      PIC X.                         
          05 WS-PARM-GAS-WORK-LITERAL    PIC X(10).                     
          05 WS-PARM-GAS-WORK            PIC X(3).                      
          05 FILLER                      PIC X(48).                     
      *                                                                         
       01  WS-PARM-AMR-TYPE-DATA.                                       
           05 WS-PARM-AMR-TYPE-LITERAL    PIC X(9).                     
           05 WS-PARM-AMR-TYPE            PIC X.                        
           05 FILLER                      PIC X.                        
           05 WS-PARM-WANTED-DATE-LITERAL PIC X(12).                    
           05 WS-PARM-DATE                PIC X(10).                    
           05 FILLER                      PIC X(47).                    
      *                                                                         
       01  WS-PARM-SPEC-CODE-DATA.                                      
           05 WS-PARM-SPEC-CODE-LITERAL   PIC X(10).                    
           05 WS-PARM-SPEC-CODE           PIC X(03).                    
           05 FILLER                      PIC X(67).                    
      *                                                                         
       01  WS-WHO-CARES-DATE              PIC X(10).                    
       01  WS-FIRST-TIME                  PIC X     VALUE 'Y'.          
      *                                                                         
       01  WS-SAVE-DATA.                                                
           05  WS-SAVE-CO                    PIC XX.                    
           05  WS-SAVE-ROUTE                 PIC X(4).                  
      *                                                                         
       01  WS-IS-THIS-A-GOOD-AMR          PIC X.                        
      *                                                                         
       01  WS-SAVE-THIS-TYPE.                                           
           05 WS-CODE-VALUE-LEN           PIC S9(4) USAGE COMP.         
           05 WS-CODE-VALUE-TEXT          PIC X(10).                    
      *                                                                         
       01 HEADER1.                                                      
          05 FILLER             PIC X(11) VALUE 'PCSCA629-01'.          
          05 FILLER             PIC X(37) VALUE SPACES.                 
          05 WS-COMPANY-NAME    PIC X(26) VALUE SPACES.                 
          05 FILLER             PIC X(25) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN DATE:  '.          
          05 HDR-DATE           PIC X(17) VALUE SPACES.                 
          05 FILLER             PIC X(5)  VALUE SPACES.                 
      *                                                                         
       01 HEADER2.                                                      
          05 FILLER             PIC X(38) VALUE SPACES.                 
          05 FILLER             PIC X(41) VALUE                         
             'END POINT LINK FROM HOST EXCEPTION REPORT'.               
          05 FILLER             PIC X(20) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN TIME:  '.          
          05 HDR-TIME           PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC XX    VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'PAGE = '.              
          05 HDR-PAGE           PIC ZZ9.                                
          05 FILLER             PIC XX    VALUE SPACES.                 
                                                                        
       01 HEADER3.                                                      
          05 FILLER             PIC X     VALUE SPACES.                 
          05 FILLER             PIC X(15) VALUE 'ACCOUNT/PREMISE'.      
          05 FILLER             PIC X     VALUE SPACES.                 
          05 FILLER             PIC X(10) VALUE 'METER/STAT'.           
          05 FILLER             PIC XX    VALUE SPACES.                 
          05 FILLER             PIC X(4)  VALUE 'UTIL'.                 
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(3)  VALUE 'DMT'.                  
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(5)  VALUE 'PGMID'.                
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(3)  VALUE 'RRI'.                  
          05 FILLER             PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC X(15) VALUE 'SERVICE ADDRESS'.      
          05 FILLER             PIC X(34) VALUE SPACES.                 
          05 FILLER             PIC X(8)  VALUE 'COMMENTS'.             
          05 FILLER             PIC X(3)  VALUE SPACES.                 
      *                                                                         
       01 NO-DATA-LINE.                                                 
          05 NO-DATA-LITERAL          PIC X(18)                         
                    VALUE 'NO DATA FOR RUN   '.                         
          05 NO-DATA-ROUTE            PIC X(4).                         
      *                                                                         
       01 PRINT-LINE.                                                   
          05 FILLER                PIC X     VALUE SPACES.              
          05 PRT-ACCOUNT           PIC X(13).                           
          05 PRT-PREMISEX REDEFINES PRT-ACCOUNT.                        
             10 PRT-PREMISE           PIC X(10).                        
             10 FILLER                PIC X(3).                         
          05 FILLER                PIC X(3)  VALUE SPACES.              
          05 PRT-METER-NO          PIC X(9).                            
          05 PRT-METER-STAT REDEFINES PRT-METER-NO.                     
             10 FILLER                PIC X(4).                         
             10 PRT-STATUS            PIC X.                            
             10 FILLER                PIC X(4).                         
          05 FILLER                PIC X(5)  VALUE SPACES.              
      *                                                                         
          05 PRT-MESSAGE.                                               
             07 PRT-UTIL-TYPE      PIC X.                               
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-DMT            PIC X(3).                            
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-PGM-ID         PIC XX.                              
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-REMOTE-READ    PIC X.                               
      *                                                                         
          05 FILLER                PIC X(5)  VALUE SPACES.              
          05 PRT-ADDRESS           PIC X(42).                           
          05 FILLER                PIC X(3) VALUE SPACES.               
          05 PRT-COMMENT           PIC X(29).                           
      *                                                                         
       01  WS-CODE-METER-STATUS.                                        
           10  WS-MTR-STAT-CD0         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-0X          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CD1         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-1X          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDA         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-AX          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDB         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-BX          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDI         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-IX          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDJ         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-JX          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDK         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-KX          PIC X VALUE 'W'.                 
           10  WS-MTR-STAT-CDX         PIC X VALUE SPACES.              
           10  WS-MTR-STAT-XX          PIC X VALUE 'W'.                 
      *                                                                         
       01  WS-ZIP-CODES.                                                
           10  WS-ZIP-CODE-1           PIC X(5) VALUE SPACES.           
           10  WS-ZIP-CODE-2           PIC X(5) VALUE SPACES.           
           10  WS-ZIP-CODE-3           PIC X(5) VALUE SPACES.           
           10  WS-ZIP-CODE-4           PIC X(5) VALUE SPACES.           
           10  WS-ZIP-CODE-5           PIC X(5) VALUE SPACES.           
           10  WS-ZIP-CODE-6           PIC X(5) VALUE SPACES.           
      *                                                                         
       01  WS-LEAK-SURVEY-FREQ.                                         
           10  WS-LEAK-FREQ-16X        PIC XX VALUE 'WW'.               
           10  WS-LEAK-FREQ-27X        PIC XX VALUE 'WW'.               
           10  WS-LEAK-FREQ-38X        PIC XX VALUE 'WW'.               
           10  WS-LEAK-FREQ-49X        PIC XX VALUE 'WW'.               
           10  WS-LEAK-FREQ-50X        PIC XX VALUE 'WW'.               
      *                                                                         
       01  WS-RATE-PLAN.                                                
           10  WS-RATE-PLAN-1X         PIC X(3) VALUE 'WWW'.            
           10  WS-RATE-PLAN-2X         PIC X(3) VALUE 'WWW'.            
           10  WS-RATE-PLAN-3X         PIC X(3) VALUE 'WWW'.            
           10  WS-RATE-PLAN-4X         PIC X(3) VALUE 'WWW'.            
      *                                                                         
      *****************************************************************         
      **                   NECESSARY COPYBOOKS                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************                                             
      **  ABEND SWITCH COPYBOOK  **                                             
      *****************************                                             
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ****************************************************************          
      **  COPYBOOK FOR CSS_JOB_PARM -  DO NOT PUT ANYTHING BETWEEN   *          
      **  THIS COPYBOOK AND WS-INPUT-CODE-METER-STATUS               *          
      ****************************************************************          
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
       01  WS-INPUT-CODE-METER-STATUS                                   
                  REDEFINES                                             
                      WS-INPUT-DATA-BREAKDOWN.                          
           10  WS-METER-STATUS-LIT     PIC X(13).                       
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-0-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-0           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-1-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-1           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-A-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-A           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-B-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-B           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-I-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-I           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-J-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-J           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-K-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-K           PIC X.                           
           10  FILLER                  PIC XX.                          
           10  WS-MTR-STAT-X-LIT       PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-MTR-STAT-X           PIC X.                           
           10  FILLER                  PIC X(28).                       
      *                                                                         
       01  WS-INPUT-LEAK-FREQ                                           
                  REDEFINES                                             
                      WS-INPUT-DATA-BREAKDOWN.                          
           10  WS-LEAK-FREQ-LIT        PIC X(11).                       
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-16-LIT     PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-16         PIC XX.                          
           10  FILLER                  PIC XX.                          
           10  WS-LEAK-FREQ-27-LIT     PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-27         PIC XX.                          
           10  FILLER                  PIC XX.                          
           10  WS-LEAK-FREQ-38-LIT     PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-38         PIC XX.                          
           10  FILLER                  PIC XX.                          
           10  WS-LEAK-FREQ-49-LIT     PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-49         PIC XX.                          
           10  FILLER                  PIC XX.                          
           10  WS-LEAK-FREQ-50-LIT     PIC X.                           
           10  FILLER                  PIC X.                           
           10  WS-LEAK-FREQ-50         PIC XX.                          
           10  FILLER                  PIC X(40).                       
      *                                                                         
       01  WS-INPUT-RATE-PLAN                                           
                  REDEFINES                                             
                      WS-INPUT-DATA-BREAKDOWN.                          
           10  WS-RATE-PLAN-LIT        PIC X(16).                       
           10  FILLER                  PIC XX.                          
           10  WS-RATE-PLAN-1          PIC X(3).                        
           10  FILLER                  PIC XX.                          
           10  WS-RATE-PLAN-2          PIC X(3).                        
           10  FILLER                  PIC XX.                          
           10  WS-RATE-PLAN-3          PIC X(3).                        
           10  FILLER                  PIC XX.                          
           10  WS-RATE-PLAN-4          PIC X(3).                        
           10  FILLER                  PIC X(44).                       
      *                                                                         
       01  WS-PARM-ZIP-CODE                                             
                  REDEFINES                                             
                      WS-INPUT-DATA-BREAKDOWN.                          
           05 WS-ZIP-CO-NO                PIC X(3).                     
           05 WS-ZIP-COMP-NO              PIC XX.                       
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIP-LITERAL         PIC X(6).                     
           05 WS-PARM-ZIPCD-1             PIC X(5).                     
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIPCD-2             PIC X(5).                     
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIPCD-3             PIC X(5).                     
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIPCD-4             PIC X(5).                     
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIPCD-5             PIC X(5).                     
           05 FILLER                      PIC X.                        
           05 WS-PARM-ZIPCD-6             PIC X(5).                     
           05 FILLER                      PIC X(33).                    
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      **********************************                                        
      **  DB2 AND SQL ERROR CHECKING  **                                        
      **********************************                                        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      **                 COMMON ABEND FUNCTIONALITY                  **         
      *****************************************************************         
      *                                                                         
       01 ABEND-FUNCTIONS.                                              
          05 WS-ABEND-SPACE              PIC XX  VALUE SPACE.           
          05 FILLER REDEFINES WS-ABEND-SPACE.                           
             10 WS-ABEND-NUMERIC         PIC 99.                        
      *                                                                         
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_UTIL_ENVRNMT**                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_MTRD_ENVRNMT**                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_ELEC_METER  **                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBELMTR                                                    
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      **********************                                                    
      **  CSS_MTR_CAP     **                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMTRCAP                                                   
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_ACCOUNT  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_LOCAL_OFFICE **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBLOCOFC                                                   
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_COMPANY  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_NAME         **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_NAME_ACCT_XREF*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_ADDR_FREEFORM**                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
      ***********************                                                   
      **  CSS_ADDR_FORMATTED*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
      ***********************                                                   
      **  CSS_ZIP_CODE     **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_CUST_ADDR_XREF*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
      *                                                                         
      ************************                                                  
      **  CSS_ACCT_MISC_INFO**                                                  
      ************************                                                  
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST *                              
      ********************************************                              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCSTPRM                                                   
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
      *   DCLGEN COPYBOOK FOR CSS_CODE_VALUE     *                              
      ********************************************                              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************                    
      *   DCLGEN COPYBOOK FOR CSS_ORDER-WK-TYPE - L3       *                    
      ******************************************************                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBORWT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************                    
      *   DCLGEN COPYBOOK FOR CSS_PREMISE  -  PR           *                    
      ******************************************************                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBPREM                                                     
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
      **  CURSOR DECLARATION -- ROUTE_METER_CSR **                              
      ********************************************                              
           EXEC SQL                                                     
            DECLARE ROUTE_METER_CSR CURSOR FOR                          
             SELECT AT.ACCOUNT_NO                                       
                   ,UT.READ_ROUTE                                       
                   ,UT.READ_CYCLE                                       
                   ,UT.COMPANY_NO                                       
                   ,AT.LOCAL_OFFICE                                     
                   ,MN.REGISTER_RD_SEQ                                  
                   ,MN.METER_NO                                         
                   ,MN.CODE_UTIL_TYPE                                   
                   ,MN.MTR_REF_NO                                       
                   ,MN.IC_NO                                            
                   ,AT.PREMISE_NO                                       
                   ,MN.DIGTL_MTR_TYPE                                   
                   ,MN.PROGRAM_ID                                       
                   ,AT.ADDRESS_ID                                       
                   ,MN.REMOTE_READ_IND                                  
                   ,MN.CODE_DATA_PRESENT                                
                   ,MC.CONSTANT                                         
                   ,MN.CODE_METER_STATUS                                
                   ,UT.RATE_PLAN_NO                                     
                   ,PR.GAS_LK_SURVEY_FREQ                               
                   ,DY.ZIP_CODE                                         
               FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_MTR_RD_SOURCE  X7 WITH(READUNCOMMITTED)                
                    ,CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                      
                    ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
              WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO               
                AND AT.PREMISE_NO         = PR.PREMISE_NO               
                AND PR.ADDRESS_ID         = DY.ADDRESS_ID               
                AND UT.IC_NO              = MN.IC_NO                    
                AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE           
                AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE           
                AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD       
                AND MN.METER_NO           = MC.METER_NO                 
                AND MC.REG_ID_NO          = MN.REG_ID_NO                
                AND X7.SEND_READ_REQ_FL   = 'Y'                         
                AND UT.CODE_UTIL_TYPE    BETWEEN :WS-LO-UTIL            
                                             AND :WS-HI-UTIL            
                AND UT.CODE_UTIL_TYPE     <> :WS-U                      
                AND MN.CODE_METER_STATUS IN (:WS-MTR-STAT-0X            
                                            ,:WS-MTR-STAT-1X            
                                            ,:WS-MTR-STAT-AX            
                                            ,:WS-MTR-STAT-BX            
                                            ,:WS-MTR-STAT-IX            
                                            ,:WS-MTR-STAT-JX            
                                            ,:WS-MTR-STAT-KX            
                                            ,:WS-MTR-STAT-XX)           
                AND AT.COMPANY_NO         = :AT-COMPANY-NO              
                AND AT.COMPANY_NO         = MC.COMPANY_NO               
      *                                                                         
                AND DY.ZIP_CODE IN (:WS-ZIP-CODE-1                      
                                   ,:WS-ZIP-CODE-2                      
                                   ,:WS-ZIP-CODE-3                      
                                   ,:WS-ZIP-CODE-4                      
                                   ,:WS-ZIP-CODE-5                      
                                   ,:WS-ZIP-CODE-6)                     
      *                                                                         
                AND MN.CODE_DATA_PRESENT BETWEEN :WS-LO-DATA            
                                             AND :WS-HI-DATA            
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ROUTE_METER_CSR CURSOR FOR                                  
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,UT.READ_CYCLE                                               
MFA-TR*            ,UT.COMPANY_NO                                               
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,MN.REGISTER_RD_SEQ                                          
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_UTIL_TYPE                                           
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*            ,MN.IC_NO                                                    
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.CODE_DATA_PRESENT                                        
MFA-TR*            ,MC.CONSTANT                                                 
MFA-TR*            ,MN.CODE_METER_STATUS                                        
MFA-TR*            ,UT.RATE_PLAN_NO                                             
MFA-TR*            ,PR.GAS_LK_SURVEY_FREQ                                       
MFA-TR*            ,DY.ZIP_CODE                                                 
MFA-TR*        FROM  CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_PREMISE PR                                             
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_MTR_RD_SOURCE  X7                                      
MFA-TR*             ,CSS_MTR_CAP  MC                                            
MFA-TR*             ,CSS_ADDR_FORMATTED DY                                      
MFA-TR*       WHERE AT.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO                       
MFA-TR*         AND AT.PREMISE_NO         = PR.PREMISE_NO                       
MFA-TR*         AND PR.ADDRESS_ID         = DY.ADDRESS_ID                       
MFA-TR*         AND UT.IC_NO              = MN.IC_NO                            
MFA-TR*         AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD               
MFA-TR*         AND MN.METER_NO           = MC.METER_NO                         
MFA-TR*         AND MC.REG_ID_NO          = MN.REG_ID_NO                        
MFA-TR*         AND X7.SEND_READ_REQ_FL   = 'Y'                                 
MFA-TR*         AND UT.CODE_UTIL_TYPE    BETWEEN :WS-LO-UTIL                    
MFA-TR*                                      AND :WS-HI-UTIL                    
MFA-TR*         AND UT.CODE_UTIL_TYPE     <> :WS-U                              
MFA-TR*         AND MN.CODE_METER_STATUS IN (:WS-MTR-STAT-0X                    
MFA-TR*                                     ,:WS-MTR-STAT-1X                    
MFA-TR*                                     ,:WS-MTR-STAT-AX                    
MFA-TR*                                     ,:WS-MTR-STAT-BX                    
MFA-TR*                                     ,:WS-MTR-STAT-IX                    
MFA-TR*                                     ,:WS-MTR-STAT-JX                    
MFA-TR*                                     ,:WS-MTR-STAT-KX                    
MFA-TR*                                     ,:WS-MTR-STAT-XX)                   
MFA-TR*         AND AT.COMPANY_NO         = :AT-COMPANY-NO                      
MFA-TR*         AND AT.COMPANY_NO         = MC.COMPANY_NO                       
MFA-TR*                                                                         
MFA-TR*         AND DY.ZIP_CODE IN (:WS-ZIP-CODE-1                              
MFA-TR*                            ,:WS-ZIP-CODE-2                              
MFA-TR*                            ,:WS-ZIP-CODE-3                              
MFA-TR*                            ,:WS-ZIP-CODE-4                              
MFA-TR*                            ,:WS-ZIP-CODE-5                              
MFA-TR*                            ,:WS-ZIP-CODE-6)                             
MFA-TR*                                                                         
MFA-TR*         AND MN.CODE_DATA_PRESENT BETWEEN :WS-LO-DATA                    
MFA-TR*                                      AND :WS-HI-DATA                    
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **    OPEN START END PARAGRAPHS                               **          
      ****************************************************************          
      *                                                                         
       0000-NOW-WE-START.                                               
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
           PERFORM 0200-PROCESS-MAIN THRU 0200-EXIT.                    
      *                                                                         
           IF WS-SAVE-CO = '01' AND WS-SCEG = 'N'                       
              MOVE 0 TO WS-PAGE-COUNT                                   
              MOVE 'S C ELECTRIC & GAS CO     ' TO WS-COMPANY-NAME      
              MOVE 'Y' TO WS-SCEG                                       
              PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT               
              MOVE SPACES TO PRINT-LINE                                 
              MOVE NO-DATA-LINE TO PRT-MESSAGE                          
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF.                                                      
      *                                                                         
           IF WS-SAVE-CO = '26' AND WS-PSNC = 'N'                       
              MOVE 0 TO WS-PAGE-COUNT                                   
              MOVE '     PSNC ENERGY          ' TO WS-COMPANY-NAME      
              MOVE 'Y' TO WS-PSNC                                       
              PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT               
              MOVE SPACES TO PRINT-LINE                                 
              MOVE NO-DATA-LINE TO PRT-MESSAGE                          
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       OPEN OUTPUT FILE.                                    **          
      **       VALIDATE THE PARAMETER FROM CSS_JOB_PARM.            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSCA629-FILE.                                   
      *                                                                         
           IF FCA629-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**     PCSCA629 PROCESSING ERROR          **'    
              DISPLAY '**     OPEN ERROR ON FCSCA629 FILE        **'    
              DISPLAY '**     FCA629 FILE STATUS = ' WS-FCA629-STATUS   
              DISPLAY '**     PROCESSING TERMINATED....          **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT32-FILE.                                    
           IF  FCA32-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'FCSPT32 FILE OPEN ERROR'                         
              DISPLAY 'FCSPT32 FILE STATUS IS ==>' WS-FCA32-STATUS      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
           MOVE WS-CURRENT-TIMESTAMP(12:8) TO HDR-TIME.                 
           MOVE WS-CURRENT-DATE TO HDR-DATE.                            
      *                                                                         
      *  GET CODE-METER-STATUS VALUES FROM CSS_JOB_PARM                         
      *                                                                         
           PERFORM 0222-GET-CODE-METER-STATUS THRU 0222-EXIT.           
      *                                                                         
      *  GET LEAK SURVEY CODES FROM CSS_JOB_PARM                                
      *                                                                         
           PERFORM 0233-GET-LEAK-SURVEY THRU 0233-EXIT.                 
      *                                                                         
      *  GET RATE PLAN NUMBERS FROM CSS_JOB_PARM                                
      *                                                                         
           PERFORM 0244-GET-RATE-PLAN THRU 0244-EXIT.                   
      *                                                                         
      *                                                                         
      *  GET ZIP CODES FROM CSS_JOB_PARM                                        
      *                                                                         
           PERFORM 0246-GET-ZIP-CODES THRU 0246-EXIT.                   
      *                                                                         
      *  GET UTIL TYPE AND METER TYPE PARM FROM CSS_JOB_PARM                    
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:10) =                   
                         'UTIL TYPE=' AND INPUT-ACTIVE)                 
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-PARM-UTIL-DATA.                      
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**  UTIL TYPE PARM NOT ACTIVE         **'        
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              IF (WS-PARM-UTIL-TYPE = 'E' OR 'G' OR 'B')                
                    AND (WS-PARM-METER-TYPE = 'S' OR 'B' OR 'M')        
                 IF WS-RUN-TYPE = 'C' OR 'U' OR 'B'                     
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '***************************************'   
                    DISPLAY '** ' WS-PGRMNAME '                   **'   
                    DISPLAY '**      INVALID PARM FOR             **'   
                    DISPLAY '**     UTIL TYPE / METER TYPE.       **'   
                    DISPLAY '**  THE RUN TYPE MUST BE = C U OR B  **'   
                    DISPLAY '**     PROCESSING TERMINATED         **'   
                    DISPLAY '***************************************'   
                    DISPLAY ' '                                         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
                 IF WS-PARM-UTIL-TYPE = 'E'                             
                    MOVE 'E' TO WS-LO-UTIL                              
                    MOVE 'E' TO WS-HI-UTIL                              
                 END-IF                                                 
                 IF WS-PARM-UTIL-TYPE = 'G'                             
                    MOVE 'G' TO WS-LO-UTIL                              
                    MOVE 'G' TO WS-HI-UTIL                              
                 END-IF                                                 
                 IF WS-PARM-UTIL-TYPE = 'B'                             
                    MOVE 'E' TO WS-LO-UTIL                              
                    MOVE 'G' TO WS-HI-UTIL                              
                 END-IF                                                 
                 IF WS-PARM-METER-TYPE = 'S'                            
                    MOVE SPACES TO WS-LO-DATA                           
                                   WS-HI-DATA                           
                 END-IF                                                 
                 IF WS-PARM-METER-TYPE = 'B'                            
                    MOVE SPACES TO WS-LO-DATA                           
                    MOVE 'A'    TO WS-HI-DATA                           
                 END-IF                                                 
                 IF WS-PARM-METER-TYPE = 'M'                            
                    MOVE 'A' TO WS-LO-DATA                              
                    MOVE 'A' TO WS-HI-DATA                              
                 END-IF                                                 
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** ' WS-PGRMNAME '                    **'     
                 DISPLAY '**      INVALID PARM FOR              **'     
                 DISPLAY '**     UTIL TYPE / METER TYPE         **'     
                 DISPLAY '**  UTIL TYPE MUST = E OR G OR B      **'     
                 DISPLAY '**  METER TYPE MUST = S OR B OR M     **'     
                 DISPLAY '**     PROCESSING TERMINATED          **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           DISPLAY '************* UTIL METER PARM DATA ************'.   
           DISPLAY 'WS-LO-UTIL = ' WS-LO-UTIL.                          
           DISPLAY 'WS-HI-UTIL = ' WS-HI-UTIL.                          
           DISPLAY 'WS-LO-DATA = ' WS-LO-DATA.                          
           DISPLAY 'WS-HI-DATA = ' WS-HI-DATA.                          
           DISPLAY 'WS-PARM-UTIL-TYPE  = ' WS-PARM-UTIL-TYPE.           
           DISPLAY 'WS-PARM-METER-TYPE = ' WS-PARM-METER-TYPE.          
           DISPLAY 'WS-RUN-TYPE        = ' WS-RUN-TYPE.                 
           DISPLAY '***********************************************'.   
      *                                                                         
      *  GET ELECTRIC SERVICE WORK ORDER TYPE PARM FROM CSS_JOB_PARM            
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:14) =                   
                         'ELEC ORD TYPE=' AND INPUT-ACTIVE)             
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-ELE-PARM-ORDER-TYPE-DATA.            
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '********************************************'    
              DISPLAY '** ' WS-PGRMNAME '                        **'    
              DISPLAY '**  ELECTRIC ORDER TYPE PARM NOT ACTIVE   **'    
              DISPLAY '********************************************'    
              DISPLAY ' '                                               
           ELSE                                                         
              IF WS-PARM-ELEC-ORDER > SPACES                            
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** ' WS-PGRMNAME '                    **'     
                 DISPLAY '**      INVALID PARM FOR ELECTRIC     **'     
                 DISPLAY '**   SERVICE ORDER WORK ORDER TYPE    **'     
                 DISPLAY '**     PROCESSING TERMINATED          **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *  GET GAS SERVICE WORK ORDER TYPE PARM FROM CSS_JOB_PARM                 
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:13) =                   
                         'GAS ORD TYPE=' AND INPUT-ACTIVE)              
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-GAS-PARM-ORDER-TYPE-DATA.            
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '********************************************'    
              DISPLAY '** ' WS-PGRMNAME '                        **'    
              DISPLAY '**  GAS ORDER TYPE PARM NOT ACTIVE        **'    
              DISPLAY '********************************************'    
              DISPLAY ' '                                               
           ELSE                                                         
              IF WS-PARM-GAS-ORDER > SPACES                             
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** ' WS-PGRMNAME '                    **'     
                 DISPLAY '**      INVALID PARM FOR GAS          **'     
                 DISPLAY '**   SERVICE ORDER WORK ORDER TYPE    **'     
                 DISPLAY '**     PROCESSING TERMINATED          **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      *  AT THIS POINT OUR UTIL PARM AND ORDER TYPE PARMS ARE                   
      *  VALID, BUT THEY MUST ALSO BE APPROPRIATE.                              
      *  IF YOUR UTIL PARM HAS YOU LOOKING FOR AN ELECTRIC METER,               
      *  THEN THE ELECTRIC ORDER TYPE MUST BE PRESENT.                          
      *  SAME GOES FOR GAS, OR BOTH.                                            
      *                                                                         
           IF (WS-PARM-UTIL-TYPE = 'E')                                 
                  AND (WS-PARM-ELEC-ORDER > SPACES)                     
              MOVE SPACES TO WS-PARM-GAS-ORDER                          
                             WS-PARM-GAS-WORK                           
           ELSE                                                         
              IF (WS-PARM-UTIL-TYPE = 'G')                              
                     AND (WS-PARM-GAS-ORDER > SPACES)                   
                 MOVE SPACES TO WS-PARM-ELEC-ORDER                      
                                WS-PARM-ELEC-WORK                       
              ELSE                                                      
                 IF (WS-PARM-UTIL-TYPE = 'B')                           
                        AND (WS-PARM-ELEC-ORDER > SPACES)               
                           AND (WS-PARM-GAS-ORDER > SPACES)             
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '****************************************'  
                    DISPLAY '** ' WS-PGRMNAME '                    **'  
                    DISPLAY '**      INVALID DATA FOR THE PARMS    **'  
                    DISPLAY '**   UTIL TYPE PARM AND SERVICE WORK  **'  
                    DISPLAY '**   ORDER TYPE PARMS DO NOT AGREE.   **'  
                    DISPLAY ' '                                         
                    DISPLAY '** IF YOU HAVE AN ELECTRIC TYPE PARM  **'  
                    DISPLAY '** THEN YOU MUST HAVE AN ELECTRIC     **'  
                    DISPLAY '** ORDER TYPE.  SAME FOR GAS.  IF YOU **'  
                    DISPLAY '** HAVE BOTH FOR UTIL TYPE PARM, THEN **'  
                    DISPLAY '** YOU MUST HAVE BOTH ELECTRIC AND    **'  
                    DISPLAY '** GAS ORDER TYPES IN THE ORDER PARM. **'  
                    DISPLAY '**     PROCESSING TERMINATED          **'  
                    DISPLAY '****************************************'  
                    DISPLAY ' '                                         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           DISPLAY '***** ELECTRIC / GAS ORDER DATA ***************'.   
           DISPLAY 'WS-PARM-UTIL-TYPE  = ' WS-PARM-UTIL-TYPE.           
           DISPLAY '    '.                                              
           DISPLAY 'WS-PARM-ELEC-ORDER = ' WS-PARM-ELEC-ORDER.          
           DISPLAY 'WS-PARM-ELEC-WORK  = ' WS-PARM-ELEC-WORK.           
           DISPLAY '    '.                                              
           DISPLAY 'WS-PARM-GAS-ORDER  = ' WS-PARM-GAS-ORDER.           
           DISPLAY 'WS-PARM-GAS-WORK   = ' WS-PARM-GAS-WORK.            
           DISPLAY '***********************************************'.   
      *                                                                         
      *                                                                         
      *  GET AMR TYPE AND WANTED DATE PARM FROM CSS_JOB_PARM                    
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:9) =                    
                         'AMR TYPE=' AND INPUT-ACTIVE)                  
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-PARM-AMR-TYPE-DATA.                  
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    AMR TYPE PARM NOT ACTIVE        **'        
              DISPLAY '**     PROCESSING TERMINATED          **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE WS-PARM-AMR-TYPE TO WS-CODE-VALUE-TEXT               
              MOVE 1 TO WS-CODE-VALUE-LEN                               
              PERFORM 7030-SELECT-CODE-VALUE THRU 7030-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              END-IF                                                    
              IF WS-PARM-DATE > SPACES                                  
                 PERFORM 7510-VERIFY-PARM-DATE-IS-VALID THRU 7510-EXIT  
              ELSE                                                      
                 IF WS-PARM-DATE = LOW-VALUES                           
                    MOVE SPACES TO WS-PARM-DATE                         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        THIS PARAGRAPH TAKES THE ROWS FROM CSS_JOB_PARM TABLE*          
      **        AND DETERMINE IF THE VALUES IN PARM-DATA FIELD ARE  **          
      **        VALID.                                              **          
      **                                                            **          
      **        THERE MUST BE ONE ROW WITH THE FOLOWING FORMAT      **          
      **                                                            **          
      **        UTIL TYPE=A   METER TYPE=Y                          **          
      **        WHERE 'A' IS 'E' (ELECTRIC), 'G' (GAS) OR 'B' (BOTH)**          
      **        WHERE 'Y' CAN BE 'S' (SINGLE REGISTER)              **          
      **            OR 'B' (BOTH SINGLE AND MULTI-REGISTER)         **          
      **                                                            **          
      **                         AND                                **          
      **        THERE MUST BE ONE ROW WITH THE FOLLOWING FORMAT     **          
      **                                                            **          
      **        ELECTRIC ORDER TYPE=XXXXX  GAS ORDER TYPE=XXXXX     **          
      **        WHERE 'XXXXX' CAN BE ANY SERVICE ORDER TYPE         **          
      **        CORRESPONDING TO ELECTRIC AND/OR GAS.               **          
      **        THERE MUST BE A MATCHING ENTRY HERE FOR THE         **          
      **        UTIL TYPE ROW ABOVE.  EXAMPLE: IF YOU ARE ONLY      **          
      **        DOING UTIL TYPE=E, THEN THERE MUST BE AN ELECTRIC   **          
      **        ORDER TYPE ENTERED, WITH THE GAS ORDER TYPE BLANK.  **          
      **        IF UTIL TYPE=B, THEN BOTH ELECTRIC AND GAS ORDER    **          
      **        TYPES MUST HAVE A LEGITIMATE ORDER TYPE ENTERED.    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0200-PROCESS-MAIN.                                               
      *                                                                         
           MOVE SPACES TO WS-SYSIPT.                                    
      *                                                                         
           IF  WS-FIRST-TIME = 'Y'                                      
              MOVE 'N' TO WS-FIRST-TIME                                 
      *                                                                         
      *  AT THIS POINT OUR ORDER TYPE AND WORK TYPE MUST BE VALID               
      *  TOGETHER.   IF NOT, ABEND PROGRAM                                      
      *                                                                         
              MOVE WS-SAVE-CO TO L3-COMPANY-NO                          
              IF (WS-PARM-UTIL-TYPE = 'E')                              
                     AND (WS-PARM-ELEC-ORDER > SPACES)                  
                 MOVE WS-PARM-ELEC-ORDER TO L3-ORDER-TYPE-CD            
                 MOVE WS-PARM-ELEC-WORK  TO L3-WORK-TYPE-CD             
                 PERFORM 7322-SELECT-WORK-TYPE THRU 7322-EXIT           
              ELSE                                                      
                 IF (WS-PARM-UTIL-TYPE = 'G')                           
                        AND (WS-PARM-GAS-ORDER > SPACES)                
                    MOVE WS-PARM-GAS-ORDER TO L3-ORDER-TYPE-CD          
                    MOVE WS-PARM-GAS-WORK  TO L3-WORK-TYPE-CD           
                    PERFORM 7322-SELECT-WORK-TYPE THRU 7322-EXIT        
                 ELSE                                                   
                    IF (WS-PARM-UTIL-TYPE = 'B')                        
                           AND (WS-PARM-ELEC-ORDER > SPACES)            
                              AND (WS-PARM-GAS-ORDER > SPACES)          
                       MOVE WS-PARM-ELEC-ORDER TO L3-ORDER-TYPE-CD      
                       MOVE WS-PARM-ELEC-WORK  TO L3-WORK-TYPE-CD       
                       PERFORM 7322-SELECT-WORK-TYPE THRU 7322-EXIT     
                       MOVE WS-PARM-GAS-ORDER TO L3-ORDER-TYPE-CD       
                       MOVE WS-PARM-GAS-WORK  TO L3-WORK-TYPE-CD        
                       PERFORM 7322-SELECT-WORK-TYPE THRU 7322-EXIT     
                    ELSE                                                
                    DISPLAY '* INFORMATIONAL COMMENT ONLY *'            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              IF WS-SAVE-CO = '01' AND WS-SCEG = 'N'                    
                 MOVE 0 TO WS-PAGE-COUNT                                
                 MOVE 'S C ELECTRIC & GAS CO     ' TO WS-COMPANY-NAME   
                 MOVE 'Y' TO WS-SCEG                                    
                 PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT            
                 MOVE SPACES TO PRINT-LINE                              
                 MOVE NO-DATA-LINE TO PRT-MESSAGE                       
                 PERFORM 8300-PRINT-REPORT THRU 8300-EXIT               
                 MOVE SPACES TO PRINT-LINE                              
                 MOVE WS-PARM-COMP-NO   TO WS-SAVE-CO                   
                 MOVE +66 TO WS-LINE-COUNT                              
              END-IF                                                    
              IF WS-SAVE-CO = '26' AND WS-PSNC = 'N'                    
                 MOVE 0 TO WS-PAGE-COUNT                                
                 MOVE '     PSNC ENERGY          ' TO WS-COMPANY-NAME   
                 MOVE 'Y' TO WS-PSNC                                    
                 PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT            
                 MOVE SPACES TO PRINT-LINE                              
                 MOVE NO-DATA-LINE TO PRT-MESSAGE                       
                 PERFORM 8300-PRINT-REPORT THRU 8300-EXIT               
                 MOVE SPACES TO PRINT-LINE                              
                 MOVE WS-PARM-COMP-NO   TO WS-SAVE-CO                   
                 MOVE +66 TO WS-LINE-COUNT                              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF  G6-STATUS = WS-A                                         
               PERFORM 0500-PROCESS-DATA THRU 0500-EXIT                 
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET ALL VALID CODE_METER_STATUS THAT THEY WANT TO USE       *          
      *  FOR EACH RUN.  THE JOB PARM MEMBER IS CODED WITH EACH       *          
      *  POSSIBLE CODE-METER-STATUS.  FOR EXAMPLE, THEY ARE ENTERED  *          
      *  ON JOB-PARM AS N=J, ETC.  FOR EACH CODE-METER-STATUS THEY   *          
      *  WANT TO INCLUDE, THEY NEED TO CHANGE THE "N' BEFORE EACH    *          
      *  CODE TO EITHER A 'Y' OR AN 'R'.  IF A 'Y' IT IS ONE THEY    *          
      *  WANT TO GO TO THE OUTPUT FILE AND AN 'R' SENDS IT TO THE    *          
      *  REPORT.                                                     *          
      *  THE LAST CODE IS N=X, AND THE 'X' IS IF THEY                *          
      *  WANT TO INCLUDE WHERE CODE-METER-STATUS = SPACE.            *          
      ****************************************************************          
      *                                                                         
       0222-GET-CODE-METER-STATUS.                                      
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-METER-STATUS-LIT = 'MTR STATUS - '             
                         AND INPUT-ACTIVE)                              
                      OR END-OF-SYSIPT.                                 
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    METER STATUS NOT FOUND          **'        
              DISPLAY '**     END-OF-SYSIPT                  **'        
              DISPLAY '**     PROCESSING TERMINATED          **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 7611-CLOSE THRU 7611-EXIT.                           
      *                                                                         
           IF WS-MTR-STAT-0-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-0-LIT TO WS-MTR-STAT-CD0                 
              MOVE WS-MTR-STAT-0     TO WS-MTR-STAT-0X                  
           END-IF.                                                      
           IF WS-MTR-STAT-1-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-1-LIT TO WS-MTR-STAT-CD1                 
              MOVE WS-MTR-STAT-1     TO WS-MTR-STAT-1X                  
           END-IF.                                                      
           IF WS-MTR-STAT-A-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-A-LIT TO WS-MTR-STAT-CDA                 
              MOVE WS-MTR-STAT-A     TO WS-MTR-STAT-AX                  
           END-IF.                                                      
           IF WS-MTR-STAT-B-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-B-LIT TO WS-MTR-STAT-CDB                 
              MOVE WS-MTR-STAT-B     TO WS-MTR-STAT-BX                  
           END-IF.                                                      
           IF WS-MTR-STAT-I-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-I-LIT TO WS-MTR-STAT-CDI                 
              MOVE WS-MTR-STAT-I     TO WS-MTR-STAT-IX                  
           END-IF.                                                      
           IF WS-MTR-STAT-J-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-J-LIT TO WS-MTR-STAT-CDJ                 
              MOVE WS-MTR-STAT-J TO WS-MTR-STAT-JX                      
           END-IF.                                                      
           IF WS-MTR-STAT-K-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-K-LIT TO WS-MTR-STAT-CDK                 
              MOVE WS-MTR-STAT-K     TO WS-MTR-STAT-KX                  
           END-IF.                                                      
           IF WS-MTR-STAT-X-LIT = WS-YES OR WS-R                        
              MOVE WS-MTR-STAT-X-LIT TO WS-MTR-STAT-CDX                 
              MOVE SPACES            TO WS-MTR-STAT-XX                  
           END-IF.                                                      
      *                                                                         
           DISPLAY 'STAT = ' WS-MTR-STAT-0X ' CODE = ' WS-MTR-STAT-CD0. 
           DISPLAY 'STAT = ' WS-MTR-STAT-1X ' CODE = ' WS-MTR-STAT-CD1. 
           DISPLAY 'STAT = ' WS-MTR-STAT-AX ' CODE = ' WS-MTR-STAT-CDA. 
           DISPLAY 'STAT = ' WS-MTR-STAT-BX ' CODE = ' WS-MTR-STAT-CDB. 
           DISPLAY 'STAT = ' WS-MTR-STAT-IX ' CODE = ' WS-MTR-STAT-CDI. 
           DISPLAY 'STAT = ' WS-MTR-STAT-JX ' CODE = ' WS-MTR-STAT-CDJ. 
           DISPLAY 'STAT = ' WS-MTR-STAT-KX ' CODE = ' WS-MTR-STAT-CDK. 
           DISPLAY 'STAT = ' WS-MTR-STAT-XX ' CODE = ' WS-MTR-STAT-CDX. 
      *                                                                         
       0222-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET ALL VALID LEAK SURVEY FREQUENCY CODES THEY WANT TO USE  *          
      *  FOR EACH RUN.  THE JOB PARM MEMBER IS CODED WITH EACH       *          
      *  POSSIBLE CODE.  THEY NEED TO CHANGE 'N' TO 'Y' FOR ONES     *          
      *  THEY WANT TO PULL FOR.                                      *          
      ****************************************************************          
      *                                                                         
       0233-GET-LEAK-SURVEY.                                            
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-LEAK-FREQ-LIT = 'LEAK FREQ -'                  
                         AND INPUT-ACTIVE)                              
                      OR END-OF-SYSIPT.                                 
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    LEAK SURVEY NOT BEING USED      **'        
              DISPLAY '**     SQLCODE = 100                  **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
           ELSE                                                         
              MOVE WS-YES TO WS-LEAK-FREQ-SW                            
              IF WS-LEAK-FREQ-16-LIT = WS-YES                           
                 MOVE WS-LEAK-FREQ-16 TO WS-LEAK-FREQ-16X               
              END-IF                                                    
      *                                                                         
              IF WS-LEAK-FREQ-27-LIT = WS-YES                           
                 MOVE WS-LEAK-FREQ-27 TO WS-LEAK-FREQ-27X               
              END-IF                                                    
      *                                                                         
              IF WS-LEAK-FREQ-38-LIT = WS-YES                           
                 MOVE WS-LEAK-FREQ-38 TO WS-LEAK-FREQ-38X               
              END-IF                                                    
      *                                                                         
              IF WS-LEAK-FREQ-49-LIT = WS-YES                           
                 MOVE WS-LEAK-FREQ-49 TO WS-LEAK-FREQ-49X               
              END-IF                                                    
      *                                                                         
              IF WS-LEAK-FREQ-50-LIT = WS-YES                           
                 MOVE WS-LEAK-FREQ-50 TO WS-LEAK-FREQ-50X               
              END-IF                                                    
      *                                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
      *                                                                         
           END-IF.                                                      
      *                                                                         
           DISPLAY '********** LEAK SURVEY FREQUENCY CODES ********'.   
           DISPLAY 'WS-LEAK-FREQ-16X = ' WS-LEAK-FREQ-16X.              
           DISPLAY 'WS-LEAK-FREQ-27X = ' WS-LEAK-FREQ-27X.              
           DISPLAY 'WS-LEAK-FREQ-38X = ' WS-LEAK-FREQ-38X.              
           DISPLAY 'WS-LEAK-FREQ-49X = ' WS-LEAK-FREQ-49X.              
           DISPLAY 'WS-LEAK-FREQ-50X = ' WS-LEAK-FREQ-50X.              
           DISPLAY '***********************************************'.   
      *                                                                         
       0233-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET ALL GAS RATES THEY WANT TO USE FOR EACH RUN.            *          
      *  IF NOT WANTED, JOB PARM RATE SHOULD BE LEFT AS 'XXX'.       *          
      ****************************************************************          
      *                                                                         
       0244-GET-RATE-PLAN.                                              
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-RATE-PLAN-LIT = 'GAS RATES ONLY -'             
                         AND INPUT-ACTIVE)                              
                      OR END-OF-SYSIPT.                                 
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    RATE PLAN NOT BEING USED        **'        
              DISPLAY '**     SQLCODE = 100                  **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
           ELSE                                                         
              MOVE WS-YES TO WS-RATE-PLAN-SW                            
              MOVE WS-RATE-PLAN-1 TO WS-RATE-PLAN-1X                    
              MOVE WS-RATE-PLAN-2 TO WS-RATE-PLAN-2X                    
              MOVE WS-RATE-PLAN-3 TO WS-RATE-PLAN-3X                    
              MOVE WS-RATE-PLAN-4 TO WS-RATE-PLAN-4X                    
      *                                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
      *                                                                         
           END-IF.                                                      
      *                                                                         
           DISPLAY '************* RATE PLAN ***********************'.   
           DISPLAY 'WS-RATE-PLAN-1X = ' WS-RATE-PLAN-1X.                
           DISPLAY 'WS-RATE-PLAN-2X = ' WS-RATE-PLAN-2X.                
           DISPLAY 'WS-RATE-PLAN-3X = ' WS-RATE-PLAN-3X.                
           DISPLAY 'WS-RATE-PLAN-4X = ' WS-RATE-PLAN-4X.                
           DISPLAY '***********************************************'.   
      *                                                                         
       0244-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET ALL ZIP CODES THEY WANT TO USE FOR EACH RUN.            *          
      *  IF NOT WANTED, JOB PARM ZIP CODE SHOULD BE LEFT AS 'XXXXX'. *          
      ****************************************************************          
      *                                                                         
       0246-GET-ZIP-CODES.                                              
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-ZIP-CO-NO = 'CO='                              
                     AND WS-PARM-ZIP-LITERAL = 'ZIPCD='                 
                         AND INPUT-ACTIVE)                              
                      OR END-OF-SYSIPT.                                 
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    ZIP CODE NOT ACTIVE ABEND       **'        
              DISPLAY '**     SQLCODE = 100                  **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE WS-PARM-ZIPCD-1 TO WS-ZIP-CODE-1                     
              MOVE WS-PARM-ZIPCD-2 TO WS-ZIP-CODE-2                     
              MOVE WS-PARM-ZIPCD-3 TO WS-ZIP-CODE-3                     
              MOVE WS-PARM-ZIPCD-4 TO WS-ZIP-CODE-4                     
              MOVE WS-PARM-ZIPCD-5 TO WS-ZIP-CODE-5                     
              MOVE WS-PARM-ZIPCD-6 TO WS-ZIP-CODE-6                     
              MOVE WS-ZIP-COMP-NO  TO WS-PARM-COMP-NO                   
              MOVE WS-ZIP-COMP-NO  TO AT-COMPANY-NO                     
                                      WS-SAVE-CO                        
      *                                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
      *                                                                         
           END-IF.                                                      
      *                                                                         
           DISPLAY '************* ZIP CODE  ***********************'.   
           DISPLAY 'WS-ZIP-CODE-1 = ' WS-ZIP-CODE-1.                    
           DISPLAY 'WS-ZIP-CODE-2 = ' WS-ZIP-CODE-2.                    
           DISPLAY 'WS-ZIP-CODE-3 = ' WS-ZIP-CODE-3.                    
           DISPLAY 'WS-ZIP-CODE-5 = ' WS-ZIP-CODE-4.                    
           DISPLAY 'WS-ZIP-CODE-5 = ' WS-ZIP-CODE-5.                    
           DISPLAY 'WS-ZIP-CODE-6 = ' WS-ZIP-CODE-6.                    
           DISPLAY '***********************************************'.   
      *                                                                         
       0246-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    PROCESS PCSCA629                                        **          
      ****************************************************************          
      *                                                                         
       0500-PROCESS-DATA.                                               
      *                                                                         
           PERFORM 7000-OPEN-METER-CURSOR THRU 7000-EXIT.               
           PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT.              
           PERFORM 1100-FORMAT-READONE THRU 1100-EXIT                   
                 UNTIL WS-NO-MORE-DATA = WS-YES.                        
      *                                                                         
           PERFORM 7200-CLOSE-METER-CURSOR THRU 7200-EXIT.              
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   FORMAT DATA FOR THE OUTPUT FILE FCSCA629                 **          
      ****************************************************************          
      *                                                                         
       1100-FORMAT-READONE.                                             
      *                                                                         
           MOVE WS-N TO WS-RATE-PLAN-WANTED.                            
           MOVE WS-N TO WS-LEAK-FREQ-WANTED.                            
      *                                                                         
           IF WS-RATE-PLAN-SW = WS-N OR                                 
               DY-ZIP-CODE NOT = WS-ZIP-CODE-1 AND WS-ZIP-CODE-2        
                AND WS-ZIP-CODE-3 AND WS-ZIP-CODE-4 AND WS-ZIP-CODE-5   
                AND WS-ZIP-CODE-6                                       
              CONTINUE                                                  
           ELSE                                                         
              IF MN-CODE-UTIL-TYPE = 'E'                                
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 1200-DO-I-WANT-THIS-RATE THRU 1200-EXIT        
                 IF WS-RATE-PLAN-WANTED = WS-YES                        
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT      
                    GO TO 1100-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-LEAK-FREQ-SW = WS-N                                    
              CONTINUE                                                  
           ELSE                                                         
              IF MN-CODE-UTIL-TYPE = 'E'                                
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 1205-DO-I-WANT-THIS-LEAK THRU 1205-EXIT        
                 IF WS-LEAK-FREQ-WANTED = WS-YES                        
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT      
                    GO TO 1100-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT.              
      *                                                                         
           IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                       
              PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT             
           ELSE                                                         
              PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT            
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-CODE-METER-STATUS = WS-MTR-STAT-0X                     
              IF WS-MTR-STAT-CD0   = WS-YES                             
                 PERFORM 1125-CREATE-OUTPUT-FILE THRU 1125-EXIT         
              ELSE                                                      
                 PERFORM 1150-CREATE-REPORT THRU 1150-EXIT              
              END-IF                                                    
           ELSE                                                         
      *                                                                         
             IF MN-CODE-METER-STATUS = WS-MTR-STAT-1X                   
                IF WS-MTR-STAT-CD1   = WS-YES                           
                   PERFORM 1125-CREATE-OUTPUT-FILE THRU 1125-EXIT       
                ELSE                                                    
                   PERFORM 1150-CREATE-REPORT THRU 1150-EXIT            
                END-IF                                                  
             ELSE                                                       
      *                                                                         
               IF MN-CODE-METER-STATUS = WS-MTR-STAT-AX                 
                  IF WS-MTR-STAT-CDA   = WS-YES                         
                     PERFORM 1125-CREATE-OUTPUT-FILE THRU 1125-EXIT     
                  ELSE                                                  
                     PERFORM 1150-CREATE-REPORT THRU 1150-EXIT          
                  END-IF                                                
               ELSE                                                     
      *                                                                         
                 IF MN-CODE-METER-STATUS = WS-MTR-STAT-BX               
                    IF WS-MTR-STAT-CDB   = WS-YES                       
                       PERFORM 1125-CREATE-OUTPUT-FILE THRU 1125-EXIT   
                    ELSE                                                
                       PERFORM 1150-CREATE-REPORT THRU 1150-EXIT        
                    END-IF                                              
                 ELSE                                                   
      *                                                                         
                   IF MN-CODE-METER-STATUS = WS-MTR-STAT-IX             
                      IF WS-MTR-STAT-CDI   = WS-YES                     
                         PERFORM 1125-CREATE-OUTPUT-FILE                
                               THRU 1125-EXIT                           
                      ELSE                                              
                         PERFORM 1150-CREATE-REPORT THRU 1150-EXIT      
                      END-IF                                            
                   ELSE                                                 
      *                                                                         
                     IF MN-CODE-METER-STATUS = WS-MTR-STAT-JX           
                        IF WS-MTR-STAT-CDJ   = WS-YES                   
                           PERFORM 1125-CREATE-OUTPUT-FILE              
                                 THRU 1125-EXIT                         
                        ELSE                                            
                           PERFORM 1150-CREATE-REPORT THRU 1150-EXIT    
                        END-IF                                          
                     ELSE                                               
      *                                                                         
                       IF MN-CODE-METER-STATUS = WS-MTR-STAT-KX         
                          IF WS-MTR-STAT-CDK   = WS-YES                 
                             PERFORM 1125-CREATE-OUTPUT-FILE            
                                   THRU 1125-EXIT                       
                          ELSE                                          
                             PERFORM 1150-CREATE-REPORT THRU 1150-EXIT  
                          END-IF                                        
                       ELSE                                             
      *                                                                         
                         IF MN-CODE-METER-STATUS = WS-MTR-STAT-XX       
                            IF WS-MTR-STAT-CDX   = WS-YES               
                               PERFORM 1125-CREATE-OUTPUT-FILE          
                                     THRU 1125-EXIT                     
                            ELSE                                        
                               PERFORM 1150-CREATE-REPORT               
                                     THRU 1150-EXIT                     
                            END-IF                                      
                         END-IF                                         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT.              
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE OUTPUT FILE                                           *          
      ****************************************************************          
      *                                                                         
       1125-CREATE-OUTPUT-FILE.                                         
      *                                                                         
           MOVE SPACES TO FIOCA629-RECORD.                              
      *                                                                         
           MOVE AT-ACCOUNT-NO        TO E-FCA629-ACCT-NO.               
           MOVE MN-METER-NO          TO E-FCA629-METER-NO.              
           MOVE MN-CODE-UTIL-TYPE    TO E-FCA629-UTIL-TYPE.             
           MOVE MN-CODE-METER-STATUS TO E-FCA629-CODE-METER-STAT.       
           MOVE UT-COMPANY-NO        TO E-FCA629-COMPANY-NO.            
           MOVE WS-PARM-AMR-TYPE     TO E-FCA629-TEST-TYPE.             
           MOVE WS-PARM-DATE         TO E-FCA629-WANTED-DATE.           
           MOVE WS-RUN-TYPE          TO E-FCA629-RUN-TYPE.              
           MOVE AT-PREMISE-NO        TO E-FCA629-PREMISE-NO.            
      *                                                                         
           IF MN-CODE-UTIL-TYPE = 'E'                                   
              MOVE WS-PARM-ELEC-ORDER TO E-FCA629-ORDER-TYPE            
              MOVE WS-PARM-ELEC-WORK  TO E-FCA629-WORK-TYPE             
           ELSE                                                         
              MOVE WS-PARM-GAS-ORDER TO E-FCA629-ORDER-TYPE             
              MOVE WS-PARM-GAS-WORK  TO E-FCA629-WORK-TYPE              
           END-IF.                                                      
      *                                                                         
           PERFORM 8000-WRITE-FIOCA629 THRU 8000-EXIT.                  
      *                                                                         
       1125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE THE PRINT LINE FOR THE REPORT OF ACCOUNTS THAT ARE    *          
      * OBTAINED USING THE ROUTE_METER_CSR, BUT HAVE FAILED SOME     *          
      * TEST AND ARE NOT TO BE INCLUDED ON THE OUTPUT FILE.          *          
      ****************************************************************          
      *                                                                         
       1150-CREATE-REPORT.                                              
      *                                                                         
           MOVE SPACES  TO PRINT-LINE.                                  
           MOVE WS-LIT1 TO PRT-COMMENT.                                 
      *                                                                         
           IF MC-CONSTANT > 1                                           
              MOVE WS-LIT4 TO PRT-COMMENT                               
           END-IF.                                                      
      *                                                                         
           IF MN-CODE-DATA-PRESENT = 'A'                                
                     AND WS-PARM-METER-TYPE = 'S'                       
              MOVE WS-LIT3 TO PRT-COMMENT                               
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO       TO PRT-ACCOUNT.                     
           MOVE MN-METER-NO         TO PRT-METER-NO.                    
           MOVE MN-CODE-UTIL-TYPE   TO PRT-UTIL-TYPE.                   
           MOVE MN-DIGTL-MTR-TYPE   TO PRT-DMT.                         
           MOVE MN-PROGRAM-ID       TO PRT-PGM-ID.                      
           MOVE MN-REMOTE-READ-IND  TO PRT-REMOTE-READ.                 
           MOVE WS-PR-STREET        TO PRT-ADDRESS.                     
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
           MOVE AT-PREMISE-NO TO PRT-PREMISE.                           
           MOVE MN-CODE-METER-STATUS TO PRT-STATUS.                     
           MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO PRT-ADDRESS.              
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *** WHEN THE RATE PLAN PARM IS USED, THIS ROUTINE             **          
      *** DETERMINES IF THE ACCOUNT IS ONE THAT WE WANT TO PROCESSS **          
      ****************************************************************          
      *                                                                         
       1200-DO-I-WANT-THIS-RATE.                                        
      *                                                                         
           IF UT-RATE-PLAN-NO = WS-RATE-PLAN-1X OR WS-RATE-PLAN-2X      
                             OR WS-RATE-PLAN-3X OR WS-RATE-PLAN-4X      
              MOVE WS-YES TO WS-RATE-PLAN-WANTED                        
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *** WHEN THE LEAK SURVEY PARM IS USED, THIS ROUTINE           **          
      *** DETERMINES IF THE ACCOUNT IS ONE THAT WE WANT TO PROCESSS **          
      ****************************************************************          
      *                                                                         
       1205-DO-I-WANT-THIS-LEAK.                                        
      *                                                                         
           IF PR-GAS-LK-SURVEY-FREQ = WS-LEAK-FREQ-16X OR               
                                      WS-LEAK-FREQ-27X OR               
                                      WS-LEAK-FREQ-38X OR               
                                      WS-LEAK-FREQ-49X OR               
                                      WS-LEAK-FREQ-50X                  
              MOVE WS-YES TO WS-LEAK-FREQ-WANTED                        
           END-IF.                                                      
      *                                                                         
       1205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  ERROR ROUTINE FOR CPD00099                                  *          
      ****************************************************************          
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '*************PCSCA629************'.                 
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSCA629************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **        THE DRIVING CURSOR IS OPENED.                       **          
      ****************************************************************          
      *                                                                         
       7000-OPEN-METER-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN ROUTE_METER_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7000       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7030-SELECT-CODE-VALUE                                    **          
      ****************************************************************          
      *                                                                         
       7030-SELECT-CODE-VALUE.                                          
           MOVE '7030'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           EXEC SQL                                                     
            SELECT 'Y'                                                  
              INTO :WS-IS-THIS-A-GOOD-AMR                               
             FROM  CSS_CODE_VALUE WITH(READUNCOMMITTED)                         
             WHERE COMPANY_NO = '01'                                    
             AND   COLUMN_NA  = 'ORDER_PLACED_BY'                       
             AND   TABLE_NA   = 'CSS_SO_DATA_MF'                        
             AND   CODE_VALUE = :WS-CODE-VALUE-TEXT                     
             AND   PROGRAM_ID = 'PCSCA629'                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT 'Y'                                                          
MFA-TR*       INTO :WS-IS-THIS-A-GOOD-AMR                                       
MFA-TR*      FROM  CSS_CODE_VALUE                                               
MFA-TR*      WHERE COMPANY_NO = '01'                                            
MFA-TR*      AND   COLUMN_NA  = 'ORDER_PLACED_BY'                               
MFA-TR*      AND   TABLE_NA   = 'CSS_SO_DATA_MF'                                
MFA-TR*      AND   CODE_VALUE = :WS-CODE-VALUE-TEXT                             
MFA-TR*      AND   PROGRAM_ID = 'PCSCA629'                                      
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '****************************************'       
               DISPLAY '** ' WS-PGRMNAME '                    **'       
               DISPLAY '**    7030-SELECT-CODE-VALUE          **'       
               DISPLAY '**      INVALID PARM FOR              **'       
               DISPLAY '**     AMR TYPE / WANTED DATE         **'       
               DISPLAY '**  AMR TYPE MUST = A OR D            **'       
               DISPLAY '**  DATE MUST BE GREATER SPACES       **'       
               DISPLAY '**  IN FORMAT YYYY-MM-DD              **'       
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '****************************************'       
               DISPLAY ' '                                              
               PERFORM 9900-ABEND THRU 9900-EXIT                        
            END-IF.                                                     
      *                                                                         
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **       THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **          
      ****************************************************************          
      *                                                                         
       7100-FETCH-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
             FETCH  ROUTE_METER_CSR                                     
              INTO  :AT-ACCOUNT-NO                                      
                   ,:UT-READ-ROUTE                                      
                   ,:UT-READ-CYCLE                                      
                   ,:UT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:MN-REGISTER-RD-SEQ                                 
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-IC-NO                                           
                   ,:AT-PREMISE-NO                                      
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-PROGRAM-ID                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-CODE-DATA-PRESENT                               
                   ,:MC-CONSTANT                                        
                   ,:MN-CODE-METER-STATUS                               
                   ,:UT-RATE-PLAN-NO                                    
                   ,:PR-GAS-LK-SURVEY-FREQ                              
                   ,:DY-ZIP-CODE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE WS-YES TO WS-NO-MORE-DATA                       
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA629 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7100       **'   
                   DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE      
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        THE DRIVING CURSOR IS CLOSED.                       **          
      ****************************************************************          
      *                                                                         
       7200-CLOSE-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE ROUTE_METER_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        RETRIEVE ELECTRIC METER CLASS CODE.                 **          
      ****************************************************************          
      *                                                                         
       7300-SELECT-ELEC-METER.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT EM.ELEC_MTR_CLASS_CD                                
                   ,EM.ELEC_MTR_SPEC_CD                                 
               INTO :EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-ELEC-MTR-SPEC-CD                                
               FROM  CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
              WHERE EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE              
                AND EM.METER_NO       = :EM-METER-NO                    
                AND EM.COMPANY_NO     = :EM-COMPANY-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT EM.ELEC_MTR_CLASS_CD                                        
MFA-TR*            ,EM.ELEC_MTR_SPEC_CD                                         
MFA-TR*        INTO :EM-ELEC-MTR-CLASS-CD                                       
MFA-TR*            ,:EM-ELEC-MTR-SPEC-CD                                        
MFA-TR*        FROM  CSS_ELEC_METER EM                                          
MFA-TR*       WHERE EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                      
MFA-TR*         AND EM.METER_NO       = :EM-METER-NO                            
MFA-TR*         AND EM.COMPANY_NO     = :EM-COMPANY-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '**      7300-SELECT-ELEC-METER.       **'       
               DISPLAY '**     PCSCA629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
               DISPLAY '* COMPANY-NO     = ' EM-COMPANY-NO              
               DISPLAY '* CODE-UTIL-TYPE = ' EM-CODE-UTIL-TYPE          
               DISPLAY '* METER-NO       = ' EM-METER-NO                
               DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        VALIDATE ORDER TYPE AND WORK TYPE                   **          
      ****************************************************************          
      *                                                                         
       7322-SELECT-WORK-TYPE.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :WS-WORKTYPE-OK                                     
               FROM  CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                    
              WHERE COMPANY_NO    = :L3-COMPANY-NO                      
                AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                   
                AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                    
                AND STATUS_CHANGE_DT IS NULL                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-WORKTYPE-OK                                             
MFA-TR*        FROM  CSS_ORDER_WK_TYPE                                          
MFA-TR*       WHERE COMPANY_NO    = :L3-COMPANY-NO                              
MFA-TR*         AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                           
MFA-TR*         AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                            
MFA-TR*         AND STATUS_CHANGE_DT IS NULL                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '**      7322-SELECT-WORK-TYPE.        **'       
               DISPLAY '**     PCSCA629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7322       **'       
               DISPLAY '**      INVALID COMBINATION OF        **'       
               DISPLAY '**      ORDER TYPE AND WORK TYPE      **'       
               DISPLAY '* L3-COMPANY-NO = '  L3-COMPANY-NO              
               DISPLAY '* L3-ORDER-TYPE-CD = ' L3-ORDER-TYPE-CD         
               DISPLAY '* L3-WORK-TYPE-CD = ' L3-WORK-TYPE-CD           
               DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7322-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING       **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    GET CURRENT DATE                                          *          
      ****************************************************************          
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
      *  REPLACED MODEL SQL WITH SET STMT FOR BETTER PERFORMANCE                
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '7500-GET-CURRENT-TIMESTAMP'                      
              PERFORM 9900-ABEND THRU  9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    VERIFY THE WS-PARM-DATE IS VALID                          *          
      *    THIS DATE ONLY HAS TO BE A GOOD DATE.                     *          
      ****************************************************************          
      *                                                                         
       7510-VERIFY-PARM-DATE-IS-VALID.                                  
      *                                                                         
      *  REPLACED MODEL SQL WITH SET STMT FOR BETTER PERFORMANCE                
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-PARM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARM-DATE
              ) <> 0) OR (LEN(:WS-PARM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PARM-DATE
              ), CONVERT(DATE, :WS-PARM-DATE) ) )
            INTO
              :WS-WHO-CARES-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WHO-CARES-DATE =                                          
MFA-TR*           DATE(:WS-PARM-DATE) - 1 DAYS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = -181                              
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** ' WS-PGRMNAME '                    **'     
                 DISPLAY '** 7510-VERIFY-PARM-DATE-IS-VALID     **'     
                 DISPLAY '**  INVALID PARM-AMR-TYPE-DATA        **'     
                 DISPLAY '**  DATE MUST BE VALID AND IN DB2     **'     
                 DISPLAY '**     FORMAT YYYY-MM-DD              **'     
                 DISPLAY '**     PROCESSING TERMINATED          **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** WRITE INTO THE FILE FCSCA629                               **          
      ****************************************************************          
      *                                                                         
       8000-WRITE-FIOCA629.                                             
      *                                                                         
           WRITE FIOCA629-RECORD.                                       
      *                                                                         
           IF  FCA629-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '**     PCSCA629 PROCESSING ERROR         **'    
               DISPLAY '**      ABEND IN PARAGRAPH 8000          **'    
               DISPLAY '**      ERROR ON FCSCA629  WRITE         **'    
               DISPLAY '**      STATUS IS ' WS-FCA629-STATUS            
               DISPLAY '*******************************************'    
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CHECK FOR LINE COUNT FOR REPORT HEADERS              **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-REPORT.                                               
      *                                                                         
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       WRITES THE HEADER TO THE REPORT FILE                 **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-HEADERS.                                              
      *                                                                         
           IF WS-PARM-COMP-NO = '01'                                    
             IF WS-SCEG = 'N'                                           
                MOVE 0 TO WS-PAGE-COUNT                                 
             END-IF                                                     
             MOVE 'S C ELECTRIC & GAS CO     ' TO WS-COMPANY-NAME       
             MOVE 'Y' TO WS-SCEG                                        
           END-IF.                                                      
      *                                                                         
           IF WS-PARM-COMP-NO = '26'                                    
             IF WS-PSNC = 'N'                                           
                MOVE 0 TO WS-PAGE-COUNT                                 
             END-IF                                                     
             MOVE '     PSNC ENERGY          ' TO WS-COMPANY-NAME       
             MOVE 'Y' TO WS-PSNC                                        
           END-IF.                                                      
      *                                                                         
       8200-NO-DATA-HEADERS.                                            
      *                                                                         
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                         
           MOVE HEADER1 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE HEADER2 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE SPACES TO PRT32-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE HEADER3 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE SPACES TO PRT32-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE +5 TO WS-LINE-COUNT.                                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE         **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-REPORT.                                               
      *                                                                         
           MOVE PRINT-LINE TO PRT32-RECORD.                             
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       WRITES THE REPORT                                    **          
      ****************************************************************          
      *                                                                         
       8900-WRITE-REPORT.                                               
      *                                                                         
           WRITE PRT32-RECORD.                                          
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **    NORMAL TERMINATION OF JOB                              **           
      ***************************************************************           
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA629-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 9700-PROCESS-ABEND                             *          
      ****************************************************************          
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
