       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA628.                                      
       AUTHOR.       MITHUN KUMAR SEKARAN.                              
COB303 DATE-WRITTEN.     NOV 20,  2015.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      *** THIS PROGRAM POSTS BTU FACTOR AND SPECIFIC GRAVITY VALUES  ***        
      *** TO CIG BTU-ID'S.                                           ***        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
A05268***  -----------   --------    --------------------------------***        
ACT035***  11/20/2015    MS7M727     EZT TO COBOL CONVERSION         ***        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999    COMMON PROGRAM MODULES                **         
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT80.                                                            
      *                                                                         
           SELECT FCSPT33-FILE                                          
               ASSIGN  TO UT-S-FCSPT33                                  
               FILE STATUS IS WS-FCSPT33-STATUS.                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *****************************************************************         
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE                           
      *****************************************************************         
      *                                                                         
       FD  FCSPT80-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01 IN-BTU-INDUST-FCT.                                            
          05 IN-BTU-DT                      PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 IN-BTU-FACTOR.                                             
             10 IN-BTU-FACTOR-N             PIC 9(01) VALUE ZERO.       
             10 FILLER                      PIC X(01) VALUE SPACES.     
             10 IN-BTU-FACTOR-D             PIC 9(03) VALUE ZERO.       
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 IN-SPECIFIC-GRAVITY.                                       
             10 IN-SPECIFIC-GRAVITY-N       PIC 9(01) VALUE ZERO.       
             10 FILLER                      PIC X(01) VALUE SPACES.     
             10 IN-SPECIFIC-GRAVITY-D       PIC 9(03) VALUE ZERO.       
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 IN-INDUST-BTU-ID               PIC X(03) VALUE SPACES.     
          05 IN-HDR-BTU.                                                
             10 IN-HDR-IST-CHAR             PIC X(01) VALUE SPACES.     
             10 IN-HDR-OTHR-2CH             PIC X(02) VALUE SPACES.     
          05 FILLER                         PIC X(51) VALUE SPACES.     
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA628'.
MSQ017     COPY MFASQLM.
      *                                                                         
      *****************************************************************         
      *    CSS_BTU_INDUST_FCT FE                                                
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINDFCT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COMMON SQL AND DB2 ABEND CODES                                       
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       01 WS-LITERAL.                                                   
          05 WS-PROGRAM-NAME                PIC X(08) VALUE 'PCSCA628'. 
          05 WS-FIRST                       PIC X(01) VALUE 'Y'.        
      *                                                                         
       01 WS-COUNTER.                                                   
          05 WS-LINE-COUNT                  PIC 9(02) VALUE ZERO.       
          05 WS-LINE-COUNT-REC              PIC 9(02) VALUE ZERO.       
          05 WS-PAGE-NUM                    PIC 9(02) VALUE ZERO.       
          05 WS-REC-COUNT                   PIC 9(08) VALUE ZERO.       
          05 WS-TOT-COUNT                   PIC 9(08) VALUE ZERO.       
      *                                                                         
       01 WS-FILE-STATUS-SW.                                            
          05 WS-FPT80-STATUS                PIC X(02).                  
             88 FCSPT80-SUCCESSFUL                    VALUE '00'.       
             88 END-OF-REC                            VALUE '10'.       
          05 WS-FCSPT33-STATUS              PIC  X(02).                 
             88 FCSPT33-SUCCESSFUL                    VALUE '00'.       
      *                                                                         
       01 WS-VALID-FL                       PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-BTU-SPEC-GRAV.                                             
          05 WS-BTU                         PIC S9(04)V9(05) USAGE      
                                                COMP-3 VALUE ZERO.      
          05 WS-SPEC                        PIC S9(03)V9(03) USAGE      
                                                COMP-3 VALUE ZERO.      
          05 WS-BTU-C                       PIC 9(04)V9(05) VALUE ZERO. 
          05 WS-SPEC-C                      PIC 9(03)V9(03) VALUE ZERO. 
      *                                                                         
       01 WS-BTU-DT.                                                    
          05 WS-BTU-DT-MM                   PIC 9(02) VALUE ZERO.       
          05 WS-BTU-DT-F1                   PIC X(01) VALUE '-'.        
          05 WS-BTU-DT-DD                   PIC 9(02) VALUE ZERO.       
          05 WS-BTU-DT-F2                   PIC X(01) VALUE '-'.        
          05 WS-BTU-DT-CCYY                 PIC 9(04) VALUE ZERO.       
      *                                                                         
       01 WS-TEMP-DT.                                                   
          05 WS-TEMP-DT-CCYY                PIC 9(04) VALUE ZERO.       
          05 WS-TEMP-DT-F1                  PIC X(01) VALUE '-'.        
          05 WS-TEMP-DT-MM                  PIC 9(02) VALUE ZERO.       
          05 WS-TEMP-DT-F2                  PIC X(01) VALUE '-'.        
          05 WS-TEMP-DT-DD                  PIC 9(02) VALUE ZERO.       
      *                                                                         
       01 WS-ERROR-DETAIL.                                              
          05 WS-ERROR-DESC                  PIC X(45) VALUE SPACES.     
          05 WS-DATE-ERROR                  PIC X(45) VALUE             
                                'INVALID DATE; FACTORS NOT POSTED'.     
          05 WS-BTU-ID-ERROR                PIC X(45) VALUE             
                              'INVALID BTU-ID; FACTORS NOT POSTED'.     
          05 WS-BTU-FCT-ERROR               PIC X(45) VALUE             
                      'BTU FACTOR NOT NUMERIC; FACTORS NOT POSTED'.     
          05 WS-SP-GRV-ERROR                PIC X(45) VALUE             
                      'SP GRAVITY NOT NUMERIC; FACTORS NOT POSTED'.     
          05 WS-GRAVITY-0-ERROR             PIC X(45) VALUE             
                                        'SPECIFIC GRAVITY IS ZERO'.     
          05 WS-BTU-ERROR                   PIC X(45) VALUE             
                                       'BTU FACTOR IS LESS THAN 1'.     
          05 WS-SPEC-GRV-ERROR              PIC X(45) VALUE             
                              'SPECIFIC GRAVITY IS GREATER THAN 1'.     
       01 WS-CURRENT-TIME.                                              
          05  WS-HH                         PIC 9(02) VALUE ZERO.       
          05  WS-MM                         PIC 9(02) VALUE ZERO.       
          05  WS-SS                         PIC 9(02) VALUE ZERO.       
          05  WS-TT                         PIC 9(02) VALUE ZERO.       
      *                                                                         
       01 WS-RUN-TIME.                                                  
          05  WS-RT-HH                      PIC X(02) VALUE SPACES.     
          05  FILLER                        PIC X(01) VALUE '.'.        
          05  WS-RT-MM                      PIC X(02) VALUE SPACES.     
          05  FILLER                        PIC X(01) VALUE '.'.        
          05  WS-RT-SS                      PIC X(02) VALUE SPACES.     
      *                                                                         
       01 WS-CURRENT-DATE.                                              
          05  WS-CY                         PIC 9(04) VALUE ZERO.       
          05  WS-CM                         PIC 9(02) VALUE ZERO.       
          05  WS-CD                         PIC 9(02) VALUE ZERO.       
      *                                                                         
       01 WS-RUN-DATE.                                                  
          05  WS-RD-MM                      PIC X(02) VALUE SPACES.     
          05  FILLER                        PIC X(01) VALUE '/'.        
          05  WS-RD-DD                      PIC X(02) VALUE SPACES.     
          05  FILLER                        PIC X(01) VALUE '/'.        
          05  WS-RD-YY                      PIC X(04) VALUE SPACES.     
      *                                                                         
       01 WS-REPORT-HEADER1.                                            
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 P-RPT-PROGRAM-NAME             PIC X(11) VALUE             
                                                     'PCSCA628-01'.     
          05 FILLER                         PIC X(35) VALUE SPACES.     
          05 P-RPT-HEADER1                  PIC X(31) VALUE             
                                 'SOUTH CAROLINA ELECTRIC AND GAS'.     
          05 FILLER                         PIC X(41) VALUE SPACES.     
          05 P-RPT-PAGE-HEADER              PIC X(04) VALUE 'PAGE'.     
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 P-RPT-PAGE-COUNT               PIC Z(02) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-REPORT-HEADER2.                                            
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 P-RPT-DATE-HDR                 PIC X(05) VALUE 'DATE:'.    
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-SYS-DATE1                PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(32) VALUE SPACES.     
          05 P-RPT-HEADER2                  PIC X(27) VALUE             
                                     'CIG BTU FACTOR ERROR REPORT'.     
          05 FILLER                         PIC X(34) VALUE SPACES.     
          05 P-RPT-RUN-DATE                 PIC X(09) VALUE             
                                                       'RUN DATE:'.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-RUN-DATE1                PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-REPORT-HEADER3.                                            
          05 FILLER                         PIC X(112) VALUE SPACES.    
          05 P-RPT-RUN-TIME                 PIC X(09) VALUE             
                                                        'RUN TIME:'.    
          05 FILLER                         PIC X(03) VALUE SPACES.     
          05 P-RPT-RUN-TIME1                PIC X(08) VALUE SPACES.     
          05 FILLER                         PIC X(01) VALUE SPACES.     
      *                                                                         
       01 WS-REPORT-HEADER4.                                            
          05 FILLER                         PIC X(133) VALUE SPACES.    
      *                                                                         
       01 WS-REPORT-HEADER5.                                            
          05 FILLER                         PIC X(01) VALUE SPACES.     
          05 P-RPT-BTU-ID-HDR               PIC X(06) VALUE 'BTU ID'.   
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 P-RPT-DATE-HDR                 PIC X(04) VALUE 'DATE'.     
          05 FILLER                         PIC X(05) VALUE SPACES.     
          05 P-RPT-BTU-FCTR-HDR             PIC X(10) VALUE             
                                                         'BTU FACTOR'.  
          05 FILLER                         PIC X(02) VALUE SPACES.     
          05 P-RPT-SPEC-GRAV-HDR            PIC X(16) VALUE             
                                                 'SPECIFIC GRAVITY'.    
          05 FILLER                         PIC X(16) VALUE SPACES.     
          05 P-RPT-ERROR-DESC-HDR           PIC X(17) VALUE             
                                                 'ERROR DESCRIPTION'.   
          05 FILLER                         PIC X(51) VALUE SPACES.     
      *                                                                         
       01 WS-REPORT-HEADER6.                                            
          05 FILLER                         PIC X(02) VALUE SPACES.     
          05 P-RPT-BTU-ID                   PIC X(03) VALUE SPACES.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 P-RPT-DATE                     PIC X(10) VALUE SPACES.     
          05 FILLER                         PIC X(04) VALUE SPACES.     
          05 P-RPT-BTU-FCTR                 PIC X(05) VALUE SPACES.     
          05 FILLER                         PIC X(10) VALUE SPACES.     
          05 P-RPT-SPEC-GRAV                PIC X(05) VALUE SPACES.     
          05 FILLER                         PIC X(08) VALUE SPACES.     
          05 P-RPT-ERROR-DESC               PIC X(45) VALUE SPACES.     
          05 FIILLER                        PIC X(36) VALUE SPACES.     
                                                                        
      *                                                                         
       01 WS-REPORT-HEADER7.                                            
          05 FILLER                         PIC X(60) VALUE SPACES.     
          05 P-RPT-END-OF-RPT               PIC X(21) VALUE             
                                             '*** END OF REPORT ***'.   
          05 FILLER                         PIC X(52) VALUE SPACES.     
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE                THRU  0100-EXIT.      
                                                                        
           PERFORM 1000-PROCESS-INPUT             THRU  1000-EXIT.      
                                                                        
           PERFORM 9000-TERMINATE                 THRU 9000-EXIT.       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ** 0100-INITIALIZE                                              **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                    TO WS-RT-HH.                   
           MOVE WS-MM                    TO WS-RT-MM.                   
           MOVE WS-SS                    TO WS-RT-SS.                   
           MOVE WS-RUN-TIME              TO P-RPT-RUN-TIME1.            
      *                                                                         
           ACCEPT WS-CURRENT-DATE  FROM DATE YYYYMMDD.                  
           MOVE WS-CY                    TO WS-RD-YY.                   
           MOVE WS-CM                    TO WS-RD-MM.                   
           MOVE WS-CD                    TO WS-RD-DD.                   
           MOVE WS-RUN-DATE              TO P-RPT-RUN-DATE1.            
           MOVE WS-RUN-DATE              TO P-RPT-SYS-DATE1.            
      *                                                                         
           OPEN INPUT  FCSPT80-FILE.                                    
           IF NOT FCSPT80-SUCCESSFUL                                    
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSCA628******************'         
               DISPLAY '**  0100-INITIALIZATION             **'         
               DISPLAY '**  ERROR OPENING FCSBW04 FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
           IF NOT FCSPT33-SUCCESSFUL                                    
               MOVE 12                   TO RETURN-CODE                 
               DISPLAY '**************************************'         
               DISPLAY '****PROGRAM PCSCA628******************'         
               DISPLAY '**  ERROR OPENING FCSPT33           **'         
               DISPLAY '**  FILE STATUS = ' WS-FCSPT33-STATUS           
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-INPUT                                           **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 7000-READ-FCSBW04              THRU 7000-EXIT.       
           PERFORM 2000-PROCESS-BTU-ID            THRU 2000-EXIT        
             UNTIL END-OF-REC.                                          
           PERFORM 2100-WRITE-FINAL-REC-COUNT     THRU 2100-EXIT.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-BTU-ID                                                    
      ******************************************************************        
      *                                                                         
       2000-PROCESS-BTU-ID.                                             
      *                                                                         
           IF IN-HDR-IST-CHAR NOT EQUAL ' ' OR                          
HEX01         X'09' AND IN-HDR-BTU NOT EQUAL 'BTU'                      
              MOVE '01'                   TO FE-COMPANY-NO              
              MOVE IN-BTU-DT              TO WS-BTU-DT                  
              MOVE WS-BTU-DT-CCYY         TO WS-TEMP-DT-CCYY            
              MOVE WS-BTU-DT-MM           TO WS-TEMP-DT-MM              
              MOVE WS-BTU-DT-DD           TO WS-TEMP-DT-DD              
              MOVE WS-TEMP-DT             TO FE-BTU-DT                  
              MOVE IN-INDUST-BTU-ID       TO FE-INDUST-BTU-ID           
              MOVE 0                      TO FE-BTU-FACTOR              
              MOVE 0                      TO FE-SPECIFIC-GRAVITY        
              MOVE 'Y'                    TO WS-VALID-FL                
      *                                                                         
               IF IN-BTU-FACTOR-N IS NUMERIC AND                        
                  IN-BTU-FACTOR-D IS NUMERIC                            
                  COMPUTE  FE-BTU-FACTOR    = IN-BTU-FACTOR-N +         
                                             (IN-BTU-FACTOR-D) / 1000.0 
      *                                                                         
                  IF FE-BTU-FACTOR < 1                                  
                     MOVE WS-BTU-ERROR   TO WS-ERROR-DESC               
                     PERFORM 2200-WRITE-PROCESS   THRU 2200-EXIT        
                  END-IF                                                
      *                                                                         
               ELSE                                                     
                   MOVE 'N'              TO WS-VALID-FL                 
                   MOVE WS-BTU-FCT-ERROR TO WS-ERROR-DESC               
                   PERFORM 2200-WRITE-PROCESS     THRU 2200-EXIT        
               END-IF                                                   
      *                                                                         
               IF IN-SPECIFIC-GRAVITY-N  IS NUMERIC AND                 
                  IN-SPECIFIC-GRAVITY-D  IS NUMERIC                     
                  COMPUTE FE-SPECIFIC-GRAVITY = IN-SPECIFIC-GRAVITY-N   
                                   + (IN-SPECIFIC-GRAVITY-D) / 1000.0   
      *                                                                         
                  IF FE-SPECIFIC-GRAVITY > 1                            
                     MOVE WS-SPEC-GRV-ERROR TO WS-ERROR-DESC            
                     PERFORM 2200-WRITE-PROCESS   THRU 2200-EXIT        
                  ELSE                                                  
      *                                                                         
                      IF FE-SPECIFIC-GRAVITY EQUAL 0                    
                         MOVE WS-GRAVITY-0-ERROR TO  WS-ERROR-DESC      
                         PERFORM 2200-WRITE-PROCESS THRU 2200-EXIT      
                      END-IF                                            
      *                                                                         
                  END-IF                                                
      *                                                                         
               ELSE                                                     
                   MOVE 'N'              TO WS-VALID-FL                 
                   MOVE WS-SP-GRV-ERROR  TO WS-ERROR-DESC               
                   PERFORM 2200-WRITE-PROCESS     THRU 2200-EXIT        
               END-IF                                                   
      *                                                                         
               IF WS-VALID-FL = 'Y'                                     
                  PERFORM 8400-INSERT-BTU-TABLE   THRU 8400-EXIT        
                  PERFORM 2500-CHECK-COMMIT       THRU 2500-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSBW04              THRU 7000-EXIT.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2100-WRITE-FINAL-REC-COUNT                                             
      ******************************************************************        
      *                                                                         
       2100-WRITE-FINAL-REC-COUNT.                                      
      *                                                                         
           COMPUTE WS-TOT-COUNT = WS-TOT-COUNT + WS-REC-COUNT           
           DISPLAY 'TOTAL RECORDS INSERTED/UPDATED  = ' WS-TOT-COUNT    
           MOVE WS-REPORT-HEADER7        TO PRT33-RECORD.               
      *                                                                         
           IF WS-LINE-COUNT >= 1                                        
              PERFORM 8100-WRITE-FCSPT33          THRU 8100-EXIT        
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-WRITE-PROCESS                                           **        
      ******************************************************************        
      *                                                                         
       2200-WRITE-PROCESS.                                              
      *                                                                         
           IF WS-FIRST EQUAL 'Y' OR WS-LINE-COUNT >= 55                 
      *                                                                         
              IF WS-LINE-COUNT >= 55                                    
                 MOVE WS-LINE-COUNT      TO WS-LINE-COUNT-REC           
                 MOVE ZERO               TO WS-LINE-COUNT               
              END-IF                                                    
      *                                                                         
              ADD 1                   TO WS-PAGE-NUM                    
              PERFORM 2300-WRITE-PROCESS-HEADER   THRU 2300-EXIT        
      *                                                                         
           END-IF.                                                      
      *                                                                         
           PERFORM 2400-WRITE-DETAIL-RECORD       THRU 2400-EXIT.       
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-WRITE-PROCESS-HEADER.                                             
      ******************************************************************        
      *                                                                         
       2300-WRITE-PROCESS-HEADER.                                       
      *                                                                         
           MOVE WS-PAGE-NUM              TO P-RPT-PAGE-COUNT            
           MOVE WS-REPORT-HEADER1        TO PRT33-RECORD.               
           PERFORM 8000-WRITE-FCSPT33             THRU 8000-EXIT.       
           MOVE WS-REPORT-HEADER2        TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33             THRU 8100-EXIT.       
           MOVE WS-REPORT-HEADER3        TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33             THRU 8100-EXIT.       
           MOVE WS-REPORT-HEADER4        TO PRT33-RECORD.               
           PERFORM 8200-WRITE-FCSPT33             THRU 8200-EXIT.       
           MOVE WS-REPORT-HEADER5        TO PRT33-RECORD.               
           PERFORM 8100-WRITE-FCSPT33             THRU 8100-EXIT.       
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-WRITE-DETAIL-RECORD.                                              
      ******************************************************************        
      *                                                                         
       2400-WRITE-DETAIL-RECORD.                                        
      *                                                                         
           MOVE FE-INDUST-BTU-ID         TO P-RPT-BTU-ID.               
           MOVE IN-BTU-DT                TO P-RPT-DATE.                 
           MOVE IN-BTU-FACTOR            TO P-RPT-BTU-FCTR.             
           MOVE IN-SPECIFIC-GRAVITY      TO P-RPT-SPEC-GRAV.            
           MOVE WS-ERROR-DESC            TO P-RPT-ERROR-DESC.           
           MOVE WS-REPORT-HEADER6        TO PRT33-RECORD.               
      *                                                                         
           IF WS-FIRST EQUAL 'Y' OR WS-LINE-COUNT-REC >= 55             
              MOVE ZERO                  TO WS-LINE-COUNT-REC           
              PERFORM 8300-WRITE-FCSPT33          THRU 8300-EXIT        
           ELSE                                                         
              PERFORM 8100-WRITE-FCSPT33          THRU 8100-EXIT        
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                      TO WS-FIRST.                   
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 2500-CHECK-COMMIT                                                      
      ******************************************************************        
      *                                                                         
       2500-CHECK-COMMIT.                                               
      *                                                                         
           COMPUTE WS-REC-COUNT = WS-REC-COUNT + 1.                     
      *                                                                         
           IF WS-REC-COUNT = 500                                        
              COMPUTE  WS-TOT-COUNT = WS-TOT-COUNT + WS-REC-COUNT       
              DISPLAY 'TOTAL RECORDS INSERTED/UPDATED  = ' WS-TOT-COUNT 
              MOVE ZERO                  TO WS-REC-COUNT                
              PERFORM 8600-PERFORM-COMMIT         THRU 8600-EXIT        
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-READ-FCSBW04                                                       
      ******************************************************************        
      *                                                                         
       7000-READ-FCSBW04.                                               
      *                                                                         
           READ FCSPT80-FILE                                            
                                                                        
           IF FCSPT80-SUCCESSFUL  OR END-OF-REC                         
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSCA628 ABORT *********'          
               DISPLAY '**ERROR IN READING FCSBW04 FILE ****'           
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS '  WS-FPT80-STATUS            
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8000-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 8100-WRITE-FCSPT33                                           **        
      ******************************************************************        
      *                                                                         
       8100-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD.                                          
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8200-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8200-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 3 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8300-WRITE-FCSPT33.                                          **        
      ******************************************************************        
      *                                                                         
       8300-WRITE-FCSPT33.                                              
      *                                                                         
           WRITE PRT33-RECORD AFTER ADVANCING 2 LINES.                  
           COMPUTE WS-LINE-COUNT = WS-LINE-COUNT + 1.                   
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-INSERT-BTU-TABLE.                                                  
      ******************************************************************        
      *                                                                         
       8400-INSERT-BTU-TABLE.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT  INTO  CSS_BTU_INDUST_FCT                         
                      (COMPANY_NO                                       
                      ,INDUST_BTU_ID                                    
                      ,BTU_DT                                           
                      ,BTU_FACTOR                                       
                      ,SPECIFIC_GRAVITY)                                
               VALUES(:FE-COMPANY-NO                                    
                     ,:FE-INDUST-BTU-ID                                 
                     ,IIF(TRY_CONVERT(DATE, :FE-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :FE-BTU-DT) <> 0) OR (LEN(
                                                             :FE-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:FE-BTU-DT), CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) )                                        
                     ,:FE-BTU-FACTOR                                    
                     ,:FE-SPECIFIC-GRAVITY)                             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT  INTO  CSS_BTU_INDUST_FCT                                 
MFA-TR*               (COMPANY_NO                                               
MFA-TR*               ,INDUST_BTU_ID                                            
MFA-TR*               ,BTU_DT                                                   
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,SPECIFIC_GRAVITY)                                        
MFA-TR*        VALUES(:FE-COMPANY-NO                                            
MFA-TR*              ,:FE-INDUST-BTU-ID                                         
MFA-TR*              ,:FE-BTU-DT                                                
MFA-TR*              ,:FE-BTU-FACTOR                                            
MFA-TR*              ,:FE-SPECIFIC-GRAVITY)                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN -803                                                
                   PERFORM 8500-UPDATE-BTU-INDUST-FCT                   
                                                  THRU 8500-EXIT        
               WHEN -530                                                
                   MOVE WS-BTU-ID-ERROR  TO WS-ERROR-DESC               
                   PERFORM 2200-WRITE-PROCESS     THRU 2200-EXIT        
               WHEN -181                                                
                   MOVE WS-DATE-ERROR    TO WS-ERROR-DESC               
                   PERFORM 2200-WRITE-PROCESS     THRU 2200-EXIT        
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '******** PCSCA628 ABORT *****'              
                   DISPLAY '**8400-INSERT-BTU-TABLE   ***'              
                   DISPLAY '**COMPANY N0  = ' FE-COMPANY-NO             
                   DISPLAY '**INDUS BTU ID= ' FE-INDUST-BTU-ID          
                   DISPLAY '**BTU DT      = ' FE-BTU-DT                 
                   DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                   DISPLAY '**PROCESSING TERMINATED    **'              
                   PERFORM 9900-ABEND             THRU 9900-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 8500-UPDATE-BTU-INDUST-FCT                                   **        
      ******************************************************************        
      *                                                                         
       8500-UPDATE-BTU-INDUST-FCT.                                      
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_BTU_INDUST_FCT                                  
                SET BTU_FACTOR       = :FE-BTU-FACTOR                   
                   ,SPECIFIC_GRAVITY = :FE-SPECIFIC-GRAVITY             
              WHERE COMPANY_NO       = :FE-COMPANY-NO                   
                AND INDUST_BTU_ID    = :FE-INDUST-BTU-ID                
                AND BTU_DT           = IIF(TRY_CONVERT(DATE, :FE-BTU-DT
              ) IS NULL OR (PATINDEX('%.%', :FE-BTU-DT) <> 0) OR (LEN(
                                                             :FE-BTU-DT
              ) <> 10), CIS.CHAR2DATE(:FE-BTU-DT), CONVERT(DATE, 
                                                             :FE-BTU-DT
              ) )                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_BTU_INDUST_FCT                                          
MFA-TR*         SET BTU_FACTOR       = :FE-BTU-FACTOR                           
MFA-TR*            ,SPECIFIC_GRAVITY = :FE-SPECIFIC-GRAVITY                     
MFA-TR*       WHERE COMPANY_NO       = :FE-COMPANY-NO                           
MFA-TR*         AND INDUST_BTU_ID    = :FE-INDUST-BTU-ID                        
MFA-TR*         AND BTU_DT           = :FE-BTU-DT                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA628 ABORT *****'                   
              DISPLAY '**8500-UPDATE-BTU-INDUST-FCT **'                 
              DISPLAY '**COMPANY N0  = ' FE-COMPANY-NO                  
              DISPLAY '**INDUS BTU ID= ' FE-INDUST-BTU-ID               
              DISPLAY '**BTU DT      = ' FE-BTU-DT                      
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                  THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8600-PERFORM-COMMIT                                         *           
      ****************************************************************          
      *                                                                         
       8600-PERFORM-COMMIT.                                             
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00047                                                  
           END-EXEC.                                                            
                                                    
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9000-CLOSE-FILES.                                            *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT80-FILE.                                          
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
