       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA627.                                        
       AUTHOR.         SREENI GUNTUPALLI                                
       INSTALLATION.                                                    
       DATE-WRITTEN.   AUG 2005.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                     DB2                        *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 08/25/05   SG18894       DEVELOPMENT OF NEW PROGRAM         **         
      **                                                             **         
      ** 04/20/06   SP94986       PERFORMANCE TUNING FOR DRIVER      **         
      **                          CURSOR (METER_CSR).                **         
      **                                                             **         
C33884** 09/11/06   NC94746       INCLUDED ITRON MOBILE AMR SOURCE BY**         
C33884**                          ADDING CSS_MTR_RD_SOURCE TABLE WITH**         
C33884**                          SEND_READ_REQ_FL = 'Y'             **         
C32098** 08/02/07   RC41079       ADD METER FORM CODE TO THE OUTPUT  **         
C33884**                          FILE FIOCA627.                     **         
T33887** 11/08/07   PG36856       CHANGE MA-DEVICE-NO TO USE LAST 10 **         
T33887**                          DIGITS AND REMOVE HARDCODE FROM    **         
T33887**                          SQL 7300-.                         **         
C36070** 06/05/08   NC94746       PERFORMANCE CHANGES                **         
C36070**                                                             **         
C33743** 05/09/08   SC41135       POINT ID PROJECT - REPLACE SNE_POINT*         
C33743**                          TABLE WITH CSS_PIM_POINT           **         
      **                                                             **         
ACT061** 25 MAR 2011 RF10596      ADD CUSTOMER NAME AND SUBDIVISION  **         
ACT061** APPL003082               DESCRIPTION - ADD QUERYNO          **         
      **                                                             **         
P00462** 26 JUN 2011 DM94438    1.ADD MTR READ SRC CODE TO OUTPUTFILE**         
P00462**                        2.REMOVE REFERENCES TO BW01          **         
P00462**                        3.INCLUDE CPDCA099 INSTEAD OF CPD00099*         
      **                                                             **         
A03548** 05 AUG 2011 DM94438    INCLUDE ALL METER READ SOURCES IN RRI           
A03548**                        REPORT BY REMOVING SEND_READ_REQ_FL=Y           
A03548**                        IN METER_CSR                                    
A#5470** 11 NOV 2016 SS95855    ACT054 LAT/LONG FROM PREMISE         **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA627 NARRATIVE                        
      *                                                                         
           THIS PROGRAM IS TO FILTER SPECIFIC ROUTES/LOCAL OFFICES FROM 
           THE ITRON INTEGRATOR TOHOST FILE TO POST THE READINGS ON     
           CIS. THIS PROGRAM CAN ALSO BE USED TO GENERATE CUSTOMER/METER
           LISTING BASED ON THE JOB-PARM SELECTION CRITERIA             
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      * SELECT STMT FOR CA627 FILE  *                                           
       COPY CSSCA627.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA627.                                                           
       01  FIOCA627-REC                 PIC X(500).                     
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA627'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA627 STARTS HERE'.            
      *                                                                         
       COPY FIOCA627.                                                           
      ***************************************************************           
      * FCA00-KEY          *                                                    
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      * IO AREA FOR PARM INPUT FILE 'A' *                                       
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *    DB2 TABLE DCLGENS USING IN THIS PROGRAM                              
      *****************************************************************         
      * CSS_ACCOUNT (AT)                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      * CSS_MTRD_ENVRNMT (MN)                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      * CSS_UTIL_ENVRNMT (UT)                                                   
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      * CSS_ELEC_CL_SPEC (U0)                                                   
           EXEC SQL                                                             
              INCLUDE TBELCLSP                                                  
           END-EXEC.                                                            
      * CSS_JOB_PARM (G6)                                                       
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      * CSS_METER_ATTCHMTS (MA)                                                 
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      * CSS_NAME (DQ)                                                           
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      * CSS_NAME_ACCT_XREF                                                      
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_CUST_ACCT_XREF                                                      
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_ADDR_FREE_FORM                                                      
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_ADDR_FORMATTED                                                      
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_ZIP_CODE                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCT_MISC                                                           
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_ACCT_BILL_NMES                                                      
           EXEC SQL                                                             
               INCLUDE TBATBLNM                                                 
           END-EXEC.                                                            
                                                                        
C33743*CSS_PIM_POINT                                                            
C33743     EXEC SQL                                                             
C33743         INCLUDE TBPIMPNT                                                 
C33743     END-EXEC.                                                            
      *                                                                         
      *CSS_MTR_RD_INST                                                          
           EXEC SQL                                                             
               INCLUDE TBMTRINS                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_METER_LOC                                                            
           EXEC SQL                                                             
               INCLUDE TBMTRLOC                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_GAS_METER                                                            
           EXEC SQL                                                             
               INCLUDE TBGASMTR                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_ELEC_METER                                                           
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *CSS_MTR_CAP                                                              
           EXEC SQL                                                             
               INCLUDE TBMTRCAP                                                 
           END-EXEC.                                                            
      *                                                                         
      *CSS_PREMISE                                                              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
ACT061*  CSS_SUBDIVISION  -  B0                                      *          
      ****************************************************************          
      *                                                                         
ACT061     EXEC SQL                                                             
ACT061         INCLUDE TBSUBDVN                                                 
ACT061     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE            PIC X              VALUE SPACE.
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                         PIC 9.                         
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-YES                    PIC X(01)  VALUE 'Y'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
           05  WS-U                      PIC X(01)  VALUE 'U'.          
           05  WS-I                      PIC X(01)  VALUE 'I'.          
           05  WS-IT                     PIC X(02)  VALUE 'IT'.         
           05  WS-NO                     PIC X(01)  VALUE 'N'.          
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA627'.   
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA627'.   
           05  RS-RETURN-CODE            PIC S9(09) VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP       PIC S9(09) VALUE +000 COMP.    
           05  WS-END-REC                PIC X(01)  VALUE 'N'.          
           05  WS-FOUND                  PIC X(01)  VALUE 'N'.          
           05  WS-TAB-ROW-FOUND          PIC X(01)  VALUE 'N'.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA627-STATUS          PIC X(02).                     
               88  FCA627-SUCCESSFUL                VALUE '00'.         
           05  WS-END-OF-READS           PIC X(01)  VALUE 'N'.          
               88 END-OF-READS                      VALUE 'Y'.          
           05  WS-SELECT-ROUTE-FL        PIC X(01)  VALUE 'N'.          
               88 SELECT-ROUTE                      VALUE 'Y'.          
               88 DO-NOT-SELECT-ROUTE               VALUE 'N'.          
           05  WS-END-OF-CURSOR          PIC X(01)  VALUE 'N'.          
               88 END-OF-CURSOR                     VALUE 'Y'.          
C36070     05  WS-ACC-CHNG-SW            PIC X(01)  VALUE 'N'.          
C36070         88 NOT-SAME-ACCOUNT                  VALUE 'N'.          
C36070         88 SAME-ACCOUNT                      VALUE 'Y'.          
C36070     05  WS-CPD99-MATCH-SW         PIC X(01)  VALUE 'A'.          
C36070         88 CPD99-NOT-EXECUTED                VALUE 'A'.          
C36070         88 CPD99-EXECUTED                    VALUE 'B', 'C'.     
C36070         88 LATEST-ACCOUNT                    VALUE 'B'.          
C36070         88 NOT-LATEST-ACCOUNT                VALUE 'C'.          
      *                                                                         
      * RUN TYPE VALUES: 'A' - AMR; ' ' - ALL METERS, 'N' - NON-AMR             
       01  WS-RUN-TYPE-PARM.                                            
           05  WS-RUN-TYPE               PIC X(09).                     
           05  WS-PGM-RUN-TYPE           PIC X(01).                     
           05  WS-FILLER                 PIC X(70).                     
      *                                                                         
       01  WS-WORK-AREA.                                                
ACT061     05  WS-SAVE-PR-CITY-STATE-ZIP PIC X(41)  VALUE SPACES.       
ACT061     05  WS-SAVE-PR-STREET         PIC X(55)  VALUE SPACES.       
ACT061     05  WS-SUBDIVISION            PIC X(26)  VALUE SPACES.       
ACT061     05  WS-CUST-NAME              PIC X(96)  VALUE SPACES.       
           05  WS-COMPANY-NO             PIC X(02)  VALUE '01'.         
           05  WS-PARM-ROUTE             PIC 9(04).                     
           05  WS-LO-ROUTE               PIC S9(4)  COMP.               
           05  WS-HI-ROUTE               PIC S9(4)  COMP.               
           05  WS-LO-CYCLE               PIC X(02).                     
           05  WS-HI-CYCLE               PIC X(02).                     
           05  WS-LO-RRI                 PIC X(01).                     
           05  WS-RUN-TYPE-FL            PIC X(01).                     
           05  WS-EXCLUDE-RRI            PIC X(01).                     
           05  WS-ACCOUNT-NO             PIC S9(13)V COMP-3 VALUE ZERO. 
C36070     05  WS-PRIOR-ACCOUNT-NO       PIC S9(13)V COMP-3 VALUE ZERO. 
           05  WS-NO-MORE-ROWS           PIC X(01)          VALUE 'N'.  
           05  WS-FCSCA627-REC-CNTR      PIC S9(09) COMP VALUE ZERO.    
           05  WS-SUB                    PIC S9(04) COMP VALUE ZEROES.  
           05  WS-TAB-SUB                PIC S9(3) COMP-3 VALUE 0.      
           05  WS-TAB-SUB-MAX            PIC S9(3) COMP-3 VALUE 0.      
           05  WS-LATITUDE               PIC S9(4)V9(6).                
           05  WS-CA627-LATITUDE         PIC -99.9(6).                  
           05  WS-CA627-LATITUDE-RED REDEFINES WS-CA627-LATITUDE        
                                         PIC X(10).                     
           05  WS-LONGITUDE              PIC S9(4)V9(6).                
           05  WS-CA627-LONGITUDE        PIC -99.9(6).                  
           05  WS-CA627-LONGITUDE-RED REDEFINES WS-CA627-LONGITUDE      
                                         PIC X(10).                     
T33887 01  WS-DEVICE-NO-12.                                             
T33887     05 WS-DEVICE-NO-02            PIC X(02).                     
T33887     05 WS-DEVICE-NO-10            PIC X(10).                     
      *                                                                         
C36070 01  WS-JOB-PARM-DTL-OPTN.                                        
C36070     05  WS-CO-TXT-OPTN             PIC X(03).                    
C36070     05  WS-CO-PARM-OPTN           PIC X(02).                     
C36070     05  FILLER                    PIC X(01).                     
C36070     05  WS-LOC-OFF-TXT-OPTN       PIC X(08).                     
C36070     05  WS-LOC-OFF-PARM-OPTN      PIC X(03).                     
C36070     05  FILLER                    PIC X(01).                     
C36070     05  WS-FROM-CYC-TXT           PIC X(11).                     
C36070     05  WS-FROM-CYC-PARM          PIC X(02).                     
C36070     05  FILLER                    PIC X(01).                     
C36070     05  WS-TO-CYC-TXT             PIC X(09).                     
C36070     05  WS-TO-CYC-PARM            PIC X(02).                     
C36070     05  FILLER                    PIC X(01).                     
      *                                                                         
       01  WS-JOB-PARM-DTL.                                             
           05  WS-CO-TXT                 PIC X(03).                     
           05  WS-CO-PARM                PIC X(02).                     
           05  FILLER                    PIC X(01).                     
           05  WS-LOC-OFF-TXT            PIC X(08).                     
           05  WS-LOC-OFF-PARM           PIC X(03).                     
           05  FILLER                    PIC X(01).                     
           05  WS-READ-CYC-TXT           PIC X(06).                     
           05  WS-READ-CYC-PARM          PIC X(02).                     
           05  FILLER                    PIC X(01).                     
           05  WS-ROUTE-TXT              PIC X(06).                     
           05  WS-ROUTE-PARM             PIC X(04).                     
           05  FILLER                    PIC X(01).                     
      *                                                                         
       01  WS-ROUTE-DTL-TABLE.                                          
           05  WS-ROUTE-DTL-ENTRIES OCCURS 100 TIMES.                   
               10 WS-TBL-CO              PIC X(02).                     
               10 WS-TBL-LOC-OFF         PIC X(03).                     
               10 WS-TBL-CYCLE           PIC X(02).                     
               10 WS-TBL-ROUTE           PIC X(04).                     
      *                                                                         
      * ABEND SWITCH         *                                                  
       COPY CWS09900.                                                           
      * WARNING DATA         *                                                  
       COPY CWS00303.                                                           
      * WS ABEND WORK AREA   *                                                  
       COPY CWS00010.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      * WOKING STORAGE FOR CPD00099                                             
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR PCSCA627 ENDS HERE  '.            
      *                                                                         
      ******************* BEGIN CURSOR DECLARATION ********************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE PARM_CUR CURSOR FOR                                
             SELECT PARM_DATA                                           
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE COMPANY_NO   = '01'                                 
                AND PROGRAM_NAME = :G6-PROGRAM-NAME                     
                AND CMND_CODE    = :G6-CMND-CODE                        
                AND STATUS       = :WS-A                                
                AND PARM_DATA LIKE 'CO=%'                               
             ORDER BY SEQ_NO                                            
C33884        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PARM_CUR CURSOR FOR                                        
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE COMPANY_NO   = '01'                                         
MFA-TR*         AND PROGRAM_NAME = :G6-PROGRAM-NAME                             
MFA-TR*         AND CMND_CODE    = :G6-CMND-CODE                                
MFA-TR*         AND STATUS       = :WS-A                                        
MFA-TR*         AND PARM_DATA LIKE 'CO=%'                                       
MFA-TR*      ORDER BY SEQ_NO                                                    
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **************************************                                    
      **  CURSOR DECLARATION -- METER_CSR **                                    
      **************************************                                    
           EXEC SQL                                                     
            DECLARE METER_CSR CURSOR FOR                                
             SELECT AT.ACCOUNT_NO                                       
                   ,AT.COMPANY_NO                                       
C36070             ,AT.PREMISE_NO                                       
                   ,MN.METER_NO                                         
                   ,MN.CODE_UTIL_TYPE                                   
                   ,MN.REMOTE_READ_IND                                  
                   ,MN.PROGRAM_ID                                       
                   ,MN.DIGTL_MTR_TYPE                                   
                   ,MN.METER_PRESSURE                                   
                   ,MN.CODE_METER_LOC                                   
                   ,MN.CODE_MTR_RD_INST1                                
                   ,MN.REGISTER_RD_SEQ                                  
                   ,MN.GIS_POINT_ID                                     
                   ,MN.REG_ID_NO                                        
                   ,UT.READ_ROUTE                                       
                   ,UT.READ_CYCLE                                       
P00462             ,MN.MTR_READ_SOURCE_CD                               
A#5470             ,PR.PREM_REF_LATITUDE                                
A#5470             ,PR.PREM_REF_LONGITUDE                               
               FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
                   ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                   
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
                   ,CSS_MTR_RD_SOURCE  X7 WITH(READUNCOMMITTED)                 
A#5470             ,CSS_PREMISE PR WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO         = MN.ACCOUNT_NO               
                AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO               
                AND UT.IC_NO              = MN.IC_NO                    
                AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE           
C36070          AND MN.CODE_UTIL_TYPE     IN ( 'E' ,'G')                
C36070          AND AT.BILL_CYCLE    BETWEEN :WS-LO-CYCLE               
C36070                               AND :WS-HI-CYCLE                   
                AND AT.LOCAL_OFFICE       = :AT-LOCAL-OFFICE            
                AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD       
T33185          AND MN.CODE_METER_STATUS  <> 'K'                        
C36070          AND (MN.REMOTE_READ_IND   <>  :WS-EXCLUDE-RRI           
C36070               OR :WS-EXCLUDE-RRI = ' ' )                         
C36070          AND (MN.REMOTE_READ_IND =  :WS-LO-RRI                   
C36070               OR :WS-LO-RRI = ' ' )                              
A#5470          AND AT.PREMISE_NO         = PR.PREMISE_NO               
               FOR READ ONLY                                    
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE METER_CSR CURSOR FOR                                        
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_UTIL_TYPE                                           
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.METER_PRESSURE                                           
MFA-TR*            ,MN.CODE_METER_LOC                                           
MFA-TR*            ,MN.CODE_MTR_RD_INST1                                        
MFA-TR*            ,MN.REGISTER_RD_SEQ                                          
MFA-TR*            ,MN.GIS_POINT_ID                                             
MFA-TR*            ,MN.REG_ID_NO                                                
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,UT.READ_CYCLE                                               
MFA-TR*            ,MN.MTR_READ_SOURCE_CD                                       
MFA-TR*            ,PR.PREM_REF_LATITUDE                                        
MFA-TR*            ,PR.PREM_REF_LONGITUDE                                       
MFA-TR*        FROM CSS_ACCOUNT      AT                                         
MFA-TR*            ,CSS_MTRD_ENVRNMT MN                                         
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_MTR_RD_SOURCE  X7                                       
MFA-TR*            ,CSS_PREMISE PR                                              
MFA-TR*       WHERE AT.ACCOUNT_NO         = MN.ACCOUNT_NO                       
MFA-TR*         AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO                       
MFA-TR*         AND UT.IC_NO              = MN.IC_NO                            
MFA-TR*         AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_UTIL_TYPE     IN ( 'E' ,'G')                        
MFA-TR*         AND AT.BILL_CYCLE    BETWEEN :WS-LO-CYCLE                       
MFA-TR*                              AND :WS-HI-CYCLE                           
MFA-TR*         AND AT.LOCAL_OFFICE       = :AT-LOCAL-OFFICE                    
MFA-TR*         AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD               
MFA-TR*         AND MN.CODE_METER_STATUS  <> 'K'                                
MFA-TR*         AND (MN.REMOTE_READ_IND   <>  :WS-EXCLUDE-RRI                   
MFA-TR*              OR :WS-EXCLUDE-RRI = ' ' )                                 
MFA-TR*         AND (MN.REMOTE_READ_IND =  :WS-LO-RRI                           
MFA-TR*              OR :WS-LO-RRI = ' ' )                                      
MFA-TR*         AND AT.PREMISE_NO         = PR.PREMISE_NO                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************* END CURSOR DECLARATION **********************         
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   0000-MAINLINE                                                *        
      *        CONTROLS THE MAIN PATH OF PROGRAM                       *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 1100-PROCESS-CURSOR THRU 1100-EXIT                   
      *                                                                         
           PERFORM 8180-PRINT-COUNTERS        THRU 8180-EXIT            
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   0100-INITIALIZATION                                          *        
      *        COMMON INITIALIZATION ROUTINE                           *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE 'N'                        TO WS-END-REC.               
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               DISPLAY 'COMMON DATE ==> ' WS-FCA00-COMMON-DATE          
               MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE             
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCA627-FILE                                    
      *                                                                         
           IF  FCA627-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** 0100-ERROR ON FCSCA627 OPEN. STATUS IS '     
                                  WS-FCA627-STATUS                      
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
           INITIALIZE WS-ROUTE-DTL-TABLE.                               
      *                                                                         
           MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME.          
           MOVE WS-PARM                    TO G6-CMND-CODE.             
           PERFORM 7100-OPEN-PARM-CUR  THRU 7100-EXIT.                  
      *                                                                         
           MOVE +1 TO WS-TAB-SUB.                                       
           PERFORM 7110-FETCH-PARM-CUR THRU 7110-EXIT.                  
      *                                                                         
           PERFORM 0200-LOAD-ROUTE-DTL-TABLE THRU 0200-EXIT             
                   UNTIL SQLCODE = NOT-FOUND.                           
           SUBTRACT +1 FROM WS-TAB-SUB GIVING WS-TAB-SUB-MAX.           
      *                                                                         
           PERFORM 7120-CLOSE-PARM-CUR THRU 7120-EXIT.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MODULE TO LOAD JOB PARM SELECTION CRITERIA TO WS TABLE         *        
      ******************************************************************        
       0200-LOAD-ROUTE-DTL-TABLE.                                       
      *                                                                         
           MOVE G6-PARM-DATA               TO WS-JOB-PARM-DTL.          
      *                                                                         
           MOVE WS-CO-PARM                 TO WS-TBL-CO (WS-TAB-SUB).   
           MOVE WS-LOC-OFF-PARM            TO WS-TBL-LOC-OFF(WS-TAB-SUB)
           MOVE WS-READ-CYC-PARM           TO WS-TBL-CYCLE(WS-TAB-SUB)  
           MOVE WS-ROUTE-PARM              TO WS-TBL-ROUTE (WS-TAB-SUB).
      *                                                                         
           PERFORM 7110-FETCH-PARM-CUR THRU 7110-EXIT                   
           ADD +1 TO WS-TAB-SUB.                                        
      *                                                                         
           IF  WS-TAB-SUB > +100                                        
               MOVE 12 TO WS-ACTIVE-RETURN-CODE                         
               DISPLAY '0200-LOAD-ROUTE-DTL-TABLE'                      
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'WS-TAB-SUB = ' WS-TAB-SUB                       
               DISPLAY 'ENTRIES EXCEED TABLE SIZE'                      
               PERFORM 9900-ABEND  THRU 9900-EXIT                       
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MODULE TO GET RUN TYPE FOR CURSOR PROCESSING                   *        
      ******************************************************************        
       0300-GET-RUN-TYPE.                                               
      *                                                                         
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE WS-PGRMNAME                TO WS-PROGRAM.               
           MOVE WS-OPTN                    TO WS-COMMAND.               
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           MOVE ' '                        TO WS-RUN-TYPE-FL            
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:9) =                    
                     'RUN TYPE=' AND INPUT-ACTIVE)                      
                  OR  END-OF-SYSIPT.                                    
                                                                        
           IF  END-OF-SYSIPT                                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-RUN-TYPE-PARM          
               MOVE WS-PGM-RUN-TYPE        TO WS-RUN-TYPE-FL            
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  MAIN MODULE TO EXTRACT CUSTOMER DATA FROM DB2                 *        
      ******************************************************************        
       1100-PROCESS-CURSOR.                                             
      *                                                                         
           MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME.          
           MOVE WS-OPTN                    TO G6-CMND-CODE.             
           PERFORM 7100-OPEN-PARM-CUR  THRU 7100-EXIT.                  
      *                                                                         
           PERFORM 7110-FETCH-PARM-CUR THRU 7110-EXIT.                  
      *                                                                         
C36070     PERFORM UNTIL WS-ACTIVE-RETURN-CODE  = NOT-FOUND             
C36070         MOVE G6-PARM-DATA           TO WS-JOB-PARM-DTL-OPTN      
C36070         MOVE WS-CO-PARM-OPTN        TO AT-COMPANY-NO             
C36070         MOVE WS-LOC-OFF-PARM-OPTN   TO AT-LOCAL-OFFICE           
C36070*                                                                         
C36070         IF  WS-FROM-CYC-PARM   > SPACES OR                       
C36070             WS-TO-CYC-PARM   > SPACES                            
C36070             IF  WS-TO-CYC-PARM   <= SPACES                       
C36070                 MOVE WS-FROM-CYC-PARM TO WS-TO-CYC-PARM          
C36070             END-IF                                               
C36070             IF  WS-FROM-CYC-PARM  <= SPACES                      
C36070                 MOVE WS-TO-CYC-PARM TO WS-FROM-CYC-PARM          
C36070             END-IF                                               
C36070             MOVE WS-FROM-CYC-PARM   TO WS-LO-CYCLE               
C36070             MOVE WS-TO-CYC-PARM     TO WS-HI-CYCLE               
C36070         ELSE                                                     
C36070             MOVE '  '               TO WS-LO-CYCLE               
C36070             MOVE '99'               TO WS-HI-CYCLE               
C36070         END-IF                                                   
      *                                                                         
               MOVE SPACES                 TO WS-EXCLUDE-RRI            
               IF  WS-RUN-TYPE-FL  EQUAL SPACES OR LOW-VALUES           
                   MOVE SPACES             TO WS-LO-RRI                 
               ELSE                                                     
                   IF  WS-RUN-TYPE-FL EQUAL 'N'                         
                       MOVE WS-A           TO WS-EXCLUDE-RRI            
                       MOVE SPACES         TO WS-LO-RRI                 
                   ELSE                                                 
                       MOVE WS-RUN-TYPE-FL TO WS-LO-RRI                 
                       MOVE SPACES         TO WS-EXCLUDE-RRI            
                   END-IF                                               
               END-IF                                                   
      *                                                                         
C36070         DISPLAY '*** PROCESSING FOR LOC OFF ' AT-LOCAL-OFFICE    
C36070                    ' FROM CYCLE = ' WS-LO-CYCLE                  
C36070                    ' TO CYCLE = ' WS-HI-CYCLE                    
C36070                    ' & RUN TYPE = ' WS-RUN-TYPE-FL               
      *                                                                         
               MOVE WS-N                   TO WS-END-OF-CURSOR          
C36070         MOVE ZEROS                  TO WS-PRIOR-ACCOUNT-NO       
               PERFORM 7200-OPEN-METER-CURSOR THRU 7200-EXIT            
               PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT           
               PERFORM 1150-PROCESS-METER-CSR THRU 1150-EXIT            
                                       UNTIL END-OF-CURSOR              
               PERFORM 7220-CLOSE-METER-CURSOR THRU 7220-EXIT           
               PERFORM 7110-FETCH-PARM-CUR THRU 7110-EXIT               
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7120-CLOSE-PARM-CUR THRU 7120-EXIT.                  
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  VERIFY THE ACCOUNT IS MOST RECENT AND PROCESS                 *        
      ******************************************************************        
       1150-PROCESS-METER-CSR.                                          
      *                                                                         
C36070     IF WS-PRIOR-ACCOUNT-NO = AT-ACCOUNT-NO                       
C36070        SET SAME-ACCOUNT             TO TRUE                      
C36070     ELSE                                                         
C36070        SET NOT-SAME-ACCOUNT         TO TRUE                      
C36070        SET CPD99-NOT-EXECUTED       TO TRUE                      
C36070        MOVE AT-ACCOUNT-NO           TO WS-PRIOR-ACCOUNT-NO       
C36070     END-IF                                                       
C36070*                                                                         
C36070     MOVE AT-PREMISE-NO              TO WS-CPD99-PREMISE-NO       
C36070                                        PR-PREMISE-NO             
C36070     IF CPD99-NOT-EXECUTED                                        
C36070        PERFORM 6990-FETCH-CUR-ACCOUNT  THRU  6990-EXIT           
C36070        IF WS-CPD99-ACCOUNT-NO EQUAL AT-ACCOUNT-NO                
C36070           SET LATEST-ACCOUNT        TO TRUE                      
C36070*          PROCESS CPD00074 - TO GET THE PREMISE ADDRESS DETAILS          
C36070           MOVE SPACES              TO PR-SPCL-READ-INSTR-TEXT    
C36070                                       PR-SPCL-INSTRUCTIONS-TEXT  
C36070           PERFORM 7360-SELECT-PREMISE    THRU 7360-EXIT          
C36070           INSPECT PR-SPCL-READ-INSTR-TEXT                        
C36070                               REPLACING ALL ',' BY SPACES        
C36070           INSPECT PR-SPCL-INSTRUCTIONS-TEXT                      
C36070                               REPLACING ALL ',' BY SPACES        
C36070*                                                                         
C36070           MOVE ZERO          TO  AT-ADDRESS-ID                   
C36070           MOVE PR-ADDRESS-ID TO HT-ADDRESS-ID                    
ACT061           MOVE SPACES        TO WS-SAVE-PR-CITY-STATE-ZIP        
ACT061                                 WS-SAVE-PR-STREET                
C36070           PERFORM 4025-DETERMINE-ADDRESS THRU 4025-EXIT          
      *                                                                         
C36070           INSPECT WS-PR-STREET                                   
C36070                   REPLACING ALL ',' BY SPACES                    
C36070           INSPECT WS-PR-ADDR-CITY-STATE-ZIP                      
C36070                   REPLACING ALL ',' BY SPACES                    
ACT061           MOVE WS-PR-STREET TO WS-SAVE-PR-STREET                 
ACT061           MOVE WS-PR-ADDR-CITY-STATE-ZIP                         
ACT061                             TO WS-SAVE-PR-CITY-STATE-ZIP         
      *                                                                         
C36070        ELSE                                                      
C36070           SET NOT-LATEST-ACCOUNT    TO TRUE                      
C36070        END-IF                                                    
C36070     END-IF.                                                      
C36070*                                                                         
C36070     IF NOT-LATEST-ACCOUNT                                        
C36070        PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT            
C36070        GO TO 1150-EXIT                                           
C36070     END-IF.                                                      
C36070*                                                                         
           MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO             
                                              MN-ACCOUNT-NO.            
      *                                                                         
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT            
           PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT.              
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  POPULATE SELECTED ACCOUNT DATA TO OUTPUT FILE                 *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           INITIALIZE FIOCA627.                                         
           MOVE SPACES TO FIOCA627.                                     
           MOVE ','    TO E-FCA627-FILLER-1 E-FCA627-FILLER-2           
                          E-FCA627-FILLER-3 E-FCA627-FILLER-4           
                          E-FCA627-FILLER-5 E-FCA627-FILLER-6           
                          E-FCA627-FILLER-7 E-FCA627-FILLER-8           
                          E-FCA627-FILLER-9 E-FCA627-FILLER-10          
                          E-FCA627-FILLER-11 E-FCA627-FILLER-12         
                          E-FCA627-FILLER-13 E-FCA627-FILLER-14         
                          E-FCA627-FILLER-15 E-FCA627-FILLER-16         
                          E-FCA627-FILLER-17 E-FCA627-FILLER-18         
                          E-FCA627-FILLER-19 E-FCA627-FILLER-20         
                          E-FCA627-FILLER-21 E-FCA627-FILLER-22         
                          E-FCA627-FILLER-23 E-FCA627-FILLER-24         
                          E-FCA627-FILLER-25 E-FCA627-FILLER-26         
                          E-FCA627-FILLER-27 E-FCA627-FILLER-28         
                          E-FCA627-FILLER-29 E-FCA627-FILLER-30         
ACT061                    E-FCA627-FILLER-31 E-FCA627-FILLER-32.        
      *                                                                         
ACT061     MOVE SPACES                  TO WS-CUST-NAME.                
ACT061     SET WS-NAME-ONLY TO TRUE.                                    
ACT061     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
ACT061     MOVE 'N' TO WS-NAME-ONLY-SW.                                 
ACT061     INSPECT WS-CUSTOMER-NAME  REPLACING ALL ',' BY ' '.          
ACT061     MOVE WS-CUSTOMER-NAME        TO WS-CUST-NAME.                
      *                                                                         
ACT061     MOVE SPACES                  TO WS-SUBDIVISION.              
ACT061     MOVE AT-COMPANY-NO           TO B0-COMPANY-NO.               
ACT061     MOVE PR-SUBDIVISION-ID       TO B0-SUBDIVISION-ID.           
ACT061     PERFORM 7361-SELECT-SUBDIVISION THRU 7361-EXIT.              
ACT061     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT061        MOVE B0-SUBDIVISION-DESC TO WS-SUBDIVISION                
ACT061        INSPECT WS-SUBDIVISION REPLACING ALL ',' BY ' '           
ACT061     ELSE                                                         
ACT061        MOVE 'NOT FOUND' TO WS-SUBDIVISION                        
ACT061     END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO              TO MA-COMPANY-NO             
C36070                                        MC-COMPANY-NO             
                                              GM-COMPANY-NO             
                                              EM-COMPANY-NO             
                                              E-FCA627-COMPANY-NO.      
      *                                                                         
           MOVE WS-CUST-NAME               TO E-FCA627-CUST-NAME.       
           MOVE WS-SUBDIVISION             TO E-FCA627-SUBDIVISION.     
      *                                                                         
           MOVE AT-LOCAL-OFFICE            TO E-FCA627-LOCAL-OFFICE     
           MOVE AT-ACCOUNT-NO              TO E-FCA627-ACCOUNT-NO.      
           MOVE UT-READ-CYCLE              TO E-FCA627-READ-CYCLE       
           MOVE UT-READ-ROUTE              TO E-FCA627-READ-ROUTE       
           MOVE MN-CODE-UTIL-TYPE          TO MA-CODE-UTIL-TYPE         
                                              EM-CODE-UTIL-TYPE         
                                              GM-CODE-UTIL-TYPE         
                                              E-FCA627-UTIL-TYPE        
           MOVE MN-METER-NO                TO MA-METER-NO               
                                              GM-METER-NO               
                                              EM-METER-NO               
                                              E-FCA627-METER-NO.        
           MOVE MN-REMOTE-READ-IND         TO E-FCA627-RRI              
           MOVE MN-PROGRAM-ID              TO E-FCA627-PGM-ID           
           MOVE MN-DIGTL-MTR-TYPE          TO E-FCA627-DMT              
           MOVE MN-METER-PRESSURE          TO E-FCA627-MTR-PRESSURE     
           MOVE MN-REGISTER-RD-SEQ         TO E-FCA627-SEQUENCE-NO      
      *                                                                         
           MOVE PR-SPCL-READ-INSTR-TEXT    TO E-FCA627-SPCL-READ-INST   
           MOVE PR-SPCL-INSTRUCTIONS-TEXT  TO E-FCA627-SPCL-INST        
      *                                                                         
           IF  MN-CODE-UTIL-TYPE = 'G'                                  
               PERFORM 7310-SELECT-GAS-METER THRU 7310-EXIT             
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE SPACES             TO GM-METER-SIZE-ID          
C32098                                        U0-ELEC-MTR-FORM-CD       
               END-IF                                                   
               MOVE GM-METER-SIZE-ID       TO E-FCA627-METER-TYPE       
C32098         MOVE SPACES                 TO E-FCA627-FORM-CD          
C33743         MOVE SPACES                 TO PP-SUBSTATION-ID          
C33743                                        PP-CIRCUIT-ID             
           ELSE                                                         
               PERFORM 7320-SELECT-ELEC-METER THRU 7320-EXIT            
C36070         IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL          
C36070             MOVE EM-ELEC-MTR-CLASS-CD TO U0-ELEC-MTR-CLASS-CD    
C36070             MOVE EM-ELEC-MTR-SPEC-CD  TO U0-ELEC-MTR-SPEC-CD     
C36070             MOVE SPACES               TO U0-ELEC-MTR-FORM-CD     
C36070             PERFORM 7325-SELECT-FORM-CD THRU 7325-EXIT           
C36070         ELSE                                                     
                   MOVE SPACES             TO EM-METER-SIZE-ID          
                                              EM-ELEC-MTR-CLASS-CD      
                                              EM-ELEC-MTR-SPEC-CD       
C32098                                        U0-ELEC-MTR-FORM-CD       
C36070         END-IF                                                   
               MOVE EM-METER-SIZE-ID       TO E-FCA627-METER-TYPE       
               MOVE EM-ELEC-MTR-CLASS-CD   TO E-FCA627-CLASS-CD         
               MOVE EM-ELEC-MTR-SPEC-CD    TO E-FCA627-SPEC-CD          
C32098         MOVE U0-ELEC-MTR-FORM-CD    TO E-FCA627-FORM-CD          
C36070         PERFORM 7330-SELECT-SUB-CIRCUIT THRU 7330-EXIT           
C36070         IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
C33743            MOVE SPACES              TO PP-SUBSTATION-ID          
C33743                                        PP-CIRCUIT-ID             
C36070         END-IF                                                   
C33743         MOVE PP-SUBSTATION-ID          TO E-FCA627-SUB-ID        
C33743         MOVE PP-CIRCUIT-ID             TO E-FCA627-CIRCUIT-ID    
           END-IF                                                       
      *                                                                         
C36070     MOVE MC-NO-READ-DIALS           TO E-FCA627-DIALS            
C36070     MOVE MC-CONSTANT                TO E-FCA627-CONSTANT         
C36070     MOVE SPACES                     TO MA-DEVICE-NO              
C36070                                        MA-CODE-ATT-TYPE          
C36070                                        WS-DEVICE-NO-12           
           PERFORM 7300-SELECT-AMR-DEVICE-DTL THRU 7300-EXIT            
T33887*                                                                         
T33887     MOVE MA-DEVICE-NO               TO WS-DEVICE-NO-12           
T33887     MOVE WS-DEVICE-NO-10            TO E-FCA627-AMR-MODULE-ID    
           MOVE MA-CODE-ATT-TYPE           TO E-FCA627-AMR-TYPE         
           MOVE MN-CODE-METER-LOC          TO Q4-CODE-METER-LOC         
           MOVE MN-CODE-MTR-RD-INST1       TO Q5-CODE-MTR-RD-INST       
           PERFORM 7340-SELECT-LOC-DESC     THRU 7340-EXIT.             
           PERFORM 7350-SELECT-RD-INST-DESC THRU 7350-EXIT.             
           MOVE Q4-METER-LOC-DESC          TO E-FCA627-METER-LOC        
           MOVE Q5-MTR-RD-INSTR-DESC       TO E-FCA627-READ-INST        
      *                                                                         
ACT061     MOVE WS-SAVE-PR-STREET          TO E-FCA627-ST-ADDRESS.      
ACT061     MOVE WS-SAVE-PR-CITY-STATE-ZIP  TO E-FCA627-CITY-ST-ZIP.     
      *                                                                         
A#5470     MOVE PR-PREM-REF-LATITUDE       TO WS-LATITUDE               
A#5470     MOVE PR-PREM-REF-LONGITUDE      TO WS-LONGITUDE              
           MOVE WS-LATITUDE                TO WS-CA627-LATITUDE         
           MOVE WS-LONGITUDE               TO WS-CA627-LONGITUDE        
           MOVE WS-CA627-LATITUDE-RED      TO E-FCA627-LATITUDE         
           MOVE WS-CA627-LONGITUDE-RED     TO E-FCA627-LONGITUDE        
P00462     MOVE MN-MTR-READ-SOURCE-CD      TO E-FCA627-SOURCE-CD        
      *                                                                         
           MOVE FIOCA627                   TO FIOCA627-REC.             
           PERFORM 8100-WRITE-FIOCA627 THRU 8100-EXIT.                  
C36070     MOVE SPACES                     TO Q4-METER-LOC-DESC         
                                              Q5-MTR-RD-INSTR-DESC.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  SEARCH WS TABLE TO SEE WHETHER THE CURRENT ROUTE QUALIFIES    *        
      ******************************************************************        
      ****************************************************************          
      **      INCLUDE COPY BOOK TO RETRIEVE NAMES AND ADDRESSES     **          
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00074                                                
           END-EXEC.                                                            
      *                                                                         
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *                                                                         
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *                                                                         
      */6010-REDUCE-EMBEDDED-SPACES/*                                           
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************  20231000
      * 6990-FETCH-CUR-ACCOUNT                                       *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************  20231000
           EXEC SQL                                                             
P00462          INCLUDE CPDCA099                                                
           END-EXEC.                                                            
      *                                                                 20231000
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                 20231000
           MOVE ZEROES                     TO  WS-CPD99-ACCOUNT-NO.     
      *                                                                 20231000
           DISPLAY '****************** PCSCA627 ***************'.       
           DISPLAY '* ERROR IN PARA ', ACTIVE-PARAGRAPH                 
           DISPLAY '* PREMISE-NO = ', WS-CPD99-PREMISE-NO               
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE               
           DISPLAY '*******************************************'.       
           PERFORM 9900-ABEND     THRU  9900-EXIT.                      
      *                                                                 20231000
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * OPEN PARM CURSOR                                                        
      *****************************************************************         
       7100-OPEN-PARM-CUR.                                              
      *                                                                         
           EXEC SQL                                                     
                OPEN PARM_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**     7100-OPEN-PARM-CUR             **'       
               DISPLAY '**     OPEN ERROR FOR PARM_CUR CURSOR **'       
               DISPLAY '**     RETURNCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * FETCH PARM CURSOR                                                       
      *****************************************************************         
       7110-FETCH-PARM-CUR.                                             
      *                                                                         
           EXEC SQL                                                     
                FETCH PARM_CUR                                          
                 INTO :G6-PARM-DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
                                           NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**   PCSCA627 PROCESSING ERROR        **'       
               DISPLAY '**   7110-FETCH-PARM-CUR              **'       
               DISPLAY '**   FETCH ERROR FOR PARM_CUR CURSOR  **'       
               DISPLAY '**   RETURNCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**   PROCESSING TERMINATED            **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CLOSE PARM CURSOR                                                       
      *****************************************************************         
       7120-CLOSE-PARM-CUR.                                             
      *                                                                         
           EXEC SQL                                                     
                CLOSE PARM_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**   PCSCA627 PROCESSING ERROR        **'       
               DISPLAY '**   7120-CLOSE-PARM-CUR              **'       
               DISPLAY '**   CLOSE ERROR FOR PARM_CUR CURSOR  **'       
               DISPLAY '**   RETURNCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**   PROCESSING TERMINATED            **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      * 7600-START-FCSJC01                    *                                 
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      /                                                                         
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      /                                                                         
      *****************************************************************         
      **        THE DRIVING CURSOR IS OPENED.                        **         
      *****************************************************************         
       7200-OPEN-METER-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN METER_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      *****************************************************************         
       7210-FETCH-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
             FETCH  METER_CSR                                           
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
C36070             ,:AT-PREMISE-NO                                      
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-PROGRAM-ID                                      
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-METER-PRESSURE                                  
                   ,:MN-CODE-METER-LOC                                  
                   ,:MN-CODE-MTR-RD-INST1                               
                   ,:MN-REGISTER-RD-SEQ                                 
C36070             ,:MN-GIS-POINT-ID                                    
C36070             ,:MN-REG-ID-NO                                       
                   ,:UT-READ-ROUTE                                      
                   ,:UT-READ-CYCLE                                      
P00462             ,:MN-MTR-READ-SOURCE-CD                              
A#5470             ,:PR-PREM-REF-LATITUDE                               
A#5470             ,:PR-PREM-REF-LONGITUDE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE WS-Y TO WS-END-OF-CURSOR                        
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA627 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7210       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      *****************************************************************         
       7220-CLOSE-METER-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE  METER_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7220       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT AMR ATTACHMENT DETAILS                                           
      *****************************************************************         
       7300-SELECT-AMR-DEVICE-DTL.                                      
      *                                                                         
           EXEC SQL                                                     
T33887         SELECT TOP(1) MA.DEVICE_NO,
              MA.CODE_ATT_TYPE                                 
                 INTO  :MA-DEVICE-NO                                    
                      ,:MA-CODE-ATT-TYPE                                
                 FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
T33887                ,CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                
T33887          WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE            
T33887            AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE             
T33887            AND  MA.COMPANY_NO     = :MA-COMPANY-NO               
T33887            AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
T33887            AND  MA.METER_NO       = :MA-METER-NO                 
T33887            AND  N5.DEVICE_TYPE_CD = 'A'                          
T33887                                              
T33887                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MA.DEVICE_NO                                             
MFA-TR*               ,MA.CODE_ATT_TYPE                                         
MFA-TR*          INTO  :MA-DEVICE-NO                                            
MFA-TR*               ,:MA-CODE-ATT-TYPE                                        
MFA-TR*          FROM  CSS_METER_ATTCHMTS MA                                    
MFA-TR*               ,CSS_MTR_ATT_TYPE N5                                      
MFA-TR*         WHERE  MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                    
MFA-TR*           AND  MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                     
MFA-TR*           AND  MA.COMPANY_NO     = :MA-COMPANY-NO                       
MFA-TR*           AND  MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                   
MFA-TR*           AND  MA.METER_NO       = :MA-METER-NO                         
MFA-TR*           AND  N5.DEVICE_TYPE_CD = 'A'                                  
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                                        OR -811                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '* 7300: RETURN CODE ERROR                *'     
               DISPLAY '* RC = ' WS-ACTIVE-RETURN-CODE                  
               DISPLAY '* CODE-UTIL-TYPE = ' MA-CODE-UTIL-TYPE          
               DISPLAY '* METER-NO       = ' MA-METER-NO                
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT GAS METER DETAILS                                                
      *****************************************************************         
       7310-SELECT-GAS-METER.                                           
      *                                                                         
           EXEC SQL                                                     
C36070        SELECT GM.METER_SIZE_ID                                   
C36070              ,MC.CONSTANT                                        
C36070              ,MC.NO_READ_DIALS                                   
C36070          INTO :GM-METER-SIZE-ID                                  
C36070              ,:MC-CONSTANT                                       
C36070              ,:MC-NO-READ-DIALS                                  
C36070          FROM CSS_GAS_METER    GM WITH(READUNCOMMITTED)                  
C36070              ,CSS_MTR_CAP      MC WITH(READUNCOMMITTED)                  
C36070         WHERE GM.COMPANY_NO     = :GM-COMPANY-NO                 
C36070           AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE             
C36070           AND GM.METER_NO       = :GM-METER-NO                   
C36070           AND GM.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE          
C36070           AND GM.COMPANY_NO         = MC.COMPANY_NO              
C36070           AND GM.METER_NO           = MC.METER_NO                
C36070           AND MC.REG_ID_NO          = :MN-REG-ID-NO              
C33884                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GM.METER_SIZE_ID                                           
MFA-TR*             ,MC.CONSTANT                                                
MFA-TR*             ,MC.NO_READ_DIALS                                           
MFA-TR*         INTO :GM-METER-SIZE-ID                                          
MFA-TR*             ,:MC-CONSTANT                                               
MFA-TR*             ,:MC-NO-READ-DIALS                                          
MFA-TR*         FROM CSS_GAS_METER    GM                                        
MFA-TR*             ,CSS_MTR_CAP      MC                                        
MFA-TR*        WHERE GM.COMPANY_NO     = :GM-COMPANY-NO                         
MFA-TR*          AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                     
MFA-TR*          AND GM.METER_NO       = :GM-METER-NO                           
MFA-TR*          AND GM.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                  
MFA-TR*          AND GM.COMPANY_NO         = MC.COMPANY_NO                      
MFA-TR*          AND GM.METER_NO           = MC.METER_NO                        
MFA-TR*          AND MC.REG_ID_NO          = :MN-REG-ID-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7310       **'       
               DISPLAY '**        COMPANY NO = ' GM-COMPANY-NO          
               DISPLAY '**        METER NO   = ' GM-METER-NO            
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT ELEC METER DETAILS                                               
      *****************************************************************         
       7320-SELECT-ELEC-METER.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT EM.METER_SIZE_ID                                   
C36070              ,EM.ELEC_MTR_CLASS_CD                               
C36070              ,EM.ELEC_MTR_SPEC_CD                                
C36070              ,MC.CONSTANT                                        
C36070              ,MC.NO_READ_DIALS                                   
C36070          INTO :EM-METER-SIZE-ID                                  
C36070              ,:EM-ELEC-MTR-CLASS-CD                              
C36070              ,:EM-ELEC-MTR-SPEC-CD                               
C36070              ,:MC-CONSTANT                                       
C36070              ,:MC-NO-READ-DIALS                                  
C36070          FROM CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
C36070              ,CSS_MTR_CAP      MC WITH(READUNCOMMITTED)                  
C36070         WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                 
C36070           AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE             
C36070           AND EM.METER_NO       = :EM-METER-NO                   
C36070           AND EM.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE          
C36070           AND EM.COMPANY_NO         = MC.COMPANY_NO              
C36070           AND EM.METER_NO           = MC.METER_NO                
C36070           AND MC.REG_ID_NO          = :MN-REG-ID-NO              
C33884                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EM.METER_SIZE_ID                                           
MFA-TR*             ,EM.ELEC_MTR_CLASS_CD                                       
MFA-TR*             ,EM.ELEC_MTR_SPEC_CD                                        
MFA-TR*             ,MC.CONSTANT                                                
MFA-TR*             ,MC.NO_READ_DIALS                                           
MFA-TR*         INTO :EM-METER-SIZE-ID                                          
MFA-TR*             ,:EM-ELEC-MTR-CLASS-CD                                      
MFA-TR*             ,:EM-ELEC-MTR-SPEC-CD                                       
MFA-TR*             ,:MC-CONSTANT                                               
MFA-TR*             ,:MC-NO-READ-DIALS                                          
MFA-TR*         FROM CSS_ELEC_METER EM                                          
MFA-TR*             ,CSS_MTR_CAP      MC                                        
MFA-TR*        WHERE EM.COMPANY_NO     = :EM-COMPANY-NO                         
MFA-TR*          AND EM.CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                     
MFA-TR*          AND EM.METER_NO       = :EM-METER-NO                           
MFA-TR*          AND EM.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                  
MFA-TR*          AND EM.COMPANY_NO         = MC.COMPANY_NO                      
MFA-TR*          AND EM.METER_NO           = MC.METER_NO                        
MFA-TR*          AND MC.REG_ID_NO          = :MN-REG-ID-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7320       **'       
               DISPLAY '**        COMPANY NO = ' EM-COMPANY-NO          
               DISPLAY '**        METER NO   = ' EM-METER-NO            
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36070*****************************************************************         
C36070* SELECT ELEC METER FORM CODE                                             
C36070*****************************************************************         
C36070 7325-SELECT-FORM-CD.                                             
C36070*                                                                         
C36070     EXEC SQL                                                     
C36070        SELECT U0.ELEC_MTR_FORM_CD                                
C36070          INTO :U0-ELEC-MTR-FORM-CD                               
C36070          FROM CSS_ELEC_CL_SPEC U0 WITH(READUNCOMMITTED)                  
C36070         WHERE U0.ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD      
C36070           AND U0.ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD       
C36070                                                           
ACT061                                                      
C36070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT U0.ELEC_MTR_FORM_CD                                        
MFA-TR*         INTO :U0-ELEC-MTR-FORM-CD                                       
MFA-TR*         FROM CSS_ELEC_CL_SPEC U0                                        
MFA-TR*        WHERE U0.ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD              
MFA-TR*          AND U0.ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36070*                                                                         
C36070     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C36070*                                                                         
C36070     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C36070         NEXT SENTENCE                                            
C36070     ELSE                                                         
C36070         DISPLAY '****************************************'       
C36070         DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
C36070         DISPLAY '**      ABEND IN PARAGRAPH 7325       **'       
C36070         DISPLAY '** ELEC_MTR_CLASS_CD = ' U0-ELEC-MTR-CLASS-CD   
C36070         DISPLAY '** ELEC_MTR_SPEC_CD  = ' U0-ELEC-MTR-SPEC-CD    
C36070         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C36070         DISPLAY '****************************************'       
C36070         PERFORM 9900-ABEND THRU 9900-EXIT                        
C36070     END-IF.                                                      
C36070*                                                                         
C36070 7325-EXIT.                                                       
C36070     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT SUB AND CIRCUIT DETAILS                                          
      *****************************************************************         
       7330-SELECT-SUB-CIRCUIT.                                         
      *                                                                         
C36070     EXEC SQL                                                     
C36070        SELECT SUBSTATION_ID                                      
C36070              ,CIRCUIT_ID                                         
C33743          INTO :PP-SUBSTATION-ID                                  
C33743              ,:PP-CIRCUIT-ID                                     
C33743          FROM CSS_PIM_POINT    PP WITH(READUNCOMMITTED)                  
C33743         WHERE PP.POINT_ID       = :MN-GIS-POINT-ID               
C33884                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBSTATION_ID                                              
MFA-TR*             ,CIRCUIT_ID                                                 
MFA-TR*         INTO :PP-SUBSTATION-ID                                          
MFA-TR*             ,:PP-CIRCUIT-ID                                             
MFA-TR*         FROM CSS_PIM_POINT    PP                                        
MFA-TR*        WHERE PP.POINT_ID       = :MN-GIS-POINT-ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
                                        OR -811                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7330       **'       
               DISPLAY '**        ACCOUNT NO = ' MN-ACCOUNT-NO          
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT METER LOCATION DESCIRPTION                                       
      *****************************************************************         
       7340-SELECT-LOC-DESC.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT METER_LOC_DESC                                     
                INTO :Q4-METER-LOC-DESC                                 
                FROM CSS_METER_LOC WITH(READUNCOMMITTED)                        
               WHERE CODE_METER_LOC = :Q4-CODE-METER-LOC                
C33884                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_LOC_DESC                                             
MFA-TR*         INTO :Q4-METER-LOC-DESC                                         
MFA-TR*         FROM CSS_METER_LOC                                              
MFA-TR*        WHERE CODE_METER_LOC = :Q4-CODE-METER-LOC                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7340                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7340       **'       
               DISPLAY '**        ACCOUNT NO = ' MN-ACCOUNT-NO          
               DISPLAY '**        METER LOC  = ' Q4-CODE-METER-LOC      
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT METER READ INSTRUCTION DESCRIPTION                               
      *****************************************************************         
       7350-SELECT-RD-INST-DESC.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT MTR_RD_INSTR_DESC                                  
                INTO :Q5-MTR-RD-INSTR-DESC                              
                FROM CSS_MTR_RD_INST WITH(READUNCOMMITTED)                      
               WHERE CODE_MTR_RD_INST  = :Q5-CODE-MTR-RD-INST           
C33884                                                           
ACT061                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_RD_INSTR_DESC                                          
MFA-TR*         INTO :Q5-MTR-RD-INSTR-DESC                                      
MFA-TR*         FROM CSS_MTR_RD_INST                                            
MFA-TR*        WHERE CODE_MTR_RD_INST  = :Q5-CODE-MTR-RD-INST                   
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7350       **'       
               DISPLAY '**        ACCOUNT NO = ' MN-ACCOUNT-NO          
               DISPLAY '**        READ INST  = ' Q5-CODE-MTR-RD-INST    
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C36070*===============================================================*         
C36070 7360-SELECT-PREMISE.                                             
C36070*===============================================================*         
C36070*                                                                         
C36070     EXEC SQL                                                     
C36070        SELECT PR.SPCL_READ_INSTR                                 
C36070              ,PR.SPCL_INSTRUCTIONS                               
C36070              ,PR.ADDRESS_ID                                      
ACT061              ,PR.SUBDIVISION_ID                                  
C36070          INTO :PR-SPCL-READ-INSTR                                
C36070              ,:PR-SPCL-INSTRUCTIONS                              
C36070              ,:PR-ADDRESS-ID                                     
ACT061              ,:PR-SUBDIVISION-ID                                 
C36070          FROM CSS_PREMISE  PR WITH(READUNCOMMITTED)                      
C36070         WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                    
C36070                                                           
ACT061                                                      
C36070     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.SPCL_READ_INSTR                                         
MFA-TR*             ,PR.SPCL_INSTRUCTIONS                                       
MFA-TR*             ,PR.ADDRESS_ID                                              
MFA-TR*             ,PR.SUBDIVISION_ID                                          
MFA-TR*         INTO :PR-SPCL-READ-INSTR                                        
MFA-TR*             ,:PR-SPCL-INSTRUCTIONS                                      
MFA-TR*             ,:PR-ADDRESS-ID                                             
MFA-TR*             ,:PR-SUBDIVISION-ID                                         
MFA-TR*         FROM CSS_PREMISE  PR                                            
MFA-TR*        WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7360                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36070*                                                                         
C36070     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C36070*                                                                         
C36070     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C36070         NEXT SENTENCE                                            
C36070     ELSE                                                         
C36070         DISPLAY '****************************************'       
C36070         DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
C36070         DISPLAY '**      ABEND IN PARAGRAPH 7360       **'       
C36070         DISPLAY '**     PREMISE_NO  = ' PR-PREMISE-NO            
C36070         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C36070         DISPLAY '****************************************'       
C36070         PERFORM 9900-ABEND THRU 9900-EXIT                        
C36070     END-IF.                                                      
C36070*                                                                         
C36070 7360-EXIT.                                                       
C36070     EXIT.                                                        
      *                                                                         
      *==============================================================*          
ACT061*   GET THE SUBDIVISION NAME                                   *          
      *==============================================================*          
ACT061 7361-SELECT-SUBDIVISION.                                         
      *                                                                         
ACT061     EXEC SQL                                                     
ACT061        SELECT SUBDIVISION_DESC                                   
ACT061          INTO :B0-SUBDIVISION-DESC                               
ACT061          FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                      
ACT061         WHERE SUBDIVISION_ID  = :B0-SUBDIVISION-ID               
ACT061           AND COMPANY_NO      = :B0-COMPANY-NO                   
ACT061                                                           
ACT061                                                      
ACT061     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBDIVISION_DESC                                           
MFA-TR*         INTO :B0-SUBDIVISION-DESC                                       
MFA-TR*         FROM CSS_SUBDIVISION                                            
MFA-TR*        WHERE SUBDIVISION_ID  = :B0-SUBDIVISION-ID                       
MFA-TR*          AND COMPANY_NO      = :B0-COMPANY-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7361                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT061     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
ACT061     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
ACT061         NEXT SENTENCE                                            
ACT061     ELSE                                                         
ACT061         DISPLAY '****************************************'       
ACT061         DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
ACT061         DISPLAY '**      ABEND IN PARAGRAPH 7361       **'       
ACT061         DISPLAY '**  PREMISE_NO     = ' PR-PREMISE-NO            
ACT061         DISPLAY '**  SUBDIVISION-ID = ' B0-SUBDIVISION-ID        
ACT061         DISPLAY '**  COMPANY-NO     = ' B0-COMPANY-NO            
ACT061         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
ACT061         DISPLAY '****************************************'       
ACT061         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT061     END-IF.                                                      
      *                                                                         
ACT061 7361-EXIT.                                                       
ACT061     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * WRITE CUSTOMER DATA TO OUTPUT FILE                                      
      *****************************************************************         
       8100-WRITE-FIOCA627.                                             
      *                                                                         
           WRITE FIOCA627-REC.                                          
           IF  FCA627-SUCCESSFUL                                        
               ADD 1                       TO WS-FCSCA627-REC-CNTR      
           ELSE                                                         
               DISPLAY '8100-ERROR ON FCSCA627 WRITE. STATUS IS '       
                        WS-FCA627-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * DISPLAY CONTROL TOTALS                                                  
      *****************************************************************         
       8180-PRINT-COUNTERS.                                             
      *                                                                         
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR PCSCA627   *****'.         
           DISPLAY ' '.                                                 
           DISPLAY '** RECS WRITTEN TO CA627 = ' WS-FCSCA627-REC-CNTR.  
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
      *                                                                         
       8180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   9000-TERMINATE                                              *         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA627-FILE.                                         
      *                                                                         
           IF  FCA627-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**  PCSCA627 PROCESSING ERROR           **'     
               DISPLAY '**  CLOSE ERROR  - OUTPUT FILES         **'     
               DISPLAY '**  FILE STATUS = ' WS-FCA627-STATUS            
               DISPLAY '**  UNSUCCESSFUL CLOSE OF FCSCA627-FILE  **'    
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
