       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA626.                                        
       AUTHOR . ROGER D. FAULK                                          
       DATE-WRITTEN.   JULY 2005.                                       
                                                                        
      ****************************************************************          
      *                 SOUTH CAROLINA ELECTRICITY & GAS             *          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      *                                                              *          
      *               PROGRAM  MODIFICATION  LOG                     *          
      *     DATE    INTIALS      REASON                              *          
      *     ____    _______      ______                              *          
T35434* 24-JAN-2008 MK92804    ADDED FOR FETCH ONLY WITH UR FOR      *          
      *                        CURSORS AND WITH UR FOR SINGELTON     *          
      *                        SELECTS AND REPLACED CSS_MODEL_SQL    *          
      *                        WITH SET STATEMENTS                   *          
      *                                                              *          
C37760*  1 OCT 2008 RF10596    INCREASED SIZE OF PRINT FIELDS IN     *          
      *                        DETAIL LINE.                          *          
      *                                                              *          
A03411*  2 NOV 2011 RF10596    CHANGE PROGRAM TO USE NEW REVENUE     *          
      *                        TABLES AS INPUT.  ADD RATE 076        *          
      *                                                              *          
A03082*  3 FEB 2012 RF10596    CHANGE  TO USE READ UNITS AND         *          
      *                        HANDLE DEKATHERMS.                    *          
      *                                                              *          
A03967*  1 DEC 2012 RF10596    ADD NEW PRIVATE LIGHT RATE 075        *          
A03967*                        IN 4600-CALCULATE-AMOUNT - CHANGE     *          
A03967*                        FACTOR FROM 77 TO 76 FOR RATE 76      *          
      *                                                              *          
A03967*  3 JAN 2013 RF10596    ADD TAXES TO REPORT                   *          
      *                                                              *          
A04527*  1 JUL 2013 RF10596    LENGHTEN PRINT FIELD                  *          
      *                                                              *          
A04527*  1 SEP 2013 RF10596    ADD OPERATING AND BUSINESS UNIT       *          
      *                                                              *          
      ****************************************************************          
      *    REMARKS.                                                  *          
      *                    PCSCA626 NARRATIVE                        *          
      *                                                              *          
      * INPUT TO THIS PROGRAM IS DEADHEAD ACCOUNTS                   *          
      *                                                              *          
      * THIS  PROGRAM  READS  THE  REVENUE TABLES. POPULATES  THE    *          
      * MRSCRR03-FILE, PRINTS A SUMMARY TAX REPORT BY LOCATION AND   *          
      * PRINTS A DETAILED REPORT OF ALL INPUT RECORD ACCOUNTS,       *          
      * INCLUDING THE ACCOUNTS WITH ZERO CONSUMPTION, WHICH ARE NOT  *          
      * INCLUDED IN THE SUMMARY REPORT.                              *          
      * IT GETS RATE FACTORS, FROM JOB_PARM, TO MULTIPLY THE         *          
      * KWH/CCF BY TO GET THE MONEY AMOUNT.   THEN TAXES ARE         *          
      * CALCULATED ON THIS AMOUNT.   FRANCHISE TAX IS NOT INCLUDED   *          
      * IN THIS REPORT, BECAUSE IT WAS DETERMINED DEADHEAD ACCOUNTS  *          
      * ARE NOT SUBJECT TO FRANCHISE TAXES.                          *          
      ****************************************************************          
      *              ---- BASIC BATCH SEQUENCE STRUCTURE ----        *          
      *             1000 - 1999   INPUT PROCESSING CONTROL PATH      *          
      *             2000 - 2999   OUTPUT PROCESSING CONTROL PATH     *          
      *             6000 - 6999   COMMON SYSTEM MODULES              *          
      *             7000 - 7999   INPUT MODULES                      *          
      *             9000 - 9799   TERMINATION MODULES                *          
      *             9900 - 9999   ABEND/ABORT MODULES                *          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT MRSCRR03-FILE                                         
               ASSIGN TO UT-S-MRSCRR03                                  
               FILE STATUS IS WS-CRR03-STATUS.                          
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
           SELECT PRINTER2 ASSIGN TO DA-PRINTER2.                       
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  MRSCRR03-FILE.                                               
       01  MRSCRR03-REC                     PIC X(222).                 
      *                                                                         
       FD  PRINTER1.                                                    
       01  FS-PRINT-REC.                                                
           05  RPT-CNTL                     PIC X.                      
           05  RPT-LINE                     PIC X(132).                 
      *                                                                         
       FD  PRINTER2.                                                    
       01  FS-PRINT2-REC.                                               
           05  RPT2-CNTL                    PIC X.                      
           05  RPT2-LINE                    PIC X(132).                 
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA626'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ****************************************************************          
      **** APPLICATION TABLE WORKING STORAGE DECLARATIONS   **********          
      ****************************************************************          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *-- ABEND SWITCH COPYBOOK                                                 
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      *-- COPY BOOK TO FORMAT PARM DATA                                         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-FILE-STATUS-AREA.                                         
           05  WS-CRR03-STATUS              PIC XX.                     
               88  CRR03-SUCCESSFUL    VALUE '00'.                      
      *                                                                         
       01  WS-CHECK-RATE.                                               
           05  WS-CHECK-RATEA          PIC X    VALUE SPACES.           
           05  WS-CHECK-RATEB          PIC XX   VALUE SPACES.           
      *                                                                         
       01  WS-A8300-DATE.                                               
           05 WS-A8300-YEAR            PIC X(4).                        
           05 FILLER                   PIC X   VALUE '-'.               
           05 WS-A8300-MONTH           PIC XX.                          
           05 FILLER                   PIC X   VALUE '-'.               
           05 WS-A8300-DAY             PIC XX.                          
      *                                                                         
       01  WS-FIX-DATE                 PIC X(10).                       
       01  WS-FIX-DATE2                PIC X(10).                       
      *                                                                         
       01  WS-WORK-DATE.                                                
           05  WS-WORK-YEAR            PIC X(4).                        
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-WORK-MONTH           PIC XX.                          
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-WORK-DAY             PIC XX.                          
      *                                                                         
       01  WS-BILL-UNIQUE-TS.                                           
           05  WS-BUT-YEAR             PIC X(4).                        
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-BUT-MONTH            PIC XX.                          
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-BUT-DAY              PIC XX.                          
           05  WS-BUT-REST             PIC X(16)                        
                                       VALUE '-00.00.00.000000'.        
      *                                                                         
       01  WS-FACTOR                         PIC 9V9(6).                
       01  WS-FACTOR-AN REDEFINES WS-FACTOR  PIC X(7).                  
      *                                                                         
A03967 01  WS-RATE075-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
       01  WS-RATE076-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
       01  WS-RATE077-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
       01  WS-RATE078-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
       01  WS-RATE079-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
       01  WS-RATE78B-FACTOR           PIC S9V9(6) COMP-3 VALUE 0.      
      *                                                                         
A03967 01  WS-SAVE-RATE075.                                             
A03967     05  WS-SAVE-RATE075A        PIC X    VALUE SPACES.           
A03967     05  FILLER                  PIC X    VALUE '.'.              
A03967     05  WS-SAVE-RATE075B        PIC X(6) VALUE SPACES.           
      *                                                                         
       01  WS-SAVE-RATE076.                                             
           05  WS-SAVE-RATE076A        PIC X    VALUE SPACES.           
           05  FILLER                  PIC X    VALUE '.'.              
           05  WS-SAVE-RATE076B        PIC X(6) VALUE SPACES.           
      *                                                                         
       01  WS-SAVE-RATE077.                                             
           05  WS-SAVE-RATE077A        PIC X    VALUE SPACES.           
           05  FILLER                  PIC X    VALUE '.'.              
           05  WS-SAVE-RATE077B        PIC X(6) VALUE SPACES.           
      *                                                                         
       01  WS-SAVE-RATE078.                                             
           05  WS-SAVE-RATE078A        PIC X    VALUE SPACES.           
           05  FILLER                  PIC X    VALUE '.'.              
           05  WS-SAVE-RATE078B        PIC X(6) VALUE SPACES.           
      *                                                                         
       01  WS-SAVE-RATE079.                                             
           05  WS-SAVE-RATE079A        PIC X    VALUE SPACES.           
           05  FILLER                  PIC X    VALUE '.'.              
           05  WS-SAVE-RATE079B        PIC X(6) VALUE SPACES.           
      *                                                                         
       01  WS-SAVE-RATE78B.                                             
           05  WS-SAVE-RATE78BA        PIC X    VALUE SPACES.           
           05  FILLER                  PIC X    VALUE '.'.              
           05  WS-SAVE-RATE78BB        PIC X(6) VALUE SPACES.           
      *                                                                         
       01 WS-WORK-PARM.                                                 
          05 WS-PARM-PROGRAM           PIC X(8)    VALUE 'PCSCA626'.    
          05 WS-PARM-COMPANY           PIC XX      VALUE SPACES.        
          05 WS-PARM-CMND-CODE         PIC X(4)    VALUE 'PARM'.        
      *                                                                         
       01  WS-PARM-DATA626.                                             
           05 WS-PARM-LITERAL7         PIC X(14).                       
           05 WS-REVENUE-MONTH.                                         
              07 WS-REVENUE-YEAR       PIC 9(4).                        
              07 WS-REVENUE-MM         PIC 99.                          
           05 FILLER                   PIC X(60).                       
      *                                                                         
       01  WS-WORK-REVENUE             PIC 9(6) VALUE 0.                
       01  WS-REVENUE-MONTH-P          PIC S9(6)V COMP-3 VALUE 0.       
      *                                                                         
       01 WS-PARM-RATE-FACTORS.                                         
          05 WS-PARM-COMPANY-LITERAL   PIC X(3).                        
          05 WS-PARM-COMPANY-NO        PIC XX.                          
          05 FILLER                    PIC X.                           
          05 WS-PARM-RATE1ST-LITERAL   PIC X(8).                        
          05 WS-PARM-RATE1ST.                                           
             10 WS-PARM-1STA           PIC X.                           
             10 WS-PARM-1ST-DOT        PIC X.                           
             10 WS-PARM-1STB           PIC X(6).                        
          05 FILLER                    PIC X.                           
          05 WS-PARM-RATE2ND-LITERAL   PIC X(8).                        
          05 WS-PARM-RATE2ND.                                           
             10 WS-PARM-2NDA           PIC X.                           
             10 WS-PARM-2ND-DOT        PIC X.                           
             10 WS-PARM-2NDB           PIC X(6).                        
          05 FILLER                    PIC X(41).                       
      *                                                                         
       01  WS-REF-ITEMS.                                                
           02 MRSCRR03-REC-SPLIT            PIC X(222).                 
           02 ZIKRT8300                                                 
              REDEFINES MRSCRR03-REC-SPLIT.                             
           COPY CSRCRR03.                                                       
      *                                                                         
       01  WS-PARAMETER-AREA.                                           
           05 WS-ACCT-PERIOD-PARAM          PIC X(6) VALUE '999999'.    
           05 FILLER  REDEFINES  WS-ACCT-PERIOD-PARAM.                  
              10 WS-ACCT-PERIOD-PARAM-CCYY  PIC X(4).                   
              10 WS-ACCT-PERIOD-PARAM-MM    PIC XX.                     
           05 WS-ACCT-PERIOD-PARAM-RED                                  
              REDEFINES WS-ACCT-PERIOD-PARAM PIC 9(6).                  
           05 WS-MRS-LOCAL-OFFICE            PIC X(3).                  
      *                                                                         
       01  WS-ACCT-PERIOD-BREAKDOWN          PIC 9(6).                  
       01  WS-ACCT-PERIOD-BREAKDOWN-RED                                 
           REDEFINES WS-ACCT-PERIOD-BREAKDOWN.                          
           05 WS-ACCT-PERIOD-CCYY            PIC 9(4).                  
           05 FILLER  REDEFINES  WS-ACCT-PERIOD-CCYY.                   
              10 WS-ACCT-PERIOD-CC           PIC 99.                    
              10 WS-ACCT-PERIOD-YY           PIC 99.                    
           05 WS-ACCT-PERIOD-MM              PIC 99.                    
      *                                                                         
       01  WS-CURRENT-DATE                   PIC X(10).                 
      *                                                                         
       01  WS-LAST-CALENDAR-DATE             PIC 9(8).                  
       01  WS-LAST-CALENDAR-DATE-RED                                    
                    REDEFINES WS-LAST-CALENDAR-DATE.                    
           05 WS-LAST-CALENDAR-DATE-YY       PIC 9999.                  
           05 WS-LAST-CALENDAR-DATE-MM       PIC 99.                    
           05 WS-LAST-CALENDAR-DATE-DD       PIC 99.                    
                                                                        
      *                                                                         
       01  WS-MISC-FIELDS.                                              
           05 WS-LOC-OPT-TAX-PCT      PIC V999    VALUE 0.              
COB305     05 WS-REVAMT        PIC S9V9(6) COMP-3 VALUE 0.               
COB305     05 WS-YEAR-QUOTIENT        PIC S9(5) COMP-3 VALUE 0.               
COB305     05 WS-LEAP-YEAR-CHECK        PIC S9(5) COMP-3 VALUE 0.               
COB305     05 WS-LEAP-YEAR-CHECK-400        PIC S9(5) COMP-3 VALUE 0.           
COB305     05 WS-LEAP-YEAR-CHECK-100        PIC S9(5) COMP-3 VALUE 0.           
           05 WS-ACCT-PERIOD-AFFCTD   PIC S9(9)   COMP VALUE 0.         
      *                                                                         
       01 WS-PCT-FLAGS.                                                 
          05  WS-LOCAL-OPTION-FLAG    PIC X VALUE 'N'.                  
          05  WS-SALES-TAX-FLAG       PIC X VALUE 'N'.                  
          05  WS-CAPITAL-FLAG         PIC X VALUE 'N'.                  
          05  WS-TRANSP-FLAG          PIC X VALUE 'N'.                  
          05  WS-EDUCATION-FLAG       PIC X VALUE 'N'.                  
      *                                                                         
       01  WS-CALC-FIELDS.                                              
A03967     05 WS-PRT2-TAX             PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-HONK-SALES-TAX       PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-SAVE-USE             PIC S9(9)     COMP-3 VALUE 0.     
           05 WS-CALC-AMOUNT          PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CALC-SALES           PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CALC-LOST            PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CALC-CAPITAL         PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CALC-TRANSP          PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CALC-EDUCATION       PIC S9(9)V99  COMP-3 VALUE 0.     
      *                                                                         
       01  WS-LOCATION-TOTALS.                                          
           05 WS-LOC-USE              PIC S9(9)     COMP-3 VALUE 0.     
           05 WS-LOC-AMOUNT           PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-LOC-SALES-TAX        PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-LOC-LOST-TAX         PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-LOC-CAPITAL-TAX      PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-LOC-TRANSP-TAX       PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-LOC-EDUCATION-TAX    PIC S9(7)V99  COMP-3 VALUE 0.     
      *                                                                         
       01  WS-TOTAL-TOTALS.                                             
           05 WS-TOT-USE              PIC S9(9)     COMP-3 VALUE 0.     
           05 WS-TOT-AMOUNT           PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-TOT-SALES-TAX        PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-TOT-LOST-TAX         PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-TOT-CAPITAL-TAX      PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-TOT-TRANSP-TAX       PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-TOT-EDUCATION-TAX    PIC S9(7)V99  COMP-3 VALUE 0.     
      *                                                                         
       01  WS-COMPANY-TOTALS.                                           
           05 WS-CO-USE               PIC S9(9)     COMP-3 VALUE 0.     
           05 WS-CO-AMOUNT            PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CO-SALES-TAX         PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-CO-LOST-TAX          PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-CO-CAPITAL-TAX       PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-CO-TRANSP-TAX        PIC S9(7)V99  COMP-3 VALUE 0.     
           05 WS-CO-EDUCATION-TAX     PIC S9(7)V99  COMP-3 VALUE 0.     
      *                                                                         
       01  WS-GRAND-TOTALS.                                             
           05 WS-GRAND-USE            PIC S9(9)     COMP-3 VALUE 0.     
           05 WS-GRAND-AMOUNT         PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-GRAND-SALES-TAX      PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-GRAND-LOST-TAX       PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-GRAND-CAPITAL-TAX    PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-GRAND-TRANSP-TAX     PIC S9(9)V99  COMP-3 VALUE 0.     
           05 WS-GRAND-EDUCATION-TAX  PIC S9(9)V99  COMP-3 VALUE 0.     
      *                                                                         
       01  WS-VARIABLES.                                                
A04527     05 WS-PSNC-OPERUNIT         PIC X(4)   VALUE 'PSNC'.         
A04527     05 WS-PSNC-BUSIUNIT         PIC X(5)   VALUE 'PSNC '.        
A04527     05 WS-SCEG-OPERUNIT         PIC X(4)   VALUE 'EGCO'.         
A04527     05 WS-SCEG-BUSIUNIT         PIC X(5)   VALUE 'EG   '.        
           05 WS-SEQ-NO                PIC S9999V COMP-3 VALUE 6.       
           05 WS-CNTRL-NO              PIC S9(4) COMP VALUE 0.          
           05 WS-DETAIL-ID             PIC X(3).                        
           05 WS-PREV-TYPE-SERV        PIC X.                           
           05 WS-PREV-LOC-CODE         PIC X(4).                        
           05 WS-PREV-REV-DIST         PIC X(3).                        
           05 WS-PREV-LOCAL-OFFICE     PIC X(3).                        
           05 WS-PREV-LOC-TAX-PCT      PIC V999.                        
           05 WS-PREV-COMPANY          PIC XX    VALUE SPACES.          
           05 WS-RETURN-CODE-UED       PIC S9(4) VALUE ZEROS.           
           05 WS-ACCT-NO               PIC X(7).                        
           05 WS-ACCT-NO-NUM REDEFINES WS-ACCT-NO PIC 9(3)V9(4).        
           05 WS-COMPANY               PIC XX    VALUE '01'.            
           05 WS-NO-MORE-DATA          PIC X     VALUE 'N'.             
           05 WS-SUB                   PIC 9(3)  VALUE ZEROS.           
           05 WS-CALC-AMT              PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAXABLE-AMT           PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TAX-AMT               PIC S9(7)V99 COMP-3 VALUE 0.     
           05 WS-TOT-ELEC-MTRS         PIC S9(7)    COMP-3 VALUE 0.     
           05 WS-TOT-GAS-MTRS          PIC S9(7)    COMP-3 VALUE 0.     
           05 WS-NBR-MTRS              PIC S9(3)    COMP-3 VALUE 1.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-ACTIVE                PIC X     VALUE 'A'.             
           05 WS-PGM-204               PIC X(8)  VALUE 'PCSCA204'.      
           05 WS-PARM-204              PIC X(4)  VALUE 'PARM'.          
           05 WS-COMPANY-204           PIC XX    VALUE '01'.            
           05 WS-FIRST-TIME-SW         PIC X     VALUE 'Y'.             
           05 WS-PGRMNAME              PIC X(8)  VALUE 'PCSCA626'.      
           05 WS-A184-SW               PIC X     VALUE 'N'.             
           05 WS-SOURCE-SYSTEM         PIC X     VALUE 'B'.             
           05 WS-SYSTEM-CODE           PIC X     VALUE '0'.             
           05 WS-CENTURY               PIC XX    VALUE '20'.            
           05 WS-LOCOFF-02             PIC XX    VALUE '02'.            
           05 WS-TAX                   PIC X(3)  VALUE 'TAX'.           
           05 WS-COST-CENTER           PIC X(4)  VALUE '0001'.          
           05 WS-FUNCTION-CODE         PIC X(4)  VALUE 'ACJV'.          
           05 WS-NOE                   PIC X(3)  VALUE '901'.           
           05 WS-TRN-CODE              PIC X(4)  VALUE '8300'.          
           05 WS-ONE                   PIC 9     VALUE 1.               
           05 WS-TWO                   PIC 9     VALUE 2.               
           05 WS-FOUR                  PIC 9     VALUE 4.               
           05 WS-FIVE                  PIC 9     VALUE 5.               
           05 WS-SIX                   PIC 9     VALUE 6.               
           05 WS-SEVEN                 PIC 9     VALUE 7.               
A03967     05 WS-EIGHT                 PIC 9     VALUE 8.               
           05 WS-TEN                   PIC 99    VALUE 10.              
           05 WS-TWENTY                PIC 99    VALUE 20.              
           05 WS-ELEVEN                PIC 99    VALUE 11.              
           05 WS-THIRTY-TWO            PIC 99    VALUE 32.              
           05 WS-THIRTY-THREE          PIC 99    VALUE 33.              
           05 WS-FORTY-TWO             PIC 99    VALUE 42.              
           05 WS-FORTY-THREE           PIC 99    VALUE 43.              
           05 WS-FIFTY-TWO             PIC 99    VALUE 52.              
           05 WS-FIFTY-THREE           PIC 99    VALUE 53.              
           05 WS-SIXTY-TWO             PIC 99    VALUE 62.              
           05 WS-SIXTY-THREE           PIC 99    VALUE 63.              
           05 WS-THREE                 PIC 9     VALUE 3.               
           05 WS-FIFTY-SIX             PIC 99    VALUE 56.              
           05 WS-FIFTY-SEVEN           PIC 99    VALUE 57.              
      *                                                                         
       01  WS-ELECTRIC-GLS.                                             
           05 WS-OFFSET-GL-X           PIC X(7)  VALUE '1840030'.       
           05 WS-ELEC-SALES-GL-X       PIC X(7)  VALUE '2410107'.       
           05 WS-ELEC-EDUCATION-GL-X   PIC X(7)  VALUE '2410231'.       
      *                                                                         
           05 WS-ELEC-SALES-GL         PIC X(8)  VALUE '241.0107'.      
           05 WS-ELEC-EDUCATION-GL     PIC X(8)  VALUE '241.0231'.      
           05 WS-ELEC-LOST-GL          PIC 9(3)V9999 COMP-3 VALUE 0.    
           05 WS-ELEC-CAPITAL-GL       PIC 9(3)V9999 COMP-3 VALUE 0.    
           05 WS-ELEC-TRANSP-GL        PIC 9(3)V9999 COMP-3 VALUE 0.    
      *                                                                         
       01  WS-GAS-GLS.                                                  
           05 WS-GAS-SALES-GL-X        PIC X(7)  VALUE '2410108'.       
           05 WS-GAS-EDUCATION-GL-X    PIC X(7)  VALUE '2410241'.       
      *                                                                         
           05 WS-GAS-SALES-GL          PIC X(8)  VALUE '241.0108'.      
           05 WS-GAS-EDUCATION-GL      PIC X(8)  VALUE '241.0241'.      
           05 WS-GAS-LOST-GL           PIC 9(3)V9999 COMP-3 VALUE 0.    
           05 WS-GAS-CAPITAL-GL        PIC 9(3)V9999 COMP-3 VALUE 0.    
           05 WS-GAS-TRANSP-GL         PIC 9(3)V9999 COMP-3 VALUE 0.    
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-FIRST-RECORD-READ     PIC X     VALUE 'Y'.             
           05 WS-FIRST-REC-WRITE       PIC X     VALUE 'N'.             
           05 WS-FIRST-PRINT-RECORD    PIC X     VALUE 'Y'.             
           05 WS-TYPE-SERVICE-INVALID  PIC X     VALUE 'N'.             
           05 WS-LOCATION-SW           PIC X     VALUE 'N'.             
      *                                                                         
       01  WS-COMP-VARIABLES.                                           
           05 WS-8300-CONTROL-AMOUNT   PIC S9(13)V99 COMP-3 VALUE 0.    
           05 WS-SAVE-AMOUNT           PIC S9(13)V99 COMP-3 VALUE 0.    
      *                                                                         
      ***   WS-REPORT-VARIABLES.                                                
      *                                                                         
       01  WS-PRINTER1-COUNTERS.                                        
           05 WS-LINE-CNTR             PIC 99   VALUE ZEROS.            
           05 WS-PAGE                  PIC 99   VALUE ZEROS.            
           05 WS-LINE-SPACE            PIC 9    VALUE ZERO.             
      *                                                                         
       01  WS-PRINTER2-COUNTERS.                                        
           05 WS-LINE-CNTR2            PIC 99   VALUE 66.               
           05 WS-PAGE2                 PIC 99   VALUE ZEROS.            
           05 WS-LINE-SPACE2           PIC 9    VALUE ZERO.             
      *                                                                         
       01  WS-FOOT-REPORT-VARIABLES.                                    
           05 WS-IN-REC-READ           PIC 9(8) VALUE ZEROS.            
           05 WS-REC-SKIPPED           PIC 9(8) VALUE ZEROS.            
           05 WS-REP-WRITE             PIC 9(8) VALUE ZEROS.            
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-ONE.                                                  
           05 FILLER                   PIC X(8)  VALUE 'PCSCA626'.      
           05 FILLER                   PIC X(45) VALUE SPACES.          
           05 P-COMPANY                PIC X(39) VALUE                  
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                   PIC X(30) VALUE SPACES.          
           05 FILLER                   PIC X(8)  VALUE 'PAGE -'.        
           05 WS-DET-PAGE              PIC ZZ    VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-TWO.                                                  
           05 FILLER                   PIC X(15) VALUE                  
              'REVENUE MONTH ='.                                        
           05 FILLER                   PIC XX    VALUE SPACES.          
           05 WS-REVENUE-MTH.                                           
              10 WS-REVENUE-CC         PIC XX.                          
              10 WS-REVENUE-YY         PIC XX.                          
              10 FILLER                PIC X     VALUE '/'.             
              10 WS-REVENUE-MM2        PIC XX.                          
           05 FILLER                   PIC X(18) VALUE SPACES.          
           05 FILLER                   PIC X(50) VALUE                  
              'DEADHEAD REPORT FOR AMOUNT, CONSUMPTION AND TAXES '.     
           05 FILLER                   PIC X(11) VALUE                  
              'BY LOCATION'.                                            
           05 FILLER                   PIC X(19) VALUE SPACES.          
           05 WS-RPT-H2-DATE           PIC X(10) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-THREE.                                                
           05 FILLER                   PIC X(15) VALUE                  
              'TYPE SERVICE  ='.                                        
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-RPT-SERV              PIC X(8).                        
           05 FILLER                   PIC X(108).                      
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-FOUR.                                                 
           05 FILLER                   PIC X(8)  VALUE 'LOCATION'.      
           05 FILLER                   PIC X     VALUE SPACES.          
           05 FILLER                   PIC X(12) VALUE                  
              'REVENUE DIST'.                                           
           05 FILLER                   PIC X(9)  VALUE SPACES.          
           05 FILLER                   PIC X(6)  VALUE 'AMOUNT'.        
           05 FILLER                   PIC X(7)  VALUE SPACES.          
           05 FILLER                   PIC X(9)  VALUE 'KWH / CCF'.     
           05 FILLER                   PIC X(10) VALUE SPACES.          
           05 FILLER                   PIC X(5)  VALUE 'SALES'.         
           05 FILLER                   PIC X(11) VALUE SPACES.          
           05 FILLER                   PIC X(4)  VALUE 'LOST'.          
           05 FILLER                   PIC X(8)  VALUE SPACES.          
           05 FILLER                   PIC X(7)  VALUE 'CAPITAL'.       
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 FILLER                   PIC X(14) VALUE                  
              'TRANSPORTATION'.                                         
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X(9)  VALUE                  
              'EDUCATION'.                                              
           05 FILLER                   PIC XX    VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 1                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-FIVE.                                                 
           05 FILLER                   PIC X(13) VALUE                  
              'GL ACCOUNT NO'.                                          
           05 FILLER                   PIC X(47) VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-SALES-GL              PIC X(8)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-LOST-GL               PIC 9(3).9(4) VALUE ZEROS.       
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-CAPITAL-GL            PIC 9(3).9(4) VALUE ZEROS.       
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-TRANSP-GL             PIC 9(3).9(4) VALUE ZEROS.       
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE '('.             
           05 WS-EDUCATION-GL          PIC X(8)  VALUE SPACES.          
           05 FILLER                   PIC X     VALUE ')'.             
           05 FILLER                   PIC X     VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** PRINT LINE FOR SUMMARY REPORT OF TAXES                     **          
      ****************************************************************          
      *                                                                         
       01  PRT-DETAIL-LINE.                                             
           05 PRT-DET-PREP.                                             
              10 PRT-LOCATION          PIC X(4).                        
              10 FILLER                PIC X(5).                        
              10 PRT-REV-DIST          PIC X(3).                        
           05 PRT-TOT-PREP REDEFINES PRT-DET-PREP.                      
              10 PRT-TOT-TYPE          PIC X(3).                        
              10 FILLER                PIC X.                           
              10 PRT-TOT-LITERAL       PIC X(8).                        
C37760     05 FILLER                   PIC X(11) VALUE SPACES.          
C37760     05 PRT-AMOUNT               PIC ---,---,--9.99.              
C37760     05 FILLER                   PIC XX    VALUE SPACES.          
C37760     05 PRT-USE                  PIC -,---,---,--9.               
A04527     05 FILLER                   PIC X(6)  VALUE SPACES.          
A04527     05 PRT-SALES-TAX            PIC -,---,--9.99.                
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 PRT-LOST-TAX             PIC ---,--9.99.                  
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 PRT-CAPITAL-TAX          PIC ---,--9.99.                  
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 PRT-TRANSP-TAX           PIC ---,--9.99.                  
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 PRT-EDUCATION-TAX        PIC ---,--9.99.                  
           05 FILLER                   PIC X     VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 2                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-ONE-2.                                                
           05 FILLER                   PIC X(8)  VALUE 'PCSCA626'.      
           05 FILLER                   PIC X(45) VALUE SPACES.          
           05 P2-COMPANY               PIC X(39) VALUE                  
              'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.                
           05 FILLER                   PIC X(30) VALUE SPACES.          
           05 FILLER                   PIC X(8)  VALUE 'PAGE -'.        
           05 WS-DET-PAGE2             PIC ZZ    VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 2                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-TWO-2.                                                
           05 FILLER                   PIC X(47) VALUE SPACES.          
           05 FILLER                   PIC X(51) VALUE                  
              'DETAIL LIST OF ACCOUNTS USED IN DEADHEAD TAX REPORT'.    
           05 FILLER                   PIC X(24) VALUE SPACES.          
           05 WS-RPT2-H2-DATE          PIC X(10) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 2                                        **          
      ****************************************************************          
      *                                                                         
       01  HEADER-THREE-2.                                              
           05 FILLER                   PIC X(20) VALUE SPACES.          
           05 FILLER                   PIC X(7)  VALUE 'SERVICE'.       
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 FILLER                   PIC X(7)  VALUE 'REVENUE'.       
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 FILLER                   PIC X(5)  VALUE 'LOCAL'.         
           05 FILLER                   PIC X(86) VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** HEADER FOR REPORT 2                                        **          
      ****************************************************************          
      *                                                                         
A03967 01  HEADER-FOUR-2.                                               
A03967     05 FILLER                   PIC X(4)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(10) VALUE 'ACCOUNT NO'.    
A03967     05 FILLER                   PIC X(8)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(4)  VALUE 'TYPE'.          
A03967     05 FILLER                   PIC X(4)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(8)  VALUE 'DISTRICT'.      
A03967     05 FILLER                   PIC X(3)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(6)  VALUE 'OFFICE'.        
A03967     05 FILLER                   PIC X(3)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(8)  VALUE 'LOCATION'.      
A03967     05 FILLER                   PIC X(3)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(5)  VALUE 'CLASS'.         
A03967     05 FILLER                   PIC X(4)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(4)  VALUE 'RATE'.          
A03967     05 FILLER                   PIC X(8)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(9)  VALUE 'KWH / CCF'.     
A03967     05 FILLER                   PIC X(7)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(6)  VALUE 'AMOUNT'.        
A03967     05 FILLER                   PIC X(8)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(8)  VALUE 'NBR MTRS'.      
A03967     05 FILLER                   PIC X(5)  VALUE SPACES.          
A03967     05 FILLER                   PIC X(3)  VALUE 'TAX'.           
A03967     05 FILLER                   PIC X(4)  VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** PRINT LINE FOR ALL ACCOUNTS USED FOR THE SUMMARY REPORT 2  **          
      ****************************************************************          
      *                                                                         
       01  PRT2-DETAIL-LINE.                                            
           05 FILLER                   PIC X     VALUE SPACES.          
           05 PRT2-ACCT-NBR            PIC XBXXXXBXXXXBXXXX.            
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 PRT2-TYPE-SERV           PIC X.                           
           05 FILLER                   PIC X(8)  VALUE SPACES.          
           05 PRT2-REV-DIST            PIC XXX.                         
           05 FILLER                   PIC X(8)  VALUE SPACES.          
           05 PRT2-LOCAL-OFFICE        PIC XXX.                         
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 PRT2-LOCATION            PIC X(4).                        
           05 FILLER                   PIC X(6)  VALUE SPACES.          
           05 PRT2-CLASS               PIC X(3).                        
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 PRT2-RATE                PIC X(3).                        
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 PRT2-KWH-CCF             PIC --,---,--9.                  
           05 FILLER                   PIC X(4)  VALUE SPACES.          
           05 PRT2-AMT                 PIC -,---,--9.99.                
           05 FILLER                   PIC X(3)  VALUE SPACES.          
           05 PRT2-MTRS                PIC --,---,--9.                  
A04527     05 FILLER                   PIC XX    VALUE SPACES.          
A04527     05 PRT2-TAX                 PIC ---,--9.99.                  
           05 FILLER                   PIC X(3)  VALUE SPACES.          
      *                                                                         
      ****************************************************************          
      ** PRINT FACTORS ON DETAIL ACCOUNT REPORT                     **          
      ****************************************************************          
      *                                                                         
       01  PRT2-RATE-FACTOR-LINE.                                       
           05 FILLER                   PIC X(4)   VALUE SPACES.         
           05 PRT2-LITERAL             PIC X(18)  VALUE SPACES.         
           05 PRT2-FACTOR              PIC X(8)   VALUE SPACES.         
           05 FILLER                   PIC X(102) VALUE SPACES.         
      *                                                                         
      ****************************************************************          
      * WORKING STORAGE FOOTER VARIABLES                                        
      ****************************************************************          
      *                                                                         
       01  WS-REP-ONE.                                                  
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              'NUMBER OF INPUT FILE RECORDS READ      :'.               
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-REC-READ              PIC X(10).                       
           05 FILLER                   PIC X(76) VALUE SPACES.          
      *                                                                         
       01  WS-REP-TWO.                                                  
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              'NUMBER OF INPUT RECORDS SKIPPED        :'.               
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-REC-SKIP              PIC X(8).                        
           05 FILLER                   PIC X(74) VALUE SPACES.          
      *                                                                         
       01  WS-REP-THREE.                                                
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              'NUMBER OF RECORDS REPORTED             :'.               
           05 FILLER                   PIC X     VALUE SPACES.          
           05 WS-REP-WRITTEN           PIC X(8).                        
           05 FILLER                   PIC X(82) VALUE SPACES.          
      *                                                                         
       01  WS-FOOT-LINE.                                                
           05 FILLER                   PIC X(46) VALUE SPACES.          
           05 FILLER                   PIC X(40) VALUE                  
              '*************END OF REPORT**************'.               
           05 FILLER                   PIC X(46) VALUE SPACES.          
      *                                                                         
       01  PRT-RPT2-ELEC-TOTAL.                                         
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(42) VALUE                  
              'NUMBER OF ELECTRIC METERS ON INPUT FILE : '.             
           05 PRT-ELEC-MTRS-READ       PIC --,---,--9.                  
           05 FILLER                   PIC X(75) VALUE SPACES.          
      *                                                                         
       01  PRT-RPT2-GAS-TOTAL.                                          
           05 FILLER                   PIC X(5)  VALUE SPACES.          
           05 FILLER                   PIC X(42) VALUE                  
              'NUMBER OF GAS METERS ON INPUT FILE      : '.             
           05 PRT-GAS-MTRS-READ        PIC --,---,--9.                  
           05 FILLER                   PIC X(75) VALUE SPACES.          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTXCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTXRATE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * REV_BILLING_DET  -  RV                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVBLD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * REV_BILL_COMP_ADJ - RB                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBREVCOM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
               DECLARE GL-ACCT-CURSOR CURSOR FOR                        
               SELECT TC.TAX_CNTRL_NO,                                  
                      SF.GL_ACCT_NO                                     
                FROM  CSS_TAX_CNTL  TC WITH(READUNCOMMITTED),                   
                      CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                WHERE TC.TAX_CNTRL_NO IN (32,33,42,43,52,53)            
                AND   SF.FACTOR_ID    =  TC.FACTOR_ID                   
T35434          FOR READ ONLY                                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GL-ACCT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT TC.TAX_CNTRL_NO,                                          
MFA-TR*               SF.GL_ACCT_NO                                             
MFA-TR*         FROM  CSS_TAX_CNTL  TC,                                         
MFA-TR*               CSS_SPCL_FCTR SF                                          
MFA-TR*         WHERE TC.TAX_CNTRL_NO IN (32,33,42,43,52,53)                    
MFA-TR*         AND   SF.FACTOR_ID    =  TC.FACTOR_ID                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION REVENUE TABLES                     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE REV-CURSOR CURSOR FOR                              
                SELECT RV.REV_COMPANY_NO                                
                      ,RV.CODE_SERVICE_TYPE                             
                      ,RV.MNICPLTY_COUNTY_CD                            
                      ,RV.ACCOUNT_NO                                    
                      ,RV.RATE_PLAN_NO                                  
                      ,RV.CODE_UTIL_TYPE                                
                      ,RV.REV_DISTRICT_CD                               
                      ,RV.LOCAL_OFFICE                                  
                      ,RV.CODE_REVENUE_CLASS                            
A03082                ,RB.CONSUMPT_TYPE_CD                              
A03082                ,SUM(RB.READ_UNITS)                               
                      ,SUM(RB.BILLED_AMT)                               
                 FROM  REV_BILL_COMP_ADJ RB WITH(READUNCOMMITTED)               
                      ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                 
                WHERE RV.REV_COMPANY_NO = :RV-REV-COMPANY-NO            
                  AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH             
                  AND RV.BILL_UNIQUE_TS >= CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )           
                  AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS             
                  AND RV.RATE_DEPT_CD IN ('E99', 'G99')                 
                  AND RV.RATE_PLAN_NO <> '000'                          
                  AND RB.UTILITY_REV_CD = 'U'                           
                GROUP BY RV.REV_COMPANY_NO                              
                        ,RV.CODE_SERVICE_TYPE                           
                        ,RV.MNICPLTY_COUNTY_CD                          
                        ,RV.ACCOUNT_NO                                  
                        ,RV.RATE_PLAN_NO                                
                        ,RV.CODE_UTIL_TYPE                              
                        ,RV.REV_DISTRICT_CD                             
                        ,RV.LOCAL_OFFICE                                
                        ,RV.CODE_REVENUE_CLASS                          
A03082                  ,RB.CONSUMPT_TYPE_CD                            
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE REV-CURSOR CURSOR FOR                                      
MFA-TR*         SELECT RV.REV_COMPANY_NO                                        
MFA-TR*               ,RV.CODE_SERVICE_TYPE                                     
MFA-TR*               ,RV.MNICPLTY_COUNTY_CD                                    
MFA-TR*               ,RV.ACCOUNT_NO                                            
MFA-TR*               ,RV.RATE_PLAN_NO                                          
MFA-TR*               ,RV.CODE_UTIL_TYPE                                        
MFA-TR*               ,RV.REV_DISTRICT_CD                                       
MFA-TR*               ,RV.LOCAL_OFFICE                                          
MFA-TR*               ,RV.CODE_REVENUE_CLASS                                    
MFA-TR*               ,RB.CONSUMPT_TYPE_CD                                      
MFA-TR*               ,SUM(RB.READ_UNITS)                                       
MFA-TR*               ,SUM(RB.BILLED_AMT)                                       
MFA-TR*          FROM  REV_BILL_COMP_ADJ RB                                     
MFA-TR*               ,REV_BILLING_DET RV                                       
MFA-TR*         WHERE RV.REV_COMPANY_NO = :RV-REV-COMPANY-NO                    
MFA-TR*           AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                     
MFA-TR*           AND RV.BILL_UNIQUE_TS >= :RV-BILL-UNIQUE-TS                   
MFA-TR*           AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS                     
MFA-TR*           AND RV.RATE_DEPT_CD IN ('E99', 'G99')                         
MFA-TR*           AND RV.RATE_PLAN_NO <> '000'                                  
MFA-TR*           AND RB.UTILITY_REV_CD = 'U'                                   
MFA-TR*         GROUP BY RV.REV_COMPANY_NO                                      
MFA-TR*                 ,RV.CODE_SERVICE_TYPE                                   
MFA-TR*                 ,RV.MNICPLTY_COUNTY_CD                                  
MFA-TR*                 ,RV.ACCOUNT_NO                                          
MFA-TR*                 ,RV.RATE_PLAN_NO                                        
MFA-TR*                 ,RV.CODE_UTIL_TYPE                                      
MFA-TR*                 ,RV.REV_DISTRICT_CD                                     
MFA-TR*                 ,RV.LOCAL_OFFICE                                        
MFA-TR*                 ,RV.CODE_REVENUE_CLASS                                  
MFA-TR*                 ,RB.CONSUMPT_TYPE_CD                                    
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      * PROGRAM MAINLINE                                             *          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 4400-GET-KWH-CCF-FACTORS THRU 4400-EXIT.             
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2987-PRINT-FACTORS  THRU 2987-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                        UNTIL WS-NO-MORE-DATA = 'Y'.                    
      *                                                                         
           PERFORM 7530-CLOSE-REV-CURSOR THRU 7530-EXIT.                
      *                                                                         
           MOVE WS-OFFSET-GL-X TO WS-ACCT-NO.                           
           PERFORM 2205-DO184-RECORD THRU 2205-EXIT.                    
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROGRAM INITIALIZATION                                       *          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 1200-PROCESS-DATE THRU 1200-EXIT.                    
      *                                                                         
           PERFORM 7800-GET-LAST-DAY THRU 7800-EXIT.                    
      *                                                                         
           MOVE WS-FIX-DATE2   TO WS-WORK-DATE.                         
           MOVE WS-WORK-YEAR  TO WS-LAST-CALENDAR-DATE-YY.              
           MOVE WS-WORK-MONTH TO WS-LAST-CALENDAR-DATE-MM.              
           MOVE WS-WORK-DAY   TO WS-LAST-CALENDAR-DATE-DD.              
           DISPLAY 'WS-LAST-CALENDAR-DATE = ' WS-LAST-CALENDAR-DATE.    
      *                                                                         
           PERFORM 1500-GET-GL-ACCT THRU 1500-EXIT.                     
      *                                                                         
           MOVE WS-COMPANY        TO RV-REV-COMPANY-NO.                 
           MOVE WS-WORK-REVENUE   TO RV-REVENUE-MONTH.                  
           MOVE WS-BILL-UNIQUE-TS TO RV-BILL-UNIQUE-TS.                 
           PERFORM 7500-OPEN-REV-CURSOR THRU 7500-EXIT.                 
      *                                                                         
           PERFORM 7520-FETCH-REV-CURSOR THRU 7520-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS OUTPUT MRSCRR03-FILE AND PRINTER1                      *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN OUTPUT MRSCRR03-FILE                                    
                       PRINTER1                                         
                       PRINTER2.                                        
      *                                                                         
           IF  CRR03-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      PCSCA626 PROCESSING ERROR        **'    
               DISPLAY '**  OPEN ERROR OF MRSCRR03 - OUTPUT FILE **'    
               DISPLAY '**  FILE STATUS = ' WS-CRR03-STATUS             
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OBTAINS THE CURRENT DATE FOR THE HEADERS AND REVENUE MONTH   *          
      *    FROM JOB PARM USING PCSCA204                              *          
      ****************************************************************          
      *                                                                         
       1200-PROCESS-DATE.                                               
      *                                                                         
           PERFORM 7200-GET-CURRENT-DATE THRU 7200-EXIT.                
      *                                                                         
           MOVE WS-CURRENT-DATE TO WS-RPT-H2-DATE                       
                                   WS-RPT2-H2-DATE.                     
      *                                                                         
           MOVE WS-PGM-204     TO G6-PROGRAM-NAME.                      
           MOVE WS-PARM-204    TO G6-CMND-CODE.                         
           MOVE WS-COMPANY-204 TO G6-COMPANY-NO.                        
           MOVE WS-SEQ-NO      TO G6-SEQ-NO.                            
           MOVE WS-ACTIVE      TO G6-STATUS.                            
           PERFORM 7400-GET-REVENUE-MONTH THRU 7400-EXIT.               
           MOVE G6-PARM-DATA TO WS-PARM-DATA626.                        
           PERFORM 4444-ONE-MONTH-BACK THRU 4444-EXIT.                  
           MOVE WS-REVENUE-MONTH TO WS-WORK-REVENUE.                    
           MOVE WS-WORK-REVENUE  TO WS-REVENUE-MONTH-P                  
                                    WS-REVENUE-MTH.                     
      *                                                                         
           MOVE WS-REVENUE-YEAR TO WS-A8300-YEAR                        
                                   WS-BUT-YEAR.                         
           MOVE WS-REVENUE-MM   TO WS-A8300-MONTH                       
                                   WS-BUT-MONTH.                        
           MOVE '01'            TO WS-A8300-DAY                         
                                   WS-BUT-DAY.                          
           MOVE WS-A8300-DATE   TO WS-FIX-DATE                          
                                   WS-FIX-DATE2.                        
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GETS THE GL-ACCT-NOS OF OTHER NEW TAXES                      *          
      * APPLICABLE FOR REVENUE DISTRICT                              *          
      ****************************************************************          
      *                                                                         
       1500-GET-GL-ACCT.                                                
      *                                                                         
           PERFORM 7000-OPEN-GL-ACCT-CURSOR THRU 7000-EXIT.             
      *                                                                         
           PERFORM 7010-FETCH-GL-ACCT-CURSOR THRU 7010-EXIT.            
      *                                                                         
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
               EVALUATE TC-TAX-CNTRL-NO                                 
                   WHEN WS-THIRTY-TWO                                   
                       MOVE SF-GL-ACCT-NO TO WS-ELEC-LOST-GL            
                   WHEN WS-FORTY-TWO                                    
                       MOVE SF-GL-ACCT-NO TO WS-ELEC-CAPITAL-GL         
                   WHEN WS-FIFTY-TWO                                    
                       MOVE SF-GL-ACCT-NO TO WS-ELEC-TRANSP-GL          
                   WHEN WS-THIRTY-THREE                                 
                       MOVE SF-GL-ACCT-NO TO WS-GAS-LOST-GL             
                   WHEN WS-FORTY-THREE                                  
                       MOVE SF-GL-ACCT-NO TO WS-GAS-CAPITAL-GL          
                   WHEN WS-FIFTY-THREE                                  
                       MOVE SF-GL-ACCT-NO TO WS-GAS-TRANSP-GL           
                END-EVALUATE                                            
                PERFORM 7010-FETCH-GL-ACCT-CURSOR THRU 7010-EXIT        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-GL-ACCT-CURSOR THRU 7020-EXIT.            
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROCESS EACH RECORD FOUND VIA THE REV-CURSOR                 *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           IF RV-REV-COMPANY-NO NOT = WS-PARM-COMPANY-NO                
              GO TO 2000-CONTINUE                                       
           END-IF.                                                      
      *                                                                         
           MOVE RV-RATE-PLAN-NO TO WS-CHECK-RATE.                       
      *                                                                         
A03967     IF WS-CHECK-RATEB = '77' OR '78' OR '79' OR '76' OR '75'     
              CONTINUE                                                  
           ELSE                                                         
              IF RV-RATE-PLAN-NO  = '78B'                               
                 CONTINUE                                               
              ELSE                                                      
                 GO TO 2000-CONTINUE                                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           ADD WS-ONE TO WS-IN-REC-READ.                                
A03967     MOVE ZEROS TO WS-PRT2-TAX.                                   
      *                                                                         
           PERFORM 4600-CALCULATE-AMOUNT THRU 4600-EXIT.                
      *                                                                         
           IF RB-READ-UNITS = 0                                         
A03967        PERFORM 2950-ACCOUNT-LIST-REPORT THRU 2950-EXIT           
              GO TO 2000-CONTINUE                                       
           END-IF.                                                      
      *                                                                         
           MOVE 'N' TO WS-LOCATION-SW.                                  
      *                                                                         
           PERFORM 2150-CALC-TAXES THRU 2150-EXIT.                      
      *                                                                         
A03967     PERFORM 2950-ACCOUNT-LIST-REPORT THRU 2950-EXIT.             
      *                                                                         
           IF RV-CODE-SERVICE-TYPE = 'E'                                
              PERFORM 2200-PROC-ELEC-RECORDS THRU 2200-EXIT             
      *                                                                         
              IF WS-CALC-LOST = 0                                       
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'Y'             TO WS-LOCATION-SW                 
                 MOVE WS-ELEC-LOST-GL TO WS-ACCT-NO-NUM                 
                 PERFORM 2201-PROC-LOST-RECORDS THRU 2201-EXIT          
              END-IF                                                    
      *                                                                         
              IF WS-CALC-CAPITAL = 0                                    
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'Y'                TO WS-LOCATION-SW              
                 MOVE WS-ELEC-CAPITAL-GL TO WS-ACCT-NO-NUM              
                 PERFORM 2202-PROC-CAPITAL-RECORDS THRU 2202-EXIT       
              END-IF                                                    
      *                                                                         
              IF WS-CALC-TRANSP = 0                                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'Y'               TO WS-LOCATION-SW               
                 MOVE WS-ELEC-TRANSP-GL TO WS-ACCT-NO-NUM               
                 PERFORM 2203-PROC-TRANSP-RECORDS THRU 2203-EXIT        
              END-IF                                                    
      *                                                                         
              IF WS-CALC-EDUCATION = 0                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 'Y'                    TO WS-LOCATION-SW          
                 MOVE WS-ELEC-EDUCATION-GL-X TO WS-ACCT-NO              
                 PERFORM 2204-PROC-EDUCATION-RECORDS THRU 2204-EXIT     
              END-IF                                                    
      *                                                                         
           ELSE                                                         
              IF RV-CODE-SERVICE-TYPE = 'G'                             
                 PERFORM 2300-PROC-GAS-RECORDS THRU 2300-EXIT           
      *                                                                         
                 IF WS-CALC-LOST = 0                                    
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'Y'            TO WS-LOCATION-SW               
                    MOVE WS-GAS-LOST-GL TO WS-ACCT-NO-NUM               
                    PERFORM 2201-PROC-LOST-RECORDS THRU 2201-EXIT       
                 END-IF                                                 
      *                                                                         
                 IF WS-CALC-CAPITAL = 0                                 
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'Y'               TO WS-LOCATION-SW            
                    MOVE WS-GAS-CAPITAL-GL TO WS-ACCT-NO-NUM            
                    PERFORM 2202-PROC-CAPITAL-RECORDS THRU 2202-EXIT    
                 END-IF                                                 
      *                                                                         
                 IF WS-CALC-TRANSP = 0                                  
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'Y'              TO WS-LOCATION-SW             
                    MOVE WS-GAS-TRANSP-GL TO WS-ACCT-NO-NUM             
                    PERFORM 2203-PROC-TRANSP-RECORDS THRU 2203-EXIT     
                 END-IF                                                 
      *                                                                         
                 IF WS-CALC-EDUCATION = 0                               
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'Y'                   TO WS-LOCATION-SW        
                    MOVE WS-GAS-EDUCATION-GL-X TO WS-ACCT-NO            
                    PERFORM 2204-PROC-EDUCATION-RECORDS THRU 2204-EXIT  
                 END-IF                                                 
      *                                                                         
              ELSE                                                      
                 DISPLAY ' INVALID TYPE SERV  ' RV-CODE-SERVICE-TYPE    
                  ' RV-ACCOUNT-NO = '  RV-ACCOUNT-NO                    
                 ADD WS-ONE TO WS-REC-SKIPPED                           
                 MOVE 'Y'   TO WS-TYPE-SERVICE-INVALID                  
                                                                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF  WS-TYPE-SERVICE-INVALID = 'Y'                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2100-SELECT-DTL-TOT THRU 2100-EXIT                
           END-IF.                                                      
      *                                                                         
       2000-CONTINUE.                                                   
      *                                                                         
           PERFORM 7520-FETCH-REV-CURSOR THRU 7520-EXIT.                
      *                                                                         
           IF WS-NO-MORE-DATA = 'Y'                                     
              PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT                
              PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT               
              PERFORM 2675-COMP-BREAK THRU 2675-EXIT                    
              PERFORM 2800-SUMM-REPORT THRU 2800-EXIT                   
              PERFORM 2955-SUMM-ACCT-REPORT THRU 2955-EXIT              
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CHECKS FOR A BREAK BY TYPE-SERVICE AND THEN FOR BREAK BY     *          
      * LOCATION. IF BREAK OCCURS PRINTS THE TOTALS BY LOCATION      *          
      * AND THEN BY TYPE-SERVICE.                                    *          
      * PRINTS THE DETAIL LINE FOR EVERY RECORD.                     *          
      ****************************************************************          
      *                                                                         
       2100-SELECT-DTL-TOT.                                             
      *                                                                         
           IF  WS-FIRST-RECORD-READ = 'Y'                               
               MOVE RV-CODE-SERVICE-TYPE  TO WS-PREV-TYPE-SERV          
               MOVE RV-MNICPLTY-COUNTY-CD TO WS-PREV-LOC-CODE           
               MOVE RV-REV-DISTRICT-CD    TO WS-PREV-REV-DIST           
               MOVE RV-REV-COMPANY-NO     TO WS-PREV-COMPANY            
               MOVE 'N'                   TO WS-FIRST-RECORD-READ       
           END-IF.                                                      
      *                                                                         
           IF RV-REV-COMPANY-NO NOT = WS-PREV-COMPANY                   
              PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT                
              PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT               
              PERFORM 2675-COMP-BREAK THRU 2675-EXIT                    
           END-IF.                                                      
      *                                                                         
           IF  RV-CODE-SERVICE-TYPE NOT = WS-PREV-TYPE-SERV             
               PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT               
               PERFORM 2650-TYPE-SERV-BREAK THRU 2650-EXIT              
           END-IF.                                                      
      *                                                                         
           IF  RV-MNICPLTY-COUNTY-CD NOT = WS-PREV-LOC-CODE             
               PERFORM 2600-LOC-CODE-BREAK THRU 2600-EXIT               
           END-IF.                                                      
      *                                                                         
           ADD WS-CALC-AMT       TO WS-CALC-AMOUNT                      
                                    WS-LOC-AMOUNT                       
                                    WS-TOT-AMOUNT                       
                                    WS-CO-AMOUNT                        
                                    WS-GRAND-AMOUNT.                    
      *                                                                         
           ADD RB-READ-UNITS       TO WS-SAVE-USE                       
                                    WS-LOC-USE                          
                                    WS-TOT-USE                          
                                    WS-CO-USE                           
                                    WS-GRAND-USE.                       
      *                                                                         
           ADD WS-CALC-SALES     TO WS-LOC-SALES-TAX                    
                                    WS-TOT-SALES-TAX                    
                                    WS-CO-SALES-TAX                     
                                    WS-GRAND-SALES-TAX.                 
      *                                                                         
           ADD WS-CALC-LOST      TO WS-LOC-LOST-TAX                     
                                    WS-TOT-LOST-TAX                     
                                    WS-CO-LOST-TAX                      
                                    WS-GRAND-LOST-TAX.                  
      *                                                                         
           ADD WS-CALC-CAPITAL   TO WS-LOC-CAPITAL-TAX                  
                                    WS-TOT-CAPITAL-TAX                  
                                    WS-CO-CAPITAL-TAX                   
                                    WS-GRAND-CAPITAL-TAX.               
      *                                                                         
           ADD WS-CALC-TRANSP    TO WS-LOC-TRANSP-TAX                   
                                    WS-TOT-TRANSP-TAX                   
                                    WS-CO-TRANSP-TAX                    
                                    WS-GRAND-TRANSP-TAX.                
      *                                                                         
           ADD WS-CALC-EDUCATION TO WS-LOC-EDUCATION-TAX                
                                    WS-TOT-EDUCATION-TAX                
                                    WS-CO-EDUCATION-TAX                 
                                    WS-GRAND-EDUCATION-TAX.             
      *                                                                         
           PERFORM 2500-PRINT-ELEC-GAS-LINE THRU 2500-EXIT.             
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CALCULATE APPLICABLE TAXES FOR EACH COUNTY.                  *          
      ****************************************************************          
      *                                                                         
       2150-CALC-TAXES.                                                 
      *                                                                         
           MOVE ZEROS TO WS-CALC-SALES.                                 
           MOVE ZEROS TO WS-CALC-LOST.                                  
           MOVE ZEROS TO WS-CALC-CAPITAL.                               
           MOVE ZEROS TO WS-CALC-TRANSP.                                
           MOVE ZEROS TO WS-CALC-EDUCATION.                             
           MOVE ZEROS TO WS-HONK-SALES-TAX.                             
A03967     MOVE ZEROS TO WS-PRT2-TAX.                                   
      *                                                                         
           MOVE RV-REV-DISTRICT-CD TO WS-DETAIL-ID.                     
      *                                                                         
A03967     IF WS-CHECK-RATEB = '77' OR '79' OR '76' OR '75'             
              MOVE WS-THIRTY-TWO   TO WS-CNTRL-NO                       
           ELSE                                                         
              MOVE WS-THIRTY-THREE TO WS-CNTRL-NO                       
           END-IF.                                                      
      *                                                                         
           PERFORM 2250-RETRIEVE-PCT THRU 2250-EXIT.                    
      *                                                                         
           IF WS-LOCAL-OPTION-FLAG = 'Y'                                
              MULTIPLY WS-CALC-AMT BY TR-TAX-RATE                       
                       GIVING WS-CALC-LOST ROUNDED                      
              MOVE 'N' TO WS-LOCAL-OPTION-FLAG                          
              MOVE TR-TAX-RATE TO WS-LOC-OPT-TAX-PCT                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-TEN TO WS-CNTRL-NO.                                  
      *                                                                         
           PERFORM 2250-RETRIEVE-PCT THRU 2250-EXIT.                    
      *                                                                         
           IF WS-SALES-TAX-FLAG = 'Y'                                   
              MULTIPLY WS-CALC-AMT BY TR-TAX-RATE                       
                       GIVING WS-CALC-SALES ROUNDED                     
              MOVE 'N' TO WS-SALES-TAX-FLAG                             
           END-IF.                                                      
      *                                                                         
A03967     IF WS-CHECK-RATEB = '77' OR '79' OR '76' OR '75'             
              MOVE WS-FORTY-TWO   TO WS-CNTRL-NO                        
           ELSE                                                         
              MOVE WS-FORTY-THREE TO WS-CNTRL-NO                        
           END-IF.                                                      
      *                                                                         
           PERFORM 2250-RETRIEVE-PCT THRU 2250-EXIT.                    
      *                                                                         
           IF WS-CAPITAL-FLAG = 'Y'                                     
              MULTIPLY WS-CALC-AMT BY TR-TAX-RATE                       
                       GIVING WS-CALC-CAPITAL ROUNDED                   
              MOVE 'N' TO WS-CAPITAL-FLAG                               
           END-IF.                                                      
      *                                                                         
A03967     IF WS-CHECK-RATEB = '77' OR '79' OR '76' OR '75'             
              MOVE WS-FIFTY-TWO   TO WS-CNTRL-NO                        
           ELSE                                                         
              MOVE WS-FIFTY-THREE TO WS-CNTRL-NO                        
           END-IF.                                                      
      *                                                                         
           PERFORM 2250-RETRIEVE-PCT THRU 2250-EXIT.                    
      *                                                                         
           IF WS-TRANSP-FLAG = 'Y'                                      
              MULTIPLY WS-CALC-AMT BY TR-TAX-RATE                       
                       GIVING WS-CALC-TRANSP ROUNDED                    
              MOVE 'N' TO WS-TRANSP-FLAG                                
           END-IF.                                                      
      *                                                                         
A03967     IF WS-CHECK-RATEB = '77' OR '79' OR '76' OR '75'             
              MOVE WS-SIXTY-TWO   TO WS-CNTRL-NO                        
           ELSE                                                         
              MOVE WS-SIXTY-THREE TO WS-CNTRL-NO                        
           END-IF.                                                      
      *                                                                         
           PERFORM 2250-RETRIEVE-PCT THRU 2250-EXIT.                    
      *                                                                         
           IF WS-EDUCATION-FLAG = 'Y'                                   
              MULTIPLY WS-CALC-AMT BY TR-TAX-RATE                       
                       GIVING WS-CALC-EDUCATION ROUNDED                 
              MOVE 'N' TO WS-EDUCATION-FLAG                             
           END-IF.                                                      
      *                                                                         
A03967     MOVE WS-CALC-SALES TO  WS-PRT2-TAX.                          
      *                                                                         
           COMPUTE WS-HONK-SALES-TAX = WS-CALC-SALES -                  
             (WS-CALC-LOST + WS-CALC-CAPITAL + WS-CALC-TRANSP +         
                WS-CALC-EDUCATION).                                     
      *                                                                         
           MOVE WS-HONK-SALES-TAX TO WS-CALC-SALES.                     
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * IF TYPE SERVICE IS 1 POPULATES THE OUTPUT FILE FOR ELECTRIC  *          
      ****************************************************************          
      *                                                                         
       2200-PROC-ELEC-RECORDS.                                          
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-SALES)        
           MOVE RV-REV-COMPANY-NO        TO WS-COMPANY.                 
           MOVE WS-ELEC-SALES-GL-X       TO WS-ACCT-NO.                 
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATE THE OUTPUT FILE FOR LOCAL OPTION SALES TAX          *          
      ****************************************************************          
      *                                                                         
       2201-PROC-LOST-RECORDS.                                          
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-LOST)         
           MOVE RV-REV-COMPANY-NO TO WS-COMPANY.                        
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATE THE OUTPUT FILE FOR CAPITAL TAX                     *          
      ****************************************************************          
      *                                                                         
       2202-PROC-CAPITAL-RECORDS.                                       
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-CAPITAL)      
           MOVE RV-REV-COMPANY-NO TO WS-COMPANY.                        
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATE THE OUTPUT FILE FOR TRANSPORTATION TAX              *          
      ****************************************************************          
      *                                                                         
       2203-PROC-TRANSP-RECORDS.                                        
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-TRANSP)       
           MOVE RV-REV-COMPANY-NO TO WS-COMPANY.                        
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2203-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATE THE OUTPUT FILE FOR TRANSPORTATION TAX              *          
      ****************************************************************          
      *                                                                         
       2204-PROC-EDUCATION-RECORDS.                                     
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-EDUCATION)    
           MOVE RV-REV-COMPANY-NO TO WS-COMPANY.                        
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2204-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATE THE OUTPUT FILE FOR OFFSET AMOUNT                   *          
      ****************************************************************          
      *                                                                         
       2205-DO184-RECORD.                                               
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-SAVE-AMOUNT)       
           MOVE '01' TO WS-COMPANY.                                     
           MOVE 'Y'  TO WS-A184-SW.                                     
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * RETRIEVES PERCENTAGES FOR EACH TAX TYPE BY COUNTY (REV DIST) *          
      ****************************************************************          
      *                                                                         
       2250-RETRIEVE-PCT.                                               
      *                                                                         
            EXEC SQL                                                    
               SELECT TAX_RATE                                          
                 INTO :TR-TAX-RATE                                      
                 FROM CSS_TAX_RATE TR WITH(READUNCOMMITTED)                     
                WHERE TR.TAX_CNTRL_NO  = :WS-CNTRL-NO                   
                  AND TR.DETAIL_ID = :WS-DETAIL-ID                      
                  AND TR.DATE_FROM < IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                   
                  AND TR.DATE_TO   > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                   
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT TAX_RATE                                                  
MFA-TR*          INTO :TR-TAX-RATE                                              
MFA-TR*          FROM CSS_TAX_RATE TR                                           
MFA-TR*         WHERE TR.TAX_CNTRL_NO  = :WS-CNTRL-NO                           
MFA-TR*           AND TR.DETAIL_ID = :WS-DETAIL-ID                              
MFA-TR*           AND TR.DATE_FROM < :WS-CURRENT-DATE                           
MFA-TR*           AND TR.DATE_TO   > :WS-CURRENT-DATE                           
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE WS-CNTRL-NO                                      
                 WHEN WS-TEN                                            
                      MOVE 'Y' TO WS-SALES-TAX-FLAG                     
                 WHEN WS-THIRTY-TWO                                     
                      MOVE 'Y' TO WS-LOCAL-OPTION-FLAG                  
                 WHEN WS-THIRTY-THREE                                   
                      MOVE 'Y' TO WS-LOCAL-OPTION-FLAG                  
                 WHEN WS-FORTY-TWO                                      
                      MOVE 'Y' TO WS-CAPITAL-FLAG                       
                 WHEN WS-FORTY-THREE                                    
                      MOVE 'Y' TO WS-CAPITAL-FLAG                       
                 WHEN WS-FIFTY-TWO                                      
                      MOVE 'Y' TO WS-TRANSP-FLAG                        
                 WHEN WS-FIFTY-THREE                                    
                      MOVE 'Y' TO WS-TRANSP-FLAG                        
                 WHEN WS-SIXTY-TWO                                      
                      MOVE 'Y' TO WS-EDUCATION-FLAG                     
                 WHEN WS-SIXTY-THREE                                    
                      MOVE 'Y' TO WS-EDUCATION-FLAG                     
              END-EVALUATE                                              
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 EVALUATE WS-CNTRL-NO                                   
                    WHEN WS-TEN                                         
                       MOVE 'N' TO WS-SALES-TAX-FLAG                    
                    WHEN WS-THIRTY-TWO                                  
                       MOVE 'N' TO WS-LOCAL-OPTION-FLAG                 
                    WHEN WS-THIRTY-THREE                                
                       MOVE 'N' TO WS-LOCAL-OPTION-FLAG                 
                    WHEN WS-FORTY-TWO                                   
                       MOVE 'N' TO WS-CAPITAL-FLAG                      
                    WHEN WS-FORTY-THREE                                 
                       MOVE 'N' TO WS-CAPITAL-FLAG                      
                    WHEN WS-FIFTY-TWO                                   
                       MOVE 'N' TO WS-TRANSP-FLAG                       
                    WHEN WS-FIFTY-THREE                                 
                       MOVE 'N' TO WS-TRANSP-FLAG                       
                    WHEN WS-SIXTY-TWO                                   
                       MOVE 'N' TO WS-EDUCATION-FLAG                    
                    WHEN WS-SIXTY-THREE                                 
                       MOVE 'N' TO WS-EDUCATION-FLAG                    
                 END-EVALUATE                                           
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '**  PCSCA626 PROCESSING ERROR          **'    
                 DISPLAY '**  PARA 2250-RETRIEVE-PCT             **'    
                 DISPLAY '**  RETURN CODE  =' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  ACCOUNT NO   =' RV-ACCOUNT-NO             
                 DISPLAY '**  REVENUE DIST =' RV-REV-DISTRICT-CD        
                 DISPLAY '**  TAX CNTRL NO =' WS-CNTRL-NO               
                 DISPLAY '**  DATE FROM    =' WS-CURRENT-DATE           
                 DISPLAY '**  DATE TO      =' WS-CURRENT-DATE           
                 DISPLAY '*****************************************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * IF TYPE SERVICE IS 2 POPULATES THE OUTPUT FILE FOR GAS       *          
      ****************************************************************          
      *                                                                         
       2300-PROC-GAS-RECORDS.                                           
      *                                                                         
           COMPUTE WS-8300-CONTROL-AMOUNT = -1 * (WS-CALC-SALES).       
           MOVE RV-REV-COMPANY-NO  TO WS-COMPANY.                       
      *                                                                         
           MOVE WS-GAS-SALES-GL-X  TO WS-ACCT-NO.                       
      *                                                                         
           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT.               
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * POPULATES THE OUTPUT FILE                                    *          
      ****************************************************************          
      *                                                                         
       2400-POPULATE-8300-REC.                                          
      *                                                                         
           INITIALIZE ZIKRT8300.                                        
      *                                                                         
           PERFORM 2450-FRMT-8300-KEY THRU 2450-EXIT.                   
      *                                                                         
           MOVE WS-SOURCE-SYSTEM        TO ZIKRT8300-SOURCE-SYSTEM.     
      *                                                                         
           IF WS-A184-SW = 'Y'                                          
              MOVE SPACES               TO ZIKRT8300-DOCUMENT-NUMBER    
              MOVE WS-SYSTEM-CODE       TO ZIKRT8300-SYSTEM-CODE        
              MOVE WS-LOCOFF-02         TO ZIKRT8300-LOCAL-OFFICE       
              MOVE ZEROS                TO ZIKRT8300-LOC-OPT-TAX-PCT    
           ELSE                                                         
              MOVE WS-TAX               TO ZIKRT8300-DOCUMENT-NUMBER    
              MOVE RV-LOCAL-OFFICE(1:1) TO ZIKRT8300-SYSTEM-CODE        
              MOVE RV-LOCAL-OFFICE(2:2) TO ZIKRT8300-LOCAL-OFFICE       
              MOVE WS-LOC-OPT-TAX-PCT   TO ZIKRT8300-LOC-OPT-TAX-PCT    
           END-IF.                                                      
      *                                                                         
           MOVE WS-8300-CONTROL-AMOUNT   TO ZIKRT8300-CONTROL-AMOUNT.   
           MOVE WS-LAST-CALENDAR-DATE    TO ZIKRT8300-EFFECTIVE-DATE.   
           MOVE WS-COMPANY               TO ZIKRT8300-COMPANY-CODE.     
           MOVE WS-ACCT-NO               TO ZIKRT8300-ACCOUNT-NUMBER.   
           MOVE WS-COST-CENTER           TO ZIKRT8300-COST-CENTER.      
           MOVE WS-COST-CENTER  TO ZIKRT8300-EG-ADMIN-COST-CENTER.      
           MOVE WS-FUNCTION-CODE         TO ZIKRT8300-FUNCTION-CODE.    
           MOVE WS-NOE                   TO ZIKRT8300-NOE-2.            
           MOVE WS-TRN-CODE              TO ZIKRT8300-TRANSACTION-CODE. 
      *                                                                         
A04527     IF WS-COMPANY = '26'                                         
A04527        MOVE WS-PSNC-OPERUNIT TO ZIKRT8300-OPERATING-UNIT         
A04527        MOVE WS-PSNC-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT          
A04527     ELSE                                                         
A04527        MOVE WS-SCEG-OPERUNIT TO ZIKRT8300-OPERATING-UNIT         
A04527        MOVE WS-SCEG-BUSIUNIT TO ZIKRT8300-BUSINESS-UNIT          
A04527     END-IF.                                                      
      *                                                                         
           IF  WS-LOCATION-SW = 'Y'                                     
               MOVE RV-MNICPLTY-COUNTY-CD TO ZIKRT8300-LOCATION         
           END-IF.                                                      
      *                                                                         
           PERFORM 2900-WRITE-8300-REC THRU 2900-EXIT.                  
           MOVE 'N' TO WS-LOCATION-SW.                                  
      *                                                                         
           ADD WS-8300-CONTROL-AMOUNT TO WS-SAVE-AMOUNT.                
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FORMATS THE OUTPUT RECORDS                                   *          
      ****************************************************************          
      *                                                                         
       2450-FRMT-8300-KEY.                                              
      *                                                                         
           MOVE ZEROS TO ZIKRT8300-STATUS-CODE                          
                         ZIKRT8300-SOURCE-SYSTEM                        
                         ZIKRT8300-BATCH-NUMBER                         
                         ZIKRT8300-BATCH-DATE                           
                         ZIKRT8300-RECORD-CONTROL-KEY.                  
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS SUMMARY RRPORT                                       *          
      ****************************************************************          
      *                                                                         
       2500-PRINT-ELEC-GAS-LINE.                                        
      *                                                                         
           IF  WS-FIRST-PRINT-RECORD = 'Y'                              
               PERFORM 2700-HEAD-PARA THRU 2700-EXIT                    
               PERFORM 2750-WRITE-COL-HDNG THRU 2750-EXIT               
               MOVE 'N'  TO WS-FIRST-PRINT-RECORD                       
           END-IF.                                                      
      *                                                                         
           IF  WS-LINE-CNTR  > WS-FIFTY-SIX                             
               PERFORM 2700-HEAD-PARA THRU 2700-EXIT                    
               PERFORM 2750-WRITE-COL-HDNG THRU 2750-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE RV-MNICPLTY-COUNTY-CD TO PRT-LOCATION.                  
           ADD WS-ONE TO WS-REP-WRITE.                                  
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * LOCATION BREAK                                               *          
      ****************************************************************          
      *                                                                         
       2600-LOC-CODE-BREAK.                                             
      *                                                                         
           MOVE WS-PREV-REV-DIST        TO PRT-REV-DIST.                
      *                                                                         
           MOVE WS-LOC-USE              TO PRT-USE.                     
      *                                                                         
           MOVE WS-LOC-AMOUNT           TO PRT-AMOUNT.                  
      *                                                                         
           MOVE WS-LOC-SALES-TAX        TO PRT-SALES-TAX.               
           MOVE WS-LOC-LOST-TAX         TO PRT-LOST-TAX.                
           MOVE WS-LOC-CAPITAL-TAX      TO PRT-CAPITAL-TAX.             
           MOVE WS-LOC-TRANSP-TAX       TO PRT-TRANSP-TAX.              
           MOVE WS-LOC-EDUCATION-TAX    TO PRT-EDUCATION-TAX.           
      *                                                                         
           MOVE PRT-DETAIL-LINE         TO RPT-LINE.                    
           MOVE WS-TWO                  TO WS-LINE-SPACE.               
           ADD  WS-TWO                  TO WS-LINE-CNTR.                
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           MOVE SPACES TO PRT-DETAIL-LINE.                              
           MOVE RV-MNICPLTY-COUNTY-CD   TO WS-PREV-LOC-CODE.            
           MOVE RV-REV-DISTRICT-CD      TO WS-PREV-REV-DIST.            
           MOVE RV-LOCAL-OFFICE         TO WS-PREV-LOCAL-OFFICE.        
      *                                                                         
           MOVE ZEROS                   TO WS-LOC-USE.                  
      *                                                                         
           MOVE ZEROS                   TO WS-LOC-AMOUNT.               
      *                                                                         
           MOVE ZEROS                   TO WS-LOC-SALES-TAX             
                                           WS-LOC-LOST-TAX              
                                           WS-LOC-CAPITAL-TAX           
                                           WS-LOC-TRANSP-TAX            
                                           WS-LOC-EDUCATION-TAX.        
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTALS BY TYPE-SERVICE WHENEVER THE BREAK OCCURS  *          
      ****************************************************************          
      *                                                                         
       2650-TYPE-SERV-BREAK.                                            
      *                                                                         
           IF  WS-PREV-TYPE-SERV = 'E'                                  
               MOVE 'ELE'            TO PRT-TOT-TYPE                    
               MOVE 'TOTALS :'       TO PRT-TOT-LITERAL                 
               MOVE RV-CODE-SERVICE-TYPE    TO WS-PREV-TYPE-SERV        
           ELSE                                                         
               MOVE 'GAS'            TO PRT-TOT-TYPE                    
               MOVE 'TOTALS :'       TO PRT-TOT-LITERAL                 
               MOVE RV-CODE-SERVICE-TYPE    TO WS-PREV-TYPE-SERV        
           END-IF.                                                      
      *                                                                         
           MOVE WS-TOT-USE           TO PRT-USE.                        
      *                                                                         
           MOVE WS-TOT-AMOUNT        TO PRT-AMOUNT.                     
      *                                                                         
           MOVE WS-TOT-SALES-TAX     TO PRT-SALES-TAX.                  
           MOVE WS-TOT-LOST-TAX      TO PRT-LOST-TAX.                   
           MOVE WS-TOT-CAPITAL-TAX   TO PRT-CAPITAL-TAX.                
           MOVE WS-TOT-TRANSP-TAX    TO PRT-TRANSP-TAX.                 
           MOVE WS-TOT-EDUCATION-TAX TO PRT-EDUCATION-TAX.              
      *                                                                         
           MOVE WS-FIFTY-SEVEN       TO WS-LINE-CNTR.                   
      *                                                                         
           MOVE ZEROS                TO WS-TOT-USE.                     
      *                                                                         
           MOVE ZEROS                TO WS-TOT-AMOUNT.                  
      *                                                                         
           MOVE ZEROS                TO WS-TOT-SALES-TAX                
                                        WS-TOT-LOST-TAX                 
                                        WS-TOT-CAPITAL-TAX              
                                        WS-TOT-TRANSP-TAX               
                                        WS-TOT-EDUCATION-TAX.           
      *                                                                         
           MOVE PRT-DETAIL-LINE      TO RPT-LINE.                       
           MOVE WS-TWO               TO WS-LINE-SPACE.                  
           ADD  WS-TWO               TO WS-LINE-CNTR.                   
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           MOVE SPACES TO PRT-DETAIL-LINE.                              
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINTS THE TOTALS BY COMPANY WHENEVER THE BREAK OCCURS       *          
      ****************************************************************          
      *                                                                         
       2675-COMP-BREAK.                                                 
      *                                                                         
           MOVE 'COM'            TO PRT-TOT-TYPE.                       
           MOVE 'TOTALS :'       TO PRT-TOT-LITERAL.                    
      *                                                                         
           MOVE RV-REV-COMPANY-NO    TO WS-PREV-COMPANY.                
      *                                                                         
      *    MOVE WS-CO-USE            TO PRT-USE.                                
      *                                                                         
      *    MOVE WS-CO-AMOUNT         TO PRT-AMOUNT.                             
      *                                                                         
           MOVE WS-CO-SALES-TAX      TO PRT-SALES-TAX.                  
           MOVE WS-CO-LOST-TAX       TO PRT-LOST-TAX.                   
           MOVE WS-CO-CAPITAL-TAX    TO PRT-CAPITAL-TAX.                
           MOVE WS-CO-TRANSP-TAX     TO PRT-TRANSP-TAX.                 
           MOVE WS-CO-EDUCATION-TAX  TO PRT-EDUCATION-TAX.              
      *                                                                         
           MOVE ZEROS                TO WS-TOT-USE.                     
      *                                                                         
           MOVE ZEROS                TO WS-TOT-AMOUNT.                  
      *                                                                         
           MOVE ZEROS                TO WS-TOT-SALES-TAX                
                                        WS-TOT-LOST-TAX                 
                                        WS-TOT-CAPITAL-TAX              
                                        WS-TOT-TRANSP-TAX               
                                        WS-TOT-EDUCATION-TAX.           
      *                                                                         
           MOVE ZEROS                TO WS-CO-USE.                      
      *                                                                         
           MOVE ZEROS                TO WS-CO-AMOUNT.                   
      *                                                                         
           MOVE ZEROS                TO WS-CO-SALES-TAX                 
                                        WS-CO-LOST-TAX                  
                                        WS-CO-CAPITAL-TAX               
                                        WS-CO-TRANSP-TAX                
                                        WS-CO-EDUCATION-TAX.            
      *                                                                         
           MOVE PRT-DETAIL-LINE       TO RPT-LINE.                      
           MOVE WS-TWO                TO WS-LINE-SPACE.                 
           ADD  WS-TWO                TO WS-LINE-CNTR.                  
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           MOVE SPACES TO PRT-DETAIL-LINE.                              
      *                                                                         
       2675-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  PRINTS THE PAGE HEADINGS AT THE TOP OF EACH PAGE            *          
      ****************************************************************          
      *                                                                         
       2700-HEAD-PARA.                                                  
           MOVE 0                        TO WS-LINE-CNTR.               
           ADD WS-ONE                    TO WS-PAGE.                    
           MOVE WS-PAGE                  TO WS-DET-PAGE.                
           MOVE HEADER-ONE               TO RPT-LINE.                   
           WRITE FS-PRINT-REC AFTER ADVANCING PAGE.                     
           MOVE HEADER-TWO               TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           ADD  WS-TWO                   TO WS-LINE-CNTR.               
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES THE COLUMN HEADINGS AT THE TOP OF EACH PAGE           *          
      ****************************************************************          
      *                                                                         
       2750-WRITE-COL-HDNG.                                             
      *                                                                         
           IF  WS-PREV-TYPE-SERV = 'E'                                  
               MOVE 'ELECTRIC'           TO WS-RPT-SERV                 
               MOVE WS-ELEC-SALES-GL     TO WS-SALES-GL                 
               MOVE WS-ELEC-LOST-GL      TO WS-LOST-GL                  
               MOVE WS-ELEC-CAPITAL-GL   TO WS-CAPITAL-GL               
               MOVE WS-ELEC-TRANSP-GL    TO WS-TRANSP-GL                
               MOVE WS-ELEC-EDUCATION-GL TO WS-EDUCATION-GL             
           ELSE                                                         
               MOVE 'GAS'                TO WS-RPT-SERV                 
               MOVE WS-GAS-SALES-GL      TO WS-SALES-GL                 
               MOVE WS-GAS-LOST-GL       TO WS-LOST-GL                  
               MOVE WS-GAS-CAPITAL-GL    TO WS-CAPITAL-GL               
               MOVE WS-GAS-TRANSP-GL     TO WS-TRANSP-GL                
               MOVE WS-GAS-EDUCATION-GL  TO WS-EDUCATION-GL             
           END-IF.                                                      
      *                                                                         
           MOVE HEADER-THREE             TO RPT-LINE.                   
           MOVE WS-TWO                   TO WS-LINE-SPACE.              
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           ADD WS-TWO                    TO WS-LINE-CNTR.               
      *                                                                         
           MOVE HEADER-FOUR              TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           ADD WS-ONE                    TO WS-LINE-CNTR.               
           MOVE HEADER-FIVE              TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           ADD WS-ONE                    TO WS-LINE-CNTR.               
           MOVE 'Y'                      TO WS-FIRST-REC-WRITE.         
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  HEADERS FOR DETAIL ACCOUNT REPORT - PRINTER2.               *          
      ****************************************************************          
      *                                                                         
       2775-PRINTER2-HEADERS.                                           
      *                                                                         
           MOVE 0                        TO WS-LINE-CNTR2.              
           ADD WS-ONE                    TO WS-PAGE2.                   
           MOVE WS-PAGE2                 TO WS-DET-PAGE2.               
           MOVE HEADER-ONE-2             TO RPT2-LINE.                  
           WRITE FS-PRINT2-REC AFTER ADVANCING PAGE.                    
           MOVE HEADER-TWO-2             TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE HEADER-THREE-2           TO RPT2-LINE.                  
           MOVE WS-TWO                   TO WS-LINE-SPACE2.             
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE HEADER-FOUR-2            TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE WS-SIX                   TO WS-LINE-CNTR2.              
      *                                                                         
       2775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * IF THE END OF INPUT FILE IS REACHED THEN PRINTS THE GRAND    *          
      * TOTALS AS WELL AS GIVES THE STATISTICS SUCH AS TOTAL RECORDS *          
      * READ, TOTAL RECORDS SKIPPED AND TOTAL RECORDS WRITTEN        *          
      ****************************************************************          
      *                                                                         
       2800-SUMM-REPORT.                                                
      *                                                                         
           MOVE 'GRD'                  TO PRT-TOT-TYPE.                 
           MOVE 'TOTALS :'             TO PRT-TOT-LITERAL.              
      *                                                                         
      *    MOVE WS-GRAND-USE           TO PRT-USE.                              
      *                                                                         
      *    MOVE WS-GRAND-AMOUNT        TO PRT-AMOUNT.                           
      *                                                                         
           MOVE WS-GRAND-SALES-TAX     TO PRT-SALES-TAX.                
           MOVE WS-GRAND-LOST-TAX      TO PRT-LOST-TAX.                 
           MOVE WS-GRAND-CAPITAL-TAX   TO PRT-CAPITAL-TAX.              
           MOVE WS-GRAND-TRANSP-TAX    TO PRT-TRANSP-TAX.               
           MOVE WS-GRAND-EDUCATION-TAX TO PRT-EDUCATION-TAX.            
           MOVE PRT-DETAIL-LINE        TO RPT-LINE.                     
           MOVE WS-TWO                 TO WS-LINE-SPACE.                
      *                                                                         
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
           MOVE SPACES TO PRT-DETAIL-LINE.                              
      *                                                                         
           MOVE WS-TWO                   TO WS-LINE-SPACE.              
           MOVE WS-IN-REC-READ           TO WS-REC-READ.                
           MOVE WS-REP-ONE               TO RPT-LINE.                   
      *                                                                         
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
           MOVE WS-REC-SKIPPED           TO WS-REC-SKIP.                
           MOVE WS-REP-TWO               TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
      *                                                                         
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
           MOVE WS-REP-WRITE             TO WS-REP-WRITTEN.             
           MOVE WS-REP-THREE             TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
      *                                                                         
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
           MOVE WS-FOOT-LINE             TO RPT-LINE.                   
           MOVE WS-ONE                   TO WS-LINE-SPACE.              
      *                                                                         
           PERFORM 2850-WRITE-PRINT-REC THRU 2850-EXIT.                 
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES REPORT LINE FOR THE SUMMARY                           *          
      ****************************************************************          
      *                                                                         
       2850-WRITE-PRINT-REC.                                            
      *                                                                         
           WRITE FS-PRINT-REC AFTER ADVANCING WS-LINE-SPACE.            
      *                                                                         
       2850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES A REPORT LINE FOR THE DETAIL ACCOUNT REPORT           *          
      ****************************************************************          
      *                                                                         
       2875-WRITE-PRINTER2.                                             
      *                                                                         
           WRITE FS-PRINT2-REC AFTER ADVANCING WS-LINE-SPACE2.          
      *                                                                         
       2875-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITES EACH RECORD OF THE INPUT FILE TO THE OUTPUT FILE. IF  *          
      * IF WS-CALC-LOST NOT = ZEROS IT AGAIN WRITES THE              *          
      * RECORD WITH RV-MNICPLTY-COUNTY-CD.                                    * 
      ****************************************************************          
      *                                                                         
       2900-WRITE-8300-REC.                                             
      *                                                                         
           MOVE ZIKRT8300 TO MRSCRR03-REC.                              
           WRITE MRSCRR03-REC.                                          
      *                                                                         
           IF  CRR03-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*** WRITE ERROR - 8300    ' WS-CRR03-STATUS     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * REPORT OF EACH ACCOUNT THAT WAS USED TO CREATE THE TAX       *          
      * REPORT.                                                      *          
      ****************************************************************          
      *                                                                         
       2950-ACCOUNT-LIST-REPORT.                                        
      *                                                                         
           IF  WS-LINE-CNTR2 > WS-FIFTY-SIX                             
               PERFORM 2775-PRINTER2-HEADERS THRU 2775-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE RV-ACCOUNT-NO     TO PRT2-ACCT-NBR.                     
           INSPECT PRT2-ACCT-NBR REPLACING ALL ' ' BY '-'.              
      *                                                                         
A03967     MOVE WS-PRT2-TAX           TO PRT2-TAX.                      
           MOVE RV-CODE-UTIL-TYPE     TO PRT2-TYPE-SERV.                
           MOVE RV-REV-DISTRICT-CD    TO PRT2-REV-DIST.                 
           MOVE RV-CODE-REVENUE-CLASS TO PRT2-CLASS.                    
           MOVE RV-RATE-PLAN-NO       TO PRT2-RATE.                     
           MOVE WS-NBR-MTRS           TO PRT2-MTRS.                     
           MOVE RB-READ-UNITS   TO PRT2-KWH-CCF.                        
           MOVE RB-BILLED-AMT         TO PRT2-AMT.                      
           MOVE RV-MNICPLTY-COUNTY-CD TO PRT2-LOCATION.                 
           MOVE RV-LOCAL-OFFICE       TO PRT2-LOCAL-OFFICE.             
           MOVE PRT2-DETAIL-LINE      TO RPT2-LINE.                     
           MOVE WS-ONE                TO WS-LINE-SPACE2.                
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE SPACES TO PRT2-DETAIL-LINE.                             
           ADD WS-ONE  TO WS-LINE-CNTR2.                                
      *                                                                         
           IF RV-CODE-SERVICE-TYPE = 'E'                                
              ADD WS-NBR-MTRS TO WS-TOT-ELEC-MTRS                       
           END-IF.                                                      
      *                                                                         
           IF RV-CODE-SERVICE-TYPE = 'G'                                
              ADD WS-NBR-MTRS TO WS-TOT-GAS-MTRS                        
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * AT END OF JOB, PRINT THE TOTAL NUMBER OF ELECTRIC METERS     *          
      * AND GAS METERS FROM THE INPUT FILE                           *          
      ****************************************************************          
      *                                                                         
       2955-SUMM-ACCT-REPORT.                                           
      *                                                                         
           IF  WS-LINE-CNTR2 > WS-FIFTY-SIX                             
               PERFORM 2775-PRINTER2-HEADERS THRU 2775-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE WS-TOT-ELEC-MTRS    TO PRT-ELEC-MTRS-READ.              
           MOVE WS-TOT-GAS-MTRS     TO PRT-GAS-MTRS-READ.               
      *                                                                         
           MOVE PRT-RPT2-ELEC-TOTAL TO RPT2-LINE.                       
           MOVE WS-TWO              TO WS-LINE-SPACE2.                  
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE SPACES TO PRT2-DETAIL-LINE.                             
      *                                                                         
           MOVE PRT-RPT2-GAS-TOTAL  TO RPT2-LINE.                       
           MOVE WS-TWO              TO WS-LINE-SPACE2.                  
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE SPACES TO PRT2-DETAIL-LINE.                             
      *                                                                         
           MOVE WS-FOOT-LINE     TO RPT2-LINE.                          
           MOVE WS-TWO           TO WS-LINE-SPACE2.                     
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE SPACES TO PRT2-DETAIL-LINE.                             
      *                                                                         
       2955-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT THE PARM FACTORS USED IN THE CALCULATIONS.             *          
      ****************************************************************          
      *                                                                         
       2987-PRINT-FACTORS.                                              
      *                                                                         
           IF  WS-LINE-CNTR2 > WS-FIFTY-SIX                             
               PERFORM 2775-PRINTER2-HEADERS THRU 2775-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE 'REVENUE MONTH     '     TO PRT2-LITERAL.               
           MOVE WS-REVENUE-MTH           TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-TWO                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
A03967     MOVE 'RATE 075 FACTOR = '     TO PRT2-LITERAL.               
A03967     MOVE WS-SAVE-RATE075          TO PRT2-FACTOR.                
A03967     MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
A03967     MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
A03967     PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
           MOVE 'RATE 076 FACTOR = '     TO PRT2-LITERAL.               
           MOVE WS-SAVE-RATE076          TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
           MOVE 'RATE 077 FACTOR = '     TO PRT2-LITERAL.               
           MOVE WS-SAVE-RATE077          TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
           MOVE 'RATE 078 FACTOR = '     TO PRT2-LITERAL.               
           MOVE WS-SAVE-RATE078          TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
           MOVE 'RATE 78B FACTOR = '     TO PRT2-LITERAL.               
           MOVE WS-SAVE-RATE78B          TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
           MOVE 'RATE 079 FACTOR = '     TO PRT2-LITERAL.               
           MOVE WS-SAVE-RATE079          TO PRT2-FACTOR.                
           MOVE PRT2-RATE-FACTOR-LINE    TO RPT2-LINE.                  
           MOVE WS-ONE                   TO WS-LINE-SPACE2.             
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
           MOVE SPACES TO RPT2-LINE.                                    
      *                                                                         
           PERFORM 2875-WRITE-PRINTER2 THRU 2875-EXIT.                  
      *                                                                         
A03967*    ADD WS-SEVEN TO WS-LINE-CNTR2.                                       
A03967     ADD WS-EIGHT TO WS-LINE-CNTR2.                               
      *                                                                         
       2987-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE FACTORS FOR RATES O76, 077, 078 AND 079 TO USE TO *          
      *    MULTIPLY BY THE USE TO GET THE PRE-TAXED BILLED AMOUNT    *          
      *    FOR DEADHEAD ACCOUNTS.                                    *          
      ****************************************************************          
      *                                                                         
       4400-GET-KWH-CCF-FACTORS.                                        
      *                                                                         
      *  GET RATE 076                                                           
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'RATE076=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA626                         **'        
              DISPLAY '**  4400-GET-KWH-CCF-FACTORS          **'        
              DISPLAY '**  ERROR RETRIEVING THE RATE FACTORS **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-RATE-FACTORS                 
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 4500-PACK-RATE-FACTORS THRU 4500-EXIT.               
      *                                                                         
      *  GET RATE 077 AND RATE 079                                              
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'RATE077=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA626                         **'        
              DISPLAY '**  4400-GET-KWH-CCF-FACTORS          **'        
              DISPLAY '**  ERROR RETRIEVING THE RATE FACTORS **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-RATE-FACTORS                 
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 4500-PACK-RATE-FACTORS THRU 4500-EXIT.               
      *                                                                         
      *  GET RATE 078 AND RATE 78B                                              
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'RATE078=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA626                         **'        
              DISPLAY '**  4400-GET-KWH-CCF-FACTORS          **'        
              DISPLAY '**  ERROR RETRIEVING THE RATE FACTORS **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-RATE-FACTORS                 
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 4500-PACK-RATE-FACTORS THRU 4500-EXIT.               
      *                                                                         
       4400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET THE MONTH PRIOR TO REVENUE MONTH FOUND ON PCSCA204    *          
      ****************************************************************          
      *                                                                         
       4444-ONE-MONTH-BACK.                                             
      *                                                                         
           DISPLAY 'PCSCA204 REVENUE MONTH = ' WS-REVENUE-MONTH.        
           IF WS-REVENUE-MM = 01                                        
              SUBTRACT 1 FROM WS-REVENUE-YEAR                           
              MOVE 12 TO WS-REVENUE-MM                                  
           ELSE                                                         
              SUBTRACT 1 FROM WS-REVENUE-MM                             
           END-IF.                                                      
      *                                                                         
           DISPLAY 'REVENUE MONTH USED = ' WS-REVENUE-MONTH.            
      *                                                                         
       4444-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    PACK THE RATE FACTORS FOR USE IN CALCULATING THE          *          
      *    PRE-TAXED BILL AMOUNT.                                    *          
      ****************************************************************          
      *                                                                         
       4500-PACK-RATE-FACTORS.                                          
      *                                                                         
           IF WS-PARM-RATE1ST-LITERAL = 'RATE076='                      
              MOVE WS-PARM-1STA  TO WS-FACTOR-AN (1:1)                  
                                    WS-SAVE-RATE076A                    
              MOVE WS-PARM-1STB  TO WS-FACTOR-AN (2:6)                  
                                    WS-SAVE-RATE076B                    
              MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE076-FACTOR         
      *                                                                         
A03967        MOVE WS-PARM-1STA  TO WS-FACTOR-AN (1:1)                  
A03967                              WS-SAVE-RATE075A                    
A03967        MOVE WS-PARM-1STB  TO WS-FACTOR-AN (2:6)                  
A03967                              WS-SAVE-RATE075B                    
A03967        MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE075-FACTOR         
           END-IF.                                                      
      *                                                                         
           IF WS-PARM-RATE1ST-LITERAL = 'RATE077='                      
              MOVE WS-PARM-1STA  TO WS-FACTOR-AN (1:1)                  
                                    WS-SAVE-RATE077A                    
              MOVE WS-PARM-1STB  TO WS-FACTOR-AN (2:6)                  
                                    WS-SAVE-RATE077B                    
              MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE077-FACTOR         
              MOVE WS-PARM-2NDA  TO WS-FACTOR-AN (1:1)                  
                                    WS-SAVE-RATE079A                    
              MOVE WS-PARM-2NDB  TO WS-FACTOR-AN (2:6)                  
                                    WS-SAVE-RATE079B                    
              MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE079-FACTOR         
           END-IF.                                                      
      *                                                                         
           IF WS-PARM-RATE1ST-LITERAL = 'RATE078='                      
              MOVE WS-PARM-1STA  TO WS-FACTOR-AN (1:1)                  
                                    WS-SAVE-RATE078A                    
              MOVE WS-PARM-1STB  TO WS-FACTOR-AN (2:6)                  
                                    WS-SAVE-RATE078B                    
              MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE078-FACTOR         
              MOVE WS-PARM-2NDA  TO WS-FACTOR-AN (1:1)                  
                                    WS-SAVE-RATE78BA                    
              MOVE WS-PARM-2NDB  TO WS-FACTOR-AN (2:6)                  
                                    WS-SAVE-RATE78BB                    
              MULTIPLY WS-FACTOR BY +1 GIVING WS-RATE78B-FACTOR         
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    CALCULATE THE PRE-TAXED MONEY AMOUNT FOR THE ACCOUNT      *          
      ****************************************************************          
      *                                                                         
       4600-CALCULATE-AMOUNT.                                           
      *                                                                         
A03082     IF RB-CONSUMPT-TYPE-CD = 'D'                                 
A03082        COMPUTE RB-READ-UNITS = RB-READ-UNITS * 10                
A03082     END-IF.                                                      
      *                                                                         
           IF WS-CHECK-RATEB = '77'                                     
              MULTIPLY RB-READ-UNITS BY WS-RATE077-FACTOR               
                               GIVING WS-CALC-AMT                       
           ELSE                                                         
             IF WS-CHECK-RATEB = '78'                                   
                MULTIPLY RB-READ-UNITS BY WS-RATE078-FACTOR             
                                 GIVING WS-CALC-AMT                     
             ELSE                                                       
               IF RV-RATE-PLAN-NO = '78B'                               
                  MULTIPLY RB-READ-UNITS BY WS-RATE78B-FACTOR           
                                   GIVING WS-CALC-AMT                   
               ELSE                                                     
                 IF WS-CHECK-RATEB = '79'                               
                    MULTIPLY RB-READ-UNITS BY WS-RATE079-FACTOR         
                                     GIVING WS-CALC-AMT                 
                 ELSE                                                   
                   IF WS-CHECK-RATEB = '76'                             
                      MULTIPLY RB-READ-UNITS                            
A03967                    BY WS-RATE076-FACTOR GIVING WS-CALC-AMT       
                   ELSE                                                 
A03967                IF WS-CHECK-RATEB = '75'                          
A03967                   MULTIPLY RB-READ-UNITS                         
A03967                       BY WS-RATE075-FACTOR GIVING WS-CALC-AMT    
                      ELSE                                              
                       DISPLAY '***********************************'    
                       DISPLAY '** PCSCA626                      **'    
                       DISPLAY '** 4600-CALCULATE-AMOUNTS        **'    
                       DISPLAY '** INVALID RATE - NOT A DEADHEAD **'    
                       DISPLAY '** ACCOUNT NO = ' RV-ACCOUNT-NO         
                       DISPLAY '** RV-RATE-PLAN-NO = ' RV-RATE-PLAN-NO  
                       DISPLAY '***********************************'    
                       DISPLAY ' '                                      
                      END-IF                                            
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-CALC-AMT TO RB-BILLED-AMT.                           
      *                                                                         
       4600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  OPENS GL-ACCT-CURSOR TO GET THE GL-ACCT-NO OF OTHER TAXES   *          
      ****************************************************************          
      *                                                                         
       7000-OPEN-GL-ACCT-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              OPEN GL-ACCT-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA626  ABORT ***************'     
               DISPLAY '* 7000-OPEN-GL-ACCT-CURSOR               *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA626  ABORT ***************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCHES THE TAX-CNTRL-NOS AND GL-ACCT-NOS FROM CSS_TAX_CNTL  *          
      *   AND CSS_SPCL_FCTR                                          *          
      ****************************************************************          
      *                                                                         
       7010-FETCH-GL-ACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH GL-ACCT-CURSOR                                      
               INTO  :TC-TAX-CNTRL-NO                                   
                    ,:SF-GL-ACCT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA626 ABORT ****************'     
               DISPLAY '* 7010-FETCH-GL-ACCT-CURSOR              *'     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                    *'     
               DISPLAY '********** PCSCA626 ABORT ****************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES THE GL-ACCT-CURSOR CURSOR                             *          
      ****************************************************************          
      *                                                                         
       7020-CLOSE-GL-ACCT-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE GL-ACCT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA626 ABORT ****************'     
               DISPLAY '**  7020-CLOSE-GL-ACCT-CURSOR           **'     
               DISPLAY '**  SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROGRAM ABORTING...                 **'     
               DISPLAY '********** PCSCA626 ABORT ****************'     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * GET CURRENT DATE                                             *          
      ****************************************************************          
      *                                                                         
       7200-GET-CURRENT-DATE.                                           
      *                                                                         
            EXEC SQL                                                    
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET  :WS-CURRENT-DATE  = CURRENT DATE                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**  7200-GET-CURRENT-DATE              **'      
               DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'      
               DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE         
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET REVENUE MONTH USING PCSCA204 JOB PARM                 **          
      ****************************************************************          
      *                                                                         
       7400-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  PARM_DATA                                        
                 INTO  :G6-PARM-DATA                                    
               FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  CMND_CODE    = :G6-CMND-CODE                       
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                AND  SEQ_NO       = :G6-SEQ-NO                          
                AND  STATUS       = :G6-STATUS                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  PARM_DATA                                                
MFA-TR*          INTO  :G6-PARM-DATA                                            
MFA-TR*        FROM  CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*         AND  SEQ_NO       = :G6-SEQ-NO                                  
MFA-TR*         AND  STATUS       = :G6-STATUS                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**ERROR RETRIEVING REVENUE MONTH       **'       
              DISPLAY '**   FROM JOB PARM - PCSCA204          **'       
              DISPLAY '**7400-GET-REVENUE-MONTH               **'       
              DISPLAY '**SQLCODE = ' WS-ACTIVE-RETURN-CODE              
              DISPLAY '**G6-PROGRAM-NAME = ' G6-PROGRAM-NAME            
              DISPLAY '**G6-CMND-CODE    = ' G6-CMND-CODE               
              DISPLAY '**G6-COMPANY-NO   = ' G6-COMPANY-NO              
              DISPLAY '**G6-SEQ-NO       = ' G6-SEQ-NO                  
              DISPLAY '**G6-STATUS       = ' G6-STATUS                  
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS REVENUE CURSOR                                **          
      ****************************************************************          
      *                                                                         
       7500-OPEN-REV-CURSOR.                                            
      *                                                                         
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN REV-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7500-OPEN-REV-CURSOR **'            
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED      **'            
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET DATE WITH THE LAST DAY OF THE CURRENT MONTH           **          
      ****************************************************************          
      *                                                                         
       7800-GET-LAST-DAY.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -1, DATEADD( MONTH, 2, 
              IIF(TRY_CONVERT(DATE, :WS-FIX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FIX-DATE
              ) <> 0) OR (LEN(:WS-FIX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-FIX-DATE
              ), CONVERT(DATE, :WS-FIX-DATE) ) ) )
            INTO
              :WS-FIX-DATE2                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-FIX-DATE2 =                                               
MFA-TR*            DATE(:WS-FIX-DATE) + 2 MONTH - 1 DAY                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ERROR RETRIEVING LAST DAY OF MONTH   **'      
              DISPLAY '** 7800-GET-LAST-DAY                    **'      
              DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE             
              DISPLAY '** WS-FIX-DATE2 ' WS-FIX-DATE2                   
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES REVENUE CURSOR                              **          
      ****************************************************************          
      *                                                                         
       7520-FETCH-REV-CURSOR.                                           
      *                                                                         
           MOVE '7520' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                FETCH REV-CURSOR                                        
                INTO  :RV-REV-COMPANY-NO                                
                     ,:RV-CODE-SERVICE-TYPE                             
                     ,:RV-MNICPLTY-COUNTY-CD                            
                     ,:RV-ACCOUNT-NO                                    
                     ,:RV-RATE-PLAN-NO                                  
                     ,:RV-CODE-UTIL-TYPE                                
                     ,:RV-REV-DISTRICT-CD                               
                     ,:RV-LOCAL-OFFICE                                  
                     ,:RV-CODE-REVENUE-CLASS                            
A03082               ,:RB-CONSUMPT-TYPE-CD                              
A03082               ,:RB-READ-UNITS                                    
                     ,:RB-BILLED-AMT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-NO-MORE-DATA                            
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7520-FETCH-REV-CURSOR **'        
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  RV-REV-COMPANY-NO = ' RV-REV-COMPANY-NO   
                 DISPLAY '**  RV-REVENUE-MONTH  = ' RV-REVENUE-MONTH    
                 DISPLAY '**  RV-BILL-UNIQUE-TS = ' RV-BILL-UNIQUE-TS   
                 DISPLAY '**  PROCESSING IS TERMINATED       **'        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES REVENUE CURSOR                               **          
      ****************************************************************          
      *                                                                         
       7530-CLOSE-REV-CURSOR.                                           
      *                                                                         
           MOVE '7530' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE REV-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7530-CLOSE-REV-CURSOR **'           
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED       **'           
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * NORMAL TERMINATION                                           *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE MRSCRR03-FILE                                          
                 PRINTER1                                               
                 PRINTER2.                                              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
