       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA625.                                        
       AUTHOR.         ROGER D FAULK                                    
       INSTALLTION.                                                     
       DATE-WRITTEN.   JUNE 2005.                                       
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      ********                   DB2                         *********          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  7/03/05   RF10596        DEVELOPMENT OF NEW PROGRAM TO    **          
      **                           UPDATE LONGITUDE AND LATTITUDE   **          
      **                           ON CSS_MTRD_ENVRNT.              **          
      **  04/10/06  NC94746        ADDED MORE EDIT CHECKS, RESTART  **          
      **                           LOGIC AND MADE LIVE IN PRODUCTION**          
T35434** 24-JAN-2008 MC95456       ADDED WITH UR TO THE CURSORS     **          
T35434**                           REPLACED CSS_MODEL_SQL WITH SET STMT         
T35434**                           REMOVED THE ABEND LOGIC WHEN THE **          
T35434**                           INPUT FILE IS EMPTY              **          
A37741** 17 NOV 2009 MS93554       DECLARED  S-RETURN-CODE          **          
      **                           RESPECTIVE TO CPD00067 CHANGES   **          
A37741** 19 NOV 2009 MS93554      ADDED 9000-SEND-ERROR-RESULT PARA **          
A03345** 01 JUL 2011 BD09555       ADDED LOGIC TO UPDATE ALL THE    **          
A03345**                           LAT/LONG FOR ALL METERS AND FOR  **          
A03345**                           THE PREMISE IF THE INPUT FILE    **          
A03345**                           CONTAINS ONLY THE PREMISE NUMBER.**          
A#5470**  11/10/16  SS95855        REMOVE LAT/LONG UPDATES FROM MN   **         
      ****************************************************************          
           REMARKS.                                                     
                              PCSCA625 NARRATIVE                        
           THIS PROGRAM IS TO POST LONGITUDE AND LATTITUDE TO           
             CSS_MTRD_ENVRNT.                                           
           AN EXCEPTION REPORT IS ALSO CREATED FOR:                     
           1.  EITHER LATITUDE OR LONGITUDE BEING BLANK OR ZERO         
                 WITH VALID FIELD IN THE OTHER.                         
           2.  LATITUDE OR LONGITUDE BEING OUTSIDE THE MAX/MIN RANGE    
               THE MAXIMUM / MINIMUM RANGE IS OBTAINED FROM THE         
               JOB PARM TABLE ENTRY FOR THIS PROGRAM.                   
           3.  IF THE ACCOUNT NUMBER AND METER NUMBER ARE SPACES,       
               ZEROS OR LOW-VALUES.                                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SPECIAL-NAMES.      C01 IS NEW-PAGE.                             
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
       COPY CSSCA625.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       COPY CFDCA625.                                                           
      *                                                                         
       COPY FIOCA625.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA625'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  PROGRAM-NAME                PIC X(8)    VALUE 'PCSCA625'.    
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                           PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-PRV-REMOTE-READ-IND  PIC X       VALUE SPACES.        
           05  WS-REMOTE-READ-IND      PIC X       VALUE SPACES.        
           05  WS-INSPT-CNTR           PIC 99      VALUE 0.             
           05  WS-WQ-SW                PIC X       VALUE SPACES.        
           05  WS-COMPARE-ACCT         PIC 9(13)   VALUE 0.             
           05  WS-ACTIVE-RETURN-CODE   PIC S9(9)   VALUE +0.            
           05  WS-NORMAL-PRIORITY      PIC X       VALUE 'N'.           
           05  WS-SCEG-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-PSNC-NO-DATA         PIC X       VALUE 'N'.           
           05  WS-ROUTING-CATEGORY1    PIC X       VALUE '1'.           
           05  WS-CATEGORY-ID-362      PIC S9(4)   VALUE 362 COMP.      
           05  WS-DEVICE-NO            PIC X(9)    VALUE SPACES.        
           05  WS-METER-NO             PIC X(9)    VALUE SPACES.        
           05  SUCCESSFUL-CALL         PIC S9(9)   VALUE +0   COMP.     
           05  NOT-FOUND               PIC S9(9)   VALUE +100 COMP.     
           05  WS-811                  PIC S9(9)   VALUE -811 COMP.     
           05  WS-803                  PIC S9(9)   VALUE -803 COMP.     
           05  WS-PREV-PREMISE-NO      PIC 9(10)   VALUE 0.             
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSCA625'.    
           05  WS-EXP-COUNT            PIC S9(3)   VALUE 0 COMP-3.      
           05  WS-DETAIL-COUNT         PIC 9(7)    VALUE 0.             
           05  WS-CURRENT-TIMESTAMP    PIC X(26)   VALUE SPACES.        
           05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CHECK-DATE           PIC X(10)   VALUE SPACES.        
           05  WS-RECORD-STATUS        PIC X(04)   VALUE SPACES.        
      *                                                                         
           05  WS-MTR-NO               PIC X(9).                        
           05  WS-METER-NO-JUSTIFIED   PIC X(9) JUSTIFIED RIGHT.        
           05  WS-INSPECT-CNTR         PIC 99      VALUE ZERO.          
      *                                                                         
           05  WS-TEMP-CC              PIC 99.                          
           05  WS-PREMISE-NO           PIC S9(10)V VALUE 0 COMP-3.      
           05  WS-LAST-PREMISE-UPDATED PIC S9(10)V VALUE 0 COMP-3.      
           05  WS-LINE-COUNT           PIC S9(3)   VALUE +66 COMP-3.    
           05  WS-PAGE-COUNT           PIC S9(3)   VALUE 0 COMP-3.      
           05  WS-MTRP-TEXT-LEN        PIC S9(4)   VALUE +38 COMP.      
           05  WS-MTRP-TEXT            PIC X(38)   VALUE                
            'UPDATE VIA READONE LINK TOHOST PROCESS'.                   
           05  WS-TOTAL-MTRP-CHG       PIC S9(5)   VALUE 0 COMP-3.      
      *                                                                         
           05  WS-SWITCHES.                                             
               10  WS-EOF-FLAG         PIC X    VALUE 'N'.              
                   88  END-OF-FILE              VALUE 'Y'.              
               10  WS-FCA625-STATUS    PIC XX.                          
                   88  FCA625-SUCCESSFUL        VALUE '00'.             
               10  WS-FCA33-STATUS     PIC XX.                          
                   88  FCA33-SUCCESSFUL         VALUE '00'.             
      *                                                                         
       01  WS-MIN-LATITUDE-MN           PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MAX-LATITUDE-MN           PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MIN-LONGITUDE-MN          PIC S9(3)V9(6) COMP-3 VALUE 0.  
       01  WS-MAX-LONGITUDE-MN          PIC S9(3)V9(6) COMP-3 VALUE 0.  
      *                                                                         
       01  WS-LONG                      PIC 9(2)V9(9).                  
       01  WS-LONG-AN REDEFINES WS-LONG PIC X(11).                      
       01  WS-LONG-CHECK                PIC 9(3)V9(6)  VALUE ZEROS.     
      *                                                                         
A37741 01 S-RETURN-CODE                 PIC S9(9) VALUE 0.              
      *                                                                         
A03345 01 WS-UPDATE-BY-PREMISE         PIC X       VALUE 'N'.           
A03345     88  UPDATING-BY-METER                   VALUE 'N'.           
A03345     88  UPDATING-BY-PREMISE                 VALUE 'Y'.           
      *                                                                         
       01 WS-WORK-PARM.                                                 
          05 WS-PARM-PROGRAM           PIC X(8)    VALUE 'PCSCA625'.    
          05 WS-PARM-COMPANY           PIC XX      VALUE SPACES.        
          05 WS-PARM-CMND-CODE         PIC X(4)    VALUE 'PARM'.        
      *                                                                         
       01 WS-PARM-MIN-MAX.                                              
          05 WS-PARM-COMPANY-LITERAL   PIC X(3).                        
          05 WS-PARM-COMPANY-NO        PIC XX.                          
          05 FILLER                    PIC X.                           
          05 WS-PARM-MINIMUM-LITERAL   PIC X(8).                        
          05 WS-PARM-MINIMUM.                                           
             10 WS-PARM-MIN-SIGN       PIC X.                           
             10 WS-PARM-MIN1           PIC XX.                          
             10 WS-PARM-MIN-DOT        PIC X.                           
             10 WS-PARM-MIN2           PIC X(6).                        
          05 FILLER                    PIC X.                           
          05 WS-PARM-MAXIMUM-LITERAL   PIC X(8).                        
          05 WS-PARM-MAXIMUM.                                           
             10 WS-PARM-MAX-SIGN       PIC X.                           
             10 WS-PARM-MAX1           PIC XX.                          
             10 WS-PARM-MAX-DOT        PIC X.                           
             10 WS-PARM-MAX2           PIC X(6).                        
          05 FILLER                    PIC X(37).                       
      *                                                                         
       01 WS-LATITUDE-MIN-MAX.                                          
          05 WS-MIN-LATITUDE.                                           
             10 WS-LAT-MIN-SIGN       PIC X.                            
             10 WS-LAT-MIN1           PIC XX.                           
             10 WS-LAT-MIN-DOT        PIC X.                            
             10 WS-LAT-MIN2           PIC X(6).                         
          05 WS-MAX-LATITUDE.                                           
             10 WS-LAT-MAX-SIGN       PIC X.                            
             10 WS-LAT-MAX1           PIC XX.                           
             10 WS-LAT-MAX-DOT        PIC X.                            
             10 WS-LAT-MAX2           PIC X(6).                         
      *                                                                         
       01 WS-LONGITUDE-MIN-MAX.                                         
          05 WS-MIN-LONGITUDE.                                          
             10 WS-LON-MIN-SIGN       PIC X.                            
             10 WS-LON-MIN1           PIC XX.                           
             10 WS-LON-MIN-DOT        PIC X.                            
             10 WS-LON-MIN2           PIC X(6).                         
          05 WS-MAX-LONGITUDE.                                          
             10 WS-LON-MAX-SIGN       PIC X.                            
             10 WS-LON-MAX1           PIC XX.                           
             10 WS-LON-MAX-DOT        PIC X.                            
             10 WS-LON-MAX2           PIC X(6).                         
      *                                                                         
      *                                                                         
       01  WS-EXCEPTION-MESSAGES.                                       
           05 WS-MSG-1                PIC X(47)                         
              VALUE 'ACCOUNT NUMBER AND METER NUMBER ARE INVALID    '.  
           05 WS-MSG-2                PIC X(47)                         
              VALUE 'INVALID LATITUDE AND/OR LONGITUDE NUMBERS      '.  
           05 WS-MSG-3                PIC X(47)                         
              VALUE 'INVALID DATE COLLECTED                         '.  
           05 WS-MSG-4                PIC X(47)                         
              VALUE 'ALL ATTEMPTS TO GET MOST RECENT ACCOUNT FAILED '.  
           05 WS-MSG-5                PIC X(47)                         
              VALUE 'LONGITUDE FIELD MUST BE A NEGATIVE NUMBER      '.  
           05 WS-MSG-6                PIC X(47)                         
              VALUE 'LATITUDE AND/OR LONGITUDE OUT OF PARM RANGE    '.  
           05 WS-MSG-7                PIC X(47)                         
              VALUE 'ACCOUNT NUMBER NOT FOUND ON METER ENVIRONMENT  '.  
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-NEGATIVE                 PIC X      VALUE '-'.        
           05  WS-YES                      PIC X      VALUE 'Y'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-I                        PIC X(01)  VALUE 'I'.        
           05  WS-NO                       PIC X      VALUE 'N'.        
           05  WS-M                        PIC X      VALUE 'M'.        
           05  WS-DOT                      PIC X      VALUE '.'.        
           05  WS-19-CENTURY               PIC 99     VALUE  19.        
           05  WS-20-CENTURY               PIC 99     VALUE  20.        
           05  WS-SCEG                     PIC X(26)                    
               VALUE '   S C ELECTRIC AND GAS CO'.                      
           05  WS-PSNC                 PIC X(26)                        
               VALUE '       PSNC ENERGY        '.                      
      *                                                                         
       01  WS-WHO-CARES-DATE           PIC X(10).                       
      *                                                                         
      *--------------------------------------------------------------*          
      *   HEADERS FOR THE EXCEPTION REPORT.                          *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 HEADER1.                                                      
          05 FILLER           PIC X     VALUE SPACES.                   
          05 FILLER           PIC X(11) VALUE 'PCSCA625-01'.            
          05 FILLER           PIC X(41) VALUE SPACES.                   
          05 WS-COMPANY-NAME  PIC X(26) VALUE SPACES.                   
          05 FILLER           PIC X(22) VALUE SPACES.                   
          05 FILLER           PIC X(10) VALUE 'RUN DATE: '.             
          05 HDR-DATE         PIC X(10) VALUE SPACES.                   
          05 FILLER           PIC X     VALUE SPACES.                   
          05 FILLER           PIC X(7)  VALUE 'PAGE = '.                
          05 HDR-PAGE         PIC ZZ9.                                  
          05 FILLER           PIC X     VALUE SPACES.                   
      *                                                                         
       01 HEADER2.                                                      
          05 FILLER           PIC X(51) VALUE SPACES.                   
          05 FILLER           PIC X(33) VALUE                           
             'GIS DATA POSTING EXCEPTION REPORT'.                       
          05 FILLER           PIC X(49)  VALUE SPACES.                  
      *                                                                         
       01 HEADER2B.                                                     
          05 FILLER           PIC X(40) VALUE SPACES.                   
          05 FILLER           PIC X(55) VALUE                           
             'GIS DATA POSTING EXCEPTION REPORT - DATAWAREHOUSE LOAD'.  
          05 FILLER           PIC X(38)  VALUE SPACES.                  
      *                                                                         
       01 HEADER3.                                                      
          05 FILLER           PIC X(19) VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'UTL'.                    
          05 FILLER           PIC X(16) VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'GIS'.                    
          05 FILLER           PIC X(33) VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'TECH'.                   
          05 FILLER           PIC X(6)  VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'DATE'.                   
          05 FILLER           PIC X(45) VALUE SPACES.                   
      *                                                                         
       01 HEADER4.                                                      
          05 FILLER           PIC X(4)  VALUE SPACES.                   
          05 FILLER           PIC X(10) VALUE 'ACCOUNT NO'.             
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(3)  VALUE 'TYP'.                    
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(8)  VALUE 'METER NO'.               
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(4)  VALUE 'SRCE'.                   
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(8)  VALUE 'LATITUDE'.               
          05 FILLER           PIC X(6)  VALUE SPACES.                   
          05 FILLER           PIC X(9)  VALUE 'LONGITUDE'.              
          05 FILLER           PIC X(7)  VALUE SPACES.                   
          05 FILLER           PIC XX    VALUE 'ID'.                     
          05 FILLER           PIC X(5)  VALUE SPACES.                   
          05 FILLER           PIC X(9)  VALUE 'COLLECTED'.              
          05 FILLER           PIC X(3)  VALUE SPACES.                   
          05 FILLER           PIC X(15) VALUE 'PREMISE ADDRESS'.        
          05 FILLER           PIC X(22)                                 
             VALUE '/EXCEPTION DESCRIPTION'.                            
          05 FILLER           PIC XX    VALUE SPACES.                   
      *                                                                         
      *--------------------------------------------------------------*          
      *   NO DATA PRINT LINE FOR THE EXCEPTION REPORT                *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 NO-DATA-LINE.                                                 
          05 FILLER            PIC X(57) VALUE SPACES.                  
          05 NO-DATA-LITERAL   PIC X(20) VALUE 'NO DATA FOR THIS RUN'.  
          05 FILLER            PIC X(56) VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   EXCEPTION REPORT LINE                                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 EXCEPTION-LINE.                                               
          05 FILLER            PIC X     VALUE SPACES.                  
          05 PRT-ACCOUNT       PIC XBXXXXBXXXXBXXXX VALUE SPACES.       
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-UTIL-TYPE     PIC X     VALUE SPACES.                  
          05 FILLER            PIC X(5)  VALUE SPACES.                  
          05 PRT-METER-NO      PIC X(9)  VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
          05 PRT-GIS-SOURCE    PIC X     VALUE SPACES.                  
          05 FILLER            PIC X(5)  VALUE SPACES.                  
          05 PRT-LATITUDE      PIC X(11) VALUE SPACES.                  
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-LONGITUDE     PIC X(11) VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
          05 PRT-TECH-ID       PIC X(5)  VALUE SPACES.                  
          05 FILLER            PIC X(3)  VALUE SPACES.                  
          05 PRT-DATE-COLL     PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC XX    VALUE SPACES.                  
          05 PRT-ADDRESS.                                               
             10 PRT-HOUSE      PIC X(5)  VALUE SPACES.                  
             10 FILLER         PIC X     VALUE SPACES.                  
             10 PRT-STREET     PIC X(18) VALUE SPACES.                  
             10 FILLER         PIC X     VALUE SPACES.                  
             10 PRT-SUFFIX     PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC X(4)  VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   EXCEPTION DESCRIPTION FOR REPORT LINE                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 EXCEPTION-DESC-LINE.                                          
          05 FILLER            PIC X(85) VALUE SPACES.                  
          05 PRT-DESCRIPTION   PIC X(47) VALUE SPACES.                  
          05 FILLER            PIC X     VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   GENERAL USE PRINT LINE.                                    *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-LINE           PIC X(133) VALUE SPACES.                 
      *                                                                         
      *--------------------------------------------------------------*          
      *   PRINT TOTAL LINE FOR THE EXCEPTION REPORT                  *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-TOTAL-LINE.                                             
          05 FILLER            PIC X(10) VALUE SPACES.                  
          05 FILLER            PIC X(45)                                
             VALUE 'TOTAL NUMBER OF ACCOUNTS WITH AN EXCEPTION = '.     
          05 PRT-TOTAL         PIC Z(9)9 VALUE ZEROS.                   
          05 FILLER            PIC X(68) VALUE SPACES.                  
      *                                                                         
      *--------------------------------------------------------------*          
      *   PRINT END OF REPORT LINE FOR THE EXCEPTION REPORT          *          
      *--------------------------------------------------------------*          
      *                                                                         
       01 PRINT-END.                                                    
          05 FILLER            PIC X(60) VALUE SPACES.                  
          05 FILLER            PIC X(13) VALUE 'END OF REPORT'.         
          05 FILLER            PIC X(60) VALUE SPACES.                  
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE     REDEFINES                    
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05) VALUE ZERO.        
           05  WS-RESTART-RECORD-NO        PIC 9(07).                   
           05  WS-RESTART-REC-KEY.                                      
               10 WS-RESTART-COMPANY-NO    PIC XX.                      
               10 WS-RESTART-G-E-W-IND     PIC X.                       
               10 WS-RESTART-METER-ID      PIC X(9).                    
               10 WS-RESTART-ACCOUNT-NO    PIC X(13).                   
               10 WS-RESTART-PREMISE-NO    PIC X(10).                   
                                                                        
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +59.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART            VALUE 'Y'.           
           05  WS-NEXT-RECORD-READ-FLAG    PIC X(01) VALUE 'N'.         
               88  WS-NEXT-RECORD-READ             VALUE 'Y'.           
               88  WS-NEXT-RECORD-NOT-READ         VALUE 'N'.           
           05  WS-FCA625-REC-CNT           PIC S9(09) COMP VALUE ZERO.  
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.         
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 20.          
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
           05  WS-COMMIT-COUNTER           PIC S9(3) COMP-3 VALUE 0.    
           05  WS-COMMIT-REQ-SW            PIC X(1) VALUE 'Y'.          
               88 WS-COMMITS-REQUIRE                VALUE 'Y'.          
               88 WS-COMMITS-NOT-REQUIRE            VALUE 'N'.          
           05  WS-CHKP-UPD-COUNTER         PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02) VALUE 'B4'.        
               10  WS-CHKP-PART-NO         PIC 9(01) VALUE 1.           
               10  WS-CHKP-SEQ-NO          PIC 9(05) VALUE ZERO.        
      *****************************************************************         
      *    THE FOLLOWING FIELD WILL ALLOW PROGRAMMER TO FORCE ABEND BY          
      *    SPECIFYING AN ACCOUNT NO                                             
      *****************************************************************         
           05  WS-STOP-ACCOUNT-NO          PIC 9(13).                   
      *--------------------------------------------------------------*          
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                      *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      *  CWS00038  JOB PARM ROUTINE                                  *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      * WORKING STORAGE FOR CPD09900                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_METER_ATTCHMTS                             *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_EQUIPMENT                                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBEQUIP                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_MTRD_ENVRNMT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DECLARATION FOR SQL COMMAND AREA                          *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    COPYBOOK FOR CSS_ACCOUNT                                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_MNT_TRANS_HIST                                         *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_MT_TRN_HST_DET                                         *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   CSS_PREMISE                                                *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST                     *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   DCLGEN COPYBOOK FOR CSS_MOVEMENT_HIST                      *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMVHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *    DCLGEN FOR CSS_RESTART                                    *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *   WORKING STORAGE FOR CPD00099 - GET MOST CURRENT            *          
      *        ACCOUNT NUMBER AT A PREMISE                           *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                 40070000
       PROCEDURE DIVISION.                                              
      *                                                                         
      *==============================================================*          
       0000-MAINLINE.                                                   
      *==============================================================*          
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE                                 
              THRU 7000-EXIT.                                           
      *                                                                         
           IF END-OF-FILE                                               
              IF NOT WS-THIS-IS-A-RESTART                               
                 DISPLAY '***********************************'          
                 DISPLAY '     FCSCA625 FILE IS EMPTY      **'          
                 DISPLAY '         0000-MAINLINE           **'          
                 DISPLAY '***********************************'          
              END-IF                                                    
           ELSE                                                         
                 DISPLAY 'PROCESING STARTED WITH: '                     
                          FIOCA625-RECORD(1:83)                         
           END-IF.                                                      
      *                                                                         
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT UNTIL END-OF-FILE                          
      *                                                                         
           PERFORM 3000-PROCESS-NODATA-REPORT                           
              THRU 3000-EXIT                                            
      *                                                                         
           PERFORM 5000-PROCESS-SUCCESSFUL-JOB                          
              THRU 5000-EXIT                                            
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT                                            
      *                                                                         
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0100-INITIALIZATION.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   INTITIAL ROUTINE - GET REVENUE MONTH, CURRENT DATE,        *          
      *                      OPEN INPUT FILE AND OUTPUT PRINT FILE   *          
      *--------------------------------------------------------------*          
      *                                                                         
           PERFORM 0300-OPEN-INPUT-FILES THRU 0300-EXIT.                
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           PERFORM 4400-GET-LAT-LONG-RANGE THRU 4400-EXIT.              
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT  THRU 6253-EXIT            
      *                                                                         
           IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
             AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
               SET WS-COMMITS-NOT-REQUIRE TO TRUE                       
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
           END-IF                                                       
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
      *                                                                         
           MOVE WS-CURRENT-DATE TO HDR-DATE.                            
      *                                                                         
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT           
      *                                                                         
           PERFORM 0600-GET-RESTART-DATA       THRU 0600-EXIT           
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT           
           IF  WS-THIS-IS-A-RESTART                                     
               PERFORM 0611-REPOSITION-FILES                            
                  THRU 0611-EXIT                                        
           ELSE                                                         
               PERFORM 0610-INITIALIZE-RESTART  THRU 0610-EXIT          
           END-IF                                                       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0300-OPEN-INPUT-FILES.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   OPEN INPUT FILES                                           *          
      *--------------------------------------------------------------*          
      *                                                                         
           OPEN INPUT FCSCA625-FILE.                                    
      *                                                                         
           IF FCA625-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '    ABENDING PROGRAM    '                        
              DISPLAY ' FIOCA625 FILE OPEN ERROR '                      
              DISPLAY '  0300-OPEN-INPUT-FILES '                        
              DISPLAY 'FIOCA625 FILE STATUS = ' WS-FCA625-STATUS        
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0600-GET-RESTART-DATA.                                           
      *==============================================================*          
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO           
                                              WS-CHKP-PART-NO.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           PERFORM 7550-SELECT-RESTART-DATA    THRU 7550-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT   TO WS-RESTART-DATA           
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-YES             TO WS-IS-THIS-A-RESTART      
               ELSE                                                     
                   MOVE WS-NO              TO WS-IS-THIS-A-RESTART      
               END-IF                                                   
           ELSE                                                         
               MOVE WS-NO              TO WS-IS-THIS-A-RESTART          
           END-IF                                                       
           .                                                            
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0610-INITIALIZE-RESTART.                                         
      *==============================================================*          
      *                                                                         
           MOVE 0                        TO WS-RESTART-PROCESS-TYPE     
           MOVE WS-CURRENT-DATE          TO WS-RESTART-INPUT-DATE       
           MOVE ZERO                     TO WS-RESTART-CHKP-SEQ-NO      
           MOVE SPACES                   TO WS-RESTART-REC-KEY          
           SET WS-RERUN-PENDING          TO TRUE                        
           .                                                            
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       0611-REPOSITION-FILES.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    REPOSITION INPUT FILE                                     *          
      *--------------------------------------------------------------*          
           MOVE ZERO                       TO WS-FCA625-REC-CNT.        
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT                  
               UNTIL WS-FCA625-REC-CNT = WS-RESTART-RECORD-NO.          
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA625  *****'.       
           DISPLAY '*******************************************'.       
           IF  WS-RESTART-G-E-W-IND  = E-FCA625-G-E-W-IND               
           AND WS-RESTART-METER-ID   = E-FCA625-METER-ID                
           AND WS-RESTART-COMPANY-NO = E-FCA625-COMPANY-NO              
           AND WS-RESTART-PREMISE-NO = E-FCA625-PREMISE-NO              
           AND WS-RESTART-ACCOUNT-NO = E-FCA625-ACCOUNT-NO              
               DISPLAY '*** REPOSITION SUCCESSFULL ***'                 
           ELSE                                                         
               DISPLAY '***    FAIL TO REPOSITIONING FILE     **'       
               DISPLAY '**      ABEND IN PARAGRAPH 0611       **'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
           .                                                            
       0611-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1000-PROCESS-INPUT.                                              
      *==============================================================*          
      *                                                                         
           PERFORM 4200-SAVE-FOR-RESTART                                
              THRU 4200-EXIT                                            
      *                                                                         
           IF E-FCA625-COMPANY-NO = '01'                                
              MOVE WS-SCEG TO WS-COMPANY-NAME                           
           ELSE                                                         
              MOVE WS-PSNC TO WS-COMPANY-NAME                           
           END-IF                                                       
      *                                                                         
A03345     MOVE 'N' TO WS-UPDATE-BY-PREMISE.                            
A03345     IF E-FCA625-METER-ID > ZEROES                                
A03345         CONTINUE                                                 
A03345     ELSE                                                         
A03345         IF E-FCA625-PREMISE-NO  > ZEROES                         
A03345             MOVE 'Y'                 TO WS-UPDATE-BY-PREMISE     
A03345             MOVE E-FCA625-PREMISE-NO TO WS-PREMISE-NO            
A03345             IF E-FCA625-DATE-COLL   > ZEROES                     
A03345                 CONTINUE                                         
A03345             ELSE                                                 
A03345                 MOVE WS-CURRENT-DATE     TO E-FCA625-DATE-COLL   
A03345             END-IF                                               
A03345         END-IF                                                   
A03345     END-IF                                                       
           PERFORM 1200-PROCESS-DETAIL-RECORD THRU 1200-EXIT.           
A03345     IF WS-CPD99-PREMISE-NO NOT =  WS-LAST-PREMISE-UPDATED        
A03345         PERFORM 8470-UPDATE-PREMISE        THRU 8470-EXIT        
A03345     END-IF.                                                      
      *                                                                         
           PERFORM 1400-PROCESS-COMMIT       THRU 1400-EXIT             
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT                  
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1200-PROCESS-DETAIL-RECORD.                                      
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   PROCESS DETAIL RECORDS.                                    *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE 'PASS'  TO WS-RECORD-STATUS                             
A03345     IF UPDATING-BY-METER                                         
               MOVE E-FCA625-METER-ID TO WS-METER-NO                    
               MOVE WS-METER-NO       TO WS-MTR-NO                      
               INSPECT WS-MTR-NO REPLACING ALL LOW-VALUES BY SPACES     
               MOVE 0                 TO WS-INSPECT-CNTR                
               INSPECT WS-MTR-NO TALLYING  WS-INSPECT-CNTR FOR ALL ' '  
               COMPUTE WS-INSPECT-CNTR =                                
                   LENGTH OF WS-MTR-NO - WS-INSPECT-CNTR                
               MOVE WS-MTR-NO(1:WS-INSPECT-CNTR) TO                     
                    WS-METER-NO-JUSTIFIED                               
               INSPECT WS-METER-NO-JUSTIFIED REPLACING ALL ' ' BY '0'   
               MOVE WS-METER-NO-JUSTIFIED TO WS-METER-NO                
               IF (WS-METER-NO = ZEROS OR SPACES OR LOW-VALUES)         
               AND (E-FCA625-ACCOUNT-NO = ZEROS OR SPACES OR LOW-VALUES)
                  MOVE WS-MSG-1 TO PRT-DESCRIPTION                      
                  PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT          
                  GO TO 1200-EXIT                                       
A03345     END-IF
           END-IF.                                                      
      *                                                                         
           IF (E-FCA625-LATITUDE = ZEROS OR SPACES OR LOW-VALUES)       
            OR (E-FCA625-LONGITUDE = ZEROS OR SPACES OR LOW-VALUES)     
              MOVE WS-MSG-2 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1200-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF E-FCA625-LONGITUDE (1:1) NOT = WS-NEGATIVE                
              MOVE WS-MSG-5 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1200-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FCA625-DATE-COLL     TO WS-CHECK-DATE.                
           PERFORM 7510-VERIFY-COLL-DATE-IS-VALID THRU 7510-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              MOVE E-FCA625-DATE-COLL  TO MN-LAT-LONG-DT                
           ELSE                                                         
              MOVE WS-MSG-3 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1200-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF E-FCA625-PREMISE-NO = ZEROS OR SPACES OR LOW-VALUES       
              IF E-FCA625-ACCOUNT-NO = ZEROS OR SPACES OR LOW-VALUES    
                 IF WS-METER-NO = ZEROS OR SPACES OR LOW-VALUES         
                    MOVE WS-MSG-1 TO PRT-DESCRIPTION                    
                    PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT        
                    GO TO 1200-EXIT                                     
                 ELSE                                                   
                    MOVE E-FCA625-COMPANY-NO    TO EQ-COMPANY-NO        
                    MOVE WS-METER-NO            TO EQ-DEVICE-NO         
                    MOVE E-FCA625-G-E-W-IND     TO EQ-CODE-UTIL-TYPE    
                    PERFORM 7300-GET-PREMISE-FROM-EQ THRU 7300-EXIT     
                    IF WS-ACTIVE-RETURN-CODE = ZERO                     
                             AND EQ-CODE-CRNT-LOC = 'J'                 
                       MOVE EQ-CRNT-LOC-NO TO WS-CPD99-PREMISE-NO       
                    ELSE                                                
                       MOVE E-FCA625-COMPANY-NO TO MV-COMPANY-NO        
                       MOVE WS-METER-NO         TO MV-DEVICE-NO         
                       MOVE E-FCA625-G-E-W-IND  TO MV-CODE-UTIL-TYPE    
                       PERFORM 7325-GET-PREMISE-FROM-MV THRU 7325-EXIT  
                       IF WS-ACTIVE-RETURN-CODE = ZERO                  
                          IF MV-LOC-NO > ZEROS                          
                             MOVE MV-LOC-NO TO WS-CPD99-PREMISE-NO      
                          ELSE                                          
                             MOVE WS-MSG-4 TO PRT-DESCRIPTION           
                             PERFORM 1300-EXCEPTION-REPORT              
                                 THRU 1300-EXIT                         
                             GO TO 1200-EXIT                            
                          END-IF                                        
                       ELSE                                             
                          MOVE WS-MSG-4 TO PRT-DESCRIPTION              
                          PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT  
                          GO TO 1200-EXIT                               
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE E-FCA625-ACCOUNT-NO    TO AT-ACCOUNT-NO           
                 PERFORM 7350-GET-PREMISE-FROM-AT THRU 7350-EXIT        
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE E-FCA625-COMPANY-NO    TO EQ-COMPANY-NO        
                    MOVE WS-METER-NO            TO EQ-DEVICE-NO         
                    MOVE E-FCA625-G-E-W-IND     TO EQ-CODE-UTIL-TYPE    
                    PERFORM 7300-GET-PREMISE-FROM-EQ THRU 7300-EXIT     
                    IF WS-ACTIVE-RETURN-CODE = ZERO                     
                             AND EQ-CODE-CRNT-LOC = 'J'                 
                       MOVE EQ-CRNT-LOC-NO TO WS-CPD99-PREMISE-NO       
                    ELSE                                                
                       MOVE E-FCA625-COMPANY-NO TO MV-COMPANY-NO        
                       MOVE WS-METER-NO         TO MV-DEVICE-NO         
                       MOVE E-FCA625-G-E-W-IND  TO MV-CODE-UTIL-TYPE    
                       PERFORM 7325-GET-PREMISE-FROM-MV THRU 7325-EXIT  
                       IF WS-ACTIVE-RETURN-CODE = ZERO                  
                          IF MV-LOC-NO > ZEROS                          
                             MOVE MV-LOC-NO TO WS-CPD99-PREMISE-NO      
                          ELSE                                          
                             MOVE WS-MSG-4 TO PRT-DESCRIPTION           
                             PERFORM 1300-EXCEPTION-REPORT              
                                 THRU 1300-EXIT                         
                             GO TO 1200-EXIT                            
                          END-IF                                        
                       ELSE                                             
                          MOVE WS-MSG-4 TO PRT-DESCRIPTION              
                          PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT  
                          GO TO 1200-EXIT                               
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
                    MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO           
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE E-FCA625-PREMISE-NO TO WS-CPD99-PREMISE-NO           
           END-IF.                                                      
      *                                                                         
           MOVE ZEROS TO WS-CPD99-ACCOUNT-NO.                           
      *                                                                         
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
      *                                                                         
           MOVE WS-CPD99-ACCOUNT-NO TO WS-COMPARE-ACCT.                 
A03345     IF E-FCA625-ACCOUNT-NO NOT > ZERO                            
A03345         MOVE WS-COMPARE-ACCT TO E-FCA625-ACCOUNT-NO              
A03345     END-IF.                                                      
      *                                                                         
           IF E-FCA625-ACCOUNT-NO = WS-COMPARE-ACCT                     
              CONTINUE                                                  
           ELSE                                                         
              IF WS-CPD99-ACCOUNT-NO = ZEROS                            
                  MOVE WS-MSG-4 TO PRT-DESCRIPTION                      
                  PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT          
                  GO TO 1200-EXIT                                       
              ELSE                                                      
                  DISPLAY '             '                               
                  DISPLAY '***************************************'     
                  DISPLAY '   SHOULD BE INFORMATIONAL ONLY        '     
                  DISPLAY '   1200-PROCESS-DETAIL-RECORD          '     
                  DISPLAY ' DISPLAY FOR WHEN INPUT ACCOUNT NUMBER '     
                  DISPLAY ' DOES NOT EQUAL THE MOST CURRENT NUMBER'     
                  DISPLAY 'INPUT ACCOUNT NO = ' E-FCA625-ACCOUNT-NO     
                  DISPLAY 'CPD99 ACCOUNT NO = ' WS-COMPARE-ACCT         
                  DISPLAY '***************************************'     
                  DISPLAY '             '                               
                  MOVE WS-COMPARE-ACCT TO E-FCA625-ACCOUNT-NO           
                  END-IF                                                
           END-IF.                                                      
      *                                                                         
           PERFORM 1250-PREP-FIELDS THRU 1250-EXIT                      
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1250-PREP-FIELDS.                                                
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   PREPARE FOR EXCEPTION REPORT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE E-FCA625-LATITUDE (1:2) TO WS-LONG-AN (1:2).            
           MOVE E-FCA625-LATITUDE (4:9) TO WS-LONG-AN (3:9).            
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY +1 GIVING MN-MTR-REF-LATITUDE.     
      *                                                                         
           MOVE E-FCA625-LONGITUDE (2:2) TO WS-LONG-AN (1:2).           
           MOVE E-FCA625-LONGITUDE (5:9) TO WS-LONG-AN (3:9).           
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY -1 GIVING MN-MTR-REF-LONGITUDE.    
      *                                                                         
           IF MN-MTR-REF-LATITUDE < WS-MIN-LATITUDE-MN                  
              MOVE WS-MSG-6 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1250-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-MTR-REF-LATITUDE > WS-MAX-LATITUDE-MN                  
              MOVE WS-MSG-6 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1250-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-MTR-REF-LONGITUDE < WS-MIN-LONGITUDE-MN                
              MOVE WS-MSG-6 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1250-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-MTR-REF-LONGITUDE > WS-MAX-LONGITUDE-MN                
              MOVE WS-MSG-6 TO PRT-DESCRIPTION                          
              PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT              
              GO TO 1250-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE E-FCA625-GIS-SOURCE-CD TO MN-LAT-LONG-SOURCE-CD.        
      *                                                                         
           MOVE E-FCA625-ACCOUNT-NO    TO MN-ACCOUNT-NO.                
           MOVE E-FCA625-G-E-W-IND     TO MN-CODE-UTIL-TYPE.            
           MOVE WS-METER-NO            TO MN-METER-NO.                  
      *    MOVE E-FCA625-IC-NO         TO MN-IC-NO.                             
           MOVE E-FCA625-MTR-REF-NO    TO MN-MTR-REF-NO.                
      *                                                                         
A#5470*    IF UPDATING-BY-PREMISE                                               
A#5470*         PERFORM 8430-UPDATE-ALL-METERS THRU 8430-EXIT                   
A#5470*    ELSE                                                                 
A#5470*         IF E-FCA625-GIS-SOURCE-CD = 'D'                                 
A#5470*             PERFORM 8420-UPDATE-BY-METER THRU 8420-EXIT                 
A#5470*         ELSE                                                            
A#5470*             PERFORM 8400-UPDATE-MTRD-ENVRNMT THRU 8400-EXIT             
A#5470*    END-IF.                                                              
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1300-EXCEPTION-REPORT.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   PREPARE FOR EXCEPTION REPORT                               *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE 'FAIL'  TO WS-RECORD-STATUS                             
                                                                        
           MOVE WS-METER-NO            TO PRT-METER-NO.                 
           MOVE E-FCA625-ACCOUNT-NO    TO PRT-ACCOUNT.                  
           INSPECT PRT-ACCOUNT REPLACING ALL ' ' BY '-'.                
           MOVE E-FCA625-G-E-W-IND     TO PRT-UTIL-TYPE.                
           MOVE E-FCA625-HOUSE-NBR     TO PRT-HOUSE.                    
           MOVE E-FCA625-STREET        TO PRT-STREET.                   
           MOVE E-FCA625-SUFFIX        TO PRT-SUFFIX.                   
      *                                                                         
           MOVE E-FCA625-GIS-SOURCE-CD TO PRT-GIS-SOURCE.               
           MOVE E-FCA625-TECH-ID       TO PRT-TECH-ID.                  
      *                                                                         
           MOVE E-FCA625-LATITUDE      TO PRT-LATITUDE.                 
           MOVE E-FCA625-LONGITUDE     TO PRT-LONGITUDE.                
      *                                                                         
           MOVE E-FCA625-DATE-COLL     TO PRT-DATE-COLL.                
      *                                                                         
           MOVE EXCEPTION-LINE TO PRINT-LINE.                           
      *                                                                         
           PERFORM 8200-WRITE-EXCEPTION-REPORT THRU 8200-EXIT.          
      *                                                                         
           MOVE SPACES TO EXCEPTION-LINE.                               
      *                                                                         
           MOVE EXCEPTION-DESC-LINE TO PRINT-LINE.                      
      *                                                                         
           PERFORM 8200-WRITE-EXCEPTION-REPORT THRU 8200-EXIT.          
           ADD +1 TO WS-EXP-COUNT.                                      
      *                                                                         
           IF E-FCA625-COMPANY-NO = '01'                                
              MOVE 'Y' TO WS-SCEG-NO-DATA                               
           ELSE                                                         
              MOVE 'Y' TO WS-PSNC-NO-DATA                               
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       1400-PROCESS-COMMIT.                                             
      *==============================================================*          
      *                                                                         
           DISPLAY 'PROCESSING ' WS-RECORD-STATUS                       
                    ' ACCOUNT: ' E-FCA625-ACCOUNT-NO                    
                    ' METER: ' WS-METER-NO                              
                                                                        
           ADD +1 TO WS-COMMIT-COUNTER                                  
           IF WS-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT                    
              AND WS-COMMITS-REQUIRE                                    
      *                                                                         
              MOVE 0               TO WS-RESTART-PROCESS-TYPE           
              SET WS-RERUN-PENDING TO TRUE                              
              PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                    
              MOVE 0 TO WS-COMMIT-COUNTER                               
      *                                                                         
           END-IF                                                       
           .                                                            
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       3000-PROCESS-NODATA-REPORT.                                      
      *==============================================================*          
      ****************************************************************          
      *  WS-SCEG-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 01 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      *                                                                         
      *  WS-PSNC-NO-DATA IS SET TO 'Y' IF THERE IS SOME DATA FOR     *          
      *      COMPANY 26 ON THE EXCEPTION REPORT.                     *          
      *      IF AT THIS POINT IT IS = 'N' THEN                       *          
      *      'NO DATA FOR THIS RUN' LINE IS PRINTED ON THE REPORT    *          
      ****************************************************************          
      *                                                                         
           IF WS-SCEG-NO-DATA = 'N'                                     
              MOVE WS-SCEG TO WS-COMPANY-NAME                           
              MOVE 0 TO WS-PAGE-COUNT                                   
              PERFORM 8500-PRINT-HEADERS THRU 8500-EXIT                 
              MOVE NO-DATA-LINE TO PRINT-LINE                           
              PERFORM 8600-PRINT-REPORT THRU 8600-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
              MOVE PRINT-END TO PRINT-LINE                              
              PERFORM 8600-PRINT-REPORT THRU 8600-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF.                                                      
      *                                                                         
           IF WS-PSNC-NO-DATA = 'N'                                     
              MOVE WS-PSNC TO WS-COMPANY-NAME                           
              MOVE 0 TO WS-PAGE-COUNT                                   
              PERFORM 8500-PRINT-HEADERS THRU 8500-EXIT                 
              MOVE NO-DATA-LINE TO PRINT-LINE                           
              PERFORM 8600-PRINT-REPORT THRU 8600-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
              MOVE PRINT-END TO PRINT-LINE                              
              PERFORM 8600-PRINT-REPORT THRU 8600-EXIT                  
              MOVE SPACES TO PRINT-LINE                                 
           END-IF                                                       
           .                                                            
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       4200-SAVE-FOR-RESTART.                                           
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   SAVE NON-EDITED DATA FOR RESTART JUST IN CASE              *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE WS-FCA625-REC-CNT   TO WS-RESTART-RECORD-NO             
           MOVE E-FCA625-ACCOUNT-NO TO WS-RESTART-ACCOUNT-NO            
           MOVE E-FCA625-PREMISE-NO TO WS-RESTART-PREMISE-NO            
           MOVE E-FCA625-G-E-W-IND  TO WS-RESTART-G-E-W-IND             
           MOVE E-FCA625-METER-ID   TO WS-RESTART-METER-ID              
           MOVE E-FCA625-COMPANY-NO TO WS-RESTART-COMPANY-NO            
           .                                                            
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       4400-GET-LAT-LONG-RANGE.                                         
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET THE MINIMUM / MAXIMUM LATITUDE AND LONGITUDE FOR      *          
      *    THE COMPANY YOU ARE RUNNING FOR.                          *          
      *    USED FOR LATITUDE / LONGITUDE VALIDATION.                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'MIN LAT=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA625                         **'        
              DISPLAY '**  4400-GET-LAT-LONG-RANGE           **'        
              DISPLAY '**  ERROR RETRIEVING THE MINIMUM AND  **'        
              DISPLAY '**  MAXIMUM LATITUDE PARM FROM        **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-MIN-MAX                      
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE WS-PARM-MINIMUM TO WS-MIN-LATITUDE                   
              MOVE WS-PARM-MAXIMUM TO WS-MAX-LATITUDE                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-PROGRAM     TO WS-PROGRAM.                      
           MOVE WS-PARM-CMND-CODE   TO WS-COMMAND.                      
           MOVE ZEROS               TO WS-SEQUENCE.                     
           MOVE SPACES              TO WS-SYSIPT.                       
           MOVE WS-KEY-AREA         TO E-FJC01-KEY.                     
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
      *                                                                         
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) =                    
                         'CO=' AND                                      
                      WS-INPUT-DATA-BREAKDOWN(7:8) =                    
                         'MIN LON=' AND INPUT-ACTIVE)                   
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '**   PCSCA625                         **'        
              DISPLAY '**  4400-GET-LAT-LONG-RANGE           **'        
              DISPLAY '**  ERROR RETRIEVING THE MINIMUM AND  **'        
              DISPLAY '**  MAXIMUM LONGITUDE PARM FROM       **'        
              DISPLAY '**  CSS_JOB_PARM                      **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE G6-PARM-DATA TO WS-PARM-MIN-MAX                      
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE WS-PARM-MINIMUM TO WS-MIN-LONGITUDE                  
              MOVE WS-PARM-MAXIMUM TO WS-MAX-LONGITUDE                  
           END-IF.                                                      
      *                                                                         
           PERFORM 4500-PACK-LAT-LONG THRU 4500-EXIT                    
           .                                                            
       4400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       4500-PACK-LAT-LONG.                                              
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    PUT THE MINIMUM / MAXIMUM LATITUDE AND LONGITUDE FOR      *          
      *    THE COMPANY YOU ARE RUNNING INTO PACKED FORMAT TO COMPARE *          
      *    AGAINST THE INPUT FIELDS FOR VALIDATION.                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           DISPLAY 'MIN LATITUDE: ' WS-MIN-LATITUDE                     
           MOVE WS-LAT-MIN1             TO WS-LONG-AN (1:2).            
           MOVE WS-LAT-MIN2             TO WS-LONG-AN (3:9).            
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY +1 GIVING WS-MIN-LATITUDE-MN.      
      *                                                                         
           DISPLAY 'MAX LATITUDE: ' WS-MAX-LATITUDE                     
           MOVE WS-LAT-MAX1             TO WS-LONG-AN (1:2).            
           MOVE WS-LAT-MAX2             TO WS-LONG-AN (3:9).            
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY +1 GIVING WS-MAX-LATITUDE-MN.      
      *                                                                         
           DISPLAY 'MIN LONGITUDE: ' WS-MIN-LONGITUDE                   
           MOVE WS-LON-MIN1             TO WS-LONG-AN (1:2).            
           MOVE WS-LON-MIN2             TO WS-LONG-AN (3:9).            
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY -1 GIVING WS-MIN-LONGITUDE-MN.     
      *                                                                         
           DISPLAY 'MAX LONGITUDE: ' WS-MAX-LONGITUDE                   
           MOVE WS-LON-MAX1             TO WS-LONG-AN (1:2).            
           MOVE WS-LON-MAX2             TO WS-LONG-AN (3:9).            
           MULTIPLY WS-LONG BY +1 GIVING WS-LONG-CHECK ROUNDED.         
           MULTIPLY WS-LONG-CHECK BY -1 GIVING WS-MAX-LONGITUDE-MN      
           .                                                            
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       5000-PROCESS-SUCCESSFUL-JOB.                                     
      *==============================================================*          
      *--------------------------------------------------------------*          
      * THE FOLLOWING SETTINGS DECLARES SUCCESSFUL COMPLETION OF RUN *          
      * AND RESET RE-START CONTROLS IN CASE OF RE-START RUN          *          
      *--------------------------------------------------------------*          
           MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED    TO TRUE                        
           ELSE                                                         
               SET WS-RUN-COMPLETED-NO-PROBLEMS                         
                                         TO TRUE                        
           END-IF.                                                      
           PERFORM 8898-ISSUE-CHKP           THRU 8898-EXIT             
      *                                                                         
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                  THRU 8893-EXIT                                        
           END-IF                                                       
           .                                                            
       5000-EXIT.                                                       
           EXIT.                                                        
      *==============================================================*          
       6995-CPD99-ERROR-ROUTINE.                                        
      *==============================================================*          
      *                                                                         
           DISPLAY '*************PCSCA625************'.                 
           DISPLAY '* ERROR IN PERFORMING - 6990-FETCH-CUR-ACCOUNT '.   
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSCA625************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT                            
           .                                                            
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7000-READ-INPUT-FILE.                                            
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   READ INPUT FILE                                            *          
      *--------------------------------------------------------------*          
      *                                                                         
           READ FCSCA625-FILE                                           
                     AT END MOVE WS-YES TO WS-EOF-FLAG.                 
      *                                                                         
           IF FCA625-SUCCESSFUL                                         
              ADD 1         TO  WS-FCA625-REC-CNT                       
           ELSE                                                         
              IF END-OF-FILE                                            
                 CONTINUE                                               
              ELSE                                                      
                   DISPLAY '*************************************'      
                   DISPLAY '**   PCSCA625 PROCESSING ERROR     **'      
                   DISPLAY '**   ABEND IN PARAGRAPH 7000       **'      
                   DISPLAY '**  READ STATUS   = ' WS-FCA625-STATUS      
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7300-GET-PREMISE-FROM-EQ.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET THE PREMISE NUMBER FROM CSS_EQUIPMENT                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
              SELECT CODE_CRNT_LOC                                      
                    ,CRNT_LOC_NO                                        
                INTO :EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
                WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
                AND   DEVICE_NO      = :EQ-DEVICE-NO                    
                AND   CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CRNT_LOC                                              
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*         INTO :EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*         WHERE COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*         AND   DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*         AND   CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = ZERO OR NOT-FOUND                 
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_EQUIPMENT FETCH  '                    
               DISPLAY '      7300-GET-PREMISE-FROM-EQ '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' EQ-DEVICE-NO                
               DISPLAY ' CODE UTIL TYPE = ' EQ-CODE-UTIL-TYPE           
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7325-GET-PREMISE-FROM-MV.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET THE PREMISE NUMBER FROM CSS_MOVEMENT_HIST             *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
              SELECT M1.LOC_NO                                          
                INTO :MV-LOC-NO                                         
                FROM CSS_MOVEMENT_HIST M1 WITH(READUNCOMMITTED)                 
                WHERE M1.COMPANY_NO     = :MV-COMPANY-NO                
                AND   M1.DEVICE_NO      = :MV-DEVICE-NO                 
                AND   M1.CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE            
                AND   M1.CODE_CRNT_LOC  = 'J'                           
                AND   M1.MOVE_NO  = (SELECT MAX(M2.MOVE_NO)             
                      FROM CSS_MOVEMENT_HIST M2 WITH(READUNCOMMITTED)           
                      WHERE M2.COMPANY_NO   = M1.COMPANY_NO             
                      AND M2.DEVICE_NO      = M1.DEVICE_NO              
                      AND M2.CODE_UTIL_TYPE = M1.CODE_UTIL_TYPE         
                      AND M2.CODE_CRNT_LOC  = 'J')                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT M1.LOC_NO                                                  
MFA-TR*         INTO :MV-LOC-NO                                                 
MFA-TR*         FROM CSS_MOVEMENT_HIST M1                                       
MFA-TR*         WHERE M1.COMPANY_NO     = :MV-COMPANY-NO                        
MFA-TR*         AND   M1.DEVICE_NO      = :MV-DEVICE-NO                         
MFA-TR*         AND   M1.CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                    
MFA-TR*         AND   M1.CODE_CRNT_LOC  = 'J'                                   
MFA-TR*         AND   M1.MOVE_NO  = (SELECT MAX(M2.MOVE_NO)                     
MFA-TR*               FROM CSS_MOVEMENT_HIST M2                                 
MFA-TR*               WHERE M2.COMPANY_NO   = M1.COMPANY_NO                     
MFA-TR*               AND M2.DEVICE_NO      = M1.DEVICE_NO                      
MFA-TR*               AND M2.CODE_UTIL_TYPE = M1.CODE_UTIL_TYPE                 
MFA-TR*               AND M2.CODE_CRNT_LOC  = 'J')                              
MFA-TR*               WITH UR                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = ZERO OR NOT-FOUND                 
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '       CSS_MOVEMENT_HIST '                      
               DISPLAY '      7325-GET-PREMISE-FROM-MV '                
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' METER NO       = ' MV-DEVICE-NO                
               DISPLAY ' CODE UTIL TYPE = ' MV-CODE-UTIL-TYPE           
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7350-GET-PREMISE-FROM-AT.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET THE MOST CURRENT ACCOUNT NUMBER FOR THE PREMISE       *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                    ,PREMISE_NO                                         
                    ,COMPANY_NO                                         
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = ZERO OR NOT-FOUND                 
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '       ABENDING PROGRAM '                       
               DISPLAY '      CSS_ACCOUNT FETCH  '                      
               DISPLAY '     7350-GET-PREMISE-FROM-AT '                 
               DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY ' ACCOUNT NO     = ' E-FCA625-ACCOUNT-NO         
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7500-GET-CURRENT-TIMESTAMP.                                      
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    GET CURRENT DATE AND TIMESTAMP                            *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP  =  CURRENT TIMESTAMP                 
MFA-TR*            ,:WS-CURRENT-DATE       =  CURRENT DATE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURRENT DATE '                    
              DISPLAY ' 7500-GET-CURRENT-TIMESTAMP '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       7510-VERIFY-COLL-DATE-IS-VALID.                                  
      *==============================================================*          
      *--------------------------------------------------------------*          
      *    VERIFY THE INPUT COLLECTION DATE IS VALID.                *          
      *    THIS DATE ONLY HAS TO BE A GOOD DATE.                     *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
T35434          SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) )
            INTO
              :WS-WHO-CARES-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET  :WS-WHO-CARES-DATE  =                                      
MFA-TR*              DATE (:WS-CHECK-DATE) - 1 DAY                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
       7550-SELECT-RESTART-DATA.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      * THIS SELECTS A ROW FROM CSS_RESTART TO CHECK WHETHER THE     *          
      * CURRENT RUN IS A REGULAR RUN OR A RESTART.IF A ROW IS PRESENT*          
      * FOR THIS PROGRAM IT IS A RERUN, THE PROCESS STARTS FROM THE  *          
      * ACCOUNT AND PROCESS WHICH IS STORED IN RESTART-DATA          *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW143 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7550       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8200-WRITE-EXCEPTION-REPORT.                                     
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   WRITE THE EXCEPTION REPORT                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           PERFORM 8600-PRINT-REPORT THRU 8600-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8400-UPDATE-MTRD-ENVRNMT.                                        
      *==============================================================*          
      *--------------------------------------------------------------*          
      *   UPDATE CSS_MTRD_ENVRNMT WITH NEW LATITUDE & LONGITUDE      *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_MTRD_ENVRNMT                                  
               SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :MN-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAT-LONG-DT
              ) <> 0) OR (LEN(:MN-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :MN-LAT-LONG-DT
              ), CONVERT(DATE, :MN-LAT-LONG-DT) ),                
                   LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,         
                   MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,           
                   MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE           
               WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*        SET LAT_LONG_DT        = :MN-LAT-LONG-DT,                        
MFA-TR*            LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,                 
MFA-TR*            MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,                   
MFA-TR*            MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE                   
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                 MOVE WS-MSG-7 TO PRT-DESCRIPTION                       
                 PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT           
              ELSE                                                      
                  DISPLAY '****************************************'    
                  DISPLAY '       ABENDING PROGRAM '                    
                  DISPLAY '     MTRD-ENVRNMT UPDATE '                   
                  DISPLAY '   8400-UPDATE-MTRD-ENVRNMT '                
                  DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                  DISPLAY ' ACCOUNT NO     = ' E-FCA625-ACCOUNT-NO      
                  DISPLAY ' CODE-UTIL-TYPE = ' E-FCA625-G-E-W-IND       
                  DISPLAY ' METER-NO       = ' WS-METER-NO              
                  DISPLAY '****************************************'    
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
A03345 8420-UPDATE-BY-METER.                                            
A03345*==============================================================*          
A03345*--------------------------------------------------------------*          
A03345*   UPDATE CSS_MTRD_ENVRNMT WITH NEW LATITUDE & LONGITUDE      *          
A03345*--------------------------------------------------------------*          
A03345*                                                                         
A03345     EXEC SQL                                                     
A03345         UPDATE CSS_MTRD_ENVRNMT                                  
A03345         SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :MN-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAT-LONG-DT
              ) <> 0) OR (LEN(:MN-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :MN-LAT-LONG-DT
              ), CONVERT(DATE, :MN-LAT-LONG-DT) ),                
A03345             LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,         
A03345             MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,           
A03345             MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE           
A03345         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
A03345           AND METER_NO       = :MN-METER-NO                      
A03345           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                
A03345     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*        SET LAT_LONG_DT        = :MN-LAT-LONG-DT,                        
MFA-TR*            LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,                 
MFA-TR*            MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,                   
MFA-TR*            MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE                   
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*          AND METER_NO       = :MN-METER-NO                              
MFA-TR*          AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03345*                                                                         
A03345     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03345*                                                                         
A03345     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A03345         NEXT SENTENCE                                            
A03345     ELSE                                                         
A03345        IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
A03345           DISPLAY 'PCSCA625 METER NO ' MN-METER-NO               
A03345               ' WAS NOT FOUND AT ACCOUNT ' MN-ACCOUNT-NO         
A03345        ELSE                                                      
A03345            DISPLAY '****************************************'    
A03345            DISPLAY '       ABENDING PROGRAM '                    
A03345            DISPLAY '     MTRD-ENVRNMT UPDATE '                   
A03345            DISPLAY '   8420-UPDATE-MTRD-ENVRNMT '                
A03345            DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
A03345            DISPLAY ' ACCOUNT NO     = ' E-FCA625-ACCOUNT-NO      
A03345            DISPLAY ' CODE-UTIL-TYPE = ' E-FCA625-G-E-W-IND       
A03345            DISPLAY ' METER-NO       = ' WS-METER-NO              
A03345            DISPLAY '****************************************'    
A03345            PERFORM 9900-ABEND THRU 9900-EXIT                     
A03345        END-IF                                                    
A03345     END-IF.                                                      
A03345*                                                                         
A03345 8420-EXIT.                                                       
A03345     EXIT.                                                        
      *                                                                         
A03345*==============================================================*          
A03345 8430-UPDATE-ALL-METERS.                                          
A03345*==============================================================*          
A03345*--------------------------------------------------------------*          
A03345*   UPDATE CSS_MTRD_ENVRNMT WITH NEW LATITUDE & LONGITUDE      *          
A03345*--------------------------------------------------------------*          
A03345*                                                                         
A03345     EXEC SQL                                                     
A03345         UPDATE CSS_MTRD_ENVRNMT                                  
A03345         SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :MN-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAT-LONG-DT
              ) <> 0) OR (LEN(:MN-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :MN-LAT-LONG-DT
              ), CONVERT(DATE, :MN-LAT-LONG-DT) ),                
A03345             LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,         
A03345             MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,           
A03345             MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE           
A03345         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                    
A03345     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MTRD_ENVRNMT                                          
MFA-TR*        SET LAT_LONG_DT        = :MN-LAT-LONG-DT,                        
MFA-TR*            LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,                 
MFA-TR*            MTR_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,                   
MFA-TR*            MTR_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE                   
MFA-TR*        WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03345*                                                                         
A03345     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03345*                                                                         
A03345     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A03345         NEXT SENTENCE                                            
A03345     ELSE                                                         
A03345        IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
A03345            MOVE WS-MSG-7 TO PRT-DESCRIPTION                      
A03345            PERFORM 1300-EXCEPTION-REPORT THRU 1300-EXIT          
A03345        ELSE                                                      
A03345            DISPLAY '****************************************'    
A03345            DISPLAY '       ABENDING PROGRAM '                    
A03345            DISPLAY '     MTRD-ENVRNMT UPDATE '                   
A03345            DISPLAY '   8430-UPDATE-ALL-METERS   '                
A03345            DISPLAY ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
A03345            DISPLAY ' ACCOUNT NO     = ' E-FCA625-ACCOUNT-NO      
A03345            DISPLAY ' PREMISE NO     = ' WS-CPD99-PREMISE-NO      
A03345            DISPLAY '****************************************'    
A03345            PERFORM 9900-ABEND THRU 9900-EXIT                     
A03345        END-IF                                                    
A03345     END-IF.                                                      
A03345*                                                                         
A03345 8430-EXIT.                                                       
A03345     EXIT.                                                        
A03345*                                                                         
A03345 8470-UPDATE-PREMISE.                                             
A03345*==============================================================*          
A03345*--------------------------------------------------------------*          
A03345*    UPDATE THE PREMISE WITH LAT/LONG INFO                     *          
A03345*                                                              *          
A03345*--------------------------------------------------------------*          
A03345*                                                                         
A03345     EXEC SQL                                                     
A03345         UPDATE CSS_PREMISE                                       
A03345         SET LAT_LONG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :MN-LAT-LONG-DT
              ) IS NULL OR (PATINDEX('%.%', :MN-LAT-LONG-DT
              ) <> 0) OR (LEN(:MN-LAT-LONG-DT) <> 10), CIS.CHAR2DATE(
                                                        :MN-LAT-LONG-DT
              ), CONVERT(DATE, :MN-LAT-LONG-DT) ),                
A03345             LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,         
A03345             PREM_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,          
A03345             PREM_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE          
A03345         WHERE PREMISE_NO     = :WS-CPD99-PREMISE-NO              
A03345     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*        SET LAT_LONG_DT        = :MN-LAT-LONG-DT,                        
MFA-TR*            LAT_LONG_SOURCE_CD = :MN-LAT-LONG-SOURCE-CD,                 
MFA-TR*            PREM_REF_LATITUDE   = :MN-MTR-REF-LATITUDE,                  
MFA-TR*            PREM_REF_LONGITUDE  = :MN-MTR-REF-LONGITUDE                  
MFA-TR*        WHERE PREMISE_NO     = :WS-CPD99-PREMISE-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03345     MOVE WS-CPD99-PREMISE-NO TO WS-LAST-PREMISE-UPDATED.         
A03345     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03345     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A03345         NEXT SENTENCE                                            
A03345     ELSE                                                         
A03345         DISPLAY '****************************************'       
A03345         DISPLAY '**     PCSCA625 PROCESSING ERROR      **'       
A03345         DISPLAY '**      ABEND IN PARAGRAPH 8470       **'       
A03345         DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
A03345         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A03345         DISPLAY '**      PREMISE = ' WS-CPD99-PREMISE-NO         
A03345         DISPLAY '****************************************'       
A03345         PERFORM 9900-ABEND THRU 9900-EXIT                        
A03345     END-IF.                                                      
A03345 8470-EXIT.                                                       
A03345     EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8500-PRINT-HEADERS.                                              
      *==============================================================*          
      *--------------------------------------------------------------*          
      *        WRITES THE HEADER TO THE REPORT FILE                  *          
      *--------------------------------------------------------------*          
      *                                                                         
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER1 AFTER NEW-PAGE.              
      *                                                                         
           IF E-FCA625-GIS-SOURCE-CD = 'D'                              
               WRITE PRT33-RECORD FROM HEADER2B AFTER 1                 
           ELSE                                                         
               WRITE PRT33-RECORD FROM HEADER2  AFTER 1                 
           END-IF                                                       
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER3 AFTER 2.                     
      *                                                                         
           WRITE PRT33-RECORD FROM HEADER4 AFTER 1.                     
      *                                                                         
           MOVE SPACES TO PRT33-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE +6 TO WS-LINE-COUNT.                                    
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8600-PRINT-REPORT.                                               
      *==============================================================*          
      *--------------------------------------------------------------*          
      *        WRITES THE OUTPUT RECORDS TO THE REPORT FILE          *          
      *--------------------------------------------------------------*          
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8500-PRINT-HEADERS THRU 8500-EXIT                 
           END-IF                                                       
      *                                                                         
           MOVE PRINT-LINE TO PRT33-RECORD.                             
      *                                                                         
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8896-UPDATE-RESTART.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      * UPDATES A ROW IN CSS_RESTART BEFORE EVERY COMMIT             *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA625 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 8896       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8897-INSERT-RESTART.                                             
      *==============================================================*          
      *--------------------------------------------------------------*          
      * INSERTS A ROW INTO CSS_RESTART WHEN THERE IS NO ROW FOR      *          
      * RESTART DATA                                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM                                        
                   ,PARTITION_NO                                        
                   ,DUP_CNTRL_NO                                        
                   ,RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM                                    
                   ,:RF-PARTITION-NO                                    
                   ,:RF-DUP-CNTRL-NO                                    
                   ,:RF-RESTART-DATA)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA625 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 8897       **'       
               DISPLAY '**      NAME_PROGRAM  = ' RF-NAME-PROGRAM       
               DISPLAY '**      PARTITION_NO  = ' RF-PARTITION-NO       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8898-ISSUE-CHKP.                                                 
      *==============================================================*          
      *                                                                         
           ADD 1                           TO WS-CHKP-SEQ-NO.           
           MOVE WS-CHKP-SEQ-NO             TO WS-RESTART-CHKP-SEQ-NO.   
      *                                                                         
           PERFORM 8899-WRITE-RSDDR THRU 8899-EXIT.                     
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN. '          
           DISPLAY 'LAST RECORD PROCESSED: '                            
                    FIOCA625-RECORD(1:83)  '......'                     
           .                                                            
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8899-WRITE-RSDDR.                                                
      *==============================================================*          
      *--------------------------------------------------------------*          
      * POPULATES THE RESTART-DATA BEFORE IT IS STORED IN CSS_RESTART*          
      * AND UPDATES/INSERTS THE RESTART-DATA IN CSS_RESTART          *          
      *--------------------------------------------------------------*          
      *                                                                         
           MOVE PROGRAM-NAME               TO RF-NAME-PROGRAM           
           MOVE 1                          TO RF-DUP-CNTRL-NO           
                                              RF-PARTITION-NO           
           MOVE WS-RESTART-DATA            TO RF-RESTART-DATA-TEXT      
           MOVE WS-RESTART-DATA-LENGTH     TO RF-RESTART-DATA-LEN       
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT                   
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               PERFORM 8897-INSERT-RESTART THRU 8897-EXIT               
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *==============================================================*          
       8900-WRITE-REPORT.                                               
      *==============================================================*          
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A37741****************************************************************          
A37741* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A37741****************************************************************          
A37741 9000-SEND-ERROR-RESULT.                                          
A37741                                                                  
A37741     GO TO 9000-EXIT.                                             
A37741*                                                                         
      *==============================================================*          
       9000-TERMINATE.                                                  
      *==============================================================*          
      *                                                                         
           CLOSE FCSCA625-FILE.                                         
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *              
      * COPYBOOK FOR WRITING THE MH AND MI.                      *              
      ************************************************************              
      *                                                                         
      *==============================================================*          
       9900-SQL-ERROR-ROUTINE.                                          
      *==============================================================*          
           GO TO 9900-EXIT.                                             
      *                                                                         
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE                      *          
      *  MOVES 12 TO RETURN CODE                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6235-GET-FJC01-RESTART-REQ.                                          
      *****************************************************************         
       COPY CPD00035.                                                           
      *                                                                         
      *****************************************************************         
      *    0605-VALIDATE-RESTART                                      *         
      *****************************************************************         
       COPY CPD00030.                                                           
      *                                                                         
      ****************************************************************          
      *    6253-GET-FJC01-CHKP-LIMIT.                                           
      ****************************************************************          
       COPY CPD00034.                                                           
      *                                                                         
      ****************************************************************          
      * 6530-LOAD-MNT-TRANS-HIST                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  6990-FETCH-CUR-ACCOUNT                                      *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  ERROR ROUTINE FOR CPD00099 - GETTING MOST CURRENT ACCT NO   *          
      ****************************************************************          
      *                                                                         
      *****************************************************************         
      **************** END OF PCSCA625 *******************************          
