       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA624.                                        
       DATE-WRITTEN.   FEB 2005.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **               PROGRAM  MODIFICATION  LOG                    **         
      **                                                             **         
      **    DATE     INITIALS                 REASON                 **         
      **  ________   ________   ___________________________________  **         
      **                                                             **         
      **  02/10/05   SG18894    INITIAL NEW PROGRAM                  **         
T32676**  08/09/05   GOKUL      TO ADD EFFECTIVE_DT AS A KEY TO      **         
T32676**                        CSS_BTU_WNA_RANGE.                   **         
C32676**  09/06/05   VIJAY      CHANGES MADE TO CALCULATE WNA USING  **         
C32676**                        NEW RATES AND FORMULA WEF 2005/11.   **         
A04735**  07/16/2013 MC95456    REMOVE REFERENCE OF CSS_WNA_GAS_RATE **         
      **                                                             **         
A05460** 12 DEC 2016 RF10596    REMOVE JCL PARM - UPDATE JOB PARM    **         
      **                                                             **         
A05744** 23 FEB 2017 RF10596    ADD TOTAL THERMS TO OUTPUT FILE      **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA624 NARRATIVE                        
              **********************************************************
               THIS PROGRAM IS WRITTEN TO GIVE WNA NUMBERS TO HARRY     
               SCRUGGS FOR HIS RATE CASE. HE CAN INPUT THE REVENUE      
               MONTHS THROUGH JOB-PARM AND REQUEST THE JOB.             
      *                                                                         
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-3090.                                    
       OBJECT-COMPUTER.    IBM-3090.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FCSCA624-FILE                                         
               ASSIGN TO UT-S-FCSCA624                                  
               FILE STATUS IS WS-FCSCA624-STATUS.                       
HPCCDM*EJECT                                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSCA624-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01 E-FCA624-RECORD.                                              
          05  E-FCA624-ACCOUNT-NO      PIC S9(13)V COMP-3.              
          05  E-FCA624-ACCT-STAT       PIC X(01).                       
          05  E-FCA624-LOC-OFF         PIC X(03).                       
          05  E-FCA624-RATE            PIC X(03).                       
          05  E-FCA624-CLASS           PIC X(03).                       
          05  E-FCA624-REV-DIST        PIC X(03).                       
          05  E-FCA624-BILL-RATE       PIC X(03).                       
          05  E-FCA624-ATH-BASE-USE    PIC S9(7)V     COMP-3.           
          05  E-FCA624-BILLED-WNA      PIC S9(1)V9(5) COMP-3.           
          05  E-FCA624-ACTUAL-WNA      PIC S9(1)V9(5) COMP-3.           
          05  E-FCA624-RATE-1          PIC S9(1)V9(5) COMP-3.           
          05  E-FCA624-RATE-2          PIC S9(1)V9(5) COMP-3.           
          05  E-FCA624-R1-WSL          PIC S9(7)V     COMP-3.           
          05  E-FCA624-R2-WSL          PIC S9(7)V     COMP-3.           
          05  E-FCA624-R1-WNA-FACT     PIC S9(2)V9(5) COMP-3.           
          05  E-FCA624-R2-WNA-FACT     PIC S9(2)V9(5) COMP-3.           
          05  E-FCA624-R1-WNA-AMT      PIC S9(9)V9(2) COMP-3.           
          05  E-FCA624-R2-WNA-AMT      PIC S9(9)V9(2) COMP-3.           
          05  E-FCA624-REV-MONTH       PIC S9(6) COMP-3.                
          05  E-FCA624-WNA-HI-FL       PIC X(01).                       
A05744    05  E-FCA624-THERMS          PIC S9(7)V     COMP-3.           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA624'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR PCSCA624 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
COB305     05 WS-ORIG-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
           05  WS-MAX-REV-MM           PIC 9(06) VALUE 0.               
           05  WS-REVENUE-MONTH        PIC 9(06) VALUE 0.               
           05  WS-REVENUE-MONTH-N      PIC 9(06) VALUE 0.               
           05  WS-REVENUE-MONTH-TEMP REDEFINES WS-REVENUE-MONTH-N.      
               10  WS-REVENUE-MONTH-YYYY PIC 9(04).                     
               10  WS-REVENUE-MONTH-MM   PIC 9(02).                     
           05  WS-PROCESS-TYPE         PIC X(01) VALUE ' '.             
           05  WS-RATE-PLAN-NO         PIC X(03).                       
           05  WS-RATE                 PIC X(01) VALUE ' '.             
           05  WS-CODE-REVENUE-CLASS   PIC X(03).                       
           05  WS-BEGIN-CYCLE          PIC X(02).                       
           05  WS-END-CYCLE            PIC X(02).                       
COB305     05 WS-BEGIN-REV-MM        PIC S9(6)V COMP-3 VALUE 0.               
COB305     05 WS-END-REV-MM        PIC S9(6)V COMP-3 VALUE 0.               
           05  WS-NULL-IND-1           PIC S9(4)  COMP.                 
           05  WS-NULL-IND-2           PIC S9(4)  COMP.                 
           05  WS-NULL-IND-3           PIC S9(4)  COMP.                 
           05  WS-NULL-IND-4           PIC S9(4)  COMP.                 
           05  WS-NULL-IND-5           PIC S9(4)  COMP.                 
           05  WS-INDX                 PIC S9(4)  COMP.                 
           05  WS-DISPLAY-RC           PIC S9(09) COMP.                 
COB305     05 WS-ACCUM-THERMS        PIC S9(11)V COMP-3 VALUE 0.              
           05  WS-ACCUM-DAYS           PIC S9(4)  COMP.                 
           05  WS-BASE-USE-FL          PIC X(01) VALUE SPACES.          
COB305     05 WS-BASE-USE-WORK        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-BASE-USE        PIC S9(09) COMP-3 VALUE 0.            
           05  WS-SEASON-CODE          PIC X(1) VALUE SPACES.           
           05  WS-NO-MORE-BG-SW        PIC X(01)  VALUE 'N'.            
           05  WS-FCSCA624-STATUS      PIC X(02).                       
               88  FCSCA624-SUCCESSFUL             VALUE '00'.          
           05 WS-CURR-READ-DT.                                          
              10 WS-CURR-READ-YYYY.                                     
                15 WS-CURR-READ-CC     PIC 99.                          
                15 WS-CURR-READ-YY     PIC 99.                          
              10 WS-F3                 PIC X       VALUE '-'.           
              10 WS-CURR-READ-MN       PIC 99.                          
              10 WS-F4                 PIC X       VALUE '-'.           
              10 WS-CURR-READ-DD       PIC 99.                          
C32676     05 WS-EFFECTIVE-DT-BR       PIC X(10)   VALUE SPACES.        
      *                                                                         
       01  WS-WNA-CALC-FIELDS.                                          
           05  WS-WNA-BASE-USE         PIC S9(09)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WNA-CURR-USE         PIC S9(09)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-BASE-USE-ADJUST      PIC S9(09)      COMP-3           
                                                       VALUE ZERO.      
           05  WS-PRORATE-USE          PIC S9(09)      COMP-3           
                                                       VALUE ZERO.      
           05  WS-WORK-DEGREE          PIC S9(05)V99   USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WORK-WSL             PIC S9(10)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-LIM-MINUS-ATH        PIC S9(7)V     COMP-3            
                                                       VALUE ZERO.      
           05  WS-ATH-MINUS-BTH        PIC S9(7)V     COMP-3            
                                                       VALUE ZERO.      
           05  WS-RATE-WORK1           PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-RATE-WORK2           PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-RATE-WORK            PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WSL-INTERMED         PIC S9(5)V9(05) USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WSL-FINAL            PIC S9(5)V9(05) USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WSL-ROUNDED-FINAL    PIC S9(05)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WNA-FACTOR           PIC S9V9(05)    USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-BILLED-WNA           PIC S9V9(05)    USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-CALC-ADD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-CALC-NDD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA624'.      
           05  WS-COMPANY-NO           PIC X(02) VALUE '01'.            
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-D                    PIC X(01) VALUE 'D'.             
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA624'.      
           05  WS-811                  PIC S9(09) VALUE -811 COMP.      
      *                                                                         
       01  WS-PARM-DATA.                                                
           05  WS-PARM-DETAILS.                                         
A05460         10  WS-PARM-REV-HDR     PIC X(17).                       
A05460             88  PARM-HDR        VALUE 'REVENUE MONTHS = '.       
A05460         10  WS-PARM-BEG-MM      PIC X(6).                        
A05460         10  FILLER              PIC X.                           
A05460         10  WS-PARM-END-MM      PIC X(6).                        
A05460         10  FILLER              PIC X(50).                       
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00038.                                                           
       COPY CWS09900.                                                           
       COPY FIOJC01.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBBTUWNA                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBPRCSCH                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBRTCRTR                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                         
      *********************** CURSOR DECLARATIVES ***************               
      *                                                                         
      * CURSOR TO SELECT ALL WNA RATE ACCOUNTS                                  
           EXEC SQL                                                     
               DECLARE MAIN_CSR CURSOR FOR                              
                 SELECT  AT.ACCOUNT_NO                                  
                        ,AT.CODE_ACCT_STAT                              
                        ,AT.LOCAL_OFFICE                                
                        ,UT.IC_NO                                       
                        ,AT.BILL_CYCLE                                  
                        ,AT.COMPANY_NO                                  
                        ,UT.RATE_PLAN_NO                                
                        ,UT.CODE_REVENUE_CLASS                          
                        ,PR.REV_DISTRICT_CD                             
                        ,AT.ACCT_XFER_TO                                
                        ,C7.MIN_PRORATION_DAYS                          
                        ,C7.MAX_PRORATION_DAYS                          
                   FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)              
                       ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)              
                       ,CSS_PREMISE       PR WITH(READUNCOMMITTED)              
                       ,CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)              
                       ,CSS_COMPANY       C7 WITH(READUNCOMMITTED)              
                  WHERE AT.COMPANY_NO = C7.COMPANY_NO                   
                    AND UT.CODE_UTIL_TYPE = 'G'                         
                    AND UT.COMPANY_NO = AT.COMPANY_NO                   
                    AND PR.COMPANY_NO = AT.COMPANY_NO                   
                    AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                   
                    AND UT.PREMISE_NO = AT.PREMISE_NO                   
                    AND PR.PREMISE_NO = UT.PREMISE_NO                   
                    AND BR.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND BR.RATE_PLAN_NO   = UT.RATE_PLAN_NO             
                    AND (BR.WNA_UPPER_LIMIT <> 0                        
                     OR  BR.WNA_LOWER_LIMIT <> 0)                       
T32676              AND BR.EFFECTIVE_DT = (SELECT MAX(B1.EFFECTIVE_DT)  
T32676                                  FROM CSS_BTU_WNA_RANGE B1
                           WITH(READUNCOMMITTED)       
T32676                               WHERE ((B1.WNA_UPPER_LIMIT <> 0 OR 
T32676                                       B1.WNA_LOWER_LIMIT <> 0)   
T32676                       AND B1.RATE_PLAN_NO = BR.RATE_PLAN_NO      
T32676                       AND B1.CODE_UTIL_TYPE = BR.CODE_UTIL_TYPE))
                    AND AT.CODE_ACCT_STAT <> 'P'                        
                    AND C7.CALC_BASE_USE_FL = 'Y'                       
                    AND AT.REV_MTH_LST_NRML <> 0                        
A04735        FOR READ ONLY                                     
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MAIN_CSR CURSOR FOR                                      
MFA-TR*          SELECT  AT.ACCOUNT_NO                                          
MFA-TR*                 ,AT.CODE_ACCT_STAT                                      
MFA-TR*                 ,AT.LOCAL_OFFICE                                        
MFA-TR*                 ,UT.IC_NO                                               
MFA-TR*                 ,AT.BILL_CYCLE                                          
MFA-TR*                 ,AT.COMPANY_NO                                          
MFA-TR*                 ,UT.RATE_PLAN_NO                                        
MFA-TR*                 ,UT.CODE_REVENUE_CLASS                                  
MFA-TR*                 ,PR.REV_DISTRICT_CD                                     
MFA-TR*                 ,AT.ACCT_XFER_TO                                        
MFA-TR*                 ,C7.MIN_PRORATION_DAYS                                  
MFA-TR*                 ,C7.MAX_PRORATION_DAYS                                  
MFA-TR*            FROM CSS_ACCOUNT       AT                                    
MFA-TR*                ,CSS_UTIL_ENVRNMT  UT                                    
MFA-TR*                ,CSS_PREMISE       PR                                    
MFA-TR*                ,CSS_BTU_WNA_RANGE BR                                    
MFA-TR*                ,CSS_COMPANY       C7                                    
MFA-TR*           WHERE AT.COMPANY_NO = C7.COMPANY_NO                           
MFA-TR*             AND UT.CODE_UTIL_TYPE = 'G'                                 
MFA-TR*             AND UT.COMPANY_NO = AT.COMPANY_NO                           
MFA-TR*             AND PR.COMPANY_NO = AT.COMPANY_NO                           
MFA-TR*             AND UT.ACCOUNT_NO = AT.ACCOUNT_NO                           
MFA-TR*             AND UT.PREMISE_NO = AT.PREMISE_NO                           
MFA-TR*             AND PR.PREMISE_NO = UT.PREMISE_NO                           
MFA-TR*             AND BR.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                   
MFA-TR*             AND BR.RATE_PLAN_NO   = UT.RATE_PLAN_NO                     
MFA-TR*             AND (BR.WNA_UPPER_LIMIT <> 0                                
MFA-TR*              OR  BR.WNA_LOWER_LIMIT <> 0)                               
MFA-TR*             AND BR.EFFECTIVE_DT = (SELECT MAX(B1.EFFECTIVE_DT)          
MFA-TR*                                 FROM CSS_BTU_WNA_RANGE B1               
MFA-TR*                              WHERE ((B1.WNA_UPPER_LIMIT <> 0 OR         
MFA-TR*                                      B1.WNA_LOWER_LIMIT <> 0)           
MFA-TR*                      AND B1.RATE_PLAN_NO = BR.RATE_PLAN_NO              
MFA-TR*                      AND B1.CODE_UTIL_TYPE = BR.CODE_UTIL_TYPE))        
MFA-TR*             AND AT.CODE_ACCT_STAT <> 'P'                                
MFA-TR*             AND C7.CALC_BASE_USE_FL = 'Y'                               
MFA-TR*             AND AT.REV_MTH_LST_NRML <> 0                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************01993200
      *    CURSOR TO LOOK THROUGH EACH BILL                             01993300
      ******************************************************************01993400
      *                                                                 01993500
           EXEC SQL                                                     
              DECLARE BG_CURSOR CURSOR FOR                              
              SELECT  BILL_NO                                           
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                                
                     ,CASE                                              
                        WHEN REV_MTH_ORIG_BILL > 0                      
                           THEN REV_MTH_ORIG_BILL                       
                           ELSE REVENUE_MONTH                           
                      END AS REVENUE_MONTH                              
                     ,REV_DISTRICT_CD                                   
                     ,RATE_PLAN_NO                                      
                     ,CODE_REVENUE_CLASS                                
                     ,NO_OF_CONS_DAYS                                   
                     ,WNA_FACTOR                                        
                     ,GAS_BASE_USE                                      
              FROM    CSS_BILLING_DET WITH(READUNCOMMITTED)                     
              WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO                   
                AND   CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               
                AND   IC_NO          = :BG-IC-NO                        
                AND ((REV_MTH_ORIG_BILL = 0                             
                AND   REVENUE_MONTH                                     
                         BETWEEN :WS-BEGIN-REV-MM                       
                             AND :WS-END-REV-MM)                        
                 OR   REV_MTH_ORIG_BILL                                 
                         BETWEEN :WS-BEGIN-REV-MM                       
                             AND :WS-END-REV-MM )                       
                AND   CODE_BILL_ITM_TYPE = 'C'                          
                AND   CODE_BILL_ITM_IND  = 'A'                          
                AND  (WNA_FACTOR         > 0                            
                 OR   WNA_FACTOR         < 0)                           
A04735        FOR READ ONLY                                     
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01993600
MFA-TR*       DECLARE BG_CURSOR CURSOR FOR                              01993700
MFA-TR*       SELECT  BILL_NO                                           01993900
MFA-TR*              ,BILL_ITEM_TIMESTMP                                01994100
MFA-TR*              ,CASE                                                      
MFA-TR*                 WHEN REV_MTH_ORIG_BILL > 0                              
MFA-TR*                    THEN REV_MTH_ORIG_BILL                               
MFA-TR*                    ELSE REVENUE_MONTH                                   
MFA-TR*               END AS REVENUE_MONTH                                      
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,NO_OF_CONS_DAYS                                           
MFA-TR*              ,WNA_FACTOR                                        01993800
MFA-TR*              ,GAS_BASE_USE                                              
MFA-TR*       FROM    CSS_BILLING_DET                                   01994300
MFA-TR*       WHERE   ACCOUNT_NO     = :BG-ACCOUNT-NO                           
MFA-TR*         AND   CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE               01995400
MFA-TR*         AND   IC_NO          = :BG-IC-NO                        01995500
MFA-TR*         AND ((REV_MTH_ORIG_BILL = 0                                     
MFA-TR*         AND   REVENUE_MONTH                                             
MFA-TR*                  BETWEEN :WS-BEGIN-REV-MM                               
MFA-TR*                      AND :WS-END-REV-MM)                                
MFA-TR*          OR   REV_MTH_ORIG_BILL                                         
MFA-TR*                  BETWEEN :WS-BEGIN-REV-MM                               
MFA-TR*                      AND :WS-END-REV-MM )                               
MFA-TR*         AND   CODE_BILL_ITM_TYPE = 'C'                                  
MFA-TR*         AND   CODE_BILL_ITM_IND  = 'A'                                  
MFA-TR*         AND  (WNA_FACTOR         > 0                                    
MFA-TR*          OR   WNA_FACTOR         < 0)                                   
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                    01996000
      *                                                                         
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      *   CONTROLS MAIN PATH OF PROGRAM                                *        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7000-OPEN-CURSOR THRU 7000-OPEN-EXIT.                
           PERFORM 7000-FETCH-CURSOR THRU 7000-FETCH-EXIT.              
      *                                                                         
           PERFORM 1000-MAIN-PROCESSING THRU 1000-EXIT UNTIL            
             SQLCODE = NOT-FOUND                                        
                                                                        
           PERFORM 7000-CLOSE-CURSOR THRU 7000-CLOSE-EXIT.              
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
       0100-INITIALIZATION.                                             
      ****************************************************************          
      *                                                                         
           OPEN OUTPUT FCSCA624-FILE.                                   
           IF FCSCA624-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA624 **'      
              DISPLAY '**     PARA - 0100-INITIALIZATION       **'      
              DISPLAY '** ERROR DURING OPEN OF FILE FCSCA624    **'     
              DISPLAY '** RC = ' WS-FCSCA624-STATUS                     
              DISPLAY '** PROCESSING TERMINATED                **'      
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           MOVE ' '                    TO WS-RATE.                      
           INITIALIZE E-FCA624-RECORD.                                  
           MOVE ZEROS                  TO E-FCA624-RATE-1               
                                          E-FCA624-RATE-2               
                                          E-FCA624-R1-WSL               
                                          E-FCA624-R2-WSL               
                                          E-FCA624-R1-WNA-FACT          
                                          E-FCA624-R2-WNA-FACT          
                                          E-FCA624-R1-WNA-AMT           
                                          E-FCA624-R2-WNA-AMT.          
      *                                                                         
      * GET  PARM DETAILS                                                       
      *                                                                         
           MOVE  WS-PGRMNAME           TO WS-PROGRAM.                   
           MOVE  WS-PARM               TO WS-COMMAND.                   
           MOVE  ZEROS                 TO WS-SEQUENCE.                  
           MOVE  SPACES                TO WS-SYSIPT.                    
           MOVE  WS-KEY-AREA           TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
A05460         UNTIL (WS-INPUT-DATA-BREAKDOWN(1:17) =                   
A05460                   'REVENUE MONTHS = '  AND INPUT-ACTIVE)         
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF  END-OF-SYSIPT                                            
               DISPLAY '******************************************'     
               DISPLAY '***    PROCESSING ERROR IN PCSCA624    ***'     
               DISPLAY '*** NO ACTIVE REVENUE MONTH RANGE PARM ***'     
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           ELSE                                                         
               MOVE G6-PARM-DATA       TO WS-PARM-DATA                  
               MOVE WS-PARM-BEG-MM     TO WS-BEGIN-REV-MM               
               MOVE WS-PARM-END-MM     TO WS-END-REV-MM                 
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
               DISPLAY '******************************************'     
               DISPLAY '**  PCSCA624 PROCESSING FOR REV MONTHS: '       
                    WS-BEGIN-REV-MM ' THROUGH ' WS-END-REV-MM ' **'     
               DISPLAY '******************************************'     
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * MAIN PROCESSING                                               *         
      *****************************************************************         
       1000-MAIN-PROCESSING.                                            
      *                                                                         
           MOVE WS-BEGIN-REV-MM        TO WS-REVENUE-MONTH.             
           MOVE WS-END-REV-MM          TO WS-MAX-REV-MM.                
           PERFORM 1050-RECALCULATE-WNA THRU 1050-EXIT.                 
      *                                                                         
           PERFORM 7000-FETCH-CURSOR THRU 7000-FETCH-EXIT.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * RECALCULATE WNA                                               *         
      *****************************************************************         
       1050-RECALCULATE-WNA.                                            
      *                                                                         
           MOVE 'G'                    TO BG-CODE-UTIL-TYPE.            
           MOVE AT-ACCOUNT-NO          TO BG-ACCOUNT-NO.                
           MOVE UT-IC-NO               TO BG-IC-NO.                     
           PERFORM 1100-PROCESS-ALL-BG THRU 1100-EXIT.                  
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * PROCESS EACH BG                                               *         
      *****************************************************************         
       1100-PROCESS-ALL-BG.                                             
           MOVE 'N'                    TO  WS-NO-MORE-BG-SW.            
      *                                                                         
           PERFORM 7050-OPEN-BG-CURSOR  THRU 7050-EXIT.                 
           PERFORM 7060-FETCH-BG-CURSOR THRU 7060-EXIT.                 
      *                                                                         
           PERFORM UNTIL WS-NO-MORE-BG-SW = 'Y'                         
               MOVE SPACES             TO BZ-CONSUMPT-TYPE-CD           
               MOVE ZEROS              TO WS-NULL-IND-4                 
                                              WS-NULL-IND-5             
                                              BZ-BILL-UNITS             
                                              BZ-WNA-COMP-AM            
               PERFORM 7075-GET-BILLED-WNA THRU 7075-EXIT               
               PERFORM 1200-CALC-NEW-WNA THRU 1200-EXIT                 
               PERFORM 2000-PROCESS-FCSCA624 THRU 2000-EXIT             
               PERFORM 7060-FETCH-BG-CURSOR THRU 7060-EXIT              
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7070-CLOSE-BG-CURSOR THRU 7070-EXIT.                 
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * PROCESS TO GET NEW WNA                                        *         
      *****************************************************************         
       1200-CALC-NEW-WNA.                                               
      *                                                                         
           IF  BG-NO-OF-CONS-DAYS < C7-MIN-PRORATION-DAYS OR            
               BG-NO-OF-CONS-DAYS > C7-MAX-PRORATION-DAYS               
               COMPUTE WS-BASE-USE-ADJUST ROUNDED                       
                  = BG-GAS-BASE-USE * BG-NO-OF-CONS-DAYS / 30           
           ELSE                                                         
               COMPUTE WS-BASE-USE-ADJUST = BG-GAS-BASE-USE             
           END-IF                                                       
      *                                                                         
           IF  WS-BASE-USE-ADJUST > BZ-BILL-UNITS                       
               MOVE ZEROS              TO BZ-WNA-COMP-AM                
               GO TO 1200-EXIT                                          
           END-IF                                                       
      *                                                                         
           MOVE ZEROS                  TO WS-NULL-IND-3.                
           PERFORM 7100-SELECT-CX-DETAILS THRU 7100-EXIT.               
           IF  SQLCODE EQUAL NOT-FOUND OR WS-NULL-IND-3 = -1            
           DISPLAY '* NOT FOUND ON CX = ' BG-ACCOUNT-NO, '; ',          
                        BG-BILL-NO, '; ', BG-REVENUE-MONTH              
               MOVE ZEROS              TO CX-NO-DAYS                    
           END-IF                                                       
      *                                                                         
           MOVE ZEROS                  TO WS-NULL-IND-1                 
                                          WS-NULL-IND-2.                
           MOVE BG-NO-OF-CONS-DAYS     TO CX-NO-DAYS.                   
           MOVE CX-DATE-READ           TO WS-CURR-READ-DT.              
      *                                                                         
C32676     MOVE WS-CURR-READ-DT        TO WS-EFFECTIVE-DT-BR.           
C32676     MOVE '01'                   TO WS-EFFECTIVE-DT-BR (9:2).     
      *                                                                         
           IF  BG-NO-OF-CONS-DAYS < C7-MIN-PRORATION-DAYS               
               MOVE 30                 TO CX-NO-DAYS                    
           END-IF                                                       
      *                                                                         
           PERFORM 7200-GET-CURR-ADD-NDD THRU 7200-EXIT.                
           MOVE ZEROS                  TO WS-BILLED-WNA                 
                                          BR-WNA-LOWER-LIMIT            
                                          BR-WNA-UPPER-LIMIT            
                                          BZ-WNA-COMP-AM.               
           MOVE WS-BASE-USE-ADJUST     TO WS-WNA-BASE-USE               
           MOVE BZ-BILL-UNITS          TO WS-WNA-CURR-USE               
           MOVE BG-RATE-PLAN-NO        TO BR-RATE-PLAN-NO               
                                          WS-RATE-PLAN-NO               
           PERFORM 7260-SELECT-BTU-WNA-RANGE THRU 7260-EXIT.            
           IF  BZ-CONSUMPT-TYPE-CD = 'D'                                
               COMPUTE WS-WNA-BASE-USE = WS-WNA-BASE-USE * 10           
               COMPUTE WS-WNA-CURR-USE = WS-WNA-CURR-USE * 10           
               COMPUTE BR-WNA-LOWER-LIMIT = BR-WNA-LOWER-LIMIT / 10.0   
               COMPUTE BR-WNA-UPPER-LIMIT = BR-WNA-UPPER-LIMIT / 10.0   
           END-IF.                                                      
      *                                                                         
           IF  BR-WNA-LOWER-LIMIT = 0 AND BR-WNA-UPPER-LIMIT = 0        
               MOVE ZEROS              TO WS-WNA-FACTOR                 
                                          WS-BILLED-WNA                 
           ELSE                                                         
               PERFORM 1400-CALCULATE-WNA-FACT THRU 1400-EXIT           
           END-IF.                                                      
      *                                                                         
           MOVE WS-BILLED-WNA          TO E-FCA624-ACTUAL-WNA           
      *                                                                         
           IF  WS-BILLED-WNA > BR-WNA-UPPER-LIMIT                       
               MOVE BR-WNA-UPPER-LIMIT TO WS-BILLED-WNA                 
               MOVE 'Y'                TO E-FCA624-WNA-HI-FL            
           ELSE                                                         
               MOVE 'N'                TO E-FCA624-WNA-HI-FL            
           END-IF                                                       
           IF  WS-BILLED-WNA < BR-WNA-LOWER-LIMIT                       
               MOVE BR-WNA-LOWER-LIMIT TO WS-BILLED-WNA                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-BILLED-WNA          TO BG-WNA-FACTOR                 
                                          E-FCA624-BILLED-WNA.          
      *                                                                         
           PERFORM 1500-CALC-WNA-AMT THRU 1500-EXIT.                    
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CALCULATE WNA FACTOR                                          *         
      *****************************************************************         
       1400-CALCULATE-WNA-FACT.                                         
           MOVE ZEROS                  TO E-FCA624-RATE-1               
                                          E-FCA624-RATE-2               
                                                                        
      **   ATH-BTH                                                      03628000
           COMPUTE WS-ATH-MINUS-BTH  =                                  
                     WS-WNA-CURR-USE - WS-WNA-BASE-USE                  
      **   NDD-ADD                                                      03628000
           COMPUTE WS-WORK-DEGREE = WS-CALC-NDD - WS-CALC-ADD.          
                                                                        
      **   (ATH - BTH) / ADD                                            03628000
           IF WS-CALC-ADD = ZERO                                        
              MOVE ZERO                TO WS-WSL-INTERMED               
           ELSE                                                         
              COMPUTE WS-WSL-INTERMED  = WS-ATH-MINUS-BTH / WS-CALC-ADD 
           END-IF.                                                      
                                                                        
           IF WS-WSL-INTERMED < ZERO                                    
              MOVE ZERO                TO WS-WSL-INTERMED               
           END-IF.                                                      
                                                                        
      **   WSL = ((ATH - BTH) / ADD) * (NDD - ADD)                      03628000
           COMPUTE WS-WSL-FINAL = WS-WSL-INTERMED * WS-WORK-DEGREE.     
           COMPUTE WS-WSL-ROUNDED-FINAL ROUNDED = WS-WSL-FINAL.         
                                                                        
C32676***************************************************************           
      *    CALCUATE WNA WITH NEW FORMULA AND RATES WEF 2005-11-01.              
      *    WS-EFFECIVE-DT-BR = WS-CURR-READ-DT WITH 01 IN DD PART.              
      ***************************************************************           
                                                                        
C32676     IF  WS-ATH-MINUS-BTH < ZERO                                  
C32676         MOVE ZERO               TO WS-ATH-MINUS-BTH              
C32676     END-IF.                                                      
C32676*                                                                 04132600
C32676     IF  WS-ATH-MINUS-BTH = ZERO                                  
C32676         MOVE ZERO               TO WS-WNA-FACTOR                 
C32676     ELSE                                                         
C32676         COMPUTE WS-WNA-FACTOR ROUNDED = (WS-WSL-ROUNDED-FINAL *  
C32676                            BR-WNA-GAS-RATE) / WS-ATH-MINUS-BTH   
C32676     END-IF.                                                      
C32676                                                                  
C32676     MOVE WS-WNA-FACTOR          TO WS-BILLED-WNA.                
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 04134200
      ******************************************************************        
      **  CALC WNA AMOUNT                                             **        
      ******************************************************************        
       1500-CALC-WNA-AMT.                                               
      *                                                                         
           IF  BZ-CONSUMPT-TYPE-CD = 'D'                                
               COMPUTE BG-WNA-FACTOR = BG-WNA-FACTOR * 10.0             
           END-IF.                                                      
      *                                                                         
           IF  BG-NO-OF-CONS-DAYS = 0 OR BZ-BILL-UNITS = 0              
               MOVE ZERO               TO BZ-WNA-COMP-AM                
               GO TO 1500-EXIT                                          
           END-IF.                                                      
      *                                                                         
           IF  BG-NO-OF-CONS-DAYS < C7-MIN-PRORATION-DAYS OR            
               BG-NO-OF-CONS-DAYS > C7-MAX-PRORATION-DAYS               
               COMPUTE WS-PRORATE-USE ROUNDED                           
                  = BZ-BILL-UNITS * 30 / BG-NO-OF-CONS-DAYS             
           ELSE                                                         
               COMPUTE WS-PRORATE-USE = BZ-BILL-UNITS                   
           END-IF.                                                      
      *                                                                         
           IF  BG-GAS-BASE-USE  > WS-PRORATE-USE                        
               MOVE ZERO               TO BZ-WNA-COMP-AM                
           ELSE                                                         
               COMPUTE BZ-WNA-COMP-AM ROUNDED                           
                 = (WS-PRORATE-USE - BG-GAS-BASE-USE) * BG-WNA-FACTOR   
           END-IF.                                                      
      *                                                                         
           IF  BG-NO-OF-CONS-DAYS < C7-MIN-PRORATION-DAYS OR            
               BG-NO-OF-CONS-DAYS > C7-MAX-PRORATION-DAYS               
               COMPUTE BZ-WNA-COMP-AM ROUNDED                           
                  = BZ-WNA-COMP-AM * BG-NO-OF-CONS-DAYS / 30            
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  WRITE DETAILS TO OUTPUT                                     **        
      ******************************************************************        
       2000-PROCESS-FCSCA624.                                           
      *                                                                         
           MOVE BG-ACCOUNT-NO          TO E-FCA624-ACCOUNT-NO           
           MOVE AT-LOCAL-OFFICE        TO E-FCA624-LOC-OFF              
           MOVE AT-CODE-ACCT-STAT      TO E-FCA624-ACCT-STAT            
           MOVE UT-RATE-PLAN-NO        TO E-FCA624-RATE                 
           MOVE BG-RATE-PLAN-NO        TO E-FCA624-BILL-RATE            
           MOVE BG-CODE-REVENUE-CLASS  TO E-FCA624-CLASS                
           MOVE BG-REVENUE-MONTH       TO E-FCA624-REV-MONTH            
           MOVE BG-REV-DISTRICT-CD     TO E-FCA624-REV-DIST             
           MOVE WS-ATH-MINUS-BTH       TO E-FCA624-ATH-BASE-USE         
A05744     MOVE BZ-BILL-UNITS          TO E-FCA624-THERMS               
      *                                                                         
           IF  E-FCA624-RATE-1 > 0 AND E-FCA624-RATE-2 = 0              
               MOVE WS-WSL-ROUNDED-FINAL                                
                                       TO E-FCA624-R1-WSL               
               MOVE BG-WNA-FACTOR      TO E-FCA624-R1-WNA-FACT          
               MOVE BZ-WNA-COMP-AM     TO E-FCA624-R1-WNA-AMT           
           ELSE                                                         
           IF  E-FCA624-RATE-1 = 0 AND E-FCA624-RATE-2 > 0              
               MOVE WS-WSL-ROUNDED-FINAL                                
                                       TO E-FCA624-R2-WSL               
               MOVE BG-WNA-FACTOR      TO E-FCA624-R2-WNA-FACT          
               MOVE BZ-WNA-COMP-AM     TO E-FCA624-R2-WNA-AMT           
           ELSE                                                         
            IF WS-RATE = '1'                                            
               MOVE WS-LIM-MINUS-ATH   TO E-FCA624-R1-WSL               
               COMPUTE E-FCA624-R2-WSL                                  
                  = (WS-WSL-ROUNDED-FINAL - WS-LIM-MINUS-ATH)           
               IF WS-ATH-MINUS-BTH = ZERO                               
                  MOVE ZERO TO E-FCA624-R1-WNA-FACT                     
               ELSE                                                     
                  COMPUTE E-FCA624-R1-WNA-FACT ROUNDED                  
                       =  WS-RATE-WORK1 / WS-ATH-MINUS-BTH              
                  COMPUTE E-FCA624-R2-WNA-FACT ROUNDED                  
                       =  WS-RATE-WORK2 / WS-ATH-MINUS-BTH              
               END-IF                                                   
               MOVE E-FCA624-R1-WNA-FACT TO BG-WNA-FACTOR               
               PERFORM 1500-CALC-WNA-AMT THRU 1500-EXIT                 
               MOVE BZ-WNA-COMP-AM         TO E-FCA624-R1-WNA-AMT       
               MOVE E-FCA624-R2-WNA-FACT TO BG-WNA-FACTOR               
               PERFORM 1500-CALC-WNA-AMT THRU 1500-EXIT                 
               MOVE BZ-WNA-COMP-AM         TO E-FCA624-R2-WNA-AMT       
            ELSE                                                        
            IF WS-RATE = '2'                                            
               MOVE WS-LIM-MINUS-ATH   TO E-FCA624-R2-WSL               
               COMPUTE E-FCA624-R1-WSL                                  
                  = (WS-WSL-ROUNDED-FINAL - WS-LIM-MINUS-ATH)           
               IF WS-ATH-MINUS-BTH = ZERO                               
                  MOVE ZERO TO E-FCA624-R1-WNA-FACT                     
               ELSE                                                     
                  COMPUTE E-FCA624-R1-WNA-FACT ROUNDED                  
                       =  WS-RATE-WORK1 / WS-ATH-MINUS-BTH              
                  COMPUTE E-FCA624-R2-WNA-FACT ROUNDED                  
                       =  WS-RATE-WORK2 / WS-ATH-MINUS-BTH              
               END-IF                                                   
               MOVE E-FCA624-R1-WNA-FACT TO BG-WNA-FACTOR               
               PERFORM 1500-CALC-WNA-AMT THRU 1500-EXIT                 
               MOVE BZ-WNA-COMP-AM       TO E-FCA624-R1-WNA-AMT         
               MOVE E-FCA624-R2-WNA-FACT TO BG-WNA-FACTOR               
               PERFORM 1500-CALC-WNA-AMT THRU 1500-EXIT                 
               MOVE BZ-WNA-COMP-AM       TO E-FCA624-R2-WNA-AMT         
            END-IF                                                      
            END-IF                                                      
           END-IF                                                       
           END-IF.                                                      
      *                                                                         
C32676     IF BR-WNA-GAS-RATE > 0                                       
C32676         MOVE WS-WSL-ROUNDED-FINAL                                
C32676                                  TO E-FCA624-R1-WSL              
C32676         MOVE BG-WNA-FACTOR       TO E-FCA624-R1-WNA-FACT         
C32676         MOVE BZ-WNA-COMP-AM      TO E-FCA624-R1-WNA-AMT          
C32676         MOVE BR-WNA-GAS-RATE     TO E-FCA624-RATE-1              
C32676     END-IF.                                                      
      *                                                                         
           PERFORM 8000-WRITE-FCSCA624 THRU 8000-EXIT.                  
      *                                                                         
           MOVE ' '                    TO WS-RATE.                      
           INITIALIZE E-FCA624-RECORD.                                  
           MOVE ZEROS                  TO E-FCA624-RATE-1               
                                          E-FCA624-RATE-2               
                                          E-FCA624-R1-WSL               
                                          E-FCA624-R2-WSL               
                                          E-FCA624-R1-WNA-FACT          
                                          E-FCA624-R2-WNA-FACT          
                                          E-FCA624-R1-WNA-AMT           
                                          E-FCA624-R2-WNA-AMT.          
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *COPY CPD00037.                                                           
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  7000-MAJOR ACCOUNT CURSOR.                                  **        
      ******************************************************************        
       7000-OPEN-CURSOR.                                                
           EXEC SQL                                                     
               OPEN MAIN_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA624******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - OPEN         *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA624******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7000-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
       7000-FETCH-CURSOR.                                               
           EXEC SQL                                                     
               FETCH MAIN_CSR                                           
                   INTO :AT-ACCOUNT-NO                                  
                       ,:AT-CODE-ACCT-STAT                              
                       ,:AT-LOCAL-OFFICE                                
                       ,:UT-IC-NO                                       
                       ,:AT-BILL-CYCLE                                  
                       ,:AT-COMPANY-NO                                  
                       ,:UT-RATE-PLAN-NO                                
                       ,:UT-CODE-REVENUE-CLASS                          
                       ,:PR-REV-DISTRICT-CD                             
                       ,:AT-ACCT-XFER-TO                                
                       ,:C7-MIN-PRORATION-DAYS                          
                       ,:C7-MAX-PRORATION-DAYS                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA624******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - FETCH        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA624******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7000-FETCH-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
       7000-CLOSE-CURSOR.                                               
      *                                                                         
           EXEC SQL                                                     
               CLOSE MAIN_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-RC                            
               DISPLAY '*****************PCSCA624******************'    
               DISPLAY '* 7000 : RETURN CODE ERROR - CLOSE        *'    
               DISPLAY '*        RC = ' WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA624******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                         
       7000-CLOSE-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7050-OPEN-BG-CURSOR                                           *         
      * GETS DETAILS FROM BG                                          *         
      *****************************************************************         
       7050-OPEN-BG-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
                OPEN BG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*****************PCSCA624******************'  
                 DISPLAY '* 7050 : RETURN CODE ERROR - OPEN         *'  
                 DISPLAY '*         RC = ' WS-DISPLAY-RC                
                 DISPLAY '* ACCOUNT NO = ' BG-ACCOUNT-NO                
                 DISPLAY '*   IC NO    = ' BG-IC-NO                     
                 DISPLAY '*****************PCSCA624******************'  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7060-FETCH-BG-CURSOR                                          *         
      * GETS DETAILS FROM BG                                          *         
      *****************************************************************         
       7060-FETCH-BG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               FETCH BG_CURSOR                                          
                  INTO :BG-BILL-NO                                      
                      ,:BG-BILL-ITEM-TIMESTMP                           
                      ,:BG-REVENUE-MONTH                                
                      ,:BG-REV-DISTRICT-CD                              
                      ,:BG-RATE-PLAN-NO                                 
                      ,:BG-CODE-REVENUE-CLASS                           
                      ,:BG-NO-OF-CONS-DAYS                              
                      ,:BG-WNA-FACTOR                                   
                      ,:BG-GAS-BASE-USE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
               IF  SQLCODE EQUAL NOT-FOUND                              
                   MOVE 'Y'                    TO WS-NO-MORE-BG-SW      
               ELSE                                                     
                   MOVE SQLCODE TO WS-DISPLAY-RC                        
                   DISPLAY '*****************PCSCA624************'      
                   DISPLAY '* 7060 : RETURN CODE ERROR - FETCH  *'      
                   DISPLAY '*         RC = ' WS-DISPLAY-RC              
                   DISPLAY '* ACCOUNT NO = ' BG-ACCOUNT-NO              
                   DISPLAY '*   IC NO    = ' BG-IC-NO                   
                   DISPLAY '*****************PCSCA624************'      
                   PERFORM 9900-ABEND  THRU  9900-EXIT                  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7070-CLOSE-BG-CURSOR                                          *         
      * GETS DETAILS FROM BG                                          *         
      *****************************************************************         
       7070-CLOSE-BG-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*****************PCSCA624******************'  
                 DISPLAY '* 7070 : RETURN CODE ERROR - CLOSE        *'  
                 DISPLAY '*         RC = ' WS-DISPLAY-RC                
                 DISPLAY '* ACCOUNT NO = ' BG-ACCOUNT-NO                
                 DISPLAY '*   IC NO    = ' BG-BILL-NO                   
                 DISPLAY '*****************PCSCA624******************'  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7075-GET-BILLED-WNA                                           *         
      * GETS DETAILS FROM BZ                                          *         
      *****************************************************************         
       7075-GET-BILLED-WNA.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(BILL_UNITS)                                  
                      ,CONSUMPT_TYPE_CD                                 
                  INTO :BZ-BILL-UNITS :WS-NULL-IND-4                     
                      ,:BZ-CONSUMPT-TYPE-CD                             
                  FROM CSS_BILL_CALC_DET WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO              
                   AND CODE_UTIL_TYPE     = 'G'                         
                   AND IC_NO              = :BG-IC-NO                   
                   AND CONSUMPT_TYPE_CD   IN ('C', 'D')                 
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
                   AND INSTR_USE_TYPE_CD  = 'R'                         
                GROUP BY CONSUMPT_TYPE_CD                               
A04735                                                           
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(BILL_UNITS)                                          
MFA-TR*               ,CONSUMPT_TYPE_CD                                         
MFA-TR*           INTO :BZ-BILL-UNITS:WS-NULL-IND-4                             
MFA-TR*               ,:BZ-CONSUMPT-TYPE-CD                                     
MFA-TR*           FROM CSS_BILL_CALC_DET                                        
MFA-TR*          WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                      
MFA-TR*            AND CODE_UTIL_TYPE     = 'G'                                 
MFA-TR*            AND IC_NO              = :BG-IC-NO                           
MFA-TR*            AND CONSUMPT_TYPE_CD   IN ('C', 'D')                         
MFA-TR*            AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*            AND INSTR_USE_TYPE_CD  = 'R'                                 
MFA-TR*         GROUP BY CONSUMPT_TYPE_CD                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7075                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*****************PCSCA624******************'  
                 DISPLAY '* 7075 : RETURN CODE ERROR - SELECT       *'  
                 DISPLAY '*         RC = ' WS-DISPLAY-RC                
                 DISPLAY '* ACCOUNT NO = ' BG-ACCOUNT-NO                
                 DISPLAY '* BILL NO    = ' BG-BILL-NO                   
                 DISPLAY '* TIMESTMP   = ' BG-BILL-ITEM-TIMESTMP        
                 DISPLAY '*****************PCSCA624******************'  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7100-SELECT-CX-DETAILS                                       *          
      * GETS THE REVENUE AMOUNT AND TAXES                            *          
      ****************************************************************          
       7100-SELECT-CX-DETAILS.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT MAX(DATE_READ)                                   
                  INTO :CX-DATE-READ :WS-NULL-IND-3                      
                  FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                  
                   AND CODE_UTIL_TYPE = 'G'                             
                   AND BILL_NO        = :BG-BILL-NO                     
                   AND IC_NO          = :BG-IC-NO                       
                   AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
                   AND REG_ID_NO      = 1                               
A04735                                                           
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(DATE_READ)                                           
MFA-TR*           INTO :CX-DATE-READ:WS-NULL-IND-3                              
MFA-TR*           FROM CSS_CNSMPTN_HIST                                         
MFA-TR*          WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = 'G'                                     
MFA-TR*            AND BILL_NO        = :BG-BILL-NO                             
MFA-TR*            AND IC_NO          = :BG-IC-NO                               
MFA-TR*            AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*            AND REG_ID_NO      = 1                                       
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*************PCSCA624******************'      
                 DISPLAY '** 7100 :  RETURN CODE ERROR           '      
                 DISPLAY '**      :  RC = ' WS-DISPLAY-RC               
                 DISPLAY '** ACCOUNT NO = ' BG-ACCOUNT-NO               
                 DISPLAY '** BILL NO = ' BG-BILL-NO                     
                 DISPLAY '** TIMESTMP = ' BG-BILL-ITEM-TIMESTMP         
                 DISPLAY '*************PCSCA624******************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7200-GET-NDD                                                 *          
      * GET NDD       FROM TEMPERATURE TABLE                         *          
      ****************************************************************          
       7200-GET-CURR-ADD-NDD.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT SUM(ACT_HEAT_DEGREE)                                
                   ,SUM(NORM_HEAT_DEGREE)                               
               INTO                                                     
                   :WS-CALC-ADD :WS-NULL-IND-1                           
                  ,:WS-CALC-NDD :WS-NULL-IND-2                           
               FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                       
              WHERE COMPANY_NO  = :AT-COMPANY-NO                        
                AND TEMP_DT <= DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) ) )      
                AND TEMP_DT >=                                          
                   DATEADD( DAY, -:CX-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                          :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) ) )         
A04735                                                           
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUM(ACT_HEAT_DEGREE)                                        
MFA-TR*            ,SUM(NORM_HEAT_DEGREE)                                       
MFA-TR*        INTO                                                             
MFA-TR*            :WS-CALC-ADD:WS-NULL-IND-1                                   
MFA-TR*           ,:WS-CALC-NDD:WS-NULL-IND-2                                   
MFA-TR*        FROM CSS_TEMPERATURE                                             
MFA-TR*       WHERE COMPANY_NO  = :AT-COMPANY-NO                                
MFA-TR*         AND TEMP_DT <= DATE(DATE(:CX-DATE-READ)  - 1 DAYS)              
MFA-TR*         AND TEMP_DT >=                                                  
MFA-TR*            DATE(DATE(:CX-DATE-READ) - :CX-NO-DAYS DAYS)                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*************PCSCA624******************'      
                 DISPLAY '** 7200 :  RETURN CODE ERROR           '      
                 DISPLAY '**      :  RC = ' WS-DISPLAY-RC               
                 DISPLAY '** ACCOUNT NO = ' BG-ACCOUNT-NO               
                 DISPLAY '** BILL NO = ' BG-BILL-NO                     
                 DISPLAY '*************PCSCA624******************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04139000
      * THE FOLLOWING MODULE IS TO GET WNA-LOWER-FACTOR & UPPER-FACTOR *40500000
      * FROM CSS_BTU_WNA_RANGE TABLE                                   *        
      ******************************************************************40490000
       7260-SELECT-BTU-WNA-RANGE.                                       
      *                                                                 11132400
           EXEC SQL                                                     
               SELECT  WNA_LOWER_LIMIT                                  
                      ,WNA_UPPER_LIMIT                                  
                      ,WNA_GAS_RATE                                     
                 INTO :BR-WNA-LOWER-LIMIT                               
                     ,:BR-WNA-UPPER-LIMIT                               
                     ,:BR-WNA-GAS-RATE                                  
                 FROM  CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)               
                WHERE  BR.CODE_UTIL_TYPE  = :WS-G                       
                  AND  BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO            
T32676            AND  BR.EFFECTIVE_DT = (SELECT MAX(B1.EFFECTIVE_DT)   
T32676                                 FROM CSS_BTU_WNA_RANGE B1
                           WITH(READUNCOMMITTED)        
T32676                    WHERE B1.CODE_UTIL_TYPE = BR.CODE_UTIL_TYPE   
T32676                     AND  B1.RATE_PLAN_NO   = BR.RATE_PLAN_NO     
C32676                     AND  B1.EFFECTIVE_DT  <= 
              IIF(TRY_CONVERT(DATE, :WS-EFFECTIVE-DT-BR
              ) IS NULL OR (PATINDEX('%.%', :WS-EFFECTIVE-DT-BR
              ) <> 0) OR (LEN(:WS-EFFECTIVE-DT-BR
              ) <> 10), CIS.CHAR2DATE(:WS-EFFECTIVE-DT-BR
              ), CONVERT(DATE, :WS-EFFECTIVE-DT-BR) ))
A04735                                                           
A04735                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11132600
MFA-TR*        SELECT  WNA_LOWER_LIMIT                                          
MFA-TR*               ,WNA_UPPER_LIMIT                                          
MFA-TR*               ,WNA_GAS_RATE                                             
MFA-TR*          INTO :BR-WNA-LOWER-LIMIT                               11133100
MFA-TR*              ,:BR-WNA-UPPER-LIMIT                               11133200
MFA-TR*              ,:BR-WNA-GAS-RATE                                  11133200
MFA-TR*          FROM  CSS_BTU_WNA_RANGE BR                                     
MFA-TR*         WHERE  BR.CODE_UTIL_TYPE  = :WS-G                               
MFA-TR*           AND  BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO                    
MFA-TR*           AND  BR.EFFECTIVE_DT = (SELECT MAX(B1.EFFECTIVE_DT)           
MFA-TR*                                FROM CSS_BTU_WNA_RANGE B1                
MFA-TR*                   WHERE B1.CODE_UTIL_TYPE = BR.CODE_UTIL_TYPE           
MFA-TR*                    AND  B1.RATE_PLAN_NO   = BR.RATE_PLAN_NO             
MFA-TR*                    AND  B1.EFFECTIVE_DT  <= :WS-EFFECTIVE-DT-BR)        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7260                                                    
MFA-TR*    END-EXEC.                                                    11133300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11130500
           IF  SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                   
               CONTINUE                                                 
           ELSE                                                         
                 MOVE SQLCODE TO WS-DISPLAY-RC                          
                 DISPLAY '*************PCSCA624******************'      
                 DISPLAY '** 7260 :  RETURN CODE ERROR           '      
                 DISPLAY '**      :  RC = ' WS-DISPLAY-RC               
                 DISPLAY '**      RATE  = ' BR-RATE-PLAN-NO             
                 DISPLAY '*************PCSCA624******************'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 8000-WRITE-FCSCA624                                         *           
      ***************************************************************           
       8000-WRITE-FCSCA624.                                             
      *                                                                         
           WRITE E-FCA624-RECORD.                                       
           IF FCSCA624-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSCA624    **'    
              DISPLAY '**        PARA - 8000-WRITE-FCSCA624       **'   
              DISPLAY '** ERROR DURING WRITE OF FILE FCSCA624     **'   
              DISPLAY '**  RC = ' WS-FCSCA624-STATUS                    
              DISPLAY '**          PROCESSING TERMINATED         **'    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA624-FILE.                                         
           IF FCSCA624-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** PROCESSING ERROR INPROGRAM PCSCA624    **'    
              DISPLAY '**        PARA - 9000-TERMINATE           **'    
              DISPLAY '** ERROR DURING CLOSE OF FILE FCSCA624     **'   
              DISPLAY '**  RC = ' WS-FCSCA624-STATUS                    
              DISPLAY '**          PROCESSING TERMINATED         **'    
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
