       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA623.                                        
       DATE-WRITTEN.   08/24/04.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  08/24/04     MSR       NEW PROGRAM                         **         
T35434**  03/28/07  COVANSYS     REPLACED MODEL_SQL WITH SET COMMAND **         
T35434**                         AND ADDED WITH UR FOR -911          **         
A00765**  02/18/09    CVNS       ADDED 9000-SEND-ERROR-RESULT PARA.  **         
A00765**             CHENNAI                                         **         
A37741**  17/11/09   MS93554     DECLARED  S-RETURN-CODE             **         
A37741**                         RESPECTIVE TO CPD00067 CHANGES      **         
P00201**  04/29/10   MS93554     BASED ON THE ACCONUT TYPE WE ARE    **         
P00201**                         UPDATING A PHONE TYPE (H1 FOR       **         
P00201**                         RESIDENTIAL AND B1 FOR COMMERCIAL)  **         
P00201**                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSCA623 REPORTS ----      
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA623.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA623.                                                           
       COPY FIOCA623.                                                           
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA623'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)     VALUE              
           'WORKING STORAGE FOR PCSCA623 STARTS HERE'.                  
P00201*                                                                         
P00201**********************************                                        
P00201**  CSS_COMPANY C7              **                                        
P00201**********************************                                        
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
P00201**********************************                                        
P00201**  CSS_ACCOUNT AT              **                                        
P00201**********************************                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
P00201**  CSS_RESP_AREA C1            **                                        
      **********************************                                        
           EXEC SQL                                                             
               INCLUDE TBRSAREA                                                 
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
P00201**  CSS_MT_TRAN_HIST_DET MI     **                                        
      **********************************                                        
           EXEC SQL                                                     00740000
              INCLUDE TBMNHDT                                           00750000
           END-EXEC.                                                    00760000
      *                                                                 00770000
      **********************************                                        
P00201**  CSS_MNT_TRANS_HIST MH       **                                        
      **********************************                                        
           EXEC SQL                                                     00780000
              INCLUDE TBMNHIST                                          00790000
           END-EXEC.                                                    00800000
      *                                                                 00810000
      **********************************                                        
P00201**  CSS_CUST_PHONE CB           **                                        
      **********************************                                        
           EXEC SQL                                                     00780000
              INCLUDE TBCSTPHN                                          00790000
           END-EXEC.                                                    00800000
      *                                                                         
P00201**********************************                                        
P00201**  CSS_NAME DQ                 **                                        
P00201**********************************                                        
P00201     EXEC SQL                                                             
P00201         INCLUDE TBNAME                                                   
P00201     END-EXEC.                                                            
P00201*                                                                         
                                                                        
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-USERID                  PIC X(08) VALUE SPACES.       
           05  WS-CURRENT-DATE            PIC X(10) VALUE SPACES.       
           05  WS-CURRENT-TIME            PIC X(08) VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP       PIC X(26) VALUE SPACES.       
           05  WS-ACCOUNT-EXISTS          PIC X(01) VALUE 'N'.          
           05  WS-COMMENT                 PIC X(45) VALUE               
               'THIRD PARTY CUSTOMER HOME PHONE NUMBER UPDATE'.         
           05  WS-RESP-AREA-ID            PIC X(03) VALUE SPACES.       
COB305     05 WS-CUSTOMER-NO-COMP        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-PREMISE-NO-COMP        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.     
      *                                                                         
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01) VALUE 'F'.          
           05  WS-TRAN-APPL-NO            PIC S9(02) VALUE 0.           
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02).                   
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(30).                    
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02).                   
      *                                                                 03510000
       01  WS-LITERALS.                                                 
           05  WS-H1                      PIC X(02) VALUE 'H1'.         
P00201     05  WS-B1                      PIC X(02) VALUE 'B1'.         
           05  WS-E                       PIC X(01) VALUE 'E'.          
           05  WS-C                       PIC X(01) VALUE 'C'.          
           05  WS-N                       PIC X(01) VALUE 'N'.          
           05  WS-A                       PIC X(01) VALUE 'A'.          
           05  WS-D                       PIC X(01) VALUE 'D'.          
           05  WS-F                       PIC X(01) VALUE 'F'.          
           05  WS-G                       PIC X(01) VALUE 'G'.          
           05  WS-I                       PIC X(01) VALUE 'I'.          
           05  WS-J                       PIC X(01) VALUE 'J'.          
           05  WS-L                       PIC X(01) VALUE 'L'.          
           05  WS-M                       PIC X(01) VALUE 'M'.          
           05  WS-P                       PIC X(01) VALUE 'P'.          
           05  WS-Q                       PIC X(01) VALUE 'Q'.          
           05  WS-O                       PIC X(01) VALUE 'O'.          
           05  WS-S                       PIC X(01) VALUE 'S'.          
           05  WS-T                       PIC X(01) VALUE 'T'.          
           05  WS-Y                       PIC X(01) VALUE 'Y'.          
           05  WS-Z                       PIC X(01) VALUE 'Z'.          
           05  WS-1                       PIC 9(01) VALUE 1.            
           05  WS-70                      PIC 9(02) VALUE 70.           
           05  WS-SYSTEM                  PIC X(06) VALUE 'SYSTEM'.     
           05  WS-PGRMNAME                PIC X(08) VALUE 'PCSCA623'.   
           05  WS-52                      PIC 9(02) VALUE 52.           
           05  WS-62                      PIC 9(02) VALUE 62.           
           05  WS-LINE                    PIC X(133) VALUE ALL '*'.     
      *                                                                 03510000
       01  WS-SWITCHES.                                                 
           05  WS-FCA623-STATUS           PIC X(02).                    
               88 FCA623-SUCCESSFUL                  VALUE '00'         
                                                           '04'.        
           05  WS-FRPERR-STATUS           PIC X(02).                    
               88 FRPERR-SUCCESSFUL                  VALUE '00'.        
           05  WS-RECORD-IN-ERR           PIC X(01)  VALUE 'N'.         
               88 RECORD-IN-ERR                      VALUE 'Y'.         
           05  WS-MORE-DATA-SW            PIC X(01)  VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-CUST-NOT-FOUND          PIC X(01)  VALUE 'N'.         
               88  CUST-NOT-FOUND                    VALUE 'Y'.         
           05  WS-PHONE-NO-UPDT           PIC X(01)  VALUE 'N'.         
               88  PHONE-NO-UPDT                     VALUE 'Y'.         
      *                                                                 03510000
       01  WS-MISC.                                                     
           05  WS-PHONE-NO                PIC X(10) VALUE SPACES.       
           05  WS-ERROR-CODE              PIC 9(06) VALUE ZEROS.        
           05  WS-DISPLAY-SQLCODE         PIC -ZZZZZZZZ9.               
           05  WS-ACCT-CUST-NO.                                         
               10 WS-ACCOUNT-NO           PIC 9(13) VALUE ZEROS.        
               10 FILLER                  PIC X(01) VALUE '-'.          
               10 WS-CUSTOMER-NO          PIC 9(10) VALUE ZEROS.        
           05  WS-TOTAL-MATCHES           PIC 9(05) VALUE ZEROS.        
           05  WS-RESULTS-RET             PIC 9(05) VALUE ZEROS.        
           05  WS-LISTING-TYPE            PIC X(02) VALUE ZEROS.        
           05  WS-NON-PUBLISHED           PIC X(01) VALUE SPACES.       
           05  WS-BIZ-GOV-NAME            PIC X(50) VALUE SPACES.       
           05  WS-FIRST-NAME              PIC X(15) VALUE SPACES.       
           05  WS-LAST-NAME               PIC X(20) VALUE SPACES.       
           05  WS-ADDRESS                 PIC X(41) VALUE SPACES.       
           05  WS-CITY                    PIC X(26) VALUE SPACES.       
           05  WS-STATE                   PIC X(02) VALUE SPACES.       
           05  WS-ZIPCODE                 PIC X(09) VALUE SPACES.       
           05  WS-MATCH-LVL               PIC X(01) VALUE SPACES.       
HEX01      05  WS-DELIMITER               PIC X(01) VALUE X'09'.        
           05  WS-MATCH-CODE              PIC X(01) VALUE SPACES.       
           05  WS-IMATCH                  PIC X(01) VALUE SPACES.       
           05  WS-MATCH-SCORE             PIC 9(05) VALUE ZEROS.        
           05  WS-RPT1-LINE-NO            PIC 9(02) VALUE 62   COMP-3.  
           05  WS-RPT1-PAGE-NO            PIC 9(02) VALUE ZERO COMP-3.  
A37741     05  S-RETURN-CODE              PIC S9(9) COMP VALUE 0.       
P00201     05  WS-PHONE-NO-UPDATED        PIC X(01) VALUE 'N'.          
      *                                                                         
       01  WS-CURRENT-TIME-EDT.                                         
           05  WS-HH                      PIC 9(02).                    
           05  FILLER                     PIC X(01) VALUE '.'.          
           05  WS-MM                      PIC 9(02).                    
           05  FILLER                     PIC X(01) VALUE '.'.          
           05  WS-SS                      PIC 9(02).                    
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                   PIC X(02).                    
           05  FILLER                     PIC X(01) VALUE ':'.          
           05  WS-RT-MM                   PIC X(02).                    
           05  FILLER                     PIC X(01) VALUE ':'.          
           05  WS-RT-SS                   PIC X(02).                    
      *                                                                         
       01  WS-CURRENT-DATE-EDT.                                         
           05  WS-CC                      PIC 9(02).                    
           05  WS-YY                      PIC 9(02).                    
           05  FILLER                     PIC X(01) VALUE '-'.          
           05  WS-CM                      PIC 9(02).                    
           05  FILLER                     PIC X(01) VALUE '-'.          
           05  WS-CD                      PIC 9(02).                    
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                   PIC X(02).                    
           05  FILLER                     PIC X(01) VALUE '/'.          
           05  WS-RD-DD                   PIC X(02).                    
           05  FILLER                     PIC X(01) VALUE '/'.          
           05  WS-RD-YY                   PIC X(02).                    
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CCYY                PIC X(04).                    
           05  FILLER                     PIC X(01) VALUE '/'.          
           05  WS-D10-MM                  PIC X(02).                    
      *                                                                         
       01  WS-DATE-6.                                                   
           05  WS-D6-MM                   PIC X(02).                    
           05  FILLER                     PIC X(01) VALUE '/'.          
           05  WS-D6-CCYY                 PIC X(04).                    
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-FCA623-REC-CNTR          PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-TOT-RECS-PROCESSED       PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-TOT-RECS-SKIPPED         PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-CUST-ERR-RECDS           PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-ERR-RECDS-CNT            PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-NO-MATCH-CNT             PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-PH-NO-UPDT               PIC S9(05) COMP-3 VALUE ZEROS.
P00201     05 WS-PH-NO-UPDATED            PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-A               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-C               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-D               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-F               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-G               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-I               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-J               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-L               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-M               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-O               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-P               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-Q               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-S               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-T               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-Y               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-RECD-CNT-Z               PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-TOT-RECS-UPDATED         PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-COMMIT-CNTR              PIC S9(05) COMP-3 VALUE ZEROS.
           05 WS-TOT-COMMIT-CNTR          PIC S9(05) COMP-3 VALUE ZEROS.
      *                                                                         
       01  WS-REPORT-VARS.                                              
      *                                                                         
           05  WS-DEFAULT-RPT1-TITLE1     PIC X(50)  VALUE              
               '  CUSTOMER HOME PH NO UPDATE STATISTICS           '.    
      *                                                                         
      *    05  WS-DEFAULT-RPT1-TITLE2.                                          
      *        10  FILLER                 PIC X(09)  VALUE SPACES.              
      *        10  FILLER                 PIC X(33)  VALUE SPACES.              
      *        10  FILLER                 PIC X(01)  VALUE SPACES.              
      *        10  FILLER                 PIC X(09)  VALUE SPACES.              
      *        10  FILLER                 PIC X(01)  VALUE SPACES.              
      *        10  WS-DEFAULT-RPT1-TITLE2-DT PIC X(04).                         
      *        10  FILLER                 PIC X(13)  VALUE SPACES.              
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT TITLE          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-TITLE.                                           
               10  P-RPT1-TITLE-PGNM      PIC X(08).                    
               10  FILLER                 PIC X(36)  VALUE SPACES.      
               10  P-RPT1-COMP-NAME       PIC X(35).                    
               10  FILLER                 PIC X(33)  VALUE SPACES.      
               10  FILLER                 PIC X(10)  VALUE 'RUN-DATE: '.
               10  P-RPT1-RUN-DATE        PIC X(08).                    
               10  FILLER                 PIC X(02)  VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER1        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER                 PIC X(06)  VALUE SPACES.      
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(27)  VALUE SPACES.      
               10  P-RPT1-HEAD1           PIC X(50).                    
               10  FILLER                 PIC X(21)  VALUE SPACES.      
               10  FILLER                 PIC X(10)  VALUE 'RUN-TIME: '.
               10  P-RPT1-RUN-TIME        PIC X(08).                    
               10  FILLER                 PIC X(02)  VALUE SPACES.      
      *                                                                         
      ****************************************************************          
      **           COMMON WORKING STORAGE FOR REPORT HEADER2        **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
               10  FILLER                 PIC X(41)  VALUE SPACES.      
               10  FILLER                 PIC X(50)  VALUE SPACES.      
               10  FILLER                 PIC X(25)  VALUE SPACES.      
               10  FILLER                 PIC X(08)  VALUE 'PAGE:   '.  
               10  P-RPT1-PAGE-NO         PIC ZZ,ZZ9.                   
               10  FILLER                 PIC X(02)  VALUE SPACES.      
      *                                                                         
       01  WS-TOTAL-LINES.                                              
      *                                                                         
           05  WS-TOTAL-LINE-1.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(31)  VALUE              
                   'TOTAL RECS RETURNED WITH ERROR '.                   
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-ERR-CNT     PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-2.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(33)  VALUE              
                    'TOTAL RECS RETURNED WITH NO MATCH'.                
               10  FILLER                 PIC X(06)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-NOMATCH     PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-3.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(38)  VALUE              
                   'TOTAL RECS RETURNED WITH NO CUST MATCH'.            
               10  FILLER                 PIC X(01)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-NOCUST      PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-4.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(37)  VALUE              
P00201             'TOTAL RECS WITH PH NO ALREADY UPD H1'.              
               10  FILLER                 PIC X(02)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-PH-UPDT     PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-5.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(27)  VALUE              
                   'TOTAL RECS WITH MATCH CODE '.                       
               10  P-MATCH-CODE           PIC X(01)  VALUE SPACES.      
               10  FILLER                 PIC X(11)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-MATCH-CD    PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-6.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(21)  VALUE              
                   'TOTAL RECORDS UPDATED'.                             
               10  FILLER                 PIC X(18)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-UPDT        PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-7.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(21)  VALUE              
                   'TOTAL RECORDS SKIPPED'.                             
               10  FILLER                 PIC X(18)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-SKIPPED     PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
           05  WS-TOTAL-LINE-8.                                         
               10  FILLER                 PIC X(08)  VALUE SPACES.      
               10  FILLER                 PIC X(23)  VALUE              
                   'TOTAL RECORDS PROCESSED'.                           
               10  FILLER                 PIC X(16)  VALUE SPACES.      
               10  FILLER                 PIC X(01)  VALUE ':'.         
               10  P-TOT-RECS-PROCESSED   PIC ZZZ,ZZ9.                  
               10  FILLER                 PIC X(05)  VALUE SPACES.      
               10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
P00201     05  WS-TOTAL-LINE-9.                                         
P00201         10  FILLER                 PIC X(08)  VALUE SPACES.      
P00201         10  FILLER                 PIC X(37)  VALUE              
P00201             'TOTAL RECS WITH PH NO ALREADY UPD B1'.              
P00201         10  FILLER                 PIC X(02)  VALUE SPACES.      
P00201         10  FILLER                 PIC X(01)  VALUE ':'.         
P00201         10  P-TOT-RECS-PH-UPDATED  PIC ZZZ,ZZ9.                  
P00201         10  FILLER                 PIC X(05)  VALUE SPACES.      
P00201         10  FILLER                 PIC X(78)  VALUE SPACES.      
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSCA623 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 7100-READ-FCSCA623            THRU 7100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT         
                  UNTIL NO-MORE-DATA.                                   
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       OPEN INPUT/OUTPUT FILES, ACCEPT SYSTEM TIME & DATE,  **          
      **       ACCEPT COMPANY-NO FROM SYSIN                         **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 7500-GET-TIMESTMP                THRU 7500-EXIT.     
           MOVE WS-CURRENT-DATE        TO WS-CURRENT-DATE-EDT.          
           MOVE WS-CURRENT-TIME        TO WS-CURRENT-TIME-EDT.          
      *                                                                         
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
      *                                                                         
           MOVE WS-YY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSCA623-FILE.                                    
           IF FCA623-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**      FCSCA623 PROCESSING ERROR        **'    
               DISPLAY '**  OPEN ERROR OF FCSCA623 - INPUT FILE  **'    
               DISPLAY '**        FILE STATUS = ' WS-FCA623-STATUS      
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
     *                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-PROCESS-INPUT.                                      **          
      **       PROCESS THE INPUT FILE.                              **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           UNSTRING E-FCA623-REC                                        
           DELIMITED BY WS-DELIMITER                                    
           INTO WS-ACCT-CUST-NO                                         
                WS-TOTAL-MATCHES                                        
                WS-RESULTS-RET                                          
                WS-IMATCH                                               
                WS-LISTING-TYPE                                         
                WS-NON-PUBLISHED                                        
                WS-MATCH-LVL                                            
                WS-MATCH-SCORE                                          
                WS-MATCH-CODE                                           
                WS-BIZ-GOV-NAME                                         
                WS-FIRST-NAME                                           
                WS-LAST-NAME                                            
                WS-ADDRESS                                              
                WS-CITY                                                 
                WS-STATE                                                
                WS-ZIPCODE                                              
                WS-PHONE-NO                                             
                WS-ERROR-CODE                                           
           MOVE WS-ACCOUNT-NO          TO AT-ACCOUNT-NO.                
           MOVE WS-CUSTOMER-NO         TO AT-CUSTOMER-NO.               
           IF WS-IMATCH NOT EQUAL WS-M                                  
              IF WS-IMATCH = WS-N                                       
                 ADD WS-1                 TO WS-NO-MATCH-CNT            
              ELSE                                                      
                 ADD WS-1                 TO WS-ERR-RECDS-CNT           
              END-IF                                                    
              PERFORM 7100-READ-FCSCA623    THRU 7100-EXIT              
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           EVALUATE WS-MATCH-CODE                                       
              WHEN WS-A                                                 
                 ADD WS-1                 TO WS-RECD-CNT-A              
              WHEN WS-C                                                 
                 ADD WS-1                 TO WS-RECD-CNT-C              
              WHEN WS-D                                                 
                 ADD WS-1                 TO WS-RECD-CNT-D              
              WHEN WS-F                                                 
                 ADD WS-1                 TO WS-RECD-CNT-F              
              WHEN WS-G                                                 
                 ADD WS-1                 TO WS-RECD-CNT-G              
              WHEN WS-I                                                 
                 ADD WS-1                 TO WS-RECD-CNT-I              
              WHEN WS-J                                                 
                 ADD WS-1                 TO WS-RECD-CNT-J              
              WHEN WS-L                                                 
                 ADD WS-1                 TO WS-RECD-CNT-L              
              WHEN WS-M                                                 
                 ADD WS-1                 TO WS-RECD-CNT-M              
              WHEN WS-O                                                 
                 ADD WS-1                 TO WS-RECD-CNT-O              
              WHEN WS-P                                                 
                 ADD WS-1                 TO WS-RECD-CNT-P              
              WHEN WS-Q                                                 
                 ADD WS-1                 TO WS-RECD-CNT-Q              
              WHEN WS-S                                                 
                 ADD WS-1                 TO WS-RECD-CNT-S              
              WHEN WS-T                                                 
                 ADD WS-1                 TO WS-RECD-CNT-T              
              WHEN WS-Y                                                 
                 ADD WS-1                 TO WS-RECD-CNT-Y              
              WHEN WS-Z                                                 
                 ADD WS-1                 TO WS-RECD-CNT-Z              
           END-EVALUATE.                                                
           IF (WS-MATCH-CODE = WS-A OR WS-MATCH-CODE = WS-C OR          
               WS-MATCH-CODE = WS-J)                                    
              AND WS-MATCH-SCORE >= WS-70                               
              PERFORM 7200-GET-ACCT-DTLS  THRU 7200-EXIT                
              IF CUST-NOT-FOUND                                         
                 MOVE WS-N             TO WS-CUST-NOT-FOUND             
                 DISPLAY '** CUSTOMER NOT FOUND IN THE ACCOUNT TABLE **'
                 DISPLAY '** ACCOUNT NO  = ' AT-ACCOUNT-NO              
                 ADD WS-1                 TO WS-CUST-ERR-RECDS          
                 PERFORM 7100-READ-FCSCA623    THRU 7100-EXIT           
                 GO TO 1000-EXIT                                        
              END-IF                                                    
              PERFORM 7300-GET-CUST-PH    THRU 7300-EXIT                
              IF PHONE-NO-UPDT                                          
                 ADD WS-1                 TO WS-PH-NO-UPDT              
                 MOVE WS-N                TO WS-PHONE-NO-UPDT           
                 PERFORM 7100-READ-FCSCA623    THRU 7100-EXIT           
                 GO TO 1000-EXIT                                        
              END-IF                                                    
P00201        PERFORM 7700-GET-NAME-FMAT     THRU 7700-EXIT             
P00201        IF AT-ACCOUNT-TYPE-CODE = 'C'  AND DQ-NAME-FORMAT = 'B'   
P00201           PERFORM 7800-CHK-PHONE-NO   THRU 7800-EXIT             
P00201           IF WS-PHONE-NO-UPDATED  = 'Y'                          
P00201              ADD WS-1                 TO WS-PH-NO-UPDATED        
P00201              MOVE WS-N                TO WS-PHONE-NO-UPDATED     
P00201              PERFORM 7100-READ-FCSCA623    THRU 7100-EXIT        
P00201              GO TO 1000-EXIT                                     
P00201           END-IF                                                 
P00201        END-IF                                                    
P00201                                                                  
P00201        IF AT-ACCOUNT-TYPE-CODE = 'R'                             
P00201           MOVE WS-H1 TO CB-PHONE-TYPE                            
P00201        ELSE                                                      
P00201          IF AT-ACCOUNT-TYPE-CODE = 'C' AND DQ-NAME-FORMAT = 'I'  
P00201             MOVE WS-H1 TO CB-PHONE-TYPE                          
P00201          ELSE                                                    
P00201             MOVE WS-B1 TO CB-PHONE-TYPE                          
P00201          END-IF                                                  
P00201        END-IF                                                    
                                                                        
              MOVE AT-CUSTOMER-NO         TO CB-CUSTOMER-NO             
P00201*       MOVE WS-H1                  TO CB-PHONE-TYPE                      
              MOVE WS-PHONE-NO            TO CB-PHONE-NO                
              MOVE SPACES                 TO CB-EXTENSION-NO            
              MOVE WS-C                   TO CB-CUSTOMER-TYPE           
              PERFORM 7400-UPDATE-CUST-PH THRU 7400-EXIT                
              ADD WS-1                    TO WS-TOT-RECS-UPDATED        
                                             WS-COMMIT-CNTR             
                                             WS-TOT-COMMIT-CNTR         
              EVALUATE WS-MATCH-CODE                                    
                 WHEN WS-A                                              
                   SUBTRACT WS-1          FROM WS-RECD-CNT-A            
                 WHEN WS-C                                              
                   SUBTRACT WS-1          FROM WS-RECD-CNT-C            
                 WHEN WS-J                                              
                   SUBTRACT WS-1          FROM WS-RECD-CNT-J            
              END-EVALUATE                                              
              PERFORM 2100-UPDATE-MNT-TRANS THRU 2100-EXIT              
              IF WS-COMMIT-CNTR >= 1000                                 
                 PERFORM 7600-COMMIT     THRU 7600-EXIT                 
                 MOVE ZEROS              TO WS-COMMIT-CNTR              
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7100-READ-FCSCA623    THRU 7100-EXIT.                
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2100-UPDATE-MNT-TRANS.                                           
      *                                                                 16230000
           PERFORM 7500-GET-TIMESTMP        THRU 7500-EXIT.             
           MOVE        +1                 TO  WS-TRAN-APPL-NO.          
           MOVE 'PHONE TYPE'              TO  WS-COLUMN-DESC.           
           MOVE '*NEW*'                   TO  WS-PRV-COLUMN-VALUE-TEXT. 
           MOVE 05                        TO  WS-PRV-COLUMN-VALUE-LEN.  
           MOVE CB-PHONE-TYPE             TO  WS-CHG-COLUMN-VALUE-TEXT. 
           MOVE 02                        TO  WS-CHG-COLUMN-VALUE-LEN.  
           PERFORM 2150-SET-MNT-TRANS-VARS          THRU 2150-EXIT.     
           PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT.     
      *                                                                 16230000
           ADD      +1                    TO WS-TRAN-APPL-NO.           
           MOVE 'PHONE NO'                TO WS-COLUMN-DESC.            
           MOVE '*NEW*'                   TO WS-PRV-COLUMN-VALUE-TEXT.  
           MOVE 10                        TO WS-PRV-COLUMN-VALUE-LEN.   
           MOVE CB-PHONE-NO               TO WS-CHG-COLUMN-VALUE-TEXT.  
           MOVE 10                        TO WS-CHG-COLUMN-VALUE-LEN.   
           PERFORM 2150-SET-MNT-TRANS-VARS          THRU 2150-EXIT.     
           PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT.     
      *                                                                 16230000
           ADD      +1                    TO WS-TRAN-APPL-NO.           
           MOVE 'CUSTOMER TYPE'           TO WS-COLUMN-DESC.            
           MOVE '*NEW*'                   TO WS-PRV-COLUMN-VALUE-TEXT.  
           MOVE 05                        TO WS-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-C                      TO WS-CHG-COLUMN-VALUE-TEXT.  
           MOVE 01                        TO WS-CHG-COLUMN-VALUE-LEN.   
           PERFORM 2150-SET-MNT-TRANS-VARS          THRU 2150-EXIT.     
           PERFORM 6530-LOAD-MNT-TRANS-HIST         THRU 6530-EXIT.     
      *                                                                 16230000
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************16140000
      * 2150 SET MNT TRANS VARS                                        *16150000
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *16160000
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *16170000
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *16180000
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *16190000
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *16200000
      ******************************************************************16210000
       2150-SET-MNT-TRANS-VARS.                                         
      *                                                                 16230000
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE AT-CUSTOMER-NO              TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-SYSTEM                   TO MH-USER-ID.              
           MOVE WS-PGRMNAME                 TO MH-APPL-PROGRAM-ID.      
           MOVE WS-COMMENT                  TO MH-TRAN-COMMENT-TEXT.    
           MOVE 45                          TO MH-TRAN-COMMENT-LEN.     
      *                                                                 16430000
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE SPACES                      TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
      *                                                                 16560000
       2150-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSCA623                                       **          
      **       READ THE INPUT FILE FCSCA623                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSCA623.                                              
      *                                                                         
           READ FCSCA623-FILE                                           
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO TO 7100-EXIT.                                     
      *                                                                         
           IF FCA623-SUCCESSFUL                                         
               ADD 1                   TO WS-FCA623-REC-CNTR            
           ELSE                                                         
               DISPLAY '**   7100-ERROR ON FCSCA623 READ   **'          
               DISPLAY '**   STATUS IS ' WS-FCA623-STATUS               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   7200-GET-ACCT-DTLS                                       **          
      **       GET THE CUSTOMER AND PREMISE DETAILS FOR THE ACCOUNT.**          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7200-GET-ACCT-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT  CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
P00201                ,ACCOUNT_TYPE_CODE                                
                 INTO :AT-CUSTOMER-NO                                   
                     ,:AT-PREMISE-NO                                    
P00201               ,:AT-ACCOUNT-TYPE-CODE                             
                 FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                    
                  AND  CUSTOMER_NO  = :AT-CUSTOMER-NO                   
P00201            AND  CODE_ACCT_STAT = 'A'                             
T35434                                                          
P00201                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,ACCOUNT_TYPE_CODE                                        
MFA-TR*          INTO :AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM  CSS_ACCOUNT                                              
MFA-TR*         WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                            
MFA-TR*           AND  CUSTOMER_NO  = :AT-CUSTOMER-NO                           
MFA-TR*           AND  CODE_ACCT_STAT = 'A'                                     
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   SET CUST-NOT-FOUND  TO TRUE                          
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7200-GET-ACCT-DTLS   **' 
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          ACCOUNT NO  = ' AT-ACCOUNT-NO   
P00201             DISPLAY '**          CUSTOMER NO = ' AT-CUSTOMER-NO  
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7300-GET-CUST-PH                                         **          
      **       GET THE CUST PHONE DETAILS FOR THE CUSTOMER.         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7300-GET-CUST-PH.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT  CUSTOMER_NO                                      
                      ,PHONE_NO                                         
                      ,PHONE_TYPE                                       
                 INTO :CB-CUSTOMER-NO                                   
                     ,:CB-PHONE-NO                                      
                     ,:CB-PHONE-TYPE                                    
                 FROM  CSS_CUST_PHONE WITH(READUNCOMMITTED)                     
                WHERE  CUSTOMER_NO   = :AT-CUSTOMER-NO                  
P00201            AND  PHONE_TYPE    = 'H1'                             
T35434                                                          
P00201                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CUSTOMER_NO                                              
MFA-TR*               ,PHONE_NO                                                 
MFA-TR*               ,PHONE_TYPE                                               
MFA-TR*          INTO :CB-CUSTOMER-NO                                           
MFA-TR*              ,:CB-PHONE-NO                                              
MFA-TR*              ,:CB-PHONE-TYPE                                            
MFA-TR*          FROM  CSS_CUST_PHONE                                           
MFA-TR*         WHERE  CUSTOMER_NO   = :AT-CUSTOMER-NO                          
MFA-TR*           AND  PHONE_TYPE    = 'H1'                                     
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               SET PHONE-NO-UPDT       TO TRUE                          
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO CB-PHONE-NO                   
               ELSE                                                     
                   DISPLAY '** SELECT ERROR IN 7300-GET-CUST-PH      **'
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          ACCOUNT NO  = ' AT-ACCOUNT-NO   
P00201             DISPLAY '**          PHONE TYPE  = ' WS-H1           
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7400-UPDATE-CUST-PH                                      **          
      **       INSERT HOME PHONE DETAILS FOR THE CUSTOMERS.         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7400-UPDATE-CUST-PH.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_PHONE                               
                           (CUSTOMER_NO                                 
                           ,PHONE_TYPE                                  
                           ,PHONE_NO                                    
                           ,EXTENSION_NO                                
                           ,CUSTOMER_TYPE)                              
                      VALUES                                            
                           (:CB-CUSTOMER-NO                             
                           ,:CB-PHONE-TYPE                              
                           ,:CB-PHONE-NO                                
                           ,:CB-EXTENSION-NO                            
                           ,:CB-CUSTOMER-TYPE)                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               NEXT SENTENCE                                            
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE SPACES         TO CB-PHONE-NO                   
               ELSE                                                     
                   DISPLAY '** INSERT ERROR IN 7400-UPDATE-CUST-PH   **'
                   DISPLAY '**          RETURN CODE = ' SQLCODE         
                   DISPLAY '**          ACCOUNT NO  = ' AT-ACCOUNT-NO   
P00201             DISPLAY '**          CUSTOMER NO = ' AT-CUSTOMER-NO  
                   DISPLAY '**          PROCESSING TERMINATED        **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT CURRENT TIME STAMP                                   **         
      *****************************************************************         
       7500-GET-TIMESTMP.                                               
      *                                                                 05910000
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     05920000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE      = CURRENT DATE                        
MFA-TR*            ,:WS-CURRENT-TIME      = CURRENT TIME                        
MFA-TR*    END-EXEC.                                                    05960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
T35434         DISPLAY '**    SET ERROR IN 7500-GET-TIMESTMP         **'
               DISPLAY '**          RETURN CODE = ' SQLCODE             
               DISPLAY '**              PROCESSING TERMINATED        **'
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 06060000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7600-COMMIT.                                                **         
      *****************************************************************         
       7600-COMMIT.                                                     
      *                                                                 05910000
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               DISPLAY 'NO OF RECORDS COMMITED : ' WS-TOT-COMMIT-CNTR   
               DISPLAY '**          ACCOUNT NO  = ' AT-ACCOUNT-NO       
               DISPLAY '**          CUSTOMER NO = ' AT-CUSTOMER-NO      
           ELSE                                                         
               DISPLAY '** INSERT ERROR IN 7600-COMMIT               **'
               DISPLAY '**          RETURN CODE = ' SQLCODE             
               DISPLAY '**          ACCOUNT NO  = ' AT-ACCOUNT-NO       
P00201         DISPLAY '**          CUSTOMER NO = ' AT-CUSTOMER-NO      
               DISPLAY '**              PROCESSING TERMINATED        **'
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 06060000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00201****************************************************************          
P00201**   7700-GET-NAME-FMAT                                       **          
P00201**       GET THE NAME FORMAT DETAILS FOR THE CUSTOMER.        **          
P00201****************************************************************          
P00201*                                                                         
P00201 7700-GET-NAME-FMAT.                                              
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201         SELECT DQ.NAME_FORMAT                                    
P00201           INTO :DQ-NAME-FORMAT                                   
P00201           FROM CSS_CUSTOMER  CU WITH(READUNCOMMITTED)                    
P00201               ,CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00201          WHERE CU.NAME_ID     = DQ.NAME_ID                       
P00201            AND CU.CUSTOMER_NO = :AT-CUSTOMER-NO                  
P00201                                                           
P00201                                                      
P00201     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.NAME_FORMAT                                            
MFA-TR*          INTO :DQ-NAME-FORMAT                                           
MFA-TR*          FROM CSS_CUSTOMER  CU                                          
MFA-TR*              ,CSS_NAME DQ                                               
MFA-TR*         WHERE CU.NAME_ID     = DQ.NAME_ID                               
MFA-TR*           AND CU.CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00201*                                                                         
P00201     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
P00201        CONTINUE                                                  
P00201     ELSE                                                         
P00201        DISPLAY '** SELECT ERROR IN 7700-GET-NAME-FMAT   **'      
P00201        DISPLAY '** RETURN CODE = ' SQLCODE                       
P00201        DISPLAY '** ACCOUNT NO  = ' AT-CUSTOMER-NO                
P00201        DISPLAY '** PROCESSING TERMINATED         **'             
P00201        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00201     END-IF.                                                      
P00201*                                                                         
P00201 7700-EXIT.                                                       
P00201     EXIT.                                                        
P00201*                                                                         
P00201****************************************************************          
P00201**   7800-CHK-PHONE-NO                                        **          
P00201**       CHK THE CUST PHONE DETAILS FOR THE CUSTOMER.         **          
P00201****************************************************************          
P00201*                                                                         
P00201 7800-CHK-PHONE-NO.                                               
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201         SELECT  'Y'                                              
P00201           INTO :WS-PHONE-NO-UPDATED                              
P00201           FROM  CSS_CUST_PHONE WITH(READUNCOMMITTED)                     
P00201          WHERE  CUSTOMER_NO   = :AT-CUSTOMER-NO                  
P00201            AND  PHONE_TYPE    = 'B1'                             
P00201                                                          
P00201                                                     
P00201     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO :WS-PHONE-NO-UPDATED                                      
MFA-TR*          FROM  CSS_CUST_PHONE                                           
MFA-TR*         WHERE  CUSTOMER_NO   = :AT-CUSTOMER-NO                          
MFA-TR*           AND  PHONE_TYPE    = 'B1'                                     
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00201*                                                                         
P00201     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
P00201        NEXT SENTENCE                                             
           ELSE                                                         
P00201        IF SQLCODE EQUAL NOT-FOUND                                
P00201           MOVE SPACES         TO CB-PHONE-NO                     
P00201        ELSE                                                      
P00201           DISPLAY '** SELECT ERROR IN 7800-CHK-PHONE-NO   **'    
P00201           DISPLAY '** RETURN CODE = ' SQLCODE                    
P00201           DISPLAY '** ACCOUNT NO  = ' AT-CUSTOMER-NO             
P00201           DISPLAY '** PHONE TYPE  = ' WS-B1                      
P00201           DISPLAY '** PROCESSING TERMINATED               **'    
P00201           PERFORM 9900-ABEND            THRU 9900-EXIT           
P00201        END-IF                                                    
P00201     END-IF.                                                      
P00201*                                                                         
P00201 7800-EXIT.                                                       
P00201     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8000-DISPLAY-STATS                                       **          
      **       DISPLAYS THE UPDATE STATS                            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8000-DISPLAY-STATS.                                              
      *                                                                         
           MOVE WS-FCA623-REC-CNTR           TO P-TOT-RECS-PROCESSED    
           MOVE WS-ERR-RECDS-CNT             TO P-TOT-RECS-ERR-CNT      
           MOVE WS-NO-MATCH-CNT              TO P-TOT-RECS-NOMATCH      
           MOVE WS-CUST-ERR-RECDS            TO P-TOT-RECS-NOCUST       
           MOVE WS-PH-NO-UPDT                TO P-TOT-RECS-PH-UPDT      
P00201     MOVE WS-PH-NO-UPDATED             TO P-TOT-RECS-PH-UPDATED   
           MOVE WS-TOT-RECS-UPDATED          TO P-TOT-RECS-UPDT         
           SUBTRACT WS-TOT-RECS-UPDATED      FROM WS-FCA623-REC-CNTR    
                                             GIVING WS-TOT-RECS-SKIPPED 
           MOVE WS-TOT-RECS-SKIPPED          TO P-TOT-RECS-SKIPPED      
           PERFORM 8100-PRINT-COMP-NAME      THRU 8100-EXIT             
           PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT             
           PERFORM 8410-PRINT-TOTAL-LINE     THRU 8410-EXIT.            
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **       8100-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                       TO WS-RPT1-PAGE-NO.              
           MOVE WS-PGRMNAME            TO P-RPT1-TITLE-PGNM.            
      *                                                                         
           MOVE 'S C ELECTRIC & GAS CO / PSNC ENERGY'                   
                                       TO P-RPT1-COMP-NAME              
      *                                                                         
           MOVE  WS-RPT1-TITLE   TO  PRT33-DATA                         
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING PAGE.                                   
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
           MOVE WS-DEFAULT-RPT1-TITLE1 TO P-RPT1-HEAD1.                 
           MOVE  WS-RPT1-HEADER-1   TO  PRT33-DATA                      
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
      *    MOVE WS-DEFAULT-RPT1-TITLE2 TO P-RPT1-HEAD2.                         
           MOVE WS-RPT1-PAGE-NO        TO P-RPT1-PAGE-NO.               
           MOVE  WS-RPT1-HEADER-2    TO  PRT33-DATA                     
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8410-PRINT-TOTAL-LINE                                    **          
      **       PRINTS THE TOTAL LINES FOR THE LOCAL OFFICE          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8410-PRINT-TOTAL-LINE.                                           
      *                                                                         
           MOVE  WS-TOTAL-LINE-1   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 3 LINES.                                
           MOVE  WS-TOTAL-LINE-2   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE  WS-TOTAL-LINE-3   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE  WS-TOTAL-LINE-4   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
P00201     MOVE  WS-TOTAL-LINE-9   TO  PRT33-DATA                       
P00201     WRITE PRT33-RECORD                                           
P00201          AFTER ADVANCING 1 LINE.                                 
           IF WS-RECD-CNT-A > 0                                         
              MOVE WS-RECD-CNT-A             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-A                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-C > 0                                         
              MOVE WS-RECD-CNT-C             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-C                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-D > 0                                         
              MOVE WS-RECD-CNT-D             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-D                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-F > 0                                         
              MOVE WS-RECD-CNT-F             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-F                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-G > 0                                         
              MOVE WS-RECD-CNT-G             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-G                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-I > 0                                         
              MOVE WS-RECD-CNT-I             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-I                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-J > 0                                         
              MOVE WS-RECD-CNT-J             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-J                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-L > 0                                         
              MOVE WS-RECD-CNT-L             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-L                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-M > 0                                         
              MOVE WS-RECD-CNT-M             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-M                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-O > 0                                         
              MOVE WS-RECD-CNT-O             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-O                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-P > 0                                         
              MOVE WS-RECD-CNT-P             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-P                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-Q > 0                                         
              MOVE WS-RECD-CNT-Q             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-Q                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-S > 0                                         
              MOVE WS-RECD-CNT-S             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-S                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-T > 0                                         
              MOVE WS-RECD-CNT-T             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-T                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-Y > 0                                         
              MOVE WS-RECD-CNT-Y             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-Y                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           IF WS-RECD-CNT-Z > 0                                         
              MOVE WS-RECD-CNT-Z             TO P-TOT-RECS-MATCH-CD     
              MOVE WS-Z                      TO P-MATCH-CODE            
              MOVE WS-TOTAL-LINE-5           TO  PRT33-DATA             
              WRITE PRT33-RECORD                                        
                   AFTER ADVANCING 1 LINE                               
           END-IF.                                                      
           MOVE  WS-TOTAL-LINE-6   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE  WS-TOTAL-LINE-7   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
           MOVE  WS-TOTAL-LINE-8   TO  PRT33-DATA                       
           WRITE PRT33-RECORD                                           
                AFTER ADVANCING 1 LINE.                                 
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSE ALL OPEN FILES AND CHECK FOR ERROR             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA623-FILE.                                         
           PERFORM 8000-DISPLAY-STATS            THRU 8000-EXIT.        
           IF FCA623-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSCA623 PROCESSING ERROR        **'   
               DISPLAY '**  CLOSE ERROR FOR FCSCA623 - INPUT FILE  **'  
               DISPLAY '**       STATUS IS ' WS-FCA623-STATUS           
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    COPY BOOK FOR MNT TRANSACTION HIST TABLE.                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ****************************************************************          
      **    9900-ABEND    DB2 SQL ABEND MODULE                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
