       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA622.                                           
       DATE-WRITTEN.  AUGUST 04.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 08/18/04   SR82046        DEVELOPMENT OF NEW PROGRAM        **         
A37061*  02/17/09   MC95456        REPLACED CHECKING MIDDLE DIGIT    **         
A37061*                            FROM CODE_REV_CLASS OF            **         
A37061*                            CSS_UTIL_ENVRMT WITH              **         
A37061*                            ACCOUNT_TYPE_CODE OF CSS_ACCOUNT. **         
A37061*                            ADDED WITH UR TO SINGLETON SELECT **         
P00201*  04/22/10   SP94986        CHANGED THE EXISTING CURSOR IN THE**         
P00201*                            PROGRAM TO SELECT ONLY CUSTOMERS  **         
P00201*                            WITH NAME_FORMAT = 'I' AND        **         
P00201*                            ADDED ANOTHER CURSOR TO SELECT    **         
P00201*                            COMMERCIAL ACCOUNTS               **         
      *****************************************************************         
      *                   PCSCA622  NARRATIVE                          *        
      *                                                                *        
      * THIS PROGRAM SELECTS ALL THE ACCOUNTS RECORDS WHICH DOES NOT   *        
      * HAVE HOME PHONE NO AND WRITES OUTPUT FILE TO SEND TO TFCC.     *        
      ******************************************************************        
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA622.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA622.                                                           
       COPY FIOCA622.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA622'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCA622-STATUS                PIC X(02).               
               88 FCA622-SUCCESSFUL                      VALUE '00'.    
P00201*    05  WS-LL-FOUND                     PIC X(01) VALUE 'N'.             
P00201*        88 LL-FOUND                               VALUE 'Y'.             
      *                                                                         
       01  WS-LITERALS.                                                 
P00201*    05  WS-R                            PIC X(01) VALUE 'R'.             
P00201     05  WS-I                            PIC X(01) VALUE 'I'.     
P00201*    05  WS-Y                            PIC X(01) VALUE 'Y'.             
P00201*    05  WS-N                            PIC X(01) VALUE 'N'.             
P00201*    05  WS-B                            PIC X(01) VALUE 'B'.             
HEX01      05  WS-PIPE                         PIC X(01) VALUE X'09'.   
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-FULL-NAME-CONCAT             PIC X(50).               
           05  WS-FULL-NAME.                                            
               10  WS-FULL-NAME-CH             PIC X(01)                
                                              OCCURS 50 TIMES           
                                               VALUE SPACES.            
           05  WS-NAME-LEN                     PIC 9(02) VALUE ZEROS.   
           05  WS-STREET-ADDRESS               PIC X(46) VALUE SPACES.  
           05  WS-RECORD-COUNT                PIC S9(7) VALUE +0 COMP-3.
P00201*                                                                         
P00201     05  WS-INSPECT-CNTR                 PIC 99 VALUE ZEROS.      
P00201     05  WS-EXCLUDE-BUS-CUST.                                     
P00201         10 WS-BUS-CUST1                 PIC X(19) VALUE          
P00201           'CAROLINA WATER SERV'.                                 
P00201         10 WS-BUS-CUST2                 PIC X(11) VALUE          
P00201         'CBS OUTDOOR'.                                           
P00201         10 WS-BUS-CUST3                 PIC X(09) VALUE          
P00201         'CHAS CNTY'.                                             
P00201         10 WS-BUS-CUST4                 PIC X(11) VALUE          
P00201         'CHAS COUNTY'.                                           
P00201         10 WS-BUS-CUST5                 PIC X(07) VALUE          
P00201         'CITY OF'.                                               
P00201         10 WS-BUS-CUST6                 PIC X(03) VALUE          
P00201         'CSX'.                                                   
P00201         10 WS-BUS-CUST7                 PIC X(16) VALUE          
P00201         'LEXINGTON COUNTY'.                                      
P00201         10 WS-BUS-CUST8                 PIC X(07) VALUE          
P00201         'NORFOLK'.                                               
P00201         10 WS-BUS-CUST9                 PIC X(11) VALUE          
P00201         'S C DEPT OF'.                                           
P00201         10 WS-BUS-CUST10                PIC X(09) VALUE          
P00201         'S C E & G'.                                             
P00201         10 WS-BUS-CUST11                PIC X(05) VALUE          
P00201         'SCANA'.                                                 
P00201         10 WS-BUS-CUST12                PIC X(05) VALUE          
P00201         'SCDOT'.                                                 
P00201         10 WS-BUS-CUST13                PIC X(05) VALUE          
P00201         'SCPRT'.                                                 
P00201         10 WS-BUS-CUST14                PIC X(08) VALUE          
P00201         'SEABOARD'.                                              
P00201         10 WS-BUS-CUST15                PIC X(07) VALUE          
P00201         'TOWN OF'.                                               
P00201         10 WS-BUS-CUST16                PIC X(08) VALUE          
P00201         'U S POST'.                                              
P00201         10 WS-BUS-CUST17                PIC X(07) VALUE          
P00201         'US POST'.                                               
P00201*                                                                         
           05  WS-ACCT-CUST-NO.                                         
               10  WS-ACCOUNT-NO               PIC 9(13).               
               10  FILLER                      PIC X(01) VALUE '-'.     
               10  WS-CUSTOMER-NO              PIC 9(10).               
           05  WS-OLD-CUSTOMER-NO              PIC 9(10) VALUE ZEROS.   
           05 PROGRAM-NAME                     PIC X(8)  VALUE          
              'PCSCA622'.                                               
           05 RS-RETURN-CODE                   PIC S9(9) VALUE          
              +000 COMP.                                                
           05 RS-RETURN-CODE-DISP              PIC S9(9) VALUE          
              +000 COMP.                                                
      *                                                                         
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_CUST_PHONE                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCSTPHN                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_ACCOUNT                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_NAME                                                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_PREMISE                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_CUSTOMER                                                           
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ADDR_FORMATTED                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ZIP_CODE                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_NAME_ACCT_XREF                                                      
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_LANDLORD                                                            
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBLNDLRD                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      * -- USED BY CPD00004                                                     
      * WORKING STORAGE AREA USED TO REDUCE EMBEDDED BLANKS                     
       COPY CWS00011.                                                           
       COPY CWS00010.                                                           
                                                                        
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT ACCOUNT DETAILS OF ACTIVE ACCTS**         
      ** WHOSE  PHONE-TYPE'S ARE H1 AND WITH NO PHONE NOS.           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE ACCT-DET-CURSOR CURSOR FOR                       
               SELECT  DISTINCT                                         
                        AT.ACCOUNT_NO,                                  
                        AT.CUSTOMER_NO,                                 
                        AT.PREMISE_NO,                                  
                        AT.CODE_ACCT_STAT,                              
                        AT.ACCOUNT_TYPE_CODE,                           
                        AT.LOCAL_OFFICE,                                
                        DQ.FULL_NAME,                                   
                        DQ.FIRST_NAME,                                  
                        DQ.MIDDLE_NAME,                                 
                        DQ.LAST_NAME,                                   
                        DQ.NAME_FORMAT,                                 
                        DY.HOUSE_NO,                                    
                        DY.ADDR_PREFIX_1,                               
                        DY.ADDR_PREFIX_2,                               
                        DY.STREET_NAME,                                 
                        DY.STREET_LOCATION_1,                           
                        DY.STREET_LOCATION_2,                           
                        DY.STREET_SUFFIX,                               
                        A4.TOWN,                                        
                        A4.STATE,                                       
                        DY.ZIP_CODE,                                    
                        DY.ZIP_CODE_PLUS_FOUR                           
                 FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED),                  
                        CSS_PREMISE PR WITH(READUNCOMMITTED),                   
                        CSS_NAME DQ WITH(READUNCOMMITTED),                      
                        CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),            
                        CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                   
                 WHERE CU.CUSTOMER_NO    = AT.CUSTOMER_NO               
                   AND AT.PREMISE_NO     = PR.PREMISE_NO                
                   AND PR.ADDRESS_ID     = DY.ADDRESS_ID                
                   AND CU.NAME_ID        = DQ.NAME_ID                   
P00201             AND DQ.NAME_FORMAT    = 'I'                          
                   AND AT.CODE_ACCT_STAT = 'A'                          
                   AND (DY.ZIP_CODE      = A4.ZIP_CODE AND              
                        DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN)          
                   AND NOT EXISTS (SELECT *                             
                                     FROM CSS_CUST_PHONE CB
                           WITH(READUNCOMMITTED)             
                                   WHERE AT.CUSTOMER_NO = CB.CUSTOMER_NO
                                     AND CB.PHONE_TYPE = 'H1'           
                                     AND CB.PHONE_NO <> '')             
A37061             AND AT.ACCOUNT_TYPE_CODE = 'R'                       
               ORDER BY AT.CUSTOMER_NO                                  
A37061         FOR READ ONLY                                    
P00201                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT-DET-CURSOR CURSOR FOR                               
MFA-TR*        SELECT  DISTINCT                                                 
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.CODE_ACCT_STAT,                                      
MFA-TR*                 AT.ACCOUNT_TYPE_CODE,                                   
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 DQ.FULL_NAME,                                           
MFA-TR*                 DQ.FIRST_NAME,                                          
MFA-TR*                 DQ.MIDDLE_NAME,                                         
MFA-TR*                 DQ.LAST_NAME,                                           
MFA-TR*                 DQ.NAME_FORMAT,                                         
MFA-TR*                 DY.HOUSE_NO,                                            
MFA-TR*                 DY.ADDR_PREFIX_1,                                       
MFA-TR*                 DY.ADDR_PREFIX_2,                                       
MFA-TR*                 DY.STREET_NAME,                                         
MFA-TR*                 DY.STREET_LOCATION_1,                                   
MFA-TR*                 DY.STREET_LOCATION_2,                                   
MFA-TR*                 DY.STREET_SUFFIX,                                       
MFA-TR*                 A4.TOWN,                                                
MFA-TR*                 A4.STATE,                                               
MFA-TR*                 DY.ZIP_CODE,                                            
MFA-TR*                 DY.ZIP_CODE_PLUS_FOUR                                   
MFA-TR*          FROM   CSS_CUSTOMER CU,                                        
MFA-TR*                 CSS_PREMISE PR,                                         
MFA-TR*                 CSS_NAME DQ,                                            
MFA-TR*                 CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY,                                  
MFA-TR*                 CSS_ZIP_CODE A4                                         
MFA-TR*          WHERE CU.CUSTOMER_NO    = AT.CUSTOMER_NO                       
MFA-TR*            AND AT.PREMISE_NO     = PR.PREMISE_NO                        
MFA-TR*            AND PR.ADDRESS_ID     = DY.ADDRESS_ID                        
MFA-TR*            AND CU.NAME_ID        = DQ.NAME_ID                           
MFA-TR*            AND DQ.NAME_FORMAT    = 'I'                                  
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND (DY.ZIP_CODE      = A4.ZIP_CODE AND                      
MFA-TR*                 DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN)                  
MFA-TR*            AND NOT EXISTS (SELECT *                                     
MFA-TR*                              FROM CSS_CUST_PHONE CB                     
MFA-TR*                            WHERE AT.CUSTOMER_NO = CB.CUSTOMER_NO        
MFA-TR*                              AND CB.PHONE_TYPE = 'H1'                   
MFA-TR*                              AND CB.PHONE_NO <> '')                     
MFA-TR*            AND AT.ACCOUNT_TYPE_CODE = 'R'                               
MFA-TR*        ORDER BY AT.CUSTOMER_NO                                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00201*****************************************************************         
P00201** CURSOR DECLARATION TO SELECT ACCOUNT DETAILS OF ACTIVE ACCTS**         
P00201** WHOSE  PHONE-TYPE'S ARE 'H1'AND 'B1' WITH NO PHONE NOS.     **         
P00201**                                                             **         
P00201*****************************************************************         
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201         DECLARE CUST-DET-CURSOR CURSOR FOR                       
P00201         SELECT  DISTINCT                                         
P00201                  AT.ACCOUNT_NO,                                  
P00201                  AT.CUSTOMER_NO,                                 
P00201                  AT.PREMISE_NO,                                  
P00201                  AT.CODE_ACCT_STAT,                              
P00201                  AT.ACCOUNT_TYPE_CODE,                           
P00201                  AT.LOCAL_OFFICE,                                
P00201                  DQ.FULL_NAME,                                   
P00201                  DQ.FIRST_NAME,                                  
P00201                  DQ.MIDDLE_NAME,                                 
P00201                  DQ.LAST_NAME,                                   
P00201                  DQ.NAME_FORMAT,                                 
P00201                  DY.HOUSE_NO,                                    
P00201                  DY.ADDR_PREFIX_1,                               
P00201                  DY.ADDR_PREFIX_2,                               
P00201                  DY.STREET_NAME,                                 
P00201                  DY.STREET_LOCATION_1,                           
P00201                  DY.STREET_LOCATION_2,                           
P00201                  DY.STREET_SUFFIX,                               
P00201                  A4.TOWN,                                        
P00201                  A4.STATE,                                       
P00201                  DY.ZIP_CODE,                                    
P00201                  DY.ZIP_CODE_PLUS_FOUR                           
P00201           FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED),                  
P00201                  CSS_PREMISE PR WITH(READUNCOMMITTED),                   
P00201                  CSS_NAME DQ WITH(READUNCOMMITTED),                      
P00201                  CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
P00201                  CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),            
P00201                  CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                   
P00201           WHERE CU.CUSTOMER_NO    = AT.CUSTOMER_NO               
P00201             AND AT.PREMISE_NO     = PR.PREMISE_NO                
P00201             AND PR.ADDRESS_ID     = DY.ADDRESS_ID                
P00201             AND CU.NAME_ID        = DQ.NAME_ID                   
P00201             AND AT.CODE_ACCT_STAT = 'A'                          
P00201             AND (DY.ZIP_CODE      = A4.ZIP_CODE AND              
P00201                  DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN)          
P00201             AND NOT EXISTS (SELECT *                             
P00201                               FROM CSS_CUST_PHONE CB
                           WITH(READUNCOMMITTED)             
P00201                             WHERE AT.CUSTOMER_NO = CB.CUSTOMER_NO
P00201                               AND CB.PHONE_TYPE IN ('H1','B1')   
P00201                               AND CB.PHONE_NO <> '')             
P00201             AND AT.ACCOUNT_TYPE_CODE = 'C'                       
P00201         ORDER BY AT.CUSTOMER_NO                                  
P00201         FOR READ ONLY                                    
P00201                                                      
P00201     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CUST-DET-CURSOR CURSOR FOR                               
MFA-TR*        SELECT  DISTINCT                                                 
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.CODE_ACCT_STAT,                                      
MFA-TR*                 AT.ACCOUNT_TYPE_CODE,                                   
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 DQ.FULL_NAME,                                           
MFA-TR*                 DQ.FIRST_NAME,                                          
MFA-TR*                 DQ.MIDDLE_NAME,                                         
MFA-TR*                 DQ.LAST_NAME,                                           
MFA-TR*                 DQ.NAME_FORMAT,                                         
MFA-TR*                 DY.HOUSE_NO,                                            
MFA-TR*                 DY.ADDR_PREFIX_1,                                       
MFA-TR*                 DY.ADDR_PREFIX_2,                                       
MFA-TR*                 DY.STREET_NAME,                                         
MFA-TR*                 DY.STREET_LOCATION_1,                                   
MFA-TR*                 DY.STREET_LOCATION_2,                                   
MFA-TR*                 DY.STREET_SUFFIX,                                       
MFA-TR*                 A4.TOWN,                                                
MFA-TR*                 A4.STATE,                                               
MFA-TR*                 DY.ZIP_CODE,                                            
MFA-TR*                 DY.ZIP_CODE_PLUS_FOUR                                   
MFA-TR*          FROM   CSS_CUSTOMER CU,                                        
MFA-TR*                 CSS_PREMISE PR,                                         
MFA-TR*                 CSS_NAME DQ,                                            
MFA-TR*                 CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_ADDR_FORMATTED DY,                                  
MFA-TR*                 CSS_ZIP_CODE A4                                         
MFA-TR*          WHERE CU.CUSTOMER_NO    = AT.CUSTOMER_NO                       
MFA-TR*            AND AT.PREMISE_NO     = PR.PREMISE_NO                        
MFA-TR*            AND PR.ADDRESS_ID     = DY.ADDRESS_ID                        
MFA-TR*            AND CU.NAME_ID        = DQ.NAME_ID                           
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND (DY.ZIP_CODE      = A4.ZIP_CODE AND                      
MFA-TR*                 DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN)                  
MFA-TR*            AND NOT EXISTS (SELECT *                                     
MFA-TR*                              FROM CSS_CUST_PHONE CB                     
MFA-TR*                            WHERE AT.CUSTOMER_NO = CB.CUSTOMER_NO        
MFA-TR*                              AND CB.PHONE_TYPE IN ('H1','B1')           
MFA-TR*                              AND CB.PHONE_NO <> '')                     
MFA-TR*            AND AT.ACCOUNT_TYPE_CODE = 'C'                               
MFA-TR*        ORDER BY AT.CUSTOMER_NO                                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                         
P00201     PERFORM 1000-PROCESS-INPUT-RESI     THRU 1000-EXIT.          
P00201     PERFORM 1100-PROCESS-INPUT-COMM     THRU 1100-EXIT.          
      *                                                                         
           DISPLAY ' TOTAL NO OF CUSTOMERS WRITTEN ' WS-RECORD-COUNT    
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   OPENS THE OUTPUT FILE FCSCA622                               *        
      ******************************************************************        
       0100-INITIALISATION.                                             
                                                                        
           OPEN OUTPUT FCSCA622-FILE.                                   
      *                                                                         
           IF  FCA622-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************PCSCA622**********'                
               DISPLAY 'ERROR IN OPENING FCSCA622'                      
               DISPLAY 'ERROR STATUS ' WS-FCA622-STATUS                 
               DISPLAY '*************PCSCA622**********'                
               PERFORM 9000-TERMINATE          THRU 9000-EXIT           
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE CURSOR  ACCT-DET   **        
      * CURSOR                                                        **        
      ******************************************************************        
      *                                                                         
P00201 1000-PROCESS-INPUT-RESI.                                         
      *                                                                         
           PERFORM 7000-OPEN-ACCT-DET-CURSOR   THRU 7000-EXIT.          
           PERFORM 7010-FETCH-ACCT-DET-CURSOR  THRU 7010-EXIT.          
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               DISPLAY '********** PCSCA622 ********************'       
               DISPLAY '* NO ROWS FETCHED FOR ACCOUNT         *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '********** PCSCA622 ********************'       
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   IF AT-CUSTOMER-NO NOT EQUAL WS-OLD-CUSTOMER-NO       
P00201*               MOVE WS-N                   TO WS-LL-FOUND                
P00201*               IF DQ-NAME-FORMAT = WS-B                                  
P00201*                  PERFORM 7100-GET-LL-INFO THRU 7100-EXIT                
P00201*               END-IF                                                    
P00201*               IF NOT LL-FOUND                                           
P00201                PERFORM 2000-LOAD-OUTPUT THRU 2000-EXIT           
P00201*               END-IF                                                    
                   END-IF                                               
                   PERFORM 7010-FETCH-ACCT-DET-CURSOR                   
                                               THRU 7010-EXIT           
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-ACCT-DET-CURSOR  THRU 7020-EXIT.          
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00201******************************************************************        
P00201* PASSES CONTROL TO OPEN,FETCH AND CLOSE THE CURSOR  ACCT-DET   **        
P00201* CURSOR PHONE_TYPE 'H1' AND 'B1'                               **        
P00201******************************************************************        
P00201*                                                                         
P00201 1100-PROCESS-INPUT-COMM.                                         
P00201*                                                                         
P00201     PERFORM 7100-OPEN-CUST-DET-CURSOR   THRU 7100-EXIT.          
P00201     PERFORM 7110-FETCH-CUST-DET-CURSOR  THRU 7110-EXIT.          
P00201*                                                                         
P00201     IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
P00201         DISPLAY '********** PCSCA622 ********************'       
P00201         DISPLAY '* NO ROWS FETCHED FOR ACCOUNT         *'        
P00201         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00201         DISPLAY '********** PCSCA622 ********************'       
P00201     END-IF.                                                      
P00201*                                                                         
P00201     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
P00201         IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
P00201             IF AT-CUSTOMER-NO NOT EQUAL WS-OLD-CUSTOMER-NO       
P00201                PERFORM 2000-LOAD-OUTPUT THRU 2000-EXIT           
P00201             END-IF                                               
P00201             PERFORM 7110-FETCH-CUST-DET-CURSOR                   
P00201                                         THRU 7110-EXIT           
P00201         END-IF                                                   
P00201     END-PERFORM.                                                 
P00201*                                                                         
P00201     PERFORM 7120-CLOSE-CUST-DET-CURSOR  THRU 7120-EXIT.          
P00201*                                                                         
P00201 1100-EXIT.                                                       
P00201     EXIT.                                                        
PRO201*                                                                         
      ******************************************************************        
      * POPULATES THE OUTPUT VARIABLES AND WRITES ON TO FCSCA622 FILE           
      ******************************************************************        
      *                                                                         
       2000-LOAD-OUTPUT.                                                
      *                                                                         
           INITIALIZE E-FCA622-REC                                      
                      WS-STREET-ADDRESS                                 
                      WS-FULL-NAME                                      
           MOVE SPACES                        TO WS-CMP-TABLE           
                                                 WS-EMB-INPUT           
           MOVE 1                             TO WS-NAME-LEN.           
           MOVE AT-ACCOUNT-NO                 TO WS-ACCOUNT-NO.         
           MOVE AT-CUSTOMER-NO                TO WS-CUSTOMER-NO         
                                                 WS-OLD-CUSTOMER-NO.    
           MOVE WS-ACCT-CUST-NO               TO E-FCA622-ACCT-CUST-NO. 
           MOVE WS-PIPE                       TO E-FCA622-PIPE1         
                                                 E-FCA622-PIPE2         
                                                 E-FCA622-PIPE3         
                                                 E-FCA622-PIPE4         
                                                 E-FCA622-PIPE5         
                                                 E-FCA622-PIPE6         
                                                 E-FCA622-PIPE7.        
                                                                        
           MOVE DQ-LAST-NAME                  TO E-FCA622-LAST-NAME     
           MOVE DQ-FIRST-NAME                 TO E-FCA622-FIRST-NAME    
P00201     IF DQ-NAME-FORMAT = WS-I                                     
P00201        MOVE SPACES                     TO E-FCA622-ACCOUNT-NAME  
P00201     ELSE                                                         
P00201        MOVE DQ-FULL-NAME               TO WS-EMB-INPUT           
P00201        MOVE SPACES                     TO DQ-FULL-NAME           
P00201        PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
P00201        MOVE WS-CMP-TABLE               TO DQ-FULL-NAME           
P00201        MOVE SPACES TO WS-CMP-TABLE WS-EMB-INPUT                  
P00201        MOVE DQ-FULL-NAME               TO E-FCA622-ACCOUNT-NAME  
P00201        INSPECT DQ-FULL-NAME TALLYING WS-INSPECT-CNTR FOR ALL     
P00201        WS-BUS-CUST1,                                             
P00201        WS-BUS-CUST2,                                             
P00201        WS-BUS-CUST3,                                             
P00201        WS-BUS-CUST4,                                             
P00201        WS-BUS-CUST5,                                             
P00201        WS-BUS-CUST6,                                             
P00201        WS-BUS-CUST7,                                             
P00201        WS-BUS-CUST8,                                             
P00201        WS-BUS-CUST9,                                             
P00201        WS-BUS-CUST10,                                            
P00201        WS-BUS-CUST11,                                            
P00201        WS-BUS-CUST12,                                            
P00201        WS-BUS-CUST13,                                            
P00201        WS-BUS-CUST14,                                            
P00201        WS-BUS-CUST15,                                            
P00201        WS-BUS-CUST16,                                            
P00201        WS-BUS-CUST17                                             
P00201     END-IF.                                                      
           MOVE SPACES                        TO E-FCA622-HOME-PHONE.   
           MOVE A4-TOWN                       TO E-FCA622-CITY.         
           MOVE A4-STATE                      TO E-FCA622-STATE.        
                                                                        
           STRING DY-HOUSE-NO          DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-ADDR-PREFIX-1     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-ADDR-PREFIX-2     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-NAME       DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-SUFFIX     DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-LOCATION-1 DELIMITED BY SIZE                
                  ' '                  DELIMITED BY SIZE                
                  DY-STREET-LOCATION-2 DELIMITED BY SIZE                
               INTO WS-STREET-ADDRESS.                                  
           MOVE WS-STREET-ADDRESS            TO WS-EMB-INPUT.           
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                             THRU 6010-EXIT.            
           MOVE WS-CMP-TABLE                 TO E-FCA622-STREET-ADDRESS.
           STRING DY-ZIP-CODE           DELIMITED BY SIZE               
                  DY-ZIP-CODE-PLUS-FOUR DELIMITED BY SIZE               
           INTO E-FCA622-ZIP-CODE.                                      
P00201     IF DQ-NAME-FORMAT = 'B'  AND WS-INSPECT-CNTR > 0             
P00201        MOVE ZEROS                     TO WS-INSPECT-CNTR         
P00201     ELSE                                                         
              ADD +1 TO WS-RECORD-COUNT                                 
              PERFORM 8000-WRITE-E-FCA622-REC   THRU 8000-EXIT          
P00201     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00004                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
      ******************************************************************        
      * OPENS ACCT-DET CURSOR                                                   
      ******************************************************************        
      *                                                                         
       7000-OPEN-ACCT-DET-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT-DET-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO                       
                                                WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA622   ABORT ************'       
               DISPLAY '* 7000-OPEN-ACCT-DET-CURSOR           *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA622   ABORT ************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES ACCOUNT  DETAILS                                       *        
      ******************************************************************        
       7010-FETCH-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT-DET-CURSOR                                     
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-LOCAL-OFFICE,                                  
                     :DQ-FULL-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-STREET-SUFFIX,                                 
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO                       
                                                WS-ACTIVE-RETURN-CODE.  
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA622  ABORT ************'        
               DISPLAY '* 7010-FETCH-ACCT-DET-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA622  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00201* CLOSES ACCT-DET-CURSOR                                         *        
      ******************************************************************        
       7020-CLOSE-ACCT-DET-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT-DET-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO                       
                                            WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA622  ABORT ************'        
               DISPLAY '* 7020-CLOSE-ACCT-DET-CURSOR         *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA622  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00201******************************************************************        
P00201* OPENS CUST-DET CURSOR                                                   
P00201******************************************************************        
P00201*                                                                         
P00201 7100-OPEN-CUST-DET-CURSOR.                                       
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201        OPEN CUST-DET-CURSOR                                      
P00201     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00201                                                                  
P00201     MOVE SQLCODE                        TO                       
P00201                                          WS-ACTIVE-RETURN-CODE.  
P00201     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00201         CONTINUE                                                 
P00201     ELSE                                                         
P00201         DISPLAY '********** PCSCA622   ABORT ************'       
P00201         DISPLAY '* 7100-OPEN-CUST-DET-CURSOR           *'        
P00201         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00201         DISPLAY '* PROGRAM ABORTING...                 *'        
P00201         DISPLAY '********** PCSCA622   ABORT ************'       
P00201         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00201     END-IF.                                                      
P00201*                                                                         
P00201 7100-EXIT.                                                       
P00201     EXIT.                                                        
P00201*                                                                         
P00201******************************************************************        
P00201* FETCHES CUSTOMER DETAILS                                       *        
P00201******************************************************************        
P00201 7110-FETCH-CUST-DET-CURSOR.                                      
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201        FETCH CUST-DET-CURSOR                                     
P00201          INTO :AT-ACCOUNT-NO,                                    
P00201               :AT-CUSTOMER-NO,                                   
P00201               :AT-PREMISE-NO,                                    
P00201               :AT-CODE-ACCT-STAT,                                
P00201               :AT-ACCOUNT-TYPE-CODE,                             
P00201               :AT-LOCAL-OFFICE,                                  
P00201               :DQ-FULL-NAME,                                     
P00201               :DQ-FIRST-NAME,                                    
P00201               :DQ-MIDDLE-NAME,                                   
P00201               :DQ-LAST-NAME,                                     
P00201               :DQ-NAME-FORMAT,                                   
P00201               :DY-HOUSE-NO,                                      
P00201               :DY-ADDR-PREFIX-1,                                 
P00201               :DY-ADDR-PREFIX-2,                                 
P00201               :DY-STREET-NAME,                                   
P00201               :DY-STREET-LOCATION-1,                             
P00201               :DY-STREET-LOCATION-2,                             
P00201               :DY-STREET-SUFFIX,                                 
P00201               :A4-TOWN,                                          
P00201               :A4-STATE,                                         
P00201               :DY-ZIP-CODE,                                      
P00201               :DY-ZIP-CODE-PLUS-FOUR                             
P00201     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00201*                                                                         
P00201     MOVE SQLCODE                        TO                       
P00201                                          WS-ACTIVE-RETURN-CODE.  
P00201     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00201         CONTINUE                                                 
P00201     ELSE                                                         
P00201         DISPLAY '********** PCSCA622  ABORT ************'        
P00201         DISPLAY '* 7110-FETCH-CUST-DET-CURSOR         *'         
P00201         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00201         DISPLAY '* PROGRAM ABORTING...                *'         
P00201         DISPLAY '********** PCSCA622  ABORT ************'        
P00201         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00201     END-IF.                                                      
P00201*                                                                         
P00201 7110-EXIT.                                                       
P00201     EXIT.                                                        
P00201*                                                                         
P00201******************************************************************        
P00201* CLOSES CUST-DET-CURSOR                                         *        
P00201******************************************************************        
P00201 7120-CLOSE-CUST-DET-CURSOR.                                      
P00201*                                                                         
P00201     EXEC SQL                                                     
P00201        CLOSE CUST-DET-CURSOR                                     
P00201     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00201*                                                                         
P00201     MOVE SQLCODE                        TO                       
P00201                                      WS-ACTIVE-RETURN-CODE.      
P00201     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00201         CONTINUE                                                 
P00201     ELSE                                                         
P00201         DISPLAY '********** PCSCA622  ABORT ************'        
P00201         DISPLAY '* 7120-CLOSE-CUST-DET-CURSOR         *'         
P00201         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00201         DISPLAY '* PROGRAM ABORTING...                *'         
P00201         DISPLAY '********** PCSCA622  ABORT ************'        
P00201         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00201     END-IF.                                                      
P00201*                                                                         
P00201 7120-EXIT.                                                       
P00201     EXIT.                                                        
P00201******************************************************************        
P00201* CHECKS FOR LANDLORD INFO.                                               
P00201******************************************************************        
P00201*                                                                         
P00201*7100-GET-LL-INFO.                                                        
P00201*                                                                         
P00201*    EXEC SQL                                                             
P00201*       SELECT :WS-Y                                                      
P00201*         INTO :WS-LL-FOUND                                               
P00201*         FROM CSS_LANDLORD                                               
P00201*        WHERE PREMISE_NO = :AT-PREMISE-NO                                
A37061*        WITH UR                                                          
P00201*    END-EXEC.                                                            
P00201*                                                                         
P00201*    MOVE SQLCODE                        TO                               
P00201*                                         WS-ACTIVE-RETURN-CODE.          
P00201*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND          
P00201*        CONTINUE                                                         
P00201*    ELSE                                                                 
P00201*        DISPLAY '********** PCSCA622   ABORT ************'               
P00201*        DISPLAY '* 7100-GET-LL-INFO                    *'                
P00201*        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE                   
P00201*        DISPLAY '* PROGRAM ABORTING...                 *'                
P00201*        DISPLAY '********** PCSCA622   ABORT ************'               
P00201*        PERFORM 9900-ABEND              THRU 9900-EXIT                   
P00201*    END-IF.                                                              
P00201*                                                                         
P00201*7100-EXIT.                                                               
P00201*    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      * WRITES A RECORD TO FCSCA622-FILE                              *         
      *****************************************************************         
       8000-WRITE-E-FCA622-REC.                                         
      *                                                                         
           WRITE FIOCA622.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSES  THE OUTPUT  FILES                                  **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE   FCSCA622-FILE                                        
      *                                                                         
           IF  FCA622-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSCA622-FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FCA622-STATUS                 
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
