       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA621.                                         
       DATE-WRITTEN.   11 JUNE 2004.                                    
       DATE-COMPILED.                                                   
      *****************************************************************         
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **              COMPLETE BUSINESS SOLUTIONS INC.               **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **            PROGRAM    MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **                                                             **         
C33884** 09/11/06   NC94746    INCLUDED ITRON MOBILE AMR SOURCE BY   **         
C33884**                       ADDING CSS_MTR_RD_SOURCE TABLE WITH   **         
C33884**                       SEND_READ_REQ_FL = 'Y'                **         
      **                                                             **         
C35599** 04/04/07   NC94746    ENHANCE THE PROGAM TO GENERATE AMR    **         
C35599**                       LETTERS BY USING ACCOUNT LIST INPUT   **         
C35599**                       FILE                                  **         
C35599**                                                             **         
T35584**  4/10/07   DB41297    CHANGES FOR COMMUNICATION TYPES       **         
T35584**                        AND SUBTYPES.                        **         
C32098** 07/27/07   RC41079   CHANGE TO EXCLUDE METERS WITH CONSTANT **         
C32098**                      > 1.                                   **         
T35599** 10/25/07   PG36856   CHANGE TO EXCLUDE ELECTRIC METERS CLASS**         
T35599**                      CODES 64, 66, 73, 91, & 17.            **         
T32098** 03/20/08   NC94746   BUG FIX. REMOVE CODE THAT FETCH TWICE  **         
T32098**                      AND NOT PROCESSING ONE ROW             **         
T35152** 05-29-08   PG36856   ADDED NEW FIELDS TO RP000 AND REMOVED  **         
T35152**                      NAME AND ADDRESS PROCESS.              **         
T37417** 06-26-08   SS95855   AMR LETTER CHANGE - SEND LETTERS TO    **         
T37417**                      ACTIVE ACCOUNTS.                       **         
A03866** 01/30/12   MC95456   COMMUNICATION DETAILS ARE TO BE        **         
A03866** A03866-ACT011        WRITTEN TO CSS_COMM_DATA.              **         
ACT034** 04/04/12   NS75440   MOVED 'N' TO KO-RED-FLAG-IND AND       **         
ACT034**   A03967             KO-PSC-COMPLIANCE-IND ALSO REMOVED     **         
ACT034**                      COMMENTS.                              **         
P00599** 13/09/12   AS7C117   INSERT NOTICES INTO DB2 TABLES         **         
P00599**                      INSTEAD OF WRITING IT TO RP000 FILE    **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSCA621 NARRATIVE                        
            THIS PROGRAM EXTRACTS THE DETAILS OF ALL THE ACCOUNTS       
            BASED ON THE USER SPECIFIED ROUTE/SEQ# COMBINATION. SUCH    
            EXTRACTED FILE WILL BE USED TO PRINT NOTICES.               
            APPLICATION WHICH WILL CREATE SERVICE WORK ORDERS           
      *                                                                         
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  5000 - 5999     COMMON PROGRAM MODULES                
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSPT32.                                                            
      *                                                                         
      *                                                                         
C35599 COPY CSSCA621.                                                           
C35599*                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
C35599*                                                                         
C35599 COPY CFDCA621.                                                           
C35599*                                                                         
C35599 COPY FIOCA621.                                                           
      *                                                                         
       COPY CFDPT32.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA621'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSCA621 STARTS HERE'.                  
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-VENDER-NAME              PIC X(50) VALUE SPACES.        
          05 WS-HONK                     PIC X.                         
          05 WS-I-AM-DOING-A-LOCOFF      PIC X.                         
          05 WS-I-AM-DOING-A-ROUTE       PIC X.                         
          05 WS-ACCOUNT-NO               PIC S9(13)V COMP-3 VALUE 0.    
          05 WS-CUSTOMER-NO              PIC S9(10)V COMP-3 VALUE 0.    
          05 WS-COMPANY-NO               PIC XX VALUE SPACES.           
C35599    05 WS-REQUEST-COMPANY          PIC XX VALUE SPACES.           
          05 WS-PHONE-NO                 PIC X(10) VALUE SPACES.        
          05 WS-CO-ROUTE-SUB             PIC S9(3) COMP-3 VALUE 0.      
          05 WS-SUB                      PIC S9(3) COMP-3 VALUE 0.      
          05 WS-SCEG                     PIC X  VALUE 'N'.              
          05 WS-PSNC                     PIC X  VALUE 'N'.              
          05 WS-LO-LOCAL-OFFICE          PIC XXX.                       
          05 WS-HI-LOCAL-OFFICE          PIC XXX.                       
A03866    05 WS-RED-FL-NULL-IND          PIC S9(04) COMP VALUE +0.      
A03866    05 WS-INITIAL-COMMENT-TX.                                     
A03866        10  WS-INITIAL-COMMENT-TX-LEN  PIC S9(4) USAGE COMP.      
A03866        10  WS-INITIAL-COMMENT-TX-TEXT PIC X(255) VALUE SPACES.   
A03866    05 WS-END-NULL-IND             PIC S9(04) COMP VALUE +0.      
A03866    05 WS-MESSAGE-NO               PIC 9(05)  VALUE 40003.        
      *                                                                         
          05 WS-BEG-READ-ROUTE           PIC 9(4).                      
          05 WS-END-READ-ROUTE           PIC 9(4).                      
          05 WS-BEG-READ-ROUTE-C         PIC S9(4) COMP VALUE ZERO.     
          05 WS-END-READ-ROUTE-C         PIC S9(4) COMP VALUE ZERO.     
      *                                                                         
          05 WS-LO-UTIL                  PIC X.                         
          05 WS-HI-UTIL                  PIC X.                         
          05 PROGRAM-NAME                PIC X(8)  VALUE 'PCSCA621'.    
          05 WS-PGRMNAME                 PIC X(8)  VALUE 'PCSCA621'.    
          05 WS-READ-ROUTE               PIC S9(4) COMP.                
          05 WS-BEG-SEQ-N                PIC 9(9).                      
          05 WS-END-SEQ-N                PIC 9(9).                      
COB305    05 WS-BEG-SEQ        PIC S9(9) COMP-3 VALUE 0.              
COB305    05 WS-END-SEQ        PIC S9(9) COMP-3 VALUE 0.              
          05 WS-NO-MORE-DATA             PIC X  VALUE 'N'.              
C35599    05 WS-FCA621-REC-CNT           PIC S9(09) COMP VALUE ZERO.    
C35599    05 WS-FCA621-STATUS            PIC XX.                        
C35599       88 FCA621-SUCCESSFUL  VALUE '00'.                          
C35599    05 WS-EOF-FLAG                 PIC X VALUE 'N'.               
C35599       88 END-OF-FILE                    VALUE 'Y'.               
C35599    05 WS-PROCESS-TYPE             PIC X VALUE ' '.               
C35599       88 WS-DBASE-PROCESS               VALUE ' '.               
C35599       88 WS-INPUT-FILE-PROCESS          VALUE 'Y'.               
          05 WS-FCA32-STATUS             PIC XX.                        
             88 FCA32-SUCCESSFUL  VALUE '00'.                           
          05 WS-SEQ-NO                   PIC X(8).                      
          05 WS-SEQ-NO-JUSTIFIED         PIC X(8) JUSTIFIED RIGHT.      
          05 WS-INSPECT-CNTR             PIC 99    VALUE ZERO.          
          05 WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.        
          05 WS-CURRENT-DATE             PIC X(10) VALUE SPACES.        
          05 WS-DISPLAY-RC               PIC -ZZZZZZZZ9.9.              
COB305    05 WS-CORRESP-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.      
      *                                                                         
       01 WS-WORK-DATE.                                                 
           05 WS-WORK-YYYY               PIC X(4).                      
           05 FILLER                     PIC X    VALUE '-'.            
           05 WS-WORK-MM                 PIC XX.                        
           05 FILLER                     PIC X    VALUE '-'.            
           05 WS-WORK-DD                 PIC XX.                        
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 WS-LINE-COUNT               PIC S9(3) COMP-3 VALUE +66.    
          05 WS-LINE-COUNTX REDEFINES WS-LINE-COUNT PIC X(2).           
          05 WS-PAGE-COUNT               PIC S9(3) COMP-3 VALUE ZEROS.  
      *                                                                         
       01 WS-CO-ROUTE-AREA.                                             
          05 TAB-COMPANY              PIC XX    VALUE SPACES.           
          05 TAB-LOCAL-OFFICE         PIC X(3)  VALUE SPACES.           
          05 TAB-ROUTE                PIC X(4)  VALUE SPACES.           
          05 TAB-NOTICES-SENT         PIC S9(5) COMP-3 VALUE ZEROS.     
          05 TAB-NOTICES-NOT-SENT     PIC S9(5) COMP-3 VALUE ZEROS.     
          05 TOTAL-NOTICES            PIC S9(5) COMP-3 VALUE ZEROS.     
      *                                                                         
       01  WS-SERV-ADDRESS.                                             
           05  WS-STREET                 PIC X(39).                     
           05  WS-ADDR-OVERFLOW          PIC X(26).                     
           05  WS-ADDR-CITY-STATE-ZIP    PIC X(41).                     
           05  WS-ADDR-ZIP.                                             
                 10  WS-ADDR-ZIP-CODE    PIC X(5).                      
                 10  WS-ADDR-ZIP-PLUS-4  PIC X(4).                      
                 10  WS-ADDR-DEL-PT      PIC XX.                        
           05  WS-CARRIER-ROUTE          PIC X(5).                      
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-LIT1                     PIC X(29)                      
             VALUE 'CURRENT METER IS AN AMR METER'.                     
          05 WS-LIT2                     PIC X(29)                      
             VALUE 'PROBED METER                 '.                     
          05 WS-LIT3                     PIC X(29)                      
             VALUE 'MULTI-REGISTER METER         '.                     
          05 WS-LIT4                     PIC X(29)                      
             VALUE 'DEAD HEAD ACCOUNT            '.                     
          05 WS-LIT5                     PIC X(29)                      
             VALUE 'SINGLE REGISTER METER        '.                     
C32098    05 WS-LIT6                     PIC X(29)                      
C32098       VALUE 'METER CONSTANT > 1           '.                     
T35599    05 WS-LIT7                     PIC X(29)                      
T35599       VALUE 'POLYPHASE BOLT-IN METER      '.                     
          05 WS-K                        PIC X  VALUE 'K'.              
          05 WS-N                        PIC X  VALUE 'N'.              
          05 WS-Y                        PIC X  VALUE 'Y'.              
          05 WS-U                        PIC X  VALUE 'U'.              
          05 WS-CURRENT-RES              PIC X(19)                      
             VALUE 'OR CURRENT RESIDENT'.                               
      *                                                                         
       01 WS-ROUTE-HDR.                                                 
          05 FILLER                      PIC X(11)                      
             VALUE ' FOR ROUTE '.                                       
          05 WS-MOVE-ROUTE               PIC X(4)  VALUE SPACES.        
          05 FILLER                      PIC X(10) VALUE SPACES.        
      *                                                                         
       01 WS-LOCOF-HDR.                                                 
          05 FILLER                      PIC X(18)                      
             VALUE ' FOR LOCAL OFFICE '.                                
          05 WS-MOVE-LOCOFF              PIC X(3)  VALUE SPACES.        
          05 FILLER                      PIC X(4)  VALUE SPACES.        
      *                                                                         
C35599 01 WS-ACC-FILE-HDR.                                              
C35599    05 FILLER                      PIC X(19)                      
C35599       VALUE ' FOR GIVEN ACCOUNTS'.                               
C35599    05 FILLER                      PIC X(6)  VALUE SPACES.        
      *                                                                         
       01 WS-PARM-DATA.                                                 
          05 WS-PARM-DETAILS.                                           
             10 WS-PARM-CO-NO            PIC X(3).                      
                88 COMP-HDR    VALUE 'CO='.                             
             10 WS-PARM-COMP-NO          PIC XX.                        
             10 FILLER                   PIC X.                         
             10 WS-PARM-ROUTE            PIC X(6).                      
                88 ROUTE-HDR   VALUE 'ROUTE='.                          
             10 WS-PARM-ROUTE-VAL        PIC 9(4).                      
             10 FILLER                   PIC X.                         
             10 WS-PARM-BEG-SEQ          PIC X(10).                     
                88 BEG-SEQ-HDR VALUE 'BEGIN SEQ='.                      
             10 WS-PARM-BEG-SEQ-VAL      PIC X(8).                      
             10 FILLER                   PIC X.                         
             10 WS-PARM-END-SEQ          PIC X(8).                      
                88 END-SEQ-HDR VALUE 'END SEQ='.                        
             10 WS-PARM-END-SEQ-VAL      PIC X(8).                      
      *                                                                         
       01  WS-PARM-LOC-OFF-DATA REDEFINES WS-PARM-DATA.                 
           05 WS-LO-CO-NO                 PIC X(3).                     
              88 COMP-HDR-LO VALUE 'CO='.                               
           05 WS-LO-COMP-NO               PIC XX.                       
           05 FILLER                      PIC X.                        
           05 WS-PARM-LOC-OFF-LITERAL     PIC X(7).                     
              88 LOC-OFF-HDR    VALUE 'LOCOFF='.                        
           05 WS-PARM-LOC-OFF             PIC X(3).                     
           05 FILLER                      PIC X(64).                    
      *                                                                         
       01 WS-PARM-UTIL-DATA.                                            
          05 WS-PARM-UTIL-LITERAL        PIC X(10).                     
          05 WS-PARM-UTIL-TYPE           PIC X.                         
             88 ELECTRIC       VALUE 'E'.                               
             88 GAS            VALUE 'G'.                               
             88 BOTH           VALUE 'B'.                               
          05 FILLER                      PIC X.                         
          05 WS-PARM-METER-LITERAL       PIC X(11).                     
          05 WS-PARM-METER-TYPE          PIC X.                         
             88 SINGLE         VALUE 'S'.                               
             88 BOTH           VALUE 'B'.                               
          05 FILLER                      PIC X(56).                     
      *                                                                         
       01 WS-VENDER-NAME-DATA.                                          
          05 WS-PARM-NAME                PIC X(12).                     
          05 WS-PARM-NAME-LITERAL        PIC X(50).                     
          05 FILLER                      PIC X(18).                     
      *                                                                         
       01  WS-WHO-CARES-DATE              PIC X(10).                    
      *                                                                         
       01  WS-SAVE-DATA.                                                
           05  WS-SAVE-CO                 PIC XX.                       
           05  WS-SAVE-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.   
           05  WS-SAVE-UTIL-TYPE          PIC X.                        
           05  WS-SAVE-METER-NO           PIC X(9).                     
      *                                                                         
       01 HEADER1.                                                      
          05 FILLER             PIC X(11) VALUE 'PCSCA621-01'.          
          05 FILLER             PIC X(37) VALUE SPACES.                 
          05 WS-COMPANY-NAME    PIC X(26) VALUE SPACES.                 
          05 FILLER             PIC X(25) VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN DATE:  '.          
          05 HDR-DATE           PIC X(17) VALUE SPACES.                 
          05 FILLER             PIC X(5)  VALUE SPACES.                 
      *                                                                         
       01 HEADER2.                                                      
          05 FILLER             PIC X(33) VALUE SPACES.                 
          05 FILLER             PIC X(33) VALUE                         
             'AMR NOTIFICATION EXCEPTION REPORT'.                       
          05 PRT-HDR-MESSAGE    PIC X(25) VALUE SPACES.                 
          05 FILLER             PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC X(11) VALUE 'RUN TIME:  '.          
          05 HDR-TIME           PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC XX    VALUE SPACES.                 
          05 FILLER             PIC X(7)  VALUE 'PAGE = '.              
          05 HDR-PAGE           PIC ZZ9.                                
          05 FILLER             PIC XX    VALUE SPACES.                 
      *                                                                         
       01 HEADER3.                                                      
          05 FILLER             PIC X     VALUE SPACES.                 
          05 FILLER             PIC X(14) VALUE 'ACCOUNT NUMBER'.       
          05 FILLER             PIC XX    VALUE SPACES.                 
          05 FILLER             PIC X(9)  VALUE 'METER NBR'.            
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(4)  VALUE 'UTIL'.                 
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(3)  VALUE 'DMT'.                  
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(5)  VALUE 'PGMID'.                
          05 FILLER             PIC X(3)  VALUE SPACES.                 
          05 FILLER             PIC X(3)  VALUE 'RRI'.                  
          05 FILLER             PIC X(8)  VALUE SPACES.                 
          05 FILLER             PIC X(15) VALUE 'SERVICE ADDRESS'.      
          05 FILLER             PIC X(34) VALUE SPACES.                 
          05 FILLER             PIC X(8)  VALUE 'COMMENTS'.             
          05 FILLER             PIC X(3)  VALUE SPACES.                 
      *                                                                         
       01 NO-DATA-LINE.                                                 
          05 NO-DATA-LITERAL    PIC X(22)                               
                    VALUE 'NO DATA FOR THIS RUN  '.                     
      *                                                                         
       01 PRINT-LINE.                                                   
          05 FILLER                PIC X     VALUE SPACES.              
          05 PRT-ACCOUNT           PIC X(13).                           
          05 FILLER                PIC X(3)  VALUE SPACES.              
          05 PRT-METER-NO          PIC X(9).                            
          05 FILLER                PIC X(5)  VALUE SPACES.              
      *                                                                         
          05 PRT-MESSAGE.                                               
             07 PRT-UTIL-TYPE      PIC X.                               
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-DMT            PIC X(3).                            
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-PGM-ID         PIC XX.                              
             07 FILLER             PIC X(5)  VALUE SPACES.              
             07 PRT-REMOTE-READ    PIC X.                               
      *                                                                         
          05 FILLER                PIC X(5)  VALUE SPACES.              
          05 PRT-ADDRESS           PIC X(42).                           
          05 FILLER                PIC X(3) VALUE SPACES.               
          05 PRT-COMMENT           PIC X(29).                           
C35599*                                                                         
C35599 01 PRINT-TOTAL-ACCOUNT-LINE.                                     
C35599    05 FILLER                PIC X      VALUE SPACES.             
C35599    05 FILLER                PIC X(17)                            
C35599       VALUE 'TOTAL ACCOUNTS = '.                                 
C35599    05 PRT-TOTAL-ACCOUNTS    PIC Z(9)9  VALUE ZEROS.              
C35599    05 FILLER                PIC X(14)  VALUE SPACES.             
C35599    05 FILLER                PIC X(18)                            
C35599       VALUE 'NOTICE NOT SENT = '.                                
C35599    05 PRT-NO-NOTICE-AC      PIC Z(9)9  VALUE ZEROS.              
C35599    05 FILLER                PIC X(7)   VALUE SPACES.             
C35599    05 FILLER                PIC X(14)                            
C35599       VALUE 'NOTICE SENT = '.                                    
C35599    05 PRT-YES-NOTICE-AC     PIC Z(9)9  VALUE ZEROS.              
C35599    05 FILLER                PIC X(32)  VALUE SPACES.             
      *                                                                         
       01 PRINT-TOTAL-LOCOFF-LINE.                                      
          05 FILLER                PIC X      VALUE SPACES.             
          05 FILLER                PIC X(18)                            
             VALUE 'TOTAL FOR COMPANY '.                                
          05 PRT-COMPANY-LO        PIC XX     VALUE SPACES.             
          05 FILLER                PIC X(14)                            
             VALUE ' LOCAL OFFICE '.                                    
          05 PRT-NOTICE-LOCOFF     PIC X(3)   VALUE SPACES.             
          05 FILLER                PIC X(5)   VALUE SPACES.             
          05 FILLER                PIC X(18)                            
             VALUE 'NOTICE NOT SENT = '.                                
          05 PRT-NO-NOTICE-LO      PIC Z(9)9  VALUE ZEROS.              
          05 FILLER                PIC X(5)   VALUE SPACES.             
          05 FILLER                PIC X(14)                            
             VALUE 'NOTICE SENT = '.                                    
          05 PRT-YES-NOTICE-LO     PIC Z(9)9  VALUE ZEROS.              
          05 FILLER                PIC X(32)  VALUE SPACES.             
      *                                                                         
       01 PRINT-TOTAL-ROUTE-LINE.                                       
          05 FILLER                PIC X      VALUE SPACES.             
          05 FILLER                PIC X(18)                            
             VALUE 'TOTAL FOR COMPANY '.                                
          05 PRT-COMPANY-RT        PIC XX     VALUE SPACES.             
          05 FILLER                PIC X(7)                             
             VALUE ' ROUTE '.                                           
          05 PRT-NOTICE-ROUTE      PIC X(4)   VALUE SPACES.             
          05 FILLER                PIC X(4)   VALUE SPACES.             
          05 FILLER                PIC X(18)                            
             VALUE 'NOTICE NOT SENT = '.                                
          05 PRT-NO-NOTICE-RT      PIC Z(9)9  VALUE ZEROS.              
          05 FILLER                PIC X(5)   VALUE SPACES.             
          05 FILLER                PIC X(14)                            
             VALUE 'NOTICE SENT = '.                                    
          05 PRT-YES-NOTICE-RT     PIC Z(9)9  VALUE ZEROS.              
          05 FILLER                PIC X(39)  VALUE SPACES.             
      *                                                                         
      *****************************************************************         
      **                   NECESSARY COPYBOOKS                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************                                             
      **  ABEND SWITCH COPYBOOK  **                                             
      *****************************                                             
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      **********************************                                        
      **  DB2 AND SQL ERROR CHECKING  **                                        
      **********************************                                        
      *                                                                         
           COPY CWS00303.                                                       
P00599*****************************************************************         
P00599*  CWS00350  - CORRESP_COMM VARIABLES                           *         
P00599*****************************************************************         
P00599     EXEC SQL                                                             
P00599       INCLUDE CWS00350                                                   
P00599     END-EXEC.                                                            
P00599                                                                  
P00599******************************************************************        
P00599* CORRESP MAIL UID CPYC WS VARIABLES.                            *        
P00599******************************************************************        
P00599     EXEC SQL                                                             
P00599         INCLUDE CWSCA165                                                 
P00599     END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                 COMMON ABEND FUNCTIONALITY                  **         
      *****************************************************************         
      *                                                                         
       01 ABEND-FUNCTIONS.                                              
          05 WS-ABEND-SPACE              PIC XX  VALUE SPACE.           
          05 FILLER REDEFINES WS-ABEND-SPACE.                           
             10 WS-ABEND-NUMERIC         PIC 99.                        
      *                                                                         
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
P00599******************************************************************        
P00599* CSS_DELINQUENCY  - C8                                          *        
P00599******************************************************************        
P00599                                                                  
P00599     EXEC SQL                                                             
P00599         INCLUDE TBDELQ                                                   
P00599     END-EXEC.                                                            
P00599                                                                  
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_UTIL_ENVRNMT**                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      **********************                                                    
      **  CSS_MTRD_ENVRNMT**                                                    
      **********************                                                    
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
T35599**********************                                                    
T35599**  CSS_ELEC_METER  **                                                    
T35599**********************                                                    
T35599*                                                                         
T35599     EXEC SQL                                                             
T35599       INCLUDE TBELMTR                                                    
T35599     END-EXEC.                                                            
T35599*                                                                         
      *                                                                         
C32098**********************                                                    
C32098**  CSS_MTR_CAP     **                                                    
C32098**********************                                                    
C32098*                                                                         
C32098     EXEC SQL                                                             
C32098       INCLUDE TBMTRCAP                                                   
C32098     END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_ACCOUNT  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_LOCAL_OFFICE **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBLOCOFC                                                   
           END-EXEC.                                                            
      *                                                                         
      *******************                                                       
      **  CSS_COMPANY  **                                                       
      *******************                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_NAME         **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_NAME_ACCT_XREF*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_ADDR_FREEFORM**                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
      ***********************                                                   
      **  CSS_ADDR_FORMATTED*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
      ***********************                                                   
      **  CSS_ZIP_CODE     **                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
      *                                                                         
      ***********************                                                   
      **  CSS_CUST_ADDR_XREF*                                                   
      ***********************                                                   
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
      *                                                                         
      ************************                                                  
      **  CSS_ACCT_MISC_INFO**                                                  
      ************************                                                  
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
      *   DCLGEN COPYBOOK FOR CSS_CUST_PREM_HIST *                              
      ********************************************                              
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCSTPRM                                                   
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
A03866*   DCLGEN COPYBOOK FOR CSS_COMM_DATA(KO)  *                              
      ********************************************                              
      *                                                                         
           EXEC SQL                                                             
A03866       INCLUDE TBCOMDAT                                                   
           END-EXEC.                                                            
P00599******************************************************************        
P00599* CSS_CORRESP_NOTICE- 1M                                         *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORNOT                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************        
P00599* CSS_CORRESP_HDR - 1J                                           *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORVAR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599                                                                  
P00599******************************************************************        
P00599* CSS_CORRESP_COMM  - 1L                                         *        
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORCOM                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************        
      *                                                                         
      ********************************************                              
      **  CURSOR DECLARATION -- ROUTE_METER_CSR **                              
      ********************************************                              
           EXEC SQL                                                     
            DECLARE ROUTE_METER_CSR CURSOR FOR                          
             SELECT AT.ACCOUNT_NO                                       
                   ,AT.CUSTOMER_NO                                      
                   ,UT.READ_ROUTE                                       
                   ,UT.READ_CYCLE                                       
                   ,AT.LOCAL_OFFICE                                     
                   ,MN.REGISTER_RD_SEQ                                  
                   ,MN.METER_NO                                         
                   ,MN.CODE_UTIL_TYPE                                   
                   ,MN.MTR_REF_NO                                       
                   ,MN.IC_NO                                            
                   ,AT.PREMISE_NO                                       
                   ,MN.DIGTL_MTR_TYPE                                   
                   ,MN.PROGRAM_ID                                       
                   ,AT.ADDRESS_ID                                       
                   ,MN.REMOTE_READ_IND                                  
                   ,MN.CODE_DATA_PRESENT                                
                   ,B1.PHONE_NO                                         
                   ,AT.ADDRESS_FORMAT                                   
                   ,UT.CODE_REVENUE_CLASS                               
                   ,AT.CODE_ACCT_STAT                                   
C32098             ,MC.CONSTANT                                         
               FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
                    ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
                    ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
C33884              ,CSS_MTR_RD_SOURCE X7 WITH(READUNCOMMITTED)                 
C32098              ,CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                      
              WHERE AT.COMPANY_NO         = :AT-COMPANY-NO              
                AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO               
AARON           AND MN.REMOTE_READ_IND    = 'C'                         
T37417          AND AT.CODE_ACCT_STAT     = 'A'                         
T32098          AND UT.CODE_UTIL_TYPE IN (:WS-LO-UTIL, :WS-HI-UTIL)     
                AND UT.READ_ROUTE BETWEEN :WS-BEG-READ-ROUTE-C          
                                      AND :WS-END-READ-ROUTE-C          
                AND AT.LOCAL_OFFICE BETWEEN :WS-LO-LOCAL-OFFICE         
                                        AND :WS-HI-LOCAL-OFFICE         
                AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO               
                AND UT.IC_NO              = MN.IC_NO                    
                AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE           
C32098          AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE           
                AND MN.CODE_METER_STATUS  <> 'K'                        
                AND MN.REGISTER_RD_SEQ   BETWEEN :WS-BEG-SEQ            
                                             AND :WS-END-SEQ            
C33884          AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD       
C32098          AND MN.METER_NO           = MC.METER_NO                 
C32098          AND MC.REG_ID_NO          = MN.REG_ID_NO                
C33884          AND X7.SEND_READ_REQ_FL   = 'Y'                         
                AND AT.COMPANY_NO   = B1.COMPANY_NO                     
C32098          AND AT.COMPANY_NO   = MC.COMPANY_NO                     
                AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                   
                ORDER BY AT.ACCOUNT_NO,                                 
                         UT.CODE_UTIL_TYPE                              
C33884        FOR READ ONLY                                     
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ROUTE_METER_CSR CURSOR FOR                                  
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,UT.READ_CYCLE                                               
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,MN.REGISTER_RD_SEQ                                          
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_UTIL_TYPE                                           
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*            ,MN.IC_NO                                                    
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.CODE_DATA_PRESENT                                        
MFA-TR*            ,B1.PHONE_NO                                                 
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,UT.CODE_REVENUE_CLASS                                       
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,MC.CONSTANT                                                 
MFA-TR*        FROM  CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*             ,CSS_MTR_RD_SOURCE X7                                       
MFA-TR*             ,CSS_MTR_CAP  MC                                            
MFA-TR*       WHERE AT.COMPANY_NO         = :AT-COMPANY-NO                      
MFA-TR*         AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND MN.REMOTE_READ_IND    = 'C'                                 
MFA-TR*         AND AT.CODE_ACCT_STAT     = 'A'                                 
MFA-TR*         AND UT.CODE_UTIL_TYPE IN (:WS-LO-UTIL, :WS-HI-UTIL)             
MFA-TR*         AND UT.READ_ROUTE BETWEEN :WS-BEG-READ-ROUTE-C                  
MFA-TR*                               AND :WS-END-READ-ROUTE-C                  
MFA-TR*         AND AT.LOCAL_OFFICE BETWEEN :WS-LO-LOCAL-OFFICE                 
MFA-TR*                                 AND :WS-HI-LOCAL-OFFICE                 
MFA-TR*         AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO                       
MFA-TR*         AND UT.IC_NO              = MN.IC_NO                            
MFA-TR*         AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_METER_STATUS  <> 'K'                                
MFA-TR*         AND MN.REGISTER_RD_SEQ   BETWEEN :WS-BEG-SEQ                    
MFA-TR*                                      AND :WS-END-SEQ                    
MFA-TR*         AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD               
MFA-TR*         AND MN.METER_NO           = MC.METER_NO                         
MFA-TR*         AND MC.REG_ID_NO          = MN.REG_ID_NO                        
MFA-TR*         AND X7.SEND_READ_REQ_FL   = 'Y'                                 
MFA-TR*         AND AT.COMPANY_NO   = B1.COMPANY_NO                             
MFA-TR*         AND AT.COMPANY_NO   = MC.COMPANY_NO                             
MFA-TR*         AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                           
MFA-TR*         ORDER BY AT.ACCOUNT_NO,                                         
MFA-TR*                  UT.CODE_UTIL_TYPE                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            
C35599*                                                                         
C35599********************************************                              
C35599**  CURSOR DECLARATION -- FILE_METER_CSR **                               
C35599********************************************                              
C35599     EXEC SQL                                                     
C35599      DECLARE FILE_METER_CSR CURSOR FOR                           
C35599       SELECT AT.ACCOUNT_NO                                       
C35599             ,AT.CUSTOMER_NO                                      
C35599             ,UT.READ_ROUTE                                       
C35599             ,UT.READ_CYCLE                                       
C35599             ,AT.LOCAL_OFFICE                                     
C35599             ,MN.REGISTER_RD_SEQ                                  
C35599             ,MN.METER_NO                                         
C35599             ,MN.CODE_UTIL_TYPE                                   
C35599             ,MN.MTR_REF_NO                                       
C35599             ,MN.IC_NO                                            
C35599             ,AT.PREMISE_NO                                       
C35599             ,MN.DIGTL_MTR_TYPE                                   
C35599             ,MN.PROGRAM_ID                                       
C35599             ,AT.ADDRESS_ID                                       
C35599             ,MN.REMOTE_READ_IND                                  
C35599             ,MN.CODE_DATA_PRESENT                                
C35599             ,B1.PHONE_NO                                         
C35599             ,AT.ADDRESS_FORMAT                                   
C35599             ,UT.CODE_REVENUE_CLASS                               
C35599             ,AT.CODE_ACCT_STAT                                   
T35599             ,MC.CONSTANT                                         
C35599         FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
C35599              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
C35599              ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
C35599              ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
C35599              ,CSS_MTR_RD_SOURCE X7 WITH(READUNCOMMITTED)                 
T35599              ,CSS_MTR_CAP  MC WITH(READUNCOMMITTED)                      
C35599        WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO              
T37417          AND AT.CODE_ACCT_STAT     = 'A'                         
C35599          AND AT.COMPANY_NO         = :AT-COMPANY-NO              
C35599          AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO               
T32098          AND UT.CODE_UTIL_TYPE IN (:WS-LO-UTIL, :WS-HI-UTIL)     
C35599          AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO               
C35599          AND UT.IC_NO              = MN.IC_NO                    
C35599          AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE           
T35599          AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE           
C35599          AND MN.CODE_METER_STATUS  <> 'K'                        
C35599          AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD       
T35599          AND MN.METER_NO           = MC.METER_NO                 
T35599          AND MC.REG_ID_NO          = MN.REG_ID_NO                
C35599          AND X7.SEND_READ_REQ_FL   = 'Y'                         
C35599          AND B1.COMPANY_NO   = AT.COMPANY_NO                     
T35599          AND AT.COMPANY_NO   = MC.COMPANY_NO                     
C35599          AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                   
C35599          ORDER BY AT.ACCOUNT_NO,                                 
C35599                   UT.CODE_UTIL_TYPE                              
C35599        FOR READ ONLY                                     
A03866                                                      
C35599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE FILE_METER_CSR CURSOR FOR                                   
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,UT.READ_ROUTE                                               
MFA-TR*            ,UT.READ_CYCLE                                               
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,MN.REGISTER_RD_SEQ                                          
MFA-TR*            ,MN.METER_NO                                                 
MFA-TR*            ,MN.CODE_UTIL_TYPE                                           
MFA-TR*            ,MN.MTR_REF_NO                                               
MFA-TR*            ,MN.IC_NO                                                    
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,MN.DIGTL_MTR_TYPE                                           
MFA-TR*            ,MN.PROGRAM_ID                                               
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,MN.REMOTE_READ_IND                                          
MFA-TR*            ,MN.CODE_DATA_PRESENT                                        
MFA-TR*            ,B1.PHONE_NO                                                 
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,UT.CODE_REVENUE_CLASS                                       
MFA-TR*            ,AT.CODE_ACCT_STAT                                           
MFA-TR*            ,MC.CONSTANT                                                 
MFA-TR*        FROM  CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*             ,CSS_LOCAL_OFFICE B1                                        
MFA-TR*             ,CSS_MTR_RD_SOURCE X7                                       
MFA-TR*             ,CSS_MTR_CAP  MC                                            
MFA-TR*       WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*         AND AT.CODE_ACCT_STAT     = 'A'                                 
MFA-TR*         AND AT.COMPANY_NO         = :AT-COMPANY-NO                      
MFA-TR*         AND UT.ACCOUNT_NO         = AT.ACCOUNT_NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE IN (:WS-LO-UTIL, :WS-HI-UTIL)             
MFA-TR*         AND UT.ACCOUNT_NO         = MN.ACCOUNT_NO                       
MFA-TR*         AND UT.IC_NO              = MN.IC_NO                            
MFA-TR*         AND UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_UTIL_TYPE     = MC.CODE_UTIL_TYPE                   
MFA-TR*         AND MN.CODE_METER_STATUS  <> 'K'                                
MFA-TR*         AND MN.MTR_READ_SOURCE_CD = X7.MTR_READ_SOURCE_CD               
MFA-TR*         AND MN.METER_NO           = MC.METER_NO                         
MFA-TR*         AND MC.REG_ID_NO          = MN.REG_ID_NO                        
MFA-TR*         AND X7.SEND_READ_REQ_FL   = 'Y'                                 
MFA-TR*         AND B1.COMPANY_NO   = AT.COMPANY_NO                             
MFA-TR*         AND AT.COMPANY_NO   = MC.COMPANY_NO                             
MFA-TR*         AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                           
MFA-TR*         ORDER BY AT.ACCOUNT_NO,                                         
MFA-TR*                  UT.CODE_UTIL_TYPE                                      
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01 WS-WORKING-STORAGE-END         PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSCA621 ENDS HERE  '.                  
      *                                                                         
C35599*                                                                         
C35599 LINKAGE SECTION.                                                 
C35599 01  JCL-PARM.                                                    
C35599     05  PARM-LENGTH               PIC S9(4)      COMP.           
C35599     05  PARM-DATA.                                               
C35599         10  REQUEST-FILE          PIC X(04).                     
C35599         10  REQUEST-COMPANY       PIC X(02).                     
C35599*                                                                         
C35599 PROCEDURE DIVISION USING JCL-PARM.                               
      *                                                                         
      *****************************************************************         
      **    OPEN START END PARAGRAPHS                                **         
      *****************************************************************         
      *                                                                         
       0000-NOW-WE-START.                                               
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
C35599     IF WS-DBASE-PROCESS                                          
C35599        PERFORM 0200-DBASE-PROCESS THRU 0200-EXIT                 
C35599     ELSE                                                         
C35599        PERFORM 0600-FILE-PROCESS  THRU 0600-EXIT                 
C35599     END-IF                                                       
      *                                                                         
           IF WS-SAVE-CO = '01' AND WS-SCEG = 'N'                       
              MOVE 0             TO WS-PAGE-COUNT                       
              MOVE 'Y'           TO WS-SCEG                             
              PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT               
              MOVE SPACES        TO PRINT-LINE                          
              MOVE NO-DATA-LINE  TO PRT-MESSAGE                         
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES        TO PRINT-LINE                          
           END-IF.                                                      
      *                                                                         
           IF WS-SAVE-CO = '26' AND WS-PSNC = 'N'                       
              MOVE 0             TO WS-PAGE-COUNT                       
              MOVE 'Y'           TO WS-PSNC                             
              PERFORM 8200-NO-DATA-HEADERS THRU 8200-EXIT               
              MOVE SPACES        TO PRINT-LINE                          
              MOVE NO-DATA-LINE  TO PRT-MESSAGE                         
              PERFORM 8300-PRINT-REPORT THRU 8300-EXIT                  
              MOVE SPACES        TO PRINT-LINE                          
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **       OPEN OUTPUT FILE.                                     **         
      **       VALIDATE THE PARAMETER FROM CSS_JOB_PARM.             **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZE.                                                 
C35599*                                                                         
C35599* GET JCL PARM DETAILS                                                    
P00599     INITIALIZE DCLCSS-CORRESP-HDR                                
P00599                DCLCSS-CORRESP-VAR                                
C35599     SET WS-DBASE-PROCESS            TO TRUE                      
C35599     IF PARM-LENGTH > 0 AND REQUEST-FILE = 'FILE'                 
C35599        SET WS-INPUT-FILE-PROCESS   TO TRUE                       
C35599        MOVE REQUEST-COMPANY  TO WS-REQUEST-COMPANY               
C35599        MOVE WS-REQUEST-COMPANY TO AT-COMPANY-NO                  
C35599                                    WS-SAVE-CO                    
C35599                                    C7-COMPANY-NO                 
C35599                                    WS-PARM-COMP-NO               
C35599        DISPLAY '**********************************'              
C35599        DISPLAY '*** INPUT FILE PROCESS STARTED ***'              
C35599        DISPLAY '*** PROCESSING FOR COMPANY: ' C7-COMPANY-NO      
C35599        DISPLAY '**********************************'              
C35599        PERFORM 7300-SELECT-COMP-NAME THRU 7300-EXIT              
C35599        MOVE C7-COMPANY-NAME        TO WS-COMPANY-NAME            
C35599     END-IF.                                                      
C35599*                                                                         
C35599     IF WS-INPUT-FILE-PROCESS                                     
C35599        OPEN INPUT FCSCA621-FILE                                  
C35599*                                                                         
C35599        IF FCA621-SUCCESSFUL                                      
C35599           CONTINUE                                               
C35599        ELSE                                                      
C35599           DISPLAY '********************************************' 
C35599           DISPLAY '**     PCSCA621 PROCESSING ERROR          **' 
C35599           DISPLAY '**     OPEN ERROR ON FCSCA621 FILE        **' 
C35599           DISPLAY '**    FCA621 FILE STATUS = ' WS-FCA621-STATUS 
C35599           DISPLAY '**     PROCESSING TERMINATED....          **' 
C35599           DISPLAY '********************************************' 
C35599           PERFORM 9900-ABEND THRU 9900-EXIT                      
C35599        END-IF                                                    
C35599     END-IF.                                                      
C35599*                                                                         
      *                                                                         
P00599* TO IDENTIFY THE DATA BASE                                               
P00599     MOVE '01'                       TO C8-COMPANY-NO.            
P00599     MOVE ZERO                       TO WS-CWS350-DATABASE.       
P00599     MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
P00599     PERFORM 7150-SELECT-DELINQ-VALUE     THRU 7150-EXIT.         
P00599     MOVE C8-DELINQ-VALUE            TO WS-CWS350-DATABASE.       
P00599*                                                                         
      *                                                                         
           OPEN OUTPUT FCSPT32-FILE.                                    
           IF  FCA32-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'FCSPT32 FILE OPEN ERROR'                         
              DISPLAY 'FCSPT32 FILE STATUS IS ==>' WS-FCA32-STATUS      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP THRU 7500-EXIT.           
           MOVE WS-CURRENT-TIMESTAMP(12:8) TO HDR-TIME.                 
           MOVE WS-CURRENT-DATE TO WS-WORK-DATE                         
                                   HDR-DATE.                            
      *                                                                         
      *  GET PARM VENDER NAME -  IF NOT ACTIVE MOVE SPACES                      
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:12) =                   
                         'VENDER NAME=' AND INPUT-ACTIVE)               
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-VENDER-NAME-DATA.                    
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** INFORMATIONAL ONLY                 **'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**  VENDER NAME PARM NOT ACTIVE       **'        
              DISPLAY '**  MOVING SPACES                     **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              MOVE SPACES TO WS-VENDER-NAME                             
           ELSE                                                         
              MOVE WS-PARM-NAME-LITERAL TO WS-VENDER-NAME               
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
      *  GET UTIL TYPE AND METER TYPE PARM FROM CSS_JOB_PARM                    
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:10) =                   
                         'UTIL TYPE=' AND INPUT-ACTIVE)                 
                  OR  END-OF-SYSIPT.                                    
           MOVE G6-PARM-DATA TO WS-PARM-UTIL-DATA.                      
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**  UTIL TYPE PARM NOT ACTIVE         **'        
              DISPLAY '**  PROCESSING TERMINATED             **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              IF (WS-PARM-UTIL-TYPE = 'E' OR 'G' OR 'B')                
                    AND (WS-PARM-METER-TYPE = 'S' OR 'B' OR 'M')        
                 IF WS-PARM-UTIL-TYPE = 'E'                             
                    MOVE 'E' TO WS-LO-UTIL                              
                    MOVE 'E' TO WS-HI-UTIL                              
                 END-IF                                                 
                 IF WS-PARM-UTIL-TYPE = 'G'                             
                    MOVE 'G' TO WS-LO-UTIL                              
                    MOVE 'G' TO WS-HI-UTIL                              
                 END-IF                                                 
                 IF WS-PARM-UTIL-TYPE = 'B'                             
                    MOVE 'E' TO WS-LO-UTIL                              
                    MOVE 'G' TO WS-HI-UTIL                              
                 END-IF                                                 
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              ELSE                                                      
                 DISPLAY ' '                                            
                 DISPLAY '****************************************'     
                 DISPLAY '** ' WS-PGRMNAME '                    **'     
                 DISPLAY '**      INVALID PARM FOR              **'     
                 DISPLAY '**     UTIL TYPE / METER TYPE         **'     
                 DISPLAY '**  UTIL TYPE MUST = E OR G OR B      **'     
                 DISPLAY '**  METER TYPE MUST = S OR B OR M     **'     
                 DISPLAY '**     PROCESSING TERMINATED          **'     
                 DISPLAY '****************************************'     
                 DISPLAY ' '                                            
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
C35599*                                                                         
C35599*===============================================================*         
C35599 0200-DBASE-PROCESS.                                              
C35599*===============================================================*         
C35599*                                                                         
      *  GET COMPANY NUMBER, ROUTE AND SEQ NUMBERS FROM JOB_PARM                
      *  OR LOCAL OFFICE                                                        
C35599*                                                                         
C35599     DISPLAY '***********************************'                
C35599     DISPLAY '*** DATA EXTRACT USING JOB PARM ***'                
C35599     DISPLAY '***********************************'                
C35599*                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) = 'CO='              
                  AND WS-INPUT-DATA-BREAKDOWN(7:6) = 'ROUTE='           
                    AND INPUT-ACTIVE)                                   
                 OR (WS-INPUT-DATA-BREAKDOWN(1:3) = 'CO='               
                  AND WS-INPUT-DATA-BREAKDOWN(7:7) = 'LOCOFF='          
                    AND INPUT-ACTIVE)                                   
                 OR  END-OF-SYSIPT                                      
           IF END-OF-SYSIPT                                             
              DISPLAY ' '                                               
              DISPLAY '****************************************'        
              DISPLAY '** ' WS-PGRMNAME '                    **'        
              DISPLAY '**    COMPANY NUMBER, ROUTE AND       **'        
              DISPLAY '**    SEQUENCE PARM NOT ACTIVE        **'        
              DISPLAY '**     PROCESSING TERMINATED          **'        
              DISPLAY '****************************************'        
              DISPLAY ' '                                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +100                           
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
C35599     PERFORM 0210-PROCESS-DB   THRU 0210-EXIT                     
C35599                 UNTIL END-OF-SYSIPT.                             
      *                                                                         
C35599 0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **         THIS PARAGRAPH TAKES THE ROWS FROM CSS_JOB_PARM TABLE*         
      **         AND DETERMINE IF THE VALUES IN PARM-DATA FIELD ARE  **         
      **         VALID.                                              **         
      *****************************************************************         
      *                                                                         
C35599 0210-PROCESS-DB.                                                 
      *                                                                         
           MOVE SPACES TO WS-SYSIPT.                                    
           PERFORM 0250-JOB-PARM-VALID-CHECK THRU 0250-EXIT.            
      *                                                                         
           IF  G6-STATUS = WS-A                                         
               PERFORM 0500-PROCESS-DATA THRU 0500-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-N TO WS-NO-MORE-DATA.                                
           MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN                       
           PERFORM 7610-READ-FCSJC01 THRU 7610-EXIT                     
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:3) = 'CO='              
                  AND WS-INPUT-DATA-BREAKDOWN(7:6) = 'ROUTE='           
                    AND INPUT-ACTIVE)                                   
                 OR (WS-INPUT-DATA-BREAKDOWN(1:3) = 'CO='               
                  AND WS-INPUT-DATA-BREAKDOWN(7:7) = 'LOCOFF='          
                    AND INPUT-ACTIVE)                                   
                 OR  END-OF-SYSIPT                                      
           IF WS-ACTIVE-RETURN-CODE = +100                              
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
C35599 0210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *** VALIDATE JOB-PARM DATA                                    ***         
      *****************************************************************         
      *                                                                         
       0250-JOB-PARM-VALID-CHECK.                                       
      *                                                                         
           IF G6-STATUS NOT EQUAL WS-A                                  
              CONTINUE                                                  
           ELSE                                                         
             MOVE G6-PARM-DATA TO WS-PARM-DATA                          
      *                                                                         
             IF ROUTE-HDR AND BEG-SEQ-HDR AND END-SEQ-HDR               
                    AND COMP-HDR                                        
                IF  WS-PARM-COMP-NO IS NUMERIC                          
                   MOVE WS-PARM-COMP-NO TO AT-COMPANY-NO                
                                           WS-SAVE-CO                   
                                           TAB-COMPANY                  
                                           PRT-COMPANY-RT               
                   MOVE 'Y' TO WS-I-AM-DOING-A-ROUTE                    
                   MOVE 'N' TO WS-I-AM-DOING-A-LOCOFF                   
                ELSE                                                    
                    DISPLAY '*********************************'         
                    DISPLAY '**  PCSCA621 PROCESSING ERROR  **'         
                    DISPLAY '**  COMPANY-NO ON JOB-PARM IS  **'         
                    DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'         
                    DISPLAY '**  PROCESSING TERMINATED....  **'         
                    DISPLAY '*********************************'         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                END-IF                                                  
                IF  WS-PARM-ROUTE-VAL IS NUMERIC                        
                    MOVE WS-PARM-ROUTE-VAL TO TAB-ROUTE                 
                                              WS-BEG-READ-ROUTE         
                                              WS-END-READ-ROUTE         
                                              PRT-NOTICE-ROUTE          
                                              WS-MOVE-ROUTE             
                    MOVE WS-ROUTE-HDR      TO PRT-HDR-MESSAGE           
                    MOVE 'Y'               TO WS-I-AM-DOING-A-ROUTE     
                    MOVE 'N'               TO WS-I-AM-DOING-A-LOCOFF    
                    MOVE WS-BEG-READ-ROUTE TO WS-BEG-READ-ROUTE-C       
                    MOVE WS-END-READ-ROUTE TO WS-END-READ-ROUTE-C       
                    MOVE 000 TO WS-LO-LOCAL-OFFICE                      
                    MOVE 999 TO WS-HI-LOCAL-OFFICE                      
                ELSE                                                    
                    DISPLAY '*********************************'         
                    DISPLAY '**  PCSCA621 PROCESSING ERROR  **'         
                    DISPLAY '**  READ-ROUTE ON JOB-PARM IS  **'         
                    DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'         
                    DISPLAY '**  PROCESSING TERMINATED....  **'         
                    DISPLAY '*********************************'         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                END-IF                                                  
                IF  WS-PARM-BEG-SEQ-VAL > LOW-VALUES AND SPACES         
                    MOVE WS-PARM-BEG-SEQ-VAL TO WS-SEQ-NO               
                    PERFORM 0300-FORMAT-SEQ-NO THRU 0300-EXIT           
                    MOVE WS-SEQ-NO-JUSTIFIED TO WS-BEG-SEQ-N            
                    IF  WS-BEG-SEQ-N IS NUMERIC                         
                        MOVE WS-BEG-SEQ-N TO WS-BEG-SEQ                 
                    ELSE                                                
                        DISPLAY '*********************************'     
                        DISPLAY '**  PCSCA621 PROCESSING ERROR  **'     
                        DISPLAY '**  BEGIN SEQ# ON JOB-PARM IS  **'     
                        DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'     
                        DISPLAY '**  PROCESSING TERMINATED....  **'     
                        DISPLAY '*********************************'     
                        PERFORM 9900-ABEND THRU 9900-EXIT               
                    END-IF                                              
                ELSE                                                    
                    MOVE ZEROS TO WS-BEG-SEQ                            
                END-IF                                                  
                IF  WS-PARM-END-SEQ-VAL > LOW-VALUES AND SPACES         
                    MOVE WS-PARM-END-SEQ-VAL TO WS-SEQ-NO               
                    PERFORM 0300-FORMAT-SEQ-NO THRU 0300-EXIT           
                    MOVE WS-SEQ-NO-JUSTIFIED TO WS-END-SEQ-N            
                    IF  WS-END-SEQ-N IS NUMERIC                         
                        MOVE WS-END-SEQ-N TO WS-END-SEQ                 
                    ELSE                                                
                        DISPLAY '*********************************'     
                        DISPLAY '**  PCSCA621 PROCESSING ERROR  **'     
                        DISPLAY '**  END  SEQ# ON JOB-PARM IS   **'     
                        DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'     
                        DISPLAY '**  PROCESSING TERMINATED....  **'     
                        DISPLAY '*********************************'     
                        PERFORM 9900-ABEND THRU 9900-EXIT               
                    END-IF                                              
                ELSE                                                    
                    MOVE +99999999 TO WS-END-SEQ                        
                END-IF                                                  
             ELSE                                                       
               IF LOC-OFF-HDR                                           
                  IF WS-PARM-COMP-NO IS NUMERIC                         
                    MOVE WS-PARM-COMP-NO TO AT-COMPANY-NO               
                                            WS-SAVE-CO                  
                                            TAB-COMPANY                 
                                            PRT-COMPANY-LO              
                  ELSE                                                  
                    DISPLAY '*********************************'         
                    DISPLAY '**  PCSCA621 PROCESSING ERROR  **'         
                    DISPLAY '**  COMPANY-NO ON JOB-PARM IS  **'         
                    DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'         
                    DISPLAY '**  PROCESSING TERMINATED....  **'         
                    DISPLAY '*********************************'         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                  END-IF                                                
                  IF WS-PARM-LOC-OFF IS NUMERIC                         
                    MOVE WS-PARM-LOC-OFF TO TAB-LOCAL-OFFICE            
                                            WS-LO-LOCAL-OFFICE          
                                            WS-HI-LOCAL-OFFICE          
                                            WS-MOVE-LOCOFF              
                                            PRT-NOTICE-LOCOFF           
                    MOVE WS-LOCOF-HDR    TO PRT-HDR-MESSAGE             
                    MOVE 0000 TO WS-BEG-READ-ROUTE                      
                    MOVE 9999 TO WS-END-READ-ROUTE                      
                    MOVE WS-BEG-READ-ROUTE TO WS-BEG-READ-ROUTE-C       
                    MOVE WS-END-READ-ROUTE TO WS-END-READ-ROUTE-C       
                    MOVE ZEROS     TO WS-BEG-SEQ                        
                    MOVE +99999999 TO WS-END-SEQ                        
                    MOVE 'Y' TO WS-I-AM-DOING-A-LOCOFF                  
                    MOVE 'N' TO WS-I-AM-DOING-A-ROUTE                   
                  ELSE                                                  
                    DISPLAY '*********************************'         
                    DISPLAY '**  PCSCA621 PROCESSING ERROR  **'         
                    DISPLAY '**  LOCAL OFFICE ON JOB-PARM IS**'         
                    DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'         
                    DISPLAY '**  PROCESSING TERMINATED....  **'         
                    DISPLAY '*********************************'         
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                  END-IF                                                
               ELSE                                                     
                   DISPLAY '*****************************************'  
                   DISPLAY '**     PCSCA621 PROCESSING ERROR       **'  
                   DISPLAY '**     RECORDS IN CSS_JOB_PARM ARE NOT **'  
                   DISPLAY '**     IN PROPER FORMAT. PLEASE CHECK. **'  
                   DISPLAY '**     PROCESSING TERMINATED....       **'  
                   DISPLAY '*****************************************'  
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
            END-IF                                                      
           END-IF.                                                      
      *                                                                         
       0250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *** FORMAT SEQ NO TO GO THRU NUMERIC CHECK.                   ***         
      *****************************************************************         
      *                                                                         
       0300-FORMAT-SEQ-NO.                                              
      *                                                                         
           INSPECT WS-SEQ-NO REPLACING ALL LOW-VALUES BY SPACES.        
           MOVE 0 TO WS-INSPECT-CNTR.                                   
           INSPECT WS-SEQ-NO TALLYING WS-INSPECT-CNTR FOR ALL ' '.      
           COMPUTE WS-INSPECT-CNTR =                                    
                   LENGTH OF WS-SEQ-NO - WS-INSPECT-CNTR.               
           MOVE WS-SEQ-NO(1:WS-INSPECT-CNTR) TO WS-SEQ-NO-JUSTIFIED.    
           INSPECT WS-SEQ-NO-JUSTIFIED REPLACING ALL ' ' BY '0'.        
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    PROCESS PCSCA621                                         **         
      *****************************************************************         
      *                                                                         
       0500-PROCESS-DATA.                                               
      *                                                                         
C35599     PERFORM 7050-OPEN-METER-CURSOR THRU 7050-EXIT.               
           MOVE ZEROS TO WS-SAVE-ACCOUNT-NO.                            
           PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT.              
C35599     PERFORM UNTIL WS-NO-MORE-DATA = WS-Y                         
C35599        MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO                 
C35599        PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT            
C35599*                                                                         
C35599        IF WS-CPD99-ACCOUNT-NO = AT-ACCOUNT-NO                    
C35599           PERFORM 1100-FORMAT-NOTICES     THRU 1100-EXIT         
C35599        END-IF                                                    
C35599        PERFORM 7100-FETCH-METER-CURSOR THRU 7100-EXIT            
C35599     END-PERFORM                                                  
           PERFORM 7200-CLOSE-METER-CURSOR THRU 7200-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                   
           PERFORM 3000-DO-TOTALS THRU 3000-EXIT.                       
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
C35599*                                                                         
C35599*===============================================================*         
C35599 0600-FILE-PROCESS.                                               
C35599*===============================================================*         
C35599*                                                                         
C35599     MOVE WS-ACC-FILE-HDR        TO PRT-HDR-MESSAGE               
C35599     PERFORM 7000-READ-INPUT-FILE  THRU 7000-EXIT.                
C35599*                                                                         
C35599     PERFORM 1000-PROCESS-INPUT-FILE   THRU 1000-EXIT             
C35599                 UNTIL END-OF-FILE.                               
C35599*                                                                         
C35599     PERFORM 3100-DO-FILE-TOTALS THRU 3100-EXIT.                  
C35599*                                                                         
C35599 0600-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
C35599*================================================================*        
C35599 1000-PROCESS-INPUT-FILE.                                         
C35599*================================================================*        
C35599*                                                                         
C35599     MOVE E-FCA621-ACCOUNT-NO TO AT-ACCOUNT-NO                    
C35599*                                                                         
C35599     PERFORM 7010-SELECT-ACCOUNT THRU 7010-EXIT                   
C35599*                                                                         
C35599     MOVE AT-PREMISE-NO TO WS-CPD99-PREMISE-NO                    
C35599     PERFORM 6990-FETCH-CUR-ACCOUNT  THRU 6990-EXIT               
C35599*                                                                         
C35599     IF WS-CPD99-ACCOUNT-NO NOT = AT-ACCOUNT-NO                   
C35599        DISPLAY ' '                                               
C35599        DISPLAY '*********************************************'   
C35599        DISPLAY '*** WARNING: INPUT ACCOUNT IS NOT CURRENT ***'   
C35599        DISPLAY '*** INPUT ACCOUNT: ' E-FCA621-ACCOUNT-NO         
C35599        DISPLAY '*** CURRENT ACCOUNT: ' WS-CPD99-ACCOUNT-NO       
C35599        DISPLAY '*** CURRENT ACCOUNT USED TO GENERATE LETTERS'    
C35599        DISPLAY '*********************************************'   
C35599        MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                 
C35599     END-IF.                                                      
C35599     PERFORM 7210-OPEN-FILE-METER-CURSOR  THRU 7210-EXIT.         
C35599     MOVE ZEROS TO WS-SAVE-ACCOUNT-NO.                            
C35599     MOVE WS-N  TO WS-NO-MORE-DATA.                               
C35599     PERFORM 7220-FETCH-FILE-METER-CURSOR THRU 7220-EXIT.         
C35599     PERFORM UNTIL WS-NO-MORE-DATA = WS-Y                         
C35599        PERFORM 1100-FORMAT-NOTICES        THRU 1100-EXIT         
C35599        PERFORM 7220-FETCH-FILE-METER-CURSOR THRU 7220-EXIT       
C35599     END-PERFORM                                                  
C35599     PERFORM 7230-CLOSE-FILE-METER-CURSOR THRU 7230-EXIT.         
C35599     PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                   
C35599     PERFORM 7000-READ-INPUT-FILE  THRU 7000-EXIT.                
C35599*                                                                         
C35599 1000-EXIT.                                                       
C35599     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   FORMAT DATA FOR THE OUTPUT FILE FCSRP000                  **         
      *****************************************************************         
      *                                                                         
       1100-FORMAT-NOTICES.                                             
      *                                                                         
      *                                                                         
T35599     IF MN-CODE-UTIL-TYPE = 'E'                                   
T35599        MOVE MN-CODE-UTIL-TYPE TO EM-CODE-UTIL-TYPE               
T35599        MOVE MN-METER-NO       TO EM-METER-NO                     
T32098        MOVE AT-COMPANY-NO     TO EM-COMPANY-NO                   
T35599        PERFORM 7400-SELECT-ELEC-METER THRU 7400-EXIT             
T35599*                                                                         
T35599        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T35599           IF EM-ELEC-MTR-CLASS-CD =                              
T35599                     ('64' OR '66' OR '73' OR '91' OR '17')       
T35599              MOVE SPACES TO PRINT-LINE                           
T35599              MOVE WS-LIT7 TO PRT-COMMENT                         
T35599              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT           
T35599              GO TO 1100-EXIT                                     
T35599           END-IF                                                 
T35599        END-IF                                                    
T35599     END-IF.                                                      
      *                                                                         
C32098     IF MC-CONSTANT > 1                                           
C32098        MOVE SPACES TO PRINT-LINE                                 
C32098        MOVE WS-LIT6 TO PRT-COMMENT                               
C32098        PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
C32098        GO TO 1100-EXIT                                           
C32098     END-IF.                                                      
      *                                                                         
           IF MN-REMOTE-READ-IND = 'A'                                  
              MOVE SPACES           TO PRINT-LINE                       
              MOVE WS-LIT1          TO PRT-COMMENT                      
              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
              ADD +1                TO TAB-NOTICES-NOT-SENT             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-REMOTE-READ-IND = ('B' OR 'T' OR 'I' OR 'M')           
              MOVE SPACES           TO PRINT-LINE                       
              MOVE WS-LIT2          TO PRT-COMMENT                      
              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
              ADD +1                TO TAB-NOTICES-NOT-SENT             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-CODE-DATA-PRESENT > SPACES                             
                     AND WS-PARM-METER-TYPE = 'S'                       
              MOVE SPACES           TO PRINT-LINE                       
              MOVE WS-LIT3          TO PRT-COMMENT                      
              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
              ADD +1                TO TAB-NOTICES-NOT-SENT             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF UT-CODE-REVENUE-CLASS(2:1) = '0'                          
              MOVE SPACES           TO PRINT-LINE                       
              MOVE WS-LIT4          TO PRT-COMMENT                      
              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
              ADD +1                TO TAB-NOTICES-NOT-SENT             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           IF MN-CODE-DATA-PRESENT = SPACES                             
                     AND WS-PARM-METER-TYPE = 'M'                       
              MOVE SPACES           TO PRINT-LINE                       
              MOVE WS-LIT5          TO PRT-COMMENT                      
              PERFORM 1150-CREATE-REPORT THRU 1150-EXIT                 
              ADD +1                TO TAB-NOTICES-NOT-SENT             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                         
           MOVE MN-CODE-UTIL-TYPE   TO WS-SAVE-UTIL-TYPE.               
           MOVE MN-METER-NO         TO WS-SAVE-METER-NO.                
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE THE PRINT LINE FOR THE REPORT OF ACCOUNTS THAT ARE    *          
      * OBTAINED USING THE ROUTE_METER_CSR, BUT HAVE FAILED SOME     *          
      * TEST AND ARE NOT TO BE INCLUDED ON THE OUTPUT FILE.          *          
      ****************************************************************          
      *                                                                         
       1150-CREATE-REPORT.                                              
      *                                                                         
T37417     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT                
           MOVE AT-ACCOUNT-NO       TO PRT-ACCOUNT.                     
           MOVE MN-METER-NO         TO PRT-METER-NO.                    
           MOVE MN-CODE-UTIL-TYPE   TO PRT-UTIL-TYPE.                   
           MOVE MN-DIGTL-MTR-TYPE   TO PRT-DMT.                         
           MOVE MN-PROGRAM-ID       TO PRT-PGM-ID.                      
           MOVE MN-REMOTE-READ-IND  TO PRT-REMOTE-READ.                 
           MOVE WS-PR-STREET        TO PRT-ADDRESS.                     
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
           MOVE WS-PR-ADDR-CITY-STATE-ZIP  TO PRT-ADDRESS.              
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
           MOVE SPACES TO PRINT-LINE.                                   
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * LOAD DATA FOR THE CSS_CUST_COMM_MF TABLE ENTRY               *          
      ****************************************************************          
      *                                                                         
       1200-LOAD-CUST-COMM.                                             
      *                                                                         
A03866     MOVE 'O'                     TO KO-COMM-DIRECTION.           
A03866     MOVE 'L'                     TO KO-COMM-METHOD.              
P00599     MOVE WS-CURR-COMM-TYP-CD     TO KO-COMM-TYPE-CD.             
P00599     MOVE WS-CURR-COMM-SUBTYP-CD  TO KO-COMM-SUBTYPE-CODE.        
ACT034     MOVE 'N'                     TO KO-RED-FLAG-IND.             
A03866     MOVE SPACES                  TO KO-RED-FLAG-EXPIRE-DT.       
A03866     MOVE -1                      TO WS-RED-FL-NULL-IND.          
A03866     MOVE 'SYSTEM'                TO KO-CONTACT-NAME              
A03866                                     KO-USER-ID-ORIG.             
ACT034     MOVE AT-PREMISE-NO           TO KO-PREMISE-NO.               
ACT034     INITIALIZE    WS-INITIAL-COMMENT-TX.                         
A03866     MOVE WS-INITIAL-COMMENT-TX   TO KO-INITIAL-COMMENT-TX.       
A03866     MOVE 0                       TO KO-CALL-ORIGIN-ID            
A03866                                     KO-NUMBER-TRANSFERS          
A03866                                     KO-HOLD-TIME                 
A03866                                     KO-QUEUE-TIME                
A03866                                     KO-TOTAL-CALL-TIME.          
A03866     MOVE 'N'                     TO KO-SCREEN-POP-IND.           
A03866     MOVE SPACES                  TO KO-RESPONSE-REASON-CD        
A03866     MOVE -1                      TO WS-END-NULL-IND.             
A03866     MOVE SPACES                  TO KO-RESPONSE-TYPE-CD.         
A03866     MOVE SPACES                  TO KO-SOLICITATION-CD.          
A03866     MOVE 'C'                     TO KO-COMM-ASSOC-CD.            
A03866     MOVE 'N'                     TO KO-COMPLAINT-FL.             
A03866     MOVE WS-MESSAGE-NO           TO KO-PROMOTION-ID.             
ACT034     MOVE 'N'                     TO KO-PSC-COMPLIANCE-IND.       
A03866     MOVE SPACES                  TO KO-DISCOVERY-MTHD-CD.        
A03866     MOVE SPACES                  TO KO-PREV-MARKETER-CD.         
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   LOAD DATA FOR THE OUTPUT FILE CREATION                     *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           IF WS-SAVE-ACCOUNT-NO NOT = AT-ACCOUNT-NO                    
      *                                                                         
              IF WS-SAVE-ACCOUNT-NO NOT = ZEROS                         
                 ADD +1 TO TAB-NOTICES-SENT                             
A03866           MOVE WS-ACCOUNT-NO  TO KO-ACCOUNT-NO                   
A03866           MOVE WS-COMPANY-NO  TO KO-COMPANY-NO                   
A03866           MOVE WS-CUSTOMER-NO TO KO-CUSTOMER-NO                  
                                                                        
P00599           IF WS-CURR-COMM-INSERT-FL= 'Y'                         
                    PERFORM 1200-LOAD-CUST-COMM   THRU 1200-EXIT        
                    PERFORM 8400-INSERT-COMM-DATA THRU 8400-EXIT        
P00599           END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF WS-NO-MORE-DATA = 'Y'                                  
                 CONTINUE                                               
              ELSE                                                      
P00599          MOVE WS-MESSAGE-NO          TO 1J-CORRESP-MSG-ID        
P00599                                         1L-CORRESP-MSG-ID        
P00599          MOVE AT-ACCOUNT-NO          TO 1J-ACCOUNT-NO            
P00599          MOVE AT-LOCAL-OFFICE        TO WS-CWS350-LOCAL-OFFICE   
P00599          MOVE AT-COMPANY-NO          TO 1J-CORRESP-COMPANY-NO    
P00599                                         1L-COMPANY-NO            
P00599          MOVE AT-CUSTOMER-NO         TO 1J-CUSTOMER-NO           
P00599          MOVE SPACES                 TO 1J-REG-GROUP-CD          
P00599          MOVE 'A'                    TO 1J-CORRESP-STATUS-CD     
P00599          MOVE ZEROES                 TO 1J-GUARNTR-ACCT-NO       
P00599          MOVE SPACES                 TO 1J-BARCODE-UNIQUE-ID     
P00599          MOVE WS-PGRMNAME            TO 1J-CREATED-BY-PGM-ID     
P00599                                         1J-LAST-UPDATE-PGM-ID    
P00599          MOVE WS-CURRENT-DATE        TO 1J-CORRESP-STMT-DT       
P00599                                         1L-EFF-TO-DT             
P00599          MOVE SPACES                 TO WS-CORRESP-ID-FND        
P00599          PERFORM 5000-CHECK-LOAD-CORRESP-TBL                     
P00599                                      THRU 5000-CPD350-EXIT       
P00599          MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD       
P00599                                                                  
P00599          PERFORM 5425-GET-CORRESP-ID-VAL                         
P00599                                      THRU 5425-CPD350-EXIT       
P00599          MOVE 'ALPHA-VAR-5'          TO 1K-CORRESP-VAR-NM        
P00599          MOVE 'VENDOR-NAME'          TO 1K-CORRESP-VAR-DATA      
P00599          MOVE WS-VENDER-NAME         TO 1K-CORRESP-VAR-CHAR      
P00599          PERFORM 5500-LOAD-CORRESP-VAR    THRU 5500-EXIT         
                IF MN-CODE-UTIL-TYPE = 'E'                              
P00599             MOVE 'ALPHA-VAR-1'            TO 1K-CORRESP-VAR-NM   
P00599             MOVE 'MN-CODE-UTIL-TYPE'      TO 1K-CORRESP-VAR-DATA 
P00599             MOVE MN-CODE-UTIL-TYPE        TO 1K-CORRESP-VAR-CHAR 
P00599             PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT         
P00599             MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM   
P00599             MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA 
P00599             MOVE MN-METER-NO              TO 1K-CORRESP-VAR-CHAR 
P00599             PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT         
P00599          ELSE                                                    
P00599             MOVE 'ALPHA-VAR-3'            TO 1K-CORRESP-VAR-NM   
P00599             MOVE 'MN-CODE-UTIL-TYPE'      TO 1K-CORRESP-VAR-DATA 
P00599             MOVE MN-CODE-UTIL-TYPE        TO 1K-CORRESP-VAR-CHAR 
P00599             PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT         
P00599             MOVE 'ALPHA-VAR-4'            TO 1K-CORRESP-VAR-NM   
P00599             MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA 
P00599             MOVE MN-METER-NO              TO 1K-CORRESP-VAR-CHAR 
P00599             PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT         
                END-IF                                                  
                MOVE AT-ACCOUNT-NO        TO WS-SAVE-ACCOUNT-NO         
                MOVE MN-CODE-UTIL-TYPE    TO WS-SAVE-UTIL-TYPE          
                MOVE MN-METER-NO          TO WS-SAVE-METER-NO           
              END-IF                                                    
           ELSE                                                         
              MOVE AT-ACCOUNT-NO TO WS-SAVE-ACCOUNT-NO                  
              IF MN-CODE-UTIL-TYPE = 'E'                                
P00599           MOVE 'ALPHA-VAR-1'            TO 1K-CORRESP-VAR-NM     
P00599           MOVE 'MN-CODE-UTIL-TYPE'      TO 1K-CORRESP-VAR-DATA   
P00599           MOVE MN-CODE-UTIL-TYPE        TO 1K-CORRESP-VAR-CHAR   
P00599           PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT           
P00599           MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM     
P00599           MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA   
P00599           MOVE MN-METER-NO              TO 1K-CORRESP-VAR-CHAR   
P00599           PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT           
              ELSE                                                      
P00599           MOVE 'ALPHA-VAR-3'            TO 1K-CORRESP-VAR-NM     
P00599           MOVE 'MN-CODE-UTIL-TYPE'      TO 1K-CORRESP-VAR-DATA   
P00599           MOVE MN-CODE-UTIL-TYPE        TO 1K-CORRESP-VAR-CHAR   
P00599           PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT           
P00599           MOVE 'ALPHA-VAR-4'            TO 1K-CORRESP-VAR-NM     
P00599           MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA   
P00599           MOVE MN-METER-NO              TO 1K-CORRESP-VAR-CHAR   
              END-IF                                                    
                                                                        
              IF (WS-SAVE-UTIL-TYPE = MN-CODE-UTIL-TYPE) AND            
                    (WS-SAVE-METER-NO NOT = MN-METER-NO)                
                 IF WS-SAVE-UTIL-TYPE = 'E'                             
P00599              MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM  
P00599              MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA
P00599              MOVE 'MULTIPLE'               TO 1K-CORRESP-VAR-CHAR
P00599              PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT        
                 ELSE                                                   
P00599              MOVE 'ALPHA-VAR-4'            TO 1K-CORRESP-VAR-NM  
P00599              MOVE 'MN-METER-NO'            TO 1K-CORRESP-VAR-DATA
P00599              MOVE 'MULTIPLE'               TO 1K-CORRESP-VAR-CHAR
P00599              PERFORM 5500-LOAD-CORRESP-VAR THRU 5500-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CREATE THE PRINT LINE FOR THE REPORT OF NOTICE TOTALS BY     *          
      * COMPANY AND ROUTE OR LOCAL OFFICE                            *          
      ****************************************************************          
      *                                                                         
       3000-DO-TOTALS.                                                  
      *                                                                         
           IF WS-LINE-COUNT > +58                                       
              PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
           END-IF.                                                      
      *                                                                         
           IF WS-I-AM-DOING-A-ROUTE = 'Y'                               
              MOVE TAB-NOTICES-SENT     TO PRT-YES-NOTICE-RT            
              MOVE TAB-NOTICES-NOT-SENT TO PRT-NO-NOTICE-RT             
              MOVE ZEROS                TO TAB-NOTICES-SENT             
              MOVE ZEROS                TO TAB-NOTICES-NOT-SENT         
              MOVE PRINT-TOTAL-ROUTE-LINE TO PRT32-RECORD               
           END-IF.                                                      
      *                                                                         
           IF WS-I-AM-DOING-A-LOCOFF = 'Y'                              
               MOVE TAB-NOTICES-SENT     TO PRT-YES-NOTICE-LO           
               MOVE TAB-NOTICES-NOT-SENT TO PRT-NO-NOTICE-LO            
               MOVE ZEROS                TO TAB-NOTICES-SENT            
               MOVE ZEROS                TO TAB-NOTICES-NOT-SENT        
               MOVE PRINT-TOTAL-LOCOFF-LINE TO PRT32-RECORD             
           END-IF.                                                      
      *                                                                         
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE SPACES TO PRT32-RECORD.                                 
           MOVE +66 TO WS-LINE-COUNT.                                   
           MOVE +0 TO WS-PAGE-COUNT.                                    
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
C35599*                                                                         
C35599*==============================================================*          
C35599 3100-DO-FILE-TOTALS.                                             
C35599*==============================================================*          
C35599* CREATE THE PRINT LINE FOR THE REPORT OF NOTICE TOTALS AFTER  *          
C35599* PROCESSING ALL FILE RECORDS                                  *          
C35599****************************************************************          
C35599*                                                                         
C35599     IF WS-LINE-COUNT > +58                                       
C35599        PERFORM 8200-PRINT-HEADERS THRU 8200-EXIT                 
C35599     END-IF.                                                      
C35599*                                                                         
C35599     MOVE TAB-NOTICES-SENT         TO PRT-YES-NOTICE-AC           
C35599     MOVE TAB-NOTICES-NOT-SENT     TO PRT-NO-NOTICE-AC            
C35599     MOVE WS-FCA621-REC-CNT        TO PRT-TOTAL-ACCOUNTS          
C35599     MOVE ZEROS                    TO TAB-NOTICES-SENT            
C35599     MOVE ZEROS                    TO TAB-NOTICES-NOT-SENT        
C35599     MOVE PRINT-TOTAL-ACCOUNT-LINE TO PRT32-RECORD                
C35599*                                                                         
C35599     PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
C35599*                                                                         
C35599     MOVE SPACES TO PRT32-RECORD.                                 
C35599     MOVE +66 TO WS-LINE-COUNT.                                   
C35599     MOVE +0 TO WS-PAGE-COUNT.                                    
C35599*                                                                         
C35599 3100-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
P00599*************************************************************             
P00599* 5000-CHECK-LOAD-CORRESP-TBL.                                            
P00599*************************************************************             
P00599      EXEC SQL                                                            
P00599           INCLUDE CPD00350                                               
P00599      END-EXEC.                                                           
P00599                                                                  
P00599******************************************************************        
P00599*5500-LOAD-CORRESP-VAR.                                        *          
P00599******************************************************************        
P00599  5500-LOAD-CORRESP-VAR.                                          
P00599     MOVE WS-CORRESP-ID              TO   1K-CORRESP-ID.          
P00599     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
P00599*                                                                         
P00599     INITIALIZE DCLCSS-CORRESP-VAR.                               
P00599                                                                  
P00599  5500-EXIT.                                                      
            EXIT.                                                       
      ****************************************************************          
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  6990-FETCH-CUR-ACCOUNT                                        *        
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  ERROR ROUTINE FOR CPD00099                                    *        
      ******************************************************************        
      *                                                                         
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
           DISPLAY '*************PCSCA621************'.                 
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS ', WS-CPD99-RETURN-CODE.              
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSCA621************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
C35599*                                                                         
C35599*==============================================================*          
C35599 7000-READ-INPUT-FILE.                                            
C35599*==============================================================*          
C35599*--------------------------------------------------------------*          
C35599*   READ INPUT FILE                                            *          
C35599*--------------------------------------------------------------*          
C35599*                                                                         
C35599     READ FCSCA621-FILE                                           
C35599               AT END MOVE 'Y'  TO WS-EOF-FLAG.                   
C35599*                                                                         
C35599     IF FCA621-SUCCESSFUL                                         
C35599        ADD 1         TO  WS-FCA621-REC-CNT                       
C35599     ELSE                                                         
C35599        IF END-OF-FILE                                            
C35599           CONTINUE                                               
C35599        ELSE                                                      
C35599             DISPLAY '*************************************'      
C35599             DISPLAY '**   PCSCA621 PROCESSING ERROR     **'      
C35599             DISPLAY '**   ABEND IN PARAGRAPH 7000       **'      
C35599             DISPLAY '**  READ STATUS   = ' WS-FCA621-STATUS      
C35599             DISPLAY '*************************************'      
C35599             PERFORM 9900-ABEND THRU 9900-EXIT                    
C35599         END-IF                                                   
C35599     END-IF                                                       
C35599     .                                                            
C35599 7000-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
C35599*===============================================================*         
C35599 7010-SELECT-ACCOUNT.                                             
C35599*===============================================================*         
C35599*                                                                         
C35599     MOVE '7010'                 TO WS-ACTIVE-PARAGRAPH.          
C35599     EXEC SQL                                                     
C35599         SELECT PREMISE_NO                                        
C35599         INTO   :AT-PREMISE-NO                                    
C35599         FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
C35599         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C35599                                                           
A03866                                                      
C35599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*        INTO   :AT-PREMISE-NO                                            
MFA-TR*        FROM   CSS_ACCOUNT                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35599     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C35599         CONTINUE                                                 
C35599     ELSE                                                         
C35599         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C35599         DISPLAY '***************PCSCA621***************'         
C35599         DISPLAY '* ERROR ON 7010-SELECT-ACCOUNT       *'         
C35599         DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
C35599         DISPLAY '* ACCOUNT_NO =' AT-ACCOUNT-NO                   
C35599         DISPLAY '* PROGRAM ABENDING...                *'         
C35599         DISPLAY '***************PCSCA621***************'         
C35599         PERFORM 9900-ABEND            THRU 9900-EXIT             
C35599     END-IF.                                                      
C35599*                                                                         
C35599 7010-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
      *****************************************************************         
      **        THE DRIVING CURSOR IS OPENED.                        **         
      *****************************************************************         
      *                                                                         
C35599 7050-OPEN-METER-CURSOR.                                          
      *                                                                         
C35599     MOVE '7050'                 TO WS-ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
               OPEN ROUTE_METER_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA621 PROCESSING ERROR      **'       
C35599         DISPLAY '**      ABEND IN PARAGRAPH 7050       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
C35599 7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  **         
      *****************************************************************         
      *                                                                         
       7100-FETCH-METER-CURSOR.                                         
      *                                                                         
           MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
             FETCH  ROUTE_METER_CSR                                     
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:UT-READ-ROUTE                                      
                   ,:UT-READ-CYCLE                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:MN-REGISTER-RD-SEQ                                 
                   ,:MN-METER-NO                                        
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-IC-NO                                           
                   ,:AT-PREMISE-NO                                      
                   ,:MN-DIGTL-MTR-TYPE                                  
                   ,:MN-PROGRAM-ID                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:MN-REMOTE-READ-IND                                 
                   ,:MN-CODE-DATA-PRESENT                               
                   ,:WS-PHONE-NO                                        
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:UT-CODE-REVENUE-CLASS                              
                   ,:AT-CODE-ACCT-STAT                                  
C32098             ,:MC-CONSTANT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE 9999999999999 TO AT-ACCOUNT-NO                  
                   MOVE WS-Y TO WS-NO-MORE-DATA                         
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA621 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7100       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00599******************************************************************        
P00599* 7150-SELECT-DELINQ-VALUE                                       *        
P00599* SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *        
P00599******************************************************************        
P00599 7150-SELECT-DELINQ-VALUE.                                        
P00599*                                                                         
P00599     EXEC SQL                                                     
P00599        SELECT DELINQ_VALUE                                       
P00599          INTO :C8-DELINQ-VALUE                                   
P00599          FROM CSS_DELINQUENCY                                    
P00599         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P00599           AND COMPANY_NO = :C8-COMPANY-NO                        
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSCA621 ABORT **************'        
P00599        DISPLAY '* 7150-SELECT-DELINQ-VALUE             *'        
P00599        DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
P00599        DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                  *'        
P00599        DISPLAY '********** PCSCA621 ABORT **************'        
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7150-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
      *****************************************************************         
      **        THE DRIVING CURSOR IS CLOSED.                        **         
      *****************************************************************         
      *                                                                         
       7200-CLOSE-METER-CURSOR.                                         
      *                                                                         
           MOVE '7200'                 TO WS-ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
               CLOSE  ROUTE_METER_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA621 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C35599*                                                                         
C35599*===============================================================*         
C35599 7210-OPEN-FILE-METER-CURSOR.                                     
C35599*===============================================================*         
C35599*---------------------------------------------------------------*         
C35599**        THE DRIVING CURSOR IS OPENED USING FILE INPUT        **         
C35599*---------------------------------------------------------------*         
C35599*                                                                         
C35599     MOVE '7210'                 TO WS-ACTIVE-PARAGRAPH.          
C35599*                                                                         
C35599     EXEC SQL                                                     
C35599         OPEN FILE_METER_CSR                                      
C35599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35599*                                                                         
C35599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35599*                                                                         
C35599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35599         NEXT SENTENCE                                            
C35599     ELSE                                                         
C35599         DISPLAY '****************************************'       
C35599         DISPLAY '**     PCSCA621 PROCESSING ERROR      **'       
C35599         DISPLAY '**      ABEND IN PARAGRAPH 7210       **'       
C35599         DISPLAY '** ACCOUNT-NO = ' AT-ACCOUNT-NO                 
C35599         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C35599         DISPLAY '****************************************'       
C35599         PERFORM 9900-ABEND THRU 9900-EXIT                        
C35599     END-IF.                                                      
C35599*                                                                         
C35599 7210-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
C35599*===============================================================*         
C35599 7220-FETCH-FILE-METER-CURSOR.                                    
C35599*===============================================================*         
C35599*                                                                         
C35599     MOVE '7220'                 TO WS-ACTIVE-PARAGRAPH.          
C35599     EXEC SQL                                                     
C35599       FETCH  FILE_METER_CSR                                      
C35599        INTO  :AT-ACCOUNT-NO                                      
C35599             ,:AT-CUSTOMER-NO                                     
C35599             ,:UT-READ-ROUTE                                      
C35599             ,:UT-READ-CYCLE                                      
C35599             ,:AT-LOCAL-OFFICE                                    
C35599             ,:MN-REGISTER-RD-SEQ                                 
C35599             ,:MN-METER-NO                                        
C35599             ,:MN-CODE-UTIL-TYPE                                  
C35599             ,:MN-MTR-REF-NO                                      
C35599             ,:MN-IC-NO                                           
C35599             ,:AT-PREMISE-NO                                      
C35599             ,:MN-DIGTL-MTR-TYPE                                  
C35599             ,:MN-PROGRAM-ID                                      
C35599             ,:AT-ADDRESS-ID                                      
C35599             ,:MN-REMOTE-READ-IND                                 
C35599             ,:MN-CODE-DATA-PRESENT                               
C35599             ,:WS-PHONE-NO                                        
C35599             ,:AT-ADDRESS-FORMAT                                  
C35599             ,:UT-CODE-REVENUE-CLASS                              
C35599             ,:AT-CODE-ACCT-STAT                                  
T32098             ,:MC-CONSTANT                                        
C35599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35599*                                                                         
C35599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35599*                                                                         
C35599     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C35599         NEXT SENTENCE                                            
C35599     ELSE                                                         
C35599         IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C35599             MOVE 9999999999999 TO AT-ACCOUNT-NO                  
C35599             MOVE WS-Y TO WS-NO-MORE-DATA                         
C35599         ELSE                                                     
C35599             DISPLAY '****************************************'   
C35599             DISPLAY '**     PCSCA621 PROCESSING ERROR      **'   
C35599             DISPLAY '**      ABEND IN PARAGRAPH 7220       **'   
C35599             DISPLAY '** ACCOUNT-NO = ' AT-ACCOUNT-NO             
C35599             DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
C35599             DISPLAY '****************************************'   
C35599             PERFORM 9900-ABEND THRU 9900-EXIT                    
C35599         END-IF                                                   
C35599     END-IF.                                                      
C35599*                                                                         
C35599 7220-EXIT.                                                       
C35599     EXIT.                                                        
C35599*                                                                         
C35599*===============================================================*         
C35599 7230-CLOSE-FILE-METER-CURSOR.                                    
C35599*===============================================================*         
C35599*                                                                         
C35599     MOVE '7230'                 TO WS-ACTIVE-PARAGRAPH.          
C35599     EXEC SQL                                                     
C35599         CLOSE  FILE_METER_CSR                                    
C35599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35599*                                                                         
C35599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35599*                                                                         
C35599     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C35599         NEXT SENTENCE                                            
C35599     ELSE                                                         
C35599         DISPLAY '****************************************'       
C35599         DISPLAY '**     PCSCA621 PROCESSING ERROR      **'       
C35599         DISPLAY '**      ABEND IN PARAGRAPH 7230       **'       
C35599         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C35599         DISPLAY '****************************************'       
C35599         PERFORM 9900-ABEND THRU 9900-EXIT                        
C35599     END-IF.                                                      
C35599*                                                                         
C35599 7230-EXIT.                                                       
C35599     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7300-SELECT-COMP-NAME                                     **          
      ****************************************************************          
      *                                                                         
       7300-SELECT-COMP-NAME.                                           
      *                                                                         
           MOVE '7300'                 TO WS-ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
               SELECT COMPANY_NAME                                      
               INTO   :C7-COMPANY-NAME                                  
               FROM   CSS_COMPANY WITH(READUNCOMMITTED)                         
               WHERE COMPANY_NO = :C7-COMPANY-NO                        
C33884                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*        INTO   :C7-COMPANY-NAME                                          
MFA-TR*        FROM   CSS_COMPANY                                               
MFA-TR*        WHERE COMPANY_NO = :C7-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE        TO WS-DISPLAY-RC                     
               DISPLAY '***************PCSCA621***************'         
               DISPLAY '* ERROR ON 7300-SELECT-COMP-NAME     *'         
               DISPLAY '* SQL CODE IS ', WS-DISPLAY-RC                  
               DISPLAY '* PROGRAM ABENDING...                *'         
               DISPLAY '***************PCSCA621***************'         
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
T35599*                                                                         
T35599*****************************************************************         
T35599**        RETRIEVE ELECTRIC METER CLASS CODE.                  **         
T35599*****************************************************************         
T35599*                                                                         
T35599 7400-SELECT-ELEC-METER.                                          
T35599*                                                                         
T35599     EXEC SQL                                                     
T35599       SELECT EM.ELEC_MTR_CLASS_CD                                
T35599         INTO :EM-ELEC-MTR-CLASS-CD                               
T35599         FROM  CSS_ELEC_METER EM WITH(READUNCOMMITTED)                    
T35599        WHERE EM.CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE          
T35599          AND EM.METER_NO           = :EM-METER-NO                
T35599          AND EM.COMPANY_NO         = :EM-COMPANY-NO              
T35599                                                           
A03866                                                      
T35599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT EM.ELEC_MTR_CLASS_CD                                        
MFA-TR*        INTO :EM-ELEC-MTR-CLASS-CD                                       
MFA-TR*        FROM  CSS_ELEC_METER EM                                          
MFA-TR*       WHERE EM.CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE                  
MFA-TR*         AND EM.METER_NO           = :EM-METER-NO                        
MFA-TR*         AND EM.COMPANY_NO         = :EM-COMPANY-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35599*                                                                         
T35599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35599*                                                                         
T35599     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
T35599         NEXT SENTENCE                                            
T35599      ELSE                                                        
T35599         DISPLAY '****************************************'       
T35599         DISPLAY '**      7400-SELECT-ELEC-METER.       **'       
T35599         DISPLAY '**     PCSCA621 PROCESSING ERROR      **'       
T35599         DISPLAY '**      ABEND IN PARAGRAPH 7400       **'       
T35599         DISPLAY '** COMPANY-NO     = ' EM-COMPANY-NO             
T35599         DISPLAY '** CODE-UTIL-TYPE = ' EM-CODE-UTIL-TYPE         
T35599         DISPLAY '** METER-NO       = ' EM-METER-NO               
T35599         DISPLAY '**    SQLCODE = ' WS-ACTIVE-RETURN-CODE         
T35599         DISPLAY '****************************************'       
T35599         PERFORM 9900-ABEND THRU 9900-EXIT                        
T35599     END-IF.                                                      
T35599*                                                                         
T35599 7400-EXIT.                                                       
T35599     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING        **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *    GET CURRENT DATE                                        *            
      **************************************************************            
      *                                                                         
       7500-GET-CURRENT-TIMESTAMP.                                      
           MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
C33884*                                                                         
C33884*  REPLACED MODEL SQL WITH SET STMT FOR BETTER PERFORMANCE                
C33884*                                                                         
C33884     EXEC SQL                                                     
C33884        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
C33884     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33884*                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '**********************************'              
              DISPLAY '**  7500-GET-CURRENT-TIMESTAMP  **'              
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**********************************'              
              PERFORM 9900-ABEND THRU  9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **       CHECK FOR LINE COUNT FOR REPORT HEADERS                **        
      ******************************************************************        
      *                                                                         
       8100-PRINT-REPORT.                                               
      *                                                                         
           PERFORM 8300-PRINT-REPORT THRU 8300-EXIT.                    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **       WRITES THE HEADER TO THE REPORT FILE                   **        
      ******************************************************************        
      *                                                                         
       8200-PRINT-HEADERS.                                              
      *                                                                         
           IF WS-PARM-COMP-NO = '01'                                    
             IF WS-SCEG = 'N'                                           
                MOVE 0 TO WS-PAGE-COUNT                                 
             END-IF                                                     
             MOVE 'Y' TO WS-SCEG                                        
           END-IF.                                                      
      *                                                                         
           IF WS-PARM-COMP-NO = '26'                                    
             IF WS-PSNC = 'N'                                           
                MOVE 0 TO WS-PAGE-COUNT                                 
             END-IF                                                     
             MOVE 'Y' TO WS-PSNC                                        
           END-IF.                                                      
      *                                                                         
       8200-NO-DATA-HEADERS.                                            
      *                                                                         
           MOVE WS-SAVE-CO             TO  C7-COMPANY-NO.               
C35599     IF WS-DBASE-PROCESS                                          
C35599        PERFORM 7300-SELECT-COMP-NAME THRU 7300-EXIT              
C35599     END-IF                                                       
           MOVE C7-COMPANY-NAME        TO WS-COMPANY-NAME.              
      *                                                                         
           ADD 1 TO WS-PAGE-COUNT.                                      
           MOVE WS-PAGE-COUNT TO HDR-PAGE.                              
      *                                                                         
           MOVE HEADER1 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE HEADER2 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE SPACES TO PRT32-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE HEADER3 TO PRT32-RECORD.                                
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE SPACES TO PRT32-RECORD.                                 
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
      *                                                                         
           MOVE +5 TO WS-LINE-COUNT.                                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **       WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **        
      ******************************************************************        
      *                                                                         
       8300-PRINT-REPORT.                                               
      *                                                                         
           MOVE PRINT-LINE TO PRT32-RECORD.                             
           PERFORM 8900-WRITE-REPORT THRU 8900-EXIT.                    
           ADD +1 TO WS-LINE-COUNT.                                     
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
A03866*   INSERT A ROW IN CSS_COMM_DATA                             *           
      ***************************************************************           
      *                                                                         
A03866 8400-INSERT-COMM-DATA.                                           
      *                                                                         
           MOVE '8400'                 TO WS-ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
A03866          INSERT INTO CSS_COMM_DATA                               
A03866                  (COMMUNICATION_ID,                              
A03866                   ACCOUNT_NO,                                    
A03866                   CUSTOMER_NO,                                   
A03866                   PREMISE_NO,                                    
A03866                   COMPANY_NO,                                    
A03866                   RED_FLAG_IND,                                  
A03866                   RED_FLAG_EXPIRE_DT,                            
A03866                   COMM_METHOD,                                   
A03866                   COMM_DIRECTION,                                
A03866                   COMM_TYPE_CD,                                  
A03866                   COMM_SUBTYPE_CODE,                             
A03866                   USER_ID_ORIG,                                  
A03866                   CONTACT_NAME,                                  
A03866                   PROMOTION_ID,                                  
A03866                   PSC_COMPLIANCE_IND,                            
A03866                   CALL_ORIGIN_ID,                                
A03866                   CALL_END_TIME,                                 
A03866                   NUMBER_TRANSFERS,                              
A03866                   HOLD_TIME,                                     
A03866                   QUEUE_TIME,                                    
A03866                   SCREEN_POP_IND,                                
A03866                   TOTAL_CALL_TIME,                               
A03866                   INITIAL_COMMENT_TX,                            
A03866                   RESPONSE_REASON_CD,                            
A03866                   RESPONSE_TYPE_CD,                              
A03866                   SOLICITATION_CD,                               
A03866                   COMM_ASSOC_CD,                                 
A03866                   COMPLAINT_FL,                                  
A03866                   DISCOVERY_MTHD_CD,                             
A03866                   PREV_MARKETER_CD)                              
A03866          VALUES   (CIS.CURRENT$TIMESTAMP(),                            
A03866                   :KO-ACCOUNT-NO,                                
A03866                   :KO-CUSTOMER-NO,                               
A03866                   :KO-PREMISE-NO,                                
A03866                   :KO-COMPANY-NO,                                
A03866                   :KO-RED-FLAG-IND,                              
A03866                   CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
A03866                   :KO-COMM-METHOD,                               
A03866                   :KO-COMM-DIRECTION,                            
A03866                   :KO-COMM-TYPE-CD,                              
A03866                   :KO-COMM-SUBTYPE-CODE,                         
A03866                   :KO-USER-ID-ORIG,                              
A03866                   :KO-CONTACT-NAME,                              
A03866                   :KO-PROMOTION-ID,                              
A03866                   :KO-PSC-COMPLIANCE-IND,                        
A03866                   :KO-CALL-ORIGIN-ID,                            
A03866                   CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
A03866                   :KO-NUMBER-TRANSFERS,                          
A03866                   :KO-HOLD-TIME,                                 
A03866                   :KO-QUEUE-TIME,                                
A03866                   :KO-SCREEN-POP-IND,                            
A03866                   :KO-TOTAL-CALL-TIME,                           
A03866                   :KO-INITIAL-COMMENT-TX,                        
A03866                   :KO-RESPONSE-REASON-CD,                        
A03866                   :KO-RESPONSE-TYPE-CD,                          
A03866                   :KO-SOLICITATION-CD,                           
A03866                   :KO-COMM-ASSOC-CD,                             
A03866                   :KO-COMPLAINT-FL,                              
A03866                   :KO-DISCOVERY-MTHD-CD,                         
A03866                   :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
A03866         DISPLAY '* 8400-INSERT-COMM-DATA'                        
               DISPLAY '* CUSTOMER_NO = ' AT-CUSTOMER-NO                
               DISPLAY '* ACCOUNT_NO  = ' AT-ACCOUNT-NO                 
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **       WRITES THE REPORT                                      **        
      ******************************************************************        
      *                                                                         
       8900-WRITE-REPORT.                                               
      *                                                                         
           WRITE PRT32-RECORD.                                          
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    NORMAL TERMINATION OF JOB                                **         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
C35599*                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * THIS INCLUDES 9700-PROCESS-ABEND                           *            
      **************************************************************            
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
