       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA614.                                        
       DATE-WRITTEN.   MARCH 2016.                                      
       DATE-COMPILED.                                                   
      ****************************************************************          
      **             SOUTH CAROLINA ELECTRICITY AND GAS             **          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********                      DB2                       ********          
      ****************************************************************          
      **               P R O G R A M  S U M M A R Y                 **          
      **                                                            **          
      ** COBOL REWRITE OF GMC514                                    **          
      ** THIS PROGRAM OBTAINS THE INPUT TEST YEAR FROM CSS_JOB_PARM **          
      ** TABLE.  IF NONE IS PRESENT, THEN THE CURRENT YEAR IS USED. **          
      ** PROCESSES THE METER TEST GROUP TABLE AND CREATES NEW TEST  **          
      ** HISTORY RECORDS FOR THE TEST YEAR FOR ELIGIBLE TEST GROUPS.**          
      **                                                            **          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **  DATE        INITIALS    REASON                            **          
      ** ___________  ________    _______________________________   **          
      ** 20 MAR 2016  RF10596     NEW PROGRAM - REWRITE OF GMC514   **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                   ---- REPORT GENERATOR FOR PCSCA614 REPORTS ----      
                   ----- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA614'.
MSQ017     COPY MFASQLM.
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRTST                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00011.                                                           
      *                                                                         
      ****************************************************************          
      *   FCA00 MISC                                                 *          
      ****************************************************************          
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-PARM1                PIC X(4)     VALUE 'PARM'.       
           05  WS-REC-COUNT            PIC 9(9)     VALUE ZERO COMP-3.  
           05  WS-TEST-YEAR            PIC S9(4)    VALUE ZERO COMP.    
           05  WS-SELECT-YEAR          PIC S9(4)    VALUE ZERO COMP.    
           05  WS-CURR-DATE            PIC X(10)    VALUE SPACES.       
           05  WS-HONK-YEAR            PIC S9(4)    VALUE ZERO COMP.    
           05  WS-SAVE-YEAR            PIC 9(4)     VALUE ZEROS.        
           05  WS-STATUS-DESC          PIC X(15)    VALUE SPACES.       
           05  PROGRAM-NAME            PIC X(8)     VALUE 'PCSCA614'.   
           05  RS-RETURN-CODE          PIC S9(9)    VALUE +000 COMP.    
           05  RS-RETURN-CODE-DISP     PIC S9(9)    VALUE +000 COMP.    
           05  WS-SYSIN-COMP-NO        PIC XX       VALUE SPACES.       
           05  WS-COMP-NO              PIC XX       VALUE '01'.         
      *                                                                         
       01  WS-INPUT-PARM-DATA.                                          
           05  WS-PARM-YEAR            PIC 9(4).                        
           05  WS-PARM-FILLER          PIC X(76).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(8)     VALUE 'PCSCA614'.   
           05  WS-N                    PIC X        VALUE 'N'.          
           05  WS-Y                    PIC X        VALUE 'Y'.          
           05  WS-G                    PIC X        VALUE 'G'.          
           05  WS-R                    PIC X        VALUE 'R'.          
           05  WS-10                   PIC S9(3)V   VALUE 10 COMP-3.    
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CUR-YEAR             PIC X(04).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-CUR-MONTH            PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '-'.          
           05  WS-CUR-DAY              PIC X(02).                       
      *                                                                         
      ****************************************************************          
      * CURSOR FOR RECORDS FOR INSERTION                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE COPY_TEST_REC CURSOR WITH HOLD FOR               
                SELECT TEST_SCHED_CD                                    
                      ,MTR_TEST_GRP_CD                                  
                      ,MTR_TEST_GRP_TX                                  
                      ,SAMPL_CORRECTV_PCT                               
                      ,SAMPL_OVERAGE_PCT                                
                  FROM CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                  
                 WHERE CODE_UTIL_TYPE = :WS-G                           
                   AND TEST_YEAR      = :WS-TEST-YEAR                   
                   AND TEST_SCHED_CD  = :WS-R                           
                   AND COMPANY_NO     = :WS-COMP-NO                     
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE COPY_TEST_REC CURSOR WITH HOLD FOR                       
MFA-TR*         SELECT TEST_SCHED_CD                                            
MFA-TR*               ,MTR_TEST_GRP_CD                                          
MFA-TR*               ,MTR_TEST_GRP_TX                                          
MFA-TR*               ,SAMPL_CORRECTV_PCT                                       
MFA-TR*               ,SAMPL_OVERAGE_PCT                                        
MFA-TR*           FROM CSS_MTR_TEST_HIST                                        
MFA-TR*          WHERE CODE_UTIL_TYPE = :WS-G                                   
MFA-TR*            AND TEST_YEAR      = :WS-TEST-YEAR                           
MFA-TR*            AND TEST_SCHED_CD  = :WS-R                                   
MFA-TR*            AND COMPANY_NO     = :WS-COMP-NO                             
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7160                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURSOR FOR TEST GROUP RECORDS                                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
               DECLARE TEST_GROUP CURSOR WITH HOLD FOR                  
                SELECT GR.MTR_TEST_GRP_CD                               
                      ,GR.MTR_TEST_GRP_TX                               
                  FROM CSS_MTR_TEST_GROUP GR WITH(READUNCOMMITTED)              
                      ,CSS_GAS_TST_GROUP  GT WITH(READUNCOMMITTED)              
                 WHERE GR.CODE_UTIL_TYPE    = :WS-G                     
                   AND   GR.CODE_UTIL_TYPE  = GT.CODE_UTIL_TYPE         
                   AND   GR.COMPANY_NO      = :WS-COMP-NO               
                   AND   GR.COMPANY_NO      = GT.COMPANY_NO             
                   AND   GR.MTR_TEST_GRP_CD = GT.MTR_TEST_GRP_CD        
                   AND   YEAR(GT.BEGIN_PURCHASE_DT) <=                  
                           (:WS-SELECT-YEAR - GT.TEST_FREQ_YEARS_QT)    
                   AND   GR.MTR_TEST_GRP_CD NOT IN                      
                          (SELECT  GP.MTR_TEST_GRP_CD                   
                        FROM  CSS_MTR_TEST_GROUP GP
                           WITH(READUNCOMMITTED)                     
                             ,CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)        
                       WHERE  GP.CODE_UTIL_TYPE  = :WS-G                
                         AND  GP.MTR_TEST_GRP_CD = MQ.MTR_TEST_GRP_CD   
                         AND  GP.COMPANY_NO = :WS-COMP-NO               
                         AND  GP.COMPANY_NO = MQ.COMPANY_NO             
                         AND  MQ.TEST_YEAR  = :MQ-TEST-YEAR)            
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TEST_GROUP CURSOR WITH HOLD FOR                          
MFA-TR*         SELECT GR.MTR_TEST_GRP_CD                                       
MFA-TR*               ,GR.MTR_TEST_GRP_TX                                       
MFA-TR*           FROM CSS_MTR_TEST_GROUP GR                                    
MFA-TR*               ,CSS_GAS_TST_GROUP  GT                                    
MFA-TR*          WHERE GR.CODE_UTIL_TYPE    = :WS-G                             
MFA-TR*            AND   GR.CODE_UTIL_TYPE  = GT.CODE_UTIL_TYPE                 
MFA-TR*            AND   GR.COMPANY_NO      = :WS-COMP-NO                       
MFA-TR*            AND   GR.COMPANY_NO      = GT.COMPANY_NO                     
MFA-TR*            AND   GR.MTR_TEST_GRP_CD = GT.MTR_TEST_GRP_CD                
MFA-TR*            AND   YEAR(GT.BEGIN_PURCHASE_DT) <=                          
MFA-TR*                    (:WS-SELECT-YEAR - GT.TEST_FREQ_YEARS_QT)            
MFA-TR*            AND   GR.MTR_TEST_GRP_CD NOT IN                              
MFA-TR*                   (SELECT  GP.MTR_TEST_GRP_CD                           
MFA-TR*                 FROM  CSS_MTR_TEST_GROUP GP                             
MFA-TR*                      ,CSS_MTR_TEST_HIST MQ                              
MFA-TR*                WHERE  GP.CODE_UTIL_TYPE  = :WS-G                        
MFA-TR*                  AND  GP.MTR_TEST_GRP_CD = MQ.MTR_TEST_GRP_CD           
MFA-TR*                  AND  GP.COMPANY_NO = :WS-COMP-NO                       
MFA-TR*                  AND  GP.COMPANY_NO = MQ.COMPANY_NO                     
MFA-TR*                  AND  MQ.TEST_YEAR  = :MQ-TEST-YEAR)                    
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7260                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 7150-OPEN-MTR-TEST-HIST  THRU 7150-EXIT.             
           PERFORM 7160-FETCH-MTR-TEST-HIST THRU 7160-EXIT.             
           PERFORM 0200-PROCESS-TEST-HIST   THRU 0200-EXIT.             
           PERFORM 7170-CLOSE-MTR-TEST-HIST THRU 7170-EXIT.             
      *                                                                         
           DISPLAY 'TOTAL TEST RECORDS CREATED = ' WS-REC-COUNT.        
      *                                                                         
           MOVE ZEROS TO WS-REC-COUNT.                                  
           MOVE WS-R  TO MQ-TEST-SCHED-CD.                              
           MOVE WS-10 TO MQ-SAMPL-OVERAGE-PCT.                          
           MOVE ZEROS TO MQ-SAMPL-CORRECTV-PCT.                         
           PERFORM 7250-OPEN-TEST-GROUP    THRU 7250-EXIT.              
           PERFORM 7260-FETCH-TEST-GROUP   THRU 7260-EXIT.              
           PERFORM 0300-PROCESS-TEST-GROUP THRU 0300-EXIT.              
           PERFORM 7270-CLOSE-TEST-GROUP   THRU 7270-EXIT.              
      *                                                                         
           DISPLAY 'TOTAL TEST GROUP RECORDS CREATED = ' WS-REC-COUNT.  
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   GET CURRENT DATE, JOB PARM DATE AND COMPANY NUMBER       **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE THRU 7000-EXIT.                
      *                                                                         
           ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
           IF WS-SYSIN-COMP-NO <= SPACES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-SYSIN-COMP-NO TO WS-COMP-NO                       
           END-IF.                                                      
      *                                                                         
           DISPLAY 'USING COMPANY NUMBER = ' WS-COMP-NO.                
      *                                                                         
           MOVE PROGRAM-NAME                   TO WS-PROGRAM.           
           MOVE WS-COMP-NO                     TO G6-COMPANY-NO.        
           MOVE WS-PARM1                       TO WS-COMMAND.           
      *                                                                         
           PERFORM 7600-START-FCSJC01 THRU 7600-EXIT.                   
           PERFORM 7610-READ-FCSJC01  THRU 7610-EXIT                    
               UNTIL INPUT-ACTIVE OR END-OF-SYSIPT.                     
      *                                                                         
           IF END-OF-SYSIPT                                             
              MOVE WS-CUR-YEAR TO WS-SELECT-YEAR                        
                                  WS-SAVE-YEAR                          
              COMPUTE WS-TEST-YEAR = (WS-SAVE-YEAR - 1)                 
           ELSE                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
              MOVE G6-PARM-DATA TO WS-INPUT-PARM-DATA                   
              MOVE WS-PARM-YEAR TO WS-SAVE-YEAR                         
                                   WS-SELECT-YEAR                       
              COMPUTE WS-TEST-YEAR = (WS-SAVE-YEAR - 1)                 
           END-IF.                                                      
      *                                                                         
           MOVE WS-G           TO MQ-CODE-UTIL-TYPE.                    
           MOVE WS-SELECT-YEAR TO MQ-TEST-YEAR.                         
           MOVE WS-A           TO MQ-STATUS-CD.                         
           MOVE ZEROS          TO MQ-SELECTED-QT                        
                                  MQ-INSTALLED-QT                       
                                  MQ-TESTED-QT                          
                                  MQ-SAMPLE-MIN-QT                      
                                  MQ-SAMPL-ADDITIONL-QT.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  PROCESS MTR_TEST_HIST CURSOR REOCRDS                      **          
      ****************************************************************          
      *                                                                         
       0200-PROCESS-TEST-HIST.                                          
      *                                                                         
           MOVE '0200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0500-CREATE-NEW-TEST THRU 0500-EXIT               
              PERFORM 7160-FETCH-MTR-TEST-HIST THRU 7160-EXIT           
           END-PERFORM.                                                 
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  PROCESS TETS_GROUP CURSOR REOCRDS                         **          
      ****************************************************************          
      *                                                                         
       0300-PROCESS-TEST-GROUP.                                         
      *                                                                         
           MOVE '0300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 0500-CREATE-NEW-TEST THRU 0500-EXIT               
              PERFORM 7260-FETCH-TEST-GROUP THRU 7260-EXIT              
           END-PERFORM.                                                 
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  CREATE NEW TEST RECORDS                                   **          
      **  IF ALEADY EXIST IN CSS_MTR_TEST_HIST GET OUT.             **          
      **  IF NOT, INSERT A NEW ROW.                                 **          
      ****************************************************************          
      *                                                                         
       0500-CREATE-NEW-TEST.                                            
      *                                                                         
           MOVE '0500' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TEST_YEAR                                          
                INTO :WS-HONK-YEAR                                      
                FROM CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                    
               WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE              
                 AND  TEST_YEAR       = :MQ-TEST-YEAR                   
                 AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD               
                 AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD             
                 AND  MTR_TEST_GRP_TX = :MQ-MTR-TEST-GRP-TX             
                 AND  COMPANY_NO      = :WS-COMP-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TEST_YEAR                                                  
MFA-TR*         INTO :WS-HONK-YEAR                                              
MFA-TR*         FROM CSS_MTR_TEST_HIST                                          
MFA-TR*        WHERE  CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE                      
MFA-TR*          AND  TEST_YEAR       = :MQ-TEST-YEAR                           
MFA-TR*          AND  TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                       
MFA-TR*          AND  MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                     
MFA-TR*          AND  MTR_TEST_GRP_TX = :MQ-MTR-TEST-GRP-TX                     
MFA-TR*          AND  COMPANY_NO      = :WS-COMP-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY '*****************************************'       
              DISPLAY '**  RECORD ALREADY EXISTS              **'       
              DISPLAY '** MQ-CODE-UTIL-TYPE = ' MQ-CODE-UTIL-TYPE       
              DISPLAY '** MQ-TEST-YEAR      = ' MQ-TEST-YEAR            
              DISPLAY '** MQ-TEST-SCHED-CD  = ' MQ-TEST-SCHED-CD        
              DISPLAY '** MQ-MTR-TEST-GRP-CD= ' MQ-MTR-TEST-GRP-CD      
              DISPLAY '** MQ-MTR-TEST-GRP-TX= ' MQ-MTR-TEST-GRP-TX      
              DISPLAY '*****************************************'       
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 7675-INSERT-MTR-TEST-HIST THRU 7675-EXIT       
              ELSE                                                      
                 DISPLAY '*********** PCSCA614 ABEND  *************'    
                 DISPLAY '**  ERROR IN 0500-CREATE-NEW-TEST      **'    
                 DISPLAY '** MQ-CODE-UTIL-TYPE = ' MQ-CODE-UTIL-TYPE    
                 DISPLAY '** MQ-TEST-YEAR      = ' MQ-TEST-YEAR         
                 DISPLAY '** MQ-TEST-SCHED-CD  = ' MQ-TEST-SCHED-CD     
                 DISPLAY '** MQ-MTR-TEST-GRP-CD= ' MQ-MTR-TEST-GRP-CD   
                 DISPLAY '** MQ-MTR-TEST-GRP-TX= ' MQ-MTR-TEST-GRP-TX   
                 DISPLAY '** RETURN CODE = ' SQLCODE                    
                 DISPLAY '** PROCESSING TERMINATED               **'    
                 DISPLAY '*********** PCSCA614 ABEND  *************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE                                          *          
      * COPY BOOK TO GET JOB PARM DATE                               *          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      * 7000-START-FJC01 ..                                          *          
      * SQL STATEMENTS TO RETRIEVE DATE FROM JOB PARM TABLE          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CURRENT DATE                                                 *          
      ****************************************************************          
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-DATE  = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-CURR-DATE TO WS-CURRENT-DATE                      
              DISPLAY 'CURRENT DATE = ' WS-CURRENT-DATE                 
           ELSE                                                         
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              DISPLAY '**  7000-GET-CURRENT-DATE              **'       
              DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS COPY_TEST_REC CURSOR                                   *          
      ****************************************************************          
      *                                                                         
       7150-OPEN-MTR-TEST-HIST.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN COPY_TEST_REC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*********** PCSCA614 ABEND  *************'      
               DISPLAY '**  ERROR IN 7150-OPEN-MTR-TEST-HIST   **'      
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSCA614 ABEND  *************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCH COPY_TEST_REC CURSOR                                   *          
      ****************************************************************          
      *                                                                         
       7160-FETCH-MTR-TEST-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH COPY_TEST_REC                                      
                INTO :MQ-TEST-SCHED-CD                                  
                    ,:MQ-MTR-TEST-GRP-CD                                
                    ,:MQ-MTR-TEST-GRP-TX                                
                    ,:MQ-SAMPL-CORRECTV-PCT                             
                    ,:MQ-SAMPL-OVERAGE-PCT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '*********** PCSCA614 ABEND  *************'   
                  DISPLAY 'ERROR IN 7160-FETCH-MTR-TEST-HIST      **'   
                  DISPLAY 'TEST-SCHED-CD      = ' MQ-TEST-SCHED-CD      
                  DISPLAY 'MTR-TEST-GRP-CD    = ' MQ-MTR-TEST-GRP-CD    
                  DISPLAY 'MTR-TEST-GRP-TX    = ' MQ-MTR-TEST-GRP-TX    
                  DISPLAY 'SAMPL-CORRECTV-PCT = ' MQ-SAMPL-CORRECTV-PCT 
                  DISPLAY 'SAMPL-OVERAGE-PCT  = ' MQ-SAMPL-OVERAGE-PCT  
                  DISPLAY 'RETURN CODE = ' SQLCODE                      
                  DISPLAY 'PROCESSING TERMINATED                  **'   
                  DISPLAY '*********** PCSCA614 ABEND  *************'   
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSE COPY_TEST_REC CURSOR                                   *          
      ****************************************************************          
      *                                                                         
       7170-CLOSE-MTR-TEST-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE COPY_TEST_REC                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              DISPLAY '**  ERROR IN 7170-CLOSE-MTR-TEST-HIST  **'       
              DISPLAY '**  RETURN CODE  = ' SQLCODE                     
              DISPLAY '**  PROCESSING TERMINATED              **'       
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS TEST_GROUP CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7250-OPEN-TEST-GROUP.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN TEST_GROUP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*********** PCSCA614 ABEND  *************'      
               DISPLAY '**  ERROR IN 7250-OPEN-TEST-GROUP      **'      
               DISPLAY '**  RETURN CODE = ' SQLCODE                     
               DISPLAY '**  PROCESSING TERMINATED              **'      
               DISPLAY '*********** PCSCA614 ABEND  *************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FETCH TEST_GROUP CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7260-FETCH-TEST-GROUP.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH TEST_GROUP                                         
                INTO :MQ-MTR-TEST-GRP-CD                                
                    ,:MQ-MTR-TEST-GRP-TX                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '*********** PCSCA614 ABEND  *************'    
                 DISPLAY '*  ERROR IN 7260-FETCH-TEST-GROUP      **'    
                 DISPLAY '* MTR-TEST-GRP-CD = ' MQ-MTR-TEST-GRP-CD      
                 DISPLAY '* MTR-TEST-GRP-TX = ' MQ-MTR-TEST-GRP-TX      
                 DISPLAY '*  PROCESSING TERMINATED               **'    
                 DISPLAY '*********** PCSCA614 ABEND  *************'    
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSE TEST_GROUP CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7270-CLOSE-TEST-GROUP.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE TEST_GROUP                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              DISPLAY '**  ERROR IN 7270-CLOSE-TEST-GROUP     **'       
              DISPLAY '**  RETURN CODE  = ' SQLCODE                     
              DISPLAY '**  PROCESSING TERMINATED              **'       
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * INSERT ROW INTO CSS_MTR_TEST_HIST                            *          
      ****************************************************************          
      *                                                                         
       7675-INSERT-MTR-TEST-HIST.                                       
      *                                                                         
           MOVE '7675' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MTR_TEST_HIST                             
                          (CODE_UTIL_TYPE                               
                          ,TEST_YEAR                                    
                          ,TEST_SCHED_CD                                
                          ,MTR_TEST_GRP_CD                              
                          ,SELECTED_QT                                  
                          ,INSTALLED_QT                                 
                          ,LAST_TEST_SEL_DT                             
                          ,STATUS_CD                                    
                          ,TESTED_QT                                    
                          ,SAMPLE_MIN_QT                                
                          ,SAMPL_ADDITIONL_QT                           
                          ,SAMPL_CORRECTV_PCT                           
                          ,SAMPL_OVERAGE_PCT                            
                          ,COMPANY_NO                                   
                          ,MTR_TEST_GRP_TX)                             
              VALUES                                                    
                          (:MQ-CODE-UTIL-TYPE                           
                          ,:MQ-TEST-YEAR                                
                          ,:MQ-TEST-SCHED-CD                            
                          ,:MQ-MTR-TEST-GRP-CD                          
                          ,:MQ-SELECTED-QT                              
                          ,:MQ-INSTALLED-QT                             
                          ,NULL                                         
                          ,:MQ-STATUS-CD                                
                          ,:MQ-TESTED-QT                                
                          ,:MQ-SAMPLE-MIN-QT                            
                          ,:MQ-SAMPL-ADDITIONL-QT                       
                          ,:MQ-SAMPL-CORRECTV-PCT                       
                          ,:MQ-SAMPL-OVERAGE-PCT                        
                          ,:WS-COMP-NO                                  
                          ,:MQ-MTR-TEST-GRP-TX)                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1 TO WS-REC-COUNT                                    
           ELSE                                                         
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              DISPLAY '**  ERROR IN 7675-INSERT-MTR-TEST-HIST  *'       
              DISPLAY '**  INSERT CODE = ' MQ-MTR-TEST-GRP-CD           
              DISPLAY '**  RETURN CODE = ' SQLCODE                      
              DISPLAY '**  PROCESSING TERMINATED               *'       
              DISPLAY '*********** PCSCA614 ABEND  *************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7675-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * NORMAL JOB END                                               *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY 'NORMAL JOB END'.                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9900-ABEND                                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
