       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA611.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  FEBRUARY 2016.                                    
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                         DB2                                **          
      ****************************************************************          
      *  COMMENTS: CONVERTS THE NEW METER FILE FROM THE MANUFACTURER *          
      *            TESTS INTO A FILE - READ INTO PCSMT601.           *          
      *            ANY ERRORS WILL BE WRITTEN TO THE REPORT.         *          
      *            THERE IS A SORT STEP PRIOR TO THIS PROGRAM.       *          
      *            IT TAKES A REALLY MESSED UP DATA SET AND          *          
      *            REFORMATS IT INTO A FIXED BLOCK, USABLE FILE.     *          
      *                                                              *          
      *  FILES:   NEWMTR    - NEW INPUT METER FILE                   *          
      *           FIOCA611  - NEW OUTPUT METER FILE                  *          
      *           SYSIN     - SYSTEM DATE CARD                       *          
      *           PRINTER1  - PRINTER                                *          
      *                                                              *          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  11 FEB 2015 RF10596      REWRITE GMC025 (EZTRIEVE) INTO   **          
      **                           A COBOL PROGRAM.                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA611.                                                           
      *                                                                         
           SELECT NEWMTR-FILE                                           
               ASSIGN UT-S-NEWMTR                                       
               FILE STATUS IS WS-NEWMTR-STATUS.                         
      *                                                                         
           SELECT PRINTER1 ASSIGN TO DA-PRINTER1.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA611.                                                           
       COPY FIOCA611.                                                           
      *                                                                         
       FD  NEWMTR-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      *                                                                         
       01  NEWMTR-RECORD.                                               
           05 E-611MTR-ATT-NBR         PIC X(12).                       
           05 E-611MTR-ATT-TYPE        PIC XX.                          
           05 E-611MTR-WARRANTY        PIC XX.                          
           05 E-611MTR-MAKE            PIC XX.                          
           05 E-611MTR-VERSION         PIC X(3).                        
           05 E-611MTR-TEST-CODE       PIC X.                           
           05 E-611MTR-DATE.                                            
              07 E-611MTR-MONTH        PIC XX.                          
              07 E-611MTR-SLASH1       PIC X.                           
              07 E-611MTR-DAY          PIC XX.                          
              07 E-611MTR-SLASH2       PIC X.                           
              07 E-611MTR-YEAR         PIC X(4).                        
           05 E-611MTR-MSF-CODE        PIC X(3).                        
           05 E-611MTR-FILLER          PIC X(45).                       
      *                                                                         
       FD  PRINTER1                                                     
           RECORD CONTAINS 133 CHARACTERS                               
           RECORDING MODE IS F.                                         
       01  PRT-REPORT.                                                  
           02  PRT-REPORT-CNTL        PIC X.                            
           02  PRT-REPORT-LINE        PIC X(132).                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA611'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           03  WS-PRINT-FIELDS.                                         
               05  WS-PAGE-COUNT       PIC S9(3) VALUE +1  COMP-3.      
               05  WS-LINE-COUNT       PIC S9(3) VALUE +99 COMP-3.      
               05  WS-INPUT-REC-COUNT  PIC S9(6) VALUE +0  COMP-3.      
               05  WS-COUNTER          PIC 9(4)  VALUE 0.               
      *                                                                         
       01  WS-FLAG.                                                     
           03  WS-NEWMTR-READ-STATUS PIC X VALUE SPACES.                
               88  NEWMTR-NO-REC           VALUE 'N'.                   
               88  NEWMTR-END              VALUE 'E'.                   
               88  NEWMTR-STARTED          VALUE 'S'.                   
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
           03  WS-SCEG-HDR             PIC X(39)                        
               VALUE 'SOUTH CAROLINA ELECTRIC AND GAS COMPANY'.         
           03  WS-PSNC-HDR             PIC X(39)                        
               VALUE '              PSNC ENERGY              '.         
           03  WS-202                  PIC X(3)  VALUE '202'.           
           03  WS-CS                   PIC XX    VALUE 'CS'.            
           03  WS-PSNC                 PIC XX    VALUE '26'.            
           03  WS-SCEG                 PIC XX    VALUE '01'.            
           03  WS-NODATA-SW            PIC X     VALUE 'Y'.             
           03  WS-SLASH                PIC X     VALUE '/'.             
           03  WS-Y                    PIC X     VALUE 'Y'.             
           03  WS-N                    PIC X     VALUE 'N'.             
           03  WS-ERROR-SW             PIC X     VALUE 'N'.             
           03  WS-ERROR-MSG            PIC X(40) VALUE SPACES.          
           03  WS-MTR-DATE             PIC X(10) VALUE SPACES.          
           03  WS-DATE1                PIC X(10) VALUE SPACES.          
           03  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           03  WS-COMPANY-NO           PIC XX    VALUE SPACES.          
           03  WS-CODE-UTIL-TYPE       PIC X     VALUE 'G'.             
           03  WS-NEWMTR-STATUS        PIC XX    VALUE SPACES.          
           03  WS-FCA611-STATUS        PIC XX    VALUE SPACES.          
           03  WS-ATTACHMENT-NBR       PIC X(12) VALUE SPACES.          
      *                                                                         
       01  WS-WARRANTY.                                                 
           03  WS-WAR1                 PIC X     VALUE '0'.             
           03  WS-WAR2                 PIC XX    VALUE SPACES.          
      *                                                                         
       01  WS-MSF-CODE.                                                 
           03  WS-MSF2                 PIC XX    VALUE SPACES.          
           03  WS-MSF1                 PIC X     VALUE SPACES.          
      *                                                                         
       01  WS-ERROR-MESSAGES.                                           
           03  WS-NBR-MSG              PIC X(40)                        
                  VALUE 'INVALID ATTACHMENT NBR ON THE FILE      '.     
           03  WS-TYPE-MSG             PIC X(40)                        
                  VALUE 'NO ATTACHMENT TYPE ON THE FILE          '.     
           03  WS-WAR-MSG              PIC X(40)                        
                  VALUE 'NO ATTACH WARRANTY ON THE FILE          '.     
           03  WS-MAKE-MSG             PIC X(40)                        
                  VALUE 'NO ATTACHMENT MAKE ON THE FILE          '.     
           03  WS-VERS-MSG             PIC X(40)                        
                  VALUE 'NO ATTACH VERSION ON THE FILE           '.     
           03  WS-CODE-MSG             PIC X(40)                        
                  VALUE 'NO ATTACH TEST CODE ON THE FILE         '.     
           03  WS-DATE-MSG             PIC X(40)                        
                  VALUE 'NO ATTACH PURCHASE DATE ON THE FILE     '.     
           03  WS-MSF-MSG              PIC X(40)                        
                  VALUE 'INVALID MSF CODE ON THE FILE            '.     
      *                                                                         
       01  WS-REPORT-PAGE-CONTROLS.                                     
           03  WS-PRT-REPORT-LINE-SPACE      PIC 9.                     
           03  WS-PRT-REPORT-LINE-COUNT      PIC 99 VALUE 0.            
               88  REPORT-PAGE-OVERFLOW         VALUE 57 THRU 99.       
               88  REPORT-NEW-PAGE              VALUE 0.                
               88  REPORT-FIRST-LINE            VALUE 1.                
      *                                                                         
      ****************************************************************          
      * REPORT HEADER RECORDS                                        *          
      ****************************************************************          
      *                                                                         
       01  PRT-REPORT-HEADER1.                                          
           03  FILLER                  PIC X(8)  VALUE 'PCSCA611'.      
           03  FILLER                  PIC X(39) VALUE SPACES.          
           03  PRT-HDR-COMPANY         PIC X(39) VALUE SPACES.          
           03  FILLER                  PIC X(20) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'DATE : '.       
           03  PRT-HDR-DATE            PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(9)  VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER2.                                          
           03  FILLER                  PIC X(47) VALUE SPACES.          
           03  FILLER                  PIC X(36) VALUE                  
           'METER ATTACHMENT (ERT) ERROR RECORDS'.                      
           03  FILLER                  PIC X(23) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'PAGE : '.       
           03  PRT-HDR-PAGE            PIC Z,ZZ9.                       
           03  FILLER                  PIC X(14) VALUE SPACES.          
      *                                                                         
       01  PRT-REPORT-HEADER3.                                          
           03  FILLER                  PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(10) VALUE 'ATTACHMENT'.    
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'TYPE'.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE 'WAR'.           
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'MAKE'.          
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE 'VERS'.          
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(8)  VALUE 'TESTCODE'.      
           03  FILLER                  PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'PURCHASE DATE'. 
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE 'MSFCODE'.       
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'ERROR MESSAGE'. 
           03  FILLER                  PIC X(44) VALUE SPACES.          
      *                                                                         
       01  PRT-ERROR-LINE.                                              
           03  FILLER                  PIC X     VALUE SPACES.          
           03  PRT-ATT-NBR             PIC X(12) VALUE SPACES.          
           03  FILLER                  PIC X(3)  VALUE SPACES.          
           03  PRT-ATT-TYPE            PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-ATT-WARRANTY        PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-ATT-MAKE            PIC XX    VALUE SPACES.          
           03  FILLER                  PIC X(4)  VALUE SPACES.          
           03  PRT-ATT-VERSION         PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-ATT-CODE            PIC X     VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE SPACES.          
           03  PRT-ATT-DATE            PIC X(10) VALUE SPACES.          
           03  FILLER                  PIC X(7)  VALUE SPACES.          
           03  PRT-ATT-MSF             PIC X(3)  VALUE SPACES.          
           03  FILLER                  PIC X(5)  VALUE SPACES.          
           03  PRT-ERROR-MESSAGE       PIC X(40) VALUE SPACES.          
           03  FILLER                  PIC X(17) VALUE SPACES.          
      *                                                                         
       01  PRT-END-LINE.                                                
           03  FILLER                  PIC X(59) VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'END OF REPORT'. 
           03  FILLER                  PIC X(60) VALUE SPACES.          
      *                                                                         
       01  PRT-NODATA-LINE.                                             
           03  FILLER                  PIC X(59) VALUE SPACES.          
           03  FILLER                  PIC X(13) VALUE 'NO DATA TODAY'. 
           03  FILLER                  PIC X(60) VALUE SPACES.          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAIN-PARA.                                                  
      *                                                                         
           PERFORM 1000-INITIALIZATION THRU 1000-EXIT.                  
      *                                                                         
           PERFORM 2000-PROCESS THRU 2000-EXIT                          
                   UNTIL NEWMTR-END.                                    
      *                                                                         
           IF WS-NODATA-SW = WS-Y                                       
              MOVE WS-PSNC-HDR TO PRT-HDR-COMPANY                       
              SET REPORT-NEW-PAGE TO TRUE                               
              MOVE ZEROS TO WS-LINE-COUNT                               
              PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
              MOVE PRT-NODATA-LINE TO PRT-REPORT-LINE                   
              MOVE 2 TO WS-PRT-REPORT-LINE-SPACE                        
              PERFORM 4500-PRINT-REPORT THRU 4500-EXIT                  
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPEN INPUT AND OUTPUT FILES.  GET CURRENT DATE               *          
      ****************************************************************          
      *                                                                         
       1000-INITIALIZATION.                                             
      *                                                                         
           PERFORM 1100-OPEN-FILES THRU 1100-EXIT.                      
      *                                                                         
           PERFORM 7000-GET-CURRENT-DATE THRU 7000-EXIT.                
      *                                                                         
           MOVE WS-CURRENT-DATE TO PRT-HDR-DATE.                        
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * THIS PROCESS OPENS ALL INPUT AND OUTPUT FILES.               *          
      ****************************************************************          
      *                                                                         
       1100-OPEN-FILES.                                                 
      *                                                                         
           OPEN INPUT NEWMTR-FILE.                                      
           OPEN OUTPUT FCSCA611-FILE                                    
                       PRINTER1.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * MAIN PROCESS                                                 *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS.                                                    
      *                                                                         
           MOVE WS-N TO WS-ERROR-SW.                                    
           MOVE SPACES TO PRT-ERROR-LINE                                
                          WS-ATTACHMENT-NBR                             
                          WS-MSF-CODE                                   
                          WS-ERROR-MSG                                  
                          WS-DATE1.                                     
      *                                                                         
           MOVE E-611MTR-ATT-NBR TO WS-ATTACHMENT-NBR.                  
           INSPECT WS-ATTACHMENT-NBR REPLACING ALL SPACES BY ZEROES.    
           IF WS-ATTACHMENT-NBR = ZEROS                                 
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-NBR-MSG TO WS-ERROR-MSG                           
           END-IF.                                                      
      *                                                                         
           MOVE E-611MTR-MSF-CODE TO WS-MSF-CODE.                       
           IF WS-MSF-CODE = WS-202                                      
              MOVE WS-PSNC TO WS-COMPANY-NO                             
              MOVE WS-PSNC-HDR TO PRT-HDR-COMPANY                       
           ELSE                                                         
              IF WS-MSF2 = WS-CS                                        
                 MOVE WS-SCEG TO WS-COMPANY-NO                          
                 MOVE WS-SCEG-HDR TO PRT-HDR-COMPANY                    
              ELSE                                                      
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-MSF-MSG TO WS-ERROR-MSG                        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE E-611MTR-WARRANTY TO WS-WAR2.                           
      *                                                                         
           MOVE E-611MTR-DATE TO WS-DATE1.                              
           PERFORM 7011-CONVERT-DATES THRU 7011-EXIT.                   
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              NEXT SENTENCE                                             
           ELSE                                                         
              IF E-611MTR-ATT-TYPE = SPACES                             
                 MOVE WS-Y TO WS-ERROR-SW                               
                 MOVE WS-TYPE-MSG TO WS-ERROR-MSG                       
              ELSE                                                      
                 IF E-611MTR-WARRANTY  = SPACES                         
                    MOVE WS-Y TO WS-ERROR-SW                            
                    MOVE WS-WAR-MSG TO WS-ERROR-MSG                     
                 ELSE                                                   
                    IF E-611MTR-MAKE = SPACES                           
                       MOVE WS-Y TO WS-ERROR-SW                         
                       MOVE WS-MAKE-MSG TO WS-ERROR-MSG                 
                    ELSE                                                
                       IF E-611MTR-VERSION = SPACES                     
                          MOVE WS-Y TO WS-ERROR-SW                      
                          MOVE WS-VERS-MSG TO WS-ERROR-MSG              
                       ELSE                                             
                          IF E-611MTR-TEST-CODE = SPACES                
                             MOVE WS-Y TO WS-ERROR-SW                   
                             MOVE WS-CODE-MSG TO WS-ERROR-MSG           
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ERROR-SW = WS-Y                                        
              PERFORM 2215-PRINT-ERROR-REPORT THRU 2215-EXIT            
              MOVE WS-N TO WS-ERROR-SW                                  
              MOVE WS-N TO WS-NODATA-SW                                 
           ELSE                                                         
              PERFORM 2210-CREATE-OUTPUT-REC THRU 2210-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 3100-READ-NEWMTR-FILE THRU 3100-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  INITIALIZE OUTPUT FIELDS. LOAD OUTPUT RECORD.               *          
      ****************************************************************          
      *                                                                         
       2210-CREATE-OUTPUT-REC.                                          
      *                                                                         
           INITIALIZE FIOCA611.                                         
      *                                                                         
           MOVE WS-ATTACHMENT-NBR     TO E-FMT611-DEVICE-NO.            
           MOVE E-611MTR-ATT-TYPE     TO E-FMT611-CODE-ATT-TYPE.        
           MOVE WS-COMPANY-NO         TO E-FMT611-COMPANY-NO.           
           MOVE WS-CODE-UTIL-TYPE     TO E-FMT611-CODE-UTIL-TYPE.       
           MOVE WS-WARRANTY           TO E-FMT611-ATTACH-WARRANTY.      
           MOVE E-611MTR-MAKE         TO E-FMT611-CODE-MAKE.            
           MOVE E-611MTR-TEST-CODE    TO E-FMT611-TEST-SCHED-CD.        
           MOVE E-611MTR-VERSION      TO E-FMT611-VERSION-CD.           
           MOVE WS-MTR-DATE           TO E-FMT611-DATE-PURCHASED.       
           MOVE WS-MSF-CODE           TO E-FMT611-MTR-STORAGE-FAC-CD.   
      *                                                                         
           PERFORM 3600-WRITE-FIOCA611 THRU 3600-EXIT.                  
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   LOAD AND PRINT ERROR REPORT                                *          
      ****************************************************************          
      *                                                                         
       2215-PRINT-ERROR-REPORT.                                         
      *                                                                         
           MOVE WS-ATTACHMENT-NBR  TO PRT-ATT-NBR.                      
           MOVE E-611MTR-ATT-TYPE  TO PRT-ATT-TYPE.                     
           MOVE E-611MTR-WARRANTY  TO PRT-ATT-WARRANTY.                 
           MOVE E-611MTR-MAKE      TO PRT-ATT-MAKE.                     
           MOVE E-611MTR-TEST-CODE TO PRT-ATT-CODE.                     
           MOVE E-611MTR-VERSION   TO PRT-ATT-VERSION.                  
           MOVE WS-MTR-DATE        TO PRT-ATT-DATE.                     
           MOVE WS-MSF-CODE        TO PRT-ATT-MSF.                      
           MOVE WS-ERROR-MSG       TO PRT-ERROR-MESSAGE.                
      *                                                                         
           PERFORM 4300-PRINT-DETAIL THRU 4300-EXIT.                    
      *                                                                         
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ NEWMTR-FILE                                             *          
      ****************************************************************          
      *                                                                         
       3100-READ-NEWMTR-FILE.                                           
      *                                                                         
           READ NEWMTR-FILE                                             
               AT END SET NEWMTR-END TO TRUE                            
           END-READ.                                                    
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * WRITE OUTPUT RECORD                                          *          
      ****************************************************************          
      *                                                                         
       3600-WRITE-FIOCA611.                                             
      *                                                                         
           WRITE FIOCA611.                                              
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT DETAIL RECORD - CHECK FOR HEADERS                      *          
      ****************************************************************          
      *                                                                         
       4300-PRINT-DETAIL.                                               
      *                                                                         
           IF WS-LINE-COUNT > +56                                       
              SET REPORT-NEW-PAGE TO TRUE                               
              MOVE ZEROS TO WS-LINE-COUNT                               
              PERFORM 4310-HEADER-CTRLRPT1 THRU 4310-EXIT               
           END-IF.                                                      
      *                                                                         
           MOVE PRT-ERROR-LINE TO PRT-REPORT-LINE.                      
           MOVE 2 TO WS-PRT-REPORT-LINE-SPACE.                          
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT HEADERS                                                *          
      ****************************************************************          
      *                                                                         
       4310-HEADER-CTRLRPT1.                                            
      *                                                                         
           MOVE +0                 TO WS-LINE-COUNT.                    
           MOVE WS-PAGE-COUNT      TO PRT-HDR-PAGE.                     
           MOVE PRT-REPORT-HEADER1 TO PRT-REPORT-LINE.                  
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER2 TO PRT-REPORT-LINE.                  
           MOVE 1                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
           MOVE PRT-REPORT-HEADER3 TO PRT-REPORT-LINE.                  
           MOVE 2                  TO WS-PRT-REPORT-LINE-SPACE.         
           PERFORM 4500-PRINT-REPORT THRU 4500-EXIT.                    
      *                                                                         
       4310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PRINT REPORT                                                 *          
      ****************************************************************          
      *                                                                         
       4500-PRINT-REPORT.                                               
      *                                                                         
           IF REPORT-NEW-PAGE                                           
              WRITE PRT-REPORT AFTER ADVANCING PAGE                     
              SET REPORT-FIRST-LINE TO TRUE                             
              MOVE +1 TO WS-LINE-COUNT                                  
              ADD  +1 TO WS-PAGE-COUNT                                  
           ELSE                                                         
              WRITE PRT-REPORT AFTER WS-PRT-REPORT-LINE-SPACE           
              ADD WS-PRT-REPORT-LINE-SPACE TO WS-LINE-COUNT             
           END-IF.                                                      
      *                                                                         
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  GET CURRENT DATE FOR HEADERS                                *          
      ****************************************************************          
      *                                                                         
       7000-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-DATE  = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  7000-GET-CURRENT-DATE              **'       
              DISPLAY '**  ERROR RETRIEVING CURRENT DATE      **'       
              DISPLAY '**  RETURN CODE=' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*****************************************'       
              PERFORM 9100-ABEND THRU 9100-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CONVERT THE INPUT DATE FORMATS INTO DB2 FORMAT              *          
      ****************************************************************          
      *                                                                         
       7011-CONVERT-DATES.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           LTRIM(RTRIM(:WS-DATE1)) E) T),'ISO')
            INTO
              :WS-MTR-DATE        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MTR-DATE = CHAR(DATE(TRIM(:WS-DATE1)),ISO)                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** 7011-CONVERT-DATES                   **'      
              DISPLAY '** ERROR CONVERTING INPUT PURCHASE DATE **'      
              DISPLAY '** NOT ABENDING - SEND RECORD TO REPORT **'      
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** WS-DATE1 = ' WS-DATE1                         
              DISPLAY '******************************************'      
              MOVE WS-Y TO WS-ERROR-SW                                  
              MOVE WS-DATE-MSG TO WS-ERROR-MSG                          
           END-IF.                                                      
      *                                                                         
       7011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSES FILES AT NORMAL TERMINATION                           *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA611-FILE                                          
                 NEWMTR-FILE                                            
                 PRINTER1.                                              
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * FOLLOWING PROCESS IS INVOKED WHEN ABNORMAL TERMINATION.      *          
      ****************************************************************          
      *                                                                         
       9100-ABEND.                                                      
      *                                                                         
           MOVE +9 TO RETURN-CODE.                                      
           STOP RUN.                                                    
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
