       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA608.                                        
       DATE-WRITTEN.   NOV 2002.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                                                             **         
      **            SOUTH CAROLINA ELECTRICITY AND GAS               **         
      **    MASS CANCEL/REBILL BTU FACTOR TRNSP BUY BACK CHANGE      **         
      **                                                             **         
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      CIG                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **    ----    --------     ------                              **         
      **  11/25/02   JS83520     ORIGINAL VERSION                    **         
T29397*  08/19/03 GANESH   CHANGES ADDED TO PROVIDE AUTOMATED PROCESS**         
T29397*                    FOR COST OF GAS ADJUSTMENT.               **         
      *                                                              **         
T30491*   03/09/04   JS83520     ADD COMMIT LOGIC                    **         
      *                                                              **         
30924 *   6/2/2004   RF10596     ADD TOTALS TO THE PRINTED REPORT    **         
C35005*                                                              **         
C35005*  10/05/2006  SS95855   ENHANCEMENT OF MASS CANCEL/REBILL     **         
C35005*                        1.NEW ERROR MESSAGE FOR THE ACCOUNTS  **         
C35005*                          THAT ARE NOT FOUND.                 **         
C35005*                        2.CATER FOR UTIL_TYPE = 'G' 'E' 'U'   **         
C35005*                        3.ADD 'WITH UR' IN SQL FOR PERFORMANCE**         
C35005*                        4.SPECIAL HANDLING FROM JOB_PARM TABLE**         
C35005*                          FOR BILL PRINT                      **         
C35005*                        5 BATCH PROCESS NEED TO FOLLOW ONLINE **         
C35005*                          PROCESS FOR BILL_ADJ RSN DESCRIPTION**         
C35005*                         ,EXEMPT FLAG AND BILL CORRECTED CODE **         
T35434*  06/08/2007  MK92804   REPLACED MODEL_SQL WITH SET COMMAND   **         
C36422*  11/05/2007  SS95855   MASS CANCEL\REBILL FOR MULTIPLE MONTHS**         
      *                        USING THE FILE INPUT AND FIX COMMIT   **         
      *                        LOGIC.                                **         
      *                                                              **         
A00303*   8/21/2008  RF10596   IF ACCOUNT IS ACTIVE OR FINAL, PROCESS**         
      *                        CANCEL REBILL, ELSE PUT IT ON ERROR   **         
      *                        REPORT. ADD PRINTER FOR ERROR REPORT. **         
      *                        ADD COMPANY NAME FOR MULTI COMPANY.   **         
      *                        REPLACE CWS00166 AND CPD00166 WITH    **         
      *                        UPDATED CURSOR. CLEAN UP CODE         **         
      *                                                              **         
      *****************************************************************         
      * REMARKS.                                                                
      *****************************************************************         
      *   THIS PROGRAM DOES A MASS CANCEL REBILL FOR A BTU FACTOR     *         
      *   CHANGE OR TRANSPORTATION. A FLAG IS USED TO DETERMINE IF    *         
      *   THE CANCEL REBILL IS FOR BTU FACTOR OR TRANSPORTATION. THE  *         
      *   PROGRAM CALLS THE CANCEL REBILL SUBROUTINE CPDCA190 AFTER   *         
      *   IDENTIFYING THE ACCOUNTS TO BE CANCEL REBILLED.             *         
      *****************************************************************         
                ------------------------------------------------------- 
                     ---- BASIC BATCH SEQUENCE STRUCTURE -------------  
                    0000 - 0000     MAIN CONTROL PATH                   
                    --------------------------------------------------- 
                    0100 - 0100     INITIALIZE SWITCHES AND COUNTERS    
                                    OPEN FILES                          
HPCCDM*                 0120 - 0120   OVERRIDE REPORT TITLE                     
HPCCDM*                 0140 - 0140   OVERRIDE REPORT HEAD                      
                        0160 - 0160   GET CHECK NUMBER & DATE           
                        0180 - 0180   VALIDATE CHECK NUMBER & DATE      
                    --------------------------------------------------- 
                    1000 - 1000     MAIN PROCESSING LOOP                
                        1100 - 1100                                     
                    --------------------------------------------------- 
                    1400 - 1420     PRINT CONTROL REPORT                
                    --------------------------------------------------- 
                    4000 - 4090     ACCESS CUSTOMER NAME                
                    --------------------------------------------------- 
                    7000 - 7500     INQUIRY CALLS TO DATABASES          
                    --------------------------------------------------- 
                    8000 - 8000     CREATE EXTRACT                      
                    --------------------------------------------------- 
                    9000 - 9000     TERMINATE                           
                    --------------------------------------------------- 
                    9900 - 9900     ABEND                               
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA608.                                                           
      *                                                                         
       COPY CSSPT33.                                                            
      *                                                                         
A00303 COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA608.                                                           
       COPY FIOCA608.                                                           
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
A00303 COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA608'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
A00303     05 WS-FOUND-COGBR-FACT       PIC X VALUE 'N'.                
A00303        88 FOUND-COGBR-FACT             VALUE 'Y'.                
A00303        88 NOT-FOUND-COGBR-FACT         VALUE 'N'.                
A00303     05 WS-FOUND-TRNS-ROW         PIC X VALUE 'N'.                
A00303        88 FOUND-TRNS-ROW               VALUE 'Y'.                
A00303        88 NOT-FOUND-TRNS-ROW           VALUE 'N'.                
A00303     05  WS-ERROR-ACCOUNT         PIC S9(13)V COMP-3 VALUE 0.     
A00303     05  WS-ERROR-COUNT           PIC S9(3)   COMP-3 VALUE 0.     
A00303     05  WS-PRT2-NODATA           PIC X      VALUE 'Y'.           
A00303     05  WS-PRT-NODATA            PIC X      VALUE 'Y'.           
A00303     05  WS-COMPANY-NAME          PIC X(26)  VALUE SPACES.        
           05  RS-RETURN-CODE           PIC S9(4)  COMP VALUE 0.        
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
           05  WS-CURRENT-TIME          PIC 9(08).                      
           05  WS-CURRENT-DT.                                           
               10  WS-CURRENT-YY        PIC 99.                         
               10  WS-CURRENT-MM        PIC 99.                         
               10  WS-CURRENT-DD        PIC 99.                         
           05  WS-INPUT-RECS-READ       PIC S9(04) COMP VALUE ZERO.     
           05  WS-INPUT-RECS-READ-DIS   PIC ZZZ9.                       
           05  WS-MAX-LINES             PIC 9(02) VALUE 56.             
           05  WS-LINE-COUNT            PIC 9(02) VALUE 66.             
A00303     05  WS-PRT2-LINE-COUNT       PIC S9(3) COMP-3 VALUE 66.      
           05  WS-PAGE-COUNT            PIC 9(03) VALUE ZERO.           
A00303     05  WS-PRT2-PAGE-COUNT       PIC S9(3) COMP-3 VALUE 0.       
           05  WS-ONE                   PIC 9(02) VALUE 01.             
           05  WS-COMMENTS              PIC X(60).                      
           05  WS-CIG-CUSTOMER          PIC X(01) VALUE SPACES.         
A00303     05  WS-FCA331-STATUS         PIC XX.                         
           05  WS-FCSCA608-STATUS       PIC X(02).                      
               88  E-FCSCA608-SUCCESSFUL          VALUE '00'.           
               88  E-FCSCA608-EOF                 VALUE '23'.           
           05  WS-UNMTRD-PRESENT        PIC X(01) VALUE SPACES.         
           05  WS-FIRST-UT-FETCH        PIC X(1) VALUE 'N'.             
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  BI-DATE-BILLED-NI        PIC S9(4) COMP.                 
           05  BG-DATE-ORIG-BILL-NULL   PIC S9(4) COMP.                 
           05  BG-DATE-LFTM-HI-DMD-NULL PIC S9(4) COMP.                 
                                                                        
       01  WS-SWITCHES.                                                 
A00303     05  WS-7119-FIRST-SW         PIC X VALUE 'Y'.                
A00303     05  WS-BG-SW                 PIC X VALUE 'N'.                
           05  WS-PRINT-FILE-STATUS     PIC X(02).                      
               88  PRINT-FILE-SUCCESS             VALUE '00'.           
           05  WS-CIG-CRSR-FL           PIC X(01) VALUE 'N'.            
               88 END-OF-CIG-CRSR       VALUE 'Y'.                      
           05  WS-UTIL-CRSR-FL          PIC X(01) VALUE 'N'.            
               88 END-OF-UTIL-CRSR      VALUE 'Y'.                      
           05  WS-FCSCA608-EOF-SW       PIC X(01) VALUE 'N'.            
               88 END-OF-INPUT          VALUE 'Y'.                      
           05  WS-FILE-INPUT-SW         PIC X(01) VALUE 'N'.            
               88 FILE-INPUT            VALUE 'Y'.                      
C35005     05  WS-ACCT-NO-PREV          PIC S9(13)V COMP-3 VALUE 0.     
C35005     05  WS-PARM-HANDLE           PIC X(12) VALUE 'TEMP-PULL-CD'. 
C35005                                                                  
C35005 01  WS-CD-UTIL-TYPE              PIC X(03).                      
C35005 01  WS-CODE-UTIL-TYPE   REDEFINES  WS-CD-UTIL-TYPE.              
C35005     05  WS-CODE-UTIL-1           PIC X(01).                      
C35005     05  WS-CODE-UTIL-2           PIC X(01).                      
C35005     05  WS-CODE-UTIL-3           PIC X(01).                      
      *                                                                         
A00303 01  WS-NON-ACTIVE                PIC X(50)                       
A00303     VALUE 'ACCOUNT NOT ACTIVE OR FINAL: WILL NOT BE PROCESSED'.  
      *                                                                         
A00303 01  WS-NOT-VALID                 PIC X(50)                       
A00303     VALUE 'ACCOUNT NOT ON CSS_ACCOUNT : WILL NOT BE PROCESSED'.  
      *                                                                         
A00303 01  WS-MSG-REBILL                PIC X(46)                       
A00303     VALUE '             MASS CANCEL/REBILL               '.      
      *                                                                         
A00303 01  WS-MSG-BTU                   PIC X(46)                       
A00303     VALUE '     MASS CANCEL/REBILL BTU FACTOR CHANGE     '.      
      *                                                                         
A00303 01  WS-MSG-COG                   PIC X(46)                       
A00303     VALUE '       MASS CANCEL/REBILL COG FACT ADJ        '.      
      *                                                                         
A00303 01  WS-MSG-BUYBACK               PIC X(46)                       
A00303     VALUE 'MASS CANCEL/REBILL TRNSP BUY BACK PRICE CHANGE'.      
      *                                                                         
A00303 01  WS-MSG-FILE                  PIC X(46)                       
A00303     VALUE '     MASS CANCEL/REBILL USING FILE INPUT      '.      
      *                                                                         
A00303 01  WS-MSG-SCSCA190.                                             
A00303     05 WS-MSG-SCSCA190-PARA      PIC X(7) VALUE 'PARA = '.       
A00303     05 WS-MSG-SCSCA190-REVIEW    PIC X(4).                       
A00303     05 FILLER                    PIC X.                          
A00303     05 WS-MSG-SCSCA190-SQL       PIC +Z(4).                      
A00303     05 FILLER                    PIC X.                          
A00303     05 WS-MSG-SCSCA190-ABEND     PIC X(8).                       
A00303     05 FILLER                    PIC X.                          
A00303     05 WS-MSG-SCSCA190-TXT       PIC X(21)                       
A00303     VALUE '- FAILED IN SCSCA190 '.                               
      *                                                                         
A00303 01  WS-MSG-NOT-FOUND             PIC X(39)                       
A00303     VALUE '2000 - INPUT FILE BILL NOT FOUND       '.             
      *                                                                         
A00303 01  WS-MSG-8800-NO-VALID-DETAILS.                                
A00303     05 WS-MSG-8800-BGREVIEW      PIC X(8).                       
A00303     05 FILLER                    PIC X.                          
A00303     05 WS-MSG-8800-BGTEXT        PIC X(41)                       
A00303     VALUE '8800 - NO VALID BILLING DETAILS TO REBILL'.           
      *                                                                         
A00303 01  WS-MSG-8800-ACCOUNT-ABENDED.                                 
A00303     05 WS-MSG-8800-REVIEW        PIC X(8).                       
A00303     05 FILLER                    PIC X.                          
A00303     05 WS-MSG-8800-TEXT          PIC X(41)                       
A00303     VALUE '8800-ACCOUNT ABENDED DURING CANCEL REBILL'.           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC X(08) VALUE 'PCSCA608'.     
           05  PROGRAM-NAME             PIC X(08) VALUE 'PCSCA608'.     
           05  SCSCA190                 PIC X(08) VALUE 'SCSCA190'.     
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
A00303     05  WS-ACT                   PIC X(6)  VALUE 'ACTIVE'.       
A00303     05  WS-FIN                   PIC X(6)  VALUE 'FINAL '.       
A00303     05  WS-OTH                   PIC X(6)  VALUE 'OTHER '.       
      *                                                                         
T30491 01  WS-COMMIT-VARS.                                              
T30491     05  WS-CHKP-SEQ-NO                PIC 99 VALUE 0.            
T30491     05  WS-TOTAL-RECORD-CNT           PIC 9(5) VALUE 0.          
T30491     05  WS-RECORD-COUNT               PIC 9(4) VALUE 0.          
T30491     05  WS-COMMIT-COUNT               PIC 9(4) VALUE 0.          
T30491     05  WS-COMMIT-LIMIT               PIC 9(4) VALUE 0.          
T30491     05  WS-DEFAULT-CHKP-LUW-LIMIT     PIC 9(4) VALUE 50.         
30924      05  WS-TOTAL-THAT-SHOULD-BE-THERE PIC 9(5) VALUE 0.          
      *                                                                         
T30491 01  WS-COMMIT-DATA.                                              
T30491     05  WS-COMMIT-TEXT              PIC X(09).                   
T30491     05  WS-COMMIT-NUM               PIC 9(04).                   
T30491     05  FILLER                      PIC X(67).                   
      *                                                                         
       01  WS-HEADING-LINES.                                            
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
      *                                                                         
A00303     05 WS-RPT-TITLE-1.                                           
A00303        10 FILLER                  PIC XX    VALUE SPACES.        
A00303        10 P-RPT-TITLE-PGNM        PIC X(8).                      
A00303        10 FILLER                  PIC X(43) VALUE SPACES.        
A00303        10 P-RPT-COMPANY           PIC X(26).                     
A00303        10 FILLER                  PIC X(20) VALUE SPACES.        
A00303        10 FILLER                  PIC X(9)  VALUE 'RUN-DATE:'.   
A00303        10 P-RPT-RUN-MM            PIC XX.                        
A00303        10 FILLER                  PIC X     VALUE '/'.           
A00303        10 P-RPT-RUN-DD            PIC XX.                        
A00303        10 FILLER                  PIC X     VALUE '/'.           
A00303        10 P-RPT-RUN-YY            PIC XX.                        
A00303        10 FILLER                  PIC X(6)  VALUE ' TIME:'.      
A00303        10 WS-REP-HH               PIC XX.                        
A00303        10 FILLER                  PIC X     VALUE ':'.           
A00303        10 WS-REP-MIN              PIC XX.                        
A00303        10 FILLER                  PIC X     VALUE ':'.           
A00303        10 WS-REP-SS               PIC XX.                        
A00303        10 FILLER                  PIC XXX   VALUE SPACES.        
      *                                                                         
A00303***************************************************************           
A00303*           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
A00303***************************************************************           
      *                                                                         
A00303     05 WS-RPT-TITLE-2.                                           
A00303        10 FILLER                  PIC X(43) VALUE SPACES.        
A00303        10 P-RPT-REP-NAME          PIC X(46).                     
A00303        10 FILLER                  PIC X(24) VALUE SPACES.        
A00303        10 FILLER                  PIC X(10) VALUE 'PAGE    : '.  
A00303        10 FILLER                  PIC XXX   VALUE SPACES.        
A00303        10 WS-REP-PAGE             PIC ZZZ9.                      
A00303        10 FILLER                  PIC XXX   VALUE SPACES.        
      *                                                                         
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                  PIC X(133) VALUE SPACES.      
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR HEADER LINE           **           
      ***************************************************************           
           05 WS-RPT-HEADER1.                                           
              10 FILLER                  PIC X(5)  VALUE SPACES.        
A00303        10 RPT-STATUS              PIC X(6)  VALUE 'STATUS'.      
              10 FILLER                  PIC X(12) VALUE SPACES.        
              10 FILLER                  PIC X(10) VALUE                
                      'ACCOUNT NO'.                                     
              10 FILLER                  PIC X(06) VALUE SPACES.        
              10 FILLER                  PIC X(07) VALUE                
                      'BILL NO'.                                        
              10 FILLER                  PIC X(06) VALUE SPACES.        
              10 FILLER                  PIC X(05) VALUE                
                      'IC NO'.                                          
              10 FILLER                  PIC X(06) VALUE SPACES.        
              10 FILLER                  PIC X(13) VALUE                
                      'CODE UTIL TYP'.                                  
              10 FILLER                  PIC X(06) VALUE SPACES.        
              10 FILLER                  PIC X(08) VALUE                
                      'COMMENTS'.                                       
              10 FILLER                  PIC X(43) VALUE SPACES.        
                                                                        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR DETAIL LINE           **           
      ***************************************************************           
           05  WS-DETAIL-LINE.                                          
               10 FILLER                  PIC X(5)  VALUE SPACES.       
A00303         10 P-STATUS                PIC X(6)  VALUE SPACES.       
               10 FILLER                  PIC X(9)  VALUE SPACES.       
               10 P-ACCOUNT-NO            PIC X(13).                    
               10 FILLER                  PIC X(08) VALUE SPACES.       
               10 P-BILL-NO               PIC 9(04).                    
               10 FILLER                  PIC X(09) VALUE SPACES.       
               10 P-IC-NO                 PIC 9(04).                    
               10 FILLER                  PIC X(13) VALUE SPACES.       
               10 P-CODE-UTIL-TYPE        PIC X(01).                    
               10 FILLER                  PIC X(10) VALUE SPACES.       
A00303         10 P-COMMENTS              PIC X(50).                    
      *                                                                         
A00303****************************************************************          
A00303*           COMMON WORKING STORAGE FOR ERROR REPORT           **          
A00303****************************************************************          
      *                                                                         
A00303     05  WS-PRT2-LINE.                                            
A00303         10 FILLER                  PIC X(5)  VALUE SPACES.       
A00303         10 PRT2-STATUS             PIC X(6)  VALUE SPACES.       
A00303         10 FILLER                  PIC X(9)  VALUE SPACES.       
A00303         10 PRT2-ACCOUNT-NO         PIC X(13) VALUE SPACES.       
A00303         10 FILLER                  PIC X(8)  VALUE SPACES.       
A00303         10 PRT2-BILL-NO            PIC 9(4)  VALUE ZEROS.        
A00303         10 FILLER                  PIC X(9)  VALUE SPACES.       
A00303         10 PRT2-IC-NO              PIC 9(4)  VALUE ZEROS.        
A00303         10 FILLER                  PIC X(13) VALUE SPACES.       
A00303         10 PRT2-CODE-UTIL-TYPE     PIC X     VALUE SPACES.       
A00303         10 FILLER                  PIC X(10) VALUE SPACES.       
A00303         10 PRT2-COMMENTS           PIC X(51) VALUE SPACES.       
      *                                                                         
30924 ***************************************************************           
30924 *           COMMON WORKING STORAGE FOR TOTAL LINE            **           
30924 ***************************************************************           
      *                                                                         
30924      05  WS-TOTAL-LINE.                                           
30924          10 FILLER                  PIC X(20) VALUE SPACES.       
30924          10 FILLER                  PIC X(40)                     
30924             VALUE 'TOTAL NUMBER THAT SHOULD BE PROCESSED = '.     
30924          10 WS-SHOULD-BE-CNT        PIC 9(5)  VALUE ZEROS.        
30924          10 FILLER                  PIC X(10) VALUE SPACES.       
30924          10 FILLER                  PIC X(37)                     
30924             VALUE 'TOTAL NUMBER OF ACCOUNTS PROCESSED = '.        
30924          10 WS-TOTAL-LINE-CNT       PIC 9(5)  VALUE ZEROS.        
30924          10 FILLER                  PIC X(16) VALUE SPACES.       
      *                                                                         
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR FOOTER                **           
      ***************************************************************           
           05  WS-FOOTER.                                               
               10 FILLER                     PIC X(35) VALUE SPACES.    
               10 FILLER                     PIC X(25) VALUE            
                   '* * * END OF REPORT * * *'.                         
               10 FILLER                     PIC X(73) VALUE SPACES.    
      *                                                                         
      ***************************************************************           
A00303*           COMMON WORKING STORAGE FOR NO DATA LINE          **           
      ***************************************************************           
      *                                                                         
A00303     05  WS-NODATA-LINE.                                          
A00303         10 FILLER                     PIC X(35) VALUE SPACES.    
A00303         10 FILLER                     PIC X(25) VALUE            
A00303             '* NO DATA FOR THIS RUN  *'.                         
A00303         10 FILLER                     PIC X(73) VALUE SPACES.    
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
       COPY FIOJC01.                                                            
                                                                        
       COPY FIOCA00.                                                            
                                                                        
       COPY CWSCA190.                                                           
                                                                        
       COPY CWS00010.                                                           
                                                                        
       COPY CWS00303.                                                           
                                                                        
       COPY CWS00039.                                                           
                                                                        
       COPY CWS00038.                                                           
                                                                        
      *01  WS-INPUT-DATA-BREAKDOWN     PIC X(80)  VALUE ZEROS.                  
       01  WS-INPUT-DATA-R99    REDEFINES WS-INPUT-DATA-BREAKDOWN.      
           05  IN-PARM                 PIC X(8).                        
           05  FILLER                  PIC X.                           
           05  IN-REVENUE-MONTH        PIC X(6).                        
           05  FILLER                  PIC X(10).                       
           05  IN-BTU-FACTOR           PIC X(3).                        
           05  FILLER                  PIC X(6).                        
           05  IN-BILL-WHEN            PIC X.                           
           05  FILLER                  PIC X(6).                        
           05  IN-CHANGE-TYPE          PIC X.                           
           05  FILLER                  PIC X(5).                        
           05  IN-ADJ-REASN-CODE       PIC X(3).                        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLCLDT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLCNTR                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBTRNBLK                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTCDEF                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBVOLBLK                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMTRIDT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A00303*  CSS_FIXED_FCT_HIST FH                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXHST                                                  
           END-EXEC.                                                            
      *                                                                         
A00303****************************************************************          
A00303*  CSS_COMPANY                                                 *          
A00303****************************************************************          
      *                                                                         
A00303     EXEC SQL                                                             
A00303         INCLUDE TBCOMPNY                                                 
A00303     END-EXEC.                                                            
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC       PIC 99.                       
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA608 ENDS HERE  '.            
      *                                                                         
      ****************************************                                  
      **  CURSOR DECLARATION -- CIG_CRSR    **                                  
      ****************************************                                  
           EXEC SQL                                                     
             DECLARE CIG_CRSR CURSOR WITH HOLD FOR                      
A00303        SELECT AT.ACCOUNT_NO                                      
A00303              ,AT.CODE_ACCT_STAT                                  
A00303              ,AT.CUSTOMER_NO                                     
A00303          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
A00303         WHERE AT.COMPANY_NO = '01'                               
A00303           AND EXISTS                                             
A00303              (SELECT '1'                                         
A00303                 FROM  CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)         
A00303                      ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)         
A00303                WHERE  UT.ACCOUNT_NO     = AT.ACCOUNT_NO          
A00303                  AND  UT.CODE_UTIL_TYPE = 'G'                    
A00303                  AND  UT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE      
A00303                  AND  UT.RATE_PLAN_NO   = J1.RATE_PLAN_NO        
A00303                  AND  J1.REG_TYPE_CD    = 'D')                   
C35005      FOR READ ONLY                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CIG_CRSR CURSOR WITH HOLD FOR                              
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.COMPANY_NO = '01'                                       
MFA-TR*          AND EXISTS                                                     
MFA-TR*             (SELECT '1'                                                 
MFA-TR*                FROM  CSS_RATE_COMP_DEF J1                               
MFA-TR*                     ,CSS_UTIL_ENVRNMT  UT                               
MFA-TR*               WHERE  UT.ACCOUNT_NO     = AT.ACCOUNT_NO                  
MFA-TR*                 AND  UT.CODE_UTIL_TYPE = 'G'                            
MFA-TR*                 AND  UT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE              
MFA-TR*                 AND  UT.RATE_PLAN_NO   = J1.RATE_PLAN_NO                
MFA-TR*                 AND  J1.REG_TYPE_CD    = 'D')                           
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  CURSOR DECLARATION - GET THE CORRECT CSS_BILLING_DET ROWS  *          
      ****************************************************************          
      *                                                                         
A00303     EXEC SQL                                                     
A00303       DECLARE BG_CRSR CURSOR WITH HOLD FOR                       
A00303          SELECT ACCOUNT_NO                                       
A00303                ,CASE                                             
A00303                   WHEN REV_MTH_ORIG_BILL > 0                     
A00303                      THEN REV_MTH_ORIG_BILL                      
A00303                     ELSE REVENUE_MONTH                           
A00303                 END AS REVENUE_MONTH                             
A00303                ,BILL_NO                                          
A00303                ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                               
A00303                ,CODE_BILL_ITM_IND                                
A00303                ,PRORATE_CD                                       
A00303                ,CODE_UTIL_TYPE                                   
A00303                ,IC_NO                                            
A00303           FROM  CSS_BILLING_DET WITH(READUNCOMMITTED)                    
A00303          WHERE  ACCOUNT_NO     = :BG-ACCOUNT-NO                  
A00303            AND  CODE_UTIL_TYPE IN (:WS-CODE-UTIL-1,              
A00303                                    :WS-CODE-UTIL-2,              
A00303                                    :WS-CODE-UTIL-3)              
A00303            AND ((REV_MTH_ORIG_BILL = 0                           
A00303                  AND REVENUE_MONTH = :BG-REVENUE-MONTH)          
A00303             OR (REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH            
A00303                 AND REVENUE_MONTH > 0))                          
A00303            AND  CODE_BILL_CALC     =  'A'                        
A00303            AND  CODE_BILL_ITM_TYPE =  'C'                        
A00303            AND  CODE_BILL_ITM_IND  =  'A'                        
A00303            AND  REV_RPT_CD        <>  'T'                        
A00303        FOR READ ONLY                                     
A00303     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG_CRSR CURSOR WITH HOLD FOR                               
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,CASE                                                     
MFA-TR*                  WHEN REV_MTH_ORIG_BILL > 0                             
MFA-TR*                     THEN REV_MTH_ORIG_BILL                              
MFA-TR*                    ELSE REVENUE_MONTH                                   
MFA-TR*                END AS REVENUE_MONTH                                     
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,CODE_BILL_ITM_IND                                        
MFA-TR*               ,PRORATE_CD                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*          FROM  CSS_BILLING_DET                                          
MFA-TR*         WHERE  ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*           AND  CODE_UTIL_TYPE IN (:WS-CODE-UTIL-1,                      
MFA-TR*                                   :WS-CODE-UTIL-2,                      
MFA-TR*                                   :WS-CODE-UTIL-3)                      
MFA-TR*           AND ((REV_MTH_ORIG_BILL = 0                                   
MFA-TR*                 AND REVENUE_MONTH = :BG-REVENUE-MONTH)                  
MFA-TR*            OR (REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH                    
MFA-TR*                AND REVENUE_MONTH > 0))                                  
MFA-TR*           AND  CODE_BILL_CALC     =  'A'                                
MFA-TR*           AND  CODE_BILL_ITM_TYPE =  'C'                                
MFA-TR*           AND  CODE_BILL_ITM_IND  =  'A'                                
MFA-TR*           AND  REV_RPT_CD        <>  'T'                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **    0000-MAINLINE                                           **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU  0100-EXIT.         
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU  1000-EXIT.         
                                                                        
           PERFORM 8600-PRINT-RPT-FOOTER       THRU 8600-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU  9000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  INITIALIZATION ROUTINE                                    **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
A00303     MOVE '01' TO C7-COMPANY-NO.                                  
A00303     PERFORM 7810-GET-COMPANY-DESCRIPTION THRU 7810-EXIT.         
A00303     MOVE C7-COMPANY-NAME TO WS-COMPANY-NAME.                     
      *                                                                         
           ACCEPT WS-CURRENT-DT                  FROM DATE.             
           MOVE   WS-CURRENT-YY                  TO   P-RPT-RUN-YY.     
           MOVE   WS-CURRENT-MM                  TO   P-RPT-RUN-MM.     
           MOVE   WS-CURRENT-DD                  TO   P-RPT-RUN-DD.     
                                                                        
           ACCEPT WS-CURRENT-TIME                FROM TIME.             
           MOVE   WS-CURRENT-TIME(1:2)           TO WS-REP-HH.          
           MOVE   WS-CURRENT-TIME(3:2)           TO WS-REP-MIN.         
           MOVE   WS-CURRENT-TIME(5:2)           TO WS-REP-SS.          
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
A00303                 FCSPT331-FILE.                                   
      *                                                                         
      *****************************************************************         
      *    GET THE COMMON-DATE FROM THE JOB_PARM TABLE                *         
      *****************************************************************         
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           ELSE                                                         
              MOVE WS-FCA00-COMMON-DATE        TO WS-INPUT-DATE         
           END-IF.                                                      
      *                                                                         
           PERFORM 0120-GET-COMMIT-PARM THRU 0120-EXIT.                 
           DISPLAY '0120 PARM ' G6-PARM-DATA.                           
      *                                                                         
C35005     PERFORM 0125-GET-PARM-HANDLG THRU 0125-EXIT.                 
           DISPLAY '0125 PARM ' G6-PARM-DATA.                           
      *                                                                         
           PERFORM 0110-GET-INPUT-PARM THRU 0110-EXIT.                  
           DISPLAY '0110 PARM ' G6-PARM-DATA.                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0110-GET-INPUT-PARM                                         **        
      ******************************************************************        
      *                                                                         
       0110-GET-INPUT-PARM.                                             
      *                                                                         
           MOVE  WS-PGRMNAME           TO WS-PROGRAM.                   
           MOVE  WS-PARM               TO WS-COMMAND.                   
           MOVE  ZEROS                 TO WS-SEQUENCE.                  
           MOVE  SPACES                TO WS-SYSIPT.                    
           MOVE  WS-KEY-AREA           TO E-FJC01-KEY.                  
      *                                                                         
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
      *                                                                         
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (IN-PARM = 'REV-MNTH' AND INPUT-ACTIVE)            
                  OR  END-OF-SYSIPT.                                    
      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY ' '                                              
               DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR '           
               DISPLAY '**   PARAMETERS NOT FOUND'                      
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           ELSE                                                         
               MOVE 57                    TO WS-LINE-COUNT              
               IF IN-REVENUE-MONTH   NUMERIC AND                        
                  IN-REVENUE-MONTH  > ZEROES                            
                  IF IN-CHANGE-TYPE = 'B'                               
                     IF IN-BTU-FACTOR > SPACES                          
A00303                  MOVE WS-MSG-BTU TO P-RPT-REP-NAME               
A00303                  MOVE 'G' TO UT-CODE-UTIL-TYPE                   
A00303                              WS-CODE-UTIL-1                      
A00303                              WS-CODE-UTIL-2                      
A00303                              WS-CODE-UTIL-3                      
                     ELSE                                               
                        DISPLAY ' '                                     
                        DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR '  
                        DISPLAY '**   BTU FACTOR NOT VALID'             
                        DISPLAY '**    KEY = ' E-FJC01-KEY              
                        DISPLAY '**  PROCESSING TERMINATED  **'         
                        PERFORM 9900-ABEND THRU 9900-EXIT               
                     END-IF                                             
                  ELSE                                                  
                     IF IN-CHANGE-TYPE = 'T'                            
A00303                  MOVE WS-MSG-BUYBACK TO P-RPT-REP-NAME           
A00303                  MOVE 'G' TO UT-CODE-UTIL-TYPE                   
A00303                              WS-CODE-UTIL-1                      
A00303                              WS-CODE-UTIL-2                      
A00303                              WS-CODE-UTIL-3                      
                     ELSE                                               
A00303                  IF IN-CHANGE-TYPE = 'F'                         
A00303                     SET FILE-INPUT TO TRUE                       
C35005                     MOVE IN-BTU-FACTOR TO WS-CD-UTIL-TYPE        
C35005                     IF WS-CODE-UTIL-1 > ' '                      
A00303                        MOVE WS-MSG-REBILL TO P-RPT-REP-NAME      
                           ELSE                                         
                              DISPLAY ' '                               
                          DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR' 
                             DISPLAY '**   UTIL TYPE MUST BE G, E OR U' 
                              DISPLAY '**    KEY = ' E-FJC01-KEY        
                              DISPLAY '**  PROCESSING TERMINATED  **'   
                              PERFORM 9900-ABEND THRU 9900-EXIT         
                           END-IF                                       
C35005                     IF WS-CODE-UTIL-2 > ' '                      
C35005                        CONTINUE                                  
C35005                     ELSE                                         
C35005                        MOVE WS-CODE-UTIL-1  TO WS-CODE-UTIL-2    
C35005                     END-IF                                       
C35005                     IF WS-CODE-UTIL-3 > ' '                      
C35005                        CONTINUE                                  
C35005                     ELSE                                         
C35005                        MOVE WS-CODE-UTIL-2  TO WS-CODE-UTIL-3    
C35005                     END-IF                                       
                       ELSE                                             
C29397                    IF IN-CHANGE-TYPE = 'C'                       
A00303                       MOVE WS-MSG-COG TO P-RPT-REP-NAME          
A00303                       MOVE 'G' TO UT-CODE-UTIL-TYPE              
A00303                                   WS-CODE-UTIL-1                 
A00303                                   WS-CODE-UTIL-2                 
A00303                                   WS-CODE-UTIL-3                 
C29397                    ELSE                                          
C29397                     DISPLAY ' '                                  
C29397                     DISPLAY '* ' WS-PGRMNAME ' PROCESSING ERROR' 
C29397                     DISPLAY '*   CHANGE TYPE MUST BE B T OR F'   
C29397                     DISPLAY '*    KEY = ' E-FJC01-KEY            
C29397                     DISPLAY '*  PROCESSING TERMINATED  **'       
C29397                     PERFORM 9900-ABEND THRU 9900-EXIT            
C29397                    END-IF                                        
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
                  IF IN-BILL-WHEN = 'F' OR 'I'                          
                     CONTINUE                                           
                  ELSE                                                  
                     DISPLAY ' '                                        
                     DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'  
                     DISPLAY '**   BILL WHEN MUST BE F OR I'            
                     DISPLAY '**   KEY = ' E-FJC01-KEY                  
                     DISPLAY '**  PROCESSING TERMINATED  **'            
                     PERFORM 9900-ABEND THRU 9900-EXIT                  
                  END-IF                                                
                  PERFORM 7611-CLOSE THRU 7611-EXIT                     
               ELSE                                                     
                   DISPLAY ' '                                          
                   DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'    
                   DISPLAY '**   REVENUE MONTH IS NOT NUMERIC'          
                   DISPLAY '**    KEY = ' E-FJC01-KEY                   
                   DISPLAY '**  PROCESSING TERMINATED  **'              
                   PERFORM 9900-ABEND  THRU  9900-EXIT                  
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T30491******************************************************************        
T30491**  0120-GET-COMMIT-PARM                                        **        
T30491******************************************************************        
      *                                                                         
T30491 0120-GET-COMMIT-PARM.                                            
      *                                                                         
T30491     MOVE SPACES                 TO WS-SYSIPT.                    
T30491     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
T30491     MOVE WS-PARM                TO WS-COMMAND.                   
T30491     MOVE ZEROS                  TO WS-SEQUENCE.                  
T30491                                                                  
T30491     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
T30491                                                                  
T30491     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
C36422          UNTIL (IN-PARM = 'COMMIT =' AND INPUT-ACTIVE)           
T30491            OR  END-OF-SYSIPT.                                    
T30491                                                                  
T30491     MOVE G6-PARM-DATA           TO WS-COMMIT-DATA.               
T30491                                                                  
T30491     EVALUATE TRUE                                                
T30491        WHEN END-OF-SYSIPT                                        
T30491           DISPLAY ' '                                            
T30491           DISPLAY '**  PCSCS608 PROCESSING INFO   **'            
T30491           DISPLAY '**    COMMIT PARM NOT PRESENT'                
T30491           DISPLAY '**  DEFAULT CHKP LUW 50 IS USED'              
T30491           MOVE WS-DEFAULT-CHKP-LUW-LIMIT TO WS-COMMIT-COUNT      
T30491        WHEN WS-COMMIT-NUM NOT NUMERIC                            
T30491           DISPLAY ' '                                            
T30491           DISPLAY '**  PCSCA608 PROCESSING ERROR  **'            
T30491           DISPLAY '**    COMMIT PARM NOT NUMERIC'                
T30491           DISPLAY '**    KEY = ' WS-INPUT-KEY                    
T30491           DISPLAY '**  PROCESSING TERMINATED  **'                
T30491           PERFORM 7611-CLOSE THRU 7611-EXIT                      
T30491           PERFORM 9900-ABEND  THRU  9900-EXIT                    
T30491        WHEN WS-COMMIT-NUM NUMERIC                                
T30491           DISPLAY ' '                                            
T30491           DISPLAY '**  PCSCA608 PROCESSING INFO  **'             
T30491           MOVE WS-COMMIT-NUM      TO WS-COMMIT-COUNT             
T30491           DISPLAY '** COMMIT LIMIT IS ' WS-COMMIT-COUNT          
T30491           PERFORM 7611-CLOSE THRU 7611-EXIT                      
T30491     END-EVALUATE.                                                
      *                                                                         
T30491 0120-EXIT.                                                       
T30491     EXIT.                                                        
      *                                                                         
      ****************************************************************          
C35005**  0125-GET-PARM-HANDLG                                       *          
      ****************************************************************          
      *                                                                         
C35005 0125-GET-PARM-HANDLG.                                            
      *                                                                         
C35005     MOVE SPACES                 TO WS-SYSIPT.                    
C35005     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
C35005     MOVE WS-PARM                TO WS-COMMAND.                   
C35005     MOVE ZEROS                  TO WS-SEQUENCE.                  
C35005                                                                  
C35005     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
C35005                                                                  
C35005     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
C35005       UNTIL ( WS-INPUT-DATA-BREAKDOWN(1:12) = WS-PARM-HANDLE     
C35005              AND INPUT-ACTIVE ) OR  END-OF-SYSIPT.               
C35005                                                                  
C35005     IF END-OF-SYSIPT                                             
C35005        MOVE SPACES              TO WS-C190-TEMP-PULL-CD          
C35005                                    WS-C190-EXEMPT-FL             
C35005                                    WS-C190-BILL-CORRECTED-CD     
C35005     ELSE                                                         
C35005        IF G6-PARM-DATA(14:1) > SPACES                            
C35005           MOVE G6-PARM-DATA(14:1) TO WS-C190-TEMP-PULL-CD        
C35005        END-IF                                                    
C35005        IF G6-PARM-DATA(26:1) > SPACES                            
C35005           MOVE G6-PARM-DATA(26:1) TO WS-C190-EXEMPT-FL           
C35005        END-IF                                                    
C35005        IF G6-PARM-DATA(41:1) > SPACES                            
C35005           MOVE G6-PARM-DATA(41:1) TO WS-C190-BILL-CORRECTED-CD   
C35005        END-IF                                                    
C35005     END-IF.                                                      
C35005                                                                  
C35005     PERFORM 7611-CLOSE          THRU 7611-EXIT.                  
      *                                                                         
C35005 0125-EXIT.                                                       
C35005     EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  PROCESS THE RECONCILIATION OR PRODUCE ERROR REPORT       **           
      ***************************************************************           
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
A00303     IF FILE-INPUT                                                
              PERFORM 2600-MASS-CANCEL-REBILL    THRU 2600-EXIT         
           ELSE                                                         
              PERFORM 7010-OPEN-CIG-CRSR         THRU 7010-EXIT         
              PERFORM 7020-FETCH-UTIL-CIG-CRSR   THRU 7020-EXIT         
              PERFORM 2000-PROCESS-RECORDS       THRU 2000-EXIT         
                      UNTIL END-OF-CIG-CRSR                             
              PERFORM 7030-CLOSE-CIG-CRSR        THRU 7030-EXIT         
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2000-PROCESS-RECORDS.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO       TO BG-ACCOUNT-NO.                   
           MOVE IN-REVENUE-MONTH    TO BG-REVENUE-MONTH.                
      *                                                                         
A00303     MOVE 'N' TO WS-BG-SW.                                        
A00303     MOVE 'Y' TO WS-7119-FIRST-SW.                                
      *                                                                         
A00303     PERFORM 7118-OPEN-BG-CRSR THRU 7118-EXIT.                    
      *                                                                         
A00303     PERFORM 7119-FETCH-BG-CRSR THRU 7119-EXIT.                   
      *                                                                         
A00303     PERFORM UNTIL WS-BG-SW = 'Y'                                 
A00303          MOVE 'N' TO WS-7119-FIRST-SW                            
      *                                                                         
A00303          IF AT-CODE-ACCT-STAT = 'A' OR 'B'                       
                   PERFORM 2100-CANCEL-REBILL THRU 2100-EXIT            
A00303          ELSE                                                    
A00303             MOVE WS-NON-ACTIVE TO WS-COMMENTS                    
A00303             PERFORM 3001-ERROR-REPORT THRU 3001-EXIT             
A00303          END-IF                                                  
      *                                                                         
A00303          PERFORM 7119-FETCH-BG-CRSR THRU 7119-EXIT               
      *                                                                         
A00303     END-PERFORM.                                                 
      *                                                                         
A00303     IF FILE-INPUT                                                
A00303        IF WS-7119-FIRST-SW = 'Y'                                 
A00303           MOVE WS-MSG-NOT-FOUND TO WS-COMMENTS                   
A00303           PERFORM 3001-ERROR-REPORT THRU 3001-EXIT               
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
A00303     PERFORM 7120-CLOSE-BG-CRSR THRU 7120-EXIT.                   
      *                                                                         
T30491     IF WS-RECORD-COUNT >= WS-COMMIT-COUNT                        
T30491        EXEC SQL                                                  
T30491           COMMIT                                                 
T30491        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30491        ADD 1 TO WS-CHKP-SEQ-NO                                   
T30491        DISPLAY '***'                                             
T30491        DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
T30491        DISPLAY '# OF RECORDS PROCESSED ' WS-RECORD-COUNT         
T30491        DISPLAY '***'                                             
T30491        INITIALIZE WS-RECORD-COUNT                                
T30491     END-IF.                                                      
      *                                                                         
           IF FILE-INPUT                                                
A00303        CONTINUE                                                  
           ELSE                                                         
              PERFORM 7020-FETCH-UTIL-CIG-CRSR THRU 7020-EXIT           
A00303        SET NOT-FOUND-TRNS-ROW   TO TRUE                          
A00303        SET NOT-FOUND-COGBR-FACT TO TRUE                          
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    CALL SUBROUTINE CPDCA190 TO CANCEL REBILL SELECTED BG     *          
      ****************************************************************          
      *                                                                         
       2100-CANCEL-REBILL.                                              
      *                                                                         
           EVALUATE IN-CHANGE-TYPE                                      
              WHEN 'B'                                                  
                 PERFORM 2200-BTU-FACTOR-CHANGE  THRU 2200-EXIT         
              WHEN 'T'                                                  
                 PERFORM 2500-TRNSP-BUY-BCK-PRC  THRU 2500-EXIT         
C29397        WHEN 'C'                                                  
C29397           PERFORM 2550-COG-FACTOR-ADJ     THRU 2550-EXIT         
              WHEN 'F'                                                  
                 PERFORM 2700-MASS-CANCEL-REBILL THRU 2700-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    PERFORM A CANCEL REBILL FOR A BTU FACTOR CHANGE           *          
      ****************************************************************          
      *                                                                         
       2200-BTU-FACTOR-CHANGE.                                          
      *                                                                         
           PERFORM 7100-CHK-BTU-FACTOR THRU 7100-EXIT.                  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00303        ADD +1 TO WS-TOTAL-THAT-SHOULD-BE-THERE                   
              MOVE BG-ACCOUNT-NO        TO WS-C190-ACCOUNT-NO           
              MOVE BG-CODE-UTIL-TYPE    TO WS-C190-CODE-UTIL-TYPE       
              MOVE BG-BILL-NO           TO WS-C190-BILL-NO              
              MOVE BG-IC-NO             TO WS-C190-IC-NO                
              MOVE IN-BILL-WHEN         TO WS-C190-BILL-TYPE            
              MOVE IN-ADJ-REASN-CODE    TO WS-C190-ADJ-REASN-CODE       
              MOVE 'B'                  TO WS-C190-CALL-FLAG            
              MOVE 'G'                  TO WS-C190-CUSTOMER-FL          
JSFIX         MOVE IN-REVENUE-MONTH     TO WS-C190-REVENUE-MONTH        
      *                                                                         
A00303        IF AT-CODE-ACCT-STAT = 'B'                                
A00303           MOVE 'I' TO WS-C190-BILL-TYPE                          
A00303        END-IF                                                    
      *                                                                         
              CALL SCSCA190 USING CWSCA190-FIELDS,                      
                                  ABEND-FILE,                           
                                     RS-RETURN-CODE                     
      *                                                                         
              IF ABEND-FUNCTION > SPACES                                
A00303           MOVE '2200' TO WS-MSG-SCSCA190-REVIEW                  
A00303           PERFORM 8810-EXCEPTIONS THRU 8810-EXIT                 
              ELSE                                                      
                 MOVE 'CANCEL REBILL SUCCESSFUL '  TO WS-COMMENTS       
C35005           IF WS-C190-ACCOUNT-NO NOT EQUAL WS-ACCT-NO-PREV        
C35005              MOVE WS-C190-ACCOUNT-NO TO WS-ACCT-NO-PREV          
C35005              DISPLAY 'CANCEL/REBILL ACCOUNT : ' AT-ACCOUNT-NO    
A00303              ADD 1  TO WS-TOTAL-RECORD-CNT                       
T30491              ADD 1  TO WS-RECORD-COUNT                           
C35005           END-IF                                                 
                 PERFORM 3000-CONTROL-REPORT THRU 3000-EXIT             
              END-IF                                                    
A00303     ELSE                                                         
              DISPLAY '**  2200-BTU-FACTOR-CHANGE ** ACCT = '           
              BG-ACCOUNT-NO ' BILL-NO = ' BG-BILL-NO ' TYPE = '         
              BG-CODE-UTIL-TYPE ' IC-NO = ' BG-IC-NO ' TIMESTAMP = '    
              BG-BILL-ITEM-TIMESTMP                                     
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    PERFORM A CANCEL REBILL FOR A TRANSPORTATION BUY BACK     *          
      *    PRICE CHANGE                                              *          
      ****************************************************************          
      *                                                                         
       2500-TRNSP-BUY-BCK-PRC.                                          
      *                                                                         
A00303     IF NOT-FOUND-TRNS-ROW                                        
A00303        AND BG-ACCOUNT-NO NOT = WS-ACCT-NO-PREV                   
                PERFORM 7300-CHK-TRNSP-BG THRU 7300-EXIT                
A00303          IF SQLCODE = 100                                        
A00303             MOVE BG-ACCOUNT-NO TO WS-ACCT-NO-PREV                
A00303          END-IF                                                  
A00303     END-IF.                                                      
      *                                                                         
A00303     IF FOUND-TRNS-ROW                                            
A00303        ADD +1 TO WS-TOTAL-THAT-SHOULD-BE-THERE                   
              MOVE BG-ACCOUNT-NO        TO WS-C190-ACCOUNT-NO           
              MOVE BG-CODE-UTIL-TYPE    TO WS-C190-CODE-UTIL-TYPE       
              MOVE BG-BILL-NO           TO WS-C190-BILL-NO              
              MOVE BG-IC-NO             TO WS-C190-IC-NO                
              MOVE IN-BILL-WHEN         TO WS-C190-BILL-TYPE            
              MOVE IN-ADJ-REASN-CODE    TO WS-C190-ADJ-REASN-CODE       
              MOVE 'B'                  TO WS-C190-CALL-FLAG            
              MOVE 'G'                  TO WS-C190-CUSTOMER-FL          
JSFIX         MOVE IN-REVENUE-MONTH     TO WS-C190-REVENUE-MONTH        
      *                                                                         
A00303        IF AT-CODE-ACCT-STAT = 'B'                                
A00303           MOVE 'I' TO WS-C190-BILL-TYPE                          
A00303        END-IF                                                    
      *                                                                         
              CALL SCSCA190 USING CWSCA190-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE                        
                                                                        
              IF ABEND-FUNCTION > SPACES                                
A00303           MOVE '2500' TO WS-MSG-SCSCA190-REVIEW                  
A00303           PERFORM 8810-EXCEPTIONS THRU 8810-EXIT                 
              ELSE                                                      
                 MOVE 'CANCEL REBILL SUCCESSFUL '  TO WS-COMMENTS       
C35005           IF WS-C190-ACCOUNT-NO NOT EQUAL WS-ACCT-NO-PREV        
C35005              MOVE WS-C190-ACCOUNT-NO  TO WS-ACCT-NO-PREV         
C35005              DISPLAY 'CANCEL/REBILL ACCOUNT : ' AT-ACCOUNT-NO    
A00303              ADD 1 TO WS-TOTAL-RECORD-CNT                        
T30491              ADD 1 TO WS-RECORD-COUNT                            
C35005           END-IF                                                 
                 PERFORM 3000-CONTROL-REPORT THRU 3000-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
START *    PERFORM A CANCEL REBILL FOR COST OF GAS FACTOR ADJUSTMENT *          
      ****************************************************************          
      *                                                                         
       2550-COG-FACTOR-ADJ.                                             
      *                                                                         
A00303     IF NOT-FOUND-COGBR-FACT                                      
A00303        AND BG-ACCOUNT-NO NOT = WS-ACCT-NO-PREV                   
              PERFORM 7350-CHK-COGBR-FACT     THRU 7350-EXIT            
A00303        IF SQLCODE = 100                                          
A00303           MOVE BG-ACCOUNT-NO TO WS-ACCT-NO-PREV                  
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
A00303     IF FOUND-COGBR-FACT                                          
30924         ADD +1 TO WS-TOTAL-THAT-SHOULD-BE-THERE                   
              MOVE BG-ACCOUNT-NO        TO WS-C190-ACCOUNT-NO           
              MOVE BG-CODE-UTIL-TYPE    TO WS-C190-CODE-UTIL-TYPE       
              MOVE BG-BILL-NO           TO WS-C190-BILL-NO              
              MOVE BG-IC-NO             TO WS-C190-IC-NO                
              MOVE IN-BILL-WHEN         TO WS-C190-BILL-TYPE            
              MOVE IN-ADJ-REASN-CODE    TO WS-C190-ADJ-REASN-CODE       
              MOVE 'B'                  TO WS-C190-CALL-FLAG            
              MOVE 'G'                  TO WS-C190-CUSTOMER-FL          
JSFIX         MOVE IN-REVENUE-MONTH     TO WS-C190-REVENUE-MONTH        
      *                                                                         
A00303        IF AT-CODE-ACCT-STAT = 'B'                                
A00303           MOVE 'I' TO WS-C190-BILL-TYPE                          
A00303        END-IF                                                    
      *                                                                         
              CALL SCSCA190 USING CWSCA190-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE                        
                                                                        
              IF ABEND-FUNCTION > SPACES                                
A00303           MOVE '2550' TO WS-MSG-SCSCA190-REVIEW                  
A00303           PERFORM 8810-EXCEPTIONS THRU 8810-EXIT                 
              ELSE                                                      
                 MOVE 'CANCEL REBILL SUCCESSFUL '  TO WS-COMMENTS       
C35005           IF WS-C190-ACCOUNT-NO NOT EQUAL WS-ACCT-NO-PREV        
C35005              MOVE WS-C190-ACCOUNT-NO  TO WS-ACCT-NO-PREV         
C35005              DISPLAY 'CANCEL/REBILL ACCOUNT : ' AT-ACCOUNT-NO    
A00303              ADD 1 TO WS-TOTAL-RECORD-CNT                        
T30491              ADD 1 TO WS-RECORD-COUNT                            
C35005           END-IF                                                 
                 PERFORM 3000-CONTROL-REPORT THRU 3000-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2550-EXIT.                                                       
C29397     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    PERFORM A CANCEL REBILL FOR A LIST OF ACCOUNTS PROVIDED   *          
      *    IN A INPUT FILE                                           *          
      ****************************************************************          
      *                                                                         
       2600-MASS-CANCEL-REBILL.                                         
      *                                                                         
           PERFORM 2610-OPEN-INPUT-FILE     THRU 2610-EXIT.             
      *                                                                         
           PERFORM 2620-READ-INPUT-FILE     THRU 2620-EXIT.             
      *                                                                         
           PERFORM 2630-CANCEL-REBILL-ACCT  THRU 2630-EXIT              
                   UNTIL END-OF-INPUT.                                  
      *                                                                         
           CLOSE FCSCA608-FILE.                                         
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    OPEN INPUT FILE                                             *        
      ******************************************************************        
      *                                                                         
       2610-OPEN-INPUT-FILE.                                            
      *                                                                         
           OPEN INPUT FCSCA608-FILE.                                    
      *                                                                         
           IF E-FCSCA608-SUCCESSFUL                                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA608 PROCESSING ERROR        **'        
               DISPLAY '**  OPEN ERROR OF FCSCA608   FILE      **'      
               DISPLAY '**  FILE STATUS = ' WS-FCSCA608-STATUS          
               DISPLAY '**  PROCESSING TERMINATED            **'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    READ INPUT FILE                                           *          
      ****************************************************************          
      *                                                                         
       2620-READ-INPUT-FILE.                                            
      *                                                                         
           READ FCSCA608-FILE                                           
              AT END                                                    
                 MOVE WS-Y TO WS-FCSCA608-EOF-SW                        
                 GO TO 2620-EXIT.                                       
      *                                                                         
           IF E-FCSCA608-SUCCESSFUL                                     
30924         ADD +1 TO WS-TOTAL-THAT-SHOULD-BE-THERE                   
              ADD 1              TO WS-INPUT-RECS-READ                  
           ELSE                                                         
              DISPLAY '  '                                              
              DISPLAY '2620 ERROR ON FCSCA608 READ.  STATUS IS '        
                       WS-FCSCA608-STATUS                               
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    FOR EACH ACCOUNT READ FROM THE INPUT FILE DO A CANCEL     *          
      *    REBILL                                                    *          
      ****************************************************************          
      *                                                                         
       2630-CANCEL-REBILL-ACCT.                                         
      *                                                                         
           MOVE E-FCSCA608-ACCOUNT-NO      TO WS-C190-ACCOUNT-NO        
                                              AT-ACCOUNT-NO.            
           MOVE IN-REVENUE-MONTH           TO BG-REVENUE-MONTH.         
           MOVE SPACES                     TO WS-CIG-CUSTOMER.          
           MOVE 'N'                        TO WS-FIRST-UT-FETCH.        
      *                                                                         
           PERFORM 7220-SELECT-ACCOUNT-DATA THRU 7220-EXIT.             
      *                                                                         
A00303     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00303        MOVE 'N' TO WS-CIG-CUSTOMER                               
A00303        MOVE 'Y' TO WS-FIRST-UT-FETCH                             
A00303        PERFORM 7225-CHECK-CIG-CUST THRU 7225-EXIT                
A00303        IF AT-CODE-ACCT-STAT = 'A' OR 'B'                         
                 PERFORM 2000-PROCESS-RECORDS THRU 2000-EXIT            
A00303        ELSE                                                      
A00303           MOVE E-FCSCA608-ACCOUNT-NO TO BG-ACCOUNT-NO            
A00303           MOVE WS-NON-ACTIVE TO WS-COMMENTS                      
A00303           PERFORM 3001-ERROR-REPORT THRU 3001-EXIT               
A00303        END-IF                                                    
A00303     ELSE                                                         
A00303        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00303           IF WS-FIRST-UT-FETCH = 'N'                             
A00303              MOVE E-FCSCA608-ACCOUNT-NO TO BG-ACCOUNT-NO         
A00303              MOVE WS-NOT-VALID TO WS-COMMENTS                    
A00303              PERFORM 3001-ERROR-REPORT THRU 3001-EXIT            
A00303           END-IF                                                 
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
           PERFORM 2620-READ-INPUT-FILE THRU 2620-EXIT.                 
      *                                                                         
       2630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    PERFORM A CANCEL REBILL FOR ACCOUNTS FROM INPUT FILE      *          
      ****************************************************************          
      *                                                                         
       2700-MASS-CANCEL-REBILL.                                         
      *                                                                         
           MOVE BG-ACCOUNT-NO           TO WS-C190-ACCOUNT-NO.          
           MOVE BG-CODE-UTIL-TYPE       TO WS-C190-CODE-UTIL-TYPE.      
           MOVE BG-BILL-NO              TO WS-C190-BILL-NO.             
           MOVE BG-IC-NO                TO WS-C190-IC-NO.               
           MOVE IN-BILL-WHEN            TO WS-C190-BILL-TYPE.           
           MOVE IN-ADJ-REASN-CODE       TO WS-C190-ADJ-REASN-CODE.      
           MOVE 'B'                     TO WS-C190-CALL-FLAG.           
           IF WS-CIG-CUSTOMER = 'Y'                                     
              MOVE 'G'                  TO WS-C190-CUSTOMER-FL          
           ELSE                                                         
              MOVE SPACES               TO WS-C190-CUSTOMER-FL          
           END-IF.                                                      
JSFIX      MOVE IN-REVENUE-MONTH        TO WS-C190-REVENUE-MONTH.       
      *                                                                         
A00303     IF AT-CODE-ACCT-STAT = 'B'                                   
A00303        MOVE 'I' TO WS-C190-BILL-TYPE                             
A00303     END-IF.                                                      
      *                                                                         
           CALL SCSCA190 USING CWSCA190-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
      *                                                                         
           IF ABEND-FUNCTION > SPACES                                   
A00303        MOVE '2700' TO WS-MSG-SCSCA190-REVIEW                     
A00303        PERFORM 8810-EXCEPTIONS THRU 8810-EXIT                    
           ELSE                                                         
              MOVE 'CANCEL REBILL SUCCESSFUL '     TO WS-COMMENTS       
C35005        IF WS-C190-ACCOUNT-NO NOT EQUAL WS-ACCT-NO-PREV           
C35005           MOVE WS-C190-ACCOUNT-NO  TO WS-ACCT-NO-PREV            
C35005           DISPLAY 'CANCEL/REBILL ACCOUNT : ' AT-ACCOUNT-NO       
A00303           ADD 1 TO WS-TOTAL-RECORD-CNT                           
A00303           ADD 1 TO WS-RECORD-COUNT                               
C35005        END-IF                                                    
              PERFORM 3000-CONTROL-REPORT THRU 3000-EXIT                
A00303     END-IF.                                                      
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    CONTROL REPORT FOR THE PROCESS                            *          
      ****************************************************************          
      *                                                                         
       3000-CONTROL-REPORT.                                             
      *                                                                         
A00303     IF WS-PRT-NODATA = 'Y'                                       
A00303        PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
A00303        MOVE 'N'      TO WS-PRT-NODATA                            
A00303     END-IF.                                                      
      *                                                                         
A00303     IF AT-CODE-ACCT-STAT = 'A'                                   
A00303        MOVE WS-ACT TO P-STATUS                                   
A00303     ELSE                                                         
A00303        IF AT-CODE-ACCT-STAT = 'B'                                
A00303           MOVE WS-FIN TO P-STATUS                                
A00303        ELSE                                                      
A00303           MOVE WS-OTH TO P-STATUS                                
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
           MOVE BG-ACCOUNT-NO            TO P-ACCOUNT-NO.               
           MOVE BG-BILL-NO               TO P-BILL-NO.                  
           MOVE BG-IC-NO                 TO P-IC-NO.                    
           MOVE BG-CODE-UTIL-TYPE        TO P-CODE-UTIL-TYPE.           
           MOVE WS-COMMENTS              TO P-COMMENTS.                 
      *                                                                         
           PERFORM 8300-PRINT-RPT-REPORT THRU 8300-EXIT.                
A00303     INITIALIZE WS-DETAIL-LINE.                                   
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00303****************************************************************          
A00303*    ERROR REPORT FOR THE PROCESS                              *          
A00303****************************************************************          
      *                                                                         
A00303 3001-ERROR-REPORT.                                               
      *                                                                         
A00303     IF WS-PRT2-LINE-COUNT > +58                                  
A00303        PERFORM 8551-PRT2-HEADERS THRU 8551-EXIT                  
A00303        MOVE 'N'      TO WS-PRT2-NODATA                           
A00303     END-IF.                                                      
      *                                                                         
A00303     IF WS-ERROR-ACCOUNT = BG-ACCOUNT-NO                          
A00303        CONTINUE                                                  
A00303     ELSE                                                         
A00303        MOVE BG-ACCOUNT-NO TO PRT2-ACCOUNT-NO                     
A00303        IF AT-CODE-ACCT-STAT = 'A'                                
A00303           MOVE WS-ACT TO PRT2-STATUS                             
A00303        ELSE                                                      
A00303           IF AT-CODE-ACCT-STAT = 'B'                             
A00303              MOVE WS-FIN TO PRT2-STATUS                          
A00303           ELSE                                                   
A00303              MOVE WS-OTH TO PRT2-STATUS                          
A00303           END-IF                                                 
A00303        END-IF                                                    
A00303        MOVE BG-BILL-NO        TO PRT2-BILL-NO                    
A00303        MOVE BG-IC-NO          TO PRT2-IC-NO                      
A00303        MOVE BG-CODE-UTIL-TYPE TO PRT2-CODE-UTIL-TYPE             
A00303        MOVE WS-COMMENTS       TO PRT2-COMMENTS                   
      *                                                                         
A00303        MOVE WS-PRT2-LINE TO PRT331-RECORD                        
A00303        PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT            
A00303        INITIALIZE WS-PRT2-LINE                                   
A00303        ADD +1 TO WS-PRT2-LINE-COUNT                              
A00303        ADD +1 TO WS-ERROR-COUNT                                  
A00303        MOVE BG-ACCOUNT-NO TO WS-ERROR-ACCOUNT                    
A00303     END-IF.                                                      
      *                                                                         
       3001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *       6240-GET-FCA00-COMMON-DATE                             *          
      ****************************************************************          
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ****************************************************************          
      *       6251-GET-FJC01-DATE                                    *          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      **  IDENTIFY CIG CUSTOMERS FOR CANCEL REBILL                  **          
      ****************************************************************          
      *                                                                         
       7010-OPEN-CIG-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               OPEN CIG_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA608 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7010       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    FETCH FOR CIG_CRSR                                      **          
      ****************************************************************          
      *                                                                         
       7020-FETCH-UTIL-CIG-CRSR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH CIG_CRSR                                            
A00303         INTO :AT-ACCOUNT-NO                                      
A00303             ,:AT-CODE-ACCT-STAT                                  
A00303             ,:AT-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET END-OF-CIG-CRSR      TO TRUE                       
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA608 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7020       **'     
                 DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE   
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    CLOSE FOR CIG_CRSR                                      **          
      ****************************************************************          
      *                                                                         
       7030-CLOSE-CIG-CRSR.                                             
      *                                                                         
           EXEC SQL                                                     
               CLOSE CIG_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA608 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7030       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *     THIS MODULE CHECKS IF THE BTU FACTOR TABLE ID OF THE BG  *          
      *     IS SAME AS THAT OF THE PARM BTU FACTOR ID                *          
      ****************************************************************          
      *                                                                         
       7100-CHK-BTU-FACTOR.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO,
              IC_NO                                             
                 INTO :GA-ACCOUNT-NO                                    
                     ,:GA-IC-NO                                         
                 FROM CSS_MTR_IDENT_HIST WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO               
                  AND BILL_NO            = :BG-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE           
                  AND IC_NO              = :BG-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )       
                  AND INDUST_BTU_ID      = :IN-BTU-FACTOR               
A00303                                       
A00303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*              ,IC_NO                                                     
MFA-TR*          INTO :GA-ACCOUNT-NO                                            
MFA-TR*              ,:GA-IC-NO                                                 
MFA-TR*          FROM CSS_MTR_IDENT_HIST                                        
MFA-TR*         WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :BG-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :BG-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP               
MFA-TR*           AND INDUST_BTU_ID      = :IN-BTU-FACTOR                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '7100-CHK-BTU-FACTOR'                             
              DISPLAY 'SQLCODE = ', WS-ACTIVE-RETURN-CODE               
              DISPLAY 'ACCOUNT NO = ', BG-ACCOUNT-NO                    
              DISPLAY 'BILL NO    = ', BG-BILL-NO                       
              DISPLAY 'BILL TIMESTMP', BG-BILL-ITEM-TIMESTMP            
              DISPLAY 'BTU FACTOR ID', IN-BTU-FACTOR                    
              PERFORM 9900-ABEND         THRU  9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    OPEN BILLNG_DET CURSOR                                  **          
      ****************************************************************          
      *                                                                         
       7118-OPEN-BG-CRSR.                                               
      *                                                                         
           EXEC SQL                                                     
               OPEN BG_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** PCSCA608 PROCESSING ERROR             **'    
               DISPLAY '** ABEND IN PARAGRAPH 7118-OPEN-BG-CRSR  **'    
               DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
A00303         DISPLAY '* BG-ACCOUNT-NO  = ' BG-ACCOUNT-NO              
A00303         DISPLAY '* WS-CODE-UTIL-1 = ' WS-CODE-UTIL-1             
A00303         DISPLAY '* WS-CODE-UTIL-2 = ' WS-CODE-UTIL-2             
A00303         DISPLAY '* WS-CODE-UTIL-3 = ' WS-CODE-UTIL-3             
A00303         DISPLAY '* BG-REVENUE-MONTH = ' BG-REVENUE-MONTH         
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7118-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *    GET ALL OF THE CORRECT BG ROWS FOR THE REVENUE PERIOD     *          
      ****************************************************************          
      *                                                                         
A00303 7119-FETCH-BG-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH BG_CRSR                                             
A00303          INTO  :BG-ACCOUNT-NO                                    
A00303               ,:BG-REVENUE-MONTH                                 
A00303               ,:BG-BILL-NO                                       
A00303               ,:BG-BILL-ITEM-TIMESTMP                            
A00303               ,:BG-CODE-BILL-ITM-IND                             
A00303               ,:BG-PRORATE-CD                                    
A00303               ,:BG-CODE-UTIL-TYPE                                
A00303               ,:BG-IC-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A00303     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A00303     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00303        CONTINUE                                                  
A00303     ELSE                                                         
A00303        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A00303           MOVE 'Y' TO WS-BG-SW                                   
A00303        ELSE                                                      
A00303           DISPLAY '********** PCSCA608 ABORT ************'       
A00303           DISPLAY '* 7119-FETCH-BG-CRSR                 *'       
A00303           DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE         
A00303           DISPLAY '* PROGRAM ABORTING...                *'       
A00303           DISPLAY '* BG-ACCOUNT-NO  = ' BG-ACCOUNT-NO            
A00303           DISPLAY '* WS-CODE-UTIL-1 = ' WS-CODE-UTIL-1           
A00303           DISPLAY '* WS-CODE-UTIL-2 = ' WS-CODE-UTIL-2           
A00303           DISPLAY '* WS-CODE-UTIL-3 = ' WS-CODE-UTIL-3           
A00303           DISPLAY '* BG-REVENUE-MONTH = ' BG-REVENUE-MONTH       
A00303           DISPLAY '********** PCSCA608 ABORT ************'       
A00303           PERFORM 9900-ABEND THRU 9900-EXIT                      
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
A00303 7119-EXIT.                                                       
A00303     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **    CLOSE BILLNG_DET CURSOR                                 **          
      ****************************************************************          
      *                                                                         
       7120-CLOSE-BG-CRSR.                                              
      *                                                                         
           EXEC SQL                                                     
               CLOSE BG_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** PCSCA608 PROCESSING ERROR             **'    
               DISPLAY '** ABEND IN PARAGRAPH 7120-CLOSE-BG-CRSR **'    
               DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *     INPUT FILE PROCESS ONLY WILL USE THIS PARAGRAPH          *          
      *     CHECK TO SEE IF ACCOUNT IS VALID                         *          
      ****************************************************************          
      *                                                                         
       7220-SELECT-ACCOUNT-DATA.                                        
      *                                                                         
A00303     EXEC SQL                                                     
A00303        SELECT AT.CODE_ACCT_STAT                                  
A00303              ,AT.CUSTOMER_NO                                     
A00303         INTO :AT-CODE-ACCT-STAT                                  
A00303             ,:AT-CUSTOMER-NO                                     
A00303          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
A00303         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
A00303                                                           
A00303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*        INTO :AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-CUSTOMER-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7220                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00303        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA608 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7220       **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *     INPUT FILE PROCESS ONLY WILL USE THIS PARAGRAPH          *          
      *     CHECK TO SEE IF ACCOUNT IS A CIG ACCOUNT                 *          
      ****************************************************************          
      *                                                                         
       7225-CHECK-CIG-CUST.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CIG-CUSTOMER                                   
                FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                 
A00303              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
A00303         WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                 AND UT.CODE_UTIL_TYPE  = 'G'                           
                 AND UT.CODE_UTIL_TYPE  = J1.CODE_UTIL_TYPE             
                 AND UT.RATE_PLAN_NO    = J1.RATE_PLAN_NO               
                 AND J1.REG_TYPE_CD     = 'D'                           
A00303        ORDER BY VERSION_NO_CNTRL DESC                            
A00303                                       
A00303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CIG-CUSTOMER                                           
MFA-TR*         FROM CSS_RATE_COMP_DEF J1                                       
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE  = 'G'                                   
MFA-TR*          AND UT.CODE_UTIL_TYPE  = J1.CODE_UTIL_TYPE                     
MFA-TR*          AND UT.RATE_PLAN_NO    = J1.RATE_PLAN_NO                       
MFA-TR*          AND J1.REG_TYPE_CD     = 'D'                                   
MFA-TR*       ORDER BY VERSION_NO_CNTRL DESC                                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7225                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA608 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7225       **'       
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** SQLCODE    = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  NEED TO CANCEL/REBILL ALL EVEN IF YOU FIND ONE ROW        **          
      ****************************************************************          
      *                                                                         
A00303 7300-CHK-TRNSP-BG.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-FOUND-TRNS-ROW                                
                 FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                
                    , CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND ((BG.REV_MTH_ORIG_BILL = 0                        
                        AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)       
                                OR                                      
                      (BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH         
                       AND BG.REVENUE_MONTH > 0))                       
                  AND BG.CODE_BILL_CALC     =  'A'                      
                  AND BG.CODE_BILL_ITM_TYPE =  'C'                      
                  AND BG.CODE_BILL_ITM_IND  =  'A'                      
                  AND BG.ACCOUNT_NO         = BZ.ACCOUNT_NO             
                  AND BG.BILL_NO            = BZ.BILL_NO                
                  AND BG.CODE_UTIL_TYPE     = BZ.CODE_UTIL_TYPE         
                  AND BG.IC_NO              = BZ.IC_NO                  
                  AND BG.BILL_ITEM_TIMESTMP = BZ.BILL_ITEM_TIMESTMP     
                  AND CMPNT_ID_CD        IN ('70','71')                 
                                             
A00303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-FOUND-TRNS-ROW                                        
MFA-TR*          FROM CSS_BILL_CALC_DET BZ                                      
MFA-TR*             , CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND ((BG.REV_MTH_ORIG_BILL = 0                                
MFA-TR*                 AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)               
MFA-TR*                         OR                                              
MFA-TR*               (BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH                 
MFA-TR*                AND BG.REVENUE_MONTH > 0))                               
MFA-TR*           AND BG.CODE_BILL_CALC     =  'A'                              
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE =  'C'                              
MFA-TR*           AND BG.CODE_BILL_ITM_IND  =  'A'                              
MFA-TR*           AND BG.ACCOUNT_NO         = BZ.ACCOUNT_NO                     
MFA-TR*           AND BG.BILL_NO            = BZ.BILL_NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     = BZ.CODE_UTIL_TYPE                 
MFA-TR*           AND BG.IC_NO              = BZ.IC_NO                          
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP = BZ.BILL_ITEM_TIMESTMP             
MFA-TR*           AND CMPNT_ID_CD        IN ('70','71')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA608 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**     ACCOUNT NO =  ' BG-ACCOUNT-NO            
               DISPLAY '**        BILL NO = ' BG-BILL-NO                
               DISPLAY '**          IC NO = ' BG-IC-NO                  
               DISPLAY '** BILL ITEM STMP = ' BZ-BILL-ITEM-TIMESTMP     
               DISPLAY '**      SQLCODE   = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C29397****************************************************************          
      **  NEED TO CANCEL/REBILL ALL EVEN IF YOU FIND ONE ROW        **          
      ****************************************************************          
      *                                                                         
A00303 7350-CHK-COGBR-FACT.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-FOUND-COGBR-FACT                              
                 FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                     ,CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)               
                WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.BILL_NO            = :BG-BILL-NO               
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND ((BG.REV_MTH_ORIG_BILL = 0                        
                        AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)       
                                OR                                      
                      (BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH         
                       AND BG.REVENUE_MONTH > 0))                       
                  AND BG.CODE_BILL_CALC     =  'A'                      
                  AND BG.CODE_BILL_ITM_TYPE =  'C'                      
                  AND BG.CODE_BILL_ITM_IND  =  'A'                      
                  AND BG.ACCOUNT_NO         = FH.ACCOUNT_NO             
                  AND BG.BILL_NO            = FH.BILL_NO                
                  AND BG.CODE_UTIL_TYPE     = FH.CODE_UTIL_TYPE         
                  AND BG.IC_NO              = FH.IC_NO                  
                  AND BG.BILL_ITEM_TIMESTMP = FH.BILL_ITEM_TIMESTMP     
                  AND FH.FACTOR_ID          = 'COG BR'                  
                                             
A00303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-FOUND-COGBR-FACT                                      
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*              ,CSS_FIXED_FCT_HIST FH                                     
MFA-TR*         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.BILL_NO            = :BG-BILL-NO                       
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND ((BG.REV_MTH_ORIG_BILL = 0                                
MFA-TR*                 AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)               
MFA-TR*                         OR                                              
MFA-TR*               (BG.REV_MTH_ORIG_BILL = :BG-REVENUE-MONTH                 
MFA-TR*                AND BG.REVENUE_MONTH > 0))                               
MFA-TR*           AND BG.CODE_BILL_CALC     =  'A'                              
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE =  'C'                              
MFA-TR*           AND BG.CODE_BILL_ITM_IND  =  'A'                              
MFA-TR*           AND BG.ACCOUNT_NO         = FH.ACCOUNT_NO                     
MFA-TR*           AND BG.BILL_NO            = FH.BILL_NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     = FH.CODE_UTIL_TYPE                 
MFA-TR*           AND BG.IC_NO              = FH.IC_NO                          
MFA-TR*           AND BG.BILL_ITEM_TIMESTMP = FH.BILL_ITEM_TIMESTMP             
MFA-TR*           AND FH.FACTOR_ID          = 'COG BR'                          
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*           QUERYNO 7350                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA608 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7200       **'        
              DISPLAY '**         ACCOUNT NO = ' BG-ACCOUNT-NO          
              DISPLAY '**            BILL NO = ' BG-BILL-NO             
              DISPLAY '**              IC NO = ' BG-IC-NO               
              DISPLAY '**     CODE-UTIL-TYPE = ' BG-CODE-UTIL-TYPE      
              DISPLAY '** BILL-ITEM-TIMESTMP = ' BG-BILL-ITEM-TIMESTMP  
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
C29397     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    7600-START-FCSJC01.                                                  
      *    7610-READ-FCSJC01.                                                   
      *    7611-CLOSE.                                                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    7620-START-FCSCA00.                                                  
      *    7621-READ-FCSCA00.                                                   
      *    7622-CLOSE-CA00-CSR.                                                 
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
A00303****************************************************************          
A00303**   FETCHES THE COMPANY NAME.                                **          
A00303****************************************************************          
      *                                                                         
A00303 7810-GET-COMPANY-DESCRIPTION.                                    
      *                                                                         
A00303     EXEC SQL                                                     
A00303         SELECT COMPANY_NAME                                      
A00303           INTO :C7-COMPANY-NAME                                  
A00303           FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
A00303          WHERE COMPANY_NO = :C7-COMPANY-NO                       
A00303                                                           
A00303     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NAME                                              
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A00303     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A00303     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00303        CONTINUE                                                  
A00303     ELSE                                                         
A00303        DISPLAY '****************************************'        
A00303        DISPLAY '** PCSCA608 PROCESSING ERROR          **'        
A00303        DISPLAY '**  SELECT ERROR ON CSS_COMPANY       **'        
A00303        DISPLAY '**  PARA 7810-GET-COMPANY-DESCRIPTION **'        
A00303        DISPLAY '**  RETURN CODE: ' WS-ACTIVE-RETURN-CODE         
A00303        DISPLAY '**  PROCESSING TERMINATED             **'        
A00303        DISPLAY '****************************************'        
A00303        PERFORM 9900-ABEND THRU 9900-EXIT                         
A00303     END-IF.                                                      
      *                                                                         
A00303 7810-EXIT.                                                       
A00303     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     WRITES THE HEADER OR OUTPUT RECORDS TO THE REPORT FILE **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-RPT-REPORT.                                           
      *                                                                         
           MOVE '8300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           IF WS-LINE-COUNT > WS-MAX-LINES                              
              PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 8400-PRINT-RPT-DETAILS THRU 8400-EXIT.               
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     WRITES THE OUTPUT RECORDS TO THE REPORT FILE           **          
      ****************************************************************          
      *                                                                         
       8400-PRINT-RPT-DETAILS.                                          
      *                                                                         
           MOVE '8400'  TO   WS-ACTIVE-PARAGRAPH.                       
      *                                                                         
           MOVE WS-DETAIL-LINE           TO   PRT33-DATA.               
           ADD  WS-ONE                   TO   WS-LINE-COUNT.            
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     WRITES THE HEADER TO THE REPORT FILE                   **          
      ****************************************************************          
      *                                                                         
       8500-PRINT-RPT-HEADERS.                                          
      *                                                                         
           MOVE '8500'              TO WS-ACTIVE-PARAGRAPH.             
      *                                                                         
           ADD 1                    TO WS-PAGE-COUNT.                   
           MOVE WS-PAGE-COUNT       TO WS-REP-PAGE.                     
           MOVE WS-PGRMNAME         TO P-RPT-TITLE-PGNM.                
A00303     MOVE WS-COMPANY-NAME     TO P-RPT-COMPANY.                   
      *                                                                         
           IF IN-CHANGE-TYPE = 'B'                                      
A00303        MOVE WS-MSG-BTU TO P-RPT-REP-NAME                         
           ELSE                                                         
              IF IN-CHANGE-TYPE = 'T'                                   
A00303           MOVE WS-MSG-BUYBACK TO P-RPT-REP-NAME                  
              ELSE                                                      
A00303           IF FILE-INPUT                                          
A00303              MOVE WS-MSG-FILE TO P-RPT-REP-NAME                  
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-RPT-TITLE-1           TO   PRT33-DATA.               
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE    WS-RPT-TITLE-2        TO   PRT33-DATA.               
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE    WS-BLANK-LINE         TO   PRT33-DATA.               
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE WS-RPT-HEADER1           TO PRT33-DATA                  
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT             
      *                                                                         
           MOVE    WS-BLANK-LINE         TO   PRT33-DATA.               
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
30924      MOVE +5 TO   WS-LINE-COUNT.                                  
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00303****************************************************************          
A00303**       WRITES THE HEADERS FOR ERROR REPORT                  **          
A00303****************************************************************          
      *                                                                         
A00303 8551-PRT2-HEADERS.                                               
      *                                                                         
A00303     MOVE '8551'            TO WS-ACTIVE-PARAGRAPH.               
      *                                                                         
A00303     ADD +1                  TO WS-PRT2-PAGE-COUNT.               
A00303     MOVE WS-PRT2-PAGE-COUNT TO WS-REP-PAGE.                      
A00303     MOVE WS-PGRMNAME        TO P-RPT-TITLE-PGNM.                 
A00303     MOVE WS-COMPANY-NAME    TO P-RPT-COMPANY.                    
      *                                                                         
A00303     IF IN-CHANGE-TYPE = 'B'                                      
A00303        MOVE WS-MSG-BTU TO P-RPT-REP-NAME                         
A00303     ELSE                                                         
A00303        IF IN-CHANGE-TYPE = 'T'                                   
A00303           MOVE WS-MSG-BUYBACK TO P-RPT-REP-NAME                  
A00303        ELSE                                                      
A00303           IF FILE-INPUT                                          
A00303              MOVE WS-MSG-FILE TO P-RPT-REP-NAME                  
A00303           END-IF                                                 
A00303        END-IF                                                    
A00303     END-IF.                                                      
      *                                                                         
A00303     MOVE WS-RPT-TITLE-1 TO PRT331-RECORD.                        
A00303     PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT.              
      *                                                                         
A00303     MOVE WS-RPT-TITLE-2 TO PRT331-RECORD.                        
A00303     PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT.              
      *                                                                         
A00303     MOVE WS-BLANK-LINE  TO PRT331-RECORD.                        
A00303     PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT.              
      *                                                                         
A00303     MOVE WS-RPT-HEADER1 TO PRT331-RECORD.                        
A00303     PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT.              
      *                                                                         
A00303     MOVE WS-BLANK-LINE  TO PRT331-RECORD.                        
A00303     PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT.              
A00303     MOVE +5 TO WS-PRT2-LINE-COUNT.                               
      *                                                                         
A00303 8551-EXIT.                                                       
A00303     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       WRITES THE FOOTER  TO THE REPORT FILE                **          
      ****************************************************************          
      *                                                                         
       8600-PRINT-RPT-FOOTER.                                           
      *                                                                         
A00303     IF WS-PRT-NODATA = 'Y'                                       
A00303        PERFORM 8500-PRINT-RPT-HEADERS THRU 8500-EXIT             
A00303     END-IF.                                                      
      *                                                                         
           MOVE '8600'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
30924      MOVE WS-BLANK-LINE            TO PRT33-DATA.                 
30924      PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
30924      MOVE WS-TOTAL-THAT-SHOULD-BE-THERE TO WS-SHOULD-BE-CNT.      
30924      MOVE WS-TOTAL-RECORD-CNT TO WS-TOTAL-LINE-CNT.               
30924      MOVE WS-TOTAL-LINE TO PRT33-DATA.                            
30924      PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE WS-BLANK-LINE            TO PRT33-DATA.                 
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE WS-FOOTER                TO PRT33-DATA.                 
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
           MOVE WS-BLANK-LINE            TO PRT33-DATA.                 
           PERFORM 8900-WRITE-SUMMARY-REPORT THRU 8900-EXIT.            
      *                                                                         
A00303     IF WS-PRT2-NODATA = 'Y'                                      
A00303        PERFORM 8551-PRT2-HEADERS THRU 8551-EXIT                  
A00303        MOVE WS-NODATA-LINE TO PRT331-RECORD                      
A00303        PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT            
A00303        MOVE WS-FOOTER      TO PRT331-RECORD                      
A00303        PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT            
A00303     ELSE                                                         
A00303        MOVE ZEROS TO WS-SHOULD-BE-CNT                            
A00303        MOVE WS-ERROR-COUNT TO WS-TOTAL-LINE-CNT                  
A00303        MOVE WS-TOTAL-LINE TO PRT331-RECORD                       
A00303        PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT            
A00303        MOVE WS-FOOTER      TO PRT331-RECORD                      
A00303        PERFORM 8901-WRITE-ERROR-REPORT THRU 8901-EXIT            
A00303     END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     HANDLE RETURN CODE FROM SCSCA190                       **          
      ****************************************************************          
      *                                                                         
       8800-HANDLE-RET-CODE.                                            
      *                                                                         
           MOVE '8800'   TO WS-ACTIVE-PARAGRAPH.                        
      *                                                                         
           IF ABEND-FUNCTION = 'NOBGDETL'                               
A00303        MOVE ABEND-FUNCTION TO WS-MSG-8800-BGREVIEW               
A00303        MOVE WS-MSG-8800-NO-VALID-DETAILS TO WS-COMMENTS          
A00303        PERFORM 3001-ERROR-REPORT THRU 3001-EXIT                  
           ELSE                                                         
A00303        MOVE ABEND-FUNCTION TO WS-MSG-8800-REVIEW                 
A00303        MOVE WS-MSG-8800-ACCOUNT-ABENDED TO WS-COMMENTS           
A00303        PERFORM 3001-ERROR-REPORT THRU 3001-EXIT                  
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A00303**     EXCEPTION HANDLING FOR SCSCA190                        **          
      ****************************************************************          
      *                                                                         
A00303 8810-EXCEPTIONS.                                                 
      *                                                                         
A00303     MOVE ABEND-FUNCTION TO WS-MSG-SCSCA190-ABEND.                
A00303     MOVE RS-RETURN-CODE TO WS-MSG-SCSCA190-SQL.                  
A00303     MOVE WS-MSG-SCSCA190 TO WS-COMMENTS.                         
A00303     PERFORM 3001-ERROR-REPORT THRU 3001-EXIT.                    
A00303     PERFORM 8800-HANDLE-RET-CODE THRU 8800-EXIT.                 
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
A00303 8810-EXIT.                                                       
A00303     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     WRITES THE RECORD IN THE SAME PAGE OR TO THE NEXT PAGE **          
      ****************************************************************          
      *                                                                         
       8900-WRITE-SUMMARY-REPORT.                                       
      *                                                                         
           MOVE '8900'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
           WRITE PRT33-RECORD.                                          
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A00303****************************************************************          
A00303**   WRITES ERROR REPORT                                      **          
A00303****************************************************************          
      *                                                                         
A00303 8901-WRITE-ERROR-REPORT.                                         
      *                                                                         
A00303     MOVE '8901'  TO WS-ACTIVE-PARAGRAPH.                         
      *                                                                         
A00303     WRITE PRT331-RECORD.                                         
      *                                                                         
A00303 8901-EXIT.                                                       
A00303     EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  TERMINATION PARAGRAPH                                    **           
      ***************************************************************           
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSPT33-FILE                                           
A00303           FCSPT331-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 9700-PROCESS-ABEND                                         *            
      **************************************************************            
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
      *                                                                         
      ****************************************************************          
      * 9900-ABEND                                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
             END-EXEC.                                                          
      *                                                                         
