       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA606.                                        
       DATE-WRITTEN.   MAY 2013.                                        
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE      INITIALS     REASON                           **          
      **  ________    ________     ______                           **          
      **  MAY 2013    RF10596      NEW PROGRAM FOR LETTER CREATION  **          
A04527**  06/06/13    AS7C117      REMOVE UNUSED COPYBOOK CWS00056  **          
      **                                                            **          
A04880**  29 APR 14   RF10596      ADD MORE VARIABLES FORM JOB PARM **          
      **                                                            **          
A04880**   2 OCT 14   RF10596      CHANGE TO USE CURRENT DATE       **          
A04880**                           INSTEAD OF COMMON DATE           **          
ACT102**  05/19/15    BD09555      ADD REGULATED GROUP CODE TO      **          
ACT102** A05136-ACT102             CSS_CORRESP_HDR                  **          
      **                                                            **          
      ****************************************************************          
      *                                                              *          
      *   CREATES TABLE ENTRIES FOR LETTER CREATION BY PCSKR150      *          
      *                                                              *          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA606.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA606.                                                           
      *                                                                         
       COPY FIOCA606.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA606'.
MSQ017     COPY MFASQLM.
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
       01  WS-MISCELLANEOUS.                                            
A04880     05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-FCA606-STATUS        PIC XX.                          
               88 E-FCSCA606-SUCCESSFUL  VALUE '00'.                    
               88 E-FCSCA606-EOF         VALUE '23'.                    
           05  S-RETURN-CODE           PIC S9(9)  COMP VALUE 0.         
           05  WS-ABEND-PARAGRAPH      PIC XXXX   VALUE SPACES.         
           05  WS-SQLCODE              PIC --------9.                   
           05  WS-ZERO-IND             PIC S9999  COMP VALUE 0.         
      *                                                                         
           05  WS-MAX-NUM              PIC 9    VALUE ZERO.             
           05  WS-SEB-REG-FLAG         PIC X    VALUE 'N'.              
               88  WS-SEB-REGULATED             VALUE 'Y'.              
           05  WS-RED-FL-NULL-IND      PIC S9(4) COMP VALUE 0.          
           05  WS-CALL-END-NULL-IND    PIC S9(4) COMP VALUE 0.          
           05  WS-HOLD-ATTR-VALUE-TEXT.                                 
               10  FILLER              PIC X(15).                       
               10  WS-HOLD-LTR-COUNT   PIC 9     VALUE 0.               
           05  WS-ACCT-ATR-COMMENT.                                     
               10  FILLER              PIC X(15)      VALUE             
                                       'LETTER COUNT = '.               
               10  WS-ATR-LTR-COUNT    PIC 9     VALUE 0.               
      *                                                                         
           05  WS-OLD-ACCT-NO          PIC X(13).                       
           05  WS-OLD-ACCT-NUM REDEFINES WS-OLD-ACCT-NO                 
                                       PIC 9(13).                       
           05  WS-OLD-ACCT-COMP3       PIC S9(13)V COMP-3 VALUE 0.      
           05  WS-PREV-ACCOUNT-NO      PIC X(13) VALUE SPACES.          
           05  WS-SEQ-NO-COUNT         PIC S9(4) COMP VALUE 0.          
      *                                                                         
           05  WS-NEW-ACCT-NO          PIC X(13).                       
           05  WS-MESSAGE-NO           PIC 9(5)  VALUE ZEROS.           
           05  WS-MESSAGE-DESC         PIC X(80) VALUE SPACES.          
      *                                                                         
A04880     05  WS-MESSAGE-VAR1         PIC 99    VALUE ZEROS.           
A04880     05  WS-MESSAGE-VAR1X        PIC X(5)  VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA1       PIC X(80) VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA1X      PIC X(7)  VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA2       PIC X(80) VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA2X      PIC X(4)  VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA3       PIC X(80) VALUE SPACES.          
A04880     05  WS-MESSAGE-ALPHA3X      PIC X(5)  VALUE SPACES.          
      *                                                                         
           05  WS-CORRESP-ID           PIC S9(13)V COMP-3 VALUE 0.      
      *                                                                         
       01  WS-INITIAL-COMMENT-TX.                                       
           05  WS-INITIAL-COMMENT-TX-LEN  PIC S9(4) COMP VALUE 80.      
           05  WS-INITIAL-COMMENT-TX-TEXT PIC X(255) VALUE SPACES.      
      *                                                                         
      *****************************************************************         
      *  CWS00350  - CORRESP_COMM VARIABLES                           *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00350                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  COPYBOOK - WORKING STORAGE FOR CPDCA165                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSCA165                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-INPUT-MSG-NO REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           05  WS-PARM-MESSAGE      PIC X(12).                          
               88  MESSAGE-LIT     VALUE 'MESSAGE NO ='.                
           05  WS-PARM-MESSAGE-NO   PIC 9(5).                           
           05  FILLER               PIC X(63).                          
      *                                                                         
       01  WS-INPUT-MSG-DESC REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-MESSAGE-DESC-X    PIC X(5).                           
               88  MESSAGE-DESC    VALUE 'MSG ='.                       
           05  WS-PARM-MESSAGE-DESC PIC X(75).                          
      *                                                                         
A04880 01  WS-INPUT-MSG-VAR1 REDEFINES WS-INPUT-DATA-BREAKDOWN.         
A04880     05  WS-MESSAGE-VAR-X1    PIC X(5).                           
A04880         88  MESSAGE-VAR1     VALUE 'YEAR='.                      
A04880     05  WS-PARM-MESSAGE-VAR1 PIC 99.                             
A04880     05  FILLER               PIC X(73).                          
      *                                                                         
A04880 01  WS-INPUT-MSG-ALPHA1 REDEFINES WS-INPUT-DATA-BREAKDOWN.       
A04880     05  WS-MESSAGE-ALPHA-X1    PIC X(7).                         
A04880         88  MESSAGE-ALPHA1     VALUE 'OFFICE='.                  
A04880     05  WS-PARM-MESSAGE-ALPHA1 PIC X(73).                        
      *                                                                         
A04880 01  WS-INPUT-MSG-ALPHA2 REDEFINES WS-INPUT-DATA-BREAKDOWN.       
A04880     05  WS-MESSAGE-ALPHA-X2    PIC X(4).                         
A04880         88  MESSAGE-ALPHA2     VALUE 'ADR='.                     
A04880     05  WS-PARM-MESSAGE-ALPHA2 PIC X(76).                        
      *                                                                         
A04880 01  WS-INPUT-MSG-ALPHA3 REDEFINES WS-INPUT-DATA-BREAKDOWN.       
A04880     05  WS-MESSAGE-ALPHA-X3    PIC X(5).                         
A04880         88  MESSAGE-ALPHA3     VALUE 'DATE='.                    
A04880     05  WS-PARM-MESSAGE-ALPHA3 PIC X(75).                        
      *                                                                         
       COPY CWS00074.                                                           
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
       01  WS-INPUT-DATE-BREAKDOWN     PIC 9(10)    VALUE ZEROS.        
       01  FILLER REDEFINES WS-INPUT-DATE-BREAKDOWN.                    
           05  WS-INPUT-CC-B           PIC 99.                          
           05  WS-INPUT-YY-B           PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-INPUT-MM-B           PIC 99.                          
           05  FILLER                  PIC X.                           
           05  WS-INPUT-DD-B           PIC 99.                          
      *                                                                         
       01  WS-STATEMENT-DATE.                                           
           05  WS-STATEMENT-YY         PIC XX VALUE SPACES.             
           05  WS-STATEMENT-MM         PIC XX VALUE SPACES.             
           05  WS-STATEMENT-DD         PIC XX VALUE SPACES.             
      *                                                                         
       01  WS-COMMONDATE               PIC X(10).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-L                    PIC X    VALUE 'L'.              
           05  WS-NO-MORE-RECORDS      PIC X    VALUE 'N'.              
           05  WS-N                    PIC X    VALUE 'N'.              
           05  WS-O                    PIC X    VALUE 'O'.              
           05  WS-S                    PIC X    VALUE 'S'.              
           05  WS-Y                    PIC X    VALUE 'Y'.              
           05  WS-PGRMNAME             PIC X(8) VALUE 'PCSCA606'.       
           05  PROGRAM-NAME            PIC X(8) VALUE 'PCSCA606'.       
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ACCOUNT - AT                                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ACCT_ATTRIBUTE - YP                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACTATT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ACCT_MISC_INFO - TA                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ADDR_FORMATTED - DY                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ADDR_FREEFORM - DZ                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_AR_TRAN_HIST - AR                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ATTRIBUTE - WZ                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATTRIB                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_BANK_EFT - BE                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBNKEFT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_BTCH_PARTITION - O5                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBTHPRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_COMM_DATA - KO                                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMDAT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_CUST_ADDR_XREF - DM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_CUSTOMER - CU                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_CUSTOMER_BANK - JF                                    *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTBNK                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_DELINQUENCY - C8                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_JOB_PARM - G6                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_LOCAL_OFFICE - B1                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_MNT_TRANS_HIST - MH                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_MT_TRN_HST_DET - MI                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_NAME - DQ                                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_NAME_ACCT_XREF - HT                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_REG_PROFILE - LR                                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   CSS_ZIP_CODE - A4                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CORRESP_COMM  - 1L                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCORCOM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CORRESP_NOTICE- 1M                                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCORNOT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CORRESP_HDR - 1J                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCORHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      * CSS_CORRESP_VAR - 1K                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCORVAR                                                 
           END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      **************************************************************            
      **  MAINLINE                                                **            
      **************************************************************            
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                         
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT                 
               UNTIL WS-NO-MORE-RECORDS = 'Y'.                          
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  INITIALIZE - GET CORRECT DATABASE                         **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE WS-CORRESP-COMM-VAR.                              
      *                                                                         
           MOVE ZERO                   TO WS-CWS350-DATABASE.           
           MOVE '01'                   TO C8-COMPANY-NO.                
           MOVE 'DATABASE'             TO C8-DELINQ-CD.                 
           PERFORM 7500-SELECT-MAX-NUM THRU 7500-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-CWS350-DATABASE.           
           MOVE SPACES                 TO C8-DELINQ-CD.                 
      *                                                                         
A04880     PERFORM 7550-GET-CURRENT-DATE THRU 7550-EXIT.                
      *                                                                         
A04880     DISPLAY 'WS-CURRENT-DATE = ' WS-CURRENT-DATE.                
      *                                                                         
A04880     MOVE WS-CURRENT-DATE TO WS-INPUT-DATE                        
                                   WS-COMMONDATE                        
                                   WS-INPUT-DATE-BREAKDOWN.             
           MOVE WS-INPUT-YY-B TO WS-STATEMENT-YY.                       
           MOVE WS-INPUT-MM-B TO WS-STATEMENT-MM.                       
           MOVE WS-INPUT-DD-B TO WS-STATEMENT-DD.                       
      *                                                                         
           OPEN INPUT FCSCA606-FILE.                                    
      *                                                                         
           IF E-FCSCA606-SUCCESSFUL                                     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY ' '                                               
              DISPLAY '**  PCSCA606 PROCESSING ERROR        **'         
              DISPLAY '**  OPEN ERROR OF FCSCA606   FILE      **'       
              DISPLAY '**  FILE STATUS = ' WS-FCA606-STATUS             
              DISPLAY '**  PROCESSING TERMINATED            **'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                  TO WS-SYSIPT.                   
           MOVE WS-PGRMNAME             TO WS-PROGRAM.                  
           MOVE 'PARM'                  TO WS-COMMAND.                  
           PERFORM 7600-START-FCSJC01   THRU 7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01    THRU 7610-EXIT                  
               UNTIL (MESSAGE-LIT AND INPUT-ACTIVE)                     
               OR END-OF-SYSIPT.                                        
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY SPACES                                            
              DISPLAY '******** PROGRAM ABENDING ***************'       
              DISPLAY '*   MESSAGE NUMBER IS NOT ACTIVE        *'       
              DISPLAY '*     ON JOB PARM                       *'       
              DISPLAY '******** PROGRAM ABENDING ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE WS-PARM-MESSAGE-NO TO WS-MESSAGE-NO                  
           END-IF.                                                      
      *                                                                         
           IF WS-SYSIPT = SPACES                                        
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO WS-SYSIPT                     
           MOVE WS-PGRMNAME            TO WS-PROGRAM                    
           MOVE 'PARM'                 TO WS-COMMAND                    
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
               UNTIL (MESSAGE-DESC AND INPUT-ACTIVE)                    
               OR END-OF-SYSIPT                                         
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY '******** PROGRAM ABENDING ***************'       
              DISPLAY '*   MESSAGE DESCRIPTION IS NOT ACTIVE   *'       
              DISPLAY '*     ON JOB PARM                       *'       
              DISPLAY '******** PROGRAM ABENDING ***************'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           ELSE                                                         
              MOVE WS-PARM-MESSAGE-DESC TO WS-MESSAGE-DESC              
           END-IF.                                                      
      *                                                                         
           MOVE WS-MESSAGE-DESC TO WS-INITIAL-COMMENT-TX-TEXT.          
      *                                                                         
           DISPLAY '****************************************'.          
           DISPLAY 'WS-MESSAGE-NO         = ' WS-MESSAGE-NO.            
           DISPLAY 'WS-MESSAGE-DESC       = ' WS-MESSAGE-DESC.          
           DISPLAY '****************************************'.          
      *                                                                         
           IF WS-SYSIPT = SPACES                                        
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
A04880     MOVE SPACES                 TO WS-SYSIPT                     
A04880     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
A04880     MOVE 'PARM'                 TO WS-COMMAND                    
A04880     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
A04880     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04880         UNTIL (MESSAGE-VAR1 AND INPUT-ACTIVE)                    
A04880         OR END-OF-SYSIPT                                         
      *                                                                         
A04880     IF END-OF-SYSIPT                                             
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880        DISPLAY '*   MESSAGE VARIBLE IS NOT ACTIVE       *'       
A04880        DISPLAY '*     ON JOB PARM                       *'       
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04880     ELSE                                                         
A04880        MOVE WS-PARM-MESSAGE-VAR1 TO WS-MESSAGE-VAR1              
A04880        MOVE WS-MESSAGE-VAR-X1    TO WS-MESSAGE-VAR1X             
A04880     END-IF.                                                      
      *                                                                         
A04880     IF WS-SYSIPT = SPACES                                        
A04880        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880     MOVE SPACES                 TO WS-SYSIPT                     
A04880     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
A04880     MOVE 'PARM'                 TO WS-COMMAND                    
A04880     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
A04880     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04880         UNTIL (MESSAGE-ALPHA1 AND INPUT-ACTIVE)                  
A04880         OR END-OF-SYSIPT                                         
      *                                                                         
A04880     IF END-OF-SYSIPT                                             
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880        DISPLAY '*   MESSAGE ALPHA1 IS NOT ACTIVE        *'       
A04880        DISPLAY '*     ON JOB PARM                       *'       
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880*       PERFORM 9900-ABEND THRU 9900-EXIT                                 
A04880     ELSE                                                         
A04880        MOVE WS-PARM-MESSAGE-ALPHA1 TO WS-MESSAGE-ALPHA1          
A04880        MOVE WS-MESSAGE-ALPHA-X1    TO WS-MESSAGE-ALPHA1X         
A04880     END-IF.                                                      
      *                                                                         
A04880     IF WS-SYSIPT = SPACES                                        
A04880        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880     MOVE SPACES                 TO WS-SYSIPT                     
A04880     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
A04880     MOVE 'PARM'                 TO WS-COMMAND                    
A04880     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
A04880     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04880         UNTIL (MESSAGE-ALPHA2 AND INPUT-ACTIVE)                  
A04880         OR END-OF-SYSIPT                                         
      *                                                                         
A04880     IF END-OF-SYSIPT                                             
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880        DISPLAY '*   MESSAGE ALPHA2 IS NOT ACTIVE        *'       
A04880        DISPLAY '*     ON JOB PARM                       *'       
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880*       PERFORM 9900-ABEND THRU 9900-EXIT                                 
A04880     ELSE                                                         
A04880        MOVE WS-PARM-MESSAGE-ALPHA2 TO WS-MESSAGE-ALPHA2          
A04880        MOVE WS-MESSAGE-ALPHA-X2    TO WS-MESSAGE-ALPHA2X         
A04880     END-IF.                                                      
      *                                                                         
A04880     IF WS-SYSIPT = SPACES                                        
A04880        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880     MOVE SPACES                 TO WS-SYSIPT                     
A04880     MOVE WS-PGRMNAME            TO WS-PROGRAM                    
A04880     MOVE 'PARM'                 TO WS-COMMAND                    
A04880     PERFORM 7600-START-FCSJC01  THRU 7600-EXIT                   
A04880     PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
A04880         UNTIL (MESSAGE-ALPHA3 AND INPUT-ACTIVE)                  
A04880         OR END-OF-SYSIPT                                         
      *                                                                         
A04880     IF END-OF-SYSIPT                                             
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880        DISPLAY '*   MESSAGE ALPHA3 IS NOT ACTIVE        *'       
A04880        DISPLAY '*     ON JOB PARM                       *'       
A04880        DISPLAY '******** PROGRAM ABENDING ***************'       
A04880*       PERFORM 9900-ABEND THRU 9900-EXIT                                 
A04880     ELSE                                                         
A04880        MOVE WS-PARM-MESSAGE-ALPHA3 TO WS-MESSAGE-ALPHA3          
A04880        MOVE WS-MESSAGE-ALPHA-X3    TO WS-MESSAGE-ALPHA3X         
A04880     END-IF.                                                      
      *                                                                         
A04880     IF WS-SYSIPT = SPACES                                        
A04880        PERFORM 7611-CLOSE THRU 7611-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880     DISPLAY '****************************************'.          
A04880     DISPLAY 'WS-MESSAGE-VAR1X      = ' WS-MESSAGE-VAR1X.         
A04880     DISPLAY 'WS-MESSAGE-VAR1       = ' WS-MESSAGE-VAR1.          
A04880     DISPLAY 'WS-MESSAGE-ALPHA1X    = ' WS-MESSAGE-ALPHA1X.       
A04880     DISPLAY 'WS-MESSAGE-ALPHA1     = ' WS-MESSAGE-ALPHA1.        
A04880     DISPLAY 'WS-MESSAGE-ALPHA2X    = ' WS-MESSAGE-ALPHA2X.       
A04880     DISPLAY 'WS-MESSAGE-ALPHA2     = ' WS-MESSAGE-ALPHA2.        
A04880     DISPLAY 'WS-MESSAGE-ALPHA3X    = ' WS-MESSAGE-ALPHA3X.       
A04880     DISPLAY 'WS-MESSAGE-ALPHA3     = ' WS-MESSAGE-ALPHA3.        
A04880     DISPLAY '****************************************'.          
      *                                                                         
           PERFORM 7100-READ-INPUT-FILE THRU 7100-EXIT.                 
           MOVE E-FCA606-ACCOUNT-NO TO AT-ACCOUNT-NO.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  PROCESS-ACCOUNTS                                          **          
      ****************************************************************          
      *                                                                         
       1000-PROCESS-ACCOUNTS.                                           
      *                                                                         
      *                                                                         
           PERFORM 7400-SELECT-ACCOUNT THRU 7400-EXIT.                  
      *                                                                         
           PERFORM 2100-FORMAT-LETTERS THRU 2100-EXIT.                  
      *                                                                         
           PERFORM 7100-READ-INPUT-FILE THRU 7100-EXIT.                 
           MOVE E-FCA606-ACCOUNT-NO TO AT-ACCOUNT-NO.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  FORMAT CSS_COMM_DATA RECORD                               **          
      ****************************************************************          
      *                                                                         
       1400-FORMAT-COMM-REC.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE 'N'                    TO KO-RED-FLAG-IND               
                                          KO-SCREEN-POP-IND.            
           MOVE WS-L                   TO KO-COMM-METHOD.               
           MOVE WS-O                   TO KO-COMM-DIRECTION.            
           MOVE WS-CURR-COMM-TYP-CD    TO KO-COMM-TYPE-CD.              
           MOVE WS-CURR-COMM-SUBTYP-CD TO KO-COMM-SUBTYPE-CODE.         
           MOVE WS-MESSAGE-NO          TO KO-PROMOTION-ID.              
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE WS-SALUTATION-NAME     TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT         
                                          KO-PSC-COMPLIANCE-IND         
                                          KO-CALL-END-TIME              
                                          KO-RESPONSE-REASON-CD         
                                          KO-RESPONSE-TYPE-CD           
                                          KO-SOLICITATION-CD            
                                          KO-DISCOVERY-MTHD-CD          
                                          KO-PREV-MARKETER-CD.          
           MOVE ZEROES                 TO KO-CALL-ORIGIN-ID             
                                          KO-NUMBER-TRANSFERS           
                                          KO-HOLD-TIME                  
                                          KO-QUEUE-TIME                 
                                          KO-TOTAL-CALL-TIME.           
           MOVE 'A'                    TO KO-COMM-ASSOC-CD.             
           MOVE 'N'                    TO KO-COMPLAINT-FL.              
           MOVE -1                     TO WS-RED-FL-NULL-IND            
                                          WS-CALL-END-NULL-IND.         
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  FORMAT LETTERS.                                           **          
      ****************************************************************          
      *                                                                         
       2100-FORMAT-LETTERS.                                             
      *                                                                         
           MOVE WS-SEQ-NO-COUNT          TO 1J-CORRESP-SEQ-NO.          
           MOVE WS-MESSAGE-NO            TO 1J-CORRESP-MSG-ID           
                                            1L-CORRESP-MSG-ID           
                                            WS-MESSAGE-ID.              
           MOVE AT-COMPANY-NO            TO 1J-CORRESP-COMPANY-NO       
                                            1L-COMPANY-NO.              
           MOVE AT-ACCOUNT-NO            TO 1J-ACCOUNT-NO               
                                            WS-PREV-ACCOUNT-NO.         
           MOVE AT-CUSTOMER-NO           TO 1J-CUSTOMER-NO.             
           MOVE AT-LOCAL-OFFICE          TO WS-CWS350-LOCAL-OFFICE.     
ACT102     MOVE LR-REG-GROUP-CD          TO 1J-REG-GROUP-CD.            
           MOVE 'I'                      TO 1J-CORRESP-STATUS-CD        
           MOVE ZEROES                   TO 1J-GUARNTR-ACCT-NO          
                                            1J-THD-PRTY-ID              
           MOVE SPACES                   TO 1J-BARCODE-UNIQUE-ID        
           MOVE WS-PGRMNAME              TO 1J-CREATED-BY-PGM-ID        
                                            1J-LAST-UPDATE-PGM-ID       
           MOVE WS-INPUT-DATE            TO 1J-CORRESP-STMT-DT          
                                            1L-EFF-TO-DT.               
           MOVE SPACES                   TO WS-CORRESP-ID-FND.          
      *                                                                         
           PERFORM 5000-CHECK-LOAD-CORRESP-TBL THRU 5000-CPD350-EXIT.   
      *                                                                         
           MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD.           
           PERFORM 5425-GET-CORRESP-ID-VAL THRU 5425-CPD350-EXIT.       
      *                                                                         
A04880     INITIALIZE DCLCSS-CORRESP-VAR.                               
A04880     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A04880     MOVE 'NUM-VAR-1'              TO 1K-CORRESP-VAR-NM.          
A04880     MOVE WS-MESSAGE-VAR1X         TO 1K-CORRESP-VAR-DATA.        
A04880     MOVE WS-MESSAGE-VAR1          TO 1K-CORRESP-VAR-NUM.         
A04880     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
      *                                                                         
A04880     INITIALIZE DCLCSS-CORRESP-VAR.                               
A04880     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A04880     MOVE 'ALPHA-VAR-1'            TO 1K-CORRESP-VAR-NM.          
A04880     MOVE WS-MESSAGE-ALPHA1X       TO 1K-CORRESP-VAR-DATA.        
A04880     MOVE WS-MESSAGE-ALPHA1        TO 1K-CORRESP-VAR-CHAR.        
A04880     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
      *                                                                         
A04880     INITIALIZE DCLCSS-CORRESP-VAR.                               
A04880     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A04880     MOVE 'ALPHA-VAR-2'            TO 1K-CORRESP-VAR-NM.          
A04880     MOVE WS-MESSAGE-ALPHA2X       TO 1K-CORRESP-VAR-DATA.        
A04880     MOVE WS-MESSAGE-ALPHA2        TO 1K-CORRESP-VAR-CHAR.        
A04880     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
      *                                                                         
A04880     INITIALIZE DCLCSS-CORRESP-VAR.                               
A04880     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
A04880     MOVE 'ALPHA-VAR-3'            TO 1K-CORRESP-VAR-NM.          
A04880     MOVE WS-MESSAGE-ALPHA3X       TO 1K-CORRESP-VAR-DATA.        
A04880     MOVE WS-MESSAGE-ALPHA3        TO 1K-CORRESP-VAR-CHAR.        
A04880     PERFORM 8600-INSERT-CORRESP-VAR THRU 8600-CPD350-EXIT.       
      *                                                                         
           IF WS-CURR-COMM-INSERT-FL = 'Y'                              
              PERFORM 1400-FORMAT-COMM-REC  THRU 1400-EXIT              
              PERFORM 8200-INSERT-COMM-DATA THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5000-CHECK-LOAD-CORRESP-TBL.                                 *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
                 INCLUDE CPD00350                                               
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
      **  6010-REDUCE-EMBEDDED-SPACES.                              **          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      **  6240-GE-FCA00-COMMON-DATE.                                **          
      ****************************************************************          
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ****************************************************************          
      **  6251-GET-FJC01-DATE.                                      **          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      ****************************************************************          
      **  READ INPUT FILE                                           **          
      ****************************************************************          
      *                                                                         
       7100-READ-INPUT-FILE.                                            
      *                                                                         
           MOVE '7100' TO WS-ABEND-PARAGRAPH.                           
      *                                                                         
           READ FCSCA606-FILE                                           
                 AT END                                                 
                 MOVE WS-Y TO WS-NO-MORE-RECORDS.                       
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  GET CUSTOMR NUMBER FROM CSS_ACCOUNT                       **          
      ****************************************************************          
      *                                                                         
       7400-SELECT-ACCOUNT.                                             
      *                                                                         
           MOVE '7400' TO WS-ABEND-PARAGRAPH.                           
      *                                                                         
           EXEC SQL                                                     
                SELECT  CUSTOMER_NO                                     
                       ,PREMISE_NO                                      
                       ,COMPANY_NO                                      
                       ,LOCAL_OFFICE                                    
                  INTO :AT-CUSTOMER-NO                                  
                      ,:AT-PREMISE-NO                                   
                      ,:AT-COMPANY-NO                                   
                      ,:AT-LOCAL-OFFICE                                 
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  CUSTOMER_NO                                             
MFA-TR*                ,PREMISE_NO                                              
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,LOCAL_OFFICE                                            
MFA-TR*           INTO :AT-CUSTOMER-NO                                          
MFA-TR*               ,:AT-PREMISE-NO                                           
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*               ,:AT-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_ACCOUNT                                              
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT102        PERFORM 7450-REG-PROFILE THRU 7450-EXIT                   
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*=====================================*'         
              DISPLAY '*========      PCSCA606       ========*'         
              DISPLAY '*======== BAD SQL RETURN CODE ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* PARAGRAPH 7400-SELECT-ACCOUNT       *'         
              DISPLAY '* SELECT FAILED IN CSS_ACCOUNT        *'         
              DISPLAY '* ACCOUNT_NO = ' AT-ACCOUNT-NO                   
              DISPLAY '* SQLCODE = ' WS-SQLCODE                         
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT102****************************************************************          
ACT102**  GET REGULATED GROUP CODE                                  **          
ACT102****************************************************************          
ACT102*                                                                         
ACT102 7450-REG-PROFILE.                                                
ACT102*                                                                         
ACT102     MOVE ' '    TO LR-REG-GROUP-CD.                              
ACT102     MOVE '7450' TO WS-ABEND-PARAGRAPH.                           
ACT102*                                                                         
ACT102     EXEC SQL                                                     
ACT102          SELECT REG_GROUP_CD                                     
ACT102           INTO :LR-REG-GROUP-CD                                  
ACT102            FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                    
ACT102           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
ACT102                                                           
ACT102                                                      
ACT102     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT REG_GROUP_CD                                             
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*           FROM CSS_REG_PROFILE                                          
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7450                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT102*                                                                         
ACT102     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT102*                                                                         
ACT102     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT102        CONTINUE                                                  
ACT102     ELSE                                                         
ACT102        MOVE SQLCODE TO WS-SQLCODE                                
ACT102        DISPLAY '*=====================================*'         
ACT102        DISPLAY '*========      PCSCA606       ========*'         
ACT102        DISPLAY '*======== BAD SQL RETURN CODE ========*'         
ACT102        DISPLAY '*=====================================*'         
ACT102        DISPLAY '* PARAGRAPH 7450-REG-PROFILE          *'         
ACT102        DISPLAY '* SELECT FAILED IN CSS_REG_PROFILE    *'         
ACT102        DISPLAY '* ACCOUNT_NO = ' AT-ACCOUNT-NO                   
ACT102        DISPLAY '* SQLCODE = ' WS-SQLCODE                         
ACT102        DISPLAY '*=====================================*'         
ACT102        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT102     END-IF.                                                      
ACT102*                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  SELECT MAX ROW VALUE FROM CSS_DELINQUENCY                 **          
      ****************************************************************          
      *                                                                         
       7500-SELECT-MAX-NUM.                                             
      *                                                                         
           MOVE '7500' TO WS-ABEND-PARAGRAPH.                           
      *                                                                         
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD  = :C8-DELINQ-CD                        
                  AND COMPANY_NO = :C8-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*=====================================*'         
              DISPLAY '*========      PCSCA606       ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '*======== BAD SQL RETURN CODE ========*'         
              DISPLAY '*=====================================*'         
              DISPLAY '* SELECT FAILED IN CSS_DELINQUENCY    *'         
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* DELINQ_CD = ' C8-DELINQ-CD                     
              DISPLAY '* SQLCODE..:   ' WS-SQLCODE                      
                      '                     *'                          
              DISPLAY '*=====================================*'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04880*    GET CURRENT DATE                                          *          
      ****************************************************************          
      *                                                                         
A04880 7550-GET-CURRENT-DATE.                                           
      *                                                                         
A04880     EXEC SQL                                                     
A04880          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04880     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A04880        DISPLAY '******************************************'      
A04880        DISPLAY '      ABENDING PROGRAM '                         
A04880        DISPLAY ' ERROR GETTING CURRENT DATE '                    
A04880        DISPLAY ' 7550-GET-CURRENT-DATE'                          
A04880        DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
A04880        DISPLAY '******************************************'      
A04880        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880 7550-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7600-START-FCSJC01.                                       **          
      **  7610-READ-FCSJC01.                                        **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  7620-START-FCSCA00.                                       **          
      **  7621-START-FCSCA00.                                       **          
      **  7622-CLOSE-CA00-CSR.                                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **  INSERT ROW INTO CSS_COMM_DATA                             **          
      ****************************************************************          
      *                                                                         
       8200-INSERT-COMM-DATA.                                           
      *                                                                         
           MOVE '8200' TO WS-ABEND-PARAGRAPH.                           
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_COMM_DATA                                 
                    (COMMUNICATION_ID                                   
                    ,ACCOUNT_NO                                         
                    ,CUSTOMER_NO                                        
                    ,PREMISE_NO                                         
                    ,COMPANY_NO                                         
                    ,RED_FLAG_IND                                       
                    ,RED_FLAG_EXPIRE_DT                                 
                    ,COMM_METHOD                                        
                    ,COMM_DIRECTION                                     
                    ,COMM_TYPE_CD                                       
                    ,COMM_SUBTYPE_CODE                                  
                    ,USER_ID_ORIG                                       
                    ,CONTACT_NAME                                       
                    ,PROMOTION_ID                                       
                    ,PSC_COMPLIANCE_IND                                 
                    ,CALL_ORIGIN_ID                                     
                    ,CALL_END_TIME                                      
                    ,NUMBER_TRANSFERS                                   
                    ,HOLD_TIME                                          
                    ,QUEUE_TIME                                         
                    ,SCREEN_POP_IND                                     
                    ,TOTAL_CALL_TIME                                    
                    ,INITIAL_COMMENT_TX                                 
                    ,RESPONSE_REASON_CD                                 
                    ,RESPONSE_TYPE_CD                                   
                    ,SOLICITATION_CD                                    
                    ,COMM_ASSOC_CD                                      
                    ,COMPLAINT_FL                                       
                    ,DISCOVERY_MTHD_CD                                  
                    ,PREV_MARKETER_CD)                                  
              VALUES                                                    
                    (CIS.CURRENT$TIMESTAMP()                                  
                   ,:KO-ACCOUNT-NO                                      
                   ,:KO-CUSTOMER-NO                                     
                   ,:KO-PREMISE-NO                                      
                   ,:KO-COMPANY-NO                                      
                   ,:KO-RED-FLAG-IND                                    
                   ,CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                       :WS-RED-FL-NULL-IND)           
                   ,:KO-COMM-METHOD                                     
                   ,:KO-COMM-DIRECTION                                  
                   ,:KO-COMM-TYPE-CD                                    
                   ,:KO-COMM-SUBTYPE-CODE                               
                   ,:KO-USER-ID-ORIG                                    
                   ,:KO-CONTACT-NAME                                    
                   ,:KO-PROMOTION-ID                                    
                   ,:KO-PSC-COMPLIANCE-IND                              
                   ,:KO-CALL-ORIGIN-ID                                  
                   ,CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                       :WS-CALL-END-NULL-IND)              
                   ,:KO-NUMBER-TRANSFERS                                
                   ,:KO-HOLD-TIME                                       
                   ,:KO-QUEUE-TIME                                      
                   ,:KO-SCREEN-POP-IND                                  
                   ,:KO-TOTAL-CALL-TIME                                 
                   ,:KO-INITIAL-COMMENT-TX                              
                   ,:KO-RESPONSE-REASON-CD                              
                   ,:KO-RESPONSE-TYPE-CD                                
                   ,:KO-SOLICITATION-CD                                 
                   ,:KO-COMM-ASSOC-CD                                   
                   ,:KO-COMPLAINT-FL                                    
                   ,:KO-DISCOVERY-MTHD-CD                               
                   ,:KO-PREV-MARKETER-CD)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COMM_DATA                                         
MFA-TR*             (COMMUNICATION_ID                                           
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,RED_FLAG_IND                                               
MFA-TR*             ,RED_FLAG_EXPIRE_DT                                         
MFA-TR*             ,COMM_METHOD                                                
MFA-TR*             ,COMM_DIRECTION                                             
MFA-TR*             ,COMM_TYPE_CD                                               
MFA-TR*             ,COMM_SUBTYPE_CODE                                          
MFA-TR*             ,USER_ID_ORIG                                               
MFA-TR*             ,CONTACT_NAME                                               
MFA-TR*             ,PROMOTION_ID                                               
MFA-TR*             ,PSC_COMPLIANCE_IND                                         
MFA-TR*             ,CALL_ORIGIN_ID                                             
MFA-TR*             ,CALL_END_TIME                                              
MFA-TR*             ,NUMBER_TRANSFERS                                           
MFA-TR*             ,HOLD_TIME                                                  
MFA-TR*             ,QUEUE_TIME                                                 
MFA-TR*             ,SCREEN_POP_IND                                             
MFA-TR*             ,TOTAL_CALL_TIME                                            
MFA-TR*             ,INITIAL_COMMENT_TX                                         
MFA-TR*             ,RESPONSE_REASON_CD                                         
MFA-TR*             ,RESPONSE_TYPE_CD                                           
MFA-TR*             ,SOLICITATION_CD                                            
MFA-TR*             ,COMM_ASSOC_CD                                              
MFA-TR*             ,COMPLAINT_FL                                               
MFA-TR*             ,DISCOVERY_MTHD_CD                                          
MFA-TR*             ,PREV_MARKETER_CD)                                          
MFA-TR*       VALUES                                                            
MFA-TR*             (CURRENT TIMESTAMP                                          
MFA-TR*            ,:KO-ACCOUNT-NO                                              
MFA-TR*            ,:KO-CUSTOMER-NO                                             
MFA-TR*            ,:KO-PREMISE-NO                                              
MFA-TR*            ,:KO-COMPANY-NO                                              
MFA-TR*            ,:KO-RED-FLAG-IND                                            
MFA-TR*            ,:KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND                   
MFA-TR*            ,:KO-COMM-METHOD                                             
MFA-TR*            ,:KO-COMM-DIRECTION                                          
MFA-TR*            ,:KO-COMM-TYPE-CD                                            
MFA-TR*            ,:KO-COMM-SUBTYPE-CODE                                       
MFA-TR*            ,:KO-USER-ID-ORIG                                            
MFA-TR*            ,:KO-CONTACT-NAME                                            
MFA-TR*            ,:KO-PROMOTION-ID                                            
MFA-TR*            ,:KO-PSC-COMPLIANCE-IND                                      
MFA-TR*            ,:KO-CALL-ORIGIN-ID                                          
MFA-TR*            ,:KO-CALL-END-TIME:WS-CALL-END-NULL-IND                      
MFA-TR*            ,:KO-NUMBER-TRANSFERS                                        
MFA-TR*            ,:KO-HOLD-TIME                                               
MFA-TR*            ,:KO-QUEUE-TIME                                              
MFA-TR*            ,:KO-SCREEN-POP-IND                                          
MFA-TR*            ,:KO-TOTAL-CALL-TIME                                         
MFA-TR*            ,:KO-INITIAL-COMMENT-TX                                      
MFA-TR*            ,:KO-RESPONSE-REASON-CD                                      
MFA-TR*            ,:KO-RESPONSE-TYPE-CD                                        
MFA-TR*            ,:KO-SOLICITATION-CD                                         
MFA-TR*            ,:KO-COMM-ASSOC-CD                                           
MFA-TR*            ,:KO-COMPLAINT-FL                                            
MFA-TR*            ,:KO-DISCOVERY-MTHD-CD                                       
MFA-TR*            ,:KO-PREV-MARKETER-CD)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE TO WS-SQLCODE                                
              DISPLAY '*=======================================*'       
              DISPLAY '*========      PCSCA606       ==========*'       
              DISPLAY '*=======================================*'       
              DISPLAY '*======== BAD SQL RETURN CODE ==========*'       
              DISPLAY '*=======================================*'       
              DISPLAY '* ERROR INSERTING INTO CSS_COMM_DATA    *'       
              DISPLAY '* PARAGRAPH: ' WS-ABEND-PARAGRAPH                
                      '                          *'                     
              DISPLAY '* ACCOUNT-NO = ' KO-ACCOUNT-NO                   
              DISPLAY '* SQLCODE..: ' WS-SQLCODE                        
                      '                    *'                           
              DISPLAY '*=======================================*'       
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  NORMAL JOB ENDING                                         **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           DISPLAY '<<< PCSCA606 COMPLETED >>>'.                        
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9700-PROCESS-ABEND.                                       **          
      ****************************************************************          
      *                                                                         
       COPY CPD0023B.                                                           
      *                                                                         
      ****************************************************************          
      **  9900-ABEND.                                               **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
