       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA525.                                        
      ***************************************************************** 00030002
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00040002
      **                     PRICE WATERHOUSE                        ** 00050002
      **                                                             ** 00060002
      **               CUSTOMER INFORMATION SYSTEM                   ** 00070002
      **                                                             ** 00080002
      ***************************************************************** 00090002
      **               P R O G R A M  S U M M A R Y                  ** 00100002
      **                                                             ** 00110004
      ** THIS PROCEDURE WILL INITIATE A SUMMARY OF THE DETAIL BILLING** 00120099
      ** HISTORY ANNUALLY.  INITIAL SETUP IS TRIGGERED BY WRITING OUT** 00130099
      ** THE PREVIOUS CALENDAR YEARS BILLING HISTORY INTO A SINGLE   ** 00140099
      ** RECORD FOR EACH INSTALLATION CONTROL.                       ** 00150099
      ***************************************************************** 00160004
      **                                                             ** 00170002
      **              PROGRAM  MODIFICATION  LOG                     ** 00180002
      **                                                             ** 00190002
      **    DATE    INITIALS  REASON                                 ** 00200002
      **  ________  ________  ______                                 ** 00210002
      **  04/05/95   TAJ      INITIAL PROGRAM VERSION                ** 00220099
T17670**  11/01/98   RAQ      ANNUAL SUMMARY CALCULATED INCORRECTLY. ** 00221032
T17670**                      ADD COMMIT LOGIC, SKIP UNMETERED SERV. ** 00222032
T17670**                      UNTIL 01-2000, ADD LOGIC TO PROCESS    ** 00223032
T17670**                      CANCEL/REBILLS CORRECTLY.CHANGED PROCESS* 00224032
T17670**                      TO BE DRIVEN BY ACCOUNT TABLE.         ** 00225032
T19486**  03/23/99   RAH      ANNUAL SUMMARY CALCULATED INCORRECTLY. ** 00221032
T19486**                      ALL ROWS FOR AN ACCOUNT HAVE THE SAME  ** 00222032
T19486**                      DATA.                                  ** 00222032
T22220**  05/16/00   VWG      ADDED COPYBOOK SDTCDAT2 AND GET        ** 00230030
T22220**                      REV MONTH DATES FROM IT INSTEAD OF     ** 00230030
T22220**                      JOB PARM                               ** 00230030
ACT144*   08/13/13  BD09555     REPLACE DATE CARD WITH DB2 COMMON DATE *        
      *   A04524                                                       *        
      ***************************************************************** 00240002
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00250002
      **                                                             ** 00260002
      **  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION          ** 00270004
      **  1000 - 1999  INPUT PROCESSING CONTROL PATH                 ** 00280004
      **  2000 - 4999  OUTPUT PROCESSING CONTROL PATH                ** 00290004
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00300002
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00310002
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00320002
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00330004
      **  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES         ** 00340004
      **                                                             ** 00350002
      ***************************************************************** 00360002
                                                                        
      /                                                                 00380093
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      /                                                                 00450093
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA525'.
MSQ017     COPY MFASQLM.
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA525 STARTS HERE'.            
                                                                        
      /*****************************************************************00500070
      *   TABLE DECLARATIONS GO AFTER OTHER WORKING STORAGE ITEMS      *00510070
      *   (IF DIRECT ACCESS TO DB2 TABLES IS ALLOWED). FIRST ITEM      *00520070
      *   WILL ALWAYS BE SQLCA.                                        *00530070
      ******************************************************************00540070
      /***** SQL COMMUNICATIONS AREA                                    00550070
           EXEC SQL                                                     00560070
               INCLUDE SQLCA                                            00570070
           END-EXEC.                                                    00580070
                                                                        
      /***** CSS_MODEL_SQL                                              00600099
      /***** CSS_JOB_PARM                                               00650099
           EXEC SQL                                                     00660099
               INCLUDE TBJBPARM                                         00670099
           END-EXEC.                                                    00680099
                                                                        
      /***** CSS_ANNUAL_SUMMARY                                         00700099
           EXEC SQL                                                     00710070
               INCLUDE TBANLSUM                                         00720099
           END-EXEC.                                                    00730070
                                                                        
T17670/***** CSS_ACCOUNT                                                00741008
T17670     EXEC SQL                                                     00742008
T17670         INCLUDE TBACCT                                           00743008
T17670     END-EXEC.                                                    00744008
                                                                        
      /***** CSS_BILL_CALC_DET                                          00750099
           EXEC SQL                                                     00760070
               INCLUDE TBBLCLDT                                         00770099
           END-EXEC.                                                    00780070
                                                                        
      /***** CSS_BILLING_DET                                            00800099
           EXEC SQL                                                     00810099
               INCLUDE TBBLLDET                                         00820099
           END-EXEC.                                                    00830099
                                                                        
      /***** CSS_BILLING_HDR                                            00850099
           EXEC SQL                                                     00860085
               INCLUDE TBBLLHDR                                         00870099
           END-EXEC.                                                    00880085
                                                                        
      *01  WS-WORK-VARIABLES.                                           00900030
      /**************************************************************** 00910030
      **     THE WORK VARIABLE AREA IS USED FOR TRANSIENT DATA. IT   ** 00920002
      **     IS INITIALIZED ON EACH CALL TO THE SUBROUTINE.          ** 00930002
      **     THE OTHER WORK AREAS ARE INITIALIZED UNDER PROGRAM      ** 00940002
      **     CONTROL.  ADD ANY NEW DATA FIELDS ACCORDINGLY.          ** 00950002
      **                                                             ** 00960002
      ****************************************************************/ 00970030
       01  WS-CONSTANTS.                                                
           05  WS-NO                       PIC X(01)  VALUE 'N'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-JOB-PARM                 PIC X(01)  VALUE 'N'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
                                                                        
       01  WS-COUNTERS.                                                 
COB305     05 WS-ACCOUNT-NO-PREV        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-CODE-UTIL-TYPE-PREV      PIC X(01).                   
           05  WS-IC-NO-PREV               PIC S9(09) USAGE COMP.       
COB305     05 WS-BILL-UNITS-BZ        PIC S9(09)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-BILLED-COMP-AM-BZ        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
           05  WS-NO-OF-CONS-DAYS-BG       PIC S9(04) USAGE COMP.       
T77670     05  WS-BILL-NO                  PIC S9(9)  USAGE COMP.       
T77670     05  WS-BILL-ITEM-TIMESTMP       PIC X(26).                   
COB305     05 WS-REBILL-BUNITS        PIC S9(09)V USAGE COMP-3 VALUE 0.    
T77670     05  WS-REBILL-NO-DAYS           PIC S9(04) USAGE COMP.       
COB305     05 WS-REBILL-BILL-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-SUMMARY-RETURN-CODE      PIC S9(09) COMP VALUE ZERO.  
T17670     05  WS-ACCOUNT-RETURN-CODE      PIC S9(09) COMP VALUE ZERO.  
T17670     05  WS-COUNT                    PIC S9(07)  VALUE +0.        
T17670     05  WS-DISPLAY-COUNT            PIC S9(07)  VALUE +0.        
T17670     05  WS-UPDATE-COUNT             PIC S9(07)  VALUE +0.        
T17670     05  WS-REMAINDER                PIC S9(07)  VALUE +0.        
                                                                        
T22220 01  WS-7500-FOUND                  PIC 9(7) VALUE ZERO.          
T22220 01  WS-7500-NOT-FOUND              PIC 9(7) VALUE ZERO.          
                                                                        
T22220 01  WS-8000-INSERTED               PIC 9(7) VALUE ZERO.          
T22220 01  WS-8100-UPDATED                PIC 9(7) VALUE ZERO.          
T22220 01  WS-8100-NOT-FOUND              PIC 9(7) VALUE ZERO.          
                                                                        
T22220 01  WS-8000-BAD-RC                 PIC 9(7) VALUE ZERO.          
T22220 01  WS-8100-BAD-RC                 PIC 9(7) VALUE ZERO.          
                                                                        
                                                                        
       01  WS-TEMP-VARIABLES.                                           
           05  WS-REVENUE-MONTH.                                        
               10 WS-REV-CCYY              PIC 9999.                    
               10 WS-REV-MM                PIC 99.                      
COB305     05 WS-RM01-NUMERIC        PIC S9999999V USAGE COMP-3 VALUE 0.        
COB305     05 WS-RM12-NUMERIC        PIC S9999999V USAGE COMP-3 VALUE 0.        
           05  WS-RM01.                                                 
               10  WS-YEAR-01              PIC 9999V.                   
               10  WS-01                   PIC 99V VALUE 01.            
           05  WS-RM01-R REDEFINES WS-RM01 PIC 9(06).                   
           05  WS-RM12.                                                 
               10  WS-YEAR-12              PIC 9999V.                   
               10  WS-12                   PIC 99V VALUE 12.            
           05  WS-RM12-R REDEFINES WS-RM12 PIC 9(06).                   
ACT144     05  WS-LAST-YEAR                PIC 9999.                    
ACT144     05  WS-CURRENT-DATE             PIC X(10).                   
ACT144     05  FILLER REDEFINES WS-CURRENT-DATE.                        
ACT144         10  WS-CURRENT-CCYY         PIC 9999.                    
ACT144         10  FILLER                  PIC X.                       
ACT144         10  WS-CURRENT-MONTH        PIC 99.                      
ACT144         10  FILLER                  PIC X.                       
ACT144         10  WS-CURRENT-DAY          PIC 99.                      
      /**************************************************************** 01280002
      **     PUT ANY PROGRAM SWITCH VARIABLES YOU NEED HERE.  IF     ** 01290002
      **     POSSIBLE, INCLUDE AT LEAST TWO CONDITION NAMES. IN THE  ** 01300002
      **     PROCEDURE DIVISION, USE "SET CONDITION-NAME TO TRUE"    ** 01310002
      **     RATHER THAN "MOVE 'Y' TO INDICATOR-VARIABLE-NAME"       ** 01320002
      **                                                             ** 01330002
      ****************************************************************/ 01340030
       01  WS-SWITCHES-AND-INDICATORS.                                  
           05  FIRST-TIME-SW               PIC X(01) VALUE 'Y'.         
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSCA525'. 
                                                                        
      /*****************************************************************01420002
      *                                                                *01430002
      *  WORKING STORAGE COPY BOOKS FOLLOW ALL PROGRAM WS              *01440002
      *                                                                *01450002
      ******************************************************************01460002
      /*****   SQL WORK VARIABLES                                       01470012
       COPY CWS00010.                                                   01480099
                                                                        
       COPY CWS00038.                                                   01500099
                                                                        
       COPY CWS00039.                                                   01520099
                                                                        
       COPY CWS0070B.                                                   01540099
                                                                        
       COPY CWS00303.                                                   01560012
                                                                        
       COPY CWS09900.                                                   01580099
                                                                        
       COPY FIOJC01.                                                    01600099
                                                                        
       COPY FIOCA00.                                                    01620099
                                                                        
       01  WS-END                          PIC X(40)                    
           VALUE 'DB2 INCLUDES FOR PCSCA525 START HERE '.               
                                                                        
      /*****************************************************************01670030
      **  CURSOR DECLARATIONS (IF ANY) GO LAST                         *01680030
      ******************************************************************01690030
                                                                        
           EXEC SQL                                                     
T17670          DECLARE ACCOUNT-CURSOR CURSOR WITH HOLD FOR             
T17670          SELECT    ACCOUNT_NO                                    
T17670            FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                     
T77670           WHERE    CODE_ACCT_STAT = 'A'                          
T77670*            AND    ACCOUNT_NO = 1189800002201                            
ACT144                                                      
ACT144                                                           
T17670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01800099
MFA-TR*         DECLARE ACCOUNT-CURSOR CURSOR WITH HOLD FOR             01792023
MFA-TR*         SELECT    ACCOUNT_NO                                    01793011
MFA-TR*           FROM    CSS_ACCOUNT                                   01794011
MFA-TR*          WHERE    CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND    ACCOUNT_NO = 1189800002201                            
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    01795008
                                                                        
           EXEC SQL                                                     
                DECLARE BILL-SUMMARY CURSOR WITH HOLD FOR               
                SELECT    BZ.ACCOUNT_NO,                                
                          BZ.CODE_UTIL_TYPE,                            
                          BZ.IC_NO,                                     
T17670                    BZ.BILL_NO,                                   
                          BZ.BILL_UNITS,                                
                          BG.NO_OF_CONS_DAYS,                           
                          BZ.BILLED_COMP_AM,                            
                          BG.REVENUE_MONTH,                             
                          BI.CODE_BILL_STATUS,                          
                          BG.CODE_BILL_ITM_TYPE,                        
                          BG.CODE_BILL_ITM_IND,                         
                          BZ.INSTR_USE_TYPE_CD                          
                  FROM    CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED),           
                          CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),           
                          CSS_BILLING_DET   BG WITH(READUNCOMMITTED)            
T17670*          WHERE    BG.REVENUE_MONTH BETWEEN 0                    01960000
T17670           WHERE    BG.REVENUE_MONTH BETWEEN :WS-RM01-NUMERIC     
                   AND    :WS-RM12-NUMERIC                              
T17670             AND    BG.REV_MTH_ORIG_BILL = 0                      
T17670             AND    BZ.ACCOUNT_NO         = :AT-ACCOUNT-NO        
                   AND    BG.ACCOUNT_NO         = BZ.ACCOUNT_NO         
                   AND    BI.ACCOUNT_NO         = BG.ACCOUNT_NO         
                   AND    BG.BILL_NO            = BZ.BILL_NO            
                   AND    BI.BILL_NO            = BG.BILL_NO            
                   AND    BG.CODE_UTIL_TYPE     = BZ.CODE_UTIL_TYPE     
                   AND    BG.IC_NO              = BZ.IC_NO              
                   AND    BG.BILL_ITEM_TIMESTMP = BZ.BILL_ITEM_TIMESTMP 
T17670*            AND    (BI.CODE_BILL_STATUS   = 'A'                  02050004
T17670*             OR    BI.CODE_BILL_STATUS   = 'I')                  02060004
T17670*            AND    BG.CODE_BILL_ITM_TYPE = 'C'                   02070004
T17670             AND    BG.CODE_BILL_ITM_TYPE <> 'B'                  
T17670*            AND    BG.CODE_BILL_ITM_IND  = 'A'                   02080004
T17670             AND    BG.CODE_BILL_ITM_IND  <> 'B'                  
T17670             AND    BG.CODE_BILL_ITM_IND  <> 'J'                  
T77670*            AND    BZ.INSTR_USE_TYPE_CD  = 'R'                   02090099
T17670       ORDER BY     BZ.CODE_UTIL_TYPE,                            
T17670                    BZ.IC_NO                                      
T77670                   ,BZ.BILL_NO                                    
ACT144                                                      
ACT144                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01800000
MFA-TR*         DECLARE BILL-SUMMARY CURSOR WITH HOLD FOR               01810026
MFA-TR*         SELECT    BZ.ACCOUNT_NO,                                01820099
MFA-TR*                   BZ.CODE_UTIL_TYPE,                            01830099
MFA-TR*                   BZ.IC_NO,                                     01840099
MFA-TR*                   BZ.BILL_NO,                                   01841016
MFA-TR*                   BZ.BILL_UNITS,                                01850099
MFA-TR*                   BG.NO_OF_CONS_DAYS,                           01860099
MFA-TR*                   BZ.BILLED_COMP_AM,                            01870099
MFA-TR*                   BG.REVENUE_MONTH,                             01880099
MFA-TR*                   BI.CODE_BILL_STATUS,                          01890099
MFA-TR*                   BG.CODE_BILL_ITM_TYPE,                        01900099
MFA-TR*                   BG.CODE_BILL_ITM_IND,                         01910099
MFA-TR*                   BZ.INSTR_USE_TYPE_CD                          01920099
MFA-TR*           FROM    CSS_BILL_CALC_DET BZ,                         01930099
MFA-TR*                   CSS_BILLING_HDR   BI,                         01940099
MFA-TR*                   CSS_BILLING_DET   BG                          01950099
MFA-TR*          WHERE    BG.REVENUE_MONTH BETWEEN 0                    01960000
MFA-TR*          WHERE    BG.REVENUE_MONTH BETWEEN :WS-RM01-NUMERIC     01961000
MFA-TR*            AND    :WS-RM12-NUMERIC                              01970099
MFA-TR*            AND    BG.REV_MTH_ORIG_BILL = 0                      01971004
MFA-TR*            AND    BZ.ACCOUNT_NO         = :AT-ACCOUNT-NO        01972008
MFA-TR*            AND    BG.ACCOUNT_NO         = BZ.ACCOUNT_NO         01980099
MFA-TR*            AND    BI.ACCOUNT_NO         = BG.ACCOUNT_NO         01990099
MFA-TR*            AND    BG.BILL_NO            = BZ.BILL_NO            02000099
MFA-TR*            AND    BI.BILL_NO            = BG.BILL_NO            02010099
MFA-TR*            AND    BG.CODE_UTIL_TYPE     = BZ.CODE_UTIL_TYPE     02020099
MFA-TR*            AND    BG.IC_NO              = BZ.IC_NO              02030099
MFA-TR*            AND    BG.BILL_ITEM_TIMESTMP = BZ.BILL_ITEM_TIMESTMP 02040099
MFA-TR*            AND    (BI.CODE_BILL_STATUS   = 'A'                  02050004
MFA-TR*             OR    BI.CODE_BILL_STATUS   = 'I')                  02060004
MFA-TR*            AND    BG.CODE_BILL_ITM_TYPE = 'C'                   02070004
MFA-TR*            AND    BG.CODE_BILL_ITM_TYPE <> 'B'                  02071004
MFA-TR*            AND    BG.CODE_BILL_ITM_IND  = 'A'                   02080004
MFA-TR*            AND    BG.CODE_BILL_ITM_IND  <> 'B'                  02081004
MFA-TR*            AND    BG.CODE_BILL_ITM_IND  <> 'J'                  02082004
MFA-TR*            AND    BZ.INSTR_USE_TYPE_CD  = 'R'                   02090099
MFA-TR*      ORDER BY     BZ.CODE_UTIL_TYPE,                            02092031
MFA-TR*                   BZ.IC_NO                                      02093003
MFA-TR*                  ,BZ.BILL_NO                                            
MFA-TR*      QUERYNO 2200                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    02100099
                                                                        
T17670     EXEC SQL                                                     
T17670        DECLARE BG-CANCEL-CURSOR CURSOR WITH HOLD FOR             
T17670     SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           BZ.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                                
T17670            BZ.BILL_UNITS,                                        
T17670            BG.NO_OF_CONS_DAYS,                                   
T17670            BZ.BILLED_COMP_AM                                     
T77670           ,BZ.INSTR_USE_TYPE_CD                                  
T17670       FROM CSS_BILLING_DET   BG WITH(READUNCOMMITTED),                   
T17670            CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                    
T17670      WHERE BG.ACCOUNT_NO        = :BZ-ACCOUNT-NO                 
T17670        AND BZ.ACCOUNT_NO        = BG.ACCOUNT_NO                  
T17670        AND BG.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE             
T17670        AND BZ.CODE_UTIL_TYPE    = BG.CODE_UTIL_TYPE              
T17670        AND BG.IC_NO             = :BZ-IC-NO                      
T17670        AND BZ.IC_NO             = BG.IC_NO                       
T17670        AND BZ.BILL_NO           = BG.BILL_NO                     
T17670        AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP         
T17670        AND BG.REV_MTH_ORIG_BILL <> 0                             
T17670        AND BG.DATE_ORIG_BILL    = (                              
T17670            SELECT DATE_BILLED                                    
T17670              FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                  
T17670             WHERE ACCOUNT_NO = :BZ-ACCOUNT-NO                    
T17670               AND BILL_NO    = :BZ-BILL-NO)                      
T17670      ORDER BY BILL_ITEM_TIMESTMP DESC                         
ACT144                                                      
ACT144                                                           
T17670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02112004
MFA-TR*       DECLARE BG-CANCEL-CURSOR CURSOR WITH HOLD FOR             02113023
MFA-TR*    SELECT BZ.BILL_ITEM_TIMESTMP,                                02114004
MFA-TR*           BZ.BILL_UNITS,                                        02114104
MFA-TR*           BG.NO_OF_CONS_DAYS,                                   02115004
MFA-TR*           BZ.BILLED_COMP_AM                                     02116004
MFA-TR*          ,BZ.INSTR_USE_TYPE_CD                                  01920099
MFA-TR*      FROM CSS_BILLING_DET   BG,                                 02118004
MFA-TR*           CSS_BILL_CALC_DET BZ                                  02118104
MFA-TR*     WHERE BG.ACCOUNT_NO        = :BZ-ACCOUNT-NO                 02119004
MFA-TR*       AND BZ.ACCOUNT_NO        = BG.ACCOUNT_NO                  02119104
MFA-TR*       AND BG.CODE_UTIL_TYPE    = :BZ-CODE-UTIL-TYPE             02119204
MFA-TR*       AND BZ.CODE_UTIL_TYPE    = BG.CODE_UTIL_TYPE              02119304
MFA-TR*       AND BG.IC_NO             = :BZ-IC-NO                      02119404
MFA-TR*       AND BZ.IC_NO             = BG.IC_NO                       02119504
MFA-TR*       AND BZ.BILL_NO           = BG.BILL_NO                     02119604
MFA-TR*       AND BZ.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP         02119704
MFA-TR*       AND BG.REV_MTH_ORIG_BILL <> 0                             02119804
MFA-TR*       AND BG.DATE_ORIG_BILL    = (                              02119904
MFA-TR*           SELECT DATE_BILLED                                    02120004
MFA-TR*             FROM CSS_BILLING_HDR                                02120104
MFA-TR*            WHERE ACCOUNT_NO = :BZ-ACCOUNT-NO                    02120204
MFA-TR*              AND BILL_NO    = :BZ-BILL-NO)                      02120304
MFA-TR*     ORDER BY BZ.BILL_ITEM_TIMESTMP DESC                         02120406
MFA-TR*     QUERYNO 7275                                                        
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                    02120504
                                                                        
                                                                        
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **02140099
      **                                                              **02150002
      **    0000-MAINLINE                                             **02160002
      **                                                              **02170004
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **02180002
       0000-MAINLINE.                                                   
      *    INITIALIZE WS-WORK-VARIABLES                                 02200030
      **   SET ALL CONDITION NAMES TO THEIR DEFAULT VALUES              02210030
                                                                        
           MOVE ZERO  TO WS-ACCOUNT-NO-PREV.                            
                                                                        
           PERFORM 1000-INITIALIZE-VARIABLES THRU 1000-EXIT.            
           PERFORM 2000-CHECK-JOB-PARM       THRU 2000-EXIT.            
T17670*    PERFORM 2200-GET-BILL-SUMMARY     THRU 2200-EXIT             02290008
T17670*      UNTIL WS-SUMMARY-RETURN-CODE EQUAL NOT-FOUND.              02300008
T17670*    PERFORM 7020-CLOSE-BILL-SUMMARY   THRU 7020-EXIT.            02310008
T17670     PERFORM 7100-OPEN-ACCOUNT-CURSOR  THRU 7100-EXIT.            
T17670     PERFORM 7150-FETCH-ACCOUNT-CURSOR THRU 7150-EXIT             
T17670     PERFORM 2150-PROCESS-ACCOUNT      THRU 2150-EXIT             
T17670             UNTIL WS-ACCOUNT-RETURN-CODE = NOT-FOUND             
T17670     PERFORM 7200-CLOSE-ACCOUNT-CURSOR THRU 7200-EXIT.            
T17670     DISPLAY '  PROCESS COMPLETED NORMALLY...'.                   
                                                                        
T22220     DISPLAY 'NUMBER RECORDS FOUND IN PARA 7500         = '       
T22220             WS-7500-FOUND.                                       
T22220                                                                  
T22220     DISPLAY 'NUMBER RECORDS NOT FOUND IN PARA 7500     = '       
T22220             WS-7500-NOT-FOUND.                                   
T22220                                                                  
T22220     DISPLAY 'NUMBER RECORDS INSERTED IN PARA 8000      = '       
T22220             WS-8000-INSERTED.                                    
T22220                                                                  
T22220     DISPLAY 'NUMBER OF BAD DB2 CALLIS IN PARA 8000     = '       
T22220             WS-8000-BAD-RC.                                      
T22220                                                                  
T22220     DISPLAY 'NUMBER RECORDS CHANGED IN PARA 8100       = '       
T22220             WS-8100-UPDATED.                                     
T22220                                                                  
T22220     DISPLAY 'NUMBER RECORDS NOT FOUND PARA 8100        = '       
T22220             WS-8100-NOT-FOUND.                                   
T22220                                                                  
T22220     DISPLAY 'NUMBER OF BAD DB2 CALLIS IN PARA 8100     = '       
T22220             WS-8100-BAD-RC.                                      
T22220                                                                  
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 02370099
      *                                                               * 02380099
      *    1000-INITIALIZE-VARIABLES.                                 * 02390099
      *                                                               * 02400099
      *    INITIALIZE COUNTER VARIABLES TO THEIR RESPECTIVE VALUES.   * 02410099
      *                                                               * 02420099
      ***************************************************************** 02430099
       1000-INITIALIZE-VARIABLES.                                       
           IF FIRST-TIME-SW EQUAL WS-YES                                
              MOVE SPACE TO WS-CODE-UTIL-TYPE-PREV                      
              MOVE ZERO  TO WS-BILL-UNITS-BZ                            
                            WS-BILLED-COMP-AM-BZ                        
                            WS-NO-OF-CONS-DAYS-BG                       
                            WS-IC-NO-PREV                               
           ELSE                                                         
              MOVE ZERO TO WS-BILL-UNITS-BZ                             
                           WS-BILLED-COMP-AM-BZ                         
                           WS-NO-OF-CONS-DAYS-BG                        
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 02590099
      *                                                               * 02600099
      *    2000-CHECK-JOB-PARM                                        * 02610099
      *        CHECK TO SEE IF A JOB PARM EXISTS FOR THIS PROGRAM     * 02620099
      *        AND OPEN THE CURSOR.                                   * 02630099
      *                                                               * 02640099
      ***************************************************************** 02650099
       2000-CHECK-JOB-PARM.                                             
           MOVE WS-PGRMNAME  TO WS-PROGRAM.                             
           MOVE WS-PARM      TO WS-COMMAND.                             
           MOVE WS-A         TO G6-STATUS.                              
ACT144     PERFORM 7600-START-FCSJC01    THRU 7600-EXIT.                
ACT144     PERFORM 7610-READ-FCSJC01     THRU 7610-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE WS-YES   TO WS-JOB-PARM                             
           END-IF.                                                      
ACT144     PERFORM 7611-CLOSE            THRU 7611-EXIT.                
T17670*    MOVE G6-PARM-DATA TO WS-REVENUE-MONTH.                       02850001
T17670     MOVE G6-PARM-DATA TO WS-INPUT-DATA-BREAKDOWN                 
T17670     MOVE WS-REVENUE-MONTH-PARM TO WS-REVENUE-MONTH               
           MOVE WS-REV-CCYY  TO WS-YEAR-01                              
                                WS-YEAR-12.                             
                                                                        
           MOVE WS-RM01-R    TO WS-RM01-NUMERIC.                        
           MOVE WS-RM12-R    TO WS-RM12-NUMERIC.                        
T22220                                                                  
T22220     DISPLAY 'PARM DATA FROM JOB CARD '                           
T22220             G6-PARM-DATA.                                        
ACT144     MOVE 'COMMON  ' TO WS-PGRMNAME.                              
ACT144     MOVE SPACES     TO WS-INPUT-AREA                             
ACT144                        WS-INPUT-DATA-BREAKDOWN.                  
ACT144     PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
ACT144     MOVE WS-INPUT-RUN-DATE TO WS-CURRENT-DATE.                   
T22220                                                                  
T22220     COMPUTE WS-LAST-YEAR = WS-CURRENT-CCYY - 1.                  
ACT144     DISPLAY 'USING LAST YEAR OF ' WS-LAST-YEAR.                  
T22220                                                                  
ACT144     MOVE WS-LAST-YEAR      TO WS-YEAR-01                         
T22220                               WS-YEAR-12                         
T22220                               WS-REV-CCYY.                       
T22220                                                                  
T22220     MOVE WS-RM01-R    TO WS-RM01-NUMERIC.                        
T22220     MOVE WS-RM12-R    TO WS-RM12-NUMERIC.                        
T22220                                                                  
T22220     DISPLAY 'BETWEEN DATES USED IN BILL-SUMMARY CALL'.           
T22220     DISPLAY WS-RM01-NUMERIC ' '                                  
T22220             WS-RM12-NUMERIC.                                     
T22220                                                                  
T22220                                                                  
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17670*                                                                 02931008
T17670 2150-PROCESS-ACCOUNT.                                            
T17670     MOVE ZEROS  TO WS-SUMMARY-RETURN-CODE                        
T17670     MOVE WS-YES TO FIRST-TIME-SW                                 
T17670     PERFORM 7000-OPEN-BILL-SUMMARY    THRU 7000-EXIT             
T17670     PERFORM 7010-FETCH-BILL-SUMMARY   THRU 7010-EXIT.            
T17670     PERFORM 2300-PROCESS-BILL-SUMMARY THRU 2300-EXIT             
T17670       UNTIL WS-SUMMARY-RETURN-CODE = NOT-FOUND                   
T17670     PERFORM 7020-CLOSE-BILL-SUMMARY   THRU 7020-EXIT             
T17670     IF WS-BILL-UNITS-BZ      NOT = 0 OR                          
T17670        WS-NO-OF-CONS-DAYS-BG NOT = 0 OR                          
T17670        WS-BILLED-COMP-AM-BZ  NOT = 0                             
T17670        PERFORM 2510-CREATE-SUMMARY-PART2 THRU 2510-EXIT          
T17670        PERFORM 1000-INITIALIZE-VARIABLES THRU 1000-EXIT
           END-IF.         
T17670     PERFORM 7150-FETCH-ACCOUNT-CURSOR THRU 7150-EXIT.            
T17670*                                                                 02938109
T17670 2150-EXIT.                                                       
T17670     EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **02940099
      **                                                              **02950099
      ** 2200-GET-BILL-SUMMARY.                                       **02960099
      **                                                              **02970099
      ** SELECT DATA FROM THE BILL-SUMMARY CURSOR.                    **02980099
      **                                                              **02990099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03000099
       2200-GET-BILL-SUMMARY.                                           
T17670*    IF FIRST-TIME-SW = WS-YES                                    03020015
T17670*       PERFORM 7000-OPEN-BILL-SUMMARY THRU 7000-EXIT             03030015
T17670*    END-IF.                                                      03040015
                                                                        
T17670*    PERFORM 7010-FETCH-BILL-SUMMARY THRU 7010-EXIT.              03060015
T17670*    MOVE SQLCODE    TO WS-SUMMARY-RETURN-CODE.                   03070015
T17670*    EVALUATE WS-SUMMARY-RETURN-CODE                              03080015
T17670*    WHEN SUCCESSFUL-CALL                                         03090015
T17670*       PERFORM 2300-PROCESS-BILL-SUMMARY THRU 2300-EXIT          03100015
T17670*    WHEN NOT-FOUND                                               03110015
T17670*       CONTINUE                                                  03120015
T17670*    WHEN OTHER                                                   03130015
T17670*       MOVE 'BZ'                TO  WS-DB2-TABLE-ID              03140015
T17670*       MOVE 'OPEN'              TO  WS-DB2-FUNCTION              03150015
T17670*       MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           03160015
T17670*       MOVE '525'               TO  WS-DB2-MODULE-ID             03170015
T17670*       MOVE '7000'              TO  WS-DB2-PARAGRAPH             03180015
T17670*       MOVE BZ-ACCOUNT-NO       TO  WS-DB2-KEY-1N                03190015
T17670*       MOVE 12                  TO  RETURN-CODE                  03200015
T17670*       PERFORM 9900-ABEND     THRU 9900-EXIT.                    03210015
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03250099
      **                                                              **03260099
      ** 2300-PROCESS-BILL-SUMMARY.                                   **03270099
      **                                                              **03280099
      ** PROCESS THE BILL-SUMMARY TABLE.  IF ACCOUNT-NO,              **03290099
      ** CODE-UTIL-TYPE OR IC-NO DOES NOT EXIST THEN INSERT THE RECORD**03300099
      ** INTO CSS_ANNUAL_SUMMARY.  IF THE CONDITIONS EXIST THEN       **03310099
      ** UPDATE CSS_ANNUAL_SUMMARY.                                   **03320099
      **                                                              **03330099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03340099
       2300-PROCESS-BILL-SUMMARY.                                       
           IF FIRST-TIME-SW = WS-YES                                    
T17670*       MOVE BZ-ACCOUNT-NO TO WS-ACCOUNT-NO-PREV                  03370013
T17670*       MOVE BZ-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE-PREV          03380013
T17670*       MOVE BZ-IC-NO TO WS-IC-NO-PREV                            03390013
T17670*       MOVE WS-NO TO FIRST-TIME-SW                               03400013
              PERFORM 2500-CREATE-SUMMARY-PART1 THRU 2500-EXIT          
           END-IF.                                                      
                                                                        
           IF  WS-ACCOUNT-NO-PREV EQUAL BZ-ACCOUNT-NO                   
           AND WS-CODE-UTIL-TYPE-PREV EQUAL BZ-CODE-UTIL-TYPE           
           AND WS-IC-NO-PREV EQUAL BZ-IC-NO                             
              CONTINUE                                                  
           ELSE                                                         
T17670        IF WS-BILL-UNITS-BZ      NOT = 0 OR                       
T17670           WS-NO-OF-CONS-DAYS-BG NOT = 0 OR                       
T17670           WS-BILLED-COMP-AM-BZ  NOT = 0                          
                 PERFORM 2510-CREATE-SUMMARY-PART2 THRU 2510-EXIT       
T17670        END-IF                                                    
              MOVE WS-YES TO FIRST-TIME-SW                              
              PERFORM 1000-INITIALIZE-VARIABLES THRU 1000-EXIT          
T17670*       MOVE WS-NO  TO FIRST-TIME-SW                              03520013
              PERFORM 2500-CREATE-SUMMARY-PART1 THRU 2500-EXIT          
           END-IF.                                                      
                                                                        
T77670     IF BZ-INSTR-USE-TYPE-CD = 'R' OR 'D'                         
T17670     IF BZ-CODE-UTIL-TYPE NOT = 'U' OR                            
T17670       (BZ-CODE-UTIL-TYPE = 'U' AND BG-REVENUE-MONTH > 199912)    
             PERFORM 2400-CALCULATE-SUMMARY    THRU 2400-EXIT
           END-IF
           END-IF.          
T17670     PERFORM 7010-FETCH-BILL-SUMMARY   THRU 7010-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03610099
      **                                                              **03620099
      ** 2400-CALCULATE-SUMMARY.                                      **03630099
      **                                                              **03640099
      ** CALCULATE GRAND TOTAL VARIABLES.                             **03650099
      **                                                              **03660099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03670099
       2400-CALCULATE-SUMMARY.                                          
T17670                                                                  
T17670     IF BG-CODE-BILL-ITM-IND = 'K'                                
T77670        IF BZ-BILL-NO NOT = WS-BILL-NO                            
T17670           PERFORM 2450-OBTAIN-LAST-BILL THRU 2450-EXIT           
T77670        ELSE                                                      
T77670           MOVE ZEROS TO BZ-BILL-UNITS                            
T77670                         BG-NO-OF-CONS-DAYS                       
T77670                         BZ-BILLED-COMP-AM                        
T77670        END-IF                                                    
T17670     END-IF                                                       
T77670*                                                                         
T77670     IF BZ-INSTR-USE-TYPE-CD NOT = 'D'                            
              COMPUTE WS-BILL-UNITS-BZ =                                
                   WS-BILL-UNITS-BZ + BZ-BILL-UNITS
           END-IF.                    
                                                                        
T77670********************                                                      
T77670*    ACCUMULATE NO OF DAYS ONLY ONCE FOR A SPECIFIC BILL NO               
T77670********************                                                      
                                                                        
T77670     IF WS-BILL-NO = 0 OR BZ-BILL-NO NOT = WS-BILL-NO             
T77670        MOVE BZ-BILL-NO TO WS-BILL-NO                             
              COMPUTE WS-NO-OF-CONS-DAYS-BG =                           
                   WS-NO-OF-CONS-DAYS-BG + BG-NO-OF-CONS-DAYS
           END-IF.          
                                                                        
           COMPUTE WS-BILLED-COMP-AM-BZ =                               
                   WS-BILLED-COMP-AM-BZ + BZ-BILLED-COMP-AM.            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17670                                                                  
T17670 2450-OBTAIN-LAST-BILL.                                           
T17670*                                                                 03803008
T17670     PERFORM 7275-OPEN-BG-CANCEL-CURSOR  THRU 7275-EXIT           
T17670     PERFORM 7280-FETCH-BG-CANCEL-CURSOR THRU 7280-EXIT           
T17670     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T17670        MOVE ZEROS TO BZ-BILL-UNITS                               
T17670                      BG-NO-OF-CONS-DAYS                          
T17670                      BZ-BILLED-COMP-AM                           
T77670     ELSE                                                         
T77670        MOVE ZEROS              TO WS-REBILL-BUNITS               
T77670                                   WS-REBILL-BILL-AMT             
T77670        MOVE BG-NO-OF-CONS-DAYS TO WS-REBILL-NO-DAYS              
T77670        MOVE BG-BILL-ITEM-TIMESTMP TO WS-BILL-ITEM-TIMESTMP       
T77670        PERFORM UNTIL BG-BILL-ITEM-TIMESTMP NOT =                 
T77670                      WS-BILL-ITEM-TIMESTMP OR                    
T77670                      WS-ACTIVE-RETURN-CODE = NOT-FOUND           
T77670                IF BZ-INSTR-USE-TYPE-CD = 'R' OR 'D'              
T77670                   ADD BZ-BILLED-COMP-AM TO WS-REBILL-BILL-AMT    
T77670                   IF BZ-INSTR-USE-TYPE-CD = 'R'                  
T77670                      ADD BZ-BILL-UNITS TO WS-REBILL-BUNITS       
T77670                   END-IF                                         
T77670                END-IF                                            
T77670                PERFORM 7280-FETCH-BG-CANCEL-CURSOR THRU 7280-EXIT
T77670        END-PERFORM                                               
T77670        MOVE 'R'                TO BZ-INSTR-USE-TYPE-CD           
T77670        MOVE WS-REBILL-BUNITS   TO BZ-BILL-UNITS                  
T77670        MOVE WS-REBILL-BILL-AMT TO BZ-BILLED-COMP-AM              
T77670        MOVE WS-REBILL-NO-DAYS  TO BG-NO-OF-CONS-DAYS             
T17670     END-IF                                                       
T17670     PERFORM 7285-CLOSE-BG-CANCEL-CURSOR THRU 7285-EXIT.          
T17670                                                                  
T17670 2450-EXIT.                                                       
T17670     EXIT.                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03810099
      **                                                              **03820099
      ** 2500-CREATE-SUMMARY-PART1.                                   **03830099
      **                                                              **03840099
      ** BUILD CSS_ANNUAL_SUMMARY TABLE.                              **03850099
      **                                                              **03860099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03870099
       2500-CREATE-SUMMARY-PART1.                                       
                                                                        
           MOVE BZ-ACCOUNT-NO          TO  AS-ACCOUNT-NO.               
           MOVE BZ-CODE-UTIL-TYPE      TO  AS-CODE-UTIL-TYPE.           
           MOVE BZ-IC-NO               TO  AS-IC-NO.                    
           MOVE WS-REV-CCYY            TO  AS-SUMMARY-YEAR.             
T17670     MOVE BZ-ACCOUNT-NO          TO  WS-ACCOUNT-NO-PREV           
T17670     MOVE BZ-CODE-UTIL-TYPE      TO  WS-CODE-UTIL-TYPE-PREV       
T17670     MOVE BZ-IC-NO               TO  WS-IC-NO-PREV                
T17670     MOVE WS-NO                  TO  FIRST-TIME-SW.               
T77670     MOVE ZEROS                  TO  WS-BILL-NO.                  
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **03980099
      **                                                              **03990099
      ** 2510-CREATE-SUMMARY-PART2.                                   **04000099
      **                                                              **04010099
      ** BUILD CSS_ANNUAL_SUMMARY TABLE.                              **04020099
      **                                                              **04030099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04040099
       2510-CREATE-SUMMARY-PART2.                                       
                                                                        
           MOVE WS-BILL-UNITS-BZ       TO  AS-TOTAL-USAGE.              
           MOVE WS-NO-OF-CONS-DAYS-BG  TO  AS-NO-DAYS.                  
           MOVE WS-BILLED-COMP-AM-BZ   TO  AS-TOTAL-REVENUE.            
                                                                        
           PERFORM 7500-SELECT-BILL-SUMMARY THRU 7500-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8000-INSERT-CSS-ANNUAL-SUMMARY THRU 8000-EXIT     
           ELSE                                                         
              PERFORM 8100-UPDATE-CSS-ANNUAL-SUMMARY THRU 8100-EXIT     
T17670        ADD 1 TO WS-UPDATE-COUNT                                  
           END-IF.                                                      
T17670     ADD 1 TO WS-COUNT                                            
T17670     DIVIDE WS-COUNT BY 1000 GIVING WS-DISPLAY-COUNT              
T17670            REMAINDER WS-REMAINDER                                
T17670     IF WS-REMAINDER = 0                                          
T17670        EXEC SQL                                                  
T17670             COMMIT                                               
T17670        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17670        DISPLAY 'COUNTER:  ' WS-COUNT                             
T17670        DISPLAY 'UPDATES:  ' WS-UPDATE-COUNT                      
T17670     END-IF.                                                      
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT144     EXEC SQL                                                             
ACT144         INCLUDE CPD00037                                                 
ACT144     END-EXEC.                                                            
ACT144******************************************************************        
ACT144**     7600-START-FCSJC01                                                 
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04210004
      ** 5000 SERIES PARAGRAPHS ARE "COMMON" OR "UTILITY" PARAGRAPHS  **04220002
      **                                                              **04230002
      **                                                              **04240002
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04250099
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04270099
      **    7000-OPEN-BILL-SUMMARY.                                   **04280099
      **                                                              **04290099
      **    OPEN CURSOR FOR BILL-SUMMARY.                             **04300099
      **                                                              **04310099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04320099
       7000-OPEN-BILL-SUMMARY.                                          
           EXEC SQL                                                     
                OPEN BILL-SUMMARY                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE                     
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BZ'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7000'              TO  WS-DB2-PARAGRAPH             
              MOVE BZ-ACCOUNT-NO       TO  WS-DB2-KEY-1N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04530099
      **    7010-FETCH-BILL-SUMMARY.                                  **04540099
      **                                                              **04550099
      **    FETCH COLUMNS FROM CSS_BILL_CALC_DET, CSS_BILLING_HDR AND **04560099
      **    CSS_BILLING_DET.                                          **04570099
      **                                                              **04580099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04590099
       7010-FETCH-BILL-SUMMARY.                                         
           EXEC SQL                                                     
                FETCH     BILL-SUMMARY                                  
                 INTO     :BZ-ACCOUNT-NO,                               
                          :BZ-CODE-UTIL-TYPE,                           
                          :BZ-IC-NO,                                    
T17670                    :BZ-BILL-NO,                                  
                          :BZ-BILL-UNITS,                               
                          :BG-NO-OF-CONS-DAYS,                          
                          :BZ-BILLED-COMP-AM,                           
                          :BG-REVENUE-MONTH,                            
                          :BI-CODE-BILL-STATUS,                         
                          :BG-CODE-BILL-ITM-TYPE,                       
                          :BG-CODE-BILL-ITM-IND,                        
                          :BZ-INSTR-USE-TYPE-CD                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-SUMMARY-RETURN-CODE.                   
           IF WS-SUMMARY-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              OR NOT-FOUND                                              
                CONTINUE                                                
           ELSE                                                         
                MOVE 'BZ'                TO  WS-DB2-TABLE-ID            
                MOVE 'FETCH'             TO  WS-DB2-FUNCTION            
                MOVE SQLCODE             TO  WS-DB2-RETURN-CODE         
                MOVE '525'               TO  WS-DB2-MODULE-ID           
                MOVE '7010'              TO  WS-DB2-PARAGRAPH           
                MOVE BZ-ACCOUNT-NO       TO  WS-DB2-KEY-1N              
                MOVE 12                  TO  RETURN-CODE                
                PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                  
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04920099
      **    7020-CLOSE-BILL-SUMMARY.                                  **04930099
      **                                                              **04940099
      **    CLOSE CURSOR FOR BILL-SUMMARY.                            **04950099
      **                                                              **04960099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **04970099
       7020-CLOSE-BILL-SUMMARY.                                         
           EXEC SQL                                                     
                CLOSE BILL-SUMMARY                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'BZ'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7020'              TO  WS-DB2-PARAGRAPH             
              MOVE BZ-ACCOUNT-NO       TO  WS-DB2-KEY-1N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-ACCOUNT-CURSOR.                                        
           EXEC SQL                                                     
                OPEN ACCOUNT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE                     
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7100'              TO  WS-DB2-PARAGRAPH             
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-FETCH-ACCOUNT-CURSOR.                                       
           EXEC SQL                                                     
                FETCH     ACCOUNT-CURSOR                                
                 INTO     :AT-ACCOUNT-NO                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACCOUNT-RETURN-CODE.                   
           IF WS-ACCOUNT-RETURN-CODE EQUAL SUCCESSFUL-CALL              
              OR NOT-FOUND                                              
                CONTINUE                                                
           ELSE                                                         
                MOVE 'AT'                TO  WS-DB2-TABLE-ID            
                MOVE 'FETCH'             TO  WS-DB2-FUNCTION            
                MOVE SQLCODE             TO  WS-DB2-RETURN-CODE         
                MOVE '525'               TO  WS-DB2-MODULE-ID           
                MOVE '7150'              TO  WS-DB2-PARAGRAPH           
                MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N              
                MOVE 12                  TO  RETURN-CODE                
                PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                  
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CLOSE-ACCOUNT-CURSOR.                                       
           EXEC SQL                                                     
                CLOSE ACCOUNT-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AT'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7200'              TO  WS-DB2-PARAGRAPH             
              MOVE AT-ACCOUNT-NO       TO  WS-DB2-KEY-1N                
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17670 7275-OPEN-BG-CANCEL-CURSOR.                                      
T17670*                                                                 05179608
           EXEC SQL                                                     
                OPEN BG-CANCEL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AS'                TO  WS-DB2-TABLE-ID              
              MOVE 'OPEN'              TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7275'              TO  WS-DB2-PARAGRAPH             
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17670 7280-FETCH-BG-CANCEL-CURSOR.                                     
T17670*                                                                 05181608
           EXEC SQL                                                     
                FETCH BG-CANCEL-CURSOR                                  
                INTO  :BG-BILL-ITEM-TIMESTMP,                           
                      :BZ-BILL-UNITS,                                   
                      :BG-NO-OF-CONS-DAYS,                              
                      :BZ-BILLED-COMP-AM                                
T77670               ,:BZ-INSTR-USE-TYPE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AS'                TO  WS-DB2-TABLE-ID              
              MOVE 'FETCH'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7280'              TO  WS-DB2-PARAGRAPH             
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17670 7285-CLOSE-BG-CANCEL-CURSOR.                                     
T17670*                                                                 05184108
           EXEC SQL                                                     
                CLOSE BG-CANCEL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AS'                TO  WS-DB2-TABLE-ID              
              MOVE 'CLOSE'             TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7285'              TO  WS-DB2-PARAGRAPH             
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
                                                                        
       7285-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05180099
      **    7500-SELECT-BILL-SUMMARY.                                 **05190099
      **                                                              **05200099
      **    SELECT COLUMN NAMES FOR ANNUAL-SUMMARY TABLE.             **05210099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05220099
       7500-SELECT-BILL-SUMMARY.                                        
           EXEC SQL                                                     
                SELECT   ACCOUNT_NO,                                    
                         IC_NO,                                         
                         CODE_UTIL_TYPE,                                
                         SUMMARY_YEAR                                   
                  INTO   :AS-ACCOUNT-NO,                                
                         :AS-IC-NO,                                     
                         :AS-CODE-UTIL-TYPE,                            
                         :AS-SUMMARY-YEAR                               
                  FROM   CSS_ANNUAL_SUMMARY WITH(READUNCOMMITTED)               
                 WHERE   ACCOUNT_NO     = :AS-ACCOUNT-NO                
                   AND   IC_NO          = :AS-IC-NO                     
                   AND   CODE_UTIL_TYPE = :AS-CODE-UTIL-TYPE            
T17670             AND   SUMMARY_YEAR   = :AS-SUMMARY-YEAR              
ACT144                                                      
ACT144                                                           
          END-EXEC.                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05240099
MFA-TR*         SELECT   ACCOUNT_NO,                                    05250099
MFA-TR*                  IC_NO,                                         05260099
MFA-TR*                  CODE_UTIL_TYPE,                                05270099
MFA-TR*                  SUMMARY_YEAR                                   05280099
MFA-TR*           INTO   :AS-ACCOUNT-NO,                                05290099
MFA-TR*                  :AS-IC-NO,                                     05300099
MFA-TR*                  :AS-CODE-UTIL-TYPE,                            05310099
MFA-TR*                  :AS-SUMMARY-YEAR                               05320099
MFA-TR*           FROM   CSS_ANNUAL_SUMMARY                             05330099
MFA-TR*          WHERE   ACCOUNT_NO     = :AS-ACCOUNT-NO                05340099
MFA-TR*            AND   IC_NO          = :AS-IC-NO                     05350099
MFA-TR*            AND   CODE_UTIL_TYPE = :AS-CODE-UTIL-TYPE            05360099
MFA-TR*            AND   SUMMARY_YEAR   = :AS-SUMMARY-YEAR              05361003
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*   END-EXEC.                                                     05370099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'AS'                TO  WS-DB2-TABLE-ID              
              MOVE 'SELECT'            TO  WS-DB2-FUNCTION              
              MOVE SQLCODE             TO  WS-DB2-RETURN-CODE           
              MOVE '525'               TO  WS-DB2-MODULE-ID             
              MOVE '7500'              TO  WS-DB2-PARAGRAPH             
              MOVE 12                  TO  RETURN-CODE                  
              PERFORM 9900-ABEND     THRU 9900-EXIT
           END-IF.                    
                                                                        
T22220     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22220         ADD 1 TO WS-7500-FOUND                                   
T22220         ELSE                                                     
T22220         ADD 1 TO WS-7500-NOT-FOUND
           END-IF.                              
T22220                                                                  
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT144     EXEC SQL                                                             
ACT144         INCLUDE CPD00038                                                 
ACT144     END-EXEC.                                                            
ACT144*                                                                         
                                                                        
      **** ALL SQL INSERTS, UPDATES, AND DELETES GO IN THE 8000-        06310099
      **** RANGE OF PARAGRAPHS                                          06320002
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06340098
      **    8000-INSERT-CSS-ANNUAL-SUMMARY.                           **06350099
      **                                                              **06360031
      **    INSERT THE CURRENT DETAIL BILL SUMMARY INTO               **06370099
      **    CSS_ANNUAL_SUMMARY TABLE.                                 **06380099
      **                                                              **06390099
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06400031
       8000-INSERT-CSS-ANNUAL-SUMMARY.                                  
           EXEC SQL                                                     
                INSERT INTO CSS_ANNUAL_SUMMARY                          
                  (ACCOUNT_NO,                                          
                   TOTAL_USAGE,                                         
                   NO_DAYS,                                             
                   CODE_UTIL_TYPE,                                      
                   IC_NO,                                               
                   SUMMARY_YEAR,                                        
                   TOTAL_REVENUE)                                       
                VALUES                                                  
                   (:AS-ACCOUNT-NO,                                     
                    :AS-TOTAL-USAGE,                                    
                    :AS-NO-DAYS,                                        
                    :AS-CODE-UTIL-TYPE,                                 
                    :AS-IC-NO,                                          
                    :AS-SUMMARY-YEAR,                                   
                    :AS-TOTAL-REVENUE)                                  
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T22220*       NEXT SENTENCE                                             06620022
T22220        ADD 1 TO WS-8000-INSERTED                                 
           ELSE                                                         
T22220        ADD 1 TO WS-8000-BAD-RC                                   
              MOVE 'AS'             TO  WS-DB2-TABLE-ID                 
              MOVE 'INSERT'         TO  WS-DB2-FUNCTION                 
              MOVE SQLCODE          TO  WS-DB2-RETURN-CODE              
              MOVE '525'            TO  WS-DB2-MODULE-ID                
              MOVE '8000'           TO  WS-DB2-PARAGRAPH                
T17670*       MOVE 16               TO  RETURN-CODE                     06690032
T17670*       PERFORM 9900-ABEND THRU 9900-EXIT.                        06700032
T17670        DISPLAY 'RETURN CODE:  ' WS-ACTIVE-RETURN-CODE            
T17670        DISPLAY 'ACCOUNT NO.:  ' AS-ACCOUNT-NO                    
T17670        MOVE ZEROS TO WS-ACTIVE-RETURN-CODE
           END-IF.                      
                                                                        
T22220                                                                  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06740031
      **    8100-UPDATE-CSS-ANNUAL-SUMMARY.                           **06750099
      **                                                              **06760031
      **    UPDATE COLUMNS ON ANNUAL SUMMARY TABLE.                   **06770099
      **                                                              **06780031
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06790031
       8100-UPDATE-CSS-ANNUAL-SUMMARY.                                  
           EXEC SQL                                                     
                UPDATE CSS_ANNUAL_SUMMARY                               
                SET TOTAL_USAGE           =  :AS-TOTAL-USAGE,           
                    NO_DAYS               =  :AS-NO-DAYS,               
                    TOTAL_REVENUE         =  :AS-TOTAL-REVENUE          
                WHERE ACCOUNT_NO          =  :AS-ACCOUNT-NO             
T19486            AND CODE_UTIL_TYPE      =  :AS-CODE-UTIL-TYPE         
T19486            AND IC_NO               =  :AS-IC-NO                  
T19486            AND SUMMARY_YEAR        =  :AS-SUMMARY-YEAR           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     06810026
MFA-TR*         UPDATE CSS_ANNUAL_SUMMARY                               06820099
MFA-TR*         SET TOTAL_USAGE           =  :AS-TOTAL-USAGE,           06830099
MFA-TR*             NO_DAYS               =  :AS-NO-DAYS,               06840099
MFA-TR*             TOTAL_REVENUE         =  :AS-TOTAL-REVENUE          06850099
MFA-TR*         WHERE ACCOUNT_NO          =  :AS-ACCOUNT-NO             06860099
MFA-TR*           AND CODE_UTIL_TYPE      =  :AS-CODE-UTIL-TYPE                 
MFA-TR*           AND IC_NO               =  :AS-IC-NO                          
MFA-TR*           AND SUMMARY_YEAR        =  :AS-SUMMARY-YEAR                   
MFA-TR*         QUERYNO 8100                                                    
MFA-TR*    END-EXEC.                                                    06870026

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 4 TO RETURN-CODE                               
T22220              ADD 1 TO WS-8100-NOT-FOUND                          
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
               WHEN OTHER                                               
T22220              ADD 1 TO WS-8100-BAD-RC                             
                    MOVE 'AS'             TO  WS-DB2-TABLE-ID           
                    MOVE 'UPDATE'         TO  WS-DB2-FUNCTION           
                    MOVE SQLCODE          TO  WS-DB2-RETURN-CODE        
                    MOVE '525'            TO  WS-DB2-MODULE-ID          
                    MOVE '8100'           TO  WS-DB2-PARAGRAPH          
                    MOVE AS-ACCOUNT-NO    TO  WS-DB2-KEY-1N             
T17670*             MOVE 16               TO  RETURN-CODE               07020032
T17670*             PERFORM 9900-ABEND THRU 9900-EXIT                   07030032
T17670        DISPLAY 'UPDT R.CODE:  ' WS-ACTIVE-RETURN-CODE            
T17670        DISPLAY 'ACCOUNT NO.:  ' AS-ACCOUNT-NO                    
T17670        MOVE ZEROS TO WS-ACTIVE-RETURN-CODE                       
           END-EVALUATE.                                                
T22220                                                                  
T22220     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T22220         ADD 1 TO WS-8100-UPDATED
           END-IF.                                
T22220                                                                  
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT144**   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07080099
ACT144**                                                              **07090099
ACT144**    9000-TERMINATE.                                           **07100099
ACT144**                                                              **07110099
ACT144**   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07120099
ACT144 9000-TERMINATE.                                                  
ACT144                                                                  
ACT144 9000-EXIT.                                                       
ACT144     EXIT.                                                        
ACT144                                                                  
ACT144**   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07180099
ACT144**    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE             **07190099
ACT144**                                                              **07200064
ACT144**   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **07210064
ACT144     EXEC SQL                                                     07220099
ACT144       INCLUDE CPD09900                                           07230099
ACT144     END-EXEC.                                                    07240099
