       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA507.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     FEB 15, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      ** EACH ROW IN CSS_ELEC_METER TABLE WITH NON-NULL LAST_TEST_SEL **        
      ** DT OR NON BLANK LAST_TEST_SEL_CD, IS UPDATED TO LAST_TEST_   **        
      ** SEL_DT = NULL AND LAST_TEST_SEL_CD = BLANK                   **        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
A05268***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
ACT045***  07/29/2015    VV7M728     EZY TO COBOL CONVERSION         ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA507'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTR_TEST_HIST                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ***************************************************************           
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'              *           
      ***************************************************************           
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSCA507'.     
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-REC-COUNT             PIC 9(04) VALUE ZEROES.         
      *                                                                         
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-LAST-TEST-SEL-DT-NULL PIC S9(04) COMP VALUE ZEROES.   
      *                                                                         
      ***************************************************************           
      *CURSOR FOR TEST HISTORY RECORDS                              *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE GET_REC CURSOR FOR                                 
                SELECT LAST_TEST_SEL_DT                                 
                      ,LAST_TEST_SEL_CD                                 
      *               ,METER_NO                                                 
                  FROM CSS_ELEC_METER                                   
                 WHERE (LAST_TEST_SEL_DT IS NOT NULL                    
                 OR  LAST_TEST_SEL_CD <> ' ' )                          
                 AND COMPANY_NO = :WS-COMPANY-NO                        
                  FOR  UPDATE OF                                        
                       LAST_TEST_SEL_DT                                 
                      ,LAST_TEST_SEL_CD                                 
      *            FOR FETCH ONLY WITH UR                                       
            END-EXEC.                                                   
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-INPUT.                                                   
          05 PARM-LENGTH                PIC S9(04) COMP.                
          05 PARM-COMP-NO               PIC X(02).                      
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION USING PARM-INPUT.                             
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-ELECTRIC-MTR        THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           IF PARM-COMP-NO EQUAL SPACES                                 
             MOVE '01'                    TO WS-COMPANY-NO              
           ELSE                                                         
             MOVE PARM-COMP-NO            TO WS-COMPANY-NO              
           END-IF.                                                      
                                                                        
           DISPLAY '*******************************'                    
           DISPLAY 'JOB RUNNING FOR COMPANY NO = ', WS-COMPANY-NO       
           DISPLAY '*******************************'                    
           .                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2000-PROCESS-ELECTRIC-MTR.                                   *          
      ****************************************************************          
      *                                                                         
        2000-PROCESS-ELECTRIC-MTR.                                      
      *                                                                         
           PERFORM 7200-OPEN-GET-REC                THRU  7200-EXIT.    
      *                                                                         
           PERFORM 7300-FETCH-GET-REC               THRU  7300-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
              PERFORM 2200-UPDATE-ELEC-MTR          THRU 2200-EXIT      
              UNTIL WS-ALL-ROWS-PROCESD = WS-Y                          
                                                                        
           END-IF.                                                      
           DISPLAY 'TOTAL RECS PROCESSED ' WS-REC-COUNT                 
                                                                        
           PERFORM 7400-CLOSE-GET-REC               THRU  7400-EXIT     
           .                                                            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2200-UPDATE-ELEC-MTR.                                       **        
      ******************************************************************        
      *                                                                         
       2200-UPDATE-ELEC-MTR.                                            
      *                                                                         
           MOVE -1                     TO WS-LAST-TEST-SEL-DT-NULL      
                                                                        
           PERFORM 8000-UPDT-ELEC-MTR              THRU  8000-EXIT      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             COMPUTE WS-REC-COUNT    = WS-REC-COUNT + 1                 
      *      DISPLAY 'UPDATED METER NO IS ' EM-METER-NO                         
                                                                        
           ELSE                                                         
             DISPLAY 'UPDATE ERROR ' WS-ACTIVE-RETURN-CODE              
           END-IF.                                                      
                                                                        
           PERFORM 7300-FETCH-GET-REC              THRU  7300-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7200-OPEN-GET-REC.                                           **        
      ******************************************************************        
      *                                                                         
       7200-OPEN-GET-REC.                                               
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_REC                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA507 ABORT *****'                   
              DISPLAY '**OPEN GET_REC ERROR **'                         
              DISPLAY '**7200-OPEN-GET-REC  **'                         
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-FETCH-GET-REC.                                          **        
      ******************************************************************        
      *                                                                         
       7300-FETCH-GET-REC.                                              
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_REC                                             
               INTO :EM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-NULL       
                   ,:EM-LAST-TEST-SEL-CD                                
      *            ,:EM-METER-NO                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                   TO WS-ALL-ROWS-PROCESD        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA507 ABORT *****'                   
              DISPLAY '**  MAIN CURSOR FETCH ERROR**'                   
              DISPLAY '**7300-FETCH-GET-REC **'                         
              DISPLAY '**WS-COMPANY-NO        =' WS-COMPANY-NO          
              DISPLAY '**EM-LAST-TEST-SEL-CD  =' EM-LAST-TEST-SEL-CD    
              DISPLAY '**EM-LAST-TEST-SEL-DT  =' EM-LAST-TEST-SEL-DT    
              DISPLAY '**RETURN CODE          =' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-CLOSE-GET-REC                                           **        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-GET-REC.                                              
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_REC                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA507 ABORT *****'                   
              DISPLAY '**CLOSE GET_REC ERROR**'                         
              DISPLAY '**7400-CLOSE-GET-REC **'                         
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8000-UPDT-ELEC-MTR.                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8000-UPDT-ELEC-MTR.                                              
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_ELEC_METER                                      
                  SET LAST_TEST_SEL_DT = NULL                           
                     ,LAST_TEST_SEL_CD = ' '                            
                  WHERE CURRENT OF GET_REC                              
      *           WHERE METER_NO         = :EM-METER-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCAX04 ABORT *****'                   
              DISPLAY '**  JOB PARM UPDATE FAILED **'                   
              DISPLAY '**8000-UPDT-ELEC-MTR **'                         
              DISPLAY '**EM-LAST-TEST-SEL-CD' EM-LAST-TEST-SEL-CD       
              DISPLAY '**EM-LAST-TEST-SEL-DT' EM-LAST-TEST-SEL-DT       
      *       DISPLAY '**EM-METER-NO        ' EM-METER-NO                       
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           DISPLAY '                             '.                     
           DISPLAY ' PROGRAM ENDED SUCCESSFULLY  '.                     
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
