       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA505.                                         
       DATE-WRITTEN.  DEC 2008.                                         
       DATE-COMPILED.                                                   
       AUTHOR.        SATISH S.                                         
      ****************************************************************          
      *                   CUSTOMER SERVICE SYSTEM                    *          
      *                             DB2                              *          
      ****************************************************************          
      *               PROGRAM  MODIFICATION  LOG                     *          
      *                                                              *          
      *            DATE    INITIALS       REASON                     *          
      *          ________  ________   _____________________________  *          
      *A00330    12/19/08  SS95855    Program originally written.    *          
      *A02035    07/20/10  SS95855    Correct WQ category to '4'     *          
      *A02035                         Change Restart Process.        *          
      *A02035                         When Meter is not setup, do    *          
      *A02035                         not abend.                     *          
      *A03082    08/25/11  SS95855    Do not limit posting factors   *          
      *A03082                         if meter is not setup.         *          
      *A03082                         For duplicate accounts, skip   *          
      *A03082                         abending the program and write *          
      *A03082                         into exception report.         *          
ACT006*A04860    12/26/13  SS7F226    REPLACE CSS_WQ_ITEMS_MF WITH   *          
ACT006*A04860                         CSS_WQ_ITEMS BY CALLING        *          
ACT006*A04860                         SCSCB077 AND REMOVED           *          
ACT006*A04860                         UNUSED CODE                               
ACT249*A04880    08/26/14  VIJAY  1. SHIFT WQ PROCESS SO THAT IT WILL*          
ACT249*A04880                        GENERATE WQ ONLY WHEN DDC FACTOR*          
ACT249*A04880                        INSERTED/UPDATED.               *          
ACT249*A04880                     2. DO NOT WRITE WQ IF NEW FACTOR &            
ACT249*A04880                        OLD FACTOR IS > LIMIT.                     
ACT249*A04880                     3. IF FACTOR EXISTING FOR THE PERIOD          
ACT249*A04880                        UPDATE FACTOR.                             
      *A05305    09/15/15  SS95855   FIX WQ ISSUES. DURING UPDATE,   *          
      *A05305                        POPULATE CORRECT WQ MESSAGE.    *          
      ****************************************************************          
           REMARKS.                                                     
      *                       PCSCA505 NARRATIVE                     *          
      *                                                              *          
      * Design Day is a Factor representing the amount of gas that is*          
      * projected to be used at the premises on the coldest day of   *          
      * the year.It is used to assign capacity on AGLC pipelines as  *          
      * well as to assess firm delivery charges.It is calculated and *          
      * stored in MCF's.Design day usage is recorded in MCF's,       *          
      * however it is converted to Dekatherms when determining       *          
      * Market share and firm delivery charges.                      *          
      * This program posts the design day transactions to CIS tables.*          
      * It checks for the DDAY factor and if it exists for the Acct, *          
      * it checks the End date and the factor.If they are same it    *          
      * skips the account, else it expires the old factor and inserts*          
      * a new Factor.If the Factor dosn't exist, it inserts.         *          
      ****************************************************************          
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSCA505.                                                           
       COPY CSSRP505.                                                           
A02035 COPY CSSR505R.                                                           
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
      * INPUT FILE                                                              
       COPY CFDCA505.                                                           
       COPY FIOCA505.                                                           
                                                                        
      * REPORT FILE                                                             
       COPY CFDRP505.                                                           
       COPY FIORP505.                                                           
                                                                        
A02035* FD STMT FOR R505R FILE     *                                            
A02035 COPY CFDR505R.                                                           
A02035 01  FIOR505R-REC                 PIC X(80).                      
      *                                                                         
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA505'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSCA505 STARTS HERE'.                  
                                                                        
       01  WS-PGRMNAME                     PIC X(08) VALUE              
           'PCSCA505'.                                                  
                                                                        
ACT006 01  SCSCB077                    PIC X(08) VALUE 'SCSCB077'.      
                                                                        
       01  WS-WORK-AREA.                                                
           05 WS-HOLD-VARIABLES.                                        
              10 WS-CURRENT-TIMESTAMP      PIC X(26).                   
              10 WS-NEW-FACTOR             PIC 9(04)V9(03).             
COB305        10 WS-NEW-FACTOR-COMP        PIC S9(9)V9(4) USAGE COMP-3 
COB305           VALUE 0. 
              10 WS-FILE-FCTR-1            PIC 9(04).                   
              10 WS-FILE-FCTR-2            PIC 9(03).                   
              10 WS-FILE-FCTR-DEC REDEFINES                             
                 WS-FILE-FCTR-2.                                        
                 15 WS-FILE-FCTR-DIG       PIC V9(03).                  
              10 WS-FILE-FCTR-HOLD.                                     
                 15 WS-FILE-FCTR-PRE       PIC 9(04).                   
                 15 WS-FILE-FCTR-DEC       PIC X(01).                   
                 15 WS-FILE-FCTR-POS       PIC 9(03).                   
              10 WS-CURSOR-RET-CODE        PIC S9(09) COMP.             
              10 WS-TYPE-OF-ACCT           PIC X(01).                   
              10 WS-MAX-SEQ-NO             PIC S9(04) COMP.             
COB305        10 WS-TRAN-APPL-NO        PIC S9(10) COMP-3 VALUE 0.           
              10 WS-NULL-IND-2             PIC S9(04) COMP.             
              10 WS-FACTOR-DISP            PIC 9(09).9(6).              
              10 WS-FACT-VAL-Z             PIC -Z(09).9(06).            
              10 WS-MISS-CNTR-DISP         PIC Z(08)9.                  
              10 WS-NEW-FCTR-REV-MNTH      PIC 9(06).                   
              10 WS-NEW-FCTR-REV-M REDEFINES                            
                 WS-NEW-FCTR-REV-MNTH.                                  
                 15 WS-NEW-FCTR-CCYY       PIC 9(04).                   
                 15 WS-NEW-FCTR-MM         PIC 9(02).                   
              10 WS-NEW-FCTR-START-DATE    PIC X(10).                   
A02035        10 WS-ACCOUNT-NO             PIC 9(13) VALUE 0.           
ACT006     05 RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.    
ACT006     05 WS-INPUT-ZERO                PIC X(16)                    
ACT006                                     VALUE '-00.00.00.000000'.    
ACT006     05 WS-INPUT-DATE-26             PIC X(26) VALUE SPACES.      
                                                                        
           05 WS-SWITCHES.                                              
              10 WS-FCSCA505-STATUS        PIC X(02).                   
                 88 FCSCA505-SUCCESSFUL    VALUE '00'.                  
A02035           88 FCSCA505-EOF           VALUE '10'.                  
              10 WS-FCSRP505-STATUS        PIC X(02).                   
                 88 FCSRP505-SUCCESSFUL    VALUE '00'.                  
A02035        10 WS-FCSR505R-STATUS        PIC X(02).                   
A02035           88 FCSR505R-SUCCESSFUL    VALUE '00'.                  
A02035           88 FCSR505R-EOF           VALUE '10'.                  
A02035        10 WS-CA505-EOF              PIC X(01) VALUE 'N'.         
A02035           88 CA505-EOF-REACHED      VALUE 'Y'.                   
              10 WS-ACCOUNT-TYPE           PIC X(01).                   
                 88 COMMERCIAL             VALUE 'C'.                   
                 88 RESIDENTIAL            VALUE 'R'.                   
              10 WS-OVERRIDE-DATE          PIC X(01).                   
                 88 USE-PARM-DATE          VALUE 'Y'.                   
                                                                        
           05 WS-NEW-FCTR-START-DT.                                     
              10 WS-NEW-FCTR-START-CCYY    PIC 9(04).                   
              10 WS-NEW-FCTR-START-SEP1    PIC X(01).                   
              10 WS-NEW-FCTR-START-MM      PIC 9(02).                   
              10 WS-NEW-FCTR-START-SEP2    PIC X(01).                   
              10 WS-NEW-FCTR-START-DD      PIC 9(02).                   
           05 WS-CURRENT-DATE              PIC X(10).                   
           05 WS-CURRENT-TIME              PIC X(08).                   
           05 WS-CURR-PLUS-30-DAYS         PIC X(10).                   
                                                                        
A02035   05 WS-TEMP-DATA.                                               
A02035      10 WS-TOTAL-COUNT              PIC 9(07) VALUE 0.           
A02035      10 WS-MISS-COUNT               PIC 9(07) VALUE 0.           
A02035      10 WS-TRAN-COUNT               PIC 9(07) VALUE 0.           
A02035      10 WS-REPT-COUNT               PIC 9(07) VALUE 0.           
A02035      10 WS-ERROR-MESG               PIC X(80) VALUE SPACES.      
A02035      10 WS-TEMP-MESG                PIC X(80) VALUE SPACES.      
      *                                                                         
         05 WS-LITERALS.                                                
            10 WS-YES                      PIC X(01) VALUE 'Y'.         
            10 WS-NO                       PIC X(01) VALUE 'N'.         
            10 WS-TRANID                   PIC X(04) VALUE 'DDAY'.      
            10 WS-811                      PIC S9(09) VALUE -811 COMP.  
            10 WS-FACTOR-ID-DDC            PIC X(09) VALUE 'DDC      '. 
            10 WS-FACTOR-DESC              PIC X(20) VALUE ' '.         
            10 WS-FCTR-END-DT              PIC X(10) VALUE ' '.         
            10 WS-NEW-FCTR-END-DT          PIC X(10) VALUE '2999-12-31'.
            10 WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
            10 WS-NEW                      PIC X(07) VALUE '**NEW**'.   
            10 WS-TRAN-TRLR                PIC X(07) VALUE 'TRLR'.      
            10 WS-CODE-UTIL-TYPE           PIC X(01) VALUE ' '.         
            10 WS-COMPANY-NO               PIC X(02) VALUE '  '.        
            10 WS-DDAY-RESI-LIMIT          PIC X(20) VALUE              
                                           'DDAY-RESI-LIMIT'.           
            10 WS-DDAY-COMM-LIMIT          PIC X(20) VALUE              
                                           'DDAY-COMM-LIMIT'.           
            10 WS-DDAY-CONV-CONST          PIC X(20) VALUE              
                                           'DDAY-CONV-CONST'.           
COB305      10 WS-TRAN-RESI-VALUE        PIC S9(4)V9(5) USAGE COMP-3 
COB305         VALUE 0. 
COB305      10 WS-TRAN-COMM-VALUE        PIC S9(4)V9(5) USAGE COMP-3 
COB305         VALUE 0. 
COB305      10 WS-DEKA-CONV-CONST        PIC S9(4)V9(5) USAGE COMP-3 
COB305         VALUE 0. 
            10 WS-F                        PIC X(01) VALUE 'F'.         
A02035      10 WS-TRL-REC-COUNT            PIC 9(07) VALUE 0.           
            10 WS-R                        PIC X(01) VALUE 'R'.         
            10 WS-10                       PIC X(02) VALUE '10'.        
            10 WS-FACTOR-TYP-CD            PIC X(02) VALUE '00'.        
            10 WS-FACTOR-TEXT              PIC X(15) VALUE              
                                           'FACTOR VALUE'.              
            10 WS-DATE-FROM-TEXT           PIC X(15) VALUE 'DATE FROM'. 
            10 WS-DATE-TO-TEXT             PIC X(15) VALUE 'DATE TO'.   
            10 WS-CATEGORY-ID              PIC S9(04) COMP VALUE 220.   
A02035      10 WS-ROUTING-CATEGORY         PIC X(01) VALUE '4'.         
A02035      10 WS-MESG-DUPLICATE           PIC X(21) VALUE              
A02035                         ' More than 1 Account '.                 
A02035      10 WS-MESG-ACCT                PIC X(21) VALUE              
A02035                         ' Account not in CIS  '.                 
A03082      10 WS-MESG-UTIL                PIC X(21) VALUE              
A03082                         ' Utility not setup   '.                 
            10 WS-WQ-MESSAGE-RESI.                                      
               15 WS-WQ-DESC-RESI          PIC X(39) VALUE              
ACT249                     'RESIDENTIAL ACCOUNTS NEW DDAY FACTOR = '.   
ACT249         15 WS-WQ-NEW-FACTOR-RESI    PIC Z(05).9(06).             
ACT249         15 FILLER                   PIC X(06) VALUE ' IS > '.    
               15 WS-WQ-LIMIT-RESI         PIC Z(05).9(06).             
ACT249         15 FILLER                   PIC X(20) VALUE              
ACT249                     '. OLD DDAY FACTOR = '.                      
ACT249         15 WS-WQ-OLD-FACTOR-RESI    PIC Z(05).9(06).             
            10 WS-WQ-MESSAGE-COMM.                                      
               15 WS-WQ-DESC-COMM          PIC X(38) VALUE              
ACT249                     'COMMERCIAL ACCOUNTS NEW DDAY FACTOR = '.    
ACT249         15 WS-WQ-NEW-FACTOR-COMM    PIC Z(05).9(06).             
ACT249         15 FILLER                   PIC X(06) VALUE ' IS > '.    
               15 WS-WQ-LIMIT-COMM         PIC Z(05).9(06).             
ACT249         15 FILLER                   PIC X(20) VALUE              
ACT249                     '. OLD DDAY FACTOR = '.                      
ACT249         15 WS-WQ-OLD-FACTOR-COMM    PIC Z(05).9(06).             
      *                                                                         
A05305      10 WS-WQ-MESSAGE-DIFF.                                      
A05305         15 WS-WQ-DESC-DIFF          PIC X(51) VALUE              
A05305            'NEW FCTR DIFFER FROM OLD FCTR FOR SAME START DATE: '.
A05305         15 WS-WQ-START-DATE         PIC X(10) VALUE SPACES.      
A05305*                                                                         
       01  WS-HEADER-1.                                                 
           05 FILLER                       PIC X(08) VALUE 'PCSCA505'.  
           05 FILLER                       PIC X(03) VALUE '-01'.       
           05 FILLER                       PIC X(23) VALUE SPACES.      
           05 FILLER                       PIC X(13) VALUE              
                                                     'AGLC ACCOUNTS'.   
           05 FILLER                       PIC X(12) VALUE SPACES.      
           05 FILLER                       PIC X(09) VALUE 'RUN DATE:'. 
           05 FILLER                       PIC X(02) VALUE SPACES.      
           05 WS-RPRT-DATE                 PIC X(10) VALUE SPACES.      
      *                                                                         
       01  WS-HEADER-2.                                                 
A02035     05 FILLER                       PIC X(59) VALUE SPACES.      
           05 FILLER                       PIC X(09) VALUE 'RUN TIME:'. 
           05 FILLER                       PIC X(04) VALUE SPACES.      
           05 WS-RPRT-TIME                 PIC X(08) VALUE SPACES.      
      *                                                                         
       01  WS-HEADER-3.                                                 
           05 FILLER                       PIC X(63) VALUE SPACES.      
           05 FILLER                       PIC X(05) VALUE 'PAGE:'.     
           05 FILLER                       PIC X(08) VALUE SPACES.      
           05 WS-RPRT-PAGE-NO              PIC ZZZ9.                    
      *                                                                         
       01  WS-STARS.                                                    
           05 FILLER                       PIC X(80) VALUE ALL '*'.     
                                                                        
A02035 01  WS-SUBJECT-1                    PIC X(55) VALUE              
A02035     'SEBC505 - DDAY Transaction Posting - Exception Accounts'.   
                                                                        
       01  WS-RPT-TRL                      PIC X(24) VALUE              
           'TOTAL NO. OF ACCOUNTS : '.                                  
      *                                                                         
       01  MAILHEAD-1.                                                  
           05 FILLER                      PIC X(22) VALUE               
                      'HELO DOMAIN:     SCANA'.                         
      *                                                                         
       01  MAILHEAD-2.                                                  
           05 FILLER                       PIC X(14) VALUE              
                      'MAIL FROM:   <'.                                 
           05 MAIL2-JOB-NAME               PIC X(08).                   
           05 FILLER                       PIC X(20) VALUE              
                      '@SCEGJES2.SCANA.COM>'.                           
      *                                                                         
       01  MAILHEAD-3.                                                  
           05 FILLER                       PIC X(27) VALUE              
                      'RCPT TO: <SEB505@SCANA.COM>'.                    
      *                                                                         
       01  MAILHEAD-4.                                                  
           05 FILLER                       PIC X(04) VALUE              
                      'DATA'.                                           
      *                                                                         
       01  MAILHEAD-5.                                                  
           05 FILLER                       PIC X(18) VALUE              
                      'FROM: CSR PAGING <'.                             
           05 MAIL5-JOB-NAME               PIC X(08).                   
           05 FILLER                       PIC X(20) VALUE              
                      '@SCEGJES2.SCANA.COM>'.                           
      *                                                                         
       01  MAILHEAD-6.                                                  
           05 FILLER                       PIC X(22) VALUE              
                      'TO: <SEB505@SCANA.COM>'.                         
      *                                                                         
       01  MAILHEAD-7.                                                  
           05 FILLER                       PIC X(10) VALUE              
                      'SUBJECT : '.                                     
           05 MAIL7-SUBJECT                PIC X(70).                   
      *                                                                         
       01  MAILHEAD-8.                                                  
           05 FILLER                       PIC X(60) VALUE SPACES.      
                                                                        
      ****************************************************************          
      *   BELOW IS THE WORKING STORAGE AREA FOR RESTART LOGIC        *          
      ****************************************************************          
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE REDEFINES                        
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS VALUE 'A'.              
               88  WS-RERUN-COMPLETED           VALUE 'B'.              
               88  WS-RERUN-PENDING             VALUE 'C'.              
           05  WS-RESTART-INPUT-DATE       PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05) VALUE 0.           
A02035     05  WS-RESTART-AGLC-ACCT-NO     PIC X(20).                   
A02035     05  WS-RESTART-PR-ID-NO         PIC X(09).                   
A02035     05  WS-RESTART-CUST-ID-NO       PIC X(09).                   
A02035     05  WS-RESTART-TRAN-USAGE       PIC X(08).                   
A02035     05  WS-RESTART-TOTAL-COUNT      PIC 9(07) VALUE 0.           
A02035     05  WS-RESTART-MISS-COUNT       PIC 9(07) VALUE 0.           
A02035     05  WS-RESTART-REPT-COUNT       PIC 9(07) VALUE 0.           
A02035     05  WS-RESTART-TRAN-COUNT       PIC 9(07) VALUE 0.           
      *                                                                         
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +91.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
           05  WS-NEXT-RECORD-READ-FLAG    PIC X(01) VALUE 'N'.         
               88  WS-NEXT-RECORD-READ               VALUE 'Y'.         
               88  WS-NEXT-RECORD-NOT-READ           VALUE 'N'.         
           05  WS-RESTART-REC-CNT          PIC S9(09) COMP VALUE ZERO.  
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.         
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 200.         
           05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
           05  WS-CHKP-LUW-COUNTER         PIC 9(04) COMP-3 VALUE ZERO. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 200.         
           05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
           05  WS-COMMIT-COUNTER           PIC S9(3) COMP-3 VALUE 0.    
           05  WS-COMMIT-REQ-SW            PIC X(1)  VALUE 'Y'.         
               88 WS-COMMITS-REQUIRE                 VALUE 'Y'.         
               88 WS-COMMITS-NOT-REQUIRE             VALUE 'N'.         
           05  WS-CHKP-UPD-COUNTER         PIC S9(04) COMP-3 VALUE ZERO.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02) VALUE 'B4'.        
               10  WS-CHKP-PART-NO         PIC 9(01) VALUE 1.           
               10  WS-CHKP-SEQ-NO          PIC 9(05) VALUE ZERO.        
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) COMP-3            
                                                     VALUE ZERO.        
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-I                        PIC X(01) VALUE 'I'.         
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
       01  WS-INPUT-DATA-NFF REDEFINES                                  
           WS-INPUT-DATA-BREAKDOWN.                                     
           05 WS-EFF-DATE                  PIC X(08).                   
              88  EFF-DATE                 VALUE 'EFF-DATE'.            
           05 FILLER                       PIC X(01).                   
           05 WS-EFF-DATE-PARM             PIC X(10).                   
           05 FILLER                       PIC X(61).                   
      *                                                                         
       01  WS-INPUT-DATA-UTL REDEFINES                                  
           WS-INPUT-DATA-BREAKDOWN.                                     
           05 WS-UTIL-TYPE                 PIC X(09).                   
              88  UTIL-TYPE                VALUE 'UTIL-TYPE'.           
           05 FILLER                       PIC X(01).                   
           05 WS-UTIL-TYPE-PARM            PIC X(01).                   
           05 FILLER                       PIC X(69).                   
      *                                                                         
       01  WS-INPUT-DATA-CO REDEFINES                                   
           WS-INPUT-DATA-BREAKDOWN.                                     
           05 WS-COMP-NO                   PIC X(10).                   
              88 COMPANY-NO                VALUE 'COMPANY-NO'.          
           05 FILLER                       PIC X(01).                   
           05 WS-COMP-NO-PARM              PIC X(02).                   
           05 FILLER                       PIC X(63).                   
      *                                                                         
       01  WS-END                          PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSCA505 ENDS HERE  '.                  
                                                                        
      ****************************************************************          
      * WORKING STORAGE FOR CWS00303, DB2 ERROR PROCESSING COPYBOOK  *          
      ****************************************************************          
       COPY CWS00303.                                                           
                                                                        
      ****************************************************************          
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM      *          
      ****************************************************************          
       COPY FIOJC01.                                                            
                                                                        
      ****************************************************************          
      * WORKING STORAGE FOR CPD09900, ABEND COPYBOOK                 *          
      ****************************************************************          
       COPY CWS09900.                                                           
                                                                        
ACT006****************************************************************          
ACT006 COPY CWS00010.                                                           
ACT006****************************************************************          
ACT006                                                                  
ACT006*****************************************************************         
ACT006* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077         *         
ACT006*****************************************************************         
ACT006     EXEC SQL                                                             
ACT006          INCLUDE CWS00077                                                
ACT006     END-EXEC.                                                            
ACT006                                                                  
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAN AREA                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_ACCOUNT,AT                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_MKT_XREF_ACCT,XM                            *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_FIXED_FCTR,FF                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_UTIL_ENVRNMT,UT                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_SPCL_FCTR,SF                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_MNT_TRANS_HIST,MH                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_MT_TRN_HST_DET,MI                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_RESTART,RF                                  *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_JOB_PARM,G6                                 *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_DELINQUENCY,C8                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DCLGEN FOR CSS_BILL_WINDOW,BN                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ****************************************************************          
      *0000-MAINLINE                                                 *          
      *       CONTROLS MAIN PATH OF PROGRAM                          *          
      ****************************************************************          
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
                                                                        
           PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT.             
A02035     IF CA505-EOF-REACHED                                         
              DISPLAY '  FCSCA505 FILE IS EMPTY '                       
              MOVE 05                       TO  RETURN-CODE             
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT              
A02035                                   UNTIL CA505-EOF-REACHED.       
                                                                        
           PERFORM 8550-WRITE-CNTRS         THRU 8550-EXIT.             
A02035     IF WS-TRL-REC-COUNT NOT = WS-TRAN-COUNT                      
              DISPLAY '  RECORD MISMATCH ERROR '                        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 5900-PROCESS-SUCCESSFUL-JOB                          
                                            THRU 5900-EXIT.             
                                                                        
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *0100-INITIALIZATION                                           *          
      ****************************************************************          
       0100-INITIALIZATION.                                             
                                                                        
A02035     PERFORM 0200-OPEN-FILES     THRU 0200-EXIT.                  
                                                                        
           PERFORM 7400-GET-DATE-TIME  THRU 7400-EXIT.                  
                                                                        
      * GET JOB PARM DATA                                                       
           MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE 0                      TO WS-SEQUENCE.                  
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-KEY-AREA            TO E-FJC01-KEY.                  
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT.                  
           MOVE SPACES                 TO WS-NEW-FCTR-START-DT          
                                          WS-OVERRIDE-DATE.             
           PERFORM 0210-GET-JOB-PARM   THRU 0210-EXIT.                  
           IF WS-NEW-FCTR-START-DT > SPACES                             
              SET USE-PARM-DATE        TO TRUE                          
              DISPLAY 'FCTR START DATE USED FROM JOB PARM : '           
A02035                 WS-NEW-FCTR-START-DT '  ' WS-CODE-UTIL-TYPE '  ' 
A02035                 WS-COMPANY-NO                                    
           END-IF.                                                      
                                                                        
      * GET DELINQUENCY VALUES                                                  
           MOVE WS-COMPANY-NO          TO C8-COMPANY-NO.                
           MOVE WS-DDAY-RESI-LIMIT     TO C8-DELINQ-CD.                 
           PERFORM 7700-SELECT-DLQ-VAL THRU 7700-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-TRAN-RESI-VALUE.           
                                                                        
           MOVE WS-DDAY-COMM-LIMIT     TO C8-DELINQ-CD.                 
           PERFORM 7700-SELECT-DLQ-VAL THRU 7700-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-TRAN-COMM-VALUE.           
                                                                        
           MOVE WS-DDAY-CONV-CONST     TO C8-DELINQ-CD.                 
           PERFORM 7700-SELECT-DLQ-VAL THRU 7700-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-DEKA-CONV-CONST.           
                                                                        
      * GET THE FACTOR DESCRIPTION                                              
           MOVE WS-FACTOR-ID-DDC       TO SF-FACTOR-ID.                 
           PERFORM 7570-GET-FCTOR-DESC THRU 7570-EXIT.                  
           MOVE SF-FACTOR-TEXT         TO WS-FACTOR-DESC.               
                                                                        
      * GET CHECK POINT LIMIT FOR COMMITS                                       
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
           IF WS-CHKP-LUW-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS           
              AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS       
              SET WS-COMMITS-NOT-REQUIRE TO TRUE                        
              DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'    
              DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'           
              DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS     
                      ', INTERPRETED TO  **'                            
              DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'           
              DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'           
A02035        DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'           
A02035        DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'           
A02035        DISPLAY '**      PROCESSING CONTINUING      **'           
           END-IF.                                                      
                                                                        
      * CHECK FOR RESTART                                                       
           PERFORM 6235-GET-FJC01-RESTART-REQ   THRU 6235-EXIT.         
A02035*** CHECK CSS_RESTART TABLE TO GET PRIOR RUN LAST COMMITED DATA           
A02035     PERFORM 0600-CHECK-FOR-RESTART       THRU 0600-EXIT.         
A02035*** VALIDATE JOB_PARM & CSS_RESTART STATUS                                
           PERFORM 0605-VALIDATE-RESTART-REQ    THRU 0605-EXIT.         
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
A02035        MOVE WS-Y   TO WS-REPOSITION-NEEDED                       
A02035        PERFORM 0601-REPOSITION-INPUT-FILE  THRU 0601-EXIT        
A02035        PERFORM 0700-REPOSITION-OUTPUT-FILE THRU 0700-EXIT        
           ELSE                                                         
              PERFORM 0610-INITIALIZE-RESTART   THRU 0610-EXIT          
              PERFORM 8500-CREATE-REPT-HDR      THRU 8500-EXIT          
           END-IF.                                                      
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *0200-OPEN-FILES                                               *          
      ****************************************************************          
       0200-OPEN-FILES.                                                 
                                                                        
A02035     OPEN INPUT FCSCA505-FILE.                                    
A02035                                                                  
A02035     IF FCSCA505-SUCCESSFUL                                       
A02035         CONTINUE                                                 
A02035     ELSE                                                         
A02035        DISPLAY '************ PCSCA505 ERROR ******************'  
A02035        DISPLAY '**        0100-INITIALIZATION               **'  
A02035        DISPLAY '** OPEN FILE FIOCA505                       **'  
A02035        DISPLAY '** FILE STATUS = ' WS-FCSCA505-STATUS            
A02035        DISPLAY '** PROCESSING TERMINATED.......             **'  
A02035        PERFORM 9900-ABEND                                        
A02035           THRU 9900-EXIT                                         
A02035     END-IF.                                                      
A02035                                                                  
A02035     OPEN OUTPUT FCSRP505-FILE.                                   
A02035                                                                  
A02035     IF FCSRP505-SUCCESSFUL                                       
A02035        CONTINUE                                                  
A02035     ELSE                                                         
A02035        DISPLAY '************ PCSCA505 ERROR ******************'  
A02035        DISPLAY '**        0100-INITIALIZATION               **'  
A02035        DISPLAY '** OPEN FILE FIORP505                       **'  
A02035        DISPLAY '** FILE STATUS = ' WS-FCSRP505-STATUS            
A02035        DISPLAY '** PROCESSING TERMINATED.......             **'  
A02035        PERFORM 9900-ABEND                                        
A02035           THRU 9900-EXIT                                         
A02035     END-IF.                                                      
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *0210-GET-JOB-PARM                                             *          
      ****************************************************************          
       0210-GET-JOB-PARM.                                               
                                                                        
           PERFORM UNTIL END-OF-SYSIPT                                  
             IF INPUT-ACTIVE                                            
                EVALUATE TRUE                                           
                  WHEN EFF-DATE                                         
                     MOVE WS-EFF-DATE-PARM    TO WS-NEW-FCTR-START-DT   
                  WHEN UTIL-TYPE                                        
                     MOVE WS-UTIL-TYPE-PARM   TO WS-CODE-UTIL-TYPE      
                  WHEN COMPANY-NO                                       
                     MOVE WS-COMP-NO-PARM     TO WS-COMPANY-NO          
                END-EVALUATE                                            
             END-IF                                                     
             PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT            
           END-PERFORM.                                                 
       0210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
A02035*0600-CHECK-FOR-RESTART.                                       *          
      ****************************************************************          
A02035 0600-CHECK-FOR-RESTART.                                          
                                                                        
           MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO           
                                              RF-DUP-CNTRL-NO.          
                                                                        
           PERFORM 7550-SELECT-RESTART-DATA  THRU 7550-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA           
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-YES               TO WS-IS-THIS-A-RESTART      
              ELSE                                                      
                 MOVE WS-NO                TO WS-IS-THIS-A-RESTART      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                   TO WS-IS-THIS-A-RESTART      
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
A02035*0601-REPOSITION-INPUT-FILE.                                   *          
      ****************************************************************          
A02035**** REPOSITION CA505 FILE TO LAST SUCCESSFUL COMMIT                      
A02035 0601-REPOSITION-INPUT-FILE.                                      
A02035                                                                  
A02035     MOVE ZERO TO WS-TOTAL-COUNT                                  
A02035                  WS-MISS-COUNT                                   
A02035                  WS-REPT-COUNT                                   
A02035                  WS-TRAN-COUNT.                                  
A02035*                                                                         
A02035     PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT              
A02035       UNTIL WS-TOTAL-COUNT EQUAL WS-RESTART-TOTAL-COUNT          
A02035        OR CA505-EOF-REACHED.                                     
A02035*                                                                         
A02035*****************************************************************         
A02035*    THE FOLLOWING CODE COMPARES KEY VALUES STORED IN                     
A02035*    RESTART DATA WITH REPOSITIONED RECORD KEY.                           
A02035*****************************************************************         
A02035     IF E-FIOCA505-AGLC-ACCT-NO = WS-RESTART-AGLC-ACCT-NO AND     
A02035        E-FIOCA505-PR-ID-NO     = WS-RESTART-PR-ID-NO     AND     
A02035        E-FIOCA505-CUST-ID-NO   = WS-RESTART-CUST-ID-NO   AND     
A02035        E-FIOCA505-TRAN-USAGE   = WS-RESTART-TRAN-USAGE           
A02035        CONTINUE                                                  
A02035     ELSE                                                         
A02035        DISPLAY '***************************************'         
A02035        DISPLAY '** FAIL TO REPOSITION CA505 FILE     **'         
A02035                '** CHECK FOR CORRECT CA505 FILE      **'         
A02035        DISPLAY ' '                                               
A02035        DISPLAY '** LAST ACCOUNT PROCESSED IN PRIOR RUN: '        
A02035           WS-RESTART-AGLC-ACCT-NO  ', ' WS-RESTART-PR-ID-NO ', ' 
A02035           WS-RESTART-CUST-ID-NO    ', ' WS-RESTART-TRAN-USAGE    
A02035        DISPLAY '** BUT FILE POSITIONED AT             : '        
A02035           E-FIOCA505-AGLC-ACCT-NO ', '  E-FIOCA505-PR-ID-NO ', ' 
A02035           E-FIOCA505-CUST-ID-NO   ', '  E-FIOCA505-TRAN-USAGE    
A02035        DISPLAY '***************************************'         
A02035        PERFORM 9900-ABEND            THRU 9900-EXIT              
A02035     END-IF.                                                      
A02035*                                                                         
A02035     DISPLAY '*******************************************'.       
A02035     DISPLAY '*****  THIS IS A RESTART OF PCSCA505  *****'.       
A02035     DISPLAY '*******************************************'.       
A02035     MOVE WS-RESTART-MISS-COUNT        TO WS-MISS-COUNT.          
A02035     MOVE WS-RESTART-REPT-COUNT        TO WS-REPT-COUNT.          
A02035     MOVE WS-RESTART-TRAN-COUNT        TO WS-TRAN-COUNT.          
A02035     MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
A02035*                                                                         
A02035 0601-EXIT.                                                       
A02035     EXIT.                                                        
                                                                        
      ****************************************************************          
      *0605-VALIDATE-RESTART-REQ                                     *          
      ****************************************************************          
       COPY CPD00030.                                                           
                                                                        
      ****************************************************************          
      *0610-INITIALIZE-RESTART                                       *          
      ****************************************************************          
       0610-INITIALIZE-RESTART.                                         
                                                                        
           MOVE ZEROES                   TO WS-RESTART-PROCESS-TYPE     
A02035                                      WS-RESTART-CHKP-SEQ-NO      
A02035                                      WS-RESTART-TOTAL-COUNT      
A02035                                      WS-RESTART-MISS-COUNT       
A02035                                      WS-RESTART-TRAN-COUNT       
A02035                                      WS-RESTART-REPT-COUNT.      
A02035     MOVE SPACES                   TO WS-RESTART-AGLC-ACCT-NO     
A02035                                      WS-RESTART-PR-ID-NO         
A02035                                      WS-RESTART-CUST-ID-NO       
A02035                                      WS-RESTART-TRAN-USAGE.      
           SET WS-RERUN-PENDING          TO TRUE.                       
           MOVE WS-CURRENT-DATE          TO WS-RESTART-INPUT-DATE.      
A02035     MOVE WS-NO                    TO WS-REPOSITION-NEEDED.       
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02035*================================================================*        
A02035 0700-REPOSITION-OUTPUT-FILE.                                     
A02035*================================================================*        
A02035*                                                                         
A02035     OPEN INPUT FCSR505R-FILE.                                    
A02035     IF NOT FCSR505R-SUCCESSFUL                                   
A02035        DISPLAY '0700-ERROR ON FIOR505R OPEN.  STATUS IS '        
A02035                     WS-FCSR505R-STATUS                           
A02035        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
A02035*                                                                         
A02035     PERFORM WS-RESTART-REPT-COUNT TIMES                          
A02035        READ FCSR505R-FILE                                        
A02035        IF FCSR505R-SUCCESSFUL                                    
A02035           WRITE FIORP505-RECORD FROM FIOR505R-REC                
A02035           IF FCSRP505-SUCCESSFUL                                 
A02035              CONTINUE                                            
A02035           ELSE                                                   
A02035              DISPLAY 'ERROR ON FIORP505 REWRITE.  STATUS IS '    
A02035                       WS-FCSRP505-STATUS                         
A02035              PERFORM 9900-ABEND THRU 9900-EXIT                   
A02035           END-IF                                                 
A02035        ELSE                                                      
A02035           DISPLAY 'PREMATURE EOF ON RP505 RESTART'               
A02035           DISPLAY 'PROCESSING TERMINATED'                        
A02035           PERFORM 9900-ABEND THRU 9900-EXIT                      
A02035        END-IF                                                    
A02035     END-PERFORM.                                                 
A02035                                                                  
A02035     CLOSE FCSR505R-FILE.                                         
A02035*                                                                         
A02035 0700-EXIT.                                                       
A02035      EXIT.                                                       
A02035*                                                                         
                                                                        
      ****************************************************************          
      *1000-PROCESS-INPUT                                            *          
      ****************************************************************          
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE WS-HOLD-VARIABLES                                 
                      DCLCSS-FIXED-FCTR                                 
                      DCLCSS-ACCOUNT                                    
                      DCLCSS-MKT-XREF-ACCT                              
                      DCLCSS-UTIL-ENVRNMT                               
                      WS-ACCOUNT-TYPE.                                  
                                                                        
           IF E-FIOCA505-TRAN-ID-CD = WS-TRANID                         
              MOVE E-FIOCA505-AGLC-ACCT-NO  TO XM-DIST-ACCT-NO          
              PERFORM 7500-SELECT-ACCT-NO   THRU 7500-EXIT              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF NOT USE-PARM-DATE                                   
                    PERFORM 2100-GET-FCTR-DT   THRU 2100-EXIT           
                 END-IF                                                 
                 MOVE XM-ACCOUNT-NO         TO AT-ACCOUNT-NO            
                 PERFORM 5000-PROCESS-FCTRS THRU 5000-EXIT              
A02035        ELSE                                                      
A02035           ADD +1                     TO WS-MISS-COUNT            
A02035                                         WS-REPT-COUNT            
A02035           MOVE SPACES                TO FIORP505-REC             
A02035                                         WS-ERROR-MESG            
A03082           IF WS-ACTIVE-RETURN-CODE = WS-811                      
A03082              STRING XM-DIST-ACCT-NO WS-MESG-DUPLICATE            
A03082                     DELIMITED BY SIZE INTO WS-ERROR-MESG         
A03082           ELSE                                                   
A03082              STRING XM-DIST-ACCT-NO WS-MESG-ACCT                 
A03082                     DELIMITED BY SIZE INTO WS-ERROR-MESG         
A03082           END-IF                                                 
A03082                                                                  
A02035           MOVE WS-ERROR-MESG         TO FIORP505-REC             
A02035           WRITE FIORP505-RECORD                                  
              END-IF                                                    
           ELSE                                                         
              IF E-FIOCA505-TRL = WS-TRAN-TRLR                          
                 MOVE E-FIOCA505-TRL-REC-CNT   TO  WS-TRL-REC-COUNT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 1400-PROCESS-COMMIT      THRU 1400-EXIT.             
                                                                        
           PERFORM 7000-READ-INPUT-FILE     THRU 7000-EXIT.             
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *1400-PROCESS-COMMIT.                                          *          
      ****************************************************************          
       1400-PROCESS-COMMIT.                                             
                                                                        
           ADD +1                           TO WS-COMMIT-COUNTER.       
                                                                        
A02035     IF WS-COMMITS-REQUIRE                                        
A02035        AND WS-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT                
              PERFORM 8898-ISSUE-CHKP       THRU 8898-EXIT              
           END-IF.                                                      
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2000-CONV-TRAN-FCTR.                                          *          
      ****************************************************************          
       2000-CONV-TRAN-FCTR.                                             
                                                                        
           MOVE E-FIOCA505-TRAN-USAGE       TO WS-FILE-FCTR-HOLD.       
           MOVE WS-FILE-FCTR-PRE            TO WS-FILE-FCTR-1.          
           MOVE WS-FILE-FCTR-POS            TO WS-FILE-FCTR-2.          
           COMPUTE WS-NEW-FACTOR = WS-NEW-FACTOR + WS-FILE-FCTR-1.      
           COMPUTE WS-NEW-FACTOR = WS-NEW-FACTOR + WS-FILE-FCTR-DIG.    
                                                                        
      * CONVERT THE DDC FACTOR TO DEKATHERMS FROM MCFS.                         
           COMPUTE WS-NEW-FACTOR ROUNDED =                              
                         ( WS-NEW-FACTOR * WS-DEKA-CONV-CONST ).        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *2100-GET-FCTR-DT.                                             *          
      ****************************************************************          
       2100-GET-FCTR-DT.                                                
                                                                        
           MOVE SPACES                      TO WS-NEW-FCTR-START-DT.    
                                                                        
           IF AT-REV-MTH-LST-NRML = 0                                   
              MOVE WS-CURRENT-DATE          TO BN-DATE-EXTRACT          
              PERFORM 7580-GET-MIN-REV-MTH  THRU 7580-EXIT              
              MOVE BN-REVENUE-MONTH         TO WS-NEW-FCTR-REV-MNTH     
           ELSE                                                         
              COMPUTE WS-NEW-FCTR-REV-MNTH = AT-REV-MTH-LST-NRML + 1    
           END-IF.                                                      
                                                                        
           IF WS-NEW-FCTR-MM > 12                                       
              MOVE 01                       TO WS-NEW-FCTR-MM           
              ADD +1                        TO WS-NEW-FCTR-CCYY         
           END-IF.                                                      
                                                                        
           MOVE WS-NEW-FCTR-CCYY            TO WS-NEW-FCTR-START-CCYY.  
           MOVE WS-NEW-FCTR-MM              TO WS-NEW-FCTR-START-MM.    
           MOVE '01'                        TO WS-NEW-FCTR-START-DD.    
           MOVE '/'                         TO WS-NEW-FCTR-START-SEP1   
                                               WS-NEW-FCTR-START-SEP2.  
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *5000-PROCESS-FCTRS                                            *          
      ****************************************************************          
       5000-PROCESS-FCTRS.                                              
                                                                        
           PERFORM 2000-CONV-TRAN-FCTR      THRU 2000-EXIT.             
           MOVE AT-ACCOUNT-TYPE-CODE        TO WS-ACCOUNT-TYPE.         
A05305     MOVE SPACES                      TO WS-77-COMMENTS-TEXT      
A05305                                         WS-WQ-START-DATE.        
                                                                        
                                                                        
           MOVE AT-ACCOUNT-NO               TO UT-ACCOUNT-NO            
A02035                                         WS-ACCOUNT-NO.           
           MOVE WS-CODE-UTIL-TYPE           TO UT-CODE-UTIL-TYPE.       
                                                                        
           PERFORM 7100-GET-IC-NO           THRU 7100-EXIT.             
A02035     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A02035        ADD +1                     TO WS-MISS-COUNT               
A02035                                      WS-REPT-COUNT               
A02035        MOVE SPACES                TO FIORP505-REC                
A02035                                      WS-ERROR-MESG               
A02035        STRING XM-DIST-ACCT-NO                                    
A03082               WS-MESG-UTIL                                       
A02035               WS-ACCOUNT-NO                                      
A02035        DELIMITED BY SIZE                                         
A02035        INTO WS-ERROR-MESG                                        
A02035        MOVE WS-ERROR-MESG         TO FIORP505-REC                
A02035        WRITE FIORP505-RECORD                                     
A02035        GO TO 5000-EXIT                                           
A02035     END-IF.                                                      
           MOVE AT-ACCOUNT-NO               TO FF-ACCOUNT-NO.           
           MOVE UT-IC-NO                    TO FF-IC-NO.                
           MOVE WS-CODE-UTIL-TYPE           TO FF-CODE-UTIL-TYPE.       
           MOVE WS-FACTOR-ID-DDC            TO FF-FACTOR-ID.            
           PERFORM 7900-GET-OLD-FCTRS       THRU 7900-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              IF ( FF-EFF-DATE-TO = WS-NEW-FCTR-END-DT ) AND            
                 ( FF-FACTOR      = WS-NEW-FACTOR )                     
                 GO TO 5000-EXIT                                        
ACT249        ELSE                                                      
ACT249          IF ( FF-EFF-DATE-FROM = WS-NEW-FCTR-START-DT AND        
ACT249               FF-FACTOR  NOT = WS-NEW-FACTOR )                   
ACT249               MOVE WS-NEW-FACTOR  TO WS-NEW-FACTOR-COMP          
ACT249               PERFORM 8100-UPDATE-DDC-FCTR THRU 8100-EXIT        
ACT249               PERFORM 5850-WRITE-FACTOR-MNT-HIST THRU 5850-EXIT  
A05305               MOVE FF-EFF-DATE-FROM     TO WS-WQ-START-DATE      
A05305               MOVE WS-WQ-MESSAGE-DIFF   TO WS-77-COMMENTS-TEXT   
A05305               PERFORM 5700-CREATE-WORK-QUEUE     THRU 5700-EXIT  
ACT249               GO TO 5000-EXIT                                    
                ELSE                                                    
                  MOVE WS-NEW-FCTR-START-DT  TO WS-NEW-FCTR-START-DATE  
                  PERFORM 7800-GET-FCTR-DATE THRU 7800-EXIT             
                  MOVE WS-FCTR-END-DT        TO FF-EFF-DATE-TO          
                  PERFORM 8000-EXP-OLD-FCTR  THRU 8000-EXIT             
ACT249          END-IF                                                  
A03082        END-IF                                                    
           END-IF.                                                      
                                                                        
A05305* 1. CREATE WQ IF NEW FACTOR > DELINQUENCY VALUE                          
A05305* 2. IF NEW FACTOR & OLD FACTOR > DELINQUENCY DO NOT CREATE WQ            
A05305     IF RESIDENTIAL                                               
A05305        IF WS-NEW-FACTOR > WS-TRAN-RESI-VALUE                     
A05305           IF FF-FACTOR  > WS-TRAN-RESI-VALUE                     
A05305              CONTINUE                                            
A05305           ELSE                                                   
A05305              MOVE WS-NEW-FACTOR      TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-NEW-FACTOR-RESI    
A05305              MOVE WS-TRAN-RESI-VALUE TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-LIMIT-RESI         
A05305              MOVE FF-FACTOR          TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-OLD-FACTOR-RESI    
A05305              MOVE WS-WQ-MESSAGE-RESI TO WS-77-COMMENTS-TEXT      
A05305              PERFORM 5700-CREATE-WORK-QUEUE THRU 5700-EXIT       
A05305              GO TO 5000-EXIT                                     
A05305           END-IF                                                 
A05305        END-IF                                                    
A05305     END-IF.                                                      
A05305                                                                  
A05305     IF COMMERCIAL                                                
A05305        IF WS-NEW-FACTOR > WS-TRAN-COMM-VALUE                     
A05305           IF FF-FACTOR  > WS-TRAN-COMM-VALUE                     
A05305              CONTINUE                                            
A05305           ELSE                                                   
A05305              MOVE WS-NEW-FACTOR      TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-NEW-FACTOR-COMM    
A05305              MOVE WS-TRAN-COMM-VALUE TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-LIMIT-COMM         
A05305              MOVE FF-FACTOR          TO WS-FACTOR-DISP           
A05305              MOVE WS-FACTOR-DISP     TO WS-WQ-OLD-FACTOR-COMM    
A05305              MOVE WS-WQ-MESSAGE-COMM TO WS-77-COMMENTS-TEXT      
A05305              PERFORM 5700-CREATE-WORK-QUEUE THRU 5700-EXIT       
A05305              GO TO 5000-EXIT                                     
A05305           END-IF                                                 
A05305        END-IF                                                    
A05305     END-IF.                                                      
A05305                                                                  
           PERFORM 5600-BUILD-INSERT-VAR    THRU 5600-EXIT.             
           PERFORM 8700-INSERT-FACTOR       THRU 8700-EXIT.             
           PERFORM 5800-WRITE-TRAN-DET      THRU 5800-EXIT.             
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *5600-BUILD-INSERT-VAR                                         *          
      ****************************************************************          
       5600-BUILD-INSERT-VAR.                                           
                                                                        
           MOVE 0                           TO FF-CODE-TIME-PERIOD      
                                               FF-RT-PKG-OPT-SEQ-NO     
                                               FF-FAC-CHRG-BASE-AM.     
           MOVE WS-R                        TO FF-INSTR-USE-TYPE-CD.    
           MOVE WS-B                        TO FF-CODE-SEASON.          
           MOVE WS-10                       TO FF-CMPNT-ID-CD .         
           MOVE WS-FACTOR-TYP-CD            TO FF-FIXED-FCTR-TYP-CD.    
           MOVE WS-NEW-FACTOR               TO FF-FACTOR.               
           MOVE WS-NEW-FCTR-START-DT        TO FF-EFF-DATE-FROM.        
           MOVE WS-NEW-FCTR-END-DT          TO FF-EFF-DATE-TO.          
                                                                        
      * GET THE NEXT SEQ NO                                                     
           MOVE 0                           TO WS-MAX-SEQ-NO.           
                                                                        
           PERFORM 7560-SELECT-MAX-SEQ-NO   THRU 7560-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE FF-FIXED-FCTR-SEQ-NO     TO WS-MAX-SEQ-NO            
           END-IF.                                                      
                                                                        
           COMPUTE WS-MAX-SEQ-NO = WS-MAX-SEQ-NO + 1.                   
           MOVE WS-MAX-SEQ-NO               TO FF-FIXED-FCTR-SEQ-NO.    
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ****************************************************************          
      *5700-CREATE-WORK-QUEUE                                        *          
      ****************************************************************          
       5700-CREATE-WORK-QUEUE.                                          
                                                                        
ACT006     MOVE WS-CATEGORY-ID           TO WS-77-CATEGORY-ID.          
ACT006     MOVE SPACES                   TO WS-77-RESP-AREA-ID.         
ACT006     MOVE WS-CURRENT-DATE          TO WS-INPUT-DATE-26(1:10).     
ACT006     MOVE WS-INPUT-ZERO            TO WS-INPUT-DATE-26(11:16).    
ACT006     MOVE WS-INPUT-DATE-26         TO WS-77-DATE-CREATED.         
ACT006     MOVE ZEROS                    TO WS-77-SERV-ORDER-NO.        
ACT006     MOVE WS-CURR-PLUS-30-DAYS     TO WS-77-DATE-REQUIRED.        
ACT006     MOVE AT-ACCOUNT-NO            TO WS-77-ACCOUNT-NO.           
ACT006     MOVE AT-PREMISE-NO            TO WS-77-PREMISE-NO.           
ACT006     MOVE AT-CUSTOMER-NO           TO WS-77-CUSTOMER-NO.          
ACT006     MOVE AT-LOCAL-OFFICE          TO WS-77-LOCAL-OFFICE.         
ACT006     MOVE WS-ROUTING-CATEGORY      TO WS-77-ROUTE-CATEGORY.       
ACT006     MOVE WS-SYSTEM                TO WS-77-USER-ID-ORIG.         
ACT006     MOVE WS-NO                    TO WS-77-PRIORITY.             
ACT006     MOVE SPACES                   TO WS-77-FREE-FORM-TXT.        
ACT006     MOVE LENGTH OF WS-77-FREE-FORM-TXT                           
ACT006                                   TO WS-77-FREE-FORM-LEN.        
ACT006     MOVE WS-PGRMNAME              TO WS-77-CREATED-BY.           
A05305     MOVE LENGTH OF WS-77-COMMENTS-TEXT                           
A05305                                   TO WS-77-COMMENTS-LEN.         
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *5800-WRITE-TRAN-DET                                           *          
      ****************************************************************          
       5800-WRITE-TRAN-DET.                                             
                                                                        
           ADD  +1                     TO WS-TRAN-APPL-NO.              
           MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
           MOVE WS-FACTOR-TEXT         TO MI-COLUMN-DESC.               
           MOVE WS-NEW                 TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                       TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE FF-FACTOR              TO WS-FACTOR-DISP.               
           MOVE WS-FACTOR-DISP         TO WS-FACT-VAL-Z.                
           MOVE WS-FACT-VAL-Z          TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                       TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE SPACES                 TO MI-TABLE-ID.                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD  +1                     TO WS-TRAN-APPL-NO.              
           MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
           MOVE WS-DATE-FROM-TEXT      TO MI-COLUMN-DESC.               
           MOVE WS-NEW                 TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                       TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE FF-EFF-DATE-FROM       TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                       TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD  +1                     TO WS-TRAN-APPL-NO.              
           MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
           MOVE WS-DATE-TO-TEXT        TO MI-COLUMN-DESC.               
           MOVE WS-NEW                 TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                       TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE FF-EFF-DATE-TO         TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                       TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT249*** FACTOR CHANGE HISTORY ***                                             
ACT249 5850-WRITE-FACTOR-MNT-HIST.                                      
ACT249                                                                  
ACT249     ADD  +1                     TO WS-TRAN-APPL-NO.              
ACT249     MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO.              
ACT249     MOVE WS-FACTOR-TEXT         TO MI-COLUMN-DESC.               
ACT249     MOVE FF-FACTOR              TO WS-FACTOR-DISP.               
ACT249     MOVE WS-FACTOR-DISP         TO WS-FACT-VAL-Z.                
ACT249     MOVE WS-FACT-VAL-Z          TO MI-PRV-COLUMN-VALUE-TEXT.     
ACT249     MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
ACT249                                 TO MI-PRV-COLUMN-VALUE-LEN.      
ACT249     MOVE WS-NEW-FACTOR          TO WS-FACTOR-DISP.               
ACT249     MOVE WS-FACTOR-DISP         TO WS-FACT-VAL-Z.                
ACT249     MOVE WS-FACT-VAL-Z          TO MI-CHG-COLUMN-VALUE-TEXT.     
ACT249     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
ACT249                                 TO MI-CHG-COLUMN-VALUE-LEN.      
ACT249     MOVE SPACES                 TO MI-TABLE-ID.                  
ACT249     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
ACT249                                                                  
ACT249 5850-EXIT.                                                       
ACT249      EXIT.                                                       
                                                                        
      ****************************************************************          
      *5900-PROCESS-SUCCESSFUL-JOB                                   *          
      ****************************************************************          
       5900-PROCESS-SUCCESSFUL-JOB.                                     
                                                                        
           MOVE SPACES                      TO WS-RESTART-JOB-COMPLETE. 
           IF  WS-THIS-IS-A-RESTART                                     
               SET WS-RERUN-COMPLETED       TO TRUE                     
           ELSE                                                         
               SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                 
           END-IF.                                                      
                                                                        
           PERFORM 8899-WRITE-RSDDR         THRU 8899-EXIT.             
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                                            THRU 8893-EXIT              
           END-IF.                                                      
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *6235-GET-FJC01-RESTART-REQ                                    *          
      ****************************************************************          
       COPY CPD00035.                                                           
                                                                        
      ****************************************************************          
      *6253-GET-FJC01-CHKP-LIMIT                                     *          
      ****************************************************************          
       COPY CPD00034.                                                           
                                                                        
      ****************************************************************          
      *6510-MOVE-TRANS-HDR-DETAILS                                   *          
      ****************************************************************          
       6510-MOVE-TRANS-HDR-DETAILS.                                     
                                                                        
           PERFORM 7410-GET-CURR-TIMESTAMP  THRU 7410-EXIT.             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO     
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
                                                                        
           MOVE WS-F                        TO MH-CODE-TRAN-TYPE.       
           MOVE FF-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE 0                           TO MH-CUSTOMER-NO           
                                               MH-PREMISE-NO.           
           MOVE WS-SYSTEM                   TO MH-USER-ID.              
           MOVE WS-PGRMNAME                 TO MH-APPL-PROGRAM-ID.      
           MOVE WS-FACTOR-DESC              TO MH-TRAN-COMMENT-TEXT.    
           MOVE LENGTH OF WS-FACTOR-DESC    TO MH-TRAN-COMMENT-LEN.     
       6510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *6530-LOAD-MNT-TRANS-HIST                                      *          
      ****************************************************************          
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6510-MOVE-TRANS-HDR-DETAILS THRU 6510-EXIT        
              PERFORM 8600-INSERT-MNT-TRANS-HIST  THRU 8600-EXIT        
              PERFORM 8610-INSERT-MT-TRN-HST-DET  THRU 8610-EXIT        
           ELSE                                                         
              PERFORM 8610-INSERT-MT-TRN-HST-DET  THRU 8610-EXIT        
           END-IF.                                                      
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7000-READ-INPUT-FILE                                          *          
      ****************************************************************          
       7000-READ-INPUT-FILE.                                            
                                                                        
           READ FCSCA505-FILE                                           
A02035          AT END MOVE WS-YES TO WS-CA505-EOF.                     
A02035                                                                  
A02035     EVALUATE TRUE                                                
A02035         WHEN FCSCA505-SUCCESSFUL                                 
A02035             IF E-FIOCA505-TRAN-ID-CD = WS-TRANID                 
A02035                ADD 1               TO WS-TRAN-COUNT              
A02035*               DISPLAY 'AGL ACCT# : ' E-FIOCA505-AGLC-ACCT-NO            
A02035             END-IF                                               
A02035             ADD +1                 TO WS-TOTAL-COUNT             
A02035         WHEN FCSCA505-EOF                                        
A02035             CONTINUE                                             
A02035         WHEN OTHER                                               
A02035             DISPLAY 'ERROR 7000, CA505 STATUS = '                
A02035             WS-FCSCA505-STATUS                                   
A02035             DISPLAY '**  PROCESSING TERMINATED  **'              
A02035             PERFORM 9900-ABEND          THRU 9900-EXIT           
A02035     END-EVALUATE.                                                
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7100-GET-IC-NO.                                               *          
      ****************************************************************          
       7100-GET-IC-NO.                                                  
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) UT.IC_NO                                         
A03082           INTO :UT-IC-NO                                         
                FROM   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO             
                AND   UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT UT.IC_NO                                                 
MFA-TR*          INTO :UT-IC-NO                                                 
MFA-TR*         FROM   CSS_UTIL_ENVRNMT UT                                      
MFA-TR*         WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                     
MFA-TR*         AND   UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
A02035     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM      '                    
              DISPLAY ' ERROR OPENING UTIL_ENV     '                    
              DISPLAY ' 7100-GET-IC-NO             '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT_NO      ' UT-ACCOUNT-NO                 
              DISPLAY ' CODE-UTIL-TYPE  ' UT-CODE-UTIL-TYPE             
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7400-GET-DATE-TIME.                                           *          
      ****************************************************************          
       7400-GET-DATE-TIME.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              DATEADD( DAY, 30, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME,
              :WS-CURR-PLUS-30-DAYS       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE      = CURRENT DATE                         
MFA-TR*           ,:WS-CURRENT-TIME      = CURRENT TIME                         
MFA-TR*           ,:WS-CURR-PLUS-30-DAYS = CURRENT DATE + 30 DAYS               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURRENT DATE '                    
              DISPLAY ' 7400-GET-DATE-TIME         '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7410-GET-CURR-TIMESTAMP                                       *          
      ****************************************************************          
       7410-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING CURR PLUS 30 DAYS'                
              DISPLAY ' 7410-GET-CURR-TIMESTAMP '                       
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' WS-CURRENT-DATE ' WS-CURRENT-DATE               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7500-SELECT-ACCT-NO                                           *          
      ****************************************************************          
       7500-SELECT-ACCT-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT XM.ACCOUNT_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.COMPANY_NO                                     
                     ,AT.REV_MTH_LST_NRML                               
                     ,AT.CUSTOMER_NO                                    
                     ,AT.PREMISE_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.ACCOUNT_TYPE_CODE                              
                     ,AT.REV_MTH_LST_NRML                               
               INTO  :XM-ACCOUNT-NO                                     
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-COMPANY-NO                                    
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-PREMISE-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-ACCOUNT-TYPE-CODE                             
                     ,:AT-REV-MTH-LST-NRML                              
               FROM  CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                 
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE XM.ACCOUNT_NO   = AT.ACCOUNT_NO                    
               AND XM.DIST_ACCT_NO   = :XM-DIST-ACCT-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XM.ACCOUNT_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                                      
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*        INTO  :XM-ACCOUNT-NO                                             
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*        FROM  CSS_MKT_XREF_ACCT XM                                       
MFA-TR*             ,CSS_ACCOUNT AT                                             
MFA-TR*        WHERE XM.ACCOUNT_NO   = AT.ACCOUNT_NO                            
MFA-TR*        AND XM.DIST_ACCT_NO   = :XM-DIST-ACCT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
A02035     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A03082                                                OR WS-811         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING ACCOUNT NO.  '                    
              DISPLAY ' 7500-SELECT-ACCT-NO        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #    : ' XM-DIST-ACCT-NO            
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7550-SELECT-RESTART-DATA                                      *          
      ****************************************************************          
       7550-SELECT-RESTART-DATA.                                        
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
               INTO  :RF-RESTART-DATA                                   
               FROM CSS_RESTART WITH(READUNCOMMITTED)                           
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
               AND PARTITION_NO   = :RF-PARTITION-NO                    
               AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*        INTO  :RF-RESTART-DATA                                           
MFA-TR*        FROM CSS_RESTART                                                 
MFA-TR*        WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                            
MFA-TR*        AND PARTITION_NO   = :RF-PARTITION-NO                            
MFA-TR*        AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING RESTART DATA '                    
              DISPLAY ' 7550-SELECT-RESTART-DATA   '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7560-SELECT-MAX-SEQ-NO                                        *          
      ****************************************************************          
       7560-SELECT-MAX-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FIXED_FCTR_SEQ_NO)                            
               INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-2                
               FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO    = :FF-ACCOUNT-NO                     
               AND CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                 
               AND IC_NO           = :FF-IC-NO                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FIXED_FCTR_SEQ_NO)                                    
MFA-TR*        INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-2                        
MFA-TR*        FROM CSS_FIXED_FCTR                                              
MFA-TR*        WHERE ACCOUNT_NO    = :FF-ACCOUNT-NO                             
MFA-TR*        AND CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                         
MFA-TR*        AND IC_NO           = :FF-IC-NO                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-2 < 0                                      
                 MOVE 0                     TO FF-FIXED-FCTR-SEQ-NO     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING MAX SEQ NO.  '                    
              DISPLAY ' 7560-SELECT-MAX-SEQ-NO     '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #      ' E-FIOCA505-AGLC-ACCT-NO    
              DISPLAY ' ACCOUNT-NO       : ' FF-ACCOUNT-NO              
              DISPLAY ' CODE-UTIL-TYPE   : ' FF-CODE-UTIL-TYPE          
              DISPLAY ' IC-NO            : ' FF-IC-NO                   
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7570-GET-FCTOR-DESC                                           *          
      ****************************************************************          
       7570-GET-FCTOR-DESC.                                             
                                                                        
           EXEC SQL                                                     
               SELECT FACTOR_TEXT                                       
               INTO :SF-FACTOR-TEXT                                     
               FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                      
               WHERE SF.FACTOR_ID = :SF-FACTOR-ID                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FACTOR_TEXT                                               
MFA-TR*        INTO :SF-FACTOR-TEXT                                             
MFA-TR*        FROM CSS_SPCL_FCTR SF                                            
MFA-TR*        WHERE SF.FACTOR_ID = :SF-FACTOR-ID                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING FACTOR DESC  '                    
              DISPLAY ' 7570-GET-FCTOR-DESC        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' SF-FACTOR-ID : ' SF-FACTOR-ID                   
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7580-GET-MIN-REV-MTH                                          *          
      ****************************************************************          
       7580-GET-MIN-REV-MTH.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) BN.REVENUE_MONTH                                 
                  INTO :BN-REVENUE-MONTH                                
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
                WHERE BN.DATE_EXTRACT <= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                ORDER BY BN.DATE_EXTRACT DESC                           
                        ,BN.REVENUE_MONTH ASC                           
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT BN.REVENUE_MONTH                                         
MFA-TR*           INTO :BN-REVENUE-MONTH                                        
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*         WHERE BN.DATE_EXTRACT <= :BN-DATE-EXTRACT                       
MFA-TR*         ORDER BY BN.DATE_EXTRACT DESC                                   
MFA-TR*                 ,BN.REVENUE_MONTH ASC                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING MIN REV MTH  '                    
              DISPLAY ' 7580-GET-MIN-REV-MTH       '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' BN-DATE-EXTRACT ' BN-DATE-EXTRACT               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7580-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  7600-START-FCSJC01                                          *          
      *  7610-READ-FCSJC01                                           *          
      *  7611-CLOSE                                                  *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *7700-SELECT-DLQ-VAL                                           *          
      ****************************************************************          
       7700-SELECT-DLQ-VAL.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29980000
MFA-TR*       SELECT DELINQ_VALUE                                       29990000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   30000000
MFA-TR*         FROM CSS_DELINQUENCY                                    30010000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         30020000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        30030000
MFA-TR*        WITH UR                                                  30040000
MFA-TR*    END-EXEC.                                                    30050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING DELINQ_VALUE '                    
              DISPLAY ' 7700-SELECT-DLQ-VAL        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY '* DELINQ CD  '  C8-DELINQ-CD                     
              DISPLAY '* COMPANY NO '  C8-COMPANY-NO                    
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7800-GET-FCTR-DATE.                                           *          
      ****************************************************************          
       7800-GET-FCTR-DATE.                                              
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-FCTR-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-FCTR-START-DATE
              ) <> 0) OR (LEN(:WS-NEW-FCTR-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-FCTR-START-DATE
              ), CONVERT(DATE, :WS-NEW-FCTR-START-DATE) ) )
            INTO
              :WS-FCTR-END-DT             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-FCTR-END-DT =                                           
MFA-TR*              DATE (:WS-NEW-FCTR-START-DATE) - 1 DAY                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING DATES        '                    
              DISPLAY ' 7800-GET-FCTR-DATE         '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' WS-NEW-FCTR-START-DATE ' WS-NEW-FCTR-START-DATE 
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7900-GET-OLD-FCTRS                                            *          
      ****************************************************************          
       7900-GET-OLD-FCTRS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EFF_DATE_FROM,
              EFF_DATE_TO,
              FACTOR,
              FIXED_FCTR_SEQ_NO                                 
               INTO   :FF-EFF-DATE-FROM                                 
                     ,:FF-EFF-DATE-TO                                   
                     ,:FF-FACTOR                                        
                     ,:FF-FIXED-FCTR-SEQ-NO                             
               FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                    
               AND IC_NO            = :FF-IC-NO                         
               AND CODE_UTIL_TYPE   = :FF-CODE-UTIL-TYPE                
               AND FACTOR_ID        = :FF-FACTOR-ID                     
               ORDER BY EFF_DATE_TO DESC                                
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EFF_DATE_FROM                                             
MFA-TR*              ,EFF_DATE_TO                                               
MFA-TR*              ,FACTOR                                                    
MFA-TR*              ,FIXED_FCTR_SEQ_NO                                         
MFA-TR*        INTO   :FF-EFF-DATE-FROM                                         
MFA-TR*              ,:FF-EFF-DATE-TO                                           
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*        FROM CSS_FIXED_FCTR                                              
MFA-TR*        WHERE ACCOUNT_NO     = :FF-ACCOUNT-NO                            
MFA-TR*        AND IC_NO            = :FF-IC-NO                                 
MFA-TR*        AND CODE_UTIL_TYPE   = :FF-CODE-UTIL-TYPE                        
MFA-TR*        AND FACTOR_ID        = :FF-FACTOR-ID                             
MFA-TR*        ORDER BY EFF_DATE_TO DESC                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR GETTING FACTOR DATES '                    
              DISPLAY ' 7900-GET-OLD-FCTRS         '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT-NO      ' FF-ACCOUNT-NO                 
              DISPLAY ' IC-NO           ' FF-IC-NO                      
              DISPLAY ' CODE-UTIL-TYPE  ' FF-CODE-UTIL-TYPE             
              DISPLAY ' FACTOR-ID       ' FF-FACTOR-ID                  
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8000-EXP-OLD-FCTR                                             *          
      ****************************************************************          
       8000-EXP-OLD-FCTR.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FIXED_FCTR                                    
               SET EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                  
                  ,LAST_UPDATE_TS    =  CIS.CURRENT$TIMESTAMP()               
               WHERE ACCOUNT_NO      = :FF-ACCOUNT-NO                   
               AND IC_NO             = :FF-IC-NO                        
               AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE               
               AND FACTOR_ID         = :FF-FACTOR-ID                    
               AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FIXED_FCTR                                            
MFA-TR*        SET EFF_DATE_TO       = :FF-EFF-DATE-TO                          
MFA-TR*           ,LAST_UPDATE_TS    =  CURRENT TIMESTAMP                       
MFA-TR*        WHERE ACCOUNT_NO      = :FF-ACCOUNT-NO                           
MFA-TR*        AND IC_NO             = :FF-IC-NO                                
MFA-TR*        AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                       
MFA-TR*        AND FACTOR_ID         = :FF-FACTOR-ID                            
MFA-TR*        AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR EXPIRING OLD FACTOR  '                    
              DISPLAY ' 8000-EXP-OLD-FCTR       '                       
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT-NO      ' FF-ACCOUNT-NO                 
              DISPLAY ' IC-NO           ' FF-IC-NO                      
              DISPLAY ' CODE-UTIL-TYPE  ' FF-CODE-UTIL-TYPE             
              DISPLAY ' FACTOR-ID       ' FF-FACTOR-ID                  
              DISPLAY ' FACTOR          ' FF-FACTOR                     
              DISPLAY ' EFF-DATE-TO     ' FF-EFF-DATE-TO                
              DISPLAY ' EFF-DATE-FROM   ' FF-EFF-DATE-FROM              
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT249****************************************************************          
ACT249*8100-UPDATE-DDC-FCTR                                          *          
ACT249****************************************************************          
ACT249 8100-UPDATE-DDC-FCTR.                                            
ACT249                                                                  
ACT249     EXEC SQL                                                     
ACT249         UPDATE CSS_FIXED_FCTR                                    
ACT249         SET FACTOR            = :WS-NEW-FACTOR-COMP              
ACT249         WHERE ACCOUNT_NO      = :FF-ACCOUNT-NO                   
ACT249         AND IC_NO             = :FF-IC-NO                        
ACT249         AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE               
ACT249         AND FACTOR_ID         = :FF-FACTOR-ID                    
ACT249         AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO            
ACT249     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT249                                                                  
ACT249     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT249                                                                  
ACT249     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT249        NEXT SENTENCE                                             
ACT249     ELSE                                                         
ACT249        DISPLAY '******************************************'      
ACT249        DISPLAY '      ABENDING PROGRAM '                         
ACT249        DISPLAY ' 8100-UPDATE-DDC-FCTR    '                       
ACT249        DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
ACT249        DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
ACT249        DISPLAY ' ACCOUNT-NO      ' FF-ACCOUNT-NO                 
ACT249        DISPLAY ' IC-NO           ' FF-IC-NO                      
ACT249        DISPLAY ' CODE-UTIL-TYPE  ' FF-CODE-UTIL-TYPE             
ACT249        DISPLAY ' FACTOR-ID       ' FF-FACTOR-ID                  
ACT249        DISPLAY ' FACTOR          ' FF-FACTOR                     
ACT249        DISPLAY ' EFF-DATE-TO     ' FF-EFF-DATE-TO                
ACT249        DISPLAY ' EFF-DATE-FROM   ' FF-EFF-DATE-FROM              
ACT249        DISPLAY '******************************************'      
ACT249        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT249     END-IF.                                                      
ACT249 8100-EXIT.                                                       
ACT249     EXIT.                                                        
                                                                        
      ****************************************************************          
      *8500-CREATE-REPT                                              *          
      ****************************************************************          
       8500-CREATE-REPT-HDR.                                            
                                                                        
           MOVE WS-PGRMNAME                 TO MAIL2-JOB-NAME           
                                               MAIL5-JOB-NAME.          
           MOVE  WS-SUBJECT-1               TO MAIL7-SUBJECT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-1.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-2.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-3.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-4.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-5.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-6.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-7.            
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM MAILHEAD-8.            
           ADD +1                           TO WS-REPT-COUNT.           
                                                                        
           MOVE WS-CURRENT-DATE             TO WS-RPRT-DATE.            
           MOVE WS-CURRENT-TIME             TO WS-RPRT-TIME.            
           MOVE 1                           TO WS-RPRT-PAGE-NO.         
           WRITE FIORP505-RECORD            FROM WS-HEADER-1.           
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM WS-HEADER-2.           
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM WS-HEADER-3.           
           ADD +1                           TO WS-REPT-COUNT.           
           WRITE FIORP505-RECORD            FROM WS-STARS.              
           ADD +1                           TO WS-REPT-COUNT.           
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8550-WRITE-CNTRS                                              *          
      ****************************************************************          
       8550-WRITE-CNTRS.                                                
                                                                        
           MOVE SPACES                      TO FIORP505-REC.            
           WRITE FIORP505-RECORD.                                       
                                                                        
           MOVE WS-MISS-COUNT               TO WS-MISS-CNTR-DISP.       
           STRING WS-RPT-TRL                                            
                  WS-MISS-CNTR-DISP                                     
           DELIMITED BY SIZE                                            
A02035     INTO WS-TEMP-MESG                                            
A02035     MOVE WS-TEMP-MESG                TO FIORP505-REC.            
           WRITE FIORP505-RECORD.                                       
                                                                        
           DISPLAY ' ********************************************* '.   
           DISPLAY ' RECORDS PROCESSED    : ' WS-TRAN-COUNT.            
           DISPLAY ' TRAILER RECORD COUNT : ' WS-TRL-REC-COUNT.         
           DISPLAY ' NO. OF MISSING ACCTS : ' WS-MISS-COUNT.            
           DISPLAY ' ********************************************* '.   
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8600-INSERT-MNT-TRANS-HIST                                    *          
      ****************************************************************          
       8600-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST (                         
                      TRANS_HIST_SEQ_NO                                 
                     ,DATE_TRANS                                        
                     ,CODE_TRAN_TYPE                                    
                     ,RESP_AREA_ID                                      
                     ,ACCOUNT_NO                                        
                     ,PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,USER_ID                                           
                     ,APPL_PROGRAM_ID                                   
                     ,TRAN_COMMENT)                                     
               VALUES( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                
                      ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                      ,:MH-CODE-TRAN-TYPE                               
                      ,:MH-RESP-AREA-ID                                 
                      ,:MH-ACCOUNT-NO                                   
                      ,:MH-PREMISE-NO                                   
                      ,:MH-CUSTOMER-NO                                  
                      ,:MH-USER-ID                                      
                      ,:MH-APPL-PROGRAM-ID                              
                      ,:MH-TRAN-COMMENT)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST (                                 
MFA-TR*               TRANS_HIST_SEQ_NO                                         
MFA-TR*              ,DATE_TRANS                                                
MFA-TR*              ,CODE_TRAN_TYPE                                            
MFA-TR*              ,RESP_AREA_ID                                              
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,APPL_PROGRAM_ID                                           
MFA-TR*              ,TRAN_COMMENT)                                             
MFA-TR*        VALUES( :MH-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MH-DATE-TRANS                                           
MFA-TR*               ,:MH-CODE-TRAN-TYPE                                       
MFA-TR*               ,:MH-RESP-AREA-ID                                         
MFA-TR*               ,:MH-ACCOUNT-NO                                           
MFA-TR*               ,:MH-PREMISE-NO                                           
MFA-TR*               ,:MH-CUSTOMER-NO                                          
MFA-TR*               ,:MH-USER-ID                                              
MFA-TR*               ,:MH-APPL-PROGRAM-ID                                      
MFA-TR*               ,:MH-TRAN-COMMENT)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR INSERTING MAINT HIST '                    
              DISPLAY ' 8600-INSERT-MNT-TRANS-HIST '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT-NO      ' MH-ACCOUNT-NO                 
              DISPLAY ' TRAN HIST SEQNO ' MH-TRANS-HIST-SEQ-NO          
              DISPLAY ' DATE TRANS      ' MH-DATE-TRANS                 
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8610-INSERT-MT-TRN-HST-DET                                    *          
      ****************************************************************          
       8610-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET(                          
                      TRANS_HIST_SEQ_NO                                 
                     ,TRAN_APPL_NO                                      
                     ,COLUMN_DESC                                       
                     ,PRV_COLUMN_VALUE                                  
                     ,CHG_COLUMN_VALUE                                  
                     ,TABLE_ID)                                         
               VALUES( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                
                      ,:MI-TRAN-APPL-NO                                 
                      ,:MI-COLUMN-DESC                                  
                      ,:MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                      ,:MI-TABLE-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET(                                  
MFA-TR*               TRANS_HIST_SEQ_NO                                         
MFA-TR*              ,TRAN_APPL_NO                                              
MFA-TR*              ,COLUMN_DESC                                               
MFA-TR*              ,PRV_COLUMN_VALUE                                          
MFA-TR*              ,CHG_COLUMN_VALUE                                          
MFA-TR*              ,TABLE_ID)                                                 
MFA-TR*        VALUES( :MI-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MI-TRAN-APPL-NO                                         
MFA-TR*               ,:MI-COLUMN-DESC                                          
MFA-TR*               ,:MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*               ,:MI-TABLE-ID)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR INSERTING HIST DET   '                    
              DISPLAY ' 8610-INSERT-MT-TRN-HST-DET '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT-NO      ' MH-ACCOUNT-NO                 
              DISPLAY ' TRAN HIST SEQNO ' MI-TRANS-HIST-SEQ-NO          
              DISPLAY ' TRAN APPL NO    ' MI-TRAN-APPL-NO               
              DISPLAY ' COLUMN DESC     ' MI-COLUMN-DESC                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8700-INSERT-FACTOR                                            *          
      ****************************************************************          
       8700-INSERT-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_FIXED_FCTR (                             
                         ACCOUNT_NO                                     
                        ,CODE_UTIL_TYPE                                 
                        ,IC_NO                                          
                        ,FIXED_FCTR_SEQ_NO                              
                        ,FACTOR_ID                                      
                        ,EFF_DATE_FROM                                  
                        ,CMPNT_ID_CD                                    
                        ,CODE_SEASON                                    
                        ,INSTR_USE_TYPE_CD                              
                        ,CODE_TIME_PERIOD                               
                        ,EFF_DATE_TO                                    
                        ,FIXED_FCTR_TYP_CD                              
                        ,FACTOR                                         
                        ,FAC_CHRG_BASE_AM                               
                        ,LAST_UPDATE_TS                                 
                        ,DURATION_REMAIN_NO                             
                        ,RT_PKG_OPT_SEQ_NO)                             
               VALUES(   :FF-ACCOUNT-NO                                 
                        ,:FF-CODE-UTIL-TYPE                             
                        ,:FF-IC-NO                                      
                        ,:FF-FIXED-FCTR-SEQ-NO                          
                        ,:FF-FACTOR-ID                                  
                        ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                        ,:FF-CMPNT-ID-CD                                
                        ,:FF-CODE-SEASON                                
                        ,:FF-INSTR-USE-TYPE-CD                          
                        ,:FF-CODE-TIME-PERIOD                           
                        ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
                        ,:FF-FIXED-FCTR-TYP-CD                          
                        ,:FF-FACTOR                                     
                        ,:FF-FAC-CHRG-BASE-AM                           
                        , CIS.CURRENT$TIMESTAMP()                             
                        , NULL                                          
                        ,:FF-RT-PKG-OPT-SEQ-NO)                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR (                                     
MFA-TR*                  ACCOUNT_NO                                             
MFA-TR*                 ,CODE_UTIL_TYPE                                         
MFA-TR*                 ,IC_NO                                                  
MFA-TR*                 ,FIXED_FCTR_SEQ_NO                                      
MFA-TR*                 ,FACTOR_ID                                              
MFA-TR*                 ,EFF_DATE_FROM                                          
MFA-TR*                 ,CMPNT_ID_CD                                            
MFA-TR*                 ,CODE_SEASON                                            
MFA-TR*                 ,INSTR_USE_TYPE_CD                                      
MFA-TR*                 ,CODE_TIME_PERIOD                                       
MFA-TR*                 ,EFF_DATE_TO                                            
MFA-TR*                 ,FIXED_FCTR_TYP_CD                                      
MFA-TR*                 ,FACTOR                                                 
MFA-TR*                 ,FAC_CHRG_BASE_AM                                       
MFA-TR*                 ,LAST_UPDATE_TS                                         
MFA-TR*                 ,DURATION_REMAIN_NO                                     
MFA-TR*                 ,RT_PKG_OPT_SEQ_NO)                                     
MFA-TR*        VALUES(   :FF-ACCOUNT-NO                                         
MFA-TR*                 ,:FF-CODE-UTIL-TYPE                                     
MFA-TR*                 ,:FF-IC-NO                                              
MFA-TR*                 ,:FF-FIXED-FCTR-SEQ-NO                                  
MFA-TR*                 ,:FF-FACTOR-ID                                          
MFA-TR*                 ,:FF-EFF-DATE-FROM                                      
MFA-TR*                 ,:FF-CMPNT-ID-CD                                        
MFA-TR*                 ,:FF-CODE-SEASON                                        
MFA-TR*                 ,:FF-INSTR-USE-TYPE-CD                                  
MFA-TR*                 ,:FF-CODE-TIME-PERIOD                                   
MFA-TR*                 ,:FF-EFF-DATE-TO                                        
MFA-TR*                 ,:FF-FIXED-FCTR-TYP-CD                                  
MFA-TR*                 ,:FF-FACTOR                                             
MFA-TR*                 ,:FF-FAC-CHRG-BASE-AM                                   
MFA-TR*                 , CURRENT TIMESTAMP                                     
MFA-TR*                 , NULL                                                  
MFA-TR*                 ,:FF-RT-PKG-OPT-SEQ-NO)                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM '                         
              DISPLAY ' ERROR INSERTING FACTOR     '                    
              DISPLAY ' 8700-INSERT-FACTOR         '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' AGL ACCOUNT #   ' E-FIOCA505-AGLC-ACCT-NO       
              DISPLAY ' ACCOUNT-NO      ' FF-ACCOUNT-NO                 
              DISPLAY ' IC-NO           ' FF-IC-NO                      
              DISPLAY ' CODE-UTIL-TYPE  ' FF-CODE-UTIL-TYPE             
              DISPLAY ' FACTOR-ID       ' FF-FACTOR-ID                  
              DISPLAY ' FACTOR          ' FF-FACTOR                     
              DISPLAY ' FIX FCTR SEQ NO ' FF-FIXED-FCTR-SEQ-NO          
              DISPLAY ' EFF-DATE-FROM   ' FF-EFF-DATE-FROM              
              DISPLAY ' EFF-DATE-TO     ' FF-EFF-DATE-TO                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8893-RESET-RESTART-REQ-PARM                                   *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *8895-INSERT-WORK-QUEUE                                        *          
      ****************************************************************          
       8895-INSERT-WORK-QUEUE.                                          
                                                                        
ACT006     CALL SCSCB077  USING   CWS00077-FIELDS,                      
ACT006                            ABEND-FILE,                           
ACT006                            RS-RETURN-CODE.                       
ACT006                                                                  
ACT006     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
ACT006                                                                  
ACT006     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
ACT006        MOVE WS-PGRMNAME              TO ABEND-PROGRAM            
ACT006        DISPLAY '8895-INSERT-WORK-QUEUE'                          
ACT006        DISPLAY 'CALL SCSCB077         '                          
ACT006        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
ACT006        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
ACT006        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
ACT006        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
ACT006        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT006     END-IF.                                                      
ACT006                                                                  
       8895-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8896-UPDATE-RESTART                                           *          
      ****************************************************************          
       8896-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM      '                    
              DISPLAY ' ERROR UPDATING RESTART ROW '                    
              DISPLAY ' 8896-UPDATE-RESTART        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY ' RESTART-DATA : ' RF-RESTART-DATA                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8896-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8897-INSERT-RESTART                                           *          
      ****************************************************************          
       8897-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM                                        
                   ,PARTITION_NO                                        
                   ,DUP_CNTRL_NO                                        
                   ,RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM                                    
                   ,:RF-PARTITION-NO                                    
                   ,:RF-DUP-CNTRL-NO                                    
                   ,:RF-RESTART-DATA)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '      ABENDING PROGRAM      '                    
              DISPLAY ' ERROR INSERTING RESTART ROW '                   
              DISPLAY ' 8897-INSERT-RESTART        '                    
              DISPLAY ' SQLCODE = ' WS-ACTIVE-RETURN-CODE               
              DISPLAY ' PROGRAM      : ' RF-NAME-PROGRAM                
              DISPLAY ' PARTITION-NO : ' RF-PARTITION-NO                
              DISPLAY ' DUP-CNTRL-NO : ' RF-DUP-CNTRL-NO                
              DISPLAY ' RESTART-DATA : ' RF-RESTART-DATA                
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
       8897-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8898-ISSUE-CHKP                                               *          
      ****************************************************************          
       8898-ISSUE-CHKP.                                                 
                                                                        
A02035     MOVE 1                          TO WS-RESTART-PROCESS-TYPE.  
           ADD +1                          TO WS-CHKP-SEQ-NO.           
           MOVE WS-CHKP-SEQ-NO             TO WS-RESTART-CHKP-SEQ-NO.   
A02035     MOVE E-FIOCA505-AGLC-ACCT-NO    TO WS-RESTART-AGLC-ACCT-NO.  
A02035     MOVE E-FIOCA505-PR-ID-NO        TO WS-RESTART-PR-ID-NO.      
A02035     MOVE E-FIOCA505-CUST-ID-NO      TO WS-RESTART-CUST-ID-NO.    
A02035     MOVE E-FIOCA505-TRAN-USAGE      TO WS-RESTART-TRAN-USAGE.    
A02035     MOVE WS-TOTAL-COUNT             TO WS-RESTART-TOTAL-COUNT.   
A02035     MOVE WS-MISS-COUNT              TO WS-RESTART-MISS-COUNT.    
A02035     MOVE WS-TRAN-COUNT              TO WS-RESTART-TRAN-COUNT.    
A02035     MOVE WS-REPT-COUNT              TO WS-RESTART-REPT-COUNT.    
A02035                                                                  
           PERFORM 8899-WRITE-RSDDR        THRU 8899-EXIT.              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
                                                                        
           MOVE 0                        TO WS-COMMIT-COUNTER.          
A02035     DISPLAY 'COMMIT POINT # : ' WS-CHKP-SEQ-NO ' TAKEN '         
A02035             'LAST AGL ACCT # '  E-FIOCA505-AGLC-ACCT-NO          
A02035             ' PR-ID '           E-FIOCA505-PR-ID-NO              
A02035             ' CUST-ID '         E-FIOCA505-CUST-ID-NO            
A02035             ' TRAN USAGE '      E-FIOCA505-TRAN-USAGE.           
                                                                        
       8898-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *8899-WRITE-RSDDR                                              *          
      ****************************************************************          
       8899-WRITE-RSDDR.                                                
                                                                        
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-DUP-CNTRL-NO          
                                               RF-PARTITION-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
           PERFORM 8896-UPDATE-RESTART      THRU 8896-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 8897-INSERT-RESTART   THRU 8897-EXIT              
           END-IF.                                                      
       8899-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *9000-TERMINATE.                                               *          
      ****************************************************************          
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA505-FILE                                          
                 FCSRP505-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           GO TO 9900-EXIT.                                             
                                                                        
      ****************************************************************          
      *  9900-ABEND                                                  *          
      *  THIS INCLUDES THE DB2 SQL ABEND MODULE                      *          
      *  MOVES 12 TO RETURN CODE                                     *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
