       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA504.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     FEB 08, 2016.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      **  THIS PROGRAM OBTAINS THE INPUT TEST YEAR FROM CSS_JOB_PARM  **        
      **  TABLE.  IF NONE IS PRESENT, THEN THE CURRENT YEAR IS USED.  **        
      **  IT COPIES CSS_MTR_TEST_HIST ENTRIES FOR ALL SAMPLE TESTS TO **        
      **  THE NEW SAMPLE TEST YEAR FOR ELECTRIC METER TESTS.  IT ALSO **        
      **  PROCESSES THE METER TEST GROUP TABLE AND CREATES NEW TEST   **        
      **  HISTORY RECORDS FOR THE TEST YEAR FOR ELIGIBLE TEST GROUPS. **        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
A05268***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
ACT044***  07/29/2015    VV7M728     EZY TO COBOL CONVERSION         ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA504'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MTR_TEST_HIST                                        *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRTST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      ***************************************************************           
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'              *           
      ***************************************************************           
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
                                                                        
       COPY CWS00010.                                                           
      *                                                             *           
      ******************************************************************        
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSCA504'.     
      *                                                                         
      *                                                                         
       01 WS-FLAGS.                                                     
           05 WS-PARM-FOUND             PIC X(01) VALUE 'N'.            
           05 WS-ALL-ROWS-PROCESD       PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-REC-COUNT             PIC 9(04) VALUE ZEROES.         
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                    PIC 9(04).                      
           05  WS-CM                    PIC 9(02).                      
           05  WS-CD                    PIC 9(02).                      
      *                                                                         
       01 WS-MISC.                                                      
           05  WS-PGRMNAME              PIC X(08) VALUE SPACES.         
           05  RPT-PGM-NAME             PIC X(08) VALUE SPACES.         
           05  WS-PARM-DATA             PIC X(04) VALUE SPACES.         
           05  TEST-YEAR                REDEFINES  WS-PARM-DATA         
                                        PIC 9(04).                      
           05  WS-REC-FLAG              PIC X(01) VALUE SPACES.         
           05  WS-TEST-DATE             PIC X(10) VALUE SPACES.         
           05  WS-TEST-DATE-YY          PIC X(04) VALUE ZEROES.         
           05  WS-TEST-YEAR             PIC S9(4) USAGE COMP.           
           05  WS-TEST-YEAR-DISP        PIC Z,ZZ9.                      
           05  WS-SELECT-YEAR-DISP      PIC Z,ZZ9.                      
           05  WS-MQ-TEST-YEAR          PIC Z,ZZ9.                      
           05  WS-SELECT-YEAR           PIC 9(04) VALUE ZEROES.         
           05  WS-DUMMY                 PIC X(01) VALUE SPACES.         
           05  WS-COMPANY-NO            PIC X(02) VALUE '01'.           
           05  WS-CURSOR                PIC X(15) VALUE SPACES.         
           05  WS-FUNCTION              PIC X(15) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
      *                                                                         
      ***************************************************************           
      *CURSOR FOR TEST HISTORY RECORDS                              *           
      ***************************************************************           
      *                                                                         
            EXEC SQL                                                    
             DECLARE COPY_TEST_REC CURSOR FOR                           
                SELECT GR1.MTR_TEST_GRP_CD                              
                      ,GR1.MTR_TEST_GRP_TX                              
                  FROM CSS_MTR_TEST_GROUP GR1 WITH(READUNCOMMITTED)             
                      ,CSS_ELEC_TST_GROUP  GG1 WITH(READUNCOMMITTED)            
                 WHERE GR1.CODE_UTIL_TYPE  = 'E'                        
                 AND   GR1.CODE_UTIL_TYPE  = GG1.CODE_UTIL_TYPE         
                 AND   GR1.COMPANY_NO      = :WS-COMPANY-NO             
                 AND   GR1.COMPANY_NO      = GG1.COMPANY_NO             
                 AND   GR1.MTR_TEST_GRP_CD = GG1.MTR_TEST_GRP_CD        
                 AND NOT EXISTS                                         
                 (SELECT '1'                                            
                   FROM CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)              
                  WHERE  MQ.CODE_UTIL_TYPE  = 'E'                       
                    AND  MQ.MTR_TEST_GRP_CD = GR1.MTR_TEST_GRP_CD       
                    AND  MQ.COMPANY_NO      = GR1.COMPANY_NO            
                    AND  MQ.TEST_SCHED_CD   = 'R'                       
                    AND  MQ.TEST_YEAR       = :WS-TEST-YEAR             
                    AND MQ.INSTALLED_QT     = 0)                        
                   FOR READ ONLY                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*      DECLARE COPY_TEST_REC CURSOR FOR                                   
MFA-TR*         SELECT GR1.MTR_TEST_GRP_CD                                      
MFA-TR*               ,GR1.MTR_TEST_GRP_TX                                      
MFA-TR*           FROM CSS_MTR_TEST_GROUP GR1                                   
MFA-TR*               ,CSS_ELEC_TST_GROUP  GG1                                  
MFA-TR*          WHERE GR1.CODE_UTIL_TYPE  = 'E'                                
MFA-TR*          AND   GR1.CODE_UTIL_TYPE  = GG1.CODE_UTIL_TYPE                 
MFA-TR*          AND   GR1.COMPANY_NO      = :WS-COMPANY-NO                     
MFA-TR*          AND   GR1.COMPANY_NO      = GG1.COMPANY_NO                     
MFA-TR*          AND   GR1.MTR_TEST_GRP_CD = GG1.MTR_TEST_GRP_CD                
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*          (SELECT '1'                                                    
MFA-TR*            FROM CSS_MTR_TEST_HIST MQ                                    
MFA-TR*           WHERE  MQ.CODE_UTIL_TYPE  = 'E'                               
MFA-TR*             AND  MQ.MTR_TEST_GRP_CD = GR1.MTR_TEST_GRP_CD               
MFA-TR*             AND  MQ.COMPANY_NO      = GR1.COMPANY_NO                    
MFA-TR*             AND  MQ.TEST_SCHED_CD   = 'R'                               
MFA-TR*             AND  MQ.TEST_YEAR       = :WS-TEST-YEAR                     
MFA-TR*             AND MQ.INSTALLED_QT     = 0)                                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*     END-EXEC.                                                           
      *                                                                         
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 2000-PROCESS-TEST-GROUP          THRU  2000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           DISPLAY '*******************************'                    
           DISPLAY 'JOB RUNNING FOR COMPANY NO = ', WS-COMPANY-NO       
           DISPLAY '*******************************'                    
                                                                        
           PERFORM 0200-GET-PARM-DATE               THRU  0200-EXIT     
                                                                        
           MOVE WS-TEST-YEAR              TO WS-SELECT-YEAR             
           COMPUTE WS-TEST-YEAR = WS-TEST-YEAR - 1                      
                                                                        
           MOVE WS-TEST-YEAR              TO WS-TEST-YEAR-DISP          
           MOVE WS-SELECT-YEAR            TO WS-SELECT-YEAR-DISP        
                                                                        
           DISPLAY 'WS-TEST-YEAR   =  ' WS-TEST-YEAR-DISP               
           DISPLAY 'TEST YEAR      = ' TEST-YEAR                        
           DISPLAY 'WS-SELECT-YEAR =  ' WS-SELECT-YEAR-DISP.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      ** 0200-GET-PARM-DATE                                           **        
      ******************************************************************        
      *                                                                         
       0200-GET-PARM-DATE.                                              
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
           MOVE 'ELC504'                  TO WS-PGRMNAME                
                                             RPT-PGM-NAME.              
           MOVE 'PARM'                    TO WS-DATE.                   
           MOVE WS-COMPANY-NO             TO G6-COMPANY-NO.             
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE G6-PARM-DATA(1:4)         TO WS-PARM-DATA.              
           MOVE WS-PARM-DATA              TO TEST-YEAR.                 
                                                                        
                                                                        
           IF G6-PARM-DATA > SPACES                                     
                                                                        
            IF WS-PARM-DATA NUMERIC                                     
             MOVE TEST-YEAR               TO WS-TEST-YEAR               
            ELSE                                                        
             DISPLAY 'YEAR SHOULD BE NUMERIC'                           
             DISPLAY '******** PCSCA504 ABORT *****'                    
             DISPLAY '**YEAR SHOULD BE NUMERIC   **'                    
             DISPLAY '**  PROCESSING TERMINATED  **'                    
             PERFORM 9900-ABEND                  THRU 9900-EXIT         
            END-IF                                                      
           ELSE                                                         
             ACCEPT WS-CURRENT-DATE FROM DATE YYYYMMDD                  
             MOVE WS-CY                   TO WS-TEST-DATE-YY            
             MOVE WS-TEST-DATE-YY         TO WS-TEST-YEAR               
             MOVE WS-TEST-DATE-YY         TO TEST-YEAR                  
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2000-PROCESS-TEST-GROUP.                                     *          
      ****************************************************************          
      *                                                                         
        2000-PROCESS-TEST-GROUP.                                        
      *                                                                         
           MOVE 'E'                            TO MQ-CODE-UTIL-TYPE.    
           MOVE TEST-YEAR                      TO MQ-TEST-YEAR.         
           MOVE 0                              TO MQ-SELECTED-QT.       
           MOVE 0                              TO MQ-INSTALLED-QT.      
           MOVE 'A'                            TO MQ-STATUS-CD.         
           MOVE 0                              TO MQ-TESTED-QT.         
           MOVE 0                              TO MQ-SAMPLE-MIN-QT.     
           MOVE 0                              TO MQ-SAMPL-ADDITIONL-QT.
           MOVE 'R'                            TO MQ-TEST-SCHED-CD      
           MOVE 10                             TO MQ-SAMPL-OVERAGE-PCT  
           MOVE 0                              TO MQ-SAMPL-CORRECTV-PCT 
      *                                                                         
           PERFORM 7200-OPEN-COPY-TEST-REC          THRU  7200-EXIT.    
      *                                                                         
           PERFORM 7300-FETCH-COPY-TEST-REC         THRU  7300-EXIT.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                                        
              PERFORM 2200-CREATE-NEW-TEST          THRU 2200-EXIT      
              UNTIL WS-ALL-ROWS-PROCESD = WS-Y                          
                                                                        
           END-IF.                                                      
           DISPLAY 'TOTAL TEST GROUP RECS. CREATED = ' WS-REC-COUNT     
                                                                        
           PERFORM 7400-CLOSE-COPY-TEST-REC         THRU  7400-EXIT     
           .                                                            
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2200-CREATE-NEW-TEST.                                       **        
      ******************************************************************        
      *                                                                         
       2200-CREATE-NEW-TEST.                                            
      *                                                                         
           PERFORM 7500-EXIST-CHECK                THRU  7500-EXIT      
           MOVE MQ-TEST-YEAR                 TO WS-MQ-TEST-YEAR         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             DISPLAY 'RECORD ALREADY EXISTS WITH'                       
                                               ' ' MQ-CODE-UTIL-TYPE    
                                             '   ' WS-MQ-TEST-YEAR      
                                             '   ' MQ-TEST-SCHED-CD     
                                              '  ' MQ-MTR-TEST-GRP-CD   
                                              '  ' MQ-MTR-TEST-GRP-TX   
           ELSE                                                         
             PERFORM 7650-INS-MTR-TEST-DATA        THRU  7650-EXIT      
                                                                        
             DISPLAY 'NEW MTR TEST GRP INSERTED:' MQ-MTR-TEST-GRP-CD    
                                              ' ' MQ-MTR-TEST-GRP-TX    
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7300-FETCH-COPY-TEST-REC        THRU  7300-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
                                                                        
      ******************************************************************        
      ** 7200-OPEN-COPY-TEST-REC.                                     **        
      ******************************************************************        
      *                                                                         
       7200-OPEN-COPY-TEST-REC.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN COPY_TEST_REC                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA504 ABORT *****'                   
              DISPLAY '**OPEN COPY_TEST_REC ERROR **'                   
              DISPLAY '**7200-OPEN-COPY-TEST-REC  **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-FETCH-COPY-TEST-REC.                                    **        
      ******************************************************************        
      *                                                                         
       7300-FETCH-COPY-TEST-REC.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH COPY_TEST_REC                                       
               INTO :MQ-MTR-TEST-GRP-CD                                 
                   ,:MQ-MTR-TEST-GRP-TX                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
              CONTINUE                                                  
           WHEN NOT-FOUND                                               
              MOVE WS-Y                   TO WS-ALL-ROWS-PROCESD        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA504 ABORT *****'                   
              DISPLAY '**  MAIN CURSOR FETCH ERROR**'                   
              DISPLAY '**7300-FETCH-COPY-TEST-REC **'                   
              DISPLAY '**WS-COMPANY-NO        =' WS-COMPANY-NO          
              DISPLAY '**WS-TEST-YEAR         =' WS-TEST-YEAR           
              DISPLAY '**RETURN CODE          =' WS-ACTIVE-RETURN-CODE  
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-CLOSE-COPY-TEST-REC                                     **        
      ******************************************************************        
      *                                                                         
       7400-CLOSE-COPY-TEST-REC.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE COPY_TEST_REC                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA504 ABORT *****'                   
              DISPLAY '**CLOSE COPY_TEST_REC ERROR**'                   
              DISPLAY '**7400-CLOSE-COPY-TEST-REC **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7500-EXIST-CHECK.                                           **        
      ******************************************************************        
      *                                                                         
       7500-EXIST-CHECK.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT  'Y'                                               
                INTO :WS-DUMMY                                          
                FROM  CSS_MTR_TEST_HIST WITH(READUNCOMMITTED)                   
               WHERE  CODE_UTIL_TYPE       = :MQ-CODE-UTIL-TYPE         
                 AND  TEST_YEAR            = :MQ-TEST-YEAR              
                 AND  TEST_SCHED_CD        = :MQ-TEST-SCHED-CD          
                 AND  MTR_TEST_GRP_CD      = :MQ-MTR-TEST-GRP-CD        
                 AND  COMPANY_NO           = :WS-COMPANY-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO :WS-DUMMY                                                  
MFA-TR*         FROM  CSS_MTR_TEST_HIST                                         
MFA-TR*        WHERE  CODE_UTIL_TYPE       = :MQ-CODE-UTIL-TYPE                 
MFA-TR*          AND  TEST_YEAR            = :MQ-TEST-YEAR                      
MFA-TR*          AND  TEST_SCHED_CD        = :MQ-TEST-SCHED-CD                  
MFA-TR*          AND  MTR_TEST_GRP_CD      = :MQ-MTR-TEST-GRP-CD                
MFA-TR*          AND  COMPANY_NO           = :WS-COMPANY-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
             CONTINUE                                                   
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA504 ABORT *****'                   
              DISPLAY '**7500-EXIST-CHECK           **'                 
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **   7650-INS-MTR-TEST-DATA.                                  **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       7650-INS-MTR-TEST-DATA.                                          
      *                                                                 08230000
           EXEC SQL                                                     
              INSERT INTO CSS_MTR_TEST_HIST                             
                     (                                                  
                      CODE_UTIL_TYPE                                    
                     ,TEST_YEAR                                         
                     ,TEST_SCHED_CD                                     
                     ,MTR_TEST_GRP_CD                                   
                     ,SELECTED_QT                                       
                     ,INSTALLED_QT                                      
                     ,LAST_TEST_SEL_DT                                  
                     ,STATUS_CD                                         
                     ,TESTED_QT                                         
                     ,SAMPLE_MIN_QT                                     
                     ,SAMPL_ADDITIONL_QT                                
                     ,SAMPL_CORRECTV_PCT                                
                     ,SAMPL_OVERAGE_PCT                                 
                     ,COMPANY_NO                                        
                     ,MTR_TEST_GRP_TX                                   
                     )                                                  
              VALUES                                                    
                     (                                                  
                      :MQ-CODE-UTIL-TYPE                                
                     ,:MQ-TEST-YEAR                                     
                     ,:MQ-TEST-SCHED-CD                                 
                     ,:MQ-MTR-TEST-GRP-CD                               
                     ,:MQ-SELECTED-QT                                   
                     ,:MQ-INSTALLED-QT                                  
                     ,NULL                                              
                     ,:MQ-STATUS-CD                                     
                     ,:MQ-TESTED-QT                                     
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-SAMPL-ADDITIONL-QT                            
                     ,:MQ-SAMPL-CORRECTV-PCT                            
                     ,:MQ-SAMPL-OVERAGE-PCT                             
                     ,:WS-COMPANY-NO                                    
                     ,:MQ-MTR-TEST-GRP-TX                               
                     )                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
      *        DISPLAY 'MTR TEST HIST INSERT SUCCESSFUL'                        
               COMPUTE WS-REC-COUNT         = WS-REC-COUNT + 1          
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA966 ABORT    *****'                
              DISPLAY '**MTR TEST HIST INSERT FAILED **'                
              DISPLAY '**7650-INS-MTR-TEST-DATA      **'                
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**INSERT CODE = ' MQ-MTR-TEST-GRP-CD             
              DISPLAY '**PROCESSING TERMINATED       **'                
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           DISPLAY '                             '.                     
           DISPLAY ' PROGRAM ENDED SUCCESSFULLY  '.                     
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
