       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA480.                                        
       DATE-WRITTEN.   APR 2008.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      *              P R O G R A M  S U M M A R Y                     *         
      *****************************************************************         
      **     INSERTS VALUE MODEL POSTING FILE IN TO CIS TABLES       **         
      **  THIS PROGRAM READS THE INPUT FILE RECORDS AND VALIDATES    **         
      **  THE DATA AND THEN INSERTS IN TO CIS TABLE                  **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  04/2008   VY95550      CIS VALUE MODEL POSTING             **         
      **                                                             **         
A00765**  02/02/09   CVNS        ADDED 9000-SEND-ERROR-RESULT PARA   **         
A00765**            CHENNAI                                          **         
C37825**                                                             **         
C37825**  05/2009   VY95550      SKIP THE LAST SUCCESSFULLY PROCESSED**         
C37825**                         RECORD  DURING RESTART AND          **         
C37790**                         ADDED VALUE MODEL FILE CHECK        **         
A02904**  11/2010   VY95550      MODIFIED TO SUPPORT SMALL COMMERCIAL**         
A02904**                         CUSTOMERS                           **         
      *****************************************************************         
      *                                                                *00993000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00993100
      *                                                                *00993200
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00993300
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00993400
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00993500
      *  3000 - 4999  NOT USED                                         *00993600
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00993700
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00993800
      *  7000 - 7999  INPUT MODULES                                    *00993900
      *  8000 - 8999  OUTPUT MODULES                                   *00994000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00994100
      *                                                                *00994200
      ******************************************************************00994300
      *                                                                         
           REMARKS.                                                     
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSMKT01.                                               00990000
           COPY CSSPT33.                                                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDMKT01.                                               PCS00680
           COPY FIOMKT01.                                               PCS00690
                                                                        
           COPY CFDPT33.                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA480'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40)     VALUE              
             'WORKING STORAGE FOR PCSCA480 STARTS HERE'.                
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA480'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA480'.      
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
C37825     05  WS-I                    PIC X(01) VALUE 'I'.             
           05  WS-803                  PIC S9(9) VALUE -803 COMP.       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO           PIC 9(13).                       
           05  WS-ACCOUNT-NO-RED       REDEFINES WS-ACCOUNT-NO          
                                       PIC X(13).                       
           05  WS-MKT-TIER-RANKING     PIC 9(04).                       
           05  WS-MKT-TIER-RANKING-RED REDEFINES WS-MKT-TIER-RANKING    
                                       PIC X(04).                       
           05  WS-END-OF-FCSMKT01      PIC X(01) VALUE 'N'.             
               88  END-OF-FCSMKT01-FILE          VALUE 'Y'.             
               88  NOT-END-OF-FCSMKT01-FILE      VALUE 'N'.             
           05  WS-FMKT01-STATUS        PIC X(02).                       
               88  FMKT01-SUCCESSFUL             VALUE '00'.            
           05  WS-SKIP-RECORD          PIC X(01) VALUE 'N'.             
               88  SKIP-RECORD                   VALUE 'Y'.             
           05  WS-VALID-DATE-FLAG      PIC X(01) VALUE 'N'.             
               88  INVALID-DATE                  VALUE 'Y'.             
A02904     05  WS-INVALID-TIER-FLAG    PIC X(01) VALUE 'N'.             
A02904         88  INVALID-TIER-EXISTS           VALUE 'Y'.             
           05  WS-CRM-EXIST-FLAG       PIC X(01) VALUE 'N'.             
           05  WS-END-REC-PROCESSED    PIC X(01) VALUE 'N'.             
           05  WS-DATE-TRAN            PIC X(10).                       
           05  WS-TEST-DATE            PIC X(10) VALUE SPACES.          
           05  WS-VALID-DATE           PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-EFF-START-DT         PIC X(10) VALUE SPACES.          
           05  WS-EXEMPT-COMMENT       PIC X(50) VALUE SPACES.          
           05  WS-CHKP-NO              PIC 9(05) VALUE ZERO.            
           05  WS-LINE-COUNT           PIC S9(3) COMP-3 VALUE +0.       
           05  WS-PAGE-COUNT           PIC S9(5) COMP-3 VALUE +1.       
           05  WS-SKIP-LIMIT-DELINQ    PIC S9(4) USAGE COMP VALUE +0.   
           05  WS-SKIP-LIMIT-DELINQ-CD PIC X(17) VALUE                  
                                       'NBR-SKIP-PCSCA480'.             
      *                                                                         
       01  WS-PARM-DATA.                                                
           05  WS-LAST-RUN-TEXT          PIC X(14)                      
                                         VALUE 'LAST RUN DATE='.        
           05  WS-LAST-RUN-DATE          PIC X(10).                     
      *                                                                         
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-RESTART-MISC.                                             
C37790     05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +46.    
           05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
               88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.         
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
           05  WS-PROCESS-TYPE           PIC 9(01).                     
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 100.         
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID        PIC X(02)   VALUE '09'.        
               10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
               10  WS-CHKP-SEQ-NO        PIC 9(08)   VALUE ZERO.        
           05  WS-FMKT01-REC-CNTR        PIC S9(07)  VALUE ZERO COMP-3. 
           05  WS-INSERT-REC-CNTR        PIC S9(07)  VALUE ZERO COMP-3. 
           05  WS-SKIP-REC-CNTR          PIC S9(07)  VALUE ZERO COMP-3. 
COB305     05 WS-COUNT-UNSUCCESSFUL-ROWS        PIC S9(04) COMP-3 
COB305       VALUE 0.            
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
               88  WS-RERUN-COMPLETED                VALUE 'B'.         
               88  WS-RERUN-PENDING                  VALUE 'C'.         
           05  WS-RESTART-COMMON-DATE    PIC X(10).                     
           05  WS-RESTART-CHKP-SEQ-NO    PIC 9(08).                     
C37790     05  WS-RESTART-DREG-FLAG-VAL  PIC X(01).                     
           05  WS-RESTART-ACCT-NO        PIC 9(13) VALUE 0.             
           05  WS-RESTART-FCSMKT01-REC-CNTR                             
                                         PIC S9(07)  COMP-3 VALUE ZERO. 
           05  WS-RESTART-INSERT-REC-CNTR                               
                                         PIC S9(07)  COMP-3 VALUE ZERO. 
           05  WS-RESTART-SKIP-REC-CNTR                                 
                                         PIC S9(07)  COMP-3 VALUE ZERO. 
      *                                                                         
      ****************************************************************          
      *                  PCSCA4801 REPORT HEADERS                    *          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER1          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-1.                                         
               10  FILLER              PIC X(01)    VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT-MONTH         PIC X(02).                       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  P-RPT-DAY           PIC X(02).                       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  P-RPT-YEAR          PIC X(02).                       
               10  FILLER              PIC X(19)    VALUE SPACES.       
               10  P-RPT-HEAD1         PIC X(47)    VALUE               
                    'VALUE MODEL POSTING - ACCOUNTS WITH ERROR VALUE'.  
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT-RUN-TIME      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER2          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-HEADER-2.                                         
               10  FILLER              PIC X(14)    VALUE SPACES.       
               10  FILLER              PIC X(104)   VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT-PAGE-NO       PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-COLUMN-HEADER-1.                                  
               10  FILLER              PIC X(06)    VALUE SPACES.       
               10  FILLER              PIC X(13)    VALUE               
                                                    'RECORD NUMBER'.    
               10  FILLER              PIC X(09)    VALUE SPACES.       
               10  FILLER              PIC X(14)    VALUE               
                                                    'ACCOUNT NUMBER'.   
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'FIELD NAME'. 
               10  FILLER              PIC X(08)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                                    'ERROR VALUE'.      
               10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(13)    VALUE               
                                                    'ERROR MESSAGE'.    
               10  FILLER              PIC X(34)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **          WORKING STORAGE FOR REPORT DETAIL LINES           **          
      ****************************************************************          
      *                                                                         
       01  WS-RPT-DETAIL-LINES.                                         
           05  WS-RPT-DETAIL-LINE-1.                                    
               10  FILLER                 PIC X(10)    VALUE SPACES.    
               10  PRT-REC-NO             PIC Z(6)9.                    
               10  FILLER                 PIC X(12)    VALUE SPACES.    
               10  PRT-ACCOUNT            PIC X(13)    VALUE SPACES.    
               10  FILLER                 PIC X(04)    VALUE SPACES.    
               10  PRT-FIELD-NAME         PIC X(17)    VALUE SPACES.    
               10  FILLER                 PIC X(03)    VALUE SPACES.    
               10  PRT-ERROR-VALUE        PIC X(13)    VALUE SPACES.    
               10  FILLER                 PIC X(03)    VALUE SPACES.    
               10  PRT-ERROR-MSG          PIC X(25)    VALUE SPACES.    
               10  FILLER                 PIC X(25)    VALUE SPACES.    
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
      *                                                                         
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-TOTAL-LINE.                                               
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(35)    VALUE               
                     'TOTAL NUMBER OF ACCOUNTS SKIPPED = '.             
           05  P-RPT-SKIP-COUNT        PIC ZZ,ZZ,ZZ9.                   
           05  FILLER                  PIC X(78)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE            PIC S9(04) COMP VALUE 0.       
A02904     05   S-RETURN-CODE            PIC S9(04) COMP VALUE 0.       
           05  RS-RETURN-CODE-DISP       PIC +Z(04).                    
      *                                                                         
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
                                                                        
           COPY CWS0070B.                                               07940000
                                                                        
      ***************************************************************** 04691123
      * WORKING STORAGE COPYBOOK FOR GOOD PAYMENT CRITERIA CHECKING     04692023
      ***************************************************************** 04693023
           COPY CWS00329.                                               04694023
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00039                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MKT_TIER, DD                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CRM_MKT_TIER, IG                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTER                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_RESTART, RF                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM, G6                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ***************************************************************** 07613000
      * CSS_MNT_TRANS_HIST                                              07620000
      ***************************************************************** 07630000
           EXEC SQL                                                     07640000
              INCLUDE TBMNHIST                                          07650000
           END-EXEC.                                                    07660000
                                                                        
      ***************************************************************** 07680000
      * CSS_MT_TRN_HST_DET                                              07690000
      ***************************************************************** 07700000
           EXEC SQL                                                     07710000
              INCLUDE TBMNHDT                                           07720000
           END-EXEC.                                                    07730000
                                                                        
      ***************************************************************** 04770000
      *    CSS_CODE_VALUE,  UV                                          04780000
      ***************************************************************** 04790000
           EXEC SQL                                                     04800000
               INCLUDE TBCDVALU                                         04810000
           END-EXEC.                                                    04820000
                                                                        
      ***************************************************************** 04770000
      *    CRM_TIER_ACCT_TYPE, TT                                       04780000
      ***************************************************************** 04790000
           EXEC SQL                                                     04800000
               INCLUDE TBTIACTP                                         04810000
           END-EXEC.                                                    04820000
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      *                                                                 07740000
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA480 ENDS HERE  '.            
      *                                                                         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
      ******************************************************************PCS03300
      **                                                              **PCS03310
      **    0000-MAINLINE                                             **PCS03320
      **                                                              **PCS03330
      ******************************************************************PCS03340
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT         
                                                                        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT         
                                                                        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT         
                                                                        
           STOP RUN                                                     
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03300
      **                                                              **PCS03310
      **    0100-INITIALIZATION                                       **PCS03320
      **                                                              **PCS03330
      ******************************************************************PCS03340
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ      THRU 6235-EXIT       
                                                                        
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT       THRU 6253-EXIT       
                                                                        
           OPEN INPUT  FCSMKT01-FILE                                    
           IF FMKT01-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************************************'           
               DISPLAY '**    PCSCA480 PROCESSING ERROR   **'           
               DISPLAY '**   FCSMKT01-FILE WILL NOT OPEN  **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY '************************************'           
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           OPEN OUTPUT FCSPT33-FILE                                     
                                                                        
C37790     MOVE SPACES                       TO WS-SYSIPT               
C37790     MOVE SPACES                       TO WS-INPUT-DATA-BREAKDOWN 
C37790     MOVE WS-PGRMNAME                  TO WS-PROGRAM              
C37790     MOVE WS-PARM                      TO WS-COMMAND              
C37790     MOVE ZEROS                        TO WS-SEQUENCE             
C37790     MOVE WS-KEY-AREA                  TO E-FJC01-KEY             
C37790     PERFORM 7600-START-FCSJC01           THRU 7600-EXIT          
C37790     PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
C37790                UNTIL (LAST-RUN-DATE AND INPUT-ACTIVE)            
C37790                           OR  END-OF-SYSIPT                      
C37790                                                                  
C37790     EVALUATE TRUE                                                
C37790        WHEN END-OF-SYSIPT                                        
C37790           DISPLAY '********** PCSCA480 ABORT **************'     
C37790           DISPLAY '*       0100-INITIALIZATION            *'     
C37790           DISPLAY '*  NO ACTIVE LAST RUN DATE IN JOB_PARM *'     
C37790           DISPLAY '*     PROCESSING TERMINATED            *'     
C37790           DISPLAY '********** PCSCA480 ABORT **************'     
C37790           PERFORM 9900-ABEND             THRU  9900-EXIT         
C37790        WHEN WS-L-RUN-DATE-MM NOT NUMERIC OR                      
C37790             WS-L-RUN-DATE-DD NOT NUMERIC OR                      
C37790             WS-L-RUN-DATE-YY NOT NUMERIC                         
C37790           DISPLAY '********** PCSCA480 ABORT **************'     
C37790           DISPLAY '*       0100-INITIALIZATION            *'     
C37790           DISPLAY '* LAST RUN DATE HAS NON NUMERIC VALUE  *'     
C37790           DISPLAY '*                KEY = ' E-FJC01-KEY          
C37790           DISPLAY '*     PROCESSING TERMINATED            *'     
C37790           DISPLAY '********** PCSCA480 ABORT **************'     
C37790           PERFORM 9900-ABEND             THRU  9900-EXIT         
C37790        WHEN OTHER                                                
C37790           PERFORM 7611-CLOSE             THRU 7611-EXIT          
C37790           MOVE  G6-PARM-DATA          TO WS-PARM-DATA            
C37790     END-EVALUATE                                                 
C37790                                                                  
C37790     MOVE SPACES                       TO WS-SYSIPT               
C37790     MOVE SPACES                       TO WS-INPUT-DATA-BREAKDOWN 
                                                                        
           PERFORM 0200-CHECK-RESTART          THRU 0200-EXIT           
C37825     PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT           
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0300-PREPARE-RESTART     THRU 0300-EXIT           
              MOVE WS-RESTART-COMMON-DATE   TO WS-INPUT-DATE            
           ELSE                                                         
              PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT            
              IF COMMON-DATE-NEEDED                                     
                 PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT      
                 MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE            
              END-IF                                                    
              PERFORM 0500-PROCESS-BEGIN-REC  THRU 0500-EXIT            
           END-IF                                                       
                                                                        
      * GET THE SKIP LIMIT OF INVALID RECORDS                                   
           MOVE '01'                   TO C8-COMPANY-NO                 
           MOVE WS-SKIP-LIMIT-DELINQ-CD TO C8-DELINQ-CD                 
           PERFORM 7010-SELECT-DELINQ-VALUE    THRU 7010-EXIT           
           MOVE C8-DELINQ-VALUE        TO WS-SKIP-LIMIT-DELINQ          
      *                                                                         
           MOVE WS-INPUT-DATE(3:2)     TO P-RPT-YEAR                    
           MOVE WS-INPUT-DATE(6:2)     TO P-RPT-MONTH                   
           MOVE WS-INPUT-DATE(9:2)     TO P-RPT-DAY                     
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME                             
           MOVE WS-HH                  TO WS-RT-HH                      
           MOVE WS-MM                  TO WS-RT-MM                      
           MOVE WS-SS                  TO WS-RT-SS                      
           MOVE WS-RUN-TIME            TO P-RPT-RUN-TIME                
      *                                                                         
           PERFORM 8300-PRINT-HEADERS          THRU 8300-EXIT           
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *    CHECK FOR RESTART                                     *              
      ************************************************************              
       0200-CHECK-RESTART.                                              
      *                                                                         
           MOVE WS-PGRMNAME TO RF-NAME-PROGRAM                          
           MOVE 1 TO RF-PARTITION-NO                                    
                     WS-CHKP-PART-NO                                    
           MOVE 1 TO RF-DUP-CNTRL-NO                                    
           PERFORM 7100-SELECT-RESTART THRU 7100-EXIT                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA              
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-Y TO WS-IS-THIS-A-RESTART                      
              END-IF                                                    
           END-IF                                                       
           .                                                            
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 0300-PREPARE-RESTART.                                          *        
      ******************************************************************        
       0300-PREPARE-RESTART.                                            
      *                                                                         
           MOVE WS-RESTART-COMMON-DATE       TO WS-INPUT-DATE           
           MOVE WS-RESTART-INSERT-REC-CNTR   TO WS-INSERT-REC-CNTR      
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO          
           MOVE WS-RESTART-SKIP-REC-CNTR     TO WS-SKIP-REC-CNTR        
A02904     MOVE WS-RESTART-DREG-FLAG-VAL     TO WS-INVALID-TIER-FLAG    
                                                                        
           DISPLAY '*******************************************'        
           DISPLAY '*       THIS IS A RESTART OF PCSCA480     *'        
           DISPLAY '*******************************************'        
                                                                        
           PERFORM 0500-PROCESS-BEGIN-REC    THRU 0500-EXIT             
                                                                        
           PERFORM 7000-READ-FCSMKT01        THRU 7000-EXIT             
C37825       UNTIL (WS-FMKT01-REC-CNTR >                                
                    WS-RESTART-FCSMKT01-REC-CNTR)                       
C37825     MOVE ZEROES TO WS-RESTART-COMMIT-COUNTER                     
           .                                                            
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03730
      *                                                                *PCS03740
      *     0500-PROCESS-BEGIN-REC.                                    *PCS03750
      *                                                                *PCS03770
      ******************************************************************PCS03780
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSMKT01            THRU 7000-EXIT         
      *                                                                         
           IF E-FMKT01-KEY-BREC EQUAL SPACES                            
            AND WS-FMKT01-REC-CNTR = 1                                  
            AND NOT-END-OF-FCSMKT01-FILE                                
              SUBTRACT 1 FROM WS-FMKT01-REC-CNTR                        
              MOVE E-FMKT01-CREATE-DATE-BREC     TO WS-DATE-TRAN        
              PERFORM 0600-VALIDATE-CREATE-DATE  THRU 0600-EXIT         
              PERFORM 7000-READ-FCSMKT01         THRU 7000-EXIT         
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**       PCSCA480 PROCESSING ERROR        **'    
              DISPLAY '**             PARAGRAPH 0500             **'    
              DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'    
              DISPLAY '**         PROCESSING TERMINATED          **'    
              DISPLAY '**  KEY IS ' E-FMKT01-KEY-BREC                   
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF                                                       
                                                                        
           IF END-OF-FCSMKT01-FILE                                      
              PERFORM 3100-PROCESS-END-REC-ERROR THRU 3100-EXIT         
           END-IF                                                       
                                                                        
           IF E-FMKT01-KEY-EREC EQUAL SPACES                            
            AND WS-FMKT01-REC-CNTR >= 1                                 
             PERFORM 0700-PROCESS-END-REC        THRU 0700-EXIT         
             PERFORM 7000-READ-FCSMKT01          THRU 7000-EXIT         
             IF WS-END-REC-PROCESSED EQUAL WS-Y                         
                IF END-OF-FCSMKT01-FILE                                 
                   CONTINUE                                             
                ELSE                                                    
                    DISPLAY '*****************************************' 
                    DISPLAY '**       PCSCA480 PROCESSING ERROR     **' 
                    DISPLAY '**              PARAGRAPH 0500         **' 
                    DISPLAY '**  LAST RECORD IS NOT A CONTROL RECORD**' 
                    DISPLAY '**         PROCESSING TERMINATED       **' 
                    DISPLAY '**  KEY IS ' E-FMKT01-KEY-EREC             
                    DISPLAY '*****************************************' 
                    PERFORM 9900-ABEND           THRU 9900-EXIT         
                END-IF                                                  
             END-IF                                                     
           END-IF                                                       
           .                                                            
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 0600-VALIDATE-CREATE-DATE                                    *          
      *                                                              *          
      * THE FOLLOWING CODE COMPARES CREATE DATE ON EACH BEGINNING   **          
      * CNTL REC TO RUN DATE FROM JOB CONTROL FILE:                 **          
      *                                                              *          
      ****************************************************************          
       0600-VALIDATE-CREATE-DATE.                                       
      *                                                                         
           IF E-FMKT01-CREATE-DATE-BREC EQUAL WS-LAST-RUN-DATE          
              MOVE 2                   TO RETURN-CODE                   
                                                                        
              CLOSE FCSMKT01-FILE                                       
              CLOSE FCSPT33-FILE                                        
                                                                        
              DISPLAY '**************PCSCA480*****************'         
              DISPLAY '**** VM FILE HEADER CONTAINS SAME *****'         
              DISPLAY '**** DATE OF LAST-RUN-DATE = ' WS-LAST-RUN-DATE  
              DISPLAY '**** AN E-MAIL WILL BE SEND TO USERS **'         
              DISPLAY '**** INDICATING ERROR                **'         
              DISPLAY '**************PCSCA480*****************'         
                                                                        
              STOP RUN                                                  
           END-IF                                                       
      *                                                                         
           IF OVERRIDE-DATE-LOADED                                      
              IF E-FMKT01-CREATE-DATE-BREC EQUAL WS-INPUT-DATE          
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '******************************************'  
                  DISPLAY '**   COMMON DATE/OVERRIDING RUN DATE    **'  
                  DISPLAY '** DOES NOT MATCH CREATE DATE OF FMKT01 **'  
                  DISPLAY '**   WORK FILE BEGINNING CONTROL REC    **'  
                  DISPLAY '******************************************'  
                  DISPLAY '** COMMON DATE/OVERRIDING RUN DATE = '       
                          WS-INPUT-DATE                                 
                  DISPLAY '** WORK FILE CREATE DATE = '                 
                          E-FMKT01-CREATE-DATE-BREC                     
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
              END-IF                                                    
           END-IF                                                       
           .                                                            
       0600-EXIT.                                                       
           EXIT.                                                        
C37825*                                                                         
C37825*****************************************************************         
C37825*0605-VALIDATE-RESTART-REQ                                      *         
C37825*****************************************************************         
C37825*                                                                         
C37825 COPY CPD00030.                                                           
      *                                                                         
      ******************************************************************PCS03730
      *                                                                *PCS03740
      *     0700-PROCESS-END-REC                                       *PCS03750
      *                                                                *PCS03770
      ******************************************************************PCS03780
       0700-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FMKT01-REC-CNTR                           
                                                                        
           IF WS-FMKT01-REC-CNTR EQUAL E-FMKT01-RECORD-COUNT-EREC       
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**********************************************' 
               DISPLAY '**         PCSCA480 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**     CONTROL REC COUNT = '                    
                                     E-FMKT01-RECORD-COUNT-EREC         
               DISPLAY '**     ACTUAL  REC COUNT = ' WS-FMKT01-REC-CNTR 
               DISPLAY '**           PROCESSING TERMINATED          **' 
               DISPLAY '**********************************************' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
                                                                        
           MOVE WS-Y TO WS-END-REC-PROCESSED                            
                                                                        
           IF E-FMKT01-RECORD-COUNT-EREC EQUAL  ZERO                    
               DISPLAY '**********************************************' 
               DISPLAY '**         PCSCA480 PROCESSING              **' 
               DISPLAY '**      FILE CONTAINED NO RECORDS           **' 
               DISPLAY '**********************************************' 
           END-IF                                                       
           .                                                            
       0700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-PROCESS-RECORDS          THRU 1100-EXIT         
             UNTIL END-OF-FCSMKT01-FILE                                 
                                                                        
           IF WS-PAGE-COUNT = 1 AND WS-LINE-COUNT < 7                   
                                                                        
              WRITE PRT33-RECORD FROM WS-NO-DATA-LINE                   
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT33-RECORD FROM WS-END-DATA-LINE                  
                    AFTER ADVANCING 1 LINE                              
           ELSE                                                         
              WRITE PRT33-RECORD FROM WS-BLANK-LINE                     
                    AFTER ADVANCING 1 LINE                              
              MOVE WS-SKIP-REC-CNTR      TO P-RPT-SKIP-COUNT            
              WRITE PRT33-RECORD FROM WS-TOTAL-LINE                     
                    AFTER ADVANCING 1 LINE                              
              WRITE PRT33-RECORD FROM WS-END-DATA-LINE                  
                    AFTER ADVANCING 1 LINE                              
           END-IF                                                       
                                                                        
C37825******************************************************************        
C37825* THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO     *        
C37825* INDICATE A SUCCESSFUL COMPLETION:                              *        
C37825******************************************************************        
C37825     PERFORM 1800-PREPARE-PRECOMMIT        THRU 1800-EXIT         
C37825                                                                  
C37825     MOVE SPACES                   TO WS-RESTART-JOB-COMPLETE     
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                  TO WS-RESTART-JOB-STATUS       
              DISPLAY 'PCSCA480 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                  TO WS-RESTART-JOB-STATUS       
              DISPLAY 'PCSCA480 COMPLETED SUCCESSFULLY'                 
           END-IF                                                       
                                                                        
C37825     PERFORM 8888-COMMIT                   THRU 8888-EXIT         
                                                                        
C37825     IF WS-RESTART-REQ EQUAL WS-Y                                 
C37825        PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT        
C37825     END-IF                                                       
                                                                        
           PERFORM 5000-UPDATE-PARM-DATA         THRU 5000-EXIT         
                                                                        
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 1100-PROCESS-RECORDS                                           *        
      ******************************************************************        
       1100-PROCESS-RECORDS.                                            
                                                                        
           MOVE 'N'                            TO WS-SKIP-RECORD        
                                                                        
           IF WS-SKIP-REC-CNTR > WS-SKIP-LIMIT-DELINQ                   
              DISPLAY '**************PCSCA480*****************'         
              DISPLAY '**** VM FILE EXCEEDS THE LIMIT OF *****'         
              DISPLAY '**** INVALID RECORDS = ' WS-SKIP-LIMIT-DELINQ    
              DISPLAY '**** FILE PROCESSING TERMINATED...*****'         
              DISPLAY '**************PCSCA480*****************'         
C37825        PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
A02904     PERFORM 2100-VALIDATE-DATA          THRU 2100-EXIT           
A02904                                                                  
A02904     IF NOT SKIP-RECORD                                           
C37790        PERFORM 2000-VALUE-MODEL-CHECK   THRU 2000-EXIT           
A02904     END-IF                                                       
                                                                        
           IF SKIP-RECORD                                               
              ADD 1                              TO WS-SKIP-REC-CNTR    
           ELSE                                                         
              PERFORM 6000-LOAD-CIS-DATA       THRU 6000-EXIT           
              MOVE 'N'                         TO WS-CRM-EXIST-FLAG     
              PERFORM 7300-CHECK-EXISTENCE     THRU 7300-EXIT           
              IF WS-CRM-EXIST-FLAG = 'Y'                                
                 PERFORM 6100-LOAD-CIS-DATA    THRU 6100-EXIT           
                 PERFORM 8100-INSERT-CIS-DATA  THRU 8100-EXIT           
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 6630-INSERT-TRANS-HIST-ROW                  
                       THRU 6630-EXIT                                   
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 ADD 1                         TO WS-SKIP-REC-CNTR      
                 MOVE 'CRM_MKT_TIER'           TO PRT-FIELD-NAME        
                 MOVE 'NO ROW IN PARENT TABLE' TO PRT-ERROR-MSG         
                 MOVE E-FMKT01-TIER-CUST-STAT-CD                        
                                               TO PRT-ERROR-VALUE(1:1)  
                 MOVE E-FMKT01-TIER-ACCT-TYPE-CD                        
                                               TO PRT-ERROR-VALUE(2:1)  
                 MOVE E-FMKT01-MKT-TIER-RANKING                         
                                               TO PRT-ERROR-VALUE(3:4)  
                 PERFORM 8200-WRITE-REPORT     THRU 8200-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-RESTART-COMMIT-COUNTER >= WS-CHKP-LUW-LIMIT OR         
              WS-RESTART-COMMIT-COUNTER >= WS-CHKP-UPD-LIMIT            
C37825        PERFORM 1800-PREPARE-PRECOMMIT     THRU 1800-EXIT         
              PERFORM 8888-COMMIT THRU 8888-EXIT                        
              MOVE ZEROES TO WS-RESTART-COMMIT-COUNTER                  
           END-IF                                                       
                                                                        
           PERFORM 7000-READ-FCSMKT01          THRU 7000-EXIT           
      *                                                                         
           IF WS-END-REC-PROCESSED EQUAL WS-Y                           
              PERFORM 3100-PROCESS-END-REC-ERROR THRU 3100-EXIT         
           ELSE                                                         
              IF E-FMKT01-KEY-EREC EQUAL SPACES                         
                AND WS-FMKT01-REC-CNTR >= 1                             
                 PERFORM 0700-PROCESS-END-REC          THRU 0700-EXIT   
                 PERFORM 7000-READ-FCSMKT01            THRU 7000-EXIT   
                 GO TO 1100-EXIT                                        
              ELSE                                                      
                 IF END-OF-FCSMKT01-FILE                                
                    PERFORM 3100-PROCESS-END-REC-ERROR THRU 3100-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1800-PREPARE-PRECOMMIT.                                        *        
      ******************************************************************        
       1800-PREPARE-PRECOMMIT.                                          
                                                                        
            MOVE 1                           TO WS-RESTART-PROCESS-TYPE 
            MOVE WS-C                        TO WS-RESTART-JOB-STATUS   
            MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE  
            ADD  1                           TO WS-CHKP-SEQ-NO          
A02904      MOVE WS-INVALID-TIER-FLAG        TO WS-RESTART-DREG-FLAG-VAL
            MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO  
            MOVE WS-ACCOUNT-NO               TO WS-RESTART-ACCT-NO      
            MOVE WS-FMKT01-REC-CNTR          TO                         
                                          WS-RESTART-FCSMKT01-REC-CNTR  
            MOVE WS-INSERT-REC-CNTR          TO                         
                                          WS-RESTART-INSERT-REC-CNTR    
            MOVE WS-SKIP-REC-CNTR            TO                         
                                          WS-RESTART-SKIP-REC-CNTR      
           .                                                            
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C37790******************************************************************        
C37790*                                                                *        
C37790* 2000-VALUE-MODEL-CHECK.                                        *        
C37790******************************************************************        
C37790 2000-VALUE-MODEL-CHECK.                                          
C37790*                                                                         
C37790     MOVE E-FMKT01-ACCOUNT-NO              TO WS-ACCOUNT-NO-RED   
C37790                                              PRT-ACCOUNT         
C37790     MOVE WS-ACCOUNT-NO                    TO DD-ACCOUNT-NO       
C37790                                                                  
A02904     MOVE SPACES                           TO DD-TIER-ACCT-TYPE-CD
C37790     PERFORM 7020-SELECT-TIER-ACCT-TYPE-CD THRU 7020-EXIT         
C37790                                                                  
A02904     IF DD-TIER-ACCT-TYPE-CD NOT = E-FMKT01-TIER-ACCT-TYPE-CD     
C37790        SET SKIP-RECORD                    TO TRUE                
C37790        MOVE WS-FMKT01-REC-CNTR            TO PRT-REC-NO          
C37790        MOVE SPACES                        TO PRT-FIELD-NAME      
C37790                                              PRT-ERROR-VALUE     
A02904        MOVE 'Invalid Tier ranking'        TO PRT-ERROR-MSG       
A02904        SET INVALID-TIER-EXISTS            TO TRUE                
C37790        PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
C37790     END-IF                                                       
C37790*                                                                         
C37790     .                                                            
C37790 2000-EXIT.                                                       
C37790     EXIT.                                                        
C37790*                                                                         
      ******************************************************************        
      *                                                                *        
      * 2100-VALIDATE-DATA.                                            *        
      ******************************************************************        
       2100-VALIDATE-DATA.                                              
      *                                                                         
      * CHECK IF VALID ACCOUNT NO                                               
           MOVE E-FMKT01-ACCOUNT-NO              TO WS-ACCOUNT-NO-RED   
                                                    PRT-ACCOUNT         
           MOVE WS-FMKT01-REC-CNTR               TO PRT-REC-NO          
           IF WS-ACCOUNT-NO IS NUMERIC                                  
              CONTINUE                                                  
           ELSE                                                         
              SET SKIP-RECORD                    TO TRUE                
              MOVE 'ACCOUNT-NO '                 TO PRT-FIELD-NAME      
              MOVE 'INVALID ACCOUNT NUMBER'      TO PRT-ERROR-MSG       
              MOVE WS-ACCOUNT-NO                 TO PRT-ERROR-VALUE     
              PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
           END-IF                                                       
                                                                        
A02904* CHECK TIER-ACCT-TYPE-CD                                                 
A02904     IF E-FMKT01-TIER-ACCT-TYPE-CD > SPACE                        
A02904       AND E-FMKT01-TIER-ACCT-TYPE-CD IS NOT NUMERIC              
A02904        CONTINUE                                                  
A02904     ELSE                                                         
A02904        SET SKIP-RECORD                    TO TRUE                
A02904        MOVE 'TIER-ACCT-TYPE-CD'           TO PRT-FIELD-NAME      
A02904        MOVE 'INVALID TIER ACCT TYPE CD'   TO PRT-ERROR-MSG       
A02904        MOVE E-FMKT01-TIER-ACCT-TYPE-CD    TO PRT-ERROR-VALUE     
A02904        PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
A02904     END-IF                                                       
A02904                                                                  
      * CHECK IF VALID MKT-TIER-RANKING                                         
           MOVE E-FMKT01-MKT-TIER-RANKING        TO                     
                                  WS-MKT-TIER-RANKING-RED               
           IF WS-MKT-TIER-RANKING IS NUMERIC                            
              CONTINUE                                                  
           ELSE                                                         
              SET SKIP-RECORD                    TO TRUE                
              MOVE 'MKT-TIER-RANKING'            TO PRT-FIELD-NAME      
              MOVE 'INVALID MKT TIER RANK '      TO PRT-ERROR-MSG       
              MOVE WS-MKT-TIER-RANKING           TO PRT-ERROR-VALUE     
              PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
           END-IF                                                       
                                                                        
      * CHECK IF VALID MKT-TIER-START-DT                                        
           MOVE 'N'                              TO WS-VALID-DATE-FLAG  
           MOVE E-FMKT01-MKT-TIER-START-DT       TO WS-TEST-DATE        
           PERFORM 7500-VALIDATE-DATE            THRU 7500-EXIT         
           IF INVALID-DATE                                              
              SET SKIP-RECORD                    TO TRUE                
              MOVE 'MKT-TIER-START-DATE   '      TO PRT-FIELD-NAME      
              MOVE 'INVALID MKT TIER DATE '      TO PRT-ERROR-MSG       
              MOVE E-FMKT01-MKT-TIER-START-DT    TO PRT-ERROR-VALUE     
              PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
           END-IF                                                       
                                                                        
      * CHECK IF VALID EFF-START-DT                                             
           MOVE 'N'                              TO WS-VALID-DATE-FLAG  
           MOVE E-FMKT01-EFF-START-DT            TO WS-TEST-DATE        
           PERFORM 7500-VALIDATE-DATE            THRU 7500-EXIT         
           IF INVALID-DATE                                              
              SET SKIP-RECORD                    TO TRUE                
              MOVE 'EFF-START-DT  '              TO PRT-FIELD-NAME      
              MOVE 'INVALID EFF START DATE '     TO PRT-ERROR-MSG       
              MOVE E-FMKT01-EFF-START-DT         TO PRT-ERROR-VALUE     
              PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
           END-IF                                                       
                                                                        
      * CHECK IF VALID LAST-EVALUATED-DT                                        
           MOVE 'N'                              TO WS-VALID-DATE-FLAG  
           MOVE E-FMKT01-LAST-EVALUATED-DT       TO WS-TEST-DATE        
           PERFORM 7500-VALIDATE-DATE            THRU 7500-EXIT         
           IF INVALID-DATE                                              
              SET SKIP-RECORD                    TO TRUE                
              MOVE 'LAST-EVALUATED-DT'           TO PRT-FIELD-NAME      
              MOVE 'INVALID LAST EVAL DATE'      TO PRT-ERROR-MSG       
              MOVE E-FMKT01-LAST-EVALUATED-DT    TO PRT-ERROR-VALUE     
              PERFORM 8200-WRITE-REPORT          THRU 8200-EXIT         
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *                                                                         
      *   3100-PROCESS-END-REC-ERROR                                            
      *                                                                         
      **************************************************************            
       3100-PROCESS-END-REC-ERROR.                                      
                                                                        
            DISPLAY '*****************************************'         
            DISPLAY '**      PCSCA480 PROCESSING ERROR      **'         
            DISPLAY '**            PARAGRAPH 3100           **'         
            DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'         
            DISPLAY '**        PROCESSING TERMINATED        **'         
            DISPLAY '** KEY IS ' E-FMKT01-KEY-EREC                      
            DISPLAY '*****************************************'         
            PERFORM 9900-ABEND                   THRU 9900-EXIT         
           .                                                            
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 5000-UPDATE-PARM-DATA.                                        *         
      *****************************************************************         
       5000-UPDATE-PARM-DATA.                                           
                                                                        
           INITIALIZE G6-PARM-DATA.                                     
           MOVE WS-INPUT-DATE            TO WS-LAST-RUN-DATE.           
           MOVE WS-PARM-DATA             TO G6-PARM-DATA.               
                                                                        
           MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.            
           MOVE 'PARM'                   TO G6-CMND-CODE.               
           MOVE +10                      TO G6-SEQ-NO.                  
           MOVE '01'                     TO G6-COMPANY-NO.              
                                                                        
           PERFORM 8110-UPDATE-LAST-RUN-DATE   THRU 8110-EXIT.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-LOAD-CIS-DATA.                                            *        
A02904* LOAD TO CHECK EXISTENCE OF ROW IN CRM_MKT_TIER                 *        
      ******************************************************************        
       6000-LOAD-CIS-DATA.                                              
      *                                                                         
           MOVE E-FMKT01-TIER-CUST-STAT-CD  TO IG-TIER-CUST-STAT-CD     
           MOVE E-FMKT01-TIER-ACCT-TYPE-CD  TO IG-TIER-ACCT-TYPE-CD     
           MOVE WS-MKT-TIER-RANKING         TO IG-MKT-TIER-RANKING      
           MOVE E-FMKT01-MKT-TIER-START-DT  TO IG-MKT-TIER-START-DT     
           MOVE E-FMKT01-COMPANY-NO         TO IG-COMPANY-NO            
           .                                                            
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6100-LOAD-CIS-DATA.                                            *        
      * LOAD TO INSERT ROW IN TO  CSS_ACCT_MKT_TIER                    *        
      ******************************************************************        
       6100-LOAD-CIS-DATA.                                              
      *                                                                         
           PERFORM 7050-SELECT-TIMESTAMP    THRU 7050-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO DD-CREATED-TS            
                                               DD-LAST-UPDATE-TS        
           MOVE 'SYSTEM'                    TO DD-LAST-UPDATE-USERID    
           MOVE 'VM'                        TO DD-TIER-SOURCE-CD        
           MOVE 0                           TO DD-ADJ-TIER-SEQ-NO       
                                                                        
           MOVE WS-ACCOUNT-NO               TO DD-ACCOUNT-NO            
           MOVE E-FMKT01-TIER-CUST-STAT-CD  TO DD-TIER-CUST-STAT-CD     
           MOVE E-FMKT01-TIER-ACCT-TYPE-CD  TO DD-TIER-ACCT-TYPE-CD     
           MOVE WS-MKT-TIER-RANKING         TO DD-MKT-TIER-RANKING      
           MOVE E-FMKT01-MKT-TIER-START-DT  TO DD-MKT-TIER-START-DT     
           MOVE E-FMKT01-COMPANY-NO         TO DD-COMPANY-NO            
           MOVE E-FMKT01-EFF-START-DT       TO DD-EFF-START-DT          
           MOVE E-FMKT01-LAST-EVALUATED-DT  TO DD-LAST-EVALUATED-DT     
           .                                                            
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 6630-INSERT-TRANS-HIST-ROW.                                    *        
      ******************************************************************        
       6630-INSERT-TRANS-HIST-ROW.                                      
                                                                        
           PERFORM 7050-SELECT-TIMESTAMP THRU 7050-EXIT                 
           MOVE 'VALUE MODEL POSTING'     TO WS-EXEMPT-COMMENT          
                                                                        
      ** DATA FOR CSS_MNT_TRANS_HIST                                    17730000
           MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO       
           MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS              
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE          
           MOVE SPACES                    TO MH-RESP-AREA-ID            
           MOVE DD-ACCOUNT-NO             TO MH-ACCOUNT-NO              
           MOVE +0                        TO MH-CUSTOMER-NO             
           MOVE +0                        TO MH-PREMISE-NO              
           MOVE 'SYSTEM'                  TO MH-USER-ID                 
           MOVE +19                       TO MH-TRAN-COMMENT-LEN        
           MOVE WS-EXEMPT-COMMENT         TO MH-TRAN-COMMENT-TEXT       
           MOVE 'PCSCA480'                TO MH-APPL-PROGRAM-ID         
           MOVE +0                        TO MH-ENTITY-KEY-DESC-LEN     
           MOVE SPACES                    TO MH-ENTITY-KEY-DESC-TEXT    
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                    17564000
           MOVE DD-TIER-CUST-STAT-CD      TO IG-TIER-CUST-STAT-CD       
           MOVE DD-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD       
           MOVE DD-MKT-TIER-RANKING       TO IG-MKT-TIER-RANKING        
           MOVE '01'                      TO IG-COMPANY-NO              
           MOVE DD-MKT-TIER-START-DT      TO IG-MKT-TIER-START-DT       
                                                                        
           PERFORM 7310-SEL-MKT-TIER-DESC   THRU 7310-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 1                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER RANKING'            TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
                                                                        
           MOVE IG-MKT-TIER-DESC          TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-CUST-STAT-CD      TO UV-CODE-VALUE-TEXT         
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                          TO UV-CODE-VALUE-LEN          
           MOVE 'TIER_CUST_STAT_CD'       TO UV-COLUMN-NA-TEXT          
           MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
                                          TO UV-COLUMN-NA-LEN           
           MOVE 'CRM_MKT_TIER'            TO UV-TABLE-NA-TEXT           
           MOVE LENGTH OF UV-TABLE-NA-TEXT                              
                                          TO UV-TABLE-NA-LEN            
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           MOVE '01'                      TO UV-COMPANY-NO              
           PERFORM 7320-SEL-CODE-VALUE-DESC THRU 7320-EXIT              
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 2                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER CUST STAT CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE DD-TIER-ACCT-TYPE-CD      TO TT-TIER-ACCT-TYPE-CD       
           PERFORM 7330-SEL-TIER-ACCT-TYPE-CD THRU 7330-EXIT            
                                                                        
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 3                         TO MI-TRAN-APPL-NO            
           MOVE 'TIER ACCT TYPE CD'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE TT-TIER-ACCT-DESC         TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           MOVE WS-CURRENT-TIMESTAMP      TO MI-TRANS-HIST-SEQ-NO       
           MOVE 4                         TO MI-TRAN-APPL-NO            
           MOVE 'MKT TIER START DT'       TO MI-COLUMN-DESC             
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE '** INSERTED **'          TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE DD-MKT-TIER-START-DT      TO MI-CHG-COLUMN-VALUE-TEXT   
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
      *                                                                 17600000
           .                                                            
       6630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6235-GET-FJC01-RESTART-REQ.                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  6240-GET-FCA00-COMMON-DATE                                    *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6253-GET-FJC01-CHKP-LIMIT.                                     *        
      ******************************************************************        
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
                                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-READ-FCSMKT01.                                            *        
      ******************************************************************        
       7000-READ-FCSMKT01.                                              
                                                                        
           READ FCSMKT01-FILE                                           
               AT END                                                   
                   MOVE WS-Y TO WS-END-OF-FCSMKT01                      
                   GO TO 7000-EXIT.                                     
      *                                                                         
           IF FMKT01-SUCCESSFUL                                         
              ADD 1 TO WS-FMKT01-REC-CNTR                               
                       WS-RESTART-COMMIT-COUNTER                        
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**     PCSCA480 PROCESSING ERROR          **'    
              DISPLAY '**   7000-ERROR ON FMKT01 READ.   **********'    
              DISPLAY ' FILE STATUS IS  '   WS-FMKT01-STATUS            
              DISPLAY '****** PROCESSING TERMINATED       *********'    
              MOVE 12                         TO RETURN-CODE            
              PERFORM 9000-TERMINATE          THRU 9000-EXIT            
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7010-SELECT-DELINQ-VALUE                                      * 03832900
      ***************************************************************** 03833000
       7010-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
C37825                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD    = :C8-DELINQ-CD                               
MFA-TR*          AND COMPANY_NO   = :C8-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSCA480  ABORT **************'      
               DISPLAY '* 7010-SELECT-DELINQ-VALUE              *'      
               DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '* DELINQ_CD  : ' C8-DELINQ-CD                   
               DISPLAY '* COMPANY_NO : ' C8-COMPANY-NO                  
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA480  ABORT **************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
      *                                                                         
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C37790***************************************************************** 03832700
C37790* 7020-SELECT-TIER-ACCT-TYPE-CD                                 * 03832900
C37790***************************************************************** 03833000
C37790 7020-SELECT-TIER-ACCT-TYPE-CD.                                   
C37790                                                                  
C37790     EXEC SQL                                                     
C37790        SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                               
C37790          INTO :DD-TIER-ACCT-TYPE-CD                              
C37790          FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                 
C37790         WHERE DD.ACCOUNT_NO       = :DD-ACCOUNT-NO               
C37790         ORDER BY EFF_START_DT DESC                               
C37790                                              
C37790                                                           
C37790     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DD.TIER_ACCT_TYPE_CD                                       
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*         FROM CSS_ACCT_MKT_TIER DD                                       
MFA-TR*        WHERE DD.ACCOUNT_NO       = :DD-ACCOUNT-NO                       
MFA-TR*        ORDER BY EFF_START_DT DESC                                       
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37790                                                                  
C37790     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C37790                                                                  
C37790     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C37790        NEXT SENTENCE                                             
C37790     ELSE                                                         
C37790        DISPLAY '********** PCSCA480  ABORT **************'       
C37790        DISPLAY '* 7020-SELECT-TIER-ACCT-TYPE-CD         *'       
C37790        DISPLAY '* SQLCODE IS   ' WS-ACTIVE-RETURN-CODE           
C37790        DISPLAY '* ACCOUNT_NO : ' DD-ACCOUNT-NO                   
C37790        DISPLAY '* PROGRAM ABORTING...                   *'       
C37790        DISPLAY '********** PCSCA480  ABORT **************'       
C37790        PERFORM 9900-ABEND THRU 9900-EXIT                         
C37790     END-IF                                                       
C37790     .                                                            
C37790 7020-EXIT.                                                       
C37790     EXIT.                                                        
C37790*                                                                         
      ******************************************************************        
      * SELECT CURRENT TIMESTAMP                                       *        
      ******************************************************************        
       7050-SELECT-TIMESTAMP.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA480  ABORT **************'      
               DISPLAY '* 7050-SELECT-TIMESTAMP                 *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA480  ABORT **************'      
               PERFORM 9900-ABEND          THRU 9900-EXIT               
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **                                                              **        
      **         7100-SELECT-RESTART                                  **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-RESTART.                                             
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH                           
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
C37825                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                       
MFA-TR*               PARTITION_NO = :RF-PARTITION-NO AND                       
MFA-TR*               DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**   ERROR ON 7100-SELECT-RESTART   **'          
              DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PROCESSING TERMINATED      **'          
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * CPD00038                                                   *            
      * 7600-START-FCSJC01                                         *            
      * 7610-READ-FCSJC01                                          *            
      * 7611-CLOSE                                                 *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      * CPD00039   S T A R T   A N D   R E A D   F C S C A 0 0     *            
      * 7620-START-FCSCA00                                         *            
      * 7621-READ-FCSCA00                                          *            
      * 7622-CLOSE-CA00-CSR                                        *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7300-CHECK-EXISTENCE.                                          *        
      ******************************************************************        
       7300-CHECK-EXISTENCE.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-CRM-EXIST-FLAG                                
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD = :IG-TIER-CUST-STAT-CD      
                  AND IG.TIER_ACCT_TYPE_CD = :IG-TIER-ACCT-TYPE-CD      
                  AND IG.MKT_TIER_RANKING  = :IG-MKT-TIER-RANKING       
                  AND IG.MKT_TIER_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )      
                  AND IG.COMPANY_NO        = :IG-COMPANY-NO             
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CRM-EXIST-FLAG                                        
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD = :IG-TIER-CUST-STAT-CD              
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD = :IG-TIER-ACCT-TYPE-CD              
MFA-TR*           AND IG.MKT_TIER_RANKING  = :IG-MKT-TIER-RANKING               
MFA-TR*           AND IG.MKT_TIER_START_DT = :IG-MKT-TIER-START-DT              
MFA-TR*           AND IG.COMPANY_NO        = :IG-COMPANY-NO                     
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*        7300-CHECK-EXISTENCE          *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TIER_CUST_STAT_CD : ' IG-TIER-CUST-STAT-CD     
              DISPLAY '* TIER_ACCT_TYPE_CD : ' IG-TIER-ACCT-TYPE-CD     
              DISPLAY '* MKT_TIER_RANKING  : ' IG-MKT-TIER-RANKING      
              DISPLAY '* MKT_TIER_START_DT : ' IG-MKT-TIER-START-DT     
              DISPLAY '* COMPANY_NO        : ' IG-COMPANY-NO            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7310-SEL-MKT-TIER-DESC.                                        *        
      ******************************************************************        
       7310-SEL-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT IG.MKT_TIER_DESC                                  
                 INTO :IG-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                  AND IG.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )     
C37825                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_DESC                                          
MFA-TR*          INTO :IG-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           AND IG.MKT_TIER_START_DT  = :IG-MKT-TIER-START-DT             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*        7310-SEL-MKT-TIER-DESC        *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TIER_CUST_STAT_CD : ' IG-TIER-CUST-STAT-CD     
              DISPLAY '* TIER_ACCT_TYPE_CD : ' IG-TIER-ACCT-TYPE-CD     
              DISPLAY '* MKT_TIER_RANKING  : ' IG-MKT-TIER-RANKING      
              DISPLAY '* MKT_TIER_START_DT : ' IG-MKT-TIER-START-DT     
              DISPLAY '* COMPANY_NO        : ' IG-COMPANY-NO            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-SEL-CODE-VALUE-DESC                                       *        
      ******************************************************************        
       7320-SEL-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE CODE_VALUE     = :UV-CODE-VALUE                     
                AND COLUMN_NA      = :UV-COLUMN-NA                      
                AND COMPANY_NO     = :UV-COMPANY-NO                     
                AND PROGRAM_ID     = :UV-PROGRAM-ID                     
                AND TABLE_NA       = :UV-TABLE-NA                       
C37825                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE CODE_VALUE     = :UV-CODE-VALUE                             
MFA-TR*         AND COLUMN_NA      = :UV-COLUMN-NA                              
MFA-TR*         AND COMPANY_NO     = :UV-COMPANY-NO                             
MFA-TR*         AND PROGRAM_ID     = :UV-PROGRAM-ID                             
MFA-TR*         AND TABLE_NA       = :UV-TABLE-NA                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*        7320-SEL-CODE-VALUE-DESC      *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* CODE_VALUE        : ' UV-CODE-VALUE            
              DISPLAY '* COLUMN_NA         : ' UV-COLUMN-NA             
              DISPLAY '* COMPANY_NO        : ' UV-COMPANY-NO            
              DISPLAY '* PROGRAM_ID        : ' UV-PROGRAM-ID            
              DISPLAY '* TABLE_NA          : ' UV-TABLE-NA              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-SEL-TIER-ACCT-TYPE-CD                                     *        
      ******************************************************************        
       7330-SEL-TIER-ACCT-TYPE-CD.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TT.TIER_ACCT_DESC                                  
               INTO :TT-TIER-ACCT-DESC                                  
               FROM CRM_TIER_ACCT_TYPE TT WITH(READUNCOMMITTED)                 
              WHERE TT.COMPANY_NO        = '01'                         
                AND TT.TIER_ACCT_TYPE_CD = :TT-TIER-ACCT-TYPE-CD        
C37825                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TT.TIER_ACCT_DESC                                          
MFA-TR*        INTO :TT-TIER-ACCT-DESC                                          
MFA-TR*        FROM CRM_TIER_ACCT_TYPE TT                                       
MFA-TR*       WHERE TT.COMPANY_NO        = '01'                                 
MFA-TR*         AND TT.TIER_ACCT_TYPE_CD = :TT-TIER-ACCT-TYPE-CD                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*      7330-SEL-TIER-ACCT-TYPE-CD      *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* TIER_ACCT_TYPE_CD : ' TT-TIER-ACCT-TYPE-CD     
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **      7500-VALIDATE-DATE                                    **          
      **           CHECK IF VALID DATE                              **          
      ****************************************************************          
                                                                        
       7500-VALIDATE-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              IIF(TRY_CONVERT(DATE, :WS-TEST-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEST-DATE
              ) <> 0) OR (LEN(:WS-TEST-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEST-DATE
              ), CONVERT(DATE, :WS-TEST-DATE) )
            INTO
              :WS-VALID-DATE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-VALID-DATE  = DATE(:WS-TEST-DATE)                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              SET INVALID-DATE      TO TRUE                             
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-CIS-DATA.                                          *        
      ******************************************************************        
       8100-INSERT-CIS-DATA.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_MKT_TIER                            
                      ( ACCOUNT_NO                                      
                       ,TIER_CUST_STAT_CD                               
                       ,TIER_ACCT_TYPE_CD                               
                       ,MKT_TIER_RANKING                                
                       ,MKT_TIER_START_DT                               
                       ,COMPANY_NO                                      
                       ,CREATED_TS                                      
                       ,LAST_UPDATE_USERID                              
                       ,EFF_START_DT                                    
                       ,LAST_UPDATE_TS                                  
                       ,LAST_EVALUATED_DT                               
                       ,TIER_SOURCE_CD                                  
                       ,ADJ_TIER_SEQ_NO)                                
               VALUES ( :DD-ACCOUNT-NO                                  
                       ,:DD-TIER-CUST-STAT-CD                           
                       ,:DD-TIER-ACCT-TYPE-CD                           
                       ,:DD-MKT-TIER-RANKING                            
                       ,IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )                        
                       ,:DD-COMPANY-NO                                  
                       ,CIS.CHAR2TIMESTAMP(:DD-CREATED-TS)                      
                       ,:DD-LAST-UPDATE-USERID                          
                       ,IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )                             
                       ,CIS.CHAR2TIMESTAMP(:DD-LAST-UPDATE-TS)                  
                       ,IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )                        
                       ,:DD-TIER-SOURCE-CD                              
                       ,:DD-ADJ-TIER-SEQ-NO)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_MKT_TIER                                    
MFA-TR*               ( ACCOUNT_NO                                              
MFA-TR*                ,TIER_CUST_STAT_CD                                       
MFA-TR*                ,TIER_ACCT_TYPE_CD                                       
MFA-TR*                ,MKT_TIER_RANKING                                        
MFA-TR*                ,MKT_TIER_START_DT                                       
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,CREATED_TS                                              
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,EFF_START_DT                                            
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,LAST_EVALUATED_DT                                       
MFA-TR*                ,TIER_SOURCE_CD                                          
MFA-TR*                ,ADJ_TIER_SEQ_NO)                                        
MFA-TR*        VALUES ( :DD-ACCOUNT-NO                                          
MFA-TR*                ,:DD-TIER-CUST-STAT-CD                                   
MFA-TR*                ,:DD-TIER-ACCT-TYPE-CD                                   
MFA-TR*                ,:DD-MKT-TIER-RANKING                                    
MFA-TR*                ,:DD-MKT-TIER-START-DT                                   
MFA-TR*                ,:DD-COMPANY-NO                                          
MFA-TR*                ,:DD-CREATED-TS                                          
MFA-TR*                ,:DD-LAST-UPDATE-USERID                                  
MFA-TR*                ,:DD-EFF-START-DT                                        
MFA-TR*                ,:DD-LAST-UPDATE-TS                                      
MFA-TR*                ,:DD-LAST-EVALUATED-DT                                   
MFA-TR*                ,:DD-TIER-SOURCE-CD                                      
MFA-TR*                ,:DD-ADJ-TIER-SEQ-NO)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO WS-INSERT-REC-CNTR      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = WS-803                         
                 ADD 1                             TO WS-SKIP-REC-CNTR  
                 MOVE 'CSS_ACCT_MKT_TIER'          TO PRT-FIELD-NAME    
                 MOVE 'RECORD ALREADY EXISTS'      TO PRT-ERROR-MSG     
                 MOVE '   -803'                    TO PRT-ERROR-VALUE   
                 PERFORM 8200-WRITE-REPORT         THRU 8200-EXIT       
              ELSE                                                      
                 DISPLAY '********** PCSCA480 ABORT **************'     
                 DISPLAY '*     8100-INSERT-CIS-DATA             *'     
                 DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE 
                 DISPLAY '* ACCOUNT_NO        : ' DD-ACCOUNT-NO         
                 DISPLAY '* TIER_CUST_STAT_CD : ' DD-TIER-CUST-STAT-CD  
                 DISPLAY '* TIER_ACCT_TYPE_CD : ' DD-TIER-ACCT-TYPE-CD  
                 DISPLAY '* MKT_TIER_RANKING  : ' DD-MKT-TIER-RANKING   
                 DISPLAY '* MKT_TIER_START_DT : ' DD-MKT-TIER-START-DT  
                 DISPLAY '* COMPANY_NO        : ' DD-COMPANY-NO         
                 DISPLAY '* EFF_START_DT      : ' DD-EFF-START-DT       
                 DISPLAY '* LAST_EVALUATED_DT : ' DD-LAST-EVALUATED-DT  
                 DISPLAY '* PROGRAM ABORTING...                  *'     
                 DISPLAY '********** PCSCA480 ABORT **************'     
                 PERFORM 9900-ABEND                     THRU 9900-EXIT  
              END-IF                                                    
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8110-UPDATE-LAST-RUN-DATE.                                    *         
      *****************************************************************         
       8110-UPDATE-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA     = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                 
                   AND CMND_CODE     = :G6-CMND-CODE                    
                   AND COMPANY_NO    = :G6-COMPANY-NO                   
                   AND SEQ_NO        = :G6-SEQ-NO                       
                   AND STATUS        = 'A'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*     8110-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
              DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-WRITE-REPORT                                              *        
      ******************************************************************        
       8200-WRITE-REPORT.                                               
      *                                                                         
           IF WS-LINE-COUNT > 60                                        
              ADD 1                    TO WS-PAGE-COUNT                 
              MOVE 0                   TO WS-LINE-COUNT                 
              PERFORM 8300-PRINT-HEADERS       THRU 8300-EXIT           
           END-IF                                                       
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT-DETAIL-LINE-1                 
                 AFTER ADVANCING 1 LINE                                 
                                                                        
           ADD 1                       TO WS-LINE-COUNT                 
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8300-PRINT-HEADERS.                                              
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-1                      
                 AFTER ADVANCING 1 LINE                                 
                                                                        
           MOVE WS-PAGE-COUNT          TO P-RPT-PAGE-NO                 
                                                                        
           WRITE PRT33-RECORD FROM WS-RPT-HEADER-2                      
                 AFTER ADVANCING 1 LINE                                 
           WRITE PRT33-RECORD FROM WS-RPT-COLUMN-HEADER-1               
                 AFTER ADVANCING 2 LINE                                 
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE                                 
           WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                 AFTER ADVANCING 1 LINE                                 
           ADD 6                       TO WS-LINE-COUNT                 
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8800-WRITE-RESTART                                             *        
      ******************************************************************        
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM     
           MOVE 1                                TO RF-PARTITION-NO     
           MOVE 1                                TO RF-DUP-CNTRL-NO     
           MOVE WS-RESTART-DATA                  TO                     
                                                 RF-RESTART-DATA-TEXT   
           MOVE WS-RESTART-DATA-LENGTH           TO RF-RESTART-DATA-LEN 
                                                                        
           PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
           END-IF                                                       
           .                                                            
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8850-UPDATE-RESTART.                                           *        
      ******************************************************************        
       8850-UPDATE-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                   
                  AND PARTITION_NO = :RF-PARTITION-NO                   
                  AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*        8850-UPDATE-RESTART           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8860-INSERT-RESTART.                                           *        
      ******************************************************************        
       8860-INSERT-RESTART.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                      ( NAME_PROGRAM                                    
                       ,PARTITION_NO                                    
                       ,DUP_CNTRL_NO                                    
                       ,RESTART_DATA     )                              
               VALUES ( :RF-NAME-PROGRAM                                
                       ,:RF-PARTITION-NO                                
                       ,:RF-DUP-CNTRL-NO                                
                       ,:RF-RESTART-DATA )                              
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO  WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA480 ABORT **************'        
              DISPLAY '*       8860-INSERT-RESTART            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* NAME_PROGRAM   : ' RF-NAME-PROGRAM             
              DISPLAY '* DUP_CNTRL_NO   : ' RF-DUP-CNTRL-NO             
              DISPLAY '* PARTITION_NO   : ' RF-PARTITION-NO             
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA480 ABORT **************'        
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF                                                       
           .                                                            
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
       8888-COMMIT.                                                     
              PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT         
              EXEC SQL                                                          
                  INCLUDE CPD00047                                              
              END-EXEC.                                                         
              DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'        
           .                                                            
       8888-EXIT.                                                       
           EXIT.                                                        
C37825*                                                                         
C37825******************************************************************        
C37825* 8893-RESET-RESTART-REQ-PARM                                    *        
C37825******************************************************************        
C37825*                                                                         
C37825     EXEC SQL                                                             
C37825         INCLUDE CPD00029                                                 
C37825     END-EXEC.                                                            
      *                                                                         
A00765****************************************************************          
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
A00765****************************************************************          
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                         
      ******************************************************************        
      *                                                                *        
      * 9000-TERMINATE.                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *                                                                         
           IF WS-FMKT01-REC-CNTR   EQUAL ZERO AND                       
              WS-END-REC-PROCESSED EQUAL WS-Y                           
              MOVE 4                   TO RETURN-CODE                   
              DISPLAY '**************PCSCA480*****************'         
              DISPLAY '****                              *****'         
              DISPLAY '**** VM FILE CONTAINS NO ACCOUNTS *****'         
              DISPLAY '**** AN E-MAIL WILL BE SEND TO USERS **'         
              DISPLAY '**** INDICATING ERROR                **'         
              DISPLAY '****                              *****'         
              DISPLAY '**************PCSCA480*****************'         
           END-IF                                                       
                                                                        
A02904     IF INVALID-TIER-EXISTS AND WS-END-REC-PROCESSED EQUAL WS-Y   
C37790        MOVE 6                   TO RETURN-CODE                   
C37790        DISPLAY '**************PCSCA480*****************'         
C37790        DISPLAY '****                              *****'         
A02904        DISPLAY '**** VM FILE CONTAINS INVALID TIER   **'         
C37790        DISPLAY '**** ACCOUNTS , AN E-MAIL WILL BE   **'          
C37790        DISPLAY '**** SEND TO USERS INDICATING ERROR  **'         
C37790        DISPLAY '****                              *****'         
C37790        DISPLAY '**************PCSCA480*****************'         
C37790     END-IF                                                       
C37790                                                                  
           CLOSE FCSMKT01-FILE                                          
           CLOSE FCSPT33-FILE                                           
                                                                        
           DISPLAY 'INPUT FILE RECORDS = ' WS-FMKT01-REC-CNTR           
           DISPLAY 'RECORDS INSERTED   = ' WS-INSERT-REC-CNTR           
           DISPLAY 'RECORDS SKIPED     = ' WS-SKIP-REC-CNTR             
                                                                        
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  55700000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *  55710000
      ****************************************************************  55720000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 55740000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                 56040000
      ******************************************************************        
      *  9700-PROCESS-ABEND.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
