       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA467                                         
       DATE-WRITTEN.   FEB 2010.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
      *  02/11/10  DB41297    NEW PROGRAM                              *        
A05462**   10/16    DB41297   MAKE PROGRAM MICROFOCUS COMPLIANT      ** 00016220
      ******************************************************************        
      *                                                                *        
      *   R   E    M   A     R    K     S                              *        
      *                                                                *        
      ******************************************************************        
      *  THIS PROGRAM READS NON-RECONCILED TRANS FROM CSS_PAYMENT_TRANS*        
      *  AND FLAGS THEM FOR FILEAID.                                   *        
      ******************************************************************        
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
        SOURCE-COMPUTER.    IBM-4381.                                   
        OBJECT-COMPUTER.    IBM-4381.                                   
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA467'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *             'WORKING STORAGE FOR PCSCS467 STARTS HERE'.        *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                *        
      ******************************************************************        
       01  WS-DATE-VARIABLES.                                           
           05 WS-DATE-5                        PIC X(10).               
           05 WS-DATES                         PIC X(10).               
           05 WS-COMMON-DATE                   PIC X(10).               
           05 WS-DAYS                          PIC S9(9) COMP.          
           05 WS-COUNT                         PIC S9(9) COMP.          
           05 WS-SUB                           PIC S9(9) COMP.          
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                *        
      ******************************************************************        
      *                                                                         
      *                                                                         
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-ACCOUNT-NO                    PIC 9(13).              
      *                                                                         
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-PGRMNAME                      PIC X(10) VALUE         
                                                       'PCSCA467'.      
           05  WS-COMPANY                       PIC X(02) VALUE '01'.   
           05  WS-N                             PIC X(01) VALUE 'N'.    
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
           05  WS-CHKP-UPD-COUNTER              PIC S9(04) COMP-3       
                                                          VALUE ZERO.   
           05  WS-DISPLAY-COUNTER               PIC ZZZ,ZZ9.            
      *                                                                         
      ******************************************************************        
      **   COPYBOOKS USED IN THE PROGRAM                              **        
      ******************************************************************        
      *                                                                         
      *THIS COPYBOOK IS USED FOR DB2 ERROR PROCESSING.                          
       COPY CWS00303.                                                           
      *IO AREA FOR PARAMETER INPUT FILE 'A'                                     
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *ABEND SWITCH COPYBOOK                                                    
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      **   C  W  S  0  0  3  1  5                                     **        
      ******************************************************************        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   S  Q  L  C  A                                              **        
      ******************************************************************        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQUENCY  C8                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   CSS_JOB PARM     G6                                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PAYMENT_TRANS  JT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPMTRAN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR TO SELECT CSS_OVERSHORT_HDR                          *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE RECON_CURSOR CURSOR WITH HOLD FOR                   
             SELECT JT.ACCOUNT_NO                                       
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), JT.PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
               FROM CSS_PAYMENT_TRANS JT                                
              WHERE RECONCILED_FL IN ('N')                              
                AND JT.DATE_CASH_REPORT <= IIF(TRY_CONVERT(DATE, 
                                                              :WS-DATES
              ) IS NULL OR (PATINDEX('%.%', :WS-DATES) <> 0) OR (LEN(
                                                              :WS-DATES
              ) <> 10), CIS.CHAR2DATE(:WS-DATES), CONVERT(DATE, 
                                                              :WS-DATES
              ) )              
                AND JT.CASH_LOCAL_OFFICE IN (SELECT                     
                     (CIS.SUBSTR3(JP.PARM_DATA,14,3))                        
                     FROM CSS_JOB_PARM JP                               
                      WHERE JP.PROGRAM_NAME = 'PCSCA467'                
                        AND JP.CMND_CODE    = 'PARM'                    
                        AND JP.STATUS= 'A')                             
               FOR UPDATE OF                                            
                    RECONCILED_FL                                       
                   ,RECONCILED_DT                                       
                   ,LAST_UPDATE_USERID                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RECON_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*      SELECT JT.ACCOUNT_NO                                               
MFA-TR*            ,JT.PYMT_RCVD_TS                                             
MFA-TR*        FROM CSS_PAYMENT_TRANS JT                                        
MFA-TR*       WHERE RECONCILED_FL IN ('N')                                      
MFA-TR*         AND JT.DATE_CASH_REPORT <= DATE(:WS-DATES)                      
MFA-TR*         AND JT.CASH_LOCAL_OFFICE IN (SELECT                             
MFA-TR*              (SUBSTR(JP.PARM_DATA,14,3))                                
MFA-TR*              FROM CSS_JOB_PARM JP                                       
MFA-TR*               WHERE JP.PROGRAM_NAME = 'PCSCA467'                        
MFA-TR*                 AND JP.CMND_CODE    = 'PARM'                            
MFA-TR*                 AND JP.STATUS= 'A')                                     
MFA-TR*        FOR UPDATE OF                                                    
MFA-TR*             RECONCILED_FL                                               
MFA-TR*            ,RECONCILED_DT                                               
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    'WORKING STORAGE FOR PCSCS467 ENDS HERE '.                  *        
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7200-OPEN-RECON                                      
              THRU 7200-EXIT.                                           
      *                                                                         
           PERFORM 7300-FETCH-RECON                                     
              THRU 7300-EXIT.                                           
      *                                                                         
           PERFORM 1000-PROCESS                                         
              THRU 1000-EXIT                                            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
      *                                                                         
           PERFORM 7400-CLOSE-RECON                                     
              THRU 7400-EXIT.                                           
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT.                                           
           MOVE WS-COMPANY               TO C8-COMPANY-NO.              
           MOVE 'RECONDAYS'              TO C8-DELINQ-CD.               
           PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT.                
           MOVE C8-DELINQ-VALUE TO WS-DAYS.                             
                                                                        
           MOVE WS-INPUT-DATE TO WS-COMMON-DATE                         
                                 JT-RECONCILED-DT.                      
           PERFORM 7100-GET-DAYS-DIFF THRU 7100-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0300-SETUP-DATES                                            **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSCS467'            TO WS-PGRMNAME                 
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS                                                 **        
      ******************************************************************        
       1000-PROCESS.                                                    
      *--------------------*                                                    
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7900-UPDATE-RECON-DETAIL                             
              THRU 7900-EXIT.                                           
      *                                                                         
           PERFORM 7300-FETCH-RECON                                     
              THRU 7300-EXIT.                                           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-GET-DAYS-DIFF                                          **        
      **                                                              **        
      ******************************************************************        
       7100-GET-DAYS-DIFF.                                              
      *--------------------------*                                              
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM VARYING WS-SUB FROM WS-DAYS BY -1                    
              UNTIL WS-SUB = 0                                          
              MOVE 0 TO WS-COUNT                                        
              EXEC SQL                                                  
                SELECT
              DATEADD( DAY, -:WS-SUB, IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-5                                     
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SET    :WS-DATE-5 = DATE(:WS-COMMON-DATE) -                     
MFA-TR*                :WS-SUB DAYS                                             
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              EXEC SQL                                                  
                SELECT COUNT(*)                                         
                   INTO :WS-COUNT                                       
                FROM CSS_MODEL_SQL                                      
                WHERE CIS.DAYOFWEEK(IIF(TRY_CONVERT(DATE, :WS-DATE-5
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-5) <> 0) OR (LEN(
                                                             :WS-DATE-5
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-5), CONVERT(DATE, 
                                                             :WS-DATE-5
              ) ))                       
                                             IN (1,7)                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*            INTO :WS-COUNT                                               
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYOFWEEK(DATE(:WS-DATE-5))                               
MFA-TR*                                      IN (1,7)                           
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              COMPUTE WS-DAYS = WS-DAYS + WS-COUNT                      
           END-PERFORM.                                                 
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -:WS-DAYS, IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-5                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET    :WS-DATE-5 = DATE(:WS-COMMON-DATE) -                        
MFA-TR*             :WS-DAYS DAYS                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 0 TO WS-COUNT.                                          
           EXEC SQL                                                     
             SELECT COUNT(*)                                            
                INTO :WS-COUNT                                          
              FROM CSS_HOLIDAY                                          
              WHERE COMPANY_NO = :C8-COMPANY-NO                         
                AND HOLIDAY_DT BETWEEN                                  
                    IIF(TRY_CONVERT(DATE, :WS-DATE-5
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-5) <> 0) OR (LEN(
                                                             :WS-DATE-5
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-5), CONVERT(DATE, 
                                                             :WS-DATE-5
              ) ) AND IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COUNT(*)                                                    
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*       FROM CSS_HOLIDAY                                                  
MFA-TR*       WHERE COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*         AND HOLIDAY_DT BETWEEN                                          
MFA-TR*             DATE(:WS-DATE-5) AND DATE(:WS-COMMON-DATE)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           COMPUTE WS-DAYS = WS-DAYS + WS-COUNT.                        
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -:WS-DAYS, IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATES                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET    :WS-DATES = DATE(:WS-COMMON-DATE) -                         
MFA-TR*             :WS-DAYS DAYS                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR GETTING TIMESTAMP VALUE **'                
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7800-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7800-SELECT-DATABASE.                                            
      *---------------------*                                                   
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
             WHERE COMPANY_NO            = :C8-COMPANY-NO               
               AND DELINQ_CD             = :C8-DELINQ-CD                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*      WHERE COMPANY_NO            = :C8-COMPANY-NO                       
MFA-TR*        AND DELINQ_CD             = :C8-DELINQ-CD                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  7900-UPDATE-RECON-DETAIL                                    **        
      **                                                              **        
      ******************************************************************        
       7900-UPDATE-RECON-DETAIL.                                        
      *---------------------*                                                   
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET RECONCILED_FL      = 'M'                            
                   ,RECONCILED_DT      = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   ,LAST_UPDATE_USERID = 'CA467'                        
              WHERE CURRENT OF RECON_CURSOR                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET RECONCILED_FL      = 'M'                                    
MFA-TR*            ,RECONCILED_DT      = CURRENT DATE                           
MFA-TR*            ,LAST_UPDATE_USERID = 'CA467'                                
MFA-TR*       WHERE CURRENT OF RECON_CURSOR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                        TO WS-CHKP-UPD-COUNTER       
              DISPLAY '* RECORD UPDATED SUCCESSFULLY *'                 
              DISPLAY '* ACCOUNT NO      ', JT-ACCOUNT-NO               
           ELSE                                                         
              DISPLAY '********** PCSCA467 ABORT **************'        
              DISPLAY '* 7900-UPDATE-ERROR-CODE               *'        
              DISPLAY '* ACCOUNT NO      ', JT-ACCOUNT-NO               
              DISPLAY '* ERROR CODE      ', JT-ERROR-CD                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA467 ABORT **************'        
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  7200-OPEN-RECON.                                            **        
      **                                                              **        
      ******************************************************************        
       7200-OPEN-RECON.                                                 
      *-------------*                                                           
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                OPEN RECON_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING RECON_CURSOR **'                   
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7300-FETCH-RECON.                                           **        
      **                                                              **        
      ******************************************************************        
       7300-FETCH-RECON.                                                
      *--------------*                                                          
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
              FETCH RECON_CURSOR                                        
               INTO :JT-ACCOUNT-NO                                      
                   ,:JT-PYMT-RCVD-TS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR FETCHING RECON CURSOR **'                  
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              STRING ' ACCOUNT NO  '     DELIMITED BY SIZE              
                      WS-ACCOUNT-NO      DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7400-CLOSE-RECON                                            **        
      **                                                              **        
      ******************************************************************        
       7400-CLOSE-RECON.                                                
      *--------------*                                                          
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                CLOSE RECON_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR CLOSING RECON CURSOR **'                   
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                        **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PCSCA467 ABENDING                      *'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY '**'   WS-ERR-MSG.                                   
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
      *                                                                         
       8800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
           MOVE WS-CHKP-UPD-COUNTER TO WS-DISPLAY-COUNTER               
           DISPLAY '** NUMBER OF RECORDS UPDATED '                      
             WS-DISPLAY-COUNTER ' **'.                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
