       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA466.                                        
       AUTHOR.         MELISSA JOHNSON.                                 
       DATE-WRITTEN.   MAR 2006.                                        
      ***************************************************************** 00050000
      ********   GENERATES FILE FOR THIRD PARTY LETTERS:           **** 00060000
      ********       THIRD PARTY ADD - SENT TO ACCOUNT             **** 00070000
      ********          90818                                      **** 00080000
      ********       THIRD PARTY OPT OUT - SENT TO THIRD PARTY     **** 00090000
      ********          90822                                      **** 00100000
      ********       THIRD PARTY INACTIVE - SENT TO ACCOUNT        **** 00110000
      ********          90819                                      **** 00120000
      ********       THIRD PARTY INACTIVE CC - SENT TO THIRD PARTY **** 00130000
      ********          90823                                      **** 00140000
      ********       THIRD PARTY CHANGE - SENT TO ACCOUNT          **** 00150000
      ********          90820                                      **** 00160000
      ********       THIRD PARTY CHANGE CC - SENT TO THIRD PARTY   **** 00170000
      ********          90824                                      **** 00180000
      ********       THIRD PARTY ANNIV - SENT TO ACCOUNT           **** 00190000
      ********          90821                                      **** 00200000
      ********       THIRD PARTY ANNIV - CC OF 90821 SENT TO THIRD **** 00210000
      ********          90825            PARTY                     **** 00220000
      ***************************************************************** 00230000
      *                                                             **  00240000
      *              PROGRAM  MODIFICATION  LOG                     **  00250000
      *    DATE    INITIALS     REASON                              **  00260000
      *    ----    --------     ------                              **  00270000
C32832*  03/03/2006   MJ13662 INITIAL PROGRAM VERSION               **  00280000
C32832*  05/26/2006   MJ13662 NEW REQUIREMENTS.                     **  00290000
C32832*  IF CODE-ACCT-STAT = 'B' (FINAL BILL) AND LETTER-STATUS = 'P'*  00300000
C32832*  (PENDING) SEND THE LETTER. THIS COULD HAPPEN AFTER AN      **  00310000
C32832*  ACCOUNT TRANSFER.                                          **  00320000
C32832*  06/01/2006   MJ13662 CHANGE MAINT TRANS HIST COMMENTS FOR  **  00330000
C32832*  90818 AND 90822 LETTERS.                                   **  00340000
C35584*  3/29/2007    MJ13662 MOVE VALUES TO COMM-TYPE-CD AND       **  00350000
C35584*               COMM-SUB-CD ON FIORP000 RECORD.               **  00360000
C34097*  06/01/2007   MELISSA JOHNSON - DB2 FINE TUNING.            **  00370000
C35152*  02/18/2008   MELISSA JOHNSON/RICK BLACK                    **  00380000
C35152*               REMOVED CPD00074 - NAME & ADDRESS PROCESSING  **  00390000
C35152*               WILL BE STANDARDIZED ACROSS BILL PRINT.       **  00400000
A00765*  02/02/09     CVNS    ADDED 9000-SEND-ERROR-RESULT PARA.    **  00410000
A00765*               CHENNAI                                       **  00420000
A37741*  11/16/09     VP94820 DECLARED S-RETURN-CODE RESPECTIVE TO  **  00423000
      *                       CPD00067 CHANGES.                     **  00424000
A03866*  02/20/12     MC95456 MOVED MESSAGE ID TO PROMOTION-ID IN   **  00425000
A03866*  A03866-ACT015        CSS_COMM_DATA.                        **  00426000
P00599*  08/03/12     GV7A828 MODIFIED THE PROGRAM TO CALL SCSKR125 **  00427000
P00599*                       SUB-PROGRAM INSTEAD OF WRITING TO     **  00428000
P00599*                       RP000 FILE                            **  00429000
A04735*  08/08/13     MC95456 REMOVED DCLGEN FOR CSS_CUST_COMM_MF   **  00429100
      ****************************************************************  00430000
      *REMARKS.                                                     **  00440000
      *         COMPONENT PCSCA466 PRODUCES EXTRACT FILE FCSFA00    **  00450000
      *         WHICH IS USED TO GENERATE THE THIRD PARTY LETTERS.  **  00460000
      *                                                             **  00470000
      ****************************************************************  00480000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00510000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00540000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
HPCCDM*EJECT                                                            00600000
      *                                                                 00610000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00690000
HPCCDM*EJECT                                                            00700000
      *                                                                 00710000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA466'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSCA466 STARTS HERE'.            
      *                                                                 00760000
       01  WS-DATES.                                                    
           05  WS-JOB-PARM                 PIC X(10) VALUE SPACES.      
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
           05  WS-HIST-DISP-DATE.                                       
               10  WS-HIST-DISP-MM         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-DD         PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '/'.         
               10  WS-HIST-DISP-YR         PIC X(04).                   
           05  WS-DATE-TRANS-TS.                                        
               10  WS-DATE-TRANS           PIC X(10) VALUE SPACES.      
               10  FILLER                  PIC X(01) VALUE SPACES.      
               10  WS-TIME-TRANS           PIC X(08) VALUE SPACES.      
               10  FILLER                  PIC X(07) VALUE SPACES.      
           05  WS-PENDING-DATE             PIC X(10) VALUE SPACES.      
           05  WS-TRAN-DATE.                                            
               10  WS-TRAN-YEAR            PIC X(04).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-MONTH           PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-DAY             PIC X(02).                   
           05  WS-TRAN-TIME.                                            
               10  WS-TRAN-HOUR            PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-MIN             PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-TRAN-SEC             PIC X(02).                   
                                                                        
       01  WS-PROG-MISC.                                                
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA466'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA466'.  
P00599     05  SCSKR125                    PIC X(08) VALUE 'SCSKR125'.  
P00599     05  WS-CURRENT-DATE             PIC X(10) VALUE SPACES.      
P00599     05  RS-KR125-RETURN-CODE        PIC S9(04) COMP VALUE 0.     
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
           05  WS-INDEX                    PIC 9(01) VALUE ZEROS.       
           05  WS-SEB-REG-GROUP            PIC X(03) VALUE SPACES.      
           05  WS-ACCT-MAIL-ADDR           PIC X(50) OCCURS 6.          
           05  WS-TRAN-APPL-NO             PIC S9(04) COMP VALUE 0.     
           05  WS-MAIL-CODE                PIC X(01) VALUE 'M'.         
           05  WS-PREV-AUTO-DEP-LTR-IND    PIC X(01) VALUE SPACES.      
           05  WS-END-OF-ROWS              PIC X(01) VALUE 'N'.         
               88  END-OF-ROWS             VALUE 'Y'.                   
           05  WS-END-OF-ANNIV-ROWS        PIC X(01) VALUE 'N'.         
               88  END-OF-ANNIV-ROWS       VALUE 'Y'.                   
           05  WS-SEND-OPT-OUT             PIC X(01) VALUE 'N'.         
               88  SEND-OPT-OUT            VALUE 'Y'.                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-DATA-FOUND               PIC X(1)  VALUE 'Y'.         
           05  WS-RED-FL-NULL-IND          PIC S9(4) COMP  VALUE 0.     
           05  WS-END-NULL-IND             PIC S9(4) COMP  VALUE 0.     
           05  WS-FFA00-REC-CNTR           PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-FFA00-SEQ-NO             PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-HOME-PHONE-NO            PIC X(10) VALUE SPACES.      
           05  WS-WORK-PHONE-NO            PIC X(10) VALUE SPACES.      
           05  WS-HOME-PHONE               PIC X(02) VALUE 'H1'.        
           05  WS-WORK-PHONE               PIC X(02) VALUE 'W1'.        
           05  WS-CURRENT-COMPANY          PIC X(02).                   
           05  WS-DELINQ-COMPANY           PIC X(02).                   
           05  WS-VARIABLE-ID              PIC X(20).                   
COB305     05 WS-VARIABLE-VALUE        PIC S9(9) COMP-3 VALUE 0.            
           05  WS-VARIABLE-NEXT            PIC X(10).                   
           05  WS-DT-NEXTANN               PIC X(10).                   
           05  WS-VARIABLE-PEND            PIC X(10).                   
           05  WS-DT-PENDING               PIC X(10).                   
           05  WS-DN-ANNIV-REV    PIC X(20) VALUE 'THD-PRTY-ANNIV-REV '.
           05  WS-DN-PENDING      PIC X(20) VALUE 'THD-PRTY-PENDING   '.
           05  WS-ANNIV-REV                PIC S9(05) COMP-3 VALUE +0.  
           05  WS-PENDING                  PIC S9(05) COMP-3 VALUE +0.  
           05  WS-DELINQUENCY-VALUES-TABLE.                             
               10  WS-DELINQ-COMPANY-ENTRY-TB                           
                   OCCURS 5 TIMES                                       
                   INDEXED BY TB-CO-INDEX.                              
                   15  WS-DELINQ-VALUE-ENTRY-TB                         
                       OCCURS 2 TIMES                                   
                       INDEXED BY TB-VAL-INDEX.                         
                       20  WS-DELINQ-COMPANY-TB  PIC X(02).             
                       20  WS-DELINQ-CODE-TB     PIC X(20).             
                       20  WS-DELINQ-VALUE-TB    PIC S9(05).            
                       20  WS-DELINQ-NEXTANN-TB  PIC X(10).             
                       20  WS-DELINQ-PENDING-TB  PIC X(10).             
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-CN                       PIC X(02) VALUE 'CN'.        
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-80                       PIC S9(04) COMP VALUE +80.   
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-M                        PIC X(01) VALUE 'M'.         
           05  WS-V                        PIC X(01) VALUE 'V'.         
           05  WS-S                        PIC X(01) VALUE 'S'.         
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-F                        PIC X(01) VALUE 'F'.         
           05  WS-SCEG                     PIC X(02) VALUE '01'.        
           05  WS-ZERO                     PIC 9(01) VALUE  0.          
           05  WS-NULL-IND1                PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-IND2                PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-IND3                PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-IND4                PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-IND5                PIC S9(4) COMP VALUE 0.      
           05  WS-NULL-IND6                PIC S9(4) COMP VALUE 0.      
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
A37741     05  S-RETURN-CODE               PIC S9(9) VALUE +000 COMP.   
                                                                        
P00599*                                                                 02571000
P00599 01  WS-COMMIT-VARS.                                              
P00599     05  WS-COMMIT-REC-CNTR          PIC S9(07) COMP-3 VALUE 0.   
P00599     05  WS-COMMIT-COUNTER1          PIC 9(9)   VALUE 0.          
P00599     05  WS-COMMIT-COUNTER2          PIC 9(9)   VALUE 0.          
P00599     05  WS-COMMIT-LIMIT             PIC 9(4)   VALUE 0.          
P00599     05  WS-DEFAULT-COMMIT-LIMIT     PIC 9(4)   VALUE 1000.       
P00599*                                                                 02578000
HPCCDM*EJECT                                                            02580000
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       02590000
       COPY CWS00303.                                                   02600000
                                                                        
      ******* WS-ABEND WORK AREA  ****************                      02620000
       COPY CWS00010.                                                   02630000
                                                                        
      ******* WS-FCA00-MISC       ****************                      02650000
       COPY CWS00039.                                                   02660000
                                                                        
      ******* WS-ABEND-SWITCH     ****************                      02680000
       COPY CWS09900.                                                   02690000
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                      02710000
       COPY FIOJC01.                                                    02720000
                                                                        
P00599******* CORRESP NOTICE VARIABLES************                      02731000
P00599                                                                  
P00599 COPY CWS00341.                                                   02732000
P00599                                                                  
P00599******************************************************************02734000
P00599* VARIABLES NEEDED FOR NOTICE PROCESSING                         *02735000
P00599******************************************************************02736000
P00599                                                                  
P00599     EXEC SQL                                                     02738000
P00599        INCLUDE CWS00350                                          02739000
P00599     END-EXEC.                                                    02739100
P00599                                                                  
      ******* FCA00-KEY           ****************                      02740000
       COPY FIOCA00.                                                    02750000
                                                                        
           EXEC SQL                                                     02770000
                INCLUDE SQLCA                                           02780000
           END-EXEC.                                                    02790000
                                                                        
      ******* TABLE DECLARATION FOR CSS_ACCOUNT  AT ******************  02810000
                                                                        
           EXEC SQL                                                     02830000
                INCLUDE TBACCT                                          02840000
           END-EXEC.                                                    02850000
      *                                                                 02860000
      ******* TABLE DECLARATION FOR CSS_REG_PROFILE LR ***************  02870000
           EXEC SQL                                                     02880000
                INCLUDE TBREGPRF                                        02890000
           END-EXEC.                                                    02900000
      *                                                                 02910000
      ******* TABLE DECLARATION FOR CSS_ADDR_FREEFORM DZ *************  02920000
                                                                        
           EXEC SQL                                                     02940000
                INCLUDE TBADRFRE                                        02950000
           END-EXEC.                                                    02960000
      *                                                                 02970000
      ******* TABLE DECLARATION FOR CSS_JOB_PARM G6   ******************03040000
      *                                                                 03050000
           EXEC SQL                                                     03060000
               INCLUDE TBJBPARM                                         03070000
           END-EXEC.                                                    03080000
      *                                                                 03090000
      ******* TABLE DECLARATION FOR CSS_THD_PRTY ZW ******************  03270000
      *                                                                 03280000
           EXEC SQL                                                     03290000
              INCLUDE TBTHDPTY                                          03300000
           END-EXEC.                                                    03310000
      ******* TABLE DECLARATION FOR CSS_THD_PRTY_PHONE ZY ************  03320000
      *                                                                 03330000
           EXEC SQL                                                     03340000
              INCLUDE TBTHDPHO                                          03350000
           END-EXEC.                                                    03360000
      *                                                                 03370000
      ******* TABLE DECLARATION FOR CSS_THD_PRTY_HIST ZX  ************  03380000
      *                                                                 03390000
           EXEC SQL                                                     03400000
              INCLUDE TBTHDHST                                          03410000
           END-EXEC.                                                    03420000
                                                                        
      ******* WORKING STORAGE FOR WS-MISC.                              03660000
           EXEC SQL                                                     03670000
              INCLUDE CWS00038                                          03680000
           END-EXEC.                                                    03690000
      *                                                                 03700000
P00599 01  WS-COMMIT-COUNT REDEFINES WS-INPUT-DATA-BREAKDOWN.           
P00599     10  WS-COMMIT-COUNT-TXT         PIC X(09).                   
P00599         88 COMMIT-PARM            VALUE 'COMMIT = '.             
P00599     10  WS-COMMIT-NUM               PIC 9(04).                   
P00599     10  FILLER                      PIC X(67).                   
      ******* TABLE DECLARATION FOR CSS_DELINQUENCY C8 **************   03710000
           EXEC SQL                                                     03720000
               INCLUDE TBDELQ                                           03730000
           END-EXEC.                                                    03740000
      *                                                                 03750000
      ******* CURSOR DECLARATION FOR CSS_THD_PRTY                       03810000
           EXEC SQL                                                     
              DECLARE THDPRTY_CSR CURSOR WITH HOLD FOR                  
              SELECT ZW.THD_PRTY_ID                                     
                    ,ZW.ACCOUNT_NO                                      
                    ,ZW.ADDRESS_ID                                      
                    ,ZW.DATE_CREATED                                    
                    ,ZW.DATE_INACTIVE                                   
                    ,ZW.DATE_NEXT_ANNIV                                 
                    ,ZW.NAME_ID                                         
                    ,ZW.THD_PRTY_STATUS                                 
                    ,ZX.LETTER_STATUS                                   
                    ,ZX.LETTER_TYPE_CD                                  
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), ZX.DATE_TRANS
           , 121), ' ', '-'), ':', '.') DATE_TRANS                             
               FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                       
                   ,CSS_THD_PRTY_HIST ZX WITH(READUNCOMMITTED)                  
              WHERE ZW.THD_PRTY_ID = ZX.THD_PRTY_ID                     
                AND ZX.LETTER_STATUS = :WS-P                            
                AND ZX.DATE_MAILED IS NULL                              
              ORDER BY ZW.ACCOUNT_NO                                    
              FOR READ ONLY                                     
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03820000
MFA-TR*       DECLARE THDPRTY_CSR CURSOR WITH HOLD FOR                  03830000
MFA-TR*       SELECT ZW.THD_PRTY_ID                                     03840000
MFA-TR*             ,ZW.ACCOUNT_NO                                      03850000
MFA-TR*             ,ZW.ADDRESS_ID                                      03860000
MFA-TR*             ,ZW.DATE_CREATED                                    03870000
MFA-TR*             ,ZW.DATE_INACTIVE                                   03880000
MFA-TR*             ,ZW.DATE_NEXT_ANNIV                                 03890000
MFA-TR*             ,ZW.NAME_ID                                         03900000
MFA-TR*             ,ZW.THD_PRTY_STATUS                                 03910000
MFA-TR*             ,ZX.LETTER_STATUS                                   03920000
MFA-TR*             ,ZX.LETTER_TYPE_CD                                  03930000
MFA-TR*             ,ZX.DATE_TRANS                                      03940000
MFA-TR*        FROM CSS_THD_PRTY ZW                                     03950000
MFA-TR*            ,CSS_THD_PRTY_HIST ZX                                03960000
MFA-TR*       WHERE ZW.THD_PRTY_ID = ZX.THD_PRTY_ID                     03970000
MFA-TR*         AND ZX.LETTER_STATUS = :WS-P                            03980000
MFA-TR*         AND ZX.DATE_MAILED IS NULL                              03990000
MFA-TR*       ORDER BY ZW.ACCOUNT_NO                                    04000000
MFA-TR*       FOR FETCH ONLY WITH UR                                    04010000
MFA-TR*       QUERYNO 7010                                              04011000
MFA-TR*    END-EXEC.                                                    04020000
      **                                                                04030000
      ******* CURSOR DECLARATION FOR CSS_ANNIV                          04040000
           EXEC SQL                                                     
              DECLARE ANNIV_CSR CURSOR WITH HOLD FOR                    
              SELECT ZW.THD_PRTY_ID                                     
                    ,ZW.ACCOUNT_NO                                      
                    ,ZW.ADDRESS_ID                                      
                    ,ZW.DATE_CREATED                                    
                    ,ZW.DATE_INACTIVE                                   
                    ,ZW.DATE_NEXT_ANNIV                                 
                    ,ZW.NAME_ID                                         
                    ,ZW.THD_PRTY_STATUS                                 
               FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED)                       
              WHERE ZW.THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS            
                AND ZW.DATE_NEXT_ANNIV <= IIF(TRY_CONVERT(DATE, 
                                                    :ZW-DATE-NEXT-ANNIV
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-NEXT-ANNIV
              ) <> 0) OR (LEN(:ZW-DATE-NEXT-ANNIV
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-NEXT-ANNIV
              ), CONVERT(DATE, :ZW-DATE-NEXT-ANNIV) )           
              ORDER BY ZW.ACCOUNT_NO                                    
              FOR READ ONLY                                            
                                                                 
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04050000
MFA-TR*       DECLARE ANNIV_CSR CURSOR WITH HOLD FOR                    04060000
MFA-TR*       SELECT ZW.THD_PRTY_ID                                     04070000
MFA-TR*             ,ZW.ACCOUNT_NO                                      04080000
MFA-TR*             ,ZW.ADDRESS_ID                                      04090000
MFA-TR*             ,ZW.DATE_CREATED                                    04100000
MFA-TR*             ,ZW.DATE_INACTIVE                                   04110000
MFA-TR*             ,ZW.DATE_NEXT_ANNIV                                 04120000
MFA-TR*             ,ZW.NAME_ID                                         04130000
MFA-TR*             ,ZW.THD_PRTY_STATUS                                 04140000
MFA-TR*        FROM CSS_THD_PRTY ZW                                     04150000
MFA-TR*       WHERE ZW.THD_PRTY_STATUS = :ZW-THD-PRTY-STATUS            04160000
MFA-TR*         AND ZW.DATE_NEXT_ANNIV <= :ZW-DATE-NEXT-ANNIV           04170000
MFA-TR*       ORDER BY ZW.ACCOUNT_NO                                    04180000
MFA-TR*       FOR FETCH ONLY                                            04181000
MFA-TR*       WITH UR                                                   04190000
MFA-TR*       QUERYNO 7060                                              04191000
MFA-TR*    END-EXEC.                                                    04200000
      *                                                                 04210000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA466 ENDS HERE  '.            
HPCCDM*    EJECT                                                        04240000
                                                                        
       LINKAGE SECTION.                                                 
HPCCDM*EJECT                                                            04270000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************04300000
      *                                                                *04310000
      *   0000-MAINLINE.                                               *04320000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *04330000
      *                                                                *04340000
      ******************************************************************04350000
       0000-MAINLINE.                                                   
      *                                                                 04370000
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
P00599     PERFORM 0120-GET-COMMIT-PARM      THRU 0120-EXIT.            
           PERFORM 1000-CURSOR-PROCESS       THRU 1000-EXIT.            
           PERFORM 1050-ANNIV-CURSOR-PROCESS THRU 1050-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04690000
      *                                                                *04700000
      *   0100-INITIALIZATION                                          *04710000
      *        COMMON INITIALIZATION ROUTINE                           *04720000
      *                                                                *04730000
      ***************************************************************** 04740000
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                 04770000
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE           TO WS-JOB-PARM.                 
           INITIALIZE  WS-CURRENT-COMPANY                               
                       WS-DELINQ-COMPANY                                
                       WS-VARIABLE-ID                                   
                       WS-VARIABLE-VALUE                                
                       WS-VARIABLE-NEXT                                 
                       WS-VARIABLE-PEND                                 
                       WS-DELINQUENCY-VALUES-TABLE                      
                       WS-NULL-IND1                                     
                       WS-NULL-IND2                                     
                       WS-NULL-IND3                                     
                       WS-NULL-IND4                                     
                       WS-NULL-IND5                                     
                       WS-NULL-IND6                                     
                       AT-ACCOUNT-NO.                                   
P00599* TO IDENTIFY THE DATA BASE                                       05241000
P00599     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P00599     MOVE '01'                            TO C8-COMPANY-NO.       
P00599     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
P00599     PERFORM 7150-SELECT-DELINQ-VALUE     THRU 7150-EXIT.         
P00599     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
P00599     MOVE SPACES                          TO C8-DELINQ-CD.        
P00599                                                                  
           PERFORM 7329-OPEN-DELINQ   THRU 7329-OPEN-DELINQ-EXIT.       
           PERFORM 7329-FETCH-DELINQ  THRU 7329-FETCH-DELINQ-EXIT.      
           SET TB-CO-INDEX  TO 1.                                       
           SET TB-VAL-INDEX TO 1.                                       
           PERFORM 2328-LOAD-DELINQ-VALUE THRU 2328-LOAD-DELINQ-EXIT    
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7329-CLOSE-DELINQ  THRU 7329-CLOSE-DELINQ-EXIT.      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599******************************************************************05360000
P00599**  0120-GET-COMMIT-PARM                                        **05370000
P00599******************************************************************05380000
P00599*                                                                 05390000
P00599 0120-GET-COMMIT-PARM.                                            
P00599*                                                                 05410000
P00599     MOVE SPACES                 TO WS-SYSIPT.                    
P00599     MOVE WS-PGRMNAME            TO WS-PROGRAM.                   
P00599     MOVE WS-PARM                TO WS-COMMAND.                   
P00599     MOVE ZEROS                  TO WS-SEQUENCE.                  
P00599                                                                  
P00599     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P00599                                                                  
P00599     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P00599          UNTIL (COMMIT-PARM AND INPUT-ACTIVE)                    
P00599            OR  END-OF-SYSIPT.                                    
P00599                                                                  
P00599     MOVE G6-PARM-DATA           TO WS-COMMIT-COUNT.              
P00599                                                                  
P00599     EVALUATE TRUE                                                
P00599        WHEN END-OF-SYSIPT                                        
P00599           DISPLAY ' '                                            
P00599           DISPLAY '**  PCSCA466 PROCESSING INFO   **'            
P00599           DISPLAY '**    COMMIT PARM NOT PRESENT'                
P00599           DISPLAY '**  DEFAULT CHKP LUW 1000 IS USED'            
P00599           MOVE WS-DEFAULT-COMMIT-LIMIT TO WS-COMMIT-LIMIT        
P00599        WHEN WS-COMMIT-NUM NOT NUMERIC                            
P00599           DISPLAY ' '                                            
P00599           DISPLAY '**  PCSCA466 PROCESSING ERROR  **'            
P00599           DISPLAY '**    COMMIT PARM NOT NUMERIC'                
P00599           DISPLAY '**    KEY = ' WS-INPUT-KEY                    
P00599           DISPLAY '**  PROCESSING TERMINATED  **'                
P00599           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P00599           PERFORM 9900-ABEND  THRU  9900-EXIT                    
P00599        WHEN WS-COMMIT-NUM NUMERIC                                
P00599           DISPLAY ' '                                            
P00599           DISPLAY '**  PCSCA466 PROCESSING INFO  **'             
P00599           MOVE WS-COMMIT-NUM      TO WS-COMMIT-LIMIT             
P00599           DISPLAY '** COMMIT LIMIT IS ' WS-COMMIT-LIMIT          
P00599           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P00599     END-EVALUATE.                                                
P00599*                                                                 05770000
P00599 0120-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 05800000
      ******************************************************************06130000
      * 1000 - OPENS THE CURSOR, THEN FETCH THEN PROCESS THIRD PARTY   *06140000
      * LETTERS.                                                       *06150000
      ******************************************************************06160000
       1000-CURSOR-PROCESS.                                             
           MOVE '1000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 7005-OPEN-CURSOR  THRU 7005-EXIT.                    
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
      *                                                                 06220000
           PERFORM 2000-PROCESS-RECORDS   THRU 2000-EXIT                
               UNTIL END-OF-ROWS.                                       
      *                                                                 06250000
           PERFORM 7050-CLOSE-CURSOR THRU 7050-EXIT.                    
P00599     PERFORM 8898-ISSUE-CHKP        THRU 8898-EXIT.               
      *                                                                 06270000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06300000
      ******************************************************************06310000
      * 1050 - OPENS THE ANNIVERSARY CURSOR, FETCH AND PROCESS THIRD   *06320000
      * PARTY ANNIVERSARY LETTERS.                                     *06330000
      ******************************************************************06340000
       1050-ANNIV-CURSOR-PROCESS.                                       
           MOVE '1050'                       TO ACTIVE-PARAGRAPH.       
P00599     INITIALIZE WS-COMMIT-REC-CNTR.                               
                                                                        
           MOVE WS-A                  TO ZW-THD-PRTY-STATUS.            
           MOVE WS-INPUT-DATE         TO ZW-DATE-NEXT-ANNIV.            
           PERFORM 7055-OPEN-ANNIV-CURSOR  THRU 7055-EXIT.              
           PERFORM 7060-FETCH-ANNIV-CURSOR THRU 7060-EXIT.              
      *                                                                 06420000
           PERFORM 2050-PROCESS-ANNIV      THRU 2050-EXIT               
               UNTIL END-OF-ANNIV-ROWS.                                 
      *                                                                 06450000
           PERFORM 7065-CLOSE-ANNIV-CURSOR THRU 7065-EXIT.              
P00599     PERFORM 8898-ISSUE-CHKP         THRU 8898-EXIT.              
      *                                                                 06470000
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06500000
HPCCDM*EJECT                                                            06510000
      ******************************************************************06730000
      *                                                                *06740000
      *       2000-PROCESS-RECORDS.                                    *06750000
      *                                                                *06760000
      *  PROCESSES EACH RECORD TO CREATE THIRD PARTY LETTERS.          *06770000
      *                                                                *06780000
      ******************************************************************06790000
       2000-PROCESS-RECORDS.                                            
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF ZW-ACCOUNT-NO     EQUAL   AT-ACCOUNT-NO                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE ZW-ACCOUNT-NO              TO AT-ACCOUNT-NO          
              PERFORM 7000-GET-ACCOUNT-INFO       THRU 7000-EXIT        
           END-IF.                                                      
           IF  AT-COMPANY-NO NOT EQUAL WS-CURRENT-COMPANY               
               PERFORM 2328B-LOAD-ACC-DELINQ-VALUES THRU 2328B-EXIT     
           END-IF.                                                      
                                                                        
C32832     IF (AT-CODE-ACCT-STAT = WS-A OR WS-B)                        
              PERFORM 2100-PROCESS-LETTERS         THRU 2100-EXIT       
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = WS-P                               
                 MOVE ZX-DATE-TRANS               TO WS-DATE-TRANS-TS   
                 IF WS-DATE-TRANS                 < WS-DT-PENDING       
                    MOVE ZW-THD-PRTY-ID          TO ZX-THD-PRTY-ID      
                    MOVE WS-N                    TO ZX-LETTER-STATUS    
                    MOVE SPACES                  TO ZX-DATE-MAILED      
                                                    ZW-DATE-NEXT-ANNIV  
                    MOVE WS-I                    TO ZW-THD-PRTY-STATUS  
                    MOVE WS-INPUT-DATE           TO ZW-DATE-INACTIVE    
                    MOVE AT-ACCOUNT-NO           TO ZW-ACCOUNT-NO       
                    PERFORM 8100-UPD-THD-PRTY-HIST THRU 8100-EXIT       
                    PERFORM 8150-UPD-THD-PRTY      THRU 8150-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 MOVE ZW-THD-PRTY-ID             TO ZX-THD-PRTY-ID      
                 MOVE WS-N                       TO ZX-LETTER-STATUS    
                 MOVE SPACES                     TO ZX-DATE-MAILED      
                 PERFORM 8100-UPD-THD-PRTY-HIST THRU 8100-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
P00599     ADD 1                        TO WS-COMMIT-REC-CNTR.          
P00599     IF WS-COMMIT-REC-CNTR  = WS-COMMIT-LIMIT                     
P00599       ADD 1 TO WS-COMMIT-COUNTER1                                
P00599       PERFORM 8898-ISSUE-CHKP            THRU 8898-EXIT          
P00599       DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER1' TAKEN SUCESSFULLY.'
P00599       MOVE ZEROES                TO  WS-COMMIT-REC-CNTR          
P00599     END-IF.                                                      
           PERFORM 7010-FETCH-CURSOR            THRU 7010-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07210000
      *  2003-MOVE-FIELDS.                                             *07220000
      ******************************************************************07230000
       2003-MOVE-FIELDS.                                                
           MOVE '2003'                       TO ACTIVE-PARAGRAPH.       
                                                                        
P00599     INITIALIZE WS-CORRESP-NOTICE                                 
P00599                WS-CORRESP-VAR                                    
P00599                WS-KR125-COMM-DATA-VARS                           
P00599                WS-KR125-MNT-TRANS-VARS.                          
P00599     MOVE ZW-ACCOUNT-NO           TO WS-NOTICE-ACCOUNT-NO.        
P00599     MOVE ZW-THD-PRTY-ID          TO WS-CORRESP-THD-PRTY-ID.      
P00599     MOVE AT-LOCAL-OFFICE         TO WS-CWS350-LOCAL-OFFICE.      
P00599     MOVE AT-COMPANY-NO           TO WS-CORRESP-COMPANY-NO        
P00599                                     WS-PROCESS-COMPANY-NO.       
P00599     MOVE ZEROES                  TO WS-NOTICE-GUARANTOR-ACCT-NO. 
P00599     MOVE SPACES                  TO WS-CORRESP-BARCODE-UNIQUE-ID.
P00599     MOVE WS-SEB-REG-GROUP        TO WS-NOTICE-REG-GROUP-CD       
P00599     PERFORM 7200-GET-TIMESTAMP   THRU 7200-EXIT.                 
P00599     MOVE WS-CURRENT-DATE         TO WS-CORRESP-CREATE-DT.        
                                                                        
P00599     MOVE WS-JOB-PARM             TO WS-CORRESP-STMT-DT           
P00599                                     WS-COMMON-DATE.              
P00599     MOVE AT-CUSTOMER-NO          TO WS-NOTICE-CUSTOMER-NO.       
P00599     MOVE WS-PGRMNAME             TO WS-CORRESP-CREATED-BY-PGM-ID 
P00599                                  WS-CORRESP-LAST-UPDATE-PGM-ID.  
      ***************************************************************   07392000
      * THID PARTY NAME, PHONE NUMBERS                              *   07393000
      ***************************************************************   07394000
P00599     MOVE WS-B                    TO WS-TP-ADDRESS-FORMAT.        
P00599     MOVE WS-HOME-PHONE-NO        TO WS-CORRESP-TP-HOME-PHONE.    
P00599     MOVE WS-WORK-PHONE-NO        TO WS-CORRESP-TP-WORK-PHONE.    
P00599     MOVE ZW-ADDRESS-ID           TO WS-CORRESP-CC-ADDR-ID.       
P00599     MOVE ZW-NAME-ID              TO WS-CORRESP-CC-NAME-ID.       
                                                                        
P00599* MOVE VALUES TO WS-KR125-COMM-DATA-VARS                          07530100
P00599     MOVE ZW-ACCOUNT-NO           TO WS-KR125-COMM-ACCT-NO.       
P00599     MOVE ZEROES                  TO WS-KR125-PREMISE-NO.         
P00599     MOVE AT-CUSTOMER-NO          TO WS-KR125-CUSTOMER-NO.        
P00599     MOVE 'CUSTOMER ASSISTANCE'   TO WS-KR125-CONTACT-NAME        
P00599     MOVE SPACES                  TO WS-KR125-RED-FL-EXP-DT       
P00599                                     WS-KR125-CALL-END-TIME.      
P00599     MOVE 'A'                     TO WS-KR125-COMM-ASSOC-CD.      
P00599     MOVE SPACES                  TO WS-KR125-PSC-COMPL-ID.       
P00599     EVALUATE WS-CORRESP-MSG-ID                                   
P00599        WHEN '90818'                                              
P00599        WHEN '90822'                                              
P00599           MOVE 'THIRD PARTY - ADD/OPT OUT'                       
P00599                                  TO WS-KR125-COMDAT-CMT-TEXT     
P00599           MOVE 25                TO WS-KR125-COMDAT-CMT-LEN      
P00599        WHEN '90819'                                              
P00599        WHEN '90823'                                              
P00599           MOVE 'THIRD PARTY - INACTIVE'                          
P00599                                  TO WS-KR125-COMDAT-CMT-TEXT     
P00599           MOVE 22                TO WS-KR125-COMDAT-CMT-LEN      
P00599        WHEN '90820'                                              
P00599        WHEN '90824'                                              
P00599           MOVE 'THIRD PARTY - CHANGE'                            
P00599                                  TO WS-KR125-COMDAT-CMT-TEXT     
P00599           MOVE 20                TO WS-KR125-COMDAT-CMT-LEN      
P00599        WHEN '90821'                                              
P00599        WHEN '90825'                                              
P00599           MOVE 'THIRD PARTY - ANNIVERSARY'                       
P00599                                  TO WS-KR125-COMDAT-CMT-TEXT     
P00599           MOVE 25                TO WS-KR125-COMDAT-CMT-LEN      
P00599     END-EVALUATE.                                                
P00599                                                                  
P00599* MOVE VALUES TO WS-KR125-MNT-TRANS-VARS                          07540500
P00599     MOVE 'H'                     TO WS-KR125-CODE-TRAN-TYP       
P00599     MOVE WS-CURRENT-DATE         TO WS-KR125-MNT-DATE-TRANS      
P00599     MOVE SPACES                  TO WS-KR125-RESP-AREA-ID        
P00599     MOVE ZEROES                  TO WS-KR125-MNT-PREMISE-NO      
P00599                                     WS-KR125-MNT-CUSTOMER-NO     
P00599                                     WS-KR125-MNT-ACCOUNT-NO      
P00599     MOVE WS-CORRESP-STMT-DT(6:2) TO WS-HIST-DISP-MM              
P00599     MOVE WS-CORRESP-STMT-DT(9:2) TO WS-HIST-DISP-DD              
P00599     MOVE WS-CORRESP-STMT-DT(1:4) TO WS-HIST-DISP-YR              
P00599     EVALUATE WS-CORRESP-MSG-ID                                   
P00599     WHEN '90818'                                                 
P00599        MOVE ZW-ACCOUNT-NO        TO WS-KR125-MNT-ACCOUNT-NO      
P00599        STRING 'THIRD PARTY ADD - 90818'       DELIMITED BY SIZE, 
P00599               ' THIRD PARTY OPT OUT - 90822;' DELIMITED BY SIZE, 
P00599               ' MAILED: '                     DELIMITED BY SIZE, 
P00599               WS-HIST-DISP-DATE               DELIMITED BY SIZE, 
P00599               INTO                    WS-KR125-TRAN-CMT-TEXT     
P00599        MOVE +71                   TO  WS-KR125-TRAN-CMT-LEN      
P00599     WHEN '90819'                                                 
P00599        MOVE ZW-ACCOUNT-NO         TO WS-KR125-MNT-ACCOUNT-NO     
P00599        STRING 'THIRD PARTY INACTIVE - 90819;'  DELIMITED BY SIZE,
P00599               ' MAILED: '                      DELIMITED BY SIZE,
P00599               WS-HIST-DISP-DATE                DELIMITED BY SIZE,
P00599               INTO                     WS-KR125-TRAN-CMT-TEXT    
P00599        MOVE +48                   TO   WS-KR125-TRAN-CMT-LEN     
P00599     WHEN '90820'                                                 
P00599        MOVE ZW-ACCOUNT-NO        TO WS-KR125-MNT-ACCOUNT-NO      
P00599        STRING 'THIRD PARTY CHANGE - 90820;'    DELIMITED BY SIZE,
P00599               ' MAILED: '                      DELIMITED BY SIZE,
P00599               WS-HIST-DISP-DATE                DELIMITED BY SIZE,
P00599               INTO                     WS-KR125-TRAN-CMT-TEXT    
P00599       MOVE +46                   TO   WS-KR125-TRAN-CMT-LEN      
P00599     WHEN '90821'                                                 
P00599        MOVE ZW-ACCOUNT-NO        TO WS-KR125-MNT-ACCOUNT-NO      
P00599      STRING 'THIRD PARTY ANNIVERSARY - 90821;' DELIMITED BY SIZE,
P00599              ' MAILED: '                       DELIMITED BY SIZE,
P00599              WS-HIST-DISP-DATE                 DELIMITED BY SIZE,
P00599              INTO                     WS-KR125-TRAN-CMT-TEXT     
P00599       MOVE +51                   TO   WS-KR125-TRAN-CMT-LEN      
P00599     END-EVALUATE.                                                
       2003-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07560000
      *                                                                *07570000
      *       2050-PROCESS-ANNIV.                                      *07580000
      *                                                                *07590000
      *  PROCESSES EACH RECORD TO CREATE THIRD PARTY ANNIVERSARY       *07600000
      *  LETTERS.                                                      *07610000
      ******************************************************************07620000
       2050-PROCESS-ANNIV.                                              
           MOVE '2050'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF ZW-ACCOUNT-NO     EQUAL   AT-ACCOUNT-NO                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE ZW-ACCOUNT-NO              TO AT-ACCOUNT-NO          
              PERFORM 7000-GET-ACCOUNT-INFO       THRU 7000-EXIT        
           END-IF.                                                      
           IF  AT-COMPANY-NO NOT EQUAL WS-CURRENT-COMPANY               
               PERFORM 2328B-LOAD-ACC-DELINQ-VALUES THRU 2328B-EXIT     
           END-IF.                                                      
                                                                        
           IF AT-CODE-ACCT-STAT = WS-A                                  
              MOVE WS-V                      TO ZX-LETTER-TYPE-CD       
              PERFORM 2100-PROCESS-LETTERS         THRU 2100-EXIT       
           END-IF.                                                      
                                                                        
P00599     ADD 1                        TO WS-COMMIT-REC-CNTR.          
P00599     IF WS-COMMIT-REC-CNTR  = WS-COMMIT-LIMIT                     
P00599       ADD 1 TO WS-COMMIT-COUNTER2                                
P00599       PERFORM 8898-ISSUE-CHKP               THRU  8898-EXIT      
P00599       DISPLAY 'COMMIT # ' WS-COMMIT-COUNTER2' TAKEN SUCESSFULLY.'
P00599       MOVE ZEROES                TO  WS-COMMIT-REC-CNTR          
P00599     END-IF.                                                      
           PERFORM 7060-FETCH-ANNIV-CURSOR         THRU 7060-EXIT.      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07860000
      *                                                                *07870000
      *       2100-PROCESS-LETTERS.                                    *07880000
      *                                                                *07890000
      *  PROCESSES EACH RECORD TO CREATE THIRD PARTY LETTERS.          *07900000
      *                                                                *07910000
      ******************************************************************07920000
       2100-PROCESS-LETTERS.                                            
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE ZW-ACCOUNT-NO              TO LR-ACCOUNT-NO.            
           PERFORM 2119-THD-PRTY-PHONE     THRU 2119-EXIT.              
           PERFORM 7440-SELECT-REG-PROFILE THRU 7440-EXIT.              
           PERFORM 2800-UPD-LETTER-FILE   THRU 2800-EXIT.               
           PERFORM 2900-MOVE-TP-FIELDS    THRU 2900-EXIT.               
      *                                                                 08210000
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08250000
      * 2119-THD-PRTY-PHONE                                            *08260000
      ******************************************************************08270000
        2119-THD-PRTY-PHONE.                                            
           MOVE '2119'                    TO ACTIVE-PARAGRAPH.          
           MOVE ZW-THD-PRTY-ID            TO ZY-THD-PRTY-ID.            
           MOVE WS-WORK-PHONE             TO ZY-PHONE-TYPE.             
           PERFORM 7114-SELECT-THDPRTY-PHONE       THRU 7114-EXIT.      
           MOVE ZY-PHONE-NO               TO WS-WORK-PHONE-NO.          
           MOVE WS-HOME-PHONE             TO ZY-PHONE-TYPE.             
           PERFORM 7114-SELECT-THDPRTY-PHONE       THRU 7114-EXIT.      
           MOVE ZY-PHONE-NO               TO WS-HOME-PHONE-NO.          
       2119-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08390000
      ***************************************************************** 08400000
      * LOAD DELINQUENCY LIMITS INTO WORKING STORAGE                  * 08410000
      ***************************************************************** 08420000
                                                                        
       2328-LOAD-DELINQ-VALUE.                                          
           MOVE '2328'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE C8-DELINQ-CD    TO WS-VARIABLE-ID.                      
           MOVE C8-DELINQ-VALUE TO WS-VARIABLE-VALUE.                   
           MOVE C8-COMPANY-NO   TO  WS-DELINQ-COMPANY.                  
           EVALUATE WS-VARIABLE-ID                                      
               WHEN WS-DN-ANNIV-REV                                     
                   PERFORM 7334-GET-NEXT-ANNIV    THRU 7334-EXIT        
               WHEN WS-DN-PENDING                                       
                   PERFORM 7340-CALC-PENDING-DATE THRU 7340-EXIT        
           END-EVALUATE.                                                
           PERFORM 2328A-LOAD-TABLE-ENTRY THRU 2328A-EXIT.              
                                                                        
           PERFORM 7329-FETCH-DELINQ THRU                               
                   7329-FETCH-DELINQ-EXIT.                              
                                                                        
           IF  C8-COMPANY-NO NOT EQUAL WS-DELINQ-COMPANY                
               SET TB-CO-INDEX  UP BY 1                                 
               SET TB-VAL-INDEX TO 1                                    
           END-IF.                                                      
                                                                        
       2328-LOAD-DELINQ-EXIT.                                           
           EXIT.                                                        
      *                                                                 08680000
      ***************************************************************** 08690000
      * LOAD CSS_DELIQUENCY VALUES INTO WORKING STORAGE TABLE         * 08700000
      ***************************************************************** 08710000
      *                                                                 08720000
       2328A-LOAD-TABLE-ENTRY.                                          
           MOVE '2328A'                      TO ACTIVE-PARAGRAPH.       
           MOVE WS-DELINQ-COMPANY TO                                    
               WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX).        
           MOVE WS-VARIABLE-ID TO                                       
               WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX).           
           MOVE WS-VARIABLE-VALUE TO                                    
               WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX).          
           EVALUATE WS-VARIABLE-ID                                      
               WHEN WS-DN-ANNIV-REV                                     
                   MOVE WS-DT-NEXTANN TO                                
                       WS-DELINQ-NEXTANN-TB (TB-CO-INDEX, TB-VAL-INDEX) 
               WHEN WS-DN-PENDING                                       
                   MOVE WS-DT-PENDING TO                                
                       WS-DELINQ-PENDING-TB (TB-CO-INDEX, TB-VAL-INDEX) 
           END-EVALUATE.                                                
           SET TB-VAL-INDEX UP BY 1.                                    
      *                                                                 08900000
       2328A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 08930000
      ***************************************************************** 08940000
      * LOADS DELINQUENCY VALUES FROM WORKING STORAGE TABLE TO        * 08950000
      * DELINQUENCY VARIABLES WHEN COMPANY NO CHANGES                 * 08960000
      ***************************************************************** 08970000
       2328B-LOAD-ACC-DELINQ-VALUES.                                    
           MOVE '2328B'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           SET TB-CO-INDEX TO 1.                                        
           SET TB-VAL-INDEX TO 1.                                       
                                                                        
           PERFORM UNTIL                                                
             AT-COMPANY-NO EQUAL                                        
             WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)           
             OR TB-CO-INDEX > 5                                         
            OR WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX) = SPACES
                                                                        
               IF  AT-COMPANY-NO EQUAL                                  
                   WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX)     
                   NEXT SENTENCE                                        
               ELSE                                                     
                   SET TB-CO-INDEX UP BY 1                              
               END-IF                                                   
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 2328C-INIT-DELINQ-VAL  THRU 2328C-EXIT.              
           PERFORM 2328D-LOAD-DW-VARIABLE THRU 2328D-EXIT               
              UNTIL TB-VAL-INDEX > 2                                    
              OR  WS-DELINQ-COMPANY-TB (TB-CO-INDEX, TB-VAL-INDEX) =    
              SPACES.                                                   
           PERFORM 2328E-VERIFY-DW-VARIABLES THRU 2328E-EXIT.           
                                                                        
           MOVE AT-COMPANY-NO TO WS-CURRENT-COMPANY.                    
                                                                        
       2328B-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09300000
      ******************************************************************09310000
      * INITIALIZES ALL DELINQUENCY VARIABLES                          *09320000
      ******************************************************************09330000
       2328C-INIT-DELINQ-VAL.                                           
           MOVE '2328C'                      TO ACTIVE-PARAGRAPH.       
           INITIALIZE WS-ANNIV-REV                                      
                      WS-PENDING.                                       
       2328C-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09400000
      ***************************************************************** 09410000
      *  THIS PARA LOADS THE OCCURENCE FOR THAT COMPANY-NO INTO THE   * 09420000
      *  WORKING STORAGE DELIQUENCY FIELDS                            * 09430000
      ***************************************************************** 09440000
       2328D-LOAD-DW-VARIABLE.                                          
           MOVE '2328D'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           EVALUATE WS-DELINQ-CODE-TB (TB-CO-INDEX, TB-VAL-INDEX)       
              WHEN WS-DN-ANNIV-REV                                      
                  MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)   
                     TO WS-ANNIV-REV                                    
                  MOVE WS-DELINQ-NEXTANN-TB (TB-CO-INDEX, TB-VAL-INDEX) 
                     TO WS-DT-NEXTANN                                   
                 SET TB-VAL-INDEX UP BY 1                               
              WHEN WS-DN-PENDING                                        
                  MOVE WS-DELINQ-VALUE-TB (TB-CO-INDEX, TB-VAL-INDEX)   
                     TO WS-PENDING                                      
                  MOVE WS-DELINQ-PENDING-TB (TB-CO-INDEX, TB-VAL-INDEX) 
                     TO WS-DT-PENDING                                   
                 SET TB-VAL-INDEX UP BY 1                               
           END-EVALUATE.                                                
      *                                                                 09620000
       2328D-EXIT.                                                      
           EXIT.                                                        
      *                                                                 09650000
      ***************************************************************** 09660000
      *  THIS PARA CHECKS WHETHER ALL DELINQUENCY VALUES ARE POSITIVE   09670000
      *  IN THE TABLE ITSELF.                                           09680000
      ***************************************************************** 09690000
       2328E-VERIFY-DW-VARIABLES.                                       
           MOVE '2328E'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           IF        WS-ANNIV-REV                     > ZERO            
                 AND WS-PENDING                       > ZERO            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      2328E-VERIFY-DW-VARIABLES       *'        
              DISPLAY '* COMPANY NO     : ' AT-COMPANY-NO               
              DISPLAY '* WS-ANNIV-REV   : ' WS-ANNIV-REV                
              DISPLAY '* WS-PENDING     : ' WS-PENDING                  
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       2328E-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************10150000
      *  UPDATE FIORP000 SO THIRD PARTY LETTER CAN BE PRINTED          *10160000
      ******************************************************************10170000
       2800-UPD-LETTER-FILE.                                            
P00599     MOVE '2800'                       TO ACTIVE-PARAGRAPH.       
                                                                        
P00599     INITIALIZE WS-CORRESP-HDR.                                   
           EVALUATE ZX-LETTER-TYPE-CD                                   
           WHEN WS-A                                                    
P00599        MOVE 90818                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
P00599        MOVE 90822                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
           WHEN WS-C                                                    
P00599        MOVE 90820                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
P00599        MOVE 90824                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
           WHEN WS-I                                                    
P00599        MOVE 90819                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
P00599        MOVE 90823                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
           WHEN WS-V                                                    
P00599        MOVE 90821                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
P00599        MOVE 90825                   TO WS-CORRESP-MSG-ID         
P00599        PERFORM 2003-MOVE-FIELDS        THRU 2003-EXIT            
P00599        PERFORM 5000-CALL-NOTICES       THRU 5000-EXIT            
           END-EVALUATE.                                                
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11142100
      *2900-MOVE-TP-FIELDS.                                           * 11142200
      * MOVE TP FIELD FOR INSERT OR UPDATE                            * 11143000
      ***************************************************************** 11150000
                                                                        
       2900-MOVE-TP-FIELDS.                                             
           MOVE '3000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE ZW-THD-PRTY-ID             TO ZX-THD-PRTY-ID.           
           MOVE WS-INPUT-DATE              TO ZX-DATE-MAILED.           
           MOVE WS-M                       TO ZX-LETTER-STATUS.         
           IF ZX-LETTER-TYPE-CD           = WS-V                        
              MOVE WS-DT-NEXTANN           TO ZW-DATE-NEXT-ANNIV        
              PERFORM 8150-UPD-THD-PRTY      THRU 8150-EXIT             
              MOVE WS-SYSTEM               TO ZX-USER-ID                
              PERFORM 8250-INS-THD-PRTY-HIST THRU 8250-EXIT             
           ELSE                                                         
              PERFORM 8150-UPD-THD-PRTY      THRU 8150-EXIT             
              PERFORM 8100-UPD-THD-PRTY-HIST THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
P00599******************************************************************11771000
P00599* 5000-CALL-NOTICES                                               11772000
P00599******************************************************************11773000
P00599*                                                                 11774000
P00599 5000-CALL-NOTICES.                                               
P00599                                                                  
P00599     CALL SCSKR125 USING   WS-CORRESP-HDR                         
P00599                           WS-CORRESP-NOTICE                      
P00599                           WS-CORRESP-VAR                         
P00599                           WS-MISC-PROCESSING-VARS                
P00599                           WS-KR125-COMM-DATA-VARS                
P00599                           WS-KR125-MNT-TRANS-VARS                
P00599                           ABEND-FILE                             
P00599                           WS-CWS350-MISC                         
P00599                           WS-CORRESP-COMM-VAR                    
P00599                           RS-KR125-RETURN-CODE.                  
P00599                                                                  
P00599     IF ABEND-FUNCTION  > SPACES                                  
P00599        MOVE ABEND-SQLCODE             TO RS-RETURN-CODE          
P00599                                          WS-ACTIVE-RETURN-CODE   
P00599        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00599     END-IF.                                                      
P00599                                                                  
P00599 5000-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 11790000
      ***************************************************************** 11850000
      ** 6240-GET-FCA00-COMMON-DATE                                     11860000
      ***************************************************************** 11870000
                                                                        
           EXEC SQL                                                     11890000
                INCLUDE CPD00040                                        11900000
           END-EXEC.                                                    11910000
                                                                        
      ***************************************************************** 11930000
      ** 6251-GET-FJC01-DATE                                         ** 11940000
      ***************************************************************** 11950000
                                                                        
           EXEC SQL                                                     11970000
                INCLUDE CPD00037                                        11980000
           END-EXEC.                                                    11990000
                                                                        
           EXEC SQL                                                     12090000
                INCLUDE CPD00038                                        12100000
           END-EXEC.                                                    12110000
      *                                                                 12120000
           EXEC SQL                                                     12130000
                INCLUDE CPD00039                                        12140000
           END-EXEC.                                                    12150000
      *                                                                 12160000
      ******************************************************************12250000
      * 7000-GET-ACCOUNT-INFO.                                         *12270000
      ******************************************************************12280000
       7000-GET-ACCOUNT-INFO.                                           
           MOVE '7000'                       TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.BILL_CYCLE                                      
                    ,AT.ADDRESS_FORMAT                                  
                    ,AT.CODE_ACCT_STAT                                  
               INTO :AT-ADDRESS-ID                                      
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:AT-CODE-ACCT-STAT                                  
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                      
C35584                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12310000
MFA-TR*       SELECT AT.ADDRESS_ID                                      12320000
MFA-TR*             ,AT.CUSTOMER_NO                                     12330000
MFA-TR*             ,AT.COMPANY_NO                                      12340000
MFA-TR*             ,AT.LOCAL_OFFICE                                    12350000
MFA-TR*             ,AT.BILL_CYCLE                                      12360000
MFA-TR*             ,AT.ADDRESS_FORMAT                                  12370000
MFA-TR*             ,AT.CODE_ACCT_STAT                                  12380000
MFA-TR*        INTO :AT-ADDRESS-ID                                      12390000
MFA-TR*            ,:AT-CUSTOMER-NO                                     12400000
MFA-TR*            ,:AT-COMPANY-NO                                      12410000
MFA-TR*            ,:AT-LOCAL-OFFICE                                    12420000
MFA-TR*            ,:AT-BILL-CYCLE                                      12430000
MFA-TR*            ,:AT-ADDRESS-FORMAT                                  12440000
MFA-TR*            ,:AT-CODE-ACCT-STAT                                  12450000
MFA-TR*        FROM CSS_ACCOUNT AT                                      12460000
MFA-TR*       WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                      12470000
MFA-TR*      WITH UR                                                    12480000
MFA-TR*      QUERYNO 7000                                               12481000
MFA-TR*    END-EXEC.                                                    12490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7000-GET-ACCOUNT-INFO           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 12640000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12670000
      ******************************************************************12680000
      * 7005-OPEN-CURSOR                                               *12690000
      *  OPENS THE CURSOR FOR PROCESSING                               *12700000
      *                                                                *12710000
      ******************************************************************12720000
       7005-OPEN-CURSOR.                                                
           MOVE '7005'                       TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
              OPEN THDPRTY_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7005-OPEN-CURSOR                *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 12900000
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12930000
      ******************************************************************12940000
      *                                                                *12950000
      *   7010-FETCH-CURSOR.                                           *12960000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *12970000
      *                                                                *12980000
      ******************************************************************12990000
       7010-FETCH-CURSOR.                                               
           MOVE '7010'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               FETCH THDPRTY_CSR                                        
               INTO :ZW-THD-PRTY-ID,                                    
                    :ZW-ACCOUNT-NO,                                     
                    :ZW-ADDRESS-ID,                                     
                    :ZW-DATE-CREATED :WS-NULL-IND1,                      
                    :ZW-DATE-INACTIVE :WS-NULL-IND2,                     
                    :ZW-DATE-NEXT-ANNIV :WS-NULL-IND3,                   
                    :ZW-NAME-ID,                                        
                    :ZW-THD-PRTY-STATUS,                                
                    :ZX-LETTER-STATUS,                                  
                    :ZX-LETTER-TYPE-CD,                                 
                    :ZX-DATE-TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES            TO ZW-DATE-CREATED             
               END-IF                                                   
               IF WS-NULL-IND2 = -1                                     
                  MOVE SPACES            TO ZW-DATE-INACTIVE            
               END-IF                                                   
               IF WS-NULL-IND3 = -1                                     
                  MOVE SPACES            TO ZW-DATE-NEXT-ANNIV          
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'Y' TO WS-END-OF-ROWS                           
               ELSE                                                     
                   DISPLAY '********** PCSCA466 ABORT **************'   
                   DISPLAY '*      7010-FETCH-CURSOR               *'   
                   DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE  
                   DISPLAY '* ZW THD PRTY ID : ' ZW-THD-PRTY-ID         
                   DISPLAY '* ZW ACCOUNT NO  : ' ZW-ACCOUNT-NO          
                   DISPLAY '* PROGRAM ABORTING...                  *'   
                   DISPLAY '********** PCSCA466 ABORT **************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 13440000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13470000
      ******************************************************************13480000
      *   7050-CLOSE-CURSOR.                                           *13490000
      *        CLOSES THE OPENED CURSOR                                *13500000
      ******************************************************************13510000
       7050-CLOSE-CURSOR.                                               
           MOVE '7050'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               CLOSE THDPRTY_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA466 ABORT **************'       
               DISPLAY '*      7050-CLOSE-CURSOR               *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* ZW THD PRTY ID : ' ZW-THD-PRTY-ID             
               DISPLAY '* ZW ACCOUNT NO  : ' ZW-ACCOUNT-NO              
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA466 ABORT **************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13760000
      ******************************************************************13770000
      * 7055-OPEN-ANNIV-CUROSR                                         *13780000
      *  OPENS THE CURSOR FOR ANNIVERSARY PROCESSING                   *13790000
      *                                                                *13800000
      ******************************************************************13810000
       7055-OPEN-ANNIV-CURSOR.                                          
           MOVE '7055'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 13840000
           EXEC SQL                                                     
              OPEN ANNIV_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA466 ABORT **************'       
               DISPLAY '*      7055-OPEN-ANNIV-CURSOR          *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* ZW THD PRTY ID : ' ZW-THD-PRTY-ID             
               DISPLAY '* ZW ACCOUNT NO  : ' ZW-ACCOUNT-NO              
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA466 ABORT **************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 14020000
       7055-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14050000
      ******************************************************************14060000
      *                                                                *14070000
      *   7060-FETCH-ANNIV-CUROSR.                                     *14080000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *14090000
      *                                                                *14100000
      ******************************************************************14110000
       7060-FETCH-ANNIV-CURSOR.                                         
           MOVE '7060'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               FETCH ANNIV_CSR                                          
               INTO :ZW-THD-PRTY-ID,                                    
                    :ZW-ACCOUNT-NO,                                     
                    :ZW-ADDRESS-ID,                                     
                    :ZW-DATE-CREATED :WS-NULL-IND1,                      
                    :ZW-DATE-INACTIVE :WS-NULL-IND2,                     
                    :ZW-DATE-NEXT-ANNIV :WS-NULL-IND3,                   
                    :ZW-NAME-ID,                                        
                    :ZW-THD-PRTY-STATUS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES            TO ZW-DATE-CREATED             
               END-IF                                                   
               IF WS-NULL-IND2 = -1                                     
                  MOVE SPACES            TO ZW-DATE-INACTIVE            
               END-IF                                                   
               IF WS-NULL-IND3 = -1                                     
                  MOVE SPACES            TO ZW-DATE-NEXT-ANNIV          
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'Y' TO WS-END-OF-ANNIV-ROWS                     
               ELSE                                                     
                   DISPLAY '********** PCSCA466 ABORT **************'   
                   DISPLAY '7060-FETCH-ANNIV-CURSOR'                    
                   DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                   DISPLAY 'ZW-ACCOUNT-NO = ' ZW-ACCOUNT-NO             
                   DISPLAY 'ZW THD PRTY ID : ' ZW-THD-PRTY-ID           
                   DISPLAY '* PROGRAM ABORTING...                  *'   
                   DISPLAY '********** PCSCA466 ABORT **************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 14530000
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14560000
      ******************************************************************14570000
      *   7065-CLOSE-ANNIV-CURSOR                                      *14580000
      *        CLOSES THE OPENED CURSOR                                *14590000
      ******************************************************************14600000
       7065-CLOSE-ANNIV-CURSOR.                                         
           MOVE '7065'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               CLOSE ANNIV_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA466 ABORT **************'       
               DISPLAY '7065-CLOSE-ANNIV-CURSOR'                        
               DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY 'ZW-ACCOUNT-NO = ' ZW-ACCOUNT-NO                 
               DISPLAY 'ZW THD PRTY ID : ' ZW-THD-PRTY-ID               
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA466 ABORT **************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7065-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15180000
      *  7114 SELECT THDPRTY PHONE                                     *15190000
      ******************************************************************15200000
       7114-SELECT-THDPRTY-PHONE.                                       
           MOVE '7114'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE SPACES TO ZY-PHONE-NO.                                  
           EXEC SQL                                                     
              SELECT                                                    
                  PHONE_NO                                              
              INTO                                                      
                  :ZY-PHONE-NO                                          
              FROM CSS_THD_PRTY_PHONE WITH(READUNCOMMITTED)                     
              WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                       
              AND   PHONE_TYPE  = :ZY-PHONE-TYPE                        
C35584                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15250000
MFA-TR*       SELECT                                                    15260000
MFA-TR*           PHONE_NO                                              15270000
MFA-TR*       INTO                                                      15280000
MFA-TR*           :ZY-PHONE-NO                                          15290000
MFA-TR*       FROM CSS_THD_PRTY_PHONE                                   15300000
MFA-TR*       WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                       15310000
MFA-TR*       AND   PHONE_TYPE  = :ZY-PHONE-TYPE                        15320000
MFA-TR*       WITH UR                                                   15330000
MFA-TR*       QUERYNO 7114                                              15331000
MFA-TR*    END-EXEC.                                                    15340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** PARA 7114 **'                                 
              DISPLAY '** THD_PRTY_PHONE TABLE **'                      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** THD PRTY ID = ' ZY-THD-PRTY-ID                
              DISPLAY '** PHONE TYPE = ' ZY-PHONE-TYPE                  
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7114-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599******************************************************************15531001
P00599* 7150-SELECT-DELINQ-VALUE                                       *15532001
P00599* SELECTS THE DELINQUENCY VALUE FOR THE GIVEN DELINQ CODE        *15533001
P00599******************************************************************15534001
P00599 7150-SELECT-DELINQ-VALUE.                                        
P00599*                                                                 15536001
P00599     EXEC SQL                                                     
P00599        SELECT DELINQ_VALUE                                       
P00599          INTO :C8-DELINQ-VALUE                                   
P00599          FROM CSS_DELINQUENCY                                    
P00599         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P00599           AND COMPANY_NO = :C8-COMPANY-NO                        
P00599                                                      
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     15537001
MFA-TR*       SELECT DELINQ_VALUE                                       15538001
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15539001
MFA-TR*         FROM CSS_DELINQUENCY                                    15539101
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         15539201
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                        15539301
MFA-TR*      QUERYNO 7150                                               15539401
MFA-TR*    END-EXEC.                                                    15539501

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                 15539601
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY '********** PCSCA466 ABORT **************'        
P00599        DISPLAY '* 7150-SELECT-DELINQ-VALUE             *'        
P00599        DISPLAY '* DELINQ CD ', C8-DELINQ-CD                      
P00599        DISPLAY '* COMPANY NO', C8-COMPANY-NO                     
P00599        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00599        DISPLAY '* PROGRAM ABORTING...                  *'        
P00599        DISPLAY '********** PCSCA466 ABORT **************'        
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                 15541001
P00599 7150-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 15541301
      ******************************************************************15542000
      *        GET TIMESTAMP FOR MNT_TRANS_HIST FILE                   *15550000
      ******************************************************************15560000
       7200-GET-TIMESTAMP.                                              
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TIMESTAMP,
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15600000
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                    15610000
MFA-TR*          ,: WS-CURRENT-DATE = CURRENT DATE                      15611000
MFA-TR*    END-EXEC.                                                    15620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7200-SELECT-TIMESTAMP        **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                  
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
       7329-OPEN-DELINQ.                                                
           MOVE '7329'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DECLARE DELINQUENCY_CSR CURSOR FOR                        
              SELECT                                                    
                 DELINQ_VALUE,                                          
                 DELINQ_CD,                                             
                 COMPANY_NO                                             
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
              WHERE DELINQ_CD    IN ('THD-PRTY-ANNIV-REV ' ,            
                                     'THD-PRTY-PENDING   ')             
              ORDER BY COMPANY_NO,                                      
                       DELINQ_CD                                        
C35584                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15830000
MFA-TR*       DECLARE DELINQUENCY_CSR CURSOR FOR                        15840000
MFA-TR*       SELECT                                                    15850000
MFA-TR*          DELINQ_VALUE,                                          15860000
MFA-TR*          DELINQ_CD,                                             15870000
MFA-TR*          COMPANY_NO                                             15880000
MFA-TR*       FROM CSS_DELINQUENCY                                      15890000
MFA-TR*       WHERE DELINQ_CD    IN ('THD-PRTY-ANNIV-REV ' ,            15900000
MFA-TR*                              'THD-PRTY-PENDING   ')             15910000
MFA-TR*       ORDER BY COMPANY_NO,                                      15920000
MFA-TR*                DELINQ_CD                                        15930000
MFA-TR*       WITH UR                                                   15940000
MFA-TR*       QUERYNO 7329                                              15941000
MFA-TR*    END-EXEC.                                                    15950000
                                                                        
           EXEC SQL                                                     
                OPEN DELINQUENCY_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7329-OPEN-DELINQ                *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* DELINQ VALUE   : ' C8-DELINQ-VALUE             
              DISPLAY '* DELINQ CD      : ' C8-DELINQ-CD                
              DISPLAY '* COMPANY NO     : ' C8-COMPANY-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7329-OPEN-DELINQ-EXIT.                                           
           EXIT.                                                        
                                                                        
       7329-FETCH-DELINQ.                                               
           MOVE '7329'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              FETCH DELINQUENCY_CSR                                     
              INTO                                                      
                 :C8-DELINQ-VALUE,                                      
                 :C8-DELINQ-CD,                                         
                 :C8-COMPANY-NO                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7329-FETCH-DELINQ               *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* DELINQ VALUE   : ' C8-DELINQ-VALUE             
              DISPLAY '* DELINQ CD      : ' C8-DELINQ-CD                
              DISPLAY '* COMPANY NO     : ' C8-COMPANY-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7329-FETCH-DELINQ-EXIT.                                          
           EXIT.                                                        
                                                                        
       7329-CLOSE-DELINQ.                                               
           MOVE '7329'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
                CLOSE DELINQUENCY_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7329-CLOSE-DELINQ               *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* DELINQ VALUE   : ' C8-DELINQ-VALUE             
              DISPLAY '* DELINQ CD      : ' C8-DELINQ-CD                
              DISPLAY '* COMPANY NO     : ' C8-COMPANY-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7329-CLOSE-DELINQ-EXIT.                                          
           EXIT.                                                        
                                                                        
       7334-GET-NEXT-ANNIV.                                             
           MOVE '7334'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
C34097        SELECT
              DATEADD( MONTH, :WS-VARIABLE-VALUE, IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-DT-NEXTANN   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     16750000
MFA-TR*       SET :WS-DT-NEXTANN =                                      16760000
MFA-TR*              DATE(:WS-INPUT-DATE) + :WS-VARIABLE-VALUE MONTHS   16770000
MFA-TR*    END-EXEC.                                                    16780000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7334-GET-NEXT-ANNIV             *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7334-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16950000
      * GET NEXT ANNIVERSARY DATE BASED ON DELINQUENCY VALUE.         * 16960000
      * 7340-CALCULATE THE # OF DAYS PENDING.                         * 16970000
      ***************************************************************** 16980000
                                                                        
       7340-CALC-PENDING-DATE.                                          
           MOVE '7340'                       TO ACTIVE-PARAGRAPH.       
           EXEC SQL                                                     
C34097        SELECT
              DATEADD( MONTH, -:WS-VARIABLE-VALUE, 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-DT-PENDING   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     17020000
MFA-TR*       SET :WS-DT-PENDING =                                      17030000
MFA-TR*              DATE(:WS-INPUT-DATE) - :WS-VARIABLE-VALUE MONTHS   17040000
MFA-TR*    END-EXEC.                                                    17050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA466 ABORT **************'        
              DISPLAY '*      7340-CALC-PENDING-DATE          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA466 ABORT **************'        
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      17220000
      **  7440-SELECT-REG-PROFILE.                              **      17230000
      **      TO CHECK WHETHER THE ACCT IS SEBR ACCOUNT         **      17240000
      ************************************************************      17250000
       7440-SELECT-REG-PROFILE.                                         
      *                                                                 17270000
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
C35584                                                           
A03866                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17280000
MFA-TR*        SELECT REG_GROUP_CD                                      17290000
MFA-TR*          INTO :LR-REG-GROUP-CD                                  17300000
MFA-TR*          FROM CSS_REG_PROFILE                                   17310000
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       17320000
MFA-TR*       WITH UR                                                   17330000
MFA-TR*       QUERYNO 7440                                              17331000
MFA-TR*    END-EXEC.                                                    17340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE LR-REG-GROUP-CD   TO WS-SEB-REG-GROUP           
              WHEN NOT-FOUND                                            
                   MOVE SPACES            TO WS-SEB-REG-GROUP           
              WHEN OTHER                                                
                   DISPLAY '** PCSCA466 PROCESSING ERROR       **'      
                   DISPLAY '** SELECT ERROR ON REG PROFILE     **'      
                   DISPLAY '** 7440-SELECT-REG-PROFILE         **'      
                   DISPLAY '** ACCOUNT IS  ** ' LR-ACCOUNT-NO           
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED           **'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
      *                                                                 17510000
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17540000
      ******************************************************************17850000
      *  UPDATE CSS_THD_PRTY_HIST TABLE                                *17860000
      ******************************************************************17870000
       8100-UPD-THD-PRTY-HIST.                                          
           MOVE '8100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF ZX-DATE-MAILED = SPACES OR = LOW-VALUES                   
              MOVE -1                  TO WS-NULL-IND4                  
           ELSE                                                         
              MOVE 0                   TO WS-NULL-IND4                  
           END-IF                                                       
           EXEC SQL                                                     
               UPDATE CSS_THD_PRTY_HIST                                 
                 SET DATE_MAILED       = IIF(TRY_CONVERT(DATE, 
                                                       :ZX-DATE-MAILED 
                                                          :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :ZX-DATE-MAILED 
                                                          :WS-NULL-IND4
              ) <> 0) OR (LEN(:ZX-DATE-MAILED :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:ZX-DATE-MAILED :WS-NULL-IND4
              ), CONVERT(DATE, :ZX-DATE-MAILED :WS-NULL-IND4) ),  
                     LETTER_STATUS     = :ZX-LETTER-STATUS              
                 WHERE THD_PRTY_ID     = :ZX-THD-PRTY-ID                
                   AND DATE_TRANS      = CIS.CHAR2TIMESTAMP(
                                                         :ZX-DATE-TRANS
              )                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*        UPDATE CSS_THD_PRTY_HIST                                 17970000
MFA-TR*          SET DATE_MAILED       = :ZX-DATE-MAILED:WS-NULL-IND4,  17980000
MFA-TR*              LETTER_STATUS     = :ZX-LETTER-STATUS              17990000
MFA-TR*          WHERE THD_PRTY_ID     = :ZX-THD-PRTY-ID                18000000
MFA-TR*            AND DATE_TRANS      = :ZX-DATE-TRANS                 18010000
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8100-UPD-THD-PRTY-HIST'                       
               DISPLAY '* ACCOUNT_NO = ' ZW-ACCOUNT-NO                  
               DISPLAY '* THD PRTY ID = ' ZX-THD-PRTY-ID                
               DISPLAY '* DATE TRANS    ' ZX-DATE-TRANS                 
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18210000
      ******************************************************************18220000
      *  UPDATE CSS_THD_PRTY      TABLE                                *18230000
      ******************************************************************18240000
       8150-UPD-THD-PRTY.                                               
           MOVE '8150'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF  ZW-DATE-INACTIVE    = SPACES OR = LOW-VALUES             
               MOVE -1        TO WS-NULL-IND5                           
           ELSE                                                         
               MOVE 0         TO WS-NULL-IND5                           
           END-IF.                                                      
           IF  ZW-DATE-NEXT-ANNIV  = SPACES OR = LOW-VALUES             
               MOVE -1        TO WS-NULL-IND6                           
           ELSE                                                         
               MOVE 0         TO WS-NULL-IND6                           
           END-IF.                                                      
           EXEC SQL                                                     
               UPDATE CSS_THD_PRTY                                      
                 SET DATE_INACTIVE    = IIF(TRY_CONVERT(DATE, 
                                                     :ZW-DATE-INACTIVE 
                                                          :WS-NULL-IND5
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-INACTIVE 
                                                          :WS-NULL-IND5
              ) <> 0) OR (LEN(:ZW-DATE-INACTIVE :WS-NULL-IND5
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-INACTIVE :WS-NULL-IND5
              ), CONVERT(DATE, :ZW-DATE-INACTIVE :WS-NULL-IND5) ), 
                     THD_PRTY_STATUS  = :ZW-THD-PRTY-STATUS,            
                     DATE_NEXT_ANNIV  = IIF(TRY_CONVERT(DATE, 
                                                   :ZW-DATE-NEXT-ANNIV 
                                                          :WS-NULL-IND6
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-NEXT-ANNIV 
                                                          :WS-NULL-IND6
              ) <> 0) OR (LEN(:ZW-DATE-NEXT-ANNIV :WS-NULL-IND6
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-NEXT-ANNIV :WS-NULL-IND6
              ), CONVERT(DATE, :ZW-DATE-NEXT-ANNIV :WS-NULL-IND6) )
                 WHERE THD_PRTY_ID    = :ZW-THD-PRTY-ID                 
                   AND ACCOUNT_NO     = :ZW-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18380000
MFA-TR*        UPDATE CSS_THD_PRTY                                      18390000
MFA-TR*          SET DATE_INACTIVE    = :ZW-DATE-INACTIVE:WS-NULL-IND5, 18400000
MFA-TR*              THD_PRTY_STATUS  = :ZW-THD-PRTY-STATUS,            18410000
MFA-TR*              DATE_NEXT_ANNIV  = :ZW-DATE-NEXT-ANNIV:WS-NULL-IND618420000
MFA-TR*          WHERE THD_PRTY_ID    = :ZW-THD-PRTY-ID                 18430000
MFA-TR*            AND ACCOUNT_NO     = :ZW-ACCOUNT-NO                  18440000
MFA-TR*    END-EXEC.                                                    18450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8150-UPD-THD-PRTY'                            
               DISPLAY '* ACCOUNT_NO = ' ZW-ACCOUNT-NO                  
               DISPLAY '* THD PRTY ID = ' ZW-THD-PRTY-ID                
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************19180000
      *  INSERT CSS_THD_PRTY_HIST TABLE                                *19190000
      ******************************************************************19200000
       8250-INS-THD-PRTY-HIST.                                          
           MOVE '8250'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           IF ZX-DATE-MAILED = SPACES OR = LOW-VALUES                   
              MOVE -1                  TO WS-NULL-IND4                  
           ELSE                                                         
              MOVE 0                   TO WS-NULL-IND4                  
           END-IF.                                                      
           EXEC SQL                                                     
               INSERT INTO CSS_THD_PRTY_HIST                            
                        (DATE_TRANS,                                    
                         THD_PRTY_ID,                                   
                         DATE_MAILED,                                   
                         LETTER_STATUS,                                 
                         LETTER_TYPE_CD,                                
                         USER_ID)                                       
                VALUES  (CIS.CURRENT$TIMESTAMP(),                             
                         :ZX-THD-PRTY-ID,                               
                         IIF(TRY_CONVERT(DATE, :ZX-DATE-MAILED 
                                               :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :ZX-DATE-MAILED 
                                                          :WS-NULL-IND4
              ) <> 0) OR (LEN(:ZX-DATE-MAILED :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:ZX-DATE-MAILED :WS-NULL-IND4
              ), CONVERT(DATE, :ZX-DATE-MAILED :WS-NULL-IND4) ),               
                         :ZX-LETTER-STATUS,                             
                         :ZX-LETTER-TYPE-CD,                            
                         :ZX-USER-ID)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19290000
MFA-TR*        INSERT INTO CSS_THD_PRTY_HIST                            19300000
MFA-TR*                 (DATE_TRANS,                                    19310000
MFA-TR*                  THD_PRTY_ID,                                   19320000
MFA-TR*                  DATE_MAILED,                                   19330000
MFA-TR*                  LETTER_STATUS,                                 19340000
MFA-TR*                  LETTER_TYPE_CD,                                19350000
MFA-TR*                  USER_ID)                                       19360000
MFA-TR*         VALUES  (CURRENT TIMESTAMP,                             19370000
MFA-TR*                  :ZX-THD-PRTY-ID,                               19380000
MFA-TR*                  :ZX-DATE-MAILED:WS-NULL-IND4,                  19390000
MFA-TR*                  :ZX-LETTER-STATUS,                             19400000
MFA-TR*                  :ZX-LETTER-TYPE-CD,                            19410000
MFA-TR*                  :ZX-USER-ID)                                   19420000
MFA-TR*    END-EXEC.                                                    19430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8250-INS-THD-PRTY-HIST'                       
               DISPLAY '* ACCOUNT_NO = ' ZW-ACCOUNT-NO                  
               DISPLAY '* THD PRTY ID = ' ZX-THD-PRTY-ID                
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599**************************************************************    19620000
P00599**  8898-ISSUE-CHKP                                               19630000
P00599**************************************************************    19640000
P00599*                                                                 19650000
P00599 8898-ISSUE-CHKP.                                                 
P00599       EXEC SQL                                                   19670000
P00599           INCLUDE CPD00047                                       19680000
P00599       END-EXEC                                                   19690000
                                                    
P00599*                                                                 19700000
P00599 8898-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                 19730000
A00765****************************************************************  22080000
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  22090000
A00765****************************************************************  22100000
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                 22140000
      ******************************************************************22150000
      *                                                                *22160000
      *   9000-TERMINATE.                                              *22170000
      *                                                                *22180000
      ******************************************************************22190000
       9000-TERMINATE.                                                  
           MOVE '9000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ** 9700-PROCESS-ABEND.                                         ** 22390000
      ***************************************************************** 22400000
                                                                        
           EXEC SQL                                                     22420000
               INCLUDE CPD0023B                                         22430000
           END-EXEC.                                                    22440000
                                                                        
      ****************************************************************  22460000
      **                                                            **  22470000
      **  9900-SQL-ERROR-ROUTINE                                    **  22480000
      **                                                            **  22490000
      ****************************************************************  22500000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 22520000
           MOVE SQLCODE                TO WS-DISPLAY-SQLCODE.           
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY ABEND-RECORD-1-DATA                                  
           DISPLAY ABEND-RECORD-2-DATA                                  
           DISPLAY ABEND-RECORD-3-DATA                                  
           DISPLAY '**********************************************'.    
      ***************************************************************** 22640000
      ** 9900-ABEND.                                                 ** 22650000
      ***************************************************************** 22660000
                                                                        
           EXEC SQL                                                     22680000
               INCLUDE CPD09900                                         22690000
           END-EXEC.                                                    22700000
