       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA462                                         
       DATE-WRITTEN.   OCT 2004.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
      *  10/14/04  MR         NEW PROGRAM                              *        
      *  05/17/05  SK88120    CHANGED WERE MADE TO CORRECT RECON AMT   *        
T35434*  05/18/07  MC95456    REPLACED CSS_MODEL_SQL WITH SET STATEMENTS        
T35434*                       ADDED FOR FETCH ONLY WITH UR TO THE CURSOR        
T35434*                       TO AVOID -911.                           *        
ACT281*  09/12/16  RB19957    CHANGED THE DRIVING CURSOR TO ONLY       *        
ACT281*    APPL00005460       INCLUDE CHECKFREE ITEMS.                 *        
AC281A*  09/29/16  RB19957    NEEDED TO ADD REVERSALS - CSR03488 AND   *        
AC281A*  APPL00005460,ACT281  REMOVE CSR03413B IN THE DRIVING CURSOR.  *        
      ******************************************************************        
      *                                                                *        
      *   R   E    M   A     R    K     S                              *        
      *                                                                *        
      ******************************************************************        
      *  THIS PROGRAM READS NON-RECONCILED TRANS FROM CSS_PAYMENT_TRANS*        
      *  AND WRITES A REPORT.                                          *        
      ******************************************************************        
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
        SOURCE-COMPUTER.    IBM-4381.                                   
        OBJECT-COMPUTER.    IBM-4381.                                   
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      ******************************************************************        
      *  CSSPT33 - SELECT STATEMENT FOR OUTPUT REPORT FILE - 133 CHR   *        
      ******************************************************************        
       COPY CSSPT33.                                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************        
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE          *        
      ******************************************************************        
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA462'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *             'WORKING STORAGE FOR PCSCA462 STARTS HERE'.        *        
      ******************************************************************        
      *                                                                         
       01 WS-FLAGS.                                                     
          05  WS-IS-FIRST-REC                   PIC X(01) VALUE 'Y'.    
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                *        
      ******************************************************************        
       01  WS-DATE-VARIABLES.                                           
           05 WS-RUN-DATE.                                              
              10 WS-DT-CC                       PIC 9(02).              
              10 WS-DT-YY                       PIC 9(02).              
              10  FILLER                        PIC X(01) VALUE ' '.    
              10 WS-DT-MM                       PIC 9(02).              
              10  FILLER                        PIC X(01) VALUE ' '.    
              10 WS-DT-DD                       PIC 9(02).              
           05 WS-CUR-CCYY.                                              
              10  WS-CUR-CC                    PIC 9(02).               
              10  WS-CUR-YY                    PIC 9(02).               
           05 WS-REPORT-DATE.                                           
              10  WS-REP-MM                    PIC 9(02).               
              10  FILLER                       PIC X(01) VALUE '/'.     
              10  WS-REP-DD                    PIC 9(02).               
              10  FILLER                       PIC X(01) VALUE '/'.     
              10  WS-REP-YY                    PIC 9(02).               
           05 WS-BATCH-DATE.                                            
              10  WS-BATCH-MM                  PIC 9(02).               
              10  FILLER                       PIC X(01) VALUE '-'.     
              10  WS-BATCH-DD                  PIC 9(02).               
              10  FILLER                       PIC X(01) VALUE '-'.     
              10  WS-BATCH-YY                  PIC 9(04).               
           05 WS-COMMONDATE.                                            
              10 WS-CD-YYYY                    PIC X(04).               
              10 FILLER                        PIC X(01).               
              10 WS-CD-MM                      PIC X(02).               
              10 FILLER                        PIC X(01).               
              10 WS-CD-DD                      PIC X(02).               
           05 WS-CURRENT-DATE                  PIC X(10) VALUE SPACES.  
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                *        
      ******************************************************************        
      *                                                                         
       01  WS-TIME-VARIABLES.                                           
           05 WS-RUN-TIME.                                              
              10 WS-HH                         PIC 9(02).               
              10 WS-MM                         PIC 9(02).               
              10 WS-SS                         PIC 9(02).               
              10 WS-TT                         PIC 9(02).               
           05 WS-TRAN-TIME                     PIC X(08) VALUE SPACES.  
           05 WS-XFR-TS                        PIC X(26) VALUE SPACES.  
      *                                                                         
       01  WS-COUNTERS.                                                 
           05 WS-BATCH-TOTAL-COUNT             PIC 9(04) VALUE ZEROES.  
           05 WS-BATCH-TOTAL-AMOUNT            PIC S9(11)V99            
                                                         VALUE ZEROES.  
      *                                                                         
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-NULL-INDICATOR1               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR2               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-FIFTY-FIVE                    PIC 9(03) VALUE 55.     
           05  WS-PAGE-NUM                      PIC 9(04) VALUE ZEROES. 
           05  WS-LINE-SPACE                    PIC 9(02) VALUE ZEROES. 
           05  WS-LINE-DIFF                     PIC 9(03) VALUE ZEROES. 
           05  WS-LINE-CNTR                     PIC 9(03) VALUE 56.     
           05  WS-ACCOUNT-NO                    PIC 9(13).              
           05  WS-TOT-PAYMENT-AMT               PIC S9(9)V9(2)          
                                                    VALUE 0.            
           05  WS-TOT-NON-RECON-PYMT            PIC S9(9)V9(2)          
                                                    VALUE 0.            
COB305     05 WS-RECON-TOT-PYMT-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
COB305     05 WS-RECON-TOT-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.       
           05  WS-RECON-TOT-RVSL-AMT            PIC S9(09)V99           
                                                   USAGE COMP-3 VALUE 0.
           05  WS-RECON-GRAND-TOT-AMT           PIC S9(09)V99           
                                                    VALUE 0.            
           05  WS-GR-NON-RECON-PYMT-AMT         PIC S9(09)V99           
                                                    VALUE 0.            
           05  WS-NRECON-TOT     OCCURS 100 TIMES                       
                                 INDEXED AS WS-INDEX.                   
                 10  WS-NRECON-TOT-PYMT         PIC S9(9)V9(2).         
                 10  WS-DATE-CASH-RPT           PIC X(10).              
           05 WS-PREV-DATE-CASH-REPORT          PIC X(10).              
           05 WS-CTR                            PIC 9(03) VALUE ZERO.   
      *                                                                         
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-COMPANY                       PIC X(02) VALUE '01'.   
           05  WS-CSR                           PIC S9(9)V9(5)          
                                                          VALUE 1.00000.
           05  WS-SEB                           PIC S9(9)V9(5)          
                                                          VALUE 2.00000.
           05  WS-DATABASE                      PIC X(08) VALUE         
                                                          'DATABASE'.   
           05  WS-PGRMNAME                      PIC X(10) VALUE         
                                                       'PCSCA462'.      
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
           05  WS-DATA-EXIST                    PIC X(01) VALUE 'N'.    
           05  WS-N                             PIC X(01) VALUE 'N'.    
           05  WS-ZERO                          PIC 9(01) VALUE 0.      
           05  WS-ONE                           PIC 9(01) VALUE 1.      
           05  WS-TWO                           PIC 9(01) VALUE 2.      
           05  WS-SIX                           PIC 9(01) VALUE 6.      
      *                                                                         
      ******************************************************************        
      *  REPORT STRUCTURES - FOR NON-RECONCILED ACCOUNTS               *        
      ******************************************************************        
       01  WS-RPT-HDR1.                                                 
           05  FILLER                           PIC X(1)  VALUE SPACES. 
           05  WS-RPT-ID                        PIC X(08).              
           05  FILLER                           PIC X(01) VALUE '-'.    
           05  WS-RPT-ID1                       PIC X(01).              
           05  FILLER                           PIC X(31) VALUE SPACES. 
           05  WS-RPT-NAME                      PIC X(39) VALUE         
                 'SCANA CORPORATION                      '.             
           05  FILLER                           PIC X(29) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-DATE :  '.     
           05  WS-RPT-DATE                      PIC 9(10).              
      *                                                                         
       01  WS-RPT-HDR2.                                                 
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-SYSTEM                    PIC X(36) VALUE SPACES. 
           05  FILLER                           PIC X(30) VALUE         
                           ' APS REAL-TIME PAYMENT POSTING'.            
           05  FILLER                           PIC X(43) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-TIME :  '.     
           05  WS-RPT-TIME                      PIC X(08).              
      *                                                                         
                                                                        
       01  WS-RPT-RECON-SUM.                                            
           05  FILLER                           PIC X(11) VALUE SPACES. 
           05  FILLER                           PIC X(50) VALUE         
                  'TOTAL AMOUNT OF RECONCILED REAL-TIME PAYMENTS FOR'.  
           05  FILLER                           PIC X(1) VALUE SPACES.  
           05  WS-RPT-RECON-DATE                PIC 9(10).              
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-RPT-TOT-PYMT-AMT              PIC ---,---,--9.99.     
      *                                                                         
       01  WS-RPT-NON-RECON-SUM.                                        
           05  FILLER                           PIC X(20) VALUE SPACES. 
           05  FILLER                           PIC X(41) VALUE         
                   'TOTAL UNRECONCILED REAL-TIME PAYMENTS FOR'.         
           05  FILLER                           PIC X(1) VALUE SPACES.  
           05  WS-RPT-NON-RECON-DATE            PIC 9(10).              
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-RPT-NON-RECON-PYMT            PIC ---,---,--9.99.     
      *                                                                         
       01  WS-RPT-NON-RECON-SUM-GRAND.                                  
           05  FILLER                           PIC X(11) VALUE SPACES. 
           05  FILLER                           PIC X(50) VALUE         
               'GRAND TOTAL OF UNRECONCILED REAL-TIME PAYMENTS FOR'.    
           05  FILLER                           PIC X(1) VALUE SPACES.  
           05  WS-RPT-NON-RECON-DT-GRAND        PIC 9(10).              
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-RPT-NON-RECON-PYMT-GRAND      PIC ---,---,--9.99.     
      *                                                                         
       01  WS-RPT-HDR4.                                                 
           05  FILLER                           PIC X(80) VALUE         
             ' REAL-TIME PAYMENTS POSTED TO CIS NOT ON APS FILE '.      
       01  WS-RPT-HDR-SPC.                                              
           05  FILLER                           PIC X(133) VALUE SPACES.
      *                                                                         
       01  WS-PAGE-HDR.                                                 
           05  FILLER                           PIC X(42) VALUE SPACES. 
           05  FILLER                           PIC X(24) VALUE         
                                    'RECONCILIATION REPORT'.            
           05  FILLER                           PIC X(44) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'PAGE-NO  :  '.     
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-PAGE-NO                       PIC ZZZ9  VALUE '00'.   
           05  FILLER                           PIC X(05) VALUE SPACES. 
       01  WS-RPT-LINE.                                                 
           05  FILLER                           PIC X(132) VALUE ALL    
                                                    '='.                
      *                                                                         
       01  WS-RPT-HDR5.                                                 
           05  FILLER                           PIC X(5)  VALUE SPACES. 
           05  FILLER                           PIC X(14) VALUE SPACES. 
           05  FILLER                           PIC X(14) VALUE         
                                                    'ACCOUNT NUMBER'.   
           05  FILLER                           PIC X(16) VALUE SPACES. 
           05  FILLER                           PIC X(13) VALUE         
                                                    'CURRENCY TYPE'.    
           05  FILLER                           PIC X(16) VALUE SPACES. 
           05  FILLER                           PIC X(16) VALUE         
                                                    'PAYMENT/REVERSAL'. 
           05  FILLER                           PIC X(12) VALUE SPACES. 
           05  FILLER                           PIC X(11) VALUE         
                                                    ' TIMESTAMP '.      
      *                                                                         
       01  WS-RPT-DTL.                                                  
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  FILLER                           PIC X(14) VALUE SPACES. 
           05  WS-RPT-ACCOUNT-NO                PIC 9(13).              
           05  FILLER                           PIC X(19) VALUE SPACES. 
           05  WS-RPT-CURRENCY-TYPE             PIC X(11).              
           05  FILLER                           PIC X(10) VALUE SPACES. 
           05  WS-RPT-LEFT-PAREN                PIC X(1)  VALUE '('.    
           05  WS-RPT-PAYMENT-AMT               PIC --,---,---,--9.99.  
           05  WS-RPT-RIGHT-PAREN               PIC X(1)  VALUE ')'.    
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-RPT-PYMT-RCVD-TS              PIC X(26).              
      *                                                                         
       01  WS-RPT-MESSAGE.                                              
           05  FILLER                           PIC X(17) VALUE SPACES. 
           05  WS-RPT-MSG                       PIC X(25).              
           05  FILLER                           PIC X(30) VALUE SPACES. 
           05  FILLER                           PIC X(15) VALUE         
                                                'TOTAL AMOUNT'.         
           05  FILLER                           PIC X(12) VALUE SPACES. 
           05  WS-RPT-TOTAL-AMOUNT              PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
      *                                                                         
       01  WS-GTOT-MESSAGE.                                             
           05  FILLER                           PIC X(67) VALUE SPACES. 
           05  FILLER                           PIC X(20) VALUE         
                                                'GRAND TOTAL AMOUNT  '. 
           05  FILLER                           PIC X(12) VALUE SPACES. 
           05  WS-GRAND-RPT-AMT                 PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
      *                                                                         
       01  WS-RPT-FTR.                                                  
           05 FILLER                            PIC X(50)  VALUE SPACES.
           05 FILLER                            PIC X(21) VALUE         
                                               '*** END OF REPORT ***'. 
           05 FILLER                            PIC X(60) VALUE SPACES. 
      ******************************************************************        
      **   COPYBOOKS USED IN THE PROGRAM                              **        
      ******************************************************************        
      *                                                                         
      *THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.                 
       COPY CWS00303.                                                           
      *IO AREA FOR PARAMETER INPUT FILE 'A'                                     
       COPY FIOJC01.                                                            
      *                                                                         
       COPY CWS00038.                                                           
      *ABEND SWITCH COPYBOOK                                                    
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      **   C  W  S  0  0  3  1  5                                     **        
      ******************************************************************        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   S  Q  L  C  A                                              **        
      ******************************************************************        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   CSS_CASHIER_OFFICE  Y2                                     **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
            INCLUDE TBCSHOFF                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQUENCY  C8                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   CSS_JOB PARM     G6                                        **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PAYMENT_TRANS  JT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPMTRAN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR TO SELECT CSS_OVERSHORT_HDR                          *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE RECON_CURSOR CURSOR FOR                             
             SELECT ACCOUNT_NO                                          
                   ,CURRENCY_TYPE                                       
                   ,PAYMENT_AMT                                         
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
                   ,DATE_CASH_REPORT                                    
                   ,TRANS_TYPE_CD                                       
               FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
              WHERE RECONCILED_FL = 'N'                                 
AC281A          AND APPL_PROGRAM_ID IN ('CSR03413F','CSR03488',         
ACT281                                  'PCSCA461')                     
                AND CASH_LOCAL_OFFICE = (SELECT CASH_LOCAL_OFFICE       
                                            FROM CSS_CASHIER_OFFICE
                           WITH(READUNCOMMITTED)     
                                            WHERE PAYMENT_SOURCE_CD='AP'
                                            )                           
               ORDER BY DATE_CASH_REPORT                                
                        ,PYMT_RCVD_TS                                   
T35434        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RECON_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*            ,CURRENCY_TYPE                                               
MFA-TR*            ,PAYMENT_AMT                                                 
MFA-TR*            ,PYMT_RCVD_TS                                                
MFA-TR*            ,DATE_CASH_REPORT                                            
MFA-TR*            ,TRANS_TYPE_CD                                               
MFA-TR*        FROM CSS_PAYMENT_TRANS                                           
MFA-TR*       WHERE RECONCILED_FL = 'N'                                         
MFA-TR*         AND APPL_PROGRAM_ID IN ('CSR03413F','CSR03488',                 
MFA-TR*                                 'PCSCA461')                             
MFA-TR*         AND CASH_LOCAL_OFFICE = (SELECT CASH_LOCAL_OFFICE               
MFA-TR*                                     FROM CSS_CASHIER_OFFICE             
MFA-TR*                                     WHERE PAYMENT_SOURCE_CD='AP'        
MFA-TR*                                     )                                   
MFA-TR*        ORDER BY DATE_CASH_REPORT                                        
MFA-TR*                 ,PYMT_RCVD_TS                                           
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    'WORKING STORAGE FOR PCSCA462 ENDS HERE '.                  *        
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7961-OPEN-RECON                                      
              THRU 7961-EXIT.                                           
      *                                                                         
           PERFORM 7962-FETCH-RECON                                     
              THRU 7962-EXIT.                                           
      *                                                                         
           PERFORM 1000-PROCESS                                         
              THRU 1000-EXIT                                            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
      *                                                                         
           IF WS-TOT-PAYMENT-AMT NOT EQUAL  TO ZERO THEN                
              ADD 1                         TO WS-CTR                   
              MOVE WS-PREV-DATE-CASH-REPORT TO WS-DATE-CASH-RPT(WS-CTR) 
              MOVE WS-TOT-PAYMENT-AMT       TO                          
                                             WS-NRECON-TOT-PYMT(WS-CTR) 
           END-IF.                                                      
      *                                                                         
           PERFORM 2967-PRINT-REPORT-FOOTER                             
              THRU 2967-EXIT.                                           
      *                                                                         
           PERFORM 7963-CLOSE-RECON                                     
              THRU 7963-EXIT.                                           
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT.                                           
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT.                                           
           MOVE WS-COMPANY               TO C8-COMPANY-NO               
                                            Y2-CASH-COMPANY-NO.         
           MOVE WS-DATABASE              TO C8-DELINQ-CD.               
           PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT.                
           IF C8-DELINQ-VALUE = WS-SEB                                  
              MOVE 'SEB'                 TO WS-RPT-SYSTEM               
           ELSE                                                         
              MOVE 'CSR'                 TO WS-RPT-SYSTEM               
           END-IF.                                                      
           MOVE WS-PGRMNAME              TO WS-RPT-ID.                  
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0200-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0200-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0300-SETUP-DATES                                            **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSCA462'            TO WS-PGRMNAME                 
           END-IF.                                                      
      *    FORMATING DATE FOR REPORT HEADER.                                    
           PERFORM 7700-GET-CURRENT-TIMESTAMP THRU 7700-EXIT.           
           MOVE WS-CURRENT-DATE          TO WS-RUN-DATE.                
      *                                                                         
           MOVE WS-DT-MM                 TO WS-REP-MM.                  
           MOVE WS-DT-YY                 TO WS-REP-YY.                  
           MOVE WS-DT-DD                 TO WS-REP-DD.                  
           MOVE WS-REPORT-DATE           TO WS-RPT-DATE.                
           MOVE WS-TRAN-TIME             TO WS-RPT-TIME.                
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS                                                 **        
      ******************************************************************        
       1000-PROCESS.                                                    
      *--------------------*                                                    
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT        
      *                                                                         
           PERFORM 2960-PRINT-REPORT-DETAIL                             
              THRU 2960-EXIT.                                           
      *                                                                         
           PERFORM 7962-FETCH-RECON                                     
              THRU 7962-EXIT.                                           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      *  2960-PRINT-REPORT-DETAIL*                                              
      ******************************************************************        
       2960-PRINT-REPORT-DETAIL.                                        
                                                                        
            MOVE '2960'                  TO WS-ACTIVE-PARAGRAPH.        
            MOVE WS-PGRMNAME             TO WS-RPT-ID.                  
            MOVE JT-ACCOUNT-NO           TO WS-RPT-ACCOUNT-NO.          
            EVALUATE JT-CURRENCY-TYPE                                   
              WHEN 'A'                                                  
                MOVE 'CASH' TO WS-RPT-CURRENCY-TYPE                     
              WHEN 'C'                                                  
                MOVE 'CHECK' TO WS-RPT-CURRENCY-TYPE                    
              WHEN 'M'                                                  
                MOVE 'MONEY ORDER' TO WS-RPT-CURRENCY-TYPE              
            END-EVALUATE.                                               
            MOVE JT-PAYMENT-AMT          TO WS-RPT-PAYMENT-AMT.         
            MOVE JT-PYMT-RCVD-TS         TO WS-RPT-PYMT-RCVD-TS.        
            IF JT-DATE-CASH-REPORT NOT = WS-PREV-DATE-CASH-REPORT       
             ADD 1                       TO WS-CTR                      
             MOVE WS-PREV-DATE-CASH-REPORT                              
                                         TO WS-DATE-CASH-RPT(WS-CTR)    
             MOVE WS-TOT-PAYMENT-AMT     TO WS-NRECON-TOT-PYMT(WS-CTR)  
             MOVE JT-DATE-CASH-REPORT    TO WS-PREV-DATE-CASH-REPORT    
             MOVE 0                      TO WS-TOT-PAYMENT-AMT          
            END-IF.                                                     
            IF JT-TRANS-TYPE-CD = 'P' THEN                              
               ADD JT-PAYMENT-AMT        TO WS-TOT-PAYMENT-AMT          
               MOVE SPACES               TO WS-RPT-LEFT-PAREN           
               MOVE SPACES               TO WS-RPT-RIGHT-PAREN          
            ELSE                                                        
               SUBTRACT JT-PAYMENT-AMT   FROM WS-TOT-PAYMENT-AMT        
               COMPUTE WS-RPT-PAYMENT-AMT = JT-PAYMENT-AMT * -1         
               MOVE SPACES               TO WS-RPT-LEFT-PAREN           
               MOVE SPACES               TO WS-RPT-RIGHT-PAREN          
            END-IF.                                                     
            IF WS-LINE-CNTR > WS-FIFTY-FIVE                             
               PERFORM 2965-PRINT-REPORT-HEADER                         
                  THRU 2965-EXIT                                        
               PERFORM 2970-MOVE-DETAIL-TO-REPORT                       
                  THRU 2970-EXIT                                        
               MOVE WS-TWO               TO WS-LINE-SPACE               
            END-IF.                                                     
            COMPUTE WS-LINE-DIFF = WS-FIFTY-FIVE - WS-LINE-CNTR         
            END-COMPUTE                                                 
            IF WS-LINE-DIFF > 5                                         
               PERFORM 2970-MOVE-DETAIL-TO-REPORT                       
                  THRU 2970-EXIT                                        
               MOVE WS-ZERO              TO WS-LINE-DIFF                
               MOVE WS-TWO               TO WS-LINE-SPACE               
            ELSE                                                        
               PERFORM 2965-PRINT-REPORT-HEADER                         
                  THRU 2965-EXIT                                        
               PERFORM 2970-MOVE-DETAIL-TO-REPORT                       
                  THRU 2970-EXIT                                        
               MOVE WS-TWO               TO WS-LINE-SPACE               
            END-IF.                                                     
                                                                        
           MOVE  WS-RPT-DTL              TO PRT33-DATA.                 
           MOVE  WS-ONE                     TO WS-LINE-SPACE.           
           PERFORM 8100-WRITE-RECORD                                    
              THRU 8100-EXIT.                                           
           MOVE  WS-ONE                  TO WS-LINE-SPACE.              
      *                                                                         
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2965-PRINT-REPORT-HEADER                                      *        
      ******************************************************************        
       2965-PRINT-REPORT-HEADER.                                        
      *                                                                         
            MOVE '2965'                  TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
            MOVE WS-Y                    TO WS-DATA-EXIST.              
            MOVE WS-ZERO                 TO WS-LINE-CNTR.               
            ADD  WS-ONE                  TO WS-PAGE-NUM.                
            MOVE WS-PAGE-NUM             TO WS-PAGE-NO.                 
      ***   INCREMENTS THE PAGENO AND PRINTS THE HEADER                         
      ***   AFTER ADVANCING ONE PAGE                                            
            MOVE '1'                     TO WS-RPT-ID1                  
            MOVE WS-RPT-HDR1             TO PRT33-DATA.                 
            PERFORM 8000-WRITE-FIRST-HEADER                             
               THRU 8000-EXIT.                                          
      ***  PRINT THE TITLE AND TIME                                             
            MOVE WS-RPT-HDR2             TO PRT33-DATA.                 
            MOVE WS-ONE                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
            MOVE WS-PAGE-HDR             TO PRT33-DATA.                 
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
                                                                        
            MOVE WS-RPT-HDR-SPC          TO PRT33-DATA.                 
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
            MOVE WS-RPT-HDR4             TO PRT33-DATA.                 
                                                                        
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      ***   PRINTS  ======                                                      
            MOVE WS-RPT-LINE             TO PRT33-DATA.                 
            PERFORM    8100-WRITE-RECORD                                
               THRU    8100-EXIT.                                       
      ***   PRINTS THE  COMPANY DETAILS              ***                        
            MOVE WS-RPT-HDR5             TO PRT33-DATA.                 
            MOVE WS-ONE                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      ***   PRINTS ======                             ***                       
            MOVE WS-RPT-LINE             TO PRT33-DATA.                 
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
            MOVE WS-SIX                  TO WS-LINE-CNTR.               
      *                                                                         
       2965-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  2966-PRINT-REPORT-HDR                                         *        
      ******************************************************************        
       2966-PRINT-REPORT-HDR.                                           
            MOVE '2966'                  TO WS-ACTIVE-PARAGRAPH.        
            MOVE WS-ZERO                 TO WS-LINE-CNTR.               
            ADD  WS-ONE                  TO WS-PAGE-NUM.                
            MOVE WS-PAGE-NUM             TO WS-PAGE-NO.                 
      ***   INCREMENTS THE PAGENO AND PRINTS THE HEADER                         
      ***   AFTER ADVANCING ONE PAGE                                            
            MOVE '1'                     TO WS-RPT-ID1                  
            MOVE WS-RPT-HDR1             TO PRT33-DATA.                 
            PERFORM 8000-WRITE-FIRST-HEADER                             
               THRU 8000-EXIT.                                          
      ***  PRINT THE TITLE AND TIME                                             
            MOVE WS-RPT-HDR2             TO PRT33-DATA.                 
            MOVE WS-ONE                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
            MOVE WS-PAGE-HDR             TO PRT33-DATA.                 
            MOVE WS-ONE                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      *                                                                         
       2966-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *  2967-PRINT-REPORT-FOOTER                                      *        
      ******************************************************************        
       2967-PRINT-REPORT-FOOTER.                                        
      *                                                                         
            MOVE '2967'                  TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7326-SELECT-COMMONDATE                               
              THRU 7326-EXIT.                                           
            MOVE WS-COMMONDATE           TO WS-RPT-RECON-DATE           
                                            WS-RPT-NON-RECON-DT-GRAND.  
      *                                                                         
            MOVE 'P'                    TO JT-TRANS-TYPE-CD             
            PERFORM 7810-SELECT-RECON-AMT                               
               THRU 7810-EXIT.                                          
            IF WS-NULL-INDICATOR1 < 0                                   
               MOVE ZEROS                TO WS-RECON-TOT-PYMT-AMT       
            ELSE                                                        
               MOVE WS-RECON-TOT-AMT     TO WS-RECON-TOT-PYMT-AMT       
            END-IF                                                      
      *                                                                         
            MOVE 'R'                    TO JT-TRANS-TYPE-CD             
            PERFORM 7810-SELECT-RECON-AMT                               
               THRU 7810-EXIT.                                          
            IF WS-NULL-INDICATOR1 < 0                                   
               MOVE ZEROS                TO WS-RECON-TOT-RVSL-AMT       
            ELSE                                                        
               MOVE WS-RECON-TOT-AMT     TO WS-RECON-TOT-RVSL-AMT       
            END-IF                                                      
            COMPUTE                                                     
               WS-RECON-GRAND-TOT-AMT    = WS-RECON-TOT-PYMT-AMT        
                                         - WS-RECON-TOT-RVSL-AMT        
            END-COMPUTE.                                                
            MOVE WS-RECON-GRAND-TOT-AMT  TO WS-RPT-TOT-PYMT-AMT.        
      *                                                                         
            MOVE WS-TOT-PAYMENT-AMT      TO WS-RPT-NON-RECON-PYMT-GRAND.
            SET WS-INDEX                 TO 1.                          
            PERFORM UNTIL WS-INDEX       = WS-CTR + 1                   
              MOVE WS-DATE-CASH-RPT(WS-INDEX)                           
                                         TO WS-RPT-NON-RECON-DATE       
              MOVE WS-NRECON-TOT-PYMT(WS-INDEX)                         
                                         TO WS-RPT-NON-RECON-PYMT       
              MOVE WS-NRECON-TOT-PYMT(WS-INDEX)                         
                                         TO WS-TOT-NON-RECON-PYMT       
              ADD WS-TOT-NON-RECON-PYMT  TO WS-GR-NON-RECON-PYMT-AMT    
              MOVE WS-RPT-NON-RECON-SUM  TO PRT33-DATA                  
              MOVE WS-TWO                TO WS-LINE-SPACE               
              PERFORM 8100-WRITE-RECORD                                 
                 THRU 8100-EXIT                                         
              SET WS-INDEX UP BY 1                                      
            END-PERFORM.                                                
            MOVE WS-GR-NON-RECON-PYMT-AMT                               
                                         TO WS-RPT-NON-RECON-PYMT-GRAND 
      *                                                                         
            IF WS-DATA-EXIST = WS-N                                     
               PERFORM 2965-PRINT-REPORT-HEADER                         
                  THRU 2965-EXIT                                        
            ELSE                                                        
               MOVE WS-RPT-NON-RECON-SUM-GRAND                          
                                         TO PRT33-DATA                  
               MOVE WS-TWO               TO WS-LINE-SPACE               
               PERFORM 8100-WRITE-RECORD                                
                  THRU 8100-EXIT                                        
            END-IF                                                      
      *                                                                         
            MOVE WS-RPT-RECON-SUM        TO PRT33-DATA.                 
            MOVE WS-TWO                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      *                                                                         
            MOVE WS-RPT-FTR              TO PRT33-DATA.                 
            MOVE WS-TWO                  TO WS-LINE-SPACE.              
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      *                                                                         
       2967-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      ** 2970-MOVE-DETAIL-TO-REPORT*                                            
      ****************************************************************          
       2970-MOVE-DETAIL-TO-REPORT.                                      
      *                                                                         
            MOVE '2970'                  TO WS-ACTIVE-PARAGRAPH.        
            ADD WS-ONE                   TO WS-LINE-CNTR.               
      *                                                                         
       2970-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      ** 2990-PRINT-REPORT-TRAILER                                   *          
      ****************************************************************          
       2990-PRINT-REPORT-TRAILER.                                       
      *                                                                         
            MOVE '2990'                  TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
            MOVE  WS-RPT-MESSAGE         TO PRT33-DATA.                 
      *                                                                         
            PERFORM 8100-WRITE-RECORD                                   
               THRU 8100-EXIT.                                          
      *                                                                         
            ADD  WS-ONE                  TO WS-LINE-CNTR.               
      *                                                                         
       2990-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      **  7326-SELECT-COMMONDATE                                      **        
      ******************************************************************        
       7326-SELECT-COMMONDATE.                                          
      *------------------------*                                                
           MOVE '7326'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             SELECT PARM_DATA                                           
               INTO :G6-PARM-DATA                                       
               FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
              WHERE PROGRAM_NAME = 'COMMONDATE'                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PARM_DATA                                                   
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'COMMONDATE'                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE G6-PARM-DATA TO WS-COMMONDATE                           
                                JT-RECONCILED-DT.                       
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               STRING 'GETTING COMMONDATE FROM CIS **'                  
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'COMMON DATE  ' DELIMITED BY SIZE                 
                   G6-PARM-DATA      DELIMITED BY SIZE                  
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7326-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7700-GET-CURRENT-TIMESTAMP                                  **        
      **                                                              **        
      ******************************************************************        
       7700-GET-CURRENT-TIMESTAMP.                                      
      *--------------------------*                                              
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-XFR-TS,
              :WS-TRAN-TIME,
              :WS-CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET    :WS-XFR-TS        = CURRENT TIMESTAMP                       
MFA-TR*            ,:WS-TRAN-TIME     = CURRENT TIME                            
MFA-TR*            ,:WS-CURRENT-DATE  = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR GETTING TIMESTAMP VALUE **'                
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7800-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7800-SELECT-DATABASE.                                            
      *---------------------*                                                   
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
             WHERE COMPANY_NO            = :C8-COMPANY-NO               
               AND DELINQ_CD             = :C8-DELINQ-CD                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*      WHERE COMPANY_NO            = :C8-COMPANY-NO                       
MFA-TR*        AND DELINQ_CD             = :C8-DELINQ-CD                        
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7810-SELECT-RECON-AMT                                       **        
      **                                                              **        
      ******************************************************************        
       7810-SELECT-RECON-AMT.                                           
      *---------------------*                                                   
           MOVE '7810'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
            SELECT SUM(PAYMENT_AMT)                                     
              INTO :WS-RECON-TOT-AMT :WS-NULL-INDICATOR1                 
              FROM CSS_PAYMENT_TRANS                                    
              WHERE RECONCILED_FL = 'Y'                                 
                AND CASH_LOCAL_OFFICE = (SELECT CASH_LOCAL_OFFICE       
                                           FROM CSS_CASHIER_OFFICE      
                                          WHERE PAYMENT_SOURCE_CD='AP'  
                                         )                              
                AND TRANS_TYPE_CD = :JT-TRANS-TYPE-CD                   
                AND RECONCILED_DT = IIF(TRY_CONVERT(DATE, 
                                                      :JT-RECONCILED-DT
              ) IS NULL OR (PATINDEX('%.%', :JT-RECONCILED-DT
              ) <> 0) OR (LEN(:JT-RECONCILED-DT) <> 10), CIS.CHAR2DATE(
                                                      :JT-RECONCILED-DT
              ), CONVERT(DATE, :JT-RECONCILED-DT) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT SUM(PAYMENT_AMT)                                             
MFA-TR*       INTO :WS-RECON-TOT-AMT:WS-NULL-INDICATOR1                         
MFA-TR*       FROM CSS_PAYMENT_TRANS                                            
MFA-TR*       WHERE RECONCILED_FL = 'Y'                                         
MFA-TR*         AND CASH_LOCAL_OFFICE = (SELECT CASH_LOCAL_OFFICE               
MFA-TR*                                    FROM CSS_CASHIER_OFFICE              
MFA-TR*                                   WHERE PAYMENT_SOURCE_CD='AP'          
MFA-TR*                                  )                                      
MFA-TR*         AND TRANS_TYPE_CD = :JT-TRANS-TYPE-CD                           
MFA-TR*         AND RECONCILED_DT = :JT-RECONCILED-DT                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
               WS-NULL-INDICATOR1 = -1                                  
              NEXT SENTENCE                                             
           ELSE                                                         
                 STRING 'ERROR SELECTING RECONCILE PYMT AMT**'          
                         DELIMITED BY SIZE                              
                         INTO WS-ERR-MSG                                
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF.                                                      
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  7961-OPEN-RECON.                                            **        
      **                                                              **        
      ******************************************************************        
       7961-OPEN-RECON.                                                 
      *-------------*                                                           
           MOVE '7961'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                OPEN RECON_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING RECON_CURSOR **'                   
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7961-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7962-FETCH-RECON.                                           **        
      **                                                              **        
      ******************************************************************        
       7962-FETCH-RECON.                                                
      *--------------*                                                          
           MOVE '7962'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
              FETCH RECON_CURSOR                                        
               INTO :JT-ACCOUNT-NO                                      
                   ,:JT-CURRENCY-TYPE                                   
                   ,:JT-PAYMENT-AMT                                     
                   ,:JT-PYMT-RCVD-TS                                    
                   ,:JT-DATE-CASH-REPORT                                
                   ,:JT-TRANS-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-IS-FIRST-REC = 'Y' THEN                             
                 MOVE JT-DATE-CASH-REPORT                               
                                         TO WS-PREV-DATE-CASH-REPORT    
                 MOVE 'N'                TO WS-IS-FIRST-REC             
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING RECON CURSOR **'                  
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              STRING ' ACCOUNT NO  '     DELIMITED BY SIZE              
                      WS-ACCOUNT-NO      DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7962-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7963-CLOSE-RECON                                            **        
      **                                                              **        
      ******************************************************************        
       7963-CLOSE-RECON.                                                
      *--------------*                                                          
           MOVE '7963'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                CLOSE RECON_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR CLOSING RECON CURSOR **'                   
                                         DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7963-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7971-SELECT-REPORTDATE                                      **        
      **                                                              **        
      ******************************************************************        
       7971-SELECT-REPORTDATE.                                          
      *---------------------*                                                   
           MOVE '7971'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT PARM_DATA                                            
              INTO :G6-PARM-DATA                                        
              FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                           
            WHERE PROGRAM_NAME=:G6-PROGRAM-NAME                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT PARM_DATA                                                    
MFA-TR*       INTO :G6-PARM-DATA                                                
MFA-TR*       FROM CSS_JOB_PARM                                                 
MFA-TR*     WHERE PROGRAM_NAME=:G6-PROGRAM-NAME                                 
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING REPORTDATE **'                 
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'REPORTDATE'  DELIMITED BY SIZE                 
                         WS-REPORT-DATE  DELIMITED BY SIZE              
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7971-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      ** 8000-WRITE-FIRST-HEADER*                                               
      ****************************************************************          
       8000-WRITE-FIRST-HEADER.                                         
      *                                                                         
            MOVE '8000'                  TO WS-ACTIVE-PARAGRAPH.        
            WRITE PRT33-RECORD AFTER ADVANCING PAGE.                    
      *                                                                         
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      ** 8100-WRITE-RECORD                                           *          
      ****************************************************************          
       8100-WRITE-RECORD.                                               
      *                                                                         
            MOVE '8100'                  TO WS-ACTIVE-PARAGRAPH.        
            WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.           
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                        **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY '**'   WS-ERR-MSG.                                   
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
      *                                                                         
       8800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  8900-DISPLAY-ERR-TERM                                       **        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSCA462 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
