       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA461.                                         
       DATE-WRITTEN.  OCT 2004.                                         
      ****************************************************************          
      *                 PROGRAM MODIFICATION LOG                     *          
      *                                                              *          
      *   DATE    INITIALS   REASON                                  *          
      * --------  --------   ----------------------------------------*          
      *  10/04     MR         NEW PROGRAM                            *          
      *  05/05    SK88120   A) CHANGES WERE MADE TO CREATE A FILE INS*          
      *                       -TEAD OF REPORT , AND THAT FILE WILL BE*          
      *                        USED IN PCSRP461 TO GENERATE REPORT.  *          
      *                     B) ADDED RESTART LOGIC.                  *          
T33689** 01/13/06  CHENNAI    DISPLAY ABEND INFORMATION FOR PAYMENT **          
T33689**           COVANSYS   AMT.                                  **          
T34970** 11/03/06  LG41184    FIX FOR -811 ABEND.                    *          
T34097** 11/13/06  LG41184    PERFORMANCE TUNING - REMOVE MODEL_SQL  *          
T33928** 03/27/08  SV82012    ABEND DUE TO 2 BATCHES OPEN -  -811    *          
A00575*  01/20/09  BASKAR V  STORE CREDIT ACTION FLAG IN ERROR_CD    *          
A00575*                      FIELD OF CSS_PAYMENT_TRANS TABLE, HANDLE*          
A00575*                      ERROR_CD FIELD FOR THAT.                *          
      ****************************************************************          
      *                                                              *          
      *   R   E    M   A     R    K     S                            *          
      *                                                              *          
      ****************************************************************          
      *  THIS PROGRAM READS APS PRODUCTION FILE  ,  VALIDATES IT     *          
      *  AND RECONCILES WITH PAYMENT TRANS TABLE.                    *          
      *  OUTPUT FILE IS CREATED & USED IN PCSRP461 FOR REPORTING.    *          
      ****************************************************************          
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
      ***************************************************************           
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
            SELECT FIOAC10-FILE                                         
             ASSIGN UT-S-FCSAC10                                        
             FILE STATUS IS WS-FIOAC10-STATUS.                          
      *                                                                         
            SELECT CA461RPT-FILE                                        
             ASSIGN UT-S-CA461RPT                                       
             FILE STATUS IS WS-RPT461-STATUS.                           
      *                                                                         
      ***THIS IS A DUMMY FILE USED ONLY IF WE RESTART THE JOB                   
      *                                                                         
            SELECT CA461RPR-FILE                                        
             ASSIGN UT-S-CA461RPR                                       
             FILE STATUS IS WS-RPT461R-STATUS.                          
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  FIOAC10-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       COPY FIOAC10.                                                            
      *                                                                         
       FD  CA461RPT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01  CA461RPT-REC.                                               
            05 CA461RPT-DATA            PIC X(132).                     
      *                                                                         
       FD  CA461RPR-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
        01  CA461RPR-REC.                                               
            05 CA461RPR-DATA            PIC X(132).                     
      *                                                                         
      ****************************************************************          
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA461'.
MSQ017     COPY MFASQLM.
      ****************************************************************          
      *             'WORKING STORAGE FOR PCSCA461 STARTS HERE'.      *          
      ****************************************************************          
      *                                                                         
       01  WS-START                             PIC X(40)               
           VALUE 'WORKING STORAGE FOR PCSCA461 STARTS HERE'.            
      *                                                                         
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME                       PIC X(10)               
                                                    VALUE 'PCSCA461'.   
          05  WS-PROGRAM-NAME                   PIC X(10)               
                                                    VALUE 'PCSCA461'.   
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  WS-FIOAC10-EOF-SW                 PIC X(01) VALUE 'N'.    
              88  WS-FIOAC10-AT-EOF                       VALUE 'Y'.    
              88  WS-FIOAC10-NOT-AT-EOF                   VALUE 'N'.    
          05  WS-FIOAC10-STATUS           PIC X(02)  VALUE '00'.        
              88 WS-FIOAC10-SUCCESSFUL            VALUE '00' '04'.      
          05  WS-RPT461-STATUS           PIC X(02)  VALUE '00'.         
              88 WS-RPT461-SUCCESSFUL               VALUE '00' '04'.    
          05  WS-RPT461R-STATUS          PIC X(02)  VALUE '00'.         
              88 WS-RPT461R-SUCCESSFUL              VALUE '00' '04'.    
      *                                                                         
      ***************************************************************           
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                         
      ***************************************************************           
       01 WS-DATE-VARIABLES.                                            
           05 WS-COMMONDATE.                                            
              10 WS-CD-YYYY                     PIC X(04).              
              10 FILLER                         PIC X(01).              
              10 WS-CD-MM                       PIC X(02).              
              10 FILLER                         PIC X(01).              
              10 WS-CD-DD                       PIC X(02).              
           05 WS-COMMONDATE-8.                                          
              10 WS-CD-YYYY-8                   PIC X(04).              
              10 WS-CD-MM-8                     PIC X(02).              
              10 WS-CD-DD-8                     PIC X(02).              
           05 WS-COMMONDATE-8-INT               PIC X(08).              
      ****************************************************************          
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES              *          
      ****************************************************************          
       01  WS-TIME-VARIABLES.                                           
           05 WS-XFR-TS                         PIC X(26) VALUE SPACES. 
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-NULL-INDICATOR1               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
      *                                                                         
       01 WS-DISPLAY.                                                   
           05  WS-ACCOUNT-NO                    PIC X(14) VALUE SPACES. 
           05  FILLER                           PIC X(01) VALUE SPACES. 
      *                                                                         
       01 WS-MISC-FIELDS.                                               
           05  WS-FAC10-ACCT-NO                 PIC X(13).              
           05  WS-FAC10-PAYMENT-TS              PIC X(26).              
           05  WS-FAC10-ID-TYPE                 PIC X(01).              
           05  WS-FAC10-PYMT-AMT                PIC 9(09)V99.           
COB305     05 WS-FAC10-PYMT-AMT-COMP        PIC 9(09)V99 COMP-3 VALUE 0.    
           05  WS-FAC10-HDR-RECORD-COUNT        PIC 9(10) VALUE ZEROS.  
           05  WS-FAC10-HDR-TOTAL-AMT           PIC 9(08)V99.           
           05  WS-TOT-PYMT-AMT                  PIC S9(08)V99 VALUE 0.  
           05  WS-TOT-TRNS-AMT                  PIC 9(08)V99.           
           05  WS-RECORD-READ                   PIC 9(09) VALUE 0.      
           05  WS-NON-CONT-PYMT-FL              PIC X(1) VALUE 'N'.     
           05  WS-FAC10-SOURCE                  PIC X(2).               
           05  WS-ID-TYPE                       PIC X(1).               
           05  WS-Y                             PIC X(1) VALUE 'Y'.     
           05  WS-N                             PIC X(1) VALUE 'N'.     
           05  WS-I                             PIC X(1) VALUE 'I'.     
           05  WS-ONE                           PIC 9(1) VALUE 1.       
      *                                                                         
           05  WS-CHKP-LUW-LIMIT                PIC 9(04).              
           05  WS-FLAG-TO-TURN-OFF-COMMITS                              
                                                PIC 9(04) VALUE 9999.   
           05  WS-CHKP-UPD-LIMIT                PIC 9(04).              
           05  WS-CHKP-SEQ-NO                   PIC 9(05) VALUE ZERO.   
           05  WS-DEFAULT-RESTART-REQ           PIC X(01) VALUE 'N'.    
           05  WS-DEFAULT-CHKP-LUW-LIMIT                                
                                                PIC 9(04) VALUE 4.      
           05  WS-DEFAULT-CHKP-UPD-LIMIT                                
                                                PIC 9(04) VALUE 20.     
           05  WS-COUNT-UNSUCCESSFUL-ROWS       PIC S9(04) COMP-3       
                                                          VALUE ZERO.   
           05  WS-RESTART-DATA-LENGTH         PIC S9(04) COMP VALUE +55.
           05  WS-CHKP-LUW-COUNTER              PIC S9(04)  COMP-3      
                                                          VALUE ZERO.   
           05  WS-CHKP-UPD-COUNTER              PIC S9(04) COMP-3       
                                                          VALUE ZERO.   
           05  WS-IS-THIS-A-RESTART             PIC X(01) VALUE 'N'.    
               88  WS-THIS-IS-A-RESTART                   VALUE 'Y'.    
           05  WS-ACCOUNT-EXISTS-FLAG           PIC X(01) VALUE 'N'.    
               88  WS-ACCOUNT-NOT-FOUND                   VALUE 'Y'.    
           05  WS-RESTART-REQ                   PIC X(01).              
           05  WS-OUTPUT-RECS                   PIC 9(09) VALUE ZERO.   
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE          PIC 9(01).              
           05  WS-RESTART-JOB-COMPLETE REDEFINES                        
               WS-RESTART-PROCESS-TYPE          PIC X(01).              
           05  WS-RESTART-JOB-STATUS            PIC X(01).              
               88  WS-RUN-COMPLETED-NO-PROBLEMS     VALUE 'A'.          
               88  WS-RERUN-COMPLETED               VALUE 'B'.          
               88  WS-RERUN-PENDING                 VALUE 'C'.          
           05  WS-RESTART-INPUT-DATE            PIC X(10).              
           05  WS-RESTART-CHKP-SEQ-NO           PIC 9(05) VALUE ZERO.   
           05  WS-RESTART-RECON-RECS-READ       PIC 9(09) VALUE ZERO.   
           05  WS-RESTART-OUTPUT-RECS           PIC 9(09) VALUE ZERO.   
           05  WS-RESTART-TOT-PYMT-AMT          PIC S9(08)V99 VALUE 0.  
           05  WS-RESTART-TOT-TRNS-AMT          PIC S9(08)V99.          
      *                                                                         
       01  WS-RPT-DTL.                                                  
           05  FILLER                           PIC X(02) VALUE SPACES. 
           05  WS-CASH-RPT-DATE                 PIC X(10).              
           05  FILLER                           PIC X(07) VALUE SPACES. 
           05  WS-RPT-COMPANY-NO                PIC 9(02).              
           05  FILLER                           PIC X(12) VALUE SPACES. 
           05  WS-RPT-LOCAL-OFFICE              PIC 9(03).              
           05  FILLER                           PIC X(10) VALUE SPACES. 
           05  WS-RPT-ACCT-NO-DET               PIC 9(13).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-REJ-REASON                PIC X(28).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-PYMT-TYPE                 PIC X(08).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-AMOUNT                    PIC ---,---,--9.99.     
           05  WS-RPT-TAMOUNT                   PIC ---,---,--9.99.     
      *                                                                         
      *                                                                         
      *THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.                 
       COPY CWS00303.                                                           
      *IO AREA FOR PARAMETER INPUT FILE 'A'                                     
       COPY FIOJC01.                                                            
      *SUPPORTS RESTART REQ PARAMETERS                                          
       COPY CWS00038.                                                           
      *ABEND SWITCH COPYBOOK                                                    
       COPY CWS09900.                                                           
      *                                                                         
      *****************************************************************         
      **   S Q L C A                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   CSS_ACCOUNT  AT                                            *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
      *****************************************************************         
      **   CSS_PAYMENT_TRANS  JT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE TBPMTRAN                                                    
           END-EXEC.                                                            
      *****************************************************************         
      **   CSS_JOB_PARM  G6                                           *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE TBJBPARM                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL CS                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCDCNTL                                                 
           END-EXEC.                                                            
      *****************************************************************         
      **   CSS_CASHIER_OFFICE  Y2                                     *         
      *****************************************************************         
           EXEC SQL                                                             
            INCLUDE TBCSHOFF                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **   CSS_RESTART         RF                                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                               PIC X(40)               
           VALUE 'WORKING STORAGE FOR PCSCA461 ENDS HERE  '.            
      *                                                               *         
      **   'WORKING STORAGE FOR PCSCA461 ENDS HERE '.                **         
      *                                                               *         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      **                         M A I N L I N E                     **         
      *****************************************************************         
       0000-MAINLINE.                                                   
      *-------------*                                                           
      *                                                                         
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7000-READ-RECORD                                     
              THRU 7000-EXIT.                                           
      *                                                                         
           MOVE ZEROS                        TO WS-RECORD-READ          
      *                                                                         
           IF E-FAC10-HDR-DATE = WS-COMMONDATE-8-INT THEN               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH     
               STRING 'FILE HEADER DATE DOESNOT MATCH        **'        
                                            DELIMITED BY SIZE           
                                           INTO WS-ERR-MSG              
               STRING 'CURRENT DATE FROM CSS_JOB_PARM TABLE  **'        
                                            DELIMITED BY SIZE           
                                           INTO WS-ERR-MSG2             
                DISPLAY 'FILE HEADER DATE :' E-FAC10-HDR-DATE           
                DISPLAY 'COMMON DATE USED :' WS-COMMONDATE-8-INT        
               PERFORM 8900-DISPLAY-ERR-TERM                            
                  THRU 8900-EXIT                                        
           END-IF.                                                      
      *                                                                         
           MOVE E-FAC10-HDR-RECORD-COUNT TO WS-FAC10-HDR-RECORD-COUNT.  
           MOVE E-FAC10-HDR-TOTAL-AMT    TO WS-FAC10-HDR-TOTAL-AMT.     
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ  THRU 6235-EXIT.          
           INITIALIZE   WS-SYSIPT                                       
           PERFORM 0600-PREPARE-FOR-RESTART    THRU 0600-EXIT.          
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
           IF  WS-THIS-IS-A-RESTART                                     
              PERFORM 0700-OPEN-RESTART        THRU 0700-EXIT           
           ELSE                                                         
               PERFORM 0610-INITIALIZE-RESTART THRU 0610-EXIT           
               MOVE WS-INPUT-DATE              TO WS-RESTART-INPUT-DATE 
           END-IF.                                                      
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              OPEN EXTEND CA461RPT-FILE                                 
           ELSE                                                         
              OPEN OUTPUT CA461RPT-FILE                                 
           END-IF                                                       
      *                                                                         
           IF WS-RPT461-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR OUTPUT FILE' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-RPT461-STATUS                         DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
      *                                                                         
           MOVE SPACES                   TO CA461RPT-REC.               
      *                                                                         
           PERFORM 7000-READ-RECORD                                     
              THRU 7000-EXIT.                                           
      *                                                                         
           PERFORM 1000-LOAD-CA10                                       
              THRU 1000-EXIT                                            
                   UNTIL WS-FIOAC10-AT-EOF.                             
      *                                                                         
           IF WS-RECORD-READ NOT     = WS-FAC10-HDR-RECORD-COUNT        
              OR WS-TOT-PYMT-AMT NOT = WS-FAC10-HDR-TOTAL-AMT THEN      
              MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH      
              DISPLAY 'HEADER    - COUNT :' WS-FAC10-HDR-RECORD-COUNT   
              DISPLAY 'PROCESSED - COUNT :' WS-RECORD-READ              
              DISPLAY 'HEADER    - AMOUNT:' WS-FAC10-HDR-TOTAL-AMT      
              DISPLAY 'PROCESSED -AMOUNT :' WS-TOT-PYMT-AMT             
              STRING  'COUNT OR AMOUNT FROM FILE  HEADER     **'        
                                            DELIMITED BY SIZE           
                                           INTO WS-ERR-MSG              
              STRING  'DIDNOT MATCH WITH COUNT/AMOUNT PROCESSED'        
                                            DELIMITED BY SIZE           
                                           INTO WS-ERR-MSG2             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                  THRU 8900-EXIT                                        
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                         TO                       
                                               WS-RESTART-JOB-COMPLETE. 
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED           TO TRUE                  
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8897-WRITE-RSDDR         THRU 8897-EXIT           
           END-IF.                                                      
           IF  WS-RESTART-REQ EQUAL WS-Y                                
               PERFORM 8893-RESET-RESTART-REQ-PARM                      
                                               THRU 8893-EXIT           
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 0200-OPEN-FILE                                       
              THRU 0200-EXIT.                                           
      *                                                                         
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT                                            
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
           INITIALIZE   WS-SYSIPT                                       
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'          
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0200-OPEN-FILE                                              **        
      ******************************************************************        
       0200-OPEN-FILE.                                                  
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           OPEN INPUT FIOAC10-FILE.                                     
      *                                                                         
           IF WS-FIOAC10-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  '** FILE OPEN ERROR INPUT FILE*' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
              WS-FIOAC10-STATUS                        DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
      *                                                                         
           INITIALIZE FIOAC10.                                          
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *----------------------------------------------------------------*        
      *   GET THE CURRENT DATE, TIME AND RUN DATE FROM JOB PARM TABLE  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                 TO WS-ACTIVE-PARAGRAPH           
      *                                                                         
           PERFORM 7710-GET-CURRENT-TIMESTAMP                           
              THRU 7710-EXIT.                                           
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT                                            
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '          TO WS-PGRMNAME                   
              MOVE SPACES              TO WS-INPUT-AREA                 
              MOVE SPACES              TO WS-INPUT-DATA-BREAKDOWN       
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE WS-PROGRAM-NAME     TO WS-PGRMNAME                   
           END-IF                                                       
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-COMMONDATE.                
           MOVE WS-CD-YYYY             TO WS-CD-YYYY-8.                 
           MOVE WS-CD-MM               TO WS-CD-MM-8.                   
           MOVE WS-CD-DD               TO WS-CD-DD-8.                   
           MOVE WS-COMMONDATE-8 TO WS-COMMONDATE-8-INT.                 
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    0600-PREPARE-FOR-RESTART                                             
      *****************************************************************         
      *                                                                         
       0600-PREPARE-FOR-RESTART.                                        
      *                                                                         
           MOVE WS-PGRMNAME                  TO RF-NAME-PROGRAM.        
           MOVE WS-ONE                       TO RF-PARTITION-NO.        
           MOVE WS-ONE                       TO RF-DUP-CNTRL-NO         
           PERFORM 7450-SELECT-RESTART-DATA  THRU 7450-EXIT.            
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA         
               IF  WS-RESTART-PROCESS-TYPE NUMERIC                      
                   MOVE WS-Y                 TO WS-IS-THIS-A-RESTART    
              ELSE                                                      
                 GO TO 0600-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              GO TO 0600-EXIT                                           
           END-IF.                                                      
      *                                                                         
      *****************************************************************         
      *    REPOSITION INPUT FILE                                                
      *****************************************************************         
      *                                                                         
           PERFORM 7000-READ-RECORD       THRU 7000-EXIT                
             UNTIL WS-RECORD-READ         EQUAL                         
                                             WS-RESTART-RECON-RECS-READ.
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA461  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
           MOVE WS-RESTART-RECON-RECS-READ   TO WS-RECORD-READ.         
           MOVE WS-RESTART-OUTPUT-RECS       TO WS-OUTPUT-RECS          
           MOVE WS-RESTART-TOT-PYMT-AMT      TO WS-TOT-PYMT-AMT         
           MOVE WS-RESTART-TOT-TRNS-AMT      TO WS-TOT-TRNS-AMT         
           MOVE ZERO                         TO                         
                                         WS-RESTART-RECON-RECS-READ.    
           MOVE ZERO                         TO                         
                                         WS-RESTART-OUTPUT-RECS.        
      *                                                                         
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE  EQUAL WS-INPUT-DATE                
             OR WS-RESTART-INPUT-DATE EQUAL SPACES                      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                                         
      *    0605-VALIDATE-RESTART                                                
      *                                                                         
      *****************************************************************         
      *                                                               *         
       COPY CPD00030.                                                           
      *                                                               *         
      *****************************************************************         
      *    0610-INITIALIZE-RESTART                                    *         
      *****************************************************************         
       0610-INITIALIZE-RESTART.                                         
      *                                                                         
           MOVE ZEROS                    TO WS-RESTART-PROCESS-TYPE.    
           MOVE SPACES                   TO WS-RESTART-INPUT-DATE.      
           MOVE ZEROS                    TO WS-RESTART-CHKP-SEQ-NO.     
           MOVE ZEROS                    TO WS-RESTART-RECON-RECS-READ. 
           MOVE ZEROS                    TO WS-RESTART-OUTPUT-RECS.     
           MOVE ZEROS                    TO WS-RESTART-TOT-PYMT-AMT.    
           MOVE ZEROS                    TO WS-RESTART-TOT-TRNS-AMT.    
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *------------------*                                                      
       0700-OPEN-RESTART.                                               
      *------------------*                                                      
           OPEN INPUT CA461RPR-FILE.                                    
      *                                                                         
           IF WS-RPT461R-SUCCESSFUL                                     
              CONTINUE                                                  
           ELSE                                                         
              STRING  '**0700-ERROR ON CA461RPR OPEN*' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
                                   WS-RPT461R-STATUS   DELIMITED BY SIZE
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
      *                                                                         
           OPEN OUTPUT CA461RPT-FILE.                                   
           IF WS-RPT461-SUCCESSFUL                                      
              CONTINUE                                                  
           ELSE                                                         
              STRING  '**0700-ERROR ON CA461RPT OPEN*' DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
                                   WS-RPT461-STATUS   DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF                                                       
      *                                                                         
           PERFORM WS-OUTPUT-RECS TIMES                                 
              READ CA461RPR-FILE                                        
              IF WS-RPT461R-SUCCESSFUL                                  
                 WRITE CA461RPT-REC  FROM CA461RPR-REC                  
                 IF WS-RPT461-SUCCESSFUL                                
                    CONTINUE                                            
                 ELSE                                                   
                    STRING  '0700-ERROR ON CA461RPT REWRITE'            
                                                       DELIMITED BY SIZE
                                    'FILE STATUS = '   DELIMITED BY SIZE
                                   WS-RPT461-STATUS   DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
                    PERFORM 8900-DISPLAY-ERR-TERM                       
                       THRU 8900-EXIT                                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON CA461 RESTART'               
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 8900-DISPLAY-ERR-TERM                          
                    THRU 8900-EXIT                                      
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           CLOSE CA461RPT-FILE                                          
                 CA461RPR-FILE.                                         
      *                                                                         
        0700-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      **1000-LOAD-CA10.                                               **        
      ******************************************************************        
       1000-LOAD-CA10.                                                  
      *---------------*                                                         
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE E-FAC10-DET-ACCT-NO      TO WS-FAC10-ACCT-NO.           
           MOVE E-FAC10-DET-TIMESTAMP    TO WS-FAC10-PAYMENT-TS.        
           MOVE E-FAC10-DET-ID-TYPE      TO WS-FAC10-ID-TYPE.           
           MOVE E-FAC10-DET-PYMT-AMT     TO WS-FAC10-PYMT-AMT.          
           MOVE E-FAC10-DET-SOURCE       TO WS-FAC10-SOURCE.            
           IF E-FAC06-DET-TERM-ID(2:1) = 'X'                            
              MOVE 'Y'                   TO WS-NON-CONT-PYMT-FL         
           ELSE                                                         
              MOVE 'N'                   TO WS-NON-CONT-PYMT-FL         
           END-IF.                                                      
           IF WS-FAC10-ID-TYPE = 'C'                                    
              SUBTRACT WS-FAC10-PYMT-AMT FROM WS-TOT-PYMT-AMT           
           ELSE                                                         
              ADD WS-FAC10-PYMT-AMT      TO WS-TOT-PYMT-AMT             
           END-IF                                                       
      *                                                                         
           PERFORM 2400-POPULATE-PYMT-TABLE                             
               THRU 2400-EXIT.                                          
           IF WS-FAC10-ID-TYPE = 'C' THEN                               
                MOVE E-FAC10-DET-TIMESTAMP                              
                                         TO JT-ORIG-PYMT-TS             
                PERFORM 7327-SELECT-RVSL-INFO                           
                    THRU 7327-EXIT                                      
                MOVE 0                   TO WS-NULL-INDICATOR1          
                MOVE 'R'                 TO JT-TRANS-TYPE-CD            
           ELSE                                                         
                PERFORM 7325-SELECT-PYMT-INFO                           
                    THRU 7325-EXIT                                      
                MOVE  -1                 TO WS-NULL-INDICATOR1          
                MOVE 'P'                 TO JT-TRANS-TYPE-CD            
           END-IF.                                                      
      ****   *   N  *  O   *   *   T    *    E    *     *    ****               
      **** PLEASE TRY TO CHANG THIS IF LOGIC TO EVALUATE     ****               
      **** AS THIS WAS POINTED IN CODE REVIEW AFTER SYSTEM   ****               
      **** TEST WE ARE NOT CHANGING IT.                      ****               
      ****   *   N  *  O   *   *   T    *    E    *     *    ****               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND THEN                    
              PERFORM 7710-GET-CURRENT-TIMESTAMP                        
                 THRU 7710-EXIT                                         
                IF JT-TRANS-TYPE-CD = 'R'                               
                   MOVE WS-XFR-TS        TO JT-PYMT-RCVD-TS             
                END-IF                                                  
                MOVE WS-FAC10-PYMT-AMT   TO WS-FAC10-PYMT-AMT-COMP      
                MOVE WS-FAC10-PYMT-AMT-COMP                             
                                         TO JT-PAYMENT-AMT              
                IF WS-NON-CONT-PYMT-FL = 'Y' THEN                       
                     MOVE SPACES TO JT-ERROR-CD                         
                     MOVE 'PYMT/RVSL FROM NON-CONT AGNT'                
                                         TO WS-RPT-REJ-REASON           
                     PERFORM 2960-MOVE-REPORT-DETAIL                    
                        THRU 2960-EXIT                                  
                     PERFORM 7700-INSERT-PAYMENT-TRAN                   
                         THRU 7700-EXIT                                 
                ELSE                                                    
                     MOVE SPACES TO JT-ERROR-CD                         
                     MOVE 'PYMT/REVERSL NOT REAL-TIME  '                
                          TO WS-RPT-REJ-REASON                          
                     PERFORM 2960-MOVE-REPORT-DETAIL                    
                        THRU 2960-EXIT                                  
                     PERFORM 7700-INSERT-PAYMENT-TRAN                   
                         THRU 7700-EXIT                                 
                END-IF                                                  
           ELSE                                                         
                IF JT-PAYMENT-AMT NOT = WS-FAC10-PYMT-AMT THEN          
A00575               MOVE 'V'              TO JT-ERROR-CD(1:1)          
                     IF WS-FAC10-ID-TYPE = 'C' THEN                     
                        MOVE 'REVERSAL AMT NOT MATCHING'                
                          TO WS-RPT-REJ-REASON                          
                     ELSE                                               
                        MOVE 'PAYMENT AMT NOT MATCHING'                 
                          TO WS-RPT-REJ-REASON                          
                     END-IF                                             
                     PERFORM 2960-MOVE-REPORT-DETAIL                    
                        THRU 2960-EXIT                                  
                     PERFORM 8200-UPDATE-ERROR-CODE                     
                              THRU 8200-EXIT                            
                ELSE                                                    
                     IF JT-RECONCILED-FL = 'Y' THEN                     
A00575                    MOVE SPACES  TO JT-ERROR-CD(1:1)              
                          MOVE 'ALREADY RECONCILED'                     
                               TO WS-RPT-REJ-REASON                     
                          PERFORM 2960-MOVE-REPORT-DETAIL               
                             THRU 2960-EXIT                             
                     ELSE                                               
                          IF WS-NON-CONT-PYMT-FL = 'Y' THEN             
A00575                         MOVE '3' TO JT-ERROR-CD(1:1)             
                               PERFORM 8200-UPDATE-ERROR-CODE           
                                   THRU 8200-EXIT                       
                          ELSE                                          
                               PERFORM 8200-UPDATE-ERROR-CODE           
                                   THRU 8200-EXIT                       
                          END-IF                                        
                     END-IF                                             
                END-IF                                                  
           END-IF.                                                      
           ADD WS-ONE                   TO WS-CHKP-LUW-COUNTER          
           IF (WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT)             
             OR (WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT           
             OR GREATER WS-CHKP-UPD-LIMIT)                              
              PERFORM 8896-ISSUE-CHKP   THRU 8896-EXIT                  
           END-IF.                                                      
           PERFORM 7000-READ-RECORD                                     
              THRU 7000-EXIT.                                           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
      * MOVE VALUES TO PAYMENT TABLE                                 *          
      *--------------------------------------------------------------*          
      *                                                                         
       2400-POPULATE-PYMT-TABLE.                                        
      *                                                                         
           MOVE '2400'                       TO WS-ACTIVE-PARAGRAPH.    
           INITIALIZE DCLCSS-PAYMENT-TRANS                              
           MOVE E-FAC10-DET-ACCT-NO          TO JT-ACCOUNT-NO           
                                                AT-ACCOUNT-NO           
                                                WS-ACCOUNT-NO.          
           MOVE E-FAC10-DET-TIMESTAMP        TO JT-PYMT-RCVD-TS.        
      *                                                                         
           PERFORM 7328-SELECT-LOCAL-OFF                                
               THRU 7328-EXIT.                                          
           PERFORM 7329-SELECT-REPORT-DT                                
               THRU 7329-EXIT.                                          
           MOVE WS-PGRMNAME                  TO JT-APPL-PROGRAM-ID.     
           MOVE 'N'                          TO JT-APPLIED-FL.          
           MOVE SPACES                       TO JT-CUST-PHONE-NO.       
A00575     MOVE SPACES                       TO JT-ERROR-CD(1:1).       
           MOVE SPACES                       TO JT-PYMT-CONFIRM-NO.     
           MOVE 'A'                          TO JT-PYMT-FACILITY-CD.    
           MOVE SPACES                       TO JT-CREDIT-CARD-TYPE.    
           IF JT-CASH-LOCAL-OFFICE = '029'                              
              MOVE '01'                      TO JT-COMPANY-NO           
           ELSE                                                         
              PERFORM 7330-SELECT-COMPANY                               
                 THRU 7330-EXIT                                         
              MOVE AT-COMPANY-NO             TO JT-COMPANY-NO           
           END-IF                                                       
      *                                                                         
           EVALUATE E-FAC10-DET-PAY-TYPE                                
              WHEN '1'                                                  
                 MOVE 'A'                    TO JT-CURRENCY-TYPE        
              WHEN '4'                                                  
                 MOVE 'M'                    TO JT-CURRENCY-TYPE        
              WHEN OTHER                                                
                 MOVE 'C'                    TO JT-CURRENCY-TYPE        
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE E-FAC10-DET-ID-TYPE                                 
              WHEN 'M'                                                  
                 MOVE 'DIR'                  TO JT-DIRECTED-PYMT-CD     
              WHEN 'C'                                                  
                 MOVE 'REV'                  TO JT-DIRECTED-PYMT-CD     
              WHEN OTHER                                                
                 MOVE 'UND'                  TO JT-DIRECTED-PYMT-CD     
           END-EVALUATE.                                                
      *                                                                         
           MOVE E-FAC06-DET-TERM-ID          TO JT-TERMINAL-ID.         
           MOVE WS-COMMONDATE                TO JT-RECONCILED-DT.       
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  2960-MOVE-REPORT-DETAIL                                       *        
      ******************************************************************        
       2960-MOVE-REPORT-DETAIL.                                         
      *                                                                         
           MOVE '2960'                       TO WS-ACTIVE-PARAGRAPH.    
           MOVE JT-PAYMENT-AMT               TO WS-RPT-TAMOUNT.         
           MOVE WS-FAC10-PYMT-AMT            TO WS-RPT-AMOUNT.          
           IF JT-TRANS-TYPE-CD = 'P' THEN                               
              MOVE 'PAYMENT'                 TO WS-RPT-PYMT-TYPE        
           ELSE                                                         
              MOVE 'REVERSAL'                TO WS-RPT-PYMT-TYPE        
           END-IF.                                                      
           MOVE JT-ACCOUNT-NO                TO WS-RPT-ACCT-NO-DET.     
           MOVE JT-COMPANY-NO                TO WS-RPT-COMPANY-NO       
           MOVE JT-DATE-CASH-REPORT          TO WS-CASH-RPT-DATE        
           MOVE JT-CASH-LOCAL-OFFICE         TO WS-RPT-LOCAL-OFFICE     
      *                                                                         
           MOVE  WS-RPT-DTL                    TO CA461RPT-DATA.        
      *                                                                         
           PERFORM 8100-WRITE-RECORD                                    
              THRU 8100-EXIT.                                           
      *                                                                         
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  6235-GET-FJC01-RESTART-REQ.                                            
      *****************************************************************         
      *                                                                 01881000
       COPY CPD00035.                                                           
      *                                                                 07518000
      *****************************************************************         
      *  6253-GET-FJC01-CHKP-LIMIT.                                             
      *****************************************************************         
      *                                                                 01881000
       COPY CPD00034.                                                           
      *                                                                         
      *****************************************************************         
       7000-READ-RECORD.                                                
      *                                                                         
           MOVE '7000'                         TO WS-ACTIVE-PARAGRAPH.  
           READ FIOAC10-FILE                                            
           AT END                                                       
              SET WS-FIOAC10-AT-EOF TO TRUE                             
              MOVE HIGH-VALUE       TO FIOAC10                          
           END-READ.                                                    
      *                                                                         
           IF WS-FIOAC10-SUCCESSFUL OR WS-FIOAC10-AT-EOF                
              IF WS-FIOAC10-SUCCESSFUL                                  
                 ADD 1                         TO WS-RECORD-READ        
              ELSE                                                      
                GO TO 7000-EXIT                                         
              END-IF                                                    
           ELSE                                                         
              STRING  'READ ERROR OF FCS2040 INPUT FILE     **'         
                                                      DELIMITED BY SIZE 
              WS-FIOAC10-STATUS                       DELIMITED BY SIZE 
                                         INTO    WS-ERR-MSG             
              PERFORM 8900-DISPLAY-ERR-TERM                             
                 THRU 8900-EXIT                                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  7325-SELECT-PYMT-INFO                                       **        
      ******************************************************************        
       7325-SELECT-PYMT-INFO.                                           
      *------------------------*                                                
           MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
             SELECT TOP(1) PAYMENT_AMT,
              RECONCILED_FL                                       
              INTO :JT-PAYMENT-AMT,                                     
                   :JT-RECONCILED-FL                                    
               FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO        = :JT-ACCOUNT-NO                  
                AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
      *         AND DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                    
                AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
T34970                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PAYMENT_AMT,                                                
MFA-TR*             RECONCILED_FL                                               
MFA-TR*       INTO :JT-PAYMENT-AMT,                                             
MFA-TR*            :JT-RECONCILED-FL                                            
MFA-TR*        FROM CSS_PAYMENT_TRANS                                           
MFA-TR*       WHERE ACCOUNT_NO        = :JT-ACCOUNT-NO                          
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                        
MFA-TR*         AND DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7325-SELECT-PYMT-INFO                *'        
T33689        DISPLAY '* ACCOUNT NO ', JT-ACCOUNT-NO                    
T33689        DISPLAY '* PAYMENT RECVD', JT-PYMT-RCVD-TS                
T33689        DISPLAY '* CASH LOCAL OFFICE', JT-CASH-LOCAL-OFFICE       
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7327-SELECT-RVSL-INFO                                       **        
      ******************************************************************        
       7327-SELECT-RVSL-INFO.                                           
      *------------------------*                                                
           MOVE '7327'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) PAYMENT_AMT,
              REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS, 121), 
           ' ', '-'), ':', '.') PYMT_RCVD_TS,
              RECONCILED_FL                                       
              INTO :JT-PAYMENT-AMT,                                     
                   :JT-PYMT-RCVD-TS,                                    
                   :JT-RECONCILED-FL                                    
               FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO       = :JT-ACCOUNT-NO                   
                AND ORIG_PYMT_TS     = CIS.CHAR2TIMESTAMP(
                                                       :JT-ORIG-PYMT-TS
              )                 
      *         AND DATE_CASH_REPORT = :JT-DATE-CASH-REPORT                     
                AND CASH_LOCAL_OFFICE= :JT-CASH-LOCAL-OFFICE            
T34970                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PAYMENT_AMT,                                                
MFA-TR*             PYMT_RCVD_TS,                                               
MFA-TR*             RECONCILED_FL                                               
MFA-TR*       INTO :JT-PAYMENT-AMT,                                             
MFA-TR*            :JT-PYMT-RCVD-TS,                                            
MFA-TR*            :JT-RECONCILED-FL                                            
MFA-TR*        FROM CSS_PAYMENT_TRANS                                           
MFA-TR*       WHERE ACCOUNT_NO       = :JT-ACCOUNT-NO                           
MFA-TR*         AND ORIG_PYMT_TS     = :JT-ORIG-PYMT-TS                         
MFA-TR*         AND DATE_CASH_REPORT = :JT-DATE-CASH-REPORT                     
MFA-TR*         AND CASH_LOCAL_OFFICE= :JT-CASH-LOCAL-OFFICE                    
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7327-SELECT-RVSL-INFO                *'        
T33689        DISPLAY '* ACCOUNT NO   ', JT-ACCOUNT-NO                  
T33689        DISPLAY '* ORIG PYMT TS ', JT-ORIG-PYMT-TS                
T33689        DISPLAY '* CASH LOCAL OFF ', JT-CASH-LOCAL-OFFICE         
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7327-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7328-SELECT-LOCAL-OFF                                       **        
      ******************************************************************        
       7328-SELECT-LOCAL-OFF.                                           
      *------------------------*                                                
           MOVE '7328'                   TO WS-ACTIVE-PARAGRAPH.        
           MOVE WS-FAC10-SOURCE          TO Y2-PAYMENT-SOURCE-CD.       
           EXEC SQL                                                     
             SELECT CASH_LOCAL_OFFICE                                   
               INTO :JT-CASH-LOCAL-OFFICE                               
               FROM CSS_CASHIER_OFFICE                                  
              WHERE PAYMENT_SOURCE_CD = :Y2-PAYMENT-SOURCE-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7328-SELECT-LOCAL-OFF                *'        
T33689        DISPLAY '* CASH LOCAL OFF ', JT-CASH-LOCAL-OFFICE         
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7328-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  7329-SELECT-REPORT-DT                                       **        
      ******************************************************************        
       7329-SELECT-REPORT-DT.                                           
      *------------------------*                                                
           MOVE '7329'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) DATE_CASH_REPORT                                    
               INTO :JT-DATE-CASH-REPORT                                
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = '01'                           
                AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND CODE_CSH_DRWR_STAT= 'A'                             
                AND CASH_DRAWER_ID < 500                                
T33928         ORDER BY DATE_CASH_REPORT DESC                           
T33928                                              
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE_CASH_REPORT                                            
MFA-TR*        INTO :JT-DATE-CASH-REPORT                                        
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                           
MFA-TR*       WHERE CASH_COMPANY_NO    = '01'                                   
MFA-TR*         AND CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*         AND CODE_CSH_DRWR_STAT= 'A'                                     
MFA-TR*         AND CASH_DRAWER_ID < 500                                        
MFA-TR*        ORDER BY DATE_CASH_REPORT DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7329-SELECT-REPORT-DT                *'        
T33689        DISPLAY '* CASH_LOCAL_OFFICE ', JT-CASH-LOCAL-OFFICE      
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7329-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  7330-SELECT-COMPANY                                         **        
      ******************************************************************        
       7330-SELECT-COMPANY.                                             
      *--------------------*                                                    
           MOVE '7330'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
             SELECT COMPANY_NO                                          
               INTO :AT-COMPANY-NO                                      
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
T33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO                                                  
MFA-TR*        INTO :AT-COMPANY-NO                                              
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE '01'            TO AT-COMPANY-NO                  
              END-IF                                                    
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7330-SELECT-COMPANY                  *'        
T33689        DISPLAY '* ACCT NO        ', AT-ACCOUNT-NO                
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *** 7450-SELECT-RESTART-DATA.                                  ***        
      ******************************************************************        
       7450-SELECT-RESTART-DATA.                                        
           MOVE '7450'                   TO WS-ACTIVE-PARAGRAPH.        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7450-SELECT-RESTART-DATA             *'        
T33689        DISPLAY '* PROGRAM NAME   ', RF-NAME-PROGRAM              
T33689        DISPLAY '* PARTITION NO   ', RF-PARTITION-NO              
T33689        DISPLAY '* DUP CNTRL NO   ', RF-DUP-CNTRL-NO              
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07518000
      *****************************************************************         
      **  7700-INSERT-PAYMENT-TRAN.                                  **       * 
      **      INSERT INTO CSS_PAYMENT_TRANS                          **         
      *****************************************************************         
       7700-INSERT-PAYMENT-TRAN.                                        
      *------------------*                                                      
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE 'Y' TO JT-RECONCILED-FL.                                
           EXEC SQL                                                     
             INSERT INTO CSS_PAYMENT_TRANS                              
                ( DATE_CASH_REPORT                                      
                 ,CASH_LOCAL_OFFICE                                     
                 ,PYMT_RCVD_TS                                          
                 ,ACCOUNT_NO                                            
                 ,APPL_PROGRAM_ID                                       
                 ,APPLIED_FL                                            
                 ,APPLIED_TS                                            
                 ,COMPANY_NO                                            
                 ,CREDIT_CARD_TYPE                                      
                 ,CURRENCY_TYPE                                         
                 ,CUST_PHONE_NO                                         
                 ,DIRECTED_PYMT_CD                                      
                 ,ERROR_CD                                              
                 ,PAYMENT_AMT                                           
                 ,PYMT_CONFIRM_NO                                       
                 ,PYMT_FACILITY_CD                                      
                 ,LAST_UPDATE_USERID                                    
                 ,ORIG_PYMT_TS                                          
                 ,RECONCILED_FL                                         
                 ,TRANS_HIST_SEQ_NO                                     
                 ,TRANS_TYPE_CD                                         
                 ,RECONCILED_DT                                         
                 ,TERMINAL_ID                                           
                )                                                       
              VALUES                                                    
                (  IIF(TRY_CONVERT(DATE, :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )                         
                  ,:JT-CASH-LOCAL-OFFICE                                
                  ,CIS.CHAR2TIMESTAMP(:JT-PYMT-RCVD-TS)                         
                  ,:JT-ACCOUNT-NO                                       
                  ,:JT-APPL-PROGRAM-ID                                  
                  ,'N'                                                  
                  ,NULL                                                 
                  ,:JT-COMPANY-NO                                       
                  ,:JT-CREDIT-CARD-TYPE                                 
                  ,:JT-CURRENCY-TYPE                                    
                  ,:JT-CUST-PHONE-NO                                    
                  ,:JT-DIRECTED-PYMT-CD                                 
                  ,:JT-ERROR-CD                                         
                  ,:JT-PAYMENT-AMT                                      
                  ,:JT-PYMT-CONFIRM-NO                                  
                  ,:JT-PYMT-FACILITY-CD                                 
                  ,'SYSTEM'                                             
                  ,CIS.CHAR2TIMESTAMP(:JT-ORIG-PYMT-TS 
                                      :WS-NULL-INDICATOR1)                  
                  ,:JT-RECONCILED-FL                                    
                  ,NULL                                                 
                  ,:JT-TRANS-TYPE-CD                                    
                  ,IIF(TRY_CONVERT(DATE, :JT-RECONCILED-DT
              ) IS NULL OR (PATINDEX('%.%', :JT-RECONCILED-DT
              ) <> 0) OR (LEN(:JT-RECONCILED-DT) <> 10), CIS.CHAR2DATE(
                                                      :JT-RECONCILED-DT
              ), CONVERT(DATE, :JT-RECONCILED-DT) )                            
                  ,:JT-TERMINAL-ID                                      
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PAYMENT_TRANS                                      
MFA-TR*         ( DATE_CASH_REPORT                                              
MFA-TR*          ,CASH_LOCAL_OFFICE                                             
MFA-TR*          ,PYMT_RCVD_TS                                                  
MFA-TR*          ,ACCOUNT_NO                                                    
MFA-TR*          ,APPL_PROGRAM_ID                                               
MFA-TR*          ,APPLIED_FL                                                    
MFA-TR*          ,APPLIED_TS                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CREDIT_CARD_TYPE                                              
MFA-TR*          ,CURRENCY_TYPE                                                 
MFA-TR*          ,CUST_PHONE_NO                                                 
MFA-TR*          ,DIRECTED_PYMT_CD                                              
MFA-TR*          ,ERROR_CD                                                      
MFA-TR*          ,PAYMENT_AMT                                                   
MFA-TR*          ,PYMT_CONFIRM_NO                                               
MFA-TR*          ,PYMT_FACILITY_CD                                              
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,ORIG_PYMT_TS                                                  
MFA-TR*          ,RECONCILED_FL                                                 
MFA-TR*          ,TRANS_HIST_SEQ_NO                                             
MFA-TR*          ,TRANS_TYPE_CD                                                 
MFA-TR*          ,RECONCILED_DT                                                 
MFA-TR*          ,TERMINAL_ID                                                   
MFA-TR*         )                                                               
MFA-TR*       VALUES                                                            
MFA-TR*         (  :JT-DATE-CASH-REPORT                                         
MFA-TR*           ,:JT-CASH-LOCAL-OFFICE                                        
MFA-TR*           ,:JT-PYMT-RCVD-TS                                             
MFA-TR*           ,:JT-ACCOUNT-NO                                               
MFA-TR*           ,:JT-APPL-PROGRAM-ID                                          
MFA-TR*           ,'N'                                                          
MFA-TR*           ,NULL                                                         
MFA-TR*           ,:JT-COMPANY-NO                                               
MFA-TR*           ,:JT-CREDIT-CARD-TYPE                                         
MFA-TR*           ,:JT-CURRENCY-TYPE                                            
MFA-TR*           ,:JT-CUST-PHONE-NO                                            
MFA-TR*           ,:JT-DIRECTED-PYMT-CD                                         
MFA-TR*           ,:JT-ERROR-CD                                                 
MFA-TR*           ,:JT-PAYMENT-AMT                                              
MFA-TR*           ,:JT-PYMT-CONFIRM-NO                                          
MFA-TR*           ,:JT-PYMT-FACILITY-CD                                         
MFA-TR*           ,'SYSTEM'                                                     
MFA-TR*           ,:JT-ORIG-PYMT-TS:WS-NULL-INDICATOR1                          
MFA-TR*           ,:JT-RECONCILED-FL                                            
MFA-TR*           ,NULL                                                         
MFA-TR*           ,:JT-TRANS-TYPE-CD                                            
MFA-TR*           ,:JT-RECONCILED-DT                                            
MFA-TR*           ,:JT-TERMINAL-ID                                              
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-ONE                   TO WS-CHKP-UPD-COUNTER       
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7700-INSERT-PAYMENT-TRAN             *'        
T33689        DISPLAY '* ACCOUNT NO     ', JT-ACCOUNT-NO                
T33689        DISPLAY '* COMPANY NO     ', JT-COMPANY-NO                
T33689        DISPLAY '* APPLN PROG ID  ', JT-APPL-PROGRAM-ID           
T33689        DISPLAY '* CASH LOCAL OFF ', JT-CASH-LOCAL-OFFICE         
T33689        DISPLAY '* ERROR CODE     ', JT-ERROR-CD                  
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7710-GET-CURRENT-TIMESTAMP                                  **        
      **                                                              **        
      ******************************************************************        
       7710-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           MOVE '7710'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
T34097*    EXEC SQL                                                             
T34097*       SELECT CURRENT TIMESTAMP                                          
T34097*        INTO  :WS-XFR-TS                                                 
T34097*         FROM CSS_MODEL_SQL                                              
T34097*    END-EXEC.                                                            
      *                                                                         
T34097     EXEC SQL                                                     
T34097        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-XFR-TS                                         
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-XFR-TS                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 7710-GET-CURRENT-TIMESTAMP           *'        
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 8100-WRITE-RECORD                                           *          
      ****************************************************************          
       8100-WRITE-RECORD.                                               
      *                                                                         
           MOVE '8100'                         TO WS-ACTIVE-PARAGRAPH.  
      *                                                                         
           WRITE CA461RPT-REC.                                          
      *                                                                         
           IF WS-RPT461-SUCCESSFUL                                      
              ADD +1                            TO WS-OUTPUT-RECS       
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 8100-WRITE-RECORD                    *'        
T33689        DISPLAY '* FILE-STATUS    ', WS-RPT461-STATUS             
T33689        DISPLAY '* RECORD CNT ', WS-OUTPUT-RECS                   
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * UPDATES A PAYMENT RECORD AS ERROR IN CSS_PAYMENT_TRANS TABLE  *         
      *---------------------------------------------------------------*         
      *                                                                         
        8200-UPDATE-ERROR-CODE.                                         
      *                                                                         
           MOVE '8200'                         TO WS-ACTIVE-PARAGRAPH.  
           EXEC SQL                                                     
             UPDATE CSS_PAYMENT_TRANS                                   
                SET ERROR_CD           = :JT-ERROR-CD                   
                   ,RECONCILED_FL      = 'Y'                            
                   ,RECONCILED_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :JT-RECONCILED-DT
              ) IS NULL OR (PATINDEX('%.%', :JT-RECONCILED-DT
              ) <> 0) OR (LEN(:JT-RECONCILED-DT) <> 10), CIS.CHAR2DATE(
                                                      :JT-RECONCILED-DT
              ), CONVERT(DATE, :JT-RECONCILED-DT) )              
                   ,LAST_UPDATE_USERID = 'SYSTEM'                       
                   ,TERMINAL_ID        = :JT-TERMINAL-ID                
      *       WHERE DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT                   
              WHERE                                                     
                    CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE          
                AND PYMT_RCVD_TS       = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                AND ACCOUNT_NO         = :JT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                           
MFA-TR*         SET ERROR_CD           = :JT-ERROR-CD                           
MFA-TR*            ,RECONCILED_FL      = 'Y'                                    
MFA-TR*            ,RECONCILED_DT      = :JT-RECONCILED-DT                      
MFA-TR*            ,LAST_UPDATE_USERID = 'SYSTEM'                               
MFA-TR*            ,TERMINAL_ID        = :JT-TERMINAL-ID                        
MFA-TR*       WHERE DATE_CASH_REPORT   = :JT-DATE-CASH-REPORT                   
MFA-TR*       WHERE                                                             
MFA-TR*             CASH_LOCAL_OFFICE  = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*         AND PYMT_RCVD_TS       = :JT-PYMT-RCVD-TS                       
MFA-TR*         AND ACCOUNT_NO         = :JT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD WS-ONE                   TO WS-CHKP-UPD-COUNTER       
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 8200-UPDATE-ERROR-CODE               *'        
T33689        DISPLAY '* ACCOUNT NO      ', JT-ACCOUNT-NO               
T33689        DISPLAY '* ERROR CODE      ', JT-ERROR-CD                 
T33689        DISPLAY '* CASH LOCAL OFF  ', JT-CASH-LOCAL-OFFICE        
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 8893-RESET-RESTART-REQ-PARM                                    *        
      * 8894-COUNT-RESTART-DATA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *** 8896-ISSUE-CHKP.                                           ***        
      ******************************************************************        
       8896-ISSUE-CHKP.                                                 
      *                                                                         
           MOVE '8896'                      TO WS-ACTIVE-PARAGRAPH.     
           IF WS-CHKP-LUW-LIMIT     EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              GO TO 8896-EXIT                                           
           END-IF.                                                      
           ADD WS-ONE                       TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           PERFORM 8897-WRITE-RSDDR         THRU 8897-EXIT.             
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
                   'LAST ENTRY PROCESSED = '                            
                    WS-RESTART-RECON-RECS-READ                          
           MOVE ZERO                        TO WS-CHKP-LUW-COUNTER      
                                               WS-CHKP-UPD-COUNTER.     
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8897-WRITE-RSDDR.                                                
      *                                                                         
           MOVE WS-ONE                      TO RF-PARTITION-NO.         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE WS-ONE                      TO RF-DUP-CNTRL-NO          
           MOVE WS-RECORD-READ              TO                          
                                            WS-RESTART-RECON-RECS-READ. 
           MOVE WS-OUTPUT-RECS              TO                          
                                            WS-RESTART-OUTPUT-RECS.     
           MOVE WS-TOT-PYMT-AMT             TO WS-RESTART-TOT-PYMT-AMT  
           MOVE WS-TOT-TRNS-AMT             TO WS-RESTART-TOT-TRNS-AMT  
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
           PERFORM 8898-UPDATE-RESTART      THRU 8898-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8899-INSERT-RESTART   THRU 8899-EXIT              
           END-IF.                                                      
      *                                                                         
       8897-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *** 8898-UPDATE-RESTART.                                   ***            
      ****************************************************************          
       8898-UPDATE-RESTART.                                             
      *                                                                         
           MOVE '8898'                      TO WS-ACTIVE-PARAGRAPH.     
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 8898-UPDATE-RESTART                  *'        
T33689        DISPLAY '* NAME_PROGRAM ', RF-NAME-PROGRAM                
T33689        DISPLAY '* PARTITION NO ', RF-PARTITION-NO                
T33689        DISPLAY '* DUP CNTL  NO ', RF-DUP-CNTRL-NO                
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF
           END-IF.                                                      
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *** 8899-INSERT-RESTART                                        ***        
      ******************************************************************        
       8899-INSERT-RESTART.                                             
           MOVE '8899'                      TO WS-ACTIVE-PARAGRAPH.     
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        DISPLAY '* 8899-INSERT-RESTART                  *'        
T33689        DISPLAY '* PROGRAM NAME ', RF-NAME-PROGRAM                
T33689        DISPLAY '* PARTITION NO ', RF-PARTITION-NO                
T33689        DISPLAY '* DUP CNTL  NO ', RF-DUP-CNTRL-NO                
T33689        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
T33689        DISPLAY '* PROGRAM ABORTING...                  *'        
T33689        DISPLAY '********** PCSCA461 ABORT **************'        
T33689        PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
      *                                                                         
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8900-DISPLAY-ERR-TERM                                       **        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
      *                                                                         
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSCA461 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      **  NORMAL TERMINATION OF THE PROGRAM                           **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
      *                                                                         
           CLOSE FIOAC10-FILE.                                          
           CLOSE CA461RPT-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      **** COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE ****                    
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
      *                                                                         
      **** START FCSJC01 FILE USING E-FJC01-KEY ****                            
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
      *                                                                         
      **** PERFORMED IF VSAM OR DB2 PROBLEM OCCURS(9900-ABEND) ****             
      *                                                                         
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
