       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA456.                                           
       AUTHOR.      PALASH DAS.                                         
COB303 DATE-WRITTEN. JULY 2004.                                          
COB303*************************************************************             
COB303**          SOUTH CAROLINA ELECTRIC & GAS              **                 
COB303*************************************************************             
COB303**       CALLING PROGRAMME:  CSR03451                  **                 
COB303*************************************************************             
COB303**                  S U M M A R Y                          **             
COB303**  UPDATE ACCOUNT SCORE TABLE & CREDIT PROFILE TABLE      **             
COB303**  GETTING WTG SCORE/MATRIX SCORE                         **             
COB303*************************************************************             
COB303**    SUPPLIED PARAMETERS TO SP                            **             
COB303**         TIMESTAMP                    TIMESTAMP          **             
COB303**         ACCOUNT_NO                   CHAR(13)           **             
COB303**         BEACON_SCORE                 CHAR(05)           **             
COB303**         BILL_NO                      CHAR(05)           **             
COB303**         BATCH_CD                     CHAR(??)           **             
COB303**                                                         **             
COB303**    OUTPUT PARAMETERS FROM SP                            **             
COB303**         CELL_SCORE                   CHAR(08)           **             
COB303**         WGT_SCORE                    CHAR(08)           **             
COB303**         RATING                       CHAR(01)           **             
COB303**         RETURN_CODE                  INTEGER            **             
COB303**    INOUT                                                **             
COB303**         NONE                                            **             
COB303**                                                         **             
COB303*************************************************************             
COB303**              MODIFICATION LOG                           **             
COB303*************************************************************             
COB303**           DATE       INITIALS   COMMENTS                **             
COB303*************************************************************             
COB303** C30257*-- 06/07/2004 PALASH DAS FIX BHV SCORING PROBLEM **             
COB303** C30070*-- 08/11/2004 SS82048    UPDATE CREDIT HIST      **             
COB303** C33193*-- 09/07/2005 SS82048    REMOVE DISPLAY STMTS.   **             
COB303**                                 ALL BEACON SCORES WILL  **             
COB303**                                 BE FROM CSS_CREDIT_HIST **             
COB303**                                 A DUMMY VSAM FILE WILL  **             
COB303**                                 BE USED.                               
COB303** PRDFIX    09/21/2006 SS82048    CHANGED COMMIT FREQUENCY**             
COB303**                                 FROM 1000 TO 100 TO FIX **             
COB303**                                 V8 NFM.                 **             
COB303** A04776    08/29/2013 AS7C117    REMOVED UNUSED COPYBOOK **             
COB303**                                 CWS0068L AND DCLGENS    **             
COB303** A05136    10/14/2015 DB41297    REMOVE CSR03450 CALLS.  **             
COB303** A05460    04/20/2016 MS7M727    TO REMOVE VSAM FILE     **             
COB303**                      ACT129     RELATED CODE            **             
COB303** A05460    08/18/2016 BD09555    CORRECT SPELLING OF     **             
COB303** A05460-ACT258        ACT258     'SUSAGE' TO 'USAGE'     **             
COB303**************************************************************    ****    
COB303*           ---- BASIC BATCH SEQUENCE STRUCTURE ---- *                    
COB303**************************************************************            
COB303  0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION            
COB303  1000 - 1999     INPUT PROCESSING CONTROL PATH                   
COB303  2000 - 2999     OUTPUT PROCESSING CONTROL PATH                  
COB303  3000 - 4999     BATCH PROCESSING MODULES - NOT USED             
COB303  5000 - 5999     COMMON PROGRAM MODULES                          
COB303  6000 - 6999     COMMON SYSTEM MODULES                           
COB303  7000 - 7999     INPUT MODULES                                   
COB303  8000 - 8999     OUTPUT MODULES                                  
COB303  9000 - 9799     TERMINATION MODULES                             
COB303  9800 - 9899     XCTLS TO PROGRAMS                               
COB303  9900 - 9999     ABEND/ABORT MODULES                             
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.   IBM-370.                                      
       OBJECT-COMPUTER.   IBM-370.                                      
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA456'.
MSQ017     COPY MFASQLM.
      **************************************************************    --------
      *    DB2 INCLUDES                                            *            
      **************************************************************    --------
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_MODEL_SQL                                                           
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      **************************************************************    ****    
      **   CSS_CREDIT_PROFILE                                     **            
      **************************************************************    ****    
           EXEC SQL                                                             
            INCLUDE TBCRPROF                                                    
           END-EXEC.                                                            
      **************************************************************    ****    
      **   CSS_CREDIT_HISTORY **                                                
      **************************************************************    ****    
           EXEC SQL                                                             
            INCLUDE TBCRHIST                                                    
           END-EXEC.                                                            
      **************************************************************            
      **   CSS_ACCOUNT                                            **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE **                                                
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBACSCRE                                                    
           END-EXEC                                                             
      **************************************************************            
      *    CSS_BHV_MODEL                                          **            
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHMODL                                                    
           END-EXEC                                                             
      **************************************************************            
                                                                        
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY CWS00010.                                                       
           COPY FIOJC01.                                                        
      ***************************************************************   ****    
      *    DB2 COMMUNICATION REQUIREMENT *                                      
      ***************************************************************   ****    
ACT258*01  LOC1                   USAGE IS SQL TYPE IS                  
      *                          RESULT-SET-LOCATOR VARYING.            
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
           02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
                                 INDEXED BY ERROR-INDEX.                
       77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
       77  TRACE-MESSAGE-AREA    PIC X(256).                            
       77  OPENFN                PIC X(12).                             
       77  SSID                  PIC X(4).                              
       77  PLANNAME              PIC X(8).                              
       77  RETCODE               PIC S9(5).                             
       77  REASCODE              PIC S9(5).                             
       77  CLOSFN                PIC X(12).                             
       77  TERMOP                PIC X(4).                              
                                                                        
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-TIMESTAMP         PIC X(26)   VALUE SPACES.              
          05 S-COMPANY-NO        PIC X(04)   VALUE SPACES.              
          05 S-BILLED-BALANCE    PIC X(13)   VALUE SPACES.              
          05 S-CANCEL-DNP-FLAG   PIC X(01)   VALUE SPACES.              
      ************************************************************              
      **  ERROR PROCESSING VARIABLES                            **              
      ************************************************************              
       01  WS-CSRERLOG-P.                                               
           10  WS-SP-NAME               PIC X(18)  VALUE SPACES.        
           10  WS-SQLCODE               PIC S9(9)  VALUE 0 COMP.        
           10  WS-SQLSTATE              PIC X(05)  VALUE SPACES.        
           10  WS-TABLE-NAME            PIC X(18)  VALUE SPACES.        
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L  PIC S9(4)  USAGE COMP.          
                   49  WS-ABEND-SQLERRMC-V  PIC X(255).                 
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG              PIC X(100) VALUE SPACES.         
           05  WS-ERR-MSG2             PIC X(100) VALUE SPACES.         
       01  WS-FCA456-STATUS            PIC XX.                          
           88  FCA456-SUCCESSFUL     VALUE '00'.                        
       01  WS-FCA456-EMPTY-FLG         PIC X(01) VALUE 'N'.             
       01  WS-GTT-RETURN-FIELDS.                                        
           10 WS-RETURN-CODE           PIC S9(9)  VALUE 0 COMP.         
           10 WS-TIMESTAMP             PIC X(26)  VALUE SPACES.         
           10 WS-COMPANY-NO            PIC X(04)  VALUE SPACES.         
       01  WS-CONSTANTS.                                                
           05  WS-SYSTEM               PIC X(07) VALUE 'SYSTEM'.        
           05  WS-PCSCA456             PIC X(08) VALUE 'PCSCA456'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03413'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'CSR03413'.      
           05  WS-USER-ABEND-CODE       PIC S9(4) COMP VALUE +100.      
           05  WS-JRNL-NAME            PIC X(04) VALUE '3413'.          
           05  WS-1                    PIC X(01) VALUE '1'.             
           05  WS-2                    PIC X(01) VALUE '2'.             
           05  WS-3                    PIC X(01) VALUE '3'.             
           05  WS-4                    PIC X(01) VALUE '4'.             
           05  WS-5                    PIC X(01) VALUE '5'.             
           05  WS-6                    PIC X(01) VALUE '6'.             
           05  WS-R                    PIC X(01) VALUE 'R'.             
           05  WS-C                    PIC X(01) VALUE 'C'.             
           05  WS-ONE                  PIC 9(01) VALUE 1.               
           05  WS-TWO                  PIC 9(01) VALUE 2.               
           05  WS-THREE                PIC 9(01) VALUE 3.               
           05  WS-FOUR                 PIC 9(01) VALUE 4.               
           05  WS-FIVE                 PIC 9(01) VALUE 5.               
           05  WS-SIX                  PIC 9(01) VALUE 6.               
           05  WS-SEVEN                PIC 9(01) VALUE 7.               
           05  WS-EIGHT                PIC 9(01) VALUE 8.               
           05  WS-NINE                 PIC 9(01) VALUE 9.               
           05  WS-HUNDRED              PIC 9(03) VALUE 100.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-X                    PIC X(01) VALUE 'X'.             
           05  WS-TRAN-COMMENT-LEN     PIC S9(04) COMP VALUE +19.       
           05  WS-TRAN-COMMENT-TEXT    PIC X(34) VALUE                  
                                       'THIRD PARTY JOURNAL'.           
       01  WS-SWITCHES.                                                 
           05 WS-INPUT-ERROR-SW        PIC X(01) VALUE SPACES.          
       01  WS-NULL-IND1                PIC S9(04) COMP   VALUE +0.      
       01  WS-NULL-IND2                PIC S9(04) COMP   VALUE +0.      
       01  WS-MISC-ITEMS.                                               
           05  WS-ACCOUNT-NO               PIC X(13).                   
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                           PIC 9(13).                   
           05  WS-CUSTOMER-NO              PIC X(10).                   
           05  WS-CUSTOMER-NO-NUM REDEFINES WS-CUSTOMER-NO              
                                           PIC 9(10).                   
           05  RS-RETURN-CODE          PIC S9(9)  VALUE 0 COMP.         
           05  WS-RECORD-COUNT         PIC S9(9)  VALUE 0 COMP.         
           05  WS-REV-DATE.                                             
               10 WS-REV-YY            PIC X(04)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-MM            PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-REV-DD            PIC X(02)  VALUE '01'.           
           05  WS-RUN-DATE.                                             
               10 WS-RUN-CC            PIC X(02)  VALUE SPACES.         
               10 WS-RUN-YY            PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-RUN-MM            PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-RUN-DD            PIC X(02)  VALUE '01'.           
           05  WS-TEMP-BHV-RATNG-HIST.                                  
               10  WS-CURR-BHV-RATNG   PIC X(01)  VALUE SPACES.         
               10  WS-BHV-RATNG-HIST   PIC X(23)  VALUE SPACES.         
      ************************************************************              
      **       VARIABLES IN USE                                 **              
      ************************************************************              
       01  WS-WORKING-VARIABLES.                                        
           05  S-ACCOUNT-NO            PIC X(13)   VALUE SPACES.        
           05  S-BEACON-SCORE          PIC X(05)   VALUE SPACES.        
           05  S-COMPANY-NO            PIC X(02).                       
           05  S-REGULATED-FL          PIC X(01).                       
           05  S-DATE-BILLED           PIC X(10).                       
           05  S-REVENUE-MONTH         PIC X(02).                       
           05  S-MODEL-ID              PIC X(04).                       
           05  S-EXEMPT-CD             PIC X(01).                       
           05  S-BILL-NO               PIC 9(05).                       
           05  WS-LAST-REVENUE-MONTH   PIC X(02).                       
           05  WS-REVENUE-MONTH        PIC X(02).                       
           05  WS-BHV-HIST             PIC X(24)  VALUE SPACES.         
           05  WS-BHV-HIST-TEMP        PIC X(24)  VALUE SPACES.         
           05  WS-EXEMPT-FL            PIC X(01).                       
           05  WS-CURRENT-DATE.                                         
               10 WS-CURRENT-YEAR      PIC X(04)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-CURRENT-MONTH     PIC X(02)  VALUE SPACES.         
               10 FILLER               PIC X(01)  VALUE '-'.            
               10 WS-CURRENT-DATE      PIC X(02)  VALUE SPACES.         
       01 WS-ACCT-CREATE-DT.                                            
          05  WS-ACCT-CREATE-YEAR     PIC X(04).                        
          05  WS-ACCT-CREATE-MONTH    PIC X(02).                        
          05  WS-ACCT-CREATE-DATE     PIC X(02).                        
      ************************************************************              
      ** INPUT VARIABLES                                        **              
      ************************************************************              
       01  WS-INPUT-PARAMETERS.                                         
           05  I-ACCOUNT-NO         PIC X(13).                          
           05  I-BILL-NO            PIC X(05).                          
           05  I-MODEL-ID           PIC X(04).                          
           05  I-BEACON-SCORE       PIC X(05).                          
           05  I-BATCH-CD           PIC X(01).                          
           05  I-UPDATE-FLAG        PIC X(05).                          
      ************************************************************              
      **  OUTPUT VARIABLES                                      **              
      ************************************************************              
       01  WS-OUTPUT-PARAMETERS.                                        
           05 S-RETURN-CODE                  PIC S9(9) COMP.            
COB305     05 S-CELL-SCORE        PIC S9(8)V9(2) COMP-3 VALUE 0.     
           05 S-WGT-SCORE                    PIC X(4).                  
           05 S-RATING                       PIC X(01).                 
           05 S-ERROR-MSG                    PIC X(20).                 
      ************************************************************              
      *  CURSOR TO SELECT RECORDS FROM CSS_BHV_ACCT_SCORE        *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                    
             SELECT ACCOUNT_NO                                          
                  , COMPANY_NO                                          
                  , REGULATED_FL                                        
                  , DATE_BILLED                                         
                  , REVENUE_MONTH                                       
                  , BHV_MODEL_ID                                        
                  , BHV_SCORE_RATING                                    
                  , BHV_EXEMPT_CD                                       
                  , BILL_NO                                             
                  , BEACON_SCORE                                        
                  , BHV_SCOR_VALU_CELL                                  
                  , BHV_SCORE_VALU_WGT                                  
                  , LAST_UPDATE_USERID                                  
                  , REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                  , BHV_SCORED_DT                                       
               FROM CSS_BHV_ACCT_SCORE                                  
              WHERE SCORED_FL <> :WS-YES                                
                AND BHV_MODEL_ID NOT IN ('0',' ', '')                   
               FOR UPDATE OF  SCORED_FL                                 
                             ,BHV_SCOR_VALU_CELL                        
                             ,BHV_SCORE_VALU_WGT                        
                             ,BHV_SCORE_RATING                          
                             ,LAST_UPDATE_USERID                        
                             ,LAST_UPDATE_TS                            
                             ,BHV_SCORED_DT                             
                             ,BEACON_SCORE                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*           , COMPANY_NO                                                  
MFA-TR*           , REGULATED_FL                                                
MFA-TR*           , DATE_BILLED                                                 
MFA-TR*           , REVENUE_MONTH                                               
MFA-TR*           , BHV_MODEL_ID                                                
MFA-TR*           , BHV_SCORE_RATING                                            
MFA-TR*           , BHV_EXEMPT_CD                                               
MFA-TR*           , BILL_NO                                                     
MFA-TR*           , BEACON_SCORE                                                
MFA-TR*           , BHV_SCOR_VALU_CELL                                          
MFA-TR*           , BHV_SCORE_VALU_WGT                                          
MFA-TR*           , LAST_UPDATE_USERID                                          
MFA-TR*           , LAST_UPDATE_TS                                              
MFA-TR*           , BHV_SCORED_DT                                               
MFA-TR*        FROM CSS_BHV_ACCT_SCORE                                          
MFA-TR*       WHERE SCORED_FL <> :WS-YES                                        
MFA-TR*         AND BHV_MODEL_ID NOT IN ('0',' ', '')                           
MFA-TR*        FOR UPDATE OF  SCORED_FL                                         
MFA-TR*                      ,BHV_SCOR_VALU_CELL                                
MFA-TR*                      ,BHV_SCORE_VALU_WGT                                
MFA-TR*                      ,BHV_SCORE_RATING                                  
MFA-TR*                      ,LAST_UPDATE_USERID                                
MFA-TR*                      ,LAST_UPDATE_TS                                    
MFA-TR*                      ,BHV_SCORED_DT                                     
MFA-TR*                      ,BEACON_SCORE                                      
MFA-TR*    END-EXEC.                                                            
      ************************************************************              
      *  CURSOR TO SELECT RECORDS FROM CSS_CREDIT_HIST           *              
      ************************************************************              
           EXEC SQL                                                     
            DECLARE BEACON_CURSOR CURSOR FOR                            
             SELECT BEACON_SCORE                                        
                   ,CR_HIST_TRAN_DT                                     
                   ,REPLACE(CONVERT(CHAR(8), CR_HIST_TRAN_TM, 108), 
           ':', '.') CR_HIST_TRAN_TM                                     
               FROM CSS_CREDIT_HIST                                     
              WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                       
             ORDER BY CR_HIST_TRAN_DT DESC, CR_HIST_TRAN_TM DESC        
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BEACON_CURSOR CURSOR FOR                                    
MFA-TR*      SELECT BEACON_SCORE                                                
MFA-TR*            ,CR_HIST_TRAN_DT                                             
MFA-TR*            ,CR_HIST_TRAN_TM                                             
MFA-TR*        FROM CSS_CREDIT_HIST                                             
MFA-TR*       WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                               
MFA-TR*      ORDER BY CR_HIST_TRAN_DT DESC, CR_HIST_TRAN_TM DESC                
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR03451                                      
             ( :I-ACCOUNT-NO
                  , :I-BILL-NO
                  , :I-MODEL-ID
                  , :I-BEACON-SCORE
                  , :I-BATCH-CD
                  , :I-UPDATE-FLAG
                  )
MSQ001        END-EXEC.
                                                    
      ************************************************************              
       PROCEDURE DIVISION.                                              
      ************************************************************              
      ***************************************************************           
      **  0000-MAINLINE.                                           **           
      ***************************************************************           
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
                                                                        
           PERFORM 1200-ACCT-SCORE                                      
              THRU 1200-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      **  1200-ACCT-SCORE                                       **              
      ************************************************************              
       1200-ACCT-SCORE.                                                 
      *------------------------*                                                
           MOVE '1200' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE 0 TO WS-RECORD-COUNT                                    
           PERFORM 7210-OPEN-ACCT-CURSOR                                
              THRU 7210-EXIT.                                           
           PERFORM 7220-FETCH-ACCT-CURSOR                               
              THRU 7220-EXIT.                                           
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             PERFORM 1300-CALL-BHV-SCORING-SP                           
                THRU 1300-EXIT                                          
             IF S-RETURN-CODE = 0                                       
               PERFORM 8700-UPDATE-ACCT-SCORE                           
                  THRU 8700-EXIT                                        
               PERFORM 7550-UPDATE-RATING-HIST                          
                  THRU 7550-EXIT                                        
               PERFORM 7560-UPDATE-CREDIT-PROFILE                       
                  THRU 7560-EXIT                                        
               ADD 1 TO WS-RECORD-COUNT                                 
PRDFIX         IF WS-RECORD-COUNT = 100                                 
                  PERFORM 8750-COMMIT                                   
                     THRU 8750-EXIT                                     
                  MOVE 0 TO WS-RECORD-COUNT                             
               END-IF                                                   
             END-IF                                                     
             PERFORM 7220-FETCH-ACCT-CURSOR                             
                THRU 7220-EXIT                                          
           END-PERFORM.                                                 
           PERFORM 7230-CLOSE-ACCT-CURSOR                               
              THRU 7230-EXIT.                                           
       1200-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **  1300-CALL-BHV-SCORING-SP                                 **           
      ***************************************************************           
       1300-CALL-BHV-SCORING-SP.                                        
      *-------------------------*                                               
           MOVE '1300' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE '100' TO S-RETURN-CODE.                                 
           PERFORM 2000-CALC-BEACON-SCORE                               
              THRU 2000-EXIT.                                           
           MOVE KF-BHV-MODEL-ID      TO KS-BHV-MODEL-ID                 
           PERFORM 7428-GET-MODEL-STYLE                                 
              THRU 7428-EXIT                                            
           MOVE KF-ACCOUNT-NO        TO I-ACCOUNT-NO.                   
           MOVE KF-BHV-MODEL-ID      TO I-MODEL-ID.                     
           MOVE KF-BILL-NO           TO I-BILL-NO.                      
           MOVE CK-BEACON-SCORE      TO I-BEACON-SCORE.                 
           MOVE SPACES               TO I-BATCH-CD                      
           MOVE SPACES               TO I-UPDATE-FLAG                   
           IF KS-BHV-MODEL-STYLE = 'W'                                  
      *     EXEC SQL CALL CSR03451                                      
      *      ( :I-ACCOUNT-NO                                            
      *       ,:I-BILL-NO                                               
      *       ,:I-MODEL-ID                                              
      *       ,:I-BEACON-SCORE                                          
      *       ,:I-BATCH-CD                                              
      *       ,:I-UPDATE-FLAG                                           
      *      )                                                          
      *     END-EXEC                                                    
MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                    
           END-IF                                                       
           IF SQLCODE = 466 THEN                                        
      *      IF KS-BHV-MODEL-STYLE = 'W'                                
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *        CSR03451                                                 
      *       END-EXEC                                                  
      *      END-IF                                                     
                                                                        
      *      EXEC SQL                                                   
      *       ALLOCATE C1 CURSOR FOR RESULT SET :LOC1                   
      *      END-EXEC                                                   
                                                                        
             EXEC SQL                                                   
             FETCH C1 INTO :S-RETURN-CODE                               
                          ,:S-CELL-SCORE                                
                          ,:S-WGT-SCORE                                 
                          ,:S-RATING                                    
                          ,:S-ERROR-MSG                                 
             END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF.                                                      
                                                                        
                                                                        
           COMPUTE S-RETURN-CODE = S-RETURN-CODE * 100 END-COMPUTE      
           MOVE KF-ACCOUNT-NO            TO  CZ-ACCOUNT-NO.             
           PERFORM 7555-SELECT-BHV-RATNG-HIST THRU 7555-EXIT.           
           INITIALIZE WS-TEMP-BHV-RATNG-HIST.                           
           MOVE CZ-BHV-RATING-HIST       TO  WS-BHV-RATNG-HIST          
           IF  KF-BHV-EXEMPT-CD > SPACES                                
               MOVE KF-BHV-EXEMPT-CD     TO  WS-CURR-BHV-RATNG          
           ELSE                                                         
               MOVE S-RATING             TO  WS-CURR-BHV-RATNG          
           END-IF                                                       
           MOVE WS-TEMP-BHV-RATNG-HIST   TO  CZ-BHV-RATING-HIST         
           MOVE KF-ACCOUNT-NO            TO  CZ-ACCOUNT-NO.             
           IF KS-BHV-MODEL-STYLE = 'W'                                  
             MOVE 0                        TO  KF-BHV-SCOR-VALU-CELL    
             MOVE S-WGT-SCORE              TO  KF-BHV-SCORE-VALU-WGT    
           ELSE                                                         
             MOVE S-CELL-SCORE             TO  KF-BHV-SCOR-VALU-CELL    
             MOVE 0                        TO  KF-BHV-SCORE-VALU-WGT    
           END-IF                                                       
           MOVE S-RATING                 TO  KF-BHV-SCORE-RATING.       
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      **  2000-CALC-BEACON-SCORE                                   **           
      ***************************************************************           
       2000-CALC-BEACON-SCORE.                                          
                                                                        
           MOVE '2000' TO WS-ACTIVE-PARAGRAPH.                          
           MOVE KF-ACCOUNT-NO TO AT-ACCOUNT-NO                          
           PERFORM 7427-GET-CUSTOMER                                    
              THRU 7427-EXIT.                                           
           MOVE AT-CUSTOMER-NO TO CK-CUSTOMER-NO                        
           PERFORM 7240-OPEN-BEACON-CURSOR                              
              THRU 7240-EXIT                                            
           PERFORM 7250-FETCH-BEACON-CURSOR                             
              THRU 7250-EXIT                                            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE '00000'   TO CK-BEACON-SCORE                         
              MOVE SPACES    TO CK-CR-HIST-TRAN-DT                      
           END-IF.                                                      
           PERFORM 7260-CLOSE-BEACON-CURSOR                             
              THRU 7260-EXIT.                                           
           MOVE CK-BEACON-SCORE     TO KF-BEACON-SCORE.                 
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  7210-OPEN-ACCT-CURSOR                                    **           
      ***************************************************************           
       7210-OPEN-ACCT-CURSOR.                                           
      *---------------------*                                                   
             MOVE '7210'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              OPEN ACCT_CURSOR                                          
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                STRING ' ERROR OPENING ACCOUNTS CURSOR **'              
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
                                                                        
       7210-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  7220-FETCH-ACCT-CURSOR                                **              
      ************************************************************              
       7220-FETCH-ACCT-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7220'        TO WS-ACTIVE-PARAGRAPH.                 
                                                                        
             EXEC SQL                                                   
              FETCH ACCT_CURSOR                                         
               INTO :KF-ACCOUNT-NO                                      
                   ,:KF-COMPANY-NO                                      
                   ,:KF-REGULATED-FL                                    
                   ,:KF-DATE-BILLED                                     
                   ,:KF-REVENUE-MONTH                                   
                   ,:KF-BHV-MODEL-ID                                    
                   ,:KF-BHV-SCORE-RATING                                
                   ,:KF-BHV-EXEMPT-CD                                   
                   ,:KF-BILL-NO                                         
                   ,:KF-BEACON-SCORE                                    
                   ,:KF-BHV-SCOR-VALU-CELL                              
                   ,:KF-BHV-SCORE-VALU-WGT                              
                   ,:KF-LAST-UPDATE-USERID                              
                   ,:KF-LAST-UPDATE-TS                                  
                   ,:KF-BHV-SCORED-DT :WS-NULL-IND2                      
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE            
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR FETCHING ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7220-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ************************************************************              
      **  7230-CLOSE ACCT CURSOR                                **              
      ************************************************************              
       7230-CLOSE-ACCT-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              CLOSE ACCT_CURSOR                                         
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7230-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  7240-OPEN-BEACON-CURSOR                                  **           
      ***************************************************************           
       7240-OPEN-BEACON-CURSOR.                                         
      *---------------------*                                                   
             MOVE '7240'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              OPEN BEACON_CURSOR                                        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                STRING ' ERROR OPENING ACCOUNTS CURSOR **'              
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
                                                                        
       7240-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  7250-FETCH-BEACON-CURSOR                              **              
      ************************************************************              
       7250-FETCH-BEACON-CURSOR.                                        
      *----------------------*                                                  
             MOVE '7250'        TO WS-ACTIVE-PARAGRAPH.                 
                                                                        
             EXEC SQL                                                   
              FETCH BEACON_CURSOR                                       
               INTO :CK-BEACON-SCORE                                    
                   ,:CK-CR-HIST-TRAN-DT                                 
                   ,:CK-CR-HIST-TRAN-TM                                 
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE            
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR FETCHING ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7250-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ************************************************************              
      **  7260-CLOSE BEACON CURSOR                              **              
      ************************************************************              
       7260-CLOSE-BEACON-CURSOR.                                        
      *----------------------*                                                  
             MOVE '7260'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              CLOSE BEACON_CURSOR                                       
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7260-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      **     7427-GET-CUSTOMER.           **                                    
      **************************************************************            
       7427-GET-CUSTOMER.                                               
      *---------------------------*                                             
           MOVE '7427'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT CUSTOMER_NO                                          
              INTO :AT-CUSTOMER-NO                                      
              FROM CSS_ACCOUNT                                          
             WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             NEXT SENTENCE                                              
           ELSE                                                         
                                                                        
               STRING 'FETCHING BEACON SCORE FROM CIS **'               
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
                                                                        
               STRING 'ACCOUNT_NO    ' DELIMITED BY SIZE                
                      WS-ACCOUNT-NO      DELIMITED BY SIZE              
                                      INTO    WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7427-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      **     7428-GET-MODEL-STYLE.        **                                    
      **************************************************************            
       7428-GET-MODEL-STYLE.                                            
      *---------------------------*                                             
           MOVE '7428'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT BHV_MODEL_STYLE                                      
              INTO :KS-BHV-MODEL-STYLE                                  
              FROM CSS_BHV_MODEL                                        
             WHERE BHV_MODEL_ID = :KS-BHV-MODEL-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             NEXT SENTENCE                                              
           ELSE                                                         
                                                                        
               STRING 'SELECTING MODEL_ID             **'               
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
                                                                        
               STRING 'MODEL_ID      ' DELIMITED BY SIZE                
                      KS-BHV-MODEL-ID    DELIMITED BY SIZE              
                                      INTO    WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7428-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **   7550-UPDATE-RATING-HIST.                                   **        
      **                                                              **        
      ******************************************************************        
       7550-UPDATE-RATING-HIST.                                         
                                                                        
           EXEC SQL                                                     
                SELECT BHV_SCORE_RATING                                 
                     , BHV_EXEMPT_CD                                    
                  INTO :KF-BHV-SCORE-RATING                             
                     , :KF-BHV-EXEMPT-CD                                
                  FROM CSS_BHV_ACCT_SCORE                               
                 WHERE ACCOUNT_NO         = :KF-ACCOUNT-NO              
                   AND COMPANY_NO         = :KF-COMPANY-NO              
                   AND REGULATED_FL       = :KF-REGULATED-FL            
                   AND DATE_BILLED        = IIF(TRY_CONVERT(DATE, 
                                                        :KF-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :KF-DATE-BILLED
              ) <> 0) OR (LEN(:KF-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :KF-DATE-BILLED
              ), CONVERT(DATE, :KF-DATE-BILLED) )             
                   AND REVENUE_MONTH      = :KF-REVENUE-MONTH           
                   AND BHV_MODEL_ID       = :KF-BHV-MODEL-ID            
                   AND BILL_NO            = :KF-BILL-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT BHV_SCORE_RATING                                         
MFA-TR*              , BHV_EXEMPT_CD                                            
MFA-TR*           INTO :KF-BHV-SCORE-RATING                                     
MFA-TR*              , :KF-BHV-EXEMPT-CD                                        
MFA-TR*           FROM CSS_BHV_ACCT_SCORE                                       
MFA-TR*          WHERE ACCOUNT_NO         = :KF-ACCOUNT-NO                      
MFA-TR*            AND COMPANY_NO         = :KF-COMPANY-NO                      
MFA-TR*            AND REGULATED_FL       = :KF-REGULATED-FL                    
MFA-TR*            AND DATE_BILLED        = :KF-DATE-BILLED                     
MFA-TR*            AND REVENUE_MONTH      = :KF-REVENUE-MONTH                   
MFA-TR*            AND BHV_MODEL_ID       = :KF-BHV-MODEL-ID                    
MFA-TR*            AND BILL_NO            = :KF-BILL-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  THEN             
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR IN UPDATING RATING **'                     
                                                  DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG       
              STRING ' ACCOUNT-NO  '                DELIMITED BY SIZE   
                      I-ACCOUNT-NO                DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG2      
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
           END-IF.                                                      
                                                                        
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  7555-SELECT-BHV-RATNG-HIST.                                            
      ******************************************************************        
       7555-SELECT-BHV-RATNG-HIST.                                      
           EXEC SQL                                                     
                SELECT BHV_RATING_HIST                                  
                INTO  :CZ-BHV-RATING-HIST                               
                FROM CSS_CREDIT_PROFILE                                 
                WHERE ACCOUNT_NO      = :CZ-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  THEN             
            CONTINUE                                                    
           ELSE                                                         
              STRING ' ERROR IN SELECTING RATING **'                    
                                                  DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG       
              STRING ' ACCOUNT-NO  '                DELIMITED BY SIZE   
                      I-ACCOUNT-NO                DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG2      
                                                                        
            PERFORM 8800-DIS-TABLE-ERROR                                
               THRU 8800-EXIT                                           
            PERFORM 9000-SEND-ERROR-RESULT                              
               THRU 9000-EXIT                                           
            END-IF.                                                     
       7555-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  7560-UPDATE-CREDIT-PROFILE                                             
      ******************************************************************        
       7560-UPDATE-CREDIT-PROFILE.                                      
           EXEC SQL                                                     
                UPDATE CSS_CREDIT_PROFILE                               
                   SET BHV_RATING_HIST = :CZ-BHV-RATING-HIST            
                 WHERE ACCOUNT_NO      = :CZ-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  THEN             
            CONTINUE                                                    
           ELSE                                                         
              STRING ' ERROR IN UPDATING RATING **'                     
                                                  DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG       
              STRING ' ACCOUNT-NO  '                DELIMITED BY SIZE   
                      I-ACCOUNT-NO                DELIMITED BY SIZE     
                                                  INTO WS-ERR-MSG2      
                                                                        
            PERFORM 8800-DIS-TABLE-ERROR                                
               THRU 8800-EXIT                                           
            PERFORM 9000-SEND-ERROR-RESULT                              
               THRU 9000-EXIT                                           
            END-IF.                                                     
       7560-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  8700-SET-SCORED_FL.                                         **        
      **                                                              **        
      ******************************************************************        
       8700-UPDATE-ACCT-SCORE.                                          
      *---------------------------*                                             
           MOVE '8700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            UPDATE CSS_BHV_ACCT_SCORE                                   
             SET SCORED_FL             = 'Y'                            
                ,BHV_SCOR_VALU_CELL    = :KF-BHV-SCOR-VALU-CELL         
                ,BHV_SCORE_VALU_WGT    = :KF-BHV-SCORE-VALU-WGT         
                ,BHV_SCORE_RATING      = :KF-BHV-SCORE-RATING           
                ,BEACON_SCORE          = :KF-BEACON-SCORE               
                ,LAST_UPDATE_USERID    = 'CA456'                        
                ,LAST_UPDATE_TS        = CIS.CURRENT$TIMESTAMP()              
                ,BHV_SCORED_DT         = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
            WHERE CURRENT OF ACCT_CURSOR                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_BHV_ACCT_SCORE                                           
MFA-TR*      SET SCORED_FL             = 'Y'                                    
MFA-TR*         ,BHV_SCOR_VALU_CELL    = :KF-BHV-SCOR-VALU-CELL                 
MFA-TR*         ,BHV_SCORE_VALU_WGT    = :KF-BHV-SCORE-VALU-WGT                 
MFA-TR*         ,BHV_SCORE_RATING      = :KF-BHV-SCORE-RATING                   
MFA-TR*         ,BEACON_SCORE          = :KF-BEACON-SCORE                       
MFA-TR*         ,LAST_UPDATE_USERID    = 'CA456'                                
MFA-TR*         ,LAST_UPDATE_TS        = CURRENT TIMESTAMP                      
MFA-TR*         ,BHV_SCORED_DT         = CURRENT DATE                           
MFA-TR*     WHERE CURRENT OF ACCT_CURSOR                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                NEXT SENTENCE                                           
           ELSE                                                         
              MOVE   ' ERROR UPDATE CSS_PAYMENT_TRANS   **'             
                                           TO WS-ERR-MSG                
              MOVE SPACES                  TO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8750-COMMIT.                                                **        
      **                                                              **        
      ******************************************************************        
       8750-COMMIT.                                                     
      *---------------------------*                                             
           MOVE '8750'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            COMMIT                                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
              MOVE   ' ERROR COMMITING                  **'             
                                           TO WS-ERR-MSG                
              MOVE SPACES                  TO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                                  
      **                                                                        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
            DISPLAY '**********************************************'.   
            DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.   
            DISPLAY  WS-ERR-MSG.                                        
            DISPLAY '**********************************************'.   
            DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.      
            DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.    
            DISPLAY '**' WS-ERR-MSG2.                                   
            DISPLAY '**********************************************'.   
            PERFORM 9900-ABEND                                          
               THRU 9900-EXIT.                                          
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * SENDS ERROR RESULT                                            *         
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK' TO ABEND-FUNCTION                         
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00      
      *     9900-ABEND                                                 *00      
      *                                                                *00      
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *00      
      ******************************************************************00      
       9900-ABEND.                                                      
010590     DISPLAY 'PERFORMING 9900-ABEND'.                             
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
                                                                        
                                                                        
