       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA455.                                        
       DATE-WRITTEN.   JUL 2004.                                        
      ***************************************************************           
      *   PROGRAM MODIFICATION LOG                                              
      *   DATE    INITIALS   REASON                                             
      * --------  --------   -------------------------------------              
      *  12/03     PD         NEW PROGRAM                                       
A04527*  06/13     AS7C117    REMOVE UNUSED COPYBOOK CWS00056                   
      ***************************************************************           
      *       REMARKS.                                                          
      ***************************************************************           
      *  THIS PROGRAM ASSIGNS PRE-ASSIGNED MODEL                    *           
      ***************************************************************           
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
      ****************************************************************          
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *COPY CSSCA455.                                                           
           SELECT FCSCA455-FILE                                         
               ASSIGN UT-S-FCSCA455.                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************CSS00010
      * CSSCA455 - FD STATEMENT FOR OUTPUT FILE                        *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
       FD  FCSCA455-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ******************************************************************        
      *  FIOC453R                                                      *        
      *      IO AREA FOR QSAM OUTPUT FILE                E             *        
      ******************************************************************        
       01  FIOCA455.                                                    
           10 E-FCSCA455-RANDOM               PIC X(07).                
           10 E-FCSCA455-DET                  PIC X(01).                
           10 E-FCSCA455-ACCT-NO              PIC 9(13).                
           10 E-FCSCA455-BILL-NO              PIC 9(04).                
           10 E-FCSCA455-REV-MNTH             PIC 9(06).                
           10 FILLER                          PIC X(01).                
      *                                                                         
       01  FIOCA455-HDR.                                                
           10 E-FCSCA455-RANDOM-HDR           PIC X(07).                
           10 E-FCSCA455-HDR                  PIC X(01).                
           10 E-FCSCA455-ACCOUNT              PIC 9(13).                
           10 E-FCSCA455-COUNT                PIC 9(06).                
           10 E-FCSCA455-HDR-REG-FL           PIC X(01).                
           10 FILLER                          PIC X(04).                
      *                                                                         
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA455'.
MSQ017     COPY MFASQLM.
      **************************************************************            
      *        'WORKING STORAGE FOR PCSCA455 STARTS HERE'.                      
      **************************************************************            
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA362 STARTS HERE'.            
      *                                                                         
       01 WS-FLAGS.                                                     
          05  WS-EXISTS-FLAG          PIC X(01).                        
          05  WS-ACCT-EXIST           PIC X(01).                        
          05  WS-COUNT-N              PIC S9(06) COMP.                  
          05  WS-MODEL-COUNT          PIC S9(06) COMP.                  
          05  WS-DREG-COUNT-N          PIC S9(06) COMP.                 
                                                                        
       01 WS-SWITCHES.                                                  
           05  WS-FCA455-FLAG       PIC X(01) VALUE SPACE.              
               88  END-OF-FCA455              VALUE 'Y'.                
          05 WS-FCSCA455-EOF-SW     PIC X(01) VALUE 'N'.                
             88 WS-FCSCA455-AT-EOF            VALUE 'Y'.                
             88 WS-FCSCA356-NOT-AT-EOF        VALUE 'N'.                
          05 WS-FAC01-STATUS        PIC X(02) VALUE '00'.               
             88  WS-FAC01-SUCCESSFUL          VALUE '00'                
                                                      '04'.             
          05 WS-FAC22-STATUS        PIC X(02) VALUE '00'.               
             88  WS-FAC22-SUCCESSFUL          VALUE '00'                
                                                      '04'.             
          05 WS-VALID-ACCT-SW       PIC X(01) VALUE 'Y'.                
             88  WS-VALID-ACCOUNT             VALUE 'Y'.                
             88  WS-NOT-VALID-ACCOUNT         VALUE 'N'.                
                                                                        
          05 WS-VALID-PROC-SW         PIC X(01) VALUE 'Y'.              
             88  WS-ACCT-PROC                   VALUE 'Y'.              
             88  WS-ACCT-NOT-PROC               VALUE 'N'.              
                                                                        
          05 WS-COBB-XFERED-FLAG      PIC X(01) VALUE 'Y'.              
             88  COBB-XFERED-ACCT               VALUE 'Y'.              
             88  REGULAR-ACCT                   VALUE 'N'.              
                                                                        
          05 WS-MODEL-ASSIGNED        PIC X(01) VALUE 'Y'.              
             88  MODEL-ASSIGNED                 VALUE 'Y'.              
             88  MODEL-NOT-ASSIGNED             VALUE 'N'.              
                                                                        
          05 WS-GOT-HIST-MODEL        PIC X(01) VALUE 'Y'.              
             88  GOT-HIST                       VALUE 'Y'.              
             88  NO-HIST                        VALUE 'N'.              
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME              PIC X(10) VALUE 'PCSCA455'.      
          05  WS-USER-ABEND-CODE       PIC S9(4) COMP VALUE +100.       
          05  WS-Y                     PIC X(1) VALUE 'Y'.              
          05  WS-A                     PIC X(1) VALUE 'A'.              
                                                                        
       01 WS-ACCT-SCORE.                                                
COB305    05 WS-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
          05  WS-COMPANY-NO            PIC X(02).                       
          05  WS-REGULATED-FLAG        PIC X(01).                       
          05  WS-DATE-BILLED           PIC X(10).                       
COB305    05 WS-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.              
          05  WS-CODE-REV-CLASS        PIC X(3).                        
          05  WS-CUSTOMER-NO           PIC 9(10).                       
          05  WS-BILL-NO               PIC S9(09)  COMP.                
      **************************************************************            
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                         
      **************************************************************            
       01 WS-DATE-VARIABLES.                                            
          05  WS-TEMP-DATE.                                             
              10  WS-TEMP-YY           PIC 9(04).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-MM           PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-DD           PIC 9(02).                       
          05  WS-RUN-DATE.                                              
              10 WS-DT-YY              PIC 9(02).                       
              10 WS-DT-MM              PIC 9(02).                       
              10 WS-DT-DD              PIC 9(02).                       
          05  WS-BATCH-DATE.                                            
              10  WS-BATCH-MM          PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-BATCH-DD          PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-BATCH-YY          PIC 9(04).                       
      *                                                                         
      ***************************************************************           
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                         
      ***************************************************************           
                                                                        
       01  WS-TIME-VARIABLES.                                           
           05  WS-RUN-TIME.                                             
               10 WS-HH                PIC 9(02).                       
               10 WS-MM                PIC 9(02).                       
               10 WS-TT                PIC 9(02).                       
       01  WS-DATE-VARIABLES-1.                                         
           05  WS-AC01-DATE.                                            
               10  WS-AC01-CC          PIC 9(02) VALUE ZEROES.          
               10  WS-AC01-YY          PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-AC01-MM          PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-AC01-DD          PIC 9(02) VALUE ZEROES.          
           05  WS-DRAFT-DATE.                                           
               10  WS-DRAFT-CC         PIC 9(02) VALUE ZEROES.          
               10  WS-DRAFT-YY         PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-DRAFT-MM         PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-DRAFT-DD         PIC 9(02) VALUE ZEROES.          
           05  WS-CHECK-DATE.                                           
               10  WS-CHECK-CC         PIC X(02) VALUE '20'.            
               10  WS-CHECK-YY         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-CHECK-MM         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-CHECK-DD   PIC X(02) VALUE SPACES.                
      *01 WS-WORK-VARIABLES.                                                    
          05  WS-ERR-MSG         PIC X(100) VALUE SPACES.               
          05  WS-ERR-MSG2        PIC X(100) VALUE SPACES.               
          05  WS-ACCOUNT-NO      PIC 9(13)  VALUE 0.                    
          05  WS-NULL-IND1       PIC S9(4) COMP.                        
          05  WS-NULL-IND2       PIC S9(4) COMP.                        
       01 WS-DISPLAY.                                                   
          05  FILLER             PIC X(01) VALUE SPACES.                
       01 WS-HARDCODED-VARIABLES.                                       
          05 WS-COMPANY          PIC X(02) VALUE '01'.                  
          05 WS-CSR              PIC S9(9)V9(5)                         
                                          VALUE 1.                      
          05 WS-DATABASE         PIC X(08) VALUE                        
                                       'DATABASE'.                      
          05 WS-COMMENT-LEN      PIC S9(04) COMP                        
                                       VALUE +34.                       
          05 WS-COMMENT-TEXT     PIC X(34) VALUE                        
             'BATCH OVERAGE POSTED BY THE SYSTEM'.                      
          05 WS-SCORE-VALUES     PIC X(01) VALUE 'Y'.                   
          05 WS-DEF-RATING       PIC X(01) VALUE ' '.                   
          05 WS-DEF-SCORED-FL    PIC X(01) VALUE 'N'.                   
          05 WS-DEF-DIALER-FL    PIC X(01) VALUE 'N'.                   
       01 WS-END                PIC X(40)                               
                      VALUE 'WORKING STORAGE FOR PCSCA455 ENDS HERE'.   
      **************************************************************            
      **   COPYBOOKS USED IN THE PROGRAM                                        
      **************************************************************            
      *                                                                         
      ****** DB2 COMMUNICATION REQUIREMENT *************************            
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN   PIC S9(4)  COMP VALUE +1320.                 
           02  ERROR-TEXT  PIC X(132) OCCURS 10 TIMES                   
                                      INDEXED BY ERROR-INDEX.           
       77 ERROR-TEXT-LEN          PIC S9(9)  COMP VALUE +132.           
       77 TRACE-MESSAGE-AREA      PIC X(256).                           
       77 OPENFN                  PIC X(12).                            
       77 SSID                    PIC X(4).                             
       77 PLANNAME                PIC X(8).                             
       77 RETCODE                 PIC S9(5).                            
       77 REASCODE                PIC S9(5).                            
       77 CLOSFN                  PIC X(12).                            
       77 TERMOP                  PIC X(4).                             
                                                                        
       01 I-ACCOUNT-NO                   PIC X(14).                     
       01 I-BEACON-SCORE                 PIC X(06).                     
       01 I-UPDATE-FLAG                  PIC X(01).                     
                                                                        
      ***************************************************************           
      **   CSS_ACCOUNT **                                                       
      ***************************************************************           
             EXEC SQL                                                           
              INCLUDE TBACCT                                                    
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BILLING_HDR                                        **            
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBLLHDR                                                  
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BILLING_DET **                                                   
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBLLDET                                                  
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BHV_DIMENSION **                                                 
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHDIMS                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CATEGORY                                 **                  
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHVCAT                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CRITERIA **                                                  
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBCRITRA                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE **                                                
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBACSCRE                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_MODEL                                          **            
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHMODL                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCORE **                                                     
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHVSCR                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCOR_MODL **                                                 
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHSCRE                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCOR_RATING                                    **            
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBSCRRAT                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CATEG_MODL **                                                
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBCATMDL                                                  
             END-EXEC                                                           
      **************************************************************            
                                                                        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
                                                                        
             EXEC SQL                                                           
              INCLUDE CWS00315                                                  
             END-EXEC.                                                          
                                                                        
             EXEC SQL                                                           
              INCLUDE SQLCA                                                     
             END-EXEC.                                                          
      ***************************************************************           
      *    CURSOR TO SELECT CSS_BHV_MODEL **                                    
      ***************************************************************           
             EXEC SQL                                                   
              DECLARE MODL_CURSOR CURSOR FOR                            
              SELECT BHV_MODEL_ID                                       
                    ,BHV_MODEL_PCT                                      
              FROM CSS_BHV_MODEL                                        
              WHERE BHV_MODEL_STATUS = 'A'                              
              AND   REGULATED_FL     = :KS-REGULATED-FL                 
             END-EXEC.                                                  
      ***************************************************************           
      **   'WORKING STORAGE FOR PCSCA455 ENDS HERE '. **                        
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
      **                  M A I N L I N E **                                    
      ***************************************************************           
       0000-MAINLINE.                                                   
      *-------------*                                                           
             MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             PERFORM 0100-INITIALIZE                                    
                THRU 0100-EXIT.                                         
                                                                        
             DISPLAY 'ASSIGN MODELS '.                                  
                                                                        
                                                                        
                                                                        
             PERFORM 1200-ASSIGN-HIST-MODEL                             
                THRU 1200-EXIT                                          
                                                                        
                                                                        
                                                                        
             PERFORM 9000-TERMINATE                                     
                THRU 9000-EXIT.                                         
                                                                        
             STOP RUN.                                                  
                                                                        
       0000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ***************************************************************           
      **  0100-INITIALIZE                                          **           
      ***************************************************************           
       0100-INITIALIZE.                                                 
      *--------------*                                                          
             MOVE '100'             TO WS-ACTIVE-PARAGRAPH.             
                                                                        
             PERFORM 0200-OPEN-INPUT-FILES                              
                THRU 0200-EXIT.                                         
                                                                        
                                                                        
       0100-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  0200-OPEN-INPUT-FILES                                **               
      ************************************************************              
       0200-OPEN-INPUT-FILES.                                           
      *---------------------*                                                   
             MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             OPEN INPUT FCSCA455-FILE.                                  
                                                                        
       0200-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      **  1200-ASSIGN-HIST-MODEL                                  **            
      **************************************************************            
       1200-ASSIGN-HIST-MODEL.                                          
      *----------------------*                                                  
             MOVE '1200'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 6000-READ-FCSCA455                                   
              THRU 6000-EXIT.                                           
           PERFORM 2885-READ-CONTROL-HDR                                
              THRU 2885-EXIT.                                           
           PERFORM 7210-OPEN-MODL-CURSOR                                
              THRU 7210-EXIT                                            
           PERFORM 7220-FETCH-MODL-CURSOR                               
              THRU 7220-EXIT                                            
           PERFORM 6000-READ-FCSCA455                                   
              THRU 6000-EXIT                                            
           IF KS-BHV-MODEL-PCT = 100                                    
             MOVE KS-BHV-MODEL-ID TO KF-BHV-MODEL-ID                    
             PERFORM UNTIL END-OF-FCA455                                
               PERFORM 2925-READ-TO-DET-FILE                            
                  THRU 2925-EXIT                                        
               PERFORM 8320-UPDATE-ACCT-MODEL                           
                  THRU 8320-EXIT                                        
               PERFORM 6000-READ-FCSCA455                               
                  THRU 6000-EXIT                                        
             END-PERFORM                                                
           ELSE                                                         
             MOVE KS-BHV-MODEL-ID TO KF-BHV-MODEL-ID                    
             COMPUTE WS-MODEL-COUNT = WS-COUNT-N *                      
                                      (KS-BHV-MODEL-PCT/100)            
             END-COMPUTE                                                
             PERFORM WS-MODEL-COUNT TIMES                               
               PERFORM 2925-READ-TO-DET-FILE                            
                  THRU 2925-EXIT                                        
               PERFORM 8320-UPDATE-ACCT-MODEL                           
                  THRU 8320-EXIT                                        
               PERFORM 6000-READ-FCSCA455                               
                  THRU 6000-EXIT                                        
             END-PERFORM                                                
             PERFORM 7220-FETCH-MODL-CURSOR                             
                THRU 7220-EXIT                                          
             MOVE KS-BHV-MODEL-ID TO KF-BHV-MODEL-ID                    
             IF WS-MODEL-COUNT <= WS-COUNT-N                            
              PERFORM UNTIL END-OF-FCA455                               
               PERFORM 2925-READ-TO-DET-FILE                            
                  THRU 2925-EXIT                                        
               PERFORM 8320-UPDATE-ACCT-MODEL                           
                  THRU 8320-EXIT                                        
               PERFORM 6000-READ-FCSCA455                               
                  THRU 6000-EXIT                                        
              END-PERFORM                                               
             END-IF                                                     
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      ** 2885-READ-CONTROL-HDR                                    *             
      **************************************************************            
       2885-READ-CONTROL-HDR.                                           
      *---------------------*                                                   
             MOVE '2885'               TO WS-ACTIVE-PARAGRAPH.          
             MOVE E-FCSCA455-COUNT     TO WS-COUNT-N                    
             MOVE E-FCSCA455-HDR-REG-FL    TO KF-REGULATED-FL.          
             MOVE E-FCSCA455-HDR-REG-FL    TO KS-REGULATED-FL.          
             DISPLAY 'REGULATED-FL HDR',KF-REGULATED-FL.                
       2885-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      ** 2925-READ-TO-DET-FILE                                    *             
      **************************************************************            
       2925-READ-TO-DET-FILE.                                           
      *---------------------*                                                   
                                                                        
             MOVE '2925'              TO WS-ACTIVE-PARAGRAPH.           
             MOVE E-FCSCA455-ACCT-NO  TO KF-ACCOUNT-NO                  
             MOVE E-FCSCA455-BILL-NO  TO KF-BILL-NO                     
             MOVE E-FCSCA455-REV-MNTH TO KF-REVENUE-MONTH.              
             DISPLAY 'REGULATED-FL DET' ,KF-REGULATED-FL.               
                                                                        
       2925-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
       6000-READ-FCSCA455.                                              
      *                                                                         
           READ FCSCA455-FILE                                           
           AT END                                                       
              SET END-OF-FCA455 TO TRUE                                 
              MOVE HIGH-VALUE   TO FIOCA455                             
              GO TO 6000-EXIT                                           
           END-READ.                                                    
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  7210-OPEN-MODL-CURSOR                                    **           
      ***************************************************************           
       7210-OPEN-MODL-CURSOR.                                           
      *---------------------*                                                   
             MOVE '7210'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              OPEN MODL_CURSOR                                          
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                STRING ' ERROR OPENING ACCOUNTS CURSOR **'              
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
                                                                        
       7210-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  7220-FETCH-MODL-CURSOR                                **              
      ************************************************************              
       7220-FETCH-MODL-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7220'        TO WS-ACTIVE-PARAGRAPH.                 
                                                                        
             EXEC SQL                                                   
              FETCH MODL_CURSOR                                         
               INTO :KS-BHV-MODEL-ID                                    
                   ,:KS-BHV-MODEL-PCT                                   
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE            
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR FETCHING ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7220-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ************************************************************              
      **  7230-CLOSE ACCT CURSOR                                **              
      ************************************************************              
       7230-CLOSE-MODL-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              CLOSE MODL_CURSOR                                         
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7230-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  8320-UPDATE-ACCT-MODEL                                   **           
      ***************************************************************           
       8320-UPDATE-ACCT-MODEL.                                          
      *----------------------*                                                  
             MOVE '8320'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              UPDATE CSS_BHV_ACCT_SCORE                                 
                 SET BHV_MODEL_ID     = :KF-BHV-MODEL-ID                
               WHERE ACCOUNT_NO       = :KF-ACCOUNT-NO                  
                 AND BILL_NO          = :KF-BILL-NO                     
                 AND REGULATED_FL     = :KF-REGULATED-FL                
                 AND SCORED_FL       <> :WS-Y                           
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                DISPLAY KF-ACCOUNT-NO                                   
                DISPLAY KF-BILL-NO                                      
                DISPLAY KF-REGULATED-FL                                 
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       8320-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  8800-DIS-TABLE-ERROR                                     **           
      ***************************************************************           
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
             DISPLAY '**********************************************'.  
             DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.  
             DISPLAY  WS-ERR-MSG.                                       
             DISPLAY '**********************************************'.  
             DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.     
             DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.   
             DISPLAY '**' WS-ERR-MSG2.                                  
             DISPLAY '**********************************************'.  
             PERFORM 9900-ABEND                                         
                THRU 9900-EXIT.                                         
                                                                        
       8800-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  8900-DISPLAY-ERR-TERM **                                              
      ************************************************************              
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
             DISPLAY '                                   '.             
             DISPLAY '******************************************'.      
             DISPLAY '**     PCSCA455 PROCESSING ERROR        **'.      
             DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.     
             DISPLAY '**' WS-ERR-MSG.                                   
             DISPLAY '**' WS-ERR-MSG2.                                  
             DISPLAY '**       PROCESSING TERMINATED          **'.      
             DISPLAY '******************************************'.      
             PERFORM 9900-ABEND                                         
                THRU 9900-EXIT.                                         
       8900-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      **  9000-TERMINATE **                                                     
      **  NORMAL TERMINATION OF THE PROGRAM **                                  
      **************************************************************            
       9000-TERMINATE.                                                  
      *--------------*                                                          
             CLOSE FCSCA455-FILE.                                       
             PERFORM 7230-CLOSE-MODL-CURSOR                             
                THRU 7230-EXIT.                                         
                                                                        
       9000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *      EXEC SQL                                                           
      *       INCLUDE CPD00037                                                  
      *      END-EXEC.                                                          
      *********************************************************554600           
      *     9900-ABEND                                              *           
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                *           
      ***************************************************************           
       9900-ABEND.                                                      
             DISPLAY 'PERFORMING 9900-ABEND'.                           
             PERFORM 9000-TERMINATE THRU 9000-EXIT.                     
SCA003       EXEC SQL
SCA003           ROLLBACK
SCA003       END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

             MOVE 12  TO  RETURN-CODE.                                  
             MOVE 'YES' TO WS-ABEND-SWITCH.                             
             DISPLAY 'PCSCA455 ABEND INITIATED'.                        
       9900-EXIT.                                                       
             IF WS-ABEND-YES                                            
               STOP RUN
             END-IF.                                                
