       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA454.                                        
       DATE-WRITTEN.   JULY 04.                                         
      **************************************************************            
      *                 PROGRAM MODIFICATION LOG                                
      *   DATE    INITIALS   REASON                                             
      * --------  --------   -------------------------------------              
      *  07/04     PD         NEW PROGRAM                                       
T35434*  05/07     MC95456    REPLACED CSS_MODEL_SQL WITH SET                   
      *                       STATEMENTS                                        
      **************************************************************            
      *                REMARKS. **                                              
      **************************************************************            
      *  THIS PROGRAM ASSIGNS RANDOM NUMBERS TO MODELS                          
      **************************************************************            
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
      **************************************************************            
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *COPY CSSCA356.                                                           
           SELECT FCSC454I-FILE                                         
               ASSIGN UT-S-FCSC454I.                                    
      *                                                                         
      *COPY CSSEQUIFAX.                                                         
           SELECT FCSC454O-FILE                                         
               ASSIGN UT-S-FCSC454O.                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************CSS00010
      * CSSC454I - FD STATEMENT FOR INPUT  FILE                        *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
       FD  FCSC454I-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ******************************************************************        
      *  FIOC453R                                                      *        
      *      IO AREA FOR QSAM OUTPUT FILE                E             *        
      ******************************************************************        
       01  FIOC454I.                                                    
           10 E-FCSC454I-VALUE                PIC X(500).               
      *                                                                         
      ******************************************************************CSS00010
      * CSSC454O - FD STATEMENT FOR OUTPUT FILE                        *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
       FD  FCSC454O-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ******************************************************************        
      *  FIOC454O                                                      *        
      *      IO AREA FOR QSAM OUTPUT FILE                E             *        
      ******************************************************************        
       01  FIOC454O.                                                    
           10 E-FCSC454O-RANDOM-NO            PIC 9(07).                
           10 E-FCSC454O-VALUE                PIC X(500).               
      *                                                                         
      **************************************************************            
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA454'.
MSQ017     COPY MFASQLM.
      **************************************************************            
      *             'WORKING STORAGE FOR PCSCA454 STARTS HERE'.                 
      **************************************************************            
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA454 STARTS HERE'.            
      *                                                                         
       01 WS-TIMESTAMP         PIC X(26) VALUE SPACES.                  
       01 WS-TIMESTAMP-CHAR.                                            
          05 FILLER            PIC X(21).                               
          05 SEED-CHAR         PIC X(5).                                
       77 WS-RANDOM-NUMBER     PIC V9(7) VALUE 0.                       
       77 WS-RANDOM-NUMBER-F   PIC 9(7) VALUE 0.                        
       77 SEED-NUMBER          PIC 9(5) VALUE 0.                        
       77 RAND                 PIC S9(9) COMP VALUE 0.                  
       77 SEED                 PIC S9(9) COMP VALUE 3.                  
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME              PIC X(10)   VALUE 'PCSCA454'.    
          05  WS-USER-ABEND-CODE       PIC S9(4) COMP VALUE +100.       
                                                                        
       01 WS-MISC.                                                      
           05  WS-FCA454-FLAG               PIC X(01)   VALUE SPACE.    
               88  END-OF-FCA454                        VALUE 'Y'.      
           05  WS-ERR-MSG                   PIC X(100) VALUE SPACES.    
           05  WS-ERR-MSG2                  PIC X(100) VALUE SPACES.    
                                                                        
        01  WS-END                          PIC X(40)                   
           VALUE 'WORKING STORAGE FOR PCSCA454 ENDS HERE  '.            
      **************************************************************            
      **   COPYBOOKS USED IN THE PROGRAM **                                     
      **************************************************************            
                                                                        
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00010.                                                           
       COPY CWS00104.                                                           
                                                                        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
      ************************************************************              
      *    'WORKING STORAGE FOR PCSCA454 ENDS HERE '.            *              
      ************************************************************              
       PROCEDURE DIVISION.                                              
      ************************************************************              
      *                    M A I N L I N E  *                                   
      ************************************************************              
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 0100-INITIALIZE                                      
              THRU 0100-EXIT.                                           
           PERFORM 7000-SELECT-TIMESTAMP                                
              THRU 7000-EXIT.                                           
                                                                        
           MOVE WS-TIMESTAMP          TO WS-TIMESTAMP-CHAR              
           MOVE SEED-CHAR             TO SEED-NUMBER                    
           MOVE SEED-NUMBER           TO SEED                           
           COMPUTE WS-RANDOM-NUMBER = FUNCTION RANDOM (SEED)            
           END-COMPUTE                                                  
           DISPLAY WS-TIMESTAMP                                         
           DISPLAY WS-RANDOM-NUMBER                                     
           DISPLAY SEED                                                 
           COMPUTE WS-RANDOM-NUMBER-F = WS-RANDOM-NUMBER * 10000000     
           END-COMPUTE                                                  
           DISPLAY WS-RANDOM-NUMBER-F                                   
           PERFORM 6000-READ-FCSC454I                                   
              THRU 6000-EXIT.                                           
                                                                        
           PERFORM UNTIL END-OF-FCA454                                  
               COMPUTE WS-RANDOM-NUMBER = FUNCTION RANDOM END-COMPUTE   
               COMPUTE WS-RANDOM-NUMBER-F = WS-RANDOM-NUMBER * 10000000 
               END-COMPUTE                                              
               DISPLAY WS-RANDOM-NUMBER-F                               
               MOVE WS-RANDOM-NUMBER-F TO E-FCSC454O-RANDOM-NO          
               MOVE E-FCSC454I-VALUE   TO E-FCSC454O-VALUE              
               WRITE FIOC454O                                           
               PERFORM 6000-READ-FCSC454I                               
                  THRU 6000-EXIT                                        
           END-PERFORM.                                                 
                                                                        
           CLOSE FCSC454I-FILE.                                         
           CLOSE FCSC454O-FILE.                                         
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  0100-INITIALIZE                                          **           
      ***************************************************************           
       0100-INITIALIZE.                                                 
      *--------------*                                                          
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT.                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      **  0200-OPEN-FILES                                         **            
      **************************************************************            
       0200-OPEN-FILES.                                                 
      *----------------------*                                                  
             MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             OPEN INPUT  FCSC454I-FILE.                                 
             OPEN OUTPUT FCSC454O-FILE.                                 
                                                                        
       0200-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
       6000-READ-FCSC454I.                                              
      *                                                                         
           READ FCSC454I-FILE                                           
           AT END                                                       
              SET END-OF-FCA454 TO TRUE                                 
              MOVE HIGH-VALUE   TO FIOC454I                             
              GO TO 6000-EXIT                                           
           END-READ.                                                    
       6000-EXIT.                                                       
           EXIT.                                                        
******************************************************************              
      **  7000-SELECT-TIMESTAMP.                                **              
      **                                                        **              
                                                                        
******************************************************************              
       7000-SELECT-TIMESTAMP.                                           
      *------------------------*                                                
           MOVE '7310'                   TO WS-ACTIVE-PARAGRAPH.        
               EXEC SQL                                                 
T35434            SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP             
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SET  :WS-TIMESTAMP   =  CURRENT TIMESTAMP                     
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL THEN              
              NEXT SENTENCE                                             
           ELSE                                                         
                                                                        
               STRING 'ERROR FETCHING TIMESTAMP           **'           
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
                                                                        
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
******************************************************************              
                                                                        
      **  8800-DIS-TABLE-ERROR                                  **              
      **                                                        **              
                                                                        
******************************************************************              
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
******************************************************************              
      **  8900-DISPLAY-ERR-TERM                                                 
**                                                                      
      **                                                                        
**                                                                      
                                                                        
******************************************************************              
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSCA360 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
******************************************************************              
      **  9000-TERMINATE                                                        
**                                                                      
      *        NORMAL TERMINATION OF THE PROGRAM                                
**                                                                      
                                                                        
******************************************************************              
       9000-TERMINATE.                                                  
      *--------------*                                                          
                                                                        
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ******************************************************************55460000
      *     9900-ABEND                                                 *55470000
      *                                                                *55480000
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                   *55490000
      ******************************************************************55500000
       9900-ABEND.                                                      
010590     DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

???           MOVE 12  TO  RETURN-CODE.                                 
???           MOVE 'YES' TO WS-ABEND-SWITCH.                            
           DISPLAY 'PCSCA362 ABEND INITIATED'.                          
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
