       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA453.                                        
       DATE-WRITTEN.   JUL 2004.                                        
      ***************************************************************           
      *   PROGRAM MODIFICATION LOG                                              
      *   DATE    INITIALS   REASON                                             
      * --------  --------   -------------------------------------              
      *  12/03     PD         NEW PROGRAM                                       
A03579*  08/2011   BD09555    ADD LOGIC TO TAKE A COMMIT POINT EVERY            
A03579*                       1000 UPDATES.  COUNTER IS SET TO ONLY             
A03579*                       THREE POSITIONS, SO IT WILL ROLL OVER             
A03579*                       TO 000 EVERY 1000 UPDATES.                        
ACT050*  05/2012   BD09555    CHANGE CURSOR TO LOOK FOR NULL                    
ACT050*                       BEHAVIOUR MODEL ID INSTEAD OF EQUAL TO            
ACT050*  A03967               SPACES                                            
A04527*  06/2013   AS7C117    REMOVE UNUSED COPYBOOK CWS00056                   
A05460** 06/02/16  MR7E794    REPLACE THE DUPLICATE FIELD WS-A AND              
A05460**           ACT188     REMOVED THE UNUSED COPYBOOKS AND CODE.            
      ***************************************************************           
      *       REMARKS.                                                          
      ***************************************************************           
      *  THIS PROGRAM ASSIGNS PRE-ASSIGNED MODEL                    *           
      ***************************************************************           
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
      ****************************************************************          
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *COPY CSSC453R.                                                           
           SELECT FCSC453R-FILE                                         
               ASSIGN UT-S-FCSC453R.                                    
      *                                                                         
      *COPY CSSC453D.                                                           
           SELECT FCSC453D-FILE                                         
               ASSIGN UT-S-FCSC453D.                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************CSS00010
      * CSSC453R - FD STATEMENT FOR OUTPUT FILE                        *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
       FD  FCSC453R-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ******************************************************************        
      *  FIOC453R                                                      *        
      *      IO AREA FOR QSAM OUTPUT FILE                E             *        
      ******************************************************************        
       01  FIOC453R.                                                    
           10 E-FCSC453R-DET                  PIC X(01).                
           10 E-FCSC453R-ACCT-NO              PIC 9(13).                
           10 E-FCSC453R-BILL-NO              PIC 9(04).                
           10 E-FCSC453R-REV-MNTH             PIC 9(06).                
           10 E-FCSC453R-REG-FL               PIC X(01).                
      *                                                                         
       01  FIOC453R-HDR.                                                
           10 E-FCSC453R-HDR                  PIC X(01).                
           10 E-FCSC453R-ACCOUNT              PIC 9(13).                
           10 E-FCSC453R-COUNT                PIC 9(06).                
           10 E-FCSC453R-HDR-REG-FL           PIC X(01).                
           10 FILLER                          PIC X(04).                
      *                                                                         
      ******************************************************************CSS00010
      * CSSC453D - FD STATEMENT FOR OUTPUT FILE                        *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
       FD  FCSC453D-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
      ******************************************************************        
      *  FIOC453D                                                      *        
      *      IO AREA FOR QSAM OUTPUT FILE                E             *        
      ******************************************************************        
       01  FIOC453D.                                                    
           10 E-FCSC453D-DET                  PIC X(01).                
           10 E-FCSC453D-ACCT-NO              PIC 9(13).                
           10 E-FCSC453D-BILL-NO              PIC 9(04).                
           10 E-FCSC453D-REV-MNTH             PIC 9(06).                
           10 E-FCSC453D-REG-FL               PIC X(01).                
      *                                                                         
       01  FIOC453D-HDR.                                                
           10 E-FCSC453D-HDR                  PIC X(01).                
           10 E-FCSC453D-ACCOUNT              PIC 9(13).                
           10 E-FCSC453D-COUNT                PIC 9(06).                
           10 E-FCSC453D-HDR-REG-FL           PIC X(01).                
           10 FILLER                          PIC X(04).                
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA453'.
MSQ017     COPY MFASQLM.
      **************************************************************            
      *        'WORKING STORAGE FOR PCSCA453 STARTS HERE'.                      
      **************************************************************            
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA362 STARTS HERE'.            
      *                                                                         
       01 WS-FLAGS.                                                     
          05  WS-EXISTS-FLAG          PIC X(01).                        
          05  WS-ACCT-EXIST           PIC X(01).                        
          05  WS-REG-COUNT-N          PIC S9(06) COMP.                  
          05  WS-DREG-COUNT-N          PIC S9(06) COMP.                 
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-FCSCA453-EOF-SW     PIC X(01) VALUE 'N'.                
             88 WS-FCSCA453-AT-EOF            VALUE 'Y'.                
             88 WS-FCSCA356-NOT-AT-EOF        VALUE 'N'.                
          05 WS-FAC01-STATUS        PIC X(02) VALUE '00'.               
             88  WS-FAC01-SUCCESSFUL          VALUE '00'                
                                                      '04'.             
          05 WS-FAC22-STATUS        PIC X(02) VALUE '00'.               
             88  WS-FAC22-SUCCESSFUL          VALUE '00'                
                                                      '04'.             
          05 WS-VALID-ACCT-SW       PIC X(01) VALUE 'Y'.                
             88  WS-VALID-ACCOUNT             VALUE 'Y'.                
             88  WS-NOT-VALID-ACCOUNT         VALUE 'N'.                
                                                                        
          05 WS-VALID-PROC-SW         PIC X(01) VALUE 'Y'.              
             88  WS-ACCT-PROC                   VALUE 'Y'.              
             88  WS-ACCT-NOT-PROC               VALUE 'N'.              
                                                                        
          05 WS-COBB-XFERED-FLAG      PIC X(01) VALUE 'Y'.              
             88  COBB-XFERED-ACCT               VALUE 'Y'.              
             88  REGULAR-ACCT                   VALUE 'N'.              
                                                                        
          05 WS-MODEL-ASSIGNED        PIC X(01) VALUE 'Y'.              
             88  MODEL-ASSIGNED                 VALUE 'Y'.              
             88  MODEL-NOT-ASSIGNED             VALUE 'N'.              
                                                                        
          05 WS-GOT-HIST-MODEL        PIC X(01) VALUE 'Y'.              
             88  GOT-HIST                       VALUE 'Y'.              
             88  NO-HIST                        VALUE 'N'.              
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME              PIC X(10) VALUE 'PCSCA453'.      
          05  WS-USER-ABEND-CODE       PIC S9(4) COMP VALUE +100.       
          05  WS-Y                     PIC X(1) VALUE 'Y'.              
                                                                        
       01 WS-ACCT-SCORE.                                                
COB305    05 WS-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
          05  WS-COMPANY-NO            PIC X(02).                       
          05  WS-REGULATED-FLAG        PIC X(01).                       
          05  WS-DATE-BILLED           PIC X(10).                       
COB305    05 WS-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.              
          05  WS-CODE-REV-CLASS        PIC X(3).                        
          05  WS-CUSTOMER-NO           PIC 9(10).                       
          05  WS-BILL-NO               PIC S9(09)  COMP.                
      **************************************************************            
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                         
      **************************************************************            
       01 WS-DATE-VARIABLES.                                            
          05  WS-TEMP-DATE.                                             
              10  WS-TEMP-YY           PIC 9(04).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-MM           PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-TEMP-DD           PIC 9(02).                       
          05  WS-RUN-DATE.                                              
              10 WS-DT-YY              PIC 9(02).                       
              10 WS-DT-MM              PIC 9(02).                       
              10 WS-DT-DD              PIC 9(02).                       
          05  WS-BATCH-DATE.                                            
              10  WS-BATCH-MM          PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-BATCH-DD          PIC 9(02).                       
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-BATCH-YY          PIC 9(04).                       
      *                                                                         
      ***************************************************************           
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                         
      ***************************************************************           
                                                                        
       01  WS-TIME-VARIABLES.                                           
           05  WS-RUN-TIME.                                             
               10 WS-HH                PIC 9(02).                       
               10 WS-MM                PIC 9(02).                       
               10 WS-TT                PIC 9(02).                       
       01  WS-DATE-VARIABLES-1.                                         
           05  WS-AC01-DATE.                                            
               10  WS-AC01-CC          PIC 9(02) VALUE ZEROES.          
               10  WS-AC01-YY          PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-AC01-MM          PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-AC01-DD          PIC 9(02) VALUE ZEROES.          
           05  WS-DRAFT-DATE.                                           
               10  WS-DRAFT-CC         PIC 9(02) VALUE ZEROES.          
               10  WS-DRAFT-YY         PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-DRAFT-MM         PIC 9(02) VALUE ZEROES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-DRAFT-DD         PIC 9(02) VALUE ZEROES.          
           05  WS-CHECK-DATE.                                           
               10  WS-CHECK-CC         PIC X(02) VALUE '20'.            
               10  WS-CHECK-YY         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-CHECK-MM         PIC X(02) VALUE SPACES.          
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-CHECK-DD   PIC X(02) VALUE SPACES.                
      *01 WS-WORK-VARIABLES.                                                    
          05  WS-ERR-MSG         PIC X(100) VALUE SPACES.               
          05  WS-ERR-MSG2        PIC X(100) VALUE SPACES.               
A03579    05  WS-UPDATE-CT       PIC  999   VALUE  0   COMP-3.          
A03579    05  WS-COMMIT-CT       PIC  999   VALUE  0   COMP-3.          
          05  WS-ACCOUNT-NO      PIC 9(13)  VALUE 0.                    
          05  WS-NULL-IND1       PIC S9(4) COMP.                        
          05  WS-NULL-IND2       PIC S9(4) COMP.                        
       01 WS-DISPLAY.                                                   
          05  FILLER             PIC X(01) VALUE SPACES.                
       01 WS-HARDCODED-VARIABLES.                                       
          05 WS-COMPANY          PIC X(02) VALUE '01'.                  
          05 WS-CSR              PIC S9(9)V9(5)                         
                                          VALUE 1.                      
          05 WS-DATABASE         PIC X(08) VALUE                        
                                       'DATABASE'.                      
          05 WS-COMMENT-LEN      PIC S9(04) COMP                        
                                       VALUE +34.                       
          05 WS-COMMENT-TEXT     PIC X(34) VALUE                        
             'BATCH OVERAGE POSTED BY THE SYSTEM'.                      
          05 WS-SCORE-VALUES     PIC X(01) VALUE 'Y'.                   
          05 WS-DEF-RATING       PIC X(01) VALUE ' '.                   
          05 WS-DEF-SCORED-FL    PIC X(01) VALUE 'N'.                   
          05 WS-DEF-DIALER-FL    PIC X(01) VALUE 'N'.                   
       01 WS-END                PIC X(40)                               
                      VALUE 'WORKING STORAGE FOR PCSCA453 ENDS HERE'.   
      **************************************************************            
      **   COPYBOOKS USED IN THE PROGRAM                                        
      **************************************************************            
      *                                                                         
      ****** DB2 COMMUNICATION REQUIREMENT *************************            
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN   PIC S9(4)  COMP VALUE +1320.                 
           02  ERROR-TEXT  PIC X(132) OCCURS 10 TIMES                   
                                      INDEXED BY ERROR-INDEX.           
       77 ERROR-TEXT-LEN          PIC S9(9)  COMP VALUE +132.           
       77 TRACE-MESSAGE-AREA      PIC X(256).                           
       77 OPENFN                  PIC X(12).                            
       77 SSID                    PIC X(4).                             
       77 PLANNAME                PIC X(8).                             
       77 RETCODE                 PIC S9(5).                            
       77 REASCODE                PIC S9(5).                            
       77 CLOSFN                  PIC X(12).                            
       77 TERMOP                  PIC X(4).                             
                                                                        
       01 I-ACCOUNT-NO                   PIC X(14).                     
       01 I-BEACON-SCORE                 PIC X(06).                     
       01 I-UPDATE-FLAG                  PIC X(01).                     
                                                                        
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE **                                                
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBACSCRE                                                  
             END-EXEC                                                           
      **************************************************************            
                                                                        
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
                                                                        
                                                                        
             EXEC SQL                                                           
              INCLUDE SQLCA                                                     
             END-EXEC.                                                          
      ***************************************************************           
      *    CURSOR TO SELECT CSS_BHV_MODEL **                                    
      ***************************************************************           
             EXEC SQL                                                   
A03579        DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                  
              SELECT ACCOUNT_NO                                         
                    ,COMPANY_NO                                         
                    ,REGULATED_FL                                       
                    ,DATE_BILLED                                        
                    ,REVENUE_MONTH                                      
                    ,BILL_NO                                            
                    ,BHV_MODEL_ID                                       
              FROM CSS_BHV_ACCT_SCORE                                   
              WHERE SCORED_FL <> :WS-Y AND                              
ACT050              BHV_MODEL_ID IS NULL                                
              FOR UPDATE OF BHV_MODEL_ID                                
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*      EXEC SQL                                                           
MFA-TR*       DECLARE ACCT_CURSOR CURSOR WITH HOLD FOR                          
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REGULATED_FL                                               
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,BHV_MODEL_ID                                               
MFA-TR*       FROM CSS_BHV_ACCT_SCORE                                           
MFA-TR*       WHERE SCORED_FL <> :WS-Y AND                                      
MFA-TR*             BHV_MODEL_ID IS NULL                                        
MFA-TR*       FOR UPDATE OF BHV_MODEL_ID                                        
MFA-TR*       QUERYNO 7220                                                      
MFA-TR*      END-EXEC.                                                          
      ***************************************************************           
      **   'WORKING STORAGE FOR PCSCA453 ENDS HERE '. **                        
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
      **                  M A I N L I N E **                                    
      ***************************************************************           
       0000-MAINLINE.                                                   
      *-------------*                                                           
             MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             PERFORM 0100-INITIALIZE                                    
                THRU 0100-EXIT.                                         
                                                                        
             DISPLAY 'ASSIGN PRE-ASSIGNED MODELS '.                     
                                                                        
             PERFORM 7210-OPEN-ACCT-CURSOR                              
                THRU 7210-EXIT.                                         
                                                                        
             PERFORM 7220-FETCH-ACCT-CURSOR                             
                THRU 7220-EXIT.                                         
                                                                        
             PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND            
                                                                        
              PERFORM 1200-ASSIGN-HIST-MODEL                            
                 THRU 1200-EXIT                                         
                                                                        
              IF MODEL-NOT-ASSIGNED THEN                                
                                                                        
                IF KF-REGULATED-FL = 'Y'                                
                   PERFORM 2925-WRITE-TO-REG-FILE                       
                      THRU 2925-EXIT                                    
                ELSE                                                    
                   PERFORM 2935-WRITE-TO-DREG-FILE                      
                      THRU 2935-EXIT                                    
                END-IF                                                  
                                                                        
              END-IF                                                    
                                                                        
              PERFORM 7220-FETCH-ACCT-CURSOR                            
                 THRU 7220-EXIT                                         
                                                                        
             END-PERFORM.                                               
                                                                        
             PERFORM 7230-CLOSE-ACCT-CURSOR                             
                THRU 7230-EXIT.                                         
                                                                        
                                                                        
             PERFORM 2885-WRITE-CONTROL-HDR                             
                THRU 2885-EXIT.                                         
                                                                        
             PERFORM 9000-TERMINATE                                     
                THRU 9000-EXIT.                                         
                                                                        
             STOP RUN.                                                  
                                                                        
       0000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ***************************************************************           
      **  0100-INITIALIZE                                          **           
      ***************************************************************           
       0100-INITIALIZE.                                                 
      *--------------*                                                          
             MOVE '100'             TO WS-ACTIVE-PARAGRAPH.             
                                                                        
             PERFORM 0200-OPEN-OUTPUT-FILES                             
                THRU 0200-EXIT.                                         
                                                                        
                                                                        
       0100-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  0200-OPEN-OUTPUT-FILES                                **              
      ************************************************************              
       0200-OPEN-OUTPUT-FILES.                                          
      *---------------------*                                                   
             MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             OPEN OUTPUT FCSC453R-FILE.                                 
             OPEN OUTPUT FCSC453D-FILE.                                 
                                                                        
       0200-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      **  1200-ASSIGN-HIST-MODEL                                  **            
      **************************************************************            
       1200-ASSIGN-HIST-MODEL.                                          
      *----------------------*                                                  
             MOVE '1200'                   TO WS-ACTIVE-PARAGRAPH.      
             SET NO-HIST                   TO TRUE.                     
             SET MODEL-NOT-ASSIGNED        TO TRUE.                     
                                                                        
             PERFORM 7310-SELECT-HIST-MODEL                             
                THRU 7310-EXIT.                                         
                                                                        
             IF GOT-HIST                                                
                PERFORM 8320-UPDATE-ACCT-MODEL                          
                   THRU 8320-EXIT                                       
                SET MODEL-ASSIGNED TO TRUE                              
A03579          ADD +1 TO WS-UPDATE-CT                                  
A03579          IF WS-UPDATE-CT = 0                                     
A03579              EXEC SQL COMMIT                                     
A03579              END-EXEC                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03579              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
A03579                  ADD +1 TO WS-COMMIT-CT                          
A03579                  DISPLAY 'PCSCA453 - COMMIT # ' WS-COMMIT-CT     
A03579                      ' ACCOUNT NUMBER ' KF-ACCOUNT-NO            
A03579                ELSE                                              
A03579                  DISPLAY '**************************************'
A03579                  DISPLAY 'PCSCA453 - 1200-ASSIGN-HIST-MODEL '    
A03579                         'COMMIT SQLCODE = ' SQLCODE              
A03579                  DISPLAY '**************************************'
A03579                  PERFORM 9900-ABEND  THRU 9900-EXIT              
A03579              END-IF                                              
A03579          END-IF                                                  
A03579      END-IF.                                                     
                                                                        
       1200-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      ** 2885-WRITE-CONTROL-HDR                                    *            
      **************************************************************            
       2885-WRITE-CONTROL-HDR.                                          
      *---------------------*                                                   
             MOVE '2885'                       TO WS-ACTIVE-PARAGRAPH.  
             MOVE 9999999999999        TO E-FCSC453R-ACCOUNT            
             MOVE WS-REG-COUNT-N       TO E-FCSC453R-COUNT              
             MOVE 'Y'                  TO E-FCSC453R-HDR-REG-FL         
             MOVE '0'                  TO E-FCSC453R-HDR                
             WRITE FIOC453R                                             
             MOVE 9999999999999        TO E-FCSC453D-ACCOUNT            
             MOVE WS-DREG-COUNT-N      TO E-FCSC453D-COUNT              
             MOVE 'N'                  TO E-FCSC453D-HDR-REG-FL         
             MOVE '0'                  TO E-FCSC453D-HDR                
             WRITE FIOC453D.                                            
       2885-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      ** 2925-WRITE-TO-REG-FILE                                    *            
      **************************************************************            
       2925-WRITE-TO-REG-FILE.                                          
      *---------------------*                                                   
             MOVE '2925'              TO WS-ACTIVE-PARAGRAPH.           
             MOVE KF-ACCOUNT-NO       TO E-FCSC453R-ACCT-NO             
             MOVE KF-BILL-NO          TO E-FCSC453R-BILL-NO             
             MOVE KF-REVENUE-MONTH    TO E-FCSC453R-REV-MNTH            
             MOVE '1'                 TO E-FCSC453R-DET                 
             WRITE FIOC453R.                                            
             ADD 1    TO WS-REG-COUNT-N.                                
                                                                        
       2925-EXIT.                                                       
             EXIT.                                                      
      *************************************************************             
      ** 2935-WRITE-TO-DREG-FILE                                 *              
      *************************************************************             
       2935-WRITE-TO-DREG-FILE.                                         
             MOVE '2935'                       TO WS-ACTIVE-PARAGRAPH.  
                                                                        
             MOVE KF-ACCOUNT-NO       TO E-FCSC453D-ACCT-NO             
             MOVE KF-BILL-NO          TO E-FCSC453D-BILL-NO             
             MOVE KF-REVENUE-MONTH    TO E-FCSC453D-REV-MNTH            
             MOVE '1'                 TO E-FCSC453D-DET                 
             WRITE FIOC453D.                                            
             ADD 1    TO WS-DREG-COUNT-N.                               
                                                                        
       2935-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  7310-SELECT-HIST-MODEL                                **              
      ************************************************************              
       7310-SELECT-HIST-MODEL.                                          
      *------------------------*                                                
             MOVE '7310'                 TO WS-ACTIVE-PARAGRAPH.        
                                                                        
             EXEC SQL                                                   
              SELECT ACC.BHV_MODEL_ID                                   
                INTO :KF-BHV-MODEL-ID :WS-NULL-IND2                      
                FROM CSS_BHV_ACCT_SCORE  ACC
                           WITH(READUNCOMMITTED), CSS_BHV_MODEL MOD
                           WITH(READUNCOMMITTED)         
               WHERE ACC.ACCOUNT_NO       = :KF-ACCOUNT-NO              
                 AND ACC.SCORED_FL        = :WS-Y                       
                 AND ACC.BHV_MODEL_ID     = MOD.BHV_MODEL_ID            
ACT188           AND MOD.BHV_MODEL_STATUS = 'A'                         
                 AND ACC.DATE_BILLED = (SELECT MAX(DATE_BILLED)         
                                    FROM CSS_BHV_ACCT_SCORE
                           WITH(READUNCOMMITTED)             
                                   WHERE ACCOUNT_NO = :KF-ACCOUNT-NO    
                                     AND SCORED_FL = :WS-Y)             
                                                                 
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT ACC.BHV_MODEL_ID                                           
MFA-TR*         INTO :KF-BHV-MODEL-ID:WS-NULL-IND2                              
MFA-TR*         FROM CSS_BHV_ACCT_SCORE  ACC, CSS_BHV_MODEL MOD                 
MFA-TR*        WHERE ACC.ACCOUNT_NO       = :KF-ACCOUNT-NO                      
MFA-TR*          AND ACC.SCORED_FL        = :WS-Y                               
MFA-TR*          AND ACC.BHV_MODEL_ID     = MOD.BHV_MODEL_ID                    
MFA-TR*          AND MOD.BHV_MODEL_STATUS = 'A'                                 
MFA-TR*          AND ACC.DATE_BILLED = (SELECT MAX(DATE_BILLED)                 
MFA-TR*                             FROM CSS_BHV_ACCT_SCORE                     
MFA-TR*                            WHERE ACCOUNT_NO = :KF-ACCOUNT-NO            
MFA-TR*                              AND SCORED_FL = :WS-Y)                     
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7310                                                   
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.       
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               OR NOT-FOUND THEN                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  AND WS-NULL-IND2 = 0                                  
                 SET GOT-HIST TO TRUE                                   
               END-IF                                                   
             ELSE                                                       
               STRING 'ERROR FETCHING PRE-ASSIGNED MODELS **'           
                                  DELIMITED BY SIZE                     
                                  INTO    WS-ERR-MSG                    
               STRING 'ACCOUNT NO   ' DELIMITED BY SIZE                 
                 WS-ACCOUNT-NO   DELIMITED BY SIZE                      
                                 INTO    WS-ERR-MSG2                    
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
             END-IF.                                                    
                                                                        
       7310-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  7210-OPEN-ACCT-CURSOR                                    **           
      ***************************************************************           
       7210-OPEN-ACCT-CURSOR.                                           
      *---------------------*                                                   
             MOVE '7210'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              OPEN ACCT_CURSOR                                          
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                CONTINUE                                                
             ELSE                                                       
                STRING ' ERROR OPENING ACCOUNTS CURSOR **'              
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
                                                                        
       7210-EXIT.                                                       
             EXIT.                                                      
      ************************************************************              
      **  7220-FETCH-ACCT-CURSOR                                **              
      ************************************************************              
       7220-FETCH-ACCT-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7220'        TO WS-ACTIVE-PARAGRAPH.                 
                                                                        
             EXEC SQL                                                   
              FETCH ACCT_CURSOR                                         
               INTO :KF-ACCOUNT-NO                                      
                   ,:KF-COMPANY-NO                                      
                   ,:KF-REGULATED-FL                                    
                   ,:KF-DATE-BILLED                                     
                   ,:KF-REVENUE-MONTH                                   
                   ,:KF-BILL-NO                                         
                   ,:KF-BHV-MODEL-ID :WS-NULL-IND1                       
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE            
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR FETCHING ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7220-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ************************************************************              
      **  7230-CLOSE ACCT CURSOR                                **              
      ************************************************************              
       7230-CLOSE-ACCT-CURSOR.                                          
      *----------------------*                                                  
             MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              CLOSE ACCT_CURSOR                                         
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.    
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       7230-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  8320-UPDATE-ACCT-MODEL                                   **           
      ***************************************************************           
       8320-UPDATE-ACCT-MODEL.                                          
      *----------------------*                                                  
             MOVE '8320'                   TO WS-ACTIVE-PARAGRAPH.      
             EXEC SQL                                                   
              UPDATE CSS_BHV_ACCT_SCORE                                 
                 SET BHV_MODEL_ID     = :KF-BHV-MODEL-ID                
               WHERE CURRENT OF ACCT_CURSOR                             
**************** AND BILL_NO          = :KF-BILL-NO                             
**************** AND COMPANY_NO       = :KF-COMPANY-NO                          
**************** AND REGULATED_FL     = :KF-REGULATED-FL                        
**************** AND DATE_BILLED      = :KF-DATE-BILLED                         
**************** AND REVENUE_MONTH    = :KF-REVENUE-MONTH                       
**************** AND SCORED_FL       <> :WS-Y                                   
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                NEXT SENTENCE                                           
             ELSE                                                       
                STRING ' ERROR CLOSING  ACCOUNTS CURSOR **'             
                                   DELIMITED BY SIZE                    
                                   INTO WS-ERR-MSG                      
                STRING SPACES            DELIMITED BY SIZE              
                                   INTO WS-ERR-MSG2                     
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
             END-IF.                                                    
       8320-EXIT.                                                       
             EXIT.                                                      
      ***************************************************************           
      **  8800-DIS-TABLE-ERROR                                     **           
      ***************************************************************           
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
             DISPLAY '**********************************************'.  
             DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.  
             DISPLAY  WS-ERR-MSG.                                       
             DISPLAY '**********************************************'.  
             DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.     
             DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.   
             DISPLAY '**' WS-ERR-MSG2.                                  
             DISPLAY '**********************************************'.  
             PERFORM 9900-ABEND                                         
                THRU 9900-EXIT.                                         
                                                                        
       8800-EXIT.                                                       
             EXIT.                                                      
      **************************************************************            
      **  9000-TERMINATE **                                                     
      **  NORMAL TERMINATION OF THE PROGRAM **                                  
      **************************************************************            
       9000-TERMINATE.                                                  
      *--------------*                                                          
             CLOSE FCSC453R-FILE.                                       
             CLOSE FCSC453D-FILE.                                       
                                                                        
       9000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      *      EXEC SQL                                                           
      *       INCLUDE CPD00037                                                  
      *      END-EXEC.                                                          
      *********************************************************554600           
      *     9900-ABEND                                              *           
      *     PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                *           
      ***************************************************************           
       9900-ABEND.                                                      
             DISPLAY 'PERFORMING 9900-ABEND'.                           
             PERFORM 9000-TERMINATE THRU 9000-EXIT.                     
SCA003       EXEC SQL
SCA003           ROLLBACK
SCA003       END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

             MOVE 12  TO  RETURN-CODE.                                  
             MOVE 'YES' TO WS-ABEND-SWITCH.                             
             DISPLAY 'PCSCA453 ABEND INITIATED'.                        
       9900-EXIT.                                                       
             IF WS-ABEND-YES                                            
               STOP RUN
             END-IF.                                                
