       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA452.                                        
       DATE-WRITTEN.   OCT 2003.                                        
                                                                        
      **************************************************************            
      *   PROGRAM MODIFICATION LOG                                              
      **************************************************************            
      *  12/03     PD         NEW PROGRAM                                       
A04527*  06/06/13  MR7E794    REMOVED UNUSED COPYBOOK CWS00056.                 
      **************************************************************            
      *       REMARKS.                                                          
      **************************************************************            
      *  THIS PROGRAM ACTIVATES/DEACTIVATES MODELS IN CSS_BHV_MODEL*            
      **************************************************************            
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
          0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION          
          1000 - 1999     INPUT PROCESSING CONTROL PATH                 
          2000 - 2999     OUTPUT PROCESSING CONTROL PATH                
          3000 - 4999     BATCH PROCESSING MODULES - NOT USED           
          5000 - 5999     COMMON PROGRAM MODULES                        
          6000 - 6999     COMMON SYSTEM MODULES                         
          7000 - 7999     INPUT MODULES                                 
          8000 - 8999     OUTPUT MODULES                                
          9000 - 9799     TERMINATION MODULES                           
          9800 - 9899     XCTLS TO PROGRAMS                             
          9900 - 9999     ABEND/ABORT MODULES                           
      **************************************************************            
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *COPY CSSCA356.                                                           
********** SELECT FCSCA356-FILE                                                 
**********     ASSIGN UT-S-FCSCA356.                                            
      *                                                                         
      *COPY CSSEQUIFAX.                                                         
********** SELECT EQUIFAX-FILE                                                  
**********     ASSIGN UT-S-FCSEQUIFAX.                                          
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
*******COPY FIOCA356.                                                           
*******COPY FIOEQUIFAX.                                                         
      *                                                                         
      **************************************************************            
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA452'.
MSQ017     COPY MFASQLM.
      **************************************************************            
      * 'WORKING STORAGE FOR PCSCA452 STARTS HERE'.                             
      **************************************************************            
                                                                        
       01 WS-START                   PIC X(40)                          
           VALUE 'WORKING STORAGE FOR PCSCA452 STARTS HERE'.            
      *                                                                         
       01 WS-FLAGS.                                                     
          05  WS-EXISTS-FLAG         PIC X(01).                         
          05  WS-ACCT-EXIST          PIC X(01).                         
       01 WS-SWITCHES.                                                  
          05  WS-FCSCA356-EOF-SW          PIC X(01) VALUE 'N'.          
              88  WS-FCSCA356-AT-EOF      VALUE 'Y'.                    
              88  WS-FCSCA356-NOT-AT-EOF  VALUE 'N'.                    
          05  WS-FAC01-STATUS             PIC X(02) VALUE '00'.         
              88  WS-FAC01-SUCCESSFUL     VALUE '00'.                   
          05  WS-FAC22-STATUS             PIC X(02) VALUE '00'.         
              88  WS-FAC22-SUCCESSFUL     VALUE '00'.                   
          05  WS-VALID-ACCT-SW            PIC X(01) VALUE 'Y'.          
              88  WS-VALID-ACCOUNT                  VALUE 'Y'.          
              88  WS-NOT-VALID-ACCOUNT              VALUE 'N'.          
          05  WS-VALID-PROC-SW            PIC X(01) VALUE 'Y'.          
              88  WS-ACCT-PROC                      VALUE 'Y'.          
              88  WS-ACCT-NOT-PROC                  VALUE 'N'.          
          05  WS-COBB-XFERED-FLAG         PIC X(01) VALUE 'Y'.          
              88  COBB-XFERED-ACCT                  VALUE 'Y'.          
              88  REGULAR-ACCT                      VALUE 'N'.          
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME            PIC X(10) VALUE 'PCSCA452'.        
          05  WS-USER-ABEND-CODE     PIC S9(4) COMP VALUE +100.         
       01 WS-ACCT-SCORE.                                                
COB305    05 WS-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.                
          05  WS-COMPANY-NO          PIC X(02).                         
          05  WS-REGULATED-FL        PIC X(01).                         
          05  WS-ASSOC-MODEL-ID      PIC X(04).                         
          05  WS-DATE-BILLED         PIC X(10).                         
COB305    05 WS-REVENUE-MONTH        PIC S9(06)V COMP-3 VALUE 0.                
          05  WS-CODE-REV-CLASS      PIC X(3).                          
          05  WS-CUSTOMER-NO         PIC 9(10).                         
          05  WS-BILL-NO             PIC S9(09)  COMP.                  
      **************************************************************            
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                         
      **************************************************************            
       01 WS-DATE-VARIABLES.                                            
          05  WS-TEMP-DATE.                                             
              10 WS-TEMP-YY               PIC 9(04).                    
              10 FILLER                   PIC X(01) VALUE '-'.          
              10 WS-TEMP-MM               PIC 9(02).                    
              10 FILLER                   PIC X(01) VALUE '-'.          
              10 WS-TEMP-DD               PIC 9(02).                    
          05  WS-RUN-DATE                 PIC X(10).                    
          05  WS-BATCH-DATE.                                            
              10 WS-BATCH-MM              PIC 9(02).                    
              10 FILLER                   PIC X(01) VALUE '-'.          
              10 WS-BATCH-DD              PIC 9(02).                    
              10 FILLER                   PIC X(01) VALUE '-'.          
              10 WS-BATCH-YY              PIC 9(04).                    
      **************************************************************            
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                         
      **************************************************************            
       01 WS-TIME-VARIABLES.                                            
          05  WS-RUN-TIME.                                              
              10 WS-HH                PIC 9(02).                        
              10 WS-MM                PIC 9(02).                        
              10 WS-TT                PIC 9(02).                        
       01 WS-DATE-VARIABLES-1.                                          
          05  WS-AC01-DATE.                                             
              10  WS-AC01-CC          PIC 9(02) VALUE ZEROES.           
              10  WS-AC01-YY          PIC 9(02) VALUE ZEROES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-AC01-MM          PIC 9(02) VALUE ZEROES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-AC01-DD          PIC 9(02) VALUE ZEROES.           
          05  WS-DRAFT-DATE.                                            
              10  WS-DRAFT-CC         PIC 9(02) VALUE ZEROES.           
              10  WS-DRAFT-YY         PIC 9(02) VALUE ZEROES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-DRAFT-MM         PIC 9(02) VALUE ZEROES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-DRAFT-DD         PIC 9(02) VALUE ZEROES.           
          05  WS-CHECK-DATE.                                            
              10  WS-CHECK-CC         PIC X(02) VALUE '20'.             
              10  WS-CHECK-YY         PIC X(02) VALUE SPACES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-CHECK-MM         PIC X(02) VALUE SPACES.           
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-CHECK-DD         PIC X(02) VALUE SPACES.           
       01 WS-WORK-VARIABLES.                                            
          05  WS-ERR-MSG              PIC X(100) VALUE SPACES.          
          05  WS-ERR-MSG2             PIC X(100) VALUE SPACES.          
          05  WS-NO-FUT-MODEL         PIC S9(4) COMP VALUE 0.           
       01 WS-DISPLAY.                                                   
          05  WS-ACCOUNT-NO           PIC X(14) VALUE SPACES.           
          05  FILLER                  PIC X(01) VALUE SPACES.           
       01 WS-HARDCODED-VARIABLES.                                       
          05  WS-COMPANY              PIC X(02) VALUE '01'.             
          05  WS-CSR                  PIC S9(9)V9(5).                   
          05  WS-DATABASE             PIC X(08) VALUE 'DATABASE'.       
          05  WS-SCORE-VALUES         PIC X(01) VALUE 'Y'.              
          05  WS-DEF-RATING           PIC X(01) VALUE ' '.              
          05  WS-DEF-SCORED-FL        PIC X(01) VALUE 'N'.              
          05  WS-DEF-DIALER-FL        PIC X(01) VALUE 'N'.              
       01 WS-END                      PIC X(40)                         
                 VALUE 'WORKING STORAGE FOR PCSCA452 ENDS HERE  '.      
      **************************************************************            
      **     COPYBOOKS USED IN THE PROGRAM                                      
      **************************************************************            
      ****** DB2 COMMUNICATION REQUIREMENT *************************            
      *01 LOC1                    USAGE IS SQL TYPE IS                  
      *                           RESULT-SET-LOCATOR VARYING.           
       01 ERROR-MESSAGE.                                                
          02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.          
          02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES            
                                  INDEXED BY ERROR-INDEX.               
       77 ERROR-TEXT-LEN          PIC S9(9)  COMP VALUE +132.           
       77 TRACE-MESSAGE-AREA      PIC X(256).                           
       77 OPENFN                  PIC X(12).                            
       77 SSID                    PIC X(4).                             
       77 PLANNAME                PIC X(8).                             
       77 RETCODE                 PIC S9(5).                            
       77 REASCODE                PIC S9(5).                            
       77 CLOSFN                  PIC X(12).                            
       77 TERMOP                  PIC X(4).                             
                                                                        
       01 I-ACCOUNT-NO            PIC X(14).                            
       01 I-BEACON-SCORE          PIC X(06).                            
       01 I-UPDATE-FLAG           PIC X(01).                            
                                                                        
                                                                        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
                                                                        
             EXEC SQL                                                           
              INCLUDE CWS00315                                                  
             END-EXEC.                                                          
                                                                        
             EXEC SQL                                                           
              INCLUDE SQLCA                                                     
             END-EXEC.                                                          
      ***************************************************************           
      **    CSS_ACCOUNT                                                         
      ***************************************************************           
             EXEC SQL                                                           
              INCLUDE TBACCT                                                    
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BILLING_HDR                                                      
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBLLHDR                                                  
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_JOB_PARM                                                         
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBJBPARM                                                  
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BILLING_DET                                                      
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBLLDET                                                  
             END-EXEC.                                                          
      **************************************************************            
      **   CSS_BHV_DIMENSION                                                    
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHDIMS                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CATEGORY                                                     
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHVCAT                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CRITERIA                                                     
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBCRITRA                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE                                                   
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBACSCRE                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_MODEL                                                        
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHMODL                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCORE                                                        
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHVSCR                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCOR_MODL                                                    
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBBHSCRE                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_SCOR_RATING                                                  
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBSCRRAT                                                  
             END-EXEC                                                           
      **************************************************************            
      *    CSS_BHV_CATEG_MODL                                                   
      **************************************************************            
             EXEC SQL                                                           
              INCLUDE TBCATMDL                                                  
             END-EXEC                                                           
      *************************************************************             
      **************************************************************            
      **            CURSOR TO SELECT CSS_BHV_MODEL                              
      **************************************************************            
             EXEC SQL                                                   
              DECLARE FUT_CURSOR CURSOR FOR                             
              SELECT  COMPANY_NO                                        
                     ,REGULATED_FL                                      
                     ,ASSOC_MODEL_ID                                    
                     ,BHV_MODEL_STATUS                                  
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                     ,LAST_UPDATE_USERID                                
              FROM CSS_BHV_MODEL                                        
              WHERE EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :KS-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :KS-EFFECTIVE-DT
              ) <> 0) OR (LEN(:KS-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :KS-EFFECTIVE-DT
              ), CONVERT(DATE, :KS-EFFECTIVE-DT) )                
                AND BHV_MODEL_STATUS = 'F'                              
              FOR UPDATE OF                                             
                      BHV_MODEL_STATUS                                  
                     ,LAST_UPDATE_TS                                    
                     ,LAST_UPDATE_USERID                                
                                                                        
       END-EXEC.                                                        

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*       DECLARE FUT_CURSOR CURSOR FOR                                     
MFA-TR*       SELECT  COMPANY_NO                                                
MFA-TR*              ,REGULATED_FL                                              
MFA-TR*              ,ASSOC_MODEL_ID                                            
MFA-TR*              ,BHV_MODEL_STATUS                                          
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*       FROM CSS_BHV_MODEL                                                
MFA-TR*       WHERE EFFECTIVE_DT     <= :KS-EFFECTIVE-DT                        
MFA-TR*         AND BHV_MODEL_STATUS = 'F'                                      
MFA-TR*       FOR UPDATE OF                                                     
MFA-TR*               BHV_MODEL_STATUS                                          
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*                                                                         
MFA-TR*END-EXEC.                                                                
      **************************************************************            
      *    'WORKING STORAGE FOR PCSCA452 ENDS HERE '.                           
      **************************************************************            
       PROCEDURE DIVISION.                                              
      **************************************************************            
      **                   M A I N L I N E                                      
      **************************************************************            
       0000-MAINLINE.                                                   
      *------------*                                                            
              MOVE '0000'                     TO WS-ACTIVE-PARAGRAPH.   
                                                                        
              PERFORM 0300-SETUP-DATES                                  
                 THRU 0300-EXIT.                                        
                                                                        
              DISPLAY 'ACTIVATE/DEACTICVATE MODELS '.                   
                                                                        
              MOVE WS-RUN-DATE TO KS-EFFECTIVE-DT                       
                                                                        
              PERFORM 7200-SELECT-FUT-MODEL                             
                 THRU 7200-EXIT.                                        
                                                                        
              IF WS-NO-FUT-MODEL >= 1 THEN                              
                 PERFORM 1200-REFRESH-MODEL-STATUS                      
                    THRU 1200-EXIT                                      
              END-IF.                                                   
              PERFORM 9000-TERMINATE                                    
                 THRU 9000-EXIT.                                        
                                                                        
              STOP RUN.                                                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
      *************************************************************     ******* 
      **             0300-SETUP-DATES **                                     ** 
      *************************************************************     ******* 
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
           MOVE 'COMMONDATE'             TO G6-PROGRAM-NAME.            
           PERFORM 7100-SELECT-JOB-PARM  THRU 7100-EXIT                 
           MOVE G6-PARM-DATA             TO WS-RUN-DATE.                
                                                                        
                                                                        
       0300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      **************************************************************    *       
      **        1200-REFRESH-MODEL-STATUS                          *    *       
      **************************************************************    *       
       1200-REFRESH-MODEL-STATUS.                                       
      *------------------------*                                                
              MOVE '1200'           TO WS-ACTIVE-PARAGRAPH.             
                                                                        
              PERFORM 7210-OPEN-FUT-MODEL                               
                 THRU 7210-EXIT.                                        
                                                                        
              PERFORM 7220-FETCH-FUT-MODEL                              
                 THRU 7220-EXIT.                                        
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                 
                                                                        
                PERFORM 8200-UPDATE-TO-INACTIVE                         
                   THRU 8200-EXIT                                       
                                                                        
                PERFORM 8300-UPDATE-TO-ACTIVE                           
                   THRU 8300-EXIT                                       
                                                                        
                PERFORM 7220-FETCH-FUT-MODEL                            
                   THRU 7220-EXIT                                       
                                                                        
              END-PERFORM.                                              
                                                                        
              PERFORM 7230-CLOSE-FUT-MODEL                              
                      THRU 7230-EXIT.                                   
                                                                        
       1200-EXIT.                                                       
            EXIT.                                                       
      **************************************************************    *       
      **        7100-SELECT-JOB-PARM                               *    *       
      **************************************************************    *       
       7100-SELECT-JOB-PARM.                                            
      *------------------------*                                                
              MOVE '7100'                 TO WS-ACTIVE-PARAGRAPH.       
                                                                        
              EXEC SQL                                                  
              SELECT  PARM_DATA                                         
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM                                       
               WHERE PROGRAM_NAME      = :G6-PROGRAM-NAME               
              END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.      
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                CONTINUE                                                
              ELSE                                                      
                STRING 'SELECT JOBPARM    **'                           
                                    DELIMITED BY SIZE                   
                                    INTO    WS-ERR-MSG                  
                STRING 'RUN DATE   ' DELIMITED BY SIZE                  
                   G6-PROGRAM-NAME     DELIMITED BY SIZE                
                                        INTO    WS-ERR-MSG2             
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
              END-IF.                                                   
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      **************************************************************    *       
      **        7200-SELECT-FUT-MODEL                              *    *       
      **************************************************************    *       
       7200-SELECT-FUT-MODEL.                                           
      *------------------------*                                                
              MOVE '7200'                 TO WS-ACTIVE-PARAGRAPH.       
                                                                        
              EXEC SQL                                                  
              SELECT  COUNT(*)                                          
                INTO :WS-NO-FUT-MODEL                                   
                FROM CSS_BHV_MODEL                                      
               WHERE EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :KS-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :KS-EFFECTIVE-DT
              ) <> 0) OR (LEN(:KS-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :KS-EFFECTIVE-DT
              ), CONVERT(DATE, :KS-EFFECTIVE-DT) )               
                 AND BHV_MODEL_STATUS  = 'F'                            
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*       SELECT  COUNT(*)                                                  
MFA-TR*         INTO :WS-NO-FUT-MODEL                                           
MFA-TR*         FROM CSS_BHV_MODEL                                              
MFA-TR*        WHERE EFFECTIVE_DT     <= :KS-EFFECTIVE-DT                       
MFA-TR*          AND BHV_MODEL_STATUS  = 'F'                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.      
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                CONTINUE                                                
              ELSE                                                      
                STRING 'FETCHING FUTURE MODELS FROM CIS **'             
                                    DELIMITED BY SIZE                   
                                    INTO    WS-ERR-MSG                  
                STRING 'RUN DATE   ' DELIMITED BY SIZE                  
                   WS-RUN-DATE         DELIMITED BY SIZE                
                                        INTO    WS-ERR-MSG2             
                PERFORM 8800-DIS-TABLE-ERROR                            
                   THRU 8800-EXIT                                       
              END-IF.                                                   
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      **************************************************************    *       
      **           7210-OPEN FUT MODEL CURSOR **                                
      **************************************************************    *       
       7210-OPEN-FUT-MODEL.                                             
      *-------------------*                                                     
            MOVE '7210'               TO WS-ACTIVE-PARAGRAPH.           
                                                                        
            EXEC SQL                                                    
             OPEN FUT_CURSOR                                            
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.         
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              CONTINUE                                                  
            ELSE                                                        
             STRING ' ERROR OPENING MODEL CURSOR **'                    
                                  DELIMITED BY SIZE                     
                                   INTO WS-ERR-MSG                      
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
            END-IF.                                                     
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
      **************************************************************    *       
      **  7220-FETCH FUT MODEL CURSOR                              *    *       
      **************************************************************    *       
       7220-FETCH-FUT-MODEL.                                            
      *--------------------*                                                    
           MOVE '7220'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            FETCH FUT_CURSOR                                            
             INTO :WS-COMPANY-NO,                                       
                 :WS-REGULATED-FL,                                      
                 :WS-ASSOC-MODEL-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
             STRING ' ERROR FETCHING MODEL CURSOR **'                   
                                    DELIMITED BY SIZE                   
                                    INTO WS-ERR-MSG                     
             STRING SPACES          DELIMITED BY SIZE                   
                                    INTO WS-ERR-MSG2                    
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
           END-IF.                                                      
                                                                        
        7220-EXIT.                                                      
           EXIT.                                                        
      ***************************************************************** *       
      **  7230-CLOSE FUT MODEL CURSOR                                 * *       
      ***************************************************************** *       
       7230-CLOSE-FUT-MODEL.                                            
      *--------------------*                                                    
            MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH.       
                                                                        
            EXEC SQL                                                    
             CLOSE FUT_CURSOR                                           
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
             CONTINUE                                                   
            ELSE                                                        
             STRING ' ERROR CLOSING MODEL CURSOR **'                    
                                          DELIMITED BY SIZE             
                                          INTO WS-ERR-MSG               
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
            END-IF.                                                     
                                                                        
       7230-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************   *       
      **        8200-UPDATE-TO-INACTIVE                             *   *       
      ***************************************************************   *       
       8200-UPDATE-TO-INACTIVE.                                         
      *----------------------*                                                  
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
            EXEC SQL                                                    
             UPDATE CSS_BHV_MODEL                                       
                SET BHV_MODEL_STATUS  = 'I'                             
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
                   ,LAST_UPDATE_USERID = 'CA452'                        
              WHERE COMPANY_NO        = :WS-COMPANY-NO                  
                AND REGULATED_FL      = :WS-REGULATED-FL                
                AND BHV_MODEL_STATUS  = 'A'                             
                AND BHV_MODEL_ID      <> :WS-ASSOC-MODEL-ID             
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*      UPDATE CSS_BHV_MODEL                                               
MFA-TR*         SET BHV_MODEL_STATUS  = 'I'                                     
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*            ,LAST_UPDATE_USERID = 'CA452'                                
MFA-TR*       WHERE COMPANY_NO        = :WS-COMPANY-NO                          
MFA-TR*         AND REGULATED_FL      = :WS-REGULATED-FL                        
MFA-TR*         AND BHV_MODEL_STATUS  = 'A'                                     
MFA-TR*         AND BHV_MODEL_ID      <> :WS-ASSOC-MODEL-ID                     
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
             CONTINUE                                                   
            ELSE                                                        
             STRING ' ERROR DE-ACTIVATING MODEL **'                     
                                       DELIMITED BY SIZE                
                                       INTO WS-ERR-MSG                  
             STRING SPACES             DELIMITED BY SIZE                
                                       INTO WS-ERR-MSG2                 
             PERFORM 8800-DIS-TABLE-ERROR                               
                THRU 8800-EXIT                                          
            END-IF.                                                     
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **      8300-UPDATE-TO-ACTIVE                                **           
      ***************************************************************           
       8300-UPDATE-TO-ACTIVE.                                           
      *------------------------*                                                
              MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.     
              EXEC SQL                                                  
                UPDATE CSS_BHV_MODEL                                    
                SET BHV_MODEL_STATUS   = 'A'                            
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
                   ,LAST_UPDATE_USERID = 'CA452'                        
                WHERE CURRENT OF FUT_CURSOR                             
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*         UPDATE CSS_BHV_MODEL                                            
MFA-TR*         SET BHV_MODEL_STATUS   = 'A'                                    
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*            ,LAST_UPDATE_USERID = 'CA452'                                
MFA-TR*         WHERE CURRENT OF FUT_CURSOR                                     
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                  CONTINUE                                              
              ELSE                                                      
                  STRING ' ERROR ACTIVATING MODEL **'                   
                           DELIMITED BY SIZE                            
                           INTO WS-ERR-MSG                              
                  STRING SPACES   DELIMITED BY SIZE                     
                           INTO WS-ERR-MSG2                             
                  PERFORM 8800-DIS-TABLE-ERROR                          
                     THRU 8800-EXIT                                     
              END-IF.                                                   
                                                                        
       8300-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **  8800-DIS-TABLE-ERROR                               **                 
      ***************************************************************           
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
            DISPLAY '**********************************************'.   
            DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.   
            DISPLAY  WS-ERR-MSG.                                        
            DISPLAY '**********************************************'.   
            DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.      
            DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.    
            DISPLAY '**' WS-ERR-MSG2.                                   
            DISPLAY '**********************************************'.   
            PERFORM 9900-ABEND                                          
                THRU 9900-EXIT.                                         
       8800-EXIT.                                                       
            EXIT.                                                       
      **************************************************************            
      **  8900-DISPLAY-ERR-TERM **                                              
      **************************************************************            
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
             DISPLAY '                                   '.             
             DISPLAY '******************************************'.      
             DISPLAY '**     PCSCA452 PROCESSING ERROR        **'.      
             DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.     
             DISPLAY '**' WS-ERR-MSG.                                   
             DISPLAY '**' WS-ERR-MSG2.                                  
             DISPLAY '**       PROCESSING TERMINATED          **'.      
             DISPLAY '******************************************'.      
             PERFORM 9900-ABEND                                         
                  THRU 9900-EXIT.                                       
       8900-EXIT.                                                       
            EXIT.                                                       
      *************************************************************             
       9000-TERMINATE.                                                  
      *--------------*                                                          
******* CLOSE FCSCA356-FILE.                                                    
******* CLOSE FCSEQUIFAX-FILE.                                                  
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *       EXEC SQL                                                          
      *         INCLUDE CPD00037                                                
      *       END-EXEC.                                                         
                                                                        
      ***************************************************************           
      *     9900-ABEND                                                          
      ***************************************************************           
       9900-ABEND.                                                      
              DISPLAY 'PERFORMING 9900-ABEND'.                          
              PERFORM 9000-TERMINATE THRU 9000-EXIT.                    
SCA003        EXEC SQL
SCA003            ROLLBACK
SCA003        END-EXEC.                                                 

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

              MOVE 12  TO  RETURN-CODE.                                 
              MOVE 'YES' TO WS-ABEND-SWITCH.                            
              DISPLAY 'PCSCA452 ABEND INITIATED'.                       
       9900-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
