       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA451.                                        
       DATE-WRITTEN.   OCT 2003.                                        
      *************************************************************             
      *                 PROGRAM MODIFICATION LOG                  *             
      *   DATE    INITIALS   REASON                               *             
      * --------  --------   -------------------------------------*             
      *  12/03     PD         NEW PROGRAM                         *             
      *                                                           *             
T34713*  08/06     CVNS       SKIP ACCOUNTS THAT DON'T HAVE A     *             
T34713*                       DATE-BILLED.                        *             
P00453*  08/11     SP95538    SKIP PRP ACCOUNTS WHICH HAS         *             
P00453*                       LAST_NRML_BILL_NO = 1               *             
ACT054*  08/11     SP95538    SKIP PRP ACCOUNTS WHICH HAS         *             
ACT054*  05/12     BD09555    PREVIOUS CHANGE BACKED OUT; PROGRAM *             
ACT054*  05/12                FARTHER DOWNSTREAM NOW HAS LOGIC    *             
ACT054*  05/12                TO HANDLE NEGATIVE NUMBER OF DAYS.  *             
A04527*  06/06/13  MR7E794    REMOVED UNUSED COPYBOOK CWS00056.   *             
ACT527*  06/06/13  MR7E794    REMOVED UNUSED COPYBOOK CWS00056.   *             
ACT259*  28/12/15  MC95456    REPLACED INPUT FILE WITH DB07.      *             
ACT259*  02/01/16  MC95456    HANDLED -803 WHILE INSERT TO TABLE  *             
      *************************************************************             
                           REMARKS.                                     
      *************************************************************             
      *  THIS PROGRAM READS CSS_BHV_ACCT_SCORE FOR NON-PROCESSED                
      *  PAYMENTS AND PROCESSES THEM ACCORDINGLY.                               
      *************************************************************             
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
          0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION          
          1000 - 1999     INPUT PROCESSING CONTROL PATH                 
          2000 - 2999     OUTPUT PROCESSING CONTROL PATH                
          3000 - 4999     BATCH PROCESSING MODULES - NOT USED           
          5000 - 5999     COMMON PROGRAM MODULES                        
          6000 - 6999     COMMON SYSTEM MODULES                         
          7000 - 7999     INPUT MODULES                                 
          8000 - 8999     OUTPUT MODULES                                
          9000 - 9799     TERMINATION MODULES                           
          9800 - 9899     XCTLS TO PROGRAMS                             
          9900 - 9999     ABEND/ABORT MODULES                           
      ***************************************************************           
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
ACT259 COPY CSSDB07.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************CSS00010
ACT259* CFDDB07 - FD STATEMENT FOR DB07 FILE                           *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
      *                                                                         
ACT259 COPY CFDDB07.                                                            
ACT259 COPY FIODB07.                                                            
      *                                                                         
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA451'.
MSQ017     COPY MFASQLM.
                                                                        
      ***************************************************************           
      *         'WORKING STORAGE FOR PCSCA451 STARTS HERE'.                     
      ***************************************************************           
                                                                        
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA451 STARTS HERE'.            
      *                                                                         
       01 WS-FLAGS.                                                     
          05  WS-EXISTS-FLAG                PIC X(01).                  
          05  WS-ACCT-EXIST                 PIC X(01).                  
       01 WS-SWITCHES.                                                  
ACT259    05  WS-FDB07-STATUS               PIC X(02).                  
ACT259        88 FDB07-SUCCESSFUL                     VALUE '00'.       
ACT259    05  WS-FCSDB07-EOF-SW             PIC X(01) VALUE 'N'.        
ACT259        88  WS-FCSDB07-EOF                      VALUE 'Y'.        
ACT259        88  WS-FCSDB07-NOT-EOF                  VALUE 'N'.        
ACT259    05  WS-COMMON-DATE                PIC X(10) VALUE SPACES.     
ACT259    05  WS-BEGIN-REC-SW               PIC X(01) VALUE 'N'.        
ACT259        88 WS-BEGIN-RECS-PROCESSED              VALUE 'Y'.        
ACT259    05  WS-RECORD-FOUND               PIC X(01) VALUE 'N'.        
ACT259        88 DATA-RECORD-FOUND                    VALUE 'Y'.        
ACT259        88 NO-DATA-RECORD-FOUND                 VALUE 'N'.        
          05  WS-FAC01-STATUS               PIC X(02) VALUE '00'.       
              88  WS-FAC01-SUCCESSFUL                 VALUE '00'.       
          05  WS-FAC22-STATUS               PIC X(02) VALUE '00'.       
              88  WS-FAC22-SUCCESSFUL                 VALUE '00'.       
          05  WS-VALID-ACCT-SW              PIC X(01) VALUE 'Y'.        
              88  WS-VALID-ACCOUNT                    VALUE 'Y'.        
              88  WS-NOT-VALID-ACCOUNT                VALUE 'N'.        
          05  WS-COBB-XFERED-FLAG           PIC X(01) VALUE 'Y'.        
              88  COBB-XFERED-ACCT                    VALUE 'Y'.        
              88  REGULAR-ACCT                        VALUE 'N'.        
                                                                        
          05  WS-VALID-PROC-SW              PIC X(01) VALUE 'Y'.        
              88  WS-ACCT-PROC                        VALUE 'Y'.        
              88  WS-ACCT-NOT-PROC                    VALUE 'N'.        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME              PIC X(10)   VALUE 'PCSCA451'.    
          05  WS-USER-ABEND-CODE       PIC S9(4)   COMP VALUE +100.     
          05  WS-N                     PIC X(01)   VALUE 'N'.           
          05  WS-Y                     PIC X(01)   VALUE 'Y'.           
       01 WS-ACCT-SCORE.                                                
COB305    05 WS-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.              
          05  WS-COMPANY-NO            PIC X(02).                       
          05  WS-REGULATED-FLAG        PIC X(01).                       
          05  WS-DATE-BILLED           PIC X(10).                       
          05  WS-CODE-REV-CLASS        PIC X(3).                        
          05  WS-CUSTOMER-NO           PIC 9(10).                       
      ***********************************************************               
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                         
      ***********************************************************               
       01 WS-DATE-VARIABLES.                                            
          05  WS-TEMP-DATE.                                             
              10  WS-TEMP-YY          PIC 9(04).                        
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-TEMP-MM          PIC 9(02).                        
              10  FILLER              PIC X(01) VALUE '-'.              
              10  WS-TEMP-DD          PIC 9(02).                        
          05  WS-RUN-DATE.                                              
              10 WS-DT-YY             PIC 9(02).                        
              10 WS-DT-MM             PIC 9(02).                        
              10 WS-DT-DD             PIC 9(02).                        
          05  WS-BATCH-DATE.                                            
              10 WS-BATCH-MM          PIC 9(02).                        
              10 FILLER               PIC X(01) VALUE '-'.              
              10 WS-BATCH-DD          PIC 9(02).                        
              10 FILLER               PIC X(01) VALUE '-'.              
              10 WS-BATCH-YY          PIC 9(04).                        
      *************************************************************             
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                         
      *************************************************************             
       01  WS-TIME-VARIABLES.                                           
           05 WS-RUN-TIME.                                              
              10 WS-HH                PIC 9(02).                        
              10 WS-MM                PIC 9(02).                        
              10 WS-TT                PIC 9(02).                        
       01 WS-DATE-VARIABLES-1.                                          
           05 WS-AC01-DATE.                                             
              10  WS-AC01-CC           PIC 9(02) VALUE ZEROES.          
              10  WS-AC01-YY           PIC 9(02) VALUE ZEROES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-AC01-MM           PIC 9(02) VALUE ZEROES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-AC01-DD           PIC 9(02) VALUE ZEROES.          
          05  WS-DRAFT-DATE.                                            
              10  WS-DRAFT-CC          PIC 9(02) VALUE ZEROES.          
              10  WS-DRAFT-YY          PIC 9(02) VALUE ZEROES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-DRAFT-MM          PIC 9(02) VALUE ZEROES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-DRAFT-DD          PIC 9(02) VALUE ZEROES.          
          05  WS-CHECK-DATE.                                            
              10  WS-CHECK-CC          PIC X(02) VALUE '20'.            
              10  WS-CHECK-YY          PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-CHECK-MM          PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '-'.             
              10  WS-CHECK-DD          PIC X(02) VALUE SPACES.          
       01 WS-WORK-VARIABLES.                                            
          05  WS-ERR-MSG               PIC X(100) VALUE SPACES.         
          05  WS-ERR-MSG2              PIC X(100) VALUE SPACES.         
          05  WS-RESIDENT-COUNT        PIC S9(4) COMP VALUE 0.          
       01 WS-DISPLAY.                                                   
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  FILLER                   PIC X(01) VALUE SPACES.          
       01 WS-HARDCODED-VARIABLES.                                       
          05  WS-COMPANY         PIC X(02) VALUE '01'.                  
          05  WS-DATABASE        PIC X(08) VALUE                        
                                 'DATABASE'.                            
          05  WS-COMMENT-LEN     PIC S9(04) COMP                        
                                 VALUE +34.                             
          05  WS-COMMENT-TEXT    PIC X(34) VALUE                        
                                 'BATCH OVERAGE POSTED BY THE SYSTEM'.  
          05  WS-SCORE-VALUES    PIC X(01) VALUE 'Y'.                   
          05  WS-DEF-RATING      PIC X(01) VALUE ' '.                   
          05  WS-DEF-SCORED-FL   PIC X(01) VALUE 'N'.                   
          05  WS-DEF-DIALER-FL   PIC X(01) VALUE 'N'.                   
      *                                                                         
       01 WS-END                 PIC X(40)                              
           VALUE 'WORKING STORAGE FOR PCSCA451 ENDS HERE'.              
      ****************************************************************          
      **   COPYBOOKS USED IN THE PROGRAM                                        
      ****************************************************************          
      ********* DB2 COMMUNICATION REQUIREMENT ************************          
                                                                        
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
       01 ERROR-MESSAGE.                                                
          02  ERROR-LEN         PIC S9(4)  COMP VALUE +1320.            
          02  ERROR-TEXT        PIC X(132) OCCURS 10 TIMES              
                                INDEXED BY ERROR-INDEX.                 
       77 ERROR-TEXT-LEN        PIC S9(9)  COMP VALUE +132.             
       77 TRACE-MESSAGE-AREA    PIC X(256).                             
       77 OPENFN                PIC X(12).                              
       77 SSID                  PIC X(4).                               
       77 PLANNAME              PIC X(8).                               
       77 RETCODE               PIC S9(5).                              
       77 REASCODE              PIC S9(5).                              
       77 CLOSFN                PIC X(12).                              
       77 TERMOP                PIC X(4).                               
                                                                        
       01 I-ACCOUNT-NO          PIC X(14).                              
       01 I-BEACON-SCORE        PIC X(06).                              
       01 I-UPDATE-FLAG         PIC X(01).                              
                                                                        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
ACT259******************************************************************07910200
ACT259*   WORKING STORAGE AREA FOR RESTART-REQUEST PARM                *07910300
ACT259******************************************************************07910400
      *                                                                 07910500
ACT259     COPY CWS00038.                                               07910600
ACT259*                                                                 07910700
ACT259******************************************************************07870000
ACT259*  WORKING STORAGE AREA FOR COMMON DATES                         *07880000
ACT259******************************************************************07890000
      *                                                                 07900000
ACT259     COPY CWS00039.                                               07910000
      *                                                                 07910100
      ******************************************************************07890000
                                                                        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *                                                                         
ACT259******************************************************************06330000
ACT259* FCA00-KEY                                                      *06340000
ACT259******************************************************************06350000
      *                                                                 06360000
ACT259     COPY FIOCA00.                                                06370000
      *                                                                 06391000
      ******************************************************************06330000
      *    SQL COMMUNICATIONS AREA                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT                                                          
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      **   CSS_BILLING_HDR                                                      
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBLOCOFC                                                    
           END-EXEC.                                                            
      **************************************************************            
      **   CSS_BILLING_HDR                                                      
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBLLHDR                                                    
           END-EXEC.                                                            
      **************************************************************            
      **   CSS_BILLING_DET                                                      
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBLLDET                                                    
           END-EXEC.                                                            
      **************************************************************            
      **   CSS_BHV_DIMENSION                                                    
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHDIMS                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CATEGORY                                                     
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHVCAT                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CRITERIA                                                     
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCRITRA                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_ACCT_SCORE                                                   
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBACSCRE                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_MODEL                                                        
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHMODL                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCORE                                                        
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHVSCR                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCOR_MODL                                                    
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBBHSCRE                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_SCOR_RATING                                                  
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBSCRRAT                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CATEG_MODL                                                   
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBCATMDL                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    CSS_BHV_CATEG_MODL                                                   
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBJBPARM                                                    
           END-EXEC.                                                            
      **************************************************************            
      *    'WORKING STORAGE FOR PCSCA451 ENDS HERE '.                           
      **************************************************************            
       PROCEDURE DIVISION.                                              
      **************************************************************            
      **                         M A I N L I N E                                
      **************************************************************            
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
ACT259     PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           DISPLAY 'LOAD-ACCOUNTS'.                                     
ACT259     PERFORM 0500-READ-HEADER-RECORDS THRU 0500-EXIT              
ACT259             UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES.         
ACT259     PERFORM 1000-LOAD-FCSDB07        THRU 1000-EXIT              
ACT259             UNTIL WS-FCSDB07-EOF.                                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       0000-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **  0100-INITIALIZATION                                                   
      **  COMMON INITIALIZATION ROUTINE                                         
      ***************************************************************           
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
ACT259     INITIALIZE WS-SYSIPT.                                        
ACT259     PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
ACT259     IF COMMON-DATE-NEEDED                                        
ACT259        PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
ACT259        MOVE WS-FCA00-COMMON-DATE          TO WS-INPUT-DATE       
ACT259     END-IF.                                                      
ACT259     MOVE WS-INPUT-DATE                    TO WS-COMMON-DATE.     
ACT259     DISPLAY 'PCSCA451 RUNNING DATE - '    WS-COMMON-DATE.        
                                                                        
ACT259     PERFORM 0200-OPEN-FILE1               THRU 0200-EXIT.        
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
      ********************************************************                  
      **  0200-OPEN-FILE1                                                       
      ********************************************************                  
       0200-OPEN-FILE1.                                                 
      *---------------*                                                         
           MOVE '0200'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
ACT259     OPEN INPUT FCSDB07-FILE.                                     
                                                                        
ACT259     IF FDB07-SUCCESSFUL                                          
ACT259        CONTINUE                                                  
ACT259     ELSE                                                         
ACT259        DISPLAY '***********ABENDING**************'               
ACT259        DISPLAY '** 0100-INITIALIZE               '               
ACT259        DISPLAY '** ERROR ON OPENING FCSDB07 FILE.'               
ACT259        DISPLAY '** STATUS IS ' WS-FDB07-STATUS                   
ACT259        DISPLAY '************ PCSCA414 ***********'               
ACT259        PERFORM 9900-ABEND                 THRU 9900-EXIT         
ACT259     END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
ACT259**************************************************************            
ACT259** 0500-READ-HEADER-RECORDS.                                              
ACT259**************************************************************            
                                                                        
ACT259 0500-READ-HEADER-RECORDS.                                        
                                                                        
ACT259     PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT.             
                                                                        
      *                                                                 09478886
ACT259     EVALUATE TRUE                                                
ACT259         WHEN WS-FCSDB07-EOF                                      
ACT259              DISPLAY '************ABENDING************'          
ACT259              DISPLAY '**    PCSCA451 PROCESSING ERROR '          
ACT259              DISPLAY '**      FCSDB07 FILE IS EMPTY   '          
ACT259              DISPLAY '**      PROCESSING TERMINATED   '          
ACT259              DISPLAY '************PCSCA451************'          
ACT259              PERFORM 9900-ABEND      THRU 9900-EXIT              
ACT259         WHEN E-FDB07-KEY-BREC = LOW-VALUES                       
ACT259              IF E-FDB07-CREATE-DATE-BREC NOT = WS-COMMON-DATE    
ACT259                 DISPLAY '*********ABENDING*****************'     
ACT259                 DISPLAY '**     PCSCA451 PROCESSING ERROR  '     
ACT259                 DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE ' 
ACT259                 DISPLAY '**       PROCESSING TERMINATED    '     
ACT259                 DISPLAY '*********PCSCA451*****************'     
ACT259                 PERFORM 9900-ABEND   THRU 9900-EXIT              
ACT259              END-IF                                              
ACT259              SET WS-BEGIN-RECS-PROCESSED TO TRUE                 
ACT259         WHEN WS-BEGIN-RECS-PROCESSED                             
ACT259              IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES     
ACT259                 IF E-FDB07-KEY-BREC = HIGH-VALUES AND            
ACT259                    NO-DATA-RECORD-FOUND AND                      
ACT259                    E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
ACT259                    DISPLAY '************ABENDING************'    
ACT259                    DISPLAY '**    PCSCA451 PROCESSING ERROR '    
ACT259                    DISPLAY '**      FCSDB07 FILE IS EMPTY   '    
ACT259                    DISPLAY '**      PROCESSING TERMINATED   '    
ACT259                    DISPLAY '************PCSCA451************'    
ACT259                    PERFORM 9900-ABEND THRU 9900-EXIT             
ACT259                 ELSE                                             
ACT259                    CONTINUE                                      
ACT259                 END-IF                                           
ACT259              ELSE                                                
ACT259                 SET DATA-RECORD-FOUND TO TRUE                    
ACT259              END-IF                                              
ACT259         WHEN OTHER                                               
ACT259              DISPLAY '************ABENDING**************'        
ACT259              DISPLAY '**    PCSCA451 PROCESSING ERROR   '        
ACT259              DISPLAY '** FIRST RECORD IS NOT A CNTL REC '        
ACT259              DISPLAY '**      PROCESSING TERMINATED     '        
ACT259              DISPLAY '************PCSCA451**************'        
ACT259              PERFORM 9900-ABEND      THRU 9900-EXIT              
ACT259     END-EVALUATE.                                                
                                                                        
ACT259 0500-EXIT.                                                       
ACT259      EXIT.                                                       
                                                                        
                                                                        
ACT259**************************************************************            
ACT259**    1000-LOAD-FCSDB07                                                   
      **************************************************************            
ACT259 1000-LOAD-FCSDB07.                                               
                                                                        
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
ACT259     IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES              
ACT259        CONTINUE                                                  
ACT259     ELSE                                                         
ACT259        PERFORM 2500-OUTPUT-PROCESS THRU 2500-EXIT                
ACT259     END-IF.                                                      
                                                                        
ACT259     PERFORM 7001-READ-FCSDB07      THRU 7001-EXIT.               
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
ACT259**************************************************************            
ACT259**    2500-OUTPUT-PROCESS.                                                
ACT259**************************************************************            
ACT259 2500-OUTPUT-PROCESS.                                             
                                                                        
ACT259     MOVE E-FDB07-ACCT-NO        TO AT-ACCOUNT-NO                 
ACT259     MOVE WS-COMMON-DATE         TO BI-DATE-BILLED                
                                          KF-DATE-BILLED                
ACT259     MOVE AT-ACCOUNT-NO          TO BG-ACCOUNT-NO                 
ACT259     MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO                 
                                                                        
           PERFORM 7200-CHECK-ACCT-CLASS                                
              THRU 7200-EXIT.                                           
ACT259     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              DISPLAY 'RESIDENT ACCOUNT'                                
              PERFORM 7325-SELECT-ACCT-INFO                             
                 THRU 7325-EXIT                                         
              MOVE AT-ACCOUNT-NO          TO KF-ACCOUNT-NO              
              MOVE '00000'                TO KF-BEACON-SCORE            
              MOVE SPACES                 TO KF-BHV-ERROR-REASN-CD      
              MOVE AT-BHV-EXEMPT-CD       TO KF-BHV-EXEMPT-CD           
              MOVE 0                      TO KF-BHV-SCOR-VALU-CELL      
              MOVE SPACES                 TO KF-BHV-SCORE-RATING        
              MOVE 0                      TO KF-BHV-SCORE-VALU-WGT      
              MOVE BI-BILL-NO             TO KF-BILL-NO                 
              MOVE AT-COMPANY-NO          TO KF-COMPANY-NO              
              MOVE 'SYSTEM'               TO KF-LAST-UPDATE-USERID      
              IF B1-REGULATED-CD > ' '                                  
                 MOVE 'Y'                 TO KF-REGULATED-FL            
              ELSE                                                      
                 MOVE 'N'                 TO KF-REGULATED-FL            
              END-IF                                                    
ACT259        MOVE AT-REV-MTH-LST-NRML    TO KF-REVENUE-MONTH           
              MOVE 'N'                    TO KF-SCORED-FL               
                                                                        
              PERFORM 7700-INSERT-ACCT-SCORE                            
                 THRU 7700-EXIT                                         
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT259******************************************************************19423409
ACT259* 7001-READ-FCSDB07                                              *19423509
ACT259******************************************************************19423609
      *                                                                 19423709
ACT259 7001-READ-FCSDB07.                                               
      *                                                                 19423909
ACT259     READ FCSDB07-FILE                                            
ACT259         AT END                                                   
ACT259             MOVE WS-Y                TO WS-FCSDB07-EOF-SW        
ACT259             GO TO 7001-EXIT                                      
ACT259     END-READ.                                                    
      *                                                                 19424509
ACT259     IF  FDB07-SUCCESSFUL                                         
ACT259         CONTINUE                                                 
ACT259     ELSE                                                         
ACT259        DISPLAY '*************** ABENDING ***************'        
ACT259        DISPLAY '* 7001-ERROR ON FCSDB07 READ.          *'        
ACT259        DISPLAY '* STATUS  - ' WS-FDB07-STATUS                    
ACT259        DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO             
ACT259        DISPLAY '*************** PCSCA451 ****************'       
ACT259        PERFORM 9900-ABEND           THRU 9900-EXIT               
ACT259     END-IF.                                                      
      *                                                                 19425909
ACT259 7001-EXIT.                                                       
ACT259     EXIT.                                                        
      *                                                                 19426209
      *************************************************************             
      **  7200-CHECK-ACCT-CLASS                                                 
      *************************************************************             
       7200-CHECK-ACCT-CLASS.                                           
      *------------------------*                                                
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
ACT259       SELECT BI.ACCOUNT_NO                                       
ACT259             ,BI.BILL_NO                                          
ACT259         INTO :BI-ACCOUNT-NO                                      
ACT259             ,:BI-BILL-NO                                         
ACT259         FROM CSS_BILLING_HDR BI                                  
ACT259        WHERE BI.DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                    
ACT259          AND BI.ACCOUNT_NO IN                                    
ACT259              (SELECT DISTINCT BG.ACCOUNT_NO                      
ACT259                 FROM CSS_BILLING_DET BG                          
ACT259                WHERE BG.ACCOUNT_NO = :BG-ACCOUNT-NO              
ACT259                  AND CIS.SUBSTR3(CODE_REVENUE_CLASS,2,1) = '1')       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT BI.ACCOUNT_NO                                               
MFA-TR*            ,BI.BILL_NO                                                  
MFA-TR*        INTO :BI-ACCOUNT-NO                                              
MFA-TR*            ,:BI-BILL-NO                                                 
MFA-TR*        FROM CSS_BILLING_HDR BI                                          
MFA-TR*       WHERE BI.DATE_BILLED = :BI-DATE-BILLED                            
MFA-TR*         AND BI.ACCOUNT_NO IN                                            
MFA-TR*             (SELECT DISTINCT BG.ACCOUNT_NO                              
MFA-TR*                FROM CSS_BILLING_DET BG                                  
MFA-TR*               WHERE BG.ACCOUNT_NO = :BG-ACCOUNT-NO                      
MFA-TR*                 AND SUBSTR(CODE_REVENUE_CLASS,2,1) = '1')               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND THEN 
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'FETCHING A/C REVENUE CLASS FROM CIS **'          
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'ACCOUNT NO '   DELIMITED BY SIZE                 
                    WS-ACCOUNT-NO     DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *************************************************************             
      **  7325-SELECT-ACCT-INFO                                                 
      *************************************************************             
       7325-SELECT-ACCT-INFO.                                           
      *------------------------*                                                
           MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT AT.CUSTOMER_NO,                                     
                    AT.COMPANY_NO,                                      
                    B1.REGULATED_CD,                                    
ACT259              AT.BHV_EXEMPT_CD,                                   
ACT259              AT.REV_MTH_LST_NRML                                 
               INTO :AT-CUSTOMER-NO,                                    
                    :AT-COMPANY-NO,                                     
                    :B1-REGULATED-CD,                                   
ACT259              :AT-BHV-EXEMPT-CD,                                  
ACT259              :AT-REV-MTH-LST-NRML                                
               FROM CSS_ACCOUNT AT, CSS_LOCAL_OFFICE B1                 
              WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                    
                AND AT.LOCAL_OFFICE = B1.LOCAL_OFFICE                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               STRING 'GETTING A/C INFO FROM CIS **'                    
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
                                                                        
               STRING 'ACCOUNT NO   ' DELIMITED BY SIZE                 
                   WS-ACCOUNT-NO      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
       7325-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      **  7700-INSERT-ACCT-SCORE.                                             * 
      **  INSERT INTO CSS_BHV_ACCT_SCORE                       *                
      **************************************************************            
       7700-INSERT-ACCT-SCORE.                                          
      *---------------------*                                                   
           EXEC SQL                                                     
             INSERT INTO CSS_BHV_ACCT_SCORE                             
                ( ACCOUNT_NO                                            
                 ,BEACON_SCORE                                          
                 ,BHV_ERROR_REASN_CD                                    
                 ,BHV_EXEMPT_CD                                         
                 ,BHV_SCOR_VALU_CELL                                    
                 ,BHV_SCORE_RATING                                      
                 ,BHV_SCORE_VALU_WGT                                    
                 ,BILL_NO                                               
                 ,COMPANY_NO                                            
                 ,DATE_BILLED                                           
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                 ,REGULATED_FL                                          
                 ,REVENUE_MONTH                                         
                 ,SCORED_FL                                             
                )                                                       
                VALUES                                                  
                (  :KF-ACCOUNT-NO                                       
                  ,:KF-BEACON-SCORE                                     
                  ,:KF-BHV-ERROR-REASN-CD                               
                  ,:KF-BHV-EXEMPT-CD                                    
                  ,:KF-BHV-SCOR-VALU-CELL                               
                  ,:KF-BHV-SCORE-RATING                                 
                  ,:KF-BHV-SCORE-VALU-WGT                               
                  ,:KF-BILL-NO                                          
                  ,:KF-COMPANY-NO                                       
                  ,IIF(TRY_CONVERT(DATE, :KF-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :KF-DATE-BILLED
              ) <> 0) OR (LEN(:KF-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :KF-DATE-BILLED
              ), CONVERT(DATE, :KF-DATE-BILLED) )                              
                  , CIS.CURRENT$TIMESTAMP()                                   
                  ,:KF-LAST-UPDATE-USERID                               
                  ,:KF-REGULATED-FL                                     
                  ,:KF-REVENUE-MONTH                                    
                  ,:KF-SCORED-FL                                        
                )                                                       
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_BHV_ACCT_SCORE                                     
MFA-TR*         ( ACCOUNT_NO                                                    
MFA-TR*          ,BEACON_SCORE                                                  
MFA-TR*          ,BHV_ERROR_REASN_CD                                            
MFA-TR*          ,BHV_EXEMPT_CD                                                 
MFA-TR*          ,BHV_SCOR_VALU_CELL                                            
MFA-TR*          ,BHV_SCORE_RATING                                              
MFA-TR*          ,BHV_SCORE_VALU_WGT                                            
MFA-TR*          ,BILL_NO                                                       
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,DATE_BILLED                                                   
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,REGULATED_FL                                                  
MFA-TR*          ,REVENUE_MONTH                                                 
MFA-TR*          ,SCORED_FL                                                     
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (  :KF-ACCOUNT-NO                                               
MFA-TR*           ,:KF-BEACON-SCORE                                             
MFA-TR*           ,:KF-BHV-ERROR-REASN-CD                                       
MFA-TR*           ,:KF-BHV-EXEMPT-CD                                            
MFA-TR*           ,:KF-BHV-SCOR-VALU-CELL                                       
MFA-TR*           ,:KF-BHV-SCORE-RATING                                         
MFA-TR*           ,:KF-BHV-SCORE-VALU-WGT                                       
MFA-TR*           ,:KF-BILL-NO                                                  
MFA-TR*           ,:KF-COMPANY-NO                                               
MFA-TR*           ,:KF-DATE-BILLED                                              
MFA-TR*           , CURRENT TIMESTAMP                                           
MFA-TR*           ,:KF-LAST-UPDATE-USERID                                       
MFA-TR*           ,:KF-REGULATED-FL                                             
MFA-TR*           ,:KF-REVENUE-MONTH                                            
MFA-TR*           ,:KF-SCORED-FL                                                
MFA-TR*         )                                                               
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE                
                                                                        
ACT259     MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
ACT259                                NOT-FOUND  OR -803                
               CONTINUE                                                 
           ELSE                                                         
               MOVE KF-ACCOUNT-NO     TO WS-ACCOUNT-NO                  
                                                                        
               STRING 'UNABLE TO INSERT RECORD INTO **'                 
                                      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG                   
               STRING 'ACCOUNT NO   ' DELIMITED BY SIZE                 
                   WS-ACCOUNT-NO      DELIMITED BY SIZE                 
                                      INTO WS-ERR-MSG2                  
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      **  8800-DIS-TABLE-ERROR                                                  
      **************************************************************            
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**'WS-ERR-MSG2.                                     
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      **************************************************************            
      **  8900-DISPLAY-ERR-TERM                                                 
      **************************************************************            
       8900-DISPLAY-ERR-TERM.                                           
      *---------------------*                                                   
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSCA360 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ERR-MSG.                                     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      **  9000-TERMINATE                                                        
      *        NORMAL TERMINATION OF THE PROGRAM                                
      **************************************************************            
       9000-TERMINATE.                                                  
      *--------------*                                                          
ACT259     CLOSE FCSDB07-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT259******************************************************************        
ACT259**  6240-GET-FCA00-COMMON-DATE.                                  *        
ACT259******************************************************************        
      *                                                                         
ACT259     COPY CPD00040.                                                       
      *                                                                         
ACT259******************************************************************        
ACT259*  6251-GET-FJC01-DATE.                                          *        
ACT259******************************************************************        
      *                                                                         
ACT259     EXEC SQL                                                             
ACT259         INCLUDE CPD00037                                                 
ACT259     END-EXEC.                                                            
      *                                                                         
ACT259******************************************************************        
ACT259*  7600-START-FCSJC01.                                           *        
ACT259******************************************************************        
      *                                                                         
ACT259     EXEC SQL                                                             
ACT259         INCLUDE CPD00038                                                 
ACT259     END-EXEC.                                                            
ACT259******************************************************************        
ACT259*  7620-START-FCSCA00.                                           *        
ACT259******************************************************************        
      *                                                                         
ACT259     EXEC SQL                                                             
ACT259         INCLUDE CPD00039                                                 
ACT259     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
