       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA440.                                           
       DATE-WRITTEN.  FEBRUARY 2004.                                    
       DATE-COMPILED.                                                   
       AUTHOR.         SCANA SERVICES.                                  
      ***************************************************************** 00060000
      **                                                                00070000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00080000
      **                                                             ** 00090000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100000
      ********                   DB2                          ********* 00110000
      ***************************************************************** 00120000
      **                                                             ** 00130000
      **              PROGRAM  MODIFICATION  LOG                     ** 00140000
      **                                                             ** 00150000
      ** DATE       INITIALS       REASON                            ** 00160000
      **                                                             ** 00170000
      ** 02/12/04   WR19680        NEW LOSS RESERVE EXTRACT PROGRAM  ** 00180001
      ***************************************************************** 00190000
      *                   PCSCA440  NARRATIVE                         * 00200001
      *                                                               * 00210000
      *   THIS PROGRAM WILL EXTRACT DATA FROM THE DATA BASE TO BE USED* 00220001
      *   TO BUILD THE OUTPUT FILE FCSRP440 WHICH IS TO BE USED AS    * 00230001
      *   INPUT FOR PCSRP440 REPORT PROGRAM                           **00240001
      * REMARKS                                                       *         
T33928* SP94986     10-AUG-06    TO AVOID -911S,ADD FOR FETCH ONLY    *         
      *                          WITH  UR TO THE CURSORS.             *         
      *                                                               *         
T34268*  08/16/06 DAS    MODIFY THE EXISTING COMM LOSS RESERVE REPORT *         
T34268*                  SO THAT MASTER ACCOUNTS ALSO SHOWUP.NEED TO  *         
T34268*                  INSURE THE EXTRACT FILE CREATED BY THIS PGRAM*         
T34268*                  PICKUPS THE MASTER ACCOUNTS TOO *                      
A04110*  05/07/12 NS75440 MADE CHANGES TO ADD RISK RATING DATE TO     *         
A04110*                   PCSRP440(REPORT)                            *         
      ***************************************************************** 00260001
      *                                                                 00270000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                            00340000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00370000
       FILE-CONTROL.                                                    
           COPY CSSRP440.                                               00390000
      *                                                                 00410000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDRP440.                                               00440000
           COPY FIORP440.                                               00450000
      *                                                                 00480000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA440'.
MSQ017     COPY MFASQLM.
      *                                                                 00500000
       01  WS-SWITCHES.                                                 
           05  WS-FRP440-STATUS                  PIC X(02).             
               88  FRP440-SUCCESSFUL                       VALUE '00'.  
           05  WS-RECORD-FOUND                 PIC X(01) VALUE 'N'.     
               88  DATA-RECORD-FOUND                     VALUE 'Y'.     
               88  NO-DATA-RECORD-FOUND                  VALUE 'N'.     
           05  WS-BEGIN-REC-SW                 PIC X(01) VALUE 'N'.     
               88  WS-BEGIN-RECS-PROCESSED               VALUE 'Y'.     
           05  WS-DATABASE                     PIC 9(01) VALUE ZERO.    
               88  CSR-DATABASE                          VALUE 1.       
               88  SEB-DATABASE                          VALUE 2.       
           05  WS-INITIAL-READ                 PIC X(01) VALUE 'Y'.     
      *                                                                 00690000
      *                                                                 00870000
       01  WS-VARIABLES.                                                
           05  PROGRAM-NAME                    PIC X(08) VALUE          
                                                         'PCSCA440'.    
           05  WS-PGRMNAME                     PIC X(08) VALUE          
                                                         'PCSCA440'.    
           05  RS-RETURN-CODE                  PIC S9(9) VALUE          
               +000 COMP.                                               
           05  RS-RETURN-CODE-DISP             PIC S9(9) VALUE          
               +000 COMP.                                               
                                                                        
           05  REFORMAT-DATE.                                           
               10  WS-FORMAT-YEAR      PIC X(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-MONTH     PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-DAY       PIC X(02).                       
           05  REFORMAT-DATE-R REDEFINES REFORMAT-DATE.                 
               10  WS-FORMAT-YEAR-R    PIC 9(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-MONTH-R   PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-DAY-R     PIC 9(02).                       
           05  USA-DATE-FORMAT.                                         
               10  USA-MONTH           PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-DAY             PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-YEAR            PIC X(04).                       
                                                                        
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-REVENUE-DATE         PIC 9(06).                       
COB305     05 WS-REV-BEG-DATE        PIC S9(6)V USAGE COMP-3 VALUE 0.         
COB305     05 WS-REV-END-DATE        PIC S9(6)V USAGE COMP-3 VALUE 0.         
           05  WS-REV-BEG-DATE-R2      PIC 9(06).                       
           05  WS-REV-END-DATE-R2      PIC 9(06).                       
           05  WS-REV-BEG-DATE-R.                                       
               10  WS-REV-BEG-YYYY     PIC 9(04).                       
               10  WS-REV-BEG-MM       PIC 9(02).                       
           05  WS-REV-END-DATE-R.                                       
               10  WS-REV-END-YYYY     PIC 9(04).                       
               10  WS-REV-END-MM       PIC 9(02).                       
           05  WS-REVENUE-MMYYYY.                                       
               10  WS-REVENUE-MONTH    PIC X(02).                       
               10  WS-REVENUE-YEAR     PIC X(04).                       
           05  WS-REV-MM               PIC X(02).                       
           05  WS-REV-MM-R REDEFINES WS-REV-MM                          
                                       PIC 9(02).                       
           05  WS-REV-YEAR.                                             
                 10  WS-REV-CC         PIC X(02).                       
                 10  WS-REV-YY         PIC X(02).                       
           05  WS-REV-YEAR-R REDEFINES WS-REV-YEAR.                     
                 10  WS-REV-CC-R       PIC 9(02).                       
                 10  WS-REV-YY-R       PIC 9(02).                       
           05 WS-REV-YEAR-R1 REDEFINES WS-REV-YEAR-R PIC 9(04).         
           05  WS-PREV-ACCOUNT-NO      PIC 9(13).                       
           05  WS-PREV-BILL-NO         PIC S9(9) USAGE COMP.            
           05  WS-COMMON-DATE          PIC X(10) VALUE SPACES.          
           05  WS-RATE-COUNTER         PIC 9(02) VALUE ZEROS.           
           05  WS-PROCESSING-DONE      PIC X(01) VALUE SPACES.          
T34268     05  WS-PROCESS-MSTDONE      PIC X(01) VALUE SPACES.          
           05  WS-FRP440-REC-CTR               PIC 9(07) VALUE ZEROS.   
           05  WS-REVENUE-MTH-NULL-1           PIC S9(04) COMP VALUE +0.
           05  WS-TRAN-APPL-NO                 PIC S9(4) COMP.          
           05  WS-CURRENT-DATE                 PIC X(10) VALUE SPACES.  
           05  WS-SUB                          PIC S9(04) COMP VALUE +0.
                                                                        
           05  WS-TOTAL-AR-COMP3          PIC S9(10) COMP-3 VALUE ZEROS.
           05  WS-DEPOSIT-AMT-COMP3       PIC S9(08) COMP-3 VALUE ZEROS.
           05  WS-RESERVE-AMT-COMP3       PIC S9(08) COMP-3 VALUE ZEROS.
           05  WS-TWELVE-MONTH-REV        PIC S9(14)V99 COMP-3 VALUE +0.
           05  WS-LAST-BILL-AMT-COMP3     PIC S9(09) COMP-3 VALUE ZEROS.
           05  WS-LOSS-RES-BAL-COMP3      PIC S9(05)V99 COMP-3 VALUE +0.
           05  WS-TOTAL-AR-COMP           PIC S9(10) COMP VALUE ZEROS.  
           05  WS-DEPOSIT-AMT-COMP        PIC S9(08) COMP VALUE ZEROS.  
           05  WS-RESERVE-AMT-COMP        PIC S9(08) COMP VALUE ZEROS.  
           05  WS-TWELVE-MTH-COMP         PIC S9(14) COMP VALUE ZEROS.  
           05  WS-LAST-BILL-AMT-COMP      PIC S9(09) COMP VALUE ZEROS.  
           05  WS-LOSS-RES-BAL-COMP       PIC S9(05)V99 COMP VALUE +0.  
           05  WS-ERROR-MSG-1             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-2             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-3             PIC X(30) VALUE SPACES.       
      **                                                             ** 01720000
                                                                        
                                                                        
      *                                                                 01900000
      *                                                                 01910000
       01  WS-NULL-INDICATOR           PIC S9(04) COMP VALUE +0.        
                                                                        
       01  WS-TEMP-25-APPL-NO               PIC S9(3) COMP-3 VALUE +0.  
       01  WS-TEMP-TIMESTAMP                PIC X(26) VALUE  SPACES.    
       01  WS-DEP-TIMESTAMP                 PIC X(26) VALUE  SPACES.    
       01  CMN-TODAYS-DATE                   PIC X(10).                 
       01  WS-PROG-CLOSE-CONTRACT            PIC  X(08) VALUE           
                                               'PCSCA440'.              
       01  WS-STATUS-CODE                    PIC  X(11) VALUE           
                                              'STATUS CODE'.            
       01  WS-PROGRAM-TIMESTAMP    PIC X(26) VALUE SPACES.              
      *                                                                 03450000
      ***************************************************************** 03810000
      **      APPLICATION  TABLE DCLGENS                             ** 03820000
      ***************************************************************** 03830000
           EXEC SQL                                                     03840000
               INCLUDE SQLCA                                            03850000
           END-EXEC.                                                    03860000
      **                                                                03870000
      ***************************************************************** 03950000
      *    CSS_LOSS_RESERVE.                                            03890000
      ***************************************************************** 03900000
           EXEC SQL                                                     03910000
             INCLUDE TBLOSRES                                           03920000
           END-EXEC.                                                    03930000
      *                                                                 03940000
      ***************************************************************** 04020000
      *    CSS_DEP_ON_HAND                                              04030000
      ***************************************************************** 04040000
           EXEC SQL                                                     04050000
             INCLUDE TBDEPHND                                           04060000
           END-EXEC.                                                    04070000
      *                                                                 04080000
      *                                                                 04090000
      *                                                                 04120000
      ***************************************************************** 04930000
      *    CSS_CONTACT                                                  04940000
      ***************************************************************** 04950000
           EXEC SQL                                                     04960000
              INCLUDE TBCNTACT                                          04970000
           END-EXEC.                                                    04980000
                                                                        
      ***************************************************************** 05000000
      *    CSS_JOB-PARM.                                                05010000
      ***************************************************************** 05020000
           EXEC SQL                                                     05030000
             INCLUDE TBJBPARM                                           05040000
           END-EXEC.                                                    05050000
      *                                                                 05060000
      ***************************************************************** 05070000
      *    CSS_ACCOUNT                                                  05080000
      ***************************************************************** 05090000
           EXEC SQL                                                     05100000
             INCLUDE TBACCT                                             05110000
           END-EXEC.                                                    05120000
      *                                                                 05130000
      ***************************************************************** 05280000
      * CSS_CONTACT_CUST                                                05290000
      ***************************************************************** 05300000
           EXEC SQL                                                     05310000
              INCLUDE TBCNTCCS                                          05320000
           END-EXEC.                                                    05330000
      *                                                                 05340000
      ***************************************************************** 05420000
      * CSS_CREDIT_PROFILE                                              05430000
      ***************************************************************** 05440000
           EXEC SQL                                                     05450000
              INCLUDE TBCRPROF                                          05460000
           END-EXEC.                                                    05470000
      *                                                                 05480000
      ***************************************************************** 05490000
      * CSS_AR_TRANS_HIST                                               05500000
      ***************************************************************** 05510000
           EXEC SQL                                                     05520000
              INCLUDE TBARHIST                                          05530000
           END-EXEC.                                                    05540000
      *                                                                 05550000
      ***************************************************************** 05630000
      * CSS_CUSTOMER                                                    05640000
      ***************************************************************** 05650000
           EXEC SQL                                                     05660000
              INCLUDE TBCUST                                            05670000
           END-EXEC.                                                    05680000
      *                                                                 05690000
      ******************************************************************06601111
      *    CSS_UTIL_ENVRNMT                                             06601245
      ******************************************************************06601311
           EXEC SQL                                                     06602011
              INCLUDE TBUTLENV                                          06603045
           END-EXEC.                                                    06604011
      ******************************************************************06604145
      *    CSS_SURETY_BOND                                              06604245
      ******************************************************************06604345
           EXEC SQL                                                     06604445
              INCLUDE TBSTYBND                                          06604545
           END-EXEC.                                                    06604645
      ******************************************************************06609212
      ******************************************************************06604145
      *    CSS_CUST_MISC_INFO                                           06604245
      ******************************************************************06604345
           EXEC SQL                                                     06604445
              INCLUDE TBCSTMSC                                          06604545
           END-EXEC.                                                    06604645
      ******************************************************************06604145
      *    CSS_BILLING_DETAIL                                           06604245
      ******************************************************************06604345
           EXEC SQL                                                     06604445
              INCLUDE TBBLLDET                                          06604545
           END-EXEC.                                                    06604645
      ******************************************************************06604145
      *    CSS_BILLING_HEADER                                           06604245
      ******************************************************************06604345
           EXEC SQL                                                     06604445
              INCLUDE TBBLLHDR                                          06604545
           END-EXEC.                                                    06604645
      ******************************************************************06609212
      *    CSS_NAME                                                     06609312
      ******************************************************************06609412
           EXEC SQL                                                     06609512
              INCLUDE TBNAME                                            06609612
           END-EXEC.                                                    06609712
      ***************************************************************** 06750000
      *                                                                 07150000
       COPY CJF00101.                                                   07160000
       COPY FIOCA01.                                                    07170000
       COPY FIOJC01.                                                    07180000
       COPY FIOCA00.                                                    07190000
      *                                                                 07200000
       COPY CWS00039.                                                   07210000
       COPY CWS00038.                                                   07220000
       COPY CWS00114.                                                   07230000
       COPY CWS0070B.                                                   07240000
       COPY CWS00303.                                                   07250000
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                07260000
                                                                        
      *  ABEND SWITCH COPYBOOK                                          07280000
       COPY CWS09900.                                                   07290000
      *                                                                 07300000
      * -- USED BY CPD0303B                                             07310000
      * WS ABEND WORK AREA                                              07320000
       COPY CWS00010.                                                   07330000
      *                                                                 07340000
      ******************************************************************07350000
      * CURSOR DECLARATIONS                                             07360000
      ******************************************************************07370000
      *                                                                 07380000
      *                                                                 07380000
           EXEC SQL                                                     
               DECLARE CUST_MISC_CURSOR CURSOR FOR                      
                 SELECT LQ.CUSTOMER_NO,                                 
                        LQ.LOSS_RESERVE_CD,                             
A04110                  LQ.LOSS_RESRVE_EFF_DT,                          
                        AT.ACCOUNT_NO,                                  
                        AT.BILL_CYCLE,                                  
                        AT.DATE_BILL_DAY_00,                            
                        AT.TOTAL_AR_BALANCE,                            
                        AT.CODE_MAJOR_ACCT,                             
                        AT.LOCAL_OFFICE,                                
                        AT.COMPANY_NO,                                  
                        AT.CREDIT_GROUP,                                
                        UT.RATE_PLAN_NO,                                
                        UT.CODE_SIC_NO                                  
                 FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),              
                        CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED)             
                 WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                  
                   AND AT.ACCOUNT_NO  = UT.ACCOUNT_NO                   
                   AND AT.CODE_ACCT_STAT = 'A'                          
                   AND LQ.LOSS_RESERVE_CD > 0                           
                 ORDER BY AT.ACCOUNT_NO                                 
T33928         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        DECLARE CUST_MISC_CURSOR CURSOR FOR                      07400004
MFA-TR*          SELECT LQ.CUSTOMER_NO,                                         
MFA-TR*                 LQ.LOSS_RESERVE_CD,                                     
MFA-TR*                 LQ.LOSS_RESRVE_EFF_DT,                                  
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.DATE_BILL_DAY_00,                                    
MFA-TR*                 AT.TOTAL_AR_BALANCE,                                    
MFA-TR*                 AT.CODE_MAJOR_ACCT,                                     
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.CREDIT_GROUP,                                        
MFA-TR*                 UT.RATE_PLAN_NO,                                        
MFA-TR*                 UT.CODE_SIC_NO                                          
MFA-TR*          FROM   CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_UTIL_ENVRNMT UT,                                    
MFA-TR*                 CSS_CUST_MISC_INFO LQ                                   
MFA-TR*          WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                          
MFA-TR*            AND AT.ACCOUNT_NO  = UT.ACCOUNT_NO                           
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND LQ.LOSS_RESERVE_CD > 0                                   
MFA-TR*          ORDER BY AT.ACCOUNT_NO                                         
MFA-TR*        FOR FETCH ONLY WITH UR                                   07470000
MFA-TR*    END-EXEC.                                                    07480000
                                                                        
      *                                                                 07500000
T34268*                                                                 07380000
T34268     EXEC SQL                                                     
T34268         DECLARE CUST_MAST_CURSOR CURSOR FOR                      
T34268           SELECT LQ.CUSTOMER_NO,                                 
T34268                  LQ.LOSS_RESERVE_CD,                             
A04110                  LQ.LOSS_RESRVE_EFF_DT,                          
T34268                  AT.ACCOUNT_NO,                                  
T34268                  AT.BILL_CYCLE,                                  
T34268                  AT.DATE_BILL_DAY_00,                            
T34268                  AT.TOTAL_AR_BALANCE,                            
T34268                  AT.CODE_MAJOR_ACCT,                             
T34268                  AT.LOCAL_OFFICE,                                
T34268                  AT.COMPANY_NO,                                  
T34268                  AT.CREDIT_GROUP                                 
T34268           FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
T34268                  CSS_CUST_MISC_INFO LQ WITH(READUNCOMMITTED)             
T34268           WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                  
T34268           AND AT.CREDIT_GROUP IN ('A','C','M', ' ','S','B','N')  
T34268*          AND AT.CREDIT_GROUP = 'M'                                      
T34268             AND AT.MST_SUB_ACCT_IND = 'M'                        
T34268             AND AT.CODE_ACCT_STAT = 'A'                          
T34268             AND LQ.LOSS_RESERVE_CD > 0                           
T34268           ORDER BY AT.ACCOUNT_NO                                 
T34268         FOR READ ONLY                                    
T34268     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        DECLARE CUST_MAST_CURSOR CURSOR FOR                      07400004
MFA-TR*          SELECT LQ.CUSTOMER_NO,                                         
MFA-TR*                 LQ.LOSS_RESERVE_CD,                                     
MFA-TR*                 LQ.LOSS_RESRVE_EFF_DT,                                  
MFA-TR*                 AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.BILL_CYCLE,                                          
MFA-TR*                 AT.DATE_BILL_DAY_00,                                    
MFA-TR*                 AT.TOTAL_AR_BALANCE,                                    
MFA-TR*                 AT.CODE_MAJOR_ACCT,                                     
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.CREDIT_GROUP                                         
MFA-TR*          FROM   CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_CUST_MISC_INFO LQ                                   
MFA-TR*          WHERE AT.CUSTOMER_NO = LQ.CUSTOMER_NO                          
MFA-TR*          AND AT.CREDIT_GROUP IN ('A','C','M', ' ','S','B','N')          
MFA-TR*          AND AT.CREDIT_GROUP = 'M'                                      
MFA-TR*            AND AT.MST_SUB_ACCT_IND = 'M'                                
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND LQ.LOSS_RESERVE_CD > 0                                   
MFA-TR*          ORDER BY AT.ACCOUNT_NO                                         
MFA-TR*        FOR FETCH ONLY WITH UR                                   07470000
MFA-TR*    END-EXEC.                                                    07480000
                                                                        
      *                                                                 07500000
           EXEC SQL                                                     
               DECLARE DEP_ON_HAND_CURSOR CURSOR FOR                    
                SELECT AMT_DEPOSIT                                      
                  FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO               
                   AND DEPOSIT_STATUS_CD = 'P'                          
T33928         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        DECLARE DEP_ON_HAND_CURSOR CURSOR FOR                    07400004
MFA-TR*         SELECT AMT_DEPOSIT                                              
MFA-TR*           FROM CSS_DEP_ON_HAND                                          
MFA-TR*          WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                       
MFA-TR*            AND DEPOSIT_STATUS_CD = 'P'                                  
MFA-TR*        FOR FETCH ONLY WITH UR                                   07470000
MFA-TR*    END-EXEC.                                                    07480000
                                                                        
      *                                                                 07500000
                                                                        
      *                                                                 07500000
           EXEC SQL                                                     
               DECLARE BILL_DETAIL_CURSOR CURSOR FOR                    
                SELECT BILL_NO,                                         
                       AMT_BILL_ITEM,                                   
                       CODE_DR_CR_CNSMPTN,                              
                       REVENUE_MONTH                                    
                  FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                    
                 WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO              
                   AND REVENUE_MONTH     >= :WS-REV-BEG-DATE            
                   AND REVENUE_MONTH     <= :WS-REV-END-DATE            
                 ORDER BY REVENUE_MONTH                                 
T33928         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        DECLARE BILL_DETAIL_CURSOR CURSOR FOR                    07400004
MFA-TR*         SELECT BILL_NO,                                                 
MFA-TR*                AMT_BILL_ITEM,                                           
MFA-TR*                CODE_DR_CR_CNSMPTN,                                      
MFA-TR*                REVENUE_MONTH                                            
MFA-TR*           FROM CSS_BILLING_DET                                          
MFA-TR*          WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*            AND REVENUE_MONTH     >= :WS-REV-BEG-DATE                    
MFA-TR*            AND REVENUE_MONTH     <= :WS-REV-END-DATE                    
MFA-TR*          ORDER BY REVENUE_MONTH                                         
MFA-TR*        FOR FETCH ONLY WITH UR                                   07470000
MFA-TR*    END-EXEC.                                                    07480000
                                                                        
      *                                                                 07500000
                                                                        
                                                                        
      /                                                                 07530000
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH                 PIC S9(04) COMP.       
           03  WS-PARM-DATE                      PIC X(06).             
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *PROCEDURE DIVISION.                                              07550000
      *                                                                 07560000
       0000-MAINLINE.                                                   
      *                                                                 07580000
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                 07600000
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
      *                                                                 07630000
T34268     PERFORM 2000-PROCESS-INPUT          THRU 2000-EXIT.          
      *                                                                 07630000
           INITIALIZE FIORP440.                                         
           PERFORM 4200-WRITE-RP440-END-REC THRU 4200-EXIT.             
      *                                                                 07632011
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                 07650000
           STOP RUN.                                                    
      *                                                                 07670000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07700000
      *   OPENS THE INPUT  AND OUTPUT FILE                             *07710000
      ******************************************************************07720000
       0100-INITIALIZATION.                                             
      *                                                                 07740000
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
           PERFORM 6200-GET-PARAMETER-DATE             THRU 6200-EXIT.  
           IF WS-PARM-DATE NOT = 'CCYYMM'                               
               IF WS-PARM-DATE NUMERIC                                  
               MOVE WS-PARM-DATE (5:2) TO WS-PARM-MONTH                 
               MOVE WS-PARM-DATE (1:4) TO WS-PARM-YR                    
               DISPLAY 'PCSCA440 USING JCL PARM DATE =' WS-PARM-DATE    
               ELSE                                                     
               DISPLAY 'PCSCA440-USING JCL PARM DATE, DATE NOT NUMERIC' 
                   MOVE 12 TO RETURN-CODE                               
                   PERFORM 9000-TERMINATE THRU 9000-EXIT                
      *            PERFORM 9900-ABEND THRU 9900-EXIT                            
               END-IF                                                   
           END-IF.                                                      
           MOVE WS-PARM-YR              TO  WS-REV-YEAR.                
           MOVE WS-PARM-MONTH           TO  WS-REV-MM.                  
                                                                        
           ADD 1 TO WS-REV-MM-R.                                        
                                                                        
           DISPLAY 'PARM MTH = ' WS-PARM-MONTH.                         
           DISPLAY 'PARM YEAR = ' WS-PARM-YR.                           
           DISPLAY 'REV MTH = ' WS-REV-MM.                              
           DISPLAY 'REV YEAR = ' WS-REV-YEAR.                           
      *                                                                 07810000
           OPEN OUTPUT FCSRP440-FILE.                                   
           IF FRP440-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************************************'           
               DISPLAY '**    PCSCA440 PROCESSING ERROR   **'           
               DISPLAY '**   FCSRP440-FILE WILL NOT OPEN  **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               DISPLAY '************************************'           
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 07820000
           MOVE LOW-VALUES TO E-FRP440-KEY-BREC.                        
           MOVE WS-INPUT-DATE TO  E-FRP440-CREATE-DATE-BREC.            
           PERFORM 4100-WRITE-RP440-DATE-REC THRU 4100-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08100000
      *                                                                 08700000
      ******************************************************************08710000
      * PROCESSES EACH CUSTOMER UNTIL END OF FETCH                    **08720000
      ******************************************************************08730000
      *                                                                 08740000
       1000-PROCESS-INPUT.                                              
      *                                                                 08760000
           INITIALIZE FIORP440.                                         
           PERFORM 7100-OPEN-CUST-MISC-CURSOR.                          
           PERFORM 7110-FETCH-CUST-MISC-CURSOR.                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               DISPLAY '*********************************************'  
               DISPLAY '**    PCSCA440 PROCESSING ERROR            **'  
               DISPLAY '**   NO CUSTOMERS FOUND WITH A RISK RATING **'  
               DISPLAY '**      PROCESSING TERMINATED              **'  
               DISPLAY '*********************************************'  
               MOVE +5 TO RETURN-CODE                                   
               GO TO 1000-EXIT                                          
           ELSE                                                         
               MOVE AT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO                 
               PERFORM 1100-POPULATE-ACCT-REC THRU 1100-EXIT
           END-IF.           
      *                                                                 09040000
           PERFORM UNTIL WS-PROCESSING-DONE = 'Y'                       
               IF AT-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                    
                   PERFORM 1250-ADD-RATE THRU 1250-EXIT                 
                   PERFORM 7110-FETCH-CUST-MISC-CURSOR                  
               ELSE                                                     
                   MOVE WS-RATE-COUNTER TO E-FRP440-NUMBER-OF-RATE      
                   PERFORM 4000-WRITE-FIORP440-RECORD THRU 4000-EXIT    
                   INITIALIZE FIORP440 ZL-LOSS-RESERVE-TX-TEXT          
                   MOVE AT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO             
                   MOVE ZERO TO WS-RATE-COUNTER WS-TWELVE-MONTH-REV     
                                WS-TOTAL-AR-COMP3                       
                                WS-DEPOSIT-AMT-COMP3                    
                                WS-RESERVE-AMT-COMP3                    
                                WS-LAST-BILL-AMT-COMP3                  
                                WS-LOSS-RES-BAL-COMP3                   
                                WS-TOTAL-AR-COMP                        
                                WS-DEPOSIT-AMT-COMP                     
                                WS-RESERVE-AMT-COMP                     
                                WS-TWELVE-MTH-COMP                      
                                WS-LAST-BILL-AMT-COMP                   
                                WS-LOSS-RES-BAL-COMP                    
                   PERFORM 1100-POPULATE-ACCT-REC  THRU 1100-EXIT       
                   PERFORM 1250-ADD-RATE THRU 1250-EXIT                 
                   PERFORM 7110-FETCH-CUST-MISC-CURSOR                  
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           MOVE WS-RATE-COUNTER TO E-FRP440-NUMBER-OF-RATE.             
           PERFORM 4000-WRITE-FIORP440-RECORD THRU 4000-EXIT            
                                                                        
           PERFORM 7120-CLOSE-CUST-MISC-CURSOR THRU 7120-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************     09080003
      *                                                                 08740000
T34268 2000-PROCESS-INPUT.                                              
T34268*                                                                 08760000
T34268     INITIALIZE FIORP440.                                         
T34268     PERFORM 7200-OPEN-CUST-MAST-CURSOR.                          
T34268     PERFORM 7210-FETCH-CUST-MAST-CURSOR.                         
T34268     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T34268         DISPLAY '*********************************************'  
T34268         DISPLAY '**    PCSCA440 PROCESSING ERROR            **'  
T34268         DISPLAY '**   NO CUSTOMERS FOUND WITH A RISK RATING **'  
T34268         DISPLAY '**      PROCESSING TERMINATED              **'  
T34268         DISPLAY '*********************************************'  
T34268         MOVE +5 TO RETURN-CODE                                   
T34268         GO TO 1100-EXIT                                          
T34268     ELSE                                                         
T34268         MOVE AT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO                 
T34268         PERFORM 1100-POPULATE-ACCT-REC THRU 1200-EXIT
           END-IF.           
T34268*                                                                 09040000
T34268     PERFORM UNTIL WS-PROCESS-MSTDONE = 'Y'                       
T34268         IF AT-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                    
T34268*            PERFORM 1250-ADD-RATE THRU 1250-EXIT                         
T34268             PERFORM 7210-FETCH-CUST-MAST-CURSOR                  
T34268         ELSE                                                     
T34268             MOVE WS-RATE-COUNTER TO E-FRP440-NUMBER-OF-RATE      
T34268             PERFORM 4000-WRITE-FIORP440-RECORD THRU 4000-EXIT    
T34268             INITIALIZE FIORP440 ZL-LOSS-RESERVE-TX-TEXT          
T34268             MOVE AT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO             
T34268             MOVE ZERO TO WS-RATE-COUNTER WS-TWELVE-MONTH-REV     
T34268                          WS-TOTAL-AR-COMP3                       
T34268                          WS-DEPOSIT-AMT-COMP3                    
T34268                          WS-RESERVE-AMT-COMP3                    
T34268                          WS-LAST-BILL-AMT-COMP3                  
T34268                          WS-LOSS-RES-BAL-COMP3                   
T34268                          WS-TOTAL-AR-COMP                        
T34268                          WS-DEPOSIT-AMT-COMP                     
T34268                          WS-RESERVE-AMT-COMP                     
T34268                          WS-TWELVE-MTH-COMP                      
T34268                          WS-LAST-BILL-AMT-COMP                   
T34268                          WS-LOSS-RES-BAL-COMP                    
T34268             PERFORM 1100-POPULATE-ACCT-REC  THRU 1200-EXIT       
T34268*            PERFORM 1250-ADD-RATE THRU 1250-EXIT                         
T34268             PERFORM 7210-FETCH-CUST-MAST-CURSOR                  
T34268         END-IF                                                   
T34268     END-PERFORM.                                                 
                                                                        
T34268     MOVE WS-RATE-COUNTER TO E-FRP440-NUMBER-OF-RATE.             
T34268     PERFORM 4000-WRITE-FIORP440-RECORD THRU 4000-EXIT            
                                                                        
T34268     PERFORM 7220-CLOSE-CUST-MAST-CURSOR THRU 7220-EXIT.          
                                                                        
T34268 2000-EXIT.                                                       
T34268     EXIT.                                                        
                                                                        
      *************************************************************     09080003
      * THIS PARAGRAPH WILL POPULATE THE RECORD                 ***     09090003
      *************************************************************     09100003
       1100-POPULATE-ACCT-REC.                                          
                                                                        
           MOVE AT-COMPANY-NO         TO E-FRP440-COMPANY-NO.           
           MOVE AT-ACCOUNT-NO         TO E-FRP440-ACCOUNT-NO.           
           MOVE LQ-CUSTOMER-NO        TO E-FRP440-CUSTOMER-NUMBER.      
           MOVE AT-BILL-CYCLE         TO E-FRP440-BILLING-CYCLE.        
                                                                        
           ADD AT-TOTAL-AR-BALANCE    TO WS-TOTAL-AR-COMP3 ROUNDED.     
           MOVE WS-TOTAL-AR-COMP3     TO WS-TOTAL-AR-COMP.              
           MOVE WS-TOTAL-AR-COMP      TO E-FRP440-TOTAL-AR-BALANCE.     
                                                                        
           MOVE AT-LOCAL-OFFICE       TO E-FRP440-LOCAL-OFFICE.         
           MOVE AT-DATE-BILL-DAY-00   TO E-FRP440-LAST-BILL-DATE.       
A04110     MOVE LQ-LOSS-RESRVE-EFF-DT TO E-FRP440-LOSS-RESV-DATE.       
           MOVE AT-CREDIT-GROUP       TO E-FRP440-CREDIT-GROUP.         
                                                                        
           IF AT-CODE-MAJOR-ACCT = 'Y'                                  
               MOVE 'Y' TO E-FRP440-MAJOR-IND                           
           ELSE                                                         
               MOVE 'N' TO E-FRP440-MAJOR-IND
           END-IF.                          
                                                                        
                                                                        
           PERFORM 1200-GET-LOSS-RESERVE-FIELDS THRU 1200-EXIT.         
             IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                MOVE ZL-LOSS-RESERVE-PCT  TO E-FRP440-RESERVE-PERCENT   
                MOVE ZL-LOSS-RESERVE-TX-TEXT                            
                                          TO E-FRP440-RISK-RATING       
                MOVE ZL-GROUP-SEQ-NO      TO E-FRP440-GROUP-SEQ-NO      
                MOVE ZL-LOSS-REPORT-AMT   TO WS-LOSS-RES-BAL-COMP3      
                MOVE WS-LOSS-RES-BAL-COMP3 TO WS-LOSS-RES-BAL-COMP      
                MOVE WS-LOSS-RES-BAL-COMP TO E-FRP440-LOSS-RESERVE-BAL  
                MOVE ZL-LOSS-REPORT-IND   TO E-FRP440-LOSS-RESERVE-IND  
                MOVE ZL-SORT-SEQ-NO       TO E-FRP440-SORT-SEQ-NO       
                IF AT-TOTAL-AR-BALANCE > 0                              
                    COMPUTE WS-RESERVE-AMT-COMP3 ROUNDED =              
                        AT-TOTAL-AR-BALANCE * ZL-LOSS-RESERVE-PCT       
                    MOVE WS-RESERVE-AMT-COMP3 TO WS-RESERVE-AMT-COMP    
                    MOVE WS-RESERVE-AMT-COMP TO E-FRP440-RESERVE-AMOUNT 
                ELSE                                                    
                    MOVE ZEROS TO E-FRP440-RESERVE-AMOUNT               
                END-IF
             END-IF.                                                 
                                                                        
           PERFORM 1150-CHECK-ADDL-DEPOSIT THRU 1150-EXIT.              
                                                                        
           PERFORM 1300-GET-CUST-NAME THRU 1300-EXIT.                   
           MOVE DQ-FULL-NAME         TO E-FRP440-CUSTOMER-NAME.         
                                                                        
           PERFORM 1350-GET-ACCT-MGR-NAME THRU 1350-EXIT.               
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811          
              IF DQ-FIRST-NAME = SPACES OR DQ-LAST-NAME = SPACES        
                  MOVE DQ-FULL-NAME TO E-FRP440-ACCOUNT-MANAGER         
              ELSE                                                      
                  MOVE DQ-FIRST-NAME TO E-FRP440-FIRST-NAME             
                  MOVE DQ-LAST-NAME  TO E-FRP440-LAST-NAME              
              END-IF
           END-IF.                                                   
                                                                        
           PERFORM 1400-GET-LAST-BILL-AMT THRU 1400-EXIT.               
           MOVE AR-AMT-BILLED-UNPAID TO WS-LAST-BILL-AMT-COMP3.         
           MOVE WS-LAST-BILL-AMT-COMP3 TO WS-LAST-BILL-AMT-COMP.        
           MOVE WS-LAST-BILL-AMT-COMP TO E-FRP440-LAST-BILL-AMT.        
                                                                        
           PERFORM 1450-GET-CREDIT-PROFILE THRU 1450-EXIT.              
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE CZ-ARREARS-HIST      TO E-FRP440-ARREARS-HIST       
               MOVE CZ-DISCONNECT-HIST   TO E-FRP440-NORMAL-HIST        
               MOVE CZ-DISC-EXCEPTN-HIST TO E-FRP440-EXCEPT-HIST
           END-IF.       
                                                                        
           PERFORM 1500-OPEN-DEP-ON-HAND-CURSOR.                        
           PERFORM 1510-FETCH-DEPOSIT-AMT    THRU 1510-EXIT.            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 1510-FETCH-DEPOSIT-AMT    THRU 1510-EXIT         
           END-PERFORM.                                                 
           PERFORM 1520-CLOSE-DEP-ON-HAND-CURSOR THRU 1520-EXIT.        
                                                                        
           PERFORM 1600-GET-ROLLING-REV THRU 1600-EXIT.                 
                                                                        
T34268     IF AT-CREDIT-GROUP  = 'M'                                    
T34268        MOVE 0 TO E-FRP440-TWELVE-MTH-REV                         
T34268     END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *************************************************************     09270003
      * CHECK FOR ADDITIONAL DEPOSIT                            ***     09280003
      *************************************************************     09290003
       1150-CHECK-ADDL-DEPOSIT.                                         
      *                                                                 09310003
           EXEC SQL                                                     
             SELECT BOND_WAIV_ITEM_ID                                   
               INTO :SB-BOND-WAIV-ITEM-ID                               
               FROM CSS_SURETY_BOND                                     
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
                AND (CODE_BOND_TYPE    = 'A'                            
                 OR  CODE_BOND_TYPE    = 'B')                           
                AND CODE_STATUS        = 'A'                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811          
               MOVE 'Y'  TO E-FRP440-OTHER-SEC-IND                      
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 'N' TO E-FRP440-OTHER-SEC-IND                    
               ELSE                                                     
                  DISPLAY '********** PCSCA440 ABORT **************'    
                  DISPLAY '* 1150-CHECK-ADDL-DEPOSIT*'                  
                  DISPLAY '* ACOUNT NO ', AT-ACCOUNT-NO                 
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '********** PCSCA440 ABORT **************'    
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************     09270003
      * THIS PARAGRAPH WILL GET FIELDS FROM LOSS RESERVE TABLE  ***     09280003
      *************************************************************     09290003
       1200-GET-LOSS-RESERVE-FIELDS.                                    
      *                                                                 09310003
           EXEC SQL                                                     
             SELECT LOSS_RESERVE_PCT,                                   
                    LOSS_RESERVE_TX,                                    
                    GROUP_SEQ_NO,                                       
                    LOSS_REPORT_AMT,                                    
                    LOSS_REPORT_IND,                                    
                    SORT_SEQ_NO                                         
               INTO :ZL-LOSS-RESERVE-PCT,                               
                    :ZL-LOSS-RESERVE-TX,                                
                    :ZL-GROUP-SEQ-NO,                                   
                    :ZL-LOSS-REPORT-AMT,                                
                    :ZL-LOSS-REPORT-IND,                                
                    :ZL-SORT-SEQ-NO                                     
               FROM CSS_LOSS_RESERVE                                    
              WHERE LOSS_RESERVE_CD   = :LQ-LOSS-RESERVE-CD             
                AND COMPANY_NO        = :AT-COMPANY-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 999 TO E-FRP440-GROUP-SEQ-NO                     
                  MOVE 001 TO E-FRP440-SORT-SEQ-NO                      
                  MOVE 'CODE NOT FOUND' TO ZL-LOSS-RESERVE-TX           
                  DISPLAY '*************************************'       
                  DISPLAY 'NO MATCHING LOSS RESERVE CODES      *'       
                  DISPLAY '* LOSS RESERVE CODE ', LQ-LOSS-RESERVE-CD    
                  DISPLAY '* CUSTOMER NUMBER ', LQ-CUSTOMER-NO          
                  DISPLAY '* COMPANY NO ', AT-COMPANY-NO                
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '*************************************'       
               ELSE                                                     
                  DISPLAY '********** PCSCA440 ABORT **************'    
                  DISPLAY '* 1200-GET-LOSS-RESERVE-FIELDS*'             
                  DISPLAY '* LOSS RESERVE CODE ', LQ-LOSS-RESERVE-CD    
                  DISPLAY '* CUSTOMER NUMBER ', LQ-CUSTOMER-NO          
                  DISPLAY '* COMPANY NO ', AT-COMPANY-NO                
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '********** PCSCA440 ABORT **************'    
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *   GET ALL RATES FOR THE ACCOUNT                         ****            
      **************************************************************            
       1250-ADD-RATE.                                                   
           ADD 1 TO WS-RATE-COUNTER.                                    
                                                                        
           IF WS-RATE-COUNTER < 10                                      
               IF WS-RATE-COUNTER = 01                                  
                   MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE01          
                   MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE01      
               ELSE                                                     
                   IF WS-RATE-COUNTER = 02                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE02      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE02  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 03                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE03      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE03  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 04                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE04      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE04  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 05                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE05      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE05  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 06                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE06      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE06  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 07                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE07      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE07  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 08                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE08      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE08  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 09                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE09      
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE09  
               ELSE                                                     
                   IF WS-RATE-COUNTER = 10                              
                       MOVE   UT-RATE-PLAN-NO TO   E-FRP440-RATE010     
                       MOVE   UT-CODE-SIC-NO  TO   E-FRP440-SIC-CODE10
                   END-IF
                   END-IF
                   END-IF
                   END-IF
                   END-IF
                   END-IF
                   END-IF
                   END-IF
                   END-IF
               END-IF
           END-IF. 
                                                                        
       1250-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    09630003
      * GET CUSTOMER FULL NAME FOR CSS_NAME TABLE                ***    09640040
      **************************************************************    09650003
       1300-GET-CUST-NAME.                                              
           EXEC SQL                                                     
             SELECT DQ.FIRST_NAME,                                      
                    DQ.LAST_NAME,                                       
                    DQ.FULL_NAME                                        
               INTO :DQ-FIRST-NAME,                                     
                    :DQ-LAST-NAME,                                      
                    :DQ-FULL-NAME                                       
               FROM CSS_ACCOUNT  AT                                     
                   ,CSS_CUSTOMER CU                                     
                   ,CSS_NAME     DQ                                     
              WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                  
                AND CU.CUSTOMER_NO    = AT.CUSTOMER_NO                  
                AND DQ.NAME_ID        = CU.NAME_ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1300-GET-CUST-NAME                  *'        
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    09950009
      ******           GET ACCOUNT MANAGER NAME                  ***    09960044
      **************************************************************    09970009
       1350-GET-ACCT-MGR-NAME.                                          
           EXEC SQL                                                     
            SELECT DQ.FIRST_NAME,                                       
                   DQ.LAST_NAME,                                        
                   DQ.FULL_NAME                                         
              INTO :DQ-FIRST-NAME,                                      
                   :DQ-LAST-NAME,                                       
                   :DQ-FULL-NAME                                        
              FROM CSS_CONTACT_CUST DT                                  
                  ,CSS_CONTACT  CV                                      
                  ,CSS_NAME     DQ                                      
            WHERE DT.CUSTOMER_NO  = :LQ-CUSTOMER-NO                     
            AND   DT.CONTACT_ID   = CV.CONTACT_ID                       
            AND   CV.NAME_ID      = DQ.NAME_ID                          
            AND   DQ.NAME_TYPE    = 'CC'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE = 100                          
               MOVE 'NO ACCT MANAGER FOUND' TO E-FRP440-ACCOUNT-MANAGER 
               DISPLAY '* CUSTOMER NO ', LQ-CUSTOMER-NO                 
               DISPLAY '* NO ACCOUNT MANAGER FOUND            *'        
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1350-GET-ACCT-MGR-NAME              *'        
               DISPLAY '* CUSTOMER NO', LQ-CUSTOMER-NO                  
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
           END-IF
           END-IF.                                                      
                                                                        
       1350-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    09973044
      ******           GET LAST BILL DATE                        ***    09973144
      **************************************************************    09974044
       1400-GET-LAST-BILL-AMT.                                          
                                                                        
           EXEC SQL                                                     
               SELECT AMT_BILLED_UNPAID                                 
                 INTO :AR-AMT-BILLED-UNPAID                             
                 FROM CSS_AR_TRANS_HIST                                 
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                AND   DATE_TRANS     = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )             
                AND   CODE_TRAN_TYPE = 'B'                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09990010
MFA-TR*        SELECT AMT_BILLED_UNPAID                                 10000044
MFA-TR*          INTO :AR-AMT-BILLED-UNPAID                             10010044
MFA-TR*          FROM CSS_AR_TRANS_HIST                                 10020044
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*         AND   DATE_TRANS     = :AT-DATE-BILL-DAY-00             10030010
MFA-TR*         AND   CODE_TRAN_TYPE = 'B'                                      
MFA-TR*    END-EXEC.                                                    10040010

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  DISPLAY 'NO LAST BILL AMT FOR ACCOUNT ' AT-ACCOUNT-NO 
               ELSE                                                     
                   DISPLAY '********** PCSCA440 ABORT **************'   
                   DISPLAY '* 1400-GET-LAST-BILL-AMT              *'    
                   DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO               
                   DISPLAY '* LAST BILL DATE ', AT-DATE-BILL-DAY-00     
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                  *'   
                   DISPLAY '********** PCSCA440 ABORT **************'   
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    09973044
      ******           GET CREDIT PROFILE                        ***    09973144
      **************************************************************    09974044
       1450-GET-CREDIT-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT ARREARS_HIST,                                     
                      DISCONNECT_HIST,                                  
                      DISC_EXCEPTN_HIST                                 
                 INTO :CZ-ARREARS-HIST,                                 
                      :CZ-DISCONNECT-HIST,                              
                      :CZ-DISC-EXCEPTN-HIST                             
                 FROM CSS_CREDIT_PROFILE                                
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 'NO CREDIT PROFILE' TO E-FRP440-ARREARS-HIST     
               ELSE                                                     
                   DISPLAY '********** PCSCA440 ABORT **************'   
                   DISPLAY '* 1450-GET-CREDIT-PROFILE             *'    
                   DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO               
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                  *'   
                   DISPLAY '********** PCSCA440 ABORT **************'   
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************    09973044
      ******           GET DEPOSIT AMOUNT                        ***    09973144
      **************************************************************    09974044
       1500-OPEN-DEP-ON-HAND-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
                OPEN DEP_ON_HAND_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1500-OPEN-DEP-ON-HAND-CURSOR          *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11340000
      * FETCH DEP ON HAND CURSOR                                        11350000
      ******************************************************************11360000
                                                                        
       1510-FETCH-DEPOSIT-AMT.                                          
           EXEC SQL                                                     
               FETCH DEP_ON_HAND_CURSOR                                 
                INTO :DO-AMT-DEPOSIT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD DO-AMT-DEPOSIT TO WS-DEPOSIT-AMT-COMP3                
              MOVE WS-DEPOSIT-AMT-COMP3 TO WS-DEPOSIT-AMT-COMP          
              MOVE WS-DEPOSIT-AMT-COMP TO E-FRP440-DEPOSIT-AMOUNT       
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   NEXT SENTENCE                                        
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1510-FETCH-DEPOSIT-AMT               *'       
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 11570000
       1510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11610000
      * CLOSE DEP_ON_HAND_CURSOR                                        11620000
      ******************************************************************11630000
      *                                                                 11640000
       1520-CLOSE-DEP-ON-HAND-CURSOR.                                   
           EXEC SQL                                                     
              CLOSE DEP_ON_HAND_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1520-CLOSE-DEP-ON-HAND-CURSOR         *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *            GET 12 MONTH REVENUE                                         
      ****************************************************************          
      *                                                                         
       1600-GET-ROLLING-REV.                                            
                                                                        
           MOVE WS-REV-MM-R TO WS-REV-BEG-MM.                           
           SUBTRACT 1 FROM WS-REV-YEAR-R1 GIVING WS-REV-BEG-YYYY.       
           MOVE WS-REV-BEG-DATE-R TO WS-REV-BEG-DATE-R2.                
           MOVE WS-REV-BEG-DATE-R2 TO WS-REV-BEG-DATE.                  
                                                                        
           IF WS-REV-MM = '01'                                          
               MOVE 12 TO WS-REV-END-MM                                 
               SUBTRACT 1 FROM WS-REV-YEAR-R1 GIVING WS-REV-END-YYYY    
           ELSE                                                         
               SUBTRACT 1 FROM WS-REV-MM-R GIVING WS-REV-END-MM         
               MOVE WS-REV-YEAR-R TO WS-REV-END-YYYY
           END-IF.                   
           MOVE WS-REV-END-DATE-R TO WS-REV-END-DATE-R2                 
                                     E-FRP440-CURRENT-REV-MTH.          
                                                                        
           MOVE WS-REV-END-DATE-R2 TO WS-REV-END-DATE.                  
           DISPLAY 'REV-BEG-DATE = ' WS-REV-BEG-DATE.                   
           DISPLAY 'REV-END-DATE = ' WS-REV-END-DATE.                   
           PERFORM 1610-OPEN-BILL-CURSOR    THRU 1610-EXIT.             
           PERFORM 1620-FETCH-BILL-CURSOR   THRU 1620-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               IF  BG-CODE-DR-CR-CNSMPTN = 'C'                          
                   SUBTRACT BG-AMT-BILL-ITEM FROM                       
                              WS-TWELVE-MONTH-REV                       
               ELSE                                                     
                   ADD BG-AMT-BILL-ITEM TO                              
                              WS-TWELVE-MONTH-REV                       
               END-IF                                                   
               IF BG-BILL-NO NOT = WS-PREV-BILL-NO                      
                   PERFORM 1650-GET-OTHER-CHARGES THRU 1650-EXIT        
               END-IF                                                   
               MOVE BG-BILL-NO TO WS-PREV-BILL-NO                       
               PERFORM 1620-FETCH-BILL-CURSOR   THRU 1620-EXIT          
           END-PERFORM.                                                 
           PERFORM 1630-CLOSE-BILL-CURSOR   THRU 1630-EXIT.             
           ADD WS-TWELVE-MONTH-REV TO WS-TWELVE-MTH-COMP ROUNDED.       
           MOVE WS-TWELVE-MTH-COMP TO E-FRP440-TWELVE-MTH-REV.          
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11100000
      * OPEN  BILL_DETAIL_CURSOR                                        11110000
      ******************************************************************11120000
      *                                                                 11130000
       1610-OPEN-BILL-CURSOR.                                           
           EXEC SQL                                                     
                OPEN BILL_DETAIL_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1610-OPEN-BILL-CURSOR                 *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 11300000
       1610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11340000
      * FETCH BILL_DETAIL_CURSOR                                        11350000
      ******************************************************************11360000
                                                                        
       1620-FETCH-BILL-CURSOR.                                          
           EXEC SQL                                                     
               FETCH BILL_DETAIL_CURSOR                                 
                INTO :BG-BILL-NO,                                       
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-CODE-DR-CR-CNSMPTN,                            
                     :BG-REVENUE-MONTH                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1620-FETCH-BILL-CURSOR                *'      
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 11570000
       1620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11610000
      * CLOSE BILL_DETAIL_CURSOR                                        11620000
      ******************************************************************11630000
      *                                                                 11640000
       1630-CLOSE-BILL-CURSOR.                                          
           EXEC SQL                                                     
              CLOSE BILL_DETAIL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1630-CLOSE-BILL-CURSOR                *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       1630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12330000
      ***************************************************************           
      *  GET OTHER CHARGES FROM BILLING HEADER                                  
      ***************************************************************           
       1650-GET-OTHER-CHARGES.                                          
           EXEC SQL                                                     
               SELECT TOT_OTHER_CHARGES                                 
                 INTO :BI-TOT-OTHER-CHARGES                             
                 FROM CSS_BILLING_HDR                                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND BILL_NO    = :BG-BILL-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD BI-TOT-OTHER-CHARGES TO WS-TWELVE-MONTH-REV          
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 1650-GET-OTHER-CHARGES                *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       1650-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   10540004
      *  THIS PARAGRAPH WRITES THE RP440 RECORD                   ***   10550004
      ***************************************************************   10560004
       4000-WRITE-FIORP440-RECORD.                                      
           WRITE FIORP440.                                              
           IF FRP440-SUCCESSFUL                                         
              ADD 1  TO WS-FRP440-REC-CTR                               
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   4000-WRITE-FIORP440 NOT SUCCESSFUL  **'     
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
           INITIALIZE FIORP440.                                         
           MOVE ZEROS TO WS-RATE-COUNTER.                               
       4000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************   10740211
      *  THIS PARAGRAPH WRITES THE RP440 BEGIN RECORD             ***   10740311
      ***************************************************************   10740411
       4100-WRITE-RP440-DATE-REC.                                       
           WRITE FIORP440-BEGIN-REC.                                    
           IF FRP440-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   4100-WRITE-RP440-DATE-REC NOT SUCCESSFUL*'  
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
           INITIALIZE FIORP440.                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10743011
      ***************************************************************   10744011
      *  THIS PARAGRAPH WRITES THE RP440 END RECORD               ***   10745011
      ***************************************************************   10746011
       4200-WRITE-RP440-END-REC.                                        
           MOVE HIGH-VALUES TO E-FRP440-KEY-EREC.                       
           MOVE WS-FRP440-REC-CTR TO E-FRP440-RECORD-COUNT-EREC.        
           WRITE FIORP440-END-REC.                                      
           IF FRP440-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   4200-WRITE-RP440-END-REC NOT SUCCESSFUL*'   
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       4200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10750520
      ******  COPYBOOK FOR DATE ROUTINE OVERIDE                 *****   10750622
      ******************************************************************10750720
       COPY CPD00040.                                                   10750822
       COPY CPD00037.                                                   10750920
      * PARAGRAPH GET-6200-PARAMETER-DATE IS IN CPD00114.               10751021
           EXEC SQL                                                     10751121
              INCLUDE CPD00114                                          10751221
           END-EXEC.                                                    10752021
      * PARAGRAPH 7600-START-FCSJC01 IS IN CPD00038.                    10751021
           EXEC SQL                                                     10751121
              INCLUDE CPD00038                                          10751221
           END-EXEC.                                                    10752021
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                     10753021
           EXEC SQL                                                     10754021
              INCLUDE CPD00039                                          10755021
           END-EXEC.                                                    10756021
      ******************************************************************11100000
      * OPEN  CUST_MISC_CURSOR                                          11110000
      ******************************************************************11120000
      *                                                                 11130000
       7100-OPEN-CUST-MISC-CURSOR.                                      
           EXEC SQL                                                     
                OPEN CUST_MISC_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 7100-OPEN-CUST-MISC-CURSOR            *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 11300000
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11340000
      * FETCH AR_CNTRL CURSOR                                           11350000
      ******************************************************************11360000
                                                                        
       7110-FETCH-CUST-MISC-CURSOR.                                     
           EXEC SQL                                                     
               FETCH CUST_MISC_CURSOR                                   
                INTO :LQ-CUSTOMER-NO,                                   
                     :LQ-LOSS-RESERVE-CD,                               
A04110               :LQ-LOSS-RESRVE-EFF-DT,                            
                     :AT-ACCOUNT-NO,                                    
                     :AT-BILL-CYCLE,                                    
                     :AT-DATE-BILL-DAY-00,                              
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CODE-MAJOR-ACCT,                               
                     :AT-LOCAL-OFFICE,                                  
                     :AT-COMPANY-NO,                                    
                     :AT-CREDIT-GROUP,                                  
                     :UT-RATE-PLAN-NO,                                  
                     :UT-CODE-SIC-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE 'Y' TO WS-PROCESSING-DONE                       
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 7110-FETCH-CUST-MISC-CURSOR           *'      
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
      *                                                                 11570000
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11610000
      * CLOSE CUST_MISC_CUSSOR                                          11620000
      ******************************************************************11630000
      *                                                                 11640000
       7120-CLOSE-CUST-MISC-CURSOR.                                     
           EXEC SQL                                                     
              CLOSE CUST_MISC_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA440 ABORT **************'       
               DISPLAY '* 7120-CLOSE-CUST-MISC-CURSOR           *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA440 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12330000
T34268******************************************************************11100000
T34268* OPEN  CUST_MAST_CURSOR                                          11110000
T34268******************************************************************11120000
T34268*                                                                 11130000
T34268 7200-OPEN-CUST-MAST-CURSOR.                                      
T34268     EXEC SQL                                                     
T34268          OPEN CUST_MAST_CURSOR                                   
T34268     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34268                                                                  
T34268     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T34268     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T34268        NEXT SENTENCE                                             
T34268     ELSE                                                         
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         DISPLAY '* 7200-OPEN-CUST-MISC-CURSOR            *'      
T34268         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T34268         DISPLAY '* PROGRAM ABORTING...                  *'       
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         PERFORM 9900-ABEND              THRU 9900-EXIT           
T34268     END-IF.                                                      
T34268*                                                                 11300000
T34268 7200-EXIT.                                                       
T34268     EXIT.                                                        
T34268                                                                  
T34268******************************************************************11340000
T34268* FETCH AR_CNTRL CURSOR                                           11350000
T34268******************************************************************11360000
T34268                                                                  
T34268 7210-FETCH-CUST-MAST-CURSOR.                                     
T34268     EXEC SQL                                                     
T34268         FETCH CUST_MAST_CURSOR                                   
T34268          INTO :LQ-CUSTOMER-NO,                                   
T34268               :LQ-LOSS-RESERVE-CD,                               
A04110               :LQ-LOSS-RESRVE-EFF-DT,                            
T34268               :AT-ACCOUNT-NO,                                    
T34268               :AT-BILL-CYCLE,                                    
T34268               :AT-DATE-BILL-DAY-00,                              
T34268               :AT-TOTAL-AR-BALANCE,                              
T34268               :AT-CODE-MAJOR-ACCT,                               
T34268               :AT-LOCAL-OFFICE,                                  
T34268               :AT-COMPANY-NO,                                    
T34268               :AT-CREDIT-GROUP                                   
T34268     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34268                                                                  
T34268     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T34268     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34268        NEXT SENTENCE                                             
T34268     ELSE                                                         
T34268         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T34268             MOVE 'Y' TO WS-PROCESS-MSTDONE                       
T34268     ELSE                                                         
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         DISPLAY '* 7210-FETCH-CUST-MISC-CURSOR           *'      
T34268         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
T34268         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T34268         DISPLAY '* PROGRAM ABORTING...                  *'       
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         PERFORM 9900-ABEND              THRU 9900-EXIT           
T34268     END-IF
           END-IF.                                                      
T34268*                                                                 11570000
T34268 7210-EXIT.                                                       
T34268     EXIT.                                                        
T34268                                                                  
T34268******************************************************************11610000
T34268* CLOSE CUST_MISC_CUSSOR                                          11620000
T34268******************************************************************11630000
T34268*                                                                 11640000
T34268 7220-CLOSE-CUST-MAST-CURSOR.                                     
T34268     EXEC SQL                                                     
T34268        CLOSE CUST_MAST_CURSOR                                    
T34268     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34268                                                                  
T34268     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T34268     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34268        NEXT SENTENCE                                             
T34268     ELSE                                                         
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         DISPLAY '* 7220-CLOSE-CUST-MISC-CURSOR           *'      
T34268         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
T34268         DISPLAY '* PROGRAM ABORTING...                  *'       
T34268         DISPLAY '********** PCSCA440 ABORT **************'       
T34268         PERFORM 9900-ABEND              THRU 9900-EXIT           
T34268     END-IF.                                                      
T34268 7220-EXIT.                                                       
T34268     EXIT.                                                        
T34268*                                                                 12330000
                                                                        
      ****************************************************************  12860000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  12870000
      ****************************************************************  12880000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 12920000
      ****************************************************************  12930000
      *  CLOSES  THE INPUT  FILE                                    **  12940000
      ****************************************************************  12950000
      *                                                                 12960000
       9000-TERMINATE.                                                  
      *                                                                 12980000
           CLOSE FCSRP440-FILE                                          
      *                                                                 13090001
           IF  FRP440-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSRP440-FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FRP440-STATUS                 
           END-IF.                                                      
      *                                                                 13160001
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  13190000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *  13200000
      ****************************************************************  13210000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 13230000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                 13530000
      ****************************************************************  13540000
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****   13550000
      ****************************************************************  13560000
           EXEC SQL                                                     13570000
               INCLUDE CPD09900                                         13580000
           END-EXEC.                                                    13590000
