       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA436.                                           
       DATE-WRITTEN.  06/20/03.                                         
       DATE-COMPILED.                                                   
       AUTHOR.         SCANA SERVICES.                                  
      ***************************************************************** 00060000
      **                                                                00070000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00080000
      **                                                             ** 00090000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100000
      ********                   DB2                          ********* 00110000
      ***************************************************************** 00120000
      **                                                             ** 00130000
      **              PROGRAM  MODIFICATION  LOG                     ** 00140000
      **                                                             ** 00150000
      ** DATE       INITIALS       REASON                            ** 00160000
      **                                                             ** 00170000
      ** 06/20/03   KB40308        DEVELOPMENT OF NEW PROGRAM        ** 00180000
T33431** 03/09/06   SK88120        COG PROJECT CHANGES -             ** 00190000
T33431**                           A- ADD NEW COPYBOOKS              ** 00200000
T33431**                           B- CHANGE IN CPD0120B             ** 00210000
C30169** 03/13/08   CVNS           UPDATING AUTO XFER AMT FOR        ** 00220000
C30169**            CHENNAI        AUTO TRANSFER ACTION TYPE IN      ** 00230000
C30169**                           CSS_FIN_WO_ACTION                 ** 00240000
C36956** 11/14/08   SK42147        EPP TO BBP CHANGES.               ** 00241000
C34383** 03/09/09   RC41079        ADDED WORKING STORAGE VARIABLES   ** 00241100
C34383**                           FOR NSA.                          ** 00241200
A00977** 04/02/09   SK42147        FIX FOR WRONG ACCOUNT # IN        ** 00241000
A00977**                           COMMENTS.                         ** 00241000
A37302*  07/15/09   SK42147        REMOVE DCLGEN FOR TBRVCACT        **         
A37302*                                              TBSLSTKT        **         
A37291** 09/18/09   VV94890        CHANGED COMMENTS TO REFLECT THE   ** 00241000
A37291**                           CORRECT COPYBOOK.                 ** 00241000
P00599*  07/31/12   GV7A828        UPDATE FW_PROCESSED_FL TO 'Y' FOR  *         
P00599*                            THE PROCESSED ACCOUNTS             *         
P00627*  09/24/13   RB19957        BACKOUT TO PREVIOUS VERSION.       *         
A04776*  09/28/13   AS7C117        REMOVED UNUSED COPYBOOKS CWS00068  *         
A04776*                            REMOVED UNUSED DCLGENS.            *         
ACT216*  07/01/14   RB19957        FIX ISSUE OF FIELD NOT BEING       *         
ACT216*                            INITILIZED AND SUMM UNBILLED TOTAL *         
ACT216*                            BEING COUNTED TWICE.               *         
A05136*  01/04/16   SV95326        CALL SCSKR125 FOR LETTER GENERATE  *         
A05136*                            PROCESS .                          *         
      ***************************************************************** 00250000
      *                   PCSCA436  NARRATIVE                         * 00260000
      *                                                               * 00270000
      * THIS PROGRAM IS TO BE RUN BEFORE PCSCA132. IT IS THE AUTO     * 00280000
      * XFER MODULE                                                   * 00290000
      ***************************************************************** 00300000
      *                                                                 00310000
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                            00380000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                 00410000
       FILE-CONTROL.                                                    
       COPY CSSFA08.                                                    00430000
      *                                                                 00440000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDFA08.                                                    00470000
       COPY FIOFA08.                                                    00480000
      *                                                                 00490000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA436'.
MSQ017     COPY MFASQLM.
      *                                                                 00510000
       01  WS-SWITCHES.                                                 
           05  WS-FFA08-STATUS                  PIC X(02).              
               88  FA08-SUCCESSFUL                       VALUE '00'.    
           05  WS-END-OF-FILE                  PIC X(01) VALUE 'N'.     
               88  END-OF-FILE                           VALUE 'Y'.     
T25075     05  WS-RECORD-FOUND                 PIC X(01) VALUE 'N'.     
T25075         88  DATA-RECORD-FOUND                     VALUE 'Y'.     
T25075         88  NO-DATA-RECORD-FOUND                  VALUE 'N'.     
           05  WS-BEGIN-REC-SW                 PIC X(01) VALUE 'N'.     
               88  WS-BEGIN-RECS-PROCESSED               VALUE 'Y'.     
           05  WS-DATABASE                     PIC 9(01) VALUE ZERO.    
               88  CSR-DATABASE                          VALUE 1.       
               88  SEB-DATABASE                          VALUE 2.       
           05  WS-JOURNAL-PREPARED             PIC 9(01) VALUE ZERO.    
               88  JRNL-PREPARED                         VALUE 1.       
               88  JRNL-NOTPREPARED                      VALUE 2.       
      *                                                                 00680000
       01  WS-LITERALS.                                                 
           05  WS-D                            PIC X(01) VALUE 'D'.     
           05  WS-E                            PIC X(01) VALUE 'E'.     
           05  WS-F                            PIC X(01) VALUE 'F'.     
           05  WS-G                            PIC X(01) VALUE 'G'.     
           05  WS-J                            PIC X(01) VALUE 'J'.     
           05  WS-N                            PIC X(01) VALUE 'N'.     
           05  WS-R                            PIC X(01) VALUE 'R'.     
           05  WS-U                            PIC X(01) VALUE 'U'.     
           05  WS-Y                            PIC X(01) VALUE 'Y'.     
           05  WS-0                            PIC 9(01) VALUE 0.       
           05  WS-01                           PIC S9(4) USAGE COMP     
                                                         VALUE 1.       
           05  WS-50                           PIC S9(4) USAGE COMP     
                                                         VALUE 50.      
           05  WS-90                           PIC S9(4) USAGE COMP     
                                                         VALUE 90.      
      *                                                                 00860000
       01  WS-VARIABLES.                                                
           05  PROGRAM-NAME                    PIC X(08) VALUE          
                                                         'PCSCA436'.    
           05  WS-PGRMNAME                     PIC X(08) VALUE          
                                                         'PCSCA436'.    
           05  RS-RETURN-CODE                  PIC S9(9) VALUE          
               +000 COMP.                                               
           05  RS-RETURN-CODE-DISP             PIC S9(9) VALUE          
               +000 COMP.                                               
                                                                        
           05  REFORMAT-DATE.                                           
               10  WS-FORMAT-YEAR      PIC X(04).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-MONTH     PIC X(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-FORMAT-DAY       PIC X(02).                       
           05  USA-DATE-FORMAT.                                         
               10  USA-MONTH           PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-DAY             PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '/'.             
               10  USA-YEAR            PIC X(04).                       
                                                                        
           05  WS-FROM-ACCOUNT-NO              PIC  X(13).              
           05  WS-FROM-ACCOUNT-NO-NUM  REDEFINES WS-FROM-ACCOUNT-NO     
                                               PIC  9(13).              
COB305     05 WS-FROM-ACCOUNT-COMP3        PIC S9(13) COMP-3 VALUE 0.       
                                                                        
           05  WS-TO-ACCOUNT-NO                PIC  X(13).              
           05  WS-TO-ACCOUNT-NO-NUM    REDEFINES WS-TO-ACCOUNT-NO       
                                               PIC  9(13).              
COB305     05 WS-TO-ACCOUNT-COMP3        PIC S9(13) COMP-3 VALUE 0.       
                                                                        
A05136*    05  WS-COMMON-DATE                  PIC X(10) VALUE SPACES.  01200000
           05  WS-PROCESS-DATE                 PIC X(10) VALUE SPACES.  
           05  WS-DT-55-DAYS-AGO               PIC X(10) VALUE SPACES.  
           05  WS-DT-85-DAYS-AGO               PIC X(10) VALUE SPACES.  
           05  WS-NULL-IND-00                  PIC S9(04) COMP VALUE 0. 
           05  WS-NULL-IND-30                  PIC S9(04) COMP VALUE 0. 
           05  WS-NULL-IND-60                  PIC S9(04) COMP VALUE 0. 
           05  WS-NULL-IND-90                  PIC S9(04) COMP VALUE 0. 
           05  WS-REVENUE-MTH-NULL-1           PIC S9(04) COMP VALUE +0.
           05  WS-TRAN-APPL-NO                 PIC S9(4) COMP.          
           05  WS-EPP-DELINQ-CD                PIC X(13) VALUE          
                                               'AMT-EPPDELINQ'.         
           05  WS-AMT-EPP-DELINQ-CD            PIC X(14) VALUE          
                                               'AMT-EPPFULLBAL'.        
           05  WS-DPP-DELINQ-CD                PIC X(12) VALUE          
                                               'AMT-DPP-DROP'.          
           05  WS-SAVE-SEL-REC-COUNT           PIC S9(04) COMP VALUE +0.
           05  WS-DATE-ORIG-PYMT-IND           PIC S9(04)    COMP.      
COB305     05 WS-REMAINING-AMT        PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-CURRENT-DATE                 PIC X(10) VALUE SPACES.  
           05  WS-SUB                          PIC S9(04) COMP VALUE +0.
           05 WS-TOT-XFER-AMT                  PIC S9(09)V99 COMP-3     
                                                      VALUE  +0.        
C30169     05 WS-AUTO-TRANS-AMOUNT             PIC S9(09)V99 COMP-3     
                                                      VALUE +0.         
           05 WS-DISP-AMT-XFR                  PIC  9(9)V99.            
           05 WS-DISP-DFA-AMT                  PIC  9(9)V99.            
                                                                        
C30169     05  SCSCB061                   PIC X(08)  VALUE 'SCSCB061'.  
           05  WS-GL-LPC-KEY              PIC X(10) VALUE 'AR-LPC    '. 
           05  WS-GL-LPN-KEY              PIC X(10) VALUE 'AR-LPN    '. 
           05  WS-GL-ELC-KEY              PIC X(10) VALUE 'AR-UTE    '. 
           05  WS-GL-GAS-KEY              PIC X(10) VALUE 'AR-UTG    '. 
           05  WS-GL-EPP-KEY              PIC X(10) VALUE 'AR-BUD    '. 
           05  WS-GL-CCC-KEY              PIC X(10) VALUE 'AR-CCC    '. 
           05  WS-GL-DFA-KEY              PIC X(10) VALUE 'AR-DFA    '. 
           05  WS-GL-DEP-KEY              PIC X(10) VALUE 'AR-DEP    '. 
           05  WS-GL-CNT-KEY              PIC X(10) VALUE 'AR-CNT    '. 
           05  WS-GL-NSA-KEY              PIC X(10) VALUE 'AR-NSA    '. 
           05  WS-GL-NSN-KEY              PIC X(10) VALUE 'AR-NSN    '. 
           05  WS-GL-NSC-KEY              PIC X(10) VALUE 'AR-NSC    '. 
           05  WS-GL-PJS-KEY              PIC X(10) VALUE 'AR-PJS    '. 
           05  WS-GL-CASH-KEY             PIC X(10) VALUE 'ACASH     '. 
           05  WS-ERROR-MSG-1             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-2             PIC X(30) VALUE SPACES.       
           05  WS-ERROR-MSG-3             PIC X(30) VALUE SPACES.       
COB305     05 WS-TOTAL-AR-BALANCE        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
COB305     05 WS-AT-TOTAL-AR-BALANCE        PIC S9(11)V9(2) 
COB305       USAGE COMP-3 VALUE 0. 
A05136     05  SCSKR125                   PIC X(08) VALUE 'SCSKR125'.   
A05136     05  WS-FFA08-FROM-ACCOUNT      PIC X(13) VALUE SPACES.       
A05136     05  WS-AT-CODE-ACCT-STAT       PIC X(01) VALUE SPACES.       
A05136     05  WS-FFA08-REC-DATE          PIC X(10) VALUE SPACES.       
A05136     05  WS-RESTART-COMMIT-COUNTER  PIC 9(04) VALUE ZERO.         
A05136     05  WS-PREV-ACCOUNT-NO         PIC 9(13) VALUE 0.            
COB305     05 WS-LIEN-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.         
COB305     05 WS-AR-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
A05136     05  RS-KR125-RETURN-CODE       PIC S9(04) COMP VALUE 0.      
      **                                                             ** 01650000
                                                                        
           05  WS-SEL-TRANSFER-TABLE.                                   
               10  WS-SEL-TRANSFER-TAB OCCURS 20 TIMES.                 
                   15  WS-SEL-XFER-REC     PIC  X(03).                  
                   15  WS-SEL-XFER-ITEM-ID PIC S9(09) COMP.             
COB305             15 WS-SEL-XFER-AMT        PIC S9(09)V99 COMP-3 
COB305               VALUE 0.        
                   15  WS-SEL-XFER-CHGOFF  PIC  X(01).                  
COB305             15 WS-SEL-XFER-AMT-DEF        PIC S9(09)V99 COMP-3 
COB305               VALUE 0.        
                                                                        
       01  WS-GL-TABLE.                                                 
           05  WS-GL-TABLE-VALUES OCCURS 2000 TIMES.                    
               10  WS-GL-KEY.                                           
                   15  WS-GL-COMPANY      PIC X(02).                    
                   15  WS-GL-LOCAL-OFFICE PIC X(03).                    
                   15  WS-GL-ACCOUNT-NAME PIC X(10).                    
               10  WS-GL-ACCOUNT-NO       PIC 9(3)V9(4).                
       01  WS-GL-SUBSCRIPT                PIC S9(8) COMP.               
      *                                                                 01830000
      *                                                                 01840000
*********************WILLIE'S CODE ****************************         01850000
*********************WILLIE'S CODE START **********************         01860000
COB305 01 WS-25-AMT-XFER        PIC S9(09)V99 COMP-3 VALUE 0.            
       01  WS-25-NBR-DEPOSITS          PIC S9(09) COMP VALUE +0.        
       01  WS-25-FIRST-XFER-ID-FROM    PIC X(09).                       
       01  WS-25-FIRST-XFER-ID-TO      PIC X(09).                       
       01  WS-25-DEP-STAT-CD           PIC X(01).                       
       01  WS-25-CODE-REFUND-STATUS    PIC X(01).                       
T21158 01  WS-AR-ROW-COUNT             PIC  S9(04) COMP-3 VALUE 0.      
       01  WS-25-NULL-IND17            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND18            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND19            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND20            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND21            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND22            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND23            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND24            PIC S9(04) COMP VALUE +0.        
       01  WS-25-NULL-IND25            PIC S9(04) COMP VALUE +0.        
       01  WS-NULL-INDICATOR           PIC S9(04) COMP VALUE +0.        
       01  WS-25-SHARE-STATUS-CD       PIC  X(01)  VALUE SPACES.        
C34383 01  WS-25-PREV-TS               PIC  X(01)  VALUE SPACES.        
C34383 01  WS-25-OTHER-RECIEVABLE      PIC  X(01)  VALUE SPACES.        
C34383 01  WS-25-FIRST-AFTER-NSA       PIC  X(01)  VALUE SPACES.        
COB305 01 WS-25-CCC-CREDIT-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.         
C34383 01  WS-25-PREV-TIMESTAMP        PIC X(26) VALUE  SPACES.         
COB305 01 WS-25-AMT-ORIG-ENTERED        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305 01 WS-25-BILLED-UNPAID        PIC S9(09)V99 COMP-3 VALUE 0.            
C34383 01  WS-HOLD-25-TIMESTAMP        PIC X(26) VALUE  SPACES.         
C34383 01  WS-HOLD-25-TRAN-APPL-NO     PIC S9(03) COMP VALUE +0.        
       01  WS-120-CIA-AMOUNT           PIC S9(09)V99 COMP-3             
                                                           VALUE +0.    
       01  WS-120-CIA-EXISTS           PIC X(01) VALUE 'N'.             
       01  WS-120-JRNL-WRITTEN         PIC X(01) VALUE 'N'.             
       01  WS-120-CALC-TOTALS          PIC X(01) VALUE 'N'.             
       01  WS-PROCESS-AUTO-XFER        PIC X(01) VALUE 'N'.             
       01  WS-120-AMT-BALANCE          PIC S9(09)V99 COMP-3             
                                                            VALUE 0.    
       01  WS-120-TRAN-COMMENT-TO.                                      
           05  FILLER                  PIC X(12) VALUE                  
                                           'TRANSFER TO '.              
           05  WS-25-TRAN-CMT-ACCT-TO  PIC 9(13).                       
       01  WS-120-TRAN-COMMENT-FROM.                                    
           05  FILLER                  PIC X(14) VALUE                  
                                            'TRANSFER FROM '.           
           05  WS-25-TRAN-CMT-ACCT-FR  PIC 9(13).                       
       01  WS-120-SUM-TOT-SUMM-UNBILLED PIC S9(09)V99 COMP-3            
                                                        VALUE 0.        
       01  WS-120-DFA-BALANCE          PIC S9(09)V99 COMP-3             
                                                            VALUE 0.    
       01  WS-TEMP-AR-CNTL-AREA.                                        
           05  WS-TEMP-00-DAY            PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TEMP-30-DAY            PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TEMP-60-DAY            PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TEMP-90-DAY            PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TEMP-TRAN-BALANCE      PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-TEMP-ITEM-ID           PIC S9(09) COMP.               
           05  WS-TEMP-PYMT-PRIORITY-LVL PIC S9(04) COMP                
                                                           VALUE +0.    
                                                                        
       01  WS-EPP-BREAKDOWN-DONE            PIC X(01) VALUE 'N'.        
T15651 01  WS-ALL-PROCESSED                 PIC X(01) VALUE 'N'.        
T15651     88  ALL-PROCESS                            VALUE 'Y'.        
T15651     88  ALL-PROCESS-ENDED                      VALUE 'N'.        
T15651 01  WS-CNT-PROCESSED                 PIC X(01) VALUE 'N'.        
T15651     88  CONTRACT-PROCESS                       VALUE 'Y'.        
T15651     88  CONTRACT-PROCESS-ENDED                 VALUE 'N'.        
T15651 01  WS-DEP-PROCESSED                 PIC X(01) VALUE 'N'.        
T15651     88  DEPOSIT-PROCESS                        VALUE 'Y'.        
T15651     88  DEPOSIT-PROCESS-ENDED                  VALUE 'N'.        
T15651 01  WS-PJS-PROCESSED                 PIC X(01) VALUE 'N'.        
T15651     88  PJS-PROCESS                            VALUE 'Y'.        
T15651     88  PJS-PROCESS-ENDED                      VALUE 'N'.        
       01  WS-DFA-XFER-IND                  PIC X(01) VALUE 'N'.        
           88  TRANSFER-AS-DFA                        VALUE 'Y'.        
       01  WS-DFA-XFER-IND-WO               PIC X(01) VALUE 'N'.        
           88  TRANSFER-AS-DFA-WO                     VALUE 'Y'.        
       01  WS-CNT-XFER-IND                  PIC X(01) VALUE 'N'.        
           88  TRANSFER-CONTRACT                      VALUE 'Y'.        
       01  WS-CNT-XFER-IND-WO               PIC X(01) VALUE 'N'.        
           88  TRANSFER-CONTRACT-WO                   VALUE 'Y'.        
       01  WS-TRANSFER-ALL-WO               PIC X(01) VALUE 'N'.        
           88  TRANSFER-ALL-WO                        VALUE 'Y'.        
       01  WS-25-TO-HAS-PJS               PIC X(01) VALUE 'N'.          
           88  TO-HAS-PJS                           VALUE 'Y'.          
           88  TO-HAS-NO-PJS                        VALUE 'N'.          
       01  WS-25-TRANSFER-TYPE-STM        PIC X(01) VALUE 'N'.          
           88  TRANSFER-STM                         VALUE 'Y'.          
       01  WS-DEP-XFER-IND                  PIC X(01) VALUE 'N'.        
           88  TRANSFER-DEPOSIT                       VALUE 'Y'.        
       01  WS-SO-CNTR-XFER-TB.                                          
           05 WS-SO-CNTR-XFER-LIST                                      
               OCCURS 20 TIMES INDEXED BY WS-CNTX.                      
               10  WS-CNTR-ITEM-ID          PIC X(09).                  
               10  WS-CNTR-ITEM-ID-NUM      REDEFINES WS-CNTR-ITEM-ID   
                                            PIC 9(09).                  
       01  WS-SO066-KTB.                                                
           05  WS-25-TRAN-COMMENTS.                                     
               10  FILLER                     PIC X(12) VALUE           
                                              'TRANSFERRED '.           
               10  WS-25-TRAN-CMT-AMT         PIC $$$$$$$$$.99.         
               10  FILLER                     PIC X(15) VALUE           
                                              ' FROM ACCOUNT: '.        
               10  FILLER                     PIC X(13) VALUE           
                                              ' TO ACCOUNT: '.          
           05  WS-25-TOTAL-AMT-TRAN-BAL     PIC S9(7)V99 COMP-3 VALUE 0.
           05  WS-25-AR-BILLED-UNPAID       PIC S9(7)V99 COMP-3 VALUE 0.
           05  WS-25-CUST-NO-FROM           PIC S9(10)V COMP-3 VALUE 0. 
           05  WS-25-CUST-NO-TO             PIC S9(10)V COMP-3 VALUE 0. 
           05  WS-DEPOSIT-XFER-IND          PIC X(01).                  
           05  WS-OTHER-AR-XFER-IND         PIC X(01).                  
           05  WS-PROJ-SHR-XFER-IND         PIC X(01).                  
           05  WS-IN-LIEU-XFER-IND          PIC X(01).                  
           05  WS-ROOMMATE-XFER-IND         PIC X(01).                  
           05  WS-COAPPL-XFER-IND           PIC X(01).                  
           05  WS-MED-CERT-XFER-IND         PIC X(01).                  
           05  WS-WHT-CROSS-XFER-IND        PIC X(01).                  
           05  WS-EPP-XFER-IND              PIC X(01).                  
C21838 01  WS-BPI-CONTRACT-FL               PIC X(01) VALUE 'N'.        
C21838         88  BPI-CONTRACT                         VALUE 'Y'.      
C21838         88  NON-BPI-CONTRACT                     VALUE 'N'.      
C21838 01  WS-BPI-ITEM-ID                   PIC Z(08)9.                 
C26675 01  WS-TEMP-25-APPL-NO               PIC S9(3) COMP-3 VALUE +0.  
C26675 01  WS-DEP-FIRST-TIME-SW             PIC X(01) VALUE 'Y'.        
C26675       88 DEP-AR-FIRST-TIME              VALUE 'Y'.               
C26675       88 DEP-AR-NOT-FIRST-TIME          VALUE 'N'.               
C26675 01  WS-TEMP-AU-APPL-NO               PIC S9(4) COMP   VALUE +0.  
C26675 01  WS-TEMP-100-APPL-NO              PIC S9(3) COMP-3 VALUE +0.  
C26675 01  WS-DEP-AR-APPL                   PIC S9(3) COMP-3 VALUE +0.  
C26675 01  WS-TEMP-TIMESTAMP                PIC X(26) VALUE  SPACES.    
C26675 01  WS-DEP-TIMESTAMP                 PIC X(26) VALUE  SPACES.    
C26675 01  WS-AR-DEPOSIT-ONLY               PIC X(01) VALUE  'N'.       
C26675       88 AR-DEPOSIT-ONLY               VALUE 'Y'.                
C26675       88 NOT-AR-DEPOSIT-ONLY           VALUE 'N'.                
C26675 01  WS-AR-DEP-TRAN-BALANCE           PIC X(01) VALUE  'N'.       
C26675       88 AR-DEP-TRAN-BALANCE           VALUE 'Y'.                
C26675       88 NOT-AR-DEP-TRAN-BALANCE       VALUE 'N'.                
       01  WS-AC-AMT-TRAN-BALANCE           PIC S9(09)V99   COMP-3      
                                                         VALUE +0.      
       01  WS-AMT-POSTED                    PIC S9(09)V99   COMP-3      
                                                         VALUE +0.      
       01  CMN-CASH-DRAWER.                                             
             05  CMN-CD-COMPANY-NO           PIC X(02).                 
             05  CMN-CD-LOCAL-OFFICE         PIC X(03).                 
             05  CMN-CD-REPORT-NO            PIC X(03).                 
             05  CMN-CD-REPORT-DATE          PIC X(10).                 
             05  CMN-CASH-DRAWER-ID          PIC S9(04) COMP.           
       01  CMN-TODAYS-DATE                   PIC X(10).                 
T33431 01  SCSCB225                          PIC X(8) VALUE 'SCSCB225'. 
C21838 01  WS-PROG-CLOSE-CONTRACT            PIC  X(08) VALUE           
C21838                                         'PCSCA436'.              
C21838 01  WS-STATUS-CODE                    PIC  X(11) VALUE           
C21838                                        'STATUS CODE'.            
T21158 01  WS-PROGRAM-TIMESTAMP    PIC X(26) VALUE SPACES.              
*********************WILLIE'S CODE ****************************         03300000
*********************WILLIE'S CODE END   **********************         03310000
      ***************************************************************** 03320000
      * SUPPORTS PAYMENT ROUTINE (CPD00010).                            03330000
           EXEC SQL                                                     03340000
              INCLUDE CWS00017                                          03350000
           END-EXEC.                                                    03360000
      *                                                                 03370000
      ***************************************************************** 03380000
      * WORKING STORAGE COPYBOOK FOR CPD00309                           03390000
      ***************************************************************** 03400000
           EXEC SQL                                                     03410000
              INCLUDE CWS00309                                          03420000
           END-EXEC.                                                    03430000
                                                                        
      *                                                                 03450000
           EXEC SQL                                                             
              INCLUDE CWS00025                                                  
           END-EXEC.                                                            
      *                                                                 03460000
      ***************************************************************** 03550000
      * WORKING STORAGE COPYBOOK                                        03560000
      ***************************************************************** 03570000
           EXEC SQL                                                     03580000
              INCLUDE CJF00103                                          03590000
           END-EXEC.                                                    03600000
                                                                        
      ***************************************************************** 03620000
      * WORKING STORAGE COPYBOOK FOR JOURNALLING                        03630000
      ***************************************************************** 03640000
           EXEC SQL                                                     03650000
              INCLUDE CWS00061                                          03660000
           END-EXEC.                                                    03670000
                                                                        
      ***************************************************************** 03690000
A37291* WORKING STORAGE COPYBOOK FOR CPD0078B                           03700000
      ***************************************************************** 03710000
           EXEC SQL                                                     03720000
              INCLUDE CWS00078                                          03730000
           END-EXEC.                                                    03740000
                                                                        
      ***************************************************************** 03760000
      * WORKING STORAGE COPYBOOK FOR CODES DATA PRESENT.                03770000
      ***************************************************************** 03780000
           EXEC SQL                                                     03790000
                INCLUDE CWS00056                                        03800000
           END-EXEC.                                                    03810000
A05136******* CORRESP NOTICE VARIABLES************                      02431004
A05136     EXEC SQL                                                     03790000
A05136          INCLUDE CWS00341                                        03800000
A05136     END-EXEC.                                                    03810000
                                                                        
A05136******************************************************************        
A05136* VARIABLES NEEDED FOR NOTICE PROCESSING                         *        
A05136******************************************************************        
A05136                                                                  
A05136     EXEC SQL                                                             
A05136        INCLUDE CWS00350                                                  
A05136     END-EXEC.                                                            
A05136                                                                  
      ***************************************************************** 03820000
      **      APPLICATION  TABLE DCLGENS                             ** 03830000
      ***************************************************************** 03840000
           EXEC SQL                                                     03850000
               INCLUDE SQLCA                                            03860000
           END-EXEC.                                                    03870000
      **                                                                03880000
      ***************************************************************** 03890000
      *    CSS_DELINQUENCY.                                             03900000
      ***************************************************************** 03910000
           EXEC SQL                                                     03920000
             INCLUDE TBDELQ                                             03930000
           END-EXEC.                                                    03940000
      *                                                                 03950000
      ***************************************************************** 03960000
      *    CSS_AR_CNTL                                                  03970000
      ***************************************************************** 03980000
           EXEC SQL                                                     03990000
             INCLUDE TBARCNTL                                           04000000
           END-EXEC.                                                    04010000
      *                                                                 04020000
      ***************************************************************** 04030000
      *    CSS_BILL_WINDOW                                              04040000
      ***************************************************************** 04050000
           EXEC SQL                                                     04060000
             INCLUDE TBBILWDW                                           04070000
           END-EXEC.                                                    04080000
      *                                                                 04090000
      *                                                                 04100000
*********************WILLIE'S CODE ****************************         04110000
*********************WILLIE'S CODE START **********************         04120000
      *                                                                 04130000
      ***************************************************************** 04140000
      * CSS_DEP_ON_HAND                                                 04150000
      ***************************************************************** 04160000
           EXEC SQL                                                     04170000
              INCLUDE TBDEPHND                                          04180000
           END-EXEC.                                                    04190000
      *                                                                 04200000
      ***************************************************************** 04210000
      ***************************************************************** 04220000
      * CSS_DEP_PAY_HST                                                 04230000
      ***************************************************************** 04240000
           EXEC SQL                                                     04250000
              INCLUDE TBDEPHST                                          04260000
           END-EXEC.                                                    04270000
      *                                                                 04280000
      ***************************************************************** 04290000
      ***************************************************************** 04300000
      * CSS_INTEREST_HIST                                               04310000
      ***************************************************************** 04320000
           EXEC SQL                                                     04330000
              INCLUDE TBINTHST                                          04340000
           END-EXEC.                                                    04350000
      *                                                                 04360000
      ***************************************************************** 04370000
      ***************************************************************** 04380000
      * CSS_PROJ_SHARE                                                  04390000
      ***************************************************************** 04400000
           EXEC SQL                                                     04410000
              INCLUDE TBPRJSHR                                          04420000
           END-EXEC.                                                    04430000
      *                                                                 04440000
      ***************************************************************** 04700000
      * CSS_DEP_REQ                                                     04710000
      ***************************************************************** 04720000
           EXEC SQL                                                     04730000
              INCLUDE TBDEPREQ                                          04740000
           END-EXEC.                                                    04750000
      *                                                                 04760000
      ***************************************************************** 04770000
      ***************************************************************** 04780000
      * CSS_MNT_TRANS_HIST                                              04790000
      ***************************************************************** 04800000
           EXEC SQL                                                     04810000
              INCLUDE TBMNHIST                                          04820000
           END-EXEC.                                                    04830000
      *                                                                 04840000
      ***************************************************************** 04850000
      * CSS_MT_TRN_HST_DET                                              04860000
      ***************************************************************** 04870000
           EXEC SQL                                                     04880000
              INCLUDE TBMNHDT                                           04890000
           END-EXEC.                                                    04900000
      *                                                                 04910000
*********************WILLIE'S CODE ****************************         04920000
*********************WILLIE'S CODE END   **********************         04930000
      ***************************************************************** 04940000
      *    CSS_AR_TYPE                                                  04950000
      ***************************************************************** 04960000
           EXEC SQL                                                     04970000
              INCLUDE TBARTYPE                                          04980000
           END-EXEC.                                                    04990000
                                                                        
      ***************************************************************** 05010000
      *    CSS_JOB-PARM.                                                05020000
      ***************************************************************** 05030000
           EXEC SQL                                                     05040000
             INCLUDE TBJBPARM                                           05050000
           END-EXEC.                                                    05060000
      *                                                                 05070000
      ***************************************************************** 05080000
      *    CSS_ACCOUNT                                                  05090000
      ***************************************************************** 05100000
           EXEC SQL                                                     05110000
             INCLUDE TBACCT                                             05120000
           END-EXEC.                                                    05130000
      *                                                                 05140000
      ***************************************************************** 05150000
      *  CSS_BUDGET_PLAN                                                05160000
      ***************************************************************** 05170000
           EXEC SQL                                                     05180000
               INCLUDE TBBGTPLN                                         05190000
           END-EXEC.                                                    05200000
      *                                                                 05280000
      ***************************************************************** 05290000
      * CSS_LOCAL_OFFICE                                                05300000
      ***************************************************************** 05310000
           EXEC SQL                                                     05320000
              INCLUDE TBLOCOFC                                          05330000
           END-EXEC.                                                    05340000
      *                                                                 05420000
      ***************************************************************** 05430000
      * CSS_USER_PROFILE                                                05440000
      ***************************************************************** 05450000
           EXEC SQL                                                     05460000
              INCLUDE TBUSRPRF                                          05470000
           END-EXEC.                                                    05480000
      *                                                                 05490000
      ***************************************************************** 05500000
      * CSS_AR_TRANS_HIST                                               05510000
      ***************************************************************** 05520000
           EXEC SQL                                                     05530000
              INCLUDE TBARHIST                                          05540000
           END-EXEC.                                                    05550000
      *                                                                 05560000
      ***************************************************************** 05570000
      * CSS_AR_TRN_HST_DET                                              05580000
      ***************************************************************** 05590000
           EXEC SQL                                                     05600000
              INCLUDE TBARHDT                                           05610000
           END-EXEC.                                                    05620000
      *                                                                 05630000
      ***************************************************************** 05640000
      * CSS_CUSTOMER                                                    05650000
      ***************************************************************** 05660000
           EXEC SQL                                                     05670000
              INCLUDE TBCUST                                            05680000
           END-EXEC.                                                    05690000
      *                                                                 05700000
      ***************************************************************** 05710000
      * CSS_PREMISE                                                     05720000
      ***************************************************************** 05730000
           EXEC SQL                                                     05740000
              INCLUDE TBPREM                                            05750000
           END-EXEC.                                                    05760000
      *                                                                 05910000
      ***************************************************************** 05920000
      * CSS_BCH_JRNL_CNTL                                               05930000
      ***************************************************************** 05940000
           EXEC SQL                                                     05950000
              INCLUDE TBBJCNTL                                          05960000
           END-EXEC.                                                    05970000
      *                                                                 06050000
      ***************************************************************** 06060000
      * CSS_BATCH_JRNL                                                  06070000
      ***************************************************************** 06080000
           EXEC SQL                                                     06090000
              INCLUDE TBBTJRNL                                          06100000
           END-EXEC.                                                    06110000
      *                                                                 06190000
      ***************************************************************** 06200000
      * CSS_MISC_JRNL                                                   06210000
      ***************************************************************** 06220000
           EXEC SQL                                                     06230000
              INCLUDE TBMSJRNL                                          06240000
           END-EXEC.                                                    06250000
      *                                                                 06340000
           EXEC SQL                                                     06350000
              INCLUDE TBCNTDET                                          06360000
           END-EXEC.                                                    06370000
      *                                                                 06380000
           EXEC SQL                                                     06390000
              INCLUDE TBCNTRCT                                          06400000
           END-EXEC.                                                    06410000
      *                                                                 06460000
           EXEC SQL                                                     06470000
              INCLUDE TBRCNCHR                                          06480000
           END-EXEC.                                                    06490000
      *                                                                 06500000
           EXEC SQL                                                     06510000
              INCLUDE TBDFAACT                                          06520000
           END-EXEC.                                                    06530000
      *                                                                 06540000
           EXEC SQL                                                     06550000
              INCLUDE TBDFARCV                                          06560000
           END-EXEC.                                                    06570000
      *                                                                 06620000
           EXEC SQL                                                     06630000
              INCLUDE TBCCCHRG                                          06640000
           END-EXEC.                                                    06650000
      ******************************************************************06710000
      *    CSS_GL_ACCOUNT                                               06720000
      ******************************************************************06730000
                                                                        
           EXEC SQL                                                     06750000
               INCLUDE TBGLACCT                                         06760000
           END-EXEC.                                                    06770000
      ******************************************************************06780000
      *    CSS_GL_ACCT_NO                                               06790000
      ******************************************************************06800000
                                                                        
           EXEC SQL                                                     06820000
               INCLUDE TBGLATNO                                         06830000
           END-EXEC.                                                    06840000
      ***************************************************************** 06850000
      * SUPPORTS COMMON JOURNALING.                                     06860000
           EXEC SQL                                                     06870000
              INCLUDE CWS00013                                          06880000
           END-EXEC.                                                    06890000
C30169***************************************************************** 07010000
C30169* KD - CSS_FIN_WO_ACTION                                          07020000
C30169***************************************************************** 07030000
C30169     EXEC SQL                                                     07040000
C30169        INCLUDE TBFWACTN                                          07050000
C30169     END-EXEC.                                                    07060000
      ***************************************************************** 07070000
      * CSS_CHRG_OFF                                                    07080000
      ***************************************************************** 07090000
           EXEC SQL                                                     07100000
              INCLUDE TBCHGOFF                                          07110000
           END-EXEC.                                                    07120000
      *                                                                 07310000
       COPY CJF00101.                                                   07320000
       COPY FIOJC01.                                                    07340000
       COPY FIOCA00.                                                    07350000
T33431 COPY CWSCA225.                                                   07360000
      *                                                                 07370000
       COPY CWS00039.                                                   07380000
       COPY CWS00038.                                                   07390000
       COPY CWS0070B.                                                   07410000
       COPY CWS00303.                                                   07420000
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                07430000
                                                                        
      *  ABEND SWITCH COPYBOOK                                          07450000
       COPY CWS09900.                                                   07460000
      *                                                                 07470000
      * -- USED BY CPD0303B                                             07480000
      * WS ABEND WORK AREA                                              07490000
       COPY CWS00010.                                                   07500000
      *                                                                 07510000
      ******************************************************************07520000
      * CURSOR DECLARATIONS                                             07530000
      ******************************************************************07540000
      *                                                                 07550000
           EXEC SQL                                                     
               DECLARE AR_CNTRL_CURSOR CURSOR FOR                       
                 SELECT PYMT_PRIORITY_LVL,                              
                        ITEM_ID,                                        
                        AMT_AR_DAY_00,                                  
                        AMT_AR_DAY_30,                                  
                        AMT_AR_DAY_60,                                  
                        AMT_AR_DAY_90,                                  
                        AMT_TRAN_BALANCE,                               
                        AMT_UNUSED_CR,                                  
                        TOT_SUMM_UNBILLED,                              
                        REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   FROM CSS_AR_CNTL                                     
                  WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             
                  AND ( PYMT_PRIORITY_LVL = 40                          
                  OR    PYMT_PRIORITY_LVL = 45                          
                  OR    PYMT_PRIORITY_LVL = 30 )                        
                  AND   ITEM_ID            = :AC-ITEM-ID                
                  AND   (AMT_AR_DAY_00   > 0                            
                  OR     AMT_AR_DAY_30   > 0                            
                  OR     AMT_AR_DAY_60   > 0                            
                  OR     AMT_AR_DAY_90   > 0 )                          
               ORDER BY PYMT_PRIORITY_LVL ASC,                          
                        ITEM_ID ASC                                     
               FOR READ ONLY                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07560000
MFA-TR*        DECLARE AR_CNTRL_CURSOR CURSOR FOR                       07570000
MFA-TR*          SELECT PYMT_PRIORITY_LVL,                              07580000
MFA-TR*                 ITEM_ID,                                        07590000
MFA-TR*                 AMT_AR_DAY_00,                                  07600000
MFA-TR*                 AMT_AR_DAY_30,                                  07610000
MFA-TR*                 AMT_AR_DAY_60,                                  07620000
MFA-TR*                 AMT_AR_DAY_90,                                  07630000
MFA-TR*                 AMT_TRAN_BALANCE,                               07640000
MFA-TR*                 AMT_UNUSED_CR,                                  07650000
MFA-TR*                 TOT_SUMM_UNBILLED,                              07660000
MFA-TR*                 LAST_UPDATE_TS                                  07670000
MFA-TR*            FROM CSS_AR_CNTL                                     07680000
MFA-TR*           WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             07690000
MFA-TR*           AND ( PYMT_PRIORITY_LVL = 40                          07700000
MFA-TR*           OR    PYMT_PRIORITY_LVL = 45                          07710000
MFA-TR*           OR    PYMT_PRIORITY_LVL = 30 )                        07720000
MFA-TR*           AND   ITEM_ID            = :AC-ITEM-ID                07730000
MFA-TR*           AND   (AMT_AR_DAY_00   > 0                            07740000
MFA-TR*           OR     AMT_AR_DAY_30   > 0                            07750000
MFA-TR*           OR     AMT_AR_DAY_60   > 0                            07760000
MFA-TR*           OR     AMT_AR_DAY_90   > 0 )                          07770000
MFA-TR*        ORDER BY PYMT_PRIORITY_LVL ASC,                          07780000
MFA-TR*                 ITEM_ID ASC                                     07790000
MFA-TR*        FOR FETCH ONLY                                           07800000
MFA-TR*    END-EXEC.                                                    07810000
                                                                        
      *                                                                 07830000
           EXEC SQL                                                     
               DECLARE AR_CNTRL_ALLXFER CURSOR FOR                      
                 SELECT PYMT_PRIORITY_LVL,                              
                        ITEM_ID,                                        
                        AMT_AR_DAY_00,                                  
                        AMT_AR_DAY_30,                                  
                        AMT_AR_DAY_60,                                  
                        AMT_AR_DAY_90,                                  
                        AMT_TRAN_BALANCE,                               
                        AMT_UNUSED_CR,                                  
                        TOT_SUMM_UNBILLED,                              
                        REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   FROM CSS_AR_CNTL                                     
                  WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             
                  AND   ITEM_ID           >= :AC-ITEM-ID                
                  AND PYMT_PRIORITY_LVL NOT IN ( 30, 40, 45,50,70,80,90,
                                                100,129)                
               ORDER BY PYMT_PRIORITY_LVL ASC,                          
                        ITEM_ID ASC                                     
               FOR READ ONLY                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07840000
MFA-TR*        DECLARE AR_CNTRL_ALLXFER CURSOR FOR                      07850000
MFA-TR*          SELECT PYMT_PRIORITY_LVL,                              07860000
MFA-TR*                 ITEM_ID,                                        07870000
MFA-TR*                 AMT_AR_DAY_00,                                  07880000
MFA-TR*                 AMT_AR_DAY_30,                                  07890000
MFA-TR*                 AMT_AR_DAY_60,                                  07900000
MFA-TR*                 AMT_AR_DAY_90,                                  07910000
MFA-TR*                 AMT_TRAN_BALANCE,                               07920000
MFA-TR*                 AMT_UNUSED_CR,                                  07930000
MFA-TR*                 TOT_SUMM_UNBILLED,                              07940000
MFA-TR*                 LAST_UPDATE_TS                                  07950000
MFA-TR*            FROM CSS_AR_CNTL                                     07960000
MFA-TR*           WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO             07970000
MFA-TR*           AND   ITEM_ID           >= :AC-ITEM-ID                07980000
MFA-TR*           AND PYMT_PRIORITY_LVL NOT IN ( 30, 40, 45,50,70,80,90,07990000
MFA-TR*                                         100,129)                08000000
MFA-TR*        ORDER BY PYMT_PRIORITY_LVL ASC,                          08010000
MFA-TR*                 ITEM_ID ASC                                     08020000
MFA-TR*        FOR FETCH ONLY                                           08030000
MFA-TR*    END-EXEC.                                                    08040000
                                                                        
      *                                                                 08060000
           EXEC SQL                                                     
               DECLARE CHRG_OFF CURSOR FOR                              
                   SELECT PYMT_PRIORITY_LVL,                            
                          ITEM_ID,                                      
                          AMT_TRANS                                     
                   FROM CSS_CHRG_OFF                                    
                   WHERE  ACCOUNT_NO         =  :CO-ACCOUNT-NO          
                   AND ( PYMT_PRIORITY_LVL = 40                         
                   OR    PYMT_PRIORITY_LVL = 45                         
                   OR    PYMT_PRIORITY_LVL = 30 )                       
                   AND    ITEM_ID           >=  :CO-ITEM-ID             
                   AND    AMT_TRANS          > 0                        
                   ORDER BY PYMT_PRIORITY_LVL ASC,                      
                            ITEM_ID ASC                                 
               FOR READ ONLY                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     08070000
MFA-TR*        DECLARE CHRG_OFF CURSOR FOR                              08080000
MFA-TR*            SELECT PYMT_PRIORITY_LVL,                            08090000
MFA-TR*                   ITEM_ID,                                      08100000
MFA-TR*                   AMT_TRANS                                     08110000
MFA-TR*            FROM CSS_CHRG_OFF                                    08120000
MFA-TR*            WHERE  ACCOUNT_NO         =  :CO-ACCOUNT-NO          08130000
MFA-TR*            AND ( PYMT_PRIORITY_LVL = 40                         08140000
MFA-TR*            OR    PYMT_PRIORITY_LVL = 45                         08150000
MFA-TR*            OR    PYMT_PRIORITY_LVL = 30 )                       08160000
MFA-TR*            AND    ITEM_ID           >=  :CO-ITEM-ID             08170000
MFA-TR*            AND    AMT_TRANS          > 0                        08180000
MFA-TR*            ORDER BY PYMT_PRIORITY_LVL ASC,                      08190000
MFA-TR*                     ITEM_ID ASC                                 08200000
MFA-TR*        FOR FETCH ONLY                                           08210000
MFA-TR*    END-EXEC.                                                    08220000
                                                                        
           EXEC SQL                                                     
               DECLARE CHRG_OFF_ALLXFER CURSOR FOR                      
                 SELECT PYMT_PRIORITY_LVL,                              
                        ITEM_ID,                                        
                        AMT_TRANS,                                      
T33431                  DATE_OF_CHG_OFF                                 
                   FROM CSS_CHRG_OFF                                    
                  WHERE ACCOUNT_NO         = :CO-ACCOUNT-NO             
                  AND   ITEM_ID           >= :CO-ITEM-ID                
                  AND    AMT_TRANS        > 0                           
                  AND PYMT_PRIORITY_LVL NOT IN ( 30, 40, 45,50,70,80,90,
                                                100,129)                
               ORDER BY PYMT_PRIORITY_LVL ASC,                          
                        ITEM_ID ASC                                     
               FOR READ ONLY                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     08240000
MFA-TR*        DECLARE CHRG_OFF_ALLXFER CURSOR FOR                      08250000
MFA-TR*          SELECT PYMT_PRIORITY_LVL,                              08260000
MFA-TR*                 ITEM_ID,                                        08270000
MFA-TR*                 AMT_TRANS,                                      08280000
MFA-TR*                 DATE_OF_CHG_OFF                                 08290000
MFA-TR*            FROM CSS_CHRG_OFF                                    08300000
MFA-TR*           WHERE ACCOUNT_NO         = :CO-ACCOUNT-NO             08310000
MFA-TR*           AND   ITEM_ID           >= :CO-ITEM-ID                08320000
MFA-TR*           AND    AMT_TRANS        > 0                           08330000
MFA-TR*           AND PYMT_PRIORITY_LVL NOT IN ( 30, 40, 45,50,70,80,90,08340000
MFA-TR*                                         100,129)                08350000
MFA-TR*        ORDER BY PYMT_PRIORITY_LVL ASC,                          08360000
MFA-TR*                 ITEM_ID ASC                                     08370000
MFA-TR*        FOR FETCH ONLY                                           08380000
MFA-TR*    END-EXEC.                                                    08390000
                                                                        
                                                                        
      ******************************************************************08420000
      *    DECLARE GL ACCT-NO CURSOR *                                  08430000
      ******************************************************************08440000
      * CHANGED CURSOR TO WITH HOLD FOR COMMIT LOGIC                   *08450000
      *                                                                *08460000
           EXEC SQL                                                     
               DECLARE GL_NBRS CURSOR WITH HOLD FOR                     
                SELECT  A.COMPANY_NO,                                   
                        A.GL_ACCT_NO,                                   
                        B.LOCAL_OFFICE                                  
                FROM    CSS_GL_ACCT_NO A,                               
                        CSS_GL_ACCOUNT B                                
                WHERE   A.GL_ACCT_NAME = :GO-GL-ACCT-NAME               
                  AND   A.GL_ACCT_NO   = B.GL_ACCT_NO                   
                  AND   A.COMPANY_NO   = '01'                           
                FOR READ ONLY                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR*    EXEC SQL                                                     08470000
MFA-TR*        DECLARE GL_NBRS CURSOR WITH HOLD FOR                     08480000
MFA-TR*         SELECT  A.COMPANY_NO,                                   08490000
MFA-TR*                 A.GL_ACCT_NO,                                   08500000
MFA-TR*                 B.LOCAL_OFFICE                                  08510000
MFA-TR*         FROM    CSS_GL_ACCT_NO A,                               08520000
MFA-TR*                 CSS_GL_ACCOUNT B                                08530000
MFA-TR*         WHERE   A.GL_ACCT_NAME = :GO-GL-ACCT-NAME               08540000
MFA-TR*           AND   A.GL_ACCT_NO   = B.GL_ACCT_NO                   08550000
MFA-TR*           AND   A.COMPANY_NO   = '01'                           08560000
MFA-TR*         FOR FETCH ONLY                                          08570000
MFA-TR*    END-EXEC.                                                    08580000
A05136******************************************************************07350000
A05136* DECLARE AR_TRANS_CURSOR                                        *07360000
A05136******************************************************************07370000
A05136     EXEC SQL                                                     
A05136         DECLARE AR_TRANS_CURSOR CURSOR FOR                       
A05136           SELECT AMT_ORIG_ENTERED                                
A05136             FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                 
A05136            WHERE ACCOUNT_NO        = :WS-AR-ACCOUNT-NO           
C05136            AND   APPL_PROGRAM_ID   = 'PCSCA436'                  
A05136            AND   CODE_TRAN_TYPE    = 'T'                         
A05136            AND   CIS.SUBSTR3(TRAN_COMMENT,15,13)                      
A05136                                    = :WS-FFA08-FROM-ACCOUNT      
A05136            AND   DATE_TRANS        >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-FFA08-REC-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FFA08-REC-DATE
              ) <> 0) OR (LEN(:WS-FFA08-REC-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-FFA08-REC-DATE
              ), CONVERT(DATE, :WS-FFA08-REC-DATE) )         
A05136         FOR READ ONLY                                           
A05136                                                           
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        DECLARE AR_TRANS_CURSOR CURSOR FOR                       07400004
MFA-TR*          SELECT AMT_ORIG_ENTERED                                07410004
MFA-TR*            FROM CSS_AR_TRANS_HIST                               07420004
MFA-TR*           WHERE ACCOUNT_NO        = :WS-AR-ACCOUNT-NO           07430004
MFA-TR*           AND   APPL_PROGRAM_ID   = 'PCSCA436'                  07440004
MFA-TR*           AND   CODE_TRAN_TYPE    = 'T'                         07450004
MFA-TR*           AND   SUBSTR(TRAN_COMMENT,15,13)                              
MFA-TR*                                   = :WS-FFA08-FROM-ACCOUNT              
MFA-TR*           AND   DATE_TRANS        >= :WS-FFA08-REC-DATE         07460017
MFA-TR*        FOR FETCH ONLY                                           07470000
MFA-TR*        WITH UR                                                  07470000
MFA-TR*    END-EXEC.                                                    07480000
HPCCDM*EJECT                                                            08590000
      /                                                                 08600000
                                                                        
       PROCEDURE DIVISION.                                              

SCA006        SET WS-GL-SUB TO 1.
      *                                                                 08630000
       0000-MAINLINE.                                                   
      *                                                                 08650000
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
      *                                                                 08670000
           PERFORM 1200-LOAD-GL-NUMBERS     THRU 1200-EXIT              
                                                                        
           PERFORM 1300-LOAD-GL-ACCTS       THRU 1300-EXIT              
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT           
                   UNTIL END-OF-FILE.                                   
      *                                                                 08740000
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                 08760000
           STOP RUN.                                                    
      *                                                                 08780000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08810000
      *   OPENS THE INPUT  FILE FA08                                   *08820000
      ******************************************************************08830000
       0100-INITIALIZATION.                                             
      *                                                                 08850000
A05136     INITIALIZE WS-CORRESP-HDR.                                   
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
                                                                        
      *                                                                 08930000
           OPEN INPUT FCSFA08-FILE.                                     
           IF  FA08-SUCCESSFUL                                          
               PERFORM 0500-PROCESS-BEGIN-REC  THRU  0500-EXIT          
                   UNTIL E-FFA08-KEY-BREC NOT EQUAL LOW-VALUES          
           ELSE                                                         
               DISPLAY 'OPEN ERROR ON FCSFA08 FILE.'                    
               DISPLAY ' STATUS IS ', WS-FFA08-STATUS                   
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF                                                       
      *                                                                 09030000
           MOVE WS-INPUT-DATE                  TO WS-COMMON-DATE.       
           MOVE WS-INPUT-DATE                  TO WS-PROCESS-DATE.      
                                                                        
      *                                                                 09060000
           INITIALIZE WS-SEL-TRANSFER-TABLE.                            
           MOVE 'N' TO WS-CNT-XFER-IND.                                 
           MOVE 'N' TO WS-CNT-XFER-IND-WO.                              
           MOVE 'N' TO WS-DFA-XFER-IND.                                 
           MOVE 'N' TO WS-DFA-XFER-IND-WO.                              
           MOVE 'N' TO WS-TRANSFER-ALL-WO.                              
           MOVE SPACES TO WS-PROJ-SHR-XFER-IND.                         
           SET JRNL-NOTPREPARED TO TRUE.                                
           PERFORM 6810-GET-TIMESTAMP     THRU 6810-GET-TIMESTAMP-EXIT. 
      *                                                                 09160000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09190000
      ***************************************************************** 09200000
      *    0500-PROCESS-BEGIN-REC                                    ** 09210000
      *    THIS PARAGRAPH DOES AN INITIAL READ TO THE FA08 FILE AND  ** 09220000
      *    CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON     ** 09230000
      *    THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED     ** 09240000
      *    FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH      ** 09250000
      *    THE CORRECT FILE.                                         ** 09260000
      ***************************************************************** 09270000
      *                                                                 09280000
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                 09300000
           PERFORM 7000-READ-FCSFA08           THRU 7000-EXIT.          
      *                                                                 09320000
           EVALUATE TRUE                                                
              WHEN END-OF-FILE                                          
                 DISPLAY '**    PCSCA436 PROCESSING ERROR          **'  
                 DISPLAY '**      FCSFA08 FILE IS EMPTY            **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
      *                                                                 09390000
              WHEN E-FFA08-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FFA08-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '**     PCSCA436 PROCESSING ERROR      **'  
                    DISPLAY '** FCSFA08 CREATE DATE NOT = RUN DATE **'  
                    DISPLAY '**       PROCESSING TERMINATED        **'  
                    DISPLAY 'FILE CREATE DATE 'E-FFA08-CREATE-DATE-BREC 
                    DISPLAY 'INPUT-DATE IS :'WS-INPUT-DATE              
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 SET WS-BEGIN-RECS-PROCESSED   TO TRUE                  
A05136           MOVE E-FFA08-CREATE-DATE-BREC TO WS-FFA08-REC-DATE     
      *                                                                 09500000
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FFA08-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FFA08-KEY-BREC EQUAL HIGH-VALUES AND           
                       NO-DATA-RECORD-FOUND AND                         
                       E-FFA08-RECORD-COUNT-EREC EQUAL ZERO             
                       DISPLAY                                          
                       '**    PCSCA436 PROCESSING ERROR          **'    
                       DISPLAY                                          
                       '**      FCSFA08 FILE IS EMPTY            **'    
                       DISPLAY                                          
                       '**      PROCESSING TERMINATED            **'    
                       PERFORM 9901-ABEND            THRU 9901-EXIT     
                    ELSE                                                
                       CONTINUE                                         
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND      TO TRUE                  
                 END-IF                                                 
      *                                                                 09690000
              WHEN OTHER                                                
                 DISPLAY '**    PCSCA436 PROCESSING ERROR          **'  
                 DISPLAY '** FIRST RECORD IS NOT A CNTL REC        **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09790000
      ******************************************************************09800000
      * PROCESSES EACH INPUT RECORD UNTIL THE END OF FILE             **09810000
      ******************************************************************09820000
      *                                                                 09830000
       1000-PROCESS-INPUT.                                              
      *                                                                 09850000
           INITIALIZE WS-SEL-TRANSFER-TABLE.                            
           INITIALIZE WS-SAVE-SEL-REC-COUNT                             
A05136     INITIALIZE WS-CORRESP-NOTICE.                                
A05136     INITIALIZE WS-CORRESP-VAR.                                   
ACT216     INITIALIZE WS-25-BALANCES-TOTAL.                             
           MOVE 'N' TO WS-CNT-XFER-IND.                                 
           MOVE 'N' TO WS-CNT-XFER-IND-WO.                              
           MOVE 'N' TO WS-DFA-XFER-IND.                                 
           MOVE 'N' TO WS-DFA-XFER-IND-WO.                              
           MOVE WS-N TO WS-25-TRANSFER-ALL.                             
           MOVE WS-N TO WS-TRANSFER-ALL-WO.                             
           MOVE SPACES TO WS-PROJ-SHR-XFER-IND.                         
           MOVE 'N' TO WS-PROCESS-AUTO-XFER                             
           PERFORM 6810-GET-TIMESTAMP     THRU 6810-GET-TIMESTAMP-EXIT. 
                                                                        
           IF  E-FFA08-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES         
               CONTINUE                                                 
           ELSE                                                         
             IF E-FFA08-OUTPUT-ID = 'FA08' OR                           
                E-FFA08-OUTPUT-ID = 'FA09'                              
A05136          IF E-FFA08-TO-ACCOUNT-NO =   WS-PREV-ACCOUNT-NO         
A05136             ADD +1                    TO WS-CORRESP-SEQ-NO       
A05136          ELSE                                                    
A05136             MOVE ZERO                 TO WS-CORRESP-SEQ-NO       
A05136          END-IF                                                  
               MOVE E-FFA08-FROM-ACCOUNT-NO    TO AC-ACCOUNT-NO         
                                                  WS-FROM-ACCOUNT-NO    
      *                                           WS-ACCOUNT-NO         10050000
                                                  AT-ACCOUNT-NO         
                                                  WS-25-ACCT-NO-FROM    
C30169                                            KD-ACCOUNT-NO         
A00997                                           WS-25-TRAN-CMT-ACCT-FR 
A05136                                            WS-FFA08-FROM-ACCOUNT 
A05136                                            WS-XFER-FROM-ACCT-NO  
               MOVE E-FFA08-TO-ACCOUNT-NO    TO WS-TO-ACCOUNT-NO        
                                                WS-25-ACCT-NO-TO        
A00997                                          WS-25-TRAN-CMT-ACCT-TO  
A05136                                          WS-PREV-ACCOUNT-NO      
               MOVE E-FFA08-COMPANY-NO         TO AT-COMPANY-NO         
      *                                                                 10110000
               PERFORM 7150-SELECT-ACCOUNT     THRU 7150-EXIT           
A05136*        MOVE AT-CODE-ACCT-STAT          TO WS-AT-CODE-ACCT-STAT          
A05136*        MOVE AT-TOTAL-AR-BALANCE        TO WS-AT-TOTAL-AR-BALANCE        
               MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT 
               MOVE AT-CUSTOMER-NO             TO WS-25-CUST-NO-FROM    
               IF AT-CODE-ACCT-STAT = 'B'                               
                  MOVE 'Y' TO WS-PROCESS-AUTO-XFER                      
               ELSE                                                     
                  MOVE 'N' TO WS-PROCESS-AUTO-XFER                      
               END-IF                                                   
      *                                                                 10200000
               IF WS-PROCESS-AUTO-XFER = 'Y'                            
                  MOVE AT-ACCOUNT-NO TO AC-ACCOUNT-NO                   
                  MOVE ZEROES        TO AC-PYMT-PRIORITY-LVL            
                                    AC-ITEM-ID                          
                  PERFORM 7100-OPEN-AR-CNTRL-CURSOR  THRU 7100-EXIT     
                  PERFORM 7110-FETCH-AR-CNTRL-CURSOR THRU 7110-EXIT     
                  PERFORM 2310-LOAD-MAP-LINE THRU 2310-EXIT             
                     UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND        
                  IF WS-SAVE-SEL-REC-COUNT > 0                          
                     SET TRANSFER-AS-DFA TO TRUE                        
                     PERFORM 2725-TRANSFER-SEL-DFA THRU 2725-EXIT       
                  END-IF                                                
                  PERFORM 7120-CLOSE-AR-CNTRL-CURSOR THRU 7120-EXIT     
P00599            MOVE 'Y'               TO KD-FW-PROCESSED-FL          
C30169            PERFORM 8200-UPDATE-FIN-WO-ACTION THRU 8200-EXIT      
                  PERFORM 5000-UPDATE THRU 5000-EXIT                    
               END-IF                                                   
             ELSE                                                       
               MOVE E-FFA08-FROM-ACCOUNT-NO    TO CO-ACCOUNT-NO         
                                                  WS-FROM-ACCOUNT-NO    
      *                                           WS-ACCOUNT-NO         10400000
                                                  AT-ACCOUNT-NO         
                                                  WS-25-ACCT-NO-FROM    
C30169                                            KD-ACCOUNT-NO         
A05136                                            WS-FFA08-FROM-ACCOUNT 
A05136                                            WS-XFER-FROM-ACCT-NO  
               MOVE E-FFA08-TO-ACCOUNT-NO    TO WS-TO-ACCOUNT-NO        
                                                WS-25-ACCT-NO-TO        
               MOVE E-FFA08-COMPANY-NO         TO AT-COMPANY-NO         
      *                                                                 10460000
               PERFORM 7150-SELECT-ACCOUNT     THRU 7150-EXIT           
A05136*        MOVE AT-CODE-ACCT-STAT          TO WS-AT-CODE-ACCT-STAT          
A05136*        MOVE AT-TOTAL-AR-BALANCE        TO WS-AT-TOTAL-AR-BALANCE        
               MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT 
               IF AT-CODE-ACCT-STAT = 'S'                               
                  MOVE 'Y' TO WS-PROCESS-AUTO-XFER                      
               ELSE                                                     
                  MOVE 'N' TO WS-PROCESS-AUTO-XFER                      
               END-IF                                                   
      *                                                                 10540000
               IF WS-PROCESS-AUTO-XFER = 'Y'                            
                  MOVE AT-ACCOUNT-NO TO CO-ACCOUNT-NO                   
                  MOVE ZEROES        TO CO-PYMT-PRIORITY-LVL            
                                    CO-ITEM-ID                          
                  PERFORM 7130-OPEN-CHRG-OFF-CURSOR  THRU 7130-EXIT     
                  PERFORM 7140-FETCH-CHRG-OFF-CURSOR THRU 7140-EXIT     
                  PERFORM 2315-LOAD-MAP-LINE-CO THRU 2315-EXIT          
                     UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND        
                  IF WS-SAVE-SEL-REC-COUNT > 0                          
                     SET TRANSFER-AS-DFA-WO TO TRUE                     
                     PERFORM 2725-TRANSFER-SEL-DFA THRU 2725-EXIT       
                  END-IF                                                
                  PERFORM 7145-CLOSE-CHRG-OFF-CURSOR THRU 7145-EXIT     
P00599            MOVE 'Y'                  TO KD-FW-PROCESSED-FL       
C30169            PERFORM 8200-UPDATE-FIN-WO-ACTION THRU 8200-EXIT      
                  PERFORM 5000-UPDATE THRU 5000-EXIT                    
               END-IF                                                   
             END-IF                                                     
A05136       PERFORM 2400-LETTER-GENERATE-PROCESS THRU 2400-EXIT        
           END-IF.                                                      
      *                                                                 10730000
           IF WS-PROCESS-AUTO-XFER = 'Y'                                
             IF WS-DFA-XFER-IND     = 'Y' OR                            
                WS-DFA-XFER-IND-WO  = 'Y' OR                            
                WS-25-TRANSFER-ALL  = 'Y' OR                            
                WS-CNT-XFER-IND     = 'Y' OR                            
                WS-CNT-XFER-IND-WO  = 'Y' OR                            
                WS-TRANSFER-ALL-WO  = 'Y' OR                            
                (WS-PROJ-SHR-XFER-IND = 'Y' AND TO-HAS-NO-PJS)          
*************SET THE XFER FORWARD FLAG                                  10820000
                MOVE WS-25-ACCT-NO-FROM     TO AT-ACCOUNT-NO            
                PERFORM 6867-SELECT-ACCOUNT THRU 6867-EXIT              
                MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT    
                MOVE WS-CURRENT-DATE         TO AT-DATE-LAST-ACTION     
                MOVE ZEROES                  TO AT-ACCT-XFER-FROM-LST   
                MOVE WS-25-YES               TO AT-AR-XFER-IND          
                MOVE WS-25-ACCT-NO-TO        TO AT-ACCT-XFER-TO         
                MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT   
                PERFORM 6880-UPDATE-ACCOUNT THRU 6880-EXIT              
                                                                        
                MOVE WS-25-ACCT-NO-TO       TO AT-ACCOUNT-NO            
                PERFORM 6867-SELECT-ACCOUNT THRU 6867-EXIT              
                MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT    
                MOVE ZEROES                   TO AT-ACCT-XFER-TO        
                MOVE WS-25-NO                 TO AT-AR-XFER-IND         
                MOVE WS-25-ACCT-NO-FROM       TO AT-ACCT-XFER-FROM-LST  
                MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT  
                PERFORM 6880-UPDATE-ACCOUNT   THRU 6880-EXIT            
             END-IF                                                     
           END-IF                                                       
                                                                        
           PERFORM 7000-READ-FCSFA08           THRU 7000-EXIT.          
      *                                                                 11050000
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-LOAD-MAP-LINE.                                              
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2310-EXIT
           END-IF.                                          
                                                                        
                                                                        
      *******************                                               11140000
      * GET A/R TYPE AND DESCRIPTION                                    11150000
      *******************                                               11160000
           MOVE AC-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL            
           PERFORM 7160-SELECT-AR-TYPE THRU 7160-EXIT.                  
                                                                        
      *******************                                               11200000
              ADD  1                     TO WS-SAVE-SEL-REC-COUNT       
              MOVE L5-AR-TYPE-SHORT-DESC TO                             
                         WS-SEL-XFER-REC(WS-SAVE-SEL-REC-COUNT)         
              MOVE AC-ITEM-ID            TO                             
                         WS-SEL-XFER-ITEM-ID (WS-SAVE-SEL-REC-COUNT)    
              COMPUTE WS-TOT-XFER-AMT =                                 
                                       AC-AMT-AR-DAY-00 +               
                                       AC-AMT-AR-DAY-30 +               
                                       AC-AMT-AR-DAY-60 +               
                                       AC-AMT-AR-DAY-90 +               
                                       AC-AMT-UNUSED-CR +               
                                       AC-TOT-SUMM-UNBILLED             
              MOVE WS-TOT-XFER-AMT       TO                             
                         WS-SEL-XFER-AMT (WS-SAVE-SEL-REC-COUNT).       
           PERFORM 7110-FETCH-AR-CNTRL-CURSOR THRU 7110-EXIT.           
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11380000
       2315-LOAD-MAP-LINE-CO.                                           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2315-EXIT
           END-IF.                                          
                                                                        
                                                                        
      *******************                                               11440000
      * GET A/R TYPE AND DESCRIPTION                                    11450000
      *******************                                               11460000
           MOVE CO-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL            
           PERFORM 7160-SELECT-AR-TYPE THRU 7160-EXIT.                  
                                                                        
      *******************                                               11500000
              ADD  1                     TO WS-SAVE-SEL-REC-COUNT       
              MOVE L5-AR-TYPE-SHORT-DESC TO                             
                         WS-SEL-XFER-REC(WS-SAVE-SEL-REC-COUNT)         
              MOVE CO-ITEM-ID            TO                             
                         WS-SEL-XFER-ITEM-ID (WS-SAVE-SEL-REC-COUNT)    
              COMPUTE WS-TOT-XFER-AMT = CO-AMT-TRANS                    
              MOVE WS-TOT-XFER-AMT       TO                             
                         WS-SEL-XFER-AMT (WS-SAVE-SEL-REC-COUNT).       
           PERFORM 7140-FETCH-CHRG-OFF-CURSOR THRU 7140-EXIT.           
       2315-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11620000
A05136 2400-LETTER-GENERATE-PROCESS.                                    
A05136*                                                                         
A05136     MOVE AT-CUSTOMER-NO          TO WS-NOTICE-CUSTOMER-NO.       
A05136     MOVE E-FFA08-TO-ACCOUNT-NO   TO WS-NOTICE-ACCOUNT-NO.        
A05136     MOVE '90817'                 TO WS-CORRESP-MSG-ID.           
A05136     MOVE WS-INPUT-DATE           TO WS-CORRESP-STMT-DT.          
A05136     MOVE ZEROS                   TO WS-NOTICE-GUARANTOR-ACCT-NO. 
A05136     MOVE ZEROS                   TO WS-CORRESP-THD-PRTY-ID.      
A05136     MOVE ZEROS                   TO WS-FB-WO-AMT-XFERED.         
A05136     MOVE E-FFA08-COMPANY-NO      TO WS-CORRESP-COMPANY-NO.       
A05136     MOVE SPACES                  TO WS-CORRESP-TYPE-CD           
A05136                                     WS-NOTICE-REG-GROUP-CD       
A05136                                     WS-NOTICE-SENIOR-FL.         
A05136     MOVE WS-PGRMNAME             TO WS-CORRESP-CREATED-BY-PGM-ID.
A05136     MOVE E-FFA08-FROM-ACCOUNT-NO TO CO-ACCOUNT-NO                
A05136                                     AT-ACCOUNT-NO.               
A05136     PERFORM 7150-SELECT-ACCOUNT     THRU 7150-EXIT               
A05136     MOVE AT-CODE-ACCT-STAT          TO WS-AT-CODE-ACCT-STAT      
A05136     MOVE AT-TOTAL-AR-BALANCE        TO WS-AT-TOTAL-AR-BALANCE    
A05136     IF WS-AT-CODE-ACCT-STAT = 'S'                                
A05136        PERFORM 7170-SUM-LIEN-BALANCE THRU 7170-EXIT              
A05136         MOVE WS-LIEN-BALANCE     TO WS-TOTAL-AR-BALANCE          
A05136     ELSE                                                         
A05136         MOVE WS-AT-TOTAL-AR-BALANCE  TO WS-TOTAL-AR-BALANCE      
A05136     END-IF.                                                      
A05136     MOVE E-FFA08-TO-ACCOUNT-NO   TO WS-AR-ACCOUNT-NO.            
A05136     PERFORM 7200-OPEN-AR-TRANS-CURSOR  THRU 7200-EXIT.           
A05136     PERFORM 7210-FETCH-AR-TRANS-CURSOR THRU 7210-EXIT.           
A05136     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A05136        ADD AR-AMT-ORIG-ENTERED   TO WS-FB-WO-AMT-XFERED          
A05136        PERFORM 7210-FETCH-AR-TRANS-CURSOR THRU 7210-EXIT         
A05136     END-PERFORM.                                                 
A05136     PERFORM 7220-CLOSE-AR-TRANS-CURSOR THRU 7220-EXIT.           
A05136     COMPUTE WS-NOTICE-DUE-AM = WS-TOTAL-AR-BALANCE +             
A05136                                WS-FB-WO-AMT-XFERED.              
A05136     MOVE 1                       TO WS-NOTICE-CORRESP-ID.        
A05136     PERFORM 5100-CALL-NOTICES          THRU 5100-EXIT.           
A05136*                                                                         
A05136 2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11620000
                                                                        
       2725-TRANSFER-SEL-DFA.                                           
           INITIALIZE WS-78-DFA-AMT-TO-XFER                             
C30169     INITIALIZE WS-AUTO-TRANS-AMOUNT                              
           INITIALIZE WS-78-XFR-TABLE                                   
           INITIALIZE WS-78-DV-TABLE                                    
           INITIALIZE WS-78-FROM-AR-TABLE-SUMM                          
           PERFORM 2730-LOAD-ALL-DFA-RECV THRU 2730-EXIT                
                   VARYING WS-SUB FROM 1 BY 1                           
                   UNTIL WS-SUB GREATER THAN                            
                   WS-SAVE-SEL-REC-COUNT                                
                                                                        
           MOVE E-FFA08-TO-ACCOUNT-NO    TO WS-78-DFA-ACCT-NO-TO.       
           MOVE E-FFA08-FROM-ACCOUNT-NO  TO WS-78-DFA-ACCT-NO-FROM.     
           MOVE 'E'                      TO WS-78-DFA-CODE-DESC.        
           MOVE 'PCSCA436'               TO WS-78-TRIGGER-PROC.         
           PERFORM 6600-FORCE-DFA        THRU 6600-FORCE-DFA-EXIT.      
                                                                        
       2725-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2730-LOAD-ALL-DFA-RECV.                                          
           MOVE WS-SEL-XFER-REC(WS-SUB) TO WS-78-TBL-TYPE-XFR(WS-SUB).  
           MOVE WS-SEL-XFER-AMT(WS-SUB) TO WS-78-TBL-AMT-XFR(WS-SUB).   
           ADD  WS-SEL-XFER-AMT(WS-SUB) TO WS-78-DFA-AMT-TO-XFER.       
C30169     MOVE WS-78-DFA-AMT-TO-XFER   TO WS-AUTO-TRANS-AMOUNT.        
       2730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11910000
*********************WILLIE'S CODE ****************************         11920000
*********************WILLIE'S CODE START **********************         11930000
       5000-UPDATE.                                                     
                                                                        
********************KTB ADD                                             11960000
******************SET TRANSFER-CONTRACT IF EXIST ON FROM ACCOUNT        11970000
             IF E-FFA08-OUTPUT-ID = 'FA08' OR                           
                E-FFA08-OUTPUT-ID = 'FA09'                              
                MOVE WS-25-ACCT-NO-FROM      TO   AC-ACCOUNT-NO         
                MOVE WS-25-CNT-PYMT-PRIORITY TO   AC-PYMT-PRIORITY-LVL  
                PERFORM 6863-OPEN-AR-CNTRL-DETAIL  THRU 6863-EXIT       
                PERFORM 6864-FETCH-AR-CNTRL-DETAIL THRU 6864-EXIT       
                SET WS-CNTX TO 1                                        
                PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
                  MOVE AC-ACCOUNT-NO       TO   CT-ACCOUNT-NO           
                  MOVE AC-ITEM-ID          TO   CT-CNT-ITEM-ID          
                  MOVE SPACES              TO   CT-LIEN-CD              
                  PERFORM  7400-SELECT-LIEN-CODE     THRU 7400-EXIT     
                  IF CT-LIEN-CD = 'Y'                                   
                     PERFORM 6864-FETCH-AR-CNTRL-DETAIL  THRU 6864-EXIT 
                  ELSE                                                  
                     SET TRANSFER-CONTRACT TO TRUE                      
                     MOVE AC-ITEM-ID TO   WS-CNTR-ITEM-ID-NUM(WS-CNTX)  
                     SET WS-CNTX UP BY 1                                
                     PERFORM 6864-FETCH-AR-CNTRL-DETAIL  THRU 6864-EXIT 
                  END-IF                                                
                END-PERFORM                                             
                PERFORM 6865-CLOSE-AR-CNTRL-DETAIL     THRU 6865-EXIT   
             ELSE                                                       
****************CHARGE_OFF FOR CONTRACT                                 12210000
                MOVE WS-25-ACCT-NO-FROM      TO   CO-ACCOUNT-NO         
                MOVE WS-25-CNT-PYMT-PRIORITY TO   CO-PYMT-PRIORITY-LVL  
                PERFORM 6863B-OPEN-CHRG-OFF-DETAIL  THRU 6863B-EXIT     
                PERFORM 6864B-FETCH-CHRG-OFF-DETAIL THRU 6864B-EXIT     
                SET WS-CNTX TO 1                                        
                PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
                  MOVE CO-ACCOUNT-NO       TO   CT-ACCOUNT-NO           
                  MOVE CO-ITEM-ID          TO   CT-CNT-ITEM-ID          
                  MOVE SPACES              TO   CT-LIEN-CD              
                  PERFORM  7400-SELECT-LIEN-CODE     THRU 7400-EXIT     
                  IF CT-LIEN-CD = 'Y'                                   
                     PERFORM 6864B-FETCH-CHRG-OFF-DETAIL THRU 6864B-EXIT
                  ELSE                                                  
*******************  SET TRANSFER-CONTRACT TO TRUE                      12350000
                     SET TRANSFER-CONTRACT-WO   TO TRUE                 
                     MOVE CO-ITEM-ID TO   WS-CNTR-ITEM-ID-NUM(WS-CNTX)  
                     SET WS-CNTX UP BY 1                                
                     PERFORM 6864B-FETCH-CHRG-OFF-DETAIL THRU 6864B-EXIT
                  END-IF                                                
                END-PERFORM                                             
                PERFORM 6865B-CLOSE-CHRG-OFF-DETAIL     THRU 6865B-EXIT 
             END-IF                                                     
                                                                        
******************SET TRANSFER-PJS      IF EXIST ON FROM ACCOUNT        12450000
             IF E-FFA08-OUTPUT-ID = 'FA08' OR                           
                E-FFA08-OUTPUT-ID = 'FA09'                              
                MOVE WS-25-ACCT-NO-FROM      TO   AC-ACCOUNT-NO         
                MOVE WS-25-PJS-PYMT-PRIORITY TO   AC-PYMT-PRIORITY-LVL  
                PERFORM 6863-OPEN-AR-CNTRL-DETAIL  THRU 6863-EXIT       
                PERFORM 6864-FETCH-AR-CNTRL-DETAIL THRU 6864-EXIT       
                PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
                  MOVE 'Y' TO WS-PROJ-SHR-XFER-IND                      
                  MOVE WS-TO-ACCOUNT-NO-NUM     TO AT-ACCOUNT-NO        
                  PERFORM 7150-SELECT-ACCOUNT     THRU 7150-EXIT        
                  MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT 
                  IF WS-CODE-PROJECT-SHARE = 'A'                        
                     MOVE 'Y'                     TO WS-25-TO-HAS-PJS   
                  ELSE                                                  
                     MOVE 'N'                     TO WS-25-TO-HAS-PJS   
                  END-IF                                                
                  PERFORM 6864-FETCH-AR-CNTRL-DETAIL  THRU 6864-EXIT    
                END-PERFORM                                             
                PERFORM 6865-CLOSE-AR-CNTRL-DETAIL     THRU 6865-EXIT   
             END-IF                                                     
                                                                        
             IF E-FFA08-OUTPUT-ID = 'FA08' OR                           
                E-FFA08-OUTPUT-ID = 'FA09'                              
               MOVE WS-25-ACCT-NO-FROM      TO   AC-ACCOUNT-NO          
               MOVE ZEROES        TO AC-PYMT-PRIORITY-LVL               
                                 AC-ITEM-ID                             
               PERFORM 7100A-OPEN-AR-CNTRL-ALL  THRU 7100A-EXIT         
               PERFORM 7110A-FETCH-AR-CNTRL-ALL THRU 7110A-EXIT         
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                    OR WS-25-TRANSFER-ALL = 'Y'                         
                 IF  AC-PYMT-PRIORITY-LVL < 50                          
                    IF (   AC-AMT-AR-DAY-00 > 0                         
                        OR AC-AMT-AR-DAY-30 > 0                         
                        OR AC-AMT-AR-DAY-60 > 0                         
                        OR AC-AMT-AR-DAY-90 > 0 )                       
                       MOVE WS-Y TO WS-25-TRANSFER-ALL                  
                    END-IF                                              
                 ELSE                                                   
                    IF AC-AMT-TRAN-BALANCE > 0                          
                       MOVE WS-Y TO WS-25-TRANSFER-ALL                  
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 7110A-FETCH-AR-CNTRL-ALL  THRU 7110A-EXIT      
               END-PERFORM                                              
               PERFORM 7120A-CLOSE-AR-CNTRL-ALL     THRU 7120A-EXIT     
             ELSE                                                       
****************CHARGE_OFF FOR ALL OTHER RECEIVABLES                    12920000
                MOVE WS-25-ACCT-NO-FROM      TO   CO-ACCOUNT-NO         
                MOVE ZEROES        TO CO-PYMT-PRIORITY-LVL              
                                      CO-ITEM-ID                        
                PERFORM 7130A-OPEN-CHRG-OFF-ALL     THRU 7130A-EXIT     
                PERFORM 7140A-FETCH-CHRG-OFF-ALL    THRU 7140A-EXIT     
                PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND     
                                        OR WS-TRANSFER-ALL-WO = 'Y'     
                     MOVE WS-Y TO WS-TRANSFER-ALL-WO                    
                     PERFORM 7140A-FETCH-CHRG-OFF-ALL    THRU 7140A-EXIT
                END-PERFORM                                             
                PERFORM 7150A-CLOSE-CHRG-OFF-ALL        THRU 7150A-EXIT 
             END-IF                                                     
                                                                        
           PERFORM 6800-TRANSFER-CONTROL THRU 6800-EXIT.                
                                                                        
                                                                        
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05136******************************************************************08281004
A05136* 5100-CALL-NOTICES                                               08282004
A05136******************************************************************      08
A05136*                                                                         
A05136 5100-CALL-NOTICES.                                               
                                                                        
A05136     CALL SCSKR125 USING   WS-CORRESP-HDR                         
A05136                           WS-CORRESP-NOTICE                      
A05136                           WS-CORRESP-VAR                         
A05136                           WS-MISC-PROCESSING-VARS                
A05136                           WS-KR125-COMM-DATA-VARS                
A05136                           WS-KR125-MNT-TRANS-VARS                
A05136                           ABEND-FILE                             
A05136                           WS-CWS350-MISC                         
A05136                           WS-CORRESP-COMM-VAR                    
A05136                           RS-KR125-RETURN-CODE.                  
A05136                                                                  
A05136     IF ABEND-FUNCTION  > SPACES                                  
A05136        MOVE ABEND-SQLCODE           TO RS-RETURN-CODE            
A05136                                        WS-ACTIVE-RETURN-CODE     
A05136        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
A05136     END-IF.                                                      
A05136     ADD 1                           TO WS-RESTART-COMMIT-COUNTER.
A05136                                                                  
A05136 5100-EXIT.                                                       
A05136     EXIT.                                                        
*********************WILLIE'S CODE ****************************         13150000
*********************WILLIE'S CODE END   **********************         13160000
                                                                        
      ***************************************************************** 13180000
      *    LOAD GL NUMBER VALUES OF DESIRED GL NUMBERS.*                13190000
      ***************************************************************** 13200000
       1200-LOAD-GL-NUMBERS.                                            
      ***  LOAD GL NUMBERS FROM TBGLATNO                                13220000
           MOVE PROGRAM-NAME               TO  WS-CPD00061-CALLING-PGM. 
           MOVE SPACES                     TO  ABEND-FUNCTION.          
           CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
                                  WS-GL-ACCT-MAJOR-FIELDS,              
                                  WS-VALID-COMPANY-NOS,                 
                                  WS-GL-NAME-INFO,                      
                                  WS-GL-ACCT-NO-TABLE,                  
                                  WS-CPD00061-CALLING-PGM,              
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
      ** SUBTRACT 1 BECAUSE INDEX IS 1 MORE THAN LAST OCCURENCE LOADED  13380000
           SUBTRACT 1 FROM WS-VALID-CO-SUB.                             
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            13430000
      *                                                                 13440000
      ***************************************************************** 13450000
      *    LOAD GL ACCOUNT NUMBERS FOR DESIRED GL ACCOUNT VALUES.     * 13460000
      ***************************************************************** 13470000
       1300-LOAD-GL-ACCTS.                                              
                                                                        
           MOVE 0 TO WS-GL-SUBSCRIPT.                                   
           PERFORM 1310-INITIALIZE-GL-TABLE THRU 1310-EXIT              
             UNTIL WS-GL-SUBSCRIPT = 2000.                              
                                                                        
           MOVE 0 TO WS-GL-SUBSCRIPT.                                   
                                                                        
           MOVE WS-GL-CASH-KEY TO GO-GL-ACCT-NAME.                      
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-LPC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-LPN-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-ELC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-GAS-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-EPP-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-CCC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-DFA-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-DEP-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-CNT-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSA-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSC-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-NSN-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
           MOVE WS-GL-PJS-KEY TO GO-GL-ACCT-NAME.                       
           PERFORM 1305-GL-LOAD-ROUTINE THRU 1305-EXIT.                 
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            14000000
      ***************************************************************** 14010000
      * OPEN, LOOP, AND CLOSE FOR LOADING EACH GL NUMBER                14020000
      ***************************************************************** 14030000
       1305-GL-LOAD-ROUTINE.                                            
                                                                        
           PERFORM 7800-OPEN-GL-NBRS THRU 7800-EXIT.                    
           PERFORM 1350-LOOP-GL-NBRS THRU 1350-EXIT                     
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                   OR WS-GL-SUBSCRIPT GREATER THAN 2000.                
           PERFORM 7850-CLOSE-GL-NBRS THRU 7850-EXIT.                   
                                                                        
       1305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14150000
      *    INITIALIZE GL TABLE                                          14160000
      ***************************************************************** 14170000
       1310-INITIALIZE-GL-TABLE.                                        
                                                                        
           ADD 1 TO WS-GL-SUBSCRIPT.                                    
           MOVE ZEROES TO WS-GL-ACCOUNT-NO (WS-GL-SUBSCRIPT).           
           MOVE SPACES TO WS-GL-COMPANY (WS-GL-SUBSCRIPT)               
                          WS-GL-LOCAL-OFFICE (WS-GL-SUBSCRIPT)          
                          WS-GL-ACCOUNT-NAME (WS-GL-SUBSCRIPT).         
                                                                        
       1310-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            14280000
      ***************************************************************** 14290000
      *    LOOP GL NUMBERS                                              14300000
      ***************************************************************** 14310000
       1350-LOOP-GL-NBRS.                                               
                                                                        
           PERFORM 7820-FETCH-GL-NBRS THRU 7820-EXIT.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE GO-COMPANY-NO                                       
                     TO WS-GL-COMPANY (WS-GL-SUBSCRIPT)                 
               MOVE GO-GL-ACCT-NO                                       
                     TO WS-GL-ACCOUNT-NO (WS-GL-SUBSCRIPT)              
               MOVE GL-LOCAL-OFFICE                                     
                     TO WS-GL-LOCAL-OFFICE (WS-GL-SUBSCRIPT)            
               MOVE GO-GL-ACCT-NAME                                     
                     TO WS-GL-ACCOUNT-NAME (WS-GL-SUBSCRIPT)
           END-IF.           
                                                                        
        1350-EXIT.                                                      
            EXIT.                                                       
HPCCDM* EJECT                                                           14480000
      *                                                                 14490000
                                                                        
      *                                                                 14510000
       COPY CPD00040.                                                   14520000
       COPY CPD00037.                                                   14530000
      * PARAGRAPH 7600-START-FCSJC01 IS IN CPD00038.                    14540000
           EXEC SQL                                                     14550000
              INCLUDE CPD00038                                          14560000
           END-EXEC.                                                    14570000
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                     14580000
           EXEC SQL                                                     14590000
              INCLUDE CPD00039                                          14600000
           END-EXEC.                                                    14610000
      *                                                                 14620000
           COPY CPD0013B.                                               14630000
      *************************************************************     14640000
      * BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.           *     14650000
      *************************************************************     14660000
      *                                                                 14670000
           EXEC SQL                                                     14680000
               INCLUDE CPD00007                                         14690000
           END-EXEC.                                                    14700000
      *                                                                 14710000
      *    SUPPORTS AR TRANS HIST (6500-ONLINE-LOAD-AR-TRAN-HIST).      14720000
      *                                                                 14730000
           EXEC SQL                                                     14740000
              INCLUDE CPD00008                                          14750000
           END-EXEC.                                                    14760000
      *                                                                 14770000
           EXEC SQL                                                     14820000
                INCLUDE CPD0023B                                        14830000
           END-EXEC.                                                    14840000
      *                                                                 14850000
           EXEC SQL                                                     14860000
                INCLUDE CPD0078B                                        14870000
           END-EXEC.                                                    14880000
      *                                                                 14890000
      *                                                                 14900000
*********************WILLIE'S CODE ****************************         14910000
*********************WILLIE'S CODE START ****************************   14920000
      *                                                                 14930000
           EXEC SQL                                                     14940000
                INCLUDE CPD0120B                                        14950000
           END-EXEC.                                                    14960000
      *                                                                 14970000
*********************WILLIE'S CODE ****************************         14980000
*********************WILLIE'S CODE END   ****************************   14990000
      ******************************************************************15000000
      * 5900-NEXT-BILL-DATE                                            *15010000
      ******************************************************************15020000
           EXEC SQL                                                     15030000
               INCLUDE CPD00309                                         15040000
           END-EXEC.                                                    15050000
      *                                                                 15060000
      *                                                                 15070000
      ******************************************************************15080000
      *     7000-READ-FCSFA08                                          *15090000
      *      MAIN DRIVER.   READS THE DAILY BILLING FILE               *15100000
      *                                                                *15110000
      ******************************************************************15120000
       7000-READ-FCSFA08.                                               
      *                                                                 15140000
           READ FCSFA08-FILE                                            
               AT END                                                   
                   MOVE WS-Y                   TO WS-END-OF-FILE        
                   GO TO 7000-EXIT                                      
           END-READ.                                                    
      *                                                                 15200000
           IF  FA08-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-ERROR ON FCSFA08 READ.  STATUS IS '        
                        WS-FFA08-STATUS                                 
               DISPLAY 'ERROR IN ACCOUNT NO' E-FFA08-FROM-ACCOUNT-NO    
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 15290000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15320000
      ******************************************************************15330000
      * OPEN  AR_CNTRL CURSOR                                           15340000
      ******************************************************************15350000
      *                                                                 15360000
       7100-OPEN-AR-CNTRL-CURSOR.                                       
           EXEC SQL                                                     
                OPEN AR_CNTRL_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7100-OPEN-AR-CNTRL-CURSOR            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 15530000
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15570000
      * FETCH AR_CNTRL CURSOR                                           15580000
      ******************************************************************15590000
                                                                        
       7110-FETCH-AR-CNTRL-CURSOR.                                      
           EXEC SQL                                                     
               FETCH AR_CNTRL_CURSOR                                    
                INTO :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-TRAN-BALANCE,                              
                     :AC-AMT-UNUSED-CR,                                 
                     :AC-TOT-SUMM-UNBILLED,                             
                     :AC-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7110-FETCH-AR-CNTRL-CURSOR           *'       
               DISPLAY '* ACCOUNT NO ', AC-ACCOUNT-NO                   
               DISPLAY '* PYMT_PRIORITY_LVL', AC-PYMT-PRIORITY-LVL      
               DISPLAY '* ITEM ID          ', AC-ITEM-ID                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 15910000
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15950000
      * CLOSE AR_CNTRL CURSOR                                           15960000
      ******************************************************************15970000
      *                                                                 15980000
       7120-CLOSE-AR-CNTRL-CURSOR.                                      
           EXEC SQL                                                     
              CLOSE AR_CNTRL_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7120-CLOSE-AR-CNTRL-CURSOR           *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16170000
      ******************************************************************16180000
      * OPEN  AR_CNTRL_ALL CURSOR                                       16190000
      ******************************************************************16200000
      *                                                                 16210000
       7100A-OPEN-AR-CNTRL-ALL.                                         
           EXEC SQL                                                     
                OPEN AR_CNTRL_ALLXFER                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7100A-OPEN-AR-CNTRL-ALL              *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 16380000
       7100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************16420000
      * FETCH AR_CNTRL_ALL CURSOR                                       16430000
      ******************************************************************16440000
                                                                        
       7110A-FETCH-AR-CNTRL-ALL.                                        
           EXEC SQL                                                     
               FETCH AR_CNTRL_ALLXFER                                   
                INTO :AC-PYMT-PRIORITY-LVL,                             
                     :AC-ITEM-ID,                                       
                     :AC-AMT-AR-DAY-00,                                 
                     :AC-AMT-AR-DAY-30,                                 
                     :AC-AMT-AR-DAY-60,                                 
                     :AC-AMT-AR-DAY-90,                                 
                     :AC-AMT-TRAN-BALANCE,                              
                     :AC-AMT-UNUSED-CR,                                 
                     :AC-TOT-SUMM-UNBILLED,                             
                     :AC-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7110A-FETCH-AR-CNTRL-ALL              *'      
               DISPLAY '* ACCOUNT NO ', AC-ACCOUNT-NO                   
               DISPLAY '* PYMT_PRIORITY_LVL', AC-PYMT-PRIORITY-LVL      
               DISPLAY '* ITEM ID          ', AC-ITEM-ID                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 16760000
       7110A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************16800000
      * CLOSE AR_CNTRL_ALL CURSOR                                       16810000
      ******************************************************************16820000
      *                                                                 16830000
       7120A-CLOSE-AR-CNTRL-ALL.                                        
           EXEC SQL                                                     
              CLOSE AR_CNTRL_ALLXFER                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7120A-CLOSE-AR-CNTRL-ALL              *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7120A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 17020000
      ******************************************************************17030000
      * OPEN  CHRG_OFF CURSOR                                           17040000
      ******************************************************************17050000
      *                                                                 17060000
       7130-OPEN-CHRG-OFF-CURSOR.                                       
           EXEC SQL                                                     
                OPEN CHRG_OFF                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7130-OPEN-CHRG-OFF-CURSOR            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 17230000
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17270000
      * FETCH CHRG_OFF CURSOR                                           17280000
      ******************************************************************17290000
                                                                        
       7140-FETCH-CHRG-OFF-CURSOR.                                      
           EXEC SQL                                                     
               FETCH CHRG_OFF                                           
                INTO :CO-PYMT-PRIORITY-LVL,                             
                     :CO-ITEM-ID,                                       
                     :CO-AMT-TRANS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7140-FETCH-CHRG-OFF-CURSOR           *'       
               DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
               DISPLAY '* PYMT_PRIORITY_LVL', CO-PYMT-PRIORITY-LVL      
               DISPLAY '* ITEM ID          ', CO-ITEM-ID                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 17540000
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17580000
      * CLOSE AR_CNTRL CURSOR                                           17590000
      ******************************************************************17600000
      *                                                                 17610000
       7145-CLOSE-CHRG-OFF-CURSOR.                                      
           EXEC SQL                                                     
              CLOSE CHRG_OFF                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7145-CLOSE-CHRG-OFF-CURSOR           *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7145-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17800000
      ******************************************************************17810000
      * OPEN  CHRG_OFF_ALL CURSOR                                       17820000
      ******************************************************************17830000
      *                                                                 17840000
       7130A-OPEN-CHRG-OFF-ALL.                                         
           EXEC SQL                                                     
                OPEN CHRG_OFF_ALLXFER                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7130A-OPEN-CHRG-OFF-ALL              *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18010000
       7130A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************18050000
      * FETCH CHRG_OFF_ALL CURSOR                                       18060000
      ******************************************************************18070000
                                                                        
       7140A-FETCH-CHRG-OFF-ALL.                                        
           EXEC SQL                                                     
               FETCH CHRG_OFF_ALLXFER                                   
                INTO :CO-PYMT-PRIORITY-LVL,                             
                     :CO-ITEM-ID,                                       
                     :CO-AMT-TRANS,                                     
T33431               :CO-DATE-OF-CHG-OFF                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7140A-FETCH-CHRG-OFF-ALL              *'      
               DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
               DISPLAY '* PYMT_PRIORITY_LVL', CO-PYMT-PRIORITY-LVL      
               DISPLAY '* ITEM ID          ', CO-ITEM-ID                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18330000
       7140A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************18370000
      * CLOSE CHRG_OFF_ALL CURSOR                                       18380000
      ******************************************************************18390000
      *                                                                 18400000
       7150A-CLOSE-CHRG-OFF-ALL.                                        
           EXEC SQL                                                     
              CLOSE CHRG_OFF_ALLXFER                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7150A-CLOSE-CHRG-OFF-ALL              *'      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7150A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 18590000
                                                                        
      ******************************************************************18610000
      * SELECT ACCOUNT DETAILS                                          18620000
      ******************************************************************18630000
      *                                                                 18640000
       7150-SELECT-ACCOUNT.                                             
      *                                                                 18660000
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                    ,CUSTOMER_NO                                        
                    ,DATE_BILL_DAY_00                                   
                    ,DATE_BILL_DAY_30                                   
                    ,DATE_BILL_DAY_60                                   
                    ,DATE_BILL_DAY_90                                   
                    ,TOTAL_AR_BALANCE                                   
                    ,CODE_ACCT_STAT                                     
                    ,NOTICE_EXEMPT_CD                                   
                    ,LOCAL_OFFICE                                       
                    ,PREMISE_NO                                         
                    ,CODE_DISC_OK                                       
                    ,CODES_DATA_PRESENT                                 
                    ,COMPANY_NO                                         
                    ,CREDIT_GROUP                                       
                    ,BANKRUPTCY_IND                                     
                    ,LAST_NRML_BILL_NO                                  
                    ,REV_MTH_LST_NRML                                   
                    ,ELEC_REV_ALLOC_PCT                                 
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-00                
                    ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-30                
                    ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-60                
                    ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-90                
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-LAST-NRML-BILL-NO                              
                    ,:AT-REV-MTH-LST-NRML :WS-REVENUE-MTH-NULL-1         
                    ,:AT-ELEC-REV-ALLOC-PCT                             
               FROM CSS_ACCOUNT                                         
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19090000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND-00 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-00   
               END-IF                                                   
               IF  WS-NULL-IND-30 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-30   
               END-IF                                                   
               IF  WS-NULL-IND-60 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-60   
               END-IF                                                   
               IF  WS-NULL-IND-90 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-90   
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7150-SELECT-ACCOUNT                  *'       
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 19330000
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19360000
       7160-SELECT-AR-TYPE.                                             
           EXEC SQL                                                     
              SELECT AR_TYPE_SHORT_DESC,                                
                     AR_TYPE_LONG_DESC                                  
              INTO   :L5-AR-TYPE-SHORT-DESC,                            
                     :L5-AR-TYPE-LONG-DESC                              
              FROM CSS_AR_TYPE                                          
              WHERE PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 7160-SELECT-AR-TYPE                  *'       
               DISPLAY '* PYMT-PRIORITY LVL ', L5-PYMT-PRIORITY-LVL     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05136******************************************************************11340000
A05136* SUM LIEN BALANCE                                                11350000
A05136******************************************************************11360000
A05136 7170-SUM-LIEN-BALANCE.                                           
A05136     EXEC SQL                                                     
A05136         SELECT SUM(AMT_TRANS)                                    
A05136           INTO :WS-LIEN-BALANCE                                  
A05136           FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
A05136          WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
A05136                                                           
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07390000
MFA-TR*        SELECT SUM(AMT_TRANS)                                    07410004
MFA-TR*          INTO :WS-LIEN-BALANCE                                          
MFA-TR*          FROM CSS_CHRG_OFF                                      07420004
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                07430004
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    07480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136                                                                  
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136                           OR   NOT-FOUND                         
A05136        NEXT SENTENCE                                             
A05136     ELSE                                                         
A05136         DISPLAY '********** PCSCA436 ABORT **************'       
A05136         DISPLAY '* 7170-SUM-LIEN-BALANCE                *'       
A05136         DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
A05136         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A05136         DISPLAY '* PROGRAM ABORTING...                  *'       
A05136         DISPLAY '********** PCSCA436 ABORT **************'       
A05136         PERFORM 9900-ABEND              THRU 9900-EXIT           
A05136     END-IF.                                                      
      *                                                                 20640000
A05136 7170-EXIT.                                                       
A05136     EXIT.                                                        
      *                                                                 20640000
A05136******************************************************************11100000
A05136* OPEN  AR_CNTRL CURSOR                                           11110000
A05136******************************************************************11120000
A05136*                                                                 11130000
A05136 7200-OPEN-AR-TRANS-CURSOR.                                       
A05136     EXEC SQL                                                     
A05136          OPEN AR_TRANS_CURSOR                                    
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A05136        NEXT SENTENCE                                             
A05136     ELSE                                                         
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         DISPLAY '* 7200-OPEN-AR-TRANS-CURSOR            *'       
A05136         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A05136         DISPLAY '* PROGRAM ABORTING...                  *'       
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         PERFORM 9900-ABEND              THRU 9900-EXIT           
A05136     END-IF.                                                      
A05136*                                                                 11300000
A05136 7200-EXIT.                                                       
A05136     EXIT.                                                        
A05136******************************************************************11340000
A05136* FETCH AR_TRANS CURSOR                                           11350000
A05136******************************************************************11360000
A05136 7210-FETCH-AR-TRANS-CURSOR.                                      
A05136     EXEC SQL                                                     
A05136         FETCH AR_TRANS_CURSOR                                    
A05136          INTO :AR-AMT-ORIG-ENTERED                               
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136                                                                  
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136                           OR   NOT-FOUND                         
A05136        NEXT SENTENCE                                             
A05136     ELSE                                                         
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         DISPLAY '* 7210-FETCH-AR-TRANS-CURSOR           *'       
A05136         DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
A05136         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A05136         DISPLAY '* PROGRAM ABORTING...                  *'       
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         PERFORM 9900-ABEND              THRU 9900-EXIT           
A05136     END-IF.                                                      
A05136*                                                                 11570000
A05136 7210-EXIT.                                                       
A05136     EXIT.                                                        
A05136******************************************************************11610000
A05136* CLOSE AR_TRANS CURSOR                                           11620000
A05136******************************************************************11630000
A05136*                                                                 11640000
A05136 7220-CLOSE-AR-TRANS-CURSOR.                                      
A05136     EXEC SQL                                                     
A05136        CLOSE AR_TRANS_CURSOR                                     
A05136     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136                                                                  
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        NEXT SENTENCE                                             
A05136     ELSE                                                         
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         DISPLAY '* 7220-CLOSE-AR-TRANS-CURSOR           *'       
A05136         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A05136         DISPLAY '* PROGRAM ABORTING...                  *'       
A05136         DISPLAY '********** PCSCA437 ABORT **************'       
A05136         PERFORM 9900-ABEND              THRU 9900-EXIT           
A05136     END-IF.                                                      
A05136 7220-EXIT.                                                       
A05136     EXIT.                                                        
      ******************************************************************20650000
      *    OPEN CURSOR TO GET GL NUMBERS.                              *20660000
      ******************************************************************20670000
       7800-OPEN-GL-NBRS.                                               
                                                                        
           EXEC SQL                                                     
                OPEN GL_NBRS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7800                  TO ACTIVE-PARAGRAPH           
               MOVE 'OPEN    '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE SPACES                TO WS-ERROR-MSG-2             
               MOVE SPACES                TO HOSTVAR-ELEMENT-2          
               MOVE SPACES                TO WS-ERROR-MSG-3             
               MOVE SPACES                TO HOSTVAR-ELEMENT-3          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            20920000
      ******************************************************************20930000
      *    FETCH GL NUMBERS *                                           20940000
      ******************************************************************20950000
       7820-FETCH-GL-NBRS.                                              
                                                                        
           EXEC SQL                                                     
                FETCH GL_NBRS                                           
                INTO :GO-COMPANY-NO,                                    
                     :GO-GL-ACCT-NO,                                    
                     :GL-LOCAL-OFFICE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD 1 TO  WS-GL-SUBSCRIPT                                
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7820                  TO ACTIVE-PARAGRAPH           
               MOVE 'FETCH   '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               MOVE SPACES                TO WS-ERROR-MSG-2             
               MOVE SPACES                TO HOSTVAR-ELEMENT-2          
               MOVE SPACES                TO WS-ERROR-MSG-3             
               MOVE SPACES                TO HOSTVAR-ELEMENT-3          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF
           END-IF.           
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            21260000
      ******************************************************************21270000
      *    CLOSE GL NUMBERS *                                           21280000
      ******************************************************************21290000
       7850-CLOSE-GL-NBRS.                                              
                                                                        
           EXEC SQL                                                     
             CLOSE GL_NBRS                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 7850                  TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE   '            TO ABEND-FUNCTION             
               MOVE 'CSS_GL_ACCOUNT'      TO TABLE-1                    
               MOVE 'RETURN CODE IS'      TO WS-ERROR-MSG-1             
               MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1          
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           IF WS-GL-SUBSCRIPT GREATER THAN 2000                         
               MOVE 7850             TO ACTIVE-PARAGRAPH                
               MOVE 'BUILD   '       TO ABEND-FUNCTION                  
               MOVE 'CSS_GL_ACCOUNT' TO TABLE-1                         
               MOVE 'GL TABLE ENTRIES EXCEED 2000 - POSSIBLE'           
                     TO WS-ERROR-MSG-1                                  
               MOVE 'PROGRAM CHANGE REQUIRED' TO WS-ERROR-MSG-2         
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            21590000
                                                                        
       6999A-GET-TIMESTAMP.                                             
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-25-CURRENT-TIMESTAMP        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21620000
MFA-TR*         SET :WS-25-CURRENT-TIMESTAMP = CURRENT TIMESTAMP        21630000
MFA-TR*    END-EXEC.                                                    21640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 6999A-GET-TIMESTAMP                  *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       6999A-EXIT.                                                      
           EXIT.                                                        
                                                                        
C30169***************************************************************** 21800000
C30169*8200-UPDATE-FIN-WO-ACTION                                      * 21810000
C30169***************************************************************** 21820000
C30169 8200-UPDATE-FIN-WO-ACTION.                                       
C30169                                                                  
C30169     EVALUATE E-FFA08-OUTPUT-ID                                   
C30169         WHEN 'FA08'                                              
C30169            MOVE 'AXFR1' TO KD-FW-ACTION-TYPE-CD                  
C30169         WHEN 'FA09'                                              
C30169            MOVE 'AXFR2' TO KD-FW-ACTION-TYPE-CD                  
C30169         WHEN 'FA10'                                              
C30169            MOVE 'AXFR3' TO KD-FW-ACTION-TYPE-CD                  
C30169         WHEN 'FA11'                                              
C30169            MOVE 'AXFR4' TO KD-FW-ACTION-TYPE-CD                  
C30169     END-EVALUATE.                                                
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        UPDATE CSS_FIN_WO_ACTION                                  
C30169        SET FW_ACTION_AM      = :WS-AUTO-TRANS-AMOUNT,            
C30169            FW_ACTION_DT      = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) ),                 
P00599            FW_PROCESSED_FL   = :KD-FW-PROCESSED-FL               
C30169        WHERE ACCOUNT_NO      = :KD-ACCOUNT-NO                    
C30169        AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21960000
MFA-TR*       UPDATE CSS_FIN_WO_ACTION                                  21970000
MFA-TR*       SET FW_ACTION_AM      = :WS-AUTO-TRANS-AMOUNT,            21980000
MFA-TR*           FW_ACTION_DT      = :WS-PROCESS-DATE,                 21990000
MFA-TR*           FW_PROCESSED_FL   = :KD-FW-PROCESSED-FL                       
MFA-TR*       WHERE ACCOUNT_NO      = :KD-ACCOUNT-NO                    22000000
MFA-TR*       AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             22010000
MFA-TR*    END-EXEC.                                                    22020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169         DISPLAY '********** PCSCA436 ABORT **************'       
C30169         DISPLAY '* 8200-UPDATE-FIN-WO-ACTION            *'       
C30169         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C30169         DISPLAY '* ACCOUNT NO ', E-FFA08-FROM-ACCOUNT-NO         
C30169         DISPLAY '* PROGRAM ABORTING...                  *'       
C30169         DISPLAY '********** PCSCA436 ABORT **************'       
C30169         PERFORM 9900-ABEND              THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 8200-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
       8400A-SELECT-CHRG-OFF.                                           
           MOVE ZEROES TO   WS-CHRG-OFF-COUNT                           
           MOVE 'B' TO   WS-PAR-SPLIT-CODE-25                           
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
               INTO  :WS-CHRG-OFF-COUNT                                 
               FROM CSS_CHRG_OFF                                        
               WHERE ACCOUNT_NO      = :CO-ACCOUNT-NO                   
               AND (PYMT_PRIORITY_LVL = 40                              
               OR   PYMT_PRIORITY_LVL = 45 )                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CHRG-OFF-COUNT EQUAL 2                              
                 MOVE 'B' TO   WS-PAR-SPLIT-CODE-25                     
              ELSE                                                      
                 IF WS-CHRG-OFF-COUNT EQUAL 1                           
                  PERFORM  8400B-SELECT-CHRG-OFF-UTE  THRU 8400B-EXIT   
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'B' TO   WS-PAR-SPLIT-CODE-25                        
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 8400A-SELECT-CHRG-OFF                *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
       8400A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8400B-SELECT-CHRG-OFF-UTE.                                       
           MOVE ZEROES TO   WS-CHRG-OFF-COUNT                           
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                INTO  :WS-CHRG-OFF-COUNT                                
               FROM CSS_CHRG_OFF                                        
               WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 40                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CHRG-OFF-COUNT EQUAL 1                              
                 MOVE 'E' TO   WS-PAR-SPLIT-CODE-25                     
              ELSE                                                      
                 PERFORM  8400C-SELECT-CHRG-OFF-UTG  THRU 8400C-EXIT    
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 8400B-SELECT-CHRG-OFF-UTE            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
       8400B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8400C-SELECT-CHRG-OFF-UTG.                                       
           MOVE ZEROES TO   WS-CHRG-OFF-COUNT                           
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                INTO  :WS-CHRG-OFF-COUNT                                
               FROM CSS_CHRG_OFF                                        
               WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 45                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CHRG-OFF-COUNT EQUAL  1                             
                 MOVE 'G' TO   WS-PAR-SPLIT-CODE-25                     
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 8400C-SELECT-CHRG-OFF-UTG            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* ACCOUNT NO ', CO-ACCOUNT-NO                   
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF
           END-IF.                                                      
       8400C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8500-COMPUTE-SPLIT-AMT-LPC.                                      
               IF  WS-PAR-SPLIT-CODE-25 = 'B'                           
      ** IF BOTH, NOW DO THE TRANS HIST AND JOURNALLING FOR THE         23200000
      ** ELECTRIC PART.                                                 23210000
                 IF AT-ELEC-REV-ALLOC-PCT EQUAL ZEROES                  
                   MOVE AT-COMPANY-NO TO B1-COMPANY-NO                  
                   MOVE AT-LOCAL-OFFICE                                 
                                      TO B1-LOCAL-OFFICE                
                   PERFORM 6791F-SELECT-LOCAL-OFFICE                    
                                              THRU 6791F-EXIT           
                   COMPUTE WS-PAR-SPLIT-AMT-25 =                        
                              (B1-ELEC-REV-ALLOC-PCT / 100)             
                                          * WS-PAR-AMT-POSTED-25        
                 ELSE                                                   
                   COMPUTE WS-PAR-SPLIT-AMT-25 =                        
                              (AT-ELEC-REV-ALLOC-PCT / 100)             
                                          * WS-PAR-AMT-POSTED-25        
                 END-IF                                                 
                                                                        
                 COMPUTE WS-PAR-REMAIN-SPLIT-AMT-25 =                   
                                                 WS-PAR-AMT-POSTED-25   
                                                 - WS-PAR-SPLIT-AMT-25  
               END-IF.                                                  
               IF  WS-PAR-SPLIT-CODE-25 = 'E'                           
                   MOVE WS-PAR-AMT-POSTED-25 TO  WS-PAR-SPLIT-AMT-25    
                   MOVE ZEROES         TO WS-PAR-REMAIN-SPLIT-AMT-25    
               END-IF.                                                  
               IF  WS-PAR-SPLIT-CODE-25 = 'G'                           
                   MOVE WS-PAR-AMT-POSTED-25 TO                         
                                           WS-PAR-REMAIN-SPLIT-AMT-25   
                   MOVE ZEROES             TO WS-PAR-SPLIT-AMT-25       
               END-IF.                                                  
       8500-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    23520000
      * SELECT THE ELEC & GAS ALLOCATION % FROM THE LOC OFF TABLE. *    23530000
      **************************************************************    23540000
       6791F-SELECT-LOCAL-OFFICE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT     ELEC_REV_ALLOC_PCT                             
                INTO :B1-ELEC-REV-ALLOC-PCT                             
                FROM CSS_LOCAL_OFFICE                                   
               WHERE COMPANY_NO        = :B1-COMPANY-NO                 
                 AND LOCAL_OFFICE      = :B1-LOCAL-OFFICE               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 6791F-SELECT-LOCAL-OFFICE            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* COMPANY NO ', B1-COMPANY-NO                   
               DISPLAY '* LOCAL OFFICE', B1-LOCAL-OFFICE                
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
       6791F-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************23810000
      * 6883-ABEND-AR-NEGAMTS.                                          23820000
      *                                                                 23830000
      * IF THE RECEIVABLE HAS NEGATIVE AMOUNT IN ANY OF THE AGING      *23840000
      * AGING BUCKETS, UNUSED_CREDIT, SUM_UNBILLED THEN ABEND THE PGM  *23850000
      * AND TRANSFER NOT CONTINUED.                                    *23860000
      * IF AMT_TRAN_BALANCE IS NEGATIVE AND RECEIVABLE IS NOT EPP, RCC *23870000
      * CONTRACT THEN TRANSFER NOT DONE AND PROGRAM ABENDS.            *23880000
      ******************************************************************23890000
       6883-ABEND-AR-NEGAMTS.                                           
           IF  (AC-AMT-AR-DAY-00 < 0 OR                                 
                AC-AMT-AR-DAY-30 < 0 OR                                 
                AC-AMT-AR-DAY-60 < 0 OR                                 
                AC-AMT-AR-DAY-90 < 0 OR                                 
                AC-TOT-SUMM-UNBILLED < 0 OR                             
                AC-AMT-UNUSED-CR < 0 OR                                 
                (AC-AMT-TRAN-BALANCE < 0                                
                 AND (AC-PYMT-PRIORITY-LVL  = 050 OR                    
                      AC-PYMT-PRIORITY-LVL  = 060 OR                    
                      AC-PYMT-PRIORITY-LVL  = 100)))                    
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '* 6883-ABEND-AR-NEGAMTS                *'       
               DISPLAY '*  TRANSFER FAILED                     *'       
               DISPLAY '* UPDATE RECEIVABLE AMOUNT NEGATIVE FOR*'       
               DISPLAY '* FROM ACCOUNT                         *'       
               DISPLAY '* ACCOUNT NO ' , AC-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
       6883-EXIT.                                                       
           EXIT.                                                        
                                                                        
*********************WILLIE'S CODE ****************************         24140000
*********************WILLIE'S CODE START ****************************   24150000
T21158 5315-CREATE-CIA-RECORD.                                          
T21158     EXIT.                                                        
T21158 5315-EXIT.                                                       
T21158     EXIT.                                                        
                                                                        
       7400-SELECT-LIEN-CODE.                                           
           EXEC SQL                                                     
            SELECT LIEN_CD                                              
             INTO :CT-LIEN-CD                                           
             FROM CSS_CONTRACT                                          
             WHERE ACCOUNT_NO     = :CT-ACCOUNT-NO                      
             AND   CNT_ITEM_ID    = :CT-CNT-ITEM-ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA436 ABORT **************'       
               DISPLAY '********** COPYBOOK CPD0120B************'       
               DISPLAY '* PARA: 7400-SELECT-LIEN-CODE          *'       
               DISPLAY '* ACCOUNT NO ', CT-ACCOUNT-NO                   
               DISPLAY '* ITEM ID ', CT-CNT-ITEM-ID                     
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* TABLE IS CSS_CONTRACT'                        
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA436 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T33431******************************************************************24480000
T33431**  7410-SELECT-DEFCOGDATE                                      **24490000
T33431******************************************************************24500000
T33431 7410-SELECT-DEFCOGDATE.                                          
T33431*------------------------*                                        24520000
T33431     MOVE '7410'                   TO WS-ACTIVE-PARAGRAPH.        
T33431*                                                                 24540000
T33431     EXEC SQL                                                     
T33431       SELECT PARM_DATA                                           
T33431         INTO :G6-PARM-DATA                                       
T33431         FROM CSS_JOB_PARM                                        
T33431        WHERE PROGRAM_NAME = 'DEFCOGDATE'                         
T33431          AND COMPANY_NO   = :G6-COMPANY-NO                       
T33431          AND CMND_CODE    = 'DATE'                               
T33431          AND SEQ_NO       = 10                                   
T33431          AND STATUS       = 'A'                                  
T33431*                                                                 24640000
T33431     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T33431     MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
T33431*                                                                 24670000
T33431     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T33431         CONTINUE                                                 
T33431     ELSE                                                         
T33431         DISPLAY '********** PCSCA436  ABORT **************'      
T33431         DISPLAY '* 7410-SELECT-DEFCOGDATE                *'      
T33431         DISPLAY '* PROGRAM ABORTING...                  *'       
T33431         DISPLAY '********** PCSCA436  ABORT **************'      
T33431         PERFORM 9900-ABEND          THRU 9900-EXIT               
T33431     END-IF.                                                      
T33431*                                                                 24770000
T33431 7410-EXIT.                                                       
T33431     EXIT.                                                        
      *                                                                 24800000
                                                                        
      *                                                                 24820000
      ****************************************************************  24830000
      *  COPY BOOK CONTAINING LOAD MNT-HST                       ****   24840000
      ****************************************************************  24850000
      **     *     *     *     *     *     *     *     *     *       ***24860000
      **  6530-LOAD-MNT-TRANS-HIST.                                  ***24870000
      **                                                             ***24880000
      **     *     *     *     *     *     *     *     *     *       ***24890000
       6530-LOAD-MNT-TRANS-HIST.                                        
           MOVE '6530' TO ACTIVE-PARAGRAPH.                             
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6540-INSERT-MNT-TRANS-HIST THRU 6540-EXIT         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT         
           ELSE                                                         
              PERFORM 6550-INSERT-MT-TRN-HST-DET THRU 6550-EXIT
           END-IF.        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6540-INSERT-MNT-TRANS-HIST.                                      
           MOVE '6540' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     25020000
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           25030000
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       25040000
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     25050000
MFA-TR*            ACCOUNT_NO,                                          25060000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       25070000
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  25080000
MFA-TR*            TRAN_COMMENT)                                        25090000
MFA-TR*        VALUES                                                   25100000
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,               25110000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             25120000
MFA-TR*            :MH-ACCOUNT-NO,                                      25130000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               25140000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          25150000
MFA-TR*            :MH-TRAN-COMMENT)                                    25160000
MFA-TR*    END-EXEC.                                                    25170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA436 ABORT **************'        
              DISPLAY '********** COPYBOOK CPD0120B************'        
              DISPLAY '* PARA: 6540-INSERT-MNT-TRANS-HIST     *'        
              DISPLAY '* ACCOUNT NO IS ', MH-ACCOUNT-NO                 
              DISPLAY '* CUSTOMER NO IS ', MH-CUSTOMER-NO               
              DISPLAY '* PREMISE NO IS ', MH-PREMISE-NO                 
              DISPLAY '* DATE TRANS IS ', MH-DATE-TRANS                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* TABLE IS CSS_MNT_TRN_HST_DET'                  
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA436 ABORT **************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6550-INSERT-MT-TRN-HST-DET.                                      
           MOVE '6550' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
                 COLUMN_DESC,       PRV_COLUMN_VALUE,                   
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                 :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     25410000
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           25420000
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       25430000
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                   25440000
MFA-TR*          CHG_COLUMN_VALUE,                                      25450000
MFA-TR*          TABLE_ID)                                              25460000
MFA-TR*        VALUES                                                   25470000
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,               25480000
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           25490000
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                  25500000
MFA-TR*          :MI-TABLE-ID)                                          25510000
MFA-TR*    END-EXEC.                                                    25520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA436 ABORT **************'        
              DISPLAY '********** COPYBOOK CPD0120B************'        
              DISPLAY '* PARA: 6550-INSERT-MT-TRN-HST-DET     *'        
              DISPLAY '* TRANS HIST SEQ NO IS ', MI-TRANS-HIST-SEQ-NO   
              DISPLAY '* TRANS APPL NO IS ', MI-TRAN-APPL-NO            
              DISPLAY '* COLUMN DESC IS ', MI-COLUMN-DESC               
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* TABLE IS CSS_MT_TRN_HST_DET'                   
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA436 ABORT **************'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
       6550-EXIT.                                                       
           EXIT.                                                        
*********************WILLIE'S CODE ****************************         25720000
*********************WILLIE'S CODE END   **********************         25730000
      ***************************************************************** 25740000
      **                                                             ** 25750000
      **    6400-ONLINE-JRNL-ROUTINE                                 ** 25760000
      **  MODULE CALLS THE BATCH JOURNALLING ROUTINE - CODING FALL-  ** 25770000
      **  THROUGH WAS NECESSITATED BY THE          BATCH/ONLINE      ** 25780000
      **  COMBINATION AND DUPLICATE NUMBERING OF THE BATCH & ONLINE  ** 25790000
      **  JOURNALLING ROUTINES                                       ** 25800000
      **                                                             ** 25810000
      ***************************************************************** 25820000
       6400-ONLINE-JRNL-ROUTINE.                                        
                                                                        
           MOVE '6400'                     TO ACTIVE-PARAGRAPH.         
           GO TO 6400-BATCH-JRNL-ROUTINE.                               
      *                                                                 25870000
      ****************************************************************  25890000
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  25900000
      ****************************************************************  25910000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 25950000
      ****************************************************************  25960000
      *  CLOSES  THE INPUT  FILE                                    **  25970000
      ****************************************************************  25980000
      *                                                                 25990000
       9000-TERMINATE.                                                  
      *                                                                 26010000
           CLOSE FCSFA08-FILE                                           
      *                                                                 26030000
           IF  FA08-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSFA08-FILE'                  
               DISPLAY 'ERROR STATUS ' WS-FFA08-STATUS                  
           END-IF.                                                      
      *                                                                 26100000
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  26130000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *  26140000
      ****************************************************************  26150000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 26170000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                 26470000
      ****************************************************************  26480000
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****   26490000
      ****************************************************************  26500000
           EXEC SQL                                                     26510000
               INCLUDE CPD09900                                         26520000
           END-EXEC.                                                    26530000
       9901-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                  

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

           MOVE 02  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
       9901-EXIT.                                                       
           IF WS-ABEND-YES                                              
             STOP RUN
           END-IF.                                                  
