       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA425.                                        
       DATE-WRITTEN.   OCT 2003.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
      *  03/30/04  PD         NEW PROGRAM                              *        
T35434*  03/03/07  MC95456    REPLACED CSS_MODEL_SQL WITH SET STATEMENTS        
C33928*  03/05/07  AP40911    PERFORMANCE CHANGES AND REMOVED UNWANTED *        
      *                       CODE.                                    *        
P00641* 05/01/12   DB41297    REMOVE TBGLATNO UNUSED FIELDS.           *        
A04527* 06/06/13   MR7E794    REMOVED UNUSED COPYBOOK CWS00056.        *        
      ******************************************************************        
      *                                                                         
              REMARKS.                                                  
      *                                                                         
      ******************************************************************        
      *  THIS PROGRAM READS CSS_OVERSHORT_HDR AND MOVES LESS THAN $5   *        
      *  OVERSHORTS INTO EXPENSE ACCOUNT.                              *        
      ******************************************************************        
                                                                        
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
                                                                        
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
      *CONFIGURATION SECTION.                                                   
      *    SPECIAL NAMES.      C01 IS TOP-OF-PAGE.                              
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
      *                                                                         
      ***************************************************************           
      *  CSSPT33 - SELECT STATEMENT FOR OUTPUT REPORT FILE - 133 CHR*           
      ***************************************************************           
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ***************************************************************           
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDPT33.                                                            
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA425'.
MSQ017     COPY MFASQLM.
      *             'WORKING STORAGE FOR PCSCA425 STARTS HERE'.        *        
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                *        
      ******************************************************************        
       01  WS-DATE-VARIABLES.                                           
           05  WS-TEMP-DATE.                                            
               10  WS-TEMP-YY                   PIC 9(04).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-MM                   PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-DD                   PIC 9(02).              
           05  WS-RUN-DATE.                                             
               10 WS-DT-YY                      PIC 9(02).              
               10 WS-DT-MM                      PIC 9(02).              
               10 WS-DT-DD                      PIC 9(02).              
           05  WS-CUR-CCYY.                                             
               10  WS-CUR-CC                    PIC 9(02).              
               10  WS-CUR-YY                    PIC 9(02).              
           05  WS-REPORT-DATE.                                          
               10  WS-REP-MM                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
               10  WS-REP-DD                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
               10  WS-REP-YY                    PIC 9(02).              
           05  WS-BATCH-DATE.                                           
               10  WS-BATCH-MM                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-DD                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-YY                  PIC 9(04).              
                                                                        
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR TIME VARIABLES                *        
      ******************************************************************        
                                                                        
       01  WS-TIME-VARIABLES.                                           
           05  WS-RUN-TIME.                                             
               10 WS-HH                         PIC 9(02).              
               10 WS-MM                         PIC 9(02).              
               10 WS-SS                         PIC 9(02).              
               10 WS-TT                         PIC 9(02).              
           05  WS-REPORT-TIME.                                          
               10  WS-RT-HH                     PIC X(02).              
               10  FILLER                       PIC X(01) VALUE ':'.    
               10  WS-RT-MM                     PIC X(02).              
               10  FILLER                       PIC X(01) VALUE ':'.    
               10  WS-RT-SS                     PIC X(02).              
                                                                        
       01  WS-DATE-VARIABLES-1.                                         
           05  WS-DATE-CENTURY.                                         
               10  WS-CEN-CC                    PIC 9(02) VALUE ZEROES. 
               10  WS-CEN-YY                    PIC 9(02) VALUE ZEROES. 
           05  WS-AC01-DATE.                                            
               10  WS-AC01-CC                   PIC 9(02) VALUE ZEROES. 
               10  WS-AC01-YY                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-MM                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-DD                   PIC 9(02) VALUE ZEROES. 
           05  WS-DRAFT-DATE.                                           
               10  WS-DRAFT-CC                  PIC 9(02) VALUE ZEROES. 
               10  WS-DRAFT-YY                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-MM                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-DD                  PIC 9(02) VALUE ZEROES. 
           05  WS-CHECK-DATE.                                           
               10  WS-CHECK-CC                  PIC X(02) VALUE '20'.   
               10  WS-CHECK-YY                  PIC X(02) VALUE SPACES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-CHECK-MM                  PIC X(02) VALUE SPACES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-CHECK-DD                  PIC X(02) VALUE SPACES. 
           05  WS-TRAN-TIME                     PIC X(08) VALUE SPACES. 
           05  WS-XFR-TS                        PIC X(26) VALUE SPACES. 
           05  WS-CURRENT-DATE                  PIC X(10) VALUE SPACES. 
           05  WS-CURRENT-DATE-OH               PIC X(10) VALUE SPACES. 
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-BATCH-TOTAL-COUNT             PIC 9(04) VALUE ZEROES. 
                                                                        
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-REJECT-REASON                 PIC X(01)  VALUE SPACES.
           05  WS-DISP-CASH-DRAWER-ID           PIC 9(03).              
           05  WS-DISP-CUSTOMER-NO              PIC 9(10).              
           05  WS-DISP-ACCOUNT-NO               PIC 9(13).              
           05  WS-PYMT-AMT-NUM                  PIC 9(9)V99.            
           05  WS-PYMT-AMT REDEFINES WS-PYMT-AMT-NUM PIC X(11).         
           05  WS-DISP-GL-ACCT                  PIC 9(3).9(4).          
           05  WS-DISP-FILE-AMOUNT              PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-DISP-TOTAL-AMOUNT             PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-NULL-INDICATOR1               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR2               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR3               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR-1              PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CASH-DRAWER-ID                PIC 9(04).              
           05  WS-CNTL-TS-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-DATE-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-TIME-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CASH-GL-ACCT                  PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-BNKXFR-GL-ACCT                PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-ERR-GL-ACCT                   PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-PREV-REC-TYPE                 PIC 9(01) VALUE ZEROES. 
           05  WS-PREV-BATCH-NO                 PIC 9(04) VALUE ZEROES. 
           05  WS-AMT-9                         PIC 9(08)V99.           
           05  WS-AMT-X                                                 
               REDEFINES WS-AMT-9               PIC X(10).              
           05  WS-FIFTY-FIVE                    PIC 9(03) VALUE 55.     
           05  WS-PAGE-NUM                      PIC 9(04) VALUE ZEROES. 
           05  WS-LINE-SPACE                    PIC 9(02) VALUE ZEROES. 
           05  WS-LINE-DIFF                     PIC 9(03) VALUE ZEROES. 
           05  WS-LINE-CNTR                     PIC 9(03) VALUE 56.     
COB305     05 WS-EXP-OVSH-LAG        PIC S9(8)V COMP-3 VALUE 0.      
COB305     05 WS-EXP-OVSH-LIMIT        PIC S9(8)V COMP-3 VALUE 0.      
           05  WS-AUT-SHORT-AMT                 PIC 9(08)V99.           
           05  WS-AUT-OVER-AMT                  PIC 9(08)V99.           
           05  WS-NET-SHORT-AMT                 PIC 9(08)V99.           
           05  WS-NET-OVER-AMT                  PIC 9(08)V99.           
                                                                        
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-COMPANY                       PIC X(02) VALUE '01'.   
           05  WS-COMMENT-LEN                   PIC S9(04) COMP         
                                                VALUE +34.              
           05  WS-COMMENT-TEXT                  PIC X(34) VALUE         
C33928             'OVER/SHORT AUTO EXPENSED BY SYSTEM'.                
           05  WS-OV-SH-PRESENT                 PIC X(01) VALUE SPACES. 
           05  WS-CASHIER-USER-ID               PIC X(07) VALUE SPACES. 
           05  WS-CASHIER-CASH-OFFICE           PIC X(03) VALUE SPACES. 
           05  WS-BATCH-DEP-CASH-OFF            PIC X(03) VALUE SPACES. 
           05  WS-DEP-XFER-METHOD               PIC X(01) VALUE 'A'.    
                       88  AUTOMATIC-TRANSFER             VALUE 'A'.    
           05  WS-CASHIER-BANK-ID               PIC 9(05) VALUE 2.      
           05  WS-CASHIER-LOCAL-OFFICE          PIC X(03) VALUE SPACES. 
           05  WS-PGRMNAME                      PIC X(08) VALUE         
                                                       'PCSCA425'.      
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
           05  WS-N                             PIC X(01) VALUE 'N'.    
           05  WS-J                             PIC X(01) VALUE 'J'.    
           05  WS-T                             PIC X(01) VALUE 'T'.    
           05  WS-D                             PIC X(01) VALUE 'D'.    
           05  WS-P                             PIC X(01) VALUE 'P'.    
           05  WS-LIT-A                         PIC X(01) VALUE 'A'.    
           05  WS-LIT-C                         PIC X(01) VALUE 'C'.    
           05  WS-LIT-D                         PIC X(01) VALUE 'D'.    
           05  WS-ZERO                          PIC 9(01) VALUE 0.      
           05  WS-LIT-ZERO                      PIC X(10) VALUE ZEROES. 
           05  WS-ONE                           PIC 9(01) VALUE 1.      
           05  WS-TWO                           PIC 9(01) VALUE 2.      
           05  WS-THREE                         PIC 9(01) VALUE 3.      
           05  WS-FOUR                          PIC 9(01) VALUE 4.      
           05  WS-FIVE                          PIC 9(01) VALUE 5.      
           05  WS-SIX                           PIC 9(01) VALUE 6.      
           05  WS-SEVEN                         PIC 9(01) VALUE 7.      
           05  WS-EIGHT                         PIC 9(01) VALUE 8.      
           05  WS-NINE                          PIC 9(01) VALUE 9.      
           05  WS-YES                           PIC X(01) VALUE 'Y'.    
           05  WS-NO                            PIC X(01) VALUE 'N'.    
           05  WS-28                            PIC 9(02) VALUE 28.     
           05  WS-1                             PIC X(01) VALUE '1'.    
           05  WS-2                             PIC X(01) VALUE '2'.    
           05  WS-009                           PIC X(03) VALUE '009'.  
           05  WS-025                           PIC X(03) VALUE '025'.  
           05  WS-029                           PIC X(03) VALUE '029'.  
           05  WS-017                           PIC X(03) VALUE '017'.  
           05  WS-019                           PIC X(03) VALUE '019'.  
           05  WS-024                           PIC X(03) VALUE '024'.  
           05  WS-006                           PIC X(03) VALUE '006'.  
           05  WS-004                           PIC X(03) VALUE '004'.  
           05  WS-018                           PIC X(03) VALUE '018'.  
           05  WS-022                           PIC X(03) VALUE '022'.  
           05  WS-027                           PIC X(03) VALUE '027'.  
           05  WS-028                           PIC X(03) VALUE '028'.  
           05  WS-036                           PIC X(03) VALUE '036'.  
           05  WS-039                           PIC X(03) VALUE '039'.  
           05  WS-101                           PIC 9(03) VALUE 101.    
           05  WS-19                            PIC 9(02) VALUE 19.     
           05  WS-20                            PIC 9(02) VALUE 20.     
           05  WS-44                            PIC X(02) VALUE '44'.   
           05  WS-22                            PIC X(02) VALUE '22'.   
           05  WS-M                             PIC X(01) VALUE 'M'.    
           05  WS-METER-NO                      PIC X(09) VALUE         
                                                         '000000000'.   
           05  WS-ALL9-ACNO                     PIC 9(13) VALUE         
                                                          9999999999999.
           05  WS-TRAN-ID                       PIC X(04) VALUE 'A422'. 
           05  MULTIPLE-ROWS-SELECTED           PIC S9(09)              
                                                    VALUE -811 COMP.    
           05 WS-PAYMENT-SOURCE-CD.                                     
              10 WS-PAYMENT-SOURCE-1            PIC X(01) VALUE 'A'.    
              10 WS-PAYMENT-SOURCE-2            PIC X(01) VALUE 'T'.    
                                                                        
      ******************************************************************        
      * COBOL DECLARATION FOR TABLE CSS_OVERSHORT_HDR             *             
      ******************************************************************        
       01  WS-OVERSHORT-HDR-OH.                                         
           10 WS-CASH-COMPANY-NO-OH       PIC X(2).                     
           10 WS-CASH-LOCAL-OFFICE-OH     PIC X(3).                     
           10 WS-DATE-CASH-REPORT-OH      PIC X(10).                    
           10 WS-CASH-DRAWER-ID-OH        PIC S9(4) USAGE COMP.         
           10 WS-OVERSHORT-ID-OH          PIC S9(4) USAGE COMP.         
           10 WS-USER-ID-OH               PIC X(7).                     
COB305     10 WS-ACCOUNT-NO-OH        PIC S9(13)V USAGE COMP-3 VALUE 0.     
COB305     10 WS-OVERSHORT-AMT-OH        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.  
           10 WS-OVERSHORT-DR-CR-OH       PIC X(1).                     
COB305     10 WS-OFST-OVERSHORT-AMT-OH        PIC S9(9)V9(2) 
COB305       USAGE COMP-3 VALUE 0.  
           10 WS-OFST-DR-CR-OH            PIC X(1).                     
COB305     10 WS-GL-ACCT-NO-OH        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.  
           10 WS-TRAN-TS-OH               PIC X(26).                    
           10 WS-LAST-UPDATE-TS-OH        PIC X(26).                    
           10 WS-OVERSHORT-TYPE-CD-OH     PIC X(2).                     
           10 WS-OVERSHORT-SOLTN-FL-OH    PIC X(1).                     
           10 WS-OFFSET-MODE-FL           PIC X(1).                     
           10 WS-TRAN-COMMENT-OH.                                       
              49 WS-TRAN-COMMENT-LEN-OH   PIC S9(4) USAGE COMP.         
              49 WS-TRAN-COMMENT-TEXT-OH  PIC X(210).                   
      *                                                                         
      ******************************************************************        
      *  REPORT STRUCTURES - FOR PIPELINE PAYMENTS                     *        
      *                    - FOR ERROR ACCOUNTS                        *        
      ******************************************************************        
       01  WS-RPT-HDR1.                                                 
           05  FILLER                           PIC X(1)  VALUE SPACES. 
           05  WS-RPT-ID                        PIC X(8).               
           05  FILLER                           PIC X(34) VALUE SPACES. 
C33928     05  WS-RPT-NAME                      PIC X(39) VALUE SPACES. 
           05  FILLER                           PIC X(28) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-DATE :  '.     
           05  WS-RPT-DATE                      PIC 9(10).              
      *                                                                         
       01  WS-RPT-HDR2.                                                 
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-SYSTEM                    PIC X(36) VALUE SPACES. 
           05  FILLER                           PIC X(38) VALUE         
                           ' AUTOMATIC OV/SH EXPENSING    '.            
           05  FILLER                           PIC X(35) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-TIME :  '.     
           05  WS-RPT-TIME                      PIC X(08).              
      *                                                                         
       01  WS-RPT-SUM-HDG1.                                             
           05  FILLER                           PIC X(15) VALUE SPACES. 
           05  FILLER                           PIC X(17) VALUE SPACES. 
           05  FILLER                           PIC X(15) VALUE         
                                                ' AUTOMATIC '.          
      *                                                                         
       01  WS-RPT-SUM-DTL-OVER.                                         
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(16) VALUE         
                                                ' TOTAL OVERAGE  ' .    
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-AMT-AUT-OVER                  PIC ---,---,--9.99.     
                                                                        
       01  WS-RPT-SUM-DTL-SHORT.                                        
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(16) VALUE         
                                                ' TOTAL SHORTAGE '.     
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-AMT-AUT-SHORT                 PIC ---,---,--9.99.     
                                                                        
       01  WS-RPT-NET-DTL-SHORT.                                        
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(16) VALUE         
                                                ' NET SHORTAGE ' .      
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-RPT-NET-SHORT-AMT             PIC ---,---,--9.99.     
                                                                        
       01  WS-RPT-NET-DTL-OVER.                                         
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(16) VALUE         
                                                ' NET OVERAGE ' .       
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-RPT-NET-OVER-AMT              PIC ---,---,--9.99.     
                                                                        
      *                                                                         
       01  WS-RPT-SUM-HDG.                                              
           05  FILLER                           PIC X(20) VALUE SPACES. 
           05  FILLER                           PIC X(80) VALUE         
             ' SUMMARY OF EXPENSING OF CASHIER OVERSHORT '.             
                                                                        
       01  WS-RPT-AUT-SUM-HDG.                                          
           05  FILLER                           PIC X(20) VALUE SPACES. 
           05  FILLER                           PIC X(80) VALUE         
             ' SUMMARY OF AUTOMATIC EXPENSING OF CASHIER OVERSHORT '.   
                                                                        
       01  WS-PAGE-HDR.                                                 
           05  FILLER                           PIC X(110) VALUE SPACES.
           05  FILLER                           PIC X(12) VALUE         
                                                    'PAGE-NO  :  '.     
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-PAGE-NO                       PIC ZZZ9  VALUE '00'.   
           05  FILLER                           PIC X(05) VALUE SPACES. 
       01  WS-RPT-LINE.                                                 
           05  FILLER                           PIC X(132) VALUE ALL    
                                                    '='.                
                                                                        
       01  WS-RPT-HDR3.                                                 
           05  FILLER                           PIC X(2)  VALUE SPACES. 
           05  FILLER                           PIC X(11) VALUE         
                                                    'RPT DATE  '.       
           05  FILLER                           PIC X(04) VALUE         
                                                    'CO'.               
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(07) VALUE         
                                                    'LOC OFF'.          
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  FILLER                           PIC X(07) VALUE         
                                                    'CASHIER'.          
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(08) VALUE         
                                                    ' DRW ID '.         
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(07) VALUE         
                                                    ' SEQ NO'.          
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(07) VALUE         
                                                    ' GL NO '.          
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  FILLER                           PIC X(04) VALUE         
                                                    'TYPE'.             
           05  FILLER                           PIC X(06) VALUE SPACES. 
           05  FILLER                           PIC X(06) VALUE         
                                                    'AMOUNT'.           
           05  FILLER                           PIC X(04)  VALUE SPACES.
           05  FILLER                           PIC X(09)  VALUE        
                                                    ' MODE    '.        
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'TRAN COMMENT'.     
                                                                        
       01  WS-RPT-DTL.                                                  
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-CASH-RPT-DATE                 PIC X(10).              
           05  FILLER                           PIC X(02) VALUE SPACES. 
           05  WS-RPT-COMPANY-NO                PIC 9(02).              
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  WS-RPT-LOCAL-OFFICE              PIC 9(03).              
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  WS-RPT-CASHIER                   PIC X(08) VALUE SPACES. 
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-CASH-DRWR-ID              PIC 9(04).              
           05  FILLER                           PIC X(06) VALUE SPACES. 
           05  WS-RPT-OVERSHORT-ID              PIC X(04).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-GL-ACCT-NO                PIC 999.9999.           
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-TYPE                      PIC X(06).              
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-AMOUNT                    PIC --,--9.99.          
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-RPT-OFFSET-MODE-FL            PIC X(09) VALUE SPACES. 
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-TRAN-COMMENT              PIC X(38) VALUE SPACES. 
      *                                                                         
       01  WS-RPT-MESSAGE.                                              
           05  FILLER                           PIC X(25) VALUE SPACES. 
           05  WS-RPT-MSG                       PIC X(25).              
           05  FILLER                           PIC X(30) VALUE SPACES. 
           05  FILLER                           PIC X(15) VALUE         
                                                'TOTAL AMOUNT'.         
           05  FILLER                           PIC X(13) VALUE SPACES. 
           05  WS-RPT-TOTAL-AMOUNT              PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
                                                                        
       01  WS-GTOT-MESSAGE.                                             
           05  FILLER                           PIC X(75) VALUE SPACES. 
           05  FILLER                           PIC X(20) VALUE         
                                                'GRAND TOTAL AMOUNT  '. 
           05  FILLER                           PIC X(13) VALUE SPACES. 
           05  WS-GRAND-RPT-AMT                 PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
                                                                        
      *                                                                         
       01  WS-RPT-FTR.                                                  
           05 FILLER                            PIC X(25) VALUE SPACES. 
           05 FILLER                            PIC X(25) VALUE         
                                  '* * * END OF REPORT * * *'.          
           05 FILLER                            PIC X(82) VALUE SPACES. 
      ******************************************************************        
      **   COPYBOOKS USED IN THE PROGRAM                              **        
      ******************************************************************        
                                                                        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
                                                                        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_GL_ACCT-NO                                             **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBGLATNO                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_BANK                                                   **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBANK                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER                                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHIER                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER_OFFICE                                         **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHOFF                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_CNTL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCDCNTL                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_JRNL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBCDJRNL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_JOB_PARM                                               **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_REPORT_HDR                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSRPHD                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_COMPANY                                                     05370000
      ******************************************************************        
                                                                        
C33928     EXEC SQL                                                     05390000
C33928        INCLUDE TBCOMPNY                                          05400000
C33928     END-EXEC.                                                    05410000
                                                                        
      *****************************************************************         
      * OH - CSS_OVERSHORT_HDR                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHHD                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * OH - CSS_OVERSHORT_DET                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHDT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * OT - CSS_OVERSHORT_TYPE                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT CSS_OVERSHORT_HDR                                   
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE OVSH_CURSOR CURSOR FOR                              
             SELECT CASH_COMPANY_NO                                     
                   ,CASH_LOCAL_OFFICE                                   
                   ,DATE_CASH_REPORT                                    
                   ,CASH_DRAWER_ID                                      
                   ,OVERSHORT_ID                                        
                   ,USER_ID                                             
                   ,ACCOUNT_NO                                          
                   ,OVERSHORT_AMT                                       
                   ,OVERSHORT_DR_CR                                     
                   ,OFST_OVERSHORT_AMT                                  
                   ,OFST_DR_CR                                          
                   ,GL_ACCT_NO                                          
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), TRAN_TS, 121), 
           ' ', '-'), ':', '.') TRAN_TS                                        
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   ,OVERSHORT_TYPE_CD                                   
                   ,OVERSHORT_SOLTN_FL                                  
                   ,TRAN_COMMENT                                        
               FROM CSS_OVERSHORT_HDR OH WITH(READUNCOMMITTED)                  
               WHERE OH.OVERSHORT_AMT          <=                       
C33928              :WS-EXP-OVSH-LIMIT                                  
               AND   OH.OVERSHORT_AMT           > 0                     
               AND   OH.OFST_OVERSHORT_AMT      = 0                     
               AND   OH.OVERSHORT_SOLTN_FL      = 'P'                   
               AND   OH.GL_ACCT_NO              = 253.0200              
               AND   OH.OVERSHORT_TYPE_CD       = '01'                  
               AND   OH.DATE_CASH_REPORT        <                       
               DATEADD( DAY, -:WS-EXP-OVSH-LAG, IIF(TRY_CONVERT(DATE, 
                                                    :WS-CURRENT-DATE-OH
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE-OH
              ) <> 0) OR (LEN(:WS-CURRENT-DATE-OH
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE-OH
              ), CONVERT(DATE, :WS-CURRENT-DATE-OH) ) )        
               ORDER BY OH.CASH_LOCAL_OFFICE,OH.DATE_CASH_REPORT        
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE OVSH_CURSOR CURSOR FOR                                      
MFA-TR*      SELECT CASH_COMPANY_NO                                             
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,DATE_CASH_REPORT                                            
MFA-TR*            ,CASH_DRAWER_ID                                              
MFA-TR*            ,OVERSHORT_ID                                                
MFA-TR*            ,USER_ID                                                     
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,OVERSHORT_AMT                                               
MFA-TR*            ,OVERSHORT_DR_CR                                             
MFA-TR*            ,OFST_OVERSHORT_AMT                                          
MFA-TR*            ,OFST_DR_CR                                                  
MFA-TR*            ,GL_ACCT_NO                                                  
MFA-TR*            ,TRAN_TS                                                     
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,OVERSHORT_TYPE_CD                                           
MFA-TR*            ,OVERSHORT_SOLTN_FL                                          
MFA-TR*            ,TRAN_COMMENT                                                
MFA-TR*        FROM CSS_OVERSHORT_HDR OH                                        
MFA-TR*        WHERE OH.OVERSHORT_AMT          <=                               
MFA-TR*             :WS-EXP-OVSH-LIMIT                                          
MFA-TR*        AND   OH.OVERSHORT_AMT           > 0                             
MFA-TR*        AND   OH.OFST_OVERSHORT_AMT      = 0                             
MFA-TR*        AND   OH.OVERSHORT_SOLTN_FL      = 'P'                           
MFA-TR*        AND   OH.GL_ACCT_NO              = 253.0200                      
MFA-TR*        AND   OH.OVERSHORT_TYPE_CD       = '01'                          
MFA-TR*        AND   OH.DATE_CASH_REPORT        <                               
MFA-TR*        DATE(:WS-CURRENT-DATE-OH) - :WS-EXP-OVSH-LAG DAYS                
MFA-TR*        ORDER BY OH.CASH_LOCAL_OFFICE,OH.DATE_CASH_REPORT                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                DECLARE OVSHTYPE_CURSOR CURSOR FOR                      
                 SELECT OVERSHORT_TYPE_CD                               
                   FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                
                  WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                     
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OVSHTYPE_CURSOR CURSOR FOR                              
MFA-TR*          SELECT OVERSHORT_TYPE_CD                                       
MFA-TR*            FROM CSS_OVERSHORT_TYPE                                      
MFA-TR*           WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                             
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    'WORKING STORAGE FOR PCSCA425 ENDS HERE '.                  *        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 0500-SETUP-JOURNAL-CNTL                              
              THRU 0500-EXIT                                            
                                                                        
           DISPLAY 'OPEN CURSOR'                                        
           PERFORM 7961-OPEN-OVSH-TRAN                                  
              THRU 7961-EXIT.                                           
                                                                        
           DISPLAY 'FETCH CURSOR'                                       
           PERFORM 7962-FETCH-OVSH-TRAN                                 
              THRU 7962-EXIT.                                           
                                                                        
           DISPLAY 'CALL 1000   '                                       
           PERFORM 1000-PROCESS                                         
              THRU 1000-EXIT                                            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
           PERFORM 2967-PRINT-REPORT-FOOTER                             
              THRU 2967-EXIT                                            
                                                                        
           PERFORM 7963-CLOSE-OVSH-TRAN                                 
              THRU 7963-EXIT.                                           
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT.                                           
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT.                                           
           PERFORM 0400-SETUP-GL-ACCTS                                  
              THRU 0400-EXIT.                                           
           MOVE WS-COMPANY               TO C8-COMPANY-NO,              
                                            Y2-CASH-COMPANY-NO          
C33928     PERFORM 7400-SELECT-COMPANY   THRU 7400-EXIT                 
C33928     MOVE C7-COMPANY-NAME          TO WS-RPT-NAME                 
           MOVE WS-COMPANY               TO Y2-CASH-COMPANY-NO.         
           MOVE WS-PAYMENT-SOURCE-CD     TO Y2-PAYMENT-SOURCE-CD.       
           MOVE WS-COMPANY               TO C8-COMPANY-NO               
           MOVE 'EXP-OVSH-LAG'           TO C8-DELINQ-CD                
           PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-EXP-OVSH-LAG             
C33928     MOVE WS-COMPANY               TO C8-COMPANY-NO               
C33928     MOVE 'EXP-OVSH-LIMIT'         TO C8-DELINQ-CD                
C33928     PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT.                
C33928     MOVE C8-DELINQ-VALUE          TO WS-EXP-OVSH-LIMIT           
           MOVE WS-INPUT-DATE            TO WS-CURRENT-DATE-OH          
           PERFORM 7500-SELECT-CASH-OFFICE      THRU 7500-EXIT.         
           PERFORM 7700-GET-CURRENT-TIMESTAMP   THRU 7700-EXIT.         
           PERFORM 7560-SELECT-BANK-ST-CD       THRU 7560-EXIT.         
           MOVE '01'                     TO YR-CASH-COMPANY-NO          
           MOVE Y2-CASH-LOCAL-OFFICE     TO YR-CASH-LOCAL-OFFICE        
           MOVE WS-INPUT-DATE            TO YR-DATE-CASH-REPORT         
           MOVE Y2-USER-ID               TO YR-USER-ID                  
           MOVE 'C'                      TO YR-STATUS                   
           MOVE WS-XFR-TS                TO YR-CLOSED-TS                
           PERFORM 8325-CREATE-CASH-REPORT      THRU 8325-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0200-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0200-OPEN-FILES.                                                 
      *---------------*                                                         
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0300-SETUP-DATES                                            **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
      *----------------*                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
                                                                        
           MOVE 'PCSCA425'               TO WS-PGRMNAME                 
           MOVE WS-PGRMNAME              TO WS-RPT-ID                   
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSCA425'            TO WS-PGRMNAME                 
           END-IF.                                                      
      *    FORMATING DATE FOR REPORT HEADER.                                    
                                                                        
            ACCEPT WS-RUN-DATE               FROM DATE.                 
            IF WS-DT-YY    >   50                                       
               MOVE  WS-19               TO WS-CUR-CC                   
            ELSE                                                        
               MOVE  WS-20               TO WS-CUR-CC                   
            END-IF.                                                     
                                                                        
                                                                        
            MOVE WS-DT-MM                TO WS-REP-MM.                  
            MOVE WS-DT-YY                TO WS-CUR-YY.                  
            MOVE WS-CUR-YY               TO WS-REP-YY.                  
            MOVE WS-DT-DD                TO WS-REP-DD.                  
                                                                        
            MOVE WS-REPORT-DATE          TO WS-RPT-DATE.                
                                                                        
      *    FORMATING TIME FOR REPORT HEADER.                                    
                                                                        
           ACCEPT WS-RUN-TIME               FROM TIME.                  
                                                                        
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-REPORT-TIME         TO WS-RPT-TIME.                  
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0400-SETUP-GL-ACCTS                                         **        
      **                                                              **        
      ******************************************************************        
       0400-SETUP-GL-ACCTS.                                             
      *-------------------*                                                     
           MOVE '0400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-LIT-ZERO              TO CJ-CUSTOMER-NO.             
           MOVE WS-COMPANY               TO GO-COMPANY-NO.              
           MOVE 'CLR-CASH'               TO GO-GL-ACCT-NAME.            
                                                                        
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-CASH-GL-ACCT.            
                                                                        
           MOVE 'CLR-PST-ER'             TO GO-GL-ACCT-NAME.            
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-BNKXFR-GL-ACCT.          
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0500-SETUP-JOURNAL-CNTL.                                         
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE Y2-CASH-LOCAL-OFFICE     TO CS-CASH-LOCAL-OFFICE.       
           MOVE WS-LIT-C                 TO CS-CODE-CSH-DRWR-STAT.      
           MOVE WS-INPUT-DATE            TO CS-DATE-CASH-REPORT         
                                                                        
                                                                        
                                                                        
           PERFORM 7310-SELECT-MAX-CSH-CNTL                             
              THRU 7310-EXIT                                            
                                                                        
           PERFORM 2120-SET-CASH-DRWR-CNTL-VALUES                       
              THRU 2120-EXIT                                            
                                                                        
           PERFORM 8200-CREATE-CASH-DRWR-CNTL                           
              THRU 8200-EXIT                                            
           MOVE '01'                      TO WS-CASH-COMPANY-NO-OH      
           MOVE CS-CASH-LOCAL-OFFICE      TO WS-CASH-LOCAL-OFFICE-OH    
           MOVE CS-DATE-CASH-REPORT       TO WS-DATE-CASH-REPORT-OH     
           MOVE CS-CASH-DRAWER-ID         TO WS-CASH-DRAWER-ID-OH       
           PERFORM 7968-GET-OVSH-ID       THRU 7968-EXIT.               
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **    1000-PROCESS                                              **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       1000-PROCESS.                                                    
      *--------------------*                                                    
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT        
                                                                        
                                                                        
           PERFORM 1100-SUM-AMOUNT                                      
              THRU 1100-EXIT.                                           
                                                                        
           PERFORM 2960-PRINT-REPORT-DETAIL                             
              THRU 2960-EXIT                                            
                                                                        
           PERFORM 7962-FETCH-OVSH-TRAN                                 
              THRU 7962-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **    1100-SUM-AMOUNT                                           **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       1100-SUM-AMOUNT.                                                 
      *--------------------*                                                    
           MOVE '1100'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           IF OH-OFFSET-MODE-FL = 'A'                                   
              MOVE OH-OFFSET-MODE-FL        TO WS-OFFSET-MODE-FL        
           END-IF.                                                      
                                                                        
           IF OH-OVERSHORT-DR-CR = 'D'                                  
             ADD OH-OVERSHORT-AMT           TO WS-AUT-SHORT-AMT         
           ELSE                                                         
             ADD OH-OVERSHORT-AMT           TO WS-AUT-OVER-AMT          
           END-IF.                                                      
                                                                        
           PERFORM 1200-JOURNAL                                         
              THRU 1200-EXIT.                                           
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **       1200-JOURNAL                                           **        
      **                                                              **        
      ******************************************************************        
       1200-JOURNAL.                                                    
      *--------------------*                                                    
      *   POPULATES JOURNAL RECORD                                              
                                                                        
           PERFORM 2150-SET-CASH-DRWR-JRNL-VALUES                       
              THRU 2150-EXIT.                                           
                                                                        
      *   POPULATES TRAN-DATA VALUES - COPYBOOK CJF00101                        
           DISPLAY 'CASH OFFICE', CS-CASH-LOCAL-OFFICE                  
                                                                        
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
                                                                        
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           IF OH-OVERSHORT-DR-CR = 'C'                                  
              MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-DR   
              MOVE 253.0700                 TO WS-101-ACCT-GEN-LED-CR   
           ELSE                                                         
              MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-CR   
              MOVE 253.0700                 TO WS-101-ACCT-GEN-LED-DR   
           END-IF                                                       
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
           MOVE 2                        TO CJ-TRAN-APPL-NO.            
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
           DISPLAY 'DRAWER', CJ-CASH-DRAWER-ID                          
                                                                        
           ADD WS-ONE                       TO CS-NO-ITEMS-ENTERED      
           ADD OH-OVERSHORT-AMT             TO CS-AMT-CASH-DEBIT,       
                                               CS-AMT-CASH-CREDIT       
           MOVE WS-CASHIER-USER-ID          TO CS-USER-ID               
           MOVE Y1-CASHIER-CODE             TO CS-CASHIER-CODE          
           MOVE WS-INPUT-DATE               TO CS-DATE-LAST-ACTIVITY    
           PERFORM 8600-UPDATE-CASH-DRWR-CNTL                           
              THRU 8600-EXIT.                                           
           PERFORM 1600-INSERT-OVSH                                     
              THRU 1600-EXIT.                                           
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **  1600-INSERT-OVSH.                                           **        
      **                                                              **        
      ******************************************************************        
       1600-INSERT-OVSH.                                                
      *--------------------*                                                    
                                                                        
           MOVE 253.0700                  TO WS-GL-ACCT-NO-OH           
           MOVE OH-OVERSHORT-AMT          TO WS-OVERSHORT-AMT-OH        
           MOVE OH-OVERSHORT-DR-CR        TO WS-OVERSHORT-DR-CR-OH      
           ADD  1                         TO WS-OVERSHORT-ID-OH         
           MOVE '01'                      TO WS-CASH-COMPANY-NO-OH      
           MOVE CS-CASH-LOCAL-OFFICE      TO WS-CASH-LOCAL-OFFICE-OH    
           MOVE CS-DATE-CASH-REPORT       TO WS-DATE-CASH-REPORT-OH     
           MOVE CS-CASH-DRAWER-ID         TO WS-CASH-DRAWER-ID-OH       
           MOVE Y2-USER-ID                TO WS-USER-ID-OH              
           MOVE WS-COMMENT-LEN            TO WS-TRAN-COMMENT-LEN-OH     
           MOVE WS-COMMENT-TEXT           TO WS-TRAN-COMMENT-TEXT-OH    
           MOVE WS-P                      TO WS-OVERSHORT-SOLTN-FL-OH   
           MOVE WS-GL-ACCT-NO-OH          TO OT-GL-ACCT-NO              
           PERFORM 7964-DECLARE-OVSH-TYPE THRU 7964-EXIT                
           PERFORM 7965-FETCH-OVSH-TYPE   THRU 7965-EXIT                
           PERFORM 7966-CLOSE-OVSH-TYPE   THRU 7966-EXIT                
           MOVE OT-OVERSHORT-TYPE-CD      TO WS-OVERSHORT-TYPE-CD-OH    
           MOVE ZERO                      TO WS-OFST-OVERSHORT-AMT-OH   
           MOVE ZERO                      TO WS-ACCOUNT-NO-OH           
           MOVE SPACES                    TO WS-OFST-DR-CR-OH           
           PERFORM  8750-INSERT-OVERSHORT                               
              THRU  8750-EXIT                                           
                                                                        
           MOVE 253.0200                  TO WS-GL-ACCT-NO-OH           
           MOVE WS-GL-ACCT-NO-OH          TO OT-GL-ACCT-NO              
           PERFORM 7964-DECLARE-OVSH-TYPE THRU 7964-EXIT                
           PERFORM 7965-FETCH-OVSH-TYPE   THRU 7965-EXIT                
           PERFORM 7966-CLOSE-OVSH-TYPE   THRU 7966-EXIT                
           MOVE OT-OVERSHORT-TYPE-CD      TO WS-OVERSHORT-TYPE-CD-OH    
           MOVE OH-OVERSHORT-AMT          TO WS-OVERSHORT-AMT-OH        
           MOVE OH-OVERSHORT-AMT          TO WS-OFST-OVERSHORT-AMT-OH   
           ADD  1                         TO WS-OVERSHORT-ID-OH         
           MOVE 'S'                       TO WS-OVERSHORT-SOLTN-FL-OH   
           IF OH-OVERSHORT-DR-CR = 'C'                                  
              MOVE 'D'                    TO WS-OVERSHORT-DR-CR-OH      
              MOVE 'C'                    TO WS-OFST-DR-CR-OH           
           ELSE                                                         
              MOVE 'C'                    TO WS-OVERSHORT-DR-CR-OH      
              MOVE 'D'                    TO WS-OFST-DR-CR-OH           
           END-IF                                                       
           PERFORM  8750-INSERT-OVERSHORT                               
              THRU  8750-EXIT.                                          
           MOVE WS-CASH-COMPANY-NO-OH     TO  OD-CASH-COMPANY-NO        
           MOVE WS-CASH-LOCAL-OFFICE-OH   TO  OD-CASH-LOCAL-OFFICE      
           MOVE WS-DATE-CASH-REPORT-OH    TO  OD-DATE-CASH-REPORT       
           MOVE WS-CASH-DRAWER-ID-OH      TO  OD-CASH-DRAWER-ID         
           MOVE WS-OVERSHORT-ID-OH        TO  OD-OVERSHORT-ID           
           MOVE 1                         TO  OD-OVERSHORT-SEQ-NO       
           MOVE WS-OVERSHORT-AMT-OH       TO  OD-OFST-OVERSHORT-AMT     
           MOVE WS-OFST-DR-CR-OH          TO  OD-OFST-DR-CR             
           MOVE OH-CASH-COMPANY-NO        TO  OD-OFST-COMPANY-NO        
           MOVE OH-CASH-LOCAL-OFFICE      TO  OD-OFST-LOC-OFCE          
           MOVE OH-DATE-CASH-REPORT       TO  OD-OFST-CASH-REPT-DT      
           MOVE OH-CASH-DRAWER-ID         TO  OD-OFST-CASH-DRWR-ID      
           MOVE OH-OVERSHORT-ID           TO  OD-OFST-OVERSHORT-ID      
                                                                        
           PERFORM  8751-INSERT-OVERSHORT-DET                           
              THRU  8751-EXIT.                                          
           MOVE OH-OVERSHORT-AMT          TO OH-OFST-OVERSHORT-AMT      
           IF OH-OVERSHORT-DR-CR = 'C'                                  
              MOVE 'D'                    TO OH-OFST-DR-CR              
           ELSE                                                         
              MOVE 'C'                    TO OH-OFST-DR-CR              
           END-IF                                                       
                                                                        
           PERFORM  8760-UPDATE-OVERSHORT                               
              THRU  8760-EXIT.                                          
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **  2120-SET-CASH-DRWR-CNTL-VALUES                              **        
      **                                                              **        
      ******************************************************************        
       2120-SET-CASH-DRWR-CNTL-VALUES.                                  
      *-------------------------*                                               
           MOVE '2120'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE WS-CASHIER-CASH-OFFICE   TO CS-CASH-LOCAL-OFFICE,       
                                            CS-CASH-REPORT-NO.          
           MOVE WS-CASHIER-USER-ID       TO CS-USER-ID.                 
                                                                        
           MOVE WS-ZERO                  TO CS-AMT-CASH-DEBIT,          
                                            CS-AMT-CASH-CREDIT,         
                                            CS-AMT-AR-DEBIT,            
                                            CS-AMT-AR-CREDIT,           
                                            CS-AMT-CK-ISS-DEBIT,        
                                            CS-AMT-CK-ISS-CREDIT,       
                                            CS-AMT-GL-DEBIT,            
                                            CS-AMT-GL-CREDIT,           
                                            CS-AMT-CASH-BEGIN-BAL,      
                                            CS-AMT-BASIC-WORK.          
                                                                        
           MOVE WS-INPUT-DATE            TO CS-DATE-CASH-REPORT         
           MOVE 0                        TO CS-AMT-CASH-DEBIT           
                                            CS-AMT-CASH-CREDIT          
           MOVE WS-M                     TO CS-CODE-PYMT-FACILITY       
                                                                        
           MOVE 1                        TO CS-NO-ITEMS-ENTERED.        
                                                                        
           MOVE WS-INPUT-DATE            TO CS-DATE-LAST-ACTIVITY.      
           MOVE Y1-CASHIER-CODE          TO CS-CASHIER-CODE.            
           MOVE SPACES                   TO CS-CODE-FCS-EXTRACTED.      
                                                                        
           MOVE WS-XFR-TS                TO CS-BALANCED-TS              
           MOVE WS-ZERO                  TO WS-CNTL-TS-NI               
           MOVE WS-CASHIER-USER-ID       TO CS-BALANCED-BY              
              .                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2150-SET-CASH-DRWR-JRNL-VALUES                              **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       2150-SET-CASH-DRWR-JRNL-VALUES.                                  
      *------------------------------*                                          
           MOVE '2150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE CS-CASH-COMPANY-NO       TO CJ-CASH-COMPANY-NO,         
                                            CJ-COMPANY-NO.              
           MOVE CS-CASH-LOCAL-OFFICE     TO CJ-CASH-LOCAL-OFFICE,       
                                            CJ-CASH-REPORT-NO.          
           MOVE WS-ONE                   TO CJ-TRAN-APPL-NO.            
           MOVE CS-NO-ITEMS-ENTERED      TO CJ-ENTRY-NO.                
           MOVE CS-CASH-DRAWER-ID        TO CJ-CASH-DRAWER-ID.          
           MOVE Y2-LOCAL-OFFICE          TO CJ-LOCAL-OFFICE,            
                                            CJ-ENTRY-LOC.               
           MOVE WS-LIT-A                 TO CJ-JRNL-SORT-ID.            
           MOVE 9999999999999            TO CJ-ACCOUNT-NO.              
           MOVE WS-ZERO                  TO CJ-GL-ACCT-NO.              
           MOVE WS-METER-NO              TO CJ-METER-NO.                
           MOVE WS-ZERO                  TO CJ-TRAN-COMMENT-LEN.        
           MOVE SPACES                   TO CJ-TRAN-COMMENT-TEXT.       
                                                                        
           MOVE WS-TRAN-TIME             TO CJ-TRAN-TIME.               
           MOVE WS-TRAN-ID               TO CJ-TRAN-ID.                 
           MOVE CS-DATE-CASH-REPORT      TO CJ-DATE-CASH-REPORT.        
           MOVE WS-INPUT-DATE            TO CJ-DATE-TRAN.               
           MOVE WS-INPUT-DATE            TO CJ-DATE-LAST-ACTION.        
           MOVE WS-LIT-C                 TO CJ-CODE-ENTRY-SOURCE.       
           MOVE CS-USER-ID               TO CJ-USER-ID.                 
           MOVE SPACES                   TO CJ-BATCH-SEND-LOC.          
           MOVE SPACES                   TO CJ-ENTRY-LOC.               
           MOVE SPACES                   TO CJ-CODE-TRAN-ERRORS.        
           MOVE SPACES                   TO CJ-CODE-JRNL-EXTRACT.       
           MOVE SPACES                   TO CJ-CODE-STATUS.             
           MOVE WS-LIT-C                 TO CJ-CURRENCY-TYPE.           
           MOVE CS-CODE-PYMT-FACILITY    TO CJ-CODE-PYMT-FACILITY.      
           MOVE SPACES                   TO CJ-CSR-PC-ID.               
           MOVE WS-ZERO                  TO CJ-CUSTOMER-NO.             
                                                                        
           MOVE SPACES                   TO CJ-BALANCED-BY.             
           MOVE -1                       TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI.              
                                                                        
           MOVE WS-INPUT-DATE        TO CJ-DATE-BALANCED                
           MOVE WS-TRAN-TIME         TO CJ-TIME-BALANCED                
           MOVE WS-ZERO              TO WS-CJ-DATE-NI                   
                                        WS-CJ-TIME-NI                   
           MOVE WS-CASHIER-USER-ID   TO CJ-BALANCED-BY                  
           .                                                            
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2160-POPULATE-TRAN-DATA                                     **        
      **                                                              **        
      ******************************************************************        
       2160-POPULATE-TRAN-DATA.                                         
      *-----------------------*                                                 
           MOVE '2160'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO CJF00101.                   
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO.      
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED.    
                                                                        
           MOVE OH-OVERSHORT-AMT         TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
           IF OH-OVERSHORT-DR-CR = 'C'                                  
              MOVE 253.0200                 TO WS-101-ACCT-GEN-LED-DR   
              MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-CR   
           ELSE                                                         
              MOVE 253.0200                 TO WS-101-ACCT-GEN-LED-CR   
              MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-DR   
           END-IF                                                       
                                                                        
                                                                        
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO,          
                                            WS-101-DETAIL-END-AR-BAL,   
                                            WS-101-ACCT-END-AR-BAL,     
                                            WS-101-REVENUE-MONTH.       
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO WS-101-FCS-DEP-BANK-CD.     
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD.  
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 2960-PRINT-REPORT-DETAIL                                     **        
      **                                                              **        
      ******************************************************************        
       2960-PRINT-REPORT-DETAIL.                                        
      *-----------------------*                                                 
                                                                        
            MOVE '2960'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE WS-PGRMNAME                  TO WS-RPT-ID.             
            MOVE OH-OVERSHORT-AMT             TO WS-RPT-AMOUNT.         
            MOVE OH-CASH-COMPANY-NO           TO WS-RPT-COMPANY-NO      
            MOVE OH-DATE-CASH-REPORT          TO WS-CASH-RPT-DATE       
            MOVE OH-CASH-LOCAL-OFFICE         TO WS-RPT-LOCAL-OFFICE    
            MOVE OH-CASH-DRAWER-ID            TO WS-RPT-CASH-DRWR-ID    
            MOVE OH-OVERSHORT-ID              TO WS-RPT-OVERSHORT-ID    
            MOVE OH-USER-ID                   TO WS-RPT-CASHIER         
            MOVE OH-GL-ACCT-NO                TO WS-RPT-GL-ACCT-NO      
C33928      MOVE SPACES                       TO WS-RPT-TRAN-COMMENT    
            MOVE OH-TRAN-COMMENT-TEXT         TO WS-RPT-TRAN-COMMENT    
            MOVE 'AUTOMATIC'                  TO WS-RPT-OFFSET-MODE-FL  
                                                                        
            IF OH-OVERSHORT-DR-CR = 'D'                                 
               MOVE 'SHORT'                   TO WS-RPT-TYPE            
            ELSE                                                        
               MOVE 'OVER'                    TO WS-RPT-TYPE            
            END-IF                                                      
                                                                        
            IF WS-LINE-CNTR > WS-FIFTY-FIVE                             
               PERFORM     2965-PRINT-REPORT-HEADER                     
                  THRU     2965-EXIT                                    
                                                                        
               PERFORM     2970-MOVE-DETAIL-TO-REPORT                   
                  THRU     2970-EXIT                                    
                                                                        
               MOVE WS-TWO                      TO WS-LINE-SPACE        
            END-IF.                                                     
                                                                        
            COMPUTE WS-LINE-DIFF = WS-FIFTY-FIVE - WS-LINE-CNTR         
            END-COMPUTE                                                 
                                                                        
            IF WS-LINE-DIFF > 5                                         
               PERFORM     2970-MOVE-DETAIL-TO-REPORT                   
                  THRU     2970-EXIT                                    
                                                                        
               MOVE WS-ZERO                     TO WS-LINE-DIFF         
               MOVE WS-TWO                      TO WS-LINE-SPACE        
            ELSE                                                        
               PERFORM     2965-PRINT-REPORT-HEADER                     
                 THRU     2965-EXIT                                     
                                                                        
               PERFORM     2970-MOVE-DETAIL-TO-REPORT                   
                 THRU     2970-EXIT                                     
                                                                        
               MOVE WS-TWO                      TO WS-LINE-SPACE        
            END-IF.                                                     
                                                                        
           MOVE  WS-RPT-DTL                 TO PRT33-DATA.              
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
           MOVE  WS-ONE                     TO WS-LINE-SPACE.           
                                                                        
           ADD  WS-ONE                      TO WS-LINE-CNTR.            
                                                                        
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2965-PRINT-REPORT-HEADER                                      *        
      ******************************************************************        
       2965-PRINT-REPORT-HEADER.                                        
      *-----------------------*                                                 
                                                                        
            MOVE '2965'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE WS-ZERO                      TO WS-LINE-CNTR.          
            ADD  WS-ONE                       TO WS-PAGE-NUM.           
            MOVE WS-PAGE-NUM                  TO WS-PAGE-NO.            
                                                                        
      ***   INCREMENTS THE PAGENO AND PRINTS THE HEADER                         
      ***   AFTER ADVANCING ONE PAGE                                            
                                                                        
            MOVE WS-RPT-HDR1                  TO PRT33-DATA.            
                                                                        
            PERFORM    2975-WRITE-FIRST-HEADER                          
               THRU    2975-EXIT.                                       
                                                                        
      ***  PRINT THE TITLE AND TIME                                             
                                                                        
                                                                        
            MOVE WS-RPT-HDR2                   TO PRT33-DATA.           
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
                                                                        
            MOVE WS-PAGE-HDR                   TO PRT33-DATA.           
                                                                        
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
                                                                        
      ***   PRINTS  ======                                                      
                                                                        
            MOVE WS-RPT-LINE                   TO PRT33-DATA.           
            MOVE WS-TWO                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM    2985-WRITE-RECORD                                
               THRU    2985-EXIT.                                       
                                                                        
      ***   PRINTS THE  COMPANY DETAILS              ***                        
                                                                        
            MOVE WS-RPT-HDR3                  TO PRT33-DATA.            
            MOVE WS-ONE                       TO WS-LINE-SPACE.         
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
                                                                        
      ***   PRINTS ======                             ***                       
                                                                        
            MOVE WS-RPT-LINE                   TO PRT33-DATA.           
                                                                        
            PERFORM    2985-WRITE-RECORD                                
               THRU    2985-EXIT.                                       
                                                                        
            MOVE WS-SIX                       TO WS-LINE-CNTR.          
                                                                        
       2965-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *                                                                         
      ******************************************************************        
      *  2966-PRINT-REPORT-HEADER                                      *        
      ******************************************************************        
       2966-PRINT-REPORT-HEADER.                                        
      *-----------------------*                                                 
                                                                        
            MOVE '2966'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            MOVE WS-ZERO                      TO WS-LINE-CNTR.          
            ADD  WS-ONE                       TO WS-PAGE-NUM.           
            MOVE WS-PAGE-NUM                  TO WS-PAGE-NO.            
                                                                        
      ***   INCREMENTS THE PAGENO AND PRINTS THE HEADER                         
      ***   AFTER ADVANCING ONE PAGE                                            
                                                                        
            MOVE WS-RPT-HDR1                  TO PRT33-DATA.            
                                                                        
            PERFORM    2975-WRITE-FIRST-HEADER                          
               THRU    2975-EXIT.                                       
                                                                        
      ***  PRINT THE TITLE AND TIME                                             
                                                                        
                                                                        
            MOVE WS-RPT-HDR2                   TO PRT33-DATA.           
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
                                                                        
            MOVE WS-PAGE-HDR                   TO PRT33-DATA.           
                                                                        
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
                                                                        
       2966-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  2967-PRINT-REPORT-FOOTER                                      *        
      ******************************************************************        
       2967-PRINT-REPORT-FOOTER.                                        
      *-----------------------*                                                 
                                                                        
            MOVE '2967'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            PERFORM 2966-PRINT-REPORT-HEADER  THRU 2966-EXIT.           
                                                                        
            MOVE WS-TWO                        TO WS-LINE-SPACE.        
                                                                        
            MOVE WS-RPT-SUM-HDG           TO PRT33-DATA.                
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM    2977-WRITE-FIRST-HEADER                          
               THRU    2977-EXIT.                                       
                                                                        
            MOVE WS-RPT-SUM-HDG1           TO PRT33-DATA.               
            MOVE WS-ONE                    TO WS-LINE-SPACE.            
                                                                        
            PERFORM     2985-WRITE-RECORD                               
               THRU     2985-EXIT.                                      
            MOVE WS-AUT-SHORT-AMT              TO WS-AMT-AUT-SHORT      
            MOVE WS-AUT-OVER-AMT               TO WS-AMT-AUT-OVER       
                                                                        
            MOVE WS-RPT-SUM-DTL-OVER           TO PRT33-DATA.           
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM    2985-WRITE-RECORD                                
               THRU    2985-EXIT.                                       
            MOVE WS-RPT-SUM-DTL-SHORT          TO PRT33-DATA.           
            MOVE WS-ONE                        TO WS-LINE-SPACE.        
                                                                        
            PERFORM    2985-WRITE-RECORD                                
              THRU    2985-EXIT.                                        
                                                                        
            IF WS-AUT-OVER-AMT > WS-AUT-SHORT-AMT                       
               COMPUTE                                                  
               WS-NET-OVER-AMT = WS-AUT-OVER-AMT - WS-AUT-SHORT-AMT     
               END-COMPUTE                                              
               MOVE WS-NET-OVER-AMT TO WS-RPT-NET-OVER-AMT              
               MOVE WS-RPT-NET-DTL-OVER TO PRT33-DATA                   
               MOVE WS-ONE                        TO WS-LINE-SPACE      
C33928         MOVE WS-RPT-FTR                    TO PRT33-DATA         
               PERFORM    2976-WRITE-FOOTER                             
                  THRU    2976-EXIT                                     
            ELSE                                                        
               COMPUTE                                                  
               WS-NET-SHORT-AMT = WS-AUT-SHORT-AMT - WS-AUT-OVER-AMT    
               END-COMPUTE                                              
               MOVE WS-NET-SHORT-AMT TO WS-RPT-NET-SHORT-AMT            
               MOVE WS-RPT-NET-DTL-SHORT TO PRT33-DATA                  
               MOVE WS-ONE                        TO WS-LINE-SPACE      
C33928         MOVE WS-RPT-FTR                    TO PRT33-DATA         
               PERFORM    2976-WRITE-FOOTER                             
                  THRU    2976-EXIT                                     
            END-IF.                                                     
       2967-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      ** 2970-MOVE-DETAIL-TO-REPORT*                                            
      ****************************************************************          
       2970-MOVE-DETAIL-TO-REPORT.                                      
      *-----------------------*                                                 
                                                                        
            MOVE '2970'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
                                                                        
            ADD WS-ONE                        TO WS-LINE-CNTR.          
                                                                        
       2970-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      ** 2975-WRITE-FIRST-HEADER*                                               
      ****************************************************************          
       2975-WRITE-FIRST-HEADER.                                         
      *-----------------------*                                                 
                                                                        
            MOVE '2975'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            WRITE PRT33-RECORD AFTER ADVANCING PAGE.                    
                                                                        
       2975-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      ** 2977-WRITE-FIRST-HEADER*                                               
      ****************************************************************          
       2977-WRITE-FIRST-HEADER.                                         
      *-----------------------*                                                 
                                                                        
            MOVE '2977'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            WRITE PRT33-RECORD.                                         
                                                                        
       2977-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      ** 2976-WRITE-FOOTER*                                                     
      ****************************************************************          
       2976-WRITE-FOOTER.                                               
      *-----------------------*                                                 
                                                                        
            MOVE '2976'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            WRITE PRT33-RECORD.                                         
                                                                        
       2976-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      ** 2985-WRITE-RECORD                                           *          
      ****************************************************************          
       2985-WRITE-RECORD.                                               
      *-----------------------*                                                 
                                                                        
            MOVE '2985'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
            WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.           
                                                                        
       2985-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
       7310-SELECT-MAX-CSH-CNTL.                                        
      *--------------------------*                                              
           MOVE '7310'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT MAX(CASH_DRAWER_ID) + 1                              
             INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1                        
             FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
            WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO           
             AND  CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE         
             AND  DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
             AND  CASH_DRAWER_ID        > 0                             
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT MAX(CASH_DRAWER_ID) + 1                                      
MFA-TR*      INTO :CS-CASH-DRAWER-ID                                            
MFA-TR*           :WS-NULL-INDICATOR1                                           
MFA-TR*      FROM CSS_CSH_DRWR_CNTL                                             
MFA-TR*     WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO                   
MFA-TR*      AND  CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*      AND  DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT                  
MFA-TR*      AND  CASH_DRAWER_ID        > 0                                     
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                              OR NOT-FOUND                              
               IF WS-NULL-INDICATOR1 < 0                                
                  MOVE 1 TO CS-CASH-DRAWER-ID                           
               END-IF                                                   
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING ' ERROR SELECTING CASH DRAWER ID **'              
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * READ COMPANY USER TABLE TO GET COMPANY NAME                   *         
      *                                                               *         
      *****************************************************************         
C33928 7400-SELECT-COMPANY.                                             
C33928*-----------------------*                                                 
C33928     MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
C33928     EXEC SQL                                                     
C33928        SELECT                                                    
C33928          COMPANY_NAME                                            
C33928        INTO :C7-COMPANY-NAME                                     
C33928        FROM CSS_COMPANY WITH(READUNCOMMITTED)                            
C33928        WHERE COMPANY_NO ='01'                                    
C33928                                                           
C33928     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         COMPANY_NAME                                                    
MFA-TR*       INTO :C7-COMPANY-NAME                                             
MFA-TR*       FROM CSS_COMPANY                                                  
MFA-TR*       WHERE COMPANY_NO ='01'                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33928     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C33928     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
C33928        OR NOT-FOUND                                              
C33928        NEXT SENTENCE                                             
C33928      ELSE                                                        
C33928         STRING 'ERROR SELECTING COMPANY NAME'                    
C33928                                   DELIMITED BY SIZE              
C33928                                   INTO WS-ERR-MSG                
C33928         STRING 'CANNOT GET C7-COMPANY-NAME'                      
C33928                                   DELIMITED BY SIZE              
C33928                                   INTO WS-ERR-MSG2               
C33928        PERFORM 8800-DIS-TABLE-ERROR                              
C33928          THRU 8800-EXIT                                          
C33928     END-IF.                                                      
C33928 7400-EXIT.                                                       
C33928     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7500-SELECT-CASH-OFFICE                                     **        
      **                                                              **        
      ******************************************************************        
       7500-SELECT-CASH-OFFICE.                                         
      *-----------------------*                                                 
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
                                                                        
           EXEC SQL                                                     
            SELECT CASH_LOCAL_OFFICE,                                   
                   BATCH_DEP_CASH_OFF,                                  
                   DEP_XFER_METHOD,                                     
                   USER_ID,                                             
                   DEP_DEFT_BANK_ID,                                    
                   LOCAL_OFFICE,                                        
                   DEP_CASH_GL_OFFSET,                                  
                   PAYMENT_AGENT_FL,                                    
                   PYMT_TO_POST_DAYS,                                   
                   ERROR_GL_OFFSET                                      
             INTO :Y2-CASH-LOCAL-OFFICE,                                
                  :Y2-BATCH-DEP-CASH-OFF,                               
                  :Y2-DEP-XFER-METHOD,                                  
                  :Y2-USER-ID,                                          
                  :Y2-DEP-DEFT-BANK-ID,                                 
                  :Y2-LOCAL-OFFICE,                                     
                  :Y2-DEP-CASH-GL-OFFSET,                               
                  :Y2-PAYMENT-AGENT-FL,                                 
                  :Y2-PYMT-TO-POST-DAYS,                                
                  :Y2-ERROR-GL-OFFSET                                   
             FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                      
            WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO            
             AND  PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD          
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CASH_LOCAL_OFFICE,                                           
MFA-TR*            BATCH_DEP_CASH_OFF,                                          
MFA-TR*            DEP_XFER_METHOD,                                             
MFA-TR*            USER_ID,                                                     
MFA-TR*            DEP_DEFT_BANK_ID,                                            
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            DEP_CASH_GL_OFFSET,                                          
MFA-TR*            PAYMENT_AGENT_FL,                                            
MFA-TR*            PYMT_TO_POST_DAYS,                                           
MFA-TR*            ERROR_GL_OFFSET                                              
MFA-TR*      INTO :Y2-CASH-LOCAL-OFFICE,                                        
MFA-TR*           :Y2-BATCH-DEP-CASH-OFF,                                       
MFA-TR*           :Y2-DEP-XFER-METHOD,                                          
MFA-TR*           :Y2-USER-ID,                                                  
MFA-TR*           :Y2-DEP-DEFT-BANK-ID,                                         
MFA-TR*           :Y2-LOCAL-OFFICE,                                             
MFA-TR*           :Y2-DEP-CASH-GL-OFFSET,                                       
MFA-TR*           :Y2-PAYMENT-AGENT-FL,                                         
MFA-TR*           :Y2-PYMT-TO-POST-DAYS,                                        
MFA-TR*           :Y2-ERROR-GL-OFFSET                                           
MFA-TR*      FROM CSS_CASHIER_OFFICE                                            
MFA-TR*     WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO                    
MFA-TR*      AND  PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD                  
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               STRING ' ERROR GETTING CASH OFFICE, USER ID  **'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE          
                      Y2-CASH-COMPANY-NO     DELIMITED BY SIZE          
                      'PAYMENT CODE  '       DELIMITED BY SIZE          
                      Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
           MOVE  Y2-CASH-LOCAL-OFFICE  TO WS-CASHIER-CASH-OFFICE.       
           MOVE  Y2-BATCH-DEP-CASH-OFF TO WS-BATCH-DEP-CASH-OFF.        
           MOVE  Y2-DEP-XFER-METHOD    TO WS-DEP-XFER-METHOD.           
           MOVE  Y2-USER-ID            TO WS-CASHIER-USER-ID.           
           MOVE  Y2-LOCAL-OFFICE       TO WS-CASHIER-LOCAL-OFFICE.      
           MOVE  Y2-DEP-DEFT-BANK-ID   TO WS-CASHIER-BANK-ID.           
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7560-SELECT-BANK-ST-CD                                      **        
      **                                                              **        
      ******************************************************************        
       7560-SELECT-BANK-ST-CD.                                          
      *----------------------*                                                  
           MOVE '7560'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO D1-BANK-ID.                 
                                                                        
           EXEC SQL                                                     
             SELECT FCS_DEP_BANK_ST_CD                                  
               INTO :D1-FCS-DEP-BANK-ST-CD                              
               FROM CSS_BANK WITH(READUNCOMMITTED)                              
              WHERE BANK_ID = :D1-BANK-ID                               
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT FCS_DEP_BANK_ST_CD                                          
MFA-TR*        INTO :D1-FCS-DEP-BANK-ST-CD                                      
MFA-TR*        FROM CSS_BANK                                                    
MFA-TR*       WHERE BANK_ID = :D1-BANK-ID                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING  'ERROR GETTING BANK ST CD  **'                   
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'BANK ID '      DELIMITED BY SIZE                 
                 WS-CASHIER-BANK-ID   DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7700-GET-CURRENT-TIMESTAMP                                  **        
      **                                                              **        
      ******************************************************************        
       7700-GET-CURRENT-TIMESTAMP.                                      
      *--------------------------*                                              
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-XFR-TS,
              :WS-TRAN-TIME,
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-XFR-TS        = CURRENT TIMESTAMP                         
MFA-TR*          ,:WS-TRAN-TIME     = CURRENT TIME                              
MFA-TR*          ,:WS-CURRENT-DATE  = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR GETTING TIMESTAMP VALUE **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
                                                                        
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7800-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7800-SELECT-DATABASE.                                            
      *---------------------*                                                   
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT DELINQ_VALUE                                         
              INTO :C8-DELINQ-VALUE                                     
              FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                        
             WHERE COMPANY_NO           = :C8-COMPANY-NO                
               AND DELINQ_CD            = :C8-DELINQ-CD                 
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*       INTO :C8-DELINQ-VALUE                                             
MFA-TR*       FROM CSS_DELINQUENCY                                              
MFA-TR*      WHERE COMPANY_NO           = :C8-COMPANY-NO                        
MFA-TR*        AND DELINQ_CD            = :C8-DELINQ-CD                         
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                         'COMPANY NO  '      DELIMITED BY SIZE          
                          C8-COMPANY-NO      DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7900-SELECT-GL-ACCT-NO                                      **        
      **                                                              **        
      ******************************************************************        
       7900-SELECT-GL-ACCT-NO.                                          
      *----------------------*                                                  
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT GL_ACCT_NO                                           
             INTO :GO-GL-ACCT-NO                                        
             FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                          
            WHERE COMPANY_NO           = :GO-COMPANY-NO                 
             AND  GL_ACCT_NAME         = :GO-GL-ACCT-NAME               
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT GL_ACCT_NO                                                   
MFA-TR*      INTO :GO-GL-ACCT-NO                                                
MFA-TR*      FROM CSS_GL_ACCT_NO                                                
MFA-TR*     WHERE COMPANY_NO           = :GO-COMPANY-NO                         
MFA-TR*      AND  GL_ACCT_NAME         = :GO-GL-ACCT-NAME                       
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  DISPLAY 'ERROR SELECTING ACCOUNT NUMBER **'           
                          GO-GL-ACCT-NAME                               
              ELSE                                                      
              STRING 'ERROR SELECTING ACCOUNT NUMBER **'                
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'GL ACCOUNT NAME  '     DELIMITED BY SIZE          
                      GO-GL-ACCT-NAME   ,    DELIMITED BY SIZE          
                      'COMPANY NO  '         DELIMITED BY SIZE          
                       GO-COMPANY-NO         DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7961-OPEN-OVSH-TRAN.                                        **        
      **                                                              **        
      ******************************************************************        
       7961-OPEN-OVSH-TRAN.                                             
      *-------------*                                                           
           MOVE '7961'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                OPEN OVSH_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING OVSH_CURSOR **'                    
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7961-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7962-FETCH-OVSH-TRAN.                                       **        
      **                                                              **        
      ******************************************************************        
       7962-FETCH-OVSH-TRAN.                                            
      *--------------*                                                          
           MOVE '7962'                   TO WS-ACTIVE-PARAGRAPH.        
C33928     MOVE SPACES                   TO OH-TRAN-COMMENT             
                                                                        
           EXEC SQL                                                     
              FETCH OVSH_CURSOR                                         
               INTO :OH-CASH-COMPANY-NO                                 
                   ,:OH-CASH-LOCAL-OFFICE                               
                   ,:OH-DATE-CASH-REPORT                                
                   ,:OH-CASH-DRAWER-ID                                  
                   ,:OH-OVERSHORT-ID                                    
                   ,:OH-USER-ID                                         
                   ,:OH-ACCOUNT-NO                                      
                   ,:OH-OVERSHORT-AMT                                   
                   ,:OH-OVERSHORT-DR-CR                                 
                   ,:OH-OFST-OVERSHORT-AMT                              
                   ,:OH-OFST-DR-CR                                      
                   ,:OH-GL-ACCT-NO                                      
                   ,:OH-TRAN-TS                                         
                   ,:OH-LAST-UPDATE-TS                                  
                   ,:OH-OVERSHORT-TYPE-CD                               
                   ,:OH-OVERSHORT-SOLTN-FL                              
                   ,:OH-TRAN-COMMENT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           MOVE OH-ACCOUNT-NO            TO WS-DISP-ACCOUNT-NO          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR FETCHING OVSH CURSOR **'                   
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING ' ACCOUNT NO  '         DELIMITED BY SIZE          
                      WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7962-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7963-CLOSE-OVSH-TRAN                                        **        
      **                                                              **        
      ******************************************************************        
       7963-CLOSE-OVSH-TRAN.                                            
      *--------------*                                                          
           MOVE '7963'                   TO WS-ACTIVE-PARAGRAPH.        
           DISPLAY 'CLOSE CURSOR'                                       
           EXEC SQL                                                     
                CLOSE OVSH_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR CLOSING OVSH CURSOR **'                    
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7963-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      THIS PARA OPENS OVERSHORT TYPE CURSOR                     *        
      ******************************************************************        
       7964-DECLARE-OVSH-TYPE.                                          
      *-----------------------*                                                 
                                                                        
           MOVE '7964'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                OPEN OVSHTYPE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING  '** ERROR OPENING OVSHTYPE_CURSOR **'            
                                              DELIMITED BY SIZE         
                        ' GL ACCOUNT NO  '    DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                       INTO  WS-ERR-MSG                 
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7964-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      FETCH OVERSHORT TYPE CURSOR                               *        
      ******************************************************************        
       7965-FETCH-OVSH-TYPE.                                            
      *-----------------------*                                                 
                                                                        
           MOVE '7965'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                FETCH OVSHTYPE_CURSOR                                   
                 INTO :OT-OVERSHORT-TYPE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING '** ERROR FETCHING OVSHTYPE_CURSOR **'            
                        ' GL ACCOUNT NO     ' DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                       INTO  WS-ERR-MSG                 
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7965-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      CLOSE OVERSHORT TYPE CURSOR                               *        
      ******************************************************************        
       7966-CLOSE-OVSH-TYPE.                                            
      *-----------------------*                                                 
                                                                        
           MOVE '7966'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                CLOSE OVSHTYPE_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING '** ERROR CLOSING OVSHTYPE_CURSOR **'             
                        ' GL ACCOUNT NO     ' DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                       INTO  WS-ERR-MSG                 
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
       7966-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *      THIS PARA CREATES SELECTS                                 *        
      *               THE MAXIMUM OVERSHORT ID                         *        
      ******************************************************************        
       7968-GET-OVSH-ID.                                                
      *-----------------------*                                                 
                                                                        
           MOVE '7968'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
             SELECT MAX(OVERSHORT_ID)                                   
               INTO :WS-OVERSHORT-ID-OH :WS-NULL-INDICATOR-1            
               FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO   = :WS-CASH-COMPANY-NO-OH          
                AND CASH_LOCAL_OFFICE = :WS-CASH-LOCAL-OFFICE-OH        
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                :WS-DATE-CASH-REPORT-OH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CASH-REPORT-OH
              ) <> 0) OR (LEN(:WS-DATE-CASH-REPORT-OH
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-CASH-REPORT-OH
              ), CONVERT(DATE, :WS-DATE-CASH-REPORT-OH) )         
                AND CASH_DRAWER_ID    = :WS-CASH-DRAWER-ID-OH           
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(OVERSHORT_ID)                                           
MFA-TR*        INTO :WS-OVERSHORT-ID-OH :WS-NULL-INDICATOR-1                    
MFA-TR*        FROM CSS_OVERSHORT_HDR                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :WS-CASH-COMPANY-NO-OH                  
MFA-TR*         AND CASH_LOCAL_OFFICE = :WS-CASH-LOCAL-OFFICE-OH                
MFA-TR*         AND DATE_CASH_REPORT  = :WS-DATE-CASH-REPORT-OH                 
MFA-TR*         AND CASH_DRAWER_ID    = :WS-CASH-DRAWER-ID-OH                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
               IF WS-NULL-INDICATOR-1 EQUAL -1                          
                  MOVE WS-ONE               TO WS-OVERSHORT-ID-OH       
               END-IF                                                   
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                    OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE           
                  ',DATE CASH REPORT'       DELIMITED BY SIZE           
                    OH-DATE-CASH-REPORT,    DELIMITED BY SIZE           
                  ',CASH DRAWER-ID  '       DELIMITED BY SIZE           
                    WS-CASH-DRAWER-ID,      DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
                                                                        
           END-IF                                                       
           .                                                            
       7968-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  8200-CREATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8200-CREATE-CASH-DRWR-CNTL.                                      
      *--------------------------*                                              
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_CSH_DRWR_CNTL (                             
                        CASH_COMPANY_NO,                                
                        CASH_LOCAL_OFFICE,                              
                        CASH_REPORT_NO,                                 
                        DATE_CASH_REPORT,                               
                        CASH_DRAWER_ID,                                 
                        AMT_CASH_DEBIT,                                 
                        AMT_CASH_CREDIT,                                
                        AMT_AR_DEBIT,                                   
                        AMT_AR_CREDIT,                                  
                        AMT_CK_ISS_DEBIT,                               
                        AMT_CK_ISS_CREDIT,                              
                        AMT_GL_DEBIT,                                   
                        AMT_GL_CREDIT,                                  
                        AMT_CASH_BEGIN_BAL,                             
                        AMT_BASIC_WORK,                                 
                        USER_ID,                                        
                        CASHIER_CODE,                                   
                        CODE_PYMT_FACILITY,                             
                        CODE_FCS_EXTRACTED,                             
                        CODE_CSH_DRWR_STAT,                             
                        DATE_LAST_ACTIVITY,                             
                        BALANCED_BY,                                    
                        BALANCED_TS,                                    
                        NO_ITEMS_ENTERED )                              
             VALUES (                                                   
                        :CS-CASH-COMPANY-NO,                            
                        :CS-CASH-LOCAL-OFFICE,                          
                        :CS-CASH-REPORT-NO,                             
                        IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                        :CS-CASH-DRAWER-ID,                             
                        :CS-AMT-CASH-DEBIT,                             
                        :CS-AMT-CASH-CREDIT,                            
                        :CS-AMT-AR-DEBIT,                               
                        :CS-AMT-AR-CREDIT,                              
                        :CS-AMT-CK-ISS-DEBIT,                           
                        :CS-AMT-CK-ISS-CREDIT,                          
                        :CS-AMT-GL-DEBIT,                               
                        :CS-AMT-GL-CREDIT,                              
                        :CS-AMT-CASH-BEGIN-BAL,                         
                        :CS-AMT-BASIC-WORK,                             
                        :CS-USER-ID,                                    
                        :CS-CASHIER-CODE,                               
                        :CS-CODE-PYMT-FACILITY,                         
                        :CS-CODE-FCS-EXTRACTED,                         
                        :CS-CODE-CSH-DRWR-STAT,                         
                        IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                        :CS-BALANCED-BY,                                
                        CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS 
                                           :WS-CNTL-TS-NI),                
                        :CS-NO-ITEMS-ENTERED )                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_CSH_DRWR_CNTL (                                     
MFA-TR*                 CASH_COMPANY_NO,                                        
MFA-TR*                 CASH_LOCAL_OFFICE,                                      
MFA-TR*                 CASH_REPORT_NO,                                         
MFA-TR*                 DATE_CASH_REPORT,                                       
MFA-TR*                 CASH_DRAWER_ID,                                         
MFA-TR*                 AMT_CASH_DEBIT,                                         
MFA-TR*                 AMT_CASH_CREDIT,                                        
MFA-TR*                 AMT_AR_DEBIT,                                           
MFA-TR*                 AMT_AR_CREDIT,                                          
MFA-TR*                 AMT_CK_ISS_DEBIT,                                       
MFA-TR*                 AMT_CK_ISS_CREDIT,                                      
MFA-TR*                 AMT_GL_DEBIT,                                           
MFA-TR*                 AMT_GL_CREDIT,                                          
MFA-TR*                 AMT_CASH_BEGIN_BAL,                                     
MFA-TR*                 AMT_BASIC_WORK,                                         
MFA-TR*                 USER_ID,                                                
MFA-TR*                 CASHIER_CODE,                                           
MFA-TR*                 CODE_PYMT_FACILITY,                                     
MFA-TR*                 CODE_FCS_EXTRACTED,                                     
MFA-TR*                 CODE_CSH_DRWR_STAT,                                     
MFA-TR*                 DATE_LAST_ACTIVITY,                                     
MFA-TR*                 BALANCED_BY,                                            
MFA-TR*                 BALANCED_TS,                                            
MFA-TR*                 NO_ITEMS_ENTERED )                                      
MFA-TR*      VALUES (                                                           
MFA-TR*                 :CS-CASH-COMPANY-NO,                                    
MFA-TR*                 :CS-CASH-LOCAL-OFFICE,                                  
MFA-TR*                 :CS-CASH-REPORT-NO,                                     
MFA-TR*                 :CS-DATE-CASH-REPORT,                                   
MFA-TR*                 :CS-CASH-DRAWER-ID,                                     
MFA-TR*                 :CS-AMT-CASH-DEBIT,                                     
MFA-TR*                 :CS-AMT-CASH-CREDIT,                                    
MFA-TR*                 :CS-AMT-AR-DEBIT,                                       
MFA-TR*                 :CS-AMT-AR-CREDIT,                                      
MFA-TR*                 :CS-AMT-CK-ISS-DEBIT,                                   
MFA-TR*                 :CS-AMT-CK-ISS-CREDIT,                                  
MFA-TR*                 :CS-AMT-GL-DEBIT,                                       
MFA-TR*                 :CS-AMT-GL-CREDIT,                                      
MFA-TR*                 :CS-AMT-CASH-BEGIN-BAL,                                 
MFA-TR*                 :CS-AMT-BASIC-WORK,                                     
MFA-TR*                 :CS-USER-ID,                                            
MFA-TR*                 :CS-CASHIER-CODE,                                       
MFA-TR*                 :CS-CODE-PYMT-FACILITY,                                 
MFA-TR*                 :CS-CODE-FCS-EXTRACTED,                                 
MFA-TR*                 :CS-CODE-CSH-DRWR-STAT,                                 
MFA-TR*                 :CS-DATE-LAST-ACTIVITY,                                 
MFA-TR*                 :CS-BALANCED-BY,                                        
MFA-TR*                 :CS-BALANCED-TS  :WS-CNTL-TS-NI,                        
MFA-TR*                 :CS-NO-ITEMS-ENTERED )                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_CNTL **'     
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
                 STRING 'LOCAL OFFICE     '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT,   DELIMITED BY SIZE          
                      ',CASH-REPORT-NO '     DELIMITED BY SIZE          
                      CS-CASH-REPORT-NO,     DELIMITED BY SIZE          
                      ',CASH DRAWER ID'      DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8300-CREATE-CASH-DRWR-JRNL                                  **        
      **                                                              **        
      ******************************************************************        
       8300-CREATE-CASH-DRWR-JRNL.                                      
      *--------------------------*                                              
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            INSERT INTO CSS_CSH_DRWR_JRNL (                             
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   LOCAL_OFFICE,                                        
                   COMPANY_NO,                                          
                   JRNL_SORT_ID,                                        
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,                                         
                   GL_ACCT_NO,                                          
                   METER_NO,                                            
                   TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   BATCH_SEND_LOC,                                      
                   ENTRY_LOC,                                           
                   CODE_TRAN_ERRORS,                                    
                   CODE_JRNL_EXTRACT,                                   
                   DATE_BALANCED,                                       
                   TIME_BALANCED,                                       
                   BALANCED_BY,                                         
                   CODE_STATUS,                                         
                   CURRENCY_TYPE,                                       
                   CODE_PYMT_FACILITY,                                  
                   TRAN_DATA,                                           
                   CSR_PC_ID,                                           
                   TRAN_COMMENT )                                       
              VALUES (                                                  
                   :CJ-CASH-COMPANY-NO,                                 
                   :CJ-CASH-LOCAL-OFFICE,                               
                   :CJ-CASH-REPORT-NO,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) ),                        
                   :CJ-CASH-DRAWER-ID,                                  
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-TRAN
              ) <> 0) OR (LEN(:CJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :CJ-DATE-TRAN
              ), CONVERT(DATE, :CJ-DATE-TRAN) ),                               
                   :CJ-ENTRY-NO,                                        
                   :CJ-TRAN-APPL-NO,                                    
                   :CJ-LOCAL-OFFICE,                                    
                   :CJ-COMPANY-NO,                                      
                   :CJ-JRNL-SORT-ID,                                    
                   :CJ-ACCOUNT-NO,                                      
                   :CJ-CUSTOMER-NO,                                     
                   :CJ-GL-ACCT-NO,                                      
                   :CJ-METER-NO,                                        
                   CIS.CHAR2TIME(:CJ-TRAN-TIME),                                
                   :CJ-TRAN-ID,                                         
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:CJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :CJ-DATE-LAST-ACTION) ),                        
                   :CJ-CODE-ENTRY-SOURCE,                               
                   :CJ-USER-ID,                                         
                   :CJ-BATCH-SEND-LOC,                                  
                   :CJ-ENTRY-LOC,                                       
                   :CJ-CODE-TRAN-ERRORS ,                               
                   :CJ-CODE-JRNL-EXTRACT,                               
                   IIF(TRY_CONVERT(DATE, :CJ-DATE-BALANCED 
                                         :WS-CJ-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-BALANCED 
                                                         :WS-CJ-DATE-NI
              ) <> 0) OR (LEN(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ), CONVERT(DATE, :CJ-DATE-BALANCED :WS-CJ-DATE-NI) ),            
                   CIS.CHAR2TIME(:CJ-TIME-BALANCED :WS-CJ-TIME-NI),             
                   :CJ-BALANCED-BY,                                     
                   :CJ-CODE-STATUS,                                     
                   :CJ-CURRENCY-TYPE,                                   
                   :CJ-CODE-PYMT-FACILITY,                              
                   :CJ-TRAN-DATA,                                       
                   :CJ-CSR-PC-ID,                                       
                   :CJ-TRAN-COMMENT )                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     INSERT INTO CSS_CSH_DRWR_JRNL (                                     
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            DATE_TRAN,                                                   
MFA-TR*            ENTRY_NO,                                                    
MFA-TR*            TRAN_APPL_NO,                                                
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            COMPANY_NO,                                                  
MFA-TR*            JRNL_SORT_ID,                                                
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            GL_ACCT_NO,                                                  
MFA-TR*            METER_NO,                                                    
MFA-TR*            TRAN_TIME,                                                   
MFA-TR*            TRAN_ID,                                                     
MFA-TR*            DATE_LAST_ACTION,                                            
MFA-TR*            CODE_ENTRY_SOURCE,                                           
MFA-TR*            USER_ID,                                                     
MFA-TR*            BATCH_SEND_LOC,                                              
MFA-TR*            ENTRY_LOC,                                                   
MFA-TR*            CODE_TRAN_ERRORS,                                            
MFA-TR*            CODE_JRNL_EXTRACT,                                           
MFA-TR*            DATE_BALANCED,                                               
MFA-TR*            TIME_BALANCED,                                               
MFA-TR*            BALANCED_BY,                                                 
MFA-TR*            CODE_STATUS,                                                 
MFA-TR*            CURRENCY_TYPE,                                               
MFA-TR*            CODE_PYMT_FACILITY,                                          
MFA-TR*            TRAN_DATA,                                                   
MFA-TR*            CSR_PC_ID,                                                   
MFA-TR*            TRAN_COMMENT )                                               
MFA-TR*       VALUES (                                                          
MFA-TR*            :CJ-CASH-COMPANY-NO,                                         
MFA-TR*            :CJ-CASH-LOCAL-OFFICE,                                       
MFA-TR*            :CJ-CASH-REPORT-NO,                                          
MFA-TR*            :CJ-DATE-CASH-REPORT,                                        
MFA-TR*            :CJ-CASH-DRAWER-ID,                                          
MFA-TR*            :CJ-DATE-TRAN,                                               
MFA-TR*            :CJ-ENTRY-NO,                                                
MFA-TR*            :CJ-TRAN-APPL-NO,                                            
MFA-TR*            :CJ-LOCAL-OFFICE,                                            
MFA-TR*            :CJ-COMPANY-NO,                                              
MFA-TR*            :CJ-JRNL-SORT-ID,                                            
MFA-TR*            :CJ-ACCOUNT-NO,                                              
MFA-TR*            :CJ-CUSTOMER-NO,                                             
MFA-TR*            :CJ-GL-ACCT-NO,                                              
MFA-TR*            :CJ-METER-NO,                                                
MFA-TR*            :CJ-TRAN-TIME,                                               
MFA-TR*            :CJ-TRAN-ID,                                                 
MFA-TR*            :CJ-DATE-LAST-ACTION,                                        
MFA-TR*            :CJ-CODE-ENTRY-SOURCE,                                       
MFA-TR*            :CJ-USER-ID,                                                 
MFA-TR*            :CJ-BATCH-SEND-LOC,                                          
MFA-TR*            :CJ-ENTRY-LOC,                                               
MFA-TR*            :CJ-CODE-TRAN-ERRORS ,                                       
MFA-TR*            :CJ-CODE-JRNL-EXTRACT,                                       
MFA-TR*            :CJ-DATE-BALANCED :WS-CJ-DATE-NI,                            
MFA-TR*            :CJ-TIME-BALANCED :WS-CJ-TIME-NI,                            
MFA-TR*            :CJ-BALANCED-BY,                                             
MFA-TR*            :CJ-CODE-STATUS,                                             
MFA-TR*            :CJ-CURRENCY-TYPE,                                           
MFA-TR*            :CJ-CODE-PYMT-FACILITY,                                      
MFA-TR*            :CJ-TRAN-DATA,                                               
MFA-TR*            :CJ-CSR-PC-ID,                                               
MFA-TR*            :CJ-TRAN-COMMENT )                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE CJ-CASH-DRAWER-ID      TO WS-DISP-CASH-DRAWER-ID    
               STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_JRNL **'     
                                           DELIMITED BY SIZE            
                                         INTO WS-ERR-MSG                
               STRING 'LOCAL OFFICE     '  DELIMITED BY SIZE            
                    CJ-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE            
                    ',CASH COMPANY NO   '  DELIMITED BY SIZE            
                    CJ-CASH-COMPANY-NO,    DELIMITED BY SIZE            
                    ',DATE CASH REPORT'    DELIMITED BY SIZE            
                    CJ-DATE-CASH-REPORT,   DELIMITED BY SIZE            
                    ',CASH-REPORT-NO '     DELIMITED BY SIZE            
                    CJ-CASH-REPORT-NO,     DELIMITED BY SIZE            
                    ',CASH DRAWER ID'      DELIMITED BY SIZE            
                    WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE            
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8325-CREATE-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       8325-CREATE-CASH-REPORT.                                         
      *------------------------*                                                
           MOVE '8325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_REPORT_HDR                             
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      DATE_CASH_REPORT,                                 
                      USER_ID,                                          
                      STATUS,                                           
                      CLOSED_TS)                                        
             VALUES ( :YR-CASH-COMPANY-NO                               
                      ,:YR-CASH-LOCAL-OFFICE                            
                      ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                      ,:YR-USER-ID                                      
                      ,:YR-STATUS                                       
                      ,CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS))                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               STATUS,                                                   
MFA-TR*               CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*               ,:YR-CASH-LOCAL-OFFICE                                    
MFA-TR*               ,:YR-DATE-CASH-REPORT                                     
MFA-TR*               ,:YR-USER-ID                                              
MFA-TR*               ,:YR-STATUS                                               
MFA-TR*               ,:YR-CLOSED-TS)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803      
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'ERROR IN INSERTING CASH REPORT HEADER**'         
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      YR-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ',DATE CASH REPORT'    DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                       INTO WS-ERR-MSG2                 
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8600-UPDATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8600-UPDATE-CASH-DRWR-CNTL.                                      
      *---------------------------*                                             
           MOVE '8600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            UPDATE CSS_CSH_DRWR_CNTL                                    
             SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,            
                 AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,           
                 USER_ID               = :CS-USER-ID,                   
                 CASHIER_CODE          = :CS-CASHIER-CODE,              
                 DATE_LAST_ACTIVITY = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),           
                 NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED           
            WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO            
             AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE          
             AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID             
             AND DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_CSH_DRWR_CNTL                                            
MFA-TR*      SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,                    
MFA-TR*          AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,                   
MFA-TR*          USER_ID               = :CS-USER-ID,                           
MFA-TR*          CASHIER_CODE          = :CS-CASHIER-CODE,                      
MFA-TR*          DATE_LAST_ACTIVITY = :CS-DATE-LAST-ACTIVITY,                   
MFA-TR*          NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED                   
MFA-TR*     WHERE CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO                    
MFA-TR*      AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*      AND CASH_DRAWER_ID        = :CS-CASH-DRAWER-ID                     
MFA-TR*      AND DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR UPDATE CASH DRAWER CONTROL **'             
                                               DELIMITED BY SIZE        
                                         INTO WS-ERR-MSG                
                STRING 'LOCAL OFFICE     '           DELIMITED BY SIZE  
                   CS-CASH-LOCAL-OFFICE,             DELIMITED BY SIZE  
                   ',CASH COMPANY NO   '             DELIMITED BY SIZE  
                   CS-CASH-COMPANY-NO,               DELIMITED BY SIZE  
                   ',DATE CASH REPORT'               DELIMITED BY SIZE  
                   CS-DATE-CASH-REPORT,              DELIMITED BY SIZE  
                   ',CASH DRAWER ID'                 DELIMITED BY SIZE  
                   WS-DISP-CASH-DRAWER-ID            DELIMITED BY SIZE  
                                         INTO WS-ERR-MSG2               
                                                                        
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
           END-IF                                                       
           .                                                            
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      THIS PARA INSERTS                                         *        
      *                   OVER SHORT FOR THE PAYMENTS                  *        
      ******************************************************************        
       8750-INSERT-OVERSHORT.                                           
                                                                        
           MOVE '8750'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       ,OFFSET_MODE_FL                                  
                       )                                                
                VALUES                                                  
                       (                                                
                        :WS-CASH-COMPANY-NO-OH                          
                       ,:WS-CASH-LOCAL-OFFICE-OH                        
                       ,IIF(TRY_CONVERT(DATE, :WS-DATE-CASH-REPORT-OH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-CASH-REPORT-OH
              ) <> 0) OR (LEN(:WS-DATE-CASH-REPORT-OH
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-CASH-REPORT-OH
              ), CONVERT(DATE, :WS-DATE-CASH-REPORT-OH) )                      
                       ,:WS-CASH-DRAWER-ID-OH                           
                       ,:WS-USER-ID-OH                                  
                       ,:WS-OVERSHORT-ID-OH                             
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:WS-OVERSHORT-AMT-OH                            
                       ,:WS-OVERSHORT-DR-CR-OH                          
                       ,:WS-OFST-OVERSHORT-AMT-OH                       
                       ,:WS-OFST-DR-CR-OH                               
                       ,:WS-GL-ACCT-NO-OH                               
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:WS-OVERSHORT-TYPE-CD-OH                        
                       ,:WS-OVERSHORT-SOLTN-FL-OH                       
                       ,:WS-TRAN-COMMENT-OH                             
                       ,:WS-ACCOUNT-NO-OH                               
                       ,'A'                                             
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,TRAN_TS                                                 
MFA-TR*                ,OVERSHORT_AMT                                           
MFA-TR*                ,OVERSHORT_DR_CR                                         
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,OVERSHORT_TYPE_CD                                       
MFA-TR*                ,OVERSHORT_SOLTN_FL                                      
MFA-TR*                ,TRAN_COMMENT                                            
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                ,OFFSET_MODE_FL                                          
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :WS-CASH-COMPANY-NO-OH                                  
MFA-TR*                ,:WS-CASH-LOCAL-OFFICE-OH                                
MFA-TR*                ,:WS-DATE-CASH-REPORT-OH                                 
MFA-TR*                ,:WS-CASH-DRAWER-ID-OH                                   
MFA-TR*                ,:WS-USER-ID-OH                                          
MFA-TR*                ,:WS-OVERSHORT-ID-OH                                     
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:WS-OVERSHORT-AMT-OH                                    
MFA-TR*                ,:WS-OVERSHORT-DR-CR-OH                                  
MFA-TR*                ,:WS-OFST-OVERSHORT-AMT-OH                               
MFA-TR*                ,:WS-OFST-DR-CR-OH                                       
MFA-TR*                ,:WS-GL-ACCT-NO-OH                                       
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:WS-OVERSHORT-TYPE-CD-OH                                
MFA-TR*                ,:WS-OVERSHORT-SOLTN-FL-OH                               
MFA-TR*                ,:WS-TRAN-COMMENT-OH                                     
MFA-TR*                ,:WS-ACCOUNT-NO-OH                                       
MFA-TR*                ,'A'                                                     
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '       DELIMITED BY SIZE      
                    WS-CASH-LOCAL-OFFICE-OH,     DELIMITED BY SIZE      
                  ',DATE CASH REPORT'            DELIMITED BY SIZE      
                    WS-DATE-CASH-REPORT-OH       DELIMITED BY SIZE      
                                            INTO WS-ERR-MSG             
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
           END-IF                                                       
           .                                                            
       8750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *      THIS PARA INSERTS                                         *        
      *                   OVER SHORT DETAILS TO OFFSET                 *        
      ******************************************************************        
       8751-INSERT-OVERSHORT-DET.                                       
                                                                        
           MOVE '8751'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_DET                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,OVERSHORT_ID                                    
                       ,OVERSHORT_SEQ_NO                                
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,OFST_COMPANY_NO                                 
                       ,OFST_LOC_OFCE                                   
                       ,OFST_CASH_REPT_DT                               
                       ,OFST_CASH_DRWR_ID                               
                       ,OFST_OVERSHORT_ID                               
                       )                                                
                VALUES                                                  
                       (                                                
                        :OD-CASH-COMPANY-NO                             
                       ,:OD-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )                         
                       ,:OD-CASH-DRAWER-ID                              
                       ,:OD-OVERSHORT-ID                                
                       ,:OD-OVERSHORT-SEQ-NO                            
                       ,:OD-OFST-OVERSHORT-AMT                          
                       ,:OD-OFST-DR-CR                                  
                       ,:OD-OFST-COMPANY-NO                             
                       ,:OD-OFST-LOC-OFCE                               
                       ,IIF(TRY_CONVERT(DATE, :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )                        
                       ,:OD-OFST-CASH-DRWR-ID                           
                       ,:OD-OFST-OVERSHORT-ID                           
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_DET                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,OVERSHORT_SEQ_NO                                        
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,OFST_COMPANY_NO                                         
MFA-TR*                ,OFST_LOC_OFCE                                           
MFA-TR*                ,OFST_CASH_REPT_DT                                       
MFA-TR*                ,OFST_CASH_DRWR_ID                                       
MFA-TR*                ,OFST_OVERSHORT_ID                                       
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OD-CASH-COMPANY-NO                                     
MFA-TR*                ,:OD-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OD-DATE-CASH-REPORT                                    
MFA-TR*                ,:OD-CASH-DRAWER-ID                                      
MFA-TR*                ,:OD-OVERSHORT-ID                                        
MFA-TR*                ,:OD-OVERSHORT-SEQ-NO                                    
MFA-TR*                ,:OD-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OD-OFST-DR-CR                                          
MFA-TR*                ,:OD-OFST-COMPANY-NO                                     
MFA-TR*                ,:OD-OFST-LOC-OFCE                                       
MFA-TR*                ,:OD-OFST-CASH-REPT-DT                                   
MFA-TR*                ,:OD-OFST-CASH-DRWR-ID                                   
MFA-TR*                ,:OD-OFST-OVERSHORT-ID                                   
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                    OD-CASH-LOCAL-OFFICE, DELIMITED BY SIZE             
                  ',DATE CASH REPORT'       DELIMITED BY SIZE           
                    OD-DATE-CASH-REPORT   DELIMITED BY SIZE             
                                            INTO WS-ERR-MSG             
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
           END-IF                                                       
           .                                                            
       8751-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *      THIS PARA UPDATES                                         *        
      *                   OVER SHORT FOR THE PAYMENTS                  *        
      ******************************************************************        
       8760-UPDATE-OVERSHORT.                                           
                                                                        
           MOVE '8760'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_OVERSHORT_HDR                               
                  SET LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
                     ,OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT       
                     ,OFST_DR_CR         = :OH-OFST-DR-CR               
              WHERE CASH_COMPANY_NO      = :OH-CASH-COMPANY-NO          
                AND CASH_LOCAL_OFFICE    = :OH-CASH-LOCAL-OFFICE        
                AND DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND CASH_DRAWER_ID       = :OH-CASH-DRAWER-ID           
                AND OVERSHORT_ID         = :OH-OVERSHORT-ID             
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_OVERSHORT_HDR                                       
MFA-TR*           SET LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*              ,OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT               
MFA-TR*              ,OFST_DR_CR         = :OH-OFST-DR-CR                       
MFA-TR*       WHERE CASH_COMPANY_NO      = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND CASH_LOCAL_OFFICE    = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND DATE_CASH_REPORT     = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND CASH_DRAWER_ID       = :OH-CASH-DRAWER-ID                   
MFA-TR*         AND OVERSHORT_ID         = :OH-OVERSHORT-ID                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING 'CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                    OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE           
                  ',DATE CASH REPORT'       DELIMITED BY SIZE           
                    OH-DATE-CASH-REPORT,    DELIMITED BY SIZE           
                  ',CASH DRAWER-ID  '       DELIMITED BY SIZE           
                    WS-CASH-DRAWER-ID,      DELIMITED BY SIZE           
                                            INTO WS-ERR-MSG             
                 PERFORM      8800-DIS-TABLE-ERROR                      
                    THRU      8800-EXIT                                 
           END-IF                                                       
           .                                                            
       8760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                        **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
      *--------------------*                                                    
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      **       NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
