       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA414.                                         
       AUTHOR.        MC95456.                                          
       DATE-WRITTEN.  MAR 2013.                                         
                                                                        
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00070000
      **                                                             ** 00080000
      **                  CUSTOMER SERVICE SYSTEM                    ** 00090000
      **                         DB2                                 ** 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS       REASON                            ** 00150000
      **                                                             ** 00160000
      ** 03/13      MC95456        NEW PROGRAM                       ** 00170000
      ** 05/13      MC95456        CHANGES TO SKIP UNBILLED ACCOUNTS **         
      ** 05/13      MC95456        CHANGES TO REPORT FIRST BILLED    **         
      **                           ACCOUNTS                          **         
      ** 06/13      MC95456        FIX TO HANDLE NOT-FOUND CONDITION **         
      **                           IN 7570-GET-PAYMENT-AMT.          **         
ACT151** 09/13      MC95456        PROCESS ACCOUNTS ONLY WHEN        **         
ACT151** A04527-ACT151             NAME-FORMAT = 'I'.                **         
ACT020** 01/14      MC95456        FIX TO STOP DUPLICATE MATCHES     **         
ACT020** A04880-ACT020                                                          
ACT036** 02/14      MC95456        CHANGES TO PROCESS ONLY PSNC ACCTS**         
ACT036** A04880-ACT036                                                          
PRJ951** 01/16      DB41297        ADD ADDITIONAL SCORING MODEL      **         
ACT290** 11/16      BD09555        BACK UP TO PREVIOUS VERSION                  
ACT290** A05460-ACT290                                               **         
      ******************************************************************00530000
      ******************************************************************00540000
      *THIS PROGRAM WILL BUILD A FILE OF ACCOUNTS CAME IN FROM DB07             
      *THE RECORDS WILL BE INSERTED TO CSS_EXCH_DATA_SENT WITH THE              
      *RECORD TYPE 'NCB' FOR FINALED ACCTS AND 'NCS' FOR WRITE OFF ACCTS        
      *FILE WILL BE CREATED IN SOUTHEASTERN EXCHANGE FORMAT        *    00600001
      ******************************************************************00610000
      ******************************************************************00620000
             REMARKS.                                                   
      ******************************************************************00640000
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9899     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                 00770000
      ******************************************************************00780000
       ENVIRONMENT DIVISION.                                            
      ******************************************************************00800000
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                    00851009
       COPY CSSCA414.                                                   00852009
      *RESTART FILE                                                     00860009
       COPY CSSCA414 REPLACING FCSCA414-FILE    BY FCA414R-FILE,        00862009
                               UT-S-FCSCA414    BY UT-S-FCSC414R,       00863009
                               WS-FCA414-STATUS BY WS-FCA414R-STATUS.   00864009
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                    00951001
       COPY FIODB07.                                                    00952001
      *                                                                 00953001
       COPY CFDCA414.                                                   00960001
       COPY FIOCA414.                                                   00970001
      *                                                                 00970109
       COPY CFDCA414 REPLACING FCSCA414-FILE BY FCA414R-FILE.           00971009
       01 WS-FCA414R                       PIC X(500).                  
                                                                        
      ******************************************************************01090000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA414'.
MSQ017     COPY MFASQLM.
      ******************************************************************01110000
                                                                        
                                                                        
       01  WORK-AREAS.                                                  
           05  WS-FCA414-STATUS        PIC X(02).                       
               88 FCA414-SUCCESSFUL             VALUE '00'.             
           05  WS-FCA414R-STATUS       PIC X(02).                       
               88 FCA414R-SUCCESSFUL            VALUE '00'.             
           05  WS-FDB07-STATUS         PIC X(02).                       
               88 FDB07-SUCCESSFUL              VALUE '00'.             
           05  WS-END-OF-FILE          PIC X(01)  VALUE 'N'.            
               88 END-OF-FILE                     VALUE 'Y'.            
           05  WS-END-OF-RFILE         PIC X(01)  VALUE 'N'.            
               88 END-OF-RFILE                    VALUE 'Y'.            
           05  WS-RECORD-FOUND         PIC X(01)  VALUE 'N'.            
               88 DATA-RECORD-FOUND               VALUE 'Y'.            
               88 NO-DATA-RECORD-FOUND            VALUE 'N'.            
           05  WS-FIRST-RECORD         PIC X(01)  VALUE 'N'.            
               88 FIRST-RECORD                    VALUE 'Y'.            
           05  WS-LPC-ACCOUNT          PIC X(01)  VALUE 'N'.            
               88 LPC-ACCOUNT                     VALUE 'Y'.            
           05  WS-FCA414-REC-CNTR      PIC 9(09).                       
           05  WS-AMT-CUST-ACCT-BAL    PIC 9(14)V99.                    
           05  WS-COMPANY-PROCESSED    PIC X(02).                       
           05  WS-CO-ABBRV             PIC X(04).                       
           05  WS-GRP-CNTRL-NO.                                         
               10 WS-GROUP-DATE           PIC X(08).                    
               10 WS-GROUP-TIME           PIC X(06).                    
           05  WS-INDEX                PIC 9(02)  VALUE ZEROS.          
           05  WS-AD-ZIP9.                                              
               10  WS-AD-ZIP5          PIC X(05).                       
               10  WS-AD-ZIP4          PIC X(04).                       
                                                                        
           05  WS-CURR-DATE            PIC X(08) VALUE ZEROES.          
           05  WS-CURR-TIME.                                            
               10  WS-CURR-TIME-HH     PIC 9(02).                       
               10  WS-CURR-TIME-MM     PIC 9(02).                       
               10  WS-CURR-TIME-SS     PIC 9(02).                       
               10  WS-CURR-TIME-MS     PIC 9(02).                       
           05  WS-COMMON-DATE              PIC X(10)  VALUE SPACES.     
           05  LS-INPUT-DATE               PIC X(10)  VALUE SPACES.     
           05  WS-BIRTH-DATE.                                           
               10  WS-BT-DATE-CCYY         PIC X(04).                   
               10  WS-BT-DATE-MM           PIC X(02).                   
               10  WS-BT-DATE-DD           PIC X(02).                   
           05  WS-SERV-START-DATE.                                      
               10  WS-ST-DATE-CCYY         PIC X(04).                   
               10  WS-ST-DATE-MM           PIC X(02).                   
               10  WS-ST-DATE-DD           PIC X(02).                   
           05  WS-SERV-END-DATE.                                        
               10  WS-END-DATE-CCYY        PIC X(04).                   
               10  WS-END-DATE-MM          PIC X(02).                   
               10  WS-END-DATE-DD          PIC X(02).                   
           05  WS-AT-BILL-DATE.                                         
               10  WS-AT-BILL-CCYY         PIC X(04).                   
               10  WS-AT-BILL-MM           PIC X(02).                   
               10  WS-AT-BILL-DD           PIC X(02).                   
           05  WS-FIRST-DELINQ-DATE.                                    
               10  WS-FIRST-DELINQ-CCYY    PIC X(04).                   
               10  WS-FIRST-DELINQ-MM      PIC X(02).                   
               10  WS-FIRST-DELINQ-DD      PIC X(02).                   
           05  WS-CA414-DATE.                                           
               10  WS-CA414-DATE-CC        PIC X(02).                   
               10  WS-CA414-DATE-YY        PIC X(02).                   
               10  WS-CA414-DATE-MM        PIC X(02).                   
               10  WS-CA414-DATE-DD        PIC X(02).                   
           05  WS-RUN-DATE.                                             
               10  WS-RUN-DATE-CC          PIC X(02).                   
               10  WS-RUN-DATE-YY          PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-RUN-DATE-MM          PIC X(02).                   
               10  FILLER                  PIC X(01) VALUE '-'.         
               10  WS-RUN-DATE-DD          PIC X(02).                   
           05  WS-DELINQ-DATE              PIC X(10) VALUE SPACES.      
                                                                        
      *                                                                 02020002
           05  WS-CURRENT-TIMESTAMP        PIC X(26) VALUE SPACES.      
      *                                                                 02040002
          05  WS-DATE-OF-BIRTH-NULL        PIC S9(04) COMP VALUE +0.    
          05  WS-ACCT-FINAL-DT-NULL        PIC S9(04) COMP VALUE +0.    
          05  WS-DT-UTIL-SVC-END-NULL      PIC S9(04) COMP VALUE +0.    
          05  WS-DT-UTIL-SVC-STRT-NULL     PIC S9(04) COMP VALUE +0.    
          05  WS-CHARGE-OFF-AMT-NULL       PIC S9(04) COMP VALUE +0.    
          05  WS-PAYMENT-AMT-NULL          PIC S9(04) COMP VALUE +0.    
          05  WS-DAY-00-NULL-IND           PIC S9(04) COMP VALUE +0.    
          05  WS-DAY-30-NULL-IND           PIC S9(04) COMP VALUE +0.    
          05  WS-DAY-60-NULL-IND           PIC S9(04) COMP VALUE +0.    
          05  WS-DAY-90-NULL-IND           PIC S9(04) COMP VALUE +0.    
          05  WS-PAST-DUE-AMT              PIC S9(6)V99.                
          05  WS-CURR-BALANCE              PIC S9(6)V99.                
          05  WS-FULL-BALANCE              PIC S9(6)V99.                
          05  WS-AMT-ORIG-ENTERED          PIC S9(6)V99.                
          05  WS-COMMENT-CD                PIC X(08) VALUE SPACES.      
          05  WS-ACCOUNT-STATUS            PIC X(01) VALUE SPACES.      
          05  WS-ADDR-SEGMENT-NO           PIC 9(9) VALUE 0.            
          05  WS-RECORD-NO                 PIC 9(9) VALUE 0.            
                                                                        
      *                                                                 02670000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA414'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA414'.      
           05  WS-SCSCB068             PIC X(08) VALUE 'SCSCB068'.      
           05  WS-A1                   PIC X(02) VALUE 'A1'.            
           05  WS-W1                   PIC X(02) VALUE 'W1'.            
           05  WS-H1                   PIC X(02) VALUE 'H1'.            
           05  WS-H2                   PIC X(02) VALUE 'H2'.            
           05  WS-C1                   PIC X(02) VALUE 'C1'.            
           05  WS-F1                   PIC X(02) VALUE 'F1'.            
           05  WS-P1                   PIC X(02) VALUE 'P1'.            
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
           05  WS-F                    PIC X(01) VALUE 'F'.             
           05  WS-SYSTEM               PIC X(06) VALUE 'SYSTEM'.        
           05  WS-ZERO-POINT           PIC 99V99 VALUE ZEROS.           
           05  WS-SPACES               PIC X(01) VALUE ' '.             
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-NAME-FOUND-FLAG        PIC X(01) VALUE 'N'.           
               88 WS-NAME-FOUND                    VALUE 'Y'.           
           05  WS-RESIDENTIAL-CUST-FLAG  PIC X(01) VALUE 'N'.           
               88 WS-RESIDENTIAL-CUST              VALUE 'Y'.           
           05  WS-NAME-FORMAT-TYPE-FLAG  PIC X(01) VALUE 'N'.           
               88 WS-INDIVIDUAL-TYPE               VALUE 'Y'.           
           05  WS-JOB-PARM-STATUS        PIC X(1)  VALUE 'A'.           
           05  WS-BEGIN-REC-SW           PIC X(01) VALUE 'N'.           
               88 WS-BEGIN-RECS-PROCESSED          VALUE 'Y'.           
           05 WS-ROW-EXISTS            PIC X(01).                       
              88  ROW-EXISTS                       VALUE 'Y'.           
              88  ROW-NOT-EXISTS                   VALUE 'N'.           
           05 WS-ACCT-BILLED           PIC X(01).                       
              88 ACCT-BILLED                       VALUE 'Y'.           
       01  WS-PARM-CARD.                                                
           05  WS-PARM-COMPANY-NO      PIC X(02).                       
      *                                                                 03210000
      ***************************************************************   03220006
      * DATA USED TO UPDATE CSS_RESTART TABLE AT EVERY DB2 COMMIT.      03230006
      * LENGTH OF RESTART DATA IS 888.                                  03240006
      ***************************************************************** 03250006
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +46.   
           05  WS-IS-THIS-A-RESTART        PIC X(01)  VALUE 'N'.        
               88  WS-THIS-IS-A-RESTART               VALUE 'Y'.        
               88  WS-THIS-IS-NOT-A-RESTART           VALUE 'N'.        
           05  WS-COMMIT-COUNTER           PIC 9(04)  VALUE ZERO.       
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04)  VALUE 100.        
           05  WS-SEQ-NO                   PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-LUW-LIMIT           PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-LUW-COUNTER         PIC 9(04)  VALUE ZERO COMP-3.
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04)  VALUE 100.        
           05  WS-CHKP-UPD-LIMIT           PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-UPD-COUNTER         PIC 9(04)  VALUE ZERO COMP-3.
           05  WS-CHKP-SEQ-NO              PIC 9(05)  VALUE ZERO.       
           05  WS-FCSDB07-REC-CNTR         PIC S9(07) VALUE ZERO COMP-3.
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.        
               88  WS-RERUN-COMPLETED                 VALUE 'B'.        
               88  WS-RERUN-PENDING                   VALUE 'C'.        
           05  WS-RESTART-COMMON-DATE      PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05).                   
           05  WS-RESTART-ACCOUNT-NO       PIC X(13)  VALUE SPACES.     
           05  WS-RESTART-REC-NO           PIC 9(13).                   
      *                                                                 03440006
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP                  
                                                 VALUE +0.              
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  S-RETURN-CODE           PIC S9(9) VALUE +000 COMP.       
      *                                                                 03490000
      ******************************************************************03491014
      * FCA00-KEY                                                      *03492014
      ******************************************************************03493014
       COPY FIOCA00.                                                    03495014
      *                                                                 03496079
      ******************************************************************03497079
      *  COPYBOOK FOR ABEND FILE                                        03510000
      ******************************************************************03521079
       COPY CWS00010.                                                   03530000
      *                                                                 03530179
      ******************************************************************03531079
      *  COPYBOOK FOR ABEND SWITCH                                      03550000
      ******************************************************************03551079
       COPY CWS09900.                                                   03570000
      *                                                                 03570179
      ******************************************************************03571079
      *  COPYBOOK FOR WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT     03600006
      ******************************************************************03601079
       COPY CWS00056.                                                   03620006
      *                                                                 03620179
      ******************************************************************03621079
      *  SQL COMMUNICATION AREA                                         03650000
      ******************************************************************03651079
           EXEC SQL                                                     03670000
             INCLUDE SQLCA                                              03680000
           END-EXEC.                                                    03690000
      *                                                                 03690179
      ******************************************************************03691079
      *  CSS_CUST - CU                                                  03720004
      ******************************************************************03721079
           EXEC SQL                                                     03740004
             INCLUDE TBCUST                                             03750004
           END-EXEC.                                                    03760004
      *                                                                 03761079
      ******************************************************************03770079
      *  CSS_BILLING_HDR - BI                                           03790000
      ******************************************************************03791079
           EXEC SQL                                                     03810000
             INCLUDE TBBLLHDR                                           03820000
           END-EXEC.                                                    03830079
      *                                                                 03830179
      ******************************************************************03770079
      *  CSS_NAME - DQ                                                  03790000
      ******************************************************************03791079
           EXEC SQL                                                     03810000
             INCLUDE TBNAME                                             03820000
           END-EXEC.                                                    03830079
      *                                                                 03830179
      ******************************************************************03831005
      *    CSS_JOB_PARM - G6                                           *03832005
      ******************************************************************03833005
           EXEC SQL                                                     03835005
               INCLUDE TBJBPARM                                         03836005
           END-EXEC.                                                    03837005
      *                                                                 03837179
      ******************************************************************03837279
      *  CSS_NAME_ACCT_XREF - HT                                        03860000
      ******************************************************************03861079
           EXEC SQL                                                     03880000
             INCLUDE TBNMACTX                                           03890000
           END-EXEC.                                                    03900000
      *                                                                 03900179
      ******************************************************************03901079
      *  CSS_CUST_ADDR_XREF - DM                                        03930000
      ******************************************************************03931079
           EXEC SQL                                                     03950000
             INCLUDE TBCSADRX                                           03960000
           END-EXEC.                                                    03970000
      *                                                                 03980079
      ******************************************************************03981079
      *  CSS_ADDR_FREEFORM - DZ                                         04000000
      ******************************************************************04001079
           EXEC SQL                                                     04020000
             INCLUDE TBADRFRE                                           04030000
           END-EXEC.                                                    04040000
      *                                                                 04040179
      ******************************************************************04041079
      *  CSS_ADDR_FMTTED - DY                                           04070000
      ******************************************************************04071079
           EXEC SQL                                                     04090000
             INCLUDE TBADRFMT                                           04100000
           END-EXEC.                                                    04110000
      *                                                                 04120079
      ******************************************************************04131079
      *  CSS_ZIP_CODE - A4                                              04140000
      ******************************************************************04141079
           EXEC SQL                                                     04160000
             INCLUDE TBZIPCD                                            04170000
           END-EXEC.                                                    04180000
      *                                                                 04190079
      ******************************************************************04191079
      *  CSS_ACCT_MISC_INFO - TA                                        04210000
      ******************************************************************04211079
           EXEC SQL                                                     04230000
             INCLUDE TBATMISC                                           04240000
           END-EXEC.                                                    04250000
      *                                                                 04250179
      ******************************************************************04251079
      *  CSS_CUST_PHONE - CB                                            04280000
      ******************************************************************04281079
           EXEC SQL                                                     04300000
             INCLUDE TBCSTPHN                                           04310000
           END-EXEC.                                                    04320000
      *                                                                 04320179
      ******************************************************************04321079
      *  CSS_ACCOUNT - AT                                               04350000
      ******************************************************************04351079
           EXEC SQL                                                     04370000
             INCLUDE TBACCT                                             04380000
           END-EXEC.                                                    04390000
      *                                                                 04400079
      ******************************************************************04411079
      *  CSS_CUST_PREM_HIST - CH                                        04420000
      ******************************************************************04421079
           EXEC SQL                                                     04440000
             INCLUDE TBCSTPRM                                           04450000
           END-EXEC.                                                    04460000
      *                                                                 04460179
      ******************************************************************04461079
      *  CSS_CUST_STATS - CE                                            04490000
      ******************************************************************04500079
           EXEC SQL                                                     04510000
            INCLUDE TBCSTSTS                                            04520004
          END-EXEC.                                                     04530004
      *                                                                 04540079
      ******************************************************************04751079
      *  CSS_EXCH_DATA_SENT - EX                                        04770006
      ******************************************************************04771079
            EXEC SQL                                                    04790005
              INCLUDE TBEXCSNT                                          04800005
            END-EXEC.                                                   04810005
      *                                                                 04820079
      ******************************************************************04831079
      *  CSS_FIN_WO_ACTION - KD                                         04840005
      ******************************************************************04841079
           EXEC SQL                                                     04860005
               INCLUDE TBFWACTN                                         04870005
           END-EXEC.                                                    04880005
      *                                                                 04890079
      ******************************************************************04891079
      *  CSS_AR_CNTL - AC                                               04900005
      ******************************************************************04901079
           EXEC SQL                                                     04920005
               INCLUDE TBARCNTL                                         04930005
           END-EXEC.                                                    04940005
      *                                                                 04950079
      ******************************************************************05020179
      *  CSS_CHRG_OFF  - CO                                             05022023
      ******************************************************************05022179
           EXEC SQL                                                     05024023
               INCLUDE TBCHGOFF                                         05025023
           END-EXEC.                                                    05026023
      *                                                                 05080179
      ******************************************************************05081079
      *  CSS_AR_TRANS_HIST - AR                                         05110005
      ******************************************************************05111079
           EXEC SQL                                                     05130005
               INCLUDE TBARHIST                                         05140005
           END-EXEC.                                                    05150005
      *                                                                 05160079
      ******************************************************************05571079
      *  CSS_RESTART - RF                                               05600005
      ******************************************************************05601079
           EXEC SQL                                                     05620005
               INCLUDE TBRESTRT                                         05630005
           END-EXEC.                                                    05640005
      *****                                                                     
      *  CSS_COMPANY_NAME  - C7                                                 
      *****                                                                     
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                 05650005
      ******************************************************************05651079
      *  WORKING STORAGE FOR SCSCB068                                   05670005
      ******************************************************************05671079
           EXEC SQL                                                     05690005
             INCLUDE CWS00068                                           05700005
           END-EXEC.                                                    05710005
      *                                                                 05711079
      ******************************************************************05720079
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                       05740000
      ******************************************************************05741079
           EXEC SQL                                                     05760000
              INCLUDE CWS00074                                          05770000
           END-EXEC.                                                    05780000
      *                                                                 05790000
      ******************************************************************05791079
      *  COPYBOOK FOR FETCHING JOB PARM DETAILS                         05810000
      ******************************************************************05811079
           EXEC SQL                                                     05830000
              INCLUDE CWS00038                                          05840000
           END-EXEC.                                                    05850000
      *                                                                 05860000
      ******************************************************************05861009
      *  WORKING STORAGE AREA FOR COMMON DATES                         *05862009
      ******************************************************************05863009
      *                                                                 05864009
       COPY CWS00039.                                                   05865009
      *                                                                 05866009
      ******************************************************************05867079
      *  COPYBOOK FOR SQL ERROR CHECKING                                05880000
      ******************************************************************05881079
           EXEC SQL                                                     05900000
              INCLUDE CWS00303                                          05910000
           END-EXEC.                                                    05920000
      *                                                                 05930000
      ******************************************************************05931079
      *COPYBOOK FOR REDUCING EMBEDDED SPACES                            05950000
      ******************************************************************05951079
           EXEC SQL                                                     05970000
              INCLUDE CWS00011                                          05980000
           END-EXEC.                                                    05990000
      *                                                                 06000000
      ******************************************************************06001079
      *COPYBOOK FOR DATE CHECK                                          06020000
      ******************************************************************06021079
           EXEC SQL                                                     06040000
              INCLUDE FIOJC01                                           06050000
           END-EXEC.                                                    06060000
      *                                                                 06070000
      ***************************************************************** 06080054
      **  CURSOR DECLARATION TO SELECT UCA ACCOUNTS THAT HAVE BEEN   ** 06090054
      **  REPORTED PREVIOUSLY.                                       ** 06100054
      ***************************************************************** 06110054
      *                                                                 06120054
           EXEC SQL                                                     
             DECLARE OLD-UCA-CURSOR CURSOR WITH HOLD FOR                
               SELECT          EX.ACCOUNT_NO                            
                              ,EX.COMPANY_NO                            
                              ,EX.CUSTOMER_NO                           
                              ,EX.EXCH_REC_TYPE_CD                      
                              ,EX.EXCH_SENT_AM                          
                              ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           EX.EXCH_SENT_TS, 121), ' ', '-'), ':', '.') EXCH_SENT_TS            
                              ,EX.PREMISE_NO                            
               FROM   CSS_EXCH_DATA_SENT EX WITH(READUNCOMMITTED)               
               WHERE  EX.EXCH_REC_TYPE_CD IN ('NCB','NCS')              
                 AND  EX.COMPANY_NO = :EX-COMPANY-NO                    
ACT020           AND  EX.EXCH_SENT_TS = (SELECT MAX(EX1.EXCH_SENT_TS)   
ACT020                                     FROM CSS_EXCH_DATA_SENT EX1
                           WITH(READUNCOMMITTED)  
ACT020                                    WHERE EX1.ACCOUNT_NO =        
ACT020                                          EX.ACCOUNT_NO)          
             ORDER BY EX.ACCOUNT_NO                                     
               FOR READ ONLY                                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06130054
MFA-TR*      DECLARE OLD-UCA-CURSOR CURSOR WITH HOLD FOR                06140054
MFA-TR*        SELECT          EX.ACCOUNT_NO                            06150054
MFA-TR*                       ,EX.COMPANY_NO                            06160054
MFA-TR*                       ,EX.CUSTOMER_NO                           06170054
MFA-TR*                       ,EX.EXCH_REC_TYPE_CD                      06180054
MFA-TR*                       ,EX.EXCH_SENT_AM                          06190054
MFA-TR*                       ,EX.EXCH_SENT_TS                          06200054
MFA-TR*                       ,EX.PREMISE_NO                            06210054
MFA-TR*        FROM   CSS_EXCH_DATA_SENT EX                             06220054
MFA-TR*        WHERE  EX.EXCH_REC_TYPE_CD IN ('NCB','NCS')              06230054
MFA-TR*          AND  EX.COMPANY_NO = :EX-COMPANY-NO                    06240054
MFA-TR*          AND  EX.EXCH_SENT_TS = (SELECT MAX(EX1.EXCH_SENT_TS)           
MFA-TR*                                    FROM CSS_EXCH_DATA_SENT EX1          
MFA-TR*                                   WHERE EX1.ACCOUNT_NO =                
MFA-TR*                                         EX.ACCOUNT_NO)                  
MFA-TR*      ORDER BY EX.ACCOUNT_NO                                     06250054
MFA-TR*        FOR FETCH ONLY                                           06270054
MFA-TR*        WITH UR                                                  06280054
MFA-TR*    END-EXEC.                                                    06290054
      *                                                                 06310054
      ******************************************************************07010000
      *                P R O C E D U R E   D I V I S I O N             *07020000
      ******************************************************************07030000
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAIN.                                                       
      *                                                                 07061079
              PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.        
              PERFORM 1000-MAIN-PROCESS-PARA     THRU 1000-EXIT         
                                                      UNTIL END-OF-FILE.
              PERFORM 1500-PROCESS-OLD-EXCH-DATA THRU 1500-EXIT.        
      *                                                                 07099282
              PERFORM 2500-WRITE-END-CONTROLS    THRU 2500-EXIT.        
      *                                                                 07099454
              IF WS-THIS-IS-A-RESTART                                   
                 MOVE WS-B                      TO WS-RESTART-JOB-STATUS
                 DISPLAY 'PCSCA414 RERUN COMPLETED'                     
              ELSE                                                      
                 MOVE WS-A                      TO WS-RESTART-JOB-STATUS
                 DISPLAY 'PCSCA414 COMPLETED SUCCESSFULLY'              
              END-IF.                                                   
      *                                                                 07110057
              PERFORM 9100-DELETE-RESTART-TABLE  THRU 9100-EXIT.        
              PERFORM 9000-TERMINATE             THRU 9000-EXIT.        
              STOP RUN.                                                 
      *                                                                 07160000
      ******************************************************************07170000
      *  0100-INITIALIZATION                                           *07180000
      *      OPENS OUTPUT FILE, GETS CURRENT DATE                      *07190000
      ******************************************************************07200000
       0100-INITIALIZATION.                                             
      *                                                                 07220000
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE          TO WS-INPUT-DATE       
           END-IF.                                                      
           MOVE WS-INPUT-DATE                    TO WS-COMMON-DATE.     
           MOVE WS-COMMON-DATE                   TO LS-INPUT-DATE.      
      *                                                                 07229101
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********ABENDING**************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING FCSDB07 FILE.'               
              DISPLAY '** STATUS IS ' WS-FDB07-STATUS                   
              DISPLAY '************ PCSCA414 ***********'               
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF                                                       
      *                                                                 07230301
           OPEN OUTPUT FCSCA414-FILE.                                   
           IF FCA414-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************** ABENDING ***************'        
              DISPLAY '* ERROR - IN OPENING OUTPUT FILE       *'        
              DISPLAY '* STATUS  - ' WS-FCA414-STATUS                   
              DISPLAY '*************** PCSCA414 ****************'       
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 07340012
           INITIALIZE FIOCA414-RECORD.                                  
                                                                        
           ACCEPT WS-PARM-CARD FROM SYSIN.                              
           MOVE WS-PARM-COMPANY-NO  TO WS-COMPANY-PROCESSED             
                                       EX-COMPANY-NO.                   
      *                                                                 07340012
           PERFORM 0200-CHECK-RESTART            THRU 0200-EXIT.        
           PERFORM 0300-PREPARE-RESTART          THRU 0300-EXIT.        
           IF WS-THIS-IS-NOT-A-RESTART                                  
              PERFORM 0500-PROCESS-BEGIN-REC     THRU 0500-EXIT         
                  UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES           
           END-IF.                                                      
      *                                                                 07347012
           IF WS-THIS-IS-NOT-A-RESTART                                  
              ACCEPT WS-CURR-TIME FROM TIME                             
              ACCEPT WS-CURR-DATE FROM DATE                             
              IF WS-CURR-DATE(1:2) < 50                                 
                 MOVE '20' TO WS-CA414-DATE-CC                          
                              WS-RUN-DATE-CC                            
              ELSE                                                      
                 MOVE '19' TO WS-CA414-DATE-CC                          
                              WS-RUN-DATE-CC                            
              END-IF                                                    
              MOVE WS-CURR-DATE(1:2) TO WS-CA414-DATE-YY                
                                        WS-RUN-DATE-YY                  
              MOVE WS-CURR-DATE(3:2) TO WS-CA414-DATE-MM                
                                        WS-RUN-DATE-MM                  
              MOVE WS-CURR-DATE(5:2) TO WS-CA414-DATE-DD                
                                        WS-RUN-DATE-DD                  
                                                                        
              DISPLAY '** CURRENT RUN DATE= ' WS-RUN-DATE               
              MOVE WS-CA414-DATE     TO WS-GROUP-DATE                   
              MOVE WS-CURR-TIME      TO WS-GROUP-TIME                   
              PERFORM 4500-WRITE-BEGIN-CONTROLS  THRU 4500-EXIT         
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07860000
      ******************************************************************09461001
      * 0200-CHECK-RESTART.                                            *09462001
      ******************************************************************09463001
      *                                                                 09464001
       0200-CHECK-RESTART.                                              
      *                                                                 09466001
            MOVE WS-PGRMNAME                     TO RF-NAME-PROGRAM.    
            MOVE 1                               TO RF-PARTITION-NO.    
            MOVE 1                               TO RF-DUP-CNTRL-NO.    
      *                                                                 09470043
            PERFORM 7120-SELECT-RESTART          THRU 7120-EXIT.        
      *                                                                 09470243
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE RF-RESTART-DATA-TEXT         TO WS-RESTART-DATA     
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                     TO WS-IS-THIS-A-RESTART 
               END-IF                                                   
            ELSE                                                        
               GO TO 0200-EXIT                                          
            END-IF.                                                     
      *                                                                 09471301
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09471601
      ******************************************************************09471701
      *  0300-PREPARE-RESTART                                          *09471801
      ******************************************************************09471901
      *                                                                 09472001
       0300-PREPARE-RESTART.                                            
      *                                                                 09472201
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '**   THIS IS A RESTART OF PCSCA414       **'     
              DISPLAY '*LAST PROCESSED ACCOUNT #' WS-RESTART-ACCOUNT-NO 
              DISPLAY '*CONTINUING FROM COMMIT #' WS-RESTART-CHKP-SEQ-NO
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO           
      *                                                                 09473001
              PERFORM 7001-READ-FCSDB07     THRU 7001-EXIT              
                 UNTIL WS-FCSDB07-REC-CNTR  > WS-RESTART-REC-NO         
      *                                                                 09473301
              OPEN INPUT FCA414R-FILE                                   
              IF FCA414R-SUCCESSFUL                                     
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '**********ABENDING***************'           
                  DISPLAY '** 0300-PREPARE-RESTART          '           
                  DISPLAY '** ERROR ON OPENING FCA414R FILE.'           
                  DISPLAY '** STATUS IS ' WS-FCA414R-STATUS             
                  DISPLAY '**********PCSCA414***************'           
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
      *                                                                 09474601
              MOVE 'Y'                          TO WS-FIRST-RECORD      
              MOVE 0                            TO WS-RECORD-NO         
              PERFORM 7002-READ-FCA414          THRU 7002-EXIT          
              PERFORM UNTIL WS-RECORD-NO > WS-RESTART-REC-NO  OR        
                                                   END-OF-RFILE         
                MOVE WS-FCA414R                 TO FIOCA414-RECORD      
                IF FIRST-RECORD                                         
                     MOVE CA414-HDR-GROUP-DATE  TO WS-GROUP-DATE        
                     MOVE CA414-HDR-GROUP-TIME  TO WS-GROUP-TIME        
                     MOVE WS-GROUP-DATE(1:2)    TO WS-RUN-DATE-CC       
                     MOVE WS-GROUP-DATE(3:2)    TO WS-RUN-DATE-YY       
                     MOVE WS-GROUP-DATE(5:2)    TO WS-RUN-DATE-MM       
                     MOVE WS-GROUP-DATE(7:2)    TO WS-RUN-DATE-DD       
                     MOVE 'N'                   TO WS-FIRST-RECORD      
                ELSE                                                    
                     MOVE WS-FCA414R(26:7)      TO WS-RECORD-NO         
                END-IF                                                  
                PERFORM 8500-WRITE-CA414-FILE   THRU 8500-EXIT          
                INITIALIZE WS-FCA414R                                   
                PERFORM 7002-READ-FCA414        THRU 7002-EXIT          
              END-PERFORM                                               
              MOVE WS-RESTART-REC-NO            TO WS-FCA414-REC-CNTR   
           END-IF.                                                      
      *                                                                 09477286
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09477586
      ******************************************************************09477686
      * 0500-PROCESS-BEGIN-REC.                                        *09477786
      *   THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND     *09477886
      *   CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON        *09477986
      *   THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED        *09478086
      *   FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH         *09478186
      *   THE CORRECT FILE.                                            *09478286
      ******************************************************************09478386
      *                                                                 09478486
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                 09478686
           PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT.             
      *                                                                 09478886
           EVALUATE TRUE                                                
               WHEN END-OF-FILE                                         
                    DISPLAY '************ABENDING************'          
                    DISPLAY '**    PCSCA414 PROCESSING ERROR '          
                    DISPLAY '**      FCSDB07 FILE IS EMPTY   '          
                    DISPLAY '**      PROCESSING TERMINATED   '          
                    DISPLAY '************PCSCA414************'          
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
               WHEN E-FDB07-KEY-BREC = LOW-VALUES                       
                    IF E-FDB07-CREATE-DATE-BREC NOT = WS-COMMON-DATE    
                       DISPLAY '*********ABENDING*****************'     
                       DISPLAY '**     PCSCA414 PROCESSING ERROR  '     
                       DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE ' 
                       DISPLAY '**       PROCESSING TERMINATED    '     
                       DISPLAY '*********PCSCA414*****************'     
                       PERFORM 9900-ABEND   THRU 9900-EXIT              
                    END-IF                                              
                    SET WS-BEGIN-RECS-PROCESSED TO TRUE                 
               WHEN WS-BEGIN-RECS-PROCESSED                             
                    IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES     
                       IF E-FDB07-KEY-BREC = HIGH-VALUES AND            
                          NO-DATA-RECORD-FOUND AND                      
                          E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                          DISPLAY '************ABENDING************'    
                          DISPLAY '**    PCSCA414 PROCESSING ERROR '    
                          DISPLAY '**      FCSDB07 FILE IS EMPTY   '    
                          DISPLAY '**      PROCESSING TERMINATED   '    
                          DISPLAY '************PCSCA414************'    
                          PERFORM 9900-ABEND THRU 9900-EXIT             
                       ELSE                                             
                          CONTINUE                                      
                       END-IF                                           
                    ELSE                                                
                       SET DATA-RECORD-FOUND TO TRUE                    
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '************ABENDING**************'        
                    DISPLAY '**    PCSCA414 PROCESSING ERROR   '        
                    DISPLAY '** FIRST RECORD IS NOT A CNTL REC '        
                    DISPLAY '**      PROCESSING TERMINATED     '        
                    DISPLAY '************PCSCA414**************'        
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09484055
      ******************************************************************11470000
      *  1000-MAIN-PROCESS-PARA                                        *11480000
      *      CONTROLS MAIN PROCESS                                     *11490000
      ******************************************************************11500000
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                 11520000
           IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES              
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FDB07-ACCT-NO          TO AT-ACCOUNT-NO            
              MOVE WS-COMPANY-PROCESSED     TO AT-COMPANY-NO            
              PERFORM 7400-GET-ACCT-INFO    THRU 7400-EXIT              
              IF SQLCODE = 0                                            
                PERFORM 2000-OUTPUT-PROCESS   THRU 2000-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11775179
           PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT.             
      *                                                                 11780028
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11990000
      ******************************************************************11991054
      *  1500-PROCESS-OLD-EXCH-DATA.                                *   11992054
      *  PROCESS OLD-UCA-ACCT CURSOR ACCTS CHECKING FOR A BALANCE CHANGE11993054
      ******************************************************************11994054
       1500-PROCESS-OLD-EXCH-DATA.                                      
      *                                                                 11996054
            PERFORM 7200-OPEN-OLD-UCA-CURSOR  THRU 7200-EXIT            
            PERFORM 7240-FETCH-OLD-UCA-CURSOR THRU 7240-EXIT            
            PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                 MOVE EX-ACCOUNT-NO             TO AT-ACCOUNT-NO        
                 PERFORM 7400-GET-ACCT-INFO     THRU 7400-EXIT          
                 IF SQLCODE = 0                                         
                   IF EX-EXCH-SENT-AM NOT = AT-TOTAL-AR-BALANCE         
                      PERFORM 2000-OUTPUT-PROCESS    THRU 2000-EXIT     
                   END-IF                                               
                 END-IF                                                 
              PERFORM 7240-FETCH-OLD-UCA-CURSOR THRU 7240-EXIT          
            END-PERFORM.                                                
            PERFORM 7280-CLOSE-OLD-UCA-CURSOR   THRU 7280-EXIT.         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12000554
      ***************************************************************** 12001002
      * 2000-OUTPUT-PROCESS                                           * 12010029
      *     CHECKS ACCOUNT TO SEE IF IT IS A INDIVIDUAL NAME TYPE.    * 12020002
      ***************************************************************** 12030002
       2000-OUTPUT-PROCESS.                                             
      *                                                                 12040130
           IF AT-ACCOUNT-TYPE-CODE = 'R'                                
              PERFORM 2100-PROCESS-ACCOUNT  THRU 2100-EXIT              
           END-IF.                                                      
      *                                                                 12048379
           IF WS-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR                  
              WS-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT                     
              PERFORM 8888-COMMIT           THRU 8888-EXIT              
              MOVE ZEROES                   TO WS-COMMIT-COUNTER        
           END-IF.                                                      
                                                                        
      *                                                                 12910000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12940000
      ***************************************************************** 12941030
      * 2100-PROCESS-ACCOUNT.                                           12942052
      *     GETS INFORMATION REQUIRED FOR OUTPUT FILE                 * 12943052
      ***************************************************************** 12944030
       2100-PROCESS-ACCOUNT.                                            
      *                                                                 12945130
           MOVE 'N'                           TO WS-ACCT-BILLED         
           MOVE 0                             TO WS-PAST-DUE-AMT        
           MOVE 0                             TO WS-CURR-BALANCE        
           MOVE 0                             TO WS-FULL-BALANCE        
           MOVE 0                             TO WS-AMT-ORIG-ENTERED    
           MOVE SPACES                        TO WS-AT-BILL-DATE        
                                                 WS-SERV-START-DATE     
                                                 WS-SERV-END-DATE       
                                                 WS-DELINQ-DATE         
                                                                        
           MOVE AT-ACCOUNT-NO                 TO CH-ACCOUNT-NO          
                                                 AC-ACCOUNT-NO          
                                                 BI-ACCOUNT-NO          
                                                 AR-ACCOUNT-NO          
                                                 CO-ACCOUNT-NO          
                                                 KD-ACCOUNT-NO.         
                                                                        
           MOVE AT-DATE-BILL-DAY-00(1:4)      TO WS-AT-BILL-CCYY        
           MOVE AT-DATE-BILL-DAY-00(6:2)      TO WS-AT-BILL-MM          
           MOVE AT-DATE-BILL-DAY-00(9:2)      TO WS-AT-BILL-DD          
      *                                                                 12950330
           MOVE AT-PREMISE-NO                 TO CH-PREMISE-NO.         
           PERFORM 7500-GET-SERVICE-DATE      THRU 7500-EXIT            
           MOVE CH-DATE-UTIL-SVC-STRT(1:4)    TO WS-ST-DATE-CCYY        
           MOVE CH-DATE-UTIL-SVC-STRT(6:2)    TO WS-ST-DATE-MM          
           MOVE CH-DATE-UTIL-SVC-STRT(9:2)    TO WS-ST-DATE-DD          
           MOVE CH-DATE-UTIL-SVC-END(1:4)     TO WS-END-DATE-CCYY       
           MOVE CH-DATE-UTIL-SVC-END(6:2)     TO WS-END-DATE-MM         
           MOVE CH-DATE-UTIL-SVC-END(9:2)     TO WS-END-DATE-DD         
      *                                                                 12951230
           MOVE AT-CODES-DATA-PRESENT         TO WS-CODES-DATA-PRESENT  
           MOVE PROGRAM-NAME                  TO WS-CPD00068-CALLING-PGM
           MOVE WS-SPACES                     TO ABEND-FUNCTION         
           MOVE WS-RUN-DATE                   TO WS-HOLD-DATE           
           MOVE 'Y'                           TO CALC-BALANCE-SW        
                                                 CALC-ARREARS-SW        
                                                 CALC-PAST-DUE-SW.      
           PERFORM 2200-CALL-SCSCB068         THRU 2200-EXIT            
           MOVE WS-AMT-PAST-DUE               TO WS-PAST-DUE-AMT        
           MOVE WS-AMT-FULL-BALANCE           TO WS-FULL-BALANCE        
      *                                                                 12952430
                                                                        
           PERFORM 7560-GET-CHRG-OFF-AMT      THRU 7560-EXIT            
      *                                                                 12953130
           PERFORM 7565-GET-PREVIOUS-BILL-DT  THRU 7565-EXIT            
      *                                                                 12953396
           IF SQLCODE = NOT-FOUND                                       
              PERFORM 7567-CHECK-ACCT-BILLED  THRU 7567-EXIT            
              IF ACCT-BILLED                                            
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY 'ACCOUNT SKIPPED FROM PROCESS ' AT-ACCOUNT-NO  
                 GO TO 2100-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              PERFORM 7570-GET-PAYMENT-AMT    THRU 7570-EXIT            
              MOVE    AR-AMT-ORIG-ENTERED     TO   WS-AMT-ORIG-ENTERED  
           END-IF.                                                      
      *                                                                 12953530
           PERFORM 2300-GET-COMMENT-CODES     THRU 2300-EXIT            
      *                                                                 12953779
           PERFORM 2400-GET-ACCOUNT-STATUS    THRU 2400-EXIT            
      *                                                                 12953979
           MOVE WS-DELINQ-DATE(1:4)           TO WS-FIRST-DELINQ-CCYY   
           MOVE WS-DELINQ-DATE(6:2)           TO WS-FIRST-DELINQ-MM     
           MOVE WS-DELINQ-DATE(9:2)           TO WS-FIRST-DELINQ-DD     
      *                                                                 12954330
           MOVE AT-CUSTOMER-NO                TO   CU-CUSTOMER-NO.      
           MOVE 'N'                        TO WS-NAME-FORMAT-TYPE-FLAG. 
           PERFORM 7320-GET-CUST-INFO         THRU 7320-EXIT.           
      *                                                                 12954730
           MOVE CU-NAME-ID                    TO DQ-NAME-ID.            
           PERFORM 7330-GET-NAME-INFO         THRU 7330-EXIT.           
           IF DQ-NAME-TYPE = 'CN' AND                                   
              DQ-NAME-FORMAT = 'I'                                      
               MOVE 'Y' TO WS-NAME-FORMAT-TYPE-FLAG                     
           END-IF.                                                      
      *                                                                 12955430
ACT151     IF WS-INDIVIDUAL-TYPE                                        
              PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT         
              IF WS-MAIL-ADDR NOT = SPACES                              
                 MOVE 2 TO WS-ADDR-SEGMENT-NO                           
              ELSE                                                      
                 MOVE 1 TO WS-ADDR-SEGMENT-NO                           
              END-IF                                                    
      *                                                                 12956130
              PERFORM 5000-LOAD-FIOCA414         THRU 5000-EXIT         
              PERFORM 5500-LOAD-EXCH-DATA-SENT   THRU 5500-EXIT         
      *                                                                 12956489
              ADD  1                             TO WS-COMMIT-COUNTER   
ACT151     ELSE                                                         
ACT151        DISPLAY 'ACCOUNT SKIPPED FROM PROCESS ' AT-ACCOUNT-NO     
                                                                        
ACT151     END-IF.                                                      
      *                                                                 12956630
        2100-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************12956931
      *  2200-CALL-SCSCB068                                             12957031
      *  CALLING SCSCB068 TO GET THE VALUE OF PAST DUE AMOUNT           12957179
      ******************************************************************12957231
       2200-CALL-SCSCB068.                                              
      *                                                                 12957431
           MOVE SPACES                     TO ABEND-FUNCTION.           
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
              CALL WS-SCSCB068  USING  CWS00068-FIELDS,                 
                                       WS-CODES-DATA-PRESENT,           
                                       DCLCSS-ACCOUNT,                  
                                       ABEND-FILE,                      
                                       RS-RETURN-CODE.                  
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 12958531
       2200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 12959028
      * 2300-GET-COMMENT-CODES.                                    *    12960032
      ***************************************************************** 12980028
        2300-GET-COMMENT-CODES.                                         
                                                                        
             MOVE SPACES          TO WS-COMMENT-CD.                     
             MOVE 'N'             TO WS-LPC-ACCOUNT.                    
                                                                        
             IF AT-CODE-ACCT-STAT   = 'A'                               
                IF WS-CODE-DPP-ACCT = 'A'                               
                   MOVE 'PP' TO WS-COMMENT-CD                           
                ELSE                                                    
                   IF WS-PAST-DUE-AMT > 0                               
                      MOVE 'PS' TO WS-COMMENT-CD                        
                   END-IF                                               
                END-IF                                                  
             ELSE                                                       
                IF AT-CODE-ACCT-STAT = 'B'                              
                   PERFORM 7575-CHECK-LPC THRU 7575-EXIT                
                   IF LPC-ACCOUNT                                       
                      MOVE 'UP' TO WS-COMMENT-CD                        
                   ELSE                                                 
                      EVALUATE AT-CODE-STATUS-REASON                    
                          WHEN 'A'                                      
                          WHEN 'B'                                      
                               MOVE 'VC' TO WS-COMMENT-CD               
                          WHEN 'C'                                      
                          WHEN 'D'                                      
                               MOVE 'ID' TO WS-COMMENT-CD               
                      END-EVALUATE                                      
                   END-IF                                               
                END-IF                                                  
             END-IF.                                                    
      *                                                                 13111579
                                                                        
        2300-EXIT.                                                      
             EXIT.                                                      
      ***************************************************************** 13131029
      * 2400-GET-ACCOUNT-STATUS.                                      * 13132031
      ***************************************************************** 13133029
        2400-GET-ACCOUNT-STATUS.                                        
                                                                        
             MOVE SPACES                        TO WS-ACCOUNT-STATUS    
                                                   WS-DELINQ-DATE.      
             PERFORM 7550-GET-AR-AMOUNTS        THRU 7550-EXIT.         
                                                                        
             IF AC-AMT-AR-DAY-90 > 0                                    
                MOVE '3'                        TO WS-ACCOUNT-STATUS    
                MOVE AT-DATE-BILL-DAY-90        TO WS-DELINQ-DATE       
             ELSE                                                       
                IF AC-AMT-AR-DAY-60 > 0                                 
                   MOVE '2'                     TO WS-ACCOUNT-STATUS    
                   MOVE AT-DATE-BILL-DAY-60     TO WS-DELINQ-DATE       
                ELSE                                                    
                   IF AC-AMT-AR-DAY-30 > 0                              
                      MOVE '1'                  TO WS-ACCOUNT-STATUS    
                      MOVE AT-DATE-BILL-DAY-30  TO WS-DELINQ-DATE       
                   ELSE                                                 
                      MOVE '0'                  TO WS-ACCOUNT-STATUS    
                   END-IF                                               
                END-IF                                                  
             END-IF.                                                    
                                                                        
             IF AT-BANKRUPTCY-IND = 'B'                                 
                MOVE 'B'                        TO WS-ACCOUNT-STATUS    
             END-IF.                                                    
                                                                        
             IF AT-CODE-ACCT-STAT = 'B'                                 
                MOVE '9'                        TO WS-ACCOUNT-STATUS    
                IF WS-CODE-LPC = 'A'                                    
                   MOVE 'U'                     TO WS-ACCOUNT-STATUS    
                END-IF                                                  
             ELSE                                                       
                IF AT-CODE-ACCT-STAT = 'S'                              
                   MOVE 'C'                     TO WS-ACCOUNT-STATUS    
                END-IF                                                  
             END-IF.                                                    
                                                                        
                                                                        
             IF AT-CODE-STATUS-REASON = 'C'                             
                MOVE 'N'                        TO WS-ACCOUNT-STATUS    
             END-IF.                                                    
                                                                        
      *                                                                 13139265
      *                                                                 13142693
        2400-EXIT.                                                      
             EXIT.                                                      
      *                                                                 13330029
      ******************************************************************13331079
      *     2500-WRITE-END-CONTROLS.                                   *13332079
      *     MODULE WRITES THE TRAILER FOR THE OUTPUT FILE.             *13333079
      ******************************************************************13334079
       2500-WRITE-END-CONTROLS.                                         
                                                                        
           INITIALIZE  CA414-TRAILER-REC.                               
           MOVE '5'                       TO CA414-TRLR-RECORD-TYPE.    
PRJ951     IF WS-COMPANY-PROCESSED = '26'                               
PRJ951        MOVE 'PSNC' TO CA414-TRLR-COMPANY-ABBR                    
PRJ951        MOVE 'NC'   TO CA414-TRLR-EXCH-ID                         
PRJ951     ELSE                                                         
PRJ951        MOVE 'SCGA'  TO CA414-TRLR-COMPANY-ABBR                   
PRJ951        MOVE 'NC'    TO CA414-TRLR-EXCH-ID                        
PRJ951     END-IF.                                                      
           MOVE WS-GROUP-DATE             TO CA414-TRLR-GROUP-DATE.     
           MOVE WS-GROUP-TIME             TO CA414-TRLR-GROUP-TIME.     
           MOVE WS-GROUP-DATE             TO CA414-TRLR-GROUP-CNTRL-NO. 
           PERFORM 8500-WRITE-CA414-FILE  THRU 8500-EXIT.               
      *                                                                 13339679
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13339979
      ******************************************************************13340079
      * 2800-PRE-COMMIT.                                               *13340179
      ******************************************************************13340279
      *                                                                 13340379
       2800-PRE-COMMIT.                                                 
      *                                                                 13340579
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-COMMON-DATE              TO WS-RESTART-COMMON-DATE.  
           ADD  1                           TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE AT-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.   
           MOVE WS-FCA414-REC-CNTR          TO WS-RESTART-REC-NO.       
      *                                                                 13341379
       2800-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 16610000
      * 4000-MAIL-NAME-ADDRESS                                        * 16620000
      *     TO GET CUSTOMER NAME, ADDRESS, BILLING ADDRESS            * 16630000
      ***************************************************************** 16640000
            EXEC SQL                                                    16650000
                INCLUDE CPD00074                                        16660000
            END-EXEC.                                                   16670000
      *                                                                 16680000
            EXEC SQL                                                    16690000
                INCLUDE CPD00004                                        16700000
            END-EXEC.                                                   16710000
      *                                                                 16720000
      ******************************************************************16730001
      *     4500-WRITE-BEGIN-CONTROLS.                                 *16740001
      *     MODULE WRITES THE HEADER FOR THE OUTPUT FILE.              *16750001
      ******************************************************************16760001
       4500-WRITE-BEGIN-CONTROLS.                                       
      *                                                                 16780001
           INITIALIZE CA414-HEADER-REC.                                 
           MOVE '1'                       TO CA414-HDR-RECORD-TYPE.     
PRJ951     IF WS-COMPANY-PROCESSED = '26'                               
PRJ951        MOVE 'PSNC' TO CA414-HDR-COMPANY-ABBR                     
PRJ951        MOVE 'NC'   TO CA414-HDR-EXCH-ID                          
PRJ951     ELSE                                                         
PRJ951        MOVE 'SCGA'  TO CA414-HDR-COMPANY-ABBR                    
PRJ951        MOVE 'NC'    TO CA414-HDR-EXCH-ID                         
PRJ951     END-IF.                                                      
           MOVE WS-GROUP-DATE             TO CA414-HDR-GROUP-DATE.      
           MOVE WS-GROUP-TIME             TO CA414-HDR-GROUP-TIME.      
           MOVE WS-GROUP-DATE             TO                            
                                          CA414-HDR-GROUP-CONTROL-NO.   
           MOVE 'PASSWORD FROM EQUIXFAX        '                        
                                          TO CA414-HDR-SECURITY-CODE.   
           PERFORM 8500-WRITE-CA414-FILE THRU 8500-EXIT.                
      *                                                                 16960001
       4500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16990001
      ******************************************************************17240000
      *  5000-LOAD-FIOCA414                                            *17250002
      *   LOADS DATA INTO THE FIOCA414 FILE AND WRITES TO OUTPUT FILE  *17260002
      ******************************************************************17280000
       5000-LOAD-FIOCA414.                                              
      *                                                                 17300000
           ADD 1 TO WS-FCA414-REC-CNTR.                                 
      *** THE FOLLOWING SECTION WRITES AN ACCOUNT SEGMENT ****          17320002
           INITIALIZE CA414-ACCT-SEGMENT.                               
           MOVE '3'                    TO CA414-AC-REC-TYPE.            
PRJ951     IF WS-COMPANY-PROCESSED = '26'                               
PRJ951        MOVE 'PSNC' TO CA414-AC-COMPANY-ABBR                      
PRJ951        MOVE 'NC'   TO CA414-AC-EXCH-ID                           
PRJ951     ELSE                                                         
PRJ951        MOVE 'SCGA'  TO CA414-AC-COMPANY-ABBR                     
PRJ951        MOVE 'NC'    TO CA414-AC-EXCH-ID                          
PRJ951     END-IF.                                                      
           MOVE 001                    TO CA414-AC-LOCATION-ID.         
           MOVE WS-GROUP-DATE          TO CA414-AC-GROUP-CONTROL-NO.    
           MOVE 'A'                    TO CA414-AC-NCTUE-ACCT-CODE.     
           MOVE 6                      TO CA414-AC-TRANSACTION-CODE.    
           MOVE 'AC'                   TO CA414-AC-SEGMENT-CODE.        
           MOVE WS-FCA414-REC-CNTR     TO CA414-AC-RECORD-NUMBER.       
           MOVE AT-ACCOUNT-NO          TO CA414-AC-ACCOUNT-NO.          
           MOVE WS-FIRST-DELINQ-DATE   TO CA414-AC-FIRST-DELINQ-DT.     
           MOVE ' '                    TO CA414-AC-SUB-SERVICE-TYPE.    
           MOVE 'G'                    TO CA414-AC-SERVICE-TYPE.        
           MOVE ' '                    TO CA414-AC-OTHER-SERV-TYPE-DESC 
           MOVE WS-SERV-START-DATE     TO CA414-AC-SERV-CONNECT-DT.     
           MOVE WS-SERV-END-DATE       TO CA414-AC-SERV-DISCONN-DT.     
           MOVE WS-ACCOUNT-STATUS      TO CA414-AC-ACCOUNT-STATUS.      
           MOVE CO-AMT-TRANS           TO CA414-AC-CHRG-OFF-AMT.        
           MOVE WS-AMT-ORIG-ENTERED    TO CA414-AC-PAYMENT-AMT.         
           MOVE WS-AT-BILL-DATE        TO CA414-AC-CURR-BAL-DT.         
           MOVE ' '                    TO CA414-AC-COLL-AGENCY-NO.      
           MOVE ' '                    TO CA414-AC-MEMBER-COMMENTS.     
           MOVE WS-PAST-DUE-AMT        TO CA414-AC-PAST-DUE-AMT.        
           MOVE 1                      TO CA414-AC-CONSUMER-SEGMENT-NO. 
           MOVE WS-ADDR-SEGMENT-NO     TO CA414-AC-ADDR-SEGMENT-NO.     
           MOVE ' '                    TO CA414-AC-NEW-ACCOUNT-NO.      
           MOVE WS-COMMENT-CD          TO CA414-AC-COMMENT-CODE.        
           MOVE AT-BILL-CYCLE          TO CA414-AC-MEMBER-COMMENTS.     
           IF WS-CODE-BUDGET= 'A' OR WS-CODE-DPP-ACCT = 'A'             
                                  OR WS-CODE-DFA-ACCT = 'A'             
              COMPUTE WS-CURR-BALANCE = WS-CURR-CHARGES +               
                                        WS-AMT-PAST-DUE                 
              MOVE WS-CURR-BALANCE     TO CA414-AC-CURRENT-BALANCE      
           ELSE                                                         
              MOVE WS-FULL-BALANCE     TO CA414-AC-CURRENT-BALANCE      
           END-IF.                                                      
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'B'                                                 
                    MOVE 'NCB'              TO EX-EXCH-REC-TYPE-CD      
               WHEN 'S'                                                 
                    MOVE 'NCS'              TO EX-EXCH-REC-TYPE-CD      
               WHEN 'A'                                                 
                    MOVE 'NCA'              TO EX-EXCH-REC-TYPE-CD      
           END-EVALUATE.                                                
PRJ951     MOVE EX-EXCH-REC-TYPE-CD TO CA414-AC-REC-TYPE-CD.            
           PERFORM 8500-WRITE-CA414-FILE THRU 8500-EXIT.                
                                                                        
      *                                                                 17482079
      **** THE FOLLOWING SECTION WRITES A CONSUMER ID SEGMENT ****      17490002
           INITIALIZE CA414-CONSUMER-SEGMENT.                           
           MOVE '3'                    TO CA414-ID-RECORD-TYPE.         
           IF WS-COMPANY-PROCESSED = '26'                               
              MOVE 'PSNC' TO CA414-ID-COMPANY-ABBR                      
              MOVE 'NC'   TO CA414-ID-EXCH-ID                           
           ELSE                                                         
              MOVE 'SCGA'  TO CA414-ID-COMPANY-ABBR                     
              MOVE 'NC'    TO CA414-ID-EXCH-ID                          
           END-IF.                                                      
           MOVE '001'                  TO CA414-ID-LOCATION-ID.         
           MOVE WS-GROUP-DATE          TO CA414-ID-GROUP-CNTRL-NO.      
           MOVE 'A'                    TO CA414-ID-ACCOUNT-CODE.        
           MOVE 'ID'                   TO CA414-ID-SEGMENT-CODE.        
           MOVE WS-FCA414-REC-CNTR     TO CA414-ID-RECORD-NUMBER.       
           MOVE AT-ACCOUNT-NO          TO CA414-ID-ACCOUNT-NUMBER.      
           MOVE 'P'                    TO CA414-ID-CONSUMER-TYPE.       
           MOVE ' '                    TO CA414-ID-SUFFIX.              
           MOVE 'N' TO WS-NAME-FOUND-FLAG.                              
           PERFORM VARYING WS-INDEX FROM 1 BY 1 UNTIL                   
             WS-INDEX > 5 OR WS-NAME-FOUND                              
             IF WS-NAME-TYPE(WS-INDEX) = 'CN'                           
               MOVE 'Y' TO WS-NAME-FOUND-FLAG                           
               IF WS-FIRST-NAME(WS-INDEX) = SPACES AND                  
                  WS-LAST-NAME(WS-INDEX) = SPACES                       
                   MOVE WS-FULL-NAME(WS-INDEX) TO                       
                                             CA414-ID-ALTERNATE-NAME    
               ELSE                                                     
                   MOVE WS-FIRST-NAME(WS-INDEX)                         
                                     TO CA414-ID-FIRST-NAME             
                   MOVE WS-MIDDLE-NAME(WS-INDEX)                        
                                     TO CA414-ID-MIDDLE-NAME            
                   MOVE WS-LAST-NAME(WS-INDEX)                          
                                     TO CA414-ID-SUR-NAME               
               END-IF                                                   
             END-IF                                                     
           END-PERFORM.                                                 
           MOVE AT-CUSTOMER-NO       TO CE-CUSTOMER-NO                  
           PERFORM 7300-GET-CUST-STATS THRU 7300-EXIT.                  
           IF CE-SSN = SPACES OR LOW-VALUES                             
               MOVE ZEROES TO CA414-ID-SSN                              
           ELSE                                                         
               MOVE CE-SSN TO CA414-ID-SSN                              
           END-IF.                                                      
           MOVE CE-CODE-STATE-ID       TO CA414-ID-DRIVR-LICENS-STATE   
           MOVE CE-DRIVERS-LICENSE-NO  TO CA414-ID-LICENSE-NO           
           IF CE-OTHER-ID = SPACES OR LOW-VALUES                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'O'          TO CA414-ID-OTHER-ID-TYPE              
               MOVE CE-OTHER-ID  TO CA414-ID-OTHER-ID-NO                
           END-IF.                                                      
           MOVE ' '                    TO CA414-ID-CUST-LANGUAGE        
           MOVE CE-EMPLOYER            TO CA414-ID-EMPLOYER-NAME.       
           MOVE CE-DATE-OF-BIRTH(1:4)  TO WS-BT-DATE-CCYY               
           MOVE CE-DATE-OF-BIRTH(6:2)  TO WS-BT-DATE-MM                 
           MOVE CE-DATE-OF-BIRTH(9:2)  TO WS-BT-DATE-DD                 
           MOVE WS-BIRTH-DATE          TO CA414-ID-BIRTH-DATE.          
           IF AT-BANKRUPTCY-IND = 'B'                                   
              MOVE 'B'                 TO CA414-ID-INFORMATION-IND      
           END-IF.                                                      
                                                                        
      *                                                                 17860000
      *                                                                 18050002
           MOVE WS-H1 TO CB-PHONE-TYPE.                                 
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE CB-PHONE-NO  TO CA414-ID-SERV-PHONE1                
               MOVE 'S'          TO CA414-ID-SERV-PHONE1-TYPE           
               MOVE SPACE        TO CA414-ID-SERV-PHONE1-IND            
           END-IF.                                                      
      *                                                                 18150002
           MOVE WS-W1 TO CB-PHONE-TYPE.                                 
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE CB-PHONE-NO  TO CA414-ID-WORK-PHONE                 
           END-IF.                                                      
      *                                                                 18230002
           MOVE WS-A1 TO CB-PHONE-TYPE.                                 
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE CB-PHONE-NO  TO CA414-ID-CELL-PHONE                 
               MOVE 'O'          TO CA414-ID-CELL-PHONE-TYPE            
               MOVE SPACE        TO CA414-ID-CELL-PHONE-IND             
           END-IF.                                                      
      *                                                                 18330002
           MOVE WS-H2 TO CB-PHONE-TYPE.                                 
           MOVE 'C'   TO CB-CUSTOMER-TYPE.                              
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE CB-PHONE-NO  TO CA414-ID-SERV-PHONE3                
               MOVE 'O'          TO CA414-ID-SERV-PHONE3-TYPE           
               MOVE SPACE        TO CA414-ID-SERV-PHONE3-IND            
           END-IF.                                                      
      *                                                                 18430002
           MOVE WS-C1 TO CB-PHONE-TYPE.                                 
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE CB-PHONE-NO  TO CA414-ID-SERV-PHONE4                
               MOVE 'C'          TO CA414-ID-SERV-PHONE4-TYPE           
               MOVE SPACE        TO CA414-ID-SERV-PHONE4-IND            
           END-IF.                                                      
      *                                                                 18530002
           MOVE WS-F1 TO CB-PHONE-TYPE.                                 
           MOVE 'C' TO CB-CUSTOMER-TYPE.                                
           MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               MOVE CB-PHONE-NO  TO CA414-ID-SERV-PHONE5                
               MOVE 'F'          TO CA414-ID-SERV-PHONE5-TYPE           
               MOVE SPACE        TO CA414-ID-SERV-PHONE5-IND            
           END-IF.                                                      
      *                                                                 18630000
           PERFORM 8500-WRITE-CA414-FILE THRU 8500-EXIT.                
      *                                                                 18650002
      ** THE FOLLOWING SECTION WRITES A CONSUMER ADDRESS SEGMENT **     18660002
      ** FOR SERVICE ADDRESS                                     **     18670002
           INITIALIZE CA414-ADDRESS-SEGMENT.                            
           MOVE '3'                    TO CA414-AD-REC-TYPE.            
           IF WS-COMPANY-PROCESSED = '26'                               
              MOVE 'PSNC' TO CA414-AD-COMPANY-ABBR                      
              MOVE 'NC'   TO CA414-AD-EXCH-ID                           
           ELSE                                                         
              MOVE 'SCGA'  TO CA414-AD-COMPANY-ABBR                     
              MOVE 'NC'    TO CA414-AD-EXCH-ID                          
           END-IF.                                                      
           MOVE '001'                  TO CA414-AD-LOCATION-ID.         
           MOVE WS-GROUP-DATE          TO CA414-AD-GROUP-CONTROL-NO.    
           MOVE 'A'                    TO CA414-AD-ACCOUNT-CODE.        
           MOVE 'AD'                   TO CA414-AD-SEGMENT-CD.          
           MOVE WS-FCA414-REC-CNTR     TO CA414-AD-RECORD-NO.           
           MOVE AT-ACCOUNT-NO          TO CA414-AD-ACCOUNT-NO.          
           MOVE 'S'                    TO CA414-AD-ADDR-TYPE.           
           MOVE 'U'                    TO CA414-AD-ADDR-FORMAT          
           MOVE 'A'                    TO CA414-AD-ADDR-COUNTRY.        
           MOVE WS-PR-STREET           TO CA414-AD-LINE1.               
           MOVE WS-PR-ADDR-OVERFLOW    TO CA414-AD-LINE2.               
           MOVE WS-PR-ADDR-CITY-STATE  TO CA414-AD-LINE3.               
           MOVE WS-PR-ADDR-ZIP         TO CA414-AD-ZIP9.                
           PERFORM 8500-WRITE-CA414-FILE THRU 8500-EXIT.                
      *                                                                 18910014
           IF WS-MAIL-ADDR NOT = SPACES                                 
              INITIALIZE CA414-ADDRESS-SEGMENT                          
              MOVE '3'                     TO CA414-AD-REC-TYPE         
              IF WS-COMPANY-PROCESSED = '26'                            
                 MOVE 'PSNC' TO CA414-AD-COMPANY-ABBR                   
                 MOVE 'NC'   TO CA414-AD-EXCH-ID                        
              ELSE                                                      
                 MOVE 'SCGA'  TO CA414-AD-COMPANY-ABBR                  
                 MOVE 'NC'    TO CA414-AD-EXCH-ID                       
              END-IF                                                    
              MOVE '001'                   TO CA414-AD-LOCATION-ID      
              MOVE WS-GROUP-DATE           TO CA414-AD-GROUP-CONTROL-NO 
              MOVE 'A'                     TO CA414-AD-ACCOUNT-CODE     
              MOVE 'AD'                    TO CA414-AD-SEGMENT-CD       
              MOVE WS-FCA414-REC-CNTR      TO CA414-AD-RECORD-NO        
              MOVE AT-ACCOUNT-NO           TO CA414-AD-ACCOUNT-NO       
              MOVE 'B'                     TO CA414-AD-ADDR-TYPE        
              MOVE 'U'                     TO CA414-AD-ADDR-FORMAT      
              MOVE 'A'                     TO CA414-AD-ADDR-COUNTRY     
              MOVE WS-MAIL-ADDR-STREET     TO CA414-AD-LINE1            
              MOVE WS-MAIL-ADDR-OVERFLOW   TO CA414-AD-LINE2            
              MOVE WS-MAIL-ADDR-CITY-STATE TO CA414-AD-LINE3            
              MOVE WS-MAIL-ADDR-ZIP        TO WS-AD-ZIP5                
              MOVE WS-MAIL-ADDR-ZIP-PLUS-4 TO WS-AD-ZIP4                
              MOVE WS-AD-ZIP9              TO CA414-AD-ZIP9             
              PERFORM 8500-WRITE-CA414-FILE THRU 8500-EXIT              
           END-IF.                                                      
      *                                                                 19180065
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19250000
      ******************************************************************19260079
      * 5500-LOAD-EXCH-DATA-SENT                                       *19270079
      * THIS MODULE LOADS THE CSS_EXCH_DATA_SENT WITH ACCOUNT INFO     *19280079
      ******************************************************************19290079
       5500-LOAD-EXCH-DATA-SENT.                                        
      *                                                                 19310079
           PERFORM 7740-SELECT-TIMESTAMP    THRU 7740-EXIT              
           MOVE WS-CURRENT-TIMESTAMP        TO EX-EXCH-SENT-TS          
           MOVE AT-ACCOUNT-NO               TO EX-ACCOUNT-NO            
           MOVE AT-CUSTOMER-NO              TO EX-CUSTOMER-NO           
           MOVE AT-PREMISE-NO               TO EX-PREMISE-NO            
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'B'                                                 
                    MOVE 'NCB'              TO EX-EXCH-REC-TYPE-CD      
               WHEN 'S'                                                 
                    MOVE 'NCS'              TO EX-EXCH-REC-TYPE-CD      
               WHEN 'A'                                                 
                    MOVE 'NCA'              TO EX-EXCH-REC-TYPE-CD      
           END-EVALUATE.                                                
           MOVE EX-EXCH-REC-TYPE-CD TO CA414-AC-REC-TYPE-CD.            
           IF AT-PREMISE-NO NUMERIC                                     
               MOVE AT-PREMISE-NO           TO EX-PREMISE-NO            
           ELSE                                                         
               MOVE ZEROS                   TO EX-PREMISE-NO            
           END-IF.                                                      
           MOVE WS-COMPANY-PROCESSED        TO EX-COMPANY-NO.           
           MOVE AT-TOTAL-AR-BALANCE         TO EX-EXCH-SENT-AM.         
      *                                                                 19422879
           PERFORM 8000-INSERT-EXCH-DATA    THRU 8000-EXIT.             
                                                                        
      *                                                                 19423179
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19423179
      ******************************************************************26101009
      **  6240-GET-FCA00-COMMON-DATE.                                  *26102009
      ******************************************************************26103009
      *                                                                 26104009
           COPY CPD00040.                                               26105009
      *                                                                 26106009
      ******************************************************************26021785
      *  6251-GET-FJC01-DATE.                                          *26022008
      ******************************************************************26023008
      *                                                                 26024008
           EXEC SQL                                                     26025008
               INCLUDE CPD00037                                         26026008
           END-EXEC.                                                    26027008
      *                                                                 26028008
      ******************************************************************26021185
      **  6253-GET-FJC01-CHKP-LIMIT.                                   *26021285
      ******************************************************************26021385
      *                                                                 26021485
           COPY CPD00034.                                               26021585
      *                                                                 26021685
      ******************************************************************19423409
      * 7001-READ-FCSDB07                                              *19423509
      ******************************************************************19423609
      *                                                                 19423709
       7001-READ-FCSDB07.                                               
      *                                                                 19423909
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-END-OF-FILE           
                   GO TO 7001-EXIT                                      
           END-READ.                                                    
      *                                                                 19424509
           IF  FDB07-SUCCESSFUL                                         
               ADD 1 TO WS-FCSDB07-REC-CNTR                             
           ELSE                                                         
              DISPLAY '*************** ABENDING ***************'        
              DISPLAY '* 7001-ERROR ON FCSDB07 READ.          *'        
              DISPLAY '* STATUS  - ' WS-FDB07-STATUS                    
              DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO             
              DISPLAY '*************** PCSCA414 ****************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 19425909
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19426209
      ******************************************************************19760002
      * 7002-READ-FCA414                                               *19770002
      ******************************************************************19780002
      *                                                                 19790002
       7002-READ-FCA414.                                                
      *                                                                 19810002
           READ FCA414R-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-END-OF-RFILE          
                   GO TO 7002-EXIT                                      
           END-READ.                                                    
      *                                                                 19870002
           IF FCA414-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*************** ABENDING ***************'        
              DISPLAY '* 7002-ERROR ON FCA414 READ.        *'           
              DISPLAY '* STATUS  - ' WS-FCA414R-STATUS                  
              DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO             
              DISPLAY '*************** PCSCA414 ****************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 19950002
       7002-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19980002
      ****************************************************************  19427002
      * 7120-SELECT-RESTART                                          *  19430002
      ****************************************************************  19440002
      *                                                                 19450002
       7120-SELECT-RESTART.                                             
      *                                                                 19470002
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19480002
MFA-TR*       SELECT RF.RESTART_DATA                                    19490002
MFA-TR*         INTO :RF-RESTART-DATA                                   19500002
MFA-TR*         FROM CSS_RESTART RF                                     19510002
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 19520002
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                 19530002
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 19540002
MFA-TR*         WITH UR                                                 19550002
MFA-TR*         QUERYNO 7120                                            19560002
MFA-TR*    END-EXEC.                                                    19570002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19571029
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************ABENDING*******************'     
              DISPLAY '**   ERROR ON 7120-SELECT-RESTART        **'     
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '****************PCSCA414*******************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 19720002
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19750002
ACT084******************************************************************19990054
      *   7200-OPEN-OLD-UCA-CURSOR                                     *20000054
      *   OPENS OLD UCA CURSOR                                         *20010054
      ******************************************************************20020054
       7200-OPEN-OLD-UCA-CURSOR.                                        
           EXEC SQL                                                     
              OPEN OLD-UCA-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20070054
           MOVE SQLCODE                       TO  WS-ACTIVE-RETURN-CODE.
      *                                                                 20090054
           IF  WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL            
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7200-OPEN-OLD-UCA-CURSOR     **'             
               DISPLAY '** SQLCODE IS ',     WS-ACTIVE-RETURN-CODE      
               DISPLAY '** EX-ACCOUNT-NO = ' EX-ACCOUNT-NO              
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA414 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 20210054
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************20240054
      *  7240-FETCH-OLD-UCA-CURSOR                                      20250054
      *  FETCHES OLD-UCA-CURSOR                                         20260054
      ******************************************************************20270054
       7240-FETCH-OLD-UCA-CURSOR.                                       
           EXEC SQL                                                     
              FETCH   OLD-UCA-CURSOR                                    
               INTO   :EX-ACCOUNT-NO                                    
                     ,:EX-COMPANY-NO                                    
                     ,:EX-CUSTOMER-NO                                   
                     ,:EX-EXCH-REC-TYPE-CD                              
                     ,:EX-EXCH-SENT-AM                                  
                     ,:EX-EXCH-SENT-TS                                  
                     ,:EX-PREMISE-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20390054
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 20410054
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7240-FETCH-OLD-UCA-CURSOR    **'             
               DISPLAY '** ACCOUNT NO ',  EX-ACCOUNT-NO                 
               DISPLAY '** CUSTOMER NO ', EX-CUSTOMER-NO                
               DISPLAY '** PREMISE  NO ', EX-PREMISE-NO                 
               DISPLAY '** SQLCODE IS ',  WS-ACTIVE-RETURN-CODE         
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA414 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 20530054
       7240-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************20560054
      *  7280-CLOSE-OLD-UCA-CURSOR                                      20570054
      *  CLOSES OLD-UCA-CURSOR                                          20580054
      ******************************************************************20590054
       7280-CLOSE-OLD-UCA-CURSOR.                                       
           EXEC SQL                                                     
              CLOSE OLD-UCA-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20640054
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 20660054
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ ABENDING ************'             
               DISPLAY '** 7280-CLOSE-OLD-UCA-CURSOR    **'             
               DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA414 ************'             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 20770054
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20800054
      ***************************************************************** 22170002
      *  7300-GET-CUST-STATS                                          * 22180002
      *       GETS CUST STATS INFORMATION -CUSTOMER STATISTICS        * 22190000
      ***************************************************************** 22200000
       7300-GET-CUST-STATS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    CODE_STATE_ID,                                      
                    EMPLOYER,                                           
                    DATE_OF_BIRTH,                                      
                    CUSTOMER_TYPE,                                      
                    DRIVERS_LICENSE_NO,                                 
                    OTHER_ID,                                           
                    EMPLOYER,                                           
                    SSN,                                                
                    NAME_ID                                             
                INTO                                                    
                   :CE-CODE-STATE-ID,                                   
                   :CE-EMPLOYER,                                        
                   :CE-DATE-OF-BIRTH :WS-DATE-OF-BIRTH-NULL,            
                   :CE-CUSTOMER-TYPE,                                   
                   :CE-DRIVERS-LICENSE-NO,                              
                   :CE-OTHER-ID,                                        
                   :CE-EMPLOYER,                                        
                   :CE-SSN,                                             
                   :CE-NAME-ID                                          
                 FROM  CSS_CUST_STATS WITH(READUNCOMMITTED)                     
                WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                    
                  AND  CUSTOMER_TYPE IN ('C')                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22230000
MFA-TR*        SELECT                                                   22240000
MFA-TR*             CODE_STATE_ID,                                      22250002
MFA-TR*             EMPLOYER,                                           22260002
MFA-TR*             DATE_OF_BIRTH,                                      22270002
MFA-TR*             CUSTOMER_TYPE,                                      22280000
MFA-TR*             DRIVERS_LICENSE_NO,                                 22290000
MFA-TR*             OTHER_ID,                                           22300000
MFA-TR*             EMPLOYER,                                           22310000
MFA-TR*             SSN,                                                22320000
MFA-TR*             NAME_ID                                             22330000
MFA-TR*         INTO                                                    22340000
MFA-TR*            :CE-CODE-STATE-ID,                                   22350002
MFA-TR*            :CE-EMPLOYER,                                        22360002
MFA-TR*            :CE-DATE-OF-BIRTH :WS-DATE-OF-BIRTH-NULL,            22370002
MFA-TR*            :CE-CUSTOMER-TYPE,                                   22380000
MFA-TR*            :CE-DRIVERS-LICENSE-NO,                              22390000
MFA-TR*            :CE-OTHER-ID,                                        22400000
MFA-TR*            :CE-EMPLOYER,                                        22410000
MFA-TR*            :CE-SSN,                                             22420000
MFA-TR*            :CE-NAME-ID                                          22430000
MFA-TR*          FROM  CSS_CUST_STATS                                   22440000
MFA-TR*         WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO                    22450005
MFA-TR*           AND  CUSTOMER_TYPE IN ('C')                           22460029
MFA-TR*         WITH UR                                                 19550002
MFA-TR*         QUERYNO 7300                                            19560002
MFA-TR*    END-EXEC.                                                    22470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22480000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 22500000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-OF-BIRTH-NULL < 0                              
                 MOVE SPACES      TO CE-DATE-OF-BIRTH                   
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES           TO CE-SSN                        
                                          CE-DRIVERS-LICENSE-NO         
                                          CE-OTHER-ID                   
                                          CE-EMPLOYER                   
                                          CE-CUSTOMER-TYPE              
                                          CE-CODE-STATE-ID              
                                          CE-EMPLOYER                   
                                          CE-DATE-OF-BIRTH              
                 MOVE ZERO             TO CE-NAME-ID                    
              ELSE                                                      
               DISPLAY '************* ABENDING ************'            
               DISPLAY '**   PCSCA414 PROCESSING ERROR   **'            
               DISPLAY '**   7300-GET-CUST-STATS         **'            
               DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '**   CUSTOMER NUMBER = ' CE-CUSTOMER-NO         
               DISPLAY '**   PROCESSING TERMINATED     **'              
               DISPLAY '************* PCSCA414 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 22810002
      *  7320-GET-CUST-INFO                                           * 22820002
      *       GETS CUST INFORMATION                                   * 22830002
      ***************************************************************** 22840002
       7320-GET-CUST-INFO.                                              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    NAME_ID                                             
                INTO                                                    
                   :CU-NAME-ID                                          
                 FROM  CSS_CUSTOMER CU WITH(READUNCOMMITTED)                    
                WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22870002
MFA-TR*        SELECT                                                   22880002
MFA-TR*             NAME_ID                                             22890002
MFA-TR*         INTO                                                    22900002
MFA-TR*            :CU-NAME-ID                                          22910002
MFA-TR*          FROM  CSS_CUSTOMER CU                                  22920002
MFA-TR*         WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                    22930002
MFA-TR*         WITH UR                                                 19550002
MFA-TR*         QUERYNO 7320                                            19560002
MFA-TR*    END-EXEC.                                                    22940002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22950002
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 22970002
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES TO CU-NAME-ID                              
              ELSE                                                      
               DISPLAY '************* ABENDING ************'            
               DISPLAY '**   PCSCA414 PROCESSING ERROR   **'            
               DISPLAY '**    7320-GET-CUST-INFO    **'                 
               DISPLAY '**    CUSTOMER NUMBER = ' CU-CUSTOMER-NO        
               DISPLAY '**    ACCOUNT NUMBER = '  AT-ACCOUNT-NO         
               DISPLAY '**    SQLCODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**    PROCESSING TERMINATED     **'             
               DISPLAY '************* PCSCA414 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ***************************************************************** 23190002
      *  7330-GET-NAME-INFO                                           * 23200002
      *       GETS CUST INFORMATION                                   * 23210002
      ***************************************************************** 23220002
       7330-GET-NAME-INFO.                                              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   NAME_TYPE                                            
                  ,NAME_FORMAT                                          
                INTO                                                    
                   :DQ-NAME-TYPE                                        
                  ,:DQ-NAME-FORMAT                                      
                 FROM  CSS_NAME DQ WITH(READUNCOMMITTED)                        
                WHERE  NAME_ID = :DQ-NAME-ID                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23250002
MFA-TR*        SELECT                                                   23260002
MFA-TR*            NAME_TYPE                                            23270002
MFA-TR*           ,NAME_FORMAT                                          23280002
MFA-TR*         INTO                                                    23290002
MFA-TR*            :DQ-NAME-TYPE                                        23300002
MFA-TR*           ,:DQ-NAME-FORMAT                                      23310002
MFA-TR*          FROM  CSS_NAME DQ                                      23320002
MFA-TR*         WHERE  NAME_ID = :DQ-NAME-ID                            23330002
MFA-TR*         WITH UR                                                 19550002
MFA-TR*         QUERYNO 7330                                            19560002
MFA-TR*    END-EXEC.                                                    23340002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23350002
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 23370002
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO DQ-NAME-TYPE                            
                                DQ-NAME-FORMAT                          
              ELSE                                                      
               DISPLAY '************* PCSCA414 ************'            
               DISPLAY '**   PCSCA414 PROCESSING ERROR   **'            
               DISPLAY '**    7330-GET-NAME-INFO   **'                  
               DISPLAY '**    SQLCODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**    NAME ID = ' DQ-NAME-ID                    
               DISPLAY '**    ACCOUNT NUMBER = ' AT-ACCOUNT-NO          
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '************* PCSCA414 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 24030004
      ***************************************************************** 24040004
      *  7400-GET-ACCT-INFO                                           * 24050004
      *       RETRIEVES INFO FROM THE ACCOUNT TABLE.                  * 24060004
      ***************************************************************** 24070004
       7400-GET-ACCT-INFO.                                              
      *                                                                 24090004
           EXEC SQL                                                     
               SELECT                                                   
                    AT.CODE_ACCT_STAT                                   
                   ,AT.CUSTOMER_NO                                      
                   ,AT.PREMISE_NO                                       
                   ,AT.ADDRESS_ID                                       
                   ,AT.ADDRESS_FORMAT                                   
                   ,AT.ACCOUNT_TYPE_CODE                                
                   ,AT.BILL_CYCLE                                       
                   ,AT.TOTAL_AR_BALANCE                                 
                   ,AT.CODES_DATA_PRESENT                               
                   ,AT.LOCAL_OFFICE                                     
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                   ,AT.DATE_BILL_DAY_00                                 
                   ,AT.BANKRUPTCY_IND                                   
                   ,AT.CODE_STATUS_REASON                               
                   ,AT.ACCT_XFER_TO                                     
                   ,AT.DATE_BILL_DAY_00                                 
                   ,AT.DATE_BILL_DAY_30                                 
                   ,AT.DATE_BILL_DAY_60                                 
                   ,AT.DATE_BILL_DAY_90                                 
                INTO                                                    
                    :AT-CODE-ACCT-STAT                                  
                   ,:AT-CUSTOMER-NO                                     
                   ,:AT-PREMISE-NO                                      
                   ,:AT-ADDRESS-ID                                      
                   ,:AT-ADDRESS-FORMAT                                  
                   ,:AT-ACCOUNT-TYPE-CODE                               
                   ,:AT-BILL-CYCLE                                      
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL          
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-BANKRUPTCY-IND                                  
                   ,:AT-CODE-STATUS-REASON                              
                   ,:AT-ACCT-XFER-TO                                    
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-DATE-BILL-DAY-30                                
                   ,:AT-DATE-BILL-DAY-60                                
                   ,:AT-DATE-BILL-DAY-90                                
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                AND   AT.COMPANY_NO = :AT-COMPANY-NO                    
PRJ951          AND AT.ACCOUNT_NO NOT IN (SELECT RP.ACCOUNT_NO FROM     
PRJ951              CSS_REG_PROFILE    RP WITH(READUNCOMMITTED)                 
PRJ951              WHERE RP.ACCOUNT_NO = AT.ACCOUNT_NO)                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     24100004
MFA-TR*        SELECT                                                   24110004
MFA-TR*             AT.CODE_ACCT_STAT                                   24120004
MFA-TR*            ,AT.CUSTOMER_NO                                      24130004
MFA-TR*            ,AT.PREMISE_NO                                       24140004
MFA-TR*            ,AT.ADDRESS_ID                                       24150004
MFA-TR*            ,AT.ADDRESS_FORMAT                                   24160004
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                24160190
MFA-TR*            ,AT.BILL_CYCLE                                       24161090
MFA-TR*            ,AT.TOTAL_AR_BALANCE                                 24170004
MFA-TR*            ,AT.CODES_DATA_PRESENT                               24180004
MFA-TR*            ,AT.LOCAL_OFFICE                                     24200004
MFA-TR*            ,AT.ACCT_FINALED_DT                                  24210004
MFA-TR*            ,AT.DATE_BILL_DAY_00                                 24211019
MFA-TR*            ,AT.BANKRUPTCY_IND                                   24212029
MFA-TR*            ,AT.CODE_STATUS_REASON                               24213030
MFA-TR*            ,AT.ACCT_XFER_TO                                     24214030
MFA-TR*            ,AT.DATE_BILL_DAY_00                                         
MFA-TR*            ,AT.DATE_BILL_DAY_30                                         
MFA-TR*            ,AT.DATE_BILL_DAY_60                                         
MFA-TR*            ,AT.DATE_BILL_DAY_90                                         
MFA-TR*         INTO                                                    24220004
MFA-TR*             :AT-CODE-ACCT-STAT                                  24230004
MFA-TR*            ,:AT-CUSTOMER-NO                                     24240004
MFA-TR*            ,:AT-PREMISE-NO                                      24250004
MFA-TR*            ,:AT-ADDRESS-ID                                      24260004
MFA-TR*            ,:AT-ADDRESS-FORMAT                                  24270004
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                               24270191
MFA-TR*            ,:AT-BILL-CYCLE                                      24271090
MFA-TR*            ,:AT-TOTAL-AR-BALANCE                                24280004
MFA-TR*            ,:AT-CODES-DATA-PRESENT                              24290004
MFA-TR*            ,:AT-LOCAL-OFFICE                                    24310004
MFA-TR*            ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL          24320004
MFA-TR*            ,:AT-DATE-BILL-DAY-00                                24321019
MFA-TR*            ,:AT-BANKRUPTCY-IND                                  24322029
MFA-TR*            ,:AT-CODE-STATUS-REASON                              24323030
MFA-TR*            ,:AT-ACCT-XFER-TO                                    24324030
MFA-TR*            ,:AT-DATE-BILL-DAY-00                                        
MFA-TR*            ,:AT-DATE-BILL-DAY-30                                        
MFA-TR*            ,:AT-DATE-BILL-DAY-60                                        
MFA-TR*            ,:AT-DATE-BILL-DAY-90                                        
MFA-TR*        FROM CSS_ACCOUNT AT                                      24330004
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    24340004
MFA-TR*         AND   AT.COMPANY_NO = :AT-COMPANY-NO                    24340004
MFA-TR*         AND AT.ACCOUNT_NO NOT IN (SELECT RP.ACCOUNT_NO FROM             
MFA-TR*             CSS_REG_PROFILE    RP                                       
MFA-TR*             WHERE RP.ACCOUNT_NO = AT.ACCOUNT_NO)                        
MFA-TR*         WITH UR                                                 19550002
MFA-TR*         QUERYNO 7400                                            19560002
MFA-TR*    END-EXEC.                                                    24360004

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24370004
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 24390028
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
              IF WS-ACCT-FINAL-DT-NULL < 0                              
                  MOVE WS-SPACES TO AT-ACCT-FINALED-DT                  
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
PRJ951        CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************* ABENDING ************'             
              DISPLAY '**   PCSCA414 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 7400    **'             
              DISPLAY '**    ACCOUNT NUMBER = ' AT-ACCOUNT-NO           
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '************* PCSCA414 ************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF
           END-IF.                                                      
      *                                                                 24540004
       7400-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24561019
      *7500-GET-SERVICE-DATE.                                           24570019
      ***************************************************************** 24571019
      *                                                                 24580019
       7500-GET-SERVICE-DATE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
                 DATE_UTIL_SVC_STRT,                                    
                 DATE_UTIL_SVC_END                                      
             INTO                                                       
                 :CH-DATE-UTIL-SVC-STRT :WS-DT-UTIL-SVC-STRT-NULL,      
                 :CH-DATE-UTIL-SVC-END :WS-DT-UTIL-SVC-END-NULL        
             FROM                                                       
                 CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                       
             WHERE                                                      
                 ACCOUNT_NO = :CH-ACCOUNT-NO                            
             AND PREMISE_NO = :CH-PREMISE-NO                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24590019
MFA-TR*      SELECT                                                     24600019
MFA-TR*          DATE_UTIL_SVC_STRT,                                    24610019
MFA-TR*          DATE_UTIL_SVC_END                                      24620019
MFA-TR*      INTO                                                       24630019
MFA-TR*          :CH-DATE-UTIL-SVC-STRT :WS-DT-UTIL-SVC-STRT-NULL,      24640019
MFA-TR*          :CH-DATE-UTIL-SVC-END  :WS-DT-UTIL-SVC-END-NULL        24650029
MFA-TR*      FROM                                                       24660019
MFA-TR*          CSS_CUST_PREM_HIST                                     24670019
MFA-TR*      WHERE                                                      24680019
MFA-TR*          ACCOUNT_NO = :CH-ACCOUNT-NO                            24690019
MFA-TR*      AND PREMISE_NO = :CH-PREMISE-NO                            24700019
MFA-TR*      WITH UR                                                    19550002
MFA-TR*      QUERYNO 7500                                               19560002
MFA-TR*    END-EXEC.                                                    24710019

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24720019
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 24722028
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF SQLCODE = NOT-FOUND                                    
                 MOVE SPACES       TO CH-DATE-UTIL-SVC-STRT             
                 MOVE SPACES       TO CH-DATE-UTIL-SVC-END              
              ELSE                                                      
                 IF WS-DT-UTIL-SVC-END-NULL < 0                         
                    MOVE SPACES       TO CH-DATE-UTIL-SVC-END           
                 END-IF                                                 
                 IF WS-DT-UTIL-SVC-STRT-NULL < 0                        
                    MOVE SPACES       TO CH-DATE-UTIL-SVC-STRT          
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*****************PCSCA414******************'    
               DISPLAY '* 7500-GET-SERVICE-DATE          *'             
               DISPLAY '* CH-ACCOUNT-NO' CH-ACCOUNT-NO                  
               DISPLAY '* CH-PREMISE-NO' CH-PREMISE-NO                  
               DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 24922019
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24927630
      ***************************************************************** 24927719
      *7550-GET-AR-AMOUNTS.                                             24927829
      ***************************************************************** 24927919
      *                                                                 24928019
       7550-GET-AR-AMOUNTS.                                             
                                                                        
           EXEC SQL                                                     
             SELECT                                                     
                 SUM(AMT_AR_DAY_00),                                    
                 SUM(AMT_AR_DAY_30),                                    
                 SUM(AMT_AR_DAY_60),                                    
                 SUM(AMT_AR_DAY_90)                                     
             INTO                                                       
                 :AC-AMT-AR-DAY-00 :WS-DAY-00-NULL-IND,                  
                 :AC-AMT-AR-DAY-30 :WS-DAY-30-NULL-IND,                  
                 :AC-AMT-AR-DAY-60 :WS-DAY-60-NULL-IND,                  
                 :AC-AMT-AR-DAY-90 :WS-DAY-90-NULL-IND                   
             FROM                                                       
                 CSS_AR_CNTL WITH(READUNCOMMITTED)                              
             WHERE                                                      
                 ACCOUNT_NO = :AC-ACCOUNT-NO                            
             AND ITEM_ID    = 0                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24929219
MFA-TR*      SELECT                                                     24929319
MFA-TR*          SUM(AMT_AR_DAY_00),                                    24929468
MFA-TR*          SUM(AMT_AR_DAY_30),                                    24929568
MFA-TR*          SUM(AMT_AR_DAY_60),                                    24929668
MFA-TR*          SUM(AMT_AR_DAY_90)                                     24929768
MFA-TR*      INTO                                                       24929835
MFA-TR*          :AC-AMT-AR-DAY-00:WS-DAY-00-NULL-IND,                  24929969
MFA-TR*          :AC-AMT-AR-DAY-30:WS-DAY-30-NULL-IND,                  24930069
MFA-TR*          :AC-AMT-AR-DAY-60:WS-DAY-60-NULL-IND,                  24930169
MFA-TR*          :AC-AMT-AR-DAY-90:WS-DAY-90-NULL-IND                   24930269
MFA-TR*      FROM                                                       24930335
MFA-TR*          CSS_AR_CNTL                                            24930435
MFA-TR*      WHERE                                                      24930535
MFA-TR*          ACCOUNT_NO = :AC-ACCOUNT-NO                            24930635
MFA-TR*      AND ITEM_ID    = 0                                         24930750
MFA-TR*      WITH UR                                                    19550002
MFA-TR*      QUERYNO 7550                                               19560002
MFA-TR*    END-EXEC.                                                    24930819

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24930919
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DAY-00-NULL-IND < 0                                 
                 MOVE 0      TO AC-AMT-AR-DAY-00                        
              END-IF                                                    
              IF WS-DAY-30-NULL-IND < 0                                 
                 MOVE 0      TO AC-AMT-AR-DAY-30                        
              END-IF                                                    
              IF WS-DAY-60-NULL-IND < 0                                 
                 MOVE 0      TO AC-AMT-AR-DAY-60                        
              END-IF                                                    
              IF WS-DAY-90-NULL-IND < 0                                 
                 MOVE 0      TO AC-AMT-AR-DAY-90                        
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*****************PCSCA414******************'    
               DISPLAY '* 7550 : GET-AR-AMOUNTS             *'          
               DISPLAY '* AC-ACCOUNT-NO' AC-ACCOUNT-NO                  
               DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 24933619
       7550-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24933923
      *7560-GET-CHRG-OFF-AMT.                                           24934023
      ***************************************************************** 24934123
      *                                                                 24934223
       7560-GET-CHRG-OFF-AMT.                                           
                                                                        
      *                                                                 24936323
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-CHARGE-OFF-AMT-NULL              
                 FROM CSS_CHRG_OFF CO WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24936423
MFA-TR*        SELECT SUM(AMT_TRANS)                                    24936523
MFA-TR*          INTO :CO-AMT-TRANS:WS-CHARGE-OFF-AMT-NULL              24936625
MFA-TR*          FROM CSS_CHRG_OFF CO                                   24936723
MFA-TR*         WHERE ACCOUNT_NO        = :CO-ACCOUNT-NO                24936823
MFA-TR*        WITH UR                                                  24936923
MFA-TR*        QUERYNO 7560                                             24937023
MFA-TR*    END-EXEC.                                                    24937123

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-CHARGE-OFF-AMT-NULL < 0                             
                 MOVE ZEROS            TO CO-AMT-TRANS                  
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*****************ABENDING******************'     
              DISPLAY '* 7560-GET-CHRG-OFF-AMT                   *'     
              DISPLAY '* CO-ACCOUNT-NO' CO-ACCOUNT-NO                   
              DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCA414******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
      *                                                                 24939223
       7560-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24944096
      *7565-GET-PREVIOUS-BILL-DT                                        24945096
      ***************************************************************** 24946096
      *                                                                 24947096
       7565-GET-PREVIOUS-BILL-DT.                                       
                                                                        
      *                                                                 24950096
           EXEC SQL                                                     
               SELECT TOP(1) DATE_TRANS                                        
                 INTO :AR-DATE-TRANS                                    
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                AND   CODE_TRAN_TYPE    = 'B'                           
                AND   DATE_TRANS        < IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )          
                ORDER BY DATE_TRANS DESC                                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     24960096
MFA-TR*        SELECT DATE_TRANS                                        24970096
MFA-TR*          INTO :AR-DATE-TRANS                                    24980096
MFA-TR*          FROM CSS_AR_TRANS_HIST AR                              24990096
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                25000096
MFA-TR*         AND   CODE_TRAN_TYPE    = 'B'                           25010096
MFA-TR*         AND   DATE_TRANS        < :AT-DATE-BILL-DAY-00                  
MFA-TR*         ORDER BY DATE_TRANS DESC                                25020096
MFA-TR*         FETCH FIRST ROW ONLY                                    25030096
MFA-TR*        WITH UR                                                  25040096
MFA-TR*        QUERYNO 7565                                             25050096
MFA-TR*    END-EXEC.                                                    25060096

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*****************ABENDING******************'    
               DISPLAY '* 7565-GET-PREVIOUS-BILL-DT'                    
               DISPLAY '* AR-ACCOUNT-NO' AR-ACCOUNT-NO                  
               DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 25210096
       7565-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24944096
      *7567-CHECK-ACCT-BILLED                                           24945096
      ***************************************************************** 24946096
      *                                                                 24947096
       7567-CHECK-ACCT-BILLED.                                          
                                                                        
      *                                                                 24950096
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ACCT-BILLED                                   
                 FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO        = :BI-ACCOUNT-NO                
                AND   BI.DATE_BILLED IS NOT NULL                        
                ORDER BY BILL_NO DESC                                   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24960096
MFA-TR*        SELECT 'Y'                                               24970096
MFA-TR*          INTO :WS-ACCT-BILLED                                   24980096
MFA-TR*          FROM CSS_BILLING_HDR BI                                24990096
MFA-TR*         WHERE ACCOUNT_NO        = :BI-ACCOUNT-NO                25000096
MFA-TR*         AND   BI.DATE_BILLED IS NOT NULL                                
MFA-TR*         ORDER BY BILL_NO DESC                                           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                  25040096
MFA-TR*        QUERYNO 7567                                             25050096
MFA-TR*    END-EXEC.                                                    25060096

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*****************ABENDING******************'    
               DISPLAY '* 7567-CHECK-ACCT-BILLED'                       
               DISPLAY '* BI-ACCOUNT-NO ' BI-ACCOUNT-NO                 
               DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 25210096
       7567-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24939523
      *7570-GET-PAYMENT-AMT.                                            24939623
      ***************************************************************** 24939723
      *                                                                 24939823
       7570-GET-PAYMENT-AMT.                                            
                                                                        
      *                                                                 24940123
           EXEC SQL                                                     
               SELECT SUM(AMT_ORIG_ENTERED)                             
                 INTO :AR-AMT-ORIG-ENTERED :WS-PAYMENT-AMT-NULL          
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                AND   CODE_TRAN_TYPE    = 'P'                           
                AND   DATE_TRANS  >= IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     24940223
MFA-TR*        SELECT SUM(AMT_ORIG_ENTERED)                             24940399
MFA-TR*          INTO :AR-AMT-ORIG-ENTERED:WS-PAYMENT-AMT-NULL          24940499
MFA-TR*          FROM CSS_AR_TRANS_HIST AR                              24940523
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                24940623
MFA-TR*         AND   CODE_TRAN_TYPE    = 'P'                           24940728
MFA-TR*         AND   DATE_TRANS  >= :AR-DATE-TRANS                     24940899
MFA-TR*        WITH UR                                                  24941023
MFA-TR*        QUERYNO 7570                                             24941128
MFA-TR*    END-EXEC.                                                    24941223

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-PAYMENT-AMT-NULL < 0                                
                 MOVE 0     TO AR-AMT-ORIG-ENTERED                      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*****************ABENDING******************'     
              DISPLAY '* 7570-GET-PAYMENT-AMT                    *'     
              DISPLAY '* AR-ACCOUNT-NO' AR-ACCOUNT-NO                   
              DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE           
              DISPLAY '* PROGRAM ABENDING...                     *'     
              DISPLAY '*****************PCSCA414******************'     
              PERFORM 9900-ABEND  THRU  9900-EXIT                       
           END-IF.                                                      
      *                                                                 24943323
       7570-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 24944096
      *7575-CHECK-LPC                                                   24945096
      ***************************************************************** 24946096
      *                                                                 24947096
       7575-CHECK-LPC.                                                  
                                                                        
      *                                                                 24950096
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-LPC-ACCOUNT                                   
                 FROM CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                
                AND   FW_ACTION_TYPE_CD = 'LPC '                        
                AND   FW_ACTION_AM > 0                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24960096
MFA-TR*        SELECT 'Y'                                               24970096
MFA-TR*          INTO :WS-LPC-ACCOUNT                                   24980096
MFA-TR*          FROM CSS_FIN_WO_ACTION                                 24990096
MFA-TR*         WHERE ACCOUNT_NO        = :KD-ACCOUNT-NO                25000096
MFA-TR*         AND   FW_ACTION_TYPE_CD = 'LPC '                        25010096
MFA-TR*         AND   FW_ACTION_AM > 0                                  25011096
MFA-TR*        WITH UR                                                  25040096
MFA-TR*        QUERYNO 7575                                             25050096
MFA-TR*    END-EXEC.                                                    25060096

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*****************ABENDING******************'    
               DISPLAY '* 7575-CHECK-LPC'                               
               DISPLAY '* KD-ACCOUNT-NO' KD-ACCOUNT-NO                  
               DISPLAY '*        RC = '  WS-ACTIVE-RETURN-CODE          
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 25210096
       7575-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 26030000
      * 7600-START-FCSJC01                                            * 26040000
      *     READS JOB PARM TABLE                                      * 26050000
      ***************************************************************** 26060000
            EXEC SQL                                                    26070000
                INCLUDE CPD00038                                        26080000
            END-EXEC.                                                   26090000
      *                                                                 26100000
      ******************************************************************26100113
      *  7620-START-FCSCA00.                                           *26100213
      ******************************************************************26100313
      *                                                                 26100413
           EXEC SQL                                                     26100513
               INCLUDE CPD00039                                         26100613
           END-EXEC.                                                    26100713
      *                                                                 26100813
      ***************************************************************** 26110000
      *  7700-SELECT-PHONE-NO                                         * 26120000
      *       SELECTS CUSTOMER'S RESIDENCE PHONE NUMBER IF ABSENT     * 26130000
      *  SELECTS CUSTOMER'S WORK PHONE                                * 26140000
      ***************************************************************** 26150000
       7700-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
                SELECT PHONE_NO                                         
                  INTO :CB-PHONE-NO                                     
                  FROM  CSS_CUST_PHONE WITH(READUNCOMMITTED)                    
                 WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                 
                   AND  CUSTOMER_TYPE = :CB-CUSTOMER-TYPE               
                   AND  PHONE_TYPE    = :CB-PHONE-TYPE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26180000
MFA-TR*         SELECT PHONE_NO                                         26190000
MFA-TR*           INTO :CB-PHONE-NO                                     26200000
MFA-TR*           FROM  CSS_CUST_PHONE                                  26210000
MFA-TR*          WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                 26220000
MFA-TR*            AND  CUSTOMER_TYPE = :CB-CUSTOMER-TYPE               26230000
MFA-TR*            AND  PHONE_TYPE    = :CB-PHONE-TYPE                  26240000
MFA-TR*          WITH UR                                                19550002
MFA-TR*          QUERYNO 7700                                           19560002
MFA-TR*    END-EXEC.                                                    26250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO  WS-ACTIVE-RETURN-CODE.       
      *                                                                 26280030
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR SUCCESSFUL-CALL  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '************ ABENDING *************'            
               DISPLAY '**   PCSCA414 PROCESSING ERROR   **'            
               DISPLAY '**   7700-SELECT-PHONE-NO    **'                
               DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '**   CB-CUSTOMER-NO   = ' CB-CUSTOMER-NO        
               DISPLAY '**   CB-CUSTOMER-TYPE = ' CB-CUSTOMER-TYPE      
               DISPLAY '**   CB-PHONE-TYPE    = ' CB-PHONE-TYPE         
               DISPLAY '**   PROCESSING TERMINATED       **'            
               DISPLAY '************ PCSCA414 *************'            
               PERFORM 9900-ABEND   THRU 9900-EXIT                      
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26460000
      ******************************************************************26470030
      *      7740-SELECT-TIMESTAMP                                     *26480030
      ******************************************************************26490030
       7740-SELECT-TIMESTAMP.                                           
      *                                                                 26510030
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     26520030
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           26530030
MFA-TR*    END-EXEC.                                                    26540030

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26550030
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               DISPLAY '*****************ABENDING******************'    
               DISPLAY '* 7740 : RETURN CODE ERROR                *'    
               DISPLAY '* PARAGRAPH => 7740-SELECT-TIMESTAMP      *'    
               DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA414******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                 26680030
       7740-EXIT.                                                       
            EXIT.                                                       
      *                                                                 26710030
      ***************************************************************** 27081030
      *  8000-INSERT-EXCH-DATA.                                       * 27082030
      *      INSERT EXCHANGE DATA INTO THE CSS_EXCH_DATA_SENT TABLE   * 27083030
      ***************************************************************** 27084030
       8000-INSERT-EXCH-DATA.                                           
      *                                                                 27086030
           EXEC SQL                                                     
                INSERT INTO CSS_EXCH_DATA_SENT                          
                           (ACCOUNT_NO                                  
                           ,EXCH_REC_TYPE_CD                            
                           ,EXCH_SENT_TS                                
                           ,CUSTOMER_NO                                 
                           ,PREMISE_NO                                  
                           ,EXCH_SENT_AM                                
                           ,COMPANY_NO                                  
                           )                                            
                 VALUES   (:EX-ACCOUNT-NO                               
                          ,:EX-EXCH-REC-TYPE-CD                         
                          ,CIS.CHAR2TIMESTAMP(:EX-EXCH-SENT-TS)                 
                          ,:EX-CUSTOMER-NO                              
                          ,:EX-PREMISE-NO                               
                          ,:EX-EXCH-SENT-AM                             
                          ,:EX-COMPANY-NO                               
                           )                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     27087030
MFA-TR*         INSERT INTO CSS_EXCH_DATA_SENT                          27088030
MFA-TR*                    (ACCOUNT_NO                                  27089030
MFA-TR*                    ,EXCH_REC_TYPE_CD                            27089130
MFA-TR*                    ,EXCH_SENT_TS                                27089230
MFA-TR*                    ,CUSTOMER_NO                                 27089330
MFA-TR*                    ,PREMISE_NO                                  27089430
MFA-TR*                    ,EXCH_SENT_AM                                27089530
MFA-TR*                    ,COMPANY_NO                                  27089630
MFA-TR*                    )                                            27089730
MFA-TR*          VALUES   (:EX-ACCOUNT-NO                               27089830
MFA-TR*                   ,:EX-EXCH-REC-TYPE-CD                         27089930
MFA-TR*                   ,:EX-EXCH-SENT-TS                             27090030
MFA-TR*                   ,:EX-CUSTOMER-NO                              27090130
MFA-TR*                   ,:EX-PREMISE-NO                               27090230
MFA-TR*                   ,:EX-EXCH-SENT-AM                             27090330
MFA-TR*                   ,:EX-COMPANY-NO                               27090430
MFA-TR*                    )                                            27090530
MFA-TR*    END-EXEC.                                                    27090630

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27090730
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* ABENDING  ************'           
               DISPLAY '**   PCSCA414 PROCESSING ERROR   **'            
               DISPLAY '**   ABEND IN PARAGRAPH 8000     **'            
               DISPLAY '**   SQLCODE = '   WS-ACTIVE-RETURN-CODE        
               DISPLAY '**   ACCOUNT # = ' EX-ACCOUNT-NO                
               DISPLAY '**   EXCH REC TYPE = ' EX-EXCH-REC-TYPE-CD      
              DISPLAY '**   EXCH SENT TS = ' EX-EXCH-SENT-TS            
              DISPLAY '**   PROCESSING TERMINATED       **'             
              DISPLAY '************* PCSCA414 ************'             
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                 27092330
       8000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 27540000
      *  8500-WRITE-CA414-FILE                                        * 27550030
      *  WRITES FIOCA414-RECORD INTO OUTPUT FILE                      * 27560008
      ***************************************************************** 27570000
       8500-WRITE-CA414-FILE.                                           
           WRITE FIOCA414-RECORD.                                       
      *                                                                 27600006
           IF FCA414-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** ABENDING ***************'       
               DISPLAY '* PARAGRAPH => 8500-WRITE-CA414-FILE   *'       
               DISPLAY '* ERROR - IN WRITING OUTPUT FILE       *'       
               DISPLAY '* STATUS  - ' WS-FCA414-STATUS                  
               DISPLAY '*************** PCSCA414 ****************'      
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                 27710006
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27740000
      *                                                                 28063006
      ******************************************************************28063161
      * 8810-WRITE-RESTART                                             *28063261
      ******************************************************************28063361
      *                                                                 28063461
       8810-WRITE-RESTART.                                              
      *                                                                 28063661
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8820-UPDATE-RESTART      THRU 8820-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8830-INSERT-RESTART   THRU 8830-EXIT              
           END-IF.                                                      
      *                                                                 28064861
       8810-EXIT.                                                       
            EXIT.                                                       
      *                                                                 28065161
      ******************************************************************28065261
      * 8820-UPDATE-RESTART                                            *28065361
      ******************************************************************28065461
      *                                                                 28065561
       8820-UPDATE-RESTART.                                             
      *                                                                 28065761
           EXEC SQL                                                     
               UPDATE RF                                     
                  SET RF.RESTART_DATA = :RF-RESTART-DATA                
               FROM CSS_RESTART RF
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     28065861
MFA-TR*        UPDATE CSS_RESTART RF                                    28065961
MFA-TR*           SET RF.RESTART_DATA = :RF-RESTART-DATA                28066061
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                28066161
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                28066261
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                28066361
MFA-TR*        QUERYNO 8820                                             28066461
MFA-TR*    END-EXEC.                                                    28066561

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28066661
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************ABENDING*****************'         
              DISPLAY '**  ERROR ON 8820-UPDATE-RESTART     **'         
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  SQLCODE      = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**      PROCESSING TERMINATED        **'         
              DISPLAY '**************PCSCA414*****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 28068061
       8820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28068361
      ******************************************************************28068461
      * 8830-INSERT-RESTART                                            *28068561
      ******************************************************************28068661
      *                                                                 28068761
       8830-INSERT-RESTART.                                             
      *                                                                 28068961
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28070161
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************ABENDING*****************'         
              DISPLAY '**   ERROR ON 8830-INSERT-RESTART    **'         
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '**************PCSCA414*****************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 28071561
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28071861
      ******************************************************************28071961
      * 8888-COMMIT.                                                   *28072061
      ******************************************************************28072161
      *                                                                 28072261
       8888-COMMIT.                                                     
      *                                                                 28072461
           PERFORM 2800-PRE-COMMIT          THRU 2800-EXIT              
           PERFORM 8810-WRITE-RESTART       THRU 8810-EXIT              
      *                                                                 28090061
           EXEC SQL                                                     28100061
               INCLUDE CPD00047                                         28110061
           END-EXEC.                                                    28120061
      *                                                                 28130061
           DISPLAY '*******************************************'        
           DISPLAY '*COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.**'        
           DISPLAY '*LAST REC PROCESSED  = ' AT-ACCOUNT-NO              
           DISPLAY '*******************************************'.       
      *                                                                 28180061
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28220006
      ***************************************************************** 28300000
      *  9000-TERMINATE                                               * 28310000
      *      CLOSES OUTPUT FILE                                       * 28320000
      ***************************************************************** 28330000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA414-FILE.                                         
      *                                                                 28370006
           CLOSE FCSDB07-FILE.                                          
      *                                                                 28480006
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28560006
      ******************************************************************28570006
      *   9100-DELETE-RESTART-TABLE                                    *28580006
      *                                                                *28590006
      *        IF PROGRAM REACHES SUCCESSFUL COMPLETION THE ROW FOR    *28600006
      *   PROGRAM PCSCA414 IS DELETED FROM CSS_RESTART TABLE.          *28610029
      ******************************************************************28620006
                                                                        
       9100-DELETE-RESTART-TABLE.                                       
                                                                        
           MOVE PROGRAM-NAME TO RF-NAME-PROGRAM.                        
           MOVE 1 TO RF-PARTITION-NO.                                   
           MOVE 1 TO RF-DUP-CNTRL-NO.                                   
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RESTART                                  
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************** ABENDING ***************'       
               DISPLAY '**  PROCESSING ERROR IN PGM PCSCA414  **'       
               DISPLAY '** PARA -  9100-DELETE-RESTART-TABLE  **'       
               DISPLAY '**      ERROR DURING DELETE FOR       **'       
               DISPLAY '**             CSS_RESTART            **'       
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               DISPLAY '************ PCSCA414 ******************'       
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28970006
      ***************************************************************** 28980000
      *  9700-PROCESS-ABEND                                           * 28990000
      *                                                               * 29000000
      *    THIS PARAGRAPH:                                            * 29010000
      *      1) PROVIDES ABEND LOGIC FOR NAME/ADDRESS ROUTINE         * 29020000
      *                                                               * 29030000
      ***************************************************************** 29040000
       COPY CPD0023B.                                                   29050000
      *                                                                 29060006
      ***************************************************************** 29260000
      *  9900-ABEND                                                   * 29270000
      *                                                               * 29280000
      *    THIS PARAGRAPH:                                            * 29290000
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          * 29300000
      *         PROCESSING PARAGRAPH                                  * 29310000
      *                                                               * 29320000
      ***************************************************************** 29330000
           EXEC SQL                                                     29340000
             INCLUDE CPD09900                                           29350000
           END-EXEC.                                                    29360000
