       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA412.                                            
       DATE-WRITTEN.   JULY 2005.                                       
       AUTHOR. DANIE BOOTHA.                                            
      *****************************************************************         
      **               SOUTH CAROLINA ELECTRIC & GAS                 **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                             DB2                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **     DATE       INITIALS              REASON                 **         
A04880**   04-24-2014   DB41297               NEW PROGRAM            **         
A05744**   02-08-2017   DB41297               BYPASS ARCHIVE ACCTS.  **         
      **                                                             **         
      *****************************************************************         
      **              P R O G R A M   S U M M A R Y                  **         
      *****************************************************************         
      * THIS PROGRAM IS TO EXTRACT RECORDS FROM THE FILE THAT IS SENT *         
      * TO US FROM EQUIFAX.  THE DATA SENT TO US FROM EQUIFAX IS PART *         
      * OF THE NCTUE PROCESS WHICH IS TO HELP US COLLECT BAD DEBT FROM*         
      * PEOPLE WHO HAVE SKIPPED. THE DATA IS NEXT LOADED TO DB2 TABLES*         
      *****************************************************************         
                         ---- BASIC SEQUENCE STRUCTURE ----             
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9899     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.                                                 
       OBJECT-COMPUTER.                                                 
                                                                        
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSCA412.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA412.                                                           
       COPY FIOCA412.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA412'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                         PIC X(40) VALUE             
           'WORKING STORAGE FOR PCSCA412 STARTS HERE'.                  
                                                                        
       01  WS-VARIABLES.                                                
           05  PROGRAM-NAME                 PIC X(08) VALUE             
                                                     'PCSCA412'.        
           05  WS-PGRMNAME                  PIC X(08) VALUE             
                                                     'PCSCA412'.        
           05  SCSCB077                     PIC X(8) VALUE 'SCSCB077'.  
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  RS-RETURN-CODE               PIC S9(9) VALUE             
                                                      +000 COMP.        
           05  RS-RETURN-CODE-DISP          PIC S9(9) VALUE             
                                                      +000 COMP.        
           05  WS-DISP-VAR                  PIC -(8)9.                  
           05  WS-MATCH-FLAG                PIC X(02).                  
           05  WS-EXCH-RECV-KEY             PIC 9(09) VALUE ZERO.       
           05  WS-MF-DATE-FORMAT.                                       
               10  WS-MF-DATE-FORMAT-CC      PIC X(02).                 
               10  WS-MF-DATE-FORMAT-YY      PIC X(02).                 
               10  WS-MF-DATE-FORMAT-DASH1   PIC X(01) VALUE '-'.       
               10  WS-MF-DATE-FORMAT-MM      PIC X(02).                 
               10  WS-MF-DATE-FORMAT-DASH2   PIC X(01) VALUE '-'.       
               10  WS-MF-DATE-FORMAT-DD      PIC X(02).                 
           05  WS-OPT-DATA-VALUE-C           PIC X(40).                 
           05  WS-OPT-DATA-VALUE-N REDEFINES WS-OPT-DATA-VALUE-C.       
               10  WS-OPT-DATA-FILLER        PIC X(28).                 
               10  WS-OPT-DATA-INTEGER       PIC 999999999.99.          
           05  WS-RETURN-CODE-2400           PIC 9(2)  VALUE ZEROES.    
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-FIOCA412-STATUS            PIC X(02).                  
              88 FIOCA412-SUCCESSFUL                  VALUE '00'.       
           05 WS-FIOCA412-EOF               PIC X(01) VALUE 'N'.        
              88 END-OF-FIOCA412-FILE                 VALUE 'Y'.        
           05 WS-ACCOUNT-NO-FOUND           PIC X(01) VALUE 'N'.        
              88 ACCOUNT-FOUND                        VALUE 'Y'.        
           05 WS-PROCESS-FLAG               PIC X(01) VALUE 'N'.        
              88 WS-PROCESS                           VALUE 'Y'.        
           05  WS-MATCH-CD-ERROR-FLAG       PIC X(01) VALUE 'N'.        
               88 WS-MATCH-CD-ERROR                   VALUE 'Y'.        
A05744     05  WS-BYPASS-ACCT-SW            PIC X(01) VALUE 'N'.        
A05744         88 BYPASS-ACCOUNT                      VALUE 'Y'.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
           05  WS-ONE                       PIC 9(01) VALUE 1.          
           05  WS-ALL-NINES                 PIC X(05) VALUE             
                                                       '99999'.         
       01  WS-MISC.                                                     
           05  WS-DISP-RC                   PIC -ZZZZZZZZ9.9.           
           05  WS-ERR-MSG                   PIC X(40) VALUE SPACES.     
           05  WS-COMPANY-NO                PIC X(02) VALUE SPACES.     
           05  WS-CUSTOMER-NO               PIC S9(10)V COMP-3          
                                                         VALUE ZEROS.   
                                                                        
       01  WS-COUNTERS.                                                 
           10  WS-FIOCA412-CNT              PIC 9(9) VALUE 0.           
           10  SUB1                         PIC S9(3) VALUE 0.          
           10  SUB2                         PIC S9(3) VALUE 0.          
           10  SUB3                         PIC S9(3) VALUE 0.          
                                                                        
       01  WS-PSNC                          PIC X(02) VALUE '26'.       
       01  WS-SCEG                          PIC X(02) VALUE '01'.       
                                                                        
       01  WS-DELINQ-LIMIT                  PIC S9(4)V9(5) USAGE COMP-3 
                            VALUE ZEROS.                                
                                                                        
       01  WS-TODAY                         PIC X(10).                  
                                                                        
       01  WS-PYMT-HIST                     PIC X(24).                  
       01  WS-PYMT-HIST-R REDEFINES WS-PYMT-HIST.                       
           05 WS-PYMT-CHAR OCCURS 24        PIC X.                      
                                                                        
       01  WS-MONTH                         PIC 9(05).                  
       01  WS-MONTH-R REDEFINES WS-MONTH    PIC 9(03).                  
                                                                        
       01  WQ-TABLE.                                                    
           05 WQ-CNT                    PIC S9(5) COMP-3 VALUE +0.      
           05 WQ-TBL                    OCCURS 0 TO 99999               
                                        DEPENDING ON WQ-CNT             
                                        INDEXED BY WQ-INDX.             
COB305        10 WQ-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.              
COB305        10 WQ-CATEGORY-ID        PIC S9(03) COMP-3 VALUE 0.              
                                                                        
      *****************************************************************         
      * CWS09900  ABEND SWITCH COPYBOOK.                              *         
      *****************************************************************         
       COPY CWS09900.                                                           
      *****************************************************************         
      * CWS00303  USED FOR DB2 AND CICS ERROR PROCESSING.             *         
      *****************************************************************         
       COPY CWS00303.                                                           
      *****************************************************************         
      * CWS00010  WS ABEND WORK AREA.                                 *         
      *****************************************************************         
       COPY CWS00010.                                                           
      *****************************************************************         
      * FIOCA00 USED TO GET COMMONDATE FROM JOB_PARM TABLE            *         
      *****************************************************************         
       COPY FIOCA00.                                                            
      *****************************************************************         
      * FIOJC01 IO AREA FOR PARAMETER INPUT FILE 'A'                  *         
      *****************************************************************         
       COPY FIOJC01.                                                            
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_ACCOUNT - AT                                              *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *************************************************************     05360000
      *    CSS_JOB_PARM - G6                                            05370000
      *************************************************************     05380000
           EXEC SQL                                                     05390000
              INCLUDE TBJBPARM                                          05400000
           END-EXEC.                                                    05410000
                                                                        
      *************************************************************             
      *    CSS_DELINQUENCY - C8                                                 
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * WQ - CSS_WQ_ITEMS                                               07535200
      *************************************************************             
                                                                        
      *    EXEC SQL                                                     07535400
      *      INCLUDE TBWQITS                                            07535500
      *    END-EXEC.                                                    07535600
                                                                        
      *************************************************************             
      *    CSS_HOLIDAY - J8                                                     
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_MODEL_SQL - MS                                                   
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_EXCH_DATA_RECV - EL                                              
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBEXCREC                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_EXCH_DATA_OPT - EO                                               
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBEXCOPT                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_EXCH_DATA_MTCH - ME                                              
      *************************************************************             
           EXEC SQL                                                             
              INCLUDE TBEXCMAT                                                  
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      * WORKING STORAGE COPYBOOK.                                 *             
      *************************************************************             
                                                                        
      *****************************************************************         
      * CWS00038 REQUIRED FOR CPD00037-TO GET DATE                    *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CWS00039  USED TO GET COMMONDATE FROM JOB_PARM TABLE          *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWS00039                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY            *         
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CWS00315                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CWS00077 CALLS SCSCB077FOR INSERTING WQ'S                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                              PIC X(40) VALUE          
           'WORKING STORAGE FOR PCSCA412 ENDS HERE  '.                  
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM.                                                        
           05  LNGTH                     PIC S9(04) COMP.               
           05  WS-PASS-COMPANY           PIC X(04).                     
      *                                                                         
      ******************************************************************        
      **  0000-MAINLINE.                                              **        
      **       CONTROLS MAIN PATH OF PROGRAM                          **        
      ******************************************************************        
       PROCEDURE DIVISION USING PARM.                                   
       0000-MAINLINE.                                                   
           MOVE '0000' TO WS-ACTIVE-PARAGRAPH.                          
           PERFORM 0100-INITIALIZATION    THRU 0100-EXIT.               
           PERFORM 1000-MAIN-PROCESS-PARA THRU 1000-EXIT.               
           PERFORM 9000-TERMINATE         THRU 9000-EXIT.               
           IF WS-RETURN-CODE-2400 > 0                                   
               MOVE WS-RETURN-CODE-2400 TO RETURN-CODE                  
           END-IF.                                                      
           STOP RUN.                                                    
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  0100-INITIALIZATION.                                        **        
      **       INITIALIZATION ROUTINE                                 **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
           MOVE '0100' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
      *  OPEN INPUT FILE                                                        
           OPEN INPUT   FIOCA412-FILE.                                  
                                                                        
           IF FIOCA412-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-FIOCA412-STATUS     TO WS-DISP-RC                 
              MOVE 'ERROR IN OPENING FIOCA412 FILE.' TO WS-ERR-MSG      
              PERFORM 9100-DISPLAY-ERROR THRU 9100-EXIT                 
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT           
              MOVE 'PCSCA412' TO WS-PGRMNAME                            
           END-IF.                                                      
           MOVE WS-INPUT-DATE TO WS-NEW-BUSINESS-DAY                    
                                 WS-TODAY.                              
                                                                        
           MOVE 'EXCH_CONFIDENCE_PTS' TO C8-DELINQ-CD.                  
                                                                        
           IF WS-PASS-COMPANY = 'PSNC'                                  
              MOVE WS-PSNC TO C8-COMPANY-NO                             
           ELSE                                                         
              MOVE WS-SCEG TO C8-COMPANY-NO                             
PRJ951     END-IF.                                                      
                                                                        
           PERFORM 7300-GET-DELINQ-VALUE THRU 7300-EXIT.                
           PERFORM 7350-GET-NEXT-KEY     THRU 7350-EXIT.                
      *                                                                         
      ********NEED TO GET DATE OF THE NEXT BUSINESS DAY. **********             
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
               UNTIL NEXT-BUSINESS-DAY-FOUND.                           
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **   1000-MAIN-PROCESS-PARA.                                    **        
      **        MAIN PROCESS                                          **        
      ******************************************************************        
       1000-MAIN-PROCESS-PARA.                                          
           MOVE '1000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
                                                                        
           IF END-OF-FIOCA412-FILE                                      
              DISPLAY '****** PCSCA412 *********************'           
              DISPLAY '* INPUT FIOCA412 FILE HAS NO RECORDS  *'         
              DISPLAY '*************************************'           
              GO TO 1000-EXIT                                           
           END-IF.                                                      
           IF CA412-HDR-CO-ABBRV NOT = WS-PASS-COMPANY AND 'SCNC'       
              DISPLAY '****** PCSCA412 *********************'           
              DISPLAY '* INPUT FIOCA412 FILE COMPANY NAME    *'         
              DISPLAY '* DOES NOT MATCH PARM COMPANY NAME.   *'         
              DISPLAY '* INPUT FILE CO NAME: ' CA412-HDR-CO-ABBRV       
              DISPLAY '* PARM COMPANY NAME: ' WS-PASS-COMPANY           
              DISPLAY '*************************************'           
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
           PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT.                 
           PERFORM UNTIL END-OF-FIOCA412-FILE                           
             PERFORM 1050-CHECK-B4-PROCESS THRU 1050-EXIT               
             PERFORM 7000-READ-INPUT-FILE THRU 7000-EXIT                
           END-PERFORM.                                                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **   1050-CHECK-B4-PROCESS.                                     **        
      **        CHECK CONFIDENCE LEVEL                                **        
      ******************************************************************        
       1050-CHECK-B4-PROCESS.                                           
           IF CA412-TOT-CONFIDENCE-PTS NUMERIC AND                      
              CA412-TOT-CONFIDENCE-PTS >= WS-DELINQ-LIMIT               
               PERFORM 2000-LOAD-TABLES THRU 2000-EXIT                  
A05744         IF BYPASS-ACCOUNT                                        
A05744            GO TO 1050-EXIT                                       
A05744         END-IF                                                   
               IF WS-PASS-COMPANY NOT = 'SCGA'                          
                  PERFORM 2500-GENERATE-WQ THRU 2500-EXIT               
               END-IF                                                   
               ADD 1 TO WS-EXCH-RECV-KEY                                
           ELSE                                                         
           IF CA412-TOT-CONFIDENCE-PTSR NUMERIC AND                     
              CA412-TOT-CONFIDENCE-PTSR >= WS-DELINQ-LIMIT              
               PERFORM 2000-LOAD-TABLES THRU 2000-EXIT                  
A05744         IF BYPASS-ACCOUNT                                        
A05744            GO TO 1050-EXIT                                       
A05744         END-IF                                                   
               IF WS-PASS-COMPANY NOT = 'SCGA'                          
                  PERFORM 2500-GENERATE-WQ THRU 2500-EXIT               
               END-IF                                                   
               ADD 1 TO WS-EXCH-RECV-KEY                                
           END-IF
           END-IF.                                                      
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THE DATA RECEIVED FROM THE EXCHANGE IS LOADED INTO THE      **        
      **  COORESPONDING DB2 TABLES.                                   **        
      ******************************************************************        
       2000-LOAD-TABLES.                                                
           PERFORM 2100-LOAD-DATA-RECV    THRU 2100-EXIT.               
           IF BYPASS-ACCOUNT                                            
              GO TO 2000-EXIT                                           
           END-IF.                                                      
           PERFORM 2200-LOAD-CSA-DATA-OPT THRU 2200-EXIT.               
           PERFORM 2300-LOAD-UCA-DATA-OPT THRU 2300-EXIT.               
           PERFORM 2400-LOAD-DATA-MTCH    THRU 2400-EXIT.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2100-LOAD-DATA-RECV  LOADS DATA RECV TABLE                  **        
      ******************************************************************        
       2100-LOAD-DATA-RECV.                                             
      *************** LOAD CSS_EXCH_DATA_RECV TABLE *****************           
           MOVE WS-EXCH-RECV-KEY         TO EL-EXCH-RECV-KEY.           
           MOVE CA412-ACCT-NUMBER-C TO AT-ACCOUNT-NO.                   
           IF CA412-ACCT-NUMBER-U > ZEROS                               
              MOVE CA412-ACCT-NUMBER-U TO AT-ACCOUNT-NO                 
           END-IF.                                                      
                                                                        
A05744     MOVE 'N' TO  WS-BYPASS-ACCT-SW.                              
A05744     PERFORM 7100-SELECT-ACCOUNT THRU 7100-EXIT.                  
A05744     IF BYPASS-ACCOUNT                                            
A05744        GO TO 2100-EXIT                                           
A05744     END-IF.                                                      
                                                                        
           IF CA412-ACCT-NUMBER-U > ZEROS                               
              MOVE CA412-ACCT-NUMBER-U      TO EL-ACCOUNT-NO            
              MOVE CA412-ACCT-NUMBER-C      TO EL-EXCH-ACCOUNT-NO       
           ELSE                                                         
              MOVE CA412-ACCT-NUMBER-C      TO EL-ACCOUNT-NO            
              MOVE '000000000000000000000000000000' TO                  
                   EL-EXCH-ACCOUNT-NO                                   
           END-IF.                                                      
           IF CA412-TOT-CONFIDENCE-PTS NUMERIC                          
              MOVE CA412-TOT-CONFIDENCE-PTS TO EL-EXCH-CONFID-POINTS    
           ELSE                                                         
              MOVE CA412-TOT-CONFIDENCE-PTSR TO EL-EXCH-CONFID-POINTS   
           END-IF                                                       
           MOVE CA412-PRI-LAST-NAME-U    TO EL-EXCH-CUST-LAST-NM.       
           MOVE CA412-PRI-FIRST-NAME-U   TO EL-EXCH-CUST-FIRST-NM.      
           MOVE CA412-PRI-MID-NAME-U     TO EL-EXCH-CUST-MID-NM.        
           MOVE CA412-MATCH-TYPE         TO EL-EXCH-MATCH-TYPE-CD.      
           MOVE CA412-SERV-ADDR1-U       TO EL-EXCH-PREM-ADDR-STR.      
           MOVE CA412-SERV-ADDR-CITY-U   TO EL-EXCH-PREM-ADDR-CTY.      
           MOVE CA412-SERV-ADDR-ST-U     TO EL-EXCH-PREM-ADDR-ST.       
           MOVE CA412-SERV-ADDR-ZIP-U    TO EL-EXCH-PREM-ADDR-ZIP.      
           MOVE SPACES                   TO EL-EXCH-PREM-ADDR-OVF.      
           IF CA412-SERV-TYPES-U = '**********'                         
              MOVE 'Z'                   TO EL-EXCH-SERV-TYPE-CD        
           ELSE                                                         
              MOVE CA412-SERV-TYPES-U    TO EL-EXCH-SERV-TYPE-CD        
           END-IF.                                                      
           MOVE CA412-REPORT-DATE-CC     TO WS-MF-DATE-FORMAT-CC.       
           MOVE CA412-REPORT-DATE-YY     TO WS-MF-DATE-FORMAT-YY.       
           MOVE CA412-REPORT-DATE-MM     TO WS-MF-DATE-FORMAT-MM.       
           MOVE CA412-REPORT-DATE-DD     TO WS-MF-DATE-FORMAT-DD.       
           MOVE WS-MF-DATE-FORMAT        TO EL-EXCH-REPORT-DT.          
   ************** THE FOLLOWING CODE HANDLES AN INVALID DATE *******            
           IF CA412-DATE-CONNT-CC-U = '00' OR '  '                      
               MOVE '99' TO WS-MF-DATE-FORMAT-CC                        
               MOVE '99' TO WS-MF-DATE-FORMAT-YY                        
           ELSE                                                         
               MOVE CA412-DATE-CONNT-CC-U TO WS-MF-DATE-FORMAT-CC       
               MOVE CA412-DATE-CONNT-YY-U TO WS-MF-DATE-FORMAT-YY       
           END-IF.                                                      
   ************** THE FOLLOWING CODE HANDLES AN INVALID DATE *******            
           IF CA412-DATE-CONNT-MM-U = '00' OR '  '                      
               MOVE '01' TO WS-MF-DATE-FORMAT-MM                        
           ELSE                                                         
               MOVE CA412-DATE-CONNT-MM-U TO WS-MF-DATE-FORMAT-MM       
           END-IF.                                                      
   ************** THE FOLLOWING CODE HANDLES AN INVALID DATE *******            
           IF CA412-DATE-CONNT-DD-U = '00' OR '  '                      
               MOVE '01' TO WS-MF-DATE-FORMAT-DD                        
           ELSE                                                         
               MOVE CA412-DATE-CONNT-DD-U TO WS-MF-DATE-FORMAT-DD       
           END-IF.                                                      
           MOVE WS-MF-DATE-FORMAT        TO EL-EXCH-START-DT.           
           PERFORM 8000-INSERT-RECV-TBL  THRU 8000-EXIT.                
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2200-LOAD-CSA-DATA-OPT   LOADS ONLY CSA IN DATA OPT TABLE   **        
      ******************************************************************        
       2200-LOAD-CSA-DATA-OPT.                                          
      ********** LOAD CSA CSS_EXCH_DATA_OPT TABLE *****************             
           IF CA412-PRI-SUFFIX-C NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SUFFIX-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-SUFFIX-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SSN-C   NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SSN-C'      TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-SSN-C        TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SSN-SOURCE-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SSN-SOURCC'   TO EO-OPT-DATA-DESC-CD     
               MOVE CA412-PRI-SSN-SOURCE-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SSN-C   NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SSN-C'      TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SSN-C        TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SSN-SOURCE-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SSN-SOURCC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SSN-SOURCE-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
                                                                        
           IF CA412-PRI-PH-TYPE-C NOT = SPACES AND                      
              CA412-PRI-PH-NO-C IS NUMERIC                              
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-PH-TYPE-C'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-PH-TYPE-C    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-PH-NO-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-PH-NO-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-DL-C    NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-DL-C'       TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-DL-C         TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-DL-ST-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-DL-ST-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-OTHER-ID-TYPE-C NOT = SPACES                    
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-OTHER-ID-T' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-OTHER-ID-TYPE-C TO EO-OPT-DATA-VALUE      
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-OTHER-ID-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-OTHER-ID-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-OTHER-ID-TYPE-C NOT = SPACES                    
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-T' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-TYPE-C TO EO-OPT-DATA-VALUE      
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-OTHER-ID-TYPE-C NOT = SPACES                    
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-T' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-TYPE-C TO EO-OPT-DATA-VALUE      
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-EMPL-INFO-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-EMPL-INFO'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-EMPL-INFO-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-LAST-NAME-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-LAST-NAME'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-LAST-NAME-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-FIRST-NAME-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-FIRST-NAME' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-FIRST-NAME-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-MID-NAME-C  NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-MID-NAME-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-MID-NAME-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SUFFIX-C NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SUFFIX-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SUFFIX-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-PH-NO-C NOT = SPACES AND                        
              CA412-SEC-PH-NO-C IS NUMERIC                              
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-PH-TYPE-C'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-PH-TYPE-C    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-PH-NO-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-PH-NO-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-DL-C    NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-DL-C'       TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-DL-C         TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-DL-ST-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-DL-ST-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-OTHER-ID-C NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-OTHER-ID-T' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-OTHER-ID-TYPE-C TO EO-OPT-DATA-VALUE      
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-EMPL-INFO-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-EMPL-INFO'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-EMPL-INFO-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR1-C NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR1-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR1-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-CITY-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-CITY' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-CITY-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-ST-C NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-ST-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-ST-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-ZIP-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-ZIPC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-ZIP-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-TEXT-CUST-NOTES-C NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-TEXT-CUST-NOTC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-TEXT-CUST-NOTES-C TO EO-OPT-DATA-VALUE        
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR1-C NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR1-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR1-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-CITY-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-CITY' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-CITY-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-ST-C NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-ST-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-ST-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-ZIP-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-ZIPC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-ZIP-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR1-C NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR1-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR1-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-CITY-C NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-CITY' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-CITY-C TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-ST-C NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-ST-C' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-ST-C   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-ZIP-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-ZIPC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-ZIP-C  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRIM-CONS-TYP-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRIM-CONS-TYPC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRIM-CONS-TYP-C   TO EO-OPT-DATA-VALUE        
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-CONS-TYPE-C NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-CONS-TYPEC' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-CONS-TYPE-C   TO EO-OPT-DATA-VALUE        
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-CHG-OFF-AMT-C NOT = SPACES AND '0.0'                
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CHG-OFF-AMT-C'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CHG-OFF-AMT-C    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-DATE-ADDED-C   NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DATE-ADDED-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DATE-ADDED-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
      *    IF CA412-CURR-BAL-C    NOT = ZEROES AND                              
           IF CA412-CURR-BAL-C    IS NUMERIC                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE ZEROES TO WS-OPT-DATA-VALUE-C                       
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CURR-BAL-C'     TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CURR-BAL-C       TO WS-OPT-DATA-INTEGER       
               MOVE WS-OPT-DATA-VALUE-C    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           ELSE                                                         
           IF CA412-CURR-BAL-C-R  IS NUMERIC                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE ZEROES TO WS-OPT-DATA-VALUE-C                       
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CURR-BAL-C'     TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CURR-BAL-C-R     TO WS-OPT-DATA-INTEGER       
               MOVE WS-OPT-DATA-VALUE-C    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF
           END-IF.                                                      
      *                                                                         
           IF CA412-DATE-LASTR-C   NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DATE-LASTR-C'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DATE-LASTR-C     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-ACCT-STAT-C    NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-ACCT-STAT-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-ACCT-STAT-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-ACCT-CODE-C    NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-ACCT-CODE-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-ACCT-CODE-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-DATE-DISC-C    NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DATE-DISC-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DATE-DISC-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2300-LOAD-UCA-DATA-OPT   LOADS ONLY UCA IN DATA OPT TABLE   **        
      ******************************************************************        
       2300-LOAD-UCA-DATA-OPT.                                          
      ********** LOAD UCA CSS_EXCH_DATA_OPT TABLE *****************             
           IF CA412-SERV-TYPES-U NOT = SPACES AND '**********'          
               IF CA412-IDENT = '4120' OR '4121' OR '4122'              
                 IF CA412-ACCT-NUMBER-U = '*************' AND           
                    CA412-ACCT-STAT-U NOT = 'A' AND 'B' AND 'C' AND 'F' 
                                        AND 'G' AND 'H' AND 'I' AND 'N' 
                                        AND 'U' AND 'T'                 
                    MOVE '**********' TO CA412-SERV-TYPES-U             
                 END-IF                                                 
               END-IF                                                   
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SERV-TYPES-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SERV-TYPES-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-ACCT-STAT-U NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-ACCT-STAT-U'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-ACCT-STAT-U      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-CURR-BAL-U    NOT = SPACES AND '0.0' AND '0'        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CURR-BAL-U'     TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CURR-BAL-U       TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-DATE-DISCN-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DATE-DISCN-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DATE-DISCN-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-CHG-AMT-U NOT = SPACES AND '0.0' AND '0'            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CHG-AMT-U'      TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CHG-AMT-U        TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-TEXT-CUST-NOTES-U NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-TEXT-CUST-NOTU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-TEXT-CUST-NOTES-U TO EO-OPT-DATA-VALUE        
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PYMT-HIST-U       NOT = SPACES                      
               IF CA412-ACCT-STAT-U = '0' OR '1' OR '2' OR '3' OR '4'   
                                   OR '5'                               
                  COMPUTE WS-MONTH = CA412-REPORT-DATE-R -              
                            CA412-MATCH-DATE-R                          
                  IF WS-MONTH-R > 0                                     
                    MOVE CA412-PYMT-HIST-U TO WS-PYMT-HIST              
                    PERFORM VARYING SUB1 FROM 1 BY 1                    
                       UNTIL SUB1 > WS-MONTH-R                          
                     PERFORM VARYING SUB3 FROM 1 BY 1                   
                       UNTIL SUB3 > 24                                  
                        COMPUTE SUB2 = 24 - SUB3                        
                        IF SUB2 > 0                                     
                          MOVE WS-PYMT-CHAR(SUB2) TO                    
                               WS-PYMT-CHAR(SUB2 + 1)                   
                        END-IF                                          
                     END-PERFORM                                        
                    END-PERFORM                                         
                    PERFORM VARYING SUB1 FROM 1 BY 1                    
                      UNTIL SUB1 > WS-MONTH-R                           
                       MOVE 'D' TO WS-PYMT-CHAR(SUB1)                   
                    END-PERFORM                                         
                    MOVE WS-PYMT-HIST TO CA412-PYMT-HIST-U              
                  END-IF                                                
               END-IF                                                   
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PYMT-HIST-U'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PYMT-HIST-U      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-DATE-DISPT-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DATE-DISPT-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DATE-DISPT-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-DISPT-FLAG-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-DISPT-FLAG-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-CONS-STMT-U       NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-CONS-STMT-U'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-CONS-STMT-U      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRIM-CONS-TYP-U   NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRIM-CONS-TYPU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRIM-CONS-TYP-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-LAST-NAME-U   NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-LAST-NAMEU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-LAST-NAME-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-FIRST-NAME-U  NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-FIRST-NAMU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-FIRST-NAME-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-MID-NAME-U    NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-MID-NAME-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-MID-NAME-U TO EO-OPT-DATA-VALUE           
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SUFFIX-U      NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SUFFIX-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-SUFFIX-U   TO EO-OPT-DATA-VALUE           
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SUFFIX-U      NOT = SPACES                      
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SUFFIX-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-SUFFIX-U   TO EO-OPT-DATA-VALUE           
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SSN-U   NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SSN-U'      TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-SSN-U        TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-SSN-SOURCE-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-SSN-SOURCU'  TO EO-OPT-DATA-DESC-CD      
               MOVE CA412-PRI-SSN-SOURCE-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-PH-TYPE-U NOT = SPACES AND                      
              CA412-PRI-PH-NO-U IS NUMERIC                              
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-PH-TYPE-U'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-PH-TYPE-U    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-PH-NO-U'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-PH-NO-U      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-DL-U    NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-DL-U'       TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-DL-U         TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-DL-ST-U'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-DL-ST-U      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-OTHER-ID-TYPE-U NOT = SPACES                    
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-OTHER-ID-Y' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-OTHER-ID-TYPE-U TO EO-OPT-DATA-VALUE      
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-OTHER-ID-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-OTHER-ID-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PRI-EMPL-INFO-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PRI-EMPL-INFOU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PRI-EMPL-INFO-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-CONS-TYPE-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-CONS-TYPEU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-CONS-TYPE-U   TO EO-OPT-DATA-VALUE        
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-LAST-NAME-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-LAST-NAMEU'  TO EO-OPT-DATA-DESC-CD      
               MOVE CA412-SEC-LAST-NAME-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-FIRST-NAME-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-FIRST-NAMU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-FIRST-NAME-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-MID-NAME-U  NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-MID-NAME-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-MID-NAME-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SUFFIX-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SUFFIX-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SUFFIX-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SSN-U   NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SSN-U'      TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SSN-U        TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-SSN-SOURCE-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-SSN-SOURCU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-SSN-SOURCE-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-PH-NO-U NOT = SPACES AND                        
              CA412-SEC-PH-NO-U IS NUMERIC                              
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-PH-TYPE-U'  TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-PH-TYPE-U    TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-PH-NO-C'    TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-PH-NO-C      TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SEC-DL-U    NOT = SPACES                            
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-DL-U'       TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-DL-U         TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SEC-EMPL-INFOU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SEC-EMPL-INFO-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SERV-ADDR1-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SERV-ADDR1-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SERV-ADDR1-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SERV-ADDR-CITY-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SERV-ADDR-CITU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SERV-ADDR-CITY-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SERV-ADDR-ST-U NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SERV-ADDR-ST-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SERV-ADDR-ST-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-SERV-ADDR-ZIP-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-SERV-ADDR-ZIPU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-SERV-ADDR-ZIP-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR1-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR1-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR1-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-CITY-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-CITU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-CITY-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-ST-U NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-ST-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-ST-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-BILL-ADDR-ZIP-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-BILL-ADDR-ZIPU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-BILL-ADDR-ZIP-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR1-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR1-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR1-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-CITY-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-CITU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-CITY-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-ST-U NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-ST-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-ST-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-PREV-ADDR-ZIP-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-PREV-ADDR-ZIPU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-PREV-ADDR-ZIP-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR1-U NOT = SPACES                           
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR1-U'   TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR1-U     TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-CITY-U NOT = SPACES                       
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-CITU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-CITY-U TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-ST-U NOT = SPACES                         
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-ST-U' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-ST-U   TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
           IF CA412-FINL-ADDR-ZIP-U NOT = SPACES                        
               MOVE SPACES                 TO EO-OPT-DATA-DESC-CD       
                                              EO-OPT-DATA-VALUE         
               MOVE WS-EXCH-RECV-KEY       TO EO-EXCH-RECV-KEY          
               MOVE 'CA412-FINL-ADDR-ZIPU' TO EO-OPT-DATA-DESC-CD       
               MOVE CA412-FINL-ADDR-ZIP-U  TO EO-OPT-DATA-VALUE         
               PERFORM 8100-INSERT-OPT-TBL THRU 8100-EXIT               
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2400-LOAD-DATA-MTCH      LOADS ONLY UCA IN DATA OPT TABLE   **        
      ******************************************************************        
       2400-LOAD-DATA-MTCH.                                             
      *************** LOAD CSS_EXCH_DATA_MTCH TABLE ************                
           MOVE 'N' TO WS-MATCH-CD-ERROR-FLAG.                          
           MOVE CA412-MF-NAME  TO WS-MATCH-FLAG.                        
           PERFORM 2410-CHECK-MATCH-FLAG THRU 2410-EXIT.                
      *                                                                         
           MOVE CA412-MF-SSN   TO WS-MATCH-FLAG.                        
           PERFORM 2410-CHECK-MATCH-FLAG THRU 2410-EXIT.                
      *                                                                         
           MOVE CA412-MF-DLN   TO WS-MATCH-FLAG.                        
           PERFORM 2410-CHECK-MATCH-FLAG THRU 2410-EXIT.                
      *                                                                         
           MOVE CA412-MF-PHONE TO WS-MATCH-FLAG.                        
           PERFORM 2410-CHECK-MATCH-FLAG THRU 2410-EXIT.                
      *                                                                         
           MOVE CA412-MF-OTHERID TO WS-MATCH-FLAG.                      
           PERFORM 2410-CHECK-MATCH-FLAG THRU 2410-EXIT.                
      *                                                                         
           IF WS-MATCH-CD-ERROR                                         
                  DISPLAY '*****************PCSCA412******************' 
                  DISPLAY '* INVALID MATCH FLAG/CODE FOUND IN INPUT  *' 
                  DISPLAY '* FILE FROM EQUIFAX.                      *' 
                  DISPLAY '* THE MATCH IS EITHER NAME, SSN, DLN, ETC.*' 
                  DISPLAY '*    MF NAME : ' CA412-MF-NAME               
                  DISPLAY '*    MF SSN : ' CA412-MF-SSN                 
                  DISPLAY '*    MF PHONE : ' CA412-MF-PHONE             
                  DISPLAY '*    MF DLN : ' CA412-MF-DLN                 
                  DISPLAY '*    MF OTHERID : ' CA412-MF-OTHERID         
                  DISPLAY '*    ACCOUNT N0 : ' EL-ACCOUNT-NO            
                  DISPLAY '* PROGRAM COND CODE BEING SET TO 3        *' 
                  DISPLAY '*****************PCSCA412******************' 
                  MOVE 03  TO  RETURN-CODE                              
                               WS-RETURN-CODE-2400                      
           END-IF.                                                      
      *                                                                         
           EVALUATE CA412-MF-ADDRESS                                    
              WHEN 'SS'                                                 
                  CONTINUE                                              
              WHEN 'BB'                                                 
                  CONTINUE                                              
              WHEN 'BS'                                                 
                  CONTINUE                                              
              WHEN 'SB'                                                 
                  CONTINUE                                              
              WHEN '22'                                                 
                  CONTINUE                                              
              WHEN '2S'                                                 
                  CONTINUE                                              
              WHEN 'S2'                                                 
                  CONTINUE                                              
              WHEN 'SF'                                                 
                  CONTINUE                                              
              WHEN 'B2'                                                 
                  CONTINUE                                              
              WHEN 'BF'                                                 
                  CONTINUE                                              
              WHEN '2B'                                                 
                  CONTINUE                                              
              WHEN '2F'                                                 
                  CONTINUE                                              
              WHEN '  '                                                 
                  CONTINUE                                              
               WHEN OTHER                                               
                  DISPLAY '*****************PCSCA412******************' 
                  DISPLAY '* INVALID MATCH FLAG/CODE FOUND IN INPUT  *' 
                  DISPLAY '* FILE FROM EQUIFAX.                      *' 
                  DISPLAY '* THE MATCH IS ADDRESS.                   *' 
                  DISPLAY '*    MF ADDRESS : ' CA412-MF-ADDRESS         
                  DISPLAY '*    ACCOUNT N0 : ' EL-ACCOUNT-NO            
                  DISPLAY '* PROGRAM COND CODE BEING SET TO 3        *' 
                  DISPLAY '*****************PCSCA412******************' 
                  MOVE 03  TO  RETURN-CODE                              
                               WS-RETURN-CODE-2400                      
           END-EVALUATE.                                                
      *                                                                         
           IF CA412-MF-NAME   NOT = SPACES                              
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'NA' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-NAME TO ME-EXCH-MATCH-DESC-CD              
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CA412-MF-SSN    NOT = SPACES                              
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'SS' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-SSN TO ME-EXCH-MATCH-DESC-CD               
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CA412-MF-PHONE  NOT = SPACES                              
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'PH' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-PHONE TO ME-EXCH-MATCH-DESC-CD             
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CA412-MF-DLN    NOT = SPACES                              
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'DL' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-DLN TO ME-EXCH-MATCH-DESC-CD               
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CA412-MF-OTHERID NOT = SPACES                             
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'OT' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-OTHERID TO ME-EXCH-MATCH-DESC-CD           
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
           IF CA412-MF-ADDRESS NOT = SPACES                             
               MOVE WS-EXCH-RECV-KEY TO ME-EXCH-RECV-KEY                
               MOVE 'AD' TO ME-EXCH-MATCH-CD                            
               MOVE CA412-MF-ADDRESS TO ME-EXCH-MATCH-DESC-CD           
               PERFORM 8200-INSERT-MTCH-TBL THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CHECKS THE NAME, SSN, DLN, PHONE, AND OTHER ID MATCH FLAG   **        
      **  TYPES TO SEE IF THEY ARE VALID.                             **        
      ******************************************************************        
       2410-CHECK-MATCH-FLAG.                                           
           IF WS-MATCH-FLAG ='PP' OR 'PS' OR 'SP' OR 'PO' OR 'OP' OR    
                   'SS' OR 'SO' OR 'OO' OR '  '                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'Y' TO WS-MATCH-CD-ERROR-FLAG                       
           END-IF.                                                      
      *                                                                         
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  IF THE CUSTOMER HAS MET ALL THE CRITERIA, GENERATE A WQ     **        
      **  WITH THE NEW SE CREDIT EXCHANGE INFORMATION.                **        
      ******************************************************************        
       2500-GENERATE-WQ.                                                
      *                                                                         
           INITIALIZE LS-CWS077-CALLING-FIELDS.                         
           MOVE AT-ACCOUNT-NO           TO WS-77-ACCOUNT-NO.            
           MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
           MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
           MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE,          
           MOVE 5                       TO WS-77-ROUTE-CATEGORY.        
           MOVE WS-NO                   TO WS-77-PRIORITY.              
           MOVE WS-NEW-BUSINESS-DAY     TO WS-77-DATE-REQUIRED          
      *                                                                         
  ****** MATCH TYPE 1 = INTERNAL AND 3 = EXTERNAL **********                    
  ****** MATCH TYPE I = INITIAL  AND R = RETRO    **********                    
      *    IF CA412-MATCH-TYPE = '1'                                            
      *    IF CA412-MATCH-TYPE = 'I'                                            
           IF CA412-ACCT-NUMBER-U > ZEROS                               
              IF AT-CODE-ACCT-STAT = 'B'                                
                 MOVE 224 TO WS-77-CATEGORY-ID                          
              ELSE                                                      
                 MOVE 231 TO WS-77-CATEGORY-ID                          
              END-IF                                                    
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = 'B'                                
                 MOVE 228 TO WS-77-CATEGORY-ID                          
              ELSE                                                      
                 MOVE 230 TO WS-77-CATEGORY-ID                          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           SET WQ-INDX TO 1.                                            
           SEARCH WQ-TBL VARYING WQ-INDX                                
              AT END                                                    
                 ADD 1 TO WQ-CNT                                        
                 MOVE AT-ACCOUNT-NO     TO WQ-ACCOUNT-NO(WQ-CNT)        
                 MOVE WS-77-CATEGORY-ID TO WQ-CATEGORY-ID(WQ-CNT)       
              WHEN                                                      
                 WQ-ACCOUNT-NO(WQ-INDX) = AT-ACCOUNT-NO                 
                 AND WQ-CATEGORY-ID(WQ-INDX) = WS-77-CATEGORY-ID        
                 GO TO 2500-EXIT                                        
           END-SEARCH.                                                  
                                                                        
           MOVE SPACES TO WS-77-COMMENTS-TEXT.                          
           MOVE +0 TO WS-77-COMMENTS-LEN.                               
                                                                        
      *    PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.                       
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                                                        
           IF RS-RETURN-CODE NOT = 0                                    
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CALL'                     TO ABEND-FUNCTION         
              MOVE 'SCSCB077'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2        
              MOVE 'SERV_ORDER_NO '           TO TABLE-ELEMENT-3        
              MOVE 'SQL RETURN CODE'          TO TABLE-ELEMENT-4        
              MOVE WS-77-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
              MOVE WS-77-PREMISE-NO           TO HOSTVAR-ELEMENT-2      
              MOVE WS-77-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-3      
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-4      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * READ INPUT FILE                                                *        
      ******************************************************************        
       7000-READ-INPUT-FILE.                                            
           READ FIOCA412-FILE                                           
                AT END                                                  
                   MOVE WS-YES TO WS-FIOCA412-EOF                       
           END-READ.                                                    
      *                                                                         
           IF NOT END-OF-FIOCA412-FILE                                  
                  IF CA412-TLR-REC-TYPE = 'DEND'                        
                     PERFORM  8500-CHECK-CNTRL-TOT THRU 8500-EXIT       
                     MOVE WS-YES TO WS-FIOCA412-EOF                     
                  ELSE                                                  
                     IF CA412-TLR-REC-TYPE NOT = 'DHDR'                 
                         ADD WS-ONE TO WS-FIOCA412-CNT                  
                     END-IF                                             
                  END-IF                                                
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT ACCOUNT DETAILS                                         *        
      ******************************************************************        
       7100-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                    ,CODE_ACCT_STAT                                     
                    ,LOCAL_OFFICE                                       
                    ,PREMISE_NO                                         
                    ,COMPANY_NO                                         
                INTO :AT-CUSTOMER-NO                                    
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
               FROM CSS_ACCOUNT AT                                      
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
A05744     ELSE                                                         
A05744     IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
A05744         MOVE 'Y' TO  WS-BYPASS-ACCT-SW                           
               DISPLAY '* ACCOUNT BYPASSED, ARCHIVED  ' AT-ACCOUNT-NO   
             ELSE                                                       
               DISPLAY '********** PCSCA412 ABORT **************'       
               DISPLAY '* 7100-SELECT-ACCOUNT                  *'       
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA412 ABORT **************'       
               PERFORM 9900-ABEND         THRU 9900-EXIT                
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7300-GET-DELINQ-VALUE.                                **              
      **   GET SE CREDIT EXCHANGE DOLLAR LIMIT FROM DELINQ TABLE**              
      ************************************************************              
       7300-GET-DELINQ-VALUE.                                           
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
               INTO  :WS-DELINQ-LIMIT                                   
               FROM   CSS_DELINQUENCY                                   
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
               AND    COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT ************'         
               DISPLAY '** PCSCA412 PROCESSING ERROR        **'         
               DISPLAY '** ERROR ON SELECT                  **'         
               DISPLAY '** PARA 7300-GET-DELINQ-VALUE       **'         
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** DELINQ CODE: ' C8-DELINQ-CD                  
               DISPLAY '** COMPANY NO: ' C8-COMPANY-NO                  
               DISPLAY '** PROCESSING TERMINATED            **'         
               DISPLAY '********** PCSCA412 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      **  7350-GET-NEXT-KEY.                                    **              
      **   LOOK AT CSS_EXCH_DATA_RECV TABLE AND GET THE HIGHEST **              
      **   EXCH_RECV_KEY.  THEN ADD 1 FOR NEW START KEY.        **              
      ************************************************************              
       7350-GET-NEXT-KEY.                                               
           EXEC SQL                                                     
               SELECT MAX(EXCH_RECV_KEY)                                
               INTO  :EL-EXCH-RECV-KEY                                  
               FROM   CSS_EXCH_DATA_RECV                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
    ***** A -305 WILL ONLY BE OBTAINED WHEN THIS PROGRAM RUNS *****             
    ***** THE FIRST TIME BECAUSE NO EXCH_RECV_KEY EXISTS.     *****             
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR SQLCODE EQUAL -305       
               IF SQLCODE EQUAL -305                                    
                   MOVE 0 TO EL-EXCH-RECV-KEY                           
               END-IF                                                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT ************'         
               DISPLAY '** PCSCA412 PROCESSING ERROR        **'         
               DISPLAY '** ERROR ON SELECT                  **'         
               DISPLAY '** PARA 7350-GET-NEXT-KEY           **'         
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED            **'         
               DISPLAY '********** PCSCA412 ABORT ************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE EL-EXCH-RECV-KEY TO WS-EXCH-RECV-KEY.                   
           ADD 1 TO WS-EXCH-RECV-KEY.                                   
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INSERT-RECV-TBL                                           *        
      *      INSERT A NEW ROW INTO THE TABLE CSS_EXCH_DATA_RECV        *        
      ******************************************************************        
       8000-INSERT-RECV-TBL.                                            
           EXEC SQL                                                     
              INSERT INTO CSS_EXCH_DATA_RECV                            
                    (ACCOUNT_NO                                         
                    ,EXCH_ACCOUNT_NO                                    
                    ,EXCH_CONFID_POINTS                                 
                    ,EXCH_CUST_FIRST_NM                                 
                    ,EXCH_CUST_LAST_NM                                  
                    ,EXCH_CUST_MID_NM                                   
                    ,EXCH_MATCH_TYPE_CD                                 
                    ,EXCH_PREM_ADDR_CTY                                 
                    ,EXCH_PREM_ADDR_OVF                                 
                    ,EXCH_PREM_ADDR_ST                                  
                    ,EXCH_PREM_ADDR_STR                                 
                    ,EXCH_PREM_ADDR_ZIP                                 
                    ,EXCH_RECV_KEY                                      
                    ,EXCH_REPORT_DT                                     
                    ,EXCH_SERV_TYPE_CD                                  
                    ,EXCH_START_DT                                      
                    )                                                   
             VALUES (:EL-ACCOUNT-NO                                     
                    ,:EL-EXCH-ACCOUNT-NO                                
                    ,:EL-EXCH-CONFID-POINTS                             
                    ,:EL-EXCH-CUST-FIRST-NM                             
                    ,:EL-EXCH-CUST-LAST-NM                              
                    ,:EL-EXCH-CUST-MID-NM                               
                    ,:EL-EXCH-MATCH-TYPE-CD                             
                    ,:EL-EXCH-PREM-ADDR-CTY                             
                    ,:EL-EXCH-PREM-ADDR-OVF                             
                    ,:EL-EXCH-PREM-ADDR-ST                              
                    ,:EL-EXCH-PREM-ADDR-STR                             
                    ,:EL-EXCH-PREM-ADDR-ZIP                             
                    ,:EL-EXCH-RECV-KEY                                  
                    ,IIF(TRY_CONVERT(DATE, :EL-EXCH-REPORT-DT
              ) IS NULL OR (PATINDEX('%.%', :EL-EXCH-REPORT-DT
              ) <> 0) OR (LEN(:EL-EXCH-REPORT-DT
              ) <> 10), CIS.CHAR2DATE(:EL-EXCH-REPORT-DT
              ), CONVERT(DATE, :EL-EXCH-REPORT-DT) )                           
                    ,:EL-EXCH-SERV-TYPE-CD                              
                    ,IIF(TRY_CONVERT(DATE, :EL-EXCH-START-DT
              ) IS NULL OR (PATINDEX('%.%', :EL-EXCH-START-DT
              ) <> 0) OR (LEN(:EL-EXCH-START-DT) <> 10), CIS.CHAR2DATE(
                                                      :EL-EXCH-START-DT
              ), CONVERT(DATE, :EL-EXCH-START-DT) )                            
                    )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     34570600
MFA-TR*       INSERT INTO CSS_EXCH_DATA_RECV                            34571000
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,EXCH_ACCOUNT_NO                                            
MFA-TR*             ,EXCH_CONFID_POINTS                                         
MFA-TR*             ,EXCH_CUST_FIRST_NM                                         
MFA-TR*             ,EXCH_CUST_LAST_NM                                          
MFA-TR*             ,EXCH_CUST_MID_NM                                           
MFA-TR*             ,EXCH_MATCH_TYPE_CD                                         
MFA-TR*             ,EXCH_PREM_ADDR_CTY                                         
MFA-TR*             ,EXCH_PREM_ADDR_OVF                                         
MFA-TR*             ,EXCH_PREM_ADDR_ST                                          
MFA-TR*             ,EXCH_PREM_ADDR_STR                                         
MFA-TR*             ,EXCH_PREM_ADDR_ZIP                                         
MFA-TR*             ,EXCH_RECV_KEY                                              
MFA-TR*             ,EXCH_REPORT_DT                                             
MFA-TR*             ,EXCH_SERV_TYPE_CD                                          
MFA-TR*             ,EXCH_START_DT                                              
MFA-TR*             )                                                           
MFA-TR*      VALUES (:EL-ACCOUNT-NO                                     34780000
MFA-TR*             ,:EL-EXCH-ACCOUNT-NO                                12970000
MFA-TR*             ,:EL-EXCH-CONFID-POINTS                             12953000
MFA-TR*             ,:EL-EXCH-CUST-FIRST-NM                             12954000
MFA-TR*             ,:EL-EXCH-CUST-LAST-NM                              34780000
MFA-TR*             ,:EL-EXCH-CUST-MID-NM                               12956000
MFA-TR*             ,:EL-EXCH-MATCH-TYPE-CD                                     
MFA-TR*             ,:EL-EXCH-PREM-ADDR-CTY                             12959000
MFA-TR*             ,:EL-EXCH-PREM-ADDR-OVF                             12951000
MFA-TR*             ,:EL-EXCH-PREM-ADDR-ST                              12981000
MFA-TR*             ,:EL-EXCH-PREM-ADDR-STR                             12960000
MFA-TR*             ,:EL-EXCH-PREM-ADDR-ZIP                             12952000
MFA-TR*             ,:EL-EXCH-RECV-KEY                                          
MFA-TR*             ,:EL-EXCH-REPORT-DT                                         
MFA-TR*             ,:EL-EXCH-SERV-TYPE-CD                                      
MFA-TR*             ,:EL-EXCH-START-DT                                  12957000
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                    35010000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT **************'       
               DISPLAY '* 8000-INSERT-RECV-TBL                 *'       
               DISPLAY '* REVC KEY   ', EL-EXCH-RECV-KEY                
               DISPLAY '* ACCOUNT NO ', EL-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA412 ABORT **************'       
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-INSERT-OPT-TBL                                            *        
      *      INSERT A NEW ROW INTO THE TABLE CSS_EXCH_DATA_OPT         *        
      ******************************************************************        
       8100-INSERT-OPT-TBL.                                             
           EXEC SQL                                                     
              INSERT INTO CSS_EXCH_DATA_OPT                             
                    (EXCH_RECV_KEY                                      
                    ,OPT_DATA_DESC_CD                                   
                    ,OPT_DATA_VALUE                                     
                    )                                                   
             VALUES (:EO-EXCH-RECV-KEY                                  
                    ,:EO-OPT-DATA-DESC-CD                               
                    ,:EO-OPT-DATA-VALUE                                 
                    )                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -803          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT **************'       
               DISPLAY '* 8100-INSERT-OPT-TBL                  *'       
               DISPLAY '* REVC KEY   ', EO-EXCH-RECV-KEY                
               DISPLAY '* DATA-DESC-CD ', EO-OPT-DATA-DESC-CD           
               DISPLAY '* RECV TABLE REVC KEY   ', EL-EXCH-RECV-KEY     
               DISPLAY '* RECV TABLE ACCOUNT NO ', EL-ACCOUNT-NO        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA412 ABORT **************'       
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-MTCH-TBL                                           *        
      *      INSERT A NEW ROW INTO THE TABLE CSS_EXCH_DATA_MTCH        *        
      ******************************************************************        
       8200-INSERT-MTCH-TBL.                                            
           EXEC SQL                                                     
              INSERT INTO CSS_EXCH_DATA_MTCH                            
                    (EXCH_RECV_KEY                                      
                    ,EXCH_MATCH_CD                                      
                    ,EXCH_MATCH_DESC_CD                                 
                    )                                                   
             VALUES (:ME-EXCH-RECV-KEY                                  
                    ,:ME-EXCH-MATCH-CD                                  
                    ,:ME-EXCH-MATCH-DESC-CD                             
                    )                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT **************'       
               DISPLAY '* 8200-INSERT-MTCH-TBL                 *'       
               DISPLAY '* REVC KEY   ', ME-EXCH-RECV-KEY                
               DISPLAY '* EXCH-MATCH-CD ', ME-EXCH-MATCH-CD             
               DISPLAY '* EXCH-MATCH-DESC-CD ', ME-EXCH-MATCH-DESC-CD   
               DISPLAY '* RECV TABLE REVC KEY   ', EL-EXCH-RECV-KEY     
               DISPLAY '* RECV TABLE ACCOUNT NO ', EL-ACCOUNT-NO        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *******************************************************                   
      **    8500-CHECK-CNTRL-TOT                           **                   
      ** CHECKS THE CONTROL RECORD FOR TOTALS IF OUT OF    **                   
      ** BALANCE ABENDS THE PROGRAM.                       **                   
      *******************************************************                   
       8500-CHECK-CNTRL-TOT.                                            
           IF CA412-TLR-TOT-NO-RECS NOT EQUAL  WS-FIOCA412-CNT          
              DISPLAY '************* PCSCA412 *****************'        
              DISPLAY '* TOTAL FIOCA412 RECORD MATCHED        *'        
              MOVE CA412-TLR-TOT-NO-RECS TO WS-DISP-VAR                 
              DISPLAY '* CNTRL TOT UMR: ' WS-DISP-VAR                   
              MOVE WS-FIOCA412-CNT      TO WS-DISP-VAR                  
              DISPLAY '* WRITE TOT UMR: ' WS-DISP-VAR                   
              DISPLAY '**************PCSCA412***************'           
      *       DISPLAY '********** PCSCA412 ABORT ***********'                   
      *       DISPLAY '* TOTAL FIOCA412 RECORDS NOT MATCHED  *'                 
      *       MOVE CA412-TLR-TOT-NO-RECS TO WS-DISP-VAR                         
      *       DISPLAY '* CNTRL TOT UMR: ' WS-DISP-VAR                           
      *       MOVE WS-FIOCA412-CNT      TO WS-DISP-VAR                          
      *       DISPLAY '* WRITE TOT UMR: ' WS-DISP-VAR                           
      *       DISPLAY '********** PCSCA412 ABORT ***********'                   
      *       PERFORM 9900-ABEND         THRU 9900-EXIT                         
           ELSE                                                         
              DISPLAY '************* PCSCA412 *****************'        
              DISPLAY '* TOTAL FIOCA412 RECORD MATCHED        *'        
              MOVE CA412-TLR-TOT-NO-RECS TO WS-DISP-VAR                 
              DISPLAY '* CNTRL TOT UMR: ' WS-DISP-VAR                   
              MOVE WS-FIOCA412-CNT      TO WS-DISP-VAR                  
              DISPLAY '* WRITE TOT UMR: ' WS-DISP-VAR                   
              DISPLAY '**************PCSCA412***************'           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  CPD00037  COPYBOOK TO READ PARM FILE FOR OVERRIDE DATE.6251**         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      **  CPD00038   READS JOB_PARM TABLE.  7600, 7610, 7611         **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      **  CPD00039   THIS CPD CONTAINS THE PARAGRAPH TO START AND    **         
      **  READ THE VSAM CONTROL FILE (FCSCA00-FILE). 7620,7621,7622  **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
      *                                                                         
      *      EXEC SQL                                                           
      *       INCLUDE CPD00055                                                  
      *      END-EXEC.                                                          
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      **  CLOSES  FIOCA412 FILE                                       **        
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FIOCA412-FILE                                          
      *                                                                         
           IF  FIOCA412-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA412 ABORT **********'           
               DISPLAY 'ERROR IN CLOSING FIOCA412-FILE'                 
               DISPLAY 'ERROR STATUS ' WS-FIOCA412-STATUS               
               DISPLAY '********** PCSCA412 ABORT **********'           
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   9100-DISPLAY-ERROR.                                          *        
      *        THIS PROCEDURE DISPLAYS THE ERROR MESSAGE               *        
      ******************************************************************        
       9100-DISPLAY-ERROR.                                              
           DISPLAY WS-DISP-RC , ' WS-ACTIVE-RETURN-CODE  '.             
           DISPLAY '********** PCSCA412 ABORT ********'.                
           DISPLAY '** PROCESSING ERROR IN PCSCA412   '.                
           DISPLAY '** PARAGRAPH = ', WS-ACTIVE-PARAGRAPH.              
           DISPLAY '** ', WS-ERR-MSG.                                   
           DISPLAY '** SQLCODE   = ', WS-DISP-RC.                       
           DISPLAY '** PROCESSING TERMINATED          '.                
           DISPLAY '********** PCSCA412 ABORT ********'.                
                                                                        
           PERFORM 9900-ABEND             THRU 9900-EXIT.               
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **          COPY BOOK CONTAINING 9700-PROCESS-ABEND              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **          COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT       **        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
