       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA410.                                         
       AUTHOR.        COVANSYS.                                         
       DATE-WRITTEN.  SEP 2001.                                         
                                                                        
      ***************************************************************** 00060000
      **              SOUTH CAROLINA ELECTRICITY  & GAS              ** 00070000
      **                                                             ** 00080000
      **                  CUSTOMER SERVICE SYSTEM                    ** 00090000
      **                         DB2                                 ** 00100000
      ***************************************************************** 00110000
      **                                                             ** 00120000
      **              PROGRAM  MODIFICATION  LOG                     ** 00130000
      **                                                             ** 00140000
      ** DATE       INITIALS       REASON                            ** 00150000
      **                                                             ** 00160000
      ** 09/00      COVANSYS       NEW PROGRAM                       ** 00170000
      **            INDIA                                            ** 00180000
      ** 03/02      LEF            PASS COMPANY PSNC TO SE CRED EX   ** 00190000
      ** 10/02      LEF            DO NOT SEND COMMERCIAL AND        ** 00200000
      **                           INDUSTRIAL ACCTS TO SE CRED EX    ** 00210000
C31455** 05/06      RICK BLACK     THE SE CREDIT EXCHANGE PROCESS WAS** 00220000
C31455**                           STOPPED SEVERAL YEARS AND IS NOW  ** 00230000
C31455**                           BEING RESTARTED.  SCEG ACCOUNTS   ** 00240000
C31455**                           WILL NOW BE INCLUDED.  THE FILE   ** 00250000
C31455**                           FORMAT HAS CHANGED WITH BOTH NEW  ** 00260000
C31455**                           AND UNPAID ACCOUNTS BEING SENT TO ** 00270000
C31455**                           EQUIFAX IN THE SAME FILE.         ** 00280000
T34153**09/21/07    CVNS           CHANGE NO OF DAYS OF SENDING UCAS ** 00290000
T34153**                           TO THE EXCHANGE FROM CURRENT VALUE** 00300000
T34153**                           OF 29 TO DAY AFTER AUTO TRANS     ** 00310000
C30169**12/31/07    CVNS           WRITE OFF RECOVERY CHANGES         **00320000
C30169**                           1. UCA PROCESS WILL NOW BE DRIVEN  **00330000
C30169**                              BY FORECASTED XCHG1 DATE IN     **00340000
C30169**                              CSS_FIN_WO_ACTION               **00350000
C30169**                           2. UCA AMOUNT WILL BE UPDATED IN   **00360000
C30169**                              CSS_FIN_WO_ACTION FOR THE ROW   **00370000
C30169**                              WITH ACTION TYPE XCHG1.         **00380000
C30169**10/17/08    CVNS           DELETE THE CODES REFERENCES TO     **00390000
C30169**            CHENNAI        CSS_FINAL_WO TABLE FIELDS.         **00400000
A00765**02/02/09    CVNS         ADDED 9000-SEND-ERROR-RESULT PARA    **00410000
A00765**            CHENNAI                                           **00420000
A37061** 04/24/09   MC95456        REPLACED  CHECKING MIDDLE DIGIT   ** 00430000
A37061*                            FROM CODE_REV_CLASS OF            ** 00440000
A37061*                            CSS_UTIL_ENVRMT  WITH             ** 00450000
A37061*                            ACCOUNT_TYPE_CODE OF              ** 00460000
A37061*                            CSS_ACCOUNT TABLE.                ** 00470000
A37061*                            ADDED WITH UR TO SINGLETON SELECTS** 00480000
P00161*  0513/09    MJ13662        FOR UPDATES ON UCA RECORD, SEND '6'* 00490000
P00161*                            FOR AC-TRAN-CD INSTEAD OF '5'. ALSO* 00500000
P00161*                            NO LONGER SEND AC-ORIG-BAL ON FILE * 00510000
P00161*                            FOR UPDATES.                       * 00520000
A37741*  11/16/09   VP94820        DECLARED S-RETURN-CODE RESPECTIVE  * 00522000
      *                            TO CPD00067 CHANGES.               * 00523000
P00599*  07/31/12   GV7A828        UPDATE FW_PROCESSED_FL TO 'Y' FOR  * 00524007
P00599*                            THE PROCESSED ACCOUNTS             * 00525007
      *                                                               * 00523000
A05154* 30 JAN 2015 RF10596        REMOVE UNUSED CODE                 * 00524007
      *                                                               * 00523000
      ******************************************************************00530000
      ******************************************************************00540000
      *    PCR NUMBER 048                                              *00550000
      *    THIS PROGRAM WILL BUILD A FILE OF ACCOUNTS TURNED ON SINCE  *00560000
C31455*    THE LAST TIME THE PROGRAM RAN AND ALSO INCLUDES UNPAID ACCTS*00570000
C31455*    WHO OWE US A BALANCE > DELIQUENCY AMOUNT PLUS PREVIOUSLY    *00580000
C31455*    REPORTED UNPAID ACCTS WHERE THERE HAS BEEN AN AR CHANGE.    *00590000
      *    THIS WILL BE CREATED IN SOUTHEASTERN EXCHANGE FORMAT        *00600000
      ******************************************************************00610000
      ******************************************************************00620000
             REMARKS.                                                   
      ******************************************************************00640000
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9899     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                 00770000
      ******************************************************************00780000
       ENVIRONMENT DIVISION.                                            
      ******************************************************************00800000
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
C31455 COPY CSSCA410.                                                   00850000
C31455*                                                                 00860000
C31455******************************************************************00870000
C31455* FILE USED TO RECOVER CONTENTS OF FIOCA410 FILE DURING RESTART  *00880000
C31455******************************************************************00890000
C31455     SELECT FIOC410R-FILE                                         
C31455         ASSIGN UT-S-FIOC410R                                     
C31455         FILE STATUS IS WS-FCA410R-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
C31455 COPY CFDCA410.                                                   00960000
C31455 COPY FIOCA410.                                                   00970000
                                                                        
C31455******************************************************************00990000
C31455* FD STATEMENT FOR RECOVERY FILE OF FIOCA410 FILE                *01000000
C31455******************************************************************01010000
C31455 FD  FIOC410R-FILE                                                
C31455     BLOCK CONTAINS 0 RECORDS                                     
C31455     RECORDING MODE IS F                                          
C31455     LABEL RECORDS ARE STANDARD.                                  
C31455                                                                  
C31455 01  FIOC410R-REC                        PIC X(500).              
C31455*                                                                 01080000
      ******************************************************************01090000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA410'.
MSQ017     COPY MFASQLM.
      ******************************************************************01110000
                                                                        
       77  COMP-CODE                   PIC S9(4) COMP                   
                                                 VALUE +0.              
       77  PROG-ID                     PIC X(08) VALUE 'PCSCA410'.      
                                                                        
       01  WORK-AREAS.                                                  
C31455     05  WS-FCA410-STATUS        PIC X(02).                       
C31455         88 FCA410-GOOD-STATUS             VALUE '00'.            
C31455     05  WS-FCA410R-STATUS       PIC X(02).                       
C31455         88 FCA410R-GOOD-STATUS            VALUE '00'.            
C31455     05 WS-ROW-EXISTS            PIC X(01).                       
C31455        88  ROW-EXISTS                     VALUE 'Y'.             
C31455        88  ROW-NOT-EXISTS                 VALUE 'N'.             
C31455     05 WS-EOF-EXISTS            PIC X(01).                       
C31455        88  EOF-EXISTS                     VALUE 'Y'.             
C31455        88  NOT-EOF-EXISTS                 VALUE 'N'.             
C31455     05  WS-TEMP-REC-CNTR        PIC 9(09).                       
C31455     05  WS-FCA410-ACCT-CD       PIC X(01).                       
C31455     05  WS-FCA410-REC-CNTR      PIC 9(09).                       
C31455     05  WS-FCA410-CSA-DEL       PIC 9(09).                       
C31455     05  WS-FCA410-CSA-ADD       PIC 9(09).                       
C31455     05  WS-FCA410-CSA-UPD       PIC 9(09).                       
C31455     05  WS-FCA410-CSA-ACC-CH    PIC 9(09).                       
C31455     05  WS-FCA410-UCA-DEL       PIC 9(09).                       
C31455     05  WS-FCA410-UCA-ADD       PIC 9(09).                       
C31455     05  WS-FCA410-UCA-ADD-AMT   PIC 9(14)V99.                    
C31455     05  WS-FCA410-UCA-OVL       PIC 9(09).                       
C31455     05  WS-FCA410-UCA-OVL-AMT   PIC 9(14)V99.                    
C31455     05  WS-FCA410-UCA-PAY       PIC 9(09).                       
C31455     05  WS-FCA410-UCA-PAY-AMT   PIC 9(14)V99.                    
C31455     05  WS-FCA410-UCA-UPD       PIC 9(09).                       
C31455     05  WS-FCA410-UCA-UPD-AMT   PIC 9(14)V99.                    
C31455     05  WS-FCA410-UCA-OVLBAL    PIC 9(09).                       
C31455     05  WS-FCA410-UCA-OVLBAL-AMT PIC 9(14)V99.                   
C31455     05  WS-FCA410-UCA-CURBAL    PIC 9(09).                       
C31455     05  WS-FCA410-UCA-CURBAL-AMT PIC 9(14)V99.                   
C31455     05  WS-FCA410-UCA-ACC-CH    PIC 9(09).                       
C31455     05  WS-AMT-CUST-ACCT-BAL    PIC 9(14)V99.                    
           05  WS-COMPANY-PROCESSED    PIC X(02).                       
C31455     05  WS-CO-ABBRV             PIC X(04).                       
C31455     05  WS-GRP-CNTRL-NO         PIC X(11).                       
C31455     05  WS-GROUP-DATE           PIC X(08).                       
T34153     05 WS-HOLIDAY-FL            PIC X(01)  VALUE 'N'.            
C31455     05  WS-RECENT-AR-FLAG       PIC X(01).                       
C31455         88 WS-RECENT-AR                   VALUE 'Y'.             
           05  WS-CUSTOMER-NO          PIC S9(10)V COMP-3               
                                                 VALUE ZERO.            
C31455     05  WS-COMMIT-CTR           PIC  9(4)  VALUE 0.              
C31455     05  WS-RECS-TO-COMMIT-COUNT PIC  9(3)  VALUE 0.              
T34153     05  WS-BIZ-DAYS-COUNT       PIC S9(09) COMP VALUE 0.         
T34097     05 WS-HOLIDAY-CNT           PIC S9(04) COMP VALUE 0.         
                                                                        
           05  WS-CURR-DATE            PIC X(08) VALUE ZEROES.          
C31455     05  WS-CURR-TIME.                                            
C31455         10  WS-CURR-TIME-HH     PIC 9(02).                       
C31455         10  WS-CURR-TIME-MM     PIC 9(02).                       
C31455         10  WS-CURR-TIME-SS     PIC 9(02).                       
C31455         10  WS-CURR-TIME-MS     PIC 9(02).                       
T34153     05  WS-DAY                  PIC S9(04) COMP.                 
T34153     05 WS-WORK-DATE             PIC X(10) VALUE SPACES.          
           05  WS-WK-DATE.                                              
               10  WS-WK-DATE-CC       PIC X(02).                       
               10  WS-WK-DATE-YY       PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-WK-DATE-MM       PIC X(02).                       
               10  FILLER              PIC X(01) VALUE '-'.             
               10  WS-WK-DATE-DD       PIC X(02).                       
      *                                                                 01790000
C31455     05  WS-CA410-DATE.                                           
C31455         10  WS-CA410-DATE-CC       PIC X(02).                    
C31455         10  WS-CA410-DATE-YY       PIC X(02).                    
C31455         10  WS-CA410-DATE-MM       PIC X(02).                    
C31455         10  WS-CA410-DATE-DD       PIC X(02).                    
C31455                                                                  
C31455     05  WS-CA410-TIME.                                           
C31455         10  WS-CA410-TIME-HH       PIC X(02).                    
C31455         10  WS-CA410-TIME-MM       PIC X(02).                    
C31455         10  WS-CA410-TIME-SS       PIC X(02).                    
C31455                                                                  
C31455     05  WS-AD-ZIP9.                                              
C31455         10  WS-AD-ZIP5          PIC X(05).                       
C31455         10  WS-AD-ZIP4          PIC X(04).                       
                                                                        
           05  WS-RUN-DATE             PIC X(10) VALUE SPACES.          
                                                                        
           05  WS-PARM-DATA.                                            
               10  FILLER              PIC X(14) VALUE                  
                                                      'LAST RUN DATE=' .
               10  WS-LAST-RUN-DATE    PIC X(10).                       
               10  FILLER              PIC X(56).                       
C31455*                                                                 02020000
C31455     05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
C31455*                                                                 02040000
C31455     05  WS-TIMESTAMP.                                            
C31455         10  WS-TIMESTAMP-CC     PIC X(2).                        
C31455         10  WS-TIMESTAMP-YY     PIC X(2).                        
C31455         10  FILLER              PIC X(1).                        
C31455         10  WS-TIMESTAMP-MONTH  PIC X(2).                        
C31455         10  FILLER              PIC X(1).                        
C31455         10  WS-TIMESTAMP-DD     PIC X(2).                        
C31455         10  FILLER              PIC X(1).                        
C31455         10  WS-TIMESTAMP-HH     PIC X(2).                        
C31455         10  FILLER              PIC X(1).                        
C31455         10  WS-TIMESTAMP-MM     PIC X(2).                        
C31455         10  FILLER              PIC X(1).                        
C31455         10  WS-TIMESTAMP-SS     PIC X(2).                        
C31455         10  FILLER              PIC X(7).                        
C31455*                                                                 02190000
C31455     05  WS-LAST-RUN-TS.                                          
C31455         10  WS-LAST-RUN-DATE-TS PIC X(10).                       
C31455         10  FILLER              PIC X(1) VALUE '-'.              
C31455         10  WS-LAST-RUN-HH      PIC X(2).                        
C31455         10  FILLER              PIC X(1) VALUE '.'.              
C31455         10  WS-LAST-RUN-MM      PIC X(2).                        
C31455         10  FILLER              PIC X(1) VALUE '.'.              
C31455         10  WS-LAST-RUN-SS      PIC X(2).                        
C31455         10  FILLER              PIC X(1) VALUE '.'.              
C31455         10  WS-LAST-RUN-MS      PIC X(6).                        
C31455*                                                                 02300000
C31455     05  WS-TIMESTAMP-KEY-NO     PIC 9(12).                       
C31455     05  WS-TIMESTAMP-KEY REDEFINES WS-TIMESTAMP-KEY-NO.          
C31455         10  WS-TIMES-YY-KEY     PIC X(2).                        
C31455         10  WS-TIMES-MM-KEY     PIC X(2).                        
C31455         10  WS-TIMES-DD-KEY     PIC X(2).                        
C31455         10  WS-TIMES-HH-KEY     PIC X(2).                        
C31455         10  WS-TIMES-MIN-KEY    PIC X(2).                        
C31455         10  WS-TIMES-SS-KEY     PIC X(2).                        
      *                                                                 02390000
           05  WS-TEMP-ADDR1           PIC X(20) VALUE SPACES.          
           05  WS-TEMP-ADDR2           PIC X(20) VALUE SPACES.          
           05  WS-TEMP-ADDR3           PIC X(20) VALUE SPACES.          
           05  WS-TEMP-ADDR4           PIC X(20) VALUE SPACES.          
           05  WS-TEMP-LEN1            PIC 9(03) VALUE 0.               
           05  WS-TEMP-LEN2            PIC 9(03) VALUE 0.               
           05  WS-TEMP-LEN3            PIC 9(03) VALUE 0.               
           05  WS-TEMP-LEN4            PIC 9(03) VALUE 0.               
           05  WS-CHK-ADDR             PIC X(30) VALUE SPACES.          
           05  WS-TEMP-STATE.                                           
               10 FILLER               PIC X(01) VALUE SPACES.          
               10 WS-TEMP-ST           PIC X(02) VALUE SPACES.          
               10 FILLER               PIC X(01) VALUE SPACES.          
           05  WS-TEMP-STATE2          PIC X(04) VALUE SPACES.          
C31455     05  WS-DELINQ-LIMIT         PIC S9(05) COMP-3 VALUE 0.       
C31455     05  WS-DELINQ-LIMIT-NULL    PIC S9(04) COMP VALUE +0.        
T34153     05  WS-DELINQ-DAYS          PIC S9(09) COMP VALUE 0.         
C31455     05  WS-DATE-OF-BIRTH-NULL   PIC S9(04) COMP VALUE +0.        
C31455     05  WS-ACCT-FINAL-DT-NULL   PIC S9(04) COMP VALUE +0.        
C31455     05  WS-ACCT-DISCN-DT-NULL   PIC S9(04) COMP VALUE +0.        
C31455     05  WS-ACCT-CONN-DT-NULL    PIC S9(04) COMP VALUE +0.        
C31455     05  WS-PREV-UCA-ACCT        PIC S9(13)V COMP-3 VALUE 0.      
C31455     05  WS-MI-AMOUNT-VALUE      PIC $$$$,$$9.99.                 
C31455     05  WS-ORIG-AMOUNT          PIC S9(6)V99.                    
C31455     05  WS-CURR-AMOUNT          PIC S9(6)V99.                    
COB305     05 WS-TOTAL-AR-BALANCE        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
                                                                        
      *                                                                 02670000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA410'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA410'.      
C31455     05  WS-SCSCB068             PIC X(08) VALUE 'SCSCB068'.      
C31455     05  WS-019                  PIC X(03) VALUE '019'.           
C31455     05  WS-A1                   PIC X(02) VALUE 'A1'.            
           05  WS-W1                   PIC X(02) VALUE 'W1'.            
           05  WS-H1                   PIC X(02) VALUE 'H1'.            
           05  WS-H2                   PIC X(02) VALUE 'H2'.            
           05  WS-C1                   PIC X(02) VALUE 'C1'.            
           05  WS-F1                   PIC X(02) VALUE 'F1'.            
           05  WS-P1                   PIC X(02) VALUE 'P1'.            
           05  WS-Y                    PIC X(01) VALUE 'Y'.             
           05  WS-N                    PIC X(01) VALUE 'N'.             
C31455     05  WS-F                    PIC X(01) VALUE 'F'.             
C31455     05  WS-SYSTEM               PIC X(06) VALUE 'SYSTEM'.        
C31455     05  WS-ZERO-POINT           PIC 99V99 VALUE ZEROS.           
C31455     05  WS-SPACES               PIC X(01) VALUE ' '.             
C31455     05  WS-MSG-CSA-SENT         PIC X(42) VALUE                  
C31455         'ACCOUNT SUBMITTED TO UTILITY EXCHANGE CSA '.            
C31455     05  WS-MSG-UCA-SENT-PT1     PIC X(42) VALUE                  
C31455         'ACCOUNT SUBMITTED TO UTILITY EXCHANGE UCA '.            
C31455     05  WS-MSG-UCA-SENT-UPD2.                                    
C31455         10  WS-MSG-UCA-SENT-UPD2A PIC X(15) VALUE                
C31455                'UPDATED AMOUNT '.                                
C31455         10  FILLER                PIC X(19) VALUE SPACES.        
C31455     05  WS-MSG-RPT-SENT1        PIC X(42) VALUE                  
C31455         'CSA PREVIOUSLY SUBMITTED WITH THE SAME CUS'.            
C31455     05  WS-MSG-RPT-SENT2        PIC X(26) VALUE                  
C31455         'TOMER AND SAME PREMISE.   '.                            
C31455     05  WS-EXCH-AMOUNT-DESC     PIC X(15) VALUE                  
C31455         'EXCH SEND AMT  '.                                       
C31455*                                                                 03000000
C31455 01  WS-MH-MESSAGE.                                               
C31455     05  WS-MSG-TEXT                     PIC X(42).               
C31455     05  WS-MSG-TEXT2                    PIC X(34).               
C31455     05  FILLER                          PIC X(07) VALUE SPACE.   
C31455*                                                                 03050000
       01  WS-INDEX                    PIC 9(02) VALUE ZEROS.           
                                                                        
       01  WS-FLAGS.                                                    
           05  WS-FETCH-FLG            PIC X(01) VALUE 'Y'.             
               88 FIRST-FETCH-FLG                VALUE 'Y'.             
               88 MORE-FETCH-FLG                 VALUE 'N'.             
           05  WS-NAME-FOUND-FLAG      PIC X(01) VALUE 'N'.             
               88 WS-NAME-FOUND        VALUE 'Y'.                       
           05  WS-RESIDENTIAL-CUST-FLAG  PIC X(01) VALUE 'N'.           
               88 WS-RESIDENTIAL-CUST    VALUE 'Y'.                     
C31455     05  WS-NAME-FORMAT-TYPE-FLAG  PIC X(01) VALUE 'N'.           
C31455         88 WS-INDIVIDUAL-TYPE     VALUE 'Y'.                     
C31455     05  WS-JOB-PARM-STATUS        PIC X(1)  VALUE 'A'.           
C31455     05  WS-RESTART-SW             PIC X(1)  VALUE 'N'.           
C31455     05  WS-RESTART-STEP           PIC X(4)  VALUE SPACES.        
      *                                                                 03210000
C31455******************************************************************03220000
C31455* DATA USED TO UPDATE CSS_RESTART TABLE AT EVERY DB2 COMMIT.     *03230000
C31455* LENGTH OF RESTART DATA IS 888.                                 *03240000
C31455******************************************************************03250000
C31455                                                                  
C31455 01  WS-RESTART-DATA             PIC X(891).                      
C31455 01  WS-RESTART-DATA-BREAKDOWN REDEFINES WS-RESTART-DATA.         
C31455     05  WS-RESTRT-DATA-LEN      PIC S9(4)  USAGE COMP.           
C31455     05  WS-RESTRT-STEP          PIC X(4).                        
C31455     05  WS-RESTRT-ACCT-NO       PIC 9(13).                       
C31455     05  WS-RESTRT-AC-REC-NO     PIC 9(7).                        
C31455     05  WS-RESTRT-GRP-CNTRL-NO  PIC X(11).                       
C31455     05  WS-RESTRT-GROUP-DATE    PIC 9(7).                        
C31455     05  WS-RESTRT-CSA-ADD       PIC 9(09).                       
C31455     05  WS-RESTRT-UCA-ADD       PIC 9(09).                       
C31455     05  WS-RESTRT-UCA-PAY       PIC 9(09).                       
C31455     05  WS-RESTRT-UCA-PAY-AMT   PIC 9(12).                       
C31455     05  WS-RESTRT-CO-NO         PIC X(02).                       
C31455     05  WS-RESTRT-INPUT-DATE    PIC X(10).                       
C31455     05  WS-RESTRT-LAST-RUN-DATE PIC X(10).                       
C31455     05  WS-RESTRT-COMMITS-COUNT PIC 9(4).                        
C31455     05  WS-RESTRT-DATA-REST     PIC X(782).                      
C31455*                                                                 03440000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP                  
                                                 VALUE +0.              
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
A37741     05  S-RETURN-CODE           PIC S9(9) VALUE +000 COMP.       
      *                                                                 03490000
      *****                                                             03500000
      *  COPYBOOK FOR ABEND FILE                                        03510000
      *****                                                             03520000
       COPY CWS00010.                                                   03530000
      *****                                                             03540000
      *  COPYBOOK FOR ABEND SWITCH                                      03550000
      *****                                                             03560000
       COPY CWS09900.                                                   03570000
      *                                                                 03580000
      *****                                                             03590000
C31455*  COPYBOOK FOR WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT     03600000
C31455*****                                                             03610000
C31455 COPY CWS00056.                                                   03620000
C31455*                                                                 03630000
      *****                                                             03640000
      *  SQL COMMUNICATION AREA                                         03650000
      *****                                                             03660000
           EXEC SQL                                                     03670000
             INCLUDE SQLCA                                              03680000
           END-EXEC.                                                    03690000
      *                                                                 03700000
31455 *****                                                             03710000
31455 *  CSS_CUST - CU                                                  03720000
31455 *****                                                             03730000
31455      EXEC SQL                                                     03740000
31455        INCLUDE TBCUST                                             03750000
31455      END-EXEC.                                                    03760000
31455 *                                                                 03770000
      *****                                                             03780000
      *  CSS_NAME - DQ                                                  03790000
      *****                                                             03800000
           EXEC SQL                                                     03810000
             INCLUDE TBNAME                                             03820000
           END-EXEC.                                                    03830000
      *                                                                 03840000
      *****                                                             03850000
      *  CSS_NAME_ACCT_XREF - HT                                        03860000
      *****                                                             03870000
           EXEC SQL                                                     03880000
             INCLUDE TBNMACTX                                           03890000
           END-EXEC.                                                    03900000
      *                                                                 03910000
      *****                                                             03920000
      *  CSS_CUST_ADDR_XREF - DM                                        03930000
      *****                                                             03940000
           EXEC SQL                                                     03950000
             INCLUDE TBCSADRX                                           03960000
           END-EXEC.                                                    03970000
      *                                                                 03980000
      *****                                                             03990000
      *  CSS_ADDR_FREEFORM - DZ                                         04000000
      *****                                                             04010000
           EXEC SQL                                                     04020000
             INCLUDE TBADRFRE                                           04030000
           END-EXEC.                                                    04040000
      *                                                                 04050000
      *****                                                             04060000
      *  CSS_ADDR_FMTTED - DY                                           04070000
      *****                                                             04080000
           EXEC SQL                                                     04090000
             INCLUDE TBADRFMT                                           04100000
           END-EXEC.                                                    04110000
      *                                                                 04120000
      *****                                                             04130000
      *  CSS_ZIP_CODE - A4                                              04140000
      *****                                                             04150000
           EXEC SQL                                                     04160000
             INCLUDE TBZIPCD                                            04170000
           END-EXEC.                                                    04180000
      *                                                                 04190000
      *****                                                             04200000
      *  CSS_ACCT_MISC_INFO - TA                                        04210000
      *****                                                             04220000
           EXEC SQL                                                     04230000
             INCLUDE TBATMISC                                           04240000
           END-EXEC.                                                    04250000
      *                                                                 04260000
      *****                                                             04270000
      *  CSS_CUST_PHONE - CB                                            04280000
      *****                                                             04290000
           EXEC SQL                                                     04300000
             INCLUDE TBCSTPHN                                           04310000
           END-EXEC.                                                    04320000
      *                                                                 04330000
      *****                                                             04340000
      *  CSS_ACCOUNT - AT                                               04350000
      *****                                                             04360000
           EXEC SQL                                                     04370000
             INCLUDE TBACCT                                             04380000
           END-EXEC.                                                    04390000
      *                                                                 04400000
      *****                                                             04410000
      *  CSS_CUST_PREM_HIST - CH                                        04420000
      *****                                                             04430000
           EXEC SQL                                                     04440000
             INCLUDE TBCSTPRM                                           04450000
           END-EXEC.                                                    04460000
      *                                                                 04470000
      *****                                                             04480000
      *  CSS_CUST_STATS - CE                                            04490000
      *****                                                             04500000
           EXEC SQL                                                     04510000
             INCLUDE TBCSTSTS                                           04520000
           END-EXEC.                                                    04530000
      *                                                                 04540000
      *****                                                             04550000
      *  CSS_JOB_PARM - GL                                              04560000
      *****                                                             04570000
           EXEC SQL                                                     04580000
             INCLUDE TBJBPARM                                           04590000
           END-EXEC.                                                    04600000
      *                                                                 04610000
C31455*****                                                             04620000
C31455*  CSS_MNT_TRANS_HIST - MH                                        04630000
C31455*****                                                             04640000
C31455     EXEC SQL                                                     04650000
C31455       INCLUDE TBMNHIST                                           04660000
C31455     END-EXEC.                                                    04670000
C31455*                                                                 04680000
C31455*****                                                             04690000
C31455*  CSS_MT_TRN_HST_DET - MI                                        04700000
C31455*****                                                             04710000
C31455     EXEC SQL                                                     04720000
C31455       INCLUDE TBMNHDT                                            04730000
C31455     END-EXEC.                                                    04740000
C31455*                                                                 04750000
C31455*****                                                             04760000
C31455*  CSS_EXCH_DATA_SENT - EX                                        04770000
C31455*****                                                             04780000
C31455     EXEC SQL                                                     04790000
C31455       INCLUDE TBEXCSNT                                           04800000
C31455     END-EXEC.                                                    04810000
C31455*                                                                 04820000
C30169*****                                                             04830000
C30169*  CSS_FIN_WO_ACTION - KD                                         04840000
C30169*****                                                             04850000
C30169     EXEC SQL                                                     04860000
C30169         INCLUDE TBFWACTN                                         04870000
C30169     END-EXEC.                                                    04880000
      *                                                                 04890000
C31455*  CSS_DELINQUENCY - C8                                           05040000
      *                                                                 04890000
C31455     EXEC SQL                                                     05060000
C31455         INCLUDE TBDELQ                                           05070000
C31455     END-EXEC.                                                    05080000
      *                                                                 05090000
C31455*  CSS_RESTART - RF                                               05600000
C31455*****                                                             05610000
C31455     EXEC SQL                                                     05620000
C31455         INCLUDE TBRESTRT                                         05630000
C31455     END-EXEC.                                                    05640000
      *                                                                 05650000
C31455*  WORKING STORAGE FOR SCSCB068                                   05670000
C31455*****                                                             05680000
C31455     EXEC SQL                                                     05690000
C31455       INCLUDE CWS00068                                           05700000
C31455     END-EXEC.                                                    05710000
      *                                                                 05720000
      *****                                                             05730000
      *  WORKING STORAGE FOR NAME/ADDRESS ROUTINE                       05740000
      *****                                                             05750000
           EXEC SQL                                                     05760000
              INCLUDE CWS00074                                          05770000
           END-EXEC.                                                    05780000
      *                                                                 05790000
      *****                                                             05800000
      *  COPYBOOK FOR FETCHING JOB PARM DETAILS                         05810000
      *****                                                             05820000
           EXEC SQL                                                     05830000
              INCLUDE CWS00038                                          05840000
           END-EXEC.                                                    05850000
      *                                                                 05860000
      *****                                                             05870000
      *  COPYBOOK FOR SQL ERROR CHECKING                                05880000
      *****                                                             05890000
           EXEC SQL                                                     05900000
              INCLUDE CWS00303                                          05910000
           END-EXEC.                                                    05920000
      *                                                                 05930000
      *****                                                             05940000
      *COPYBOOK FOR REDUCING EMBEDDED SPACES                            05950000
      *****                                                             05960000
           EXEC SQL                                                     05970000
              INCLUDE CWS00011                                          05980000
           END-EXEC.                                                    05990000
      *                                                                 06000000
      *****                                                             06010000
      *COPYBOOK FOR DATE CHECK                                          06020000
      *****                                                             06030000
           EXEC SQL                                                     06040000
              INCLUDE FIOJC01                                           06050000
           END-EXEC.                                                    06060000
      *                                                                 06070000
C31455***************************************************************** 06080000
C31455**  CURSOR DECLARATION TO SELECT NEW ACCOUNTS USING THE        ** 06090000
C31455**  SERVICE START DATE.                                        ** 06100000
C31455***************************************************************** 06110000
           EXEC SQL                                                     
               DECLARE CSA-CURSOR CURSOR WITH HOLD FOR                  
               SELECT                                                   
                      AT.ACCOUNT_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,AT.CUSTOMER_NO                                    
                     ,AT.PREMISE_NO                                     
A37061               ,AT.ACCOUNT_TYPE_CODE                              
                     ,AT.ADDRESS_ID                                     
                     ,AT.ADDRESS_FORMAT                                 
                     ,AT.LOCAL_OFFICE                                   
                     ,CH.DATE_UTIL_SVC_STRT                             
                FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED),              
                      CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
               WHERE  CH.DATE_UTIL_SVC_STRT >= IIF(TRY_CONVERT(DATE, 
                                                 :CH-DATE-UTIL-SVC-STRT
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-STRT
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-STRT
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-STRT
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-STRT) )   
                 AND  CH.ACCOUNT_NO          = AT.ACCOUNT_NO            
                 AND  AT.COMPANY_NO          = :AT-COMPANY-NO           
C31455       ORDER BY AT.ACCOUNT_NO                                     
C31455         FOR READ ONLY                                           
C31455                                                           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06120000
MFA-TR*        DECLARE CSA-CURSOR CURSOR WITH HOLD FOR                  06130000
MFA-TR*        SELECT                                                   06140000
MFA-TR*               AT.ACCOUNT_NO                                     06150000
MFA-TR*              ,AT.CODE_ACCT_STAT                                 06160000
MFA-TR*              ,AT.CUSTOMER_NO                                    06170000
MFA-TR*              ,AT.PREMISE_NO                                     06180000
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                              06190000
MFA-TR*              ,AT.ADDRESS_ID                                     06200000
MFA-TR*              ,AT.ADDRESS_FORMAT                                 06210000
MFA-TR*              ,AT.LOCAL_OFFICE                                   06220000
MFA-TR*              ,CH.DATE_UTIL_SVC_STRT                             06230000
MFA-TR*         FROM  CSS_ACCOUNT        AT,                            06240000
MFA-TR*               CSS_CUST_PREM_HIST CH                             06250000
MFA-TR*        WHERE  CH.DATE_UTIL_SVC_STRT >= :CH-DATE-UTIL-SVC-STRT   06260000
MFA-TR*          AND  CH.ACCOUNT_NO          = AT.ACCOUNT_NO            06270000
MFA-TR*          AND  AT.COMPANY_NO          = :AT-COMPANY-NO           06280000
MFA-TR*      ORDER BY AT.ACCOUNT_NO                                     06290000
MFA-TR*        FOR FETCH ONLY                                           06300000
MFA-TR*        WITH UR                                                  06310000
MFA-TR*    END-EXEC.                                                    06320000
C31455*                                                                 06330000
C31455***************************************************************** 06340000
C31455**  CURSOR DECLARATION TO SELECT FINAL BILLED AND WRITE OFF    ** 06350000
C31455**  ACCOUNTS FROM CSS_ACCOUNT AND CSS_FIN_WO_ACTION.           ** 06360000
C31455***************************************************************** 06370000
C31455*                                                                 06380000
C30169     EXEC SQL                                                     
C30169       DECLARE UCA-CURSOR CURSOR WITH HOLD FOR                    
C30169         SELECT AT.ACCOUNT_NO                                     
C30169               ,KD.ACCOUNT_NO                                     
C30169               ,KD.FW_ACTION_DT                                   
C30169               ,KD.FW_ACTION_TYPE_CD                              
C30169               ,KD.FW_SEQ_NO                                      
C30169               ,AT.CODE_ACCT_STAT                                 
C30169               ,AT.CUSTOMER_NO                                    
C30169               ,AT.PREMISE_NO                                     
A37061               ,AT.ACCOUNT_TYPE_CODE                              
C30169               ,AT.ADDRESS_ID                                     
C30169               ,AT.ADDRESS_FORMAT                                 
C30169               ,AT.TOTAL_AR_BALANCE                               
C30169               ,AT.CODES_DATA_PRESENT                             
C30169               ,AT.COMPANY_NO                                     
C30169               ,AT.LOCAL_OFFICE                                   
C30169               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                
C30169               ,AT.BANKRUPTCY_IND                                 
C30169         FROM  CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                 
C30169              ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
C30169         WHERE (KD.FW_ACTION_DT > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )               
C30169           AND KD.FW_ACTION_DT <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ))                   
C30169           AND KD.FW_ACTION_TYPE_CD = 'XCHG1'                     
C30169           AND KD.ACCOUNT_NO = AT.ACCOUNT_NO                      
C30169           AND AT.COMPANY_NO = :AT-COMPANY-NO                     
C30169         FOR READ ONLY                                           
C30169                                                           
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06390000
MFA-TR*      DECLARE UCA-CURSOR CURSOR WITH HOLD FOR                    06400000
MFA-TR*        SELECT AT.ACCOUNT_NO                                     06410000
MFA-TR*              ,KD.ACCOUNT_NO                                     06420000
MFA-TR*              ,KD.FW_ACTION_DT                                   06430000
MFA-TR*              ,KD.FW_ACTION_TYPE_CD                              06440000
MFA-TR*              ,KD.FW_SEQ_NO                                      06450000
MFA-TR*              ,AT.CODE_ACCT_STAT                                 06460000
MFA-TR*              ,AT.CUSTOMER_NO                                    06470000
MFA-TR*              ,AT.PREMISE_NO                                     06480000
MFA-TR*              ,AT.ACCOUNT_TYPE_CODE                              06490000
MFA-TR*              ,AT.ADDRESS_ID                                     06500000
MFA-TR*              ,AT.ADDRESS_FORMAT                                 06510000
MFA-TR*              ,AT.TOTAL_AR_BALANCE                               06520000
MFA-TR*              ,AT.CODES_DATA_PRESENT                             06530000
MFA-TR*              ,AT.COMPANY_NO                                     06540000
MFA-TR*              ,AT.LOCAL_OFFICE                                   06550000
MFA-TR*              ,AT.ACCT_FINALED_DT                                06560000
MFA-TR*              ,AT.BANKRUPTCY_IND                                 06570000
MFA-TR*        FROM  CSS_FIN_WO_ACTION KD                               06580000
MFA-TR*             ,CSS_ACCOUNT AT                                     06590000
MFA-TR*        WHERE (KD.FW_ACTION_DT > :WS-LAST-RUN-DATE               06600000
MFA-TR*          AND KD.FW_ACTION_DT <= :WS-RUN-DATE)                   06610000
MFA-TR*          AND KD.FW_ACTION_TYPE_CD = 'XCHG1'                     06620000
MFA-TR*          AND KD.ACCOUNT_NO = AT.ACCOUNT_NO                      06630000
MFA-TR*          AND AT.COMPANY_NO = :AT-COMPANY-NO                     06640000
MFA-TR*        FOR FETCH ONLY                                           06650000
MFA-TR*        WITH UR                                                  06660000
MFA-TR*    END-EXEC.                                                    06670000
C31455***************************************************************** 06680000
C31455**  CURSOR DECLARATION TO SELECT UCA ACCOUNTS THAT HAVE BEEN   ** 06690000
C31455**  REPORTED PREVIOUSLY.                                       ** 06700000
C31455***************************************************************** 06710000
C31455*                                                                 06720000
C31455     EXEC SQL                                                     
C31455       DECLARE OLD-UCA-CURSOR CURSOR WITH HOLD FOR                
C31455         SELECT          EX.ACCOUNT_NO                            
C31455                        ,EX.COMPANY_NO                            
C31455                        ,EX.CUSTOMER_NO                           
C31455                        ,EX.EXCH_REC_TYPE_CD                      
C31455                        ,EX.EXCH_SENT_AM                          
C31455                        ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           EX.EXCH_SENT_TS, 121), ' ', '-'), ':', '.') EXCH_SENT_TS            
C31455                        ,EX.PREMISE_NO                            
C31455         FROM   CSS_EXCH_DATA_SENT EX WITH(READUNCOMMITTED)               
C31455         WHERE  EX.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD        
C31455           AND  EX.COMPANY_NO = :EX-COMPANY-NO                    
C31455       ORDER BY EX.ACCOUNT_NO                                     
C31455               ,EXCH_SENT_TS DESC                              
C31455         FOR READ ONLY                                           
C31455                                                           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06730000
MFA-TR*      DECLARE OLD-UCA-CURSOR CURSOR WITH HOLD FOR                06740000
MFA-TR*        SELECT          EX.ACCOUNT_NO                            06750000
MFA-TR*                       ,EX.COMPANY_NO                            06760000
MFA-TR*                       ,EX.CUSTOMER_NO                           06770000
MFA-TR*                       ,EX.EXCH_REC_TYPE_CD                      06780000
MFA-TR*                       ,EX.EXCH_SENT_AM                          06790000
MFA-TR*                       ,EX.EXCH_SENT_TS                          06800000
MFA-TR*                       ,EX.PREMISE_NO                            06810000
MFA-TR*        FROM   CSS_EXCH_DATA_SENT EX                             06820000
MFA-TR*        WHERE  EX.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD        06830000
MFA-TR*          AND  EX.COMPANY_NO = :EX-COMPANY-NO                    06840000
MFA-TR*      ORDER BY EX.ACCOUNT_NO                                     06850000
MFA-TR*              ,EX.EXCH_SENT_TS DESC                              06860000
MFA-TR*        FOR FETCH ONLY                                           06870000
MFA-TR*        WITH UR                                                  06880000
MFA-TR*    END-EXEC.                                                    06890000
C31455*                                                                 06900000
C31455*                                                                 06910000
      ******************************************************************06920000
       LINKAGE SECTION.                                                 
      ******************************************************************06940000
      *                                                                 06950000
       01  WS-PARM-CARD.                                                
           05  WS-CHKBYTE              PIC S9(04) COMP.                 
           05  WS-PARM-COMPANY-NO      PIC X(02).                       
      *                                                                 06990000
HPCCDM*EJECT                                                            07000000
      ******************************************************************07010000
      *                P R O C E D U R E   D I V I S I O N             *07020000
      ******************************************************************07030000
       PROCEDURE DIVISION USING WS-PARM-CARD.                           
                                                                        
C31455 0000-MAIN.                                                       
           PERFORM 0100-INITIALIZATION       THRU 0100-EXIT.            
           PERFORM 1000-MAIN-PROCESS-PARA    THRU 1000-EXIT.            
C31455     PERFORM 4550-WRITE-END-CONTROLS   THRU 4550-EXIT.            
C31455     PERFORM 0500-COMMIT-DB2-UPDATE    THRU 0500-EXIT.            
C31455     MOVE 'I' TO WS-JOB-PARM-STATUS.                              
C31455     PERFORM 0530-UPDATE-JOB-PARM-TBL  THRU 0530-EXIT.            
C31455     PERFORM 9100-DELETE-RESTART-TABLE THRU 9100-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
      *                                                                 07160000
      ******************************************************************07170000
      *  0100-INITIALIZATION                                           *07180000
      *      OPENS OUTPUT FILE, GETS CURRENT DATE                      *07190000
      ******************************************************************07200000
       0100-INITIALIZATION.                                             
      *                                                                 07220000
C31455     OPEN OUTPUT FCSCA410-FILE.                                   
      *                                                                 07240000
C31455     IF FCA410-GOOD-STATUS                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************** ABENDING ***************'       
               DISPLAY '* ERROR - IN OPENING OUTPUT FILE       *'       
               DISPLAY '* STATUS  - ' WS-FCA410-STATUS                  
               DISPLAY '*************** PCSCA410 ****************'      
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                 07340000
           INITIALIZE FIOCA410-RECORD.                                  
C31455     INITIALIZE WS-RESTART-DATA-BREAKDOWN.                        
           MOVE ZEROES                 TO WS-FCA410-REC-CNTR            
                                          WS-FCA410-CSA-ADD             
                                          WS-FCA410-UCA-ADD             
                                          WS-FCA410-UCA-PAY             
                                          WS-FCA410-UCA-PAY-AMT.        
           MOVE WS-PARM-COMPANY-NO     TO WS-COMPANY-PROCESSED          
                                          G6-COMPANY-NO                 
                                          C8-COMPANY-NO.                
      *                                                                 07450000
           DISPLAY ' '                                                  
           DISPLAY '*************** PCSCA410 ***************'           
           DISPLAY '* JOB RUNNING FOR COMPANY ' WS-COMPANY-PROCESSED    
           DISPLAY '*************** PCSCA410 ****************'          
C31455*                                                                 07500000
C31455     PERFORM 0105-PREPARE-FOR-RESTART THRU 0105-EXIT.             
      *                                                                 07520000
C31455     IF WS-RESTART-SW = 'N'                                       
C31455         ACCEPT WS-CURR-DATE FROM DATE                            
C31455         ACCEPT WS-CURR-TIME FROM TIME                            
C31455         IF WS-CURR-DATE(1:2) < 50                                
C31455             MOVE '20' TO WS-WK-DATE-CC                           
C31455                          WS-CA410-DATE-CC                        
C31455         ELSE                                                     
C31455             MOVE '19' TO WS-WK-DATE-CC                           
C31455                          WS-CA410-DATE-CC                        
C31455         END-IF                                                   
C31455         MOVE WS-CURR-DATE(1:2) TO WS-WK-DATE-YY                  
C31455                                   WS-CA410-DATE-YY               
C31455         MOVE WS-CURR-DATE(3:2) TO WS-WK-DATE-MM                  
C31455                                   WS-CA410-DATE-MM               
C31455         MOVE WS-CURR-DATE(5:2) TO WS-WK-DATE-DD                  
C31455                                   WS-CA410-DATE-DD               
C31455         MOVE WS-WK-DATE TO WS-RUN-DATE                           
T34153         DISPLAY '** CURRENT RUN DATE= ' WS-RUN-DATE              
C31455         MOVE WS-CA410-DATE   TO WS-GROUP-DATE                    
C31455         MOVE WS-CURR-TIME-HH TO WS-CA410-TIME-HH                 
C31455         MOVE WS-CURR-TIME-MM TO WS-CA410-TIME-MM                 
C31455         MOVE WS-CURR-TIME-SS TO WS-CA410-TIME-SS                 
               PERFORM 0200-GET-LAST-RUNDATE     THRU 0200-EXIT         
C31455         PERFORM 4500-WRITE-BEGIN-CONTROLS THRU 4500-EXIT         
C31455     END-IF.                                                      
T34153     INITIALIZE   WS-DELINQ-LIMIT-NULL                            
T34153                  WS-DELINQ-LIMIT                                 
T34153                  C8-DELINQ-CD                                    
C31455     MOVE 'AMT-UCA-MIN' TO C8-DELINQ-CD.                          
C31455     PERFORM 7530-GET-DELINQUENCY-VAL THRU 7530-EXIT.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07860000
C31455******************************************************************07870000
C31455*   0105-PREPARE-FOR-RESTART                                     *07880000
C31455*                                                                *07890000
C31455*        CHECK CSS_RESTART TABLE TO SEE IF THIS IS A RESTART OR  *07900000
C31455*   A NORMAL RUN.  IF A ROW IS FOUND IN THIS TABLE FOR PROGRAM   *07910000
C31455*   PCSCA410, THE RESTART LOGIC IS EXECUTED.  OTHERWISE, NORMAL  *07920000
C31455*   PROCESSING IS FOLLOWED.                                      *07930000
C31455******************************************************************07940000
C31455 0105-PREPARE-FOR-RESTART.                                        
C31455*                                                                 07960000
C31455     MOVE SPACES TO WS-RESTART-DATA.                              
C31455     MOVE PROGRAM-NAME TO RF-NAME-PROGRAM.                        
C31455     MOVE 1 TO RF-PARTITION-NO.                                   
C31455     IF WS-PARM-COMPANY-NO = '01'                                 
C31455         MOVE 1 TO RF-DUP-CNTRL-NO                                
C31455     ELSE                                                         
C31455         MOVE 2 TO RF-DUP-CNTRL-NO                                
C31455     END-IF.                                                      
C31455*                                                                 08050000
C31455     EXEC SQL                                                     
C31455         SELECT RESTART_DATA                                      
C31455           INTO :RF-RESTART-DATA                                  
C31455           FROM CSS_RESTART                                       
C31455         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
C31455           AND PARTITION_NO = :RF-PARTITION-NO                    
C31455           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 08140000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455         DISPLAY '****************PCSCA410*********************'  
C31455         DISPLAY '**                                         **'  
C31455         DISPLAY '**  ROW FOUND IN CSS_RESTART FOR PCSCA410  **'  
C31455         DISPLAY '**     RESTART LOGIC WILL BE FOLLOWED      **'  
C31455         DISPLAY '**                                         **'  
C31455         DISPLAY '****************PCSCA410*********************'  
C31455         MOVE 'Y' TO WS-RESTART-SW                                
C31455         MOVE RF-RESTART-DATA TO WS-RESTART-DATA-BREAKDOWN        
C31455         PERFORM 0106-RECOVER-FIELDS THRU 0106-EXIT               
C31455         PERFORM 0107-POSITION-FILES THRU 0107-EXIT               
C31455     ELSE                                                         
C31455         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C31455             MOVE 'N' TO WS-RESTART-SW                            
C31455         ELSE                                                     
C31455             DISPLAY '***********PCSCA410*********************'   
C31455             DISPLAY '**  PROCESSING ERROR IN PGM PCSCA410  **'   
C31455             DISPLAY '**  PARA - 0105-PREPARE-FOR-RESTART   **'   
C31455             DISPLAY '**      ERROR DURING SELECT FOR       **'   
C31455             DISPLAY '**             CSS_RESTART            **'   
C31455             DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE            
C31455             DISPLAY '***********PCSCA410*********************'   
C31455             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C31455         END-IF                                                   
C31455     END-IF.                                                      
C31455*                                                                 08410000
C31455 0105-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 08440000
C31455******************************************************************08450000
C31455*   0106-RECOVER-FIELDS                                          *08460000
C31455*        DATA THAT WAS SAVED AT THE TIME OF COMMIT IS MOVED      *08470000
C31455*   BACK TO THE ORIGINAL FIELDS.                                 *08480000
C31455******************************************************************08490000
C31455 0106-RECOVER-FIELDS.                                             
C31455*                                                                 08510000
C31455     MOVE WS-PARM                 TO WS-COMMAND.                  
C31455     MOVE PROGRAM-NAME            TO WS-PROGRAM.                  
C31455     MOVE WS-RESTRT-AC-REC-NO     TO WS-FCA410-REC-CNTR.          
C31455     MOVE WS-RESTRT-GRP-CNTRL-NO  TO WS-GRP-CNTRL-NO.             
C31455     MOVE WS-RESTRT-GROUP-DATE    TO WS-GROUP-DATE.               
C31455     MOVE WS-RESTRT-CSA-ADD       TO WS-FCA410-CSA-ADD.           
C31455     MOVE WS-RESTRT-UCA-ADD       TO WS-FCA410-UCA-ADD.           
C31455     MOVE WS-RESTRT-UCA-PAY       TO WS-FCA410-UCA-PAY.           
C31455     MOVE WS-RESTRT-UCA-PAY-AMT   TO WS-FCA410-UCA-PAY-AMT.       
C31455     MOVE WS-RESTRT-CO-NO         TO WS-COMPANY-PROCESSED         
C31455                                     G6-COMPANY-NO.               
C31455     MOVE WS-RESTRT-INPUT-DATE    TO WS-RUN-DATE.                 
C31455     MOVE WS-RESTRT-LAST-RUN-DATE TO WS-LAST-RUN-DATE.            
C31455     MOVE WS-RESTRT-COMMITS-COUNT TO WS-COMMIT-CTR.               
C31455*                                                                 08660000
C31455 0106-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 08690000
C31455******************************************************************08700000
C31455*   0107-POSITION-FILES                                          *08710000
C31455*       OUTPUT FILES FIOCA410 IS                                 *08720000
C31455*   RESTORED FROM ZERO GENERATIONS CREATED DURING THE BAD        *08730000
C31455*   RUN INTO NEW +1 GENERATION FILES UP TO THE LAST RECORD THAT  *08740000
C31455*   WAS WRITTEN AT THE POINT OF THE LAST COMMIT.                 *08750000
C31455******************************************************************08760000
C31455 0107-POSITION-FILES.                                             
C31455*                                                                 08780000
C31455     OPEN INPUT FIOC410R-FILE.                                    
C31455     IF FCA410R-GOOD-STATUS                                       
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '**********PCSCA410******************'           
C31455         DISPLAY '**    PCSCA410 PROCESSING ERROR   **'           
C31455         DISPLAY '**   FIOC410R-FILE WILL NOT OPEN  **'           
C31455         DISPLAY '**   PARA - 0107-POSITION-FILES   **'           
C31455         DISPLAY '**      PROCESSING TERMINATED     **'           
C31455         DISPLAY '************************************'           
C31455         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
C31455     END-IF.                                                      
C31455*                                                                 08910000
C31455     MOVE 'N' TO WS-EOF-EXISTS.                                   
C31455     PERFORM UNTIL WS-TEMP-REC-CNTR > WS-RESTRT-AC-REC-NO OR      
C31455                   EOF-EXISTS                                     
C31455         READ FIOC410R-FILE INTO FIOCA410-RECORD                  
C31455           AT END                                                 
C31455            MOVE 'Y' TO WS-EOF-EXISTS                             
C31455            IF WS-TEMP-REC-CNTR NOT = WS-RESTRT-AC-REC-NO         
C31455             DISPLAY '*************PCSCA410*********************' 
C31455             DISPLAY '**********0107-POSITION-FILES*************' 
C31455             DISPLAY '**  NO DATA FOUND FOR FILE FIOC410R OR  **' 
C31455             DISPLAY '**  END OF FILE REACHED PREMATURELY.    **' 
C31455             DISPLAY '**  RESTART ROW INDICATES THE NUMBER OF **' 
C31455             DISPLAY '**  ACCOUNT RECORDS SHOULD BE AT LEAST '    
C31455                 WS-RESTRT-AC-REC-NO                              
C31455             DISPLAY '**      PROCESSING TERMINATED           **' 
C31455             DISPLAY '******************************************' 
C31455             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C31455            END-IF                                                
C31455         END-READ                                                 
C31455         IF WS-TEMP-REC-CNTR NOT = WS-RESTRT-AC-REC-NO            
C31455             IF NOT FCA410R-GOOD-STATUS                           
C31455                 DISPLAY '*************PCSCA410***************'   
C31455                 DISPLAY '**    PCSCA410 PROCESSING ERROR   **'   
C31455                 DISPLAY '**   FIOC410R-FILE WILL NOT READ  **'   
C31455                 DISPLAY '**   PARA - 0107-POSITION-FILES   **'   
C31455                 DISPLAY '**      PROCESSING TERMINATED     **'   
C31455                 DISPLAY '************************************'   
C31455                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
C31455             END-IF                                               
C31455         END-IF                                                   
C31455         IF CA410-AC-REC-NO NUMERIC AND NOT-EOF-EXISTS            
C31455             MOVE CA410-AC-REC-NO   TO WS-TEMP-REC-CNTR           
C31455             MOVE CA410-AC-CO-ABBRV TO WS-CO-ABBRV                
C31455         END-IF                                                   
C31455         IF WS-TEMP-REC-CNTR <= WS-RESTRT-AC-REC-NO               
C31455           AND NOT-EOF-EXISTS                                     
C31455             WRITE FIOCA410-RECORD                                
C31455         END-IF                                                   
C31455     END-PERFORM.                                                 
C31455*                                                                 09310000
C31455     CLOSE FIOC410R-FILE.                                         
C31455     IF FCA410R-GOOD-STATUS                                       
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '***************PCSCA410******************'      
C31455         DISPLAY '**  PCSCA410 PROCESSING ERROR          **'      
C31455         DISPLAY '**    CLOSE ERROR OF FIOC410R - INPUT FILE'     
C31455         DISPLAY '**   PARA - 0107-POSITION-FILES         **'     
C31455         DISPLAY '**    FILE STATUS = ' WS-FCA410R-STATUS         
C31455         DISPLAY '******************************************'     
C31455     END-IF.                                                      
C31455*                                                                 09430000
C31455 0107-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 09460000
      ******************************************************************09470000
      * 0200-GET-LAST-RUNDATE                                         **09480000
      *  GETS THE LAST RUN DATE FROM JOB_PARM TABLE                   **09490000
      ******************************************************************09500000
       0200-GET-LAST-RUNDATE.                                           
      *                                                                 09520000
           MOVE SPACES                 TO WS-SYSIPT.                    
           MOVE PROGRAM-NAME           TO WS-PROGRAM.                   
           MOVE WS-PARM                TO WS-COMMAND.                   
           MOVE ZEROS                  TO WS-SEQUENCE.                  
      *                                                                 09570000
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
      *                                                                 09590000
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
             UNTIL (WS-INPUT-DATA-BREAKDOWN(1:14) = 'LAST RUN DATE=')   
                 OR  END-OF-SYSIPT.                                     
      *                                                                 09630000
             EVALUATE TRUE                                              
                WHEN END-OF-SYSIPT                                      
                  DISPLAY '************** PCSCA410 ********************'
                  DISPLAY '** ABEND IN 0200-GET-LAST-RUNDATE         **'
                  DISPLAY '**  PCSCA410 LAST RUN DATE PARM NOT FOUND **'
                  DISPLAY '************** PCSCA410 ********************'
                  PERFORM 9900-ABEND   THRU 9900-EXIT                   
                  DISPLAY ' '                                           
                WHEN OTHER                                              
                  MOVE G6-PARM-DATA    TO WS-PARM-DATA                  
                  DISPLAY ' '                                           
                  DISPLAY '************** PCSCA410 **************'      
                  DISPLAY '**  LAST RUN DATE = ' WS-LAST-RUN-DATE       
                  DISPLAY '************** PCSCA410 **************'      
C31455            MOVE WS-LAST-RUN-DATE TO WS-LAST-RUN-DATE-TS          
C31455            MOVE ZEROS            TO WS-LAST-RUN-HH               
C31455                                     WS-LAST-RUN-MM               
C31455                                     WS-LAST-RUN-SS               
C31455                                     WS-LAST-RUN-MS               
             END-EVALUATE.                                              
      *                                                                 09840000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09870000
C31455******************************************************************09880000
C31455*   0500-COMMIT-DB2-UPDATE                                       *09890000
C31455*        UPDATES TO DB2 ARE COMMITED FOR EVERY 100 RECORDS       *09900000
C31455*   PROCESSED.  ALSO, ONE LAST COMMIT IS DONE AT END OF EACH     *09910000
C31455*   MAIN PARAGRAPH.                                              *09920000
C31455******************************************************************09930000
C31455 0500-COMMIT-DB2-UPDATE.                                          
C31455*                                                                 09950000
C31455     ADD 1 TO WS-COMMIT-CTR.                                      
C31455     PERFORM 0510-UPDATE-RESTART-TABLE THRU 0510-EXIT             
C31455     EXEC SQL                                                     
C31455         COMMIT                                                   
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455     DISPLAY '*** COMMIT POINT # ' WS-COMMIT-CTR ' TAKEN.'        
C31455             '  ACCOUNT NUMBER PROCESSED = ' EX-ACCOUNT-NO        
C31455              ' ***'.                                             
C31455*                                                                 10040000
C31455 0500-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 10070000
C31455******************************************************************10080000
C31455*   0510-UPDATE-RESTART-TABLE                                    *10090000
C31455*        THE RESTART TABLE IS UPDATED WITH A ROW FOR PROGRAM     *10100000
C31455*   PCSCA410 WITH PERTINENT INFORMATION NEEDED TO POSITION FILE  *10110000
C31455*   AND REBUILD OUTPUT FILE  IN CASE A RESTART IS NEEDED.        *10120000
C31455*   IF A ROW FOR PCSCA410 DOES NOT ALREADY EXIST IN CSS_RESTART, *10130000
C31455*   A ROW WILL BE INSERTED.  OTHERWISE, THE EXISTING ROW WILL BE *10140000
C31455*   UPDATED.  THERE WILL ONLY BE ONE ROW IN CSS_RESTART AT ANY   *10150000
C31455*   GIVEN TIME.                                                  *10160000
C31455******************************************************************10170000
C31455 0510-UPDATE-RESTART-TABLE.                                       
C31455*                                                                 10190000
C31455     MOVE 888                   TO WS-RESTRT-DATA-LEN.            
C31455     MOVE SPACES                TO WS-RESTRT-DATA-REST.           
C31455     MOVE EX-ACCOUNT-NO         TO WS-RESTRT-ACCT-NO.             
C31455     MOVE WS-FCA410-REC-CNTR    TO WS-RESTRT-AC-REC-NO.           
C31455     MOVE WS-GRP-CNTRL-NO       TO WS-RESTRT-GRP-CNTRL-NO.        
C31455     MOVE WS-GROUP-DATE         TO WS-RESTRT-GROUP-DATE.          
C31455     MOVE WS-FCA410-CSA-ADD     TO WS-RESTRT-CSA-ADD.             
C31455     MOVE WS-FCA410-UCA-ADD     TO WS-RESTRT-UCA-ADD.             
C31455     MOVE WS-FCA410-UCA-PAY     TO WS-RESTRT-UCA-PAY.             
C31455     MOVE WS-FCA410-UCA-PAY-AMT TO WS-RESTRT-UCA-PAY-AMT.         
C31455     MOVE WS-COMPANY-PROCESSED  TO WS-RESTRT-CO-NO.               
C31455     MOVE WS-RUN-DATE           TO WS-RESTRT-INPUT-DATE           
C31455     MOVE WS-LAST-RUN-DATE      TO WS-RESTRT-LAST-RUN-DATE.       
C31455     MOVE WS-COMMIT-CTR         TO WS-RESTRT-COMMITS-COUNT.       
C31455     MOVE WS-RESTART-DATA       TO RF-RESTART-DATA.               
C31455     MOVE PROGRAM-NAME          TO RF-NAME-PROGRAM.               
C31455     MOVE 1                     TO RF-PARTITION-NO.               
C31455     IF WS-PARM-COMPANY-NO = '01'                                 
C31455         MOVE 1 TO RF-DUP-CNTRL-NO                                
C31455     ELSE                                                         
C31455         MOVE 2 TO RF-DUP-CNTRL-NO                                
C31455     END-IF.                                                      
C31455                                                                  
C31455     EXEC SQL                                                     
C31455         UPDATE CSS_RESTART                                       
C31455            SET RESTART_DATA = :RF-RESTART-DATA                   
C31455          WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
C31455                PARTITION_NO = :RF-PARTITION-NO AND               
C31455                DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C31455             PERFORM 0520-INSERT-RESTART-TABLE THRU 0520-EXIT     
C31455             MOVE 'A' TO WS-JOB-PARM-STATUS                       
C31455             PERFORM 0530-UPDATE-JOB-PARM-TBL  THRU 0530-EXIT     
C31455         ELSE                                                     
C31455             DISPLAY '**************PCSCA410******************'   
C31455             DISPLAY '**  PROCESSING ERROR IN PGM PCSCA410  **'   
C31455             DISPLAY '** PARA -  0510-UPDATE-RESTART-TABLE  **'   
C31455             DISPLAY '**      ERROR DURING UPDATE FOR       **'   
C31455             DISPLAY '**             CSS_RESTART            **'   
C31455             DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE            
C31455             DISPLAY '****************************************'   
C31455             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C31455         END-IF                                                   
C31455     END-IF.                                                      
C31455*                                                                 10700000
C31455 0510-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 10730000
C31455******************************************************************10740000
C31455*   0520-INSERT-RESTART-TABLE                                    *10750000
C31455*        IF A ROW DOES NOT EXIST IN CSS_RESTART FOR PCSCA410,    *10760000
C31455*   ONE IS ADDED.                                                *10770000
C31455******************************************************************10780000
C31455 0520-INSERT-RESTART-TABLE.                                       
C31455*                                                                 10800000
C31455     EXEC SQL                                                     
C31455         INSERT INTO CSS_RESTART                                  
C31455              (NAME_PROGRAM,                                      
C31455               PARTITION_NO,                                      
C31455               DUP_CNTRL_NO,                                      
C31455               RESTART_DATA)                                      
C31455         VALUES                                                   
C31455              (:RF-NAME-PROGRAM,                                  
C31455               :RF-PARTITION-NO,                                  
C31455               :RF-DUP-CNTRL-NO,                                  
C31455               :RF-RESTART-DATA)                                  
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 10930000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '*************PCSCA410*******************'       
C31455         DISPLAY '**  PROCESSING ERROR IN PGM PCSCA410  **'       
C31455         DISPLAY '** PARA -  0520-INSERT-RESTART-TABLE  **'       
C31455         DISPLAY '**      ERROR DURING INSERT FOR       **'       
C31455         DISPLAY '**             CSS_RESTART            **'       
C31455         DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
C31455         DISPLAY '****************************************'       
C31455         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
C31455     END-IF.                                                      
C31455*                                                                 11070000
C31455 0520-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 11100000
C31455******************************************************************11110000
C31455*   0530-UPDATE-JOB-PARM-TBL                                     *11120000
C31455*        UPDATE JOB-PARM TABLE TO INDICATE TO KEEP VSAM UNTIL    *11130000
C31455*   PROGRAM HAS COMPLETED SUCCESSFULLY OR HAS ENDED SUCCESSFULLY *11140000
C31455******************************************************************11150000
C31455 0530-UPDATE-JOB-PARM-TBL.                                        
C31455*                                                                 11170000
C31455     EXEC SQL                                                     
C31455         UPDATE                                                   
C31455            CSS_JOB_PARM                                          
C31455         SET                                                      
C31455            STATUS              = :WS-JOB-PARM-STATUS             
C31455         WHERE                                                    
C31455              PROGRAM_NAME      = :WS-PROGRAM                     
C31455         AND  CMND_CODE         = 'PARM'                          
C31455         AND  COMPANY_NO        = :WS-COMPANY-PROCESSED           
C31455         AND  PARM_DATA         = 'RESTART-REQ=Y'                 
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 11290000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '************PCSCA410********************'       
C31455         DISPLAY '**  PROCESSING ERROR IN PGM PCSCA410  **'       
C31455         DISPLAY '** PARA -  0530-UPDATE-JOB-PARM-TBL   **'       
C31455         DISPLAY '**      ERROR DURING UPDATE FOR       **'       
C31455         DISPLAY '**      CSS_JOB_PARM JOB INDICATOR    **'       
C31455         DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
C31455         DISPLAY '****************************************'       
C31455         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
C31455     END-IF.                                                      
C31455*                                                                 11430000
C31455 0530-EXIT.                                                       
C31455     EXIT.                                                        
      *                                                                 11460000
      ******************************************************************11470000
      *  1000-MAIN-PROCESS-PARA                                        *11480000
      *      CONTROLS MAIN PROCESS                                     *11490000
      ******************************************************************11500000
       1000-MAIN-PROCESS-PARA.                                          
      *                                                                 11520000
C31455     IF WS-RESTART-SW = 'N' OR                                    
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2000')          
C31455         MOVE '2000' TO WS-RESTRT-STEP                            
C31455         MOVE WS-LAST-RUN-DATE TO CH-DATE-UTIL-SVC-STRT           
C31455         MOVE WS-COMPANY-PROCESSED TO AT-COMPANY-NO               
C31455         PERFORM 7000-OPEN-CSA-CURSOR THRU 7000-EXIT              
C31455         PERFORM 7040-FETCH-CSA-CURSOR THRU 7040-EXIT             
C31455         PERFORM 2000-PROCESS-CSA-DATA THRU 2000-EXIT             
                  UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND               
C31455         PERFORM 7080-CLOSE-CSA-CURSOR THRU 7080-EXIT             
C31455     END-IF.                                                      
C31455*                                                                 11640000
C31455     IF WS-RESTART-SW = 'N' OR                                    
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2000') OR       
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2200')          
C31455         MOVE '2200' TO WS-RESTRT-STEP                            
C31455         MOVE WS-COMPANY-PROCESSED TO AT-COMPANY-NO               
C31455         PERFORM 7100-OPEN-UCA-CURSOR THRU 7100-EXIT              
C31455         PERFORM 7140-FETCH-UCA-CURSOR THRU 7140-EXIT             
C31455         PERFORM 2200-PROCESS-UCA-DATA THRU 2200-EXIT             
                  UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND               
C31455         PERFORM 7180-CLOSE-UCA-CURSOR THRU 7180-EXIT             
C31455     END-IF.                                                      
C31455*                                                                 11760000
C31455     IF WS-RESTART-SW = 'N' OR                                    
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2000') OR       
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2200') OR       
C31455       (WS-RESTART-SW = 'Y' AND WS-RESTRT-STEP = '2400')          
C31455         MOVE '2400' TO WS-RESTRT-STEP                            
C31455         MOVE WS-LAST-RUN-TS TO EX-EXCH-SENT-TS                   
C31455         MOVE WS-COMPANY-PROCESSED TO EX-COMPANY-NO               
C31455         MOVE WS-DELINQ-LIMIT TO EX-EXCH-SENT-AM                  
C31455         MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD                        
C31455         PERFORM 7200-OPEN-OLD-UCA-CURSOR THRU 7200-EXIT          
C31455         PERFORM 7240-FETCH-OLD-UCA-CURSOR THRU 7240-EXIT         
C31455         PERFORM 2400-PROCESS-OLD-UCA-DATA THRU 2400-EXIT         
                  UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND               
C31455         PERFORM 7280-CLOSE-OLD-UCA-CURSOR THRU 7280-EXIT         
C31455     END-IF.                                                      
C31455*                                                                 11920000
C31455     MOVE '9999' TO WS-RESTRT-STEP.                               
           PERFORM 7800-UPDATE-JOB-PARM                                 
                                       THRU 7800-EXIT.                  
      *                                                                 11960000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11990000
      ******************************************************************12000000
      *  2000-PROCESS-CSA-DATA                                         *12010000
      *      FIRST STEPS IN PROCESSING THE CSA DATA BY CHECKING CERTAIN*12020000
C31455*      CONDITIONS.                                               *12030000
      ******************************************************************12040000
       2000-PROCESS-CSA-DATA.                                           
C31455     IF WS-RESTART-SW = 'Y' AND                                   
C31455        AT-ACCOUNT-NO <= WS-RESTRT-ACCT-NO                        
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
               PERFORM 2500-CHECK-ACCT-TYPE THRU 2500-EXIT              
C31455         IF WS-RESIDENTIAL-CUST                                   
C31455             PERFORM 2010-CONT-PROCESS-CSA-DATA THRU 2010-EXIT    
C31455         END-IF                                                   
           END-IF.                                                      
      *                                                                 12150000
C31455     PERFORM 7040-FETCH-CSA-CURSOR THRU 7040-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12200000
      ******************************************************************12210000
      *  2010-CONT-PROCESS-CSA-DATA                                    *12220000
      *      SECOND STEP IN PROCESSING CSA DATA.                       *12230000
      ******************************************************************12240000
       2010-CONT-PROCESS-CSA-DATA.                                      
C31455     PERFORM 2550-CHECK-NAME-TYPE THRU 2550-EXIT.                 
C31455     IF WS-INDIVIDUAL-TYPE                                        
C31455         PERFORM 2020-FIN-PROCESS-CSA-DATA THRU 2020-EXIT         
C31455     END-IF.                                                      
      *                                                                 12300000
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12330000
      ******************************************************************12340000
      *  2020-FIN-PROCESS-CSA-DATA                                     *12350000
      *      LAST STEP IN THE PROCESSING OF CSA DATA WHICH IT MOVES    *12360000
      *      FETCHED VALUES TO OUTPUT VARIABLES AND WRITES INTO        *12370000
C31455*      OUTPUT FIOCA410 FILE                                      *12380000
      ******************************************************************12390000
       2020-FIN-PROCESS-CSA-DATA.                                       
C31455     MOVE AT-CUSTOMER-NO TO EX-CUSTOMER-NO.                       
C31455     MOVE AT-ACCOUNT-NO TO EX-ACCOUNT-NO.                         
C31455     MOVE AT-PREMISE-NO TO EX-PREMISE-NO.                         
C31455     MOVE 'CSA' TO EX-EXCH-REC-TYPE-CD.                           
C31455     MOVE 'N' TO WS-ROW-EXISTS.                                   
C31455     PERFORM 7580-CK-DBL-RPTIN-CSA THRU 7580-EXIT.                
C31455     IF ROW-NOT-EXISTS                                            
C31455         PERFORM 2700-GET-ADDRESS-INFO THRU 2700-EXIT             
C31455         MOVE 'C' TO WS-FCA410-ACCT-CD                            
C31455         MOVE '2' TO CA410-AC-TRAN-CD                             
C31455         MOVE CH-DATE-UTIL-SVC-STRT TO WS-WK-DATE                 
C31455         MOVE WS-WK-DATE-CC TO WS-CA410-DATE-CC                   
C31455         MOVE WS-WK-DATE-YY TO WS-CA410-DATE-YY                   
C31455         MOVE WS-WK-DATE-MM TO WS-CA410-DATE-MM                   
C31455         MOVE WS-WK-DATE-DD TO WS-CA410-DATE-DD                   
C31455         MOVE WS-CA410-DATE TO CA410-AC-SERV-CONN-DATE            
C31455         ADD 1 TO WS-FCA410-CSA-ADD                               
C31455         PERFORM 5000-LOAD-FIOCA410    THRU 5000-EXIT             
C31455         MOVE 'CSA' TO EX-EXCH-REC-TYPE-CD                        
C31455         MOVE ZEROES TO EX-EXCH-SENT-AM                           
C31455         PERFORM 7740-SELECT-TIMESTAMP    THRU 7740-EXIT          
C31455         MOVE WS-CURRENT-TIMESTAMP TO EX-EXCH-SENT-TS             
C31455                                      MH-TRANS-HIST-SEQ-NO        
C31455         MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN       
C31455         MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT      
C31455         MOVE +11                TO MI-CHG-COLUMN-VALUE-LEN       
C31455         MOVE EX-EXCH-SENT-AM    TO WS-MI-AMOUNT-VALUE            
C31455         MOVE WS-MI-AMOUNT-VALUE TO MI-CHG-COLUMN-VALUE-TEXT      
C31455         PERFORM 3040-LOAD-EXCH-DATA-SENT  THRU 3040-EXIT         
C31455         PERFORM 3050-LOAD-MNT-TRAN-HIST   THRU 3050-EXIT         
C31455     ELSE                                                         
C31455         IF ROW-EXISTS                                            
C31455            MOVE 'N' TO WS-ROW-EXISTS                             
C31455            PERFORM 7585-CK-FOR-EXISTS THRU 7585-EXIT             
                  IF ROW-NOT-EXISTS                                     
C31455               MOVE 'RPT'   TO EX-EXCH-REC-TYPE-CD                
C31455               MOVE ZEROES  TO EX-EXCH-SENT-AM                    
C31455               MOVE +5      TO MI-PRV-COLUMN-VALUE-LEN            
C31455               MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT           
C31455               MOVE +11     TO MI-CHG-COLUMN-VALUE-LEN            
C31455               MOVE EX-EXCH-SENT-AM    TO WS-MI-AMOUNT-VALUE      
C31455               MOVE WS-MI-AMOUNT-VALUE TO MI-CHG-COLUMN-VALUE-TEXT
C31455               PERFORM 7740-SELECT-TIMESTAMP THRU 7740-EXIT       
C31455               MOVE WS-CURRENT-TIMESTAMP TO EX-EXCH-SENT-TS       
C31455                                            MH-TRANS-HIST-SEQ-NO  
C31455               PERFORM 3040-LOAD-EXCH-DATA-SENT THRU 3040-EXIT    
C31455               PERFORM 3050-LOAD-MNT-TRAN-HIST THRU 3050-EXIT     
C31455            END-IF                                                
               END-IF                                                   
           END-IF.                                                      
      *                                                                 12910000
       2020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12940000
      ******************************************************************12950000
      *  2200-PROCESS-UCA-DATA                                         *12960000
      *      FIRST STEPS IN PROCESSING THE UCA DATA BY CHECKING CERTAIN*12970000
C31455*      CONDITIONS.                                               *12980000
      ******************************************************************12990000
       2200-PROCESS-UCA-DATA.                                           
C31455     IF AT-BANKRUPTCY-IND = ' '                                   
C31455         IF WS-RESTART-SW = 'Y' AND                               
C31455            AT-ACCOUNT-NO <= WS-RESTRT-ACCT-NO                    
C31455             NEXT SENTENCE                                        
C31455         ELSE                                                     
P00599             MOVE 'Y'                    TO KD-FW-PROCESSED-FL    
P00599             PERFORM 8300-UPD-FIN-WO-ACTN-PROC-FL   THRU 8300-EXIT
                   PERFORM 2500-CHECK-ACCT-TYPE THRU 2500-EXIT          
C31455             IF WS-RESIDENTIAL-CUST                               
C31455                 PERFORM 2210-CONT-PROCESS-UCA-DATA THRU 2210-EXIT
C31455             END-IF                                               
C31455         END-IF                                                   
           END-IF.                                                      
      *                                                                 13120000
C31455     PERFORM 7140-FETCH-UCA-CURSOR THRU 7140-EXIT.                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13170000
      ******************************************************************13180000
      *  2210-CONT-PROCESS-UCA-DATA                                    *13190000
      *      SECOND STEP IN PROCESSING UCA DATA.                       *13200000
      ******************************************************************13210000
       2210-CONT-PROCESS-UCA-DATA.                                      
C31455     PERFORM 2550-CHECK-NAME-TYPE THRU 2550-EXIT.                 
C31455     IF WS-INDIVIDUAL-TYPE                                        
C31455         PERFORM 2220-FIN-PROCESS-UCA-DATA THRU 2220-EXIT         
C31455     END-IF.                                                      
      *                                                                 13270000
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13300000
      ******************************************************************13310000
      * 2220-FIN-PROCESS-UCA-DATA                                       13320000
      * PROCESS EXTRACT-ACCT CURSOR FOR UNPAID ACCTS                    13330000
      ******************************************************************13340000
       2220-FIN-PROCESS-UCA-DATA.                                       
C31455     MOVE AT-ACCOUNT-NO TO EX-ACCOUNT-NO.                         
C31455     MOVE AT-CUSTOMER-NO TO EX-CUSTOMER-NO.                       
C31455     MOVE AT-PREMISE-NO TO EX-PREMISE-NO.                         
C31455     MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD.                           
C31455     MOVE 'N' TO WS-ROW-EXISTS.                                   
C31455     PERFORM 7585-CK-FOR-EXISTS THRU 7585-EXIT.                   
C31455     IF ROW-NOT-EXISTS                                            
              IF AT-CODE-ACCT-STAT = WS-B                               
                IF AT-TOTAL-AR-BALANCE >= WS-DELINQ-LIMIT               
C31455             PERFORM 2700-GET-ADDRESS-INFO THRU 2700-EXIT         
                   MOVE AT-TOTAL-AR-BALANCE  TO WS-AMT-CUST-ACCT-BAL    
C31455                                          EX-EXCH-SENT-AM         
C31455                                          CA410-AC-CURR-BAL       
C31455                                          CA410-AC-ORIG-BAL       
C31455                                          WS-CURR-AMOUNT          
C31455             MOVE 'U' TO WS-FCA410-ACCT-CD                        
C31455             MOVE '2' TO CA410-AC-TRAN-CD                         
C31455             PERFORM 2800-GET-BEGIN-END-DATES THRU 2800-EXIT      
C31455             ADD 1 TO WS-FCA410-UCA-ADD                           
C31455             PERFORM 5000-LOAD-FIOCA410 THRU 5000-EXIT            
C31455             MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD                    
C31455             PERFORM 7740-SELECT-TIMESTAMP    THRU 7740-EXIT      
C31455             MOVE WS-CURRENT-TIMESTAMP TO EX-EXCH-SENT-TS         
C31455                                          MH-TRANS-HIST-SEQ-NO    
C31455             MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN      
C31455             MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT     
C31455             MOVE +11             TO MI-CHG-COLUMN-VALUE-LEN      
C31455             MOVE EX-EXCH-SENT-AM TO WS-MI-AMOUNT-VALUE           
C31455             MOVE WS-MI-AMOUNT-VALUE TO MI-CHG-COLUMN-VALUE-TEXT  
C31455             PERFORM 3040-LOAD-EXCH-DATA-SENT  THRU 3040-EXIT     
C30169             PERFORM 8200-UPDATE-FIN-WO-ACTION THRU 8200-EXIT     
C31455             MOVE SPACES              TO WS-MSG-TEXT2             
C31455             PERFORM 3050-LOAD-MNT-TRAN-HIST  THRU 3050-EXIT      
                END-IF                                                  
              ELSE                                                      
                MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT     
                MOVE PROGRAM-NAME TO WS-CPD00068-CALLING-PGM            
                MOVE WS-SPACES TO ABEND-FUNCTION                        
                MOVE WS-RUN-DATE TO WS-HOLD-DATE                        
C30169          MOVE 'Y' TO CALC-PAST-DUE-SW                            
                PERFORM 2600-CALL-SCSCB068 THRU 2600-EXIT               
                IF WS-WO-BALANCE >= WS-DELINQ-LIMIT                     
C31455              PERFORM 2700-GET-ADDRESS-INFO THRU 2700-EXIT        
                    MOVE WS-WO-BALANCE TO WS-AMT-CUST-ACCT-BAL          
C31455                                    EX-EXCH-SENT-AM               
C31455                                    CA410-AC-CURR-BAL             
C31455                                    CA410-AC-ORIG-BAL             
C31455                                    WS-CURR-AMOUNT                
C31455              MOVE 'U' TO WS-FCA410-ACCT-CD                       
C31455              MOVE '2' TO CA410-AC-TRAN-CD                        
C31455              PERFORM 2800-GET-BEGIN-END-DATES THRU 2800-EXIT     
C31455              ADD 1 TO WS-FCA410-UCA-ADD                          
                    PERFORM 5000-LOAD-FIOCA410 THRU 5000-EXIT           
C31455              MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD                   
C31455              PERFORM 7740-SELECT-TIMESTAMP    THRU 7740-EXIT     
C31455              MOVE WS-CURRENT-TIMESTAMP TO EX-EXCH-SENT-TS        
C31455                                           MH-TRANS-HIST-SEQ-NO   
C31455              MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN     
C31455              MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT    
C31455              MOVE +11             TO MI-CHG-COLUMN-VALUE-LEN     
C31455              MOVE EX-EXCH-SENT-AM TO WS-MI-AMOUNT-VALUE          
C31455              MOVE WS-MI-AMOUNT-VALUE TO                          
C31455                                     MI-CHG-COLUMN-VALUE-TEXT     
C31455              PERFORM 3040-LOAD-EXCH-DATA-SENT THRU 3040-EXIT     
C31455              MOVE SPACES              TO WS-MSG-TEXT2            
C31455              PERFORM 3050-LOAD-MNT-TRAN-HIST  THRU 3050-EXIT     
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                 14050000
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14080000
      ******************************************************************14090000
      * 2400-PROCESS-OLD-UCA-DATA                                       14100000
      * PROCESS OLD-UCA-ACCT CURSOR ACCTS CHECKING FOR A BALANCE CHANGE 14110000
      ******************************************************************14120000
       2400-PROCESS-OLD-UCA-DATA.                                       
C31455     IF EX-EXCH-SENT-AM > 0 AND                                   
C31455        EX-ACCOUNT-NO NOT = WS-PREV-UCA-ACCT                      
C31455         PERFORM 2420-FIN-PROCESS-OLD-UCA-DATA THRU 2420-EXIT     
C31455     END-IF.                                                      
      *                                                                 14180000
C31455     MOVE EX-ACCOUNT-NO TO WS-PREV-UCA-ACCT.                      
C31455     MOVE WS-LAST-RUN-TS TO EX-EXCH-SENT-TS.                      
           PERFORM 7240-FETCH-OLD-UCA-CURSOR THRU 7240-EXIT.            
      *                                                                 14220000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14250000
      ******************************************************************14260000
      * 2420-FIN-PROCESS-OLD-UCA-DATA                                   14270000
      * PROCESS OLD-UCA-ACCT CURSOR ACCTS CHECKING FOR A BALANCE CHANGE 14280000
      ******************************************************************14290000
       2420-FIN-PROCESS-OLD-UCA-DATA.                                   
C31455     IF WS-RESTART-SW = 'Y' AND                                   
C31455        EX-ACCOUNT-NO <= WS-RESTRT-ACCT-NO                        
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         MOVE EX-ACCOUNT-NO TO AT-ACCOUNT-NO                      
C31455         PERFORM 7400-GET-ACCT-INFO THRU 7400-EXIT                
               IF AT-TOTAL-AR-BALANCE NOT = EX-EXCH-SENT-AM             
C31455            INITIALIZE CA410-AC-REC                               
                  IF AT-CODE-ACCT-STAT = WS-B                           
C31455                IF AT-TOTAL-AR-BALANCE < 0                        
C31455                   MOVE 0 TO WS-TOTAL-AR-BALANCE                  
C31455                ELSE                                              
C31455                   MOVE AT-TOTAL-AR-BALANCE TO WS-TOTAL-AR-BALANCE
C31455                END-IF                                            
                      MOVE WS-TOTAL-AR-BALANCE TO WS-AMT-CUST-ACCT-BAL  
C31455                                            WS-CURR-AMOUNT        
C31455                ADD WS-TOTAL-AR-BALANCE TO WS-FCA410-UCA-PAY-AMT  
                  ELSE                                                  
                      MOVE WS-Y TO CALC-PAST-DUE-SW                     
                                   CALC-BALANCE-SW                      
                                   CALC-ARREARS-SW                      
                     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT
                      MOVE PROGRAM-NAME TO WS-CPD00068-CALLING-PGM      
                      MOVE WS-SPACES TO ABEND-FUNCTION                  
                      MOVE WS-RUN-DATE TO WS-HOLD-DATE                  
                      PERFORM 2600-CALL-SCSCB068 THRU 2600-EXIT         
C31455                IF WS-WO-BALANCE < 0                              
C31455                    MOVE 0 TO WS-WO-BALANCE                       
C31455                END-IF                                            
                      IF WS-WO-BALANCE = EX-EXCH-SENT-AM                
                          GO TO 2420-EXIT                               
                      END-IF                                            
                      MOVE WS-WO-BALANCE TO WS-AMT-CUST-ACCT-BAL        
C31455                                      WS-CURR-AMOUNT              
C31455                ADD WS-WO-BALANCE TO WS-FCA410-UCA-PAY-AMT        
                   END-IF                                               
C31455             PERFORM 2700-GET-ADDRESS-INFO THRU 2700-EXIT         
C31455             MOVE 'U' TO WS-FCA410-ACCT-CD                        
P00161             MOVE '6' TO CA410-AC-TRAN-CD                         
C31455             PERFORM 2800-GET-BEGIN-END-DATES THRU 2800-EXIT      
C31455             MOVE AT-ACCOUNT-NO TO EX-ACCOUNT-NO                  
C31455             MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD                    
C31455             IF AT-PREMISE-NO NUMERIC                             
C31455                 MOVE AT-PREMISE-NO TO EX-PREMISE-NO              
C31455             ELSE                                                 
C31455                 MOVE ZEROS         TO EX-PREMISE-NO              
C31455             END-IF                                               
C31455             PERFORM 7540-GET-ORIG-BAL THRU 7540-EXIT             
C31455             MOVE EX-EXCH-SENT-AM TO WS-ORIG-AMOUNT               
C31455             MOVE WS-AMT-CUST-ACCT-BAL TO EX-EXCH-SENT-AM         
P00161                                          CA410-AC-CURR-BAL       
C31455             ADD 1 TO WS-FCA410-UCA-PAY                           
                   PERFORM 5000-LOAD-FIOCA410 THRU 5000-EXIT            
C31455             MOVE 'UCA' TO EX-EXCH-REC-TYPE-CD                    
C31455             PERFORM 7740-SELECT-TIMESTAMP    THRU 7740-EXIT      
C31455             MOVE WS-CURRENT-TIMESTAMP TO EX-EXCH-SENT-TS         
C31455                                          MH-TRANS-HIST-SEQ-NO    
C31455             MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN 
C31455             MOVE WS-ORIG-AMOUNT       TO WS-MI-AMOUNT-VALUE      
C31455             MOVE WS-MI-AMOUNT-VALUE   TO MI-PRV-COLUMN-VALUE-TEXT
C31455             MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN 
C31455             MOVE WS-CURR-AMOUNT       TO WS-MI-AMOUNT-VALUE      
C31455             MOVE WS-MI-AMOUNT-VALUE   TO MI-CHG-COLUMN-VALUE-TEXT
C31455             PERFORM 3040-LOAD-EXCH-DATA-SENT THRU 3040-EXIT      
C31455             MOVE SPACES               TO WS-MSG-TEXT2            
C31455             MOVE WS-MSG-UCA-SENT-UPD2 TO WS-MSG-TEXT2            
C31455             PERFORM 3050-LOAD-MNT-TRAN-HIST  THRU 3050-EXIT      
               END-IF                                                   
           END-IF.                                                      
      *                                                                 15000000
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15030000
      ***************************************************************** 15040000
      * 2500-CHECK-ACCT-TYPE.                                         * 15050000
      *     CHECKS ACCOUNT TO SEE IF IT IS A RESIDENTIAL ACCOUNT.     * 15060000
      ***************************************************************** 15070000
       2500-CHECK-ACCT-TYPE.                                            
                                                                        
           MOVE 'N' TO WS-RESIDENTIAL-CUST-FLAG.                        
                                                                        
A37061     IF AT-ACCOUNT-TYPE-CODE = 'R'                                
A37061        MOVE 'Y' TO WS-RESIDENTIAL-CUST-FLAG                      
A37061     END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15190000
      * 2550-CHECK-NAME-TYPE.                                         * 15200000
      *     CHECKS ACCOUNT TO SEE IF IT IS A INDIVIDUAL NAME TYPE.    * 15210000
      ***************************************************************** 15220000
       2550-CHECK-NAME-TYPE.                                            
                                                                        
           MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO.                       
           MOVE 'N' TO WS-NAME-FORMAT-TYPE-FLAG.                        
           PERFORM 7320-GET-CUST-INFO THRU 7320-EXIT.                   
           MOVE CU-NAME-ID TO DQ-NAME-ID.                               
           PERFORM 7330-GET-NAME-INFO THRU 7330-EXIT.                   
           IF DQ-NAME-TYPE = 'CN' AND                                   
              DQ-NAME-FORMAT = 'I'                                      
               MOVE 'Y' TO WS-NAME-FORMAT-TYPE-FLAG                     
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15380000
      *  2600-CALL-SCSCB068                                             15390000
      *  CALLING SCSCB068 TO GET THE VALUE OF WS-WO-BALANCE             15400000
      ******************************************************************15410000
       2600-CALL-SCSCB068.                                              
      *                                                                 15430000
C31455     MOVE SPACES       TO  ABEND-FUNCTION.                        
C31455     MOVE PROGRAM-NAME TO WS-CPD00068-CALLING-PGM.                
              CALL WS-SCSCB068  USING  CWS00068-FIELDS,                 
                                       WS-CODES-DATA-PRESENT,           
                                       DCLCSS-ACCOUNT,                  
                                       ABEND-FILE,                      
                                       RS-RETURN-CODE.                  
C31455     IF ABEND-FUNCTION  > SPACES                                  
C31455        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
C31455     END-IF.                                                      
      *                                                                 15540000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15570000
      ******************************************************************15580000
      *  2700-GET-ADDRESS-INFO.                                        *15590000
      *      GETS THE ADDRESS INFORMATION                              *15600000
      ******************************************************************15610000
       2700-GET-ADDRESS-INFO.                                           
C31455     PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
C31455     INITIALIZE CA410-AC-REC.                                     
C31455     MOVE 1 TO CA410-AC-NO-ID-SEGS-CSA.                           
C31455     IF WS-MAIL-ADDR NOT = SPACES                                 
C31455         MOVE 2 TO CA410-AC-NO-AD-SEGS-CSA                        
C31455     ELSE                                                         
C31455         MOVE 1 TO CA410-AC-NO-AD-SEGS-CSA                        
C31455     END-IF.                                                      
      *                                                                 15710000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15740000
      ******************************************************************15750000
      * 2800-GET-BEGIN-END-DATES.                                       15760000
      * PROCESS GETS THE BEGINNING AND ENDING SERVICE DATES.            15770000
      ******************************************************************15780000
       2800-GET-BEGIN-END-DATES.                                        
C31455     MOVE AT-ACCOUNT-NO TO CH-ACCOUNT-NO.                         
C31455     PERFORM 7350-GET-SERVICE-DATES THRU 7350-EXIT.               
C31455     MOVE CH-DATE-UTIL-SVC-END TO WS-WK-DATE.                     
C31455     MOVE WS-WK-DATE-CC TO WS-CA410-DATE-CC.                      
C31455     MOVE WS-WK-DATE-YY TO WS-CA410-DATE-YY.                      
C31455     MOVE WS-WK-DATE-MM TO WS-CA410-DATE-MM.                      
C31455     MOVE WS-WK-DATE-DD TO WS-CA410-DATE-DD.                      
C31455     MOVE WS-CA410-DATE TO CA410-AC-SERV-DISC-DATE.               
C31455     MOVE CH-DATE-UTIL-SVC-STRT TO WS-WK-DATE.                    
C31455     MOVE WS-WK-DATE-CC TO WS-CA410-DATE-CC.                      
C31455     MOVE WS-WK-DATE-YY TO WS-CA410-DATE-YY.                      
C31455     MOVE WS-WK-DATE-MM TO WS-CA410-DATE-MM.                      
C31455     MOVE WS-WK-DATE-DD TO WS-CA410-DATE-DD.                      
C31455     MOVE WS-CA410-DATE TO CA410-AC-SERV-CONN-DATE.               
      *                                                                 15940000
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15970000
C31455******************************************************************15980000
C31455* 3040-LOAD-EXCH-DATA-SENT                                       *15990000
C31455* THIS MODULE LOADS THE CSS_EXCH_DATA_SENT WITH ACCOUNT INFO     *16000000
C31455******************************************************************16010000
C31455 3040-LOAD-EXCH-DATA-SENT.                                        
C31455*                                                                 16030000
C31455     MOVE AT-ACCOUNT-NO           TO EX-ACCOUNT-NO.               
C31455     MOVE AT-CUSTOMER-NO          TO EX-CUSTOMER-NO               
C31455     IF AT-PREMISE-NO NUMERIC                                     
C31455         MOVE AT-PREMISE-NO TO EX-PREMISE-NO                      
C31455     ELSE                                                         
C31455         MOVE ZEROS         TO EX-PREMISE-NO                      
C31455     END-IF.                                                      
C31455     MOVE WS-COMPANY-PROCESSED    TO EX-COMPANY-NO.               
C31455*                                                                 16120000
C31455     PERFORM 8000-INSERT-EXCH-DATA THRU 8000-EXIT.                
C31455*                                                                 16140000
C31455 3040-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 16170000
C31455******************************************************************16180000
C31455* 3050-LOAD-MNT-TRAN-HIST                                        *16190000
C31455* THIS MODULE LOADS TRANSACTION HISTORY FOR                      *16200000
C31455* ACCOUNTS BEING SENT TO EQUIFAX AKA NCTUE.                      *16210000
C31455* THIS PROCEDURE IS USED TO INSERT THE MNT-TRAN-HIST FOR ALL     *16220000
C31455* OTHER PROCEDURES THAT ADDS RECORDS TO FCSCA410 (NCTUE FILE).   *16230000
C31455******************************************************************16240000
C31455 3050-LOAD-MNT-TRAN-HIST.                                         
C31455*                                                                 16260000
C31455     MOVE WS-RUN-DATE             TO MH-DATE-TRANS.               
C31455     MOVE WS-F                    TO MH-CODE-TRAN-TYPE.           
C31455     MOVE WS-019                  TO MH-RESP-AREA-ID.             
C31455     MOVE PROGRAM-NAME            TO MH-APPL-PROGRAM-ID.          
C31455     MOVE WS-SYSTEM               TO MH-USER-ID.                  
C31455     MOVE AT-ACCOUNT-NO           TO MH-ACCOUNT-NO.               
C31455     MOVE ZEROS                   TO MH-CUSTOMER-NO.              
C31455     MOVE ZEROS                   TO MH-PREMISE-NO.               
C31455*                                                                 16350000
C31455     IF EX-EXCH-REC-TYPE-CD = 'CSA'                               
C31455         MOVE WS-MSG-CSA-SENT TO WS-MSG-TEXT                      
C31455         MOVE SPACES          TO WS-MSG-TEXT2                     
C31455     END-IF.                                                      
C31455     IF EX-EXCH-REC-TYPE-CD = 'RPT'                               
C31455         MOVE SPACES           TO WS-MSG-TEXT2                    
C31455         MOVE WS-MSG-RPT-SENT1 TO WS-MSG-TEXT                     
C31455         MOVE WS-MSG-RPT-SENT2 TO WS-MSG-TEXT2                    
C31455     END-IF.                                                      
C31455     IF EX-EXCH-REC-TYPE-CD = 'UCA'                               
C31455         MOVE WS-MSG-UCA-SENT-PT1 TO WS-MSG-TEXT                  
C31455     END-IF.                                                      
C31455*                                                                 16480000
C31455     MOVE WS-MH-MESSAGE           TO MH-TRAN-COMMENT-TEXT.        
C31455     MOVE +107                    TO MH-TRAN-COMMENT-LEN.         
C31455*                                                                 16510000
C31455     MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO            
C31455     MOVE +1                   TO MI-TRAN-APPL-NO                 
C31455     MOVE WS-EXCH-AMOUNT-DESC  TO MI-COLUMN-DESC                  
C31455*                                                                 16550000
C31455     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C31455*                                                                 16570000
C31455 3050-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 16600000
      ***************************************************************** 16610000
      * 4000-MAIL-NAME-ADDRESS                                        * 16620000
      *     TO GET CUSTOMER NAME, ADDRESS, BILLING ADDRESS            * 16630000
      ***************************************************************** 16640000
            EXEC SQL                                                    16650000
                INCLUDE CPD00074                                        16660000
            END-EXEC.                                                   16670000
      *                                                                 16680000
            EXEC SQL                                                    16690000
                INCLUDE CPD00004                                        16700000
            END-EXEC.                                                   16710000
      *                                                                 16720000
C31455******************************************************************16730000
C31455*     4500-WRITE-BEGIN-CONTROLS.                                 *16740000
C31455*     MODULE WRITES THE HEADER FOR THE OUTPUT FILE.              *16750000
C31455******************************************************************16760000
C31455 4500-WRITE-BEGIN-CONTROLS.                                       
C31455*                                                                 16780000
C31455     INITIALIZE CA410-HEADER-REC.                                 
C31455     MOVE '1'                       TO CA410-HDR-REC-TYPE.        
C31455     MOVE 'NC'                      TO CA410-HDR-EXCH-ID.         
C31455     IF WS-COMPANY-PROCESSED = '26'                               
C31455        MOVE 'PSNC' TO CA410-HDR-CO-ABBRV                         
C31455                       WS-CO-ABBRV                                
C31455     ELSE                                                         
C31455        MOVE 'SCEG' TO CA410-HDR-CO-ABBRV                         
C31455                       WS-CO-ABBRV                                
C31455     END-IF.                                                      
C31455     MOVE WS-GROUP-DATE             TO CA410-HDR-GROUP-DATE.      
C31455     MOVE WS-CA410-TIME             TO CA410-HDR-GROUP-TIME.      
C31455     MOVE CA410-HDR-GROUP-DATE-TIME TO CA410-HDR-GRP-CNTRL-NO     
C31455                                       WS-GRP-CNTRL-NO.           
C31455     MOVE 'PASSWORD FROM EQUIXFAX        '                        
C31455                                    TO CA410-HDR-SEC-CODE.        
C31455     PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT.                
C31455*                                                                 16960000
C31455 4500-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 16990000
C31455******************************************************************17000000
C31455*     4550-WRITE-END-CONTROLS.                                   *17010000
C31455*     MODULE WRITES THE TRAILER FOR THE OUTPUT FILE.             *17020000
C31455******************************************************************17030000
C31455 4550-WRITE-END-CONTROLS.                                         
C31455*                                                                 17050000
C31455     INITIALIZE CA410-TRAILER-REC.                                
C31455     MOVE '5'                       TO CA410-TLR-REC-TYPE.        
C31455     MOVE 'NC'                      TO CA410-TLR-EXCH-ID.         
C31455     MOVE WS-CO-ABBRV               TO CA410-TLR-CO-ABBRV.        
C31455     MOVE WS-GROUP-DATE             TO CA410-TLR-GROUP-DATE.      
C31455     MOVE WS-CA410-TIME             TO CA410-TLR-GROUP-TIME.      
C31455     MOVE WS-GRP-CNTRL-NO           TO CA410-TLR-GRP-CNTRL-NO.    
C31455     MOVE HIGH-VALUES               TO CA410-TLR-FILLER2.         
C31455     MOVE WS-FCA410-REC-CNTR        TO CA410-TLR-GRP-TOT-NO.      
C31455     MOVE WS-FCA410-CSA-ADD         TO CA410-TLR-TOT-CSA-ADD.     
C31455     MOVE WS-FCA410-UCA-ADD         TO CA410-TLR-TOT-UCA-ADD.     
C31455     MOVE WS-FCA410-UCA-PAY         TO CA410-TLR-TOT-UCA-PAY.     
C31455     MOVE WS-FCA410-UCA-PAY-AMT     TO CA410-TLR-TOT-UCA-PAY-AMT. 
C31455     PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT.                
C31455*                                                                 17200000
C31455 4550-EXIT.                                                       
C31455     EXIT.                                                        
      *                                                                 17230000
      ******************************************************************17240000
      *  5000-LOAD-FIOCA410                                            *17250000
      *      LOADS DATA INTO THE FIOCA410 FILE AND WRITES INTO         *17260000
C31455*  OUTPUT FIOCA410 FILE                                          *17270000
      ******************************************************************17280000
       5000-LOAD-FIOCA410.                                              
      *                                                                 17300000
C31455     ADD 1 TO WS-FCA410-REC-CNTR.                                 
C31455**** THE FOLLOWING SECTION WRITES AN ACCOUNT SEGMENT ****         17320000
C31455     MOVE '3'                    TO CA410-AC-REC-TYPE.            
C31455     MOVE 'NC'                   TO CA410-AC-EXCH-ID.             
C31455     MOVE WS-CO-ABBRV            TO CA410-AC-CO-ABBRV.            
C31455     MOVE WS-GRP-CNTRL-NO        TO CA410-AC-GRP-CNTRL-NO.        
C31455     MOVE WS-FCA410-ACCT-CD      TO CA410-AC-ACCT-CD.             
C31455     MOVE 'AC'                   TO CA410-AC-SEG-REC-CD.          
C31455     MOVE WS-FCA410-REC-CNTR     TO CA410-AC-REC-NO.              
C31455     MOVE AT-ACCOUNT-NO          TO CA410-AC-ACCT-NUMBER.         
C31455     IF WS-COMPANY-PROCESSED = '26'                               
C31455        MOVE AT-LOCAL-OFFICE TO CA410-AC-LOC-ID                   
C31455        MOVE 'G' TO CA410-AC-SERV-TYPE                            
C31455     ELSE                                                         
C31455        MOVE '001' TO CA410-AC-LOC-ID                             
C31455        MOVE 'E' TO CA410-AC-SERV-TYPE                            
C31455     END-IF.                                                      
C31455     PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT.                
C31455**** THE FOLLOWING SECTION WRITES A CONSUMER ID SEGMENT ****      17490000
C31455     INITIALIZE CA410-AC-REC.                                     
C31455     MOVE '3'                    TO CA410-ID-REC-TYPE.            
C31455     MOVE 'NC'                   TO CA410-ID-EXCH-ID.             
C31455     MOVE WS-CO-ABBRV            TO CA410-ID-CO-ABBRV.            
C31455     IF WS-COMPANY-PROCESSED = '26'                               
C31455        MOVE AT-LOCAL-OFFICE TO CA410-ID-LOC-ID                   
C31455     ELSE                                                         
C31455        MOVE '001' TO CA410-ID-LOC-ID                             
C31455     END-IF.                                                      
C31455     MOVE WS-GRP-CNTRL-NO        TO CA410-ID-GRP-CNTRL-NO.        
C31455     MOVE WS-FCA410-ACCT-CD      TO CA410-ID-ACCT-CD.             
C31455     MOVE 'ID'                   TO CA410-ID-SEG-REC-CD.          
C31455     MOVE WS-FCA410-REC-CNTR     TO CA410-ID-REC-NO.              
C31455     MOVE AT-ACCOUNT-NO          TO CA410-ID-ACCT-NUMBER.         
C31455     MOVE AT-CUSTOMER-NO         TO CE-CUSTOMER-NO.               
C31455     PERFORM 7300-GET-CUST-STATS THRU 7300-EXIT.                  
C31455     IF CE-SSN = SPACES OR LOW-VALUES                             
C31455         MOVE ZEROES TO CA410-ID-NO-CUST-SSNO                     
C31455     ELSE                                                         
C31455         MOVE CE-SSN TO CA410-ID-NO-CUST-SSNO                     
C31455     END-IF.                                                      
C31455     MOVE CE-CODE-STATE-ID       TO CA410-ID-NO-CUST-DRIVER-ST.   
C31455     MOVE CE-DRIVERS-LICENSE-NO  TO CA410-ID-NO-CUST-DRIVER-LIC.  
C31455     IF CE-OTHER-ID = SPACES OR LOW-VALUES                        
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         MOVE 'O'          TO CA410-ID-OTHER-ID-TYPE              
C31455         MOVE CE-OTHER-ID  TO CA410-ID-OTHER-ID-NO                
C31455     END-IF.                                                      
C31455     MOVE CE-EMPLOYER            TO CA410-ID-CUST-EMPL-NAME.      
C31455     MOVE CE-DATE-OF-BIRTH       TO WS-WK-DATE.                   
C31455     MOVE WS-WK-DATE-CC          TO WS-CA410-DATE-CC.             
C31455     MOVE WS-WK-DATE-YY          TO WS-CA410-DATE-YY.             
C31455     MOVE WS-WK-DATE-MM          TO WS-CA410-DATE-MM.             
C31455     MOVE WS-WK-DATE-DD          TO WS-CA410-DATE-DD.             
C31455     MOVE WS-CA410-DATE          TO CA410-ID-BIRTH-DATE.          
      *                                                                 17860000
           MOVE 'N' TO WS-NAME-FOUND-FLAG.                              
           PERFORM VARYING WS-INDEX FROM 1 BY 1 UNTIL                   
             WS-INDEX > 5 OR WS-NAME-FOUND                              
             IF WS-NAME-TYPE(WS-INDEX) = 'CN'                           
               MOVE 'Y' TO WS-NAME-FOUND-FLAG                           
               IF WS-FIRST-NAME(WS-INDEX) = SPACES AND                  
                  WS-LAST-NAME(WS-INDEX) = SPACES                       
C31455             MOVE WS-FULL-NAME(WS-INDEX) TO CA410-ID-NAME-CUST    
               ELSE                                                     
                   MOVE WS-FIRST-NAME(WS-INDEX)                         
C31455                               TO CA410-ID-NAME-CUST-FIR          
                   MOVE WS-MIDDLE-NAME(WS-INDEX)                        
C31455                               TO CA410-ID-NAME-CUST-MID          
                   MOVE WS-LAST-NAME(WS-INDEX)                          
C31455                               TO CA410-ID-NAME-CUST-SUR          
               END-IF                                                   
             END-IF                                                     
           END-PERFORM.                                                 
C31455*                                                                 18050000
           MOVE WS-H1 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
           PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         MOVE CB-PHONE-NO  TO CA410-ID-SERV-PHONE1                
C31455         MOVE 'S'          TO CA410-ID-SERV-PHONE1-TYP            
C31455         MOVE SPACE        TO CA410-ID-SERV-PHONE1-PUBIND         
C31455     END-IF.                                                      
C31455*                                                                 18150000
C31455     MOVE WS-W1 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
C31455     PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455         MOVE CB-PHONE-NO  TO CA410-ID-WORK-PHONE                 
C31455     END-IF.                                                      
C31455*                                                                 18230000
C31455     MOVE WS-A1 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
C31455     PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         MOVE CB-PHONE-NO  TO CA410-ID-SERV-PHONE2                
C31455         MOVE 'O'          TO CA410-ID-SERV-PHONE2-TYP            
C31455         MOVE SPACE        TO CA410-ID-SERV-PHONE2-PUBIND         
C31455     END-IF.                                                      
C31455*                                                                 18330000
C31455     MOVE WS-H2 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
C31455     PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         MOVE CB-PHONE-NO  TO CA410-ID-SERV-PHONE3                
C31455         MOVE 'O'          TO CA410-ID-SERV-PHONE3-TYP            
C31455         MOVE SPACE        TO CA410-ID-SERV-PHONE3-PUBIND         
C31455     END-IF.                                                      
C31455*                                                                 18430000
C31455     MOVE WS-C1 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
C31455     PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         MOVE CB-PHONE-NO  TO CA410-ID-SERV-PHONE4                
C31455         MOVE 'C'          TO CA410-ID-SERV-PHONE4-TYP            
C31455         MOVE SPACE        TO CA410-ID-SERV-PHONE4-PUBIND         
C31455     END-IF.                                                      
C31455*                                                                 18530000
C31455     MOVE WS-F1 TO CB-PHONE-TYPE.                                 
C31455     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
C31455     MOVE AT-CUSTOMER-NO TO CB-CUSTOMER-NO.                       
C31455     PERFORM 7700-SELECT-PHONE-NO THRU 7700-EXIT.                 
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         MOVE CB-PHONE-NO  TO CA410-ID-SERV-PHONE5                
C31455         MOVE 'F'          TO CA410-ID-SERV-PHONE5-TYP            
C31455         MOVE SPACE        TO CA410-ID-SERV-PHONE5-PUBIND         
C31455     END-IF.                                                      
      *                                                                 18630000
C31455     PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT.                
C31455*                                                                 18650000
C31455** THE FOLLOWING SECTION WRITES A CONSUMER ADDRESS SEGMENT **     18660000
C31455** FOR SERVICE ADDRESS                                     **     18670000
C31455     INITIALIZE CA410-AD-REC.                                     
C31455     MOVE '3'                    TO CA410-AD-REC-TYPE.            
C31455     MOVE 'NC'                   TO CA410-AD-EXCH-ID.             
C31455     MOVE WS-CO-ABBRV            TO CA410-AD-CO-ABBRV.            
C31455     IF WS-COMPANY-PROCESSED = '26'                               
C31455        MOVE AT-LOCAL-OFFICE TO CA410-AD-LOC-ID                   
C31455     ELSE                                                         
C31455        MOVE '001' TO CA410-AD-LOC-ID                             
C31455     END-IF.                                                      
C31455     MOVE WS-GRP-CNTRL-NO        TO CA410-AD-GRP-CNTRL-NO.        
C31455     MOVE WS-FCA410-ACCT-CD      TO CA410-AD-ACCT-CD.             
C31455     MOVE 'AD'                   TO CA410-AD-SEG-REC-CD.          
C31455     MOVE WS-FCA410-REC-CNTR     TO CA410-AD-REC-NO.              
C31455     MOVE AT-ACCOUNT-NO          TO CA410-AD-ACCT-NUMBER.         
C31455     MOVE 'S'                    TO CA410-AD-ADDR-TYPE.           
C31455     MOVE 'U'                    TO CA410-AD-ADDR-FORM.           
C31455     MOVE 'A'                    TO CA410-AD-ADDR-COUN.           
C31455     MOVE WS-PR-STREET           TO CA410-AD-LINE1.               
C31455     MOVE WS-PR-ADDR-OVERFLOW    TO CA410-AD-LINE2.               
C31455     MOVE WS-PR-ADDR-CITY-STATE  TO CA410-AD-LINE3.               
C31455     MOVE WS-PR-ADDR-ZIP         TO CA410-AD-ZIP9.                
C31455     PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT.                
      *                                                                 18910000
C31455** THE FOLLOWING SECTION WRITES A CONSUMER ADDRESS SEGMENT **     18920000
C31455** FOR THE BILLING ADDRESS IF DIFFERENT THAN PREMISE ADDR. **     18930000
C31455     IF WS-MAIL-ADDR NOT = SPACES                                 
C31455         INITIALIZE CA410-AD-REC                                  
C31455         MOVE '3'                     TO CA410-AD-REC-TYPE        
C31455         MOVE 'NC'                    TO CA410-AD-EXCH-ID         
C31455         MOVE WS-CO-ABBRV             TO CA410-AD-CO-ABBRV        
C31455         IF WS-COMPANY-PROCESSED = '26'                           
C31455            MOVE AT-LOCAL-OFFICE TO CA410-AD-LOC-ID               
C31455         ELSE                                                     
C31455            MOVE '001' TO CA410-AD-LOC-ID                         
C31455         END-IF                                                   
C31455         MOVE WS-GRP-CNTRL-NO         TO CA410-AD-GRP-CNTRL-NO    
C31455         MOVE WS-FCA410-ACCT-CD       TO CA410-AD-ACCT-CD         
C31455         MOVE 'AD'                    TO CA410-AD-SEG-REC-CD      
C31455         MOVE WS-FCA410-REC-CNTR      TO CA410-AC-REC-NO          
C31455         MOVE AT-ACCOUNT-NO           TO CA410-AD-ACCT-NUMBER     
C31455         MOVE 'B'                     TO CA410-AD-ADDR-TYPE       
C31455         MOVE 'U'                     TO CA410-AD-ADDR-FORM       
C31455         MOVE 'A'                     TO CA410-AD-ADDR-COUN       
C31455         MOVE WS-MAIL-ADDR-STREET     TO CA410-AD-LINE1           
C31455         MOVE WS-MAIL-ADDR-OVERFLOW   TO CA410-AD-LINE2           
C31455         MOVE WS-MAIL-ADDR-CITY-STATE TO CA410-AD-LINE3           
C31455         MOVE WS-MAIL-ADDR-ZIP        TO WS-AD-ZIP5               
C31455         MOVE WS-MAIL-ADDR-ZIP-PLUS-4 TO WS-AD-ZIP4               
C31455         MOVE WS-AD-ZIP9              TO CA410-AD-ZIP9            
C31455         PERFORM 8100-WRITE-CA410-FILE THRU 8100-EXIT             
C31455     END-IF.                                                      
C31455*                                                                 19200000
C31455     PERFORM 8510-CK-COMMIT-WRITE THRU 8510-EXIT.                 
      *                                                                 19220000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19250000
      ***************************************************************** 19260000
      * 6251-GET-FJC01-DATE                                           * 19270000
      ***************************************************************** 19280000
            EXEC SQL                                                    19290000
                INCLUDE CPD00037                                        19300000
            END-EXEC.                                                   19310000
      *                                                                 19320000
C31455******************************************************************19330000
C31455* 6540-INSERT-MNT-TRANS-HIST                                     *19340000
C31455* THIS MODULE INSERT A MAINTENAMCE TRANSACTION HISTORY ROW.      *19350000
C31455******************************************************************19360000
C31455*6540-INSERT-MNT-TRANS-HIST                                       19370000
C31455     EXEC SQL                                                     19380000
C31455         INCLUDE CPD00067                                         19390000
C31455     END-EXEC.                                                    19400000
      *                                                                 19410000
      ***************************************************************** 19420000
      *  7000-OPEN-CSA-CURSOR                                         * 19430000
      *      OPENS CSA CURSOR TO FETCH ACCOUNTS TURNED ON YESTERDAY   * 19440000
      ***************************************************************** 19450000
       7000-OPEN-CSA-CURSOR.                                            
           EXEC SQL                                                     
                OPEN CSA-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19500000
           MOVE SQLCODE                TO  WS-ACTIVE-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '************ PCSCA410 *************'            
               DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7000    **'            
               DISPLAY '**    SQLCODE = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '************ PCSCA410 *************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 19660000
      *  7040-FETCH-CSA-CURSOR                                        * 19670000
      *      FETCHES ACCOUNT NOS THAT WERE TURNED ON YESTERDAY/TODAY  * 19680000
      ***************************************************************** 19690000
       7040-FETCH-CSA-CURSOR.                                           
           EXEC SQL                                                     
                FETCH CSA-CURSOR                                        
                INTO                                                    
                   :AT-ACCOUNT-NO,                                      
                   :AT-CODE-ACCT-STAT,                                  
                   :AT-CUSTOMER-NO,                                     
                   :AT-PREMISE-NO,                                      
A37061             :AT-ACCOUNT-TYPE-CODE,                               
                   :AT-ADDRESS-ID,                                      
                   :AT-ADDRESS-FORMAT,                                  
                   :AT-LOCAL-OFFICE,                                    
                   :CH-DATE-UTIL-SVC-STRT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19840000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 19860000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET MORE-FETCH-FLG       TO TRUE                          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 IF FIRST-FETCH-FLG                                     
                    DISPLAY '************ PCSCA410 ************'        
                    DISPLAY '**  PCSCA410 PROCESSING ERROR   **'        
                    DISPLAY '**  NO DATA EXISTS FOR RUN DATE **'        
                    DISPLAY '**  PARA: 7040-FETCH-CSA-CURSOR **'        
                    DISPLAY '**     PROCESSING TERMINATED    **'        
                    DISPLAY '************ PCSCA410 ************'        
                 END-IF                                                 
              ELSE                                                      
                  DISPLAY '************* PCSCA410 ************'         
                  DISPLAY '**   PCSCA410 PROCESSING ERROR   **'         
                  DISPLAY '**   PARA: 7040-FETCH-CSA-CURSOR **'         
                  DISPLAY '**    ABEND IN PARAGRAPH 7040    **'         
                  DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE    
                  DISPLAY '**    AT-ACCOUNT-NO = ' AT-ACCOUNT-NO        
                  DISPLAY '**     PROCESSING TERMINATED     **'         
                  DISPLAY '************* PCSCA410 ************'         
                  PERFORM 9900-ABEND   THRU 9900-EXIT                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20140000
      ***************************************************************** 20150000
      *  7080-CLOSE-CSA-CURSOR                                        * 20160000
      *      CLOSES CSA-CURSOR                                        * 20170000
      ***************************************************************** 20180000
       7080-CLOSE-CSA-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                CLOSE CSA-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20240000
           MOVE SQLCODE                TO  WS-ACTIVE-RETURN-CODE.       
      *                                                                 20260000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*********** PCSCA410 **************'            
               DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7080    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '*********** PCSCA410 **************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20410000
      ******************************************************************20420000
      *   7100-OPEN-UCA-CURSOR                                         *20430000
      *   OPENS UCA CURSOR                                             *20440000
      ******************************************************************20450000
       7100-OPEN-UCA-CURSOR.                                            
           EXEC SQL                                                     
              OPEN UCA-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20500000
           MOVE SQLCODE                       TO  WS-ACTIVE-RETURN-CODE.
      *                                                                 20520000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ PCSCA410 ************'             
               DISPLAY '** 7100-OPEN-UCA-CURSOR         **'             
               DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA410 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 20630000
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************20660000
      *  7140-FETCH-UCA-CURSOR                                          20670000
      *  FETCHES  UCA-CURSOR                                        *   20680000
      ******************************************************************20690000
       7140-FETCH-UCA-CURSOR.                                           
           EXEC SQL                                                     
              FETCH   UCA-CURSOR                                        
               INTO  :AT-ACCOUNT-NO,                                    
C30169               :KD-ACCOUNT-NO,                                    
C30169               :KD-FW-ACTION-DT,                                  
C30169               :KD-FW-ACTION-TYPE-CD,                             
C30169               :KD-FW-SEQ-NO,                                     
                     :AT-CODE-ACCT-STAT,                                
                     :AT-CUSTOMER-NO,                                   
C31455               :AT-PREMISE-NO,                                    
A37061               :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
C31455               :AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL,        
C31455               :AT-BANKRUPTCY-IND                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20910000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 20930000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C31455         IF WS-ACCT-FINAL-DT-NULL < 0                             
C31455             MOVE WS-SPACES TO AT-ACCT-FINALED-DT                 
C31455         END-IF                                                   
           ELSE                                                         
               DISPLAY '************ PCSCA410 ************'             
               DISPLAY '** 7140-FETCH-UCA-CURSOR        **'             
               DISPLAY '** ACCOUNT NO ', AT-ACCOUNT-NO                  
               DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA410 ************'             
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 21070000
       7140-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************21100000
      *  7180-CLOSE-UCA-CURSOR                                          21110000
      *  CLOSES  UCA-CURSOR                                            *21120000
      ******************************************************************21130000
       7180-CLOSE-UCA-CURSOR.                                           
           EXEC SQL                                                     
              CLOSE UCA-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21180000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 21200000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************ PCSCA410 ************'             
               DISPLAY '** 7180-CLOSE-UCA-CURSOR        **'             
               DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
               DISPLAY '**     PROCESSING TERMINATED    **'             
               DISPLAY '************ PCSCA410 ************'             
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 21310000
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21340000
C31455******************************************************************21350000
C31455*   7200-OPEN-OLD-UCA-CURSOR                                     *21360000
C31455*   OPENS OLD UCA CURSOR                                         *21370000
C31455******************************************************************21380000
C31455 7200-OPEN-OLD-UCA-CURSOR.                                        
C31455     EXEC SQL                                                     
C31455        OPEN OLD-UCA-CURSOR                                       
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 21430000
C31455     MOVE SQLCODE                       TO  WS-ACTIVE-RETURN-CODE.
C31455*                                                                 21450000
C31455     IF  WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL            
C31455         CONTINUE                                                 
C31455     ELSE                                                         
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         DISPLAY '** 7200-OPEN-OLD-UCA-CURSOR     **'             
C31455         DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
C31455         DISPLAY '**  EX-EXCH-SENT-TS = ' EX-EXCH-SENT-TS         
C31455         DISPLAY '**     PROCESSING TERMINATED    **'             
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         PERFORM 9900-ABEND             THRU 9900-EXIT            
C31455     END-IF.                                                      
C31455*                                                                 21570000
C31455 7200-EXIT.                                                       
C31455     EXIT.                                                        
C31455******************************************************************21600000
C31455*  7240-FETCH-OLD-UCA-CURSOR                                      21610000
C31455*  FETCHES OLD-UCA-CURSOR                                         21620000
C31455******************************************************************21630000
C31455 7240-FETCH-OLD-UCA-CURSOR.                                       
C31455     EXEC SQL                                                     
C31455        FETCH   OLD-UCA-CURSOR                                    
C31455         INTO   :EX-ACCOUNT-NO                                    
C31455               ,:EX-COMPANY-NO                                    
C31455               ,:EX-CUSTOMER-NO                                   
C31455               ,:EX-EXCH-REC-TYPE-CD                              
C31455               ,:EX-EXCH-SENT-AM                                  
C31455               ,:EX-EXCH-SENT-TS                                  
C31455               ,:EX-PREMISE-NO                                    
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 21750000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455*                                                                 21770000
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         DISPLAY '** 7240-FETCH-OLD-UCA-CURSOR    **'             
C31455         DISPLAY '** ACCOUNT NO ', EX-ACCOUNT-NO                  
C31455         DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
C31455         DISPLAY '**     PROCESSING TERMINATED    **'             
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         PERFORM 9900-ABEND             THRU 9900-EXIT            
C31455     END-IF.                                                      
C31455*                                                                 21890000
C31455 7240-EXIT.                                                       
C31455     EXIT.                                                        
C31455******************************************************************21920000
C31455*  7280-CLOSE-OLD-UCA-CURSOR                                      21930000
C31455*  CLOSES OLD-UCA-CURSOR                                          21940000
C31455******************************************************************21950000
C31455 7280-CLOSE-OLD-UCA-CURSOR.                                       
C31455     EXEC SQL                                                     
C31455        CLOSE OLD-UCA-CURSOR                                      
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 22000000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455*                                                                 22020000
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         CONTINUE                                                 
C31455     ELSE                                                         
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         DISPLAY '** 7280-CLOSE-OLD-UCA-CURSOR    **'             
C31455         DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
C31455         DISPLAY '**     PROCESSING TERMINATED    **'             
C31455         DISPLAY '************ PCSCA410 ************'             
C31455         PERFORM 9900-ABEND THRU 9900-EXIT                        
C31455     END-IF.                                                      
C31455*                                                                 22130000
C31455 7280-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 22160000
C31455***************************************************************** 22170000
C31455*  7300-GET-CUST-STATS                                          * 22180000
      *       GETS CUST STATS INFORMATION -CUSTOMER STATISTICS        * 22190000
      ***************************************************************** 22200000
C31455 7300-GET-CUST-STATS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
C31455              CODE_STATE_ID,                                      
C31455              EMPLOYER,                                           
C31455              DATE_OF_BIRTH,                                      
                    CUSTOMER_TYPE,                                      
                    DRIVERS_LICENSE_NO,                                 
                    OTHER_ID,                                           
                    EMPLOYER,                                           
                    SSN,                                                
                    NAME_ID                                             
                INTO                                                    
C31455             :CE-CODE-STATE-ID,                                   
C31455             :CE-EMPLOYER,                                        
C31455             :CE-DATE-OF-BIRTH :WS-DATE-OF-BIRTH-NULL,            
                   :CE-CUSTOMER-TYPE,                                   
                   :CE-DRIVERS-LICENSE-NO,                              
                   :CE-OTHER-ID,                                        
                   :CE-EMPLOYER,                                        
                   :CE-SSN,                                             
                   :CE-NAME-ID                                          
                 FROM  CSS_CUST_STATS                                   
                WHERE  CUSTOMER_NO = :CE-CUSTOMER-NO AND                
C31455                 CUSTOMER_TYPE IN ('C')                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22480000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 22500000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-OF-BIRTH-NULL < 0                              
                 MOVE SPACES      TO CE-DATE-OF-BIRTH                   
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES           TO CE-SSN                        
                                          CE-DRIVERS-LICENSE-NO         
                                          CE-OTHER-ID                   
                                          CE-EMPLOYER                   
                                          CE-CUSTOMER-TYPE              
C31455                                    CE-CODE-STATE-ID              
C31455                                    CE-EMPLOYER                   
C31455                                    CE-DATE-OF-BIRTH              
                 MOVE ZERO             TO CE-NAME-ID                    
              ELSE                                                      
               DISPLAY '************* PCSCA410 ************'            
               DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7300    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**    CUSTOMER NUMBER = ' WS-CUSTOMER-NO        
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '************* PCSCA410 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455        END-IF                                                    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C31455***************************************************************** 22810000
C31455*  7320-GET-CUST-INFO                                           * 22820000
C31455*       GETS CUST INFORMATION                                   * 22830000
C31455***************************************************************** 22840000
C31455 7320-GET-CUST-INFO.                                              
C31455                                                                  
C31455     EXEC SQL                                                     
C31455         SELECT                                                   
C31455              NAME_ID                                             
C31455          INTO                                                    
C31455             :CU-NAME-ID                                          
C31455           FROM  CSS_CUSTOMER CU                                  
C31455          WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                    
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 22950000
C31455     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C31455*                                                                 22970000
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455        NEXT SENTENCE                                             
C31455     ELSE                                                         
C31455        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C31455           MOVE ZEROES TO CU-NAME-ID                              
C31455        ELSE                                                      
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C31455         DISPLAY '**    ABEND IN PARAGRAPH 7320    **'            
C31455         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
C31455         DISPLAY '**    CUSTOMER NUMBER = ' WS-CUSTOMER-NO        
C31455         DISPLAY '**    ACCOUNT NUMBER = ' AT-ACCOUNT-NO          
C31455         DISPLAY '**     PROCESSING TERMINATED     **'            
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455        END-IF                                                    
C31455     END-IF.                                                      
C31455                                                                  
C31455 7320-EXIT.                                                       
C31455     EXIT.                                                        
C31455                                                                  
C31455***************************************************************** 23190000
C31455*  7330-GET-NAME-INFO                                           * 23200000
C31455*       GETS CUST INFORMATION                                   * 23210000
C31455***************************************************************** 23220000
C31455 7330-GET-NAME-INFO.                                              
C31455                                                                  
C31455     EXEC SQL                                                     
C31455         SELECT                                                   
C31455             NAME_TYPE                                            
C31455            ,NAME_FORMAT                                          
C31455          INTO                                                    
C31455             :DQ-NAME-TYPE                                        
C31455            ,:DQ-NAME-FORMAT                                      
C31455           FROM  CSS_NAME DQ                                      
C31455          WHERE  NAME_ID = :DQ-NAME-ID                            
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 23350000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455*                                                                 23370000
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455        NEXT SENTENCE                                             
C31455     ELSE                                                         
C31455        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C31455           MOVE SPACES TO DQ-NAME-TYPE                            
C31455                          DQ-NAME-FORMAT                          
C31455        ELSE                                                      
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C31455         DISPLAY '**    ABEND IN PARAGRAPH 7330    **'            
C31455         DISPLAY '**    SQLCODE = ' WS-ACTIVE-RETURN-CODE         
C31455         DISPLAY '**    NAME ID = ' DQ-NAME-ID                    
C31455         DISPLAY '**    ACCOUNT NUMBER = ' AT-ACCOUNT-NO          
C31455         DISPLAY '**     PROCESSING TERMINATED     **'            
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455        END-IF                                                    
C31455     END-IF.                                                      
C31455                                                                  
C31455 7330-EXIT.                                                       
C31455     EXIT.                                                        
C31455                                                                  
C31455***************************************************************** 23600000
C31455*  7350-GET-SERVICE-DATES.                                      * 23610000
C31455*       GETS THE SERVICE DATES FROM CUST PREMISE HIST.          * 23620000
C31455***************************************************************** 23630000
C31455 7350-GET-SERVICE-DATES.                                          
C31455                                                                  
C31455     EXEC SQL                                                     
C31455         SELECT                                                   
C31455              DATE_UTIL_SVC_END                                   
C31455             ,DATE_UTIL_SVC_STRT                                  
C31455          INTO                                                    
C31455             :CH-DATE-UTIL-SVC-END :WS-ACCT-DISCN-DT-NULL         
C31455            ,:CH-DATE-UTIL-SVC-STRT :WS-ACCT-CONN-DT-NULL         
C31455           FROM  CSS_CUST_PREM_HIST                               
C31455          WHERE  ACCOUNT_NO = :CH-ACCOUNT-NO                      
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 23760000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455*                                                                 23780000
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455        IF WS-ACCT-DISCN-DT-NULL < 0                              
C31455           MOVE SPACES TO CH-DATE-UTIL-SVC-END                    
C31455        END-IF                                                    
C31455        IF WS-ACCT-CONN-DT-NULL  < 0                              
C31455           MOVE SPACES TO CH-DATE-UTIL-SVC-STRT                   
C31455        END-IF                                                    
C31455     ELSE                                                         
C31455        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C31455           MOVE SPACES TO CH-DATE-UTIL-SVC-END                    
C31455        ELSE                                                      
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C31455         DISPLAY '**    ABEND IN PARAGRAPH 7350    **'            
C31455         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
C31455         DISPLAY '**    ACCOUNT NUMBER = ' CH-ACCOUNT-NO          
C31455         DISPLAY '**     PROCESSING TERMINATED     **'            
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455        END-IF                                                    
C31455     END-IF.                                                      
C31455                                                                  
C31455 7350-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 24030000
C31455***************************************************************** 24040000
C31455*  7400-GET-ACCT-INFO                                           * 24050000
C31455*       RETRIEVES INFO FROM THE ACCOUNT TABLE.                  * 24060000
C31455***************************************************************** 24070000
C31455 7400-GET-ACCT-INFO.                                              
C31455*                                                                 24090000
C31455     EXEC SQL                                                     
C31455         SELECT                                                   
C31455              AT.CODE_ACCT_STAT                                   
C31455             ,AT.CUSTOMER_NO                                      
C31455             ,AT.PREMISE_NO                                       
C31455             ,AT.ADDRESS_ID                                       
C31455             ,AT.ADDRESS_FORMAT                                   
C31455             ,AT.TOTAL_AR_BALANCE                                 
C31455             ,AT.CODES_DATA_PRESENT                               
C31455             ,AT.COMPANY_NO                                       
C31455             ,AT.LOCAL_OFFICE                                     
C31455             ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
C31455          INTO                                                    
C31455              :AT-CODE-ACCT-STAT                                  
C31455             ,:AT-CUSTOMER-NO                                     
C31455             ,:AT-PREMISE-NO                                      
C31455             ,:AT-ADDRESS-ID                                      
C31455             ,:AT-ADDRESS-FORMAT                                  
C31455             ,:AT-TOTAL-AR-BALANCE                                
C31455             ,:AT-CODES-DATA-PRESENT                              
C31455             ,:AT-COMPANY-NO                                      
C31455             ,:AT-LOCAL-OFFICE                                    
C31455             ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL          
C31455         FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
C31455          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
C31455                                                           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     24100000
MFA-TR*        SELECT                                                   24110000
MFA-TR*             AT.CODE_ACCT_STAT                                   24120000
MFA-TR*            ,AT.CUSTOMER_NO                                      24130000
MFA-TR*            ,AT.PREMISE_NO                                       24140000
MFA-TR*            ,AT.ADDRESS_ID                                       24150000
MFA-TR*            ,AT.ADDRESS_FORMAT                                   24160000
MFA-TR*            ,AT.TOTAL_AR_BALANCE                                 24170000
MFA-TR*            ,AT.CODES_DATA_PRESENT                               24180000
MFA-TR*            ,AT.COMPANY_NO                                       24190000
MFA-TR*            ,AT.LOCAL_OFFICE                                     24200000
MFA-TR*            ,AT.ACCT_FINALED_DT                                  24210000
MFA-TR*         INTO                                                    24220000
MFA-TR*             :AT-CODE-ACCT-STAT                                  24230000
MFA-TR*            ,:AT-CUSTOMER-NO                                     24240000
MFA-TR*            ,:AT-PREMISE-NO                                      24250000
MFA-TR*            ,:AT-ADDRESS-ID                                      24260000
MFA-TR*            ,:AT-ADDRESS-FORMAT                                  24270000
MFA-TR*            ,:AT-TOTAL-AR-BALANCE                                24280000
MFA-TR*            ,:AT-CODES-DATA-PRESENT                              24290000
MFA-TR*            ,:AT-COMPANY-NO                                      24300000
MFA-TR*            ,:AT-LOCAL-OFFICE                                    24310000
MFA-TR*            ,:AT-ACCT-FINALED-DT :WS-ACCT-FINAL-DT-NULL          24320000
MFA-TR*        FROM CSS_ACCOUNT AT                                      24330000
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    24340000
MFA-TR*       WITH UR                                                   24350000
MFA-TR*    END-EXEC.                                                    24360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 24370000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455*                                                                 24390000
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C31455        IF WS-ACCT-FINAL-DT-NULL < 0                              
C31455            MOVE WS-SPACES TO AT-ACCT-FINALED-DT                  
C31455        END-IF                                                    
C31455     ELSE                                                         
C31455        DISPLAY '************* PCSCA410 ************'             
C31455        DISPLAY '**   PCSCA410 PROCESSING ERROR   **'             
C31455        DISPLAY '**    ABEND IN PARAGRAPH 7400    **'             
C31455        DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
C31455        DISPLAY '**    ACCOUNT NUMBER = ' AT-ACCOUNT-NO           
C31455        DISPLAY '**     PROCESSING TERMINATED     **'             
C31455        DISPLAY '************* PCSCA410 ************'             
C31455        PERFORM 9900-ABEND      THRU 9900-EXIT                    
C31455     END-IF.                                                      
C31455*                                                                 24540000
C31455 7400-EXIT.                                                       
C31455     EXIT.                                                        
C31455******************************************************************24570000
C31455*                                                                *24580000
C31455*      7530-GET-DELINQUENCY-VAL                                  *24590000
C31455*                                                                *24600000
C31455******************************************************************24610000
C31455 7530-GET-DELINQUENCY-VAL.                                        
C31455*                                                                 24630000
C31455     EXEC SQL                                                     
C31455        SELECT                                                    
C31455            DELINQ_VALUE                                          
C31455        INTO                                                      
C31455            :WS-DELINQ-LIMIT :WS-DELINQ-LIMIT-NULL                
C31455        FROM CSS_DELINQUENCY                                      
C31455        WHERE DELINQ_CD  = :C8-DELINQ-CD                          
C31455        AND   COMPANY_NO = :C8-COMPANY-NO                         
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C31455         IF WS-DELINQ-LIMIT-NULL < 0                              
C31455             MOVE ZERO        TO WS-DELINQ-LIMIT                  
C31455         END-IF                                                   
C31455     ELSE                                                         
C31455         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         DISPLAY '* 7530 : RETURN CODE ERROR                *'    
C31455         DISPLAY '* DELINQ_CD = ' C8-DELINQ-CD                    
C31455         DISPLAY '* COMPANY # = ' C8-COMPANY-NO                   
C31455         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
C31455         DISPLAY '* PROGRAM ABENDING...                     *'    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         PERFORM 9900-ABEND  THRU  9900-EXIT                      
C31455     END-IF.                                                      
C31455                                                                  
C31455 7530-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 24920000
C31455******************************************************************24930000
C31455*      7540-GET-ORIG-BAL                                         *24940000
C31455*         THIS PROCESS GETS THE ORIGINAL AMOUNT SEND TO NCTUE    *24950000
C31455******************************************************************24960000
C31455 7540-GET-ORIG-BAL.                                               
C31455*                                                                 24980000
C31455     EXEC SQL                                                     
C31455        SELECT EX.EXCH_SENT_AM                                    
C31455          INTO :EX-EXCH-SENT-AM                                   
C31455        FROM CSS_EXCH_DATA_SENT EX WITH(READUNCOMMITTED)                  
C31455        WHERE EX.ACCOUNT_NO = :EX-ACCOUNT-NO                      
C31455          AND EX.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD          
C31455          AND EX.EXCH_SENT_TS = (SELECT MIN(DTP.EXCH_SENT_TS)     
C31455                  FROM CSS_EXCH_DATA_SENT DTP
                           WITH(READUNCOMMITTED)                     
C31455                 WHERE DTP.ACCOUNT_NO = :EX-ACCOUNT-NO AND        
C31455                   DTP.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD AND
C31455                   DTP.PREMISE_NO = :EX-PREMISE-NO)               
C31455          AND EX.PREMISE_NO = :EX-PREMISE-NO                      
C31455                                                           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24990000
MFA-TR*       SELECT EX.EXCH_SENT_AM                                    25000000
MFA-TR*         INTO :EX-EXCH-SENT-AM                                   25010000
MFA-TR*       FROM CSS_EXCH_DATA_SENT EX                                25020000
MFA-TR*       WHERE EX.ACCOUNT_NO = :EX-ACCOUNT-NO                      25030000
MFA-TR*         AND EX.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD          25040000
MFA-TR*         AND EX.EXCH_SENT_TS = (SELECT MIN(DTP.EXCH_SENT_TS)     25050000
MFA-TR*                 FROM CSS_EXCH_DATA_SENT DTP                     25060000
MFA-TR*                WHERE DTP.ACCOUNT_NO = :EX-ACCOUNT-NO AND        25070000
MFA-TR*                  DTP.EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD AND25080000
MFA-TR*                  DTP.PREMISE_NO = :EX-PREMISE-NO)               25090000
MFA-TR*         AND EX.PREMISE_NO = :EX-PREMISE-NO                      25100000
MFA-TR*       WITH UR                                                   25110000
MFA-TR*    END-EXEC.                                                    25120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         DISPLAY '* 7540 : RETURN CODE ERROR                *'    
C31455         DISPLAY '*  ACCOUNT_NO = ' EX-ACCOUNT-NO                 
C31455         DISPLAY '*  PREMISE_NO = ' EX-PREMISE-NO                 
C31455         DISPLAY '*  EXCH_REC_TYPE_CD = ' EX-EXCH-REC-TYPE-CD     
C31455         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
C31455         DISPLAY '* PROGRAM ABENDING...                     *'    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         PERFORM 9900-ABEND  THRU  9900-EXIT                      
C31455     END-IF.                                                      
C31455                                                                  
C31455 7540-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 25310000
C31455******************************************************************25320000
C31455*      7580-CK-DBL-RPTIN-CSA                                     *25330000
C31455*         THIS PROCESS CHECKS TO MAKE SURE THE CUSTOMER IS ONLY  *25340000
C31455*         SENT ONE TIME.                                         *25350000
C31455******************************************************************25360000
C31455 7580-CK-DBL-RPTIN-CSA.                                           
C31455*                                                                 25380000
C31455     EXEC SQL                                                     
C31455        SELECT 'Y'                                                
C31455          INTO :WS-ROW-EXISTS                                     
C31455        FROM CSS_EXCH_DATA_SENT                                   
C31455        WHERE CUSTOMER_NO = :EX-CUSTOMER-NO                       
C31455          AND EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD             
C31455          AND PREMISE_NO = :EX-PREMISE-NO                         
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         DISPLAY '* 7580 : RETURN CODE ERROR                *'    
C31455         DISPLAY '*  ACCOUNT_NO = ' EX-ACCOUNT-NO                 
C31455         DISPLAY '*  CUSTOMER_NO = ' EX-CUSTOMER-NO               
C31455         DISPLAY '*  EXCH_REC_TYPE_CD = ' EX-EXCH-REC-TYPE-CD     
C31455         DISPLAY '*  EXCH_SENT_AM = ' WS-DELINQ-LIMIT             
C31455         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
C31455         DISPLAY '* PROGRAM ABENDING...                     *'    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         PERFORM 9900-ABEND  THRU  9900-EXIT                      
C31455     END-IF.                                                      
C31455                                                                  
C31455 7580-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 25660000
C31455******************************************************************25670000
C31455*      7585-CK-FOR-EXISTS.                                       *25680000
C31455*         THIS PROCESS CHECKS TO SEE IF A CUSTOMER IS SENT.      *25690000
C31455******************************************************************25700000
C31455 7585-CK-FOR-EXISTS.                                              
C31455*                                                                 25720000
C31455     EXEC SQL                                                     
C31455        SELECT TOP(1) 'Y'                                                
C31455          INTO :WS-ROW-EXISTS                                     
C31455        FROM CSS_EXCH_DATA_SENT                                   
C31455        WHERE CUSTOMER_NO = :EX-CUSTOMER-NO                       
C31455          AND EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD             
C31455          AND PREMISE_NO = :EX-PREMISE-NO                         
C31455          AND ACCOUNT_NO = :EX-ACCOUNT-NO                         
C31455                                           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     25730000
MFA-TR*       SELECT 'Y'                                                25740000
MFA-TR*         INTO :WS-ROW-EXISTS                                     25750000
MFA-TR*       FROM CSS_EXCH_DATA_SENT                                   25760000
MFA-TR*       WHERE CUSTOMER_NO = :EX-CUSTOMER-NO                       25770000
MFA-TR*         AND EXCH_REC_TYPE_CD = :EX-EXCH-REC-TYPE-CD             25780000
MFA-TR*         AND PREMISE_NO = :EX-PREMISE-NO                         25790000
MFA-TR*         AND ACCOUNT_NO = :EX-ACCOUNT-NO                         25800000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   25810000
MFA-TR*    END-EXEC.                                                    25820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND OR -811        
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         DISPLAY '* 7585 : RETURN CODE ERROR                *'    
C31455         DISPLAY '*  CUSTOMER_NO = ' EX-CUSTOMER-NO               
C31455         DISPLAY '*  ACCOUNT_NO = ' EX-ACCOUNT-NO                 
C31455         DISPLAY '*  EXCH_REC_TYPE_CD = ' EX-EXCH-REC-TYPE-CD     
C31455         DISPLAY '*  EXCH_SENT_AM = ' WS-DELINQ-LIMIT             
C31455         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
C31455         DISPLAY '* PROGRAM ABENDING...                     *'    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         PERFORM 9900-ABEND  THRU  9900-EXIT                      
C31455     END-IF.                                                      
C31455                                                                  
C31455 7585-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 26020000
      ***************************************************************** 26030000
      * 7600-START-FCSJC01                                            * 26040000
      *     READS JOB PARM TABLE                                      * 26050000
      ***************************************************************** 26060000
            EXEC SQL                                                    26070000
                INCLUDE CPD00038                                        26080000
            END-EXEC.                                                   26090000
      *                                                                 26100000
      ***************************************************************** 26110000
      *  7700-SELECT-PHONE-NO                                         * 26120000
      *       SELECTS CUSTOMER'S RESIDENCE PHONE NUMBER IF ABSENT     * 26130000
      *  SELECTS CUSTOMER'S WORK PHONE                                * 26140000
      ***************************************************************** 26150000
       7700-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
                SELECT PHONE_NO                                         
                  INTO :CB-PHONE-NO                                     
                  FROM  CSS_CUST_PHONE                                  
                 WHERE  CUSTOMER_NO   = :CB-CUSTOMER-NO                 
                   AND  CUSTOMER_TYPE = :CB-CUSTOMER-TYPE               
                   AND  PHONE_TYPE    = :CB-PHONE-TYPE                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO  WS-ACTIVE-RETURN-CODE.       
C31455*                                                                 26280000
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR SUCCESSFUL-CALL  
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '************ PCSCA410 *************'            
C31455         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C31455         DISPLAY '**   ABEND IN PARAGRAPH 7700     **'            
C31455         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
C31455         DISPLAY '**   CB-CUSTOMER-NO   = ' CB-CUSTOMER-NO        
C31455         DISPLAY '**   CB-CUSTOMER-TYPE = ' CB-CUSTOMER-TYPE      
C31455         DISPLAY '**   CB-PHONE-TYPE    = ' CB-PHONE-TYPE         
C31455         DISPLAY '**   PROCESSING TERMINATED       **'            
C31455         DISPLAY '************ PCSCA410 *************'            
C31455         PERFORM 9900-ABEND   THRU 9900-EXIT                      
C31455     END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26460000
C31455******************************************************************26470000
C31455*      7740-SELECT-TIMESTAMP                                     *26480000
C31455******************************************************************26490000
C31455 7740-SELECT-TIMESTAMP.                                           
C31455*                                                                 26510000
C31455     EXEC SQL                                                     
C31455          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     26520000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           26530000
MFA-TR*    END-EXEC.                                                    26540000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 26550000
C31455     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
C31455        NEXT SENTENCE                                             
C31455     ELSE                                                         
C31455         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         DISPLAY '* 7740 : RETURN CODE ERROR                *'    
C31455         DISPLAY '* PARAGRAPH => 7740-SELECT-TIMESTAMP      *'    
C31455         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
C31455         DISPLAY '* PROGRAM ABENDING...                     *'    
C31455         DISPLAY '*****************PCSCA410******************'    
C31455         PERFORM 9900-ABEND  THRU  9900-EXIT                      
C31455     END-IF.                                                      
C31455*                                                                 26680000
C31455 7740-EXIT.                                                       
C31455      EXIT.                                                       
C31455*                                                                 26710000
      ***************************************************************** 26720000
      *  7800-UPDATE-JOB-PARM                                         * 26730000
      *      UPDATES JOB PARM WITH CURRENT DATE                       * 26740000
      ***************************************************************** 26750000
       7800-UPDATE-JOB-PARM.                                            
                                                                        
           MOVE WS-RUN-DATE            TO WS-LAST-RUN-DATE.             
           MOVE WS-PARM-DATA           TO G6-PARM-DATA.                 
           MOVE PROGRAM-NAME           TO G6-PROGRAM-NAME.              
C31455     MOVE 'PARM'                 TO G6-CMND-CODE.                 
C31455     MOVE 1                      TO G6-SEQ-NO.                    
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA    = :G6-PARM-DATA                     
                 WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                  
                   AND CMND_CODE    = :G6-CMND-CODE                     
                   AND COMPANY_NO   = :G6-COMPANY-NO                    
                   AND SEQ_NO       = :G6-SEQ-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO  WS-ACTIVE-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSCA410 ************'            
               DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7800    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '************* PCSCA410 ************'            
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27080000
C31455***************************************************************** 27090000
C31455*  8000-INSERT-EXCH-DATA.                                       * 27100000
C31455*      INSERT EXCHANGE DATA INTO THE CSS_EXCH_DATA_SENT TABLE   * 27110000
C31455***************************************************************** 27120000
C31455 8000-INSERT-EXCH-DATA.                                           
C31455*                                                                 27140000
C31455     EXEC SQL                                                     
C31455          INSERT INTO CSS_EXCH_DATA_SENT                          
C31455                     (ACCOUNT_NO                                  
C31455                     ,EXCH_REC_TYPE_CD                            
C31455                     ,EXCH_SENT_TS                                
C31455                     ,CUSTOMER_NO                                 
C31455                     ,PREMISE_NO                                  
C31455                     ,EXCH_SENT_AM                                
C31455                     ,COMPANY_NO                                  
C31455                     )                                            
C31455           VALUES   (:EX-ACCOUNT-NO                               
C31455                    ,:EX-EXCH-REC-TYPE-CD                         
C31455                    ,CIS.CHAR2TIMESTAMP(:EX-EXCH-SENT-TS)                 
C31455                    ,:EX-CUSTOMER-NO                              
C31455                    ,:EX-PREMISE-NO                               
C31455                    ,:EX-EXCH-SENT-AM                             
C31455                    ,:EX-COMPANY-NO                               
C31455                     )                                            
C31455     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     27150000
MFA-TR*         INSERT INTO CSS_EXCH_DATA_SENT                          27160000
MFA-TR*                    (ACCOUNT_NO                                  27170000
MFA-TR*                    ,EXCH_REC_TYPE_CD                            27180000
MFA-TR*                    ,EXCH_SENT_TS                                27190000
MFA-TR*                    ,CUSTOMER_NO                                 27200000
MFA-TR*                    ,PREMISE_NO                                  27210000
MFA-TR*                    ,EXCH_SENT_AM                                27220000
MFA-TR*                    ,COMPANY_NO                                  27230000
MFA-TR*                    )                                            27240000
MFA-TR*          VALUES   (:EX-ACCOUNT-NO                               27250000
MFA-TR*                   ,:EX-EXCH-REC-TYPE-CD                         27260000
MFA-TR*                   ,:EX-EXCH-SENT-TS                             27270000
MFA-TR*                   ,:EX-CUSTOMER-NO                              27280000
MFA-TR*                   ,:EX-PREMISE-NO                               27290000
MFA-TR*                   ,:EX-EXCH-SENT-AM                             27300000
MFA-TR*                   ,:EX-COMPANY-NO                               27310000
MFA-TR*                    )                                            27320000
MFA-TR*    END-EXEC.                                                    27330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455*                                                                 27340000
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31455     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C31455         CONTINUE                                                 
C31455     ELSE                                                         
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C31455         DISPLAY '**   ABEND IN PARAGRAPH 8000     **'            
C31455         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
C31455         DISPLAY '**   ACCOUNT # = ' EX-ACCOUNT-NO                
C31455         DISPLAY '**   EXCH REC TYPE = ' EX-EXCH-REC-TYPE-CD      
C31455         DISPLAY '**   EXCH SENT TS = ' EX-EXCH-SENT-TS           
C31455         DISPLAY '**   PROCESSING TERMINATED       **'            
C31455         DISPLAY '************* PCSCA410 ************'            
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455     END-IF.                                                      
C31455*                                                                 27500000
C31455 8000-EXIT.                                                       
C31455     EXIT.                                                        
      *                                                                 27530000
      ***************************************************************** 27540000
      *  8100-WRITE-CA410-FILE                                        * 27550000
C31455*      WRITES FIOCA410-RECORD INTO OUTPUT FILE                  * 27560000
      ***************************************************************** 27570000
       8100-WRITE-CA410-FILE.                                           
C31455     WRITE FIOCA410-RECORD.                                       
C31455*                                                                 27600000
C31455     IF FCA410-GOOD-STATUS                                        
C31455         CONTINUE                                                 
C31455     ELSE                                                         
C31455         DISPLAY '*************** ABENDING ***************'       
C31455         DISPLAY '* PARAGRAPH => 8100-WRITE-CA410-FILE   *'       
C31455         DISPLAY '* ERROR - IN WRITING OUTPUT FILE       *'       
C31455         DISPLAY '* STATUS  - ' WS-FCA410-STATUS                  
C31455         DISPLAY '*************** PCSCA410 ****************'      
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455     END-IF.                                                      
C31455*                                                                 27710000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27740000
C30169****************************************************************  27750000
C30169* 8200-UPDATE-FIN-WO-ACTION                                    *  27760000
C30169****************************************************************  27770000
C30169 8200-UPDATE-FIN-WO-ACTION.                                       
C30169     MOVE EX-EXCH-SENT-AM TO KD-FW-ACTION-AM.                     
C30169     EXEC SQL                                                     
C30169        UPDATE CSS_FIN_WO_ACTION                                  
C30169          SET FW_ACTION_AM    = :KD-FW-ACTION-AM                  
C30169        WHERE ACCOUNT_NO      = :KD-ACCOUNT-NO                    
C30169        AND FW_SEQ_NO         = :KD-FW-SEQ-NO                     
C30169        AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                 27870000
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C30169         CONTINUE                                                 
C30169     ELSE                                                         
C30169         DISPLAY '************* PCSCA410 ************'            
C30169         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
C30169         DISPLAY '**   ABEND IN PARAGRAPH 8200     **'            
C30169         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
C30169         DISPLAY '**   ACCOUNT # = 'KD-ACCOUNT-NO                 
C30169         DISPLAY '**   FW_SEQ_NO = 'KD-FW-SEQ-NO                  
C30169         DISPLAY '**   FW_ACTION_TYPE_CD ='KD-FW-ACTION-TYPE-CD   
C30169         DISPLAY '**   PROCESSING TERMINATED       **'            
C30169         DISPLAY '************* PCSCA410 ************'            
C30169         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C30169     END-IF.                                                      
C30169*                                                                 28030000
C30169 8200-EXIT.                                                       
C30169     EXIT.                                                        
P00599******************************************************************28051000
P00599* 8300-UPD-FIN-WO-ACTN-PROC-FL                                   *28053000
P00599******************************************************************28055000
P00599 8300-UPD-FIN-WO-ACTN-PROC-FL.                                    
P00599*                                                                 28057000
P00599     EXEC SQL                                                     
P00599        UPDATE CSS_FIN_WO_ACTION                                  
P00599        SET FW_PROCESSED_FL   = :KD-FW-PROCESSED-FL               
P00599        WHERE ACCOUNT_NO      = :KD-ACCOUNT-NO                    
P00599        AND FW_SEQ_NO         = :KD-FW-SEQ-NO                     
P00599        AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
P00599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00599         CONTINUE                                                 
P00599     ELSE                                                         
P00599         DISPLAY '************* PCSCA410 ************'            
P00599         DISPLAY '**   PCSCA410 PROCESSING ERROR   **'            
P00599         DISPLAY '**   ABEND IN PARAGRAPH 8300     **'            
P00599         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
P00599         DISPLAY '**   ACCOUNT # = 'KD-ACCOUNT-NO                 
P00599         DISPLAY '**   FW_SEQ_NO = 'KD-FW-SEQ-NO                  
P00599         DISPLAY '**   FW_ACTION_TYPE_CD ='KD-FW-ACTION-TYPE-CD   
P00599         DISPLAY '**   PROCESSING TERMINATED       **'            
P00599         DISPLAY '************* PCSCA410 ************'            
P00599         PERFORM 9900-ABEND      THRU 9900-EXIT                   
P00599     END-IF.                                                      
P00599*                                                                 28062400
P00599 8300-EXIT.                                                       
P00599     EXIT.                                                        
C31455*                                                                 28063000
C31455******************************************************************28070000
C31455*                                                                *28080000
C31455*      8510-CK-COMMIT-WRITE.                                     *28090000
C31455*                                                                *28100000
C31455******************************************************************28110000
C31455 8510-CK-COMMIT-WRITE.                                            
C31455*                                                                 28130000
C31455     ADD 1 TO WS-RECS-TO-COMMIT-COUNT.                            
C31455     IF WS-RECS-TO-COMMIT-COUNT > 100                             
C31455         PERFORM 0500-COMMIT-DB2-UPDATE THRU 0500-EXIT            
C31455         MOVE 1 TO WS-RECS-TO-COMMIT-COUNT                        
C31455     END-IF.                                                      
C31455*                                                                 28190000
C31455 8510-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 28220000
A00765****************************************************************  28230000
A00765* 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *  28240000
A00765****************************************************************  28250000
A00765 9000-SEND-ERROR-RESULT.                                          
A00765                                                                  
A00765     GO TO 9000-EXIT.                                             
A00765*                                                                 28290000
      ***************************************************************** 28300000
      *  9000-TERMINATE                                               * 28310000
      *      CLOSES OUTPUT FILE                                       * 28320000
      ***************************************************************** 28330000
       9000-TERMINATE.                                                  
                                                                        
C31455     CLOSE FCSCA410-FILE.                                         
C31455*                                                                 28370000
C31455     IF FCA410-GOOD-STATUS                                        
C31455         CONTINUE                                                 
C31455     ELSE                                                         
C31455         DISPLAY '*************** ABENDING ***************'       
C31455         DISPLAY '* PARAGRAPH => 9000-TERMINATE          *'       
C31455         DISPLAY '* ERROR - IN CLOSING OUTPUT FILE       *'       
C31455         DISPLAY '* STATUS  - ' WS-FCA410-STATUS                  
C31455         DISPLAY '*************** PCSCA410 ****************'      
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455     END-IF.                                                      
C31455*                                                                 28480000
           DISPLAY ' '.                                                 
           DISPLAY '************** PCSCA410 **************'.            
           DISPLAY '** TERMINATING PROGRAM......        **'.            
           DISPLAY '************** PCSCA410 **************'.            
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
C31455*                                                                 28560000
C31455******************************************************************28570000
C31455*   9100-DELETE-RESTART-TABLE                                    *28580000
C31455*                                                                *28590000
C31455*        IF PROGRAM REACHES SUCCESSFUL COMPLETION THE ROW FOR    *28600000
C31455*   PROGRAM PCSCA410 IS DELETED FROM CSS_RESTART TABLE.          *28610000
C31455******************************************************************28620000
C31455                                                                  
C31455 9100-DELETE-RESTART-TABLE.                                       
C31455                                                                  
C31455     MOVE PROGRAM-NAME TO RF-NAME-PROGRAM.                        
C31455     MOVE 1 TO RF-PARTITION-NO.                                   
C31455     IF WS-PARM-COMPANY-NO = '01'                                 
C31455         MOVE 1 TO RF-DUP-CNTRL-NO                                
C31455     ELSE                                                         
C31455         MOVE 2 TO RF-DUP-CNTRL-NO                                
C31455     END-IF.                                                      
C31455                                                                  
C31455     EXEC SQL                                                     
C31455         DELETE FROM CSS_RESTART                                  
C31455         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
C31455           AND PARTITION_NO = :RF-PARTITION-NO                    
C31455           AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
C31455     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31455                                                                  
C31455     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C31455     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C31455         NEXT SENTENCE                                            
C31455     ELSE                                                         
C31455         DISPLAY '*************** ABENDING ***************'       
C31455         DISPLAY '**  PROCESSING ERROR IN PGM PCSCA410  **'       
C31455         DISPLAY '** PARA -  9100-DELETE-RESTART-TABLE  **'       
C31455         DISPLAY '**      ERROR DURING DELETE FOR       **'       
C31455         DISPLAY '**             CSS_RESTART            **'       
C31455         DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
C31455         DISPLAY '************ PCSCA410 ******************'       
C31455         PERFORM 9900-ABEND      THRU 9900-EXIT                   
C31455     END-IF.                                                      
C31455                                                                  
C31455 9100-EXIT.                                                       
C31455     EXIT.                                                        
C31455*                                                                 28970000
      ***************************************************************** 28980000
      *  9700-PROCESS-ABEND                                           * 28990000
      *                                                               * 29000000
      *    THIS PARAGRAPH:                                            * 29010000
      *      1) PROVIDES ABEND LOGIC FOR NAME/ADDRESS ROUTINE         * 29020000
      *                                                               * 29030000
      ***************************************************************** 29040000
       COPY CPD0023B.                                                   29050000
C31455*                                                                 29060000
C31455****************************************************************  29070000
C31455**                                                            **  29080000
C31455**  9900-SQL-ERROR-ROUTINE                                    **  29090000
C31455**                                                            **  29100000
C31455****************************************************************  29110000
C31455 9900-SQL-ERROR-ROUTINE.                                          
C31455*                                                                 29130000
C31455     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C31455     DISPLAY ' '                                                  
C31455     DISPLAY '**********************************************'     
C31455     DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
C31455     DISPLAY '**********************************************'     
C31455     DISPLAY ' '                                                  
C31455     DISPLAY 'SQLCODE = ' WS-ACTIVE-RETURN-CODE.                  
C31455     DISPLAY ABEND-RECORD-1-DATA                                  
C31455     DISPLAY ABEND-RECORD-2-DATA                                  
C31455     DISPLAY ABEND-RECORD-3-DATA                                  
C31455     DISPLAY '**********************************************'.    
C31455     PERFORM 9900-ABEND THRU 9900-EXIT.                           
      ***************************************************************** 29260000
      *  9900-ABEND                                                   * 29270000
      *                                                               * 29280000
      *    THIS PARAGRAPH:                                            * 29290000
      *      1) INCLUDES CPD09900, WHICH IS THE COMMON ABEND          * 29300000
      *         PROCESSING PARAGRAPH                                  * 29310000
      *                                                               * 29320000
      ***************************************************************** 29330000
           EXEC SQL                                                     29340000
             INCLUDE CPD09900                                           29350000
           END-EXEC.                                                    29360000
