       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA406                                         
       DATE-WRITTEN.   04/07/1998.                                      
           AUTHOR.     CBSIMDS.                                         
      ******************************************************************00050000
      **              SOUTH CAROLINA ELECTRIC & GAS                   **00060000
      **         COMPLETE BUSINESS SOLUTIONS INC., MAD                **00070000
      **                                                              **00080000
      *********         CUSTOMER SERVICE SYSTEM            *************00090000
      *********                DB2                         *************00100000
      ******************************************************************00110000
      **                                                              **00120007
      **                  PROGRAM MODIFICATION LOG                    **00130007
      **    DATE     INITIALS        REASON                           **00140007
      **    ____     _________       ______                           **00150007
      **                                                              **00160007
T20282**  6.23.99    KP              THE SERVICE ON-OFF CHECK IS NOT  **00170007
T20282**                             WORKING ALL THE TIMES            **00170007
T22330**  6/20/00    MRL             ADD ADDITIONAL LOGIC TO PICK UP  **        
T22330**                             REV RATES 23, 24, 27, 60 & 61,   **        
T22330**                             AND CREATE A NEW REPORT FOR THESE**        
T22330**                             RATES.                           **        
T22650**  10/09/00   MRL/WM          CHANGED PGM TO SELECT ACCTS BY   **        
T22650**                             REVENUE MONTH INSTEAD OF CALENDAR**        
T22650**                             MONTH                            **        
T22330**  10/26/00   WBM             ADD CODE TO SELECT ALPHA RATES   **        
C36071**                                                              **        
C36071**  08/31/07   SV82012         REPLACED HARD CODED SECURE RATES **        
C36071**                             WITH TABLE LOOKUP AND ADDED NAME **        
C36071**                             CHANGE TRANSACTIONS TO REPORT.   **        
C36071**                             AS PER JOEL COPELAND, REMOVED    **        
C36071**                             RATE-CUR DISPATCH REPORT.        **        
      ******************************************************************00180000
      *                                                                 00190000
       REMARKS.                                                         
                                PCSCA406 NARRATIVE                      
                 EXTRACT THE DETAILS FOR INDUSTRIAL CUSTOMERS           
           THIS PROGRAM READS SEQUENTIALLY THE RECORD OF                
           CSS_RATE_PLAN_DESC TO GET RATE-PLAN-NO WHEN SUM-REVENUE-FLAG 
           IS 'N', FOR EACH SUCH RATE-PLAN IT GETS CUSTOMER ACCOUNT NO  
           FROM CSS_UTIL_ENVRNMT AND EXTRACT THE HISTORY OF TRANSACTIONS
           FOR THAT ACCOUNT NUMBER FROM CSS_MNT_TRANS_HIST WHEN         
           CODE TRANS TYPE IS 'F' AND USING THE SEQ NUMBER IT GETS THE  
           
           IT ALSO GETS THE CUSTOMER NAME AND WRITES IT IN AN           
           OUTPUT RECORD.                                               
                                                                        
              --------BASIC SEQUENCE STRUCTURE----------                
              0000 - 0999      MAIN CONTROL PATH AND INITIALIZATION     
              1000 - 1999      INPUT PROCESSING CONTROL PATH            
              2000 - 2999      OUTPUT PROCESSING CONTROL PATH           
              3000 - 4999      LOCAL COMMON PROCESSING MODULES          
              7000 - 7999      DATABASE ACCESS / INPUT MODULES          
              9000 - 9799      TERMINATION MODULES                      
              9900 - 9999      ABEND / ABORT MODULES                    
      *                                                                 00380000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00420000
       COPY CSSCA406.                                                   00421049
      *                                                                 00450000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00480000
       COPY CFDCA406.                                                   00481049
       COPY FIOCA406.                                                   00482049
      *                                                                 00570000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA406'.
MSQ017     COPY MFASQLM.
      *---COPY BOOK FOR SQLCODES                                        00590023
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.       00591023
       COPY CWS00303.                                                   00600000
      *  ABEND SWITCH COPYBOOK                                          00601023
       COPY CWS09900.                                                   00610000
      *                                                                 00610123
       COPY FIOCA00.                                                    00610357
       COPY FIOJC01.                                                    00610457
      * WORKING STORAGE FOR CPD00074. CREATE MAIL NAME AND ADDRESS.     00611023
       COPY CWS00074.                                                   00620015
      * WORKING STORAGE AREA USED TO REDUCE EMBEDDED BLANKS.            00621023
       COPY CWS00011.                                                   00630015
      * WS ABEND WORK AREA                                              00630123
       COPY CWS00010.                                                   00631020
      *                                                                 00640000
       COPY CWS00038.                                                   00660056
      *-- COPY BOOK TO FORMAT PARM DATA                                 00670056
                                                                        
       COPY CWS00114.                                                   00690056
      *-- COPY BOOK TO READ THE JOB PARM TABLE FOR THE REPORT DATE      00700056
      *                                                                 00710056
       01  WS-VARIABLES.                                                
           05 WS-ACT                       PIC X(01) VALUE 'A'.         
           05 WS-E                         PIC X(01) VALUE 'E'.         
           05 WS-G                         PIC X(01) VALUE 'G'.         
           05 WS-N                         PIC X(01) VALUE 'N'.         
           05 WS-Y                         PIC X(01) VALUE 'Y'.         
           05 WS-F                         PIC X(01) VALUE 'F'.         
C36071     05 WS-ON                        PIC X(03) VALUE 'ON '.       
           05 WS-OFF                       PIC X(03) VALUE 'OFF'.       
C36071     05 WS-SECURED-RATE-FLAG         PIC X(01) VALUE ' '.         
C36071        88 WS-SECURED-RATE                     VALUE 'Y'.         
C36071        88 WS-NOT-SECURED-RATE                 VALUE ' '.         
C36071     05 WS-RATE-PLAN1                PIC X(03) VALUE SPACES.      
C36071     05 WS-RATE-PLAN2                PIC X(03) VALUE SPACES.      
C36071     05 WS-RATE-PLAN3                PIC X(03) VALUE SPACES.      
           05 WS-DISPLAY-RC                PIC S9(4) COMP.              
           05 PROGRAM-NAME                 PIC X(08) VALUE 'PCSCA406'.  
           05 RS-RETURN-CODE               PIC S9(9) VALUE +000 COMP.   
           05 RS-RETURN-CODE-DISP          PIC S9(9) VALUE +000 COMP.   
           05 WS-PGRMNAME                  PIC X(08) VALUE 'PCSCA406'.  
C36071     05 WS-CODE-ACCT-STAT            PIC X(01) VALUE SPACES.      
C36071        88 WS-ACTIVE-STATUS                    VALUE 'A'.         
T22230     05  WS-BN-OPEN-DATE     PIC X(10).                           
T22230     05  WS-BN-CLOSE-DATE    PIC X(10).                           
C36071     05  WS-BN-OPEN-TMST       PIC X(26).                         
C36071     05  WS-BN-OPEN-TMST-RED.                                     
C36071         10 WS-OPEN-TMST-DATE  PIC X(10).                         
C36071         10 WS-LOW-TMST-TIME   PIC X(16) VALUE '-00.00.00.000000'.
C36071     05  WS-BN-CLOSE-TMST      PIC X(26).                         
C36071     05  WS-BN-CLOSE-TMST-RED.                                    
C36071         10 WS-CLOSE-TMST-DATE PIC X(10).                         
C36071         10 WS-HIGH-TMST-TIME  PIC X(16) VALUE '-23.59.59.999999'.
      *                                                                 01000018
T22330 01  WS-REV-MNTH-BREAKDOWN.                                       
T22330     05  WS-REV-MNTH-CHAR.                                        
T22330         10  WS-REVENUE-YEAR     PIC X(04).                       
T22330         10  WS-REVENUE-MONTH    PIC X(02).                       
T22330     05  WS-REV-MNTH-NUM REDEFINES WS-REV-MNTH-CHAR               
T22230                                 PIC 9(06).                       
      *                                                                 01073056
COB305 01 WS-REV-DATE-NUM        PIC S9(6)V USAGE COMP-3 VALUE 0.         
T22330*                                                                 01074057
       01  WS-STATUS.                                                   
           05  WS-FCSCA406-STATUS          PIC X(2).                    
C36071         88  FCA406-SUCCESSFUL       VALUE '00'.                  
      *                                                                 01100000
      *  CSS_RATE_PLAN_DESC.                                            01110013
           EXEC SQL                                                     01120000
             INCLUDE TBRTDESC                                           01130013
           END-EXEC.                                                    01140000
      *                                                                 01150013
      *  CSS_UTIL_ENVRNMT.                                              01160013
           EXEC SQL                                                     01170013
             INCLUDE TBUTLENV                                           01180013
           END-EXEC.                                                    01190013
      *                                                                 01200013
      *  CSS_MNT_TRANS_HIST.                                            01210013
           EXEC SQL                                                     01220013
             INCLUDE TBMNHIST                                           01230013
           END-EXEC.                                                    01240013
      *                                                                 01250013
      *  CSS_MT_TRN_HST_DET.                                            01260013
           EXEC SQL                                                     01270013
             INCLUDE TBMNHDT                                            01280013
           END-EXEC.                                                    01290013
      *                                                                 01310022
           EXEC SQL                                                     01310157
             INCLUDE TBJBPARM                                           01310257
           END-EXEC.                                                    01310357
      *                                                                 01310457
      *  CSS_NAME                                                       01311022
           EXEC SQL                                                     01320000
             INCLUDE TBNAME                                             01330015
           END-EXEC.                                                    01340000
      *                                                                 01350015
      *  CSS_NAME_ACCT_XREF                                             01351022
           EXEC SQL                                                     01360015
             INCLUDE TBNMACTX                                           01370015
           END-EXEC.                                                    01380015
      *                                                                 01381020
      *  CSS_ZIP_CODE                                                   01381122
           EXEC SQL                                                     01382020
             INCLUDE TBZIPCD                                            01383020
           END-EXEC.                                                    01384020
      *                                                                 01390000
      *  CSS_CUST_ADDR_XREF                                             01391022
           EXEC SQL                                                     01400015
             INCLUDE TBCSADRX                                           01410015
           END-EXEC.                                                    01420015
      *                                                                 01421020
      *  CSS_ACCOUNT                                                    01421122
           EXEC SQL                                                     01422020
             INCLUDE TBACCT                                             01423020
           END-EXEC.                                                    01424020
      *                                                                 01430015
      *  CSS_ADDR_FREEFORM                                              01431022
           EXEC SQL                                                     01440015
             INCLUDE TBADRFRE                                           01450015
           END-EXEC.                                                    01460015
      *                                                                 01470015
      *  CSS_ADDR_FORMATTED                                             01471022
           EXEC SQL                                                     01480015
             INCLUDE TBADRFMT                                           01490015
           END-EXEC.                                                    01500015
      *                                                                 01510015
      *  CSS_ACCT_MISC_INFO                                             01511022
           EXEC SQL                                                     01520015
             INCLUDE TBATMISC                                           01530015
           END-EXEC.                                                    01540015
      *                                                                 01550015
T22650*  CSS_BILL_WINDOW                                                01511022
T22650     EXEC SQL                                                             
T22650       INCLUDE TBBILWDW                                                   
T22650     END-EXEC.                                                            
T22330*                                                                         
      *  SQL ERROR VARIABLES.                                           01551022
           EXEC SQL                                                     01560015
             INCLUDE SQLCA                                              01570015
           END-EXEC.                                                    01580015
      *                                                                 01590015
           EXEC SQL                                                     
               DECLARE  MNT_TRN_HIST CURSOR FOR                         
C36071          SELECT  AT.ACCOUNT_NO                                   
C36071                 ,UT.RATE_PLAN_NO                                 
C36071                 ,UT.CODE_UTIL_TYPE                               
C36071                 ,UT.CODE_REVENUE_CLASS                           
C36071                 ,UT.PRV_RATE_PLAN_NO                             
C36071                 ,AT.CODE_ACCT_STAT                               
C36071                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           MI.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                            
C36071                 ,MI.COLUMN_DESC                                  
C36071                 ,MI.PRV_COLUMN_VALUE                             
C36071                 ,MI.CHG_COLUMN_VALUE                             
C36071            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
C36071                 ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)             
C36071                 ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
C36071                 ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
C36071                 ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
C36071           WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     
C36071             AND  MH.TRANS_HIST_SEQ_NO BETWEEN                    
C36071                   CIS.CHAR2TIMESTAMP(:WS-BN-OPEN-TMST) AND 
              CIS.CHAR2TIMESTAMP(:WS-BN-CLOSE-TMST)         
C36071             AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO               
C36071             AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO               
C36071             AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                 
C36071             AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE           
C36071             AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO             
C36071             AND AT.COMPANY_NO      = '01'                        
C36071             AND  RD.SECURED_RATE_FL   = 'Y'                      
C36071             AND  MI.COLUMN_DESC IN ('REVENUE CLASS'              
C36071                                    ,'CODE ACCT STAT'             
C36071                                    ,'BUSINESS NAME')             
C36071          UNION ALL                                               
C36071          SELECT  AT.ACCOUNT_NO                                   
C36071                 ,UT.RATE_PLAN_NO                                 
C36071                 ,UT.CODE_UTIL_TYPE                               
C36071                 ,UT.CODE_REVENUE_CLASS                           
C36071                 ,UT.PRV_RATE_PLAN_NO                             
C36071                 ,AT.CODE_ACCT_STAT                               
C36071                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           MI.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                            
C36071                 ,MI.COLUMN_DESC                                  
C36071                 ,MI.PRV_COLUMN_VALUE                             
C36071                 ,MI.CHG_COLUMN_VALUE                             
C36071            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
C36071                 ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)             
C36071                 ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
C36071                 ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
C36071                 ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
C36071           WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     
C36071             AND  MH.TRANS_HIST_SEQ_NO BETWEEN                    
C36071                   CIS.CHAR2TIMESTAMP(:WS-BN-OPEN-TMST) AND 
              CIS.CHAR2TIMESTAMP(:WS-BN-CLOSE-TMST)         
C36071             AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO               
C36071             AND MH.ACCOUNT_NO      = 0                           
C36071             AND AT.CUSTOMER_NO = MH.CUSTOMER_NO                  
C36071             AND AT.CODE_ACCT_STAT = 'A'                          
C36071             AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                 
C36071             AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE           
C36071             AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO             
C36071             AND AT.COMPANY_NO      = '01'                        
C36071             AND  RD.SECURED_RATE_FL   = 'Y'                      
C36071             AND  MI.COLUMN_DESC = 'BUSINESS NAME'                
C36071          UNION ALL                                               
C36071          SELECT  AT.ACCOUNT_NO                                   
C36071                 ,UT.RATE_PLAN_NO                                 
C36071                 ,UT.CODE_UTIL_TYPE                               
C36071                 ,UT.CODE_REVENUE_CLASS                           
C36071                 ,UT.PRV_RATE_PLAN_NO                             
C36071                 ,AT.CODE_ACCT_STAT                               
C36071                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           MI.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                            
C36071                 ,MI.COLUMN_DESC                                  
C36071                 ,MI.PRV_COLUMN_VALUE                             
C36071                 ,MI.CHG_COLUMN_VALUE                             
C36071            FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)             
C36071                 ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)             
C36071                 ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
C36071                 ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
C36071           WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     
C36071             AND  MH.TRANS_HIST_SEQ_NO BETWEEN                    
C36071                   CIS.CHAR2TIMESTAMP(:WS-BN-OPEN-TMST) AND 
              CIS.CHAR2TIMESTAMP(:WS-BN-CLOSE-TMST)         
C36071             AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO               
C36071             AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO               
C36071             AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                 
C36071             AND AT.COMPANY_NO      = '01'                        
C36071             AND AT.ACCOUNT_TYPE_CODE IN ('I', 'C')               
C36071             AND  MI.COLUMN_DESC = 'RATE PLAN NO'                 
C36071           FOR READ ONLY                                  
C36071     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01598020
MFA-TR*        DECLARE  MNT_TRN_HIST CURSOR FOR                         01599020
MFA-TR*         SELECT  AT.ACCOUNT_NO                                   01590374
MFA-TR*                ,UT.RATE_PLAN_NO                                 01591274
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.CODE_REVENUE_CLASS                                   
MFA-TR*                ,UT.PRV_RATE_PLAN_NO                                     
MFA-TR*                ,AT.CODE_ACCT_STAT                               01599938
MFA-TR*                ,MI.TRANS_HIST_SEQ_NO                            01590774
MFA-TR*                ,MI.COLUMN_DESC                                  01590875
MFA-TR*                ,MI.PRV_COLUMN_VALUE                             01590975
MFA-TR*                ,MI.CHG_COLUMN_VALUE                             01591075
MFA-TR*           FROM  CSS_MNT_TRANS_HIST MH                           01591274
MFA-TR*                ,CSS_MT_TRN_HST_DET MI                           01591375
MFA-TR*                ,CSS_ACCOUNT        AT                           01599938
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                           01599938
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                           01599938
MFA-TR*          WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     01591875
MFA-TR*            AND  MH.TRANS_HIST_SEQ_NO BETWEEN                            
MFA-TR*                  :WS-BN-OPEN-TMST AND :WS-BN-CLOSE-TMST                 
MFA-TR*            AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO                       
MFA-TR*            AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO                       
MFA-TR*            AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                         
MFA-TR*            AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                   
MFA-TR*            AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                     
MFA-TR*            AND AT.COMPANY_NO      = '01'                        01599938
MFA-TR*            AND  RD.SECURED_RATE_FL   = 'Y'                              
MFA-TR*            AND  MI.COLUMN_DESC IN ('REVENUE CLASS'              01591974
MFA-TR*                                   ,'CODE ACCT STAT'             01592074
MFA-TR*                                   ,'BUSINESS NAME')             01592074
MFA-TR*         UNION ALL                                               01592074
MFA-TR*         SELECT  AT.ACCOUNT_NO                                   01590374
MFA-TR*                ,UT.RATE_PLAN_NO                                 01591274
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.CODE_REVENUE_CLASS                                   
MFA-TR*                ,UT.PRV_RATE_PLAN_NO                                     
MFA-TR*                ,AT.CODE_ACCT_STAT                               01599938
MFA-TR*                ,MI.TRANS_HIST_SEQ_NO                            01590774
MFA-TR*                ,MI.COLUMN_DESC                                  01590875
MFA-TR*                ,MI.PRV_COLUMN_VALUE                             01590975
MFA-TR*                ,MI.CHG_COLUMN_VALUE                             01591075
MFA-TR*           FROM  CSS_MNT_TRANS_HIST MH                           01591274
MFA-TR*                ,CSS_MT_TRN_HST_DET MI                           01591375
MFA-TR*                ,CSS_ACCOUNT        AT                           01599938
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                           01599938
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                           01599938
MFA-TR*          WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     01591875
MFA-TR*            AND  MH.TRANS_HIST_SEQ_NO BETWEEN                            
MFA-TR*                  :WS-BN-OPEN-TMST AND :WS-BN-CLOSE-TMST                 
MFA-TR*            AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO                       
MFA-TR*            AND MH.ACCOUNT_NO      = 0                                   
MFA-TR*            AND AT.CUSTOMER_NO = MH.CUSTOMER_NO                          
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                         
MFA-TR*            AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                   
MFA-TR*            AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                     
MFA-TR*            AND AT.COMPANY_NO      = '01'                        01599938
MFA-TR*            AND  RD.SECURED_RATE_FL   = 'Y'                              
MFA-TR*            AND  MI.COLUMN_DESC = 'BUSINESS NAME'                01591974
MFA-TR*         UNION ALL                                               01592074
MFA-TR*         SELECT  AT.ACCOUNT_NO                                   01590374
MFA-TR*                ,UT.RATE_PLAN_NO                                 01591274
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.CODE_REVENUE_CLASS                                   
MFA-TR*                ,UT.PRV_RATE_PLAN_NO                                     
MFA-TR*                ,AT.CODE_ACCT_STAT                               01599938
MFA-TR*                ,MI.TRANS_HIST_SEQ_NO                            01590774
MFA-TR*                ,MI.COLUMN_DESC                                  01590875
MFA-TR*                ,MI.PRV_COLUMN_VALUE                             01590975
MFA-TR*                ,MI.CHG_COLUMN_VALUE                             01591075
MFA-TR*           FROM  CSS_MNT_TRANS_HIST MH                           01591274
MFA-TR*                ,CSS_MT_TRN_HST_DET MI                           01591375
MFA-TR*                ,CSS_ACCOUNT        AT                           01599938
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                           01599938
MFA-TR*          WHERE  MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO     01591875
MFA-TR*            AND  MH.TRANS_HIST_SEQ_NO BETWEEN                            
MFA-TR*                  :WS-BN-OPEN-TMST AND :WS-BN-CLOSE-TMST                 
MFA-TR*            AND AT.ACCOUNT_NO      = UT.ACCOUNT_NO                       
MFA-TR*            AND AT.ACCOUNT_NO      = MH.ACCOUNT_NO                       
MFA-TR*            AND UT.CODE_UTIL_TYPE  IN ('E', 'G')                         
MFA-TR*            AND AT.COMPANY_NO      = '01'                        01599938
MFA-TR*            AND AT.ACCOUNT_TYPE_CODE IN ('I', 'C')               01599938
MFA-TR*            AND  MI.COLUMN_DESC = 'RATE PLAN NO'                 01591974
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    01599938
      *                                                                 01600038
C36071*                                                                 01600038
       PROCEDURE DIVISION.                                              
      *                                                                 01610000
       0000-MAIN-PARA.                                                  
           PERFORM 1000-INITIALISATION-PARA            THRU 1000-EXIT.  
           PERFORM 2000-PROCESS                        THRU 2000-EXIT.  
           PERFORM 9000-TERMINATE                      THRU 9000-EXIT.  
                                                                        
           STOP RUN.                                                    
      *                                                                 01660000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01690016
      ******************************************************************01700024
      *              THIS PROCESS OPENS NEW-FILE . *                    01710042
      ******************************************************************01720024
       1000-INITIALISATION-PARA.                                        
C36071     INITIALIZE HT-ACCOUNT-NO                                     
C36071                AT-CUSTOMER-NO.                                   
C36071*                                                                         
           OPEN OUTPUT FCSCA406.                                        
           IF FCA406-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**       PCSCA406 PROCESSING ERROR        **'   
               DISPLAY '**  OPEN ERROR OF REPORT - OUTPUT FILE    **'   
               DISPLAY '**        FILE STATUS = ' WS-FCSCA406-STATUS    
               DISPLAY '**        PROCESSING TERMINATED           ** '  
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF.                                                      
C36071*                                                                         
C36071     PERFORM 1100-GET-DATE             THRU 1100-EXIT.            
C36071     MOVE WS-BN-OPEN-DATE        TO WS-OPEN-TMST-DATE             
C36071     MOVE WS-BN-CLOSE-DATE       TO WS-CLOSE-TMST-DATE            
C36071     MOVE WS-BN-OPEN-TMST-RED    TO WS-BN-OPEN-TMST               
C36071     MOVE WS-BN-CLOSE-TMST-RED   TO WS-BN-CLOSE-TMST.             
C36071*                                                                         
      *                                                                 01800015
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01820124
       1100-GET-DATE.                                                   
           MOVE SPACES                   TO WS-INPUT-DATA-BREAKDOWN.    
                                                                        
T22230     PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
T2233O*                                                                         
T22230     MOVE WS-PARM-MONTH          TO WS-REVENUE-MONTH.             
T22230     MOVE WS-PARM-YR             TO WS-REVENUE-YEAR.              
T22230     MOVE WS-REV-MNTH-NUM        TO WS-REV-DATE-NUM.              
T22650     EXEC SQL                                                     
T22650       SELECT MAX(DATE_EXTRACT)                                   
T22650             ,MIN(DATE_EXTRACT)                                   
T22650          INTO :WS-BN-CLOSE-DATE                                  
T22650              ,:WS-BN-OPEN-DATE                                   
T22650          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
T22650       WHERE REVENUE_MONTH = :WS-REV-DATE-NUM                     
C36071                                                           
T22330     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(DATE_EXTRACT)                                           
MFA-TR*            ,MIN(DATE_EXTRACT)                                           
MFA-TR*         INTO :WS-BN-CLOSE-DATE                                          
MFA-TR*             ,:WS-BN-OPEN-DATE                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*      WHERE REVENUE_MONTH = :WS-REV-DATE-NUM                             
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22230     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
T22230     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T22230         DISPLAY '********** PCSCA406 DATE  ************'         
T22230         DISPLAY '* DATE PRAMETERS BEING USED          *'         
T22230         DISPLAY '* REVENUE MONTH =' WS-REV-MNTH-CHAR             
T22230         DISPLAY '* OPEN DATE =' WS-BN-OPEN-DATE                  
T22230         DISPLAY '* CLOSE DATE =' WS-BN-CLOSE-DATE                
T22230         DISPLAY '********** PCSCA406 END OF DATES *****'         
T22230     ELSE                                                         
T22230         MOVE SQLCODE            TO WS-DISPLAY-RC                 
T22230         DISPLAY '********** PCSCA406 ABORT ************'         
T22230         DISPLAY '* 1100-GET-DATE FOR BILL WINDOW      *'         
T22230         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
T22230         DISPLAY '* PROGRAM ABORTING...                *'         
T22230         DISPLAY '********** PCSCA406 ABORT ************'         
T22230         PERFORM 9900-ABEND                      THRU 9900-EXIT   
T22230     END-IF.                                                      
                                                                        
           IF END-OF-SYSIPT                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 7611-CLOSE          THRU 7611-EXIT               
           END-IF.                                                      
                                                                        
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 01822424
      ******************************************************************01821024
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE CURSOR MNT_TRN_HIST *01951724
      ******************************************************************01951824
       2000-PROCESS.                                                    
      *                                                                 02070016
C36071     PERFORM 7000-OPEN-MNT-TRN-HIST              THRU 7000-EXIT.  
C36071     PERFORM 7100-FETCH-MNT-TRN-HIST             THRU 7100-EXIT.  
C36071     PERFORM 2100-PROCESS-TRANSACTION    THRU 2100-EXIT           
C36071             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
           PERFORM 7200-CLOSE-MNT-TRN-HIST             THRU 7200-EXIT.  
      *                                                                 02070016
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02073018
C36071*================================================================*02290025
C36071 2100-PROCESS-TRANSACTION.                                        
C36071*================================================================*02290025
C36071*RATE PLAN NO CHANGES STILL NEED TO VERIFY FOR SECURE RATE SINCE  02330016
C36071*MAIN CURSOR NOT CHECKING IN THERE                                02330016
C36071*----------------------------------------------------------------*02290025
C36071     IF MI-COLUMN-DESC = 'RATE PLAN NO'                           
C36071        MOVE UT-RATE-PLAN-NO          TO WS-RATE-PLAN1            
C36071        MOVE MI-PRV-COLUMN-VALUE-TEXT TO WS-RATE-PLAN2            
C36071        MOVE MI-CHG-COLUMN-VALUE-TEXT TO WS-RATE-PLAN3            
C36071        MOVE UT-CODE-UTIL-TYPE      TO RD-CODE-UTIL-TYPE          
C36071        SET WS-NOT-SECURED-RATE     TO TRUE                       
C36071        PERFORM 7825-SECURED-RATES      THRU 7825-EXIT            
C36071     ELSE                                                         
C36071        MOVE UT-RATE-PLAN-NO          TO WS-RATE-PLAN1            
C36071                                         WS-RATE-PLAN2            
C36071                                         WS-RATE-PLAN3            
C36071        SET WS-SECURED-RATE           TO TRUE                     
C36071     END-IF                                                       
C36071     IF WS-SECURED-RATE                                           
C36071        SET WS-NAME-ONLY             TO TRUE                      
C36071        PERFORM 4000-MAIL-NAME-ADDRESS  THRU 4000-EXIT            
C36071        PERFORM 2150-FORMAT-DETAILS     THRU 2150-EXIT            
C36071     END-IF                                                       
C36071     PERFORM 7100-FETCH-MNT-TRN-HIST        THRU 7100-EXIT.       
C36071*                                                                 02330016
C36071 2100-EXIT.                                                       
C36071     EXIT.                                                        
C36071*                                                                 02350125
C36071*===============================================================*         
C36071 2150-FORMAT-DETAILS.                                             
C36071*===============================================================*         
C36071*                                                                         
C36071     MOVE AT-ACCOUNT-NO            TO FCA406-ACCOUNT-NO.          
C36071**   TIME-STAMP TRUNCATED TO MAKE DATE                            02430018
C36071     MOVE MI-TRANS-HIST-SEQ-NO  TO FCA406-TRANS-DATE.             
C36071     MOVE UT-RATE-PLAN-NO          TO FCA406-CUR-RATE             
C36071                                      FCA406-PRE-RATE             
C36071                                      FCA406-NEW-RATE             
C36071*                                                                         
C36071     MOVE WS-CUSTOMER-NAME         TO FCA406-CUR-CUST-NAME        
C36071                                      FCA406-PRE-CUST-NAME        
C36071                                      FCA406-NEW-CUST-NAME        
C36071*                                                                         
C36071     MOVE UT-CODE-REVENUE-CLASS    TO FCA406-CUR-REV-CLASS        
C36071                                      FCA406-PRE-REV-CLASS        
C36071                                      FCA406-NEW-REV-CLASS        
C36071*                                                                         
C36071     IF AT-CODE-ACCT-STAT = WS-ACT                                
C36071        MOVE WS-ON                 TO FCA406-CUR-SRVC-ON-OFF      
C36071                                      FCA406-PRE-SRVC-ON-OFF      
C36071                                      FCA406-NEW-SRVC-ON-OFF      
C36071     ELSE                                                         
C36071        MOVE WS-OFF                TO FCA406-CUR-SRVC-ON-OFF      
C36071                                      FCA406-PRE-SRVC-ON-OFF      
C36071                                      FCA406-NEW-SRVC-ON-OFF      
C36071     END-IF                                                       
C36071*                                                                         
C36071     EVALUATE TRUE                                                
C36071      WHEN MI-COLUMN-DESC = 'RATE PLAN NO'                        
C36071        SET FCA406-RATE-CHANGE        TO TRUE                     
C36071        MOVE MI-PRV-COLUMN-VALUE-TEXT TO FCA406-PRE-RATE          
C36071        MOVE MI-CHG-COLUMN-VALUE-TEXT TO FCA406-NEW-RATE          
C36071*                                                                 02351867
C36071      WHEN MI-COLUMN-DESC = 'REVENUE CLASS'                       
C36071        SET FCA406-CLASS-CHANGE       TO TRUE                     
C36071        MOVE MI-PRV-COLUMN-VALUE-TEXT TO FCA406-PRE-REV-CLASS     
C36071        MOVE MI-CHG-COLUMN-VALUE-TEXT TO FCA406-NEW-REV-CLASS     
C36071*                                                                 02353267
C36071      WHEN MI-COLUMN-DESC = 'CODE ACCT STAT'                      
C36071        SET FCA406-STATUS-CHANGE      TO TRUE                     
C36071*                                                                 02354367
C36071        MOVE MI-CHG-COLUMN-VALUE-TEXT TO WS-CODE-ACCT-STAT        
C36071        IF WS-ACTIVE-STATUS                                       
C36071           MOVE WS-ON                 TO FCA406-NEW-SRVC-ON-OFF   
C36071        ELSE                                                      
C36071           MOVE WS-OFF                TO FCA406-NEW-SRVC-ON-OFF   
C36071        END-IF                                                    
C36071*                                                                 02354367
C36071        MOVE MI-PRV-COLUMN-VALUE-TEXT TO WS-CODE-ACCT-STAT        
C36071        IF WS-ACTIVE-STATUS                                       
C36071           MOVE WS-ON                 TO FCA406-PRE-SRVC-ON-OFF   
C36071        ELSE                                                      
C36071           MOVE WS-OFF                TO FCA406-PRE-SRVC-ON-OFF   
C36071        END-IF                                                    
C36071*                                                                 02354567
C36071      WHEN MI-COLUMN-DESC = 'BUSINESS NAME '                      
C36071        SET FCA406-NAME-CHANGE        TO TRUE                     
C36071        MOVE MI-PRV-COLUMN-VALUE-TEXT TO FCA406-PRE-CUST-NAME     
C36071        MOVE MI-CHG-COLUMN-VALUE-TEXT TO FCA406-NEW-CUST-NAME     
C36071     END-EVALUATE.                                                
C36071*                                                                 02354567
C36071     DISPLAY 'EXTRACTED: ' FCA406-ACCOUNT-NO '|' MI-COLUMN-DESC   
C36071*                                                                 02354567
C36071     PERFORM 2200-WRITE-FCSCA406        THRU 2200-EXIT.           
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 02359871
      ******************************************************************02351025
      * THIS PARA WRITES THE CA406-REC.                                *02360048
      ******************************************************************02361025
       2200-WRITE-FCSCA406.                                             
      *                                                                 02440016
           WRITE CA406-REC.                                             
           MOVE SPACES                     TO CA406-REC.                
                                                                        
C36071     IF  FCA406-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
C36071         DISPLAY '**       PCSCA406 PROCESSING ERROR        **'   
C36071         DISPLAY '**  OPEN ERROR OF REPORT - OUTPUT FILE    **'   
C36071         DISPLAY '**        FILE STATUS = ' WS-FCSCA406-STATUS    
C36071         DISPLAY '**        PROCESSING TERMINATED           ** '  
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF.                                                      
      *                                                                 02520016
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02540125
      ******************************************************************02541025
      ** 6200-GET-PARAMETER-DATE                                      **02541156
      ******************************************************************02981026
           EXEC SQL                                                     02541355
                 INCLUDE CPD00114                                       02541455
           END-EXEC.                                                    02541555
      *                                                                 02542055
      ************************************************************      02542157
      * CPD00038                                                        02542257
      ************************************************************      02542357
      *                                                                 02542457
           EXEC SQL                                                     02542557
               INCLUDE CPD00038                                         02542657
           END-EXEC.                                                    02542757
      *                                                                 02543057
      ******************************************************************02981026
      *        THIS PARA OPENS THE CURSOR MNT_TRN_HIST                 *02982026
      ******************************************************************02983026
       7000-OPEN-MNT-TRN-HIST.                                          
           EXEC SQL                                                     
               OPEN MNT_TRN_HIST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA406 ABORT ************'         
               DISPLAY '* 7000-OPEN-MNT-TRN-HIST             *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
C36071         DISPLAY '* TRANS_HIST_SEQ_NO BETWEEN ' WS-BN-OPEN-TMST   
C36071         DISPLAY '* AND ' WS-BN-CLOSE-TMST                        
C36071         DISPLAY '* CODE_TRAN_TYPE    = ' WS-F                    
C36071         DISPLAY '* COLUMN_DESC IN (REVENUE CLASS  '              
C36071         DISPLAY '*                ,CODE ACCT STAT '              
C36071         DISPLAY '*                ,BUSINESS NAME  '              
C36071         DISPLAY '*                ,RATE PLAN NO)      *'         
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA406 ABORT ************'         
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF.                                                      
      *                                                                 03090014
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03120014
      ******************************************************************        
      * THIS PARA GETS THE ACCOUNT NUMBER FROM TABLE CSS_UTIL_ENVRNMT  *03121126
      ******************************************************************03122026
       7100-FETCH-MNT-TRN-HIST.                                         
           EXEC SQL                                                     
               FETCH  MNT_TRN_HIST                                      
C36071          INTO  :AT-ACCOUNT-NO                                    
C36071               ,:UT-RATE-PLAN-NO                                  
C36071               ,:UT-CODE-UTIL-TYPE                                
C36071               ,:UT-CODE-REVENUE-CLASS                            
C36071               ,:UT-PRV-RATE-PLAN-NO                              
C36071               ,:AT-CODE-ACCT-STAT                                
C36071               ,:MI-TRANS-HIST-SEQ-NO                             
                     ,:MI-COLUMN-DESC                                   
                     ,:MI-PRV-COLUMN-VALUE                              
                     ,:MI-CHG-COLUMN-VALUE                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA406 ABORT ************'         
               DISPLAY '* 7100-FETCH-MNT-TRN-HIST            *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
C36071         DISPLAY '* TRANS_HIST_SEQ_NO BETWEEN ' WS-BN-OPEN-TMST   
C36071         DISPLAY '* AND ' WS-BN-CLOSE-TMST                        
C36071         DISPLAY '* CODE_TRAN_TYPE    = ' WS-F                    
C36071         DISPLAY '* COLUMN_DESC IN (REVENUE CLASS  '              
C36071         DISPLAY '*                ,CODE ACCT STAT '              
C36071         DISPLAY '*                ,BUSINESS NAME  '              
C36071         DISPLAY '*                ,RATE PLAN NO)      *'         
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA406 ABORT ************'         
               PERFORM 9900-ABEND                      THRU 9900-EXIT   
           END-IF.                                                      
      *                                                                 03240015
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03270015
      ******************************************************************        
      *        THIS PARA CLOSES THE CURSOR MNT_TRN_HIST                *03272026
      ******************************************************************03273026
       7200-CLOSE-MNT-TRN-HIST.                                         
           EXEC SQL                                                     
               CLOSE MNT_TRN_HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE SQLCODE            TO WS-DISPLAY-RC                 
               DISPLAY '********** PCSCA406 ABORT ************'         
               DISPLAY '* 7200-CLOSE-MNT-TRN-HIST            *'         
               DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA406 ABORT ************'         
              PERFORM 9900-ABEND                       THRU 9900-EXIT   
           END-IF.                                                      
      *                                                                 03380015
       7200-EXIT.                                                       
           EXIT.                                                        
C36071*                                                                 03550014
C36071*================================================================*        
C36071 7825-SECURED-RATES.                                              
C36071*================================================================*        
C36071* THIS PARA CHECKS IF THE RATE PROCESSED IS A SECURED RATE.      *        
C36071*----------------------------------------------------------------*        
C36071*                                                                 03550014
C36071     EXEC SQL                                                     
C36071         SELECT TOP(1) 'Y'                                               
C36071           INTO :WS-SECURED-RATE-FLAG                             
C36071           FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
C36071          WHERE RD.RATE_PLAN_NO IN                                
C36071               (:WS-RATE-PLAN1, :WS-RATE-PLAN2, :WS-RATE-PLAN3 )  
C36071            AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE            
C36071            AND RD.SECURED_RATE_FL = 'Y'                          
C36071                                       
C36071     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-SECURED-RATE-FLAG                                     
MFA-TR*          FROM CSS_RATE_PLAN_DESC RD                                     
MFA-TR*         WHERE RD.RATE_PLAN_NO IN                                        
MFA-TR*              (:WS-RATE-PLAN1, :WS-RATE-PLAN2, :WS-RATE-PLAN3 )          
MFA-TR*           AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                    
MFA-TR*           AND RD.SECURED_RATE_FL = 'Y'                                  
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36071     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C36071     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C36071         CONTINUE                                                 
C36071     ELSE                                                         
C36071         MOVE SQLCODE        TO WS-DISPLAY-RC                     
C36071         DISPLAY '********** PCSCA406 ABORT ************'         
C36071         DISPLAY '* 7825-SECURED-RATES                 *'         
C36071         DISPLAY '* SQLCODE IS ', WS-DISPLAY-RC                   
C36071         DISPLAY '* PROGRAM ABORTING...                *'         
C36071         DISPLAY '********** PCSCA406 ABORT ************'         
C36071         PERFORM 9900-ABEND                 THRU 9900-EXIT        
C36071     END-IF.                                                      
C36071*                                                                         
C36071 7825-EXIT.                                                       
C36071     EXIT.                                                        
C36071*                                                                         
      ******************************************************************        
      * THIS PARA CLOSES ALL FILES                                     *04590026
      ******************************************************************04600026
       9000-TERMINATE.                                                  
      *                                                                 04611048
           CLOSE FCSCA406.                                              
      *                                                                 04700000
       9000-EXIT.                                                       
           EXIT.                                                        
      * PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.                        04730023
           EXEC SQL                                                     04740000
               INCLUDE CPD09900                                         04750000
           END-EXEC.                                                    04760000
      * CREATE MAIL NAME AND ADDRESS.                                   04770023
           EXEC SQL                                                     04780015
               INCLUDE CPD00074                                         04790015
           END-EXEC.                                                    04800015
      * THE ABEND PROCESSING THAT IS UNIQUE TO A CICS COMPONENT.        04801023
           EXEC SQL                                                     04802020
               INCLUDE CPD0023B                                         04803027
           END-EXEC.                                                    04804020
      *                                                                 04813526
           EXEC SQL                                                     04813626
               INCLUDE CPD0303B                                         04813726
           END-EXEC.                                                    04813826
      * REDUCE EMBEDDED SPACES.                                         04814024
           EXEC SQL                                                     04820015
               INCLUDE CPD00004                                         04830015
           END-EXEC.                                                    04840015
      *                                                                 04850015
