       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA393.                                        
       DATE-WRITTEN.   JAN 1996.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                                                             ** 00120000
      **                  CUSTOMER INFORMATION SYSTEM                ** 00121000
      ***************************************************************** 00140000
      **                  P R O G R A M S U M M A R Y                ** 00150000
      **                                                             ** 00160000
      **                                                             ** 00161000
      **           F U N C T I O N A L   D E S C R I P T I O N       ** 00170000
      **                           O F   M O D U L E                 ** 00171000
      **                                                             ** 00172000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  EXTRACT DATA FOR REPORT PCSRP393.                          ** 00191000
      **                                                             ** 00192000
      **  LOGIC :                                                    ** 00193000
      **                                                             ** 00194000
      **  COMPONENT CA393 WILL READ IN THE COMMON DATE FROM TABLE    ** 00195000
      **  CSS_JOB_PARM AND SELECT ALL RECORDS PROCESSED CHECKS ON    ** 00196000
      **  THE REFUND TABLE THAT WERE PROCESSED BETWEEN TODAY & THE   ** 00197000
      **  LAST TIME THE PROGRAM WAS RUN. THESE FIELDS ARE WRITTEN    ** 00198000
      **  TO FILE FCSRP93. TABLE CSS_JOB_PARM IS THEN UPDATED WITH   ** 00199000
      **  THE CURRENT DATE.                                          ** 00199100
      ****************************************************************  00199203
      **                                                             ** 00199303
      **              PROGRAM  MODIFICATION  LOG                     ** 00199403
      **                                                             ** 00199503
      **    DATE    INITIALS    REASON                               ** 00199603
      **  ________  ________    ___________________________________  ** 00199703
T14725**  03-03-98    GAC       LAST RUN DATE IS OF CMND_CODE PARM,  ** 00199803
      **                        NOT DATE.  ALSO, TERMINATE HAD AN    ** 00199903
      **                        INFINITE LOOP.                       ** 00200003
T16243**  05/13/98    BAB       CORRECTED SELECTION CRITERIA.        ** 00201000
T17830**  10/21/98    CBSI      CHANGES MADE TO USE DATE-REFUNDED FOR**         
T17830**              MADRAS    TRANS-DATE INSTEAD OF CLEARED-DT.    **         
T19395**   3/12/99    CD17144   THE FIELDS FOR RECORD COUNT AND      ** 00210000
T19395**                        ACCUMULATOR ARE NOT DEFINED LARGE    ** 00210000
T19395**                        ENOUGH. CHANGED TO 9 BYTE FIELDS.    ** 00210000
T20082**   6/08/99    CB18344   ADDED LINES TO PERFORM 6251-GET-     ** 00210000
T20082**                        FJC01-DATE AND TO MOVE THE COMMON    ** 00210000
T20082**                        DATE TO WS-INPUT-DATE.               ** 00210000
T20252**  07/23/99    CB18344   MADE CHANGES TO LIST OUTSTANDING     ** 00210000
      **                        CHECKS BASED ON CALENDAR MONTH VERSUS** 00210000
      **                        REVENUE MONTH (CHECK STATUS CODES I, ** 00210000
      **                        M, AND U).                           ** 00210000
      **                        ALSO SORTED SELECT FROM CSS_REFUND   ** 00210000
      **                        BY CHECK NO, AND MADE CHANGES TO USE ** 00210000
      **                        REQUEST-DT FOR TRANS-DATE INSTEAD OF ** 00210000
      **                        DATE-REFUNDED.  THIS WILL STOP THE   ** 00210000
      **                        PRINTING OF BLANK DATES ON RP393.    ** 00210000
T20898**  10/07/99  CB18344     CHANGED PROGRAM TO EXCLUDE CHECK #'S ** 00199803
      **                        THAT ARE '         ' OR '0        '. ** 00199803
      **                        CSRC393 AND CSRR393 ARE BEING CHANGED** 00199803
      **                        TO BE SUCESSORS OF CSRC692.          ** 00199803
C23521**  01/17/01  CB18344     MADE CHANGES TO USE SYSTEM DATE      ** 00199803
C23521**                        INSTEAD OF REPORTDATE.               ** 00199803
C24044**  10/01/01  LF19392     ADDED COMPANY NUMBER TO CURSOR -     ** 00199803
C24044**                        CHANGE TO ORDER BY COMPANY NO        ** 00199803
      **                                                             ** 00210000
ACT144*   08/13/13  BD09555     REPLACE DATE CARD WITH DB2 COMMON DATE *        
      *   A04524                                                       *        
      ***************************************************************** 00290000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
HPCCDM*    EJECT                                                        00770000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSRP93.                                                    00850000
      *                                                                 00860000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP93.                                                    00930000
       COPY FIORP93.                                                    00940000
      *                                                                 00950000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA393'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA393 STARTS HERE'.            
      *                                                                 01360000
      *                                                                 01360100
      * ABEND SWITCH COPYBOOK                                           01360200
      *                                                                 01360300
       COPY CWS09900.                                                   01360400
      *                                                                 01360500
      * COPYBOOK FOR FCA00 WS DECLARATIONS.                             01360600
      *                                                                 01360700
       COPY CWS00039.                                                   01360800
C23521*                                                                 01360900
C23521* COPYBOOK FOR SYSTEM DATE.                                       01361000
C23521*                                                                 01361100
      *                                                                 01360900
      * COPYBOOK FOR JC01 DECLARATIONS.                                 01361000
      *                                                                 01361100
       COPY FIOJC01.                                                    01361200
      *                                                                 01361300
      * COPYBOOK FOR CA00 DECLARATIONS.                                 01361400
      *                                                                 01361500
       COPY FIOCA00.                                                    01361600
      *                                                                 01361700
      * WORKING STORAGE FOR REPORT HEADER                               01361800
      *                                                                 01361900
       COPY CWS00079.                                                   01362000
      *                                                                 01362100
      * COPYBOOK TO ACCESS JOB PARM TABLE                               01362200
      *                                                                 01362300
T20252     EXEC SQL                                                             
T20252       INCLUDE CWS00038                                                   
T20252     END-EXEC.                                                            
      *                                                                 01362500
       01  WS-INPUT-DATA-R8                                             
           REDEFINES  WS-INPUT-DATA-BREAKDOWN.                          
T14725     05  WS-LAST-PRG-RUN-DT           PIC X(14).                  
T14725         88  LAST-PRG-RUN-DATE                                    
T14725         VALUE 'LAST RUN DATE='.                                  
T14725     05  WS-LAST-PRG-RUN-DATE         PIC X(10).                  
      *                                                                 01363700
T20252     EXEC SQL                                                             
T20252       INCLUDE CWS00114                                                   
T20252     END-EXEC.                                                            
      *                                                                 01362500
       01  WS-WORK-AREA.                                                
T19395     05  WS-NO-TOT-RECS               PIC 9(09) VALUE ZEROES.     
T19395     05  WS-NO-COMP-RECS              PIC 9(09) VALUE ZEROES.     
ACT144     05  WS-CURRENT-DATE.                                         
ACT144         10  WS-CURRENT-CCYY          PIC 9999.                   
ACT144         10  FILLER                   PIC X.                      
ACT144         10  WS-CURRENT-MONTH         PIC 99.                     
ACT144         10  FILLER                   PIC X.                      
ACT144         10  WS-CURRENT-DAY           PIC 99.                     
T20252     05  WS-REQUEST-DT-IND            PIC S9(04) COMP.            
           05  WS-END-OF-ROWS-REFUND        PIC X(01) VALUE 'N'.        
               88  NO-DATA-REFUND                     VALUE 'Y'.        
           05  WS-FRP93-STATUS              PIC X(02).                  
               88  FRP93-SUCCESSFUL         VALUE '00'.                 
           05  WS-PREV-COMP-NO              PIC X(02) VALUE SPACES.     
           05  WS-FEBRUARY-DAYS             PIC 99    VALUE 28.         
           05  WS-QUOTIENT                  PIC 99.                     
           05  WS-REMAINDER                 PIC 99.                     
      *                                                                 01362500
ACT144 01  WS-END-DATE                      PIC X(10).                  
      *                                                                 01364700
       01  WS-LITERALS.                                                 
           05  WS-Y                         PIC X(01) VALUE 'Y'.        
           05  WS-N                         PIC X(01) VALUE 'N'.        
T20898     05  WS-PGRMNAME                  PIC X(08) VALUE 'PCSCA393'. 
           05  WS-ACTIVE                    PIC X(01) VALUE 'A'.        
           05  WS-COMMONDATE                PIC X(10) VALUE             
                                            'COMMONDATE'.               
T20252     05  WS-PROGRAM-NAME              PIC X(08) VALUE             
T20252                                      'PCSCA393'.                 
           05  WS-CA00                      PIC X(04) VALUE 'CA00'.     
      *                                                                 01366200
      *                                                                 01366200
           COPY CWS00303.                                               01366300
      *                                                                 01367000
           EXEC SQL                                                     02280000
               INCLUDE SQLCA                                            02290000
           END-EXEC.                                                    02300000
      *                                                                 02310000
           EXEC SQL                                                     02610000
               INCLUDE TBJBPARM                                         02620000
           END-EXEC.                                                    02630000
      *                                                                 02670000
           EXEC SQL                                                     02670100
               INCLUDE TBREFUND                                         02670200
           END-EXEC.                                                    02670300
      *                                                                 02670400
           EXEC SQL                                                     02670500
               INCLUDE TBACCT                                           02670600
           END-EXEC.                                                    02670700
      *                                                                 02670800
           EXEC SQL                                                     
               DECLARE CHECK_REFUND CURSOR FOR                          
               SELECT RN.ACCOUNT_NO,                                    
T20252                RN.REQUEST_DT,                                    
                      RN.REFUND_CHECK_NO,                               
                      RN.AMT_REFUNDED,                                  
                      RN.CHECK_STATUS_CD,                               
C24044                AT.COMPANY_NO                                     
               FROM  CSS_REFUND  RN WITH(READUNCOMMITTED),                      
C24044               CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
T20252         WHERE RN.REQUEST_DT  <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-STNDTE-RPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-STNDTE-RPT-END-DT
              ) <> 0) OR (LEN(:WS-STNDTE-RPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-STNDTE-RPT-END-DT
              ), CONVERT(DATE, :WS-STNDTE-RPT-END-DT) )            
T16243           AND RN.CHECK_STATUS_CD IN ('I','M','U')                
T20898           AND RN.REFUND_CHECK_NO <> '         '                  
T20898           AND RN.REFUND_CHECK_NO <> '0        '                  
T20898           AND RN.REFUND_CHECK_NO <> '000000000'                  
C24044           AND AT.ACCOUNT_NO = RN.ACCOUNT_NO                      
C24044      ORDER BY AT.COMPANY_NO,                                     
C24044               RN.REFUND_CHECK_NO                                 
ACT144                                                      
ACT144                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02671000
MFA-TR*        DECLARE CHECK_REFUND CURSOR FOR                          02671100
MFA-TR*        SELECT RN.ACCOUNT_NO,                                    02671200
MFA-TR*               RN.REQUEST_DT,                                    02671300
MFA-TR*               RN.REFUND_CHECK_NO,                               02671400
MFA-TR*               RN.AMT_REFUNDED,                                  02671500
MFA-TR*               RN.CHECK_STATUS_CD,                               02671600
MFA-TR*               AT.COMPANY_NO                                             
MFA-TR*        FROM  CSS_REFUND  RN,                                    02671700
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE RN.REQUEST_DT  <= :WS-STNDTE-RPT-END-DT            02671800
MFA-TR*          AND RN.CHECK_STATUS_CD IN ('I','M','U')                02672000
MFA-TR*          AND RN.REFUND_CHECK_NO <> '         '                  02672000
MFA-TR*          AND RN.REFUND_CHECK_NO <> '0        '                  02672000
MFA-TR*          AND RN.REFUND_CHECK_NO <> '000000000'                  02672000
MFA-TR*          AND AT.ACCOUNT_NO = RN.ACCOUNT_NO                              
MFA-TR*     ORDER BY AT.COMPANY_NO,                                             
MFA-TR*              RN.REFUND_CHECK_NO                                         
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                    02673000
      *                                                                 02674000
       01  WS-MISC-END.                                                 
           05 WS-END                   PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA393 ENDS HERE'.              
      *                                                                 02711000
       PROCEDURE DIVISION.                                              
      ******************************************************************02730000
      *                                                                *02740000
      *   0000-MAINLINE.                                               *02750000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *02760000
      *                                                                *02770000
      ******************************************************************02780000
       0000-MAINLINE.                                                   
      *                                                                 02810000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-MAIN-PROCESS THRU 1000-EXIT                     
               UNTIL NO-DATA-REFUND.                                    
           PERFORM 0150-WRITE-END-RECS THRU 0150-EXIT.                  
           PERFORM 7200-CLOSE-CSR-CHK-REF THRU 7200-EXIT.               
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
      *                                                                 02940000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02970000
      ******************************************************************02980000
      *                                                                *02990000
      *   0100-INITIALIZATION                                          *03000000
      *        COMMON INITIALIZATION ROUTINE                           *03010000
      *                                                                *03020000
      ******************************************************************03030000
       0100-INITIALIZATION.                                             
      *                                                                 03041000
           OPEN OUTPUT FCSRP93-FILE.                                    
           IF FRP93-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSCA393 PROCESSING ERROR             **'   
               DISPLAY '**  OPEN ERROR OF FCSRP93 - OUTPUT FILE   **'   
               DISPLAY '**  FILE STATUS = ' WS-FRP93-STATUS             
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 03069000
C23521*    PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.                      
      *                                                                 03069000
T20898*    MOVE WS-PROGRAM-NAME TO WS-PGRMNAME.                         03069000
C23521*    PERFORM 7611-CLOSE THRU 7611-EXIT.                           03069000
C23521*                                                                         
C23521                                                                  
T20082     PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
T20082                                                                  
           IF COMMON-DATE-NEEDED                                        
T20252        MOVE 'COMMON  ' TO WS-PGRMNAME                            
T20252        MOVE SPACES     TO WS-INPUT-AREA                          
T20252                           WS-INPUT-DATA-BREAKDOWN                
T20252        PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
T20252        MOVE WS-PROGRAM TO WS-PGRMNAME
           END-IF.                           
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-CURRENT-DATE.                       
ACT144     EXEC SQL SELECT
              (SELECT CAST(DATEADD(DAY, -DAY(E), E) AS DATE) 
              FROM (SELECT DATEADD(MONTH, 1, DATEADD( MONTH, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )) E) T)
            INTO
              :WS-END-DATE                        
ACT144     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL SET :WS-END-DATE =                                          
MFA-TR*        LAST_DAY(CURRENT_DATE - 1 MONTHS)                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT144     MOVE WS-END-DATE TO WS-STNDTE-RPT-END-DT.                    
      *                                                                 03140000
T20252     MOVE WS-PROGRAM-NAME TO WS-PROGRAM.                          
           PERFORM 7630-OPEN-JOB-PARM-CURSOR THRU 7630-EXIT.            
           MOVE SPACES TO WS-SYSIPT.                                    
           PERFORM 7631-READ-JOB-PARM-TABLE THRU 7631-EXIT.             
           PERFORM UNTIL END-OF-SYSIPT OR                               
T14725         (G6-CMND-CODE = 'PARM' AND LAST-PRG-RUN-DATE)            
               PERFORM 7631-READ-JOB-PARM-TABLE THRU 7631-EXIT          
           END-PERFORM                                                  
           IF END-OF-SYSIPT                                             
               DISPLAY '**  PCSCA393 PROCESSING ERROR             **'   
               DISPLAY '**  NO RECORD AVAILABLE IN JOB PARM FOR   **'   
               DISPLAY '**  LAST PROGRAM RUN DATE                 **'   
               DISPLAY '**  PROCESSING TERMINATED                 **'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 03201000
           MOVE LOW-VALUES TO E-FRP93-KEY-BREC.                         
           MOVE WS-INPUT-DATE TO E-FRP93-CREATE-DATE-BREC.              
           MOVE ZEROES TO E-FRP93-DB-PART-BREC.                         
           WRITE E-FIORP93.                                             
      *                                                                 03220000
           PERFORM 7000-OPEN-CSR-CHK-REF THRU 7000-EXIT.                
           PERFORM 7100-FETCH-CSR-CHK-REF THRU 7100-EXIT.               
      *                                                                 03222000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03250000
      ****************************************************************  05520000
      *                                                              *  05521000
      * 1000-MAIN-PROCESS.                                           *  05530000
      *     PERFORMS MAIN PROCESSING LOGIC WRITES INTO FILE FRP93.   *  05550000
      *     PARA IS PERFORMED UNTIL NO-DATA CSS_REFUND.              *  05560000
      *                                                              *  05570000
      ****************************************************************  05650000
      *                                                                 09280000
       1000-MAIN-PROCESS.                                               
      *                                                                 09290100
           MOVE RN-ACCOUNT-NO         TO AT-ACCOUNT-NO.                 
           PERFORM 7300-SELECT-COMP-NO THRU 7300-EXIT.                  
           IF AT-COMPANY-NO NOT = WS-PREV-COMP-NO AND                   
               WS-PREV-COMP-NO NOT = SPACES                             
               MOVE WS-NO-COMP-RECS   TO E-FRP93-CO-REC-COUNT-EREC      
               MOVE WS-PREV-COMP-NO   TO E-FRP93-CO-NO-KEY-EREC         
               MOVE HIGH-VALUES       TO E-FRP93-CO-KEY-EREC            
               MOVE ZEROES            TO E-FRP93-CO-DB-PART-EREC        
               WRITE E-FIORP93                                          
               MOVE ZEROES            TO WS-NO-COMP-RECS
           END-IF.               
           MOVE AT-COMPANY-NO         TO E-FRP93-COMPANY-NO.            
           MOVE RN-ACCOUNT-NO         TO E-FRP93-ACCOUNT-NO.            
T20252     IF  WS-REQUEST-DT-IND EQUAL -1                               
T17830         MOVE SPACES            TO E-FRP93-TRANS-DATE             
T17830     ELSE                                                         
T20252         MOVE RN-REQUEST-DT     TO E-FRP93-TRANS-DATE             
T17830     END-IF.                                                      
           MOVE RN-REFUND-CHECK-NO    TO E-FRP93-CHECK-NO.              
           MOVE RN-AMT-REFUNDED       TO E-FRP93-CHECK-AMT.             
           MOVE RN-CHECK-STATUS-CD    TO E-FRP93-CHECK-STATUS-NO.       
           WRITE E-FIORP93.                                             
T20252     INITIALIZE                    RN-REQUEST-DT.                 
           PERFORM 7100-FETCH-CSR-CHK-REF THRU 7100-EXIT.               
           ADD 1                      TO WS-NO-COMP-RECS.               
           ADD 1                      TO WS-NO-TOT-RECS.                
           MOVE AT-COMPANY-NO         TO WS-PREV-COMP-NO.               
      *                                                                 09292300
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09292600
      ****************************************************************  09292700
      *                                                              *  09292800
      * 0150-WRITE-END-RECS.                                         *  09293000
      *     WRITE COMP END RECORD FOR LAST COMPANY & ALSO WRITES     *  09294000
      *     FILE END RECORD.                                         *  09295000
      *                                                              *  09296000
      ****************************************************************  09297000
      *                                                                 09298000
       0150-WRITE-END-RECS.                                             
      *                                                                 09299100
           IF WS-NO-TOT-RECS NOT = ZERO                                 
               MOVE WS-NO-COMP-RECS   TO E-FRP93-CO-REC-COUNT-EREC      
               MOVE WS-PREV-COMP-NO   TO E-FRP93-CO-NO-KEY-EREC         
               MOVE HIGH-VALUES       TO E-FRP93-CO-KEY-EREC            
               MOVE ZEROES            TO E-FRP93-CO-DB-PART-EREC        
               WRITE E-FIORP93
           END-IF.                                         
           MOVE WS-NO-TOT-RECS    TO E-FRP93-RECORD-COUNT-EREC.         
           MOVE HIGH-VALUES       TO E-FRP93-KEY-EREC.                  
           MOVE SPACES            TO E-FRP93-DB-PART-EREC.              
           WRITE E-FIORP93.                                             
           MOVE WS-CURRENT-DATE TO WS-LAST-PRG-RUN-DATE.                
           MOVE WS-INPUT-DATA-R8 TO G6-PARM-DATA.                       
           PERFORM 7400-UPDATE-JOB-PARM THRU 7400-EXIT.                 
      *                                                                 09300500
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09300800
T20252********************************************************                  
T20252*   6200-GET-PARAMETER-DATE.                           *          09301000
T20252*   6300-GET-OVERRIDE-DATE.                            *          09301000
T20252*   6310-GET-DEFAULT-DATE.                             *          09301000
T20252*   6320-EDIT-PARM-DATE.                               *          09301000
T20252*   6330-GET-START-END-DATE.                           *          09301000
T20252*   6340-UPDATE-JOB-PARM-TABLE.                        *          09301000
T20252********************************************************                  
T20252*                                                                         
C23521*    EXEC SQL                                                             
C23521*      INCLUDE CPD00114                                                   
C23521*    END-EXEC.                                                            
      *                                                                 09300800
      ********************************************************          09300900
      *   6240-GET-FCA00-COMMON-DATE.                        *          09301000
      ********************************************************          09301100
       COPY CPD00040.                                                   09301200
      *                                                                 09301300
      ********************************************************          09301400
      *   6251-GET-FJC01-DATE.                               *          09301500
      ********************************************************          09301600
       COPY CPD00037.                                                   09301700
      *                                                                 09301800
      ****************************************************************  09301900
      *                                                              *  09302000
      * 7000-OPEN-CSR-CHK-REF.                                       *  09302100
      *     OPENS CURSOR CHECK REFUND TO ACCESS ROWS FROM TABLE      *  09302200
      *     CSS_REFUND.                                              *  09302300
      *                                                              *  09302400
      ****************************************************************  09302500
      *                                                                 09302600
       7000-OPEN-CSR-CHK-REF.                                           
      *                                                                 09302800
           EXEC SQL                                                     
                OPEN CHECK_REFUND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA393  **'    
               DISPLAY '** PARA - 7000-OPEN-CSR-CHK-REF          **'    
               DISPLAY '** RC = ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY '** PROCESSING TERMINATED                 **'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 09450000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09480000
      ****************************************************************  09490000
      *                                                              *  09500000
      * 7100-FETCH-CSR-CHK-REF.                                      *  09510000
      *     FETCHES ROWS FROM CURSOR CHK REF.                        *  09520000
      *                                                              *  09540000
      ****************************************************************  09550000
      *                                                                 09560000
       7100-FETCH-CSR-CHK-REF.                                          
           EXEC SQL                                                     
                FETCH CHECK_REFUND                                      
                INTO  :RN-ACCOUNT-NO,                                   
T20252                :RN-REQUEST-DT :WS-REQUEST-DT-IND,                 
                      :RN-REFUND-CHECK-NO,                              
                      :RN-AMT-REFUNDED,                                 
                      :RN-CHECK-STATUS-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               IF SQLCODE = NOT-FOUND                                   
                   MOVE 'Y' TO WS-END-OF-ROWS-REFUND                    
               ELSE                                                     
                   DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA393  **'
                   DISPLAY '** PARA - 7100-FETCH-CSR-CHK-REF         **'
                   DISPLAY '** RC = ' WS-ACTIVE-RETURN-CODE             
                   DISPLAY '** PROCESSING TERMINATED                 **'
                   PERFORM 9900-ABEND  THRU  9900-EXIT
               END-IF
           END-IF.                 
      *                                                                 09700000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09720100
      ****************************************************************  09721000
      *                                                              *  09722000
      * 7200-CLOSE-CSR-CHK-REF.                                      *  09723000
      *     CLOSE CURSOR CHECK REFUND.                               *  09724000
      *                                                              *  09726000
      ****************************************************************  09727000
      *                                                                 09728000
       7200-CLOSE-CSR-CHK-REF.                                          
           EXEC SQL                                                     
                CLOSE CHECK_REFUND                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA393  **'    
               DISPLAY '** PARA - 7200-CLOSE-CSR-CHK-REF         **'    
               DISPLAY '** RC = ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY '** PROCESSING TERMINATED                 **'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 09733000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09736000
      ****************************************************************  09737000
      *                                                              *  09738000
      * 7300-SELECT-COMP-NO.                                         *  09739000
      *     SELECTS COMPANY NO FROM TABLE CSS_ACCOUNT USING ACCOUNT  *  09739100
      *     NO FROM TABLE CSS_REFUND.                                *  09739200
      *                                                              *  09739300
      ****************************************************************  09739400
      *                                                                 09739500
       7300-SELECT-COMP-NO.                                             
           EXEC SQL                                                     
                SELECT COMPANY_NO                                       
                INTO :AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
ACT144                                                           
ACT144                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09739700
MFA-TR*         SELECT COMPANY_NO                                       09739800
MFA-TR*         INTO :AT-COMPANY-NO                                     09739900
MFA-TR*         FROM CSS_ACCOUNT                                        09740000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       09740100
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                    09740200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA393  **'    
               DISPLAY '** PARA - 7300-SELECT-COMP-NO            **'    
               DISPLAY '** RC = ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY '** PROCESSING TERMINATED                 **'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 09748000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09749200
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7400-UPDATE-JOB-PARM.                                        *  09749500
      *     UPDATES CURRENT DATE IN JOB PARM AS TO HAVE THE DATE THE *  09749600
      *     PROGRAM HAS RUN SO IT IS AVAILABLE FOR THE NEXT RUN.     *  09749700
      *                                                              *  09749800
      ****************************************************************  09749900
      *                                                                 09750000
       7400-UPDATE-JOB-PARM.                                            
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                SET PARM_DATA      = :G6-PARM-DATA                      
                WHERE COMPANY_NO   = :G6-COMPANY-NO AND                 
                      PROGRAM_NAME = :G6-PROGRAM-NAME AND               
                      CMND_CODE    = :G6-CMND-CODE AND                  
                      SEQ_NO       = :G6-SEQ-NO                         
ACT144                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     09752000
MFA-TR*         UPDATE CSS_JOB_PARM                                     09753000
MFA-TR*         SET PARM_DATA      = :G6-PARM-DATA                      09753100
MFA-TR*         WHERE COMPANY_NO   = :G6-COMPANY-NO AND                 09753200
MFA-TR*               PROGRAM_NAME = :G6-PROGRAM-NAME AND               09753300
MFA-TR*               CMND_CODE    = :G6-CMND-CODE AND                  09753400
MFA-TR*               SEQ_NO       = :G6-SEQ-NO                         09753500
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                    09757000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PROCESSING ERROR IN PROGRAM PCSCA393  **'    
               DISPLAY '** PARA - 7400-UPDATE-JOB-PARM           **'    
               DISPLAY '** RC = ' WS-ACTIVE-RETURN-CODE                 
               DISPLAY '** PROCESSING TERMINATED                 **'    
               PERFORM 9900-ABEND  THRU  9900-EXIT
           END-IF.                     
      *                                                                 09759800
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09761000
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7600-START-FCSJC01.                                          *  09749500
      * 7610-READ-FCSJC01.                                           *  09749500
      * 7611-CLOSE.                                                  *  09749500
      *                                                              *  09749400
      ****************************************************************  09749300
      *                                                                 09749200
            EXEC SQL                                                    15110000
                 INCLUDE CPD00038                                       15120000
            END-EXEC.                                                   15130000
      *                                                                 09761000
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7620-START-FCSCA00.                                          *  09749500
      * 7621-READ-FCSCA00.                                           *  09749500
      * 7622-CLOSE-CA00-CSR.                                         *  09749500
      *                                                              *  09749400
      ****************************************************************  09749300
      *                                                                 09749200
            EXEC SQL                                                    15140000
                 INCLUDE CPD00039                                       15150000
            END-EXEC.                                                   15160000
      *                                                                 15180000
      ****************************************************************  09749300
      *                                                              *  09749400
      * 7630-OPEN-JOB-PARM-CURSOR.                                   *  09749500
      * 7631-READ-JOB-PARM-TABLE.                                    *  09749500
      * 7632-CLOSE-JOB-PARM.                                         *  09749500
      *                                                              *  09749400
      ****************************************************************  09749300
      *                                                                 09749200
            EXEC SQL                                                    15190000
                 INCLUDE CPD00117                                       15200000
            END-EXEC.                                                   15210000
      *                                                                 15230000
       9000-TERMINATE.                                                  
      *                                                                 15290000
           CLOSE FCSRP93-FILE.                                          
           IF FRP93-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  PCSCA393 PROCESSING ERROR             **'   
               DISPLAY '**  CLOSE ERROR OF FCSRP93 - OUTPUT FILE  **'   
               DISPLAY '**  FILE STATUS = ' WS-FRP93-STATUS             
               DISPLAY '**  PROCESSING TERMINATED                 **'   
           END-IF.                                                      
      *                                                                 15310000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15180000
      ****************************************************************  09749300
      *                                                              *  09749400
      * 9900-ABEND.                                                  *  09749500
      *                                                              *  09749400
      ****************************************************************  09749300
      *                                                                 09749200
           EXEC SQL                                                     15350000
               INCLUDE CPD09900                                         15360000
           END-EXEC.                                                    15370000
