       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA385.                                           
       DATE-WRITTEN.  06/13/00.                                         
       DATE-COMPILED.                                                   
       AUTHOR.         CBSIMDS                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 06/13/00   CBSI, MDS      DEVELOPMENT OF NEW PROGRAM        **         
T22393*   06/23/00   KSB     PROGRAM ADDED TO DELTE MNT ROWS NOT FOUND *        
      *                      IN AT TABLE RETAINING JUST THE LAST SIX   *        
      *                      MONTHS ROWS                               *        
      **                                                             **         
      *****************************************************************         
      *                   PCSCA385   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM DELETES THE RECORDS FROM CSS_MNT_TRANS_HIST TABLE*         
      * THAT ARE NOT PRESENT IN CSS_ACCOUNT TABLE ,AND COMMITS        *         
      * FOR EVERY 1000 RECORDS.                                       *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
           SELECT DELTRANS-FILE ASSIGN TO DA-DELTRANS                   
              ORGANIZATION IS SEQUENTIAL                                
              ACCESS MODE IS SEQUENTIAL.                                
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       FD  DELTRANS-FILE.                                               
      *                                                                         
       01  WS-DELTRANS-REC.                                             
           05  WS-ACCT-NO                     PIC X(13).                
           05  FILLER                         PIC X(03).                
           05  WS-TRANS-HIST-NO               PIC X(26).                
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA385'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-VARIABLES.                                                
           05  WS-COMMIT-COUNT                 PIC 9(04) VALUE ZEROS.   
           05  WS-1000                         PIC 9(04) VALUE 1000.    
           05  WS-1                            PIC 9(01) VALUE 1.       
           05  WS-COMMIT-DISP                  PIC 9(09) VALUE ZEROS.   
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *  CSS_MNT_TRANS_HIST                                                     
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      * -- USED BY CPD0303B                                                     
      * WS ABEND WORK AREA                                                      
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATION TO SELECT ALL THE RECORDS THAT ARE LESS THAN         
      * TWO YEARS FROM CSS_MNT_TRANS_HIST TABLE WHICH ARE NOT PRESENT IN        
      * CSS_ACCOUNT TABLE                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE MNT_TRANS CURSOR WITH HOLD FOR                   
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           MH.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                            
                       MH.ACCOUNT_NO                                    
                  FROM CSS_MNT_TRANS_HIST MH                            
                 WHERE CAST(MH.TRANS_HIST_SEQ_NO AS DATE) <=                    
                       DATEADD( MONTH, -6, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )                    
                 AND   CAST(MH.TRANS_HIST_SEQ_NO AS DATE) >=                    
                       DATEADD( YEAR, -2, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )                     
                   AND MH.ACCOUNT_NO > 0                                
                   AND MH.ACCOUNT_NO NOT IN                             
                       (SELECT AT.ACCOUNT_NO FROM CSS_ACCOUNT AT        
                         WHERE AT.ACCOUNT_NO = MH.ACCOUNT_NO)           
                   FOR UPDATE OF TRANS_HIST_SEQ_NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MNT_TRANS CURSOR WITH HOLD FOR                           
MFA-TR*         SELECT MH.TRANS_HIST_SEQ_NO,                                    
MFA-TR*                MH.ACCOUNT_NO                                            
MFA-TR*           FROM CSS_MNT_TRANS_HIST MH                                    
MFA-TR*          WHERE DATE(MH.TRANS_HIST_SEQ_NO) <=                            
MFA-TR*                DATE(CURRENT DATE) - 6 MONTHS                            
MFA-TR*          AND   DATE(MH.TRANS_HIST_SEQ_NO) >=                            
MFA-TR*                DATE(CURRENT DATE) - 2 YEARS                             
MFA-TR*            AND MH.ACCOUNT_NO > 0                                        
MFA-TR*            AND MH.ACCOUNT_NO NOT IN                                     
MFA-TR*                (SELECT AT.ACCOUNT_NO FROM CSS_ACCOUNT AT                
MFA-TR*                  WHERE AT.ACCOUNT_NO = MH.ACCOUNT_NO)                   
MFA-TR*            FOR UPDATE OF TRANS_HIST_SEQ_NO                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 1000-MNT-TRANS-HIST         THRU 1000-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DELETES THE RECORDS FROM CSS_MNT_TRANS_HIST                   **        
      ******************************************************************        
      *                                                                         
       1000-MNT-TRANS-HIST.                                             
      *                                                                         
           INITIALIZE WS-COMMIT-COUNT.                                  
           INITIALIZE WS-COMMIT-DISP.                                   
      *                                                                         
           OPEN OUTPUT DELTRANS-FILE.                                   
      *                                                                         
           PERFORM 7000-OPEN-MNT-CURSOR        THRU 7000-EXIT.          
           PERFORM 7100-FETCH-MNT-CURSOR       THRU 7100-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '* NO RECORDS TO DELETE IN   *'                  
               DISPLAY '* CSS_MNT_TRANS_HIST TABLE  *'                  
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 2000-LOAD-FILE          THRU 2000-EXIT           
                                                                        
               PERFORM 8000-DELETE-MNT-TRANS-HIST                       
                                               THRU 8000-EXIT           
               PERFORM 7100-FETCH-MNT-CURSOR   THRU 7100-EXIT           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7200-CLOSE-MNT-CURSOR       THRU 7200-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * POPULATES THE FILE WITH ACCOUNT NUMBERS                        *        
      ******************************************************************        
      *                                                                         
       2000-LOAD-FILE.                                                  
           MOVE MH-TRANS-HIST-SEQ-NO          TO WS-TRANS-HIST-NO.      
           MOVE MH-ACCOUNT-NO                 TO WS-ACCT-NO.            
      *                                                                         
           WRITE WS-DELTRANS-REC.                                       
      *                                                                         
           INITIALIZE WS-DELTRANS-REC.                                  
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
      ******************************************************************        
      * OPENS MNT_TRANS CURSOR                                         *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-MNT-CURSOR.                                            
      *                                                                 32290000
           EXEC SQL                                                     
               OPEN MNT_TRANS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA385 ABORT  ************'        
               DISPLAY '* 7000-OPEN-MNT-CURSOR                *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA385  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************31740000
      * FETCHES ACCOUNT NUMBERS THAT ARE NOT THERE IN CSS_ACCOUNT      *31740000
      ******************************************************************31740000
      *                                                                 31740000
       7100-FETCH-MNT-CURSOR.                                           
      *                                                                 32011000
           EXEC SQL                                                     
               FETCH  MNT_TRANS                                         
                INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA385 ABORT  ************'        
               DISPLAY '* 7100-FETCH-MNT-CURSOR               *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA385  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSES MNT_TRANS CURSOR                                        *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-MNT-CURSOR.                                           
      *                                                                 32290000
           EXEC SQL                                                     
               CLOSE MNT_TRANS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31880000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA385 ABORT  ************'        
               DISPLAY '* 7200-CLOSE-MNT-CURSOR               *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA385  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DELETES RECORDS FROM CSS_MNT_TRANS_HIST                                 
      ******************************************************************        
      *                                                                         
       8000-DELETE-MNT-TRANS-HIST.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_MNT_TRANS_HIST                        
                 WHERE CURRENT OF MNT_TRANS                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_MNT_TRANS_HIST MH                               
MFA-TR*          WHERE CURRENT OF MNT_TRANS                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               ADD WS-1                        TO WS-COMMIT-COUNT       
               IF  WS-COMMIT-COUNT = WS-1000                            
                   PERFORM 8900-COMMIT         THRU 8900-EXIT           
                   INITIALIZE WS-COMMIT-COUNT                           
               END-IF                                                   
           ELSE                                                         
               DISPLAY '********** PCSCA385 ABORT  ************'        
               DISPLAY '* 8100-DELETE-MNT-TRANS-HIST          *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA385  ABORT ************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  ISSUES A COMMIT POINT                                      **          
      ****************************************************************          
      *                                                                         
       8900-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           ADD  1   TO   WS-COMMIT-DISP                                 
           DISPLAY 'COMMIT COUNT'    WS-COMMIT-DISP.                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * TERMINATES THE PROGRAM UNDER NORMAL CONDITIONS                          
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE DELTRANS-FILE.                                         
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
