00001  IDENTIFICATION DIVISION.                                         
00002  PROGRAM-ID.   PCSCA376.                                          
HPCCDM*    SKIP1                                                        53690   
HPCCDM*    SKIP1                                                        53690   
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      **    ADD THE CITY AND STATE TO THE FORMATTED ADDRESS TABLE.  ***         
      **    ALSO, REFORMAT SO THAT THE ADDRESSES ARE IN A FORMAT    ***         
      **    THAT FINALIST CAN MORE EASILY PROCESS.                  ***         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **    -----   --------     ------                              **         
      **    05/06   BD09555      LOAD THE ZIP CODE TABLE FROM THE    **         
      **                         DATABASE INSTEAD OF FROM A FLAT FILE**         
T35511**    03/07   MV41823      INCREASE W.S. ZIP TABLE LIMIT TO    **         
T35511**                         30000 ENTRIES. SEND A WARNING EMAIL **         
T35511**                         WHEN ZIP TABLE IS APPROACHING       **         
T35511**                         MAXIMUM LIMIT.                      **         
      **    09/07   BD09555      NO CHANGES.  RECOMPILE TO RETRIEVE  **         
      **                         NEW COPYBOOK FOR FORMATTED ADDRESS  **         
      **                         FILE.                               **         
A00633**    07/09   BD09555      REMOVE UNNECESSARY DISPLAYS         **         
A00633**                         ADD SQL CHECKS.                     **         
ACT120**    06/14   BD09555      INCREASE TABLE SIZE TO 60000        **         
ACT120**    A04880                                                   **         
ACTXXX**    03/16   BD09555      REMOVE OUTER JOIN FOR FORMATTED     **         
ACTXXX**    A05460-ACTXXX        TABLE.  SELECT DISTINCT FOR FREEFORM**         
ACTXXX**                         TABLE.  ADD DISPLAYS FOR NUMBER OF  **         
ACTXXX**                         ROWS SELECTED.                      **         
      *****************************************************************         
00014  ENVIRONMENT DIVISION.                                            
00015  INPUT-OUTPUT SECTION.                                            
00016  FILE-CONTROL.                                                    
           SELECT OUTFORM  ASSIGN TO OUTFORM.                           
           SELECT OUTFREE  ASSIGN TO OUTFREE.                           
T35511     SELECT MAILFILE ASSIGN TO MAILFILE.                          
00020  DATA DIVISION.                                                   
00023  FILE SECTION.                                                    
       FD  OUTFREE                                                      
           BLOCK CONTAINS 0 RECORDS.                                    
       01  FREEFORM-REC            PIC X(265).                          
       FD  OUTFORM                                                      
           BLOCK CONTAINS 0 RECORDS.                                    
       01  OUT-FORMATTED.                                               
           03  OUT-ADDR-ID         PIC 9(13) COMP-3.                    
           03  OUT-ADDR-LINE.                                           
               05  OUT-ADDR-HOUSE  PIC X(15).                           
               05  FILLER          PIC X.                               
               05  OUT-ADDR-PREF1  PIC XXX.                             
               05  FILLER          PIC X.                               
               05  OUT-ADDR-PREF2  PIC XX.                              
               05  FILLER          PIC X.                               
               05  OUT-ADDR-ST     PIC X(30).                           
               05  FILLER          PIC X.                               
               05  OUT-ADDR-SUF    PIC XXXX.                            
               05  FILLER          PIC X.                               
               05  OUT-ADDR-PDIR   PIC XX.                              
               05  OUT-ADDR-LOC    PIC XXXX.                            
               05  FILLER          PIC X.                               
               05  OUT-ADDR-LOC-NO PIC X(11).                           
           03  OUT-ZIP-CODE        PIC X(5).                            
           03  OUT-ZIP-PLUS4       PIC XXXX.                            
           03  OUT-DELIV-PT        PIC XX.                              
           03  OUT-CITY-STATE.                                          
               05  OUT-CITY  PIC X(26).                                 
               05  FILLER    PIC X.                                     
               05  OUT-ST    PIC XX.                                    
           03  OUT-ZIP-TOKEN       PIC X.                               
           03  FILLER              PIC X(4).                            
T35511 FD  MAILFILE                                                     
           BLOCK CONTAINS  0 RECORDS.                                   
       01  MAIL-REC           PIC X(80).                                
                                                                        
00024  WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA376'.
MSQ017     COPY MFASQLM.
A00633 01  WS-MISC-INFO.                                                
A00633     05  WS-EOJ-CODE        PIC S9(4)   VALUE +0          COMP.   
A00633     05  WS-EOF-SW          PIC X       VALUE 'N'.                
A00633         88  END-OF-FILE                VALUE 'Y'.                
A00633     05  WS-ZIP-SW          PIC X       VALUE 'N'.                
A00633         88  END-OF-ZIPS                VALUE 'Y'.                
A00633     05  WS-OVERFLOW-LINE   PIC X(52)   VALUE                     
A00633         'PCSCA376 - ZIP CODE TABLE HAS XXXXXXXXXX - INCREASE!'.  
A00633     05  WS-FUNCTION        PIC X(5)    VALUE 'OPEN'.             
A00633     05  WS-PARAGRAPH       PIC X(30)   VALUE SPACE.              
A00633     05  WS-TABLE-ID        PIC X(20)   VALUE SPACE.              
A00633     05  WS-TEST-NBR        PIC 999.                              
ACTXXX     05  WS-FREEFORM-CT     PIC 9(7)    VALUE ZERO.               
ACTXXX     05  FILLER REDEFINES WS-FREEFORM-CT.                         
ACTXXX         10  FILLER         PIC X(2).                             
ACTXXX         10  WS-FREEFORM-TEST PIC 9(5).                           
ACTXXX     05  WS-FORMATTED-CT     PIC 9(7)    VALUE ZERO.              
ACTXXX     05  FILLER REDEFINES WS-FORMATTED-CT.                        
ACTXXX         10  FILLER         PIC X(2).                             
ACTXXX         10  WS-FORMATTED-TEST PIC 9(5).                          
A00633     05  WS-TIME-OF-DAY     PIC 9(8).                             
A00633     05  FILLER REDEFINES WS-TIME-OF-DAY.                         
A00633         10  FILLER         PIC X(5).                             
A00633         10  WS-RANDOM-NBR  PIC 999.                              
A00633     05  WS-KEY                         VALUE SPACE.              
A00633         10  WS-ADDRESS-ID  PIC 9(13).                            
                                                                        
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
                                                                        
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
                                                                        
       01  WS-SUBJECT.                                                  
           05  FILLER                  PIC X(35)    VALUE               
T35511     'PCSCA376 IMMEDIATE ATTENTION NEEDED'.                       
                                                                        
T35511 01  MAILHEAD-1.                                                  
           05  FILLER                  PIC X(22) VALUE                  
               'HELO DOMAIN:     SCANA'.                                
                                                                        
T35511 01  MAILHEAD-2.                                                  
           05  FILLER                      PIC X(14) VALUE              
               'MAIL FROM:   <'.                                        
           05  MAIL2-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
T35511 01  MAILHEAD-3.                                                  
           05  FILLER                      PIC X(39) VALUE              
               'RCPT TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                 
                                                                        
T35511 01  MAILHEAD-4.                                                  
           05  FILLER                      PIC X(04) VALUE              
               'DATA'.                                                  
                                                                        
T35511 01  MAILHEAD-5.                                                  
           05  FILLER                      PIC X(18) VALUE              
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
T35511 01  MAILHEAD-6.                                                  
           05  FILLER                      PIC X(34) VALUE              
               'TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                      
                                                                        
T35511 01  MAILHEAD-7.                                                  
           05  FILLER                      PIC X(10) VALUE              
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT               PIC X(38).                   
                                                                        
T35511 01  MAILHEAD-8.                                                  
           05  FILLER                      PIC X(80) VALUE SPACES.      
                                                                        
T35511 01  WS-WARNING-LINE1.                                            
           05  FILLER        PIC X(13)   VALUE                          
           'PCSCA376 FOR '.                                             
           05  WS-SUB-DATE   PIC X(8).                                  
           05  FILLER        PIC X(37)   VALUE                          
           ' - W.S. ZIP CODE TABLE IS APPROACHING'.                     
                                                                        
T35511 01  WS-WARNING-LINE2   PIC X(47)   VALUE                         
           'MAXIMUM LIMIT. INCREASE IT AS SOON AS POSSIBLE!'.           
                                                                        
       01  WS-AST-LINE         PIC X(58)   VALUE                        
           '**********************************************************'.
       01  WS-ZIP-AND-TOKEN.                                            
           05  WS-ZIP         PIC X(5).                                 
           05  WS-TOKEN       PIC X.                                    
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
T35511 01  ZIP-TABLE1      PIC X(2040000)  VALUE HIGH-VALUES.           
       01  ZIP-TABLE2 REDEFINES ZIP-TABLE1.                             
ACT120     03  ZIP-CITY-STATE OCCURS 60000 TIMES                        
T35511                        ASCENDING KEY ZIP-AND-TOKEN               
                              INDEXED BY I.                             
T35511         05  ZIP-AND-TOKEN.                                       
                   07  ZIP-CODE   PIC X(5).                             
                   07  ZIP-TOKEN  PIC X.                                
T35511         05  ZIP-TAB-CITY PIC X(26).                              
T35511         05  ZIP-TAB-ST   PIC XX.                                 
                                                                        
           EXEC SQL                                                     
              DECLARE ZIP_CODE_CURSOR  CURSOR FOR                       
                SELECT ZIP_CODE,                                        
                       ZIP_CODE_TOKEN,                                  
                       TOWN,                                            
                       STATE                                            
                FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                         
                ORDER BY ZIP_CODE, ZIP_CODE_TOKEN                       
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ZIP_CODE_CURSOR  CURSOR FOR                               
MFA-TR*         SELECT ZIP_CODE,                                                
MFA-TR*                ZIP_CODE_TOKEN,                                          
MFA-TR*                TOWN,                                                    
MFA-TR*                STATE                                                    
MFA-TR*         FROM CSS_ZIP_CODE                                               
MFA-TR*         ORDER BY ZIP_CODE, ZIP_CODE_TOKEN                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
               DECLARE GET_FORMATTED CURSOR FOR                         
               SELECT DY.ADDRESS_ID,                                    
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_NAME,                                   
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2,                             
                      DY.STREET_SUFFIX,                                 
                      DY.ADDRESS_OVERFLOW,                              
                      DY.CARRIER_ROUTE,                                 
                      DY.ZIP_CODE,                                      
                      DY.ZIP_CODE_PLUS_FOUR,                            
                      DY.ZIP_CODE_TOKEN,                                
                      DY.ADDR_USAGE_CD,                                 
                      DY.ADDR_SUFFIX,                                   
                      DY.USPS_DELIV_PT_CD                               
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                 WHERE                                                  
                   DY.ADDRESS_ID  = PR.ADDRESS_ID                       
               UNION                                                    
                  SELECT DY.ADDRESS_ID,                                 
                     DY.HOUSE_NO,                                       
                     DY.ADDR_PREFIX_1,                                  
                     DY.ADDR_PREFIX_2,                                  
                     DY.STREET_NAME,                                    
                     DY.STREET_LOCATION_1,                              
                     DY.STREET_LOCATION_2,                              
                     DY.STREET_SUFFIX,                                  
                     DY.ADDRESS_OVERFLOW,                               
                     DY.CARRIER_ROUTE,                                  
                     DY.ZIP_CODE,                                       
                     DY.ZIP_CODE_PLUS_FOUR,                             
                     DY.ZIP_CODE_TOKEN,                                 
                     DY.ADDR_USAGE_CD,                                  
                     DY.ADDR_SUFFIX,                                    
                     DY.USPS_DELIV_PT_CD                                
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
                WHERE                                                   
                     AT.ADDRESS_ID  = DY.ADDRESS_ID                     
                FOR READ ONLY                                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET_FORMATTED CURSOR FOR                                 
MFA-TR*        SELECT DY.ADDRESS_ID,                                            
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               DY.STREET_SUFFIX,                                         
MFA-TR*               DY.ADDRESS_OVERFLOW,                                      
MFA-TR*               DY.CARRIER_ROUTE,                                         
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_PLUS_FOUR,                                    
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               DY.ADDR_USAGE_CD,                                         
MFA-TR*               DY.ADDR_SUFFIX,                                           
MFA-TR*               DY.USPS_DELIV_PT_CD                                       
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*          WHERE                                                          
MFA-TR*            DY.ADDRESS_ID  = PR.ADDRESS_ID                               
MFA-TR*        UNION                                                            
MFA-TR*           SELECT DY.ADDRESS_ID,                                         
MFA-TR*              DY.HOUSE_NO,                                               
MFA-TR*              DY.ADDR_PREFIX_1,                                          
MFA-TR*              DY.ADDR_PREFIX_2,                                          
MFA-TR*              DY.STREET_NAME,                                            
MFA-TR*              DY.STREET_LOCATION_1,                                      
MFA-TR*              DY.STREET_LOCATION_2,                                      
MFA-TR*              DY.STREET_SUFFIX,                                          
MFA-TR*              DY.ADDRESS_OVERFLOW,                                       
MFA-TR*              DY.CARRIER_ROUTE,                                          
MFA-TR*              DY.ZIP_CODE,                                               
MFA-TR*              DY.ZIP_CODE_PLUS_FOUR,                                     
MFA-TR*              DY.ZIP_CODE_TOKEN,                                         
MFA-TR*              DY.ADDR_USAGE_CD,                                          
MFA-TR*              DY.ADDR_SUFFIX,                                            
MFA-TR*              DY.USPS_DELIV_PT_CD                                        
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_ADDR_FORMATTED DY                                      
MFA-TR*         WHERE                                                           
MFA-TR*              AT.ADDRESS_ID  = DY.ADDRESS_ID                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       END-EXEC                                                          
           EXEC SQL                                                     
               DECLARE GET_FREEFORM       CURSOR FOR                    
                  SELECT DISTINCT DZ.ADDRESS_ID,                        
                     DZ.ADDR_STREET,                                    
                     DZ.ADDR_CITY_STATE,                                
                     DZ.ADDR_ZIP_CODE,                                  
                     DZ.ADDR_COUNTRY,                                   
                     DZ.ADDRESS_OVERFLOW,                               
                     DZ.ZIP_CODE_TOKEN,                                 
                     DZ.USPS_DELIV_PT_CD,                               
                     DZ.ADDR_STREET_2                                   
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FREEFORM  DZ WITH(READUNCOMMITTED)                
                WHERE                                                   
                     AT.ADDRESS_ID  = DZ.ADDRESS_ID                     
                FOR READ ONLY                                   
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET_FREEFORM       CURSOR FOR                            
MFA-TR*           SELECT DISTINCT DZ.ADDRESS_ID,                                
MFA-TR*              DZ.ADDR_STREET,                                            
MFA-TR*              DZ.ADDR_CITY_STATE,                                        
MFA-TR*              DZ.ADDR_ZIP_CODE,                                          
MFA-TR*              DZ.ADDR_COUNTRY,                                           
MFA-TR*              DZ.ADDRESS_OVERFLOW,                                       
MFA-TR*              DZ.ZIP_CODE_TOKEN,                                         
MFA-TR*              DZ.USPS_DELIV_PT_CD,                                       
MFA-TR*              DZ.ADDR_STREET_2                                           
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_ADDR_FREEFORM  DZ                                      
MFA-TR*         WHERE                                                           
MFA-TR*              AT.ADDRESS_ID  = DZ.ADDRESS_ID                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       END-EXEC                                                          
                                                                        
 0040  PROCEDURE DIVISION.                                              
           PERFORM 1000-GET-ADDRESS-ROWS THRU 1000-EXIT.                
           PERFORM 9700-END              THRU 9700-EXIT.                
                                                                        
       1000-GET-ADDRESS-ROWS.                                           
           PERFORM 1010-GET-ZIP-CODES    THRU 1010-EXIT.                
           OPEN OUTPUT OUTFORM OUTFREE MAILFILE.                        
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                   TO WS-RD-YY.                    
           MOVE WS-CM                   TO WS-RD-MM.                    
           MOVE WS-CD                   TO WS-RD-DD.                    
A00633     MOVE 'OPEN '                 TO WS-FUNCTION.                 
A00633     MOVE '1000-GET-ADDRESS-ROWS' TO WS-PARAGRAPH.                
A00633     MOVE 'CSS_ADDR_FORMATTED'    TO WS-TABLE-ID.                 
A00633     DISPLAY 'PCSCA376 - PROCESSING FORMATTED ADDRESSES'          
                                                                        
           EXEC SQL                                                     
               OPEN GET_FORMATTED                                       
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     PERFORM 5010-SQL-CHECK        THRU 5010-EXIT.                
A00633     MOVE 'FETCH'                    TO WS-FUNCTION.              
           PERFORM 7020-FORMATTED        THRU 7020-EXIT.                
A00633     PERFORM 5010-SQL-CHECK        THRU 5010-EXIT.                
           PERFORM UNTIL SQLCODE NOT = 0                                
               PERFORM 1050-LOAD-FORMATTED THRU 1050-EXIT               
               PERFORM 7020-FORMATTED THRU 7020-EXIT                    
A00633         PERFORM 5010-SQL-CHECK     THRU 5010-EXIT                
               END-PERFORM.                                             
A00633     MOVE 'CLOSE'                    TO WS-FUNCTION.              
           EXEC SQL                                                     
               CLOSE GET_FORMATTED                                      
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     PERFORM 5010-SQL-CHECK THRU 5010-EXIT.                       
           DISPLAY WS-FORMATTED-CT ' ROWS SELECTED'                     
                                                                        
A00633     DISPLAY 'PCSCA376 - PROCESSING FREEFORM  ADDRESSES'          
A00633     MOVE 'OPEN '                 TO WS-FUNCTION.                 
A00633     MOVE '1000-GET-ADDRESS-ROWS' TO WS-PARAGRAPH.                
A00633     MOVE 'GET_FREEFORM  '        TO WS-TABLE-ID.                 
           EXEC SQL                                                     
               OPEN GET_FREEFORM                                        
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     PERFORM 5010-SQL-CHECK        THRU 5010-EXIT.                
           PERFORM 7040-FREEFORM         THRU 7040-EXIT.                
A00633     PERFORM 5010-SQL-CHECK        THRU 5010-EXIT.                
A00633     MOVE 'FETCH'                 TO WS-FUNCTION.                 
A00633     MOVE '1000-GET-ADDRESS-ROWS' TO WS-PARAGRAPH.                
A00633     MOVE 'GET_FREEFORM  '        TO WS-TABLE-ID.                 
           PERFORM UNTIL SQLCODE NOT = 0                                
               WRITE FREEFORM-REC FROM DCLCSS-ADDR-FREEFORM             
               ADD +1 TO WS-FREEFORM-CT                                 
               IF WS-FREEFORM-TEST = 0                                  
                    DISPLAY WS-FREEFORM-CT ' ROWS SELECTED'             
               END-IF                                                   
               PERFORM 7040-FREEFORM          THRU 7040-EXIT            
A00633         PERFORM 5010-SQL-CHECK  THRU 5010-EXIT                   
               END-PERFORM.                                             
A00633     MOVE 'CLOSE'                 TO WS-FUNCTION.                 
A00633     MOVE '1000-GET-ADDRESS-ROWS' TO WS-PARAGRAPH.                
A00633     MOVE 'GET_FREEFORM  '        TO WS-TABLE-ID.                 
           EXEC SQL                                                     
               CLOSE GET_FREEFORM                                       
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           DISPLAY WS-FREEFORM-CT ' ROWS SELECTED'.                     
       1000-EXIT.                                                       
           EXIT.                                                        
       1010-GET-ZIP-CODES.                                              
           SET I TO 1.                                                  
           DISPLAY 'PCSCA376 - LOADING ZIP CODE TABLE'.                 
A00633     MOVE '1010-GET-ZIP-CODES'   TO WS-PARAGRAPH.                 
A00633     MOVE 'CSS_ZIP_CODE   '      TO WS-TABLE-ID.                  
A00633     MOVE 'OPEN'                 TO WS-FUNCTION.                  
           EXEC SQL                                                     
               OPEN ZIP_CODE_CURSOR                                     
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     PERFORM 5010-SQL-CHECK THRU 5010-EXIT.                       
A00633     MOVE 'FETCH'                 TO WS-FUNCTION.                 
           PERFORM 7010-READ-ZIPS     THRU 7010-EXIT.                   
           PERFORM UNTIL END-OF-ZIPS                                    
               MOVE DCLCSS-ZIP-CODE TO ZIP-CITY-STATE (I)               
T35511         SET I UP BY 1                                            
               PERFORM 7010-READ-ZIPS  THRU 7010-EXIT                   
A00633         PERFORM 5010-SQL-CHECK  THRU 5010-EXIT                   
           END-PERFORM.                                                 
                                                                        
A00633     MOVE 'CLOSE'                TO WS-FUNCTION.                  
           EXEC SQL                                                     
               CLOSE ZIP_CODE_CURSOR                                    
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     PERFORM 5010-SQL-CHECK  THRU 5010-EXIT.                      
       1010-EXIT.                                                       
                                                                        
       1050-LOAD-FORMATTED.                                             
           MOVE ' '                  TO OUT-ADDR-LINE                   
A00633                                  OUT-CITY-STATE                  
           MOVE DY-ADDRESS-ID        TO OUT-ADDR-ID                     
           MOVE DY-HOUSE-NO          TO OUT-ADDR-HOUSE                  
           MOVE DY-ADDR-PREFIX-1     TO OUT-ADDR-PREF1                  
           MOVE DY-ADDR-PREFIX-2     TO OUT-ADDR-PREF2                  
           MOVE DY-STREET-NAME       TO OUT-ADDR-ST                     
           MOVE DY-STREET-SUFFIX     TO OUT-ADDR-SUF                    
           MOVE DY-ADDR-SUFFIX       TO OUT-ADDR-PDIR                   
           MOVE DY-STREET-LOCATION-1 TO OUT-ADDR-LOC                    
           MOVE DY-STREET-LOCATION-2 TO OUT-ADDR-LOC-NO                 
           MOVE DY-ZIP-CODE          TO OUT-ZIP-CODE                    
           MOVE DY-ZIP-CODE-PLUS-FOUR TO OUT-ZIP-PLUS4                  
           MOVE DY-USPS-DELIV-PT-CD   TO OUT-DELIV-PT                   
           INSPECT OUT-ADDR-ST REPLACING ALL '-' BY ' '                 
           IF DY-ZIP-CODE = ZIP-CODE (I) AND                            
              A4-ZIP-CODE-TOKEN = ZIP-TOKEN (I)                         
                MOVE ZIP-TAB-CITY (I) TO OUT-CITY                       
                MOVE ZIP-TAB-ST   (I) TO OUT-ST                         
                MOVE ZIP-TOKEN    (I) TO OUT-ZIP-TOKEN                  
             ELSE                                                       
                PERFORM 5000-SEARCH THRU 5000-EXIT                      
           END-IF                                                       
           WRITE OUT-FORMATTED.                                         
           ADD +1 TO WS-FORMATTED-CT.                                   
           IF WS-FORMATTED-TEST = 0                                     
               DISPLAY WS-FORMATTED-CT ' ROWS SELECTED'                 
           END-IF.                                                      
       1050-EXIT.                                                       
           EXIT.                                                        
       5000-SEARCH.                                                     
           MOVE DY-ZIP-CODE TO WS-ZIP.                                  
           MOVE DY-ZIP-CODE-TOKEN TO WS-TOKEN.                          
           SEARCH ALL ZIP-CITY-STATE                                    
               AT END                                                   
                   MOVE 'UNKNOWN'        TO OUT-CITY-STATE              
T35511         WHEN ZIP-AND-TOKEN    (I)  = WS-ZIP-AND-TOKEN            
                   MOVE ZIP-TAB-CITY (I) TO OUT-CITY                    
                   MOVE ZIP-TOKEN    (I) TO OUT-ZIP-TOKEN               
                   MOVE ZIP-TAB-ST   (I) TO OUT-ST.                     
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00633 5010-SQL-CHECK.                                                  
           IF SQLCODE NOT = 0 AND 100                                   
               MOVE 12 TO WS-EOJ-CODE                                   
               PERFORM 9500-ABEND    THRU 9500-EXIT                     
           END-IF.                                                      
A00633 5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-READ-ZIPS.                                                  
           MOVE 'FETCH'                TO WS-FUNCTION.                  
           MOVE '7010-READ-ZIPS'       TO WS-PARAGRAPH.                 
           MOVE 'ZIP_CODE_CURSOR'      TO WS-TABLE-ID.                  
           EXEC SQL                                                     
               FETCH ZIP_CODE_CURSOR INTO                               
                   :A4-ZIP-CODE,                                        
                   :A4-ZIP-CODE-TOKEN,                                  
                   :A4-TOWN,                                            
                   :A4-STATE                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     MOVE A4-ZIP-CODE TO WS-KEY.                                  
                                                                        
           IF SQLCODE = 100                                             
               MOVE 'Y' TO WS-ZIP-SW                                    
           END-IF.                                                      
A00633     PERFORM 5010-SQL-CHECK THRU 5010-EXIT                        
ACT120     IF  I > 60000                                                
               DISPLAY '************************************'           
               DISPLAY '************************************'           
               DISPLAY WS-OVERFLOW-LINE                                 
               DISPLAY '************************************'           
               DISPLAY '************************************'           
               SET END-OF-FILE TO TRUE                                  
               SET END-OF-ZIPS TO TRUE                                  
               MOVE 12 TO WS-EOJ-CODE                                   
           END-IF.                                                      
ACT120     IF  I > 59900                                                
               MOVE 05 TO WS-EOJ-CODE                                   
               PERFORM 9000-MAIL-RTN THRU 9000-EXIT                     
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
       7020-FORMATTED.                                                  
           MOVE SPACES TO DCLCSS-ADDR-FORMATTED.                        
           EXEC SQL                                                     
               FETCH GET_FORMATTED INTO                                 
                 :DY-ADDRESS-ID,                                        
                 :DY-HOUSE-NO,                                          
                 :DY-ADDR-PREFIX-1,                                     
                 :DY-ADDR-PREFIX-2,                                     
                 :DY-STREET-NAME,                                       
                 :DY-STREET-LOCATION-1,                                 
                 :DY-STREET-LOCATION-2,                                 
                 :DY-STREET-SUFFIX,                                     
                 :DY-ADDRESS-OVERFLOW,                                  
                 :DY-CARRIER-ROUTE,                                     
                 :DY-ZIP-CODE,                                          
                 :DY-ZIP-CODE-PLUS-FOUR,                                
                 :DY-ZIP-CODE-TOKEN,                                    
                 :DY-ADDR-USAGE-CD,                                     
                 :DY-ADDR-SUFFIX,                                       
                 :DY-USPS-DELIV-PT-CD                                   
                 END-EXEC.                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     MOVE DY-ADDRESS-ID TO WS-ADDRESS-ID.                         
       7020-EXIT.                                                       
           EXIT.                                                        
       7040-FREEFORM.                                                   
           MOVE SPACES TO DCLCSS-ADDR-FREEFORM.                         
           EXEC SQL                                                     
               FETCH GET_FREEFORM INTO                                  
                 :DZ-ADDRESS-ID,                                        
                 :DZ-ADDR-STREET,                                       
                 :DZ-ADDR-CITY-STATE,                                   
                 :DZ-ADDR-ZIP-CODE,                                     
                 :DZ-ADDR-COUNTRY,                                      
                 :DZ-ADDRESS-OVERFLOW,                                  
                 :DZ-ZIP-CODE-TOKEN,                                    
                 :DZ-USPS-DELIV-PT-CD,                                  
                 :DZ-ADDR-STREET-2                                      
                 END-EXEC.                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00633     MOVE DZ-ADDRESS-ID TO WS-ADDRESS-ID.                         
       7040-EXIT.                                                       
           EXIT.                                                        
A00633 9000-MAIL-RTN.                                                   
           MOVE 'PCSCA376'           TO MAIL2-JOB-NAME                  
                                        MAIL5-JOB-NAME.                 
           MOVE WS-RUN-DATE          TO WS-SUB-DATE.                    
           MOVE WS-SUBJECT           TO MAIL7-SUBJECT.                  
           WRITE MAIL-REC FROM MAILHEAD-1.                              
           WRITE MAIL-REC FROM MAILHEAD-2.                              
           WRITE MAIL-REC FROM MAILHEAD-3.                              
           WRITE MAIL-REC FROM MAILHEAD-4.                              
           WRITE MAIL-REC FROM MAILHEAD-5.                              
           WRITE MAIL-REC FROM MAILHEAD-6.                              
           WRITE MAIL-REC FROM MAILHEAD-7.                              
           WRITE MAIL-REC FROM MAILHEAD-8.                              
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-WARNING-LINE1.                        
           WRITE MAIL-REC FROM WS-WARNING-LINE2.                        
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-AST-LINE.                             
A00633 9000-EXIT.                                                       
           EXIT.                                                        
A00633 9500-ABEND.                                                      
A00633     DISPLAY 'PCSCA376 - SQLCODE =     ' SQLCODE.                 
A00633     DISPLAY 'PCSCA376 - PARAGRAPH =   ' WS-PARAGRAPH.            
A00633     DISPLAY 'PCSCA376 - TABLE    =    ' WS-TABLE-ID.             
A00633     DISPLAY 'PCSCA376 - FUNCTION =    ' WS-FUNCTION.             
A00633     DISPLAY 'PCSCA376 - KEY =         ' WS-KEY.                  
A00633     MOVE 12 TO WS-EOJ-CODE.                                      
A00633     PERFORM 9700-END THRU 9700-EXIT.                             
A00633 9500-EXIT.                                                       
A00633     EXIT.                                                        
       9700-END.                                                        
           CLOSE OUTFORM OUTFREE MAILFILE.                              
           MOVE WS-EOJ-CODE TO RETURN-CODE.                             
           STOP RUN.                                                    
       9700-EXIT.                                                       
           EXIT.                                                        
