       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      PCSCA375.                                       
       AUTHOR.          JASON WRIGHT.                                   
       DATE-WRITTEN.    AUGUST 1999.                                    
      ***************************************************************** 00050000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00060000
      ***************************************************************** 00070000
      **                                                             ** 00080000
      **              PROGRAM  MODIFICATION  LOG                     ** 00090000
      **                                                             ** 00100000
      **    DATE    INITIALS     REASON                              ** 00110000
      **    -----   --------     ------                              ** 00120000
      **    08/99   J WRIGHT     INITIAL VERSION OF PROGRAM          ** 00130000
T20788**    09/99   J WRIGHT     MODIFY PROGRAM TO CREATE TWO FILES  ** 00140000
      **                         TO BE USED IN GENERATING REPORTS    ** 00150000
      **                         ON WHAT UPDATED, AND WHAT CODE1     ** 00160000
      **                         RETURNED NO VALUES FOR.             ** 00170000
T21097**    11/99   J WRIGHT     PROGRAM CHANGED TO ALLOW FOR +100'S ** 00180000
      **                         IN THE UPDATE SQL.                  ** 00190000
T21097**    03/01   BD09555      ADD ADDRESS TYPE TO OUTPUT FILE.    ** 00200000
      **                         "F" IS FORMATTED; "U" IS FREEFORM.  ** 00210000
      **    04/01   BD09555      PROGRAM NOW COPIES THE INPUT ZIP TO ** 00220000
      **                         THE CODE1-SUPPLIED ZIP IF THE       ** 00230000
      **                         CODE1-SUPPLIED ZIP IS BLANK.  THIS  ** 00240000
      **                         IS TO PREVENT ZIP CODES FROM BEING  ** 00250000
      **                         BLANKED OUT.                        ** 00260000
      **    06/01   BD09555      MOVED CODE AROUND FROM PREVIOUS     ** 00270000
      **                         CHAGNE.                             ** 00280000
T27413**    09/02   EM19682      ADDED CODE TO WRITE A WQ RATHER THAN** 00290000
T27413**                         UPDATE TABLE.                       ** 00300000
T27914**    11/02   CB18344      ADDED CODE FOR FIELDS IN DIFFERENT  ** 00310000
T27914**                         PLACES FOR CODE1 SOFTWARE VERSUS    ** 00320000
T27914**                         FINALIST SOFTWARE.                  ** 00330000
T27914**    08/04   BD09555      INPUT FILE RECORD LENGTH WAS        ** 00340000
T27914**                         INCREASED AS THE RESULT OF CHANGES  ** 00350000
T27914**                         IN THE NEW VERSION OF FINALIST.     ** 00360000
T27914**    04/06   BD09555      CHECK NEW LO/ROUTE AND SUBDIVSION   ** 00370000
T27914**                         TABLES FOR NEW ZIP CODE WHEN THERE  ** 00380000
T27914**                         IS A CHANGE.  IF IT'S NOT ON EITHER ** 00390000
T27914**                         OF THE TABLES, GENERATE A WORK QUEUE** 00400000
T27914**    05/06   BD09555      UPDATE TRANSACTION HISTORY.  THIS   ** 00410000
T27914**                         WAS PREVIOUSLY DONE IN A SEPARATE   ** 00420000
T27914**                         STEP.  ALSO, CREATE A FILE FOR EACH ** 00430000
T27914**                         UPDATE DONE TO ACCOUNT OR PREMISE,  ** 00440000
T27914**                         INSTEAD OF ONE FOR EACH ADDRESS.    ** 00450000
T27914**    05/07   BD09555      INPUT FILE FORMAT CHANGES.  ALSO,   ** 00460000
T27914**                         NO LONGER PROCESS CARRIER ROUTES.   ** 00470000
T27914**    05/07   BD09555      ADD NEW LOGIC TO PREVENT MASSIVE    ** 00480000
T27914**                         ERRONEOUS UPDATES.                  ** 00490000
T27914**    06/07   BD09555      RECORD LAYOUT CHANGES FOR INCREASED ** 00500000
T27914**                         ADDRESS OVERFLOW.                   ** 00510000
T27914**    07/07   BD09555      BLANK OUT ZIP+4 AND DELIVERY POINT  ** 00520000
T27914**                         WHEN THE ADDRESS PASSES FINALIST    ** 00530000
T27914**                         VALIDATION BUT FAILS DPV.           ** 00540000
T27914**                         ALSO CORRECT BUG WHEN PARM IS USED  ** 00550000
T27914**                         BEFORE PROGRAM TAKES FIRST FREEFORM ** 00560000
T27914**                         COMMIT.                             ** 00570000
T36287**    10/07   BD09555      KEEP TOWN NAME WHEN ZIP CODE CHANGES** 00580000
T36287**                         AND UPDATE TRANS HIST WHEN THE ZIP  ** 00590000
T36287**                         TOKEN CHANGES.                      ** 00600000
T36295**    10/07   DB41297      UPDATE CSS_NAME_ACCT_XREF WHEN TOWN ** 00601000
T36295**                         NAME CHANGES.                       ** 00602000
A02034**    08/10   BD09555      CLEAN UP ERRORS.  ADD QUERY NUMBERS ** 00602100
A04860**    06/14   AS7C117      REPLACE CSS_WQ_ITEMS_MF WITH        ** 00602110
A04860**                         CSS_WQ_ITEMS.                       ** 00602120
PRJ910** 10/19/15   SM93554      CHANGED THE LAYOUT LENGTH AS PART   ** 00602120
      **                         NEW SPECTRUM PROCESS.               ** 00602120
PRJ910** 11/13/15   SM93554      MADE SLIGHT CHANGES ON TERMINATE    ** 00602120
      **                         PROCESS.                            ** 00602120
PRJ910** 11/20/15   SM93554      CHANGED THE PARM LAYOUT TYPE        ** 00602120
      **                                                             ** 00602120
ACT099** 03/36/16   BD09555      CHANGE TO TAKE A COMMIT EVERY 100   ** 00602120
ACT099**A05460-ACT099            UPDATES                             ** 00602120
      ***************************************************************** 00602200
      **              PROGRAM NARRATIVE                              ** 00602300
      ***************************************************************** 00602400
      **  THIS PROGRAM COMPARES OUTPUT FROM CODE1 WITH DATA IN FLAT  ** 00602500
      **  FILES PULLED FROM THE CSS_ADDR_FREEFORM AND                ** 00602600
      **  CSS_ADDR_FORMATTED TABLES.  IF THE INFORMATION IS DIFFERENT** 00602700
      **  IT UPDATES THOSE TABLES.  IF ANY OF THE INFORMATION        ** 00602800
      **  RETURNED BY CODE1 IS BLANK, IT MOVES SPACES TO THE ZIP     ** 00602900
      **  PLUS FOUR, CARRIER ROUTE, AND DELIVERY POINT FIELDS SO     ** 00603000
      **  A BAR CODE WILL NOT BE PRINTED.                            ** 00604000
      ***************************************************************** 00605000
      *                                                                 00606000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT FREEFORM-FILE                                         
               ASSIGN TO FREEFILE.                                      
           SELECT FORMATTED-FILE                                        
               ASSIGN TO FORMFILE.                                      
T20788     SELECT AUTO-UPDATED                                          
T20788         ASSIGN TO AUTOUPDT.                                      
T20788     SELECT UNMATCHED-ADDR                                        
T20788         ASSIGN TO UMCHADDR.                                      
T27413     SELECT ZIPCODE-RPT                                           
T27413         ASSIGN TO ZIPRPT.                                        
      *                                                                 00710000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD FREEFORM-FILE.                                                
T27914*01 FREEFORM                         PIC X(1300).                 00750000
PRJ910 01 FREEFORM                         PIC X(613).                  
      *                                                                 00760000
       FD FORMATTED-FILE.                                               
T27914*01 FORMATTED                        PIC X(1300).                 00780000
PRJ910 01 FORMATTED                        PIC X(613).                  
      *                                                                 00790000
T20788 FD AUTO-UPDATED                                                  
           BLOCK CONTAINS 0 RECORDS.                                    
T20788 01 AUTO-UPDATED-LINE                PIC X(223).                  
      *                                                                 00830000
T20788 FD  UNMATCHED-ADDR                                               
           BLOCK CONTAINS 0 RECORDS.                                    
T27914 01  UNMATCHED-ADDR-LINE              PIC X(121).                 
      *                                                                 00870000
T27413 FD  ZIPCODE-RPT                                                  
           BLOCK CONTAINS 0 RECORDS.                                    
T27413 01  MAIL-REC                         PIC X(080).                 
      *                                                                 00910000
       WORKING-STORAGE SECTION.                                         

MSQ008  01 MSQ008-ZIP-CURSOR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA375'.
MSQ017     COPY MFASQLM.
      *                                                                 00930000
                                                                        
       01  WS-FREEFORM.                                                 
PRJ910     05  WS-FREE-ADDR-ID             PIC 9(13).                   
T36287     05  WS-FREE-STREET-ADDR-INP     PIC X(61).                   
           05  WS-FREE-ADDR-OFLOW-INP      PIC X(35).                   
T36287     05  WS-FREE-CITY-STATE-INP      PIC X(30).                   
           05  WS-FREE-ZIP-INP             PIC X(5).                    
           05  WS-FREE-PFOUR-INP           PIC X(4).                    
           05  WS-FREE-DP-INP              PIC XX.                      
T36287     05  FILLER                      PIC X(74).                   
           05  WS-FREE-STREET-ADDR-RET     PIC X(35).                   
           05  FILLER                      PIC X(35).                   
           05  WS-FREE-OVERFLOW-RET        PIC X(20).                   
           05  FILLER                      PIC X(76).                   
           05  WS-FREE-CITY-RET            PIC X(28).                   
           05  WS-FREE-STATE-RET           PIC X(2).                    
           05  FILLER                      PIC X(49).                   
           05  WS-FREE-ZIP-RET             PIC X(5).                    
           05  WS-FREE-PFOUR-RET           PIC X(4).                    
           05  WS-FREE-DP-RET              PIC X(2).                    
           05  FILLER                      PIC X(96).                   
           05  WS-FREE-DPV-RET-CD          PIC X.                       
           05  FILLER                      PIC X(26).                   
           05  WS-FREE-FIN-RET-CD          PIC X(4).                    
           05  FILLER                      PIC X(4).                    
           05  WS-FREE-LACS-RET-CD         PIC XX.                      
T36287  01 ZIP-TABLE                                 VALUE SPACES.      
T36287     05  WS-A4-ZIP-CODE              PIC X(5)  OCCURS 9.          
T36287     05  WS-A4-ZIP-CODE-TOKEN        PIC X     OCCURS 9.          
T36287     05  WS-A4-TOWN                  PIC X(26) OCCURS 9.          
T36287     05  WS-A4-STATE                 PIC X(2)  OCCURS 9.          
T36287  01 FILLER REDEFINES ZIP-TABLE.                                  
T36287     05  FILLER                      PIC X(5)  OCCURS 9.          
T36287     05  WS-A4-ZIP-CODE-TOKEN-NUM    PIC 9     OCCURS 9.          
T36287     05  FILLER                      PIC X(26) OCCURS 9.          
T36287     05  FILLER                      PIC X(2)  OCCURS 9.          
                                                                        
T36287  01 ZIP-TOKEN-TABLE.                                             
T36287     05  WS-NEW-TOKENS               PIC X(9)                     
T36287         VALUE '123456789'.                                       
T36287     05  WS-NEW-ZIP-TOKEN REDEFINES WS-NEW-TOKENS                 
                                           PIC X OCCURS 9.              
        01  WS-FORMATTED.                                               
PRJ910     05  WS-FORM-ADDR-ID             PIC 9(13).                   
T36287     05  WS-FORM-STREET-ADDR-INP     PIC X(61).                   
           05  WS-FORM-ADDR-OFLOW-INP      PIC X(35).                   
           05  WS-FORM-CITY-STATE-INP.                                  
               07  WS-FORM-CITY-INP        PIC X(26).                   
               07  FILLER                  PIC X.                       
               07  WS-FORM-STATE-INP       PIC XX.                      
T36287         07  FILLER                  PIC X.                       
           05  WS-FORM-ZIP-INP             PIC X(5).                    
           05  WS-FORM-PFOUR-INP           PIC X(4).                    
           05  WS-FORM-DP-INP              PIC XX.                      
T36287     05  WS-FORM-ZIP-TOKEN           PIC X.                       
T36287     05  FILLER                      PIC X(73).                   
           05  WS-FORM-STREET-ADDR-RET     PIC X(35).                   
           05  FILLER                      PIC X(35).                   
           05  WS-FORM-OVERFLOW-RET        PIC X(20).                   
           05  FILLER                      PIC X(76).                   
           05  WS-FORM-CITY-RET            PIC X(28).                   
           05  WS-FORM-STATE-RET           PIC X(2).                    
           05  FILLER                      PIC X(49).                   
           05  WS-FORM-ZIP-RET             PIC X(5).                    
           05  WS-FORM-PFOUR-RET           PIC X(4).                    
           05  WS-FORM-DP-RET              PIC X(2).                    
           05  FILLER                      PIC X(96).                   
           05  WS-FORM-DPV-RET-CD          PIC X.                       
           05  FILLER                      PIC X(26).                   
           05  WS-FORM-FIN-RET-CD          PIC X(4).                    
           05  FILLER                      PIC X(4).                    
           05  WS-FORM-LACS-RET-CD         PIC XX.                      
T20788 01  WS-OUTPUT-LINES.                                             
T20788     05  WS-AUTO-UPDATED-LINE.                                    
T20788         10  WS-AUTO-ADDRESS-ID      PIC 9(13).                   
T20788         10  WS-AUTO-ADDRESS-TYPE    PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-STREET-ADDR     PIC X(37).                   
T20788         10  WS-AUTO-PREM-MAIL-ADDR  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-ADDR-OFLOW      PIC X(35).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-CITY-STATE      PIC X(20).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-ZIP-CODE        PIC X(5).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-PFOUR           PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-CR              PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-DP              PIC X(2).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-STREET-CD1      PIC X(35).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T27914         10  WS-AUTO-CITY-STATE-CD1.                              
T27914             15  WS-AUTO-CITY-CD1    PIC X(13).                   
T27914             15  WS-AUTO-STATE-CD1   PIC X(2).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-ZIP-CD1         PIC X(5).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-PFOUR-CD1       PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-CR-CD1          PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-DP-CD1          PIC X(2).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-ACCOUNT         PIC 9(13).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-AUTO-PREMISE         PIC 9(10).                   
      *                                                                 02020000
T20788     05  WS-UPDATE-FAILED-LINE.                                   
COB305         10 WS-FAIL-ADDRESS-ID        PIC S9(13) COMP-3 VALUE 0.          
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-STREET-ADDR     PIC X(37).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-ADDR-OFLOW      PIC X(35).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-CITY-STATE      PIC X(20).                   
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-ZIP-CODE        PIC X(5).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-PFOUR           PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-CR              PIC X(4).                    
T20788         10  FILLER                  PIC X      VALUE SPACES.     
T20788         10  WS-FAIL-DP              PIC X(2).                    
T27413*                                                                 02190000
T27413 01  WS-LINE-80                      PIC X(080) VALUE ALL '-'.    
T27413 01  WS-BLANK-LINE-80                PIC X(080) VALUE SPACES.     
T27413 01  WS-HEADING-LINES.                                            
T27413     05  WS-RPT-HEADER-1.                                         
T27413         10  FILLER                  PIC X(06) VALUE 'DATE: '.    
T27413         10  P-RPT-DATE              PIC X(08).                   
T27413         10  FILLER                  PIC X(14) VALUE SPACES.      
T27413         10  FILLER                  PIC X(22) VALUE              
T27413                                     'ZIP CODE UPDATE REPORT'.    
T27413         10  FILLER                  PIC X(29) VALUE SPACES.      
T27413*                                                                 02300000
T27413     05  WS-RPT-HEADER-2.                                         
T27413         10  FILLER                  PIC X(08) VALUE 'PCSCA375'.  
T27413         10  FILLER                  PIC X(59) VALUE SPACES.      
T27413         10  FILLER                  PIC X(06) VALUE 'PAGE: '.    
T27413         10  P-RPT-PAGE-NO           PIC ZZ,ZZ9.                  
T27413*                                                                 02360000
T27413     05  WS-RPT-HEADER-3.                                         
T27413         10  FILLER                  PIC X(25) VALUE SPACES.      
T27413         10  FILLER                  PIC X(14) VALUE              
T27413                                     'ACCOUNT NUMBER'.            
T27413         10  FILLER                  PIC X(09) VALUE SPACES.      
T27413         10  FILLER                  PIC X(08) VALUE 'ZIP CODE'.  
T27413         10  FILLER                  PIC X(23) VALUE SPACES.      
T27413*                                                                 02440000
T27413 01  WS-DETAIL-LINES.                                             
T27413     05  WS-DETAIL-LINE-1.                                        
T27413         10  FILLER                  PIC X(23) VALUE SPACES.      
T27413         10  D-ACCT-NUM              PIC X(16).                   
T27413         10  FILLER                  PIC X(07) VALUE SPACES.      
T27413         10  D-ZIP-CODE-5            PIC X(05).                   
T27413         10  FILLER                  PIC X(01) VALUE '-'.         
T27413         10  D-ZIP-CODE-4            PIC X(04).                   
T27413         10  FILLER                  PIC X(23) VALUE SPACES.      
T27413*                                                                 02540000
T27413 01  WS-CURRENT-DATE.                                             
T27413     05  WS-CY                       PIC 9(02).                   
T27413     05  WS-CM                       PIC 9(02).                   
T27413     05  WS-CD                       PIC 9(02).                   
T27413*                                                                 02590000
T27413 01  WS-RUN-DATE.                                                 
T27413     05  WS-RD-MM                    PIC X(02).                   
T27413     05  FILLER                      PIC X(01) VALUE '/'.         
T27413     05  WS-RD-DD                    PIC X(02).                   
T27413     05  FILLER                      PIC X(01) VALUE '/'.         
T27413     05  WS-RD-YY                    PIC X(02).                   
T27413*                                                                 02660000
       01  WS-SUBJECT.                                                  
           05  FILLER                  PIC X(35)    VALUE               
           'PCSCA375 ERROR NOTED IN PROCESSING'.                        
                                                                        
       01  MAILHEAD-1.                                                  
           05  FILLER                  PIC X(22) VALUE                  
               'HELO DOMAIN:     SCANA'.                                
                                                                        
       01  MAILHEAD-2.                                                  
           05  FILLER                      PIC X(14) VALUE              
               'MAIL FROM:   <'.                                        
           05  MAIL2-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
       01  MAILHEAD-3.                                                  
           05  FILLER                      PIC X(39) VALUE              
               'RCPT TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                 
                                                                        
       01  MAILHEAD-4.                                                  
           05  FILLER                      PIC X(04) VALUE              
               'DATA'.                                                  
                                                                        
       01  MAILHEAD-5.                                                  
           05  FILLER                      PIC X(18) VALUE              
               'FROM: CSR PAGING <'.                                    
           05  MAIL5-JOB-NAME              PIC X(08).                   
           05  FILLER                      PIC X(20) VALUE              
               '@SCEGJES2.SCANA.COM>'.                                  
                                                                        
       01  MAILHEAD-6.                                                  
           05  FILLER                      PIC X(34) VALUE              
               'TO: <ISTCSR-BILLPRINT@SCANA.COM>'.                      
       01  MAILHEAD-7.                                                  
           05  FILLER                      PIC X(10) VALUE              
               'SUBJECT:  '.                                            
           05  MAIL7-SUBJECT               PIC X(38).                   
                                                                        
       01  MAILHEAD-8.                                                  
           05  FILLER                      PIC X(80) VALUE SPACES.      
       01  WS-AST-LINE                     PIC X(58) VALUE ALL '*'.     
                                                                        
       01  WS-TOKENS-MSG1.                                              
           05  FILLER                      PIC X(45) VALUE              
               'PCSCA375 - ALL AVAILABLE TOKENS USED FOR ZIP '.         
           05  WS-TOKENS-MSG-ZIP            PIC X(5).                   
       01  WS-TOKENS-MSG2.                                              
           05  FILLER                      PIC X(16) VALUE              
               'PCSCA375 - TOWN '.                                      
           05 WS-TOKENS-MSG-TOWN           PIC X(26).                   
           05  FILLER                      PIC X(33) VALUE              
               ' NOT ADDED; DEFAULTING TO TOKEN 1'.                     
T27413*                                                                 03190000
T27413 01  WS-NO-DATA-LINE.                                             
T27413     05  FILLER                      PIC X(28) VALUE SPACES.      
T27413     05  FILLER                      PIC X(22) VALUE              
T27413               '** NO DATA THIS RUN **'.                          
T27413     05  FILLER                      PIC X(29) VALUE SPACES.      
T27413*                                                                 03250000
T27413 01  WS-RPT-LINE-NO                  PIC 9(02) VALUE ZERO.        
T27413 01  WS-RPT-PAGE-NO                  PIC 9(04) VALUE ZERO.        
T27413 01  WS-WORKQ-LINE.                                               
           03  FILLER                       PIC X(51) VALUE             
               'ZIP CD COMBO NOT FOUND VIA SCRUB PGM-ADD TO TABLES '.   
           03  FILLER                       PIC X(4)  VALUE 'ZIP '.     
           03  WS-WQ-ZIP                    PIC X(5).                   
           03  FILLER                       PIC X(4)  VALUE ' LO '.     
           03  WS-WQ-LO                     PIC X(3).                   
           03  FILLER                       PIC X(7)  VALUE ' ROUTE '.  
           03  WS-WQ-ROUTE                  PIC 9(4).                   
           03  FILLER                       PIC X(10) VALUE             
                                                      ' REV DIST '.     
           03  WS-WQ-REV-DIST               PIC X(3).                   
           03  FILLER                       PIC X(6)  VALUE ' SUBD '.   
           03  WS-WQ-SUBD                   PIC X(3).                   
      *                                                                 03330000
       01  WS-MISC.                                                     
           05  WS-SUBDIV-SW                PIC X(1).                    
           05  WS-LO-RT-SW                 PIC X(1).                    
           05  WS-FOUND-ACCT               PIC X(1).                    
               88 WE-FOUND-AN-ACCOUNT               VALUE 'Y'.          
               88 WE-DID-NOT-FIND-AN-ACCOUNT        VALUE 'N'.          
           05  WS-FOUND-PREM               PIC X(1).                    
               88 WE-FOUND-A-PREMISE                VALUE 'Y'.          
               88 WE-DID-NOT-FIND-A-PREMISE         VALUE 'N'.          
           05  WS-END-OF-FREEFORM          PIC X(1).                    
               88 END-OF-FREEFORM                   VALUE 'Y'.          
           05  WS-END-OF-FORMATTED         PIC X(1).                    
               88 END-OF-FORMATTED                  VALUE 'Y'.          
           05  WS-ON-TAB-SW                PIC X(1).                    
COB305     05 WS-UPDATED-FIELD-CNTR        PIC S9(7) COMP-3 VALUE 0.            
ACT099     05  WS-FREE-ADDRESSES-UPDATED   PIC  9(7)                    
ACT099             VALUE 0.                                             
           05  FILLER  REDEFINES WS-FREE-ADDRESSES-UPDATED.             
ACT099         10  COMMIT-NUMBER2          PIC 9(5).                    
ACT099         10  TEST-COUNTER2           PIC  99.                     
ACT099     05  WS-FORM-ADDRESSES-UPDATED   PIC 9(7)                     
ACT099             VALUE 0.                                             
           05  FILLER  REDEFINES WS-FORM-ADDRESSES-UPDATED.             
ACT099         10  COMMIT-NUMBER1          PIC 9(5).                    
ACT099         10  TEST-COUNTER1           PIC  99.                     
COB305     05 WS-ADDRESSES-UPDATED        PIC S9(5) COMP-3 VALUE 0.            
COB305     05 WS-ADDRESS-ID        PIC S9(13) COMP-3 VALUE 0.           
COB305     05 WS-FORM-ADDRESS-ID        PIC S9(13) COMP-3 VALUE 0.           
COB305     05 WS-FREE-ADDRESS-ID        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-ZIP-TOKEN                PIC X.                       
           05  PROGRAM-NAME                PIC X(8)   VALUE 'PCSCA375'. 
A04860     05  SCSCB077                    PIC X(8)   VALUE 'SCSCB077'. 
           05  WS-ADDRESS-LOOP             PIC X.                       
               88 WE-FIND-THE-TOWN-NAME    VALUE 'F'.                   
               88 ITS-A-NEW-TOWN-NAME      VALUE 'N'.                   
               88 TABLE-IS-OUT-OF-SPACE    VALUE 'O'.                   
           05  WS-FREEFORM-COUNTER         PIC S9(7) COMP-3 VALUE +0.   
           05  WS-FORMATTED-COUNTER        PIC S9(7) COMP-3 VALUE +0.   
           05  WS-BYPASSED-COUNTER         PIC S9(7) COMP-3 VALUE +0.   
           05  WS-ACCOUNTS-UPDATED         PIC S9(7) COMP-3 VALUE +0.   
           05  WS-PREMISES-UPDATED         PIC S9(7) COMP-3 VALUE +0.   
           05  WS-PCT                      PIC SV999 COMP-3 VALUE +0.   
           05  RS-RETURN-CODE              PIC S9(4) COMP.              
           05  RS-RETURN-CODE-DISP         PIC -Z(4).                   
           05  WS-RETURN-CODE              PIC S9(3)                    
                   VALUE +000.                                          
           05  WS-SQL-RETURN-CODE          PIC S9(3)                    
                   VALUE +000.                                          
           05  WS-FREEFORM-ZIP-UPDATE.                                  
               10 WS-FREE-ZIP-UPD          PIC X(5).                    
               10 WS-FREE-PFOUR-UPD        PIC X(4).                    
           05  WS-FREE-ZIP-UPDATE                                       
               REDEFINES WS-FREEFORM-ZIP-UPDATE PIC X(9).               
           05  WS-TABLE-ID                 PIC X(20)                    
                   VALUE SPACES.                                        
T20788     05  WS-AUTO-FILE-TYPE           PIC X(1)  VALUE ZEROS.       
T20788         88  AUTO-FREEFORM           VALUE '1'.                   
T20788         88  AUTO-FORMATTED          VALUE '2'.                   
T20788     05  WS-FAIL-FILE-TYPE           PIC X(1)  VALUE ZEROS.       
T20788         88  FAIL-FREEFORM           VALUE '1'.                   
T20788         88  FAIL-FORMATTED          VALUE '2'.                   
T20788     05  WS-FORM-CITY-TEMP.                                       
T20788         10  WS-TEMP-CITY            PIC X(17).                   
T20788         10  FILLER                  PIC X     VALUE ','.         
T20788         10  WS-TEMP-STATE           PIC X(2).                    
T20788     05  WS-FORM-STREET-TEMP.                                     
T20788         10  WS-TEMP-STREET-NUM      PIC X(5).                    
T20788         10  FILLER                  PIC X     VALUE SPACES.      
T20788         10  WS-TEMP-STREET-ADDR     PIC X(26).                   
T20788     05  WS-UPDATED-FLAG             PIC X     VALUE 'N'.         
T20788         88  ADDRESS-NOT-UPDATED     VALUE 'N'.                   
T20788         88  ADDRESS-WAS-UPDATED     VALUE 'Y'.                   
T27413     05  WS-52                       PIC 9(02) VALUE 52.          
T27413     05  I                           PIC 9(4)  COMP.              
T27413     05  J                           PIC 9(4)  COMP.              
T27413     05  WS-ACCT-NUM                 PIC 9(13).                   
      *                                                                 04170000
       01  WS-FREE-WARNING.                                             
           05  FILLER                      PIC X(51) VALUE              
               'PCSCA375 - EXCESSIVE NUMBER OF FREEFORM ADDRESSES '.    
           05  FILLER                      PIC X(41) VALUE              
               'UPDATED, EXCEEDING 5% EXPECTED THRESHHOLD'.             
      *                                                                 04230000
       01  WS-FORM-WARNING.                                             
           05  FILLER                      PIC X(52) VALUE              
               'PCSCA375 - EXCESSIVE NUMBER OF FORMATTED ADDRESSES '.   
           05  FILLER                      PIC X(41) VALUE              
               'UPDATED, EXCEEDING 5% EXPECTED THRESHHOLD'.             
      *                                                                 04290000
       01  WS-WARNING2.                                                 
           05  FILLER                      PIC X(53) VALUE              
               'PCSCA375 - REVIEW UPDATES TO DETERMINE WHETHER THESE '. 
           05  FILLER                      PIC X(12) VALUE              
               'ARE VALID - '.                                          
      *                                                                 04350000
       01  WS-WARNING3.                                                 
           05  FILLER                      PIC X(52) VALUE              
               'PCSCA375 - CODE PARM=LET TO ALLOW FURTHER PROCESSING'.  
      *                                                                 04390000
       01  WS-BAD-RETURN-ZIP-MSG1.                                      
           05  FILLER                      PIC X(22) VALUE              
               'PCSCA375 - ADDRESS ID '.                                
      *                                                                 04430000
       01  WS-BAD-RETURN-ZIP-MSG2.                                      
           05  FILLER                      PIC X(40) VALUE              
               ' ATTEMPTING TO ADD NON-NUMERIC ZIP CODE '.              
      *                                                                 04470000
       01  WS-BAD-RETURN-ZIP-MSG3.                                      
           05  FILLER                      PIC X(32) VALUE              
               ' CHECK FOR POSSIBLE FORMAT ERROR'.                      
      *                                                                 04510000
       01  WS-BAD-INPUT-ZIP-MSG1.                                       
           05  FILLER                      PIC X(22) VALUE              
               'PCSCA375 - ADDRESS ID '.                                
      *                                                                 04550000
       01  WS-BAD-INPUT-ZIP-MSG2.                                       
           05  FILLER                      PIC X(11) VALUE              
               ' INPUT ZIP '.                                           
      *                                                                 04590000
       01  WS-BAD-INPUT-ZIP-MSG3.                                       
           05  FILLER                      PIC X(49) VALUE              
               ' IS NOT NUMERIC - CHECK FOR POSSIBLE FORMAT ERROR'.     
                                                                        
      *                                                                 04640000
      *                                                                 04650000
      **************************************************************    04660000
      * COPYBOOKS FOR THE PURPOSE OF DISPLAYING ERROR MESSAGES     *    04670000
      **************************************************************    04680000
           COPY CWS00303.                                               04690000
           COPY CWS0070B.                                               04700000
           COPY CWS09900.                                               04710000
           COPY CWS00010.                                               04720000
      /                                                                 04730000
           EXEC SQL                                                     04740000
               INCLUDE SQLCA                                            04750000
           END-EXEC.                                                    04760000
      /                                                                 04770000
           EXEC SQL                                                     04780000
               INCLUDE TBADRFMT                                         04790000
           END-EXEC.                                                    04800000
      /                                                                 04810000
           EXEC SQL                                                     04820000
               INCLUDE TBACCT                                           04830000
           END-EXEC.                                                    04840000
      /                                                                 04850000
           EXEC SQL                                                     04860000
               INCLUDE TBPREM                                           04870000
           END-EXEC.                                                    04880000
      /                                                                 04890000
           EXEC SQL                                                     04900000
               INCLUDE TBZIPRTE                                         04910000
           END-EXEC.                                                    04920000
      /                                                                 04930000
           EXEC SQL                                                     04940000
               INCLUDE TBZIPSUB                                         04950000
           END-EXEC.                                                    04960000
      /                                                                 05010000
           EXEC SQL                                                     05020000
               INCLUDE TBUTLENV                                         05030000
           END-EXEC.                                                    05040000
      /                                                                 05050000
           EXEC SQL                                                     05060000
               INCLUDE TBADRFRE                                         05070000
           END-EXEC.                                                    05080000
      /                                                                 05090000
           EXEC SQL                                                     05100000
               INCLUDE TBZIPCD                                          05110000
           END-EXEC.                                                    05120000
      /                                                                 05120100
           EXEC SQL                                                     05220000
               INCLUDE TBMNHIST                                         05230000
           END-EXEC.                                                    05240000
T27413/                                                                 05250000
           EXEC SQL                                                     05260000
               INCLUDE TBMNHDT                                          05270000
           END-EXEC.                                                    05280000
T36295/                                                                 05290000
           EXEC SQL                                                     05300000
               INCLUDE TBNMACTX                                         05310000
           END-EXEC.                                                    05320000
                                                                        
T27413     EXEC SQL                                                     
T27413        DECLARE ACCT_CURSOR CURSOR FOR                            
T27413          SELECT ACCOUNT_NO                                       
T27413            FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
T27413           WHERE ADDRESS_ID  = :WS-ADDRESS-ID                     
T36295         FOR READ ONLY                                    
A02034                                                     
T27413     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05340000
MFA-TR*       DECLARE ACCT_CURSOR CURSOR FOR                            05350000
MFA-TR*         SELECT ACCOUNT_NO                                       05360000
MFA-TR*           FROM CSS_ACCOUNT                                      05370000
MFA-TR*          WHERE ADDRESS_ID  = :WS-ADDRESS-ID                     05380000
MFA-TR*        FOR FETCH ONLY WITH UR                                   05390000
MFA-TR*        QUERYNO 77001                                            05391004
MFA-TR*    END-EXEC.                                                    05400000
      *                                                                 05410000
T27413     EXEC SQL                                                     
T27413        DECLARE PREM_CURSOR CURSOR FOR                            
T27413          SELECT PREMISE_NO                                       
T27413            FROM CSS_PREMISE WITH(READUNCOMMITTED)                        
T27413           WHERE ADDRESS_ID  = :WS-ADDRESS-ID                     
T36295         FOR READ ONLY                                    
A02034                                                     
T27413     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05420000
MFA-TR*       DECLARE PREM_CURSOR CURSOR FOR                            05430000
MFA-TR*         SELECT PREMISE_NO                                       05440000
MFA-TR*           FROM CSS_PREMISE                                      05450000
MFA-TR*          WHERE ADDRESS_ID  = :WS-ADDRESS-ID                     05460000
MFA-TR*        FOR FETCH ONLY WITH UR                                   05470000
MFA-TR*        QUERYNO 77001                                            05471004
MFA-TR*    END-EXEC.                                                    05480000
T36287     EXEC SQL                                                     
T36287         DECLARE ZIP_CURSOR CURSOR WITH ROWSET POSITIONING FOR    
T36287         SELECT ZIP_CODE,                                         
T36287                ZIP_CODE_TOKEN,                                   
T36287                TOWN,                                             
T36287                STATE                                             
T36287         FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                          
T36287         WHERE ZIP_CODE = :WS-FORM-ZIP-RET                        
T36287         ORDER BY ZIP_CODE_TOKEN                                  
T36287         FOR READ ONLY                                    
A02034                                                     
T36287     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05490000
MFA-TR*        DECLARE ZIP_CURSOR CURSOR WITH ROWSET POSITIONING FOR    05500000
MFA-TR*        SELECT ZIP_CODE,                                         05510000
MFA-TR*               ZIP_CODE_TOKEN,                                   05520000
MFA-TR*               TOWN,                                             05530000
MFA-TR*               STATE                                             05540000
MFA-TR*        FROM CSS_ZIP_CODE                                        05550000
MFA-TR*        WHERE ZIP_CODE = :WS-FORM-ZIP-RET                        05560000
MFA-TR*        ORDER BY ZIP_CODE_TOKEN                                  05570000
MFA-TR*        FOR FETCH ONLY WITH UR                                   05580000
MFA-TR*        QUERYNO 77001                                            05581004
MFA-TR*    END-EXEC                                                     05590000
      *                                                                 05600000
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077     05600100
A04860      EXEC SQL                                                    05600200
A04860           INCLUDE CWS00077                                       05600300
A04860      END-EXEC.                                                   05600400
A04860*                                                                 05600500
       LINKAGE SECTION.                                                 
      **************************************************************    05620000
      * JCL PARM FORMAT:                                           *    05630000
      *   PARM='?????????????,#############,LET'                   *    05640000
      *         FREEFORM      FORMATTED     (OPTIONAL)             *    05650000
      *         RESTART ID    RESTART ID                           *    05660000
      *                                                            *    05670000
      * IF THE PROCESSING ABENDED PROCESSING THE FREEFORM TABLES   *    05680000
      *    THE PARM WILL LOOK LIKE THIS:                           *    05690000
      *   PARM='?????????????,0000000000000'                       *    05700000
      *      WHERE '?????????????' IS THE LAST FREEFORM ADDRESS    *    05710000
      *           DISPLAYED AS HAVING BEEN COMMITTED.              *    05720000
      * IF THE PROCESSING ABENDED BEFORE A FREEFORM COMMIT WAS     *    05730000
      * TAKEN, NO PARM IS NECESSARY.                               *    05740000
      *                                                            *    05750000
      * IF THE PROCESSING ABENDED PROCESSING THE FORMATTED TABLES  *    05760000
      *    THE PARM WILL LOOK LIKE THIS:                           *    05770000
      *   PARM='9999999999999,#############'                       *    05780000
      *      WHERE '#############' IS THE LAST FORMATTED ADDRESS   *    05790000
      *           DISPLAYED AS HAVING BEEN COMMITTED.              *    05800000
      * IF THE PROCESSING ABENDED BEFORE A FORMATTED COMMIT WAS    *    05810000
      * TAKEN, THE PARM WILL LOOK LIKE THIS:                       *    05820000
      *   PARM='9999999999999,0000000000000'                       *    05830000
      *                                                            *    05840000
      * IN EITHER CASE ABOVE, THE 5% UPDATE LIMIT CAN BE WAIVED BY *    05850000
      *    ADDING ",LET" TO THE PARM.                              *    05860000
      * THIS IS A CIRCUIT BREAKER INTENDED TO ALERT THAT A MUCH    *    05870000
      * LARGER VOLUME OF UPDATES (USUALLY AROUND 1%) HAS BEEN      *    05880000
      * DETECTED.  FURTHER EXAMINATION WILL BE REQUIRED TO         *    05890000
      * DETERMINE WHETHER THIS IS CORRECT.                         *    05900000
      *                                                            *    05910000
      **************************************************************    05920000
       01  RESTART-PARM.                                                
           05  PARM-LENGTH                 PIC S9(4) COMP.              
PRJ910     05  FREEFORM-PARM-DATA          PIC 9(13).                   
           05  FILLER                      PIC X(1).                    
PRJ910     05  FORMATTED-PARM-DATA         PIC 9(13).                   
           05  FILLER                      PIC X(1).                    
           05  PARM-HI-UPDATES             PIC XXX.                     
      *                                                                 06000000
       PROCEDURE DIVISION USING RESTART-PARM.                           
      *                                                                 06020000
       0000-MAINLINE.                                                   
           PERFORM 1100-OPEN-INPUT-FILES THRU 1100-EXIT.                
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
      *                                                                 06060000
           MOVE ZERO TO WS-BYPASSED-COUNTER.                            
           PERFORM 2000-PROCESS-FREEFORM UNTIL END-OF-FREEFORM.         
           DISPLAY 'PCSCA375 FREEFORM  RECORDS  = '                     
                    WS-FREEFORM-COUNTER.                                
           DISPLAY 'PCSCA375 ADDRESSES UPDATED  = '                     
                    WS-FREE-ADDRESSES-UPDATED.                          
           DISPLAY 'PCSCA375 ACCOUNTS  UPDATED  = '                     
                    WS-ACCOUNTS-UPDATED.                                
           DISPLAY ' '.                                                 
           MOVE 0 TO WS-ACCOUNTS-UPDATED.                               
      *                                                                 06170000
           PERFORM 8100-READ-FORMATTED THRU 8100-EXIT.                  
           PERFORM 2100-PROCESS-FORM    UNTIL END-OF-FORMATTED.         
           DISPLAY 'PCSCA375 FORMATTED RECORDS  = '                     
               WS-FORMATTED-COUNTER.                                    
           DISPLAY 'PCSCA375 ADDRESSES UPDATED  = '                     
                    WS-FORM-ADDRESSES-UPDATED.                          
           DISPLAY 'PCSCA375 PREMISES  UPDATED  = '                     
                    WS-PREMISES-UPDATED.                                
           DISPLAY 'PCSCA375 ACCOUNTS  UPDATED  = '                     
                    WS-ACCOUNTS-UPDATED.                                
           DISPLAY ' '.                                                 
           MOVE ZERO TO WS-BYPASSED-COUNTER.                            
      *                                                                 06300000
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
PRJ910     STOP RUN.                                                    
      *                                                                 06330000
       0100-INITIALIZE.                                                 
T27413     ACCEPT WS-CURRENT-DATE FROM DATE.                            
T27413     MOVE WS-CY                  TO WS-RD-YY.                     
T27413     MOVE WS-CM                  TO WS-RD-MM.                     
T27413     MOVE WS-CD                  TO WS-RD-DD.                     
T27413     MOVE WS-RUN-DATE            TO P-RPT-DATE.                   
T27413     MOVE WS-52                  TO WS-RPT-LINE-NO.               
T27413*                                                                 06410000
           MOVE 'N' TO WS-END-OF-FREEFORM                               
                       WS-END-OF-FORMATTED.                             
           MOVE ZEROS TO WS-FREEFORM-COUNTER                            
                         WS-FORMATTED-COUNTER                           
                         WS-FREE-ADDRESSES-UPDATED                      
                         WS-FORM-ADDRESSES-UPDATED.                     
           EVALUATE TRUE                                                
               WHEN PARM-LENGTH EQUAL TO ZERO                           
                   PERFORM 8000-READ-FREEFORM THRU 8000-EXIT            
               WHEN FREEFORM-PARM-DATA = 9999999999999                  
                   MOVE 'Y' TO WS-END-OF-FREEFORM                       
               WHEN FREEFORM-PARM-DATA NOT = 0                          
                   PERFORM 8050-RECOVER-FREEFORM THRU 8050-EXIT         
               WHEN FREEFORM-PARM-DATA =     0                          
                   PERFORM 8000-READ-FREEFORM    THRU 8000-EXIT         
           END-EVALUATE.                                                
           EVALUATE TRUE                                                
               WHEN PARM-LENGTH EQUAL TO ZERO                           
                   CONTINUE                                             
               WHEN FORMATTED-PARM-DATA EQUAL TO ZERO                   
                   CONTINUE                                             
               WHEN OTHER                                               
                   PERFORM 8150-RECOVER-FORMATTED THRU 8150-EXIT        
           END-EVALUATE.                                                
           IF PARM-LENGTH > 0                                           
               DISPLAY 'PCSCA375 - PARM PRESENT '                       
               IF PARM-HI-UPDATES > '   '                               
                   IF PARM-HI-UPDATES = 'LET'                           
                       DISPLAY 'PCSCA375 - 5% UPDATE LIMIT IS WAIVED'   
                     ELSE                                               
                       DISPLAY 'PCSCA375 INVALID PARM VALUE '           
                           PARM-HI-UPDATES ' FOUND'                     
                       MOVE 12 TO WS-RETURN-CODE                        
                       PERFORM 9000-TERMINATE                           
                       END-IF                                           
                   END-IF                                               
               IF FREEFORM-PARM-DATA = 0                                
                   DISPLAY 'PCSCA375 STARTING AT FIRST FREEFORM ADDRESS'
                 ELSE                                                   
                   IF FREEFORM-PARM-DATA = 9999999999999                
                       DISPLAY 'PCSCA375 FREEFORM WILL NOT BE PROCESSED'
                       IF FORMATTED-PARM-DATA > 0                       
                           DISPLAY 'PCSCA375 STARTING AFTER '           
                              'FORMATTED ID ' FORMATTED-PARM-DATA       
                         ELSE                                           
                           DISPLAY 'PCSCA375 STARTING WITH FIRST '      
                              'FORMATTED ID '
                       END-IF                           
                     ELSE                                               
                       DISPLAY                                          
                           'PCSCA375 STARTING AFTER FREEFORM ID '       
                       FREEFORM-PARM-DATA                               
                       END-IF                                           
                   END-IF
           END-IF.                                              
                                                                        
           PERFORM 7200-CURRENT-TIMESTAMP THRU 7200-EXIT.               
           MOVE 'SYSTEM' TO MH-USER-ID.                                 
           MOVE 20 TO MH-TRAN-COMMENT-LEN.                              
           MOVE 'UPDATED ADDRESS INFO' TO MH-TRAN-COMMENT-TEXT.         
           MOVE 'PCSCA375' TO MH-APPL-PROGRAM-ID.                       
           MOVE 'F' TO MH-CODE-TRAN-TYPE.                               
           MOVE SPACES TO MH-RESP-AREA-ID,                              
                          MI-TABLE-ID.                                  
T27413*                                                                 07040000
T27413*                                                                 07050000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07080000
       1100-OPEN-INPUT-FILES.                                           
           OPEN INPUT FREEFORM-FILE.                                    
           OPEN INPUT FORMATTED-FILE.                                   
T20788     OPEN OUTPUT AUTO-UPDATED.                                    
T20788     OPEN OUTPUT UNMATCHED-ADDR.                                  
T27413     OPEN OUTPUT ZIPCODE-RPT.                                     
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07170000
       2000-PROCESS-FREEFORM.                                           
           MOVE 0 TO WS-UPDATED-FIELD-CNTR.                             
PRJ910     MOVE  WS-FREE-ADDR-ID   TO WS-FREE-ADDRESS-ID                
           MOVE WS-FREE-ADDRESS-ID TO WS-ADDRESS-ID                     
           IF WS-FREE-ZIP-RET NOT NUMERIC                               
               MOVE WS-FREE-ZIP-INP TO WS-FREE-ZIP-RET
           END-IF.                 
           IF WS-FREE-DPV-RET-CD = 'N'                                  
               MOVE ' ' TO WS-FREE-PFOUR-RET WS-FREE-DP-RET
           END-IF.            
88         MOVE 'N' TO WS-UPDATED-FLAG.                                 
           ADD 1 TO WS-FREEFORM-COUNTER.                                
           IF  (WS-FREE-PFOUR-RET = SPACES) OR                          
               (WS-FREE-DP-RET = SPACES)                                
88                 PERFORM 8600-PREPARE-FREE-UNMATCHED THRU             
88                   8600-EXIT                                          
                   MOVE SPACES TO WS-FREE-PFOUR-RET                     
                                  WS-FREE-DP-RET
           END-IF.                       
                                                                        
           IF (WS-FREE-ZIP-INP   NOT EQUAL TO WS-FREE-ZIP-RET)   OR     
              (WS-FREE-PFOUR-INP NOT EQUAL TO WS-FREE-PFOUR-RET) OR     
              (WS-FREE-DP-INP    NOT EQUAL TO WS-FREE-DP-RET)           
                  PERFORM 2050-SETUP-FREE-UPDATE THRU 2050-EXIT
           END-IF.        
           PERFORM 8000-READ-FREEFORM THRU 8000-EXIT.                   
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2050-SETUP-FREE-UPDATE.                                          
           MOVE WS-FREE-ZIP-RET         TO   WS-FREE-ZIP-UPD.           
           MOVE WS-FREE-PFOUR-RET       TO   WS-FREE-PFOUR-UPD.         
           PERFORM 2200-UPDATE-FREEFORM THRU 2200-EXIT.                 
           IF ADDRESS-WAS-UPDATED                                       
               ADD 1 TO WS-FREE-ADDRESSES-UPDATED                       
               PERFORM 5000-FREE-TRANS-HIST      THRU 5000-EXIT         
               IF TEST-COUNTER2 = 0 AND                                 
                  WS-FREE-ADDRESSES-UPDATED > 0                         
                      PERFORM 2080-CHECK-FREE-UPDATES                   
                      PERFORM 2400-COMMIT THRU 2400-EXIT                
                      IF WS-SQL-RETURN-CODE = SUCCESSFUL-CALL           
ACT099                    DISPLAY 'FREEFORM COMMIT #' COMMIT-NUMBER2    
ACT099                           ' ADDRESS ID = '    WS-FREE-ADDRESS-ID 
                        ELSE                                            
                          MOVE 'CSS_ADDR_FREEFORM' TO WS-TABLE-ID       
                          MOVE 'COMMIT'            TO WS-DB2-FUNCTION   
                          MOVE SQLCODE             TO WS-DB2-RETURN-CODE
                          MOVE 000                 TO WS-DB2-MODULE-ID  
                          MOVE 2000                TO WS-DB2-PARAGRAPH  
                          MOVE WS-FREE-ADDRESS-ID  TO WS-DB2-KEY-1N     
                          PERFORM 9500-SQL-ERROR THRU 9500-EXIT
                      END-IF
               END-IF
           END-IF.        
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07650000
      *IF WE HAVE UPDATED MORE THAN 5% OF THE ADDRESSES PROCESSED,      07660000
      *FAIL THE JOB UNLESS THE PARM HAS BEEN SET TO "LET".              07670000
       2080-CHECK-FREE-UPDATES.                                         
           COMPUTE WS-PCT ROUNDED =                                     
               WS-FREE-ADDRESSES-UPDATED / WS-FREEFORM-COUNTER.         
           IF WS-PCT > 0.05 AND PARM-HI-UPDATES NOT = 'LET'             
               DISPLAY WS-FREE-WARNING                                  
               DISPLAY 'PCSCA375 ' WS-FREE-ADDRESSES-UPDATED            
                   ' OUT OF ' WS-FREEFORM-COUNTER                       
                   ' HAVE BEEN UPDATED '                                
               DISPLAY WS-WARNING2                                      
               DISPLAY WS-WARNING3                                      
               MOVE 12 TO WS-RETURN-CODE                                
               PERFORM 9900-ABEND
           END-IF.                                      
      *                                                                 07800000
       2100-PROCESS-FORM.                                               
           MOVE 0 TO WS-UPDATED-FIELD-CNTR.                             
PRJ910     MOVE WS-FORM-ADDR-ID    TO WS-FORM-ADDRESS-ID.               
           MOVE WS-FORM-ADDRESS-ID TO WS-ADDRESS-ID.                    
           MOVE WS-FORM-ZIP-TOKEN  TO WS-ZIP-TOKEN.                     
           IF WS-FORM-DPV-RET-CD = 'N'                                  
               MOVE ' ' TO WS-FORM-PFOUR-RET WS-FORM-DP-RET
           END-IF.            
           IF WS-FORM-ZIP-RET NOT NUMERIC                               
               IF WS-FORM-ZIP-INP NUMERIC                               
                   MOVE WS-FORM-ZIP-INP TO WS-FORM-ZIP-RET              
                 ELSE                                                   
                   DISPLAY WS-BAD-INPUT-ZIP-MSG1 WS-FORM-ADDRESS-ID     
                           WS-BAD-INPUT-ZIP-MSG2 WS-FORM-ZIP-INP        
                           WS-BAD-INPUT-ZIP-MSG3                        
                   PERFORM 9900-ABEND
               END-IF
           END-IF.                                  
88         MOVE 'N' TO WS-UPDATED-FLAG.                                 
           ADD 1 TO WS-FORMATTED-COUNTER                                
           IF (WS-FORM-PFOUR-RET = SPACES) OR                           
              (WS-FORM-DP-RET    = SPACES)                              
88                PERFORM 8650-PREPARE-FORM-UNMATCHED THRU              
88                  8650-EXIT                                           
                  MOVE SPACES TO WS-FORM-PFOUR-RET                      
                                 WS-FORM-DP-RET
           END-IF.                        
           IF (WS-FORM-ZIP-INP   NOT EQUAL TO WS-FORM-ZIP-RET)   OR     
              (WS-FORM-PFOUR-INP NOT EQUAL TO WS-FORM-PFOUR-RET) OR     
              (WS-FORM-DP-INP    NOT EQUAL TO WS-FORM-DP-RET)           
                 PERFORM 2150-SETUP-FORMATTED-UPDATE
           END-IF.                   
           PERFORM 8100-READ-FORMATTED THRU 8100-EXIT.                  
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2150-SETUP-FORMATTED-UPDATE.                                     
           MOVE WS-FORM-ADDRESS-ID TO   WS-DB2-KEY-1N.                  
           IF WS-FORM-ZIP-INP = WS-FORM-ZIP-RET                         
               MOVE 'Y' TO WS-SUBDIV-SW                                 
             ELSE                                                       
               PERFORM 3000-GET-PREMISE THRU 3000-EXIT
           END-IF.                 
           IF WS-SUBDIV-SW = 'Y'                                        
               PERFORM 2300-UPDATE-FORMATTED                            
               PERFORM 9500-SQL-ERROR THRU 9500-EXIT                    
             ELSE                                                       
               IF WE-FOUND-AN-ACCOUNT OR WE-FOUND-A-PREMISE             
                   PERFORM 3800-GENERATE-WQ THRU 3800-EXIT              
                 ELSE                                                   
                   PERFORM 2300-UPDATE-FORMATTED                        
                   PERFORM 9500-SQL-ERROR THRU 9500-EXIT
               END-IF
           END-IF.               
T36295                                                                  
T36295     IF WS-FORM-ZIP-INP  NOT = WS-FORM-ZIP-RET  AND               
T36295        WS-FORM-CITY-INP NOT = WS-FORM-CITY-RET                   
T36295        IF NOT WE-FOUND-AN-ACCOUNT                                
T36295           PERFORM 3000-GET-PREMISE THRU 3000-EXIT                
T36295        END-IF                                                    
T36295        IF WE-FOUND-AN-ACCOUNT                                    
T36295           PERFORM 3100-UPDATE-ACCT-XREF THRU 3100-EXIT
              END-IF
           END-IF.          
T36295                                                                  
           IF ADDRESS-WAS-UPDATED                                       
               PERFORM 6000-FORM-TRANS-HIST      THRU 6000-EXIT         
               ADD 1 TO WS-FORM-ADDRESSES-UPDATED                       
               IF TEST-COUNTER1 = 0 AND                                 
                   WS-FORM-ADDRESSES-UPDATED > 0                        
                       PERFORM 2180-CHECK-FORM-UPDATES                  
                       PERFORM 2400-COMMIT THRU 2400-EXIT               
                       IF WS-SQL-RETURN-CODE = SUCCESSFUL-CALL          
ACT099                    DISPLAY 'FORMATTED COMMIT #' COMMIT-NUMBER1   
ACT099                           ' ADDRESS ID = '    WS-FORM-ADDRESS-ID 
                                                                        
                         ELSE                                           
                           MOVE 'CSS_ADDR_FORMATTED' TO WS-TABLE-ID     
                           MOVE 'COMMIT'           TO   WS-DB2-FUNCTION 
                           MOVE SQLCODE            TO WS-DB2-RETURN-CODE
                           MOVE 000                TO   WS-DB2-MODULE-ID
                           MOVE 2100               TO   WS-DB2-PARAGRAPH
                           MOVE WS-FORM-ADDRESS-ID TO   WS-DB2-KEY-1N   
                           PERFORM 9500-SQL-ERROR  THRU 9500-EXIT
                       END-IF
               END-IF
           END-IF.      
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
       2180-CHECK-FORM-UPDATES.                                         
           COMPUTE WS-PCT ROUNDED =                                     
               WS-FORM-ADDRESSES-UPDATED / WS-FORMATTED-COUNTER.        
           IF WS-PCT > 0.05 AND PARM-HI-UPDATES NOT = 'LET'             
               DISPLAY WS-FORM-WARNING                                  
               DISPLAY 'PCSCA375 ' WS-FORM-ADDRESSES-UPDATED            
                   ' OUT OF ' WS-FORMATTED-COUNTER                      
                   ' HAVE BEEN UPDATED '                                
               DISPLAY WS-WARNING2                                      
               DISPLAY WS-WARNING3                                      
               MOVE 12 TO WS-RETURN-CODE                                
               PERFORM 9900-ABEND
           END-IF.                                      
      *                                                                 08580000
       2200-UPDATE-FREEFORM.                                            
           EXEC SQL                                                     
                UPDATE CSS_ADDR_FREEFORM                                
                SET ADDR_ZIP_CODE        = :WS-FREE-ZIP-UPDATE,         
                    USPS_DELIV_PT_CD     = :WS-FREE-DP-RET              
           WHERE                                                        
                ADDRESS_ID = :WS-FREE-ADDRESS-ID                        
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     08600000
MFA-TR*         UPDATE CSS_ADDR_FREEFORM                                08610000
MFA-TR*         SET ADDR_ZIP_CODE        = :WS-FREE-ZIP-UPDATE,         08620000
MFA-TR*             USPS_DELIV_PT_CD     = :WS-FREE-DP-RET              08630000
MFA-TR*    WHERE                                                        08640000
MFA-TR*         ADDRESS_ID = :WS-FREE-ADDRESS-ID                        08650000
MFA-TR*         QUERYNO 2200                                            08651003
MFA-TR*    END-EXEC.                                                    08660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08670000
           MOVE SQLCODE TO WS-SQL-RETURN-CODE.                          
           PERFORM 9500-SQL-ERROR THRU 9500-EXIT.                       
           SET ADDRESS-WAS-UPDATED TO TRUE.                             
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08730000
       2300-UPDATE-FORMATTED.                                           
T36287     IF WS-FORM-ZIP-INP NOT = WS-FORM-ZIP-RET                     
T36287         PERFORM 6600-CHECK-TOWN-NAME
           END-IF.                            
           EXEC SQL                                                     
               UPDATE CSS_ADDR_FORMATTED                                
               SET ZIP_CODE             = :WS-FORM-ZIP-RET,             
T36287             ZIP_CODE_TOKEN       = :WS-ZIP-TOKEN,                
                   ZIP_CODE_PLUS_FOUR   = :WS-FORM-PFOUR-RET,           
                   USPS_DELIV_PT_CD     = :WS-FORM-DP-RET               
               WHERE                                                    
                   ADDRESS_ID  = :WS-FORM-ADDRESS-ID                    
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     08770000
MFA-TR*        UPDATE CSS_ADDR_FORMATTED                                08780000
MFA-TR*        SET ZIP_CODE             = :WS-FORM-ZIP-RET,             08790000
MFA-TR*            ZIP_CODE_TOKEN       = :WS-ZIP-TOKEN,                08800000
MFA-TR*            ZIP_CODE_PLUS_FOUR   = :WS-FORM-PFOUR-RET,           08810000
MFA-TR*            USPS_DELIV_PT_CD     = :WS-FORM-DP-RET               08820000
MFA-TR*        WHERE                                                    08830000
MFA-TR*            ADDRESS_ID  = :WS-FORM-ADDRESS-ID                    08840000
MFA-TR*        QUERYNO 2300                                             08841003
MFA-TR*    END-EXEC.                                                    08850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-SQL-RETURN-CODE.                          
           SET ADDRESS-WAS-UPDATED TO TRUE.                             
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08900000
       2400-COMMIT.                                                     
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-SQL-RETURN-CODE.                          
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08980000
       2500-INSERT-ZIP-CODE.                                            
           IF WS-FORM-ZIP-RET NOT NUMERIC                               
               DISPLAY WS-BAD-RETURN-ZIP-MSG1 WS-FORM-ADDRESS-ID        
                       WS-BAD-RETURN-ZIP-MSG2 WS-FORM-ZIP-RET           
                       WS-BAD-RETURN-ZIP-MSG3                           
               PERFORM 9900-ABEND
           END-IF.                                      
           PERFORM 7200-CURRENT-TIMESTAMP.                              
           EXEC SQL                                                     
               INSERT INTO CSS_ZIP_CODE                                 
                   (ZIP_CODE,                                           
                    ZIP_CODE_TOKEN,                                     
                    TOWN,                                               
                    STATE,                                              
                    LAST_UPDATE_TS,                                     
                    LAST_UPDATE_USERID)                                 
               VALUES                                                   
                    (:WS-FORM-ZIP-RET,                                  
                     :WS-ZIP-TOKEN,                                     
                     :WS-FORM-CITY-INP,                                 
                     :WS-FORM-STATE-INP,                                
                     CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                 
                     'SCRUB  ')                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09060000
MFA-TR*        INSERT INTO CSS_ZIP_CODE                                 09070000
MFA-TR*            (ZIP_CODE,                                           09080000
MFA-TR*             ZIP_CODE_TOKEN,                                     09090000
MFA-TR*             TOWN,                                               09100000
MFA-TR*             STATE,                                              09110000
MFA-TR*             LAST_UPDATE_TS,                                     09120000
MFA-TR*             LAST_UPDATE_USERID)                                 09130000
MFA-TR*        VALUES                                                   09140000
MFA-TR*             (:WS-FORM-ZIP-RET,                                  09150000
MFA-TR*              :WS-ZIP-TOKEN,                                     09160000
MFA-TR*              :WS-FORM-CITY-INP,                                 09170000
MFA-TR*              :WS-FORM-STATE-INP,                                09180000
MFA-TR*              :MH-TRANS-HIST-SEQ-NO,                             09190000
MFA-TR*              'SCRUB  ')                                         09200000
MFA-TR*    END-EXEC.                                                    09210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           DISPLAY 'PCSCA375 ZIP CODE ' WS-FORM-ZIP-RET  ' '            
                WS-ZIP-TOKEN ' WAS INSERTED '.                          
           PERFORM 9200-SQL-ERROR THRU 9200-EXIT.                       
       2500-EXIT.                                                       
           EXIT.                                                        
T27413*                                                                 09270000
T27413 3000-GET-PREMISE.                                                
           MOVE ZERO TO UT-READ-ROUTE.                                  
           MOVE 'N'  TO WS-FOUND-PREM WS-FOUND-ACCT WS-LO-RT-SW         
                        WS-SUBDIV-SW.                                   
           MOVE 'SELECT'            TO WS-TABLE-ID.                     
           MOVE 000                 TO WS-DB2-MODULE-ID.                
           MOVE 3000                TO WS-DB2-PARAGRAPH.                
           MOVE WS-FORM-ADDRESS-ID  TO WS-DB2-KEY-1N.                   
T27413     EXEC SQL                                                     
               SELECT TOP(1) PR.PREMISE_NO,
              PR.LOCAL_OFFICE,
              PR.COMPANY_NO,
              PR.SUBDIVISION_ID,
              PR.REV_DISTRICT_CD,
              UT.READ_ROUTE                                     
T27413         INTO  :PR-PREMISE-NO,                                    
                     :PR-LOCAL-OFFICE,                                  
T27413               :PR-COMPANY-NO,                                    
T27413               :PR-SUBDIVISION-ID,                                
T27413               :PR-REV-DISTRICT-CD,                               
T27413               :UT-READ-ROUTE                                     
               FROM CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED),               
                       CSS_PREMISE      PR WITH(READUNCOMMITTED),               
                       CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
               WHERE DY.ADDRESS_ID  = :WS-FORM-ADDRESS-ID AND           
                     PR.ADDRESS_ID  = DY.ADDRESS_ID AND                 
                     UT.PREMISE_NO  = PR.PREMISE_NO                     
T36295                                                           
A02034                                              
A02034                                                      
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09360000
MFA-TR*        SELECT PR.PREMISE_NO,                                    09370000
MFA-TR*               PR.LOCAL_OFFICE,                                  09380000
MFA-TR*               PR.COMPANY_NO,                                    09390000
MFA-TR*               PR.SUBDIVISION_ID,                                09400000
MFA-TR*               PR.REV_DISTRICT_CD,                               09410000
MFA-TR*               UT.READ_ROUTE                                     09420000
MFA-TR*        INTO  :PR-PREMISE-NO,                                    09430000
MFA-TR*              :PR-LOCAL-OFFICE,                                  09440000
MFA-TR*              :PR-COMPANY-NO,                                    09450000
MFA-TR*              :PR-SUBDIVISION-ID,                                09460000
MFA-TR*              :PR-REV-DISTRICT-CD,                               09470000
MFA-TR*              :UT-READ-ROUTE                                     09480000
MFA-TR*        FROM CSS_ADDR_FORMATTED  DY,                             09490000
MFA-TR*                CSS_PREMISE      PR,                             09500000
MFA-TR*                CSS_UTIL_ENVRNMT UT                              09510000
MFA-TR*        WHERE DY.ADDRESS_ID  = :WS-FORM-ADDRESS-ID AND           09520000
MFA-TR*              PR.ADDRESS_ID  = DY.ADDRESS_ID AND                 09530000
MFA-TR*              UT.PREMISE_NO  = PR.PREMISE_NO                     09540000
MFA-TR*        WITH UR                                                  09550000
MFA-TR*        FETCH FIRST ROW ONLY                                     09560000
MFA-TR*        QUERYNO 3000                                             09561003
MFA-TR*        END-EXEC.                                                09570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               MOVE 'Y'                 TO WS-FOUND-PREM                
             ELSE                                                       
               IF SQLCODE NOT = 100                                     
                   MOVE 'FETCH '            TO WS-DB2-FUNCTION          
                   PERFORM 9200-SQL-ERROR
               END-IF
           END-IF.                              
           IF WE-FOUND-A-PREMISE                                        
               PERFORM 3200-GET-ACCOUNT
           END-IF.                                
T27413 3000-EXIT.                                                       
T27413     EXIT.                                                        
T27413*                                                                 09680000
T36295 3100-UPDATE-ACCT-XREF.                                           
T36295*                                                                 09700000
T36295     EXEC SQL                                                     
T36295          UPDATE AX                             
T36295          SET AX.TOWN              = :WS-FORM-CITY-RET            
                FROM CSS_NAME_ACCT_XREF AX
T36295     WHERE                                                        
T36295          AX.ACCOUNT_NO = :AT-ACCOUNT-NO                          
T36295      AND AX.PREMISE_NO = :PR-PREMISE-NO                          
A02034                                                      
T36295     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     09710000
MFA-TR*         UPDATE CSS_NAME_ACCT_XREF AX                            09720000
MFA-TR*         SET AX.TOWN              = :WS-FORM-CITY-RET            09730000
MFA-TR*    WHERE                                                        09740000
MFA-TR*         AX.ACCOUNT_NO = :AT-ACCOUNT-NO                          09750000
MFA-TR*     AND AX.PREMISE_NO = :PR-PREMISE-NO                          09751000
MFA-TR*        QUERYNO 3100                                             09751103
MFA-TR*    END-EXEC.                                                    09752000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T36295*                                                                 09753000
T36295     IF SQLCODE = 0                                               
T36295        DISPLAY 'ACCOUNT ' AT-ACCOUNT-NO                          
T36295        ' UPDATED IN NAME_ACCT_XREF'                              
T36295     ELSE                                                         
T36295     IF SQLCODE = +100                                            
T36295        DISPLAY 'ACCOUNT ' AT-ACCOUNT-NO                          
T36295        ' NOT FOUND IN NAME_ACCT_XREF'                            
T36295        MOVE 2 TO RETURN-CODE                                     
T36295        GO TO 3100-EXIT                                           
T36295     END-IF
           END-IF.                                                      
T36295     MOVE SQLCODE TO WS-SQL-RETURN-CODE.                          
T36295     PERFORM 9500-SQL-ERROR THRU 9500-EXIT.                       
T36295 3100-EXIT.                                                       
T36295     EXIT.                                                        
T36295*                                                                 09759900
T27413 3200-GET-ACCOUNT.                                                
           MOVE ZERO                TO AT-ACCOUNT-NO.                   
           MOVE 'ACCT_CURSOR      ' TO WS-TABLE-ID                      
           MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
           MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
           MOVE 000                 TO WS-DB2-MODULE-ID                 
           MOVE 3200                TO WS-DB2-PARAGRAPH                 
           MOVE WS-FORM-ADDRESS-ID  TO WS-DB2-KEY-1N                    
T27413     EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO,
              CUSTOMER_NO,
              LOCAL_OFFICE,
              COMPANY_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT, 121), 
           ' ', '-'), ':', '.') ACCT_CREATE_DT                                 
               INTO  :AT-ACCOUNT-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-LOCAL-OFFICE,                                  
                     :AT-COMPANY-NO,                                    
T27413               :AT-ACCT-CREATE-DT                                 
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
               WHERE PREMISE_NO  = :PR-PREMISE-NO                       
T36295                                                           
A02034                                              
A02034                                                      
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09760800
MFA-TR*        SELECT ACCOUNT_NO,                                       09760900
MFA-TR*               CUSTOMER_NO,                                      09761000
MFA-TR*               LOCAL_OFFICE,                                     09762000
MFA-TR*               COMPANY_NO,                                       09763000
MFA-TR*               ACCT_CREATE_DT                                    09764000
MFA-TR*        INTO  :AT-ACCOUNT-NO,                                    09765000
MFA-TR*              :AT-CUSTOMER-NO,                                   09766000
MFA-TR*              :AT-LOCAL-OFFICE,                                  09767000
MFA-TR*              :AT-COMPANY-NO,                                    09768000
MFA-TR*              :AT-ACCT-CREATE-DT                                 09769000
MFA-TR*        FROM CSS_ACCOUNT                                         09770000
MFA-TR*        WHERE PREMISE_NO  = :PR-PREMISE-NO                       09780000
MFA-TR*        WITH UR                                                  09790000
MFA-TR*        FETCH FIRST ROW ONLY                                     09791001
MFA-TR*        QUERYNO 3200                                             09792004
MFA-TR*        END-EXEC.                                                09800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               MOVE 'Y' TO WS-FOUND-ACCT                                
             ELSE                                                       
               IF SQLCODE NOT = 100                                     
                   MOVE 'FETCH '            TO WS-DB2-FUNCTION          
                   PERFORM 9200-SQL-ERROR
               END-IF
           END-IF.                              
           IF WE-FOUND-A-PREMISE OR WE-FOUND-AN-ACCOUNT                 
               PERFORM 3400-CHECK-LO-RT  THRU 3400-EXIT
           END-IF.                
T27413*                                                                 09890000
T27413 3200-EXIT.                                                       
T27413     EXIT.                                                        
T27413*                                                                 09920000
T27413 3400-CHECK-LO-RT.                                                
           MOVE 'LO_RT_CURSOR     ' TO WS-TABLE-ID                      
           MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
           MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
           MOVE 000                 TO WS-DB2-MODULE-ID                 
           MOVE 3400                TO WS-DB2-PARAGRAPH                 
           MOVE WS-FORM-ADDRESS-ID  TO WS-DB2-KEY-1N                    
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE                                          
                   INTO :ZT-ZIP-CODE                                    
                   FROM CSS_ZIPCODE_LO_RT WITH(READUNCOMMITTED)                 
                   WHERE ZIP_CODE        = :WS-FORM-ZIP-RET    AND      
                       LOCAL_OFFICE      = :PR-LOCAL-OFFICE    AND      
                       REV_DISTRICT_CD   = :PR-REV-DISTRICT-CD AND      
                       READ_ROUTE        = :UT-READ-ROUTE               
T36295                                                           
A02034                                              
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10000000
MFA-TR*        SELECT ZIP_CODE                                          10010000
MFA-TR*            INTO :ZT-ZIP-CODE                                    10020000
MFA-TR*            FROM CSS_ZIPCODE_LO_RT                               10030000
MFA-TR*            WHERE ZIP_CODE        = :WS-FORM-ZIP-RET    AND      10040000
MFA-TR*                LOCAL_OFFICE      = :PR-LOCAL-OFFICE    AND      10050000
MFA-TR*                REV_DISTRICT_CD   = :PR-REV-DISTRICT-CD AND      10060000
MFA-TR*                READ_ROUTE        = :UT-READ-ROUTE               10070000
MFA-TR*        WITH UR                                                  10080000
MFA-TR*        FETCH FIRST ROW ONLY                                     10081001
MFA-TR*        QUERYNO 3400                                             10082004
MFA-TR*    END-EXEC.                                                    10090000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               MOVE 'Y' TO WS-LO-RT-SW                                  
             ELSE                                                       
               IF SQLCODE NOT = 100                                     
                   MOVE 'SELECT'            TO WS-DB2-FUNCTION          
                   PERFORM 9200-SQL-ERROR
               END-IF
           END-IF.                              
           IF WS-LO-RT-SW = 'Y'                                         
               IF  PR-SUBDIVISION-ID > '   ' AND                        
                   PR-SUBDIVISION-ID NOT = 'ZZY' AND 'ZZZ'              
                       PERFORM 3600-CHECK-SUBDIV THRU 3600-EXIT         
                 ELSE                                                   
                       MOVE 'Y' TO WS-SUBDIV-SW
               END-IF
           END-IF.                        
T27413 3400-EXIT.                                                       
T27413     EXIT.                                                        
T27413*                                                                 10240000
T27413 3600-CHECK-SUBDIV.                                               
           MOVE 'SUBDIV_CURSOR    ' TO WS-TABLE-ID                      
           MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
           MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
           MOVE 000                 TO WS-DB2-MODULE-ID                 
           MOVE 3600                TO WS-DB2-PARAGRAPH                 
           MOVE WS-FORM-ADDRESS-ID  TO WS-DB2-KEY-1N                    
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE                                          
                   INTO   :ZS-ZIP-CODE                                  
                   FROM CSS_ZIPCODE_SUBDIV WITH(READUNCOMMITTED)                
                   WHERE ZIP_CODE        = :WS-FORM-ZIP-RET AND         
                         SUBDIVISION_ID  = :PR-SUBDIVISION-ID           
T36295                                                           
A02034                                              
A02034                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10320000
MFA-TR*        SELECT ZIP_CODE                                          10330000
MFA-TR*            INTO   :ZS-ZIP-CODE                                  10340000
MFA-TR*            FROM CSS_ZIPCODE_SUBDIV                              10350000
MFA-TR*            WHERE ZIP_CODE        = :WS-FORM-ZIP-RET AND         10360000
MFA-TR*                  SUBDIVISION_ID  = :PR-SUBDIVISION-ID           10370000
MFA-TR*        WITH UR                                                  10380000
MFA-TR*        FETCH FIRST ROW ONLY                                     10381001
MFA-TR*        QUERYNO 3600                                             10382003
MFA-TR*    END-EXEC.                                                    10390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               MOVE 'Y' TO WS-SUBDIV-SW                                 
             ELSE                                                       
               IF SQLCODE NOT = 100                                     
                   MOVE 'SELECT'            TO WS-DB2-FUNCTION          
                   PERFORM 9200-SQL-ERROR
               END-IF
           END-IF.                              
T27413 3600-EXIT.                                                       
T27413     EXIT.                                                        
T27413*                                                                 10480000
T27413 3800-GENERATE-WQ.                                                
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE 0                   TO WS-77-SERV-ORDER-NO              
A04860                                 WS-77-CUSTOMER-NO.               
A04860     MOVE MH-TRANS-HIST-SEQ-NO                                    
A04860                              TO WS-77-DATE-REQUIRED.             
A04860     MOVE 406                 TO WS-77-CATEGORY-ID.               
           IF AT-ACCOUNT-NO > 0                                         
A04860         MOVE AT-ACCOUNT-NO   TO WS-77-ACCOUNT-NO                 
A04860         MOVE 0               TO WS-77-PREMISE-NO                 
A04860         MOVE AT-LOCAL-OFFICE TO WS-77-LOCAL-OFFICE               
             ELSE                                                       
A04860         MOVE 0               TO WS-77-ACCOUNT-NO                 
A04860         MOVE PR-PREMISE-NO   TO WS-77-PREMISE-NO                 
A04860         MOVE PR-LOCAL-OFFICE TO WS-77-LOCAL-OFFICE
           END-IF.              
A04860     MOVE 'SYSTEM'            TO WS-77-USER-ID-ORIG.              
A04860     MOVE ' '                 TO WS-77-RESP-AREA-ID.              
A04860     MOVE 4                   TO WS-77-ROUTE-CATEGORY.            
A04860     MOVE 'N'                 TO WS-77-PRIORITY.                  
A04860     MOVE ' '                 TO WS-77-FREE-FORM-TXT.             
A04860     MOVE ZERO                TO WS-77-FREE-FORM-LEN.             
           MOVE WS-FORM-ZIP-RET     TO WS-WQ-ZIP.                       
A04860     MOVE WS-77-LOCAL-OFFICE  TO WS-WQ-LO.                        
           MOVE UT-READ-ROUTE       TO WS-WQ-ROUTE.                     
           MOVE PR-REV-DISTRICT-CD  TO WS-WQ-REV-DIST.                  
           MOVE PR-SUBDIVISION-ID   TO WS-WQ-SUBD.                      
A04860     MOVE WS-WORKQ-LINE       TO WS-77-COMMENTS-TEXT.             
A04860     MOVE LENGTH OF WS-WORKQ-LINE                                 
A04860                              TO WS-77-COMMENTS-LEN.              
A04860     MOVE PROGRAM-NAME        TO WS-77-CREATED-BY.                
           PERFORM 8895-INSERT-WORK-QUEUE.                              
           DISPLAY 'PCSCA375 WORK QUEUE GENERATED - ACCOUNT '           
A04860         WS-77-ACCOUNT-NO ' PREMISE ' PR-PREMISE-NO.              
T27413 3800-EXIT.                                                       
T27413     EXIT.                                                        
      *                                                                 10840000
T27413*  FREEFORM ADDRESSES CAN ONLY APPLY TO AN ACCOUNT,               10850000
T27413*  NEVER TO A PREMISE, SO THE PREMISE TABLE IS NOT CHECKED.       10860000
       5000-FREE-TRANS-HIST.                                            
           MOVE 'N'                 TO WS-FOUND-ACCT.                   
           MOVE ZERO                TO AT-ACCOUNT-NO AT-PREMISE-NO      
                                       AT-CUSTOMER-NO.                  
           MOVE 'ACCT_CURSOR'       TO WS-TABLE-ID.                     
           MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
           MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
           MOVE 000                 TO WS-DB2-MODULE-ID                 
           MOVE 5000                TO WS-DB2-PARAGRAPH                 
           MOVE WS-ADDRESS-ID       TO WS-DB2-KEY-1N                    
T27413     EXEC SQL                                                     
T27413         OPEN ACCT_CURSOR                                         
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               PERFORM 9200-SQL-ERROR
           END-IF.                                  
           PERFORM 5200-FIND-ACCOUNT                                    
           PERFORM UNTIL SQLCODE = 100                                  
               ADD +1 TO WS-ACCOUNTS-UPDATED                            
               PERFORM 5400-FREE-TRANS-HIST-UPDATES                     
               MOVE 0             TO WS-AUTO-PREMISE                    
               MOVE AT-ACCOUNT-NO TO WS-AUTO-ACCOUNT                    
               PERFORM 8500-PREPARE-FREE-UPDATED THRU 8500-EXIT         
               PERFORM 5200-FIND-ACCOUNT                                
               END-PERFORM.                                             
T27413     EXEC SQL                                                     
T27413         CLOSE ACCT_CURSOR                                        
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'CLOSE '            TO WS-DB2-FUNCTION              
               PERFORM 9200-SQL-ERROR
           END-IF.                                  
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-FIND-ACCOUNT.                                               
T27413     EXEC SQL                                                     
T27413         FETCH ACCT_CURSOR INTO                                   
                     :AT-ACCOUNT-NO                                     
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0 AND 100                                   
                   PERFORM 9200-SQL-ERROR
           END-IF.                              
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5400-FREE-TRANS-HIST-UPDATES.                                    
           PERFORM 7000-TRANS-HIST-HEADER.                              
           IF WS-FREE-ZIP-INP   NOT = WS-FREE-ZIP-RET                   
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'ZIP CODE' TO MI-COLUMN-DESC                        
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 5 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FREE-ZIP-INP TO MI-PRV-COLUMN-VALUE-TEXT         
               MOVE WS-FREE-ZIP-RET TO MI-CHG-COLUMN-VALUE-TEXT         
               PERFORM 7100-TRANS-HIST-DETAIL
           END-IF.                          
                                                                        
           IF WS-FREE-PFOUR-INP   NOT = WS-FREE-PFOUR-RET               
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'ZIP+4 CODE' TO MI-COLUMN-DESC                      
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 4 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FREE-PFOUR-INP TO MI-PRV-COLUMN-VALUE-TEXT       
               MOVE WS-FREE-PFOUR-RET TO MI-CHG-COLUMN-VALUE-TEXT       
               PERFORM 7100-TRANS-HIST-DETAIL
           END-IF.                          
           IF WS-FREE-DP-INP      NOT = WS-FREE-DP-RET                  
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'USPS DELIV PT' TO MI-COLUMN-DESC                   
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 2 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FREE-DP-INP TO MI-PRV-COLUMN-VALUE-TEXT          
               MOVE WS-FREE-DP-RET TO MI-CHG-COLUMN-VALUE-TEXT          
               PERFORM 7100-TRANS-HIST-DETAIL
           END-IF.                          
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * FORMATTED ADDRESSES CAN BE EITHER A MAILING OR PREMISE          11640000
      * SO BOTH TABLES ARE CHECKED.                                     11650000
                                                                        
       6000-FORM-TRANS-HIST.                                            
           MOVE 'N'                 TO WS-FOUND-ACCT.                   
           MOVE ZERO                TO AT-ACCOUNT-NO AT-PREMISE-NO      
                                       AT-CUSTOMER-NO.                  
           MOVE 'ACCT_CURSOR      ' TO WS-TABLE-ID                      
           MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
           MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
           MOVE 000                 TO WS-DB2-MODULE-ID                 
           MOVE 6000                TO WS-DB2-PARAGRAPH                 
           MOVE WS-ADDRESS-ID       TO WS-DB2-KEY-1N                    
T27413     EXEC SQL                                                     
T27413         OPEN ACCT_CURSOR                                         
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               PERFORM 9200-SQL-ERROR
           END-IF.                                  
           PERFORM 5200-FIND-ACCOUNT                                    
           PERFORM UNTIL SQLCODE = 100                                  
               ADD +1 TO WS-ACCOUNTS-UPDATED                            
               PERFORM 6400-FORM-TRANS-HIST-UPDATES                     
               MOVE 0             TO WS-AUTO-PREMISE                    
               MOVE AT-ACCOUNT-NO TO WS-AUTO-ACCOUNT                    
               PERFORM 8550-PREPARE-FORM-UPDATED THRU 8550-EXIT         
               PERFORM 5200-FIND-ACCOUNT                                
               END-PERFORM.                                             
T27413     EXEC SQL                                                     
T27413         CLOSE ACCT_CURSOR                                        
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               MOVE 'CLOSE '            TO WS-DB2-FUNCTION              
               PERFORM 9200-SQL-ERROR
           END-IF.                                  
           MOVE 'PREM_CURSOR      ' TO WS-TABLE-ID.                     
           MOVE 0 TO AT-ACCOUNT-NO AT-CUSTOMER-NO.                      
T27413     EXEC SQL                                                     
T27413         OPEN PREM_CURSOR                                         
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
               PERFORM 9200-SQL-ERROR
           END-IF.                                  
           PERFORM 6200-FIND-PREMISE                                    
           PERFORM UNTIL SQLCODE = 100                                  
               ADD +1 TO WS-PREMISES-UPDATED                            
               MOVE PR-PREMISE-NO TO   AT-PREMISE-NO                    
               PERFORM 6400-FORM-TRANS-HIST-UPDATES                     
               MOVE 0             TO WS-AUTO-ACCOUNT                    
               MOVE PR-PREMISE-NO TO WS-AUTO-PREMISE                    
               PERFORM 8550-PREPARE-FORM-UPDATED THRU 8550-EXIT         
               PERFORM 6200-FIND-PREMISE                                
               END-PERFORM.                                             
T27413     EXEC SQL                                                     
T27413         CLOSE PREM_CURSOR                                        
               END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6200-FIND-PREMISE.                                               
T27413     EXEC SQL                                                     
T27413         FETCH PREM_CURSOR INTO                                   
                     :PR-PREMISE-NO                                     
                END-EXEC.                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0 AND 100                                   
                   PERFORM 9200-SQL-ERROR
           END-IF.                              
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6400-FORM-TRANS-HIST-UPDATES.                                    
           PERFORM 7000-TRANS-HIST-HEADER.                              
           IF WS-FORM-ZIP-INP   NOT = WS-FORM-ZIP-RET                   
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'ZIP CODE' TO MI-COLUMN-DESC                        
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 5 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FORM-ZIP-INP TO MI-PRV-COLUMN-VALUE-TEXT         
               MOVE WS-FORM-ZIP-RET TO MI-CHG-COLUMN-VALUE-TEXT         
               PERFORM 7100-TRANS-HIST-DETAIL                           
T36287         IF WS-FORM-ZIP-TOKEN NOT = WS-ZIP-TOKEN                  
T36287             ADD 1  TO WS-UPDATED-FIELD-CNTR                      
T36287             MOVE 'ZIP CODE TOKEN' TO MI-COLUMN-DESC              
T36287             MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO        
T36287             MOVE 1 TO MI-PRV-COLUMN-VALUE-LEN                    
T36287                       MI-CHG-COLUMN-VALUE-LEN                    
T36287             MOVE WS-FORM-ZIP-TOKEN TO MI-PRV-COLUMN-VALUE-TEXT   
T36287             MOVE WS-ZIP-TOKEN      TO MI-CHG-COLUMN-VALUE-TEXT   
T36287             PERFORM 7100-TRANS-HIST-DETAIL
               END-IF
           END-IF.                      
                                                                        
           IF WS-FORM-PFOUR-INP   NOT = WS-FORM-PFOUR-RET               
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'ZIP+4 CODE' TO MI-COLUMN-DESC                      
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 4 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FORM-PFOUR-INP TO MI-PRV-COLUMN-VALUE-TEXT       
               MOVE WS-FORM-PFOUR-RET TO MI-CHG-COLUMN-VALUE-TEXT       
               PERFORM 7100-TRANS-HIST-DETAIL
           END-IF.                          
                                                                        
                                                                        
           IF WS-FORM-DP-INP      NOT = WS-FORM-DP-RET                  
               ADD 1  TO WS-UPDATED-FIELD-CNTR                          
               MOVE 'USPS DELIV PT' TO MI-COLUMN-DESC                   
               MOVE WS-UPDATED-FIELD-CNTR TO MI-TRAN-APPL-NO            
               MOVE 2 TO MI-PRV-COLUMN-VALUE-LEN                        
                         MI-CHG-COLUMN-VALUE-LEN                        
               MOVE WS-FORM-DP-INP TO MI-PRV-COLUMN-VALUE-TEXT          
               MOVE WS-FORM-DP-RET TO MI-CHG-COLUMN-VALUE-TEXT          
               PERFORM 7100-TRANS-HIST-DETAIL
           END-IF.                          
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T36287* IF THE ZIP CODE CHANGES, CHECK THE ZIP CODE DB2 TABLE TO SEE    12760000
T36287* WHETHER OR NOT THE NEW ZIP CODE HAS ALREADY BEEN ADDED.         12770000
T36287* IF NOT, ADD THE NEW ZIP TO THE WORKING STORAGE TABLE.           12780000
T36287* IF IT IS, CHECK TO SEE WHETHER OR NOT THIS TOWN IS              12790000
T36287* LISTED FOR THAT ZIP CODE.                                       12800000
T36287* IF THE TOWN IS LISTED, USE THAT TOKEN.  IF NOT, ADD THIS        12810000
T36287* TOWN AND TOKEN TO THE WORKING STORAGE TABLE.                    12820000
T36287 6600-CHECK-TOWN-NAME.                                            
T36287     IF WS-FORM-ZIP-RET NOT = WS-A4-ZIP-CODE (1)                  
T36287         PERFORM 6800-GET-ZIP-TOWNS
           END-IF.                              
T36287     MOVE 'Y' TO WS-ADDRESS-LOOP.                                 
T36287     MOVE +1 TO I.                                                
T36287     PERFORM UNTIL WS-ADDRESS-LOOP NOT = 'Y'                      
T36287         IF WS-A4-ZIP-CODE (I) = ' '                              
T36287             MOVE 'N' TO WS-ADDRESS-LOOP                          
T36287           ELSE                                                   
T36287             IF WS-A4-TOWN (I) = WS-FORM-CITY-RET                 
T36287                 MOVE 'F' TO WS-ADDRESS-LOOP                      
T36287               ELSE                                               
T36287                 ADD 1 TO I                                       
T36287                 IF I > 9                                         
T36287                     MOVE 'O' TO WS-ADDRESS-LOOP                  
T36287                     END-IF                                       
T36287                 END-IF                                           
T36287             END-IF                                               
T36287          END-PERFORM.                                            
T36287     EVALUATE TRUE                                                
T36287         WHEN WE-FIND-THE-TOWN-NAME                               
T36287             MOVE WS-A4-ZIP-CODE-TOKEN (I) TO WS-ZIP-TOKEN        
T36287         WHEN ITS-A-NEW-TOWN-NAME                                 
T36287             MOVE WS-FORM-ZIP-RET      TO WS-A4-ZIP-CODE       (I)
T36287             MOVE WS-FORM-CITY-RET     TO WS-A4-TOWN           (I)
T36287             MOVE WS-NEW-ZIP-TOKEN (I) TO WS-A4-ZIP-CODE-TOKEN (I)
T36287             MOVE WS-NEW-ZIP-TOKEN (I) TO WS-ZIP-TOKEN            
T36287         WHEN TABLE-IS-OUT-OF-SPACE                               
T36287             MOVE '1'                 TO WS-ZIP-TOKEN             
                   MOVE WS-FORM-ZIP-RET     TO WS-TOKENS-MSG-ZIP        
                   MOVE WS-FORM-CITY-RET    TO WS-TOKENS-MSG-TOWN       
T36287             PERFORM 7300-TOKENS-MESSAGE                          
T36287         WHEN OTHER                                               
T36287             DISPLAY 'PCSCA375 - INVALID ADDRESS LOOP CODE '      
T36287                 WS-ADDRESS-LOOP ' RETURNED'                      
T36287             PERFORM 9900-ABEND                                   
T36287         END-EVALUATE.                                            
T36287 6600-EXIT.                                                       
T36287     EXIT.                                                        
                                                                        
T36287* FETCH UP TO 9 ROWS OF ZIP CODES.  CURRENTLY, ONLY ZIP TOKENS    13230000
T36287* 1-9 ARE IN USE.                                                 13240000
T36287*                                                                 13250000
T36287 6800-GET-ZIP-TOWNS.                                              
T36287     MOVE ' '                 TO ZIP-TABLE.                       
T36287     MOVE 'ZIP_CURSOR'        TO WS-TABLE-ID.                     
T36287     MOVE 'OPEN  '            TO WS-DB2-FUNCTION                  
T36287     MOVE 000                 TO WS-DB2-MODULE-ID                 
T36287     MOVE 6800                TO WS-DB2-PARAGRAPH                 
T36287     MOVE WS-ADDRESS-ID       TO WS-DB2-KEY-1N                    
T36287     EXEC SQL OPEN ZIP_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T36287     MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
T36287     IF SQLCODE NOT = 0                                           
T36287         PERFORM 9200-SQL-ERROR
           END-IF.                                  
T36287     MOVE 'FETCH'             TO WS-DB2-FUNCTION                  

MSQ008     MOVE 9 TO MSQ008-ZIP-CURSOR
T36287     EXEC SQL                                                     
T36287         FOR :MSQ008-ZIP-CURSOR
              FETCH 
              FROM ZIP_CURSOR             
T36287          INTO :WS-A4-ZIP-CODE,                                   
T36287               :WS-A4-ZIP-CODE-TOKEN,                             
T36287               :WS-A4-TOWN,                                       
T36287               :WS-A4-STATE                                       
T36287     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     13380000
MFA-TR*        FETCH NEXT ROWSET FROM ZIP_CURSOR  FOR  9 ROWS           13390000
MFA-TR*         INTO :WS-A4-ZIP-CODE,                                   13400000
MFA-TR*              :WS-A4-ZIP-CODE-TOKEN,                             13410000
MFA-TR*              :WS-A4-TOWN,                                       13420000
MFA-TR*              :WS-A4-STATE                                       13430000
MFA-TR*    END-EXEC.                                                    13440000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-ZIP-CURSOR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T36287     MOVE SQLCODE             TO WS-DB2-RETURN-CODE               
T36287     IF SQLCODE = 0 OR 100                                        
T36287         IF  WS-A4-ZIP-CODE (1) >     '00000' AND                 
T36287             WS-A4-ZIP-CODE (9) NOT > '00000'                     
T36287                 PERFORM 6900-ADJUST-TOWNS                        
T36287                 END-IF                                           
T36287       ELSE                                                       
T36287         PERFORM 9200-SQL-ERROR
           END-IF.                                  
T36287                                                                  
T36287     EXEC SQL CLOSE ZIP_CURSOR                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
T36287 6800-EXIT.                                                       
T36287     EXIT.                                                        
T36287                                                                  
      * THIS ROUTINE IS ENTERED WHEN WE RETRIEVE AT LEAST 1, BUT FEWER  13580000
      * THAN 9 ENTRIES.  IF WE RETRIEVE NINE ENTRIES, THEN THE TABLE    13590000
      * IS FULL, AND THERE IS NO NEED TO ADJUST THE INFORMATION.        13600000
      * HOWEVER, IF WE FOUND FEWER THAN 9, WE NEED TO CHECK THE TABLE   13610000
      * TO ENSURE THAT THE ZIP TOKENS MATCH UP WITH CORRESPONDING SLOTS 13620000
      * IN THE WORKING-STORAGE TABLE.                                   13630000
      * FOR EXAMPLE, WE MIGHT RETRIEVE:                                 13640000
      * WS TABLE ENTRY 1: 29406 1 CHARLESTON HEIGHTS SC                 13650000
      * WS TABLE ENTRY 2: 29406 3 HANAHAN            SC                 13660000
      * WS TABLE ENTRY 3: 29406 5 NORTH CHARLESTON   SC                 13670000
      * WS TABLE ENTRY 4: 29406 9 CHARLESTON         SC                 13680000
      * WS TABLE ENTRIES 5-9 BLANK                                      13690000
      * BUT WE WANT THE ZIP CODE TOKENS TO MATCH THE TABLE ENTRY        13700000
      * NUMBER.  THIS WILL FACILITATE FINDING AN AVAILABLE TOKEN.       13710000
      * AFTER THIS ROUTINE, THE ABOVE EXAMPLE WOULD LOOK THUS:          13720000
      * TABLE ENTRY 1: 29406 1 CHARLESTON HEIGHTS SC                    13730000
      * TABLE ENTRY 2: BLANK                                            13740000
      * TABLE ENTRY 3: 29406 3 HANAHAN            SC                    13750000
      * TABLE ENTRY 4: BLANK                                            13760000
      * TABLE ENTRY 5: 29406 5 NORTH CHARLESTON   SC                    13770000
      * TABLE ENTRIES 6-8 BLANK                                         13780000
      * TABLE ENTRY 9: 29406 9 CHARLESTON         SC                    13790000
T36287 6900-ADJUST-TOWNS.                                               
T36287     MOVE 8 TO I.                                                 
T36287     PERFORM 8 TIMES                                              
T36287        IF WS-A4-ZIP-CODE-TOKEN (I) NUMERIC                       
T36287            IF WS-A4-ZIP-CODE-TOKEN-NUM (I) NOT = I               
T36287               MOVE WS-A4-ZIP-CODE-TOKEN-NUM (I)                  
T36287                                       TO J                       
T36287               MOVE WS-A4-ZIP-CODE (I) TO WS-A4-ZIP-CODE (J)      
T36287               MOVE WS-A4-ZIP-CODE-TOKEN (I)                      
T36287                                       TO WS-A4-ZIP-CODE-TOKEN (J)
T36287               MOVE WS-A4-TOWN     (I) TO WS-A4-TOWN     (J)      
T36287               MOVE WS-A4-STATE    (I) TO WS-A4-STATE    (J)      
T36287               INITIALIZE WS-A4-ZIP-CODE       (I)                
T36287                          WS-A4-ZIP-CODE-TOKEN (I)                
T36287                          WS-A4-TOWN           (I)                
T36287                          WS-A4-STATE          (I)                
T36287               END-IF                                             
T36287            END-IF                                                
T36287        SUBTRACT 1 FROM I                                         
T36287        END-PERFORM.                                              
T36287 6900-EXIT.                                                       
T36287     EXIT.                                                        
T36287 7000-TRANS-HIST-HEADER.                                          
           PERFORM 7200-CURRENT-TIMESTAMP THRU 7200-EXIT.               
           MOVE MH-TRANS-HIST-SEQ-NO TO MH-DATE-TRANS.                  
           MOVE '7000' TO WS-DB2-PARAGRAPH.                             
           MOVE 13 TO MH-ENTITY-KEY-DESC-LEN.                           
           MOVE WS-ADDRESS-ID TO MH-ENTITY-KEY-DESC-TEXT.               
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                      (ACCOUNT_NO,                                      
                       APPL_PROGRAM_ID,                                 
                       CODE_TRAN_TYPE,                                  
                       CUSTOMER_NO,                                     
                       DATE_TRANS,                                      
                       ENTITY_KEY_DESC,                                 
                       PREMISE_NO,                                      
                       RESP_AREA_ID,                                    
                       TRAN_COMMENT,                                    
                       TRANS_HIST_SEQ_NO,                               
                       USER_ID)                                         
               VALUES                                                   
                      (:AT-ACCOUNT-NO,                                  
                       :MH-APPL-PROGRAM-ID,                             
                       :MH-CODE-TRAN-TYPE,                              
                       :AT-CUSTOMER-NO,                                 
                       IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                       :MH-ENTITY-KEY-DESC,                             
                       :AT-PREMISE-NO,                                  
                       :MH-RESP-AREA-ID,                                
                       :MH-TRAN-COMMENT,                                
                       CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
                       :MH-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14080000
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           14090000
MFA-TR*               (ACCOUNT_NO,                                      14100000
MFA-TR*                APPL_PROGRAM_ID,                                 14110000
MFA-TR*                CODE_TRAN_TYPE,                                  14120000
MFA-TR*                CUSTOMER_NO,                                     14130000
MFA-TR*                DATE_TRANS,                                      14140000
MFA-TR*                ENTITY_KEY_DESC,                                 14150000
MFA-TR*                PREMISE_NO,                                      14160000
MFA-TR*                RESP_AREA_ID,                                    14170000
MFA-TR*                TRAN_COMMENT,                                    14180000
MFA-TR*                TRANS_HIST_SEQ_NO,                               14190000
MFA-TR*                USER_ID)                                         14200000
MFA-TR*        VALUES                                                   14210000
MFA-TR*               (:AT-ACCOUNT-NO,                                  14220000
MFA-TR*                :MH-APPL-PROGRAM-ID,                             14230000
MFA-TR*                :MH-CODE-TRAN-TYPE,                              14240000
MFA-TR*                :AT-CUSTOMER-NO,                                 14250000
MFA-TR*                :MH-DATE-TRANS,                                  14260000
MFA-TR*                :MH-ENTITY-KEY-DESC,                             14270000
MFA-TR*                :AT-PREMISE-NO,                                  14280000
MFA-TR*                :MH-RESP-AREA-ID,                                14290000
MFA-TR*                :MH-TRAN-COMMENT,                                14300000
MFA-TR*                :MH-TRANS-HIST-SEQ-NO,                           14310000
MFA-TR*                :MH-USER-ID)                                     14320000
MFA-TR*    END-EXEC.                                                    14330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-SQL-RETURN-CODE.                          
           MOVE 'CSS_MNT_TRANS_HIST' TO WS-TABLE-ID.                    
           PERFORM 9500-SQL-ERROR       THRU 9500-EXIT.                 
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-TRANS-HIST-DETAIL.                                          
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE '7100' TO WS-DB2-PARAGRAPH.                             
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
                      (CHG_COLUMN_VALUE,                                
                       COLUMN_DESC,                                     
                       PRV_COLUMN_VALUE,                                
                       TABLE_ID,                                        
                       TRANS_HIST_SEQ_NO,                               
                       TRAN_APPL_NO)                                    
               VALUES                                                   
                      (:MI-CHG-COLUMN-VALUE,                            
                       :MI-COLUMN-DESC,                                 
                       :MI-PRV-COLUMN-VALUE,                            
                       :MI-TABLE-ID,                                    
                       CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
                       :MI-TRAN-APPL-NO)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14430000
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           14440000
MFA-TR*               (CHG_COLUMN_VALUE,                                14450000
MFA-TR*                COLUMN_DESC,                                     14460000
MFA-TR*                PRV_COLUMN_VALUE,                                14470000
MFA-TR*                TABLE_ID,                                        14480000
MFA-TR*                TRANS_HIST_SEQ_NO,                               14490000
MFA-TR*                TRAN_APPL_NO)                                    14500000
MFA-TR*        VALUES                                                   14510000
MFA-TR*               (:MI-CHG-COLUMN-VALUE,                            14520000
MFA-TR*                :MI-COLUMN-DESC,                                 14530000
MFA-TR*                :MI-PRV-COLUMN-VALUE,                            14540000
MFA-TR*                :MI-TABLE-ID,                                    14550000
MFA-TR*                :MI-TRANS-HIST-SEQ-NO,                           14560000
MFA-TR*                :MI-TRAN-APPL-NO)                                14570000
MFA-TR*    END-EXEC.                                                    14580000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT EQUAL TO SUCCESSFUL-CALL                      
               MOVE SQLCODE TO WS-SQL-RETURN-CODE                       
               MOVE 'CSS_MT_TRN_HST_DET' TO WS-TABLE-ID                 
               PERFORM 9500-SQL-ERROR       THRU 9500-EXIT
           END-IF.             
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CURRENT-TIMESTAMP.                                          
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14670000
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP            14680000
MFA-TR*    END-EXEC.                                                    14690000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-TOKENS-MESSAGE.                                             
           MOVE 'PCSCA376'           TO MAIL2-JOB-NAME                  
                                        MAIL5-JOB-NAME.                 
           MOVE WS-SUBJECT           TO MAIL7-SUBJECT.                  
           WRITE MAIL-REC FROM MAILHEAD-1.                              
           WRITE MAIL-REC FROM MAILHEAD-2.                              
           WRITE MAIL-REC FROM MAILHEAD-3.                              
           WRITE MAIL-REC FROM MAILHEAD-4.                              
           WRITE MAIL-REC FROM MAILHEAD-5.                              
           WRITE MAIL-REC FROM MAILHEAD-6.                              
           WRITE MAIL-REC FROM MAILHEAD-7.                              
           WRITE MAIL-REC FROM MAILHEAD-8.                              
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-TOKENS-MSG1.                          
           WRITE MAIL-REC FROM WS-TOKENS-MSG2.                          
           WRITE MAIL-REC FROM WS-AST-LINE.                             
           WRITE MAIL-REC FROM WS-AST-LINE.                             
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-READ-FREEFORM.                                              
           READ FREEFORM-FILE INTO WS-FREEFORM                          
               AT END MOVE 'Y' TO WS-END-OF-FREEFORM.                   
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14990000
       8050-RECOVER-FREEFORM.                                           
PRJ910     PERFORM UNTIL (WS-FREE-ADDR-ID = FREEFORM-PARM-DATA) OR      
               (WS-END-OF-FREEFORM = 'Y')                               
               IF (PARM-LENGTH > 0) AND                                 
                  (FREEFORM-PARM-DATA < 9999999999999)                  
                   PERFORM 8000-READ-FREEFORM THRU 8000-EXIT            
               END-IF                                                   
           END-PERFORM.                                                 
           IF WS-END-OF-FREEFORM = 'Y' THEN                             
               DISPLAY '*****************************************'      
               DISPLAY '*PCSCA375 RECOVER FAILED.  FREEFORM PARM ID '   
                        FREEFORM-PARM-DATA ' WAS NOT FOUND.'            
               DISPLAY '*****************************************'      
               MOVE '12' TO WS-RETURN-CODE                              
               PERFORM 9000-TERMINATE                                   
           END-IF.                                                      
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15180000
       8100-READ-FORMATTED.                                             
               READ FORMATTED-FILE INTO WS-FORMATTED                    
                   AT END MOVE 'Y' TO WS-END-OF-FORMATTED.              
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15240000
       8150-RECOVER-FORMATTED.                                          
PRJ910     PERFORM UNTIL (WS-FORM-ADDR-ID    = FORMATTED-PARM-DATA) OR  
               (WS-END-OF-FORMATTED = 'Y')                              
               IF (PARM-LENGTH > 0) AND (FORMATTED-PARM-DATA > 0)       
                   PERFORM 8100-READ-FORMATTED THRU 8100-EXIT           
               END-IF                                                   
           END-PERFORM.                                                 
           IF WS-END-OF-FORMATTED = 'Y'                                 
               DISPLAY '*****************************************'      
               DISPLAY '*PCSCA375 RECOVER FAILED.  FORMATTED PARM ID '  
                       FORMATTED-PARM-DATA ' WAS NOT FOUND'             
               DISPLAY '*****************************************'      
               MOVE 12 TO WS-RETURN-CODE                                
               PERFORM 9000-TERMINATE                                   
           END-IF.                                                      
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15420000
T20788 8500-PREPARE-FREE-UPDATED.                                       
T20788     MOVE WS-FREE-ADDRESS-ID         TO   WS-AUTO-ADDRESS-ID.     
           MOVE 'U'                        TO   WS-AUTO-ADDRESS-TYPE    
T20788     MOVE WS-FREE-STREET-ADDR-INP    TO   WS-AUTO-STREET-ADDR.    
T20788     MOVE WS-FREE-CITY-STATE-INP     TO   WS-AUTO-CITY-STATE.     
T20788     MOVE WS-FREE-ZIP-INP            TO   WS-AUTO-ZIP-CODE.       
T20788     MOVE WS-FREE-PFOUR-INP          TO   WS-AUTO-PFOUR           
T20788     MOVE WS-FREE-DP-INP             TO   WS-AUTO-DP.             
T20788     MOVE WS-FREE-STREET-ADDR-RET    TO   WS-AUTO-STREET-CD1.     
T27914     MOVE WS-FREE-CITY-RET           TO   WS-AUTO-CITY-CD1.       
T27914     MOVE WS-FREE-STATE-RET          TO   WS-AUTO-STATE-CD1.      
T20788     MOVE WS-FREE-ZIP-RET            TO   WS-AUTO-ZIP-CD1.        
T20788     MOVE WS-FREE-PFOUR-RET          TO   WS-AUTO-PFOUR-CD1.      
T20788     MOVE WS-FREE-DP-RET             TO   WS-AUTO-DP-CD1.         
T20788     MOVE WS-FREE-ADDR-OFLOW-INP     TO   WS-AUTO-ADDR-OFLOW.     
T20788     PERFORM 8800-WRITE-UPDATED-FILE THRU 8800-EXIT.              
T20788 8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15610000
T20788 8550-PREPARE-FORM-UPDATED.                                       
T20788     MOVE WS-FORM-ADDRESS-ID         TO   WS-AUTO-ADDRESS-ID.     
           MOVE 'F'                        TO   WS-AUTO-ADDRESS-TYPE    
T20788     MOVE WS-FORM-STREET-ADDR-INP    TO   WS-AUTO-STREET-ADDR.    
T20788     MOVE WS-FORM-CITY-STATE-INP     TO   WS-AUTO-CITY-STATE.     
T20788     MOVE WS-FORM-ZIP-INP            TO   WS-AUTO-ZIP-CODE.       
T20788     MOVE WS-FORM-PFOUR-INP          TO   WS-AUTO-PFOUR           
T20788     MOVE WS-FORM-DP-INP             TO   WS-AUTO-DP.             
T20788     MOVE WS-FORM-STREET-ADDR-RET    TO   WS-AUTO-STREET-CD1.     
T27914     MOVE WS-FORM-CITY-RET           TO   WS-AUTO-CITY-CD1.       
T27914     MOVE WS-FORM-STATE-RET          TO   WS-AUTO-STATE-CD1.      
T20788     MOVE WS-FORM-ZIP-RET            TO   WS-AUTO-ZIP-CD1.        
T20788     MOVE WS-FORM-PFOUR-RET          TO   WS-AUTO-PFOUR-CD1.      
T20788     MOVE WS-FORM-DP-RET             TO   WS-AUTO-DP-CD1.         
T20788     MOVE WS-FORM-ADDR-OFLOW-INP     TO   WS-FAIL-ADDR-OFLOW.     
T20788     PERFORM 8800-WRITE-UPDATED-FILE THRU 8800-EXIT.              
T20788 8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15800000
T20788 8600-PREPARE-FREE-UNMATCHED.                                     
T20788     MOVE WS-FREE-ADDRESS-ID           TO   WS-FAIL-ADDRESS-ID.   
T20788     MOVE WS-FREE-STREET-ADDR-INP      TO   WS-FAIL-STREET-ADDR.  
T20788     MOVE WS-FREE-CITY-STATE-INP       TO   WS-FAIL-CITY-STATE.   
T20788     MOVE WS-FREE-ZIP-INP              TO   WS-FAIL-ZIP-CODE.     
T20788     MOVE WS-FREE-PFOUR-INP            TO   WS-FAIL-PFOUR         
T20788     MOVE WS-FREE-DP-INP               TO   WS-FAIL-DP.           
T20788     MOVE WS-FREE-ADDR-OFLOW-INP       TO   WS-FAIL-ADDR-OFLOW.   
T20788     PERFORM 8900-WRITE-UNMATCHED-FILE THRU 8900-EXIT.            
T20788 8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15920000
T20788 8650-PREPARE-FORM-UNMATCHED.                                     
T20788     MOVE WS-FORM-ADDRESS-ID           TO   WS-FAIL-ADDRESS-ID.   
T20788     MOVE WS-FORM-STREET-ADDR-INP      TO   WS-FAIL-STREET-ADDR.  
T20788     MOVE WS-FORM-CITY-STATE-INP       TO   WS-FAIL-CITY-STATE.   
T20788     MOVE WS-FORM-ZIP-INP              TO   WS-FAIL-ZIP-CODE.     
T20788     MOVE WS-FORM-PFOUR-INP            TO   WS-FAIL-PFOUR         
T20788     MOVE WS-FORM-DP-INP               TO   WS-FAIL-DP.           
T20788     MOVE WS-FORM-ADDR-OFLOW-INP       TO   WS-FAIL-ADDR-OFLOW.   
T20788     PERFORM 8900-WRITE-UNMATCHED-FILE THRU 8900-EXIT.            
T20788 8650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16040000
T20788 8800-WRITE-UPDATED-FILE.                                         
T20788     WRITE AUTO-UPDATED-LINE FROM WS-AUTO-UPDATED-LINE.           
T20788 8800-EXIT.                                                       
T20788     EXIT.                                                        
      *                                                                 16090000
A04860*                                                                 16090100
A04860***************************************************************** 16090200
A04860*   8895-INSERT-WORK-QUEUE                                      * 16090300
A04860***************************************************************** 16090400
A04860*                                                                 16090500
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                 16090700
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
T20788 8900-WRITE-UNMATCHED-FILE.                                       
T20788     WRITE UNMATCHED-ADDR-LINE FROM WS-UPDATE-FAILED-LINE.        
T20788 8900-EXIT.                                                       
T20788     EXIT.                                                        
      *                                                                 16170000
       9000-TERMINATE.                                                  
           CLOSE FREEFORM-FILE                                          
                 FORMATTED-FILE                                         
T20788           AUTO-UPDATED                                           
T20788           UNMATCHED-ADDR                                         
T27413           ZIPCODE-RPT.                                           
PRJ910*    MOVE ZERO TO SQLCODE.                                        16240000
PRJ910*    STOP RUN.                                                    16250000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16280000
       9200-SQL-ERROR.                                                  
      *                                                                 16300000
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN 100                                                 
                   CONTINUE                                             
               WHEN OTHER                                               
                   DISPLAY '******************************************' 
                   DISPLAY '            PCSCA375                      ' 
                   DISPLAY '  SQL RETURN CODE = ' SQLCODE               
                   DISPLAY '  IN TABLE '          WS-TABLE-ID           
                   DISPLAY '  WHILE FUNCTION = '  WS-DB2-FUNCTION       
                   DISPLAY '  IN MODULE '         WS-DB2-MODULE-ID      
                   DISPLAY '  IN PARAGRAPH '      WS-DB2-PARAGRAPH      
                   DISPLAY '  FOR ADDRESS ID '    WS-DB2-KEY-1N         
                   DISPLAY '******************************************' 
                   MOVE WS-DB2-RETURN-CODE TO RETURN-CODE               
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-EVALUATE.                                            
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16510000
       9500-SQL-ERROR.                                                  
      *                                                                 16530000
      *IF AN SQL ERROR OF -530 (BAD FOREIGN KEY) IS OBTAINED FROM THE   16540000
      *FORMATTED ADDRESS TABLE, THE UPDATED ZIP CODE MUST BE ADDED TO   16550000
      *THE CSS_ZIP_CODE TABLE BY 2500-INSERT-ZIP-CODE, AND THE UPDATE   16560000
      *MUST BE ATTEMPTED AGAIN.                                         16570000
      *                                                                 16580000
           EVALUATE SQLCODE                                             
               WHEN 0                                                   
                   CONTINUE                                             
               WHEN +100                                                
                   CONTINUE                                             
               WHEN -530                                                
                   MOVE 'N' TO WS-UPDATED-FLAG                          
                   PERFORM 2500-INSERT-ZIP-CODE                         
                   PERFORM 2300-UPDATE-FORMATTED                        
                   PERFORM 9200-SQL-ERROR THRU 9200-EXIT                
               WHEN OTHER                                               
                   DISPLAY '******************************************' 
                   DISPLAY '            PCSCA375                      ' 
                   DISPLAY '  SQL RETURN CODE = ' SQLCODE               
                   DISPLAY '  IN TABLE '          WS-TABLE-ID           
                   DISPLAY '  WHILE FUNCTION = '  WS-DB2-FUNCTION       
                   DISPLAY '  IN MODULE '         WS-DB2-MODULE-ID      
                   DISPLAY '  IN PARAGRAPH '      WS-DB2-PARAGRAPH      
                   DISPLAY '  FOR ADDRESS ID '    WS-DB2-KEY-1N         
                   DISPLAY '******************************************' 
                   MOVE WS-DB2-RETURN-CODE TO RETURN-CODE               
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-EVALUATE.                                            
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16880000
           EXEC SQL                                                     16890000
               INCLUDE CPD09900                                         16900000
           END-EXEC.                                                    16910000
                                                                        
