       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA365.                                           
COB303 DATE-WRITTEN. MAY 1999.                                          
       DATE-COMPILED.                                                   
      ******************************************************************00050000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00060000
      *                                                                *00080000
      ******************************************************************00090000
      *                                                                *00130000
      *               PROGRAM  MODIFICATION  LOG                       *00140000
      *                                                                *00150000
      *    DATE      INITIALS              REASON                      *00160000
      *                                                                *00160000
      *   12/05/03   PD           COPYBOOK CDP00068 CHANGED TO SUB     *        
C34097*   01/05/2007 MJ13662      DB2 FINE TUNING:                     *        
C34097*                           ADDED FOR FETCH ONLY AND WITH UR     *        
C34097*                           AND WITH HOLD FOR TO CURSOR.         *        
C34097*                           CHANGED DATE SELECTS TO SET STMTS.   *        
C34097*                           REMOVED DISTINCT.                    *        
C34097*                           ADDED COMMIT LOGIC.                  *        
C34097*                           ADDED FOR FETCH FOR 1 ROW TO SINGLETON        
C34097*                           SELECT.                              *        
C35944*   06/28/07   BASKAR V     CHECK DNP BALANCE FOR DNP ACCOUNTS   *        
C35944*                           ONLY                                 *        
C34097*   03/14/08   LG41184      ADD WITH UR                          *        
A04290*   08/14/12   MC95456      XFER TO ACCOUNT SHOULD UNDERGO FOR   *        
A04290*                           DNP BALANCE PROCESS                  *        
A04290*   10/31/12   MC95456      WHEN XFERTO ACCOUNT IS ARCHIVED      *        
A04290*                           CURRENT ACCOUNT SHOULD UNDER GO      *        
A04290*                           DNP BALANCE PROCESS                  *        
      ******************************************************************00190000
                                                                        
      ******************************************************************        
      ** THE PROGRAM IS TO TAKE ALL ACCOUNTS FROM CSS_PAYMENT_TRANS  ***        
      ** THEM THROUGH CPD00068 AND FIND OUT IF THE DNP BAL IS ZERO.  ***        
      ** IF THE DNP BAL IS ZERO AND DNP FLAG IS SET,THEN WRITE THE   ***        
      ** ACCOUNT IN THE CSS_SO_CANCEL_DNP TABLE.                     ***        
      ******************************************************************00050000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA365'.
MSQ017     COPY MFASQLM.
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'PCSCA365'.     
T19557     05  SCSCB068                 PIC X(08) VALUE 'SCSCB068'.     
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
A04290     05  WS-CURR-ACCT-NO          PIC  X(13) VALUE SPACES.        
           05  RS-RETURN-CODE           PIC S9(9) VALUE +000 COMP.      
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND4             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND5             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND6             PIC S9(04) COMP VALUE +0.       
C34097     05  WS-COMMIT-COUNT          PIC 9(04) VALUE ZEROS.          
C34097     05  WS-100                   PIC 9(03) VALUE 100.            
C34097     05  WS-1                     PIC 9(01) VALUE 1.              
           05  WS-PARM-DATE-FROM        PIC X(10) VALUE SPACES.         
           05  WS-PARM-DATE-TO          PIC X(10) VALUE SPACES.         
           05  WS-DELINQ-VAL            PIC 9(04) VALUE 0.              
           05  WS-START-DATE            PIC X(10) VALUE SPACES.         
C34097     05  WS-START-DATE-TIME.                                      
C34097         10  WS-START-DATE-10     PIC X(10) VALUE SPACES.         
C34097         10  WS-START-TIME-16     PIC X(16)                       
C34097             VALUE '-00.00.00.000000'.                            
       01  WS-PREV-BUSINESS-DAY-MISC.                                   
           05 WS-OLD-BUSINESS-DAY      PIC X(10).                       
           05 WS-PREV-SUNDAY           PIC S9(04) COMP VALUE -1.        
           05 WS-PREV-SATURDAY         PIC S9(04) COMP VALUE +5.        
           05 WS-PREV-BUSINESS-DAY     PIC  X(01)      VALUE 'N'.       
              88 PREV-BUSINESS-DAY-FOUND               VALUE 'Y'.       
A04290     05 WS-ARCHIVED-ACCT         PIC  X(01)      VALUE 'N'.       
A04290        88 ARCHIVED-ACCT                         VALUE 'Y'.       
                                                                        
           EXEC SQL                                                     03500000
              INCLUDE SQLCA                                             03510000
           END-EXEC.                                                    03520000
                                                                        
           EXEC SQL                                                     03980000
              INCLUDE TBACCT                                            03990000
           END-EXEC.                                                    04000000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPMTRAN                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODNPC                                                  
           END-EXEC.                                                            
      *                                                                         
      * CSS_HOLIDAY                                                             
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_HOLIDAY                                                             
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      * CSS_RECONNECT                                                           
           EXEC SQL                                                             
               INCLUDE TBRECNCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     05474000
              INCLUDE CWS00010                                          05475000
           END-EXEC.                                                    05476000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     05474000
              INCLUDE CWS00068                                          05475000
           END-EXEC.                                                    05476000
                                                                        
           EXEC SQL                                                     05474000
              INCLUDE CWS00056                                          05475000
           END-EXEC.                                                    05476000
                                                                        
           EXEC SQL                                                     05474000
              INCLUDE CWS00303                                          05475000
           END-EXEC.                                                    05476000
                                                                        
           EXEC SQL                                                     05474000
              INCLUDE CWS00315                                          05475000
           END-EXEC.                                                    05476000
                                                                        
           EXEC SQL                                                             
            INCLUDE CWS09900                                                    
           END-EXEC.                                                            
                                                                        
       01  DATE-PARAMETER.                                              
      *    03  CHKBYTES                  PIC 9(04) COMP.                        
           03  PARM-IN-DATES-FROM        PIC X(10).                     
           03  PARM-IN-DATES-TO          PIC X(10).                     
                                                                        
           EXEC SQL                                                     
C34097         DECLARE PAYMENT CURSOR WITH HOLD FOR                     
               SELECT  JT.ACCOUNT_NO                                    
                FROM   CSS_PAYMENT_TRANS JT WITH(READUNCOMMITTED)               
C34097         WHERE APPLIED_TS >= CIS.CHAR2TIMESTAMP(:JT-APPLIED-TS)           
C34097           AND NOT EXISTS                                         
C34097           (SELECT 'Y'                                            
C34097            FROM CSS_SO_DNP_CANCEL XK WITH(READUNCOMMITTED)               
C34097              WHERE                                               
C34097              JT.ACCOUNT_NO = XK.ACCOUNT_NO                       
C34097              AND XK.SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL)   
C34097         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PAYMENT CURSOR WITH HOLD FOR                             
MFA-TR*        SELECT  JT.ACCOUNT_NO                                            
MFA-TR*         FROM   CSS_PAYMENT_TRANS JT                                     
MFA-TR*        WHERE APPLIED_TS >= :JT-APPLIED-TS                               
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*          (SELECT 'Y'                                                    
MFA-TR*           FROM CSS_SO_DNP_CANCEL XK                                     
MFA-TR*             WHERE                                                       
MFA-TR*             JT.ACCOUNT_NO = XK.ACCOUNT_NO                               
MFA-TR*             AND XK.SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL)           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
           PERFORM 1000-PROCESS-DNP             THRU 1000-EXIT          
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       1000-PROCESS-DNP.                                                
           PERFORM 7400-SELECT-CURRENT-DATE THRU 7400-EXIT.             
                                                                        
           MOVE 'BM-DNPCAN-DAYS'             TO C8-DELINQ-CD            
           MOVE '01'                         TO C8-COMPANY-NO           
                                                                        
           PERFORM 7700-GET-DELINQ-VALUE    THRU 7700-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 1                         TO WS-DELINQ-VAL           
           ELSE                                                         
              MOVE C8-DELINQ-VALUE           TO WS-DELINQ-VAL           
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-DATE              TO WS-OLD-BUSINESS-DAY     
           MOVE 'N'                          TO WS-PREV-BUSINESS-DAY    
           MOVE SPACES                       TO WS-HOLIDAY-EXISTS       
                                                                        
           PERFORM WS-DELINQ-VAL TIMES                                  
              PERFORM 1300-GET-PREV-BUSINESS-DAY THRU 1300-EXIT         
                UNTIL PREV-BUSINESS-DAY-FOUND                           
              MOVE 'N'                       TO WS-PREV-BUSINESS-DAY    
           END-PERFORM                                                  
                                                                        
C34097     MOVE WS-OLD-BUSINESS-DAY         TO WS-START-DATE-10.        
C34097     MOVE WS-START-DATE-TIME          TO JT-APPLIED-TS.           
C34097     MOVE 'T'                         TO XK-SO-UPDT-ACTION-FL.    
C34097     DISPLAY WS-START-DATE-TIME                                   
           PERFORM 7000-OPEN-PAYMENT        THRU 7000-EXIT.             
           PERFORM 7100-FETCH-PAYMENT       THRU 7100-EXIT.             
                                                                        
           PERFORM UNTIL SQLCODE NOT = 0                                
A04290         MOVE 'N'           TO WS-ARCHIVED-ACCT                   
A04290         MOVE ' '           TO WS-CURR-ACCT-NO                    
               MOVE JT-ACCOUNT-NO TO AT-ACCOUNT-NO                      
               DISPLAY AT-ACCOUNT-NO                                    
               PERFORM 7300-SELECT-ACCOUNT  THRU 7300-EXIT              
                                                                        
A04290         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
A04290            PERFORM UNTIL AT-ACCT-XFER-TO = 0 OR                  
A04290                       WS-ACTIVE-RETURN-CODE = NOT-FOUND          
A04290               MOVE AT-ACCOUNT-NO     TO WS-CURR-ACCT-NO          
A04290               MOVE AT-ACCT-XFER-TO   TO AT-ACCOUNT-NO            
A04290               DISPLAY AT-ACCOUNT-NO                              
A04290               PERFORM 7300-SELECT-ACCOUNT  THRU 7300-EXIT        
A04290               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND               
A04290                  MOVE 'Y'            TO WS-ARCHIVED-ACCT         
A04290               END-IF                                             
A04290            END-PERFORM                                           
A04290            IF AT-ACCT-XFER-TO = 0                                
A04290               PERFORM 1500-PROCESS-DNP-BAL THRU 1500-EXIT        
A04290            END-IF                                                
A04290            IF ARCHIVED-ACCT                                      
A04290               MOVE WS-CURR-ACCT-NO         TO AT-ACCOUNT-NO      
A04290               DISPLAY AT-ACCOUNT-NO                              
A04290               PERFORM 7300-SELECT-ACCOUNT  THRU 7300-EXIT        
A04290               PERFORM 1500-PROCESS-DNP-BAL THRU 1500-EXIT        
A04290            END-IF                                                
A04290         END-IF                                                   
                                                                        
               PERFORM 7100-FETCH-PAYMENT     THRU 7100-EXIT            
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-PAYMENT         THRU 7200-EXIT.           
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1300-GET-PREV-BUSINESS-DAY.                                      
                                                                        
           PERFORM 7500-GET-PREV-BUSINESS-DAY THRU 7500-EXIT            
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                                   
           IF WS-DAY-OF-WEEK NOT EQUAL 5 AND                            
              WS-DAY-OF-WEEK NOT EQUAL -1                               
                                                                        
              MOVE WS-OLD-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE 'N'                       TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY            
              PERFORM 7600-CHECK-HOLIDAY     THRU 7600-EXIT             
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE 'Y'                   TO WS-PREV-BUSINESS-DAY    
              ELSE                                                      
                  MOVE 'N'                   TO WS-PREV-BUSINESS-DAY    
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04290 1500-PROCESS-DNP-BAL.                                            
                                                                        
           MOVE SPACES                 TO WS-HOLD-DNP-TYPE              
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT         
C35944     IF WS-CODE-PENDING-DNP = 'A'                                 
              MOVE WS-CURRENT-DATE     TO WS-HOLD-DATE                  
                                          WS-CL-DATE-NOTICE-MAIL        
                                          WS-CL-DATE-NOTICE-DUE         
              MOVE 'Y' TO CALC-DNP-BAL-SW                               
                          CALC-ARREARS-SW                               
                          CALC-PAST-DUE-SW                              
                          CALC-BALANCE-SW                               
                          CALC-NOT-BAL-SW                               
                                                                        
              MOVE PROGRAM-NAME        TO  WS-CPD00068-CALLING-PGM      
              MOVE SPACES              TO  ABEND-FUNCTION               
              CALL SCSCB068  USING  CWS00068-FIELDS,                    
                                    WS-CODES-DATA-PRESENT,              
                                    DCLCSS-ACCOUNT,                     
                                    ABEND-FILE,                         
                                    RS-RETURN-CODE                      
              IF ABEND-FUNCTION  > SPACES                               
                 PERFORM 9900-ABEND          THRU 9900-EXIT             
              END-IF                                                    
              PERFORM 6100-CALC-NEW-DNP-AMT THRU                        
                      6100-CALC-NEW-DNP-AMT-EXIT                        
                                                                        
              DISPLAY AT-ACCOUNT-NO,' ', WS-AMT-DNP-BAL                 
                                                                        
              IF WS-AMT-DNP-BAL <= 0                                    
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
                 MOVE SPACES                TO WS-CODE-PENDING-DNP      
                 MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT    
                 DISPLAY AT-ACCOUNT-NO ' ' WS-AMT-DNP-BAL               
                         ' ' AT-LAST-PYMT-DATE                          
                 MOVE AT-ACCOUNT-NO TO XK-ACCOUNT-NO                    
                 MOVE 'T'           TO XK-SO-UPDT-ACTION-FL             
                 PERFORM 8000-INSERT-DNP    THRU 8000-EXIT              
                 IF WS-ACTIVE-RETURN-CODE = -803                        
                    PERFORM 8100-UPDATE-DNP THRU 8100-EXIT              
                 END-IF                                                 
C34097           ADD WS-1                    TO WS-COMMIT-COUNT         
C34097           IF WS-COMMIT-COUNT = WS-100                            
C34097              PERFORM 8900-COMMIT                                 
C34097              INITIALIZE WS-COMMIT-COUNT                          
C34097           END-IF                                                 
              END-IF                                                    
C35944     END-IF.                                                      
                                                                        
A04290 1500-EXIT.                                                       
A04290      EXIT.                                                       
                                                                        
       7000-OPEN-PAYMENT.                                               
           MOVE '7000'    TO WS-ACTIVE-PARAGRAPH                        
           EXEC SQL                                                     
               OPEN PAYMENT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE                   
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'OPEN CURSOR'         TO ABEND-FUNCTION              
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
       7100-FETCH-PAYMENT.                                              
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH         
           EXEC SQL                                                     
               FETCH PAYMENT                                            
               INTO   :JT-ACCOUNT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'FETCH CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
       7200-CLOSE-PAYMENT.                                              
                                                                        
           MOVE '7200'    TO WS-ACTIVE-PARAGRAPH                        
           EXEC SQL                                                     
               CLOSE PAYMENT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = 0                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'CLOSE CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
       7300-SELECT-ACCOUNT.                                             
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH         
               EXEC SQL                                                 
               SELECT  ACCOUNT_NO,                                      
                       LAST_PYMT_DATE,                                  
                       CODES_DATA_PRESENT,                              
                       NOTICE_EXEMPT_CD,                                
                       CODE_DISC_OK,                                    
                       DATE_BILL_DAY_00,                                
                       DATE_BILL_DAY_30,                                
                       DATE_BILL_DAY_60,                                
                       DATE_BILL_DAY_90,                                
                       COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       BANKRUPTCY_IND,                                  
                       CREDIT_GROUP,                                    
                       CODE_ACCT_STAT,                                  
A04290                 ACCT_XFER_TO,                                    
C28788                 IVR_EXEMPT_CD                                    
               INTO   :AT-ACCOUNT-NO,                                   
                      :AT-LAST-PYMT-DATE :WS-NULL-IND1,                  
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-NOTICE-EXEMPT-CD,                             
                      :AT-CODE-DISC-OK,                                 
                      :AT-DATE-BILL-DAY-00 :WS-NULL-IND2,                
                      :AT-DATE-BILL-DAY-30 :WS-NULL-IND3,                
                      :AT-DATE-BILL-DAY-60 :WS-NULL-IND4,                
                      :AT-DATE-BILL-DAY-90 :WS-NULL-IND5,                
                      :AT-COMPANY-NO,                                   
                      :AT-LOCAL-OFFICE,                                 
                      :AT-BANKRUPTCY-IND,                               
                      :AT-CREDIT-GROUP,                                 
                      :AT-CODE-ACCT-STAT,                               
A04290                :AT-ACCT-XFER-TO,                                 
C28788                :AT-IVR-EXEMPT-CD                                 
                  FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                        
                  WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                     
C34097                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*        SELECT  ACCOUNT_NO,                                              
MFA-TR*                LAST_PYMT_DATE,                                          
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                NOTICE_EXEMPT_CD,                                        
MFA-TR*                CODE_DISC_OK,                                            
MFA-TR*                DATE_BILL_DAY_00,                                        
MFA-TR*                DATE_BILL_DAY_30,                                        
MFA-TR*                DATE_BILL_DAY_60,                                        
MFA-TR*                DATE_BILL_DAY_90,                                        
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                BANKRUPTCY_IND,                                          
MFA-TR*                CREDIT_GROUP,                                            
MFA-TR*                CODE_ACCT_STAT,                                          
MFA-TR*                ACCT_XFER_TO,                                            
MFA-TR*                IVR_EXEMPT_CD                                            
MFA-TR*        INTO   :AT-ACCOUNT-NO,                                           
MFA-TR*               :AT-LAST-PYMT-DATE:WS-NULL-IND1,                          
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-NOTICE-EXEMPT-CD,                                     
MFA-TR*               :AT-CODE-DISC-OK,                                         
MFA-TR*               :AT-DATE-BILL-DAY-00:WS-NULL-IND2,                        
MFA-TR*               :AT-DATE-BILL-DAY-30:WS-NULL-IND3,                        
MFA-TR*               :AT-DATE-BILL-DAY-60:WS-NULL-IND4,                        
MFA-TR*               :AT-DATE-BILL-DAY-90:WS-NULL-IND5,                        
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-BANKRUPTCY-IND,                                       
MFA-TR*               :AT-CREDIT-GROUP,                                         
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-ACCT-XFER-TO,                                         
MFA-TR*               :AT-IVR-EXEMPT-CD                                         
MFA-TR*           FROM CSS_ACCOUNT                                              
MFA-TR*           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*           WITH UR                                                       
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'FETCH CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
       7400-SELECT-CURRENT-DATE.                                        
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
C34097         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
C34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
       7500-GET-PREV-BUSINESS-DAY.                                      
                                                                        
           EXEC SQL                                                     
C34097        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) )) -         
C34097              CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-OLD-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-OLD-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-BUSINESS-DAY
              ), CONVERT(DATE, :WS-OLD-BUSINESS-DAY) ) ))/7*7)-1
            INTO
              :WS-OLD-BUSINESS-DAY,
              :WS-DAY-OF-WEEK    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-OLD-BUSINESS-DAY =                                        
MFA-TR*           DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS,                          
MFA-TR*           :WS-DAY-OF-WEEK =                                             
MFA-TR*            (DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS) -                 
MFA-TR*             DAYS(DATE(:WS-OLD-BUSINESS-DAY) - 1 DAYS)/7*7)-1            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CHECKS WHETHER THE GIVEN DATE IS EXISTS IN HOLIDAY TABLE      *         
      *---------------------------------------------------------------*         
                                                                        
       7600-CHECK-HOLIDAY.                                              
                                                                        
C34097     MOVE 'N'      TO WS-HOLIDAY-EXISTS.                          
                                                                        
           EXEC SQL                                                     
C34097       SELECT 'Y'                                                 
               INTO :WS-HOLIDAY-EXISTS                                  
               FROM CSS_HOLIDAY                                         
              WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*        INTO :WS-HOLIDAY-EXISTS                                          
MFA-TR*        FROM CSS_HOLIDAY                                                 
MFA-TR*       WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_HOLIDAY  '       TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE          *         
      *---------------------------------------------------------------*         
                                                                        
       7700-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY                                     
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-DNP.                                                 
           MOVE '8000'                   TO WS-ACTIVE-PARAGRAPH         
           EXEC SQL                                                     
              INSERT INTO CSS_SO_DNP_CANCEL                             
               (ACCOUNT_NO                                              
               ,SO_UPDT_ACTION_FL)                                      
              VALUES                                                    
               (:XK-ACCOUNT-NO                                          
               ,:XK-SO-UPDT-ACTION-FL)                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      -803                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'FETCH CURSOR'        TO ABEND-FUNCTION              
              MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
              MOVE '                 '   TO TABLE-ELEMENT-1             
              MOVE '                 '   TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
       8100-UPDATE-DNP.                                                 
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH         
           EXEC SQL                                                     
             UPDATE  CSS_SO_DNP_CANCEL                                  
                SET  SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL          
             WHERE  ACCOUNT_NO = :XK-ACCOUNT-NO                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO       '   TO TABLE-ELEMENT-1             
              MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
C34097****************************************************************          
C34097*  ISSUES A COMMIT POINT                                      **          
C34097****************************************************************          
C34097 8900-COMMIT.                                                     
C34097*                                                                         
C34097     EXEC SQL                                                     
C34097        COMMIT                                                    
C34097     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
C34097*                                                                         
C34097 8900-EXIT.                                                       
C34097     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9000'                  TO   WS-ACTIVE-PARAGRAPH.       
           DISPLAY 'WS-ACTIVE-PARAGRAPH ' ,  ACTIVE-PARAGRAPH           
           DISPLAY 'PROGRAM-NAME        ' ,  ABEND-PROGRAM              
           DISPLAY 'RETURN CODE         ' ,  RS-RETURN-CODE             
           DISPLAY 'ABEND-FUNCTION      ' ,  ABEND-FUNCTION             
           DISPLAY 'TABLE-1             ' ,  TABLE-1                    
           DISPLAY 'TABLE-ELEMENT-1     ' ,  TABLE-ELEMENT-1            
           DISPLAY 'HOSTVAR-ELEMENT-1   ' ,  HOSTVAR-ELEMENT-1.         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
       9700-PROCESS-ABEND.                                              
              MOVE '9700'                TO WS-ACTIVE-PARAGRAPH         
              MOVE WS-ACTIVE-PARAGRAPH   TO ACTIVE-PARAGRAPH            
              MOVE 'CPD00068'            TO ABEND-PROGRAM               
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              PERFORM 9900-ABEND         THRU 9900-EXIT.                
       9700-EXIT.                                                       
           EXIT.                                                        
       9999-END-PROGRAM.                                                
           STOP RUN.                                                    
       9999-EXIT.                                                       
           EXIT.                                                        
           EXEC SQL                                                             
              INCLUDE CPD00316                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
