       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA362.                                        
       DATE-WRITTEN.   OCT 2003.                                        
      ******************************************************************        
      *                                                                *        
      *                 PROGRAM MODIFICATION LOG                       *        
      *                                                                *        
      *   DATE    INITIALS   REASON                                    *        
      * --------  --------   -------------------------------------     *        
      *  12/03     PD         NEW PROGRAM                              *        
C30257*  04/04     VB        1. UPDATE APPLIED FLAG ONE AT A TIME      *        
C30257*                      2. INSERT COBB XFER PYMT IN BILL AGNT TBL *        
C30257*                      3. UPDATE LAST UPDATE USERID AS 'CA362'   *        
C29529*  06/04    SS19371     CHANGES FOR E-PAY PROCESSING             *        
C29529*  09/04    SS19371    CORRECTION SO THAT CHANGES ONLY ASPPLY TO *        
C29529*                        E-PAY ACCOUNTS AND NOT BILL MATRIX ACCTS*        
C31602*  09/04    SS19371    CLEAN UP REFERENCE PARAGRAPH #S, SQLCODES *        
C31602*                        AND HOST VARIABLES DISPLAYED. AND CLEAN *        
C31602*                        UP CODE IN GENERAL AS NEEDED (CALLS TO  *        
C31602*                        COMMENTED OUT PARAGRPAHS).              *        
C2952B*  09/04    SS19371    ADDED CODE TO ENSURE PROPER JOURNALLING OF*        
C2952B*                        ERROR ACCOUNTS (EPAY VS BILL MATRIX)    *        
APSAPS*  10/04    PD80186    APS CODE                                  *        
C31844*  02/15/05 BASKAR  1. WRITE ERROR JOURNAL FOR REAL TIME EPAY    *        
C31844*                      TO OFFSET THE PAYMENT AMOUNT              *        
C31844*                   2. USE APPL-PROGRAM-ID TO VERIFY CASHIER     *        
C31844*                      OFFICE                                    *        
C31844*                   3. USE APPL-PROGRAM-ID'S CASHIER OFFICE      *        
C31844*                      WHEN DOING ERROR JOURNAL                  *        
C31844*                   4. DON'T CHECK FOR PENDING E-PAY FOR         *        
C31844*                      E-PAYMENTS                                *        
APSAPS*  04/12/05 SK88120    OVER-SHORT CORRECTION FOR REVERSALS       *        
APSAPS*  05/02/05 SK88120    CORRECTION FOR REVERSALS while updating   *        
APSAPS*                      CSS_BCH_JRNL_CNTL                         *        
APSAPS*  06/02/05 SK88120    UPDATE OV/SH TABLE WITH CORRECT CR/DR     *        
APSAPS*                      INDICATOR                                 *        
C34416*  06/21/06 BASKAR     WRITE APS REVERSAL TRANSACTIONS WITH CRDT *        
C34416*                      ACTION IN THE ERROR REPORT, THESE ARE NOT *        
C34416*                      ERRORS BUT THESE ARE REPORTED FOR         *        
C34416*                      REMITTANCE                                *        
C33928*  06/21/06 BASKAR     PERFORMANCE TUNING                        *        
C33928*  01/10/07 LG41184    PERFORMANCE TUNING                        *        
C33928*  11/16/07 BASKAR     AVOID ABEND BY LEAVING CURRENT            *        
C33928*                      TRANSACTIONS WHILE SELECTING TRANSACTIONS *        
C33928*                      FOR POSTING. WHEN BILLMATRIX CHANGE THEIR *        
C33928*                      TIME TO EST THEN CURSOR NEEDS TO BE       *        
C33928*                      MODIFIED TO SELECT < CURRENT TS - 5 MINUTE*        
C35842*  09/23/08 BASKAR     BMX CHANGED THE PAYMENT RECEIVED TS TO EST*        
C35842*                      SO REDUCING THE TIME LAG TO 5 MINUTES     *        
A00575*  01/20/09 BASKAR V   STORE CREDIT ACTION FLAG IN ERROR_CD      *        
A00575*                      FIELD OF CSS_PAYMENT_TRANS TABLE, HANDLE  *        
A00575*                      ERROR_CD FIELD FOR THAT.                  *        
P00420*  09/10/10 RICK S.    REMOVE FOR UPDATE OF CLAUSE ON PAYMENT    *        
P00420*                      TRANS SELECT.                             *        
P00641* 05/01/12   DB41297    REMOVE TBGLATNO UNUSED FIELDS.           *        
P00552* 07/26/12  BASKAR V   CREATE BATCH WITH DRAWER ID LESS THAN 9999*        
A05136* 09/17/15   DB41297    SET RC=02 IF NO DATA FOR JCL TRIGGER.    *        
ACT306* 10/28/16   RB19957    REMOVE ALL LOGIC THAT CALLS DB2          *        
ACT306*  APPL00005460,ACT306  TABLE CSS_BILL_AGNT_PYMT & TBBAPYMT.     *        
PTS55 * 03/14/17  TP7R341    FIX FOR -501 ERROR                        *        
      ******************************************************************        
      *                                                                         
              REMARKS.                                                  
      *                                                                         
      ******************************************************************        
      *  THIS PROGRAM READS CSS_PAYMENT_TRANS FOR NON-PROCESSED        *        
      *  PAYMENTS AND PROCESSES THEM ACCORDINGLY.                      *        
      ******************************************************************        
      *                                                                         
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
      *                                                                         
             0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION       
             1000 - 1999     INPUT PROCESSING CONTROL PATH              
             2000 - 2999     OUTPUT PROCESSING CONTROL PATH             
             3000 - 4999     BATCH PROCESSING MODULES - NOT USED        
             5000 - 5999     COMMON PROGRAM MODULES                     
             6000 - 6999     COMMON SYSTEM MODULES                      
             7000 - 7999     INPUT MODULES                              
             8000 - 8999     OUTPUT MODULES                             
             9000 - 9799     TERMINATION MODULES                        
             9800 - 9899     XCTLS TO PROGRAMS                          
             9900 - 9999     ABEND/ABORT MODULES                        
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
      *                                                                         
      ***************************************************************           
      *  CSSPT33 - SELECT STATEMENT FOR OUTPUT REPORT FILE - 133 CHR*           
      ***************************************************************           
       COPY CSSPT33.                                                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ***************************************************************           
      *  CFDPT33 - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE       *           
      ***************************************************************           
       COPY CFDPT33.                                                            
      *                                                                         
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA362'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                *        
      *             'WORKING STORAGE FOR PCSCA362 STARTS HERE'.        *        
      ******************************************************************        
                                                                        
       01 WS-FLAGS.                                                     
          05  WS-DEBIT-FLAG                     PIC X(01).              
          05  WS-EXISTS-FLAG                    PIC X(01).              
          05  WS-ACCT-EXIST                     PIC X(01).              
          05  WS-DFA-FLAG                       PIC X(01).              
       01  WS-SWITCHES.                                                 
           05  WS-FCSAC01-EOF-SW                PIC X(01) VALUE 'N'.    
                       88  WS-FCSAC01-AT-EOF              VALUE 'Y'.    
                       88  WS-FCSAC01-NOT-AT-EOF          VALUE 'N'.    
           05  WS-FAC01-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC01-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-FAC22-STATUS                  PIC X(02) VALUE '00'.   
                       88  WS-FAC22-SUCCESSFUL            VALUE '00'    
                                                                '04'.   
           05  WS-VALID-ACCT-SW                 PIC X(01) VALUE 'Y'.    
                       88  WS-VALID-ACCOUNT               VALUE 'Y'.    
                       88  WS-NOT-VALID-ACCOUNT           VALUE 'N'.    
                                                                        
           05  WS-VALID-PROC-SW                 PIC X(01) VALUE 'Y'.    
                       88  WS-ACCT-PROC                   VALUE 'Y'.    
                       88  WS-ACCT-NOT-PROC               VALUE 'N'.    
                                                                        
           05  WS-COBB-XFERED-FLAG              PIC X(01) VALUE 'Y'.    
                       88  COBB-XFERED-ACCT               VALUE 'Y'.    
                       88  REGULAR-ACCT                   VALUE 'N'.    
C29529     05  WS-ROW-IN-PNDING-BNK-DRFT        PIC X(01) VALUE 'Y'.    
C29529                 88  DRAFT-FOUND                    VALUE 'Y'.    
C29529                 88  DRAFT-NOT-FOUND                VALUE 'N'.    
                                                                        
                                                                        
      ******************************************************************        
      *  WORKING STORAGE DECLARATION FOR DATE VARIABLES                *        
      ******************************************************************        
       01  WS-DATE-VARIABLES.                                           
           05  WS-TEMP-DATE.                                            
               10  WS-TEMP-YY                   PIC 9(04).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-MM                   PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-TEMP-DD                   PIC 9(02).              
           05  WS-RUN-DATE.                                             
               10 WS-DT-YY                      PIC 9(02).              
               10 WS-DT-MM                      PIC 9(02).              
               10 WS-DT-DD                      PIC 9(02).              
           05  WS-CUR-CCYY.                                             
               10  WS-CUR-CC                    PIC 9(02).              
               10  WS-CUR-YY                    PIC 9(02).              
           05  WS-REPORT-DATE.                                          
               10  WS-REP-MM                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
               10  WS-REP-DD                    PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '/'.    
T22767         10  WS-REP-YY                    PIC 9(02).              
           05  WS-BATCH-DATE.                                           
               10  WS-BATCH-MM                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-DD                  PIC 9(02).              
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-BATCH-YY                  PIC 9(04).              
      *                                                                         
T22767******************************************************************        
T22767*  WORKING STORAGE DECLARATION FOR TIME VARIABLES                *        
T22767******************************************************************        
T22767                                                                  
T22767 01  WS-TIME-VARIABLES.                                           
T22767     05  WS-RUN-TIME.                                             
T22767         10 WS-HH                         PIC 9(02).              
T22767         10 WS-MM                         PIC 9(02).              
T22767         10 WS-SS                         PIC 9(02).              
T22767         10 WS-TT                         PIC 9(02).              
T22767     05  WS-REPORT-TIME.                                          
T22767         10  WS-RT-HH                     PIC X(02).              
T22767         10  FILLER                       PIC X(01) VALUE ':'.    
T22767         10  WS-RT-MM                     PIC X(02).              
T22767         10  FILLER                       PIC X(01) VALUE ':'.    
T22767         10  WS-RT-SS                     PIC X(02).              
T22767                                                                  
       01  WS-DATE-VARIABLES-1.                                         
           05  WS-DATE-CENTURY.                                         
               10  WS-CEN-CC                    PIC 9(02) VALUE ZEROES. 
               10  WS-CEN-YY                    PIC 9(02) VALUE ZEROES. 
           05  WS-AC01-DATE.                                            
               10  WS-AC01-CC                   PIC 9(02) VALUE ZEROES. 
               10  WS-AC01-YY                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-MM                   PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-AC01-DD                   PIC 9(02) VALUE ZEROES. 
           05  WS-DRAFT-DATE.                                           
               10  WS-DRAFT-CC                  PIC 9(02) VALUE ZEROES. 
               10  WS-DRAFT-YY                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-MM                  PIC 9(02) VALUE ZEROES. 
               10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-DRAFT-DD                  PIC 9(02) VALUE ZEROES. 
T29106     05  WS-CHECK-DATE.                                           
T29106         10  WS-CHECK-CC                  PIC X(02) VALUE '20'.   
T29106         10  WS-CHECK-YY                  PIC X(02) VALUE SPACES. 
T29106         10  FILLER                       PIC X(01) VALUE '-'.    
T29106         10  WS-CHECK-MM                  PIC X(02) VALUE SPACES. 
T29106         10  FILLER                       PIC X(01) VALUE '-'.    
               10  WS-CHECK-DD                  PIC X(02) VALUE SPACES. 
           05  WS-TRAN-TIME                     PIC X(08) VALUE SPACES. 
           05  WS-XFR-TS                        PIC X(26) VALUE SPACES. 
                                                                        
       01  WS-COUNTERS.                                                 
           05  WS-CIS-NO-OF-DOCS                PIC 9(06) VALUE ZEROES. 
           05  WS-CIS-BATCH-TOTAL               PIC S9(11)V99           
                                                          VALUE ZEROES. 
           05  WS-ERR-NO-OF-DOCS                PIC 9(06) VALUE ZEROES. 
           05  WS-ERR-BATCH-TOTAL               PIC S9(11)V99           
                                                          VALUE ZEROES. 
           05  WS-BATCH-TOTAL-COUNT             PIC 9(04) VALUE ZEROES. 
           05  WS-BATCH-TOTAL-AMOUNT            PIC S9(11)V99           
                                                          VALUE ZEROES. 
       01  WS-WORK-VARIABLES.                                           
           05  WS-ERR-MSG                       PIC X(100) VALUE SPACES.
           05  WS-ERR-MSG2                      PIC X(100) VALUE SPACES.
           05  WS-REJECT-REASON                 PIC X(01)  VALUE SPACES.
           05  WS-DISP-CASH-DRAWER-ID           PIC 9(03).              
           05  WS-DISP-CUSTOMER-NO              PIC 9(10).              
           05  WS-DISP-ACCOUNT-NO               PIC 9(13).              
           05  WS-PYMT-AMOUNT                   PIC S9(09)V99           
                                                 COMP-3 VALUE +0.       
           05  WS-PYMT-AMT-NUM                  PIC 9(9)V99.            
           05  WS-PYMT-AMT REDEFINES WS-PYMT-AMT-NUM PIC X(11).         
           05  WS-DISP-GL-ACCT                  PIC 9(3).9(4).          
           05  WS-DISP-FILE-AMOUNT              PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-DISP-TOTAL-AMOUNT             PIC 9(10).99            
                                                          VALUE ZEROES. 
           05  WS-NULL-INDICATOR1               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR2               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR3               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR4               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR5               PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-NULL-INDICATOR-1              PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CASH-DRAWER-ID                PIC 9(04).              
           05  WS-CNTL-TS-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-DATE-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CJ-TIME-NI                    PIC S9(4) USAGE COMP    
                                                          VALUE -1.     
           05  WS-CASH-GL-ACCT                  PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-BNKXFR-GL-ACCT                PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-ERR-GL-ACCT                   PIC 9(03)V9(04)         
                                                          VALUE ZEROES. 
           05  WS-PREV-REC-TYPE                 PIC 9(01) VALUE ZEROES. 
           05  WS-PREV-BATCH-NO                 PIC 9(04) VALUE ZEROES. 
           05  WS-AMT-9                         PIC 9(08)V99.           
           05  WS-AMT-X                                                 
               REDEFINES WS-AMT-9               PIC X(10).              
           05  WS-FIFTY-FIVE                    PIC 9(03) VALUE 55.     
           05  WS-PAGE-NUM                      PIC 9(04) VALUE ZEROES. 
           05  WS-LINE-SPACE                    PIC 9(02) VALUE ZEROES. 
           05  WS-LINE-DIFF                     PIC 9(03) VALUE ZEROES. 
           05  WS-LINE-CNTR                     PIC 9(03) VALUE 56.     
           05  WS-PAYMENT-PRESENT               PIC X(01) VALUE 'N'.    
C2952B     05  WS-EPAY-CASH-LOCAL-OFFICE    PIC X(03).                  
C2952B     05  WS-EPAY-USER-ID              PIC X(07).                  
C2952B     05  WS-EPAY-BATCH-DEP-CASH-OFF   PIC X(03).                  
C2952B     05  WS-EPAY-DEP-XFER-METHOD      PIC X(01).                  
COB305     05 WS-EPAY-DEP-DEFT-BANK-ID        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
C2952B     05  WS-EPAY-LOCAL-OFFICE         PIC X(03).                  
COB305     05 WS-EPAY-DEP-CASH-GL-OFFSET        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.
C2952B     05  WS-EPAY-PAYMENT-AGENT-FL     PIC X(01).                  
C2952B     05  WS-EPAY-PYMT-TO-POST-DAYS    PIC S9(04) USAGE COMP.      
C2952B     05  WS-EPAY-PAYMENT-SOURCE-CD    PIC X(02).                  
COB305     05 WS-EPAY-ERROR-GL-OFFSET        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.
C2952B     05  WS-APS-CASH-LOCAL-OFFICE     PIC X(03).                  
C2952B     05  WS-APS-USER-ID               PIC X(07).                  
C2952B     05  WS-APS-BATCH-DEP-CASH-OFF    PIC X(03).                  
C2952B     05  WS-APS-DEP-XFER-METHOD       PIC X(01).                  
COB305     05 WS-APS-DEP-DEFT-BANK-ID        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
C2952B     05  WS-APS-LOCAL-OFFICE          PIC X(03).                  
COB305     05 WS-APS-DEP-CASH-GL-OFFSET        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.
C2952B     05  WS-APS-PAYMENT-AGENT-FL      PIC X(01).                  
C2952B     05  WS-APS-PYMT-TO-POST-DAYS     PIC S9(04) USAGE COMP.      
C2952B     05  WS-APS-PAYMENT-SOURCE-CD     PIC X(02).                  
COB305     05 WS-APS-ERROR-GL-OFFSET        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.
C2952B     05  WS-BM-CASH-LOCAL-OFFICE      PIC X(03).                  
C2952B     05  WS-BM-USER-ID                PIC X(07).                  
C2952B     05  WS-BM-BATCH-DEP-CASH-OFF     PIC X(03).                  
C2952B     05  WS-BM-DEP-XFER-METHOD        PIC X(01).                  
COB305     05 WS-BM-DEP-DEFT-BANK-ID        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
C2952B     05  WS-BM-LOCAL-OFFICE           PIC X(03).                  
COB305     05 WS-BM-DEP-CASH-GL-OFFSET        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.
C2952B     05  WS-BM-PAYMENT-AGENT-FL       PIC X(01).                  
C2952B     05  WS-BM-PYMT-TO-POST-DAYS      PIC S9(04) USAGE COMP.      
C2952B     05  WS-BM-PAYMENT-SOURCE-CD      PIC X(02).                  
COB305     05 WS-BM-ERROR-GL-OFFSET        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.
C31844     05  WS-APPL-PGM.                                             
C31844         10 WS-APPL-PGM-1        PIC X(03) VALUE SPACES.          
C31844         10 WS-APPL-PGM-2        PIC X(06) VALUE SPACES.          
                                                                        
                                                                        
       01  WS-HARDCODED-VARIABLES.                                      
           05  WS-AC22                          PIC X(04) VALUE 'AC22'. 
           05  WS-COMPANY                       PIC X(02) VALUE '01'.   
           05  WS-CSR                           PIC S9(9)V9(5)          
                                                          VALUE 1.00000.
           05  WS-SEB                           PIC S9(9)V9(5)          
                                                          VALUE 2.00000.
           05  WS-DATABASE                      PIC X(08) VALUE         
                                                          'DATABASE'.   
           05  WS-COMMENT-LEN                   PIC S9(04) COMP         
                                                VALUE +34.              
           05  WS-COMMENT-TEXT                  PIC X(34) VALUE         
                   'BATCH OVERAGE POSTED BY THE SYSTEM'.                
           05  WS-OV-SH-PRESENT                 PIC X(01) VALUE SPACES. 
           05  WS-CASHIER-USER-ID               PIC X(07) VALUE SPACES. 
           05  WS-CASHIER-CASH-OFFICE           PIC X(03) VALUE SPACES. 
           05  WS-BATCH-DEP-CASH-OFF            PIC X(03) VALUE SPACES. 
           05  WS-DEP-XFER-METHOD               PIC X(01) VALUE 'A'.    
                       88  AUTOMATIC-TRANSFER             VALUE 'A'.    
                       88  MANUAL-TRANSFER                VALUE 'M'.    
           05  WS-CASHIER-BANK-ID               PIC 9(05) VALUE 2.      
           05  WS-CASHIER-LOCAL-OFFICE          PIC X(03) VALUE SPACES. 
           05  WS-COMPANY-NAME                  PIC X(13) VALUE         
                                                       'SCE&G COMPANY'. 
           05  WS-PGRMNAME                      PIC X(08) VALUE         
                                                       'PCSCA362'.      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05  WS-Y                             PIC X(01) VALUE 'Y'.    
           05  WS-N                             PIC X(01) VALUE 'N'.    
           05  WS-J                             PIC X(01) VALUE 'J'.    
           05  WS-T                             PIC X(01) VALUE 'T'.    
           05  WS-D                             PIC X(01) VALUE 'D'.    
           05  WS-P                             PIC X(01) VALUE 'P'.    
           05  WS-LIT-A                         PIC X(01) VALUE 'A'.    
           05  WS-LIT-C                         PIC X(01) VALUE 'C'.    
           05  WS-LIT-D                         PIC X(01) VALUE 'D'.    
           05  WS-ZERO                          PIC 9(01) VALUE 0.      
           05  WS-LIT-ZERO                      PIC X(10) VALUE ZEROES. 
           05  WS-ONE                           PIC 9(01) VALUE 1.      
           05  WS-TWO                           PIC 9(01) VALUE 2.      
           05  WS-THREE                         PIC 9(01) VALUE 3.      
           05  WS-FOUR                          PIC 9(01) VALUE 4.      
           05  WS-FIVE                          PIC 9(01) VALUE 5.      
           05  WS-SIX                           PIC 9(01) VALUE 6.      
           05  WS-SEVEN                         PIC 9(01) VALUE 7.      
           05  WS-EIGHT                         PIC 9(01) VALUE 8.      
           05  WS-NINE                          PIC 9(01) VALUE 9.      
           05  WS-YES                           PIC X(01) VALUE 'Y'.    
           05  WS-NO                            PIC X(01) VALUE 'N'.    
           05  WS-28                            PIC 9(02) VALUE 28.     
           05  WS-1                             PIC X(01) VALUE '1'.    
           05  WS-2                             PIC X(01) VALUE '2'.    
           05  WS-009                           PIC X(03) VALUE '009'.  
           05  WS-025                           PIC X(03) VALUE '025'.  
           05  WS-029                           PIC X(03) VALUE '029'.  
           05  WS-017                           PIC X(03) VALUE '017'.  
           05  WS-019                           PIC X(03) VALUE '019'.  
           05  WS-024                           PIC X(03) VALUE '024'.  
           05  WS-006                           PIC X(03) VALUE '006'.  
           05  WS-004                           PIC X(03) VALUE '004'.  
           05  WS-018                           PIC X(03) VALUE '018'.  
           05  WS-022                           PIC X(03) VALUE '022'.  
           05  WS-027                           PIC X(03) VALUE '027'.  
           05  WS-028                           PIC X(03) VALUE '028'.  
           05  WS-036                           PIC X(03) VALUE '036'.  
           05  WS-039                           PIC X(03) VALUE '039'.  
           05  WS-101                           PIC 9(03) VALUE 101.    
           05  WS-19                            PIC 9(02) VALUE 19.     
           05  WS-20                            PIC 9(02) VALUE 20.     
           05  WS-44                            PIC X(02) VALUE '44'.   
           05  WS-22                            PIC X(02) VALUE '22'.   
           05  WS-M                             PIC X(01) VALUE 'M'.    
           05  WS-METER-NO                      PIC X(09) VALUE         
                                                         '000000000'.   
           05  WS-ALL9-ACNO                     PIC 9(13) VALUE         
                                                          9999999999999.
           05  WS-TRAN-ID                       PIC X(04) VALUE 'A362'. 
           05  MULTIPLE-ROWS-SELECTED           PIC S9(09)              
                                                    VALUE -811 COMP.    
           05 WS-PAYMENT-SOURCE-CD.                                     
              10 WS-PAYMENT-SOURCE-1            PIC X(01) VALUE 'B'.    
              10 WS-PAYMENT-SOURCE-2            PIC X(01) VALUE 'M'.    
                                                                        
C29529     05 WS-E-PAYMENT                      PIC X(09) VALUE         
C29529                                                    'CSR03413E'.  
C29529     05 WS-APS-PAYMENT                    PIC X(09) VALUE         
C29529                                                    'CSR03413F'.  
                                                                        
      ******************************************************************        
      *  REPORT STRUCTURES - FOR PIPELINE PAYMENTS                     *        
      *                    - FOR ERROR ACCOUNTS                        *        
      ******************************************************************        
       01  WS-RPT-HDR1.                                                 
           05  FILLER                           PIC X(1)  VALUE SPACES. 
           05  WS-RPT-ID                        PIC X(8).               
           05  FILLER                           PIC X(34) VALUE SPACES. 
           05  FILLER                           PIC X(39) VALUE         
                 'SCANA CORPORATION                      '.             
           05  FILLER                           PIC X(28) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-DATE :  '.     
           05  WS-RPT-DATE                      PIC 9(10).              
                                                                        
       01  WS-RPT-HDR2.                                                 
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-SYSTEM                    PIC X(36) VALUE SPACES. 
           05  FILLER                           PIC X(38) VALUE         
                           ' REAL TIME PAYMENT EXCEPTIONS '.            
           05  FILLER                           PIC X(35) VALUE SPACES. 
           05  FILLER                           PIC X(12) VALUE         
                                                    'RUN-TIME :  '.     
           05  WS-RPT-TIME                      PIC X(08).              
                                                                        
       01  WS-PAGE-HDR.                                                 
           05  FILLER                           PIC X(110) VALUE SPACES.
           05  FILLER                           PIC X(12) VALUE         
                                                    'PAGE-NO  :  '.     
           05  FILLER                           PIC X(04) VALUE SPACES. 
           05  WS-PAGE-NO                       PIC ZZZ9  VALUE '00'.   
           05  FILLER                           PIC X(05) VALUE SPACES. 
       01  WS-RPT-LINE.                                                 
           05  FILLER                           PIC X(132) VALUE ALL    
                                                    '='.                
                                                                        
       01  WS-RPT-HDR3.                                                 
           05  FILLER                           PIC X(6)  VALUE         
                                                ' TYPE '.               
           05  FILLER                           PIC X(13) VALUE         
                                                    'REPORT DATE  '.    
           05  FILLER                           PIC X(10) VALUE         
                                                    'COMPANY NO'.       
           05  FILLER                           PIC X(02) VALUE SPACES. 
           05  FILLER                           PIC X(14) VALUE         
                                                    'PAYMENT OFFICE'.   
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  FILLER                           PIC X(13) VALUE         
                                                    '   ACCOUNT NO'.    
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  FILLER                           PIC X(26) VALUE         
                                                    '  REJECT REASON  '.
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  FILLER                           PIC X(11) VALUE         
                                                    '  PHONE NO '.      
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  FILLER                           PIC X(11) VALUE         
                                                    ' ERROR GL  '.      
           05  FILLER                           PIC X(07) VALUE SPACES. 
           05  FILLER                           PIC X(06) VALUE         
                                                    'AMOUNT'.           
           05  FILLER                           PIC X(8)  VALUE SPACES. 
                                                                        
       01  WS-RPT-DTL.                                                  
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-TRANS-TYPE                pic x(01).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-CASH-RPT-DATE                 PIC X(10).              
           05  FILLER                           PIC X(07) VALUE SPACES. 
           05  WS-RPT-COMPANY-NO                PIC 9(02).              
           05  FILLER                           PIC X(09) VALUE SPACES. 
           05  WS-RPT-LOCAL-OFFICE              PIC 9(03).              
           05  FILLER                           PIC X(10) VALUE SPACES. 
           05  WS-RPT-ACCT-NO-DET               PIC 9(13).              
           05  FILLER                           PIC X(03) VALUE SPACES. 
           05  WS-RPT-REJ-REASON                PIC X(28).              
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-PHONE-NO                  PIC X(10) VALUE SPACES. 
           05  FILLER                           PIC X(05) VALUE SPACES. 
           05  WS-RPT-CREDIT-GL                 PIC 9(03).9(04).        
           05  FILLER                           PIC X(01) VALUE SPACES. 
           05  WS-RPT-AMOUNT                    PIC ---,---,--9.99.     
                                                                        
       01  WS-RPT-MESSAGE.                                              
           05  FILLER                           PIC X(25) VALUE SPACES. 
           05  WS-RPT-MSG                       PIC X(25).              
           05  FILLER                           PIC X(30) VALUE SPACES. 
           05  FILLER                           PIC X(15) VALUE         
                                                'TOTAL AMOUNT'.         
           05  FILLER                           PIC X(13) VALUE SPACES. 
           05  WS-RPT-TOTAL-AMOUNT              PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
                                                                        
       01  WS-GTOT-MESSAGE.                                             
           05  FILLER                           PIC X(75) VALUE SPACES. 
           05  FILLER                           PIC X(20) VALUE         
                                                'GRAND TOTAL AMOUNT  '. 
           05  FILLER                           PIC X(13) VALUE SPACES. 
           05  WS-GRAND-RPT-AMT                 PIC --,---,---,--9.99.  
           05  FILLER                           PIC X(10) VALUE SPACES. 
                                                                        
       01  WS-RPT-FTR.                                                  
           05 FILLER                            PIC X(7)  VALUE SPACES. 
           05 FILLER                            PIC X(15) VALUE         
                                                    'END OF REPORT'.    
           05 FILLER                            PIC X(110) VALUE SPACES.
      ******************************************************************        
      **   COPYBOOKS USED IN THE PROGRAM                              **        
      ******************************************************************        
                                                                        
      ****** DB2 COMMUNICATION REQUIREMENT ****************************         
      *01  LOC1            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
      *01  LOC2            USAGE IS SQL TYPE IS                         
      *                    RESULT-SET-LOCATOR VARYING.                  
       01  ERROR-MESSAGE.                                               
         02  ERROR-LEN   PIC S9(4)  COMP VALUE +1320.                   
         02  ERROR-TEXT  PIC X(132) OCCURS 10 TIMES                     
                                    INDEXED BY ERROR-INDEX.             
       77 ERROR-TEXT-LEN      PIC S9(9)  COMP VALUE +132.               
       77 TRACE-MESSAGE-AREA      PIC X(256).                           
       77 OPENFN                  PIC X(12).                            
       77 SSID                    PIC X(4).                             
       77 PLANNAME                PIC X(8).                             
       77 RETCODE                 PIC S9(5).                            
       77 REASCODE                PIC S9(5).                            
       77 CLOSFN                  PIC X(12).                            
       77 TERMOP                  PIC X(4).                             
                                                                        
       01    I-TIMESTAMP                    PIC X(26).                  
       01    I-ACCOUNT-NO                   PIC X(13).                  
       01    I-COMPANY-NO                   PIC X(02).                  
       01    I-CASH-LOC-OFFICE              PIC X(03).                  
       01    I-CUST-PHONE-NO                PIC X(10).                  
       01    I-CURRENCY-TYPE                PIC X(01).                  
       01    I-PAYMENT-AMOUNT               PIC x(11).                  
       01    I-REPORT-DATE                  PIC X(10).                  
       01    I-PYMT-FACILITY-CD             PIC X(01).                  
       01    I-DIR-PYMT-IND                 PIC X(03).                  
       01    I-CONFIRMATION-NO              PIC X(10).                  
       01    I-APPL-PGM-ID                  PIC X(09).                  
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                  PIC S9(9)   VALUE 0 COMP.   
          05 S-TIMESTAMP                    PIC X(26)   VALUE SPACES.   
          05 S-ACCOUNT-NO                   PIC X(13)   VALUE SPACES.   
          05 S-COMPANY-NO                   PIC X(04)   VALUE SPACES.   
          05 S-BILLED-BALANCE               PIC X(13)   VALUE SPACES.   
          05 S-CANCEL-DNP-FLAG              PIC X(01)   VALUE SPACES.   
          05 S-ERROR-CD                     pic x(01)   value spaces.   
          05 S-DNP-FLAG                     pic x(01)   value spaces.   
          05 S-AR-LOCKOUT-IND               PIC X(01)   VALUE SPACES.   
          05 S-ACCT-XFER-TO                 PIC X(13)   VALUE SPACES.   
                                                                        
       COPY CJF00101.                                                           
       COPY CWS00021.                                                           
       COPY CWS00038.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00303.                                                           
       COPY CWS09900.                                                           
       COPY CWS00104.                                                           
       COPY CWS00056.                                                           
                                                                        
           EXEC SQL                                                             
            INCLUDE CWS00315                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE SQLCA                                                       
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_ACCOUNT                                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBACCT                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_XREF_ACCOUNT                                           **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBXREF                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_AR_TRANS_HIST                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBARHIST                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_GL_ACCT-NO                                             **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBGLATNO                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_BANK                                                   **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBANK                                                      
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_BANK_TRANSFER                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBBNKXFR                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER                                                **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHIER                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CASHIER_OFFICE                                         **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCSHOFF                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_CNTL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE TBCDCNTL                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_CSH_DRWR_JRNL                                          **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBCDJRNL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_MODEL_SQL                                              **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBMODEL                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      **   CSS_JOB PARM                                               **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
            INCLUDE  TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DFA_ACCT                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CUSTOMER                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_REPORT_HDR                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSRPHD                                                 
           END-EXEC.                                                            
                                                                        
C28322******************************************************************        
C28322*    CSS_COMM_DATA                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCOMDAT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_HOLIDAY                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MKT_XREF_ACCT -XM                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PAYMENT_TRANS                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPMTRAN                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CODE_VALUE                                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * OH - CSS_OVERSHORT_HDR                                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHHD                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * OT - CSS_OVERSHORT_TYPE                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
             INCLUDE TBOVSHTY                                                   
           END-EXEC.                                                            
                                                                        
C29529*****************************************************************         
C29529*     DECGEN FOR CSS_PNDNG_BNK_DRFT                             *         
C29529*****************************************************************         
C29529     EXEC SQL                                                             
C29529       INCLUDE TBPDBKDF                                                   
C29529     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT CSS_PAYMENT_TRANS                          *        
      ******************************************************************        
           EXEC SQL                                                     
PTS55       DECLARE PYMT_CURSOR CURSOR WITH HOLD FOR                    
             SELECT DATE_CASH_REPORT                                    
                   ,CASH_LOCAL_OFFICE                                   
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
                   ,ACCOUNT_NO                                          
                   ,APPL_PROGRAM_ID                                     
                   ,APPLIED_FL                                          
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), APPLIED_TS, 121), 
           ' ', '-'), ':', '.') APPLIED_TS                                     
                   ,COMPANY_NO                                          
                   ,CREDIT_CARD_TYPE                                    
                   ,CURRENCY_TYPE                                       
                   ,CUST_PHONE_NO                                       
                   ,DIRECTED_PYMT_CD                                    
                   ,ERROR_CD                                            
                   ,PAYMENT_AMT                                         
                   ,PYMT_CONFIRM_NO                                     
                   ,PYMT_FACILITY_CD                                    
                   ,LAST_UPDATE_USERID                                  
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), ORIG_PYMT_TS
           , 121), ' ', '-'), ':', '.') ORIG_PYMT_TS                           
                   ,TRANS_TYPE_CD                                       
              FROM CSS_PAYMENT_TRANS                                    
C33928       WHERE APPLIED_FL IN ('N', '')                              
               AND TRANS_TYPE_CD = 'P'                                  
C35842         AND PYMT_RCVD_TS < DATEADD( MINUTE, -5, 
           CIS.CURRENT$TIMESTAMP() )          
P00420*        FOR UPDATE OF APPLIED_FL,APPLIED_TS,LAST_UPDATE_USERID           
P00420*           ,ERROR_CD                                                     
P00552                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE PYMT_CURSOR CURSOR WITH HOLD FOR                            
MFA-TR*      SELECT DATE_CASH_REPORT                                            
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,PYMT_RCVD_TS                                                
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,APPL_PROGRAM_ID                                             
MFA-TR*            ,APPLIED_FL                                                  
MFA-TR*            ,APPLIED_TS                                                  
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CREDIT_CARD_TYPE                                            
MFA-TR*            ,CURRENCY_TYPE                                               
MFA-TR*            ,CUST_PHONE_NO                                               
MFA-TR*            ,DIRECTED_PYMT_CD                                            
MFA-TR*            ,ERROR_CD                                                    
MFA-TR*            ,PAYMENT_AMT                                                 
MFA-TR*            ,PYMT_CONFIRM_NO                                             
MFA-TR*            ,PYMT_FACILITY_CD                                            
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,TRANS_HIST_SEQ_NO                                           
MFA-TR*            ,ORIG_PYMT_TS                                                
MFA-TR*            ,TRANS_TYPE_CD                                               
MFA-TR*       FROM CSS_PAYMENT_TRANS                                            
MFA-TR*      WHERE APPLIED_FL IN ('N', '')                                      
MFA-TR*        AND TRANS_TYPE_CD = 'P'                                          
MFA-TR*        AND PYMT_RCVD_TS < CURRENT TIMESTAMP - 5 MINUTE                  
MFA-TR*        FOR UPDATE OF APPLIED_FL,APPLIED_TS,LAST_UPDATE_USERID           
MFA-TR*           ,ERROR_CD                                                     
MFA-TR*    QUERYNO 7961                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT CSS_PAYMENT_TRANS                          *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE RVSL_CURSOR CURSOR FOR                              
             SELECT DATE_CASH_REPORT                                    
                   ,CASH_LOCAL_OFFICE                                   
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
                   ,ACCOUNT_NO                                          
                   ,APPL_PROGRAM_ID                                     
                   ,APPLIED_FL                                          
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), APPLIED_TS, 121), 
           ' ', '-'), ':', '.') APPLIED_TS                                     
                   ,COMPANY_NO                                          
                   ,CREDIT_CARD_TYPE                                    
                   ,CURRENCY_TYPE                                       
                   ,CUST_PHONE_NO                                       
                   ,DIRECTED_PYMT_CD                                    
                   ,ERROR_CD                                            
                   ,PAYMENT_AMT                                         
                   ,PYMT_CONFIRM_NO                                     
                   ,PYMT_FACILITY_CD                                    
                   ,LAST_UPDATE_USERID                                  
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), ORIG_PYMT_TS
           , 121), ' ', '-'), ':', '.') ORIG_PYMT_TS                           
                   ,TRANS_TYPE_CD                                       
              FROM CSS_PAYMENT_TRANS                                    
C33928       WHERE APPLIED_FL IN ('N', '')                              
               AND TRANS_TYPE_CD = 'R'                                  
C35842         AND PYMT_RCVD_TS < DATEADD( MINUTE, -5, 
           CIS.CURRENT$TIMESTAMP() )          
P00420*        FOR UPDATE OF APPLIED_FL,APPLIED_TS,LAST_UPDATE_USERID           
P00420*           ,ERROR_CD                                                     
P00552                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RVSL_CURSOR CURSOR FOR                                      
MFA-TR*      SELECT DATE_CASH_REPORT                                            
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,PYMT_RCVD_TS                                                
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,APPL_PROGRAM_ID                                             
MFA-TR*            ,APPLIED_FL                                                  
MFA-TR*            ,APPLIED_TS                                                  
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CREDIT_CARD_TYPE                                            
MFA-TR*            ,CURRENCY_TYPE                                               
MFA-TR*            ,CUST_PHONE_NO                                               
MFA-TR*            ,DIRECTED_PYMT_CD                                            
MFA-TR*            ,ERROR_CD                                                    
MFA-TR*            ,PAYMENT_AMT                                                 
MFA-TR*            ,PYMT_CONFIRM_NO                                             
MFA-TR*            ,PYMT_FACILITY_CD                                            
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,TRANS_HIST_SEQ_NO                                           
MFA-TR*            ,ORIG_PYMT_TS                                                
MFA-TR*            ,TRANS_TYPE_CD                                               
MFA-TR*       FROM CSS_PAYMENT_TRANS                                            
MFA-TR*      WHERE APPLIED_FL IN ('N', '')                                      
MFA-TR*        AND TRANS_TYPE_CD = 'R'                                          
MFA-TR*        AND PYMT_RCVD_TS < CURRENT TIMESTAMP - 5 MINUTE                  
MFA-TR*        FOR UPDATE OF APPLIED_FL,APPLIED_TS,LAST_UPDATE_USERID           
MFA-TR*           ,ERROR_CD                                                     
MFA-TR*    QUERYNO 7971                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
C34416******************************************************************        
C34416*    CURSOR TO SELECT APS REVERSALS WITH CREDIT ACTION           *        
C34416******************************************************************        
C34416     EXEC SQL                                                     
C34416      DECLARE APSRVSL_CURSOR CURSOR FOR                           
C34416       SELECT DATE_CASH_REPORT                                    
C34416             ,CASH_LOCAL_OFFICE                                   
C34416             ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_RCVD_TS
           , 121), ' ', '-'), ':', '.') PYMT_RCVD_TS                           
C34416             ,ACCOUNT_NO                                          
C34416             ,COMPANY_NO                                          
C34416             ,ERROR_CD                                            
C34416             ,PAYMENT_AMT                                         
C34416             ,PYMT_CONFIRM_NO                                     
C34416             ,TRANS_TYPE_CD                                       
C34416        FROM CSS_PAYMENT_TRANS                                    
C34416       WHERE DATE_CASH_REPORT > DATEADD( DAY, -4, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )             
C34416         AND CASH_LOCAL_OFFICE IN ('028','029')                   
C34416         AND APPLIED_FL    = 'Y'                                  
C34416         AND ERROR_CD      = 'Z'                                  
C34416         AND TRANS_TYPE_CD = 'R'                                  
C34416         FOR UPDATE OF ERROR_CD,LAST_UPDATE_USERID                
P00552                                                      
C34416     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE APSRVSL_CURSOR CURSOR FOR                                   
MFA-TR*      SELECT DATE_CASH_REPORT                                            
MFA-TR*            ,CASH_LOCAL_OFFICE                                           
MFA-TR*            ,PYMT_RCVD_TS                                                
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,ERROR_CD                                                    
MFA-TR*            ,PAYMENT_AMT                                                 
MFA-TR*            ,PYMT_CONFIRM_NO                                             
MFA-TR*            ,TRANS_TYPE_CD                                               
MFA-TR*       FROM CSS_PAYMENT_TRANS                                            
MFA-TR*      WHERE DATE_CASH_REPORT > CURRENT DATE - 4 DAYS                     
MFA-TR*        AND CASH_LOCAL_OFFICE IN ('028','029')                           
MFA-TR*        AND APPLIED_FL    = 'Y'                                          
MFA-TR*        AND ERROR_CD      = 'Z'                                          
MFA-TR*        AND TRANS_TYPE_CD = 'R'                                          
MFA-TR*        FOR UPDATE OF ERROR_CD,LAST_UPDATE_USERID                        
MFA-TR*    QUERYNO 7981                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR TO SELECT DFA ACCOUNT                                *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE DFA_CURSOR CURSOR FOR                               
             SELECT CODE_DFA_TYPE                                       
               FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :DA-ACCOUNT-NO                         
P00552                                                      
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE DFA_CURSOR CURSOR FOR                                       
MFA-TR*      SELECT CODE_DFA_TYPE                                               
MFA-TR*        FROM CSS_DFA_ACCT                                                
MFA-TR*       WHERE ACCOUNT_NO = :DA-ACCOUNT-NO                                 
MFA-TR*     QUERYNO 7210                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                DECLARE OVSHTYPE_CURSOR CURSOR FOR                      
                 SELECT OVERSHORT_TYPE_CD                               
                   FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                
C25923            WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                     
P00552                                                      
C33928                                                           
C25923     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE OVSHTYPE_CURSOR CURSOR FOR                              
MFA-TR*          SELECT OVERSHORT_TYPE_CD                                       
MFA-TR*            FROM CSS_OVERSHORT_TYPE                                      
MFA-TR*           WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                             
MFA-TR*         QUERYNO 7964                                                    
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE C1 CURSOR
MSQ001          FOR CALL CSR03413                                       
                       ( :I-TIMESTAMP
                  , :I-ACCOUNT-NO
                  , :I-COMPANY-NO
                  , :I-CASH-LOC-OFFICE
                  , :I-CUST-PHONE-NO
                  , :I-CURRENCY-TYPE
                  , :I-PAYMENT-AMOUNT
                  , :I-REPORT-DATE
                  , :I-PYMT-FACILITY-CD
                  , :I-DIR-PYMT-IND
                  , :I-CONFIRMATION-NO
                  , :I-APPL-PGM-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR03488                                       
APSAPS                 ( :I-TIMESTAMP
                  , :I-ACCOUNT-NO
                  , :I-COMPANY-NO
                  , :I-CASH-LOC-OFFICE
                  , :I-CURRENCY-TYPE
                  , :I-PAYMENT-AMOUNT
                  , :I-REPORT-DATE
                  , :I-PYMT-FACILITY-CD
                  , :I-DIR-PYMT-IND
                  , :I-CONFIRMATION-NO
                  , 'PCSC362R'
                  , 'SYSTEM'
                  , 'REVERSING FROM PCSCA362'
                  )
MSQ001        END-EXEC.
                                                    
      ******************************************************************        
      *    'WORKING STORAGE FOR PCSCA362 ENDS HERE '.                  *        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      **                         M A I N L I N E                      **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
                                                                        
           PERFORM 7961-OPEN-PMT-TRAN                                   
              THRU 7961-EXIT.                                           
                                                                        
           PERFORM 7962-FETCH-PMT-TRAN                                  
              THRU 7962-EXIT.                                           
                                                                        
           PERFORM 1000-PROCESS                                         
              THRU 1000-EXIT                                            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
           PERFORM 7963-CLOSE-PMT-TRAN                                  
              THRU 7963-EXIT.                                           
                                                                        
APSAPS     PERFORM 7971-OPEN-RVR-TRAN                                   
APSAPS        THRU 7971-EXIT.                                           
APSAPS                                                                  
APSAPS     PERFORM 7972-FETCH-RVR-TRAN                                  
APSAPS        THRU 7972-EXIT.                                           
APSAPS                                                                  
APSAPS     PERFORM 1001-PROCESS-REVERSAL                                
APSAPS        THRU 1001-EXIT                                            
APSAPS             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
APSAPS                                                                  
APSAPS     PERFORM 7973-CLOSE-RVR-TRAN                                  
APSAPS        THRU 7973-EXIT.                                           
APSAPS                                                                  
                                                                        
C34416     PERFORM 7981-OPEN-APSRVR-TRAN                                
C34416        THRU 7981-EXIT.                                           
C34416                                                                  
C34416     PERFORM 7982-FETCH-APSRVR-TRAN                               
C34416        THRU 7982-EXIT.                                           
C34416                                                                  
C34416     PERFORM 1002-PROCESS-APSREVERSAL                             
C34416        THRU 1002-EXIT                                            
C34416             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C34416                                                                  
C34416     PERFORM 7983-CLOSE-APSRVR-TRAN                               
C34416        THRU 7983-EXIT.                                           
                                                                        
           IF WS-BATCH-TOTAL-COUNT > 0                                  
C30257        CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PGRMNAME       TO WS-RPT-ID                       
              PERFORM 2965-PRINT-REPORT-HEADER                          
                 THRU 2965-EXIT                                         
              MOVE 'NO DATA FOUND'   TO PRT33-DATA                      
              MOVE 02  TO  RETURN-CODE                                  
              WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE          
           END-IF.                                                      
                                                                        
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0100-INITIALIZATION                                         **        
      **  COMMON INITIALIZATION ROUTINE                               **        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 0200-OPEN-FILES                                      
              THRU 0200-EXIT.                                           
           PERFORM 0300-SETUP-DATES                                     
              THRU 0300-EXIT.                                           
           PERFORM 0400-SETUP-GL-ACCTS                                  
              THRU 0400-EXIT.                                           
           MOVE WS-COMPANY               TO C8-COMPANY-NO               
                                            Y2-CASH-COMPANY-NO          
           MOVE WS-DATABASE              TO C8-DELINQ-CD                
           PERFORM 7800-SELECT-DATABASE  THRU 7800-EXIT.                
           IF C8-DELINQ-VALUE = WS-SEB                                  
              MOVE 'SEB'                 TO WS-RPT-SYSTEM               
C2952B        MOVE '022'                 TO Y2-CASH-LOCAL-OFFICE        
           ELSE                                                         
              MOVE 'CSR'                 TO WS-RPT-SYSTEM               
C2952B        MOVE '025'                 TO Y2-CASH-LOCAL-OFFICE        
           END-IF.                                                      
                                                                        
           PERFORM 7700-GET-CURRENT-TIMESTAMP   THRU 7700-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0200-OPEN-FILES                                             **        
      **                                                              **        
      ******************************************************************        
       0200-OPEN-FILES.                                                 
                                                                        
           MOVE '0200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0300-SETUP-DATES                                            **        
      **                                                              **        
      ******************************************************************        
       0300-SETUP-DATES.                                                
                                                                        
           MOVE '0300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 6251-GET-FJC01-DATE                                  
              THRU 6251-EXIT.                                           
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  '            TO WS-PGRMNAME                 
              MOVE SPACES                TO WS-INPUT-AREA               
              MOVE SPACES                TO WS-INPUT-DATA-BREAKDOWN     
              PERFORM 6251-GET-FJC01-DATE                               
                 THRU 6251-EXIT                                         
              MOVE 'PCSCA362'            TO WS-PGRMNAME                 
           END-IF.                                                      
      *    FORMATING DATE FOR REPORT HEADER.                                    
                                                                        
            ACCEPT WS-RUN-DATE               FROM DATE.                 
            IF WS-DT-YY    >   50                                       
               MOVE  WS-19               TO WS-CUR-CC                   
            ELSE                                                        
               MOVE  WS-20               TO WS-CUR-CC                   
            END-IF.                                                     
                                                                        
                                                                        
            MOVE WS-DT-MM                TO WS-REP-MM.                  
            MOVE WS-DT-YY                TO WS-CUR-YY.                  
T22767*     MOVE WS-CUR-CCYY             TO WS-REP-YY.                          
T22767      MOVE WS-CUR-YY               TO WS-REP-YY.                  
            MOVE WS-DT-DD                TO WS-REP-DD.                  
                                                                        
            MOVE WS-REPORT-DATE          TO WS-RPT-DATE.                
                                                                        
T22767*    FORMATING TIME FOR REPORT HEADER.                                    
T22767                                                                  
T22767     ACCEPT WS-RUN-TIME               FROM TIME.                  
T22767                                                                  
T22767     MOVE WS-HH                  TO WS-RT-HH.                     
T22767     MOVE WS-MM                  TO WS-RT-MM.                     
T22767     MOVE WS-SS                  TO WS-RT-SS.                     
T22767     MOVE WS-REPORT-TIME         TO WS-RPT-TIME.                  
                                                                        
       0300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  0400-SETUP-GL-ACCTS                                         **        
      **                                                              **        
      ******************************************************************        
       0400-SETUP-GL-ACCTS.                                             
                                                                        
           MOVE '0400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-LIT-ZERO              TO CJ-CUSTOMER-NO.             
           MOVE WS-COMPANY               TO GO-COMPANY-NO.              
           MOVE 'CLR-CASH'               TO GO-GL-ACCT-NAME.            
                                                                        
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-CASH-GL-ACCT.            
                                                                        
           MOVE 'CLR-PST-ER'             TO GO-GL-ACCT-NAME.            
           PERFORM 7900-SELECT-GL-ACCT-NO                               
              THRU 7900-EXIT.                                           
           MOVE  GO-GL-ACCT-NO           TO WS-BNKXFR-GL-ACCT.          
                                                                        
       0400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 0500-SETUP-JOURNAL-CNTL.                                    **         
      **                                                             **         
      *****************************************************************         
       0500-SETUP-JOURNAL-CNTL.                                         
                                                                        
           MOVE '0500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE WS-LIT-A                 TO CS-CODE-CSH-DRWR-STAT.      
           MOVE JT-DATE-CASH-REPORT      TO CS-DATE-CASH-REPORT         
           MOVE 500                      TO CS-CASH-DRAWER-ID           
                                                                        
C31844* CHECK WHETHER CASH LOCAL OFFICE IS VALID, IF NOT, USE THE               
C31844* CORRECT CASH LOCAL OFFICE                                               
C31844     MOVE SPACES                       TO WS-APPL-PGM             
C31844     IF JT-APPL-PROGRAM-ID = 'CSR03413'                           
C31844        MOVE JT-APPL-PROGRAM-ID        TO UV-PROGRAM-ID           
C31844     ELSE                                                         
C31844        MOVE JT-APPL-PROGRAM-ID        TO WS-APPL-PGM             
C31844        MOVE WS-APPL-PGM-2             TO UV-PROGRAM-ID           
C31844     END-IF                                                       
C31844     MOVE '01'                         TO UV-COMPANY-NO           
C31844     MOVE 'CSS_PAYMENT_TRANS'          TO UV-TABLE-NA-TEXT        
C31844     MOVE 17                           TO UV-TABLE-NA-LEN         
C31844     MOVE 'CASH_LOCAL_OFFICE'          TO UV-COLUMN-NA-TEXT       
C31844     MOVE 17                           TO UV-COLUMN-NA-LEN        
C31844     PERFORM 7250-SELECT-CODE-VAL      THRU 7250-EXIT             
C31844     IF UV-CODE-VALUE-TEXT(1:3) NOT = I-CASH-LOC-OFFICE           
C31844        MOVE UV-CODE-VALUE-TEXT        TO Y2-CASH-LOCAL-OFFICE    
C31844        MOVE WS-COMPANY                TO Y2-CASH-COMPANY-NO      
C2952B        PERFORM 7510-SELECT-CSH-OFF    THRU 7510-EXIT             
C31844     ELSE                                                         
C31844        MOVE I-CASH-LOC-OFFICE         TO Y2-CASH-LOCAL-OFFICE    
C31844        MOVE WS-COMPANY                TO Y2-CASH-COMPANY-NO      
C31844        PERFORM 7510-SELECT-CSH-OFF    THRU 7510-EXIT             
C31844     END-IF                                                       
C31844     PERFORM 7560-SELECT-BANK-ST-CD       THRU 7560-EXIT.         
           MOVE Y2-CASH-LOCAL-OFFICE     TO CS-CASH-LOCAL-OFFICE.       
                                                                        
           PERFORM 7300-SELECT-CASH-DRWR-CNTL                           
              THRU 7300-EXIT.                                           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                                                                        
             PERFORM 7310-SELECT-MAX-CSH-CNTL                           
                THRU 7310-EXIT                                          
                                                                        
             PERFORM 2120-SET-CASH-DRWR-CNTL-VALUES                     
                THRU 2120-EXIT                                          
                                                                        
             PERFORM 8200-CREATE-CASH-DRWR-CNTL                         
                THRU 8200-EXIT                                          
                                                                        
           END-IF.                                                      
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 1000-PROCESS                                                **         
      **                                                             **         
      *****************************************************************         
       1000-PROCESS.                                                    
                                                                        
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT        
           MOVE JT-ACCOUNT-NO            TO AT-ACCOUNT-NO               
           MOVE SPACES                   TO WS-ACCT-EXIST               
           SET  REGULAR-ACCT             TO TRUE                        
           PERFORM 7100-SELECT-CIS-ACCOUNT                              
              THRU    7100-EXIT.                                        
           PERFORM 1700-PROCESS-COBB                                    
              THRU    1700-EXIT.                                        
                                                                        
C31844* BELOW LINE ARE COMMENTED                                                
                                                                        
      *                     E-CUSTOMER PROCESSING                               
      *   IF THIS IS AN E-PAYMENT, SEE IF THERE IS A MATCHING ROW IN            
      * CSS_PNNDNG_BNK_DRFT.  IF THERE IS, MOVE THE CSS_CASHIER_OFFICE          
      * INFO FOR E-PAY INTO THE HOST VARIABLES (STORED OFF IN PARA 7520)        
      * AND THEN BEGIN TO PROCESS THE PAYMENT.  IF THERE IS NOT, IT WAS         
      * ALREADY PROCESSED. JUST WRITE IT TO THE ERROR REPORT WITHOUT ANY        
      * JOURNALLING.                                                            
      *   IF THIS ISN'T AN E-PAYMENT(I.E. BILL MATRIX), PROCESS THE             
      * PAYMENT (HOST VARIABLES ALREADY LOADED WITH BILL MATRIX INFO)           
      *                                                                         
C31844     PERFORM 1010-PAYMENT-PROCESSING   THRU 1010-EXIT             
                                                                        
C30257     PERFORM 8700-SET-APPLIED-FLAG                                
C30257        THRU 8700-EXIT                                            
                                                                        
           PERFORM 7962-FETCH-PMT-TRAN                                  
              THRU 7962-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
APSAPS*****************************************************************         
APSAPS** 1001-PROCESS-REVERSAL                                       **         
APSAPS**                                                             **         
APSAPS*****************************************************************         
APSAPS 1001-PROCESS-REVERSAL.                                           
APSAPS                                                                  
APSAPS     MOVE '1001'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT        
APSAPS     MOVE JT-ACCOUNT-NO            TO AT-ACCOUNT-NO               
APSAPS     MOVE SPACES                   TO WS-ACCT-EXIST               
APSAPS     SET  REGULAR-ACCT             TO TRUE                        
APSAPS     PERFORM 7100-SELECT-CIS-ACCOUNT                              
APSAPS        THRU    7100-EXIT.                                        
APSAPS     PERFORM 1700-PROCESS-COBB                                    
APSAPS        THRU    1700-EXIT.                                        
APSAPS     PERFORM 1011-REVERSAL-PROCESSING   THRU 1011-EXIT            
APSAPS                                                                  
APSAPS     PERFORM 8710-SET-APPLIED-FLAG-RVR                            
APSAPS        THRU 8710-EXIT                                            
APSAPS                                                                  
APSAPS     PERFORM 7972-FETCH-RVR-TRAN                                  
APSAPS        THRU 7972-EXIT.                                           
APSAPS                                                                  
       1001-EXIT.                                                       
           EXIT.                                                        
                                                                        
C34416*****************************************************************         
C34416** 1002-PROCESS-apsreversal                                    **         
C34416**                                                             **         
C34416*****************************************************************         
C34416 1002-PROCESS-APSREVERSAL.                                        
C34416                                                                  
C34416     MOVE '1002'                   TO WS-ACTIVE-PARAGRAPH         
C34416                                                                  
C34416     ADD WS-ONE                    TO WS-BATCH-TOTAL-COUNT        
C34416     MOVE ZEROES                   TO Y2-ERROR-GL-OFFSET          
C34416                                                                  
C34416     PERFORM 2960-PRINT-REPORT-DETAIL                             
C34416        THRU 2960-EXIT                                            
C34416                                                                  
A00575     MOVE SPACES TO JT-ERROR-CD                                   
C34416     PERFORM 8720-UPDATE-ERROR-CD                                 
C34416        THRU 8720-EXIT                                            
C34416                                                                  
C34416     PERFORM 7982-FETCH-APSRVR-TRAN                               
C34416        THRU 7982-EXIT                                            
C34416     .                                                            
C34416 1002-EXIT.                                                       
C34416     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1010-PAYMENT-PROCESSING.                                    **        
      **                                                              **        
      ******************************************************************        
       1010-PAYMENT-PROCESSING.                                         
                                                                        
           MOVE '1010'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-ACCT-EXIST = 'Y'                                       
A00575        AND (JT-ERROR-CD(1:1) <= ' ' OR JT-ERROR-CD(1:1) = 'P')   
                                                                        
              MOVE JT-PYMT-RCVD-TS     TO  I-TIMESTAMP                  
              MOVE JT-ACCOUNT-NO       TO  I-ACCOUNT-NO                 
              MOVE JT-COMPANY-NO       TO  I-COMPANY-NO                 
              MOVE JT-CASH-LOCAL-OFFICE TO  I-CASH-LOC-OFFICE           
              MOVE JT-CUST-PHONE-NO    TO  I-CUST-PHONE-NO              
              MOVE JT-CURRENCY-TYPE    TO  I-CURRENCY-TYPE              
              MOVE JT-PAYMENT-AMT      TO  WS-PYMT-AMT-NUM              
              MOVE WS-PYMT-AMT         TO  I-PAYMENT-AMOUNT             
              MOVE JT-DATE-CASH-REPORT TO  I-REPORT-DATE                
              MOVE JT-PYMT-FACILITY-CD TO  I-PYMT-FACILITY-CD           
              MOVE JT-DIRECTED-PYMT-CD TO  I-DIR-PYMT-IND               
              MOVE JT-PYMT-CONFIRM-NO  TO  I-CONFIRMATION-NO            
              MOVE WS-PGRMNAME         TO  I-APPL-PGM-ID                
              SET  WS-VALID-ACCOUNT    TO TRUE                          
              PERFORM 1300-CALL-PAYMENT-SP                              
                 THRU 1300-EXIT                                         
           ELSE                                                         
              SET WS-NOT-VALID-ACCOUNT TO TRUE                          
A00575        IF JT-ERROR-CD(1:1) = SPACES                              
A00575           MOVE 'A'                 TO JT-ERROR-CD(1:1)           
                 PERFORM 8720-UPDATE-ERROR-CD                           
                                          THRU 8720-EXIT                
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-NOT-VALID-ACCOUNT OR WS-ACCT-NOT-PROC                  
              PERFORM 0500-SETUP-JOURNAL-CNTL THRU 0500-EXIT            
      ** INCREMENT RECORD COUNT & AMOUNT                       **               
              ADD JT-PAYMENT-AMT TO WS-BATCH-TOTAL-AMOUNT               
                                                                        
      ** FINDS IF THE DETAIL REC IS OF CIS A/C                 **               
              MOVE JT-ACCOUNT-NO            TO AT-ACCOUNT-NO            
                                               XR-OLD-ACCOUNT-NO        
              MOVE JT-PAYMENT-AMT           TO WS-AMT-9                 
                                                                        
              PERFORM 1100-PROCESS-DETAILS THRU 1100-EXIT               
                                                                        
              PERFORM 2960-PRINT-REPORT-DETAIL                          
                 THRU 2960-EXIT                                         
           END-IF.                                                      
       1010-EXIT.                                                       
           EXIT.                                                        
APSAPS                                                                  
APSAPS******************************************************************        
APSAPS**  1011-REVERSAL-PROCESSING                                    **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 1011-REVERSAL-PROCESSING.                                        
APSAPS                                                                  
APSAPS     MOVE '1011'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS     MOVE JT-ACCOUNT-NO            TO AR-ACCOUNT-NO               
APSAPS     MOVE 'N'                      TO  WS-PAYMENT-PRESENT         
APSAPS     IF WS-NULL-INDICATOR4 >= 0                                   
APSAPS        PERFORM 7974-FIND-PAYMENT     THRU 7974-EXIT              
APSAPS     END-IF                                                       
APSAPS     IF WS-PAYMENT-PRESENT = 'Y'                                  
APSAPS                                                                  
APSAPS        MOVE JT-ORIG-PYMT-TS       TO  I-TIMESTAMP                
APSAPS        MOVE JT-ACCOUNT-NO         TO  I-ACCOUNT-NO               
APSAPS        MOVE JT-COMPANY-NO         TO  I-COMPANY-NO               
APSAPS        MOVE JT-CASH-LOCAL-OFFICE  TO  I-CASH-LOC-OFFICE          
APSAPS        MOVE JT-CUST-PHONE-NO      TO  I-CUST-PHONE-NO            
APSAPS        MOVE JT-CURRENCY-TYPE      TO  I-CURRENCY-TYPE            
APSAPS        MOVE JT-PAYMENT-AMT        TO  WS-PYMT-AMT-NUM            
APSAPS        MOVE WS-PYMT-AMT           TO  I-PAYMENT-AMOUNT           
APSAPS        MOVE JT-DATE-CASH-REPORT   TO  I-REPORT-DATE              
APSAPS        MOVE JT-PYMT-FACILITY-CD   TO  I-PYMT-FACILITY-CD         
APSAPS        MOVE JT-DIRECTED-PYMT-CD   TO  I-DIR-PYMT-IND             
APSAPS        MOVE JT-PYMT-CONFIRM-NO    TO  I-CONFIRMATION-NO          
APSAPS        MOVE WS-PGRMNAME           TO  I-APPL-PGM-ID              
APSAPS        SET  WS-VALID-ACCOUNT      TO TRUE                        
APSAPS        PERFORM 1301-CALL-REVERSAL-SP                             
APSAPS           THRU 1301-EXIT                                         
APSAPS     ELSE                                                         
APSAPS        SET WS-NOT-VALID-ACCOUNT TO TRUE                          
A00575        IF JT-ERROR-CD(1:1) = SPACES                              
APSAPS           IF COBB-XFERED-ACCT                                    
A00575              MOVE 'N'                 TO JT-ERROR-CD(1:1)        
APSAPS           ELSE                                                   
A00575              MOVE 'R'                 TO JT-ERROR-CD(1:1)        
APSAPS              PERFORM 8720-UPDATE-ERROR-CD                        
APSAPS                                       THRU 8720-EXIT             
APSAPS           END-IF                                                 
APSAPS        END-IF                                                    
APSAPS     END-IF                                                       
APSAPS                                                                  
APSAPS     IF (WS-NOT-VALID-ACCOUNT OR WS-ACCT-NOT-PROC)                
APSAPS        PERFORM 0500-SETUP-JOURNAL-CNTL THRU 0500-EXIT            
APSAPS** INCREMENT RECORD COUNT & AMOUNT                       **               
APSAPS        SUBTRACT JT-PAYMENT-AMT FROM WS-BATCH-TOTAL-AMOUNT        
APSAPS                                                                  
APSAPS** FINDS IF THE DETAIL REC IS OF CIS A/C                 **               
APSAPS        MOVE JT-ACCOUNT-NO            TO AT-ACCOUNT-NO            
APSAPS                                         XR-OLD-ACCOUNT-NO        
APSAPS        MOVE JT-PAYMENT-AMT           TO WS-AMT-9                 
APSAPS                                                                  
APSAPS        PERFORM 1101-PROCESS-REV-DETAILS THRU 1101-EXIT           
APSAPS                                                                  
APSAPS        PERFORM 2960-PRINT-REPORT-DETAIL                          
APSAPS           THRU 2960-EXIT                                         
APSAPS     END-IF.                                                      
APSAPS                                                                  
APSAPS 1011-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
                                                                        
      ******************************************************************        
      **  1100-PROCESS-DETAILS.                                       **        
      **                                                              **        
      ******************************************************************        
       1100-PROCESS-DETAILS.                                            
                                                                        
           PERFORM 1200-JOURNAL                                         
              THRU 1200-EXIT.                                           
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
APSAPS******************************************************************        
APSAPS**  1101-PROCESS-REV-DETAILS.                                   **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 1101-PROCESS-REV-DETAILS.                                        
APSAPS                                                                  
APSAPS     PERFORM 1201-JOURNAL-REVERSAL                                
APSAPS        THRU 1201-EXIT.                                           
APSAPS*                                                                         
APSAPS 1101-EXIT.                                                       
APSAPS     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1200-JOURNAL.                                               **        
      **                                                              **        
      ******************************************************************        
       1200-JOURNAL.                                                    
                                                                        
           MOVE '1200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
      * POPULATES JOURNAL RECORD                                                
                                                                        
           PERFORM 2150-SET-CASH-DRWR-JRNL-VALUES                       
              THRU 2150-EXIT.                                           
                                                                        
      * POPULATES TRAN-DATA VALUES - COPYBOOK CJF00101                          
                                                                        
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
                                                                        
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-DR.     
           MOVE Y2-ERROR-GL-OFFSET       TO WS-101-ACCT-GEN-LED-CR      
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
           MOVE 2                        TO CJ-TRAN-APPL-NO.            
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
                                                                        
           ADD WS-ONE                       TO CS-NO-ITEMS-ENTERED      
           ADD JT-PAYMENT-AMT               TO CS-AMT-CASH-DEBIT,       
                                               CS-AMT-CASH-CREDIT       
           MOVE WS-CASHIER-USER-ID          TO CS-USER-ID               
           MOVE Y1-CASHIER-CODE             TO CS-CASHIER-CODE          
           MOVE WS-INPUT-DATE               TO CS-DATE-LAST-ACTIVITY    
           PERFORM 8600-UPDATE-CASH-DRWR-CNTL                           
              THRU 8600-EXIT.                                           
              PERFORM 1600-INSERT-OVSH THRU 1600-EXIT                   
C31844     .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1201-JOURNAL-REVERSAL.                                      **        
      **                                                              **        
      ******************************************************************        
       1201-JOURNAL-REVERSAL.                                           
                                                                        
           MOVE '1200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
      * POPULATES JOURNAL RECORD                                                
           MOVE WS-CASHIER-USER-ID          TO CS-USER-ID               
                                                                        
           PERFORM 2150-SET-CASH-DRWR-JRNL-VALUES                       
              THRU 2150-EXIT.                                           
                                                                        
      * POPULATES TRAN-DATA VALUES - COPYBOOK CJF00101                          
                                                                        
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE Y2-DEP-CASH-GL-OFFSET    TO WS-101-ACCT-GEN-LED-CR.     
           MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-DR      
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
                                                                        
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
           PERFORM 2160-POPULATE-TRAN-DATA                              
              THRU 2160-EXIT.                                           
           MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-CR.     
           MOVE Y2-ERROR-GL-OFFSET       TO WS-101-ACCT-GEN-LED-DR      
           MOVE CJF00101                 TO CJ-TRAN-DATA.               
           MOVE 2                        TO CJ-TRAN-APPL-NO.            
           PERFORM 8300-CREATE-CASH-DRWR-JRNL                           
              THRU 8300-EXIT.                                           
                                                                        
           ADD WS-ONE                       TO CS-NO-ITEMS-ENTERED      
           ADD JT-PAYMENT-AMT               TO CS-AMT-CASH-DEBIT        
           ADD JT-PAYMENT-AMT               TO CS-AMT-CASH-CREDIT       
           MOVE Y1-CASHIER-CODE             TO CS-CASHIER-CODE          
           MOVE WS-INPUT-DATE               TO CS-DATE-LAST-ACTIVITY    
           PERFORM 8600-UPDATE-CASH-DRWR-CNTL                           
              THRU 8600-EXIT.                                           
              PERFORM 1601-INSERT-OVSH-REV THRU 1601-EXIT               
C31844     .                                                            
       1201-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1300-CALL-PAYMENT-SP                                        **        
      **                                                              **        
      ******************************************************************        
       1300-CALL-PAYMENT-SP.                                            
                                                                        
           MOVE '1300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7970-SELECT-APPLIED-FL THRU 7970-EXIT                
           IF JT-APPLIED-FL   = 'Y'                                     
              SET WS-ACCT-PROC TO TRUE                                  
              GO TO 1300-EXIT                                           
           END-IF                                                       
           MOVE 100 TO S-RETURN-CODE                                    
      *    EXEC SQL CALL CSR03413                                       
      *                ( :I-TIMESTAMP                                   
      *                 ,:I-ACCOUNT-NO                                  
      *                 ,:I-COMPANY-NO                                  
      *                 ,:I-CASH-LOC-OFFICE                             
      *                 ,:I-CUST-PHONE-NO                               
      *                 ,:I-CURRENCY-TYPE                               
      *                 ,:I-PAYMENT-AMOUNT                              
      *                 ,:I-REPORT-DATE                                 
      *                 ,:I-PYMT-FACILITY-CD                            
      *                 ,:I-DIR-PYMT-IND                                
      *                 ,:I-CONFIRMATION-NO                             
      *                 ,:I-APPL-PGM-ID                                 
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = 466 THEN                                        
      *       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
      *         CSR03413                                                
      *       END-EXEC                                                  
      *       EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1          
      *       END-EXEC                                                  
              EXEC SQL                                                  
              FETCH C1 INTO :S-RETURN-CODE                              
                           ,:S-TIMESTAMP                                
                           ,:S-ACCOUNT-NO                               
                           ,:S-COMPANY-NO                               
                           ,:S-BILLED-BALANCE                           
                           ,:S-CANCEL-DNP-FLAG                          
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
           END-IF.                                                      
           IF S-RETURN-CODE = SUCCESSFUL-CALL                           
              AND SQLCODE = 0                                           
              SET WS-ACCT-PROC TO TRUE                                  
           ELSE                                                         
              PERFORM 7969-SELECT-ERROR-CD                              
              THRU 7969-EXIT                                            
              SET WS-ACCT-NOT-PROC TO TRUE                              
           END-IF.                                                      
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
APSAPS                                                                  
APSAPS******************************************************************        
APSAPS**  1301-CALL-REVERSAL-SP                                       **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 1301-CALL-REVERSAL-SP.                                           
APSAPS                                                                  
APSAPS     MOVE '1301'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     PERFORM 7970-SELECT-APPLIED-FL THRU 7970-EXIT                
APSAPS     IF JT-APPLIED-FL   = 'Y'                                     
APSAPS        SET WS-ACCT-PROC TO TRUE                                  
APSAPS        GO TO 1301-EXIT                                           
APSAPS     END-IF                                                       
APSAPS     MOVE 100 TO S-RETURN-CODE                                    
APSAPS*    EXEC SQL CALL CSR03488                                       
APSAPS*                ( :I-TIMESTAMP                                   
APSAPS*                 ,:I-ACCOUNT-NO                                  
APSAPS*                 ,:I-COMPANY-NO                                  
APSAPS*                 ,:I-CASH-LOC-OFFICE                             
APSAPS*                 ,:I-CURRENCY-TYPE                               
APSAPS*                 ,:I-PAYMENT-AMOUNT                              
APSAPS*                 ,:I-REPORT-DATE                                 
APSAPS*                 ,:I-PYMT-FACILITY-CD                            
APSAPS*                 ,:I-DIR-PYMT-IND                                
APSAPS*                 ,:I-CONFIRMATION-NO                             
APSAPS*                 ,'PCSC362R'                                     
APSAPS*                 ,'SYSTEM'                                       
APSAPS*                 ,'REVERSING FROM PCSCA362'                      
APSAPS*                )                                                
APSAPS*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
APSAPS     IF SQLCODE = 466 THEN                                        
APSAPS*       EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE         
APSAPS*         CSR03488                                                
APSAPS*       END-EXEC                                                  
APSAPS*       EXEC SQL ALLOCATE C2 CURSOR FOR RESULT SET :LOC2          
APSAPS*       END-EXEC                                                  
APSAPS        EXEC SQL                                                  
APSAPS        FETCH C2 INTO :S-RETURN-CODE                              
APSAPS                     ,:S-TIMESTAMP                                
APSAPS                     ,:S-ACCOUNT-NO                               
APSAPS                     ,:S-COMPANY-NO                               
APSAPS                     ,:S-BILLED-BALANCE                           
APSAPS                     ,:S-CANCEL-DNP-FLAG                          
APSAPS        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
APSAPS     END-IF.                                                      
APSAPS     IF S-RETURN-CODE = SUCCESSFUL-CALL                           
APSAPS        AND SQLCODE = 0                                           
APSAPS        SET WS-ACCT-PROC TO TRUE                                  
APSAPS     ELSE                                                         
APSAPS        PERFORM 7969-SELECT-ERROR-CD                              
APSAPS        THRU 7969-EXIT                                            
APSAPS        SET WS-ACCT-NOT-PROC TO TRUE                              
APSAPS     END-IF.                                                      
APSAPS                                                                  
APSAPS 1301-EXIT.                                                       
APSAPS     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1600-INSERT-OVSH.                                           **        
      **                                                              **        
      ******************************************************************        
       1600-INSERT-OVSH.                                                
                                                                        
           MOVE '1600'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET     TO OH-GL-ACCT-NO              
           MOVE JT-PAYMENT-AMT            TO OH-OVERSHORT-AMT           
           MOVE WS-D                      TO OH-OVERSHORT-DR-CR         
           MOVE 1                         TO OH-OVERSHORT-ID            
           PERFORM  2700-MOVE-DETAIL-TO-OVERSHORT                       
              THRU  2700-EXIT                                           
           PERFORM  7967-GET-OVSH                                       
              THRU  7967-EXIT                                           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APS           MOVE JT-PAYMENT-AMT         TO WS-PYMT-AMOUNT             
APS           IF OH-OVERSHORT-DR-CR = 'C'                               
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT -          
APS                                         WS-PYMT-AMOUNT              
APS              IF OH-OVERSHORT-AMT > 0                                
APS                 MOVE 'C'                 TO OH-OVERSHORT-DR-CR      
APS              ELSE                                                   
APS                 MOVE 'D'                 TO OH-OVERSHORT-DR-CR      
APS                 COMPUTE OH-OVERSHORT-AMT = (OH-OVERSHORT-AMT * -1)  
APS              END-IF                                                 
APS           ELSE                                                      
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT +          
APS                                         WS-PYMT-AMOUNT              
APS              MOVE 'D'                 TO OH-OVERSHORT-DR-CR         
APS           END-IF                                                    
              PERFORM  8760-UPDATE-OVERSHORT                            
                 THRU  8760-EXIT                                        
           ELSE                                                         
              PERFORM  8750-INSERT-OVERSHORT                            
                 THRU  8750-EXIT                                        
           END-IF.                                                      
           MOVE Y2-ERROR-GL-OFFSET        TO OH-GL-ACCT-NO              
           MOVE JT-PAYMENT-AMT            TO OH-OVERSHORT-AMT           
           MOVE WS-C                      TO OH-OVERSHORT-DR-CR         
           MOVE 1                         TO OH-OVERSHORT-ID            
           PERFORM  7968-GET-OVSH-ID                                    
              THRU  7968-EXIT                                           
           ADD  1                         TO OH-OVERSHORT-ID            
           MOVE OH-GL-ACCT-NO             TO OT-GL-ACCT-NO              
           PERFORM 7964-DECLARE-OVSH-TYPE THRU 7964-EXIT                
           PERFORM 7965-FETCH-OVSH-TYPE   THRU 7965-EXIT                
           PERFORM 7966-CLOSE-OVSH-TYPE   THRU 7966-EXIT                
           MOVE OT-OVERSHORT-TYPE-CD      TO OH-OVERSHORT-TYPE-CD       
           PERFORM  8750-INSERT-OVERSHORT                               
              THRU  8750-EXIT.                                          
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1601-INSERT-OVSH-REV.                                       **        
      **                                                              **        
      ******************************************************************        
       1601-INSERT-OVSH-REV.                                            
                                                                        
           MOVE '1601'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET     TO OH-GL-ACCT-NO              
           MOVE JT-PAYMENT-AMT            TO OH-OVERSHORT-AMT           
           MOVE WS-C                      TO OH-OVERSHORT-DR-CR         
           MOVE 1                         TO OH-OVERSHORT-ID            
           PERFORM  2700-MOVE-DETAIL-TO-OVERSHORT                       
              THRU  2700-EXIT                                           
           PERFORM  7967-GET-OVSH                                       
              THRU  7967-EXIT                                           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APS           MOVE JT-PAYMENT-AMT         TO WS-PYMT-AMOUNT             
APS           IF OH-OVERSHORT-DR-CR = 'D'                               
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT -          
APS                                         WS-PYMT-AMOUNT              
APS              IF OH-OVERSHORT-AMT > 0                                
APS                 MOVE 'D'                 TO OH-OVERSHORT-DR-CR      
APS              ELSE                                                   
APS                 MOVE 'C'                 TO OH-OVERSHORT-DR-CR      
APS                 COMPUTE OH-OVERSHORT-AMT = (OH-OVERSHORT-AMT * -1)  
APS              END-IF                                                 
APS           ELSE                                                      
APS              COMPUTE OH-OVERSHORT-AMT = OH-OVERSHORT-AMT +          
APS                                         WS-PYMT-AMOUNT              
APS              MOVE 'C'                 TO OH-OVERSHORT-DR-CR         
APS           END-IF                                                    
              PERFORM  8761-UPDATE-OVERSHORT                            
                 THRU  8761-EXIT                                        
           ELSE                                                         
              PERFORM  8750-INSERT-OVERSHORT                            
                 THRU  8750-EXIT                                        
           END-IF.                                                      
           MOVE Y2-ERROR-GL-OFFSET        TO OH-GL-ACCT-NO              
           MOVE JT-PAYMENT-AMT            TO OH-OVERSHORT-AMT           
           MOVE WS-D                      TO OH-OVERSHORT-DR-CR         
           MOVE 1                         TO OH-OVERSHORT-ID            
           PERFORM  7968-GET-OVSH-ID                                    
              THRU  7968-EXIT                                           
           ADD  1                         TO OH-OVERSHORT-ID            
           MOVE OH-GL-ACCT-NO             TO OT-GL-ACCT-NO              
           PERFORM 7964-DECLARE-OVSH-TYPE THRU 7964-EXIT                
           PERFORM 7965-FETCH-OVSH-TYPE   THRU 7965-EXIT                
           PERFORM 7966-CLOSE-OVSH-TYPE   THRU 7966-EXIT                
           MOVE OT-OVERSHORT-TYPE-CD      TO OH-OVERSHORT-TYPE-CD       
           PERFORM  8750-INSERT-OVERSHORT                               
              THRU  8750-EXIT.                                          
                                                                        
       1601-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1700-PROCESS-COBB.                                          **        
      **                                                              **        
      ******************************************************************        
       1700-PROCESS-COBB.                                               
                                                                        
C31602     MOVE '1700'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           IF C8-DELINQ-VALUE = WS-SEB AND WS-ACCT-EXIST = 'Y'          
              MOVE JT-ACCOUNT-NO            TO XM-ACCOUNT-NO            
              MOVE AT-COMPANY-NO            TO XM-COMPANY-NO            
              PERFORM 7350-GET-MKT-XREF     THRU 7350-EXIT              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                 AT-CODE-ACCT-STAT = WS-B AND XM-ORIGINATION-CD = WS-T  
                 MOVE AT-ACCOUNT-NO         TO KO-ACCOUNT-NO            
                 MOVE WS-44                 TO KO-COMM-TYPE-CD          
                 MOVE WS-22                 TO KO-COMM-SUBTYPE-CODE     
                 PERFORM 7950-GET-COMM-DATA THRU 7950-EXIT              
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                                         OR MULTIPLE-ROWS-SELECTED      
                    SET COBB-XFERED-ACCT    TO TRUE                     
                    MOVE AT-ACCOUNT-NO         TO XR-NEW-ACCOUNT-NO     
                    PERFORM 7960-GET-COBB-ACCT THRU 7960-EXIT           
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE XR-OLD-ACCOUNT-NO  TO WS-ACCOUNT-NO         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2120-SET-CASH-DRWR-CNTL-VALUES                              **        
      **                                                              **        
      ******************************************************************        
       2120-SET-CASH-DRWR-CNTL-VALUES.                                  
                                                                        
           MOVE '2120'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-COMPANY               TO CS-CASH-COMPANY-NO.         
           MOVE WS-CASHIER-CASH-OFFICE   TO CS-CASH-LOCAL-OFFICE,       
                                            CS-CASH-REPORT-NO.          
           MOVE WS-CASHIER-USER-ID       TO CS-USER-ID.                 
                                                                        
           MOVE WS-ZERO                  TO CS-AMT-CASH-DEBIT,          
                                            CS-AMT-CASH-CREDIT,         
                                            CS-AMT-AR-DEBIT,            
                                            CS-AMT-AR-CREDIT,           
                                            CS-AMT-CK-ISS-DEBIT,        
                                            CS-AMT-CK-ISS-CREDIT,       
                                            CS-AMT-GL-DEBIT,            
                                            CS-AMT-GL-CREDIT,           
                                            CS-AMT-CASH-BEGIN-BAL,      
                                            CS-AMT-BASIC-WORK.          
                                                                        
           MOVE JT-DATE-CASH-REPORT      TO CS-DATE-CASH-REPORT         
           MOVE 0                        TO CS-AMT-CASH-DEBIT           
                                            CS-AMT-CASH-CREDIT          
           MOVE WS-M                     TO CS-CODE-PYMT-FACILITY       
                                                                        
           MOVE WS-ONE                   TO CS-NO-ITEMS-ENTERED.        
                                                                        
           MOVE WS-INPUT-DATE            TO CS-DATE-LAST-ACTIVITY.      
           MOVE Y1-CASHIER-CODE          TO CS-CASHIER-CODE.            
           MOVE SPACES                   TO CS-CODE-FCS-EXTRACTED.      
                                                                        
           MOVE WS-XFR-TS                TO CS-BALANCED-TS              
           MOVE WS-ZERO                  TO WS-CNTL-TS-NI               
           MOVE WS-CASHIER-USER-ID       TO CS-BALANCED-BY              
              .                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2150-SET-CASH-DRWR-JRNL-VALUES                              **        
      **                                                              **        
      ******************************************************************        
       2150-SET-CASH-DRWR-JRNL-VALUES.                                  
                                                                        
           MOVE '2150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE CS-CASH-COMPANY-NO       TO CJ-CASH-COMPANY-NO,         
                                            CJ-COMPANY-NO.              
           MOVE CS-CASH-LOCAL-OFFICE     TO CJ-CASH-LOCAL-OFFICE,       
                                            CJ-CASH-REPORT-NO.          
           MOVE WS-ONE                   TO CJ-TRAN-APPL-NO.            
           MOVE CS-NO-ITEMS-ENTERED      TO CJ-ENTRY-NO.                
           MOVE CS-CASH-DRAWER-ID        TO CJ-CASH-DRAWER-ID.          
           MOVE '001'                    TO CJ-LOCAL-OFFICE,            
                                            CJ-ENTRY-LOC.               
           MOVE WS-LIT-A                 TO CJ-JRNL-SORT-ID.            
           MOVE 9999999999999            TO CJ-ACCOUNT-NO.              
           MOVE WS-ZERO                  TO CJ-GL-ACCT-NO.              
           MOVE WS-METER-NO              TO CJ-METER-NO.                
           MOVE WS-ZERO                  TO CJ-TRAN-COMMENT-LEN.        
           MOVE SPACES                   TO CJ-TRAN-COMMENT-TEXT.       
                                                                        
           MOVE WS-TRAN-TIME             TO CJ-TRAN-TIME.               
           MOVE WS-TRAN-ID               TO CJ-TRAN-ID.                 
           MOVE CS-DATE-CASH-REPORT      TO CJ-DATE-CASH-REPORT.        
           MOVE WS-INPUT-DATE            TO CJ-DATE-TRAN.               
           MOVE WS-INPUT-DATE            TO CJ-DATE-LAST-ACTION.        
           MOVE WS-LIT-C                 TO CJ-CODE-ENTRY-SOURCE.       
           MOVE CS-USER-ID               TO CJ-USER-ID.                 
           MOVE SPACES                   TO CJ-BATCH-SEND-LOC.          
           MOVE SPACES                   TO CJ-ENTRY-LOC.               
           MOVE SPACES                   TO CJ-CODE-TRAN-ERRORS.        
           MOVE SPACES                   TO CJ-CODE-JRNL-EXTRACT.       
           MOVE SPACES                   TO CJ-CODE-STATUS.             
           MOVE WS-LIT-C                 TO CJ-CURRENCY-TYPE.           
           MOVE CS-CODE-PYMT-FACILITY    TO CJ-CODE-PYMT-FACILITY.      
           MOVE SPACES                   TO CJ-CSR-PC-ID.               
           MOVE WS-ZERO                  TO CJ-CUSTOMER-NO.             
                                                                        
           MOVE SPACES                   TO CJ-BALANCED-BY.             
           MOVE -1                       TO WS-CJ-DATE-NI               
                                            WS-CJ-TIME-NI.              
                                                                        
           MOVE WS-INPUT-DATE        TO CJ-DATE-BALANCED                
           MOVE WS-TRAN-TIME         TO CJ-TIME-BALANCED                
           MOVE WS-ZERO              TO WS-CJ-DATE-NI                   
                                        WS-CJ-TIME-NI                   
           MOVE WS-CASHIER-USER-ID   TO CJ-BALANCED-BY                  
           .                                                            
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2160-POPULATE-TRAN-DATA                                     **        
      **                                                              **        
      ******************************************************************        
       2160-POPULATE-TRAN-DATA.                                         
                                                                        
           MOVE '2160'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO CJF00101.                   
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO.      
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED.    
                                                                        
           MOVE JT-PAYMENT-AMT           TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET    TO WS-101-ACCT-GEN-LED-DR.     
           MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-CR      
                                                                        
                                                                        
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO,          
                                            WS-101-DETAIL-END-AR-BAL,   
                                            WS-101-ACCT-END-AR-BAL,     
                                            WS-101-REVENUE-MONTH.       
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO WS-101-FCS-DEP-BANK-CD.     
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD.  
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2161-POPULATE-TRAN-DATA-REV                                 **        
      **                                                              **        
      ******************************************************************        
       2161-POPULATE-TRAN-DATA-REV.                                     
                                                                        
           MOVE '2160'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO CJF00101.                   
           MOVE WS-101                   TO WS-101-JRNL-FORMAT-NO.      
           MOVE WS-ONE                   TO WS-101-CASH-DRAWER-USED.    
                                                                        
           MOVE JT-PAYMENT-AMT           TO WS-101-AMOUNT-ENTERED       
                                            WS-101-AMT-POSTED           
                                                                        
           MOVE Y2-DEP-CASH-GL-OFFSET    TO WS-101-ACCT-GEN-LED-DR.     
           MOVE 184.2000                 TO WS-101-ACCT-GEN-LED-CR      
                                                                        
                                                                        
           MOVE ZEROES                   TO WS-101-ITEM-ID-NO,          
                                            WS-101-DETAIL-END-AR-BAL,   
                                            WS-101-ACCT-END-AR-BAL,     
                                            WS-101-REVENUE-MONTH.       
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO WS-101-FCS-DEP-BANK-CD.     
           MOVE D1-FCS-DEP-BANK-ST-CD    TO WS-101-FCS-DEP-BANK-ST-CD.  
                                                                        
       2161-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  2700-MOVE-DETAIL-TO-OVERSHORT                               **        
      **                                                              **        
      ******************************************************************        
       2700-MOVE-DETAIL-TO-OVERSHORT.                                   
                                                                        
C31602     MOVE '2700'                        TO WS-ACTIVE-PARAGRAPH.   
                                                                        
           MOVE '01'                          TO OH-CASH-COMPANY-NO     
C31844     MOVE CS-CASH-LOCAL-OFFICE          TO OH-CASH-LOCAL-OFFICE   
C31844     MOVE CS-DATE-CASH-REPORT           TO OH-DATE-CASH-REPORT    
           MOVE CS-CASH-DRAWER-ID             TO OH-CASH-DRAWER-ID      
           MOVE CS-CASH-DRAWER-ID             TO WS-CASH-DRAWER-ID      
           MOVE Y2-USER-ID                    TO OH-USER-ID             
           MOVE WS-COMMENT-LEN                TO OH-TRAN-COMMENT-LEN    
           MOVE WS-COMMENT-TEXT               TO OH-TRAN-COMMENT-TEXT   
           MOVE WS-P                          TO OH-OVERSHORT-SOLTN-FL  
           MOVE OH-GL-ACCT-NO                 TO OT-GL-ACCT-NO          
           PERFORM 7964-DECLARE-OVSH-TYPE     THRU 7964-EXIT            
           PERFORM 7965-FETCH-OVSH-TYPE       THRU 7965-EXIT            
           PERFORM 7966-CLOSE-OVSH-TYPE       THRU 7966-EXIT            
           MOVE OT-OVERSHORT-TYPE-CD          TO OH-OVERSHORT-TYPE-CD   
           MOVE ZERO                          TO OH-OFST-OVERSHORT-AMT  
           MOVE ZERO                          TO OH-ACCOUNT-NO          
           MOVE SPACES                        TO OH-OFST-DR-CR          
           .                                                            
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2701-REVL-DETAIL-TO-OVERSHORT                               **        
      **                                                              **        
      ******************************************************************        
       2701-REVL-DETAIL-TO-OVERSHORT.                                   
                                                                        
C31602     MOVE '2700'                        TO WS-ACTIVE-PARAGRAPH.   
                                                                        
           MOVE '01'                          TO OH-CASH-COMPANY-NO     
C31844     MOVE CS-CASH-LOCAL-OFFICE          TO OH-CASH-LOCAL-OFFICE   
C31844     MOVE CS-DATE-CASH-REPORT           TO OH-DATE-CASH-REPORT    
           MOVE CS-CASH-DRAWER-ID             TO OH-CASH-DRAWER-ID      
           MOVE CS-CASH-DRAWER-ID             TO WS-CASH-DRAWER-ID      
           MOVE Y2-USER-ID                    TO OH-USER-ID             
           MOVE WS-COMMENT-LEN                TO OH-TRAN-COMMENT-LEN    
           MOVE WS-COMMENT-TEXT               TO OH-TRAN-COMMENT-TEXT   
           MOVE WS-P                          TO OH-OVERSHORT-SOLTN-FL  
           MOVE OH-GL-ACCT-NO                 TO OT-GL-ACCT-NO          
           PERFORM 7964-DECLARE-OVSH-TYPE     THRU 7964-EXIT            
           PERFORM 7965-FETCH-OVSH-TYPE       THRU 7965-EXIT            
           PERFORM 7966-CLOSE-OVSH-TYPE       THRU 7966-EXIT            
           MOVE OT-OVERSHORT-TYPE-CD          TO OH-OVERSHORT-TYPE-CD   
           MOVE ZERO                          TO OH-OFST-OVERSHORT-AMT  
           MOVE ZERO                          TO OH-ACCOUNT-NO          
           MOVE SPACES                        TO OH-OFST-DR-CR          
           .                                                            
                                                                        
       2701-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2960-PRINT-REPORT-DETAIL                                      *        
      ******************************************************************        
       2960-PRINT-REPORT-DETAIL.                                        
                                                                        
           MOVE '2960'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-PGRMNAME                  TO WS-RPT-ID.              
           MOVE Y2-ERROR-GL-OFFSET           TO WS-RPT-CREDIT-GL.       
           MOVE JT-CUST-PHONE-NO             TO WS-RPT-PHONE-NO.        
           MOVE JT-TRANS-TYPE-CD             TO WS-RPT-TRANS-TYPE       
           MOVE JT-PAYMENT-AMT               TO WS-RPT-AMOUNT.          
           MOVE JT-ACCOUNT-NO                TO WS-RPT-ACCT-NO-DET.     
                                                                        
           MOVE 10                           TO UV-CODE-VALUE-LEN       
A00575     MOVE JT-ERROR-CD(1:1)             TO UV-CODE-VALUE-TEXT      
           MOVE SPACES                       TO UV-CODE-SHORT-DESC      
           MOVE SPACES                       TO WS-RPT-REJ-REASON       
           PERFORM 7000-SELECT-CODE-VALUE    THRU 7000-EXIT             
           MOVE UV-CODE-SHORT-DESC-TEXT      TO WS-RPT-REJ-REASON       
           MOVE JT-COMPANY-NO                TO WS-RPT-COMPANY-NO       
           MOVE JT-DATE-CASH-REPORT          TO WS-CASH-RPT-DATE        
           MOVE JT-CASH-LOCAL-OFFICE         TO WS-RPT-LOCAL-OFFICE     
                                                                        
           IF WS-LINE-CNTR > WS-FIFTY-FIVE                              
              PERFORM     2965-PRINT-REPORT-HEADER                      
                 THRU     2965-EXIT                                     
                                                                        
              PERFORM     2970-MOVE-DETAIL-TO-REPORT                    
                 THRU     2970-EXIT                                     
                                                                        
              MOVE WS-TWO                      TO WS-LINE-SPACE         
           END-IF.                                                      
                                                                        
           COMPUTE WS-LINE-DIFF = WS-FIFTY-FIVE - WS-LINE-CNTR          
           END-COMPUTE                                                  
                                                                        
           IF WS-LINE-DIFF > 5                                          
              PERFORM     2970-MOVE-DETAIL-TO-REPORT                    
                 THRU     2970-EXIT                                     
                                                                        
              MOVE WS-ZERO                     TO WS-LINE-DIFF          
              MOVE WS-TWO                      TO WS-LINE-SPACE         
           ELSE                                                         
              PERFORM     2965-PRINT-REPORT-HEADER                      
                 THRU     2965-EXIT                                     
                                                                        
              PERFORM     2970-MOVE-DETAIL-TO-REPORT                    
                 THRU     2970-EXIT                                     
                                                                        
              MOVE WS-TWO                      TO WS-LINE-SPACE         
           END-IF.                                                      
                                                                        
           MOVE  WS-RPT-DTL                 TO PRT33-DATA.              
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
           MOVE  WS-ONE                     TO WS-LINE-SPACE.           
                                                                        
           ADD  WS-ONE                      TO WS-LINE-CNTR.            
                                                                        
       2960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2965-PRINT-REPORT-HEADER                                      *        
      ******************************************************************        
       2965-PRINT-REPORT-HEADER.                                        
                                                                        
           MOVE '2965'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-ZERO                      TO WS-LINE-CNTR.           
           ADD  WS-ONE                       TO WS-PAGE-NUM.            
           MOVE WS-PAGE-NUM                  TO WS-PAGE-NO.             
                                                                        
      ***  INCREMENTS THE PAGENO AND PRINTS THE HEADER                          
      ***  AFTER ADVANCING ONE PAGE                                             
                                                                        
           MOVE WS-RPT-HDR1                  TO PRT33-DATA.             
                                                                        
           PERFORM    2975-WRITE-FIRST-HEADER                           
              THRU    2975-EXIT.                                        
                                                                        
T22767***  PRINT THE TITLE AND TIME                                             
                                                                        
           MOVE WS-RPT-HDR2                   TO PRT33-DATA.            
           MOVE WS-ONE                        TO WS-LINE-SPACE.         
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
           MOVE WS-PAGE-HDR                   TO PRT33-DATA.            
                                                                        
           MOVE WS-ONE                        TO WS-LINE-SPACE.         
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
      ***  PRINTS  ======                                                       
                                                                        
           MOVE WS-RPT-LINE                   TO PRT33-DATA.            
           MOVE WS-TWO                        TO WS-LINE-SPACE.         
                                                                        
           PERFORM    2985-WRITE-RECORD                                 
              THRU    2985-EXIT.                                        
                                                                        
      ***  PRINTS THE  COMPANY DETAILS              ***                         
                                                                        
           MOVE WS-RPT-HDR3                  TO PRT33-DATA.             
           MOVE WS-ONE                       TO WS-LINE-SPACE.          
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
      ***  PRINTS ======                             ***                        
                                                                        
           MOVE WS-RPT-LINE                  TO PRT33-DATA.             
                                                                        
           PERFORM    2985-WRITE-RECORD                                 
              THRU    2985-EXIT.                                        
                                                                        
           MOVE WS-SIX                       TO WS-LINE-CNTR.           
                                                                        
       2965-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2970-MOVE-DETAIL-TO-REPORT                                  *          
      ****************************************************************          
       2970-MOVE-DETAIL-TO-REPORT.                                      
                                                                        
           MOVE '2970'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           ADD WS-ONE                        TO WS-LINE-CNTR.           
                                                                        
       2970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2975-WRITE-FIRST-HEADER                                     *          
      ****************************************************************          
       2975-WRITE-FIRST-HEADER.                                         
                                                                        
           MOVE '2975'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING PAGE.                     
                                                                        
       2975-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2985-WRITE-RECORD                                           *          
      ****************************************************************          
       2985-WRITE-RECORD.                                               
                                                                        
           MOVE '2985'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           WRITE PRT33-RECORD AFTER ADVANCING WS-LINE-SPACE.            
                                                                        
       2985-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2990-PRINT-REPORT-TRAILER                                   *          
      ****************************************************************          
       2990-PRINT-REPORT-TRAILER.                                       
                                                                        
           MOVE '2990'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           MOVE  WS-RPT-MESSAGE              TO PRT33-DATA.             
                                                                        
           PERFORM     2985-WRITE-RECORD                                
              THRU     2985-EXIT.                                       
                                                                        
           ADD  WS-ONE                      TO WS-LINE-CNTR.            
                                                                        
       2990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **   6500-GET-NEXT-BUSINESS-DAY                                 **        
      **   COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING           **        
      **   THE NEXT BUSINESS DAY.                                     **        
      ******************************************************************        
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD00315                                                
            END-EXEC.                                                           
                                                                        
                                                                        
      ******************************************************************        
      **  7000-SELECT-CODE-VALUE                                      **        
      **                                                              **        
      ******************************************************************        
       7000-SELECT-CODE-VALUE.                                          
                                                                        
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
               INTO :UV-CODE-SHORT-DESC                                 
                FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO = '01'                                  
                 AND COLUMN_NA  = 'ERROR_CD'                            
                 AND TABLE_NA   = 'CSS_PAYMENT_TRANS'                   
                 AND CODE_VALUE = :UV-CODE-VALUE                        
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*         FROM CSS_CODE_VALUE                                             
MFA-TR*        WHERE COMPANY_NO = '01'                                          
MFA-TR*          AND COLUMN_NA  = 'ERROR_CD'                                    
MFA-TR*          AND TABLE_NA   = 'CSS_PAYMENT_TRANS'                           
MFA-TR*          AND CODE_VALUE = :UV-CODE-VALUE                                
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'UNKNOWN'             TO UV-CODE-SHORT-DESC-TEXT  
              END-IF                                                    
           ELSE                                                         
               STRING  'SELECT FROM CSS_CODE_VALUE FAILED    **'        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               MOVE SPACES              TO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7100-SELECT-CIS-ACCOUNT                                     **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-CIS-ACCOUNT.                                         
                                                                        
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT :WS-Y,                                             
                     CUSTOMER_NO,                                       
                     CODE_ACCT_STAT,                                    
C28322               CODES_DATA_PRESENT,                                
C28322               COMPANY_NO                                         
               INTO :WS-ACCT-EXIST,                                     
                    :AT-CUSTOMER-NO :WS-NULL-INDICATOR3,                 
                    :AT-CODE-ACCT-STAT,                                 
C28322              :AT-CODES-DATA-PRESENT,                             
C28322              :AT-COMPANY-NO                                      
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO              
P00552                                                      
C33928                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT :WS-Y,                                                     
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              COMPANY_NO                                                 
MFA-TR*        INTO :WS-ACCT-EXIST,                                             
MFA-TR*             :AT-CUSTOMER-NO:WS-NULL-INDICATOR3,                         
MFA-TR*             :AT-CODE-ACCT-STAT,                                         
MFA-TR*             :AT-CODES-DATA-PRESENT,                                     
MFA-TR*             :AT-COMPANY-NO                                              
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO                      
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT    
              END-IF                                                    
           ELSE                                                         
C28322         MOVE AT-ACCOUNT-NO        TO WS-DISP-ACCOUNT-NO          
               STRING  'CHECKING IF AN A/C IS CIS ACCOUNT    **'        
                                      DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG                
               STRING 'ACCOUNT NO    '                                  
                                      DELIMITED BY SIZE                 
C28322         WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7200-GET-OLD-ACCOUNT                                        **        
      **                                                              **        
      ******************************************************************        
       7200-GET-OLD-ACCOUNT.                                            
                                                                        
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT :WS-Y,                                             
                     NEW_ACCOUNT_NO                                     
               INTO :WS-EXISTS-FLAG,                                    
                    :XR-NEW-ACCOUNT-NO                                  
                FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                        
               WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT :WS-Y,                                                     
MFA-TR*              NEW_ACCOUNT_NO                                             
MFA-TR*        INTO :WS-EXISTS-FLAG,                                            
MFA-TR*             :XR-NEW-ACCOUNT-NO                                          
MFA-TR*         FROM CSS_XREF_ACCT                                              
MFA-TR*        WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                        
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                      MULTIPLE-ROWS-SELECTED            
              NEXT SENTENCE                                             
           ELSE                                                         
C28322        MOVE XR-OLD-ACCOUNT-NO    TO WS-DISP-ACCOUNT-NO           
              STRING 'CHECKING IF AN A/C IS OLD CIS ACCOUNT **'         
                                     DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG                 
              STRING 'ACCOUNT NO    '                                   
                                     DELIMITED BY SIZE                  
C28322        WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG2                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7210-OPEN-DFA                                               **        
      **       OPEN DFA_CURSOR                                        **        
      ******************************************************************        
       7210-OPEN-DFA.                                                   
                                                                        
           MOVE '7210'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN DFA_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING DA CURSOR **'                      
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7220-FETCH-DFA                                              **        
      **       FETCH DFA_CURSOR                                       **        
      ******************************************************************        
       7220-FETCH-DFA.                                                  
                                                                        
           MOVE '7220'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACES                   TO DA-CODE-DFA-TYPE            
                                                                        
           EXEC SQL                                                     
              FETCH DFA_CURSOR                                          
               INTO :DA-CODE-DFA-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           MOVE DA-ACCOUNT-NO            TO WS-DISP-ACCOUNT-NO          
           MOVE SPACES                   TO WS-DFA-FLAG                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 AND DA-CODE-DFA-TYPE = WS-B                            
                 MOVE 'Y'                TO WS-DFA-FLAG                 
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR FETCHING DFA CURSOR **'                    
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING ' ACCOUNT NO  '         DELIMITED BY SIZE          
                      WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7230-CLOSE-DFA                                              **        
      **       CLOSE THE DFA CURSOR                                   **        
      ******************************************************************        
       7230-CLOSE-DFA.                                                  
                                                                        
           MOVE '7230'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE DFA_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR CLOSING DFA CURSOR **'                     
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7240-SELECT CUSTOMER                                        **        
      **                                                              **        
      ******************************************************************        
       7240-SELECT-CUST.                                                
                                                                        
           MOVE '7240'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_CUST_STATUS                                   
               INTO :CU-CODE-CUST-STATUS                                
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_CUST_STATUS                                           
MFA-TR*        INTO :CU-CODE-CUST-STATUS                                        
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*      QUERYNO 7240                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           MOVE CU-CUSTOMER-NO           TO WS-DISP-CUSTOMER-NO         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR SELECTING CUSTOMER **'                     
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING ' CUSTOMER NO '         DELIMITED BY SIZE          
                      WS-DISP-CUSTOMER-NO    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
C31844*---------------------------------------------------------------*         
C31844*    GET VALID PAYMENT OFFICE USING APPL-PROGRAM-ID, FOR EACH   *         
C31844*    APPL-PROGRAM-ID THERE SHOULD BE ONLY ONE VALID PYMT OFFICE.*         
C31844*---------------------------------------------------------------*         
C31844                                                                  
C31844 7250-SELECT-CODE-VAL.                                            
C31844                                                                  
C31844     EXEC SQL                                                     
C31844       SELECT CODE_VALUE                                          
C31844         INTO :UV-CODE-VALUE                                      
C31844         FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
C31844        WHERE COMPANY_NO = :UV-COMPANY-NO                         
C31844          AND TABLE_NA   = :UV-TABLE-NA                           
C31844          AND COLUMN_NA  = :UV-COLUMN-NA                          
C31844          AND PROGRAM_ID = :UV-PROGRAM-ID                         
A00575                                                           
P00552                                                      
C31844     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_VALUE                                                  
MFA-TR*        INTO :UV-CODE-VALUE                                              
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE COMPANY_NO = :UV-COMPANY-NO                                 
MFA-TR*         AND TABLE_NA   = :UV-TABLE-NA                                   
MFA-TR*         AND COLUMN_NA  = :UV-COLUMN-NA                                  
MFA-TR*         AND PROGRAM_ID = :UV-PROGRAM-ID                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7250                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31844                                                                  
C31844     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
C31844                                                                  
C31844     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C31844        CONTINUE                                                  
C31844     ELSE                                                         
C31844        STRING ' ERROR SELECTING CODE VALUE IN CSS_CODE_VALUE  **'
C31844                                       DELIMITED BY SIZE          
C31844                                   INTO WS-ERR-MSG                
C31844        STRING 'TABLE_NA  '            DELIMITED BY SIZE          
C31844                UV-TABLE-NA-TEXT       DELIMITED BY SIZE          
C31844               'COLUMN_NA  '           DELIMITED BY SIZE          
C31844                UV-COLUMN-NA-TEXT      DELIMITED BY SIZE          
C31844               'PROGRAM_ID  '          DELIMITED BY SIZE          
C31844                UV-PROGRAM-ID          DELIMITED BY SIZE          
C31844                                   INTO WS-ERR-MSG2               
C31844        PERFORM 8800-DIS-TABLE-ERROR                              
C31844           THRU 8800-EXIT                                         
C31844     END-IF                                                       
C31844     .                                                            
C31844 7250-EXIT.                                                       
C31844     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7300-SELECT-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       7300-SELECT-CASH-DRWR-CNTL.                                      
                                                                        
           MOVE '7300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT CASH_DRAWER_ID,                                    
                     DATE_CASH_REPORT,                                  
                     AMT_CASH_DEBIT,                                    
                     AMT_CASH_CREDIT,                                   
                     NO_ITEMS_ENTERED                                   
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1,                     
                    :CS-DATE-CASH-REPORT,                               
                    :CS-AMT-CASH-DEBIT,                                 
                    :CS-AMT-CASH-CREDIT,                                
                    :CS-NO-ITEMS-ENTERED                                
                FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO        
                 AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE      
                 AND CODE_CSH_DRWR_STAT    = :CS-CODE-CSH-DRWR-STAT     
                 AND DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                 AND CASH_DRAWER_ID        > :CS-CASH-DRAWER-ID         
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_DRAWER_ID,                                            
MFA-TR*              DATE_CASH_REPORT,                                          
MFA-TR*              AMT_CASH_DEBIT,                                            
MFA-TR*              AMT_CASH_CREDIT,                                           
MFA-TR*              NO_ITEMS_ENTERED                                           
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*             :WS-NULL-INDICATOR1,                                        
MFA-TR*             :CS-DATE-CASH-REPORT,                                       
MFA-TR*             :CS-AMT-CASH-DEBIT,                                         
MFA-TR*             :CS-AMT-CASH-CREDIT,                                        
MFA-TR*             :CS-NO-ITEMS-ENTERED                                        
MFA-TR*         FROM CSS_CSH_DRWR_CNTL                                          
MFA-TR*        WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO                
MFA-TR*          AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE              
MFA-TR*          AND CODE_CSH_DRWR_STAT    = :CS-CODE-CSH-DRWR-STAT             
MFA-TR*          AND DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT               
MFA-TR*          AND CASH_DRAWER_ID        > :CS-CASH-DRAWER-ID                 
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                              OR NOT-FOUND                              
               IF WS-NULL-INDICATOR1 < 0                                
                  MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE               
               END-IF                                                   
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING ' ERROR SELECTING CASH DRAWER ID **'              
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                      ' CASH DRAWER STATUS ' DELIMITED BY SIZE          
                      CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7310-SELECT-MAX-CSH-CNTL.                                   *          
      **                                                             *          
      ****************************************************************          
       7310-SELECT-MAX-CSH-CNTL.                                        
                                                                        
C31602     MOVE '7310'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(CASH_DRAWER_ID) + 1                            
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1                      
                FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO        
                 AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE      
                 AND DATE_CASH_REPORT      = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                 AND CASH_DRAWER_ID        > :CS-CASH-DRAWER-ID         
P00552           AND CASH_DRAWER_ID        < 9000                       
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(CASH_DRAWER_ID) + 1                                    
MFA-TR*        INTO :CS-CASH-DRAWER-ID                                          
MFA-TR*             :WS-NULL-INDICATOR1                                         
MFA-TR*         FROM CSS_CSH_DRWR_CNTL                                          
MFA-TR*        WHERE CASH_COMPANY_NO       = :CS-CASH-COMPANY-NO                
MFA-TR*          AND CASH_LOCAL_OFFICE     = :CS-CASH-LOCAL-OFFICE              
MFA-TR*          AND DATE_CASH_REPORT      = :CS-DATE-CASH-REPORT               
MFA-TR*          AND CASH_DRAWER_ID        > :CS-CASH-DRAWER-ID                 
MFA-TR*          AND CASH_DRAWER_ID        < 9000                               
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                              OR NOT-FOUND                              
               IF WS-NULL-INDICATOR1 < 0                                
                  MOVE 501 TO CS-CASH-DRAWER-ID                         
               END-IF                                                   
           ELSE                                                         
               MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID      
               STRING ' ERROR SELECTING CASH DRAWER ID **'              
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7325-SELECT-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       7325-SELECT-CASH-REPORT.                                         
           MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT USER_ID                                            
               INTO :YR-USER-ID                                         
                FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                   
               WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO           
                 AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE         
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )          
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID                                                    
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*         FROM CSS_CSH_REPORT_HDR                                         
MFA-TR*        WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                 
MFA-TR*          AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                  
MFA-TR*      QUERYNO 7325                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
              STRING 'ERROR IN SELECTING CASH REPORT HEADER**'          
                                            DELIMITED BY SIZE           
                                         INTO WS-ERR-MSG                
              STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                     YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE           
                     ',CASH COMPANY NO   '  DELIMITED BY SIZE           
                     YR-CASH-COMPANY-NO,    DELIMITED BY SIZE           
                     ',DATE CASH REPORT'    DELIMITED BY SIZE           
                     YR-DATE-CASH-REPORT    DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG2                 
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7350-GET-MKT-XREF.                                          **        
      **                                                              **        
      ******************************************************************        
       7350-GET-MKT-XREF.                                               
           MOVE '7350'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT ORIGINATION_CD                                     
               INTO :XM-ORIGINATION-CD                                  
                FROM CSS_MKT_XREF_ACCT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO    = :XM-ACCOUNT-NO                     
                 AND COMPANY_NO    = :XM-COMPANY-NO                     
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ORIGINATION_CD                                             
MFA-TR*        INTO :XM-ORIGINATION-CD                                          
MFA-TR*         FROM CSS_MKT_XREF_ACCT                                          
MFA-TR*        WHERE ACCOUNT_NO    = :XM-ACCOUNT-NO                             
MFA-TR*          AND COMPANY_NO    = :XM-COMPANY-NO                             
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE XM-ACCOUNT-NO     TO WS-DISP-ACCOUNT-NO              
              STRING  'CHECKING IF ACCT IS TRANSFERRED TO COBB **'      
                                     DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG                 
              STRING 'ACCOUNT NO   ' DELIMITED BY SIZE                  
                  WS-DISP-ACCOUNT-NO DELIMITED BY SIZE                  
                      ', COMPANY NO ' DELIMITED BY SIZE                 
                      XM-COMPANY-NO   DELIMITED BY SIZE                 
                                      INTO    WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7400-GET-MAX-CNTL-DRWR                                      **        
      **                                                              **        
      ******************************************************************        
       7400-GET-MAX-CNTL-DRWR.                                          
                                                                        
           MOVE '7400'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(CASH_DRAWER_ID)                                
               INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1              
                FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO           
                 AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE         
                 AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT        
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(CASH_DRAWER_ID)                                        
MFA-TR*        INTO :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1                      
MFA-TR*         FROM CSS_CSH_DRWR_CNTL                                          
MFA-TR*        WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*          AND CODE_CSH_DRWR_STAT = :CS-CODE-CSH-DRWR-STAT                
MFA-TR*          AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                  
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-NULL-INDICATOR1 < ZERO OR                              
                                   WS-ACTIVE-RETURN-CODE = NOT-FOUND    
              MOVE WS-ZERO          TO CS-CASH-DRAWER-ID                
              GO TO 7400-EXIT                                           
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID       
              STRING 'ERROR GETTING MAX CNTL DRAWER ID **'              
                                            DELIMITED BY SIZE           
                                        INTO WS-ERR-MSG                 
              STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                      CS-CASH-LOCAL-OFFICE, DELIMITED BY SIZE           
                     ',CASH COMPANY NO   '  DELIMITED BY SIZE           
                     CS-CASH-COMPANY-NO,    DELIMITED BY SIZE           
                     ',CASH DRAWER STATUS'  DELIMITED BY SIZE           
                     CS-CODE-CSH-DRWR-STAT  DELIMITED BY SIZE           
                                        INTO WS-ERR-MSG2                
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7500-SELECT-CASH-OFFICE                                     **        
      **                                                              **        
      ******************************************************************        
       7500-SELECT-CASH-OFFICE.                                         
                                                                        
           MOVE '7500'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT CASH_LOCAL_OFFICE,                                 
                     BATCH_DEP_CASH_OFF,                                
                     DEP_XFER_METHOD,                                   
                     USER_ID,                                           
                     DEP_DEFT_BANK_ID,                                  
                     LOCAL_OFFICE,                                      
                     DEP_CASH_GL_OFFSET,                                
                     PAYMENT_AGENT_FL,                                  
                     PYMT_TO_POST_DAYS,                                 
                     ERROR_GL_OFFSET                                    
               INTO :Y2-CASH-LOCAL-OFFICE,                              
                    :Y2-BATCH-DEP-CASH-OFF,                             
                    :Y2-DEP-XFER-METHOD,                                
                    :Y2-USER-ID,                                        
                    :Y2-DEP-DEFT-BANK-ID,                               
                    :Y2-LOCAL-OFFICE,                                   
                    :Y2-DEP-CASH-GL-OFFSET,                             
                    :Y2-PAYMENT-AGENT-FL,                               
                    :Y2-PYMT-TO-POST-DAYS,                              
                    :Y2-ERROR-GL-OFFSET                                 
                FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                   
               WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO         
                 AND PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD       
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_LOCAL_OFFICE,                                         
MFA-TR*              BATCH_DEP_CASH_OFF,                                        
MFA-TR*              DEP_XFER_METHOD,                                           
MFA-TR*              USER_ID,                                                   
MFA-TR*              DEP_DEFT_BANK_ID,                                          
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              DEP_CASH_GL_OFFSET,                                        
MFA-TR*              PAYMENT_AGENT_FL,                                          
MFA-TR*              PYMT_TO_POST_DAYS,                                         
MFA-TR*              ERROR_GL_OFFSET                                            
MFA-TR*        INTO :Y2-CASH-LOCAL-OFFICE,                                      
MFA-TR*             :Y2-BATCH-DEP-CASH-OFF,                                     
MFA-TR*             :Y2-DEP-XFER-METHOD,                                        
MFA-TR*             :Y2-USER-ID,                                                
MFA-TR*             :Y2-DEP-DEFT-BANK-ID,                                       
MFA-TR*             :Y2-LOCAL-OFFICE,                                           
MFA-TR*             :Y2-DEP-CASH-GL-OFFSET,                                     
MFA-TR*             :Y2-PAYMENT-AGENT-FL,                                       
MFA-TR*             :Y2-PYMT-TO-POST-DAYS,                                      
MFA-TR*             :Y2-ERROR-GL-OFFSET                                         
MFA-TR*         FROM CSS_CASHIER_OFFICE                                         
MFA-TR*        WHERE CASH_COMPANY_NO      = :Y2-CASH-COMPANY-NO                 
MFA-TR*          AND PAYMENT_SOURCE_CD    = :Y2-PAYMENT-SOURCE-CD               
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF (Y2-DEP-CASH-GL-OFFSET EQUAL ZERO AND                  
                                     Y2-PAYMENT-AGENT-FL = WS-Y) OR     
                                     Y2-ERROR-GL-OFFSET  EQUAL ZERO     
                 STRING ' ERROR GL OFFSET OR DEP GL OFFSET IS ZERO **'  
                                            DELIMITED BY SIZE           
                                         INTO WS-ERR-MSG                
                 STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE        
                        Y2-CASH-COMPANY-NO     DELIMITED BY SIZE        
                        'PAYMENT CODE  '       DELIMITED BY SIZE        
                        Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE        
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR GETTING CASH OFFICE, USER ID  **'          
                                            DELIMITED BY SIZE           
                                        INTO WS-ERR-MSG                 
              STRING ' CASH COMPANY NO   '  DELIMITED BY SIZE           
                     Y2-CASH-COMPANY-NO     DELIMITED BY SIZE           
                     'PAYMENT CODE  '       DELIMITED BY SIZE           
                     Y2-PAYMENT-SOURCE-CD   DELIMITED BY SIZE           
                                        INTO WS-ERR-MSG2                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
                                                                        
C2952B     MOVE  Y2-BATCH-DEP-CASH-OFF TO WS-BATCH-DEP-CASH-OFF.        
C2952B     MOVE  Y2-DEP-XFER-METHOD    TO WS-DEP-XFER-METHOD.           
C2952B     MOVE  Y2-USER-ID            TO WS-CASHIER-USER-ID.           
C2952B     MOVE  Y2-LOCAL-OFFICE       TO WS-CASHIER-LOCAL-OFFICE.      
C2952B     MOVE  Y2-DEP-DEFT-BANK-ID   TO WS-CASHIER-BANK-ID.           
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **  7510-SELECT-CSH-OFF                                        **         
      **                                                             **         
      *****************************************************************         
       7510-SELECT-CSH-OFF.                                             
                                                                        
           MOVE '7510'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT USER_ID,                                           
                     BATCH_DEP_CASH_OFF,                                
                     DEP_XFER_METHOD,                                   
                     DEP_DEFT_BANK_ID,                                  
                     LOCAL_OFFICE,                                      
                     DEP_CASH_GL_OFFSET,                                
                     PAYMENT_AGENT_FL,                                  
                     PYMT_TO_POST_DAYS,                                 
                     PAYMENT_SOURCE_CD,                                 
                     ERROR_GL_OFFSET                                    
               INTO :Y2-USER-ID,                                        
                    :Y2-BATCH-DEP-CASH-OFF,                             
                    :Y2-DEP-XFER-METHOD,                                
                    :Y2-DEP-DEFT-BANK-ID,                               
                    :Y2-LOCAL-OFFICE,                                   
                    :Y2-DEP-CASH-GL-OFFSET,                             
                    :Y2-PAYMENT-AGENT-FL,                               
                    :Y2-PYMT-TO-POST-DAYS,                              
                    :Y2-PAYMENT-SOURCE-CD,                              
                    :Y2-ERROR-GL-OFFSET                                 
                FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                   
               WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO            
                 AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE          
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT USER_ID,                                                   
MFA-TR*              BATCH_DEP_CASH_OFF,                                        
MFA-TR*              DEP_XFER_METHOD,                                           
MFA-TR*              DEP_DEFT_BANK_ID,                                          
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              DEP_CASH_GL_OFFSET,                                        
MFA-TR*              PAYMENT_AGENT_FL,                                          
MFA-TR*              PYMT_TO_POST_DAYS,                                         
MFA-TR*              PAYMENT_SOURCE_CD,                                         
MFA-TR*              ERROR_GL_OFFSET                                            
MFA-TR*        INTO :Y2-USER-ID,                                                
MFA-TR*             :Y2-BATCH-DEP-CASH-OFF,                                     
MFA-TR*             :Y2-DEP-XFER-METHOD,                                        
MFA-TR*             :Y2-DEP-DEFT-BANK-ID,                                       
MFA-TR*             :Y2-LOCAL-OFFICE,                                           
MFA-TR*             :Y2-DEP-CASH-GL-OFFSET,                                     
MFA-TR*             :Y2-PAYMENT-AGENT-FL,                                       
MFA-TR*             :Y2-PYMT-TO-POST-DAYS,                                      
MFA-TR*             :Y2-PAYMENT-SOURCE-CD,                                      
MFA-TR*             :Y2-ERROR-GL-OFFSET                                         
MFA-TR*         FROM CSS_CASHIER_OFFICE                                         
MFA-TR*        WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF (Y2-DEP-CASH-GL-OFFSET EQUAL ZERO AND                  
                  Y2-PAYMENT-AGENT-FL = WS-Y) OR                        
                  Y2-ERROR-GL-OFFSET  EQUAL ZERO                        
                 STRING ' ERROR GL OFFSET OR DEP GL OFFSET IS ZERO **'  
                                               DELIMITED BY SIZE        
                                          INTO WS-ERR-MSG               
                 STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE        
                        Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE        
                        'COMPANY NO    '       DELIMITED BY SIZE        
                        Y2-CASH-COMPANY-NO     DELIMITED BY SIZE        
                                          INTO WS-ERR-MSG2              
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           ELSE                                                         
              STRING ' ERROR GETTING CASH OFFICE, USER ID  **'          
                                            DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              STRING ' CASH LOCAL OFFICE '  DELIMITED BY SIZE           
                     Y2-CASH-LOCAL-OFFICE   DELIMITED BY SIZE           
                     'CASH COMPANY NO    '  DELIMITED BY SIZE           
                     Y2-CASH-COMPANY-NO     DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG2                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
                                                                        
C31844     MOVE  Y2-CASH-LOCAL-OFFICE  TO WS-CASHIER-CASH-OFFICE.       
C31844     MOVE  Y2-BATCH-DEP-CASH-OFF TO WS-BATCH-DEP-CASH-OFF.        
C31844     MOVE  Y2-DEP-XFER-METHOD    TO WS-DEP-XFER-METHOD.           
C31844     MOVE  Y2-USER-ID            TO WS-CASHIER-USER-ID.           
C31844     MOVE  Y2-LOCAL-OFFICE       TO WS-CASHIER-LOCAL-OFFICE.      
C31844     MOVE  Y2-DEP-DEFT-BANK-ID   TO WS-CASHIER-BANK-ID.           
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7520-STORE-EPAY-VARS                                        **        
      **                                                              **        
      ******************************************************************        
C2952B 7520-STORE-EPAY-VARS.                                            
                                                                        
C2952B     MOVE Y2-CASH-LOCAL-OFFICE  TO WS-EPAY-CASH-LOCAL-OFFICE      
C2952B     MOVE Y2-USER-ID            TO WS-EPAY-USER-ID                
C2952B     MOVE Y2-BATCH-DEP-CASH-OFF TO WS-EPAY-BATCH-DEP-CASH-OFF     
C2952B     MOVE Y2-DEP-XFER-METHOD    TO WS-EPAY-DEP-XFER-METHOD        
C2952B     MOVE Y2-DEP-DEFT-BANK-ID   TO WS-EPAY-DEP-DEFT-BANK-ID       
C2952B     MOVE Y2-LOCAL-OFFICE       TO WS-EPAY-LOCAL-OFFICE           
C2952B     MOVE Y2-DEP-CASH-GL-OFFSET TO WS-EPAY-DEP-CASH-GL-OFFSET     
C2952B     MOVE Y2-PAYMENT-AGENT-FL   TO WS-EPAY-PAYMENT-AGENT-FL       
C2952B     MOVE Y2-PYMT-TO-POST-DAYS  TO WS-EPAY-PYMT-TO-POST-DAYS      
C2952B     MOVE Y2-PAYMENT-SOURCE-CD  TO WS-EPAY-PAYMENT-SOURCE-CD      
C2952B     MOVE Y2-ERROR-GL-OFFSET    TO WS-EPAY-ERROR-GL-OFFSET.       
                                                                        
C2952B 7520-EXIT.                                                       
C2952B     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7521-STORE-APS-VARS.                                        **        
      **                                                              **        
      ******************************************************************        
C2952B 7521-STORE-APS-VARS.                                             
                                                                        
APSAPS     MOVE Y2-CASH-LOCAL-OFFICE  TO WS-APS-CASH-LOCAL-OFFICE       
APSAPS     MOVE Y2-USER-ID            TO WS-APS-USER-ID                 
APSAPS     MOVE Y2-BATCH-DEP-CASH-OFF TO WS-APS-BATCH-DEP-CASH-OFF      
APSAPS     MOVE Y2-DEP-XFER-METHOD    TO WS-APS-DEP-XFER-METHOD         
APSAPS     MOVE Y2-DEP-DEFT-BANK-ID   TO WS-APS-DEP-DEFT-BANK-ID        
APSAPS     MOVE Y2-LOCAL-OFFICE       TO WS-APS-LOCAL-OFFICE            
APSAPS     MOVE Y2-DEP-CASH-GL-OFFSET TO WS-APS-DEP-CASH-GL-OFFSET      
APSAPS     MOVE Y2-PAYMENT-AGENT-FL   TO WS-APS-PAYMENT-AGENT-FL        
APSAPS     MOVE Y2-PYMT-TO-POST-DAYS  TO WS-APS-PYMT-TO-POST-DAYS       
APSAPS     MOVE Y2-PAYMENT-SOURCE-CD  TO WS-APS-PAYMENT-SOURCE-CD       
APSAPS     MOVE Y2-ERROR-GL-OFFSET    TO WS-APS-ERROR-GL-OFFSET.        
                                                                        
APSAPS 7521-EXIT.                                                       
APSAPS     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7530-RESTORE-EPAY-VARIABLES.                                **        
      **                                                              **        
      ******************************************************************        
C2952B 7530-RESTORE-EPAY-VARIABLES.                                     
                                                                        
C2952B     MOVE WS-EPAY-CASH-LOCAL-OFFICE  TO Y2-CASH-LOCAL-OFFICE      
C2952B                                        WS-CASHIER-CASH-OFFICE    
C2952B     MOVE WS-EPAY-USER-ID            TO Y2-USER-ID                
C2952B                                        WS-CASHIER-USER-ID        
C2952B     MOVE WS-EPAY-BATCH-DEP-CASH-OFF TO Y2-BATCH-DEP-CASH-OFF     
C2952B                                        WS-BATCH-DEP-CASH-OFF     
C2952B     MOVE WS-EPAY-DEP-XFER-METHOD    TO Y2-DEP-XFER-METHOD        
C2952B                                        WS-DEP-XFER-METHOD        
C2952B     MOVE WS-EPAY-DEP-DEFT-BANK-ID   TO Y2-DEP-DEFT-BANK-ID       
C2952B                                        WS-CASHIER-BANK-ID        
C2952B     MOVE WS-EPAY-LOCAL-OFFICE       TO Y2-LOCAL-OFFICE           
C2952B                                        WS-CASHIER-LOCAL-OFFICE   
C2952B     MOVE WS-EPAY-DEP-CASH-GL-OFFSET TO Y2-DEP-CASH-GL-OFFSET     
C2952B     MOVE WS-EPAY-PAYMENT-AGENT-FL   TO Y2-PAYMENT-AGENT-FL       
C2952B     MOVE WS-EPAY-PYMT-TO-POST-DAYS  TO Y2-PYMT-TO-POST-DAYS      
C2952B     MOVE WS-EPAY-PAYMENT-SOURCE-CD  TO Y2-PAYMENT-SOURCE-CD      
C2952B     MOVE WS-EPAY-ERROR-GL-OFFSET    TO Y2-ERROR-GL-OFFSET.       
                                                                        
C2952B 7530-EXIT.                                                       
C2952B     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7540-STORE-BM-VARS                                          **        
      **                                                              **        
      ******************************************************************        
C2952B 7540-STORE-BM-VARS.                                              
                                                                        
C2952B     MOVE Y2-CASH-LOCAL-OFFICE  TO WS-BM-CASH-LOCAL-OFFICE        
C2952B     MOVE Y2-USER-ID            TO WS-BM-USER-ID                  
C2952B     MOVE Y2-BATCH-DEP-CASH-OFF TO WS-BM-BATCH-DEP-CASH-OFF       
C2952B     MOVE Y2-DEP-XFER-METHOD    TO WS-BM-DEP-XFER-METHOD          
C2952B     MOVE Y2-DEP-DEFT-BANK-ID   TO WS-BM-DEP-DEFT-BANK-ID         
C2952B     MOVE Y2-LOCAL-OFFICE       TO WS-BM-LOCAL-OFFICE             
C2952B     MOVE Y2-DEP-CASH-GL-OFFSET TO WS-BM-DEP-CASH-GL-OFFSET       
C2952B     MOVE Y2-PAYMENT-AGENT-FL   TO WS-BM-PAYMENT-AGENT-FL         
C2952B     MOVE Y2-PYMT-TO-POST-DAYS  TO WS-BM-PYMT-TO-POST-DAYS        
C2952B     MOVE Y2-PAYMENT-SOURCE-CD  TO WS-BM-PAYMENT-SOURCE-CD        
C2952B     MOVE Y2-ERROR-GL-OFFSET    TO WS-BM-ERROR-GL-OFFSET.         
                                                                        
C2952B 7540-EXIT.                                                       
C2952B     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7545-RESTORE-BM-VARIABLES.                                **          
      **                                                            **          
      ****************************************************************          
C2952B 7545-RESTORE-BM-VARIABLES.                                       
                                                                        
C2952B     MOVE WS-BM-CASH-LOCAL-OFFICE  TO Y2-CASH-LOCAL-OFFICE        
C2952B                                      WS-CASHIER-CASH-OFFICE      
C2952B     MOVE WS-BM-USER-ID            TO Y2-USER-ID                  
C2952B                                      WS-CASHIER-USER-ID          
C2952B     MOVE WS-BM-BATCH-DEP-CASH-OFF TO Y2-BATCH-DEP-CASH-OFF       
C2952B                                      WS-BATCH-DEP-CASH-OFF       
C2952B     MOVE WS-BM-DEP-XFER-METHOD    TO Y2-DEP-XFER-METHOD          
C2952B                                      WS-DEP-XFER-METHOD          
C2952B     MOVE WS-BM-DEP-DEFT-BANK-ID   TO Y2-DEP-DEFT-BANK-ID         
C2952B                                      WS-CASHIER-BANK-ID          
C2952B     MOVE WS-BM-LOCAL-OFFICE       TO Y2-LOCAL-OFFICE             
C2952B                                      WS-CASHIER-LOCAL-OFFICE     
C2952B     MOVE WS-BM-DEP-CASH-GL-OFFSET TO Y2-DEP-CASH-GL-OFFSET       
C2952B     MOVE WS-BM-PAYMENT-AGENT-FL   TO Y2-PAYMENT-AGENT-FL         
C2952B     MOVE WS-BM-PYMT-TO-POST-DAYS  TO Y2-PYMT-TO-POST-DAYS        
C2952B     MOVE WS-BM-PAYMENT-SOURCE-CD  TO Y2-PAYMENT-SOURCE-CD        
C2952B     MOVE WS-BM-ERROR-GL-OFFSET    TO Y2-ERROR-GL-OFFSET.         
                                                                        
C2952B 7545-EXIT.                                                       
C2952B     EXIT.                                                        
APSAPS****************************************************************          
APSAPS**  7546-RESTORE-APS-VARIABLES                                **          
APSAPS**                                                            **          
APSAPS****************************************************************          
APSAPS 7546-RESTORE-APS-VARIABLES.                                      
APSAPS                                                                  
APSAPS     MOVE WS-APS-CASH-LOCAL-OFFICE  TO Y2-CASH-LOCAL-OFFICE       
APSAPS                                       WS-CASHIER-CASH-OFFICE     
APSAPS     MOVE WS-APS-USER-ID            TO Y2-USER-ID                 
APSAPS                                       WS-CASHIER-USER-ID         
APSAPS     MOVE WS-APS-BATCH-DEP-CASH-OFF TO Y2-BATCH-DEP-CASH-OFF      
APSAPS                                       WS-BATCH-DEP-CASH-OFF      
APSAPS     MOVE WS-APS-DEP-XFER-METHOD    TO Y2-DEP-XFER-METHOD         
APSAPS                                       WS-DEP-XFER-METHOD         
APSAPS     MOVE WS-APS-DEP-DEFT-BANK-ID   TO Y2-DEP-DEFT-BANK-ID        
APSAPS                                       WS-CASHIER-BANK-ID         
APSAPS     MOVE WS-APS-LOCAL-OFFICE       TO Y2-LOCAL-OFFICE            
APSAPS                                       WS-CASHIER-LOCAL-OFFICE    
APSAPS     MOVE WS-APS-DEP-CASH-GL-OFFSET TO Y2-DEP-CASH-GL-OFFSET      
APSAPS     MOVE WS-APS-PAYMENT-AGENT-FL   TO Y2-PAYMENT-AGENT-FL        
APSAPS     MOVE WS-APS-PYMT-TO-POST-DAYS  TO Y2-PYMT-TO-POST-DAYS       
APSAPS     MOVE WS-APS-PAYMENT-SOURCE-CD  TO Y2-PAYMENT-SOURCE-CD       
APSAPS     MOVE WS-APS-ERROR-GL-OFFSET    TO Y2-ERROR-GL-OFFSET.        
APSAPS                                                                  
APSAPS 7546-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
      ******************************************************************        
      **  7550-SELECT-CASHIER-CODE                                    **        
      **                                                              **        
      ******************************************************************        
       7550-SELECT-CASHIER-CODE.                                        
           MOVE '7550'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT CASHIER_CODE                                       
               INTO :Y1-CASHIER-CODE                                    
                FROM CSS_CASHIER WITH(READUNCOMMITTED)                          
               WHERE USER_ID            = :Y1-USER-ID                   
                 AND CASH_COMPANY_NO    = :Y1-CASH-COMPANY-NO           
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASHIER_CODE                                               
MFA-TR*        INTO :Y1-CASHIER-CODE                                            
MFA-TR*         FROM CSS_CASHIER                                                
MFA-TR*        WHERE USER_ID            = :Y1-USER-ID                           
MFA-TR*          AND CASH_COMPANY_NO    = :Y1-CASH-COMPANY-NO                   
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               STRING ' ERROR GETTING CASHIER CODE **'                  
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
               STRING ' FOR USER ID       '  DELIMITED BY SIZE          
                      Y1-USER-ID,            DELIMITED BY SIZE          
                      ',CASH COMPANY NO   '  DELIMITED BY SIZE          
                      Y1-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7560-SELECT-BANK-ST-CD                                      **        
      **                                                              **        
      ******************************************************************        
       7560-SELECT-BANK-ST-CD.                                          
                                                                        
           MOVE '7560'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           MOVE WS-CASHIER-BANK-ID       TO D1-BANK-ID.                 
                                                                        
           EXEC SQL                                                     
              SELECT FCS_DEP_BANK_ST_CD                                 
               INTO :D1-FCS-DEP-BANK-ST-CD                              
                FROM CSS_BANK WITH(READUNCOMMITTED)                             
               WHERE BANK_ID = :D1-BANK-ID                              
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FCS_DEP_BANK_ST_CD                                         
MFA-TR*        INTO :D1-FCS-DEP-BANK-ST-CD                                      
MFA-TR*         FROM CSS_BANK                                                   
MFA-TR*        WHERE BANK_ID = :D1-BANK-ID                                      
MFA-TR*      QUERYNO 7560                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  'ERROR GETTING BANK ST CD  **'                    
                                     DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG                 
              STRING 'BANK ID '      DELIMITED BY SIZE                  
                WS-CASHIER-BANK-ID   DELIMITED BY SIZE                  
                                     INTO    WS-ERR-MSG2                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7700-GET-CURRENT-TIMESTAMP                                  **        
      **                                                              **        
      ******************************************************************        
       7700-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           MOVE '7700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
C33928     EXEC SQL                                                     
C33928        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-XFR-TS,
              :WS-TRAN-TIME                          
C33928     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-XFR-TS    = CURRENT TIMESTAMP,                            
MFA-TR*           :WS-TRAN-TIME = CURRENT TIME                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING 'ERROR GETTING TIMESTAMP VALUE **'                 
                                            DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7800-SELECT-DATABASE                                        **        
      **                                                              **        
      ******************************************************************        
       7800-SELECT-DATABASE.                                            
           MOVE '7800'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
               INTO :C8-DELINQ-VALUE                                    
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE COMPANY_NO           = :C8-COMPANY-NO              
                 AND DELINQ_CD            = :C8-DELINQ-CD               
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE COMPANY_NO           = :C8-COMPANY-NO                      
MFA-TR*          AND DELINQ_CD            = :C8-DELINQ-CD                       
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 STRING 'ERROR SELECTING DELINQUENCY CODE **'           
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'DELINQUENCY CODE '  DELIMITED BY SIZE          
                         C8-DELINQ-CD,       DELIMITED BY SIZE          
                        'COMPANY NO  '       DELIMITED BY SIZE          
                         C8-COMPANY-NO       DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7900-SELECT-GL-ACCT-NO                                      **        
      **                                                              **        
      ******************************************************************        
       7900-SELECT-GL-ACCT-NO.                                          
           MOVE '7900'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
               INTO :GO-GL-ACCT-NO                                      
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO           = :GO-COMPANY-NO              
                 AND GL_ACCT_NAME         = :GO-GL-ACCT-NAME            
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*        INTO :GO-GL-ACCT-NO                                              
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO           = :GO-COMPANY-NO                      
MFA-TR*          AND GL_ACCT_NAME         = :GO-GL-ACCT-NAME                    
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 DISPLAY 'ERROR SELECTING ACCOUNT NUMBER **'            
                          GO-GL-ACCT-NAME                               
              ELSE                                                      
                 STRING 'ERROR SELECTING ACCOUNT NUMBER **'             
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
                 STRING 'GL ACCOUNT NAME  '     DELIMITED BY SIZE       
                         GO-GL-ACCT-NAME   ,    DELIMITED BY SIZE       
                        'COMPANY NO  '          DELIMITED BY SIZE       
                         GO-COMPANY-NO          DELIMITED BY SIZE       
                                         INTO WS-ERR-MSG2               
                 PERFORM 8800-DIS-TABLE-ERROR                           
                    THRU 8800-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7950-GET-COMM-DATA                                          **        
      **                                                              **        
      ******************************************************************        
       7950-GET-COMM-DATA.                                              
                                                                        
           MOVE '7950'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
               INTO :KO-ACCOUNT-NO                                      
                FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO         = :KO-ACCOUNT-NO                
                 AND COMM_TYPE_CD       = :KO-COMM-TYPE-CD              
                 AND COMM_SUBTYPE_CODE  = :KO-COMM-SUBTYPE-CODE         
                 AND INITIAL_COMMENT_TX LIKE                            
                     '%Account has been transferred to Cobb%'           
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*        INTO :KO-ACCOUNT-NO                                              
MFA-TR*         FROM CSS_COMM_DATA                                              
MFA-TR*        WHERE ACCOUNT_NO         = :KO-ACCOUNT-NO                        
MFA-TR*          AND COMM_TYPE_CD       = :KO-COMM-TYPE-CD                      
MFA-TR*          AND COMM_SUBTYPE_CODE  = :KO-COMM-SUBTYPE-CODE                 
MFA-TR*          AND INITIAL_COMMENT_TX LIKE                                    
MFA-TR*              '%Account has been transferred to Cobb%'                   
MFA-TR*      QUERYNO 7950                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                                          OR MULTIPLE-ROWS-SELECTED     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE KO-ACCOUNT-NO         TO WS-DISP-ACCOUNT-NO          
              STRING 'ERROR SELECTING COMM DATA FOR COBB ACCT  **'      
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              STRING 'ACCOUNT NO   '         DELIMITED BY SIZE          
                      WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
                     ',COMM TYPE CD '        DELIMITED BY SIZE          
                      KO-COMM-TYPE-CD        DELIMITED BY SIZE          
                     ',COMM SUBTYPE CODE '   DELIMITED BY SIZE          
                      KO-COMM-SUBTYPE-CODE   DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG2               
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7960-GET-COBB-ACCT                                          **        
      **                                                              **        
      ******************************************************************        
       7960-GET-COBB-ACCT.                                              
                                                                        
           MOVE '7960'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT OLD_ACCOUNT_NO                                     
               INTO :XR-OLD-ACCOUNT-NO                                  
                FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                        
               WHERE NEW_ACCOUNT_NO = :XR-NEW-ACCOUNT-NO                
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OLD_ACCOUNT_NO                                             
MFA-TR*        INTO :XR-OLD-ACCOUNT-NO                                          
MFA-TR*         FROM CSS_XREF_ACCT                                              
MFA-TR*        WHERE NEW_ACCOUNT_NO = :XR-NEW-ACCOUNT-NO                        
MFA-TR*      QUERYNO 7960                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                      MULTIPLE-ROWS-SELECTED            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE XR-NEW-ACCOUNT-NO    TO WS-DISP-ACCOUNT-NO           
              STRING 'SELECTING COBB ACCT NO   **'                      
                                     DELIMITED BY SIZE                  
                                INTO WS-ERR-MSG                         
              STRING 'ACCOUNT NO    '                                   
                                     DELIMITED BY SIZE                  
              WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE                  
                                INTO WS-ERR-MSG2                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7961-OPEN-PMT-TRAN.                                         **        
      **                                                              **        
      ******************************************************************        
       7961-OPEN-PMT-TRAN.                                              
                                                                        
           MOVE '7961'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN PYMT_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              STRING ' ERROR OPENING PYMT_CURSOR **'                    
                                             DELIMITED BY SIZE          
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7961-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7962-FETCH-PMT-TRAN.                                        **        
      **                                                              **        
      ******************************************************************        
       7962-FETCH-PMT-TRAN.                                             
                                                                        
           MOVE '7962'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH PYMT_CURSOR                                         
               INTO :JT-DATE-CASH-REPORT                                
                   ,:JT-CASH-LOCAL-OFFICE                               
                   ,:JT-PYMT-RCVD-TS                                    
                   ,:JT-ACCOUNT-NO                                      
                   ,:JT-APPL-PROGRAM-ID                                 
                   ,:JT-APPLIED-FL                                      
                   ,:JT-APPLIED-TS :WS-NULL-INDICATOR2                   
                   ,:JT-COMPANY-NO                                      
                   ,:JT-CREDIT-CARD-TYPE                                
                   ,:JT-CURRENCY-TYPE                                   
                   ,:JT-CUST-PHONE-NO                                   
                   ,:JT-DIRECTED-PYMT-CD                                
                   ,:JT-ERROR-CD                                        
                   ,:JT-PAYMENT-AMT                                     
                   ,:JT-PYMT-CONFIRM-NO                                 
                   ,:JT-PYMT-FACILITY-CD                                
                   ,:JT-LAST-UPDATE-USERID                              
                   ,:JT-TRANS-HIST-SEQ-NO :WS-NULL-INDICATOR5            
                   ,:JT-ORIG-PYMT-TS :WS-NULL-INDICATOR4                 
                   ,:JT-TRANS-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           MOVE JT-ACCOUNT-NO            TO WS-DISP-ACCOUNT-NO          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR FETCHING PMT CURSOR **'                    
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
              STRING ' ACCOUNT NO  '         DELIMITED BY SIZE          
                      WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG2                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7962-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7963-CLOSE-PMT-TRAN                                         **        
      **                                                              **        
      ******************************************************************        
       7963-CLOSE-PMT-TRAN.                                             
                                                                        
           MOVE '7963'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE PYMT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR CLOSING DFA CURSOR **'                     
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       7963-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *      THIS PARA OPENS OVERSHORT TYPE CURSOR                     *        
      ******************************************************************        
       7964-DECLARE-OVSH-TYPE.                                          
                                                                        
           MOVE '7964'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN OVSHTYPE_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING  '** ERROR OPENING OVSHTYPE_CURSOR **'             
                                              DELIMITED BY SIZE         
                       ' GL ACCOUNT NO  '     DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                       INTO  WS-ERR-MSG                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7964-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 7965-FETCH-OVSH-TYPE.                                         *        
      **     FETCH OVERSHORT TYPE CURSOR                               *        
      ******************************************************************        
       7965-FETCH-OVSH-TYPE.                                            
                                                                        
           MOVE '7965'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              FETCH OVSHTYPE_CURSOR                                     
               INTO :OT-OVERSHORT-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** ERROR FETCHING OVSHTYPE_CURSOR **'             
                       ' GL ACCOUNT NO     ' DELIMITED BY SIZE          
                        WS-DISP-GL-ACCT      DELIMITED BY SIZE          
                                       INTO  WS-ERR-MSG                 
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
       7965-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7966-CLOSE-OVSH-TYPE.                                        *         
      **    CLOSE OVERSHORT TYPE CURSOR                               *         
      *****************************************************************         
       7966-CLOSE-OVSH-TYPE.                                            
                                                                        
           MOVE '7966'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              CLOSE OVSHTYPE_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING '** ERROR CLOSING OVSHTYPE_CURSOR **'              
                       ' GL ACCOUNT NO     '  DELIMITED BY SIZE         
                        WS-DISP-GL-ACCT       DELIMITED BY SIZE         
                                        INTO  WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7966-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923**7967-GET-OVSH.                                                 *        
C25923*      THIS PARA CREATES SELECTS OVERSHORT                       *        
      ******************************************************************        
       7967-GET-OVSH.                                                   
                                                                        
           MOVE '7967'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              SELECT OVERSHORT_AMT,                                     
                     OVERSHORT_DR_CR                                    
               INTO :OH-OVERSHORT-AMT,                                  
                    :OH-OVERSHORT-DR-CR                                 
                FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO            
                 AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE          
                 AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )           
                 AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID             
                 AND OVERSHORT_ID      = :OH-OVERSHORT-ID               
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OVERSHORT_AMT,                                             
MFA-TR*              OVERSHORT_DR_CR                                            
MFA-TR*        INTO :OH-OVERSHORT-AMT,                                          
MFA-TR*             :OH-OVERSHORT-DR-CR                                         
MFA-TR*         FROM CSS_OVERSHORT_HDR                                          
MFA-TR*        WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                  
MFA-TR*          AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                     
MFA-TR*          AND OVERSHORT_ID      = :OH-OVERSHORT-ID                       
MFA-TR*      QUERYNO 7967                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING 'CASH LOCAL OFFICE '     DELIMITED BY SIZE         
                      OH-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE         
                     ',DATE CASH REPORT'      DELIMITED BY SIZE         
                      OH-DATE-CASH-REPORT,    DELIMITED BY SIZE         
                     ',CASH DRAWER-ID  '      DELIMITED BY SIZE         
                      WS-CASH-DRAWER-ID,      DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7967-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923*7968-GET-OVSH-ID.                                               *        
C25923*      THIS PARA CREATES SELECTS                                 *        
      *               THE MAXIMUM OVERSHORT ID                         *        
      ******************************************************************        
       7968-GET-OVSH-ID.                                                
                                                                        
           MOVE '7968'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              SELECT MAX(OVERSHORT_ID)                                  
               INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1               
                FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO            
                 AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE          
                 AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )           
                 AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID             
                 AND OVERSHORT_ID      > :OH-OVERSHORT-ID               
P00552                                                      
A00575                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(OVERSHORT_ID)                                          
MFA-TR*        INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1                       
MFA-TR*         FROM CSS_OVERSHORT_HDR                                          
MFA-TR*        WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                  
MFA-TR*          AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                     
MFA-TR*          AND OVERSHORT_ID      > :OH-OVERSHORT-ID                       
MFA-TR*      QUERYNO 7968                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              IF WS-NULL-INDICATOR-1 EQUAL -1                           
                 MOVE WS-ONE               TO OH-OVERSHORT-ID           
              END-IF                                                    
           ELSE                                                         
              STRING 'CASH LOCAL OFFICE '      DELIMITED BY SIZE        
                      OH-CASH-LOCAL-OFFICE,    DELIMITED BY SIZE        
                     ',DATE CASH REPORT'       DELIMITED BY SIZE        
                      OH-DATE-CASH-REPORT,     DELIMITED BY SIZE        
                     ',CASH DRAWER-ID  '       DELIMITED BY SIZE        
                      WS-CASH-DRAWER-ID,       DELIMITED BY SIZE        
                                          INTO WS-ERR-MSG               
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF                                                       
           .                                                            
                                                                        
C25923 7968-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      *****************************************************************         
      **  7969-SELECT-ERROR-CD.                                       *         
      **                                                              *         
      *****************************************************************         
       7969-SELECT-ERROR-CD.                                            
                                                                        
C31602     MOVE '7969'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT ERROR_CD                                           
               INTO :JT-ERROR-CD                                        
                FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                    
               WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                 AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE          
                 AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                 AND ACCOUNT_NO        = :JT-ACCOUNT-NO                 
P00552                                                      
A00575                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_CD                                                   
MFA-TR*        INTO :JT-ERROR-CD                                                
MFA-TR*         FROM CSS_PAYMENT_TRANS                                          
MFA-TR*        WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*          AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                       
MFA-TR*          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                         
MFA-TR*      QUERYNO 7969                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C31602     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'ACCOUNT-NO ',JT-ACCOUNT-NO                       
C31602        MOVE JT-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
              STRING 'CASH LOCAL OFFICE '     DELIMITED BY SIZE         
C31602                JT-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE         
                     ',DATE CASH REPORT'      DELIMITED BY SIZE         
C31602                JT-DATE-CASH-REPORT,    DELIMITED BY SIZE         
                     ',TIMESTAMP '            DELIMITED BY SIZE         
                      JT-PYMT-RCVD-TS,        DELIMITED BY SIZE         
C31602               ',ACCOUNT-NO '           DELIMITED BY SIZE         
C31602                WS-DISP-ACCOUNT-NO,     DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7969-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **  7970-SELECT-APPLIED-FL.                                     *         
      **                                                              *         
      *****************************************************************         
       7970-SELECT-APPLIED-FL.                                          
                                                                        
C31602     MOVE '7970'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT APPLIED_FL                                         
               INTO :JT-APPLIED-FL                                      
                FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                    
               WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
                 AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE          
                 AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
                 AND ACCOUNT_NO        = :JT-ACCOUNT-NO                 
P00552                                                      
A00575                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT APPLIED_FL                                                 
MFA-TR*        INTO :JT-APPLIED-FL                                              
MFA-TR*         FROM CSS_PAYMENT_TRANS                                          
MFA-TR*        WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*          AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                       
MFA-TR*          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                         
MFA-TR*      QUERYNO 7970                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C31602     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY 'ACCOUNT-NO ',JT-ACCOUNT-NO                       
C31602        MOVE JT-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
              STRING 'CASH LOCAL OFFICE '     DELIMITED BY SIZE         
C31602                JT-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE         
                     ',DATE CASH REPORT'      DELIMITED BY SIZE         
C31602                JT-DATE-CASH-REPORT,    DELIMITED BY SIZE         
                     ',TIMESTAMP '            DELIMITED BY SIZE         
                      JT-PYMT-RCVD-TS,        DELIMITED BY SIZE         
C31602               ',ACCOUNT-NO '           DELIMITED BY SIZE         
C31602                WS-DISP-ACCOUNT-NO,     DELIMITED BY SIZE         
                                         INTO WS-ERR-MSG                
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
APSAPS******************************************************************        
APSAPS**  7971-OPEN-RVR-TRAN.                                         **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 7971-OPEN-RVR-TRAN.                                              
APSAPS                                                                  
APSAPS     MOVE '7971'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        OPEN RVSL_CURSOR                                          
APSAPS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APSAPS        CONTINUE                                                  
APSAPS     ELSE                                                         
APSAPS        STRING ' ERROR OPENING PYMT_CURSOR **'                    
APSAPS                                       DELIMITED BY SIZE          
APSAPS                                   INTO WS-ERR-MSG                
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF.                                                      
APSAPS                                                                  
APSAPS 7971-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
APSAPS******************************************************************        
APSAPS**  7972-FETCH-RVR-TRAN.                                        **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 7972-FETCH-RVR-TRAN.                                             
APSAPS                                                                  
APSAPS     MOVE '7972'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        FETCH RVSL_CURSOR                                         
APSAPS         INTO :JT-DATE-CASH-REPORT                                
APSAPS             ,:JT-CASH-LOCAL-OFFICE                               
APSAPS             ,:JT-PYMT-RCVD-TS                                    
APSAPS             ,:JT-ACCOUNT-NO                                      
APSAPS             ,:JT-APPL-PROGRAM-ID                                 
APSAPS             ,:JT-APPLIED-FL                                      
APSAPS             ,:JT-APPLIED-TS :WS-NULL-INDICATOR2                   
APSAPS             ,:JT-COMPANY-NO                                      
APSAPS             ,:JT-CREDIT-CARD-TYPE                                
APSAPS             ,:JT-CURRENCY-TYPE                                   
APSAPS             ,:JT-CUST-PHONE-NO                                   
APSAPS             ,:JT-DIRECTED-PYMT-CD                                
APSAPS             ,:JT-ERROR-CD                                        
APSAPS             ,:JT-PAYMENT-AMT                                     
APSAPS             ,:JT-PYMT-CONFIRM-NO                                 
APSAPS             ,:JT-PYMT-FACILITY-CD                                
APSAPS             ,:JT-LAST-UPDATE-USERID                              
APSAPS             ,:JT-TRANS-HIST-SEQ-NO :WS-NULL-INDICATOR5            
APSAPS             ,:JT-ORIG-PYMT-TS :WS-NULL-INDICATOR4                 
APSAPS             ,:JT-TRANS-TYPE-CD                                   
APSAPS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
APSAPS                                                                  
APSAPS     MOVE JT-ACCOUNT-NO            TO WS-DISP-ACCOUNT-NO          
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        STRING ' ERROR FETCHING PMT CURSOR **'                    
APSAPS                                       DELIMITED BY SIZE          
APSAPS                                  INTO WS-ERR-MSG                 
APSAPS        STRING ' ACCOUNT NO  '         DELIMITED BY SIZE          
APSAPS                WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
APSAPS                                  INTO WS-ERR-MSG2                
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF.                                                      
APSAPS                                                                  
APSAPS 7972-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
APSAPS******************************************************************        
APSAPS**  7973-CLOSE-RVR-TRAN                                         **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 7973-CLOSE-RVR-TRAN.                                             
APSAPS                                                                  
APSAPS     MOVE '7963'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        CLOSE RVSL_CURSOR                                         
APSAPS     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        STRING ' ERROR CLOSING DFA CURSOR **'                     
APSAPS                                       DELIMITED BY SIZE          
APSAPS                                  INTO WS-ERR-MSG                 
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF.                                                      
APSAPS                                                                  
APSAPS 7973-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
C34416******************************************************************        
C34416**  7981-OPEN-APSRVR-TRAN                                       **        
C34416**                                                              **        
C34416******************************************************************        
C34416 7981-OPEN-APSRVR-TRAN.                                           
C34416                                                                  
C34416     MOVE '7981'                   TO WS-ACTIVE-PARAGRAPH.        
C34416                                                                  
C34416     EXEC SQL                                                     
C34416        OPEN APSRVSL_CURSOR                                       
C34416     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34416                                                                  
C34416     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C34416                                                                  
C34416     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C34416        CONTINUE                                                  
C34416     ELSE                                                         
C34416        STRING ' ERROR OPENING APSRVSL_CURSOR **'                 
C34416                                       DELIMITED BY SIZE          
C34416                                   INTO WS-ERR-MSG                
C34416        PERFORM 8800-DIS-TABLE-ERROR                              
C34416           THRU 8800-EXIT                                         
C34416     END-IF.                                                      
C34416                                                                  
C34416 7981-EXIT.                                                       
C34416     EXIT.                                                        
C34416                                                                  
C34416******************************************************************        
C34416**  7982-FETCH-APSRVR-TRAN                                      **        
C34416**                                                              **        
C34416******************************************************************        
C34416 7982-FETCH-APSRVR-TRAN.                                          
C34416                                                                  
C34416     MOVE '7982'                   TO WS-ACTIVE-PARAGRAPH.        
C34416                                                                  
C34416     EXEC SQL                                                     
C34416        FETCH APSRVSL_CURSOR                                      
C34416         INTO :JT-DATE-CASH-REPORT                                
C34416             ,:JT-CASH-LOCAL-OFFICE                               
C34416             ,:JT-PYMT-RCVD-TS                                    
C34416             ,:JT-ACCOUNT-NO                                      
C34416             ,:JT-COMPANY-NO                                      
C34416             ,:JT-ERROR-CD                                        
C34416             ,:JT-PAYMENT-AMT                                     
C34416             ,:JT-PYMT-CONFIRM-NO                                 
C34416             ,:JT-TRANS-TYPE-CD                                   
C34416     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34416                                                                  
C34416     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C34416                                                                  
C34416     MOVE JT-ACCOUNT-NO            TO WS-DISP-ACCOUNT-NO          
C34416                                                                  
C34416     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34416        NEXT SENTENCE                                             
C34416     ELSE                                                         
C34416        STRING ' ERROR FETCHING APSRVSL CURSOR **'                
C34416                                       DELIMITED BY SIZE          
C34416                                  INTO WS-ERR-MSG                 
C34416        STRING ' ACCOUNT NO  '         DELIMITED BY SIZE          
C34416                WS-DISP-ACCOUNT-NO     DELIMITED BY SIZE          
C34416                                  INTO WS-ERR-MSG2                
C34416        PERFORM 8800-DIS-TABLE-ERROR                              
C34416           THRU 8800-EXIT                                         
C34416     END-IF.                                                      
C34416                                                                  
C34416 7982-EXIT.                                                       
C34416     EXIT.                                                        
C34416                                                                  
C34416******************************************************************        
C34416**  7983-CLOSE-APSRVR-TRAN.                                     **        
C34416**                                                              **        
C34416******************************************************************        
C34416 7983-CLOSE-APSRVR-TRAN.                                          
C34416                                                                  
C34416     MOVE '7983'                   TO WS-ACTIVE-PARAGRAPH.        
C34416                                                                  
C34416     EXEC SQL                                                     
C34416        CLOSE APSRVSL_CURSOR                                      
C34416     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34416                                                                  
C34416     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C34416                                                                  
C34416     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C34416        NEXT SENTENCE                                             
C34416     ELSE                                                         
C34416        STRING ' ERROR CLOSING APSRVSL CURSOR **'                 
C34416                                       DELIMITED BY SIZE          
C34416                                  INTO WS-ERR-MSG                 
C34416        PERFORM 8800-DIS-TABLE-ERROR                              
C34416           THRU 8800-EXIT                                         
C34416     END-IF.                                                      
C34416                                                                  
C34416 7983-EXIT.                                                       
C34416     EXIT.                                                        
C34416                                                                  
      *****************************************************************         
      **  7974-FIND-PAYMENT.                                          *         
      **                                                              *         
      *****************************************************************         
       7974-FIND-PAYMENT.                                               
APSAPS                                                                  
APSAPS     MOVE '7974'                 TO WS-ACTIVE-PARAGRAPH.          
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        SELECT 'Y'                                                
APSAPS              ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                               
APSAPS         INTO :WS-PAYMENT-PRESENT                                 
APSAPS             ,:AR-TRANS-HIST-SEQ-NO                               
APSAPS          FROM CSS_PAYMENT_TRANS JT WITH(READUNCOMMITTED)                 
APSAPS              ,CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED)                 
APSAPS         WHERE JT.ACCOUNT_NO        = :JT-ACCOUNT-NO              
APSAPS           AND JT.ACCOUNT_NO        = AR.ACCOUNT_NO               
APSAPS           AND JT.PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-ORIG-PYMT-TS
              )            
APSAPS           AND JT.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO        
P00552                                                      
A00575                                                           
APSAPS     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,AR.TRANS_HIST_SEQ_NO                                       
MFA-TR*        INTO :WS-PAYMENT-PRESENT                                         
MFA-TR*            ,:AR-TRANS-HIST-SEQ-NO                                       
MFA-TR*         FROM CSS_PAYMENT_TRANS JT                                       
MFA-TR*             ,CSS_AR_TRANS_HIST AR                                       
MFA-TR*        WHERE JT.ACCOUNT_NO        = :JT-ACCOUNT-NO                      
MFA-TR*          AND JT.ACCOUNT_NO        = AR.ACCOUNT_NO                       
MFA-TR*          AND JT.PYMT_RCVD_TS      = :JT-ORIG-PYMT-TS                    
MFA-TR*          AND JT.TRANS_HIST_SEQ_NO = AR.TRANS_HIST_SEQ_NO                
MFA-TR*      QUERYNO 7974                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        DISPLAY 'ACCOUNT-NO ',AR-ACCOUNT-NO                       
APSAPS        MOVE AR-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
APSAPS        STRING 'ACCOUNT-NO        '     DELIMITED BY SIZE         
APSAPS                WS-DISP-ACCOUNT-NO,     DELIMITED BY SIZE         
APSAPS               ',TRANS_HIST_SEQ_NO'     DELIMITED BY SIZE         
APSAPS                AR-TRANS-HIST-SEQ-NO,   DELIMITED BY SIZE         
APSAPS                                   INTO WS-ERR-MSG                
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF                                                       
APSAPS     .                                                            
APSAPS                                                                  
APSAPS 7974-EXIT.                                                       
APSAPS     EXIT.                                                        
                                                                        
C29529*****************************************************************         
C29529** 8054-SELECT-PND-BNK-DRFT.                                    *         
C29529** SELECTS CUST-BANK-SEQ-NO FROM PENDING BANK DRAFT FOR INSERT  *         
C29529**   INTO AR-TRANS-HIST                                         *         
C29529*****************************************************************         
C29529 8054-SELECT-PND-BNK-DRFT.                                        
                                                                        
C29529     MOVE '8054'       TO WS-ACTIVE-PARAGRAPH                     
                                                                        
C29529     MOVE JT-PYMT-RCVD-TS TO PB-PYMT-TRANS-TS                     
C29529     MOVE JT-ACCOUNT-NO   TO PB-ACCOUNT-NO                        
                                                                        
C29529     EXEC SQL                                                     
C29529        SELECT CUST_BANK_SEQ_NO,                                  
C29529               PYMT_POSTED_FL                                     
C29529         INTO :PB-CUST-BANK-SEQ-NO,                               
C29529              :PB-PYMT-POSTED-FL                                  
C29529          FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
C29529         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       
C29529           AND PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                 
P00552                                                      
A00575                                                           
C29529     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUST_BANK_SEQ_NO,                                          
MFA-TR*              PYMT_POSTED_FL                                             
MFA-TR*        INTO :PB-CUST-BANK-SEQ-NO,                                       
MFA-TR*             :PB-PYMT-POSTED-FL                                          
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                         
MFA-TR*        WHERE ACCOUNT_NO = : PB-ACCOUNT-NO                               
MFA-TR*          AND PYMT_TRANS_TS = : PB-PYMT-TRANS-TS                         
MFA-TR*      QUERYNO 8054                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C29529                     S-RETURN-CODE                                
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        IF PB-PYMT-POSTED-FL = 'Y'                                
C29529           PERFORM 8700-SET-APPLIED-FLAG  THRU 8700-EXIT          
C29529           SET DRAFT-NOT-FOUND TO TRUE                            
A00575           MOVE 'Q' TO JT-ERROR-CD(1:1)                           
C29529        ELSE                                                      
C29529           SET DRAFT-FOUND TO TRUE                                
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29529           PERFORM 8700-SET-APPLIED-FLAG  THRU 8700-EXIT          
C29529           SET DRAFT-NOT-FOUND TO TRUE                            
A00575           MOVE 'Q' TO JT-ERROR-CD(1:1)                           
C29529        ELSE                                                      
C29529           MOVE PB-ACCOUNT-NO  TO WS-DISP-ACCOUNT-NO              
C29529           STRING 'SELECT FAILED FOR CSS_PNDNG_BNK_DRFT'          
C29529                                      DELIMITED BY SIZE           
C29529                                 INTO WS-ERR-MSG                  
C29529           STRING 'ACCOUNT_NO'        DELIMITED BY SIZE           
C29529                  WS-DISP-ACCOUNT-NO, DELIMITED BY SIZE           
C29529                  'PYMT_TRANS_TS'     DELIMITED BY SIZE           
C29529                  PB-PYMT-TRANS-TS,   DELIMITED BY SIZE           
C29529                                 INTO WS-ERR-MSG2                 
C29529           PERFORM 8800-DIS-TABLE-ERROR                           
C29529           THRU 8800-EXIT                                         
C29529        END-IF                                                    
C29529     END-IF                                                       
C29529     .                                                            
                                                                        
C29529 8054-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8100-CREATE-BANK-TRANSFER                                   **        
      **                                                              **        
      ******************************************************************        
       8100-CREATE-BANK-TRANSFER.                                       
                                                                        
           MOVE '8100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BANK_TRANSFER                             
                     ( CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       DATE_CASH_REPORT,                                
                       CASH_DRAWER_ID,                                  
                       TRANSFER_TS,                                     
                       CURRENCY_TYPE,                                   
                       USER_ID,                                         
                       BANK_ID,                                         
                       TRANSFER_AMT,                                    
                       CODE_DR_CR,                                      
                       BANK_POST_DT)                                    
              VALUES (:YB-CASH-COMPANY-NO,                              
                      :YB-CASH-LOCAL-OFFICE,                            
                      IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
                      :YB-CASH-DRAWER-ID,                               
                      CIS.CHAR2TIMESTAMP(:YB-TRANSFER-TS),                      
                      :YB-CURRENCY-TYPE,                                
                      :YB-USER-ID,                                      
                      :YB-BANK-ID,                                      
                      :YB-TRANSFER-AMT,                                 
                      :YB-CODE-DR-CR,                                   
                      IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BANK_TRANSFER                                     
MFA-TR*              ( CASH_COMPANY_NO,                                         
MFA-TR*                CASH_LOCAL_OFFICE,                                       
MFA-TR*                DATE_CASH_REPORT,                                        
MFA-TR*                CASH_DRAWER_ID,                                          
MFA-TR*                TRANSFER_TS,                                             
MFA-TR*                CURRENCY_TYPE,                                           
MFA-TR*                USER_ID,                                                 
MFA-TR*                BANK_ID,                                                 
MFA-TR*                TRANSFER_AMT,                                            
MFA-TR*                CODE_DR_CR,                                              
MFA-TR*                BANK_POST_DT)                                            
MFA-TR*       VALUES (:YB-CASH-COMPANY-NO,                                      
MFA-TR*               :YB-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :YB-DATE-CASH-REPORT,                                     
MFA-TR*               :YB-CASH-DRAWER-ID,                                       
MFA-TR*               :YB-TRANSFER-TS,                                          
MFA-TR*               :YB-CURRENCY-TYPE,                                        
MFA-TR*               :YB-USER-ID,                                              
MFA-TR*               :YB-BANK-ID,                                              
MFA-TR*               :YB-TRANSFER-AMT,                                         
MFA-TR*               :YB-CODE-DR-CR,                                           
MFA-TR*               :YB-BANK-POST-DT)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE YB-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR INSERTING INTO CSS_BANK_TRANSFER **'       
                                               DELIMITED BY SIZE        
                                          INTO WS-ERR-MSG               
              STRING 'LOCAL OFFICE     '       DELIMITED BY SIZE        
                      YB-CASH-LOCAL-OFFICE,    DELIMITED BY SIZE        
                     ',CASH COMPANY NO   '     DELIMITED BY SIZE        
                      YB-CASH-COMPANY-NO,      DELIMITED BY SIZE        
                     ',DATE CASH REPORT'       DELIMITED BY SIZE        
                      YB-DATE-CASH-REPORT,     DELIMITED BY SIZE        
                     ',CASH DRAWER ID'         DELIMITED BY SIZE        
                      WS-DISP-CASH-DRAWER-ID,  DELIMITED BY SIZE        
                     ',USER ID       '         DELIMITED BY SIZE        
                      YB-USER-ID               DELIMITED BY SIZE        
                                          INTO WS-ERR-MSG2              
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8200-CREATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8200-CREATE-CASH-DRWR-CNTL.                                      
                                                                        
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CSH_DRWR_CNTL                             
                    ( CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      CASH_REPORT_NO,                                   
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      AMT_CASH_DEBIT,                                   
                      AMT_CASH_CREDIT,                                  
                      AMT_AR_DEBIT,                                     
                      AMT_AR_CREDIT,                                    
                      AMT_CK_ISS_DEBIT,                                 
                      AMT_CK_ISS_CREDIT,                                
                      AMT_GL_DEBIT,                                     
                      AMT_GL_CREDIT,                                    
                      AMT_CASH_BEGIN_BAL,                               
                      AMT_BASIC_WORK,                                   
                      USER_ID,                                          
                      CASHIER_CODE,                                     
                      CODE_PYMT_FACILITY,                               
                      CODE_FCS_EXTRACTED,                               
                      CODE_CSH_DRWR_STAT,                               
                      DATE_LAST_ACTIVITY,                               
                      BALANCED_BY,                                      
                      BALANCED_TS,                                      
                      NO_ITEMS_ENTERED )                                
             VALUES (:CS-CASH-COMPANY-NO,                               
                     :CS-CASH-LOCAL-OFFICE,                             
                     :CS-CASH-REPORT-NO,                                
                     IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                     :CS-CASH-DRAWER-ID,                                
                     :CS-AMT-CASH-DEBIT,                                
                     :CS-AMT-CASH-CREDIT,                               
                     :CS-AMT-AR-DEBIT,                                  
                     :CS-AMT-AR-CREDIT,                                 
                     :CS-AMT-CK-ISS-DEBIT,                              
                     :CS-AMT-CK-ISS-CREDIT,                             
                     :CS-AMT-GL-DEBIT,                                  
                     :CS-AMT-GL-CREDIT,                                 
                     :CS-AMT-CASH-BEGIN-BAL,                            
                     :CS-AMT-BASIC-WORK,                                
                     :CS-USER-ID,                                       
                     :CS-CASHIER-CODE,                                  
                     :CS-CODE-PYMT-FACILITY,                            
                     :CS-CODE-FCS-EXTRACTED,                            
                     :CS-CODE-CSH-DRWR-STAT,                            
                     IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                     :CS-BALANCED-BY,                                   
                     CIS.CHAR2TIMESTAMP(:CS-BALANCED-TS :WS-CNTL-TS-NI),        
                     :CS-NO-ITEMS-ENTERED )                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CSH_DRWR_CNTL                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               CASH_REPORT_NO,                                           
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               AMT_CASH_DEBIT,                                           
MFA-TR*               AMT_CASH_CREDIT,                                          
MFA-TR*               AMT_AR_DEBIT,                                             
MFA-TR*               AMT_AR_CREDIT,                                            
MFA-TR*               AMT_CK_ISS_DEBIT,                                         
MFA-TR*               AMT_CK_ISS_CREDIT,                                        
MFA-TR*               AMT_GL_DEBIT,                                             
MFA-TR*               AMT_GL_CREDIT,                                            
MFA-TR*               AMT_CASH_BEGIN_BAL,                                       
MFA-TR*               AMT_BASIC_WORK,                                           
MFA-TR*               USER_ID,                                                  
MFA-TR*               CASHIER_CODE,                                             
MFA-TR*               CODE_PYMT_FACILITY,                                       
MFA-TR*               CODE_FCS_EXTRACTED,                                       
MFA-TR*               CODE_CSH_DRWR_STAT,                                       
MFA-TR*               DATE_LAST_ACTIVITY,                                       
MFA-TR*               BALANCED_BY,                                              
MFA-TR*               BALANCED_TS,                                              
MFA-TR*               NO_ITEMS_ENTERED )                                        
MFA-TR*      VALUES (:CS-CASH-COMPANY-NO,                                       
MFA-TR*              :CS-CASH-LOCAL-OFFICE,                                     
MFA-TR*              :CS-CASH-REPORT-NO,                                        
MFA-TR*              :CS-DATE-CASH-REPORT,                                      
MFA-TR*              :CS-CASH-DRAWER-ID,                                        
MFA-TR*              :CS-AMT-CASH-DEBIT,                                        
MFA-TR*              :CS-AMT-CASH-CREDIT,                                       
MFA-TR*              :CS-AMT-AR-DEBIT,                                          
MFA-TR*              :CS-AMT-AR-CREDIT,                                         
MFA-TR*              :CS-AMT-CK-ISS-DEBIT,                                      
MFA-TR*              :CS-AMT-CK-ISS-CREDIT,                                     
MFA-TR*              :CS-AMT-GL-DEBIT,                                          
MFA-TR*              :CS-AMT-GL-CREDIT,                                         
MFA-TR*              :CS-AMT-CASH-BEGIN-BAL,                                    
MFA-TR*              :CS-AMT-BASIC-WORK,                                        
MFA-TR*              :CS-USER-ID,                                               
MFA-TR*              :CS-CASHIER-CODE,                                          
MFA-TR*              :CS-CODE-PYMT-FACILITY,                                    
MFA-TR*              :CS-CODE-FCS-EXTRACTED,                                    
MFA-TR*              :CS-CODE-CSH-DRWR-STAT,                                    
MFA-TR*              :CS-DATE-LAST-ACTIVITY,                                    
MFA-TR*              :CS-BALANCED-BY,                                           
MFA-TR*              :CS-BALANCED-TS  :WS-CNTL-TS-NI,                           
MFA-TR*              :CS-NO-ITEMS-ENTERED )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_CNTL **'      
                                                DELIMITED BY SIZE       
                                           INTO WS-ERR-MSG              
              MOVE CS-CASH-DRAWER-ID    TO WS-DISP-CASH-DRAWER-ID       
                 STRING 'LOCAL OFFICE     '     DELIMITED BY SIZE       
                         CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE       
                        ',CASH COMPANY NO   '   DELIMITED BY SIZE       
                         CS-CASH-COMPANY-NO,    DELIMITED BY SIZE       
                        ',DATE CASH REPORT'     DELIMITED BY SIZE       
                         CS-DATE-CASH-REPORT,   DELIMITED BY SIZE       
                        ',CASH-REPORT-NO '      DELIMITED BY SIZE       
                         CS-CASH-REPORT-NO,     DELIMITED BY SIZE       
                        ',CASH DRAWER ID'       DELIMITED BY SIZE       
                         WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE       
                                           INTO WS-ERR-MSG2             
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8300-CREATE-CASH-DRWR-JRNL                                  **        
      **                                                              **        
      ******************************************************************        
       8300-CREATE-CASH-DRWR-JRNL.                                      
                                                                        
           MOVE '8300'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CSH_DRWR_JRNL                             
                     ( CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       CASH_REPORT_NO,                                  
                       DATE_CASH_REPORT,                                
                       CASH_DRAWER_ID,                                  
                       DATE_TRAN,                                       
                       ENTRY_NO,                                        
                       TRAN_APPL_NO,                                    
                       LOCAL_OFFICE,                                    
                       COMPANY_NO,                                      
                       JRNL_SORT_ID,                                    
                       ACCOUNT_NO,                                      
                       CUSTOMER_NO,                                     
                       GL_ACCT_NO,                                      
                       METER_NO,                                        
                       TRAN_TIME,                                       
                       TRAN_ID,                                         
                       DATE_LAST_ACTION,                                
                       CODE_ENTRY_SOURCE,                               
                       USER_ID,                                         
                       BATCH_SEND_LOC,                                  
                       ENTRY_LOC,                                       
                       CODE_TRAN_ERRORS,                                
                       CODE_JRNL_EXTRACT,                               
                       DATE_BALANCED,                                   
                       TIME_BALANCED,                                   
                       BALANCED_BY,                                     
                       CODE_STATUS,                                     
                       CURRENCY_TYPE,                                   
                       CODE_PYMT_FACILITY,                              
                       TRAN_DATA,                                       
                       CSR_PC_ID,                                       
                       TRAN_COMMENT )                                   
              VALUES (:CJ-CASH-COMPANY-NO,                              
                      :CJ-CASH-LOCAL-OFFICE,                            
                      :CJ-CASH-REPORT-NO,                               
                      IIF(TRY_CONVERT(DATE, :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) ),                        
                      :CJ-CASH-DRAWER-ID,                               
                      IIF(TRY_CONVERT(DATE, :CJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-TRAN
              ) <> 0) OR (LEN(:CJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :CJ-DATE-TRAN
              ), CONVERT(DATE, :CJ-DATE-TRAN) ),                               
                      :CJ-ENTRY-NO,                                     
                      :CJ-TRAN-APPL-NO,                                 
                      :CJ-LOCAL-OFFICE,                                 
                      :CJ-COMPANY-NO,                                   
                      :CJ-JRNL-SORT-ID,                                 
                      :CJ-ACCOUNT-NO,                                   
                      :CJ-CUSTOMER-NO,                                  
                      :CJ-GL-ACCT-NO,                                   
                      :CJ-METER-NO,                                     
                      CIS.CHAR2TIME(:CJ-TRAN-TIME),                             
                      :CJ-TRAN-ID,                                      
                      IIF(TRY_CONVERT(DATE, :CJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:CJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :CJ-DATE-LAST-ACTION) ),                        
                      :CJ-CODE-ENTRY-SOURCE,                            
                      :CJ-USER-ID,                                      
                      :CJ-BATCH-SEND-LOC,                               
                      :CJ-ENTRY-LOC,                                    
                      :CJ-CODE-TRAN-ERRORS ,                            
                      :CJ-CODE-JRNL-EXTRACT,                            
                      IIF(TRY_CONVERT(DATE, :CJ-DATE-BALANCED 
                                            :WS-CJ-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-BALANCED 
                                                         :WS-CJ-DATE-NI
              ) <> 0) OR (LEN(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-BALANCED :WS-CJ-DATE-NI
              ), CONVERT(DATE, :CJ-DATE-BALANCED :WS-CJ-DATE-NI) ),            
                      CIS.CHAR2TIME(:CJ-TIME-BALANCED :WS-CJ-TIME-NI),          
                      :CJ-BALANCED-BY,                                  
                      :CJ-CODE-STATUS,                                  
                      :CJ-CURRENCY-TYPE,                                
                      :CJ-CODE-PYMT-FACILITY,                           
                      :CJ-TRAN-DATA,                                    
                      :CJ-CSR-PC-ID,                                    
                      :CJ-TRAN-COMMENT )                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CSH_DRWR_JRNL                                     
MFA-TR*              ( CASH_COMPANY_NO,                                         
MFA-TR*                CASH_LOCAL_OFFICE,                                       
MFA-TR*                CASH_REPORT_NO,                                          
MFA-TR*                DATE_CASH_REPORT,                                        
MFA-TR*                CASH_DRAWER_ID,                                          
MFA-TR*                DATE_TRAN,                                               
MFA-TR*                ENTRY_NO,                                                
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                JRNL_SORT_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                GL_ACCT_NO,                                              
MFA-TR*                METER_NO,                                                
MFA-TR*                TRAN_TIME,                                               
MFA-TR*                TRAN_ID,                                                 
MFA-TR*                DATE_LAST_ACTION,                                        
MFA-TR*                CODE_ENTRY_SOURCE,                                       
MFA-TR*                USER_ID,                                                 
MFA-TR*                BATCH_SEND_LOC,                                          
MFA-TR*                ENTRY_LOC,                                               
MFA-TR*                CODE_TRAN_ERRORS,                                        
MFA-TR*                CODE_JRNL_EXTRACT,                                       
MFA-TR*                DATE_BALANCED,                                           
MFA-TR*                TIME_BALANCED,                                           
MFA-TR*                BALANCED_BY,                                             
MFA-TR*                CODE_STATUS,                                             
MFA-TR*                CURRENCY_TYPE,                                           
MFA-TR*                CODE_PYMT_FACILITY,                                      
MFA-TR*                TRAN_DATA,                                               
MFA-TR*                CSR_PC_ID,                                               
MFA-TR*                TRAN_COMMENT )                                           
MFA-TR*       VALUES (:CJ-CASH-COMPANY-NO,                                      
MFA-TR*               :CJ-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :CJ-CASH-REPORT-NO,                                       
MFA-TR*               :CJ-DATE-CASH-REPORT,                                     
MFA-TR*               :CJ-CASH-DRAWER-ID,                                       
MFA-TR*               :CJ-DATE-TRAN,                                            
MFA-TR*               :CJ-ENTRY-NO,                                             
MFA-TR*               :CJ-TRAN-APPL-NO,                                         
MFA-TR*               :CJ-LOCAL-OFFICE,                                         
MFA-TR*               :CJ-COMPANY-NO,                                           
MFA-TR*               :CJ-JRNL-SORT-ID,                                         
MFA-TR*               :CJ-ACCOUNT-NO,                                           
MFA-TR*               :CJ-CUSTOMER-NO,                                          
MFA-TR*               :CJ-GL-ACCT-NO,                                           
MFA-TR*               :CJ-METER-NO,                                             
MFA-TR*               :CJ-TRAN-TIME,                                            
MFA-TR*               :CJ-TRAN-ID,                                              
MFA-TR*               :CJ-DATE-LAST-ACTION,                                     
MFA-TR*               :CJ-CODE-ENTRY-SOURCE,                                    
MFA-TR*               :CJ-USER-ID,                                              
MFA-TR*               :CJ-BATCH-SEND-LOC,                                       
MFA-TR*               :CJ-ENTRY-LOC,                                            
MFA-TR*               :CJ-CODE-TRAN-ERRORS ,                                    
MFA-TR*               :CJ-CODE-JRNL-EXTRACT,                                    
MFA-TR*               :CJ-DATE-BALANCED :WS-CJ-DATE-NI,                         
MFA-TR*               :CJ-TIME-BALANCED :WS-CJ-TIME-NI,                         
MFA-TR*               :CJ-BALANCED-BY,                                          
MFA-TR*               :CJ-CODE-STATUS,                                          
MFA-TR*               :CJ-CURRENCY-TYPE,                                        
MFA-TR*               :CJ-CODE-PYMT-FACILITY,                                   
MFA-TR*               :CJ-TRAN-DATA,                                            
MFA-TR*               :CJ-CSR-PC-ID,                                            
MFA-TR*               :CJ-TRAN-COMMENT )                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE CJ-CASH-DRAWER-ID      TO WS-DISP-CASH-DRAWER-ID     
              STRING ' ERROR INSERTING  INTO CSS_CSH_DRWR_JRNL **'      
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
              STRING 'LOCAL OFFICE     '     DELIMITED BY SIZE          
                      CJ-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                     ',CASH COMPANY NO   '   DELIMITED BY SIZE          
                      CJ-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                     ',DATE CASH REPORT'     DELIMITED BY SIZE          
                      CJ-DATE-CASH-REPORT,   DELIMITED BY SIZE          
                     ',CASH-REPORT-NO '      DELIMITED BY SIZE          
                      CJ-CASH-REPORT-NO,     DELIMITED BY SIZE          
                     ',CASH DRAWER ID'       DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG2                
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8325-CREATE-CASH-REPORT                                     **        
      **                                                              **        
      ******************************************************************        
       8325-CREATE-CASH-REPORT.                                         
                                                                        
           MOVE '8325'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CSH_REPORT_HDR                            
                     ( CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       DATE_CASH_REPORT,                                
                       USER_ID,                                         
                       STATUS,                                          
                       CLOSED_TS)                                       
              VALUES (:YR-CASH-COMPANY-NO                               
                     ,:YR-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
                     ,:YR-USER-ID                                       
                     ,:YR-STATUS                                        
                     ,CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS))                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CSH_REPORT_HDR                                    
MFA-TR*              ( CASH_COMPANY_NO,                                         
MFA-TR*                CASH_LOCAL_OFFICE,                                       
MFA-TR*                DATE_CASH_REPORT,                                        
MFA-TR*                USER_ID,                                                 
MFA-TR*                STATUS,                                                  
MFA-TR*                CLOSED_TS)                                               
MFA-TR*       VALUES (:YR-CASH-COMPANY-NO                                       
MFA-TR*              ,:YR-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:YR-DATE-CASH-REPORT                                      
MFA-TR*              ,:YR-USER-ID                                               
MFA-TR*              ,:YR-STATUS                                                
MFA-TR*              ,:YR-CLOSED-TS)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING 'ERROR IN INSERTING CASH REPORT HEADER**'          
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
              STRING ' CASH LOCAL OFFICE '   DELIMITED BY SIZE          
                      YR-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                     ',CASH COMPANY NO   '   DELIMITED BY SIZE          
                      YR-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                     ',DATE CASH REPORT'     DELIMITED BY SIZE          
                      YR-DATE-CASH-REPORT    DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG2                
                                                                        
               PERFORM 8800-DIS-TABLE-ERROR                             
                  THRU 8800-EXIT                                        
           END-IF.                                                      
                                                                        
       8325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8600-UPDATE-CASH-DRWR-CNTL                                  **        
      **                                                              **        
      ******************************************************************        
       8600-UPDATE-CASH-DRWR-CNTL.                                      
                                                                        
           MOVE '8600'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CSH_DRWR_CNTL                                  
                 SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,        
                     AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,       
                     USER_ID               = :CS-USER-ID,               
                     CASHIER_CODE          = :CS-CASHIER-CODE,          
                     DATE_LAST_ACTIVITY    = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),    
                     NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED       
               WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO           
                 AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE         
                 AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID            
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
P00552                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CSH_DRWR_CNTL                                          
MFA-TR*          SET AMT_CASH_DEBIT        = :CS-AMT-CASH-DEBIT,                
MFA-TR*              AMT_CASH_CREDIT       = :CS-AMT-CASH-CREDIT,               
MFA-TR*              USER_ID               = :CS-USER-ID,                       
MFA-TR*              CASHIER_CODE          = :CS-CASHIER-CODE,                  
MFA-TR*              DATE_LAST_ACTIVITY    = :CS-DATE-LAST-ACTIVITY,            
MFA-TR*              NO_ITEMS_ENTERED      = :CS-NO-ITEMS-ENTERED               
MFA-TR*        WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*          AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                    
MFA-TR*          AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT                  
MFA-TR*      QUERYNO 8600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE CS-CASH-DRAWER-ID     TO WS-DISP-CASH-DRAWER-ID      
              STRING ' ERROR UPDATE CASH DRAWER CONTROL **'             
                                             DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG                 
              STRING 'LOCAL OFFICE     '     DELIMITED BY SIZE          
                      CS-CASH-LOCAL-OFFICE,  DELIMITED BY SIZE          
                     ',CASH COMPANY NO   '   DELIMITED BY SIZE          
                      CS-CASH-COMPANY-NO,    DELIMITED BY SIZE          
                     ',DATE CASH REPORT'     DELIMITED BY SIZE          
                      CS-DATE-CASH-REPORT,   DELIMITED BY SIZE          
                     ',CASH DRAWER ID'       DELIMITED BY SIZE          
                      WS-DISP-CASH-DRAWER-ID DELIMITED BY SIZE          
                                        INTO WS-ERR-MSG2                
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8700-SET-APPLIED-FLAG.                                      **        
      **                                                              **        
      ******************************************************************        
       8700-SET-APPLIED-FLAG.                                           
                                                                        
           MOVE '8700'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PAYMENT_TRANS                                  
                 SET APPLIED_FL            = :WS-Y                      
                    ,APPLIED_TS            = CIS.CURRENT$TIMESTAMP()          
C30257              ,LAST_UPDATE_USERID    = 'SYSTEM'                   
P00420         WHERE ACCOUNT_NO = :JT-ACCOUNT-NO                        
P00420           AND DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
P00420           AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE          
P00420           AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
P00420*        WHERE CURRENT OF PYMT_CURSOR                                     
P00552                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PAYMENT_TRANS                                          
MFA-TR*          SET APPLIED_FL            = :WS-Y                              
MFA-TR*             ,APPLIED_TS            = CURRENT TIMESTAMP                  
MFA-TR*             ,LAST_UPDATE_USERID    = 'SYSTEM'                           
MFA-TR*        WHERE ACCOUNT_NO = :JT-ACCOUNT-NO                                
MFA-TR*          AND DATE_CASH_REPORT = :JT-DATE-CASH-REPORT                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*          AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                       
MFA-TR*        WHERE CURRENT OF PYMT_CURSOR                                     
MFA-TR*      QUERYNO 8700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING ' ERROR UPDATE CSS_PAYMENT_TRANS   **'             
                                               DELIMITED BY SIZE        
                                         INTO WS-ERR-MSG                
              MOVE SPACES                  TO WS-ERR-MSG2               
                                                                        
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
APSAPS                                                                  
APSAPS******************************************************************        
APSAPS**  8710-SET-APPLIED-FLAG-RVR.                                  **        
APSAPS**                                                              **        
APSAPS******************************************************************        
APSAPS 8710-SET-APPLIED-FLAG-RVR.                                       
APSAPS                                                                  
APSAPS     MOVE '8710'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        UPDATE CSS_PAYMENT_TRANS                                  
APSAPS           SET APPLIED_FL            = :WS-Y                      
APSAPS              ,APPLIED_TS            = CIS.CURRENT$TIMESTAMP()          
APSAPS              ,LAST_UPDATE_USERID    = 'SYSTEM'                   
P00420         WHERE ACCOUNT_NO = :JT-ACCOUNT-NO                        
P00420           AND DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
P00420           AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE          
P00420           AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
p00420*        WHERE CURRENT OF RVSL_CURSOR                                     
P00552                                                      
APSAPS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PAYMENT_TRANS                                          
MFA-TR*          SET APPLIED_FL            = :WS-Y                              
MFA-TR*             ,APPLIED_TS            = CURRENT TIMESTAMP                  
MFA-TR*             ,LAST_UPDATE_USERID    = 'SYSTEM'                           
MFA-TR*        WHERE ACCOUNT_NO = :JT-ACCOUNT-NO                                
MFA-TR*          AND DATE_CASH_REPORT = :JT-DATE-CASH-REPORT                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*          AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                       
MFA-TR*        WHERE CURRENT OF RVSL_CURSOR                                     
MFA-TR*      QUERYNO 8710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        STRING ' ERROR UPDATE CSS_PAYMENT_TRANS   **'             
APSAPS                                         DELIMITED BY SIZE        
APSAPS                                   INTO WS-ERR-MSG                
APSAPS        MOVE SPACES                  TO WS-ERR-MSG2               
APSAPS                                                                  
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF                                                       
APSAPS     .                                                            
APSAPS                                                                  
APSAPS 8710-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
APSAPS*****************************************************************         
APSAPS**  8720-update-ERROR-CD.                                       *         
APSAPS**                                                              *         
APSAPS*****************************************************************         
APSAPS 8720-UPDATE-ERROR-CD.                                            
APSAPS                                                                  
APSAPS     MOVE '8720'                 TO WS-ACTIVE-PARAGRAPH.          
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        UPDATE CSS_PAYMENT_TRANS                                  
APSAPS         SET  ERROR_CD = :JT-ERROR-CD                             
APSAPS         WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )           
APSAPS           AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE          
APSAPS           AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )               
APSAPS           AND ACCOUNT_NO        = :JT-ACCOUNT-NO                 
P00552                                                      
APSAPS     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PAYMENT_TRANS                                          
MFA-TR*        SET  ERROR_CD = :JT-ERROR-CD                                     
MFA-TR*        WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE                  
MFA-TR*          AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                       
MFA-TR*          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                         
MFA-TR*      QUERYNO 8720                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        DISPLAY 'ACCOUNT-NO ',JT-ACCOUNT-NO                       
APSAPS        MOVE JT-ACCOUNT-NO TO WS-DISP-ACCOUNT-NO                  
APSAPS        STRING 'CASH LOCAL OFFICE '     DELIMITED BY SIZE         
APSAPS                JT-CASH-LOCAL-OFFICE,   DELIMITED BY SIZE         
APSAPS               ',DATE CASH REPORT'      DELIMITED BY SIZE         
APSAPS                JT-DATE-CASH-REPORT,    DELIMITED BY SIZE         
APSAPS               ',TIMESTAMP '            DELIMITED BY SIZE         
APSAPS                JT-PYMT-RCVD-TS,        DELIMITED BY SIZE         
APSAPS               ',ACCOUNT-NO '           DELIMITED BY SIZE         
APSAPS                WS-DISP-ACCOUNT-NO,     DELIMITED BY SIZE         
APSAPS                                   INTO WS-ERR-MSG                
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF                                                       
APSAPS     .                                                            
APSAPS                                                                  
APSAPS 8720-EXIT.                                                       
APSAPS     EXIT.                                                        
APSAPS                                                                  
      ******************************************************************        
      *      THIS PARA INSERTS                                         *        
      *                   OVER SHORT FOR THE PAYMENTS                  *        
C25923******************************************************************        
C25923 8750-INSERT-OVERSHORT.                                           
                                                                        
           MOVE '8750'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_OVERSHORT_HDR                             
                     ( CASH_COMPANY_NO                                  
                      ,CASH_LOCAL_OFFICE                                
                      ,DATE_CASH_REPORT                                 
                      ,CASH_DRAWER_ID                                   
                      ,USER_ID                                          
                      ,OVERSHORT_ID                                     
                      ,TRAN_TS                                          
                      ,OVERSHORT_AMT                                    
                      ,OVERSHORT_DR_CR                                  
                      ,OFST_OVERSHORT_AMT                               
                      ,OFST_DR_CR                                       
                      ,GL_ACCT_NO                                       
                      ,LAST_UPDATE_TS                                   
                      ,OVERSHORT_TYPE_CD                                
                      ,OVERSHORT_SOLTN_FL                               
                      ,TRAN_COMMENT                                     
                      ,ACCOUNT_NO                                       
                       )                                                
              VALUES (:OH-CASH-COMPANY-NO                               
                     ,:OH-CASH-LOCAL-OFFICE                             
                     ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                     ,:OH-CASH-DRAWER-ID                                
                     ,:OH-USER-ID                                       
                     ,:OH-OVERSHORT-ID                                  
                     ,CIS.CURRENT$TIMESTAMP()                                 
                     ,:OH-OVERSHORT-AMT                                 
                     ,:OH-OVERSHORT-DR-CR                               
                     ,:OH-OFST-OVERSHORT-AMT                            
                     ,:OH-OFST-DR-CR                                    
                     ,:OH-GL-ACCT-NO                                    
                     ,CIS.CURRENT$TIMESTAMP()                                 
                     ,:OH-OVERSHORT-TYPE-CD                             
                     ,:OH-OVERSHORT-SOLTN-FL                            
                     ,:OH-TRAN-COMMENT                                  
                     ,:OH-ACCOUNT-NO                                    
                     )                                                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_OVERSHORT_HDR                                     
MFA-TR*              ( CASH_COMPANY_NO                                          
MFA-TR*               ,CASH_LOCAL_OFFICE                                        
MFA-TR*               ,DATE_CASH_REPORT                                         
MFA-TR*               ,CASH_DRAWER_ID                                           
MFA-TR*               ,USER_ID                                                  
MFA-TR*               ,OVERSHORT_ID                                             
MFA-TR*               ,TRAN_TS                                                  
MFA-TR*               ,OVERSHORT_AMT                                            
MFA-TR*               ,OVERSHORT_DR_CR                                          
MFA-TR*               ,OFST_OVERSHORT_AMT                                       
MFA-TR*               ,OFST_DR_CR                                               
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,OVERSHORT_TYPE_CD                                        
MFA-TR*               ,OVERSHORT_SOLTN_FL                                       
MFA-TR*               ,TRAN_COMMENT                                             
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*                )                                                        
MFA-TR*       VALUES (:OH-CASH-COMPANY-NO                                       
MFA-TR*              ,:OH-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:OH-DATE-CASH-REPORT                                      
MFA-TR*              ,:OH-CASH-DRAWER-ID                                        
MFA-TR*              ,:OH-USER-ID                                               
MFA-TR*              ,:OH-OVERSHORT-ID                                          
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*              ,:OH-OVERSHORT-AMT                                         
MFA-TR*              ,:OH-OVERSHORT-DR-CR                                       
MFA-TR*              ,:OH-OFST-OVERSHORT-AMT                                    
MFA-TR*              ,:OH-OFST-DR-CR                                            
MFA-TR*              ,:OH-GL-ACCT-NO                                            
MFA-TR*              ,CURRENT TIMESTAMP                                         
MFA-TR*              ,:OH-OVERSHORT-TYPE-CD                                     
MFA-TR*              ,:OH-OVERSHORT-SOLTN-FL                                    
MFA-TR*              ,:OH-TRAN-COMMENT                                          
MFA-TR*              ,:OH-ACCOUNT-NO                                            
MFA-TR*              )                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING 'CASH LOCAL OFFICE '   DELIMITED BY SIZE           
                      OH-CASH-LOCAL-OFFICE, DELIMITED BY SIZE           
                     ',DATE CASH REPORT'    DELIMITED BY SIZE           
                      OH-DATE-CASH-REPORT,  DELIMITED BY SIZE           
                     ',CASH DRAWER-ID  '    DELIMITED BY SIZE           
                      WS-CASH-DRAWER-ID,    DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
C25923 8750-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      ****************************************************************          
      **8760-UPDATE-OVERSHORT.                                       *          
      **     THIS PARA UPDATES                                       *          
      **                  OVER SHORT FOR THE PAYMENTS                *          
C25923****************************************************************          
C25923 8760-UPDATE-OVERSHORT.                                           
                                                                        
           MOVE '8760'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_OVERSHORT_HDR                                 
                 SET OVERSHORT_AMT   = :OH-OVERSHORT-AMT                
                    ,OVERSHORT_DR_CR = :OH-OVERSHORT-DR-CR              
                    ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                
               WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO            
                 AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE          
                 AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )           
                 AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID             
                 AND OVERSHORT_ID      = :OH-OVERSHORT-ID               
P00552                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_OVERSHORT_HDR                                         
MFA-TR*          SET OVERSHORT_AMT   = :OH-OVERSHORT-AMT                        
MFA-TR*             ,OVERSHORT_DR_CR = :OH-OVERSHORT-DR-CR                      
MFA-TR*             ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                        
MFA-TR*        WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                  
MFA-TR*          AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                     
MFA-TR*          AND OVERSHORT_ID      = :OH-OVERSHORT-ID                       
MFA-TR*      QUERYNO 8760                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              STRING 'CASH LOCAL OFFICE '   DELIMITED BY SIZE           
                      OH-CASH-LOCAL-OFFICE, DELIMITED BY SIZE           
                     ',DATE CASH REPORT'    DELIMITED BY SIZE           
                      OH-DATE-CASH-REPORT,  DELIMITED BY SIZE           
                     ',CASH DRAWER-ID  '    DELIMITED BY SIZE           
                      WS-CASH-DRAWER-ID,    DELIMITED BY SIZE           
                                       INTO WS-ERR-MSG                  
              PERFORM 8800-DIS-TABLE-ERROR                              
                 THRU 8800-EXIT                                         
           END-IF                                                       
           .                                                            
                                                                        
C25923 8760-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
APSAPS****************************************************************          
APSAPS**8761-UPDATE-OVERSHORT.                                       *          
APSAPS**     THIS PARA UPDATES                                       *          
APSAPS**                  OVER SHORT FOR REVERSALS                   *          
APSAPS****************************************************************          
APSAPS 8761-UPDATE-OVERSHORT.                                           
APSAPS                                                                  
APSAPS     MOVE '8761'                   TO WS-ACTIVE-PARAGRAPH.        
APSAPS                                                                  
APSAPS     EXEC SQL                                                     
APSAPS        UPDATE  CSS_OVERSHORT_HDR                                 
APSAPS           SET OVERSHORT_AMT   = :OH-OVERSHORT-AMT                
APS                 ,OVERSHORT_DR_CR = :OH-OVERSHORT-DR-CR              
APSAPS              ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                
APSAPS         WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO            
APSAPS           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE          
APSAPS           AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )           
APSAPS           AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID             
APSAPS           AND OVERSHORT_ID      = :OH-OVERSHORT-ID               
P00552                                                      
APSAPS     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_OVERSHORT_HDR                                         
MFA-TR*          SET OVERSHORT_AMT   = :OH-OVERSHORT-AMT                        
MFA-TR*             ,OVERSHORT_DR_CR = :OH-OVERSHORT-DR-CR                      
MFA-TR*             ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                        
MFA-TR*        WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                    
MFA-TR*          AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                  
MFA-TR*          AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                   
MFA-TR*          AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                     
MFA-TR*          AND OVERSHORT_ID      = :OH-OVERSHORT-ID                       
MFA-TR*      QUERYNO 8761                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

APSAPS                                                                  
APSAPS     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
APSAPS                                                                  
APSAPS     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
APSAPS        NEXT SENTENCE                                             
APSAPS     ELSE                                                         
APSAPS        STRING 'CASH LOCAL OFFICE '   DELIMITED BY SIZE           
APSAPS                OH-CASH-LOCAL-OFFICE, DELIMITED BY SIZE           
APSAPS               ',DATE CASH REPORT'    DELIMITED BY SIZE           
APSAPS                OH-DATE-CASH-REPORT,  DELIMITED BY SIZE           
APSAPS               ',CASH DRAWER-ID  '    DELIMITED BY SIZE           
APSAPS                WS-CASH-DRAWER-ID,    DELIMITED BY SIZE           
APSAPS                                 INTO WS-ERR-MSG                  
APSAPS        PERFORM 8800-DIS-TABLE-ERROR                              
APSAPS           THRU 8800-EXIT                                         
APSAPS     END-IF                                                       
APSAPS     .                                                            
APSAPS                                                                  
APSAPS 8761-EXIT.                                                       
APSAPS     EXIT.                                                        
                                                                        
      ******************************************************************        
      **  8800-DIS-TABLE-ERROR                                        **        
      **                                                              **        
      ******************************************************************        
       8800-DIS-TABLE-ERROR.                                            
                                                                        
           DISPLAY '**********************************************'.    
           DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'.    
           DISPLAY  WS-ERR-MSG.                                         
           DISPLAY '**********************************************'.    
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE.     
           DISPLAY '**' WS-ERR-MSG2.                                    
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      **  8900-DISPLAY-ERR-TERM                                       **        
      **                                                              **        
      ******************************************************************        
       8900-DISPLAY-ERR-TERM.                                           
                                                                        
           DISPLAY '                                   '.               
           DISPLAY ' ******************************************'.       
           DISPLAY ' **     PCSCA362 PROCESSING ERROR        **'.       
           DISPLAY ' ** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.      
           DISPLAY ' **' WS-ERR-MSG.                                    
           DISPLAY ' **' WS-ERR-MSG2.                                   
           DISPLAY ' **       PROCESSING TERMINATED          **'.       
           DISPLAY ' ******************************************'.       
                                                                        
           PERFORM 9900-ABEND                                           
              THRU 9900-EXIT.                                           
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  9000-TERMINATE                                              **        
      *        NORMAL TERMINATION OF THE PROGRAM                      **        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           MOVE '9000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00037                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD00038                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
            INCLUDE CPD09900                                                    
           END-EXEC.                                                            
