       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA359.                                        
       DATE-WRITTEN.   DEC 1995.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                1410 NORTH WESTSHORE BLVD                    ** 00080000
      **                   TAMPA, FLORIDA  33607                     ** 00090000
      **                      (813) 287-9200                         ** 00100000
      **                                                             ** 00110000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ____    ________     ______                              ** 00180000
      **                                                             ** 00190000
      **           INITIAL DEVELOPMENT                               ** 00200000
      **    8/14/96   WTF        ADDED CODE TO UPDATE HOURLY PRICING ** 00201000
      **                         FILE; ADDED CODE TO INSERT RATIONING** 00202000
      **                         CHARGES;                            ** 00203000
      **                         REPLACED IBS COPY MEMBERS WITH CIS  ** 00204000
      **                         VERSION                             ** 00210000
TP5651**   10/07/96   JHR        CHANGED UNION CAMP RATE TO 60U FROM ** 00211000
TP5651**                         'UCC'.   TPR5651                    ** 00212000
T11854**   06/30/97   PD         INCLUDE PARA 8010 TI UPDATE CSS_RTP ** 00213000
T11854**                         _DETAIL IF A ROW IS PRESENT.        ** 00214000
T13609**   11/05/97   CSG        PROGRAM IS NOT CORRECTLY UPDATING   ** 00215000
      **                         CSS_RTP_DETAIL FOR WESTVACO AND     ** 00216000
      **                         UNION CAMP.                         ** 00217000
LIMIT **   11/14/97   PD         FIX THE ARRAY LIMIT ABEND.          ** 00218000
T14749**   03/09/98   RGB        CORRECTED TO PROCESS THE FILE FCSCA22* 00219005
      **              CBSI       FROM THE LAST UPDATED DATE IN TABLE ** 00219106
      **                         CSS_RTP_DETAIL.                     ** 00219206
T17237**   07/31/98   RGB        CHANGED WESTVACO AND UNION CAMP PRIC-* 00219300
T17237**              CBSI       ING  FILE(FCSCA222) TO USE NEW FILE ** 00219400
T17237**                         FORMAT FROM DIPATCH                 ** 00219500
T18658**   06/03/99   JDW        MODIFIED MAINLINE AND INITIALIZATION**         
      **                         PROCEDURES TO ALLOW PROGRAM TO RUN  **         
      **                         WITH EITHER FCSCA221 OR FCSCA222    **         
      **                         WITHOUT NEEDING THE OTHER FILE AT   **         
      **                         RUN TIME.                           **         
C26776**   07/02/02   GSR        CHANGES MADE TO POST RTP DATA TO THE**         
      **                         RATE ON THE FILE. CHANGES MADE TO THE*         
      **                         FILE FORMAT TO HAVE ONE REC FOR EACH**         
      **                         HOUR.                               **         
C26776**   06/17/03   RAH        CHANGES MADE TO SET THE VALUE OF    **         
      **                         CODE-USE-INSTR-TYPE = 'N' FOR THE   **         
      **                         HOURS WHEN LAFARGE DOES NOT GET THE **         
      **                         BELOW BASELINE CREDIT.              **         
33522 **   11/17/03   DB41297    CHANGES MADE TO ALLOW ONE DUPLICATE **         
      **                         PER RUN, AND TO ABEND IF INVALID HR.**         
T35434**   03/04/07   MC95456    REPLACED CSS_MODEL_SQL WITH SET     **         
T35434**                         STATEMENTS.                         **         
A02301**   09/04/10   SP94986    REMOVED RELATED RATE 60W (WESTVACO) **         
A02301**              ACT-01     CODE                                **         
P00496**   20/08/11   MC95456    RE-WRITE OF THE PROGRAM TO USE      **         
P00496**                         INPUT FILE WITH SINGLE LAYOUT       **         
      ***************************************************************** 00220000
      ** PURPOSE      :                                              ** 00230000
      **                                                             ** 00240000
      **    THIS PROGRAM READS IN THE MONTHLY COPY OF THE REAL       ** 00250000
      ** TIME PRICING FILE AND LOADS THE INFORMATION INTO TABLE      ** 00260000
      ** CSS_RTP_DETAIL.                                             ** 00262000
      **                                                             ** 00263000
      ***************************************************************** 00264000
      **          ---- BASIC SEQUENCE STRUCTURE ----                 ** 00265000
      **                                                             ** 00266000
      **  0000         MODULE CONTROL                                ** 00267000
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     ** 00268000
      **  1000 - 1999  FUNCTIONAL CONTROL                            ** 00269000
      **  2000 - 4999  DETAIL LOGIC                                  ** 00270000
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            ** 00280000
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  ** 00290000
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)** 00300000
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)* 00310000
      **  9000 - 9999  ABEND ROUTINES.                               ** 00320000
      **                                                             ** 00330000
      ***************************************************************** 00340000
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00380000
       COPY CSSCA359.                                                   00390000
      *                                                                 00410000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00440000
       COPY CFDCA359.                                                   00450000
       COPY FIOCA359.                                                   00460000
      *                                                                 00470000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA359'.
MSQ017     COPY MFASQLM.
       01  WS-START                        PIC X(40)                    
                   VALUE 'WORKING STORAGE FOR PCSCA359 STARTS HERE'.    
       01  WS-MISC.                                                     
           05  WS-FCA359-STATUS            PIC X(02).                   
               88  FCA359-SUCCESSFUL       VALUE '00'.                  
               88  FCA359-EOF              VALUE '10'.                  
           05  WS-359-READ-CNTR            PIC 9(04)        VALUE 0.    
           05  WS-PRICE-HOUR               PIC 9(02)        VALUE 0.    
           05  WS-PRICE-HOUR-CHAR          PIC X(02).                   
           05  WS-PRICE-HOUR-NUM           REDEFINES WS-PRICE-HOUR-CHAR 
                                           PIC 9(02).                   
           05  WS-RTP-PRICE-AMT            PIC 9(03)V9(06)  VALUE 0.    
           05  WS-SIGN-RTP-PRICE-AMT       PIC S9(03)V9(06) VALUE 0.    
           05  WS-INSERT-COUNT             PIC 9(04)        VALUE 0.    
           05  WS-UPDATE-COUNT             PIC 9(04)        VALUE 0.    
      *                                                                 00760000
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA359'.  
           05  WS-E                        PIC X     VALUE 'E'.         
      *                                                                 01002000
      ***************************************************************** 01011800
      * ABEND SWITCH COPY BOOK                                        * 01011900
      ***************************************************************** 01012000
       COPY CWS00010.                                                   01013000
       COPY CWS09900.                                                   01013100
      ******************************************************************        
      *   COPY BOOK TO SUPPORT DB2 AND CICS ERROR CHECKING             *        
      ******************************************************************        
       COPY CWS00303.                                                           
      ******************************************************************01014000
      *                                                                *01015000
      *    DB2 TABLES USED IN THIS PROGRAM                             *01016000
      *                                                                *01017000
      ******************************************************************01018000
           EXEC SQL                                                     01019000
               INCLUDE SQLCA                                            01020000
           END-EXEC.                                                    01030000
                                                                        
      *****************************************************************         
      *     CSS_RTP_DETAIL J3                                                   
      *****************************************************************         
           EXEC SQL                                                     01060000
               INCLUDE TBRTPDET                                         01070000
           END-EXEC.                                                    01080000
      *****************************************************************         
      *     CSS_RATE_CREATOR RT                                                 
      *****************************************************************         
           EXEC SQL                                                     01110000
               INCLUDE TBRTCRTR                                         01120000
           END-EXEC.                                                    01130000
      *****************************************************************         
      *                                                                 01480700
       01  WS-END                          PIC X(38) VALUE              
           'WORKING STORAGE FOR PCSCA359 ENDS HERE'.                    
      *                                                                         
                                                                        
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      **    0000-MAINLINE                                             **01486000
      **                                                              **01487000
      **  PERFORM THE INTIALIZATION ROUTINE. PERFORM MAIN LOOP UNTIL  **01488000
      **  END OF INPUT FILE. CLOSE THE FILES OPENED AND STOP RUN.     **01489000
      **                                                              **01490000
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **01500000
       0000-MAINLINE.                                                   
      *                                                                 01520000
           PERFORM 0100-INITIALIZATION            THRU 0100-EXIT.       
      *                                                                 01540000
           PERFORM 1000-LOAD-RTP                  THRU 1000-EXIT        
                                                  UNTIL FCA359-EOF.     
      *                                                                 01640000
           DISPLAY 'NO.OF ROWS INSERTED TO CSS_RTP_DETAIL '             
                                                   WS-INSERT-COUNT.     
           DISPLAY 'NO.OF ROWS UPDATED  TO CSS_RTP_DETAIL '             
                                                   WS-UPDATE-COUNT.     
      *                                                                 01640000
           PERFORM 9000-TERMINATE                 THRU 9000-EXIT.       
           STOP RUN.                                                    
      *                                                                 01770000
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************01800000
      *  0100-INITIALIZATION.                                          *01810000
      *  OPEN THE REAL TIME PRICING FILE IN INPUT MODE. CHECK THE      *01820000
      *  FILE STATUS. IF IT IS NOT SUCCESSFUL, THEN DISPLAY AN ERROR   *01830000
      *  MESSAGE AND ABEND THE PROGRAM.                                *01840000
      ******************************************************************01900000
       0100-INITIALIZATION.                                             
      *                                                                 01950000
           OPEN INPUT FCSCA359-FILE.                                    
      *                                                                 01980000
           IF NOT FCA359-SUCCESSFUL                                     
              DISPLAY '**************************************'          
              DISPLAY '*** 0100-INITIALIZATION               '          
              DISPLAY '*** ERROR ON FCSCA359 OPEN         ***'          
              DISPLAY '*** FILE STATUS IS ' WS-FCA359-STATUS            
              DISPLAY '*** PCSCA359 PROCESSING TERMINATED ***'          
              PERFORM 9900-ABEND                  THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                 02070000
           PERFORM 7500-READ-FCSCA359             THRU 7500-EXIT.       
      *                                                                 02070000
       0100-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************02477800
      *1000-LOAD-RTP.                                                  *02477900
      *  FORMAT THE INFORMATION AVAILABLE FROM INPUT RECORD FOR ALL    *02478000
      *  ROWS IN INTERNAL TABLE AND THEN READ THE NEXT RECORD FROM     *02479000
      *  INPUT FILE.                                                   *02480000
      ******************************************************************02690000
       1000-LOAD-RTP.                                                   
      *                                                                         
           MOVE E-FIOCA359-RATE-PLAN-NO            TO J3-RATE-PLAN-NO   
                                                      RT-RATE-PLAN-NO.  
           PERFORM 1100-FORMAT-CSS-RTP-DETAIL      THRU 1100-EXIT.      
      *                                                                         
      *    ADDITIONAL RATE PLAN NOS FROM THE INPUT FILE WILL BE                 
      *    INSERTED INTO CSS_RTP_DETAIL WITH THE SAME PRICE AND HOUR            
      *                                                                         
           IF E-FIOCA359-ADDL-RATE-PLAN-NO-1 > SPACES                   
              MOVE E-FIOCA359-ADDL-RATE-PLAN-NO-1  TO J3-RATE-PLAN-NO   
                                                      RT-RATE-PLAN-NO   
              PERFORM 1100-FORMAT-CSS-RTP-DETAIL   THRU 1100-EXIT       
           END-IF.                                                      
                                                                        
           IF E-FIOCA359-ADDL-RATE-PLAN-NO-2 > SPACES                   
              MOVE E-FIOCA359-ADDL-RATE-PLAN-NO-2  TO J3-RATE-PLAN-NO   
                                                      RT-RATE-PLAN-NO   
              PERFORM 1100-FORMAT-CSS-RTP-DETAIL   THRU 1100-EXIT       
           END-IF.                                                      
                                                                        
           IF E-FIOCA359-ADDL-RATE-PLAN-NO-3 > SPACES                   
              MOVE E-FIOCA359-ADDL-RATE-PLAN-NO-3  TO J3-RATE-PLAN-NO   
                                                      RT-RATE-PLAN-NO   
              PERFORM 1100-FORMAT-CSS-RTP-DETAIL   THRU 1100-EXIT       
           END-IF.                                                      
      *                                                                 03080000
           INITIALIZE DCLCSS-RTP-DETAIL                                 
                      DCLCSS-RATE-CREATOR.                              
      *                                                                 03080000
           PERFORM 7500-READ-FCSCA359              THRU 7500-EXIT.      
      *                                                                 03080000
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************03110000
      *1100-FORMAT-CSS-RTP-DETAIL. *                                    03170000
      * VERSION NUMBER WILL BE FETCHED FROM CSS_RATE_CREATOR FOR                
      * GIVEN RATE AND VALUES WILL BE MOVED TO TABLE VARIABLES.                 
      * ROWS WILL BE INSERTED/UPDATED INTO CSS_RTP_DETAIL TABLE.                
      ******************************************************************03160000
       1100-FORMAT-CSS-RTP-DETAIL.                                      
      *                                                                 03180000
           INITIALIZE                          WS-RTP-PRICE-AMT         
                                               WS-SIGN-RTP-PRICE-AMT.   
           MOVE WS-E                        TO J3-CODE-UTIL-TYPE.       
           MOVE E-FIOCA359-CMPNT-ID-CD      TO J3-CMPNT-ID-CD.          
           MOVE E-FIOCA359-PRICE-TYPE       TO J3-CODE-USE-INST-TYPE.   
           MOVE E-FIOCA359-PRICE-DT-YY      TO J3-PRICE-APPLIES-DT(1:4).
           MOVE '-'                         TO J3-PRICE-APPLIES-DT(5:1).
           MOVE E-FIOCA359-PRICE-DT-MM      TO J3-PRICE-APPLIES-DT(6:2).
           MOVE '-'                         TO J3-PRICE-APPLIES-DT(8:1).
           MOVE E-FIOCA359-PRICE-DT-DD      TO J3-PRICE-APPLIES-DT(9:2).
      *                                                                 03180000
           MOVE J3-PRICE-APPLIES-DT         TO RT-FROM-EFFECTIVE-DT.    
           PERFORM 7400-GET-CURRENT-VERSION THRU 7400-EXIT.             
           MOVE RT-VERSION-NO-CNTRL         TO J3-VERSION-NO-CNTRL.     
      *                                                                 03180000
           MOVE E-FIOCA359-RTP-PRICE-AMT    TO WS-RTP-PRICE-AMT.        
           IF E-FIOCA359-RTP-PRICE-SIGN = '-'                           
              COMPUTE WS-SIGN-RTP-PRICE-AMT  = -1 * WS-RTP-PRICE-AMT    
           ELSE                                                         
              COMPUTE WS-SIGN-RTP-PRICE-AMT  =  WS-RTP-PRICE-AMT        
           END-IF.                                                      
           MOVE WS-SIGN-RTP-PRICE-AMT       TO J3-RTP-PRICE-AMT.        
      *                                                                 03190000
      * IF THE PRICE HOUR IS AVAILABLE ROW WILL BE INSERTED FOR THAT    03190000
      * HOUR ELSE EACH HOUR OF THE DAY WILL HAVE PRICE FOR THAT RATE    03190000
      * SO TOTALLY 24 ROWS HAVE TO BE INSERTED INTO CSS_RTP_DETAIL TABLE02710000
      *                                                                 03190000
           IF E-FIOCA359-PRICE-HOUR > SPACES AND                        
              E-FIOCA359-PRICE-HOUR NOT EQUAL 'NA'                      
              IF E-FIOCA359-PRICE-HOUR = '00'                           
                 MOVE  '24'                 TO E-FIOCA359-PRICE-HOUR    
              END-IF                                                    
              MOVE E-FIOCA359-PRICE-HOUR    TO WS-PRICE-HOUR-CHAR       
              MOVE WS-PRICE-HOUR-NUM        TO J3-PRICE-APPLIES-HR      
              PERFORM 8000-INSERT-CSS-RTP-DETAIL          THRU 8000-EXIT
              IF WS-ACTIVE-RETURN-CODE =  ALREADY-EXISTS                
                 PERFORM 8010-UPDATE-CSS-RTP-DETAIL       THRU 8010-EXIT
              END-IF                                                    
           ELSE                                                         
              COMPUTE WS-PRICE-HOUR = 0                                 
              PERFORM UNTIL WS-PRICE-HOUR >= 24                         
                   ADD +1  TO WS-PRICE-HOUR                             
                   MOVE WS-PRICE-HOUR       TO J3-PRICE-APPLIES-HR      
                   PERFORM 8000-INSERT-CSS-RTP-DETAIL     THRU 8000-EXIT
                   IF WS-ACTIVE-RETURN-CODE =  ALREADY-EXISTS           
                      PERFORM 8010-UPDATE-CSS-RTP-DETAIL  THRU 8010-EXIT
                   END-IF                                               
              END-PERFORM                                               
           END-IF.                                                      
           DISPLAY 'RATE PROCESSED:'                                    
                   ' RT PLAN '       J3-RATE-PLAN-NO                    
                   ' VER NO '        J3-VERSION-NO-CNTRL                
                   ' PRICE APPL DT ' J3-PRICE-APPLIES-DT                
                   ' PRICE AMT '     J3-RTP-PRICE-AMT.                  
      *                                                                 03180000
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05060000
      *7400-GET-CURRENT-VERSION.                                       *05070000
      ******************************************************************05060000
       7400-GET-CURRENT-VERSION.                                        
                                                                        
           EXEC SQL                                                     
                SELECT RT.VERSION_NO_CNTRL                              
                INTO :RT-VERSION-NO-CNTRL                               
                FROM   CSS_RATE_CREATOR    RT WITH(READUNCOMMITTED)             
                WHERE  RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO          
                  AND  RT.CODE_STATUS       IN ('A','F')                
                  AND  RT.CODE_UTIL_TYPE    = 'E'                       
                  AND  RT.FROM_EFFECTIVE_DT =                           
                     (SELECT MAX (RT2.FROM_EFFECTIVE_DT)                
                        FROM CSS_RATE_CREATOR RT2 WITH(READUNCOMMITTED)         
                        WHERE  RT2.RATE_PLAN_NO = RT.RATE_PLAN_NO       
                          AND  RT2.CODE_STATUS       IN ('A','F')       
                          AND  RT2.CODE_UTIL_TYPE    = 'E'              
                          AND  RT2.FROM_EFFECTIVE_DT                    
                                  <= IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) ))             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05080000
MFA-TR*         SELECT RT.VERSION_NO_CNTRL                              05090000
MFA-TR*         INTO :RT-VERSION-NO-CNTRL                               05100000
MFA-TR*         FROM   CSS_RATE_CREATOR    RT                           05110000
MFA-TR*         WHERE  RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO          05120000
MFA-TR*           AND  RT.CODE_STATUS       IN ('A','F')                05130000
MFA-TR*           AND  RT.CODE_UTIL_TYPE    = 'E'                       05140000
MFA-TR*           AND  RT.FROM_EFFECTIVE_DT =                           05150000
MFA-TR*              (SELECT MAX (RT2.FROM_EFFECTIVE_DT)                05160000
MFA-TR*                 FROM CSS_RATE_CREATOR RT2                       05170000
MFA-TR*                 WHERE  RT2.RATE_PLAN_NO = RT.RATE_PLAN_NO       05180000
MFA-TR*                   AND  RT2.CODE_STATUS       IN ('A','F')       05190000
MFA-TR*                   AND  RT2.CODE_UTIL_TYPE    = 'E'              05200000
MFA-TR*                   AND  RT2.FROM_EFFECTIVE_DT                    05210000
MFA-TR*                           <= :RT-FROM-EFFECTIVE-DT)             05220000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                    05230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7400-GET-CURRENT-VERSION              '          
              DISPLAY '*** ACTIVE RATE NOT FOUND          ***'          
              DISPLAY '*** SQL CODE IS ' SQLCODE                        
              DISPLAY '*** RATE PLAN = ' RT-RATE-PLAN-NO                
              DISPLAY '*** EFF  DATE = ' RT-FROM-EFFECTIVE-DT           
              DISPLAY '*** PCSCA359 PROCESSING TERMINATED ***'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 05350000
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05380000
      *7500-READ-FCSCA359.                                             *05430000
      *  READ THE INPUT REAL TIME PRICING FILE.                        *05400000
      ******************************************************************05420000
       7500-READ-FCSCA359.                                              
      *                                                                 05440000
           READ FCSCA359-FILE.                                          
           ADD 1 TO WS-359-READ-CNTR.                                   
      *                                                                 05460000
           EVALUATE TRUE                                                
           WHEN FCA359-SUCCESSFUL                                       
              CONTINUE                                                  
           WHEN FCA359-EOF                                              
              CONTINUE                                                  
           WHEN OTHER                                                   
              DISPLAY '7500-READ-FCSCA359                    '          
              DISPLAY '*** ERROR ON FCSCA221 READ         ***'          
              DISPLAY '*** FILE STATUS IS ' WS-FCA359-STATUS            
              DISPLAY '*** PCSCA359 PROCESSING TERMINATED ***'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-EVALUATE.                                                
      *                                                                 05560000
       7500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06097000
      *8000-INSERT-CSS-RTP-DETAIL.                                     *06100000
      *  INSERT THE REAL TIME PRICING INFORMATION INTO CSS_RTP_DETAIL  *06110000
      ******************************************************************06130000
       8000-INSERT-CSS-RTP-DETAIL.                                      
      *                                                                 06150000
           EXEC SQL                                                     
                INSERT INTO CSS_RTP_DETAIL                              
                         (CODE_UTIL_TYPE,                               
                          RATE_PLAN_NO,                                 
                          VERSION_NO_CNTRL,                             
                          CMPNT_ID_CD,                                  
                          CODE_USE_INST_TYPE,                           
                          PRICE_APPLIES_HR,                             
                          PRICE_APPLIES_DT,                             
                          RTP_PRICE_AMT)                                
                VALUES                                                  
                         (:J3-CODE-UTIL-TYPE,                           
                          :J3-RATE-PLAN-NO,                             
                          :J3-VERSION-NO-CNTRL,                         
                          :J3-CMPNT-ID-CD,                              
                          :J3-CODE-USE-INST-TYPE,                       
                          :J3-PRICE-APPLIES-HR,                         
                          IIF(TRY_CONVERT(DATE, :J3-PRICE-APPLIES-DT
              ) IS NULL OR (PATINDEX('%.%', :J3-PRICE-APPLIES-DT
              ) <> 0) OR (LEN(:J3-PRICE-APPLIES-DT
              ) <> 10), CIS.CHAR2DATE(:J3-PRICE-APPLIES-DT
              ), CONVERT(DATE, :J3-PRICE-APPLIES-DT) ),                        
                          :J3-RTP-PRICE-AMT)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06160000
MFA-TR*         INSERT INTO CSS_RTP_DETAIL                              06170000
MFA-TR*                  (CODE_UTIL_TYPE,                               06180000
MFA-TR*                   RATE_PLAN_NO,                                 06190000
MFA-TR*                   VERSION_NO_CNTRL,                             06200000
MFA-TR*                   CMPNT_ID_CD,                                  06210000
MFA-TR*                   CODE_USE_INST_TYPE,                           06220000
MFA-TR*                   PRICE_APPLIES_HR,                             06230000
MFA-TR*                   PRICE_APPLIES_DT,                             06240000
MFA-TR*                   RTP_PRICE_AMT)                                06250000
MFA-TR*         VALUES                                                  06260000
MFA-TR*                  (:J3-CODE-UTIL-TYPE,                           06270000
MFA-TR*                   :J3-RATE-PLAN-NO,                             06280000
MFA-TR*                   :J3-VERSION-NO-CNTRL,                         06290000
MFA-TR*                   :J3-CMPNT-ID-CD,                              06300000
MFA-TR*                   :J3-CODE-USE-INST-TYPE,                       06310000
MFA-TR*                   :J3-PRICE-APPLIES-HR,                         06320000
MFA-TR*                   :J3-PRICE-APPLIES-DT,                         06330000
MFA-TR*                   :J3-RTP-PRICE-AMT)                            06340000
MFA-TR*    END-EXEC.                                                    06350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06360000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              ADD      +1                TO WS-INSERT-COUNT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                 
                  CONTINUE                                              
              ELSE                                                      
                  DISPLAY '8000-CSS-RTP-DETAIL                   '      
                  DISPLAY '*** ERROR IN INSERT                ***'      
                  DISPLAY '*** SQL CODE IS '  WS-ACTIVE-RETURN-CODE     
                  DISPLAY '*** RATE PLAN  = ' J3-RATE-PLAN-NO           
                  DISPLAY '*** VERSION NO = ' J3-VERSION-NO-CNTRL       
                  DISPLAY '*** UTIL TYPE  = ' J3-CODE-UTIL-TYPE         
                  DISPLAY '*** PCSCA359 PROCESSING TERMINATED ***'      
                  DISPLAY '*****************************'               
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
               END-IF                                                   
           END-IF.                                                      
      *                                                                 06460000
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06481000
      * 8010-UPDATE-CSS-RTP-DETAIL.                                    *06482000
      *  UPDATE THE REAL TIME PRICING INFORMATION INTO CSS_RTP_DETAIL  *06483000
      ******************************************************************06485000
       8010-UPDATE-CSS-RTP-DETAIL.                                      
      *                                                                 06487000
           EXEC SQL                                                     
                UPDATE CSS_RTP_DETAIL                                   
                SET  RTP_PRICE_AMT       = :J3-RTP-PRICE-AMT            
                WHERE                                                   
                     CODE_UTIL_TYPE      = :J3-CODE-UTIL-TYPE           
                 AND RATE_PLAN_NO        = :J3-RATE-PLAN-NO             
                 AND VERSION_NO_CNTRL    = :J3-VERSION-NO-CNTRL         
                 AND CMPNT_ID_CD         = :J3-CMPNT-ID-CD              
                 AND CODE_USE_INST_TYPE  = :J3-CODE-USE-INST-TYPE       
                 AND PRICE_APPLIES_HR    = :J3-PRICE-APPLIES-HR         
                 AND PRICE_APPLIES_DT    = IIF(TRY_CONVERT(DATE, 
                                                   :J3-PRICE-APPLIES-DT
              ) IS NULL OR (PATINDEX('%.%', :J3-PRICE-APPLIES-DT
              ) <> 0) OR (LEN(:J3-PRICE-APPLIES-DT
              ) <> 10), CIS.CHAR2DATE(:J3-PRICE-APPLIES-DT
              ), CONVERT(DATE, :J3-PRICE-APPLIES-DT) )         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06488000
MFA-TR*         UPDATE CSS_RTP_DETAIL                                   06489000
MFA-TR*         SET  RTP_PRICE_AMT       = :J3-RTP-PRICE-AMT            06489100
MFA-TR*         WHERE                                                   06489900
MFA-TR*              CODE_UTIL_TYPE      = :J3-CODE-UTIL-TYPE           06490100
MFA-TR*          AND RATE_PLAN_NO        = :J3-RATE-PLAN-NO             06490200
MFA-TR*          AND VERSION_NO_CNTRL    = :J3-VERSION-NO-CNTRL         06490300
MFA-TR*          AND CMPNT_ID_CD         = :J3-CMPNT-ID-CD              06490400
MFA-TR*          AND CODE_USE_INST_TYPE  = :J3-CODE-USE-INST-TYPE       06490500
MFA-TR*          AND PRICE_APPLIES_HR    = :J3-PRICE-APPLIES-HR         06490600
MFA-TR*          AND PRICE_APPLIES_DT    = :J3-PRICE-APPLIES-DT         06490700
MFA-TR*          QUERYNO 8010                                                   
MFA-TR*    END-EXEC.                                                    06490900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06491000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              ADD     +1                 TO WS-UPDATE-COUNT             
           ELSE                                                         
              DISPLAY '8010-UPDATE-CSS-RTP-DETAIL           '           
              DISPLAY '*** ERROR IN UPDATE               ***'           
              DISPLAY '*** SQL CODE IS ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '*** RATE PLAN  =' J3-RATE-PLAN-NO                
              DISPLAY '*** VERSION NO =' J3-VERSION-NO-CNTRL            
              DISPLAY '*** UTIL TYPE  =' J3-CODE-UTIL-TYPE              
              DISPLAY '*** PCSCA359 PROCESSING TERMINATED ***'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 06492100
       8010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06570000
      *9000-TERMINATE.                                                 *06580000
      * CLOSE ALL THE FILES OPENED.                                    *06590000
      ******************************************************************06610000
       9000-TERMINATE.                                                  
      *                                                                 06630000
           CLOSE FCSCA359-FILE.                                         
      *                                                                 06660000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06660000
      ****************************************************************          
      **    9900-ABEND                                              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
