       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA353.                                      
       AUTHOR.       VISHAL VELUSAMY.                                   
COB303 DATE-WRITTEN.     SEP 07, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              P R O G R A M  S U M M A R Y                  ***        
      ***------------------------------------------------------------***        
      ******************************************************************        
      *** GENERATE A REPORT FOR CORRESP HDR EXCEPTION DETAILS AND    ***        
      *** REPORT TO FIND EXCEPTIONS FROM POST-BILLING CREDIT.        ***        
      *----------------------------------------------------------------*        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      ***                    MODIFICATION LOG                        ***        
      ***------------------------------------------------------------***        
      ***                                                            ***        
      ***  DATE          INITIALS    COMMENTS                        ***        
      ***  -----------   --------    --------------------------------***        
ACT019***  09/07/2015    VV7M728     CSR342 & CSR353 EZTR TO COBOL   ***        
      ***------------------------------------------------------------***        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSPT80.                                                            
       COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      ***************************************************************           
      *    FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
       COPY CFDPT80.                                                            
       COPY CFDPT331.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA353'.
MSQ017     COPY MFASQLM.
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CORRESP_HDR                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCORHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_JOB_PARM                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_COMPANY                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCOMPNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT                                                 *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILLING_HDR                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      * FIOJC01 - IO AREA FOR PARAMETER INPUT FILE 'A'                *         
      *****************************************************************         
      *                                                                         
           COPY FIOJC01.                                                        
      *****************************************************************         
      * ABEND SWITCH COPYBOOK                                         *         
      *****************************************************************         
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
      *****************************************************************         
      ******************************************************************        
      * COPYBOOKS                                                               
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM-NAME           PIC X(08) VALUE 'PCSCA353'.     
                                                                        
       01 WS-OUTFILE1-HDR.                                              
           05 FILLER                   PIC X(01) VALUE SPACES.          
           05 WS-HDR-ACCOUNT-NO        PIC X(10) VALUE 'ACCOUNT NO'.    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-CUSTOMER-NO       PIC X(11) VALUE 'CUSTOMER NO'.   
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-CORRESP-MSG-ID    PIC X(14) VALUE 'CORRESP MSG ID'.
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-CORRESP-STMT-DT  PIC X(15) VALUE 'CORRESP STMT DT'.
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-CREATED-BY-PGM-ID PIC X(14) VALUE 'CREATED PGM ID'.
           05 FILLER                   PIC X(64) VALUE SPACES.          
                                                                        
       01 WS-OUTFILE1.                                                  
           05 FILLER                    PIC X(01) VALUE SPACES.         
           05 WS-OUT-ACCOUNT-NO         PIC X(13) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT-CUSTOMER-NO        PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT-CORRESP-MSG-ID     PIC X(05) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT-CORRESP-STMT-DT    PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT-CREATED-BY-PGM-ID  PIC X(08) VALUE SPACES.         
           05 FILLER                    PIC X(82) VALUE SPACES.         
                                                                        
       01 WS-OUTFILE2-HDR.                                              
           05 WS-HDR-ACCT-NO           PIC X(10) VALUE 'ACCOUNT NO'.    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-DATE-BILLED       PIC X(11) VALUE 'DATE BILLED'.   
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-CREDIT-GRP        PIC X(10) VALUE 'CREDIT GRP'.    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-COMPANY-NO        PIC X(10) VALUE 'COMPANY NO'.    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-BILL-CYCLE        PIC X(10) VALUE 'BILL CYCLE'.    
           05 FILLER                   PIC X(01) VALUE ','.             
           05 WS-HDR-ACCT-TYPE-CD      PIC X(12) VALUE 'ACCT TYPE CD'.  
           05 FILLER                   PIC X(12) VALUE SPACES.          
                                                                        
       01 WS-OUTFILE2.                                                  
           05 WS-OUT2-ACCOUNT-NO        PIC X(13) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT2-DATE-BILLED       PIC X(10) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT2-CREDIT-GROUP      PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT2-COMPANY-NO        PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT2-BILL-CYCLE        PIC X(02) VALUE SPACES.         
           05 FILLER                    PIC X(01) VALUE ','.            
           05 WS-OUT2-ACCOUNT-TYPE-CODE PIC X(01) VALUE SPACES.         
           05 FILLER                    PIC X(46) VALUE SPACES.         
                                                                        
       01  WS-SWITCH.                                                   
           05  WS-FPT80-STATUS          PIC X(02).                      
               88 FPT80-SUCCESSFUL                VALUE '00'.           
           05  WS-FCA331-STATUS         PIC X(02).                      
               88 FCA331-SUCCESSFUL               VALUE '00'.           
                                                                        
       01 WS-MISC.                                                      
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
           05  WS-PGRMNAME              PIC X(08) VALUE 'PCSCA353'.     
           05  WS-COMPANY-NAME          PIC X(26) VALUE SPACES.         
           05  WS-CORRESP-STAT-CD       PIC X(01) VALUE SPACES.         
           05  WS-ALL-ROWS-PROCESD      PIC X(01) VALUE SPACES.         
           05  WS-ALL-ROWS-PROCESSD     PIC X(01) VALUE SPACES.         
           05  WS-ACCOUNT-NO-NULL       PIC S9(04) COMP.                
           05  WS-COMM-DATE             PIC X(10) VALUE SPACES.         
           05  WS-COMMON-DT             PIC X(10) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-COMMON-DATE.                                              
           05 WS-COMMON-CCYY            PIC X(04) VALUE SPACES.         
           05 FILLER                    PIC X(01).                      
           05 WS-COMMON-MM              PIC X(02) VALUE SPACES.         
      *                                                                         
      ***************************************************************           
      * CURSOR FOR SELECTS CORRESP DTLS BASED ON                    *           
      * CORRESP STATUS CD AND STMT DATE                             *           
      ***************************************************************           
                                                                        
            EXEC SQL                                                    
              DECLARE CORRESP_HDRDTLS CURSOR WITH HOLD FOR              
                 SELECT C.ACCOUNT_NO                                    
                       ,C.CUSTOMER_NO                                   
                       ,C.CORRESP_MSG_ID                                
                       ,C.CORRESP_STMT_DT                               
                       ,C.CREATED_BY_PGM_ID                             
                   FROM CSS_CORRESP_HDR C WITH(READUNCOMMITTED)                 
                  WHERE C.CORRESP_STMT_DT   <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-COMMON-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DT
              ) <> 0) OR (LEN(:WS-COMMON-DT) <> 10), CIS.CHAR2DATE(
                                                          :WS-COMMON-DT
              ), CONVERT(DATE, :WS-COMMON-DT) )            
                    AND C.CORRESP_STATUS_CD  = 'X'                      
                    FOR READ ONLY                               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE CORRESP_HDRDTLS CURSOR WITH HOLD FOR                      
MFA-TR*          SELECT C.ACCOUNT_NO                                            
MFA-TR*                ,C.CUSTOMER_NO                                           
MFA-TR*                ,C.CORRESP_MSG_ID                                        
MFA-TR*                ,C.CORRESP_STMT_DT                                       
MFA-TR*                ,C.CREATED_BY_PGM_ID                                     
MFA-TR*            FROM CSS_CORRESP_HDR C                                       
MFA-TR*           WHERE C.CORRESP_STMT_DT   <= :WS-COMMON-DT                    
MFA-TR*             AND C.CORRESP_STATUS_CD  = 'X'                              
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*     END-EXEC.                                                           
                                                                        
      ***************************************************************           
      * CURSOR FOR SELECTS CORRESP DTLS BASED ON                    *           
      * CORRESP STATUS CD AND STMT DATE                             *           
      ***************************************************************           
                                                                        
            EXEC SQL                                                    
              DECLARE GET_ACCT CURSOR WITH HOLD FOR                     
                 SELECT AT.ACCOUNT_NO,                                  
                         AT.CREDIT_GROUP,                               
                         AT.COMPANY_NO,                                 
                         AT.BILL_CYCLE,                                 
                         BI.DATE_BILLED,                                
                         AT.ACCOUNT_TYPE_CODE                           
                         FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),             
                              CSS_BILLING_HDR BI WITH(READUNCOMMITTED)          
                  WHERE AT.ACCOUNT_NO = BI.ACCOUNT_NO                   
                    AND BI.DATE_BILLED > (DATEADD( DAY, -10, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))       
                    AND BILL_NO =                                       
                        (SELECT MAX(BILL_NO)                            
                         FROM CSS_BILLING_HDR B WITH(READUNCOMMITTED)           
                         WHERE B.ACCOUNT_NO = BI.ACCOUNT_NO             
                           AND B.DATE_BILLED > (DATEADD( DAY, -10, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )))
                           AND NOT EXISTS (SELECT A.ACCOUNT_NO          
                                     FROM CSS_BILL_CRED_DET A
                           WITH(READUNCOMMITTED)           
                                     WHERE A.ACCOUNT_NO = BI.ACCOUNT_NO 
                                       AND A.BILL_NO = BI.BILL_NO)      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE GET_ACCT CURSOR WITH HOLD FOR                             
MFA-TR*          SELECT AT.ACCOUNT_NO,                                          
MFA-TR*                  AT.CREDIT_GROUP,                                       
MFA-TR*                  AT.COMPANY_NO,                                         
MFA-TR*                  AT.BILL_CYCLE,                                         
MFA-TR*                  BI.DATE_BILLED,                                        
MFA-TR*                  AT.ACCOUNT_TYPE_CODE                                   
MFA-TR*                  FROM CSS_ACCOUNT AT,                                   
MFA-TR*                       CSS_BILLING_HDR BI                                
MFA-TR*           WHERE AT.ACCOUNT_NO = BI.ACCOUNT_NO                           
MFA-TR*             AND BI.DATE_BILLED > (CURRENT DATE - 10 DAYS)               
MFA-TR*             AND BILL_NO =                                               
MFA-TR*                 (SELECT MAX(BILL_NO)                                    
MFA-TR*                  FROM CSS_BILLING_HDR B                                 
MFA-TR*                  WHERE B.ACCOUNT_NO = BI.ACCOUNT_NO                     
MFA-TR*                    AND B.DATE_BILLED > (CURRENT DATE - 10 DAYS))        
MFA-TR*                    AND NOT EXISTS (SELECT A.ACCOUNT_NO                  
MFA-TR*                              FROM CSS_BILL_CRED_DET A                   
MFA-TR*                              WHERE A.ACCOUNT_NO = BI.ACCOUNT_NO         
MFA-TR*                                AND A.BILL_NO = BI.BILL_NO)              
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           
                                                                        
      ***************************************************************           
       PROCEDURE DIVISION.                                              
      ***************************************************************           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                  THRU  0100-EXIT.    
           PERFORM 1300-GET-COMMON-DATE             THRU  1300-EXIT.    
           PERFORM 7200-GET-COMPANY-NAME            THRU  7200-EXIT.    
           PERFORM 1100-PROCESS-HDR-EXCP-DTLS       THRU  1100-EXIT.    
           PERFORM 1200-POST-BILLING                THRU  1200-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE.                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           OPEN OUTPUT FCSPT80-FILE.                                    
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT80-FILE     **'          
               DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
      *INITIALIZE THE FILE VARAIABLES AFTER WRITING THE HEADER RECORD           
           INITIALIZE PRT80-RECORD                                      
                      PRT331-RECORD.                                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1100-PROCESS-HDR-EXCP-DTLS.                                  **        
      ******************************************************************        
      *                                                                         
       1100-PROCESS-HDR-EXCP-DTLS.                                      
      *                                                                         
             PERFORM 7300-OPEN-CORRESP-HDRDTLS      THRU  7300-EXIT     
             PERFORM 7400-FETCH-CORRESP-HDRDTLS     THRU  7400-EXIT     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                PERFORM 8100-WRITE-OUTFILE1-HEADER  THRU  8100-EXIT     
             END-IF                                                     
             PERFORM 2200-CORRESP-HDRDTLS           THRU  2200-EXIT     
                UNTIL WS-ALL-ROWS-PROCESD = WS-Y                        
             PERFORM 7500-CLOSE-CORRESP-HDRDTLS     THRU  7500-EXIT.    
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1200-POST-BILLING.                                           **        
      ******************************************************************        
      *                                                                         
       1200-POST-BILLING.                                               
      *                                                                         
            PERFORM 7605-OPEN-GET-ACCT              THRU  7605-EXIT.    
            PERFORM 7700-FETCH-GET-ACCT             THRU  7700-EXIT.    
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 8200-WRITE-OUTFILE2-HEADER   THRU  8200-EXIT     
            END-IF.                                                     
            PERFORM 2300-POST-BILLING-CREDIT        THRU  2300-EXIT     
               UNTIL WS-ALL-ROWS-PROCESSD = WS-Y.                       
            PERFORM 7800-CLOSE-GET-ACCT             THRU  7800-EXIT.    
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1300-GET-COMMON-DATE                                         **        
      ******************************************************************        
      *                                                                         
       1300-GET-COMMON-DATE.                                            
      *                                                                         
           MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN.   
      **********CALLING THE COPYBOOK CPD00037 USING WS-PGRMNAME.                
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           MOVE WS-INPUT-DATE(1:4)        TO WS-COMMON-CCYY.            
           MOVE WS-INPUT-DATE(6:2)        TO WS-COMMON-MM.              
      **********CALLING THE COPYBOOK CPD00037 USING COMMON.                     
           IF WS-OVERRIDE-DATE-SW = WS-N                                
              MOVE SPACES                 TO WS-INPUT-DATA-BREAKDOWN    
              MOVE 'COMMON'               TO WS-PGRMNAME                
              PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT          
              MOVE WS-INPUT-DATE(1:4)     TO WS-COMMON-CCYY             
              MOVE WS-INPUT-DATE(6:2)     TO WS-COMMON-MM               
           END-IF.                                                      
           MOVE WS-COMMON-DATE            TO WS-COMM-DATE               
           MOVE WS-INPUT-DATE(6:2)        TO WS-COMMON-DT(1:2)          
           MOVE '/'                       TO WS-COMMON-DT(3:1)          
           MOVE WS-INPUT-DATE(9:2)        TO WS-COMMON-DT(4:2)          
           MOVE '/'                       TO WS-COMMON-DT(6:1)          
           MOVE WS-INPUT-DATE(1:4)        TO WS-COMMON-DT(7:4)          
           .                                                            
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2200-CORRESP-HDRDTLS.                                       **        
      ******************************************************************        
      *                                                                         
       2200-CORRESP-HDRDTLS.                                            
      *                                                                         
            MOVE 1J-ACCOUNT-NO          TO WS-OUT-ACCOUNT-NO.           
            MOVE 1J-CUSTOMER-NO         TO WS-OUT-CUSTOMER-NO.          
            MOVE 1J-CORRESP-MSG-ID      TO WS-OUT-CORRESP-MSG-ID.       
            MOVE 1J-CORRESP-STMT-DT     TO WS-OUT-CORRESP-STMT-DT.      
            MOVE 1J-CREATED-BY-PGM-ID   TO WS-OUT-CREATED-BY-PGM-ID.    
                                                                        
           PERFORM 8300-WRITE-OUTFILE1              THRU  8300-EXIT.    
           PERFORM 7400-FETCH-CORRESP-HDRDTLS       THRU  7400-EXIT.    
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33591000
      ******************************************************************        
      **  2300-POST-BILLING-CREDIT.                                   **        
      ******************************************************************        
      *                                                                         
       2300-POST-BILLING-CREDIT.                                        
      *                                                                         
            MOVE AT-ACCOUNT-NO          TO WS-OUT2-ACCOUNT-NO.          
            MOVE AT-CREDIT-GROUP        TO WS-OUT2-CREDIT-GROUP.        
            MOVE AT-COMPANY-NO          TO WS-OUT2-COMPANY-NO.          
            MOVE AT-BILL-CYCLE          TO WS-OUT2-BILL-CYCLE.          
            MOVE BI-DATE-BILLED         TO WS-OUT2-DATE-BILLED.         
            MOVE AT-ACCOUNT-TYPE-CODE   TO WS-OUT2-ACCOUNT-TYPE-CODE.   
                                                                        
           PERFORM 8400-WRITE-OUTFILE2              THRU  8400-EXIT.    
           PERFORM 7700-FETCH-GET-ACCT              THRU  7700-EXIT.    
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33591000
      ****************************************************************          
      * 6251-GET-FJC01-DATE.                                         *          
      ****************************************************************          
       COPY CPD00037.                                                           
      *                                                                         
      ******************************************************************        
      **  7200-GET-COMPANY-NAME.                                      **        
      ** GET COMPANY NAME FROM CSS_COMPANY                            **        
      ******************************************************************        
      *                                                                         
       7200-GET-COMPANY-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT B.COMPANY_NAME                                     
                INTO :WS-COMPANY-NAME                                   
                FROM CSS_COMPANY B WITH(READUNCOMMITTED)                        
               WHERE B.COMPANY_NO = '01'                                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT B.COMPANY_NAME                                             
MFA-TR*         INTO :WS-COMPANY-NAME                                           
MFA-TR*         FROM CSS_COMPANY B                                              
MFA-TR*        WHERE B.COMPANY_NO = '01'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT *******'                 
              DISPLAY '**  COMPANY NME FETCH FAILED **'                 
              DISPLAY '**  7200-GET-COMPANY-NAME    **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '****PROCESSING TERMINATED******'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7300-OPEN-CORRESP-HDRDTLS.                                   **        
      ******************************************************************        
      *                                                                         
       7300-OPEN-CORRESP-HDRDTLS.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN CORRESP_HDRDTLS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT  *******'                
              DISPLAY '**  OPEN CORRESP-HDRDTLS ERR  **'                
              DISPLAY '**  7300-OPEN-CORRESP_HDRDTLS **'                
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '****PROCESSING TERMINATED*******'                
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7400-FETCH-CORRESP-HDRDTLS.                                  **        
      ******************************************************************        
      *                                                                         
       7400-FETCH-CORRESP-HDRDTLS.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH CORRESP_HDRDTLS                                     
               INTO :1J-ACCOUNT-NO :WS-ACCOUNT-NO-NULL                 
                   ,:1J-CUSTOMER-NO                                     
                   ,:1J-CORRESP-MSG-ID                                  
                   ,:1J-CORRESP-STMT-DT                                 
                   ,:1J-CREATED-BY-PGM-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
                                                                        
           WHEN NOT-FOUND                                               
               MOVE 'Y'                   TO WS-ALL-ROWS-PROCESD        
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT *******'                 
              DISPLAY '** OPTION CURSOR FETCH ERROR **'                 
              DISPLAY '** 7400-FETCH-CORRESP-HDRDTLS**'                 
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** WS-COMMON-DATE' WS-COMMON-DT                  
              DISPLAY '** 1J-ACCOUNT-NO ' 1J-ACCOUNT-NO                 
              DISPLAY '** PROCESSING TERMINATED ******'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7500-CLOSE-CORRESP-HDRDTLS.                                            
      ******************************************************************        
      *                                                                         
       7500-CLOSE-CORRESP-HDRDTLS.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE CORRESP_HDRDTLS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT *********'               
              DISPLAY '**  CLOSE CORRESP_HDRDTLS ERR  **'               
              DISPLAY '**  7500-CLOSE-CORRESP-HDRDTLS **'               
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*** PROCESSING TERMINATED *******'               
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7600-START-FCSJC01                                           *          
      ****************************************************************          
      *                                                                         
            EXEC SQL                                                            
               INCLUDE CPD00038                                                 
            END-EXEC.                                                           
                                                                        
      *                                                                         
      ******************************************************************        
      ** 7605-OPEN-GET-ACCT.                                          **        
      ******************************************************************        
      *                                                                         
       7605-OPEN-GET-ACCT.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN GET_ACCT                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT *******'                 
              DISPLAY '**  OPEN GET_ACCT ERROR      **'                 
              DISPLAY '**  7600-OPEN-GET-ACCT       **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7605-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7700-FETCH-GET-ACCT.                                         **        
      ******************************************************************        
      *                                                                         
       7700-FETCH-GET-ACCT.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_ACCT                                            
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CREDIT-GROUP                                    
                   ,:AT-COMPANY-NO                                      
                   ,:AT-BILL-CYCLE                                      
                   ,:BI-DATE-BILLED                                     
                   ,:AT-ACCOUNT-TYPE-CODE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
                                                                        
           WHEN NOT-FOUND                                               
               MOVE 'Y'                   TO WS-ALL-ROWS-PROCESSD       
                                                                        
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT *******'                 
              DISPLAY '**  OPTION CURSOR FETCH ERROR**'                 
              DISPLAY '**  7700-FETCH-GET-ACCT      **'                 
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  BI-DATE-BILLED' BI-DATE-BILLED               
              DISPLAY '**  1J-ACCOUNT-NO ' 1J-ACCOUNT-NO                
              DISPLAY '*** PROCESSING TERMINATED *****'                 
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7800-CLOSE-GET-ACCT.                                                   
      ******************************************************************        
      *                                                                         
       7800-CLOSE-GET-ACCT.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_ACCT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                                                                        
           WHEN SUCCESSFUL-CALL                                         
               CONTINUE                                                 
           WHEN OTHER                                                   
              DISPLAY '******** PCSCA353 ABORT ******'                  
              DISPLAY '** CLOSE GET_ACCT ERROR     **'                  
              DISPLAY '** 7800-CLOSE-GET-ACCT      **'                  
              DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
              DISPLAY '** PROCESSING TERMINATED *****'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8100-WRITE-OUTFILE1-HEADER                                ** 08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8100-WRITE-OUTFILE1-HEADER.                                      
      *                                                                 08230000
      *WRITE THE HEADER RECORD                                                  
      *                                                                         
           WRITE PRT331-RECORD FROM WS-OUTFILE1-HDR.                    
      *                                                                 08335000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8200-WRITE-OUTFILE2-HEADER                               **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8200-WRITE-OUTFILE2-HEADER.                                      
      *                                                                 08230000
      *WRITE THE HEADER RECORD                                                  
      *                                                                         
           WRITE PRT80-RECORD  FROM WS-OUTFILE2-HDR.                    
      *                                                                 08335000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8300-WRITE-OUTFILE1                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8300-WRITE-OUTFILE1.                                             
      *                                                                 08230000
           WRITE PRT331-RECORD FROM WS-OUTFILE1.                        
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  FILE WRITE UNSUCCESSFUL         **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8400-WRITE-OUTFILE2                                      **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8400-WRITE-OUTFILE2.                                             
      *                                                                 08230000
           WRITE PRT80-RECORD  FROM WS-OUTFILE2.                        
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  FILE WRITE UNSUCCESSFUL         **'         
               DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08360000
      ****************************************************************  08150000
      **                                                            **  08160000
      **   8900-CLOSE-OUTFILE                                       **  08170000
      **                                                            **  08190000
      ****************************************************************  08200000
      *                                                                 08210000
       8900-CLOSE-OUTFILE.                                              
      *                                                                 08230000
           CLOSE FCSPT80-FILE.                                          
                                                                        
           IF NOT FPT80-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT80-FILE      **'         
               DISPLAY '**  FILE STATUS = ' WS-FPT80-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           CLOSE FCSPT331-FILE.                                         
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR CLOSING FCSPT331-FILE     **'         
               DISPLAY '**  FILE STATUS = ' WS-FCA331-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 08335000
       8900-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  08384100
      **                                                            **  08384200
      **   9000-TERMINATE                                           **  08384300
      **       CLOSES FILES AND TERMINATES THE PROGRAM              **  08384400
      **                                                            **  08384500
      ****************************************************************  08384600
      *                                                                 08384700
       9000-TERMINATE.                                                  
      *                                                                 08409300
           PERFORM 8900-CLOSE-OUTFILE               THRU  8900-EXIT.    
      *                                                                 08420000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08450000
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
