       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA350.                                        
       DATE-WRITTEN.   JAN 2010.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      *                   PROGRAM NARRATIVE                         **          
      *                                                             **          
      *                                                             **          
      *   THIS PROGRAM  RETRIEVES  TAX INFO FOR GAS WATER HEATER    **          
      *   CONTRACTS TO BE USED FOR REPORTING BY MUNICIPALITY CODE   **          
      *   AND REVENUE DISTRICT.                                     **          
      *                                                             **          
      ****************************************************************          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **    DATE    INITIALS     REASON                             **          
      **    ----    --------     ------                             **          
      **  01/05/10  SS42021     INITIAL VERSION FOR IDEA 835.       **          
      **  03/25/10  AA97148     MODIFIED TO ADD NEW PAYMNETS REPORT.**          
A02036**  03/25/10  DB41297     CHECK FOR CUSTOMER_ROLE_CD = SPACES **          
A04880**  05/09/14  DB41297     ADD NEW CONTRACT NAME CODE VALUES.  **          
      **                                                            **          
A04880**   7/2/14   RF10596     CREATE OUPUT FILE IN 8300 FORMAT    **          
      **                                                            **          
A04880**   7/2/14   RF10596     REMOVE ALL CODE THAT IS NOT DOING   **          
A04880**            RF10596     THE 8300 FILE FORMAT                **          
      **                                                            **          
A05460** 8 DEC 2016 RF10596     ADD GLS TO CURSOR                   **          
      **                                                            **          
      ****************************************************************          
      **             ---- BASIC BATCH SEQUENCE STRUCTURE ----       **          
      **            0000 - 0000     MAIN CONTROL PATH               **          
      **            0100 - 0100     INITIALIZATION                  **          
      **            1000 - 1000     MAJOR PROCESSING LOOP           **          
      **            1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR   **          
      **                            PROCESSING LOOPS                **          
      **            5000 - 5999     COMMON PROGRAM MODULES          **          
      **            6000 - 6999     COMMON SYSTEM MODULES           **          
      **            7000 - 7999     INPUT MODULES                   **          
      **            8000 - 8999     OUTPUT MODULES                  **          
      **            9000 - 9799     TERMINATION MODULES             **          
      **            9900 - 9999     ABEND/ABORT MODULES             **          
      **                  ---- PARAGRAPH STRUCTURE ----             **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
      *                                                                         
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
           COPY CSSCA233.                                                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
           COPY CFDCA233.                                                       
           COPY FIOCA233.                                                       
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA350'.
MSQ017     COPY MFASQLM.
      *                                                                         
A04880 01  WS-LITERALS.                                                 
A04880     05 WS-1ST-SW                PIC X    VALUE 'Y'.              
A04880     05 WS-ACTIVE                PIC X    VALUE 'A'.              
A04880     05 WS-G                     PIC X    VALUE 'G'.              
A04880     05 WS-CREDIT-C              PIC X    VALUE 'C'.              
A04880     05 WS-DEBIT-D               PIC X    VALUE 'D'.              
A04880     05 WS-GL-CNTRL-DR-CR        PIC X    VALUE SPACES.           
A04880     05 WS-COMPANY               PIC XX   VALUE '01'.             
A04880     05 WS-GL-ACCT-NO            PIC X(7).                        
A04880     05 WS-GL-ACCT-NO-NUM REDEFINES WS-GL-ACCT-NO                 
A04880                                 PIC 9(3)V9(4).                   
A04880     05 WS-SOURCE-SYSTEM         PIC X    VALUE 'B'.              
A04880     05 WS-TAX                   PIC X(3) VALUE 'TAX'.            
A04880     05 WS-COST-CENTER           PIC X(4) VALUE '0001'.           
A04880     05 WS-FUNCTION-CODE         PIC X(4) VALUE 'ACJV'.           
A04880     05 WS-NOE                   PIC X(3) VALUE '901'.            
A04880     05 WS-TRN-CODE              PIC X(4) VALUE '8300'.           
A04880     05 WS-ONE                   PIC 9    VALUE 1.                
A04880     05 WS-TWO                   PIC 9    VALUE 2.                
      *                                                                         
A04880 01  WS-A8300-DATE.                                               
A04880     05 WS-A8300-YEAR            PIC X(4).                        
A04880     05 FILLER                   PIC X   VALUE '-'.               
A04880     05 WS-A8300-MONTH           PIC XX.                          
A04880     05 FILLER                   PIC X   VALUE '-'.               
A04880     05 WS-A8300-DAY             PIC XX.                          
      *                                                                         
       01  WS-WORK-VARIABLE.                                            
A04880     05  WS-REVENUE-MONTH        PIC S9(6)V COMP-3 VALUE 0.       
A04880     05  WS-SAVE-SQLCODE         PIC S9(9)  COMP VALUE 0.         
A04880     05  WS-ELE-SALES-GL         PIC 9(3)V9999 VALUE 241.0111.    
A04880     05  WS-8300-CONTROL-AMOUNT  PIC S9(13)V99 COMP-3 VALUE 0.    
A04880     05  WS-CURSOR-AMOUNT        PIC S9(13)V99 COMP-3 VALUE 0.    
A04880     05  WS-LOCAL-OFFICE         PIC X(3)   VALUE SPACES.         
A04880     05  WS-REV-DISTRICT-CD      PIC X(3)   VALUE SPACES.         
A04880     05  WS-CONTROL-AMOUNT       PIC S9(13)V99 COMP-3 VALUE 0.    
      *                                                                         
       01  WS-PROG-MISC.                                                
A04880     05  WS-GL-BUSINESS-UNIT      PIC X(5)   VALUE SPACES.        
A04880     05  WS-GL-CUSTOMER-CD        PIC X(3)   VALUE SPACES.        
A04880     05  WS-GL-COST-CENTER        PIC X(4)   VALUE SPACES.        
A04880     05  WS-GL-OPERATING-UNIT     PIC X(4)   VALUE SPACES.        
A04880     05  WS-GL-PEOPLESOFT         PIC S9(3)V9(4) VALUE 0 COMP-3.  
A04880     05  WS-GL-COMPANY-IND        PIC XX     VALUE SPACES.        
A04880     05  WS-GL-ACTIVITY-CD        PIC X(4)   VALUE SPACES.        
A04880     05  WS-GL-RESOURCE-CD        PIC X(3)   VALUE SPACES.        
           05  WS-SYSTEM                PIC X(6)   VALUE 'SYSTEM'.      
           05  PROGRAM-NAME             PIC X(10)  VALUE 'PCSCA350'.    
           05  WS-PGRMNAME              PIC X(8)   VALUE 'PCSCA350'.    
           05  WS-CURRENT-TS            PIC X(26)  VALUE SPACES.        
           05  WS-TIMESTAMP             PIC X(26)  VALUE SPACES.        
           05  WS-COMMON-DATE           PIC X(10)  VALUE SPACES.        
           05  WS-START-DATE            PIC X(10)  VALUE SPACES.        
           05  WS-END-DATE              PIC X(10)  VALUE SPACES.        
           05  WS-CURRENT-DATE          PIC X(10)  VALUE SPACES.        
           05  WS-DISPLAY-SQLCODE       PIC -Z(8)9.                     
           05  WS-RPT-REV-MTH.                                          
               10 WS-REV-CCYY           PIC 9(4).                       
               10 WS-REV-MM             PIC 99.                         
           05  WS-RPT-REV-MTH-N REDEFINES WS-RPT-REV-MTH                
                                        PIC 9(6).                       
           05  WS-END-DATE-N.                                           
               10 WS-END-CCYY           PIC X(4).                       
               10 FILLER                PIC X      VALUE '-'.           
               10 WS-END-MM             PIC XX.                         
               10 FILLER                PIC X      VALUE '-'.           
               10 WS-END-DD             PIC XX     VALUE '01'.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS       PIC X     VALUE 'N'.            
               88 NO-MORE-RECORDS                 VALUE 'Y'.            
           05  WS-RECD-NOT-FOUND        PIC X     VALUE 'N'.            
               88 RECD-NOT-FOUND                  VALUE 'Y'.            
A04880     05  WS-CRR03-STATUS          PIC XX.                         
A04880         88 CRR03-SUCCESSFUL                VALUE '00'.           
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                     PIC X     VALUE 'N'.            
           05  WS-Y                     PIC X     VALUE 'Y'.            
      *                                                                         
      ****************************************************************          
      ** WS FOR DB2 & CICS ERROR PROCESSING                         **          
      ****************************************************************          
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ****************************************************************          
      ** WS-ABEND-SWITCH                                            **          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ****************************************************************          
      ** WS-FCA00-MISC                                              **          
      ****************************************************************          
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ****************************************************************          
      ** FIOJC01 WORKING STORAGE                                    **          
      ****************************************************************          
      *                                                                         
        COPY FIOJC01.                                                           
      *                                                                         
      ****************************************************************          
      ** FCA00-KEY                                                  **          
      ****************************************************************          
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      ****************************************************************          
      ** COPY BOOK TO READ THE JOB PARM TABLE                       **          
      ****************************************************************          
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ****************************************************************          
      ** COPY BOOK TO FORMAT THE REPORT DATE                        **          
      ****************************************************************          
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ****************************************************************          
      ** DB2 TABLES INCLUDED IN PROGRAM                             **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** G6 - CSS_JOB_PARM                                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** GE - CSS_GL_ENTRY_CRNT                                     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGLENT                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** F4 - CSS_MNICPLTY_CNTY                                     **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNCCTY                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** GET DATA FOR GLS CURSOR                                    **          
      ****************************************************************          
      *                                                                         
A04880     EXEC SQL                                                     
A04880         DECLARE GL_CURSOR CURSOR FOR                             
A04880           SELECT LOCAL_OFFICE                                    
A04880                 ,REV_DISTRICT_CD                                 
A04880                 ,GL_ACCT_NO                                      
A04880                 ,GL_CNTRL_DR_CR                                  
A04880                 ,SUM(AMT_TRAN_ENTRY)                             
A04880           FROM   CSS_GL_ENTRY_CRNT WITH(READUNCOMMITTED)                 
A04880           WHERE  GL_ACCT_NO        IN (241.1000                  
A04880                                       ,241.0124                  
A05460                                       ,241.0200                  
A04880                                       ,241.0206                  
A05460                                       ,241.0210                  
A05460                                       ,241.0211                  
A05460                                       ,241.0212                  
A04880                                       ,241.0233                  
A04880                                       ,241.0234                  
A04880                                       ,241.0235                  
A05460                                       ,241.3000                  
A04880                                       ,241.0236)                 
A04880             AND  ACCT_PERIOD_AFFCTD = :WS-REVENUE-MONTH          
A04880             AND  LOCAL_OFFICE       < '200'                      
A04880             AND  COMPANY_NO         = '01'                       
A04880             AND  AMT_TRAN_ENTRY    <> 0                          
A04880            GROUP BY LOCAL_OFFICE, REV_DISTRICT_CD, GL_ACCT_NO,   
A04880                     GL_CNTRL_DR_CR                               
A04880            FOR READ ONLY                                 
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GL_CURSOR CURSOR FOR                                     
MFA-TR*          SELECT LOCAL_OFFICE                                            
MFA-TR*                ,REV_DISTRICT_CD                                         
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,GL_CNTRL_DR_CR                                          
MFA-TR*                ,SUM(AMT_TRAN_ENTRY)                                     
MFA-TR*          FROM   CSS_GL_ENTRY_CRNT                                       
MFA-TR*          WHERE  GL_ACCT_NO        IN (241.1000                          
MFA-TR*                                      ,241.0124                          
MFA-TR*                                      ,241.0200                          
MFA-TR*                                      ,241.0206                          
MFA-TR*                                      ,241.0210                          
MFA-TR*                                      ,241.0211                          
MFA-TR*                                      ,241.0212                          
MFA-TR*                                      ,241.0233                          
MFA-TR*                                      ,241.0234                          
MFA-TR*                                      ,241.0235                          
MFA-TR*                                      ,241.3000                          
MFA-TR*                                      ,241.0236)                         
MFA-TR*            AND  ACCT_PERIOD_AFFCTD = :WS-REVENUE-MONTH                  
MFA-TR*            AND  LOCAL_OFFICE       < '200'                              
MFA-TR*            AND  COMPANY_NO         = '01'                               
MFA-TR*            AND  AMT_TRAN_ENTRY    <> 0                                  
MFA-TR*           GROUP BY LOCAL_OFFICE, REV_DISTRICT_CD, GL_ACCT_NO,           
MFA-TR*                    GL_CNTRL_DR_CR                                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      ** 0000-MAINLINE                                              **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-INPUT-PROCESS  THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN FILES AND GET REVENUE MONTH                           **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT MRSCRR03-FILE.                                   
      *                                                                         
           IF CRR03-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '0100-ERROR ON MRSCRR03 OPEN. STATUS IS '        
                        WS-CRR03-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           MOVE WS-PGRMNAME      TO G6-PROGRAM-NAME.                    
           MOVE 'DATE'           TO G6-CMND-CODE.                       
      *                                                                         
      ** GET REVENUE MONTH                                                      
      *                                                                         
           MOVE 'PCSCA350'       TO WS-PGRMNAME.                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
           MOVE WS-PARM-MONTH    TO  WS-REV-MM.                         
           MOVE WS-PARM-YR       TO  WS-REV-CCYY.                       
      *                                                                         
           MOVE WS-RPT-REV-MTH-N TO  WS-REVENUE-MONTH.                  
A04880     DISPLAY 'WS-REVENUE-MONTH = ' WS-RPT-REV-MTH-N.              
      *                                                                         
      ** WRITE REVENUE MONTH TO THE FILE                                        
      *                                                                         
      ** GET START AND END DATE FOR PAYMENT RECEIVED                            
      *                                                                         
           PERFORM 7460-GET-CURRENT-DATE THRU 7460-EXIT.                
A04880     DISPLAY 'WS-CURRENT-DATE = ' WS-CURRENT-DATE.                
           MOVE WS-CURRENT-DATE(1:4) TO WS-END-CCYY.                    
           MOVE WS-CURRENT-DATE(6:2) TO WS-END-MM.                      
           MOVE WS-END-DATE-N        TO WS-END-DATE.                    
           PERFORM 7470-GET-DATES THRU 7470-EXIT.                       
A04880     MOVE WS-END-DATE          TO WS-A8300-DATE.                  
      *                                                                         
A04880     DISPLAY 'WS-START-DATE = ' WS-START-DATE.                    
A04880     DISPLAY 'WS-END-DATE   = ' WS-END-DATE.                      
A04880     DISPLAY 'WS-A8300-DATE = ' WS-A8300-DATE.                    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 1000-INPUT-PROCESS                                         **          
      ****************************************************************          
      *                                                                         
       1000-INPUT-PROCESS.                                              
      *                                                                         
A04880     PERFORM 7330-OPEN-GL-CURSOR THRU 7330-EXIT.                  
A04880     PERFORM 7340-FETCH-GL-CURSOR THRU 7340-EXIT.                 
A04880     MOVE SQLCODE TO WS-SAVE-SQLCODE.                             
      *                                                                         
A04880     PERFORM UNTIL WS-SAVE-SQLCODE = NOT-FOUND                    
A04880        IF WS-CURSOR-AMOUNT NOT = 0                               
A04880           MOVE WS-REV-DISTRICT-CD  TO F4-REV-DISTRICT-CD         
A04880           PERFORM 7400-SELECT-LOCATION-CODE THRU 7400-EXIT       
A04880           IF SQLCODE = SUCCESSFUL-CALL                           
A04880              CONTINUE                                            
A04880           ELSE                                                   
A04880              MOVE SPACES TO F4-MNICPLTY-COUNTY-CD                
A04480           END-IF                                                 
      *                                                                         
A04880           MOVE WS-CURSOR-AMOUNT TO WS-8300-CONTROL-AMOUNT        
      *                                                                         
      *  REVERSE SIGN BEFORE GOING TO 2400-POPULATE-8300-REC FOR 'D'            
      *                                                                         
A04880           IF WS-GL-CNTRL-DR-CR  = WS-DEBIT-D                     
A04880              COMPUTE WS-CONTROL-AMOUNT =                         
A04880                    (WS-8300-CONTROL-AMOUNT * -1)                 
A04880              MOVE WS-CONTROL-AMOUNT TO WS-8300-CONTROL-AMOUNT    
A04880           END-IF                                                 
      *                                                                         
HONK  *          MOVE GE-GL-ACCT-NO  TO WS-GL-ACCT-NO                           
A04880           PERFORM 2200-PEOPLESOFT-GL THRU 2200-EXIT              
A04880           PERFORM 2400-POPULATE-8300-REC THRU 2400-EXIT          
A04880           PERFORM 8800-WRITE-8300-REC THRU 8800-EXIT             
A04880        END-IF                                                    
      *                                                                         
A04880        MOVE ZEROS   TO WS-CURSOR-AMOUNT                          
A04880        MOVE SPACES  TO WS-LOCAL-OFFICE                           
A04880                        WS-REV-DISTRICT-CD                        
A04880        PERFORM 7340-FETCH-GL-CURSOR THRU 7340-EXIT               
A04880        MOVE SQLCODE TO WS-SAVE-SQLCODE                           
A04880     END-PERFORM.                                                 
      *                                                                         
A04880     PERFORM 7350-CLOSE-GL-CURSOR THRU 7350-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
A04880** GET PEOPLESOFT GL                                           **         
      *****************************************************************         
      *                                                                         
A04880 2200-PEOPLESOFT-GL.                                              
      *                                                                         
A04880     MOVE SPACES TO WS-GL-BUSINESS-UNIT                           
A04880                    WS-GL-CUSTOMER-CD                             
A04880                    WS-GL-COST-CENTER                             
A04880                    WS-GL-OPERATING-UNIT                          
A04880                    WS-GL-COMPANY-IND                             
A04880                    WS-GL-ACTIVITY-CD                             
A04880                    WS-GL-RESOURCE-CD.                            
      *                                                                         
A04480     PERFORM 7500-FETCH-GL-INTERFACE THRU 7500-EXIT.              
      *                                                                         
A04880 2200-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04880* POPULATES THE OUTPUT FILE                                  ***          
      ****************************************************************          
      *                                                                         
A04880 2400-POPULATE-8300-REC.                                          
      *                                                                         
A04880     INITIALIZE ZIKRT8300.                                        
      *                                                                         
A04880     MOVE ZEROS TO ZIKRT8300-STATUS-CODE                          
A04880                   ZIKRT8300-SOURCE-SYSTEM                        
A04880                   ZIKRT8300-BATCH-NUMBER                         
A04880                   ZIKRT8300-BATCH-DATE                           
A04880                   ZIKRT8300-RECORD-CONTROL-KEY.                  
      *                                                                         
A04880     MOVE WS-GL-PEOPLESOFT    TO WS-GL-ACCT-NO-NUM.               
A04880     MOVE WS-GL-ACCT-NO-NUM   TO ZIKRT8300-ACCOUNT-NUMBER.        
      *                                                                         
A04880     MOVE WS-GL-COST-CENTER   TO ZIKRT8300-COST-CENTER            
A04880                                 ZIKRT8300-EG-ADMIN-COST-CENTER.  
      *                                                                         
A04880     MOVE WS-SOURCE-SYSTEM    TO ZIKRT8300-SOURCE-SYSTEM.         
A04880     MOVE WS-TAX              TO ZIKRT8300-DOCUMENT-NUMBER.       
      *                                                                         
A04880     COMPUTE WS-CONTROL-AMOUNT = (WS-8300-CONTROL-AMOUNT * -1).   
A04880     MOVE WS-CONTROL-AMOUNT   TO ZIKRT8300-CONTROL-AMOUNT.        
      *                                                                         
A04880     MOVE WS-A8300-YEAR       TO ZIKRT8300-EFFECTIVE-YEAR.        
A04880     MOVE WS-A8300-MONTH      TO ZIKRT8300-EFFECTIVE-MONTH.       
A04880     MOVE WS-A8300-DAY        TO ZIKRT8300-EFFECTIVE-DAY.         
      *                                                                         
A04880     MOVE WS-GL-COMPANY-IND   TO ZIKRT8300-COMPANY-CODE.          
A04880     MOVE WS-GL-CUSTOMER-CD   TO ZIKRT8300-BENEFIT-COST-CENTER.   
      *                                                                         
A04880     MOVE WS-GL-ACTIVITY-CD   TO ZIKRT8300-FUNCTION-CODE.         
A04880     MOVE WS-GL-RESOURCE-CD   TO ZIKRT8300-NOE-2.                 
A04880     MOVE WS-TRN-CODE         TO ZIKRT8300-TRANSACTION-CODE.      
A04880     MOVE ZEROS               TO ZIKRT8300-SYSTEM-CODE.           
A04880     MOVE ZEROS               TO ZIKRT8300-LOCAL-OFFICE.          
A04880     MOVE ZEROS               TO ZIKRT8300-LOC-OPT-TAX-PCT.       
      *                                                                         
A04880     MOVE F4-MNICPLTY-COUNTY-CD TO ZIKRT8300-LOCATION.            
A04880     MOVE WS-GL-OPERATING-UNIT  TO ZIKRT8300-OPERATING-UNIT.      
A04880     MOVE WS-GL-BUSINESS-UNIT   TO ZIKRT8300-BUSINESS-UNIT.       
      *                                                                         
      * FOR THE BELOW GLS, ALWAYS MOVE SPACES FOR LOCATION CODE                 
      *                                                                         
A04880     IF WS-GL-ACCT-NO-NUM = WS-ELE-SALES-GL                       
A04880        MOVE SPACES TO ZIKRT8300-LOCATION                         
A04880     END-IF.                                                      
      *                                                                         
A04880 2400-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 6200-GET-PARAMETER-DATE                                    **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00114                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** 7600-START-FCSJC01                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
A04880*   OPEN CURSOR CSS_GL_ENTRY_CRNT                              *          
      * **************************************************************          
      *                                                                         
A04880 7330-OPEN-GL-CURSOR.                                             
A04880                                                                  
A04880     EXEC SQL                                                     
A04880         OPEN GL_CURSOR                                           
A04880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        DISPLAY '************ PCSCA350 ERROR ******************'  
A04880        DISPLAY '** ERROR IN  7330-OPEN-GL-CURSOR            **'  
A04880        DISPLAY '** OPEN ERROR IN CSS_GL_ENTRY_CRNT          **'  
A04880        DISPLAY '** SQL CODE       = ' WS-ACTIVE-RETURN-CODE      
A04880        DISPLAY '** PROCESSING TERMINATED                    **'  
A04880        DISPLAY '**********************************************'  
A04880        PERFORM 9900-ABEND            THRU 9900-EXIT              
A04880     END-IF.                                                      
      *                                                                         
A04880 7330-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04880*   FETCH CURSOR CSS_GL_ENTRY_CRNT                             *          
      * **************************************************************          
      *                                                                         
A04880 7340-FETCH-GL-CURSOR.                                            
      *                                                                         
A04880     EXEC SQL                                                     
A04880          FETCH GL_CURSOR                                         
A04880           INTO  :WS-LOCAL-OFFICE                                 
A04880                ,:WS-REV-DISTRICT-CD                              
A04880                ,:GE-GL-ACCT-NO                                   
A04880                ,:WS-GL-CNTRL-DR-CR                               
A04880                ,:WS-CURSOR-AMOUNT                                
A04880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        DISPLAY '************ PCSCA350 ERROR ******************'  
A04880        DISPLAY '** ERROR IN  7340-FETCH-GL-CURSOR           **'  
A04880        DISPLAY '** FETCH ERROR IN CSS_GL_ENTRY_CRNT         **'  
A04880        DISPLAY '** SQL CODE       = ' WS-ACTIVE-RETURN-CODE      
A04880        DISPLAY '** REVENUE MONTH  = ' WS-REVENUE-MONTH           
A04880        DISPLAY '** PROCESSING TERMINATED                    **'  
A04880        DISPLAY '**********************************************'  
A04880        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880 7340-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04880*   CLOSE CURSOR CSS_GL_ENTRY_CRNT                             *          
      * **************************************************************          
      *                                                                         
A04880 7350-CLOSE-GL-CURSOR.                                            
      *                                                                         
A04880     EXEC SQL                                                     
A04880         CLOSE GL_CURSOR                                          
A04880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        DISPLAY '************ PCSCA350 ERROR ******************'  
A04880        DISPLAY '** ERROR IN  7350-CLOSE-GL-CURSOR           **'  
A04880        DISPLAY '** CLOSE ERROR IN CSS_GL_ENTRY_CRNT         **'  
A04880        DISPLAY '** SQL CODE       = ' WS-ACTIVE-RETURN-CODE      
A04880        DISPLAY '** PROCESSING TERMINATED                    **'  
A04880        DISPLAY '**********************************************'  
A04880        PERFORM 9900-ABEND            THRU 9900-EXIT              
A04880     END-IF.                                                      
      *                                                                         
A04880 7350-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * RETRIEVES LOCATION-CODE FROM CSS_MNICPLITY_CNTY FOR THE      *          
      * VALUE OF REVENUE-DISTRICT-CD RETRIEVED FROM CSS_GL_ENTRY_CRNT*          
      ****************************************************************          
      *                                                                         
       7400-SELECT-LOCATION-CODE.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT MNICPLTY_COUNTY_CD                                
                 INTO :F4-MNICPLTY-COUNTY-CD                            
                 FROM CSS_MNICPLTY_CNTY WITH(READUNCOMMITTED)                   
                WHERE REV_DISTRICT_CD = :F4-REV-DISTRICT-CD             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MNICPLTY_COUNTY_CD                                        
MFA-TR*          INTO :F4-MNICPLTY-COUNTY-CD                                    
MFA-TR*          FROM CSS_MNICPLTY_CNTY                                         
MFA-TR*         WHERE REV_DISTRICT_CD = :F4-REV-DISTRICT-CD                     
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 7400-SELECT-LOCATION-CODE **'       
              DISPLAY '*** REV_DISTRICT_CD: ' F4-REV-DISTRICT-CD        
              DISPLAY '*** SQLCODE = ' WS-DISPLAY-SQLCODE               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET CURRENT DATE                                           **          
      ****************************************************************          
      *                                                                         
       7460-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE     TO WS-DISPLAY-SQLCODE.                      
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 7460-GET-CURRENT-DATE **'           
              DISPLAY '*** SQLCODE = ' WS-DISPLAY-SQLCODE               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET START DATE                                             **          
      ****************************************************************          
      *                                                                         
       7470-GET-DATES.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT DATEADD( MONTH, -1, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )                       
                    ,DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )                         
                INTO :WS-START-DATE                                     
                    ,:WS-END-DATE                                       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-END-DATE) - 1 MONTH                               
MFA-TR*             ,DATE(:WS-END-DATE) - 1 DAY                                 
MFA-TR*         INTO :WS-START-DATE                                             
MFA-TR*             ,:WS-END-DATE                                               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 7470-GET-DATES **'                  
              DISPLAY '*** SQLCODE = ' WS-DISPLAY-SQLCODE               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** GET PEOPLE SOFT GL FOR 8300 FILE                           **          
      ****************************************************************          
      *                                                                         
       7500-FETCH-GL-INTERFACE.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT  GJ.GL_INTRFCE_ACCT_NO                            
                      ,GJ.BUSINESS_UNIT                                 
                      ,GJ.CUSTOMER_CD                                   
                      ,GJ.COST_CENTER                                   
                      ,GJ.OPERATING_UNIT                                
                      ,GJ.COMPANY_IND                                   
                      ,GJ.ACTIVITY_CD                                   
                      ,GJ.RESOURCE_CD                                   
                 INTO :WS-GL-PEOPLESOFT                                 
                     ,:WS-GL-BUSINESS-UNIT                              
                     ,:WS-GL-CUSTOMER-CD                                
                     ,:WS-GL-COST-CENTER                                
                     ,:WS-GL-OPERATING-UNIT                             
                     ,:WS-GL-COMPANY-IND                                
                     ,:WS-GL-ACTIVITY-CD                                
                     ,:WS-GL-RESOURCE-CD                                
                 FROM CSS_GL_INTRFCE GJ WITH(READUNCOMMITTED)                   
                     ,CSS_GL_INTRFCE_SEQ GN WITH(READUNCOMMITTED)               
                WHERE GJ.GL_INTRFCE_SEQ_NO  = GN.GL_INTRFCE_SEQ_NO      
                  AND GN.GL_ACCT_NO         = :GE-GL-ACCT-NO            
A04880            AND GJ.COMPANY_IND        = '01'                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  GJ.GL_INTRFCE_ACCT_NO                                    
MFA-TR*               ,GJ.BUSINESS_UNIT                                         
MFA-TR*               ,GJ.CUSTOMER_CD                                           
MFA-TR*               ,GJ.COST_CENTER                                           
MFA-TR*               ,GJ.OPERATING_UNIT                                        
MFA-TR*               ,GJ.COMPANY_IND                                           
MFA-TR*               ,GJ.ACTIVITY_CD                                           
MFA-TR*               ,GJ.RESOURCE_CD                                           
MFA-TR*          INTO :WS-GL-PEOPLESOFT                                         
MFA-TR*              ,:WS-GL-BUSINESS-UNIT                                      
MFA-TR*              ,:WS-GL-CUSTOMER-CD                                        
MFA-TR*              ,:WS-GL-COST-CENTER                                        
MFA-TR*              ,:WS-GL-OPERATING-UNIT                                     
MFA-TR*              ,:WS-GL-COMPANY-IND                                        
MFA-TR*              ,:WS-GL-ACTIVITY-CD                                        
MFA-TR*              ,:WS-GL-RESOURCE-CD                                        
MFA-TR*          FROM CSS_GL_INTRFCE GJ                                         
MFA-TR*              ,CSS_GL_INTRFCE_SEQ GN                                     
MFA-TR*         WHERE GJ.GL_INTRFCE_SEQ_NO  = GN.GL_INTRFCE_SEQ_NO              
MFA-TR*           AND GN.GL_ACCT_NO         = :GE-GL-ACCT-NO                    
MFA-TR*           AND GJ.COMPANY_IND        = '01'                              
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-DISPLAY-SQLCODE.                          
      *                                                                         
           IF  SQLCODE = SUCCESSFUL-CALL                                
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*** ABEND IN 7500-FETCH-GL-INTERFACE   **'       
              DISPLAY '*** SCANA GL = ' GE-GL-ACCT-NO                   
              DISPLAY '*** SQLCODE = ' WS-DISPLAY-SQLCODE               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
A04880* WRITES EACH RECORD RETRIEVED FROM THE CURSOR TO THE FILE     *          
      ****************************************************************          
      *                                                                         
A04880 8800-WRITE-8300-REC.                                             
      *                                                                         
A04880     WRITE ZIKRT8300.                                             
      *                                                                         
A04880     IF CRR03-SUCCESSFUL                                          
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        DISPLAY '********** PCSCA350  ABORT ***************'      
A04880        DISPLAY '* 8800-WRITE-8300-REC                    *'      
A04880        DISPLAY '* SQLCODE = ' WS-ACTIVE-RETURN-CODE              
A04880        DISPLAY '* COMPANY CODE   = ' ZIKRT8300-COMPANY-CODE      
A04880        DISPLAY '* ACCOUNT NUMBER = ' ZIKRT8300-ACCOUNT-NUMBER    
A04880        DISPLAY '* COST CENTER    = ' ZIKRT8300-COST-CENTER       
A04880        DISPLAY '* LOCAL OFFICE   = ' ZIKRT8300-LOCAL-OFFICE      
A04880        DISPLAY '********** PCSCA350  ABORT ***************'      
A04880        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04880     END-IF.                                                      
      *                                                                         
A04880 8800-EXIT.                                                       
A04880     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 9000-TERMINATE - NORMAL JOB COMPLETION                     **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE MRSCRR03-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 9900-ABEND                                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
