       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA348.                                        
       DATE-WRITTEN.   AUG 2006.                                        
           DATE-COMPILED.                                               
      ******************************************************************00050000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00060000
      **                     PRICE WATERHOUSE                         **00070000
      **                1410 NORTH WESTSHORE BLVD                     **00080000
      **                   TAMPA, FLORIDA  33607                      **00090000
      **                      (813) 287-9200                          **00100000
      **                                                              **00110000
      ********            CUSTOMER SERVICE SYSTEM             **********00120000
      ********                      DB2                       **********00130000
      ******************************************************************00140000
      *                   PROGRAM NARRATIVE                            *00150000
      *                                                                *00160000
      *  THIS PROGRAM UPDATES DEPOSIT RECORDS.                         *00170000
      *  WHEN A DEPOSIT RECORD IS UPDATED, THE CSS_AR_CNTL,            *00180000
      *  CSS_DEP_ON_HAND AND CSS_ACCOUNT TABLES ARE UPDATED.           *00190000
      *  A CASH DRAWER 101 AND AR-TRANSACTION HISTORY JOURNALS         *00200000
      *  ARE WRITTEN.                                                  *00210000
      *                                                                *00220000
      ******************************************************************00230000
      ******************************************************************00240000
      **                                                              **00250000
      **              PROGRAM  MODIFICATION  LOG                      **00260000
      **    DATE    INITIALS     REASON                               **00270000
      **    ----    --------     ------                               **00280000
      **  08/18/06   CVNS       INITIAL PROGRAM VERSION               **00290000
      **            CHENNAI                                           **00300000
C32909**  11/10/08  CVNS        TO GET THE ALL SCEG AND PNC COMPANY NO.*        
C32909**            CHENNAI/                                          **        
      **            SS42021     ALLOW CSR IMMEDIATE BILL DEPOSITS     **        
      **                        TO BE REVERSED.                       **        
C32909**   01/22/09 SS42021     INITIALIZE FIELDS TO FIX ISSUES.      **        
P00399**   09/29/10 VP94820     MODIFIED TO PROCESS PCSCA097 EXTRACTED**        
P00399**                        FILE AS PART OF DAILY DEPOSIT REVIEW. **        
      **                                                              **        
A05154** 29 JAN 2015 RF10596    CLEAN UP PROGRAM                      **        
      **                                                              **        
      ******************************************************************00320000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
HPCCDM*    EJECT                                                        00470000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HPCCDM*    SKIP2                                                        00540000
           COPY CSSCA347.                                               00550000
HPCCDM*    SKIP2                                                        00550114
           COPY CSSCA348.                                               00551014
      *                                                                 00560000
      ******************************************************************00570014
      * FILE USED TO RECOVER CONTENTS OF FCSCA348 FILE DURING RESTART  *00571014
      ******************************************************************00572014
           SELECT FCSC348R-FILE                                         
               ASSIGN UT-S-FCSC348R                                     
               FILE STATUS IS WS-FCA348R-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
HPCCDM*    SKIP2                                                        00590000
       FILE SECTION.                                                    
HPCCDM*    SKIP2                                                        00610000
HPCCDM*    EJECT                                                        00620000
       COPY CFDCA347.                                                   00630000
       COPY FIOCA347.                                                   00640000
HPCCDM*    SKIP2                                                        00641014
       COPY CFDCA348.                                                   00642014
       COPY FIOCA348.                                                   00643014
      ******************************************************************00644014
      * FD STATEMENT FOR RECOVERY FILE OF FCSCA348  FILE               *00645014
      ******************************************************************00646014
       FD  FCSC348R-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOCA348R-REC                 PIC X(51).                     
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA348'.
MSQ017     COPY MFASQLM.
      *                                                                 00680000
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR PCSCA348 STARTS HERE'.                  
                                                                        
      ******************************************************************00720000
      *    WORK AREAS                                                  *00730000
      ******************************************************************00740000
      *                                                                 00750000
       01  SWITCHES.                                                    
           05  WS-DELETE-DEP-SW          PIC X(01)  VALUE 'N'.          
               88 DELETE-NOT-PROCESSED              VALUE 'N'.          
               88 DELETE-WAS-PROCESSED              VALUE 'Y'.          
           05  WS-PROCESS-RECORD-SW      PIC X(01)  VALUE 'Y'.          
               88 PROCESS-NO-RECORD                 VALUE 'N'.          
               88 PROCESS-RECORD                    VALUE 'Y'.          
P00399     05  WS-EXTRACT-TYPE           PIC X(08)  VALUE SPACES.       
P00399         88 PEND-DEP-REVIEW                   VALUE '        '.   
P00399         88 PRE-BIL-DEP-REVIEW                VALUE 'PCSCA097'.   
P00399     05  WS-REFUND-REQ             PIC X(01)  VALUE 'N'.          
P00399         88 REFUND-INS-NOT-REQ                VALUE 'N'.          
P00399         88 REFUND-INS-REQ                    VALUE 'Y'.          
      *                                                                 00830000
       01  WS-FILE-STATUS.                                              
           05  WS-FCA347-STATUS          PIC X(02).                     
               88  FCA347-SUCCESSFUL      VALUE '00'.                   
           05  WS-FCA348-STATUS          PIC X(02).                     
               88  FCA348-SUCCESSFUL      VALUE '00'.                   
           05  WS-FCA348R-STATUS         PIC X(02).                     
               88  FCA348R-SUCCESSFUL     VALUE '00'.                   
      *                                                                 00870000
       01  WS-RECORD-COUNTERS.                                          
           05  WS-FCS347-REC-CNTR        PIC S9(07) COMP-3 VALUE ZERO.  
           05  WS-FCS347-REC-CNTR-TOT    PIC S9(07) COMP-3 VALUE ZERO.  
           05  WS-FCS348-REC-CNTR        PIC S9(07) COMP-3 VALUE ZERO.  
           05  WS-RECORD-COUNT           PIC 9(4)   VALUE ZEROES.       
           05  WS-PROGRAM-DATE           PIC X(10).                     
           05  WS-RUN-DATE               PIC X(10).                     
           05  WS-LAST-RUN-DATE          PIC X(10).                     
                                                                        
      *                                                                 00960000
       01  MISCELLANEOUS-WS-FIELDS.                                     
           05  WS-NULL-IND-1             PIC S9(04) COMP VALUE -1.      
           05  WS-NULL-IND-2             PIC S9(04) COMP VALUE -1.      
P00399     05  WS-RN-NULL-IND-1          PIC S9(04) COMP VALUE 0.       
           05  WS-TOTAL-PAYMENTS-NI      PIC S9(04) COMP VALUE 0.       
           05  WS-DEP-CRED-AMT-REMAIN    PIC S9(09)V99 USAGE COMP-3     
                                                         VALUE 0.       
           05  WS-HOLD-DEP-CRED-AMT-REMAIN  PIC S9(09)V99 USAGE COMP-3  
                                                         VALUE 0.       
           05  WS-AMT-DEPOSIT-NEW        PIC S9(09)V99 USAGE COMP-3     
                                                         VALUE 0.       
           05  WS-AMT-TRAN-BAL-REMAIN    PIC S9(09)V99 USAGE COMP-3     
                                                         VALUE 0.       
           05  WS-AMT-TRAN-BAL           PIC S9(09)V99 USAGE COMP-3     
                                                         VALUE 0.       
           05  WS-TOTAL-AR-BALANCE       PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-AMT-AR-DAY-00        PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-AMT-AR-DAY-30        PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-AMT-AR-DAY-60        PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-AMT-AR-DAY-90        PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-AMT-UNUSED-CR        PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  SUMM-LAST-UPDATE-TS       PIC X(26)                      
C32909                                                   VALUE SPACES.  
           05  WS-AMT-BILLED             PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
           05  WS-AMT-UNBILLED           PIC S9(09)V99 USAGE COMP-3     
C32909                                                   VALUE 0.       
C32909     05  WS-REG-GROUP-CD           PIC X(11) VALUE SPACES.        
           05  WS-AC-EXISTS              PIC X(01) VALUE 'N'.           
           05  WS-DR-EXISTS              PIC X(01) VALUE 'N'.           
           05  WS-DEP-REQ-EXISTS         PIC X(01) VALUE 'N'.           
           05  WS-DEP-ON-HAND-EXISTS     PIC X(01) VALUE 'N'.           
           05  WS-CURRENT-DATE           PIC X(10).                     
           05  WS-TOTAL-PAYMENTS         PIC S9(09)V9(2) COMP-3 VALUE 0.
           05  WS-DEP-DET-FOUND          PIC X(01)  VALUE 'N'.          
C32909     05  WS-OTHER-RECV             PIC X(01) VALUE SPACES.        
C32909  01 WS-PROGRAM-VARS.                                             
           05  WS-100                    PIC S9(03) VALUE 100.          
           05  VALUE-SPACES              PIC X(01) VALUE ' '.           
           05  DEP-PYMT-PRIORITY-LVL     PIC S9(04) COMP VALUE +80.     
           05  ACTIVE                    PIC X(01)       VALUE 'A'.     
C32909     05  WS-DATABASE               PIC 9(01)  VALUE ZERO.         
C32909         88  CSR-DATABASE                     VALUE 1.            
C32909         88  SEB-DATABASE                     VALUE 2.            
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA348'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA348'.   
           05  WS-RESTART-SW             PIC X(01)  VALUE 'N'.          
               88 WS-THIS-IS-A-RESTART              VALUE 'Y'.          
           05  WS-RESTART-RECORD         PIC X(51).                     
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)  VALUE ZERO.         
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)  VALUE ZERO.         
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)  VALUE 4.            
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)  VALUE 20.           
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)  VALUE ZERO.         
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-SEQ-NO                 PIC 9(04)  VALUE ZERO.         
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)  VALUE 'N'.          
           05  WS-DATA-FOUND             PIC X(1)   VALUE 'Y'.          
      ******************************************************************01440000
      * DATA USED TO UPDATE CSS_RESTART TABLE AT EVERY DB2 COMMIT.     *01450000
      * LENGTH OF RESTART DATA IS 888.                                 *01460000
      ******************************************************************01470000
       01  WS-RESTART-DATA               PIC X(891).                    
       01  WS-RESTART-DATA-BREAKDOWN REDEFINES WS-RESTART-DATA.         
           05  WS-RESTRT-DATA-LEN        PIC S9(4)  USAGE COMP.         
           05  WS-RESTRT-ACCOUNT-NO      PIC 9(13).                     
           05  WS-RESTRT-FCS347-CNTR     PIC S9(07) COMP-3.             
           05  WS-RESTRT-INPUT-DATE      PIC X(10).                     
           05  WS-RESTRT-PROGRAM-DATE    PIC X(10).                     
           05  WS-RESTRT-RUN-DATE        PIC X(10).                     
           05  WS-RESTRT-LAST-RUN-DATE   PIC X(10).                     
           05  WS-RESTRT-RECORD-COUNT    PIC S9(07) COMP-3.             
           05  WS-RESTRT-DATA-REST       PIC X(757).                    
           05  WS-RESTRT-FCA347R-COUNT   PIC 9(07).                     
           05  WS-RESTRT-FCA348R-COUNT   PIC 9(07).                     
           05  WS-RESTART-TOT-COMM-CNT   PIC S9(05)  COMP.              
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-SCEG                     PIC X(02) VALUE '01'.        
       01  WS-PROGRAM-FLAGS.                                            
           05  WS-NO-MORE-DATA           PIC X(01)  VALUE 'N'.          
               88  NO-MORE-DATA                     VALUE 'Y'.          
           05  WS-FCSCA348R-EOF          PIC X(01)  VALUE 'N'.          
               88  FCSCA348R-EOF                    VALUE 'Y'.          
           05  WS-END-REC-PROCESSED      PIC X(01)  VALUE 'N'.          
                                                                        
      ******************************************************************01670000
      * WORKING STORAGE FOR JOURNALING                                 *01680000
      ******************************************************************01690000
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP         PIC X(26).                     
           05  CURRENT-DATE              PIC X(10).                     
           05  WS-DATE-ORIG-PYMT-IND     PIC S9(04) COMP.               
           05  WS-GL-ACCT-NAME           PIC X(10) VALUE 'AR-DEP'.      
           05  WS-GL-ACCT-NAME-2         PIC X(10) VALUE 'DEP-DEP'.     
           05  WS-GL-ACCT-NAME-3         PIC X(10) VALUE 'AR-DFA'.      
      *                                                                 01770000
       01  CASH-DRAWER-JOURNALING.                                      
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO      PIC X(02).                     
               10  WS-CD-LOCAL-OFFICE    PIC X(03).                     
               10  WS-CD-REPORT-NO       PIC X(03).                     
               10  WS-CD-REPORT-DATE     PIC X(10).                     
               10  WS-CASH-DRAWER-ID     PIC S9(04) COMP.               
COB305     05 WS-GL-ACCT-NO-2        PIC S999V9999 COMP-3 VALUE 0.          
COB305     05 WS-GL-ACCT-NO-3        PIC S999V9999 COMP-3 VALUE 0.          
COB305     05 WS-GL-ACCT-NO-AR-DEP        PIC S999V9999 COMP-3 VALUE 0.         
      *                                                                 01870000
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN            PIC S9(4) USAGE COMP.          
           05 WS-COMMENTS-TEXT.                                         
              10 WS-COMMENTS-TEXT1       PIC X(45) VALUE                
              'REVERSING DEPOSIT CHARGE NOT PAID ON PENDING '.          
              10 WS-COMMENTS-TEXT2       PIC X(44) VALUE                
               'ACCOUNT MORE THAN 3 MONTHS OLD.CUSTOMER MAY '.          
              10 WS-COMMENTS-TEXT3       PIC X(44) VALUE                
              'STILL BE REQUIRED TO PAY DEPOSIT FOR SERVICE'.           
      *                                                                 01970000
P00399     05 WS-COMMENTS-TEXT-1.                                       
P00399        10 FILLER                  PIC X(46) VALUE                
P00399        'CREDITING DEPOSIT - GOOD CREDIT. DEP CERT NO: '.         
P00399        10  WS-DEP-CERT-NO         PIC 9(04).                     
P00399*                                                                 01970000
      ***************************************************************   01980000
      *    WORKING STORAGE AREA FOR REDEFINING PARAMETERS           *   01990000
      ***************************************************************   02000000
       01  WS-ACCOUNT-NO-REDEFINITION.                                  
           05  WS-ACCOUNT                PIC X(13).                     
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                         PIC 9(13).                     
           05  WS-ACCOUNT-NO             PIC S9(13)V USAGE COMP-3       
                                                     VALUE +0.          
      *                                                                 02060000
       01  WS-DEPOSIT-CERT-NO-REDEF.                                    
           05  WS-DEPOSIT-CERT-NO        PIC 9(09) VALUE ZEROES.        
           05  WS-DEPOSIT-CERT-NUM REDEFINES WS-DEPOSIT-CERT-NO         
                                         PIC 9(09).                     
           05  WS-DEPOSIT-CERT-NO-NO     PIC S9(09) USAGE COMP          
                                                    VALUE +0.           
      *                                                                 02130000
       01  WS-DEP-CRED-AMT-REDEFINITION.                                
           05  WS-DEPOSIT-CREDIT-AMT     PIC 9(09)V99.                  
           05  WS-DEP-CRED-AMT    REDEFINES WS-DEPOSIT-CREDIT-AMT       
                                         PIC 9(09)V99.                  
           05  WS-DEP-CRED-AMT-DEC       PIC S9(09)V99 USAGE COMP-3     
                                                     VALUE +0.          
      *                                                                 02200000
      ******************************************************************02210000
      *    DB2 INCLUDES                                                *02220000
      ******************************************************************02230000
      *                                                                 02240000
           EXEC SQL                                                     02250000
              INCLUDE SQLCA                                             02260000
           END-EXEC.                                                    02270000
                                                                        
      *** CSS_DEP_ON_HAND                                               02340000
           EXEC SQL                                                     02350000
              INCLUDE TBDEPHND                                          02360000
           END-EXEC.                                                    02370000
                                                                        
      *** CSS_AR_CNTL                                                   02440000
           EXEC SQL                                                     02450000
              INCLUDE TBARCNTL                                          02460000
           END-EXEC.                                                    02470000
                                                                        
      *** CSS_AR_LOCKOUT                                                02490000
           EXEC SQL                                                     02500000
              INCLUDE TBARLOCK                                          02510000
           END-EXEC.                                                    02520000
                                                                        
      *** CSS_ACCOUNT                                                   02540000
           EXEC SQL                                                     02550000
              INCLUDE TBACCT                                            02560000
           END-EXEC.                                                    02570000
                                                                        
      *** CSS_AR_TRANS_HIST                                             02590000
           EXEC SQL                                                     02600000
              INCLUDE TBARHIST                                          02610000
           END-EXEC.                                                    02620000
                                                                        
      *** CSS_AR_TRN_HST_DET                                            02640000
           EXEC SQL                                                     02650000
              INCLUDE TBARHDT                                           02660000
           END-EXEC.                                                    02670000
                                                                        
      *** CSS_JOB_PARM                                                  02690000
           EXEC SQL                                                     02700000
              INCLUDE TBJBPARM                                          02710000
           END-EXEC.                                                    02720000
                                                                        
      *** CSS_CUSTOMER                                                  02740000
           EXEC SQL                                                     02750000
              INCLUDE TBCUST                                            02760000
           END-EXEC.                                                    02770000
                                                                        
      *** CSS_DEP_REQ                                                   02790000
           EXEC SQL                                                     02800000
              INCLUDE TBDEPREQ                                          02810000
           END-EXEC.                                                    02820000
                                                                        
      *** CSS_GL_ACCT_NO                                                02840000
           EXEC SQL                                                     02850000
              INCLUDE TBGLATNO                                          02860000
           END-EXEC.                                                    02870000
                                                                        
      *** CSS_BCH_JRNL_CNTL                                             02890000
           EXEC SQL                                                     02900000
              INCLUDE TBBJCNTL                                          02910000
           END-EXEC.                                                    02920000
                                                                        
      *** CSS_BATCH_JRNL                                                02940000
           EXEC SQL                                                     02950000
              INCLUDE TBBTJRNL                                          02960000
           END-EXEC.                                                    02970000
                                                                        
      *** CSS_MISC_JRNL                                                 02990000
           EXEC SQL                                                     03000000
              INCLUDE TBMSJRNL                                          03010000
           END-EXEC.                                                    03020000
      *                                                                 03130000
      *** CSS_DEP_PAY_HST                                               03190000
           EXEC SQL                                                     03200000
              INCLUDE TBDEPHST                                          03210000
           END-EXEC.                                                    03220000
P00399*                                                                         
P00399*** CSS_REFUND - RN                                               06340000
P00399     EXEC SQL                                                             
P00399         INCLUDE TBREFUND                                                 
P00399     END-EXEC.                                                            
      *                                                                         
      *** CSS_RESTART                                                   03240000
           EXEC SQL                                                     03250000
               INCLUDE TBRESTRT                                         03260000
           END-EXEC.                                                    03270000
                                                                        
      *** CSS_PREMISE                                                   03290000
           EXEC SQL                                                     03300000
               INCLUDE TBPREM                                           03310000
           END-EXEC.                                                    03320000
                                                                        
C32909*** CSS_DELINQUENCY  (C8)                                         03290000
C32909     EXEC SQL                                                     03300000
C32909         INCLUDE TBDELQ                                           03310000
C32909     END-EXEC.                                                    03320000
C32909                                                                  
      *** CSS_REG_PROFILE                                               03331016
           EXEC SQL                                                     03332016
               INCLUDE TBREGPRF                                         03333016
           END-EXEC.                                                    03334016
      ******* WS-FCA00-MISC       ****************                      03340000
       COPY CWS00039.                                                   03350000
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                      03370000
        COPY FIOJC01.                                                   03380000
                                                                        
      ******* FCA00-KEY           ****************                      03400000
       COPY FIOCA00.                                                    03410000
                                                                        
      ******* WORKING STORAGE FOR WS-MISC.*********************         03430000
           EXEC SQL                                                     03440000
              INCLUDE CWS00038                                          03450000
           END-EXEC.                                                    03460000
      *                                                                 03470000
      ******************************************************************03480000
      *    COBOL WORKING STORAGE COPY BOOKS                            *03490000
      ******************************************************************03500000
                                                                        
           COPY CJF00101.                                               03520000
           COPY CJF00102.                                               03530000
           COPY CJF00113.                                               03540000
           COPY CJF00201.                                               03550000
           COPY CCA00001.                                               03560000
           EXEC SQL                                                     03570000
              INCLUDE CWSX0010                                          03580000
           END-EXEC.                                                    03590000
           COPY CWS00027.                                               03600000
           COPY CWS00056.                                               03610000
           COPY CWS00100.                                               03630000
           COPY CWS00303.                                               03640000
           COPY CWS09900.                                               03650000
                                                                        
           EXEC SQL                                                     03670000
               INCLUDE CWS00131                                         03680000
           END-EXEC.                                                    03690000
                                                                        
           EXEC SQL                                                     03710000
               INCLUDE CWS00013                                         03720000
           END-EXEC.                                                    03730000
      *                                                                 03740000
       COPY CWS00182.                                                   03750000
HPCCDM*EJECT                                                            03760000
      *                                                                 03770000
      ******************************************************************03780000
      * CURSOR DECLARATION                                             *03790000
      ******************************************************************03800000
                                                                        
           EXEC SQL                                                     
              DECLARE DEP_REQ CURSOR FOR                                
              SELECT   'Y'                                              
              FROM     CSS_DEP_REQ                                      
              WHERE    ACCOUNT_NO = :WS-ACCOUNT-NO  AND                 
                       PYMT_PRIORITY_LVL = 080                          
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE DEP_ON_HAND CURSOR FOR                            
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND                                  
              WHERE    ACCOUNT_NO = :WS-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD IN ('A', 'P')                  
           END-EXEC.                                                    
      *                                                                 03970000
           05 WS-END                   PIC X(40)                        
               VALUE 'WORKING STORAGE FOR PCSCA348 ENDS HERE'.          
HPCCDM*EJECT                                                            04000000
       PROCEDURE DIVISION.                                              
      *                                                                 04020000
      ******************************************************************04030000
      * 0000-MAINLINE                                                  *04040000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04050000
      ******************************************************************04060000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
                                                                        
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY 'PCSCA348 RERUN COMPLETED'                        
           ELSE                                                         
              DISPLAY 'PCSCA348 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-SEQ-NO                  TO G6-SEQ-NO              
              MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME        
              MOVE WS-SCEG                    TO G6-COMPANY-NO          
              MOVE WS-I                       TO G6-STATUS              
              MOVE 'PARM'                     TO G6-CMND-CODE           
              MOVE 'RESTART-REQ=Y'            TO G6-PARM-DATA           
              PERFORM 8370-RESET-JOB-PARM     THRU 8370-EXIT            
           END-IF.                                                      
           IF RETURN-CODE = 0                                           
              PERFORM 8990-DELETE-RESTART-TABLE  THRU 8990-EXIT         
           END-IF.                                                      
                                                                        
           STOP RUN.                                                    
      *                                                                 04190000
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04230000
      *   0100-INITIALIZATION                                          *04240000
      *        COMMON INITIALIZATION ROUTINE                           *04250000
      ******************************************************************04260000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6235-GET-FJC01-RESTART-REQ                        
                                                 THRU 6235-EXIT.        
           MOVE G6-SEQ-NO                        TO WS-SEQ-NO.          
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6253-GET-FJC01-CHKP-LIMIT                         
                                                 THRU 6253-EXIT.        
           OPEN OUTPUT FCSCA348-FILE.                                   
           IF FCA348-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA348 PROCESSING ERROR    **'          
               DISPLAY '**   FCSCA348-FILE WILL NOT OPEN   **'          
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           OPEN INPUT FCSCA347-FILE.                                    
           IF FCA347-SUCCESSFUL                                         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**    PCSCA348 PROCESSING ERROR   **'            
              DISPLAY '**  FCSCA347 FILE WILL NOT OPEN   **'            
              DISPLAY '**      PROCESSING TERMINATED     **'            
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
C32909     MOVE 'DATABASE' TO C8-DELINQ-CD.                             
C32909     MOVE '01'       TO C8-COMPANY-NO.                            
C32909     PERFORM 7410-GET-DELINQ-VALUE  THRU 7410-EXIT.               
C32909     MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
C32909                                                                  
           INITIALIZE    DCLCSS-AR-TRN-HST-DET                          
                         DCLCSS-BCH-JRNL-CNTL                           
                         DCLCSS-DEP-ON-HAND                             
                         DCLCSS-AR-CNTL                                 
                         WS-RESTRT-FCA348R-COUNT                        
                         WS-RESTRT-FCA347R-COUNT                        
                                                                        
           PERFORM 0110-PREPARE-FOR-RESTART.                            
                                                                        
           IF WS-RESTART-SW = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT         
              IF COMMON-DATE-NEEDED                                     
                 PERFORM 6240-GET-FCA00-COMMON-DATE                     
                                                 THRU 6240-EXIT         
                 MOVE WS-FCA00-COMMON-DATE   TO WS-INPUT-DATE           
              END-IF                                                    
              PERFORM 0500-PROCESS-BEGIN-REC      THRU 0500-EXIT        
           END-IF.                                                      
           PERFORM 7999-SELECT-AL            THRU 7999-SELECT-AL-EXIT   
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY ' '                                               
              DISPLAY '** PCSCA348 PROCESSING ERROR  **'                
              DISPLAY '**  AR LOCKOUT IN EFFECT      **'                
              DISPLAY '**  PROCESSING TERMINATED     **'                
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF                                                       
           PERFORM 7500-READ-FCSCA347            THRU 7500-EXIT.        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04650000
      ******************************************************************04660000
      *   0110-PREPARE-FOR-RESTART.                                    *04670000
      *     CHECK THE DATA FOR RESTART.                                *04680000
      ******************************************************************04690000
                                                                        
       0110-PREPARE-FOR-RESTART.                                        
                                                                        
           MOVE SPACES                     TO WS-RESTART-DATA.          
           MOVE 'PCSCA348'                 TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           PERFORM 7960-SELECT-FOR-RESTART       THRU 7960-EXIT         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              DISPLAY '*********************************************'   
              DISPLAY '**                                         **'   
              DISPLAY '**  ROW FOUND IN CSS_RESTART FOR PCSCA348  **'   
              DISPLAY '**     RESTART LOGIC WILL BE FOLLOWED      **'   
              DISPLAY '**                                         **'   
              DISPLAY '*********************************************'   
              MOVE 'Y'                     TO WS-RESTART-SW             
              MOVE RF-RESTART-DATA         TO WS-RESTART-DATA-BREAKDOWN 
              PERFORM 0111-RECOVER-FIELDS                               
              PERFORM 0112-POSITION-FILES                               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'N'                  TO WS-RESTART-SW             
              END-IF                                                    
           END-IF.                                                      
           PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04980000
      ******************************************************************04990000
      *   0111-RECOVER-FIELDS                                          *05000000
      *        DATA THAT WAS  SAVED AT THE TIME OF COMMIT IS MOVED     *05010000
      *   BACK TO THE ORIGINAL FIELDS.                                 *05020000
      ******************************************************************05030000
                                                                        
       0111-RECOVER-FIELDS.                                             
                                                                        
           MOVE WS-RESTRT-ACCOUNT-NO       TO WS-ACCOUNT-NO.            
           MOVE WS-RESTRT-FCS347-CNTR      TO WS-FCS347-REC-CNTR.       
           MOVE WS-RESTRT-INPUT-DATE       TO WS-INPUT-DATE.            
           MOVE WS-RESTRT-PROGRAM-DATE     TO WS-PROGRAM-DATE.          
           MOVE WS-RESTRT-RUN-DATE         TO WS-RUN-DATE.              
           MOVE WS-RESTRT-LAST-RUN-DATE    TO WS-LAST-RUN-DATE.         
           MOVE WS-RESTRT-RECORD-COUNT     TO WS-RECORD-COUNT.          
                                                                        
       0111-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05170000
      ******************************************************************05180000
      *   0112-POSITION-FILES                                          *05190000
      *                                                                *05200000
      *   INPUT FILE FCSCA347 IS POSITION AFTER THE LAST RECORD        *05210000
      *   THAT WAS PROCESSED AND COMMITED. OUTPUT FILE  FCSCA348       *05220014
      *   IS RESTORED FROM   ZERO GENERATION CREATED DURING THE        *05221014
      *   BAD RUN INTO NEW +1 GENERATION.FILE  UP TO THE LAST RECORD   *05222014
      *   THAT WAS WRITTEN AT THE POINT OF THE LAST COMMIT.            *05223014
      ******************************************************************05230000
                                                                        
       0112-POSITION-FILES.                                             
                                                                        
           OPEN INPUT FCSC348R-FILE.                                    
           IF FCA348R-SUCCESSFUL                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA348 PROCESSING ERROR   **'           
               DISPLAY '**   FCSFA01R-FILE WILL NOT OPEN  **'           
               DISPLAY '**   PARA - 0112-POSITION-FILES   **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
           PERFORM WS-RESTRT-FCA348R-COUNT TIMES                        
               READ FCSC348R-FILE  INTO WS-RESTART-RECORD               
                 AT END                                                 
                   MOVE 'Y' TO WS-NO-MORE-DATA                          
                   MOVE 'N' TO WS-DATA-FOUND                            
                   DISPLAY '**                                      **' 
                   DISPLAY '**  NO DATA FOUND FOR FILE FCSC348R OR  **' 
                   DISPLAY '**  END OF FILE REACHED PREMATURELY.    **' 
                   DISPLAY '**  RESTART ROW INDICATES THE NUMBER OF **' 
                   DISPLAY '**  RECORDS SHOULD BE AT LEAST '            
                       WS-RESTRT-FCA348R-COUNT                          
                   DISPLAY '**                                      **' 
               END-READ                                                 
               IF FCSCA348R-EOF                                         
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF NOT FCA348R-SUCCESSFUL                            
                       DISPLAY '**    PCSCA348 PROCESSING ERROR   **'   
                       DISPLAY '**   FCSC348R-FILE WILL NOT READ **'    
                       DISPLAY '**   PARA - 0112-POSITION-FILES   **'   
                       DISPLAY '**      PROCESSING TERMINATED     **'   
                       PERFORM 9900-ABEND        THRU 9900-EXIT         
                   END-IF                                               
                   IF E-FCA348-BREAK-AREA1 = LOW-VALUES                 
                       MOVE WS-RESTART-RECORD TO E-FCA348-BEGIN-REC     
                   ELSE                                                 
                       MOVE WS-RESTART-RECORD TO FIOCA348               
                   END-IF                                               
                       WRITE FIOCA348                                   
               END-IF                                                   
           END-PERFORM.                                                 
           IF WS-DATA-FOUND = 'N'                                       
               DISPLAY '**                                           **'
               DISPLAY '**         PCSCA348 PROCESSING ERROR         **'
               DISPLAY '**  DATA FROM  INPUT RESTART FILE            **'
               DISPLAY '**  SEEMS TO BE MISSING.  POSSIBLY THE WRONG **'
               DISPLAY '**  RESTART JCL IS BEING EXECUTED.           **'
               DISPLAY '**          PARA - 0112-POSITION-FILES       **'
               DISPLAY '**             PROCESSING TERMINATED         **'
               DISPLAY '**                                           **'
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
           PERFORM WS-RESTRT-FCA347R-COUNT  TIMES                       
               READ FCSCA347-FILE                                       
                    AT END                                              
                    MOVE WS-Y       TO WS-NO-MORE-DATA                  
               END-READ                                                 
               IF NOT FCA347-SUCCESSFUL                                 
                  DISPLAY '**    PCSCA348 PROCESSING ERROR    **'       
                  DISPLAY '**   FCSCA347-FILE WILL NOT READ   **'       
                  DISPLAY '**   PARA - 0112-POSITION-FILES    **'       
                  DISPLAY '**      PROCESSING TERMINATED      **'       
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
       0112-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05420000
      ***************************************************************   05430000
      *                                                             **  05440000
      *    0500-PROCESS-BEGIN-REC                                   **  05450000
      *        TO CHECK THE BEGIN OF THE FILE FCSCA347-FILE        **   05460000
      *        FOR DETAIL REPORT                                    **  05470000
      ***************************************************************   05480000
      *                                                                 05490000
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                 05510000
           MOVE '0500'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7500-READ-FCSCA347            THRU 7500-EXIT         
                                                                        
           IF E-FCA347-ACCOUNT-NO  EQUAL LOW-VALUES                     
              SUBTRACT 1 FROM WS-FCS347-REC-CNTR                        
P00399        IF E-FCA347-EXTRACT-PGM > LOW-VALUES                      
P00399           MOVE E-FCA347-EXTRACT-PGM TO WS-EXTRACT-TYPE           
P00399        ELSE                                                      
P00399           MOVE SPACES               TO WS-EXTRACT-TYPE           
P00399        END-IF                                                    
           ELSE                                                         
              DISPLAY '**       1010-PROCESS-BEGIN-REC           **'    
              DISPLAY '**       PCSCA348 PROCESSING ERROR        **'    
              DISPLAY '**  ACCOUNT NO =' E-FCA347-ACCOUNT-NO            
              DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'    
              DISPLAY '**         PROCESSING TERMINATED          **'    
              PERFORM 9000-TERMINATE             THRU 9000-EXIT         
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 05670000
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05700000
      ****************************************************************  05701001
      **  0605-VALIDATE-RESTART-REQ.                                 *  05702001
      ****************************************************************  05703001
            EXEC SQL                                                    05704001
                INCLUDE CPD00030                                        05705001
            END-EXEC.                                                   05706001
      *                                                                 05707001
      ******************************************************************05710000
      * 1000-PROCESS-INPUT                                             *05720000
      *                                                                *05730000
      *        USING INPUT FILE PARAMETERS.                            *05740000
      ******************************************************************05750000
      *                                                                 05760000
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 7800-GET-GL-ACCT              THRU 7800-EXIT         
           MOVE GO-GL-ACCT-NO                    TO WS-GL-ACCT-NO-AR-DEP
           PERFORM 7850-GET-GL-ACCT-2            THRU 7850-EXIT         
           PERFORM 7900-GET-GL-ACCT-3            THRU 7900-EXIT         
           PERFORM 7550-GET-CURRENT-DATE         THRU 7550-EXIT         
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT         
              UNTIL NO-MORE-DATA.                                       
              IF WS-FCS347-REC-CNTR  NOT EQUAL WS-FCS347-REC-CNTR-TOT   
                 DISPLAY '**     PCSCA348 PROCESSING ERROR        **'   
                 DISPLAY '** ACTUAL REC COUNT NOT EQUAL  CNTL REC **'   
                 DISPLAY '** CONTROL REC COUNT = '                      
                                        WS-FCS347-REC-CNTR-TOT          
                 DISPLAY '** ACTUAL REC COUNT  = '                      
                                    WS-FCS347-REC-CNTR                  
                 DISPLAY '**        PROCESSING TERMINATED         **'   
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              ELSE                                                      
                 DISPLAY '**    PCSCA348 PROCESSING         **'         
                 DISPLAY '**    COMPLETED SUCCESSFULY       **'         
              END-IF.                                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      *   1050-COMMIT-DB2-UPDATES                                      *06030000
      *                                                                *06040000
      *        UPDATES TO DB2 ARE COMMITED FOR EVERY 50  RECORDS       *06050000
      *   PROCESSED.  ALSO, ONE LAST COMMIT IS DONE AT END OF INPUT    *06060000
      *   FILE FCSCA347.                                               *06070000
      ******************************************************************06080000
                                                                        
       1050-COMMIT-DB2-UPDATES.                                         
                                                                        
           ADD 1                           TO WS-RECORD-COUNT.          
           MOVE 888                        TO WS-RESTRT-DATA-LEN.       
           MOVE SPACES                     TO WS-RESTRT-DATA-REST.      
           MOVE WS-ACCOUNT-NO              TO WS-RESTRT-ACCOUNT-NO.     
           MOVE WS-FCS347-REC-CNTR         TO WS-RESTRT-FCS347-CNTR.    
           MOVE WS-INPUT-DATE              TO WS-RESTRT-INPUT-DATE.     
           MOVE WS-PROGRAM-DATE            TO WS-RESTRT-PROGRAM-DATE.   
           MOVE WS-RUN-DATE                TO WS-RESTRT-RUN-DATE.       
           MOVE WS-LAST-RUN-DATE           TO WS-RESTRT-LAST-RUN-DATE.  
           MOVE WS-RECORD-COUNT            TO WS-RESTRT-RECORD-COUNT.   
           MOVE WS-RESTART-DATA            TO RF-RESTART-DATA.          
           MOVE 1                          TO RF-PARTITION-NO.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
           PERFORM 8250-UPDATE-RESTART-TABLE     THRU 8250-EXIT         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
                PERFORM 8600-INSERT-RESTART-TABLE THRU 8600-EXIT        
             END-IF.                                                    
           PERFORM 8700-COMMIT-CHANGES           THRU 8700-EXIT.        
                                                                        
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 06340000
      ******************************************************************06350000
      * 1100-PROCESS-END-REC                                           *06360000
      ******************************************************************06370000
                                                                        
       1100-PROCESS-END-REC.                                            
                                                                        
           SUBTRACT 1 FROM WS-FCS347-REC-CNTR.                          
           ADD E-FCA347-RECORD-COUNT       TO WS-FCS347-REC-CNTR-TOT.   
           MOVE WS-Y                       TO WS-END-REC-PROCESSED.     
           MOVE WS-Y                       TO WS-NO-MORE-DATA.          
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        06470000
      ******************************************************************06480000
      * 1150 ASSIGN-WS-VARS                                            *06490000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *06500000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *06510000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *06520000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *06530000
      *        PROCESSING WITHIN THIS PROGRAM.                         *06540000
      ******************************************************************06550000
       1150-ASSIGN-WS-VARS.                                             
      *                                                                 06570000
           MOVE  ZEROES                    TO  WS-DEPOSIT-CERT-NO-NO.   
      *                                                                 06590000
           MOVE E-FCA347-ACCOUNT-NO        TO WS-ACCOUNT                
                                              AC-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-DEC             TO WS-ACCOUNT-NO.            
      *                                                                 06630000
           MOVE E-FCA347-DEP-ITEM-ID       TO WS-DEPOSIT-CERT-NO.       
           MOVE WS-DEPOSIT-CERT-NUM        TO WS-DEPOSIT-CERT-NO-NO.    
      *                                                                 06660000
           MOVE E-FCA347-AMT-DEP-BAL       TO WS-DEPOSIT-CREDIT-AMT.    
      *                                                                 06680000
           MOVE WS-DEP-CRED-AMT            TO WS-DEP-CRED-AMT-DEC.      
      *                                                                 06700000
           MOVE 80                         TO AC-PYMT-PRIORITY-LVL.     
      *                                                                 06720000
           MOVE E-FCA347-DEP-ITEM-ID       TO AC-ITEM-ID.               
      *                                                                 06740000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06770000
      ******************************************************************06780000
      * 2000-PROCESS-OUTPUT.                                           *06790000
      *                                                                *06800000
      *     1. DESCRIBE RESULT SET                                     *06810000
      *     2. GET CURRENT VALUES OF FIELDS THAT WILL BE CHANGED       *06820000
      *     3. UPDATE TABLES                                           *06830000
      *     4. WRITE APPROPRIATE JOURNALS                              *06840000
      *     5. SEND RESULT SET                                         *06850000
      *                                                                *06860000
      ******************************************************************06870000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 06890000
C32909     INITIALIZE MISCELLANEOUS-WS-FIELDS.                          
C32909     MOVE 'N'   TO WS-AC-EXISTS                                   
C32909                   WS-DR-EXISTS                                   
C32909                   WS-DEP-REQ-EXISTS                              
C32909                   WS-DEP-ON-HAND-EXISTS                          
C32909                   WS-DEP-DET-FOUND                               
C32909                   WS-DELETE-DEP-SW.                              
                                                                        
           IF E-FCA347-ACCOUNT-NO               EQUAL HIGH-VALUES       
              PERFORM 1100-PROCESS-END-REC       THRU 1100-EXIT         
              GO TO 2000-EXIT                                           
           ELSE                                                         
              PERFORM 1150-ASSIGN-WS-VARS        THRU 1150-EXIT         
           END-IF                                                       
                                                                        
           MOVE WS-ACCOUNT-DEC             TO AT-ACCOUNT-NO             
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT                        
           IF  AT-ACCT-XFER-TO > ZERO                                   
               MOVE  'N'                 TO  WS-PROCESS-RECORD-SW       
               DISPLAY ' '                                              
               DISPLAY '** PCSCA348 PROCESSING ERROR   **'              
               DISPLAY '**  ACCOUNT TRANSFER IND       **'              
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** ACCOUNT TRANSFER TO= '                       
                                    AT-ACCT-XFER-TO                     
               DISPLAY '**  RECORD NOT PROCESSED       **'              
           END-IF                                                       
      ***  GET CURRENT VALUES IN DB2 TABLES                             07160000
      *                                                                 07170000
           PERFORM 7300-SELECT-DEP-ON-HAND       THRU 7300-EXIT         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  DO-AMT-DEPOSIT = E-FCA347-AMT-DEP                    
P00399             MOVE  'N'              TO  WS-REFUND-REQ             
               ELSE                                                     
P00399             MOVE  'Y'              TO  WS-REFUND-REQ             
                   MOVE  'N'              TO  WS-PROCESS-RECORD-SW      
               END-IF                                                   
           END-IF                                                       
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE  'N'                 TO  WS-PROCESS-RECORD-SW       
           END-IF.                                                      
           PERFORM 7350-GET-ACCOUNT-INFO      THRU 7350-EXIT            
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  AT-CODE-ACCT-STAT = 'P'                              
                   CONTINUE                                             
               ELSE                                                     
                   MOVE  'N'           TO WS-PROCESS-RECORD-SW          
               END-IF                                                   
C32909         IF  SEB-DATABASE                                         
                   CONTINUE                                             
               ELSE                                                     
C32909             IF CSR-DATABASE                                      
C32909                IF  E-FCA347-AMT-DEP = E-FCA347-AMT-DEP-BAL       
C32909                    PERFORM 7268-CHK-OTHER-RECEIVABLES            
C32909                       THRU 7268-EXIT                             
C32909                    IF WS-OTHER-RECV = 'Y'                        
C32909                       MOVE 'N' TO WS-PROCESS-RECORD-SW           
C32909                    ELSE                                          
C32909                       MOVE WS-ACCOUNT-NO TO DP-ACCOUNT-NO        
C32909                       MOVE WS-DEPOSIT-CERT-NO-NO                 
C32909                                          TO DP-DEPOSIT-CERT-NO   
C32909                       PERFORM 7990-SELECT-DEP-PAY-AMT            
C32909                          THRU 7990-EXIT                          
C32909                       IF WS-TOTAL-PAYMENTS EQUAL ZEROES          
C32909                          CONTINUE                                
C32909                       ELSE                                       
C32909                          MOVE 'N' TO WS-PROCESS-RECORD-SW        
C32909                       END-IF                                     
C32909                    END-IF                                        
C32909                ELSE                                              
C32909                    MOVE  'N'          TO   WS-PROCESS-RECORD-SW  
C32909                END-IF                                            
C32909             ELSE                                                 
                      MOVE  'N'              TO   WS-PROCESS-RECORD-SW  
C32909             END-IF                                               
               END-IF                                                   
           END-IF.                                                      
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT    
           MOVE AT-TOTAL-AR-BALANCE         TO WS-TOTAL-AR-BALANCE      
      *                                                                 07440000
      ***  UPDATE TABLES WITH DATA PASSED FROM INPUT FILE.              07450000
      *                                                                 07460000
P00399* FOR PCSCA097 EXTRACT, VALIDATION CAN BE BY PASSED               07210000
P00399     IF  PROCESS-RECORD OR PRE-BIL-DEP-REVIEW                     
               ADD  1                     TO  WS-RESTART-COMMIT-COUNTER 
               MOVE  WS-ACCOUNT-NO        TO  LR-ACCOUNT-NO             
               PERFORM 7700-CHECK-AR-CNTL-AMT-RECVBL                    
                                                THRU 7700-EXIT          
               PERFORM 7750-CHECK-DEP-REQ-AMT-RECVBL                    
                                                THRU 7750-EXIT          
               IF (WS-AC-EXISTS = 'N') AND (WS-DR-EXISTS = 'N')         
                   PERFORM 7650-GET-TIMESTAMP-AND-DATE                  
                                                 THRU 7650-EXIT         
                   PERFORM 2400-PROCESS-DEPHND-DETAIL                   
                                                 THRU 2400-EXIT         
                   PERFORM 7650-GET-TIMESTAMP-AND-DATE                  
                                                 THRU 7650-EXIT         
                   PERFORM 2920-UPDATE-AT        THRU 2920-EXIT         
               ELSE                                                     
                   PERFORM 7400-GET-AR-CNTL-INFO THRU 7400-EXIT         
                   PERFORM 7650-GET-TIMESTAMP-AND-DATE                  
                                                 THRU 7650-EXIT         
                   PERFORM 2200-PROCESS-ARCNTL-DETAIL                   
                                                 THRU 2200-EXIT         
                   PERFORM 2400-PROCESS-DEPHND-DETAIL                   
                                                 THRU 2400-EXIT         
                   PERFORM 7650-GET-TIMESTAMP-AND-DATE                  
                                                 THRU 7650-EXIT         
                   PERFORM 2920-UPDATE-AT        THRU 2920-EXIT         
               END-IF                                                   
P00399* FOR PARTIALLY PAID DEPOSITS INSERT A ROW IN CSS_REFUND                  
P00399         IF REFUND-INS-REQ                                        
P00399            PERFORM 5000-INSERT-REFUND     THRU 5000-EXIT         
P00399         END-IF                                                   
               PERFORM 2700-PERFORM-JOURNALING THRU 2700-EXIT           
C32909         MOVE  AT-COMPANY-NO        TO  E-FCA348-COMPANY-NO       
C32909         MOVE SPACES                TO  E-FCA348-REGULATED-IND    
C32909         IF CSR-DATABASE                                          
C32909            CONTINUE                                              
C32909         ELSE                                                     
C32909            PERFORM 7995-SELECT-REG-PROFILE THRU 7995-EXIT        
C32909            MOVE  WS-REG-GROUP-CD      TO  E-FCA348-REGULATED-IND 
C32909         END-IF                                                   
               MOVE  WS-ACCOUNT-NO        TO  E-FCA348-ACCOUNT-NO       
               MOVE  WS-GL-ACCT-NO-AR-DEP TO  E-FCA348-GL-ACCT-CREDIT   
               MOVE  WS-GL-ACCT-NO-2      TO  E-FCA348-GL-ACCT-DEBIT    
               MOVE  WS-DEP-CRED-AMT-DEC  TO  E-FCA348-AMT-REVERSED     
               PERFORM 8750-WRITE-FCSCA348 THRU 8750-EXIT               
               IF  WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR     
                   WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT        
                   PERFORM 1050-COMMIT-DB2-UPDATES THRU 1050-EXIT       
                   MOVE ZEROES              TO WS-RESTART-COMMIT-COUNTER
               END-IF                                                   
           END-IF                                                       
           PERFORM 7500-READ-FCSCA347            THRU 7500-EXIT.        
      *                                                                 07820000
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07850000
      *2200-PROCESS-ARCNTL-DETAIL.                                     *07860000
      *    -- THIS MODULE UPDATES THE AMT_TRAN_BALANCE DEPENDING ON    *07870000
      *       THE DEPOSIT CRED AMT.                                    *07880000
      ******************************************************************07890000
       2200-PROCESS-ARCNTL-DETAIL.                                      
                                                                        
           PERFORM 7000-SELECT-AR-CNTL-SUMM      THRU 7000-EXIT.        
           ADD AC-AMT-AR-DAY-00, AC-AMT-AR-DAY-30,                      
               AC-AMT-AR-DAY-60, AC-AMT-AR-DAY-90, AC-AMT-UNUSED-CR     
               GIVING WS-AMT-BILLED.                                    
           SUBTRACT WS-AMT-BILLED    FROM AC-AMT-TRAN-BALANCE           
               GIVING WS-AMT-UNBILLED.                                  
           MOVE WS-DEP-CRED-AMT-DEC        TO WS-DEP-CRED-AMT-REMAIN.   
                                                                        
           MOVE 0 TO WS-HOLD-DEP-CRED-AMT-REMAIN.                       
      *--- REDUCE THE UNBILLED AMOUNT                                   08010000
           IF WS-AMT-UNBILLED > WS-DEP-CRED-AMT-REMAIN                  
              SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-AMT-UNBILLED      
              MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                          
           ELSE                                                         
              SUBTRACT WS-AMT-UNBILLED FROM WS-DEP-CRED-AMT-REMAIN      
              IF WS-AMT-UNBILLED    NOT = ZERO                          
                 MOVE WS-DEP-CRED-AMT-REMAIN TO                         
                                       WS-HOLD-DEP-CRED-AMT-REMAIN      
              END-IF                                                    
              MOVE 0 TO WS-AMT-UNBILLED                                 
           END-IF.                                                      
                                                                        
      *--- REDUCE THE CR DAY A/R                                        08140000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-UNUSED-CR > 0       
             IF AC-AMT-UNUSED-CR > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-UNUSED-CR   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-UNUSED-CR 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-UNUSED-CR FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-UNUSED-CR FROM SUMM-AMT-UNUSED-CR       
                SUBTRACT AC-AMT-UNUSED-CR FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-UNUSED-CR                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 90 DAY A/R                                        08290000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-90 > 0       
             IF AC-AMT-AR-DAY-90 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-90   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-90 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-90 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-90 FROM SUMM-AMT-AR-DAY-90       
                SUBTRACT AC-AMT-AR-DAY-90 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-90                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 60 DAY A/R                                        08440000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-60 > 0       
             IF AC-AMT-AR-DAY-60 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-60   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-60 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-60 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-60 FROM SUMM-AMT-AR-DAY-60       
                SUBTRACT AC-AMT-AR-DAY-60 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-60                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 30 DAY A/R                                        08590000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-30 > 0       
             IF AC-AMT-AR-DAY-30 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-30   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-30 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-30 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-30 FROM SUMM-AMT-AR-DAY-30       
                SUBTRACT AC-AMT-AR-DAY-30 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-30                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
      *--- REDUCE THE 00 DAY A/R                                        08740000
           IF WS-DEP-CRED-AMT-REMAIN > 0 AND AC-AMT-AR-DAY-00 > 0       
             IF AC-AMT-AR-DAY-00 > WS-DEP-CRED-AMT-REMAIN               
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM AC-AMT-AR-DAY-00   
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM SUMM-AMT-AR-DAY-00 
                SUBTRACT WS-DEP-CRED-AMT-REMAIN FROM WS-TOTAL-AR-BALANCE
                MOVE 0 TO WS-DEP-CRED-AMT-REMAIN                        
             ELSE                                                       
                SUBTRACT AC-AMT-AR-DAY-00 FROM WS-DEP-CRED-AMT-REMAIN   
                SUBTRACT AC-AMT-AR-DAY-00 FROM SUMM-AMT-AR-DAY-00       
                SUBTRACT AC-AMT-AR-DAY-00 FROM WS-TOTAL-AR-BALANCE      
                MOVE 0 TO AC-AMT-AR-DAY-00                              
             END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 8200-UPDATE-AR-CNTL-SUMM      THRU 8200-EXIT.        
           SUBTRACT WS-DEP-CRED-AMT-DEC FROM AC-AMT-TRAN-BALANCE        
           IF AC-AMT-TRAN-BALANCE = 0                                   
              PERFORM 8550-DELETE-DEP-REC        THRU 8550-EXIT         
              PERFORM 7450-SELECT-ARCNTL         THRU 7450-EXIT         
               IF WS-DEP-DET-FOUND = 'N'                                
                  PERFORM 8400-DELETE-SUMMARY    THRU 8400-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM 8350-UPDATE-AR-CNTL-TRA-BAL                      
                                                 THRU 8350-EXIT         
           END-IF.                                                      
      *                                                                 09010000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09040000
      ******************************************************************09050000
      *2400-PROCESS-DEPHND-DETAIL.                                     *09060000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *09070000
      *       CSS_DEP_ON_HAND TABLE.                                   *09080000
      ******************************************************************09090000
       2400-PROCESS-DEPHND-DETAIL.                                      
                                                                        
           SUBTRACT WS-DEP-CRED-AMT-DEC FROM DO-AMT-DEPOSIT             
               GIVING WS-AMT-DEPOSIT-NEW.                               
                                                                        
           MOVE WS-ACCOUNT-NO              TO DP-ACCOUNT-NO.            
           MOVE WS-DEPOSIT-CERT-NO-NO      TO DP-DEPOSIT-CERT-NO.       
           PERFORM 7990-SELECT-DEP-PAY-AMT       THRU 7990-EXIT.        
                                                                        
           IF WS-AMT-DEPOSIT-NEW = 0                                    
             IF WS-TOTAL-PAYMENTS > ZEROES                              
             PERFORM 8000-UPDATE-DEPHND-DEP-STA  THRU 8000-EXIT         
             ELSE                                                       
               PERFORM 2500-DELETE-DEPOSIT       THRU 2500-EXIT         
             END-IF                                                     
           ELSE                                                         
             IF WS-AMT-DEPOSIT-NEW = WS-TOTAL-PAYMENTS                  
             PERFORM 8020-UPDATE-DEPHND-DT-CRT   THRU 8020-EXIT         
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF DELETE-NOT-PROCESSED                                      
              ADD  WS-DEP-CRED-AMT-DEC     TO DO-AMT-REFUNDED           
              MOVE 'SYSTEM'                TO DO-USER-ID-UPDT-BY        
              PERFORM 8040-UPDATE-DEPHND-DP-AMT  THRU 8040-EXIT         
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09390000
      ******************************************************************09400000
      * 2500-DELETE-DEPOSIT                                            *09410000
      *    -- THIS MODULE DELETES A DEPOSIT WHEN THE AMOUNT IS FORGIVEN*09420000
      *       AND NO PAYMENTS HAVE BEEN MADE.                          *09430000
      ******************************************************************09440000
       2500-DELETE-DEPOSIT.                                             
      *                                                                 09460000
           MOVE WS-Y                       TO WS-DELETE-DEP-SW.         
      *                                                                 09480000
           MOVE WS-ACCOUNT-NO              TO DO-ACCOUNT-NO,            
                                              DR-ACCOUNT-NO.            
      *                                                                 09510000
           MOVE WS-DEPOSIT-CERT-NO-NO                                   
                                           TO DO-DEPOSIT-CERT-NO,       
                                              DR-DEP-ITEM-ID.           
      *                                                                 09550000
           MOVE +80                        TO DR-PYMT-PRIORITY-LVL.     
      *                                                                 09570000
           PERFORM 8450-DELETE-DEP-ON-HAND       THRU 8450-EXIT.        
           IF WS-ACTIVE-RETURN-CODE          = SUCCESSFUL-CALL          
              PERFORM 8300-UPDATE-NSF-HIST       THRU 8300-EXIT         
           END-IF.                                                      
           PERFORM 8500-DELETE-DEP-REQ           THRU 8500-EXIT.        
      *                                                                 09630000
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09670000
      * 2700-PERFORM-JOURNALING.                                       *09680000
      *    -- THIS MODULE PREPARES WORKING STORAGE VARIABLES FOR THE   *09690000
      *       JOURNALING PROCESSING THAT IS TO BE COMPLETED AS A       *09700000
      *       RESULT OF UPDATING A DEPOSIT ON HAND RECORD.             *09710000
      ******************************************************************09720000
       2700-PERFORM-JOURNALING.                                         
      *                                                                 09740000
           PERFORM 7650-GET-TIMESTAMP-AND-DATE   THRU 7650-EXIT.        
                                                                        
      *--- ASSIGN DUMMY CASH DRAWER VALUES                              09800000
           MOVE '01'                       TO WS-CD-COMPANY-NO.         
           MOVE '998'                      TO WS-CD-LOCAL-OFFICE.       
           MOVE '998'                      TO WS-CD-REPORT-NO.          
           MOVE CURRENT-DATE               TO WS-CD-REPORT-DATE.        
           MOVE 9999                       TO WS-CASH-DRAWER-ID.        
                                                                        
           PERFORM 2750-AR-TRANS-JOURNALING      THRU 2750-EXIT.        
           PERFORM 2760-CASH-DRAWER-101          THRU 2760-EXIT.        
      *                                                                 09890000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09920000
      ******************************************************************09930000
      * 2750-AR-TRANS-JOURNALING.                                      *09940000
      *     -- THIS MODULE WRITES AN A/R TRANSACTION JOURNAL           *09950000
      ******************************************************************09960000
       2750-AR-TRANS-JOURNALING.                                        
      *                                                                 09980000
           MOVE WS-ACCOUNT-NO              TO AR-ACCOUNT-NO             
                                              AU-ACCOUNT-NO.            
           MOVE CURRENT-TIMESTAMP          TO AR-TRANS-HIST-SEQ-NO      
                                              AU-TRANS-HIST-SEQ-NO.     
           MOVE CURRENT-DATE               TO AR-DATE-TRANS.            
           MOVE WS-TOTAL-AR-BALANCE        TO AR-AMT-BILLED-UNPAID.     
           MOVE VALUE-SPACES               TO AR-PYMT-FACILITY-CD.      
           MOVE SPACES                     TO AR-RESP-AREA-ID.          
           MOVE 'SYSTEM'                   TO AR-USER-ID.               
           MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
           MOVE VALUE-SPACES               TO AR-RECORD-ONLY-FL.        
           MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
      *                                                                 10150000
P00399     IF PRE-BIL-DEP-REVIEW                                        
P00399        MOVE DP-DEPOSIT-CERT-NO      TO WS-DEP-CERT-NO            
P00399        MOVE 'PCSCA348A'             TO AR-APPL-PROGRAM-ID        
P00399        MOVE +50                     TO WS-COMMENTS-LEN           
P00399        MOVE WS-COMMENTS-LEN         TO AR-TRAN-COMMENT-LEN       
P00399        MOVE WS-COMMENTS-TEXT-1      TO AR-TRAN-COMMENT-TEXT      
P00399     ELSE                                                         
P00399        MOVE 'PCSCA348'              TO AR-APPL-PROGRAM-ID        
P00399        MOVE +133                    TO WS-COMMENTS-LEN           
P00399        MOVE WS-COMMENTS-LEN         TO AR-TRAN-COMMENT-LEN       
P00399        MOVE WS-COMMENTS-TEXT        TO AR-TRAN-COMMENT-TEXT      
P00399     END-IF.                                                      
      *                                                                 10150000
           MOVE WS-CD-COMPANY-NO           TO AR-CASH-COMPANY-NO.       
           MOVE WS-CD-LOCAL-OFFICE         TO AR-CASH-LOCAL-OFFICE.     
           MOVE WS-CD-REPORT-NO            TO AR-CASH-REPORT-NO.        
           MOVE WS-CD-REPORT-DATE          TO AR-DATE-CASH-REPORT.      
           MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
      *                                                                 10210000
      ***  RECORD PORTION THAT HAS BEEN PAID                            10220000
           MOVE 1                          TO AU-TRAN-APPL-NO.          
           MOVE WS-DEPOSIT-CERT-NO-NO      TO AU-ITEM-ID.               
           MOVE VALUE-SPACES               TO AU-CODE-AR-AGE            
                                              AU-CODE-CONTRACT-TYPE.    
           MOVE ' '                        TO AU-CURRENCY-TYPE.         
      *                                                                 10280000
           IF WS-HOLD-DEP-CRED-AMT-REMAIN  >  ZERO                      
              MOVE 'A'                     TO AR-CODE-TRAN-TYPE         
              MOVE WS-HOLD-DEP-CRED-AMT-REMAIN                          
                                           TO AR-AMT-ORIG-ENTERED       
                                              AU-CURRENCY-AMT           
                                              AU-AMT-POSTED             
              MOVE WS-GL-ACCT-NO-3         TO AU-GL-ACCT-CREDIT         
              MOVE WS-GL-ACCT-NO-AR-DEP    TO AU-GL-ACCT-DEBIT          
              PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST                     
                                                 THRU 6500-EXIT         
              PERFORM 7650-GET-TIMESTAMP-AND-DATE                       
                                                 THRU 7650-EXIT         
              MOVE CURRENT-TIMESTAMP       TO AR-TRANS-HIST-SEQ-NO      
                                              AU-TRANS-HIST-SEQ-NO      
           END-IF.                                                      
      *                                                                 10430000
           MOVE 'I'                     TO AR-CODE-TRAN-TYPE            
           MOVE WS-DEP-CRED-AMT-DEC     TO AR-AMT-ORIG-ENTERED          
                                           AU-CURRENCY-AMT              
                                           AU-AMT-POSTED                
           MOVE WS-GL-ACCT-NO-AR-DEP    TO AU-GL-ACCT-CREDIT            
           MOVE WS-GL-ACCT-NO-2         TO AU-GL-ACCT-DEBIT             
      *                                                                 10500000
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST                        
                                        THRU 6500-EXIT.                 
      *                                                                 10540000
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10570000
      ******************************************************************10580000
      * 2755-SET-100-JRNL-VARS.                                        *10590000
      *     -- THIS MODULE SETS UP ALL 100 CODE WORKING STORAGE        *10600000
      *        VARIABLES THAT ARE USED IN THE CASH AND MISCELLANEOUS   *10610000
      *        JOURNALING PROCESS.                                     *10620000
      ******************************************************************10630000
       2755-SET-100-JRNL-VARS.                                          
      *                                                                 10650000
           MOVE 9                          TO WS-TRAN-OPER-LEVEL.       
           MOVE 1                          TO WS-TRAN-OCAP-FIELD.       
           MOVE 1                          TO WS-TRAN-OCAP-VALUE.       
           MOVE 'C'                        TO WS-TRAN-JRNL-TYPE         
           MOVE 'N'                        TO WS-TRAN-HOLD-EXEMPT-FLAG. 
      *                                                                 10710000
           MOVE 'SYSTEM'                   TO WS-JRNL-OL-TEMP-ID.       
      *                                                                 10730000
           MOVE WS-JRNL-OL-OPR-LOC         TO WS-TERM-LOC.              
      *                                                                 10750000
           MOVE 'B'                        TO WS-JRNL-SOURCE-CODE.      
           MOVE WS-CD-COMPANY-NO           TO WS-JRNL-BT-BAT-COMPANY.   
           MOVE WS-CD-LOCAL-OFFICE         TO WS-JRNL-BT-BAT-LOC-OFF.   
           MOVE WS-CD-REPORT-NO            TO WS-JRNL-BT-BAT-REPORT-NO. 
           MOVE WS-CD-REPORT-DATE          TO WS-JRNL-BT-BAT-REPORT-DT. 
           MOVE WS-CASH-DRAWER-ID          TO WS-JRNL-BT-BAT-CASH-DRWR. 
C32909     MOVE '01'                       TO WS-100-COMPANY-NO.        
      *                                                                 10830000
           MOVE WS-JRNL-SELECT-AND-OR-INS  TO WS-JRNL-OPERATION-RQST.   
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-BT-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-BT-AUTH-TYPE
           END-IF.     
              PERFORM 6400-BATCH-JRNL-ROUTINE    THRU 6400-EXIT.        
                                                                        
      *                                                                 10900000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
A05154        DISPLAY ' ABENDING PROGRAM - 2755-SET-100-JRNL-VARS '     
A05154        DISPLAY ' WS-JRNL-RTRN-CODE = ' WS-JRNL-RTRN-CODE         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 10960000
           MOVE AU-TRAN-APPL-NO            TO WS-100-JRNL-TRAN-APPL-NO. 
           MOVE 'A'                        TO WS-100-JRNL-SORT-ID.      
C32909     MOVE '01'                       TO WS-100-COMPANY-NO.        
           MOVE AT-ACCOUNT-NO              TO WS-100-ACCT-NO.           
           MOVE AT-CUSTOMER-NO             TO WS-100-CUSTOMER-NO.       
           MOVE AT-PREMISE-NO              TO WS-100-PREMISE-NO.        
           MOVE AT-LOCAL-OFFICE            TO WS-100-LOCAL-OFFICE-CD.   
           MOVE 1                          TO WS-100-JRNL-TRAN-APPL-NO. 
           MOVE AT-DATE-LAST-ACTION        TO WS-100-DATE-LAST-ACTION.  
           MOVE 'B'                        TO WS-100-CODE-ENTRY-SOURCE. 
           MOVE SPACES                     TO WS-100-TRANS-ERRORS.      
      *                                                                 11080000
       2755-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11110000
      ******************************************************************11120000
      * 2760-CASH-DRAWER-101.                                          *11130000
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL      *11140000
      ******************************************************************11150000
       2760-CASH-DRAWER-101.                                            
      *                                                                 11170000
           PERFORM 7920-GET-CUSTOMER-INFO        THRU 7920-EXIT.        
           PERFORM 7940-GET-PREMISE-INFO         THRU 7940-EXIT.        
           PERFORM 2755-SET-100-JRNL-VARS        THRU 2755-EXIT.        
      *                                                                 11210000
           MOVE 101                        TO WS-101-JRNL-FORMAT-NO.    
           MOVE SPACES                     TO WS-101-CASH-DRAWER-USED.  
           MOVE WS-DEP-CRED-AMT-DEC        TO WS-101-AMOUNT-ENTERED     
                                              WS-101-AMT-POSTED.        
           MOVE AU-GL-ACCT-CREDIT          TO WS-101-ACCT-GEN-LED-CR.   
           MOVE AU-GL-ACCT-DEBIT           TO WS-101-ACCT-GEN-LED-DR.   
           MOVE AU-CODE-AR-AGE             TO WS-101-AR-AGE.            
           MOVE CURRENT-DATE               TO WS-101-DATE-AR-BILLED.    
           MOVE WS-DEPOSIT-CERT-NO-NO      TO WS-101-ITEM-ID-NO         
           MOVE AC-AMT-TRAN-BALANCE        TO WS-101-DETAIL-END-BAL     
           ADD  AC-AMT-AR-DAY-00, AC-AMT-AR-DAY-30,                     
                AC-AMT-AR-DAY-60, AC-AMT-AR-DAY-90                      
                GIVING  WS-101-DETAIL-END-AR-BAL.                       
           MOVE AT-TOTAL-AR-BALANCE        TO WS-101-ACCT-END-AR-BAL.   
           MOVE SPACES                     TO WS-101-FUNCTION-CODE.     
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT          TO WS-101-CODE-EMPL-ACCT.    
           MOVE AT-CODE-COMPANY-ACCT       TO WS-101-CODE-COMPANY-ACCT. 
           MOVE AT-CODE-ACCT-STAT         TO WS-101-CODE-ACCOUNT-STATUS.
           MOVE PR-CODE-PREMISE-STAT      TO WS-101-CODE-PREMISE-STATUS.
           MOVE AU-AMT-POSTED              TO WS-JRNL-GEN-LEG-DEBIT-AMT 
                                              WS-JRNL-RCV-CREDIT-AMT.   
      *                                                                 11440000
           MOVE CJF00101                   TO WS-100-USER-DEFINED-AREA. 
      *                                                                 11460000
           MOVE WS-JRNL-ONLY               TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-BATCH-JRNL-ROUTINE       THRU 6400-EXIT.        
      *                                                                 11490000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
A05154        DISPLAY ' ABENDING PROGRAM - 2760-CASH-DRAWER-101 '       
A05154        DISPLAY ' AFTER FIRST 6400-BATCH-JRNL-ROUTINE '           
A05154        DISPLAY ' WS-JRNL-RTRN-CODE = ' WS-JRNL-RTRN-CODE         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 11550000
           MOVE WS-JRNL-CNTRL-ONLY         TO WS-JRNL-OPERATION-RQST.   
           PERFORM 6400-BATCH-JRNL-ROUTINE       THRU 6400-EXIT.        
      *                                                                 11580000
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
A05154        DISPLAY ' ABENDING PROGRAM - 2760-CASH-DRAWER-101 '       
A05154        DISPLAY ' AFTER SECOND 6400-BATCH-JRNL-ROUTINE '          
A05154        DISPLAY ' WS-JRNL-RTRN-CODE = ' WS-JRNL-RTRN-CODE         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 11640000
       2760-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11670000
      * 2920-UPDATE-AT.                                                *11680000
      *    -- THIS MODULE CHECKS THE  DEP PRESENT AND UPDATES THE      *11690000
      *  TOTAL_AR_BALANCE AND CODES_DATA_PRESENT FOR THIS ACCOUNT      *11700000
      *  TO THE CSS_ACCOUNT TABLE.                                     *11710000
      ******************************************************************11720000
       2920-UPDATE-AT.                                                  
      *                                                                 11740000
           PERFORM 2930-CHECK-DEP-PRESENT        THRU 2930-EXIT.        
           MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT.    
           MOVE WS-TOTAL-AR-BALANCE        TO AT-TOTAL-AR-BALANCE.      
           PERFORM 8100-UPDATE-ACCOUNT-AR-BAL    THRU 8100-EXIT.        
                                                                        
       2920-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11820000
      * 2930-CHECK-DEP-PRESENT                                         *11830000
      *    -- THIS MODULE CHECKS IF ANY DEP_REQ AND DEP_ON_HAND RECORD *11840000
      *       PRESENT TO UPDATE THE CODES_DATA_PRESENT OF CSS_ACCOUNT  *11850000
      ******************************************************************11860000
       2930-CHECK-DEP-PRESENT.                                          
                                                                        
           PERFORM 7100-OPEN-DEP-REQ             THRU 7100-EXIT.        
           PERFORM 7110-FETCH-DEP-REQ            THRU 7110-EXIT.        
           PERFORM 7120-CLOSE-DEP-REQ            THRU 7120-EXIT.        
                                                                        
           IF WS-DEP-REQ-EXISTS = 'N'                                   
              MOVE SPACES                  TO WS-CODE-DEP-REQ           
           END-IF.                                                      
                                                                        
           PERFORM 7200-OPEN-DEP-ON-HAND         THRU 7200-EXIT.        
           PERFORM 7210-FETCH-DEP-ON-HAND        THRU 7210-EXIT.        
           PERFORM 7220-CLOSE-DEP-ON-HAND        THRU 7220-EXIT.        
                                                                        
           IF WS-DEP-ON-HAND-EXISTS = 'N'                               
              MOVE SPACES                  TO WS-CODE-DEP-ON-HAND       
           END-IF.                                                      
                                                                        
       2930-EXIT.                                                       
           EXIT.                                                        
P00399*                                                                         
P00399******************************************************************        
P00399* 5000-INSERT-REFUND.                                            *        
P00399******************************************************************        
P00399*                                                                         
P00399 5000-INSERT-REFUND.                                              
P00399*                                                                         
P00399     INITIALIZE DCLCSS-REFUND.                                    
P00399     MOVE WS-ACCOUNT-DEC              TO RN-ACCOUNT-NO.           
P00399*                                                                         
P00399     PERFORM 7010-GET-REFUND-ITEM-ID  THRU 7010-EXIT.             
P00399     ADD 1                            TO RN-REFUND-ITEM-ID.       
P00399*                                                                         
P00399     MOVE '0'                         TO RN-ORIGINAL-CHECK-NO     
P00399                                         RN-REFUND-CHECK-NO.      
P00399     MOVE WS-DEPOSIT-CERT-NO-NO       TO RN-DEPOSIT-CERT-NO.      
P00399     MOVE AT-LOCAL-OFFICE             TO RN-LOCAL-OFFICE.         
P00399     MOVE WS-DEPOSIT-CREDIT-AMT       TO RN-AMT-REFUNDED.         
P00399     MOVE WS-INPUT-DATE               TO RN-DATE-REFUNDED         
P00399                                         RN-REFUND-STATUS-DT      
P00399                                         RN-REQUEST-DT.           
P00399     MOVE 'SYSTEM'                    TO RN-USER-ID-RQSTED-BY     
P00399                                         RN-USER-ID-APPRVD-BY.    
P00399     MOVE 'G'                         TO RN-CHECK-ISS-REAS-CD     
P00399     MOVE 'E'                         TO RN-MANUAL-INDICATOR.     
P00399     MOVE 'BATC'                      TO RN-PANEL-NO.             
P00399     MOVE CURRENT-TIMESTAMP           TO RN-TRANS-HIST-SEQ-NO.    
P00399     MOVE 'CREDIT UNPAID DEPOSIT'     TO RN-COMMENTS-TEXT.        
P00399     MOVE +21                         TO RN-COMMENTS-LEN.         
P00399     PERFORM 8010-INSERT-REFUND       THRU 8010-EXIT.             
P00399*                                                                         
P00399 5000-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                         
      ************************************************************      12061001
      *                                                                 12062001
      * 6235-GET-FJC01-RESTART-REQ.                                     12063003
      ************************************************************      12064001
           EXEC SQL                                                     12065001
               INCLUDE CPD00035                                         12066001
           END-EXEC.                                                    12067001
                                                                        
      ******************************************************************12070000
      * 7000-SELECT-AR-CNTL-SUMM                                       *12080000
      *     -- THIS MODULE GETS THE AGING BUCKET INFORMATION FROM THE  *12090000
      *        SUMMARY RECORD IN THE CSS_AR_CNTL TABLE.                *12100000
      ******************************************************************12110000
       7000-SELECT-AR-CNTL-SUMM.                                        
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90                                     
                 INTO :SUMM-LAST-UPDATE-TS,                             
                      :SUMM-AMT-AR-DAY-00,                              
                      :SUMM-AMT-AR-DAY-30,                              
                      :SUMM-AMT-AR-DAY-60,                              
                      :SUMM-AMT-AR-DAY-90                               
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        
                  AND ITEM_ID           = 0                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12140000
MFA-TR*        SELECT LAST_UPDATE_TS,                                   12150000
MFA-TR*               AMT_AR_DAY_00,                                    12160000
MFA-TR*               AMT_AR_DAY_30,                                    12170000
MFA-TR*               AMT_AR_DAY_60,                                    12180000
MFA-TR*               AMT_AR_DAY_90                                     12190000
MFA-TR*          INTO :SUMM-LAST-UPDATE-TS,                             12200000
MFA-TR*               :SUMM-AMT-AR-DAY-00,                              12210000
MFA-TR*               :SUMM-AMT-AR-DAY-30,                              12220000
MFA-TR*               :SUMM-AMT-AR-DAY-60,                              12230000
MFA-TR*               :SUMM-AMT-AR-DAY-90                               12240000
MFA-TR*          FROM CSS_AR_CNTL                                       12250000
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                12260000
MFA-TR*           AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL        12270000
MFA-TR*           AND ITEM_ID           = 0                             12280000
MFA-TR*    END-EXEC.                                                    12290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7000-SELECT-AR-CNTL-SUMM   **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12440000
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00399*                                                                         
P00399***************************************************************** 28211000
P00399* 7010-GET-REFUND-ITEM-ID                                       * 28220000
P00399***************************************************************** 28260000
P00399*                                                                         
P00399 7010-GET-REFUND-ITEM-ID.                                         
P00399*                                                                 28290000
P00399     EXEC SQL                                                     
P00399        SELECT COALESCE(MAX(REFUND_ITEM_ID), 0)                   
P00399          INTO :RN-REFUND-ITEM-ID                                 
P00399          FROM CSS_REFUND WITH(READUNCOMMITTED)                           
P00399         WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        
P00399                                                           
P00399                                                      
P00399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28300000
MFA-TR*       SELECT COALESCE(MAX(REFUND_ITEM_ID), 0)                   28310000
MFA-TR*         INTO :RN-REFUND-ITEM-ID                                 28320000
MFA-TR*         FROM CSS_REFUND                                         28330000
MFA-TR*        WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        28340000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                    28350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399*                                                                 28360000
P00399     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00399*                                                                         
P00399     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00399        CONTINUE                                                  
P00399     ELSE                                                         
P00399        DISPLAY '*******************************************'     
P00399        DISPLAY '**   ERROR ON 7010-GET-REFUND-ITEM-ID    **'     
P00399        DISPLAY '**   ACCOUNT-NO  = ' RN-ACCOUNT-NO               
P00399        DISPLAY '**   SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
P00399        DISPLAY '**       PROCESSING TERMINATED           **'     
P00399        DISPLAY '*******************************************'     
P00399        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00399     END-IF.                                                      
P00399*                                                                 28540000
P00399 7010-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                 28540000
      ******************************************************************12480000
      * 7100-OPEN-DEP-REQ                                              *12490000
      *      OPEN THE CURSOR TO SELECT DEP_REQ DETAILS FOR A GIVEN     *12500000
      *      ACCOUNT-NO WITH PAYMENT PRIORITY = 80                     *12510000
      ******************************************************************12520000
                                                                        
       7100-OPEN-DEP-REQ.                                               
                                                                        
           EXEC SQL                                                     
                OPEN DEP_REQ                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7100-OPEN-DEP-REQ          **'        
              DISPLAY '**      ERROR DURING OPEN FOR         **'        
              DISPLAY '**             DEP_REQ                **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12760000
      *                                                                *12770000
      *   7110-FETCH-CURSOR.                                           *12780000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *12790000
      *                                                                *12800000
      ******************************************************************12810000
       7110-FETCH-DEP-REQ.                                              
                                                                        
           EXEC SQL                                                     
                FETCH  DEP_REQ     INTO                                 
                       :WS-DEP-REQ-EXISTS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7110-FETCH-DEP-REQ         **'        
              DISPLAY '**      ERROR DURING FETCH FOR        **'        
              DISPLAY '**             DEP_REQ                **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13040000
      ******************************************************************13050000
      *   7120-CLOSE-CURSOR.                                           *13060000
      *        CLOSES THE OPENED CURSOR                                *13070000
      ******************************************************************13080000
       7120-CLOSE-DEP-REQ.                                              
                                                                        
           EXEC SQL                                                     
                CLOSE DEP_REQ                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7120-CLOSE-DEP-REQ         **'        
              DISPLAY '**      ERROR DURING CLOSE FOR        **'        
              DISPLAY '**             DEP_REQ                **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13310000
      * 7200-OPEN-DEP-ON-HAND                                          *13320000
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *13330000
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A' OR 'P'               *13340000
      ******************************************************************13350000
                                                                        
       7200-OPEN-DEP-ON-HAND.                                           
                                                                        
           EXEC SQL                                                     
                OPEN DEP_ON_HAND                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7200-OPEN-DEP-ON-HAND      **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             DEP_ON_HAND            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13580000
      ******************************************************************13590000
      *   7210-FETCH-CURSOR.                                           *13600000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *13610000
      *                                                                *13620000
      ******************************************************************13630000
       7210-FETCH-DEP-ON-HAND.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DEP_ON_HAND INTO                                 
                       :WS-DEP-ON-HAND-EXISTS                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7210-FETCH-DEP-ON-HAND     **'        
              DISPLAY '**      ERROR DURING FETCH FOR        **'        
              DISPLAY '**             DEP_ON_HAND            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13860000
      ******************************************************************13870000
      *   7220-CLOSE-CURSOR.                                           *13880000
      *        CLOSES THE OPENED CURSOR                                *13890000
      ******************************************************************13900000
       7220-CLOSE-DEP-ON-HAND.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE DEP_ON_HAND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7220-CLOSE-DEP-ON-HAND     **'        
              DISPLAY '**      ERROR DURING CLOSE FOR        **'        
              DISPLAY '**             DEP_ON_HAND            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32909******************************************************************        
C32909* 7268-CHK-OTHER-RECEIVABLES                                     *        
C32909******************************************************************        
C32909 7268-CHK-OTHER-RECEIVABLES.                                      
C32909                                                                  
C32909     EXEC SQL                                                     
C32909          SELECT TOP(1) 'Y'                                              
C32909            INTO :WS-OTHER-RECV                                   
C32909            FROM CSS_AR_CNTL                                      
C32909           WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      
C32909             AND PYMT_PRIORITY_LVL <> 80                          
C32909             AND (AMT_AR_DAY_00     <> 0                          
C32909                  OR AMT_AR_DAY_30     <> 0                       
C32909                  OR AMT_AR_DAY_60     <> 0                       
C32909                  OR AMT_AR_DAY_90     <> 0                       
C32909                  OR AMT_UNUSED_CR     <> 0                       
C32909                  OR AMT_TRAN_BALANCE  <> 0                       
C32909                  OR TOT_SUMM_UNBILLED <> 0)                      
C32909                                            
C32909     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-OTHER-RECV                                           
MFA-TR*           FROM CSS_AR_CNTL                                              
MFA-TR*          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                              
MFA-TR*            AND PYMT_PRIORITY_LVL <> 80                                  
MFA-TR*            AND (AMT_AR_DAY_00     <> 0                                  
MFA-TR*                 OR AMT_AR_DAY_30     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_60     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_90     <> 0                               
MFA-TR*                 OR AMT_UNUSED_CR     <> 0                               
MFA-TR*                 OR AMT_TRAN_BALANCE  <> 0                               
MFA-TR*                 OR TOT_SUMM_UNBILLED <> 0)                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32909                                                                  
C32909     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C32909                                                                  
C32909     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C32909        NEXT SENTENCE                                             
C32909     ELSE                                                         
C32909         DISPLAY '** ERROR IN 7268-CHK-OTHER-RECEIVABLES**'       
C32909         DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
C32909         DISPLAY 'ACCOUNT NO =' AC-ACCOUNT-NO                     
C32909         DISPLAY '**      PROCESSING IS TERMINATED     **'        
C32909         PERFORM 9900-ABEND                THRU 9900-EXIT         
C32909     END-IF.                                                      
C32909                                                                  
C32909 7268-EXIT.                                                       
C32909     EXIT.                                                        
C32909*                                                                         
                                                                        
      ******************************************************************14130000
      * 7300-SELECT-DEP-ON-HAND                                        *14140000
      *     -- GET CURRENT VALUES IN DB2                               *14150000
      ******************************************************************14160000
       7300-SELECT-DEP-ON-HAND.                                         
      *                                                                 14180000
           EXEC SQL                                                     
               SELECT AMT_DEPOSIT,                                      
                      DATE_CERT_ISSUE,                                  
                      DATE_REFUNDED,                                    
                      AMT_REFUNDED,                                     
                      CODE_REFUND_REASON,                               
                      COMMENTS                                          
                     ,CODE_DEP_TYPE                                     
                 INTO :DO-AMT-DEPOSIT,                                  
                      :DO-DATE-CERT-ISSUE :WS-NULL-IND-1,               
                      :DO-DATE-REFUNDED :WS-NULL-IND-2,                 
                      :DO-AMT-REFUNDED,                                 
                      :DO-CODE-REFUND-REASON,                           
                      :DO-COMMENTS                                      
                     ,:DO-CODE-DEP-TYPE                                 
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND DEPOSIT_CERT_NO = :WS-DEPOSIT-CERT-NO-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 14380000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 14400000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7300-SELECT-DEP-ON-HAND    **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**          CSS_DEP_ON_HAND           **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14520000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14550000
      ******************************************************************14560000
      * 7350-GET-ACCOUNT-INFO                                          *14570000
      *    -- THIS MODULE OBTAINS INFORMATION ON A SPECIFIC ACCOUNT    *14580000
      ******************************************************************14590000
       7350-GET-ACCOUNT-INFO.                                           
      *                                                                 14610000
           EXEC SQL                                                     
               SELECT COMPANY_NO,                                       
                      CODE_COMPANY_ACCT,                                
                      CODE_ACCT_STAT,                                   
                      PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      DATE_LAST_ACTION,                                 
                      LOCAL_OFFICE,                                     
                      ACCOUNT_NO,                                       
                      TOTAL_AR_BALANCE,                                 
                      CODES_DATA_PRESENT                                
                 INTO :AT-COMPANY-NO,                                   
                      :AT-CODE-COMPANY-ACCT,                            
                      :AT-CODE-ACCT-STAT,                               
                      :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-DATE-LAST-ACTION,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-ACCOUNT-NO,                                   
                      :AT-TOTAL-AR-BALANCE,                             
                      :AT-CODES-DATA-PRESENT                            
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7350-GET-ACCOUNT-INFO      **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_ACCOUNT            **'        
              DISPLAY '**  ACCOUNT NO =' WS-ACCOUNT-NO                  
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 14990000
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15020000
      ******************************************************************15030000
      * 7400-GET-AR-CNTL-INFO.                                         *15040000
      *     -- THIS MODULE GETS THE AGING BUCKET INFORMATION FROM THE  *15050000
      *        DEPOSIT RECORD IN THE CSS_AR_CNTL TABLE.                *15060000
      ******************************************************************15070000
       7400-GET-AR-CNTL-INFO.                                           
      *                                                                 15090000
           EXEC SQL                                                     
               SELECT AMT_TRAN_BALANCE,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                      AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90,                                    
                      AMT_UNUSED_CR                                     
                 INTO :AC-AMT-TRAN-BALANCE,                             
                      :AC-LAST-UPDATE-TS,                               
                      :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90,                                
                      :AC-AMT-UNUSED-CR                                 
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :AC-ITEM-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     15100000
MFA-TR*        SELECT AMT_TRAN_BALANCE,                                 15110000
MFA-TR*               LAST_UPDATE_TS,                                   15120000
MFA-TR*               AMT_AR_DAY_00,                                    15130000
MFA-TR*               AMT_AR_DAY_30,                                    15140000
MFA-TR*               AMT_AR_DAY_60,                                    15150000
MFA-TR*               AMT_AR_DAY_90,                                    15160000
MFA-TR*               AMT_UNUSED_CR                                     15170000
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE,                             15180000
MFA-TR*               :AC-LAST-UPDATE-TS,                               15190000
MFA-TR*               :AC-AMT-AR-DAY-00,                                15200000
MFA-TR*               :AC-AMT-AR-DAY-30,                                15210000
MFA-TR*               :AC-AMT-AR-DAY-60,                                15220000
MFA-TR*               :AC-AMT-AR-DAY-90,                                15230000
MFA-TR*               :AC-AMT-UNUSED-CR                                 15240000
MFA-TR*          FROM CSS_AR_CNTL                                       15250000
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                15260000
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         15270000
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                   15280000
MFA-TR*    END-EXEC.                                                    15290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15300000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 15320000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7400-GET-AR-CNTL-INFO      **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  ACCOUNT NO = ' AC-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15460000
C32909 7410-GET-DELINQ-VALUE.                                           
C32909                                                                  
C32909     EXEC SQL                                                     
C32909       SELECT DELINQ_VALUE                                        
C32909         INTO :C8-DELINQ-VALUE                                    
C32909         FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
C32909        WHERE DELINQ_CD = :C8-DELINQ-CD                           
C32909          AND COMPANY_NO = :C8-COMPANY-NO                         
C32909                                                           
C32909     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32909                                                                  
C32909     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C32909       NEXT SENTENCE                                              
C32909     ELSE                                                         
C32909         DISPLAY '** ERROR IN 7410-GET-DELINQ-VALUE **'           
C32909         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
C32909         DISPLAY '** DELINQ CD =' C8-DELINQ-CD                    
C32909         DISPLAY '** COMPANY NO =' C8-COMPANY-NO                  
C32909         DISPLAY '**      PROCESSING IS TERMINATED     **'        
C32909         PERFORM 9900-ABEND                THRU 9900-EXIT         
C32909     END-IF.                                                      
C32909                                                                  
C32909 7410-EXIT.                                                       
C32909     EXIT.                                                        
C32909*                                                                         
      *************************************************************     15470000
      * THIS PARA READS CSS_AR_CNTL TO FIND IF THERE ARE ANY DEPOSIT    15480000
      * RECORD. IF NOT FOUND, THEN THE SUMMARY RECORD CAN BE DELETED.   15490000
      *************************************************************     15500000
       7450-SELECT-ARCNTL.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                 INTO :WS-DEP-DET-FOUND                                 
              FROM CSS_AR_CNTL                                          
                 WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO AND                
                        PYMT_PRIORITY_LVL = 080      AND                
                        ITEM_ID  <>  0               AND                
                        ITEM_ID  <> :WS-DEPOSIT-CERT-NO-NO              
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     15530000
MFA-TR*       SELECT 'Y'                                                15540000
MFA-TR*          INTO :WS-DEP-DET-FOUND                                 15550000
MFA-TR*       FROM CSS_AR_CNTL                                          15560000
MFA-TR*          WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO AND                15570000
MFA-TR*                 PYMT_PRIORITY_LVL = 080      AND                15580000
MFA-TR*                 ITEM_ID  <>  0               AND                15590000
MFA-TR*                 ITEM_ID  <> :WS-DEPOSIT-CERT-NO-NO              15600000
MFA-TR*       FETCH FIRST ROW ONLY                                      15610000
MFA-TR*    END-EXEC.                                                    15620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 15630000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 15650000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7450-SELECT-ARCNTL         **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
            EXIT.                                                       
      *                                                                 15790000
      ******************************************************************15800000
      *  7500-READ-FCSCA347                                            *15810000
      *                                                                *15820000
      *  READ AND PROCESS DATA IN THE FCSCA347 FILE.                   *15830000
      ******************************************************************15840000
                                                                        
       7500-READ-FCSCA347.                                              
                                                                        
           READ FCSCA347-FILE                                           
               AT END                                                   
                 MOVE WS-Y                 TO WS-NO-MORE-DATA           
                 GO                        TO 7500-EXIT.                
           IF FCA347-SUCCESSFUL                                         
              ADD 1                        TO  WS-RESTRT-FCA347R-COUNT  
                                               WS-FCS347-REC-CNTR       
              MOVE   'Y'                   TO  WS-PROCESS-RECORD-SW     
           ELSE                                                         
              DISPLAY '**    PCSCA348 PROCESSING ERROR   **'            
              DISPLAY '**   FCSCA347-FILE WILL NOT READ   **'           
              DISPLAY '**      PROCESSING TERMINATED     **'            
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16050000
      ******************************************************************16060000
      **  7550-GET-CURRENT-DATE.                                       *16070000
      **                                                               *16080000
      **  GETS CURRENT DATE                                            *16090000
      ******************************************************************16100000
       7550-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16130000
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     16140000
MFA-TR*    END-EXEC.                                                    16150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '********** PCSCA348 ABORT ************'         
               DISPLAY '* 7550-GET-CURRENT-DATE              *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA348 ABORT ************'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 16290000
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16320000
      ******************************************************************16330000
      * 7650-GET-TIMESTAMP-AND-DATE.                                   *16340000
      *   -- THIS MODULE OBTAINS THE CURRENT TIME AND DATE FOR CRATING *16350000
      *      THE JOURNAL ENTRIES.                                      *16360000
      ******************************************************************16370000
       7650-GET-TIMESTAMP-AND-DATE.                                     
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :CURRENT-TIMESTAMP               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16400000
MFA-TR*       SET :CURRENT-TIMESTAMP =  CURRENT TIMESTAMP               16410000
MFA-TR*    END-EXEC.                                                    16420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :CURRENT-DATE                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16440000
MFA-TR*       SET :CURRENT-DATE      =  CURRENT DATE                    16450000
MFA-TR*    END-EXEC.                                                    16460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7650-GET-TIMESTAMP-AND-DATE**'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**                                    **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 16600000
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16630000
      ******************************************************************16640000
      * 7700-CHECK-AR-CNTL-AMT-RECVBL.                                 *16650000
      *    -- THIS MODULE CHECKS IF THERE ARE ROW ON AR_CNTL.          *16660000
      *       IF THERE ARE NO ROWS ON AR_CNTL AND DEP_REQ,THE          *16670000
      *       DEPOSIT HAS BEEN PAID ALREADY.IF THERE ARE ROWS          *16680000
      *       ON BOTH,NOTHING HAS BEEN PAID ON THE DEPOSIT.            *16690000
      ******************************************************************16700000
       7700-CHECK-AR-CNTL-AMT-RECVBL.                                   
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                INTO :WS-AC-EXISTS                                      
                FROM CSS_AR_CNTL                                        
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL =  80                           
                  AND ITEM_ID           =  :AC-ITEM-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA-7700-CHECK-AR-CNTL-AMT-RECVBL**'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16980000
      ******************************************************************16990000
      * 7750-CHECK-DEP-REQ-AMT-RECVBL.                                 *17000000
      *    -- THIS MODULE CHECKS IF THERE ARE ROW ON DEP_REQ.          *17010000
      *       IF THERE ARE NO ROWS ON AR_CNTL AND DEP_REQ,THE          *17020000
      *       DEPOSIT HAS BEEN PAID ALREADY.IF THERE ARE ROWS          *17030000
      *       ON BOTH,NOTHING HAS BEEN PAID ON THE DEPOSIT.            *17040000
      ******************************************************************17050000
       7750-CHECK-DEP-REQ-AMT-RECVBL.                                   
                                                                        
           EXEC SQL                                                     
                SELECT 'Y'                                              
                INTO :WS-DR-EXISTS                                      
                FROM CSS_DEP_REQ                                        
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL =  80                           
                  AND DEP_ITEM_ID       =  :WS-DEPOSIT-CERT-NO-NO       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA-7750-CHECK-DEP-REQ-AMT-RECVBL**'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_DEP_REQ            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 17300000
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17330000
      ******************************************************************17340000
      * 7800-GET-GL-ACCT                                               *17350000
      *    -- THIS MODULE OBTAINS THE GL ACCOUNT NUMBER FOR A DEPOSIT  *17360000
      ******************************************************************17370000
       7800-GET-GL-ACCT.                                                
      *                                                                 17390000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO                                    
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17470000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 17490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7800-GET-GL-ACCT           **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**            CSS_GL_ACCT_NO          **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 17600000
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17630000
      ******************************************************************17640000
      * 7850-GET-GL-ACCT-2                                             *17650000
      *    -- THIS MODULE OBTAINS THE OFFSET GL ACCOUNT NUMBER         *17660000
      *       FOR A DEPOSIT.                                           *17670000
      ******************************************************************17680000
       7850-GET-GL-ACCT-2.                                              
      *                                                                 17700000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :WS-GL-ACCT-NO-2                                  
                 FROM CSS_GL_ACCT_NO                                    
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME-2                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17780000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 17800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7850-GET-GL-ACCT-2         **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_GL_ACCT_NO         **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 17910000
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17940000
      ******************************************************************17950000
      * 7900-GET-GL-ACCT-3                                             *17960000
      *    -- THIS MODULE OBTAINS THE AR-DFA    ACCOUNT NUMBER.        *17970000
      ******************************************************************17980000
       7900-GET-GL-ACCT-3.                                              
      *                                                                 18000000
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :WS-GL-ACCT-NO-3                                  
                 FROM CSS_GL_ACCT_NO                                    
                WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :WS-GL-ACCT-NAME-3                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18080000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 18100000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7900-GET-GL-ACCT-3         **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_GL_ACCT_NO         **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18210000
       7900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************18240000
      * 7920-GET-CUSTOMER-INFO.                                        *18250000
      *    -- THIS MODULE OBTAINS THE EMPLOYEE ACCOUNT CODE.           *18260000
      ******************************************************************18270000
       7920-GET-CUSTOMER-INFO.                                          
      *                                                                 18290000
           EXEC SQL                                                     
               SELECT CODE_EMPL_ACCT                                    
                 INTO :CU-CODE-EMPL-ACCT                                
                 FROM CSS_CUSTOMER                                      
                WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18360000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 18380000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7920-GET-CUSTOMER-INFO     **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_CUSTOMER           **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18490000
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18520000
      ******************************************************************18530000
      * 7940-GET-PREMISE-INFO.                                         *18540000
      *    -- THIS MODULE OBTAINS THE REVENUE DISTRICT AND THE         *18550000
      *       PREMISE ACCOUNT CODE.                                    *18560000
      ******************************************************************18570000
       7940-GET-PREMISE-INFO.                                           
      *                                                                 18590000
           EXEC SQL                                                     
               SELECT REV_DISTRICT_CD,                                  
                      CODE_PREMISE_STAT                                 
                 INTO :PR-REV-DISTRICT-CD,                              
                      :PR-CODE-PREMISE-STAT                             
                 FROM CSS_PREMISE                                       
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18680000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 18700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7940-GET-PREMISE-INFO      **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_PREMISE            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18810000
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18840000
      ******************************************************************18850000
      *   7960-SELECT-FOR-RESTART.                                     *18860000
      *                                                                *18870000
      *        CHECK CSS_RESTART TABLE TO SEE IF THIS IS A RESTART OR  *18880000
      *   A NORMAL RUN.  IF A ROW IS FOUND IN THIS TABLE FOR PROGRAM   *18890000
      *   PCSCA348, THE RESTART LOGIC IS EXECUTED.  OTHERWISE, NORMAL  *18900000
      *   PROCESSING IS FOLLOWED.                                      *18910000
      ******************************************************************18920000
       7960-SELECT-FOR-RESTART.                                         
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL  OR NOT-FOUND 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7960-PREPARE-FOR-RESTART   **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_RESTART            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 19150000
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19180000
      ***************************************************************** 19190000
      * 7990-SELECT-DEP-PAY-AMT                                       * 19200000
      *                                                               * 19210000
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 19220000
      ***************************************************************** 19230000
      *                                                                 19240000
       7990-SELECT-DEP-PAY-AMT.                                         
      *                                                                 19260000
           EXEC SQL                                                     
              SELECT   SUM(DEP_PAY_AMT)                                 
                INTO   :WS-TOTAL-PAYMENTS :WS-TOTAL-PAYMENTS-NI          
                FROM   CSS_DEP_PAY_HST                                  
               WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
                 AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19340000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 19360000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C32909        IF  WS-TOTAL-PAYMENTS-NI < 0                              
C32909            MOVE ZEROES TO WS-TOTAL-PAYMENTS                      
C32909                           WS-TOTAL-PAYMENTS-NI                   
C32909        END-IF                                                    
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 7990-SELECT-DEP-PAY-AMT    **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_DEP_PAY_HST        **'        
              DISPLAY '**  ACCOUNT NO = ' DP-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 19480000
       7990-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19511017
      ************************************************************      19512017
      **  7995-SELECT-REG-PROFILE.                              **      19513017
      **      TO CHECK WHETHER THE ACCT IS SEBR ACCOUNT         **      19514017
      ************************************************************      19515017
       7995-SELECT-REG-PROFILE.                                         
      *                                                                 19517017
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                 INTO :WS-ACCOUNT-NO                                    
                 FROM CSS_REG_PROFILE                                   
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE  'REGULATED'  TO WS-REG-GROUP-CD                
               WHEN NOT-FOUND                                           
                   MOVE 'DEREGULATED' TO WS-REG-GROUP-CD                
               WHEN OTHER                                               
                   DISPLAY '** PCSCA348 PROCESSING ERROR        **'     
                   DISPLAY '** ERROR ON REG PROFILE             **'     
                   DISPLAY '** PARA 7995-SELECT-REG-PROFILE     **'     
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED            **'     
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
           END-EVALUATE.                                                
       7995-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19521217
      ******************************************************************19522000
      *8000-UPDATE-DEPHND-DEP-STA.                                     *19530000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *19540000
      *       CSS_DEP_ON_HAND TABLE.                                   *19550000
      ******************************************************************19560000
      *                                                                 19570000
       8000-UPDATE-DEPHND-DEP-STA.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_DEP_ON_HAND                                    
              SET  DEPOSIT_STATUS_CD   = 'R'                            
                WHERE ACCOUNT_NO       = :WS-ACCOUNT-NO                 
                 AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19660000
                MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE     
      *                                                                 19680000
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'    
                  DISPLAY '**  PARA - 8000-UPDATE-DEPHND-DEP-STA **'    
                  DISPLAY '**      ERROR DURING SELECT FOR       **'    
                  DISPLAY '**            CSS_DEP_ON_HAND         **'    
                  DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO             
                  DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE             
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
               END-IF.                                                  
      *                                                                 19800000
       8000-EXIT.                                                       
           EXIT.                                                        
P00399*                                                                         
P00399******************************************************************37462000
P00399* 8010-INSERT-REFUND                                             *37470000
P00399******************************************************************37500000
P00399*                                                                         
P00399 8010-INSERT-REFUND.                                              
P00399*                                                                 37530000
P00399     EXEC SQL                                                     
P00399        INSERT INTO CSS_REFUND                                    
P00399               (ACCOUNT_NO,                                       
P00399                REFUND_ITEM_ID,                                   
P00399                AMT_REFUNDED,                                     
P00399                CHECK_STATUS_CD,                                  
P00399                CHECK_ISS_REAS_CD,                                
P00399                COMMENTS,                                         
P00399                DATE_REFUNDED,                                    
P00399                REQUEST_DT,                                       
P00399                DEPOSIT_CERT_NO,                                  
P00399                PANEL_NO,                                         
P00399                USER_ID_RQSTED_BY,                                
P00399                MANUAL_INDICATOR,                                 
P00399                REFUND_CHECK_NO,                                  
P00399                LOCAL_OFFICE,                                     
P00399                ORIGINAL_CHECK_NO,                                
P00399                RETURNED_REASON,                                  
P00399                USER_ID_APPRVD_BY,                                
P00399                REFUND_STATUS_DT,                                 
P00399                TRANS_HIST_SEQ_NO,                                
P00399                ADDRESS_ID,                                       
P00399                ACCT_NO_CREDITED)                                 
P00399        VALUES (:RN-ACCOUNT-NO,                                   
P00399                :RN-REFUND-ITEM-ID,                               
P00399                :RN-AMT-REFUNDED,                                 
P00399                :RN-CHECK-STATUS-CD,                              
P00399                :RN-CHECK-ISS-REAS-CD,                            
P00399                :RN-COMMENTS,                                     
P00399                IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) ),                           
P00399                IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                            :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-1) ),            
P00399                :RN-DEPOSIT-CERT-NO,                              
P00399                :RN-PANEL-NO,                                     
P00399                :RN-USER-ID-RQSTED-BY,                            
P00399                :RN-MANUAL-INDICATOR,                             
P00399                :RN-REFUND-CHECK-NO,                              
P00399                :RN-LOCAL-OFFICE,                                 
P00399                :RN-ORIGINAL-CHECK-NO,                            
P00399                :RN-RETURNED-REASON,                              
P00399                :RN-USER-ID-APPRVD-BY,                            
P00399                IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
P00399                CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                
P00399                :RN-ADDRESS-ID,                                   
P00399                :RN-ACCT-NO-CREDITED)                             
P00399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     37540000
MFA-TR*       INSERT INTO CSS_REFUND                                    37550000
MFA-TR*              (ACCOUNT_NO,                                       37560000
MFA-TR*               REFUND_ITEM_ID,                                   37570000
MFA-TR*               AMT_REFUNDED,                                     37580000
MFA-TR*               CHECK_STATUS_CD,                                  37590000
MFA-TR*               CHECK_ISS_REAS_CD,                                37600000
MFA-TR*               COMMENTS,                                         37610000
MFA-TR*               DATE_REFUNDED,                                    37620000
MFA-TR*               REQUEST_DT,                                       37621000
MFA-TR*               DEPOSIT_CERT_NO,                                  37630000
MFA-TR*               PANEL_NO,                                         37640000
MFA-TR*               USER_ID_RQSTED_BY,                                37650000
MFA-TR*               MANUAL_INDICATOR,                                 37660000
MFA-TR*               REFUND_CHECK_NO,                                  37665000
MFA-TR*               LOCAL_OFFICE,                                     37670000
MFA-TR*               ORIGINAL_CHECK_NO,                                37690000
MFA-TR*               RETURNED_REASON,                                  37700000
MFA-TR*               USER_ID_APPRVD_BY,                                37710000
MFA-TR*               REFUND_STATUS_DT,                                 37720000
MFA-TR*               TRANS_HIST_SEQ_NO,                                37730000
MFA-TR*               ADDRESS_ID,                                       37740000
MFA-TR*               ACCT_NO_CREDITED)                                 37741000
MFA-TR*       VALUES (:RN-ACCOUNT-NO,                                   37750000
MFA-TR*               :RN-REFUND-ITEM-ID,                               37760000
MFA-TR*               :RN-AMT-REFUNDED,                                 37770000
MFA-TR*               :RN-CHECK-STATUS-CD,                              37780000
MFA-TR*               :RN-CHECK-ISS-REAS-CD,                            37790000
MFA-TR*               :RN-COMMENTS,                                     37800000
MFA-TR*               :RN-DATE-REFUNDED,                                37810000
MFA-TR*               :RN-REQUEST-DT:WS-RN-NULL-IND-1,                  37811000
MFA-TR*               :RN-DEPOSIT-CERT-NO,                              37820000
MFA-TR*               :RN-PANEL-NO,                                     37830000
MFA-TR*               :RN-USER-ID-RQSTED-BY,                            37840000
MFA-TR*               :RN-MANUAL-INDICATOR,                             37850000
MFA-TR*               :RN-REFUND-CHECK-NO,                              37860000
MFA-TR*               :RN-LOCAL-OFFICE,                                 37870000
MFA-TR*               :RN-ORIGINAL-CHECK-NO,                            37880000
MFA-TR*               :RN-RETURNED-REASON,                              37890000
MFA-TR*               :RN-USER-ID-APPRVD-BY,                            37900000
MFA-TR*               :RN-REFUND-STATUS-DT,                             37910000
MFA-TR*               :RN-TRANS-HIST-SEQ-NO,                            37920000
MFA-TR*               :RN-ADDRESS-ID,                                   37930000
MFA-TR*               :RN-ACCT-NO-CREDITED)                             37931000
MFA-TR*    END-EXEC.                                                    37940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00399*                                                                 37950000
P00399     MOVE SQLCODE                     TO  WS-ACTIVE-RETURN-CODE.  
P00399*                                                                 37970000
P00399     IF SQLCODE  = SUCCESSFUL-CALL                                
P00399        CONTINUE                                                  
P00399     ELSE                                                         
P00399        DISPLAY '*******************************************'     
P00399        DISPLAY '**   ERROR ON 8100-INSERT-REFUND         **'     
P00399        DISPLAY '**   ACCOUNT NO    = ' RN-ACCOUNT-NO             
P00399        DISPLAY '**   SQLCODE       = ' WS-ACTIVE-RETURN-CODE     
P00399        DISPLAY '**        PROCESSING TERMINATED          **'     
P00399        DISPLAY '*******************************************'     
P00399        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00399     END-IF.                                                      
P00399*                                                                 38140000
P00399 8010-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                 38140000
      ******************************************************************19840000
      *8020-UPDATE-DEPHND-DT-CRT.                                      *19850000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *19860000
      *       CSS_DEP_ON_HAND TABLE.                                   *19870000
      ******************************************************************19880000
      *                                                                 19890000
       8020-UPDATE-DEPHND-DT-CRT.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_DEP_ON_HAND                                     
                SET DATE_CERT_ISSUE   = CAST(SYSDATETIMEOFFSET() 
           AS DATE),                   
                DEPOSIT_STATUS_CD     = 'P'                             
             WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                  
                AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     19920000
MFA-TR*      UPDATE CSS_DEP_ON_HAND                                     19930000
MFA-TR*         SET DATE_CERT_ISSUE   = CURRENT DATE,                   19940000
MFA-TR*         DEPOSIT_STATUS_CD     = 'P'                             19950000
MFA-TR*      WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                  19960000
MFA-TR*         AND DEPOSIT_CERT_NO   = :WS-DEPOSIT-CERT-NO-NO          19970000
MFA-TR*    END-EXEC                                                     19980000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19990000
                MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE     
      *                                                                 20010000
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND 
                   CONTINUE                                             
                ELSE                                                    
                   DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'   
                   DISPLAY '**  PARA -8020-UPDATE-DEPHND-DT-CRT   **'   
                   DISPLAY '**      ERROR DURING SELECT FOR       **'   
                   DISPLAY '**          CSS_DEP_ON_HAND           **'   
                   DISPLAY '** ACCOUNT NO = ' WS-ACCOUNT-NO             
                   DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE            
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
                END-IF.                                                 
      *                                                                 20130000
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20160000
      ******************************************************************20170000
      *8040-UPDATE-DEPHND-DP-AMT.                                      *20180000
      *    -- THIS MODULE UPDATES AN EXISTING DEPOSIT RECORD ON THE    *20190000
      *       CSS_DEP_ON_HAND TABLE.                                   *20200000
      ******************************************************************20210000
      *                                                                 20220000
       8040-UPDATE-DEPHND-DP-AMT.                                       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_DEP_ON_HAND                                     
                SET AMT_DEPOSIT        = :WS-AMT-DEPOSIT-NEW,           
                    AMT_REFUNDED       = :DO-AMT-REFUNDED,              
                    CODE_REFUND_FROM   = 'B',                           
                    USER_ID_UPDT_BY    = :DO-USER-ID-UPDT-BY            
              WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                 
                AND DEPOSIT_CERT_NO    = :WS-DEPOSIT-CERT-NO-NO         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20340000
              MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 20360000
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'     
                 DISPLAY '**  PARA -8040-UPDATE-DEPHND-DP-AMT.  **'     
                 DISPLAY '**      ERROR DURING SELECT FOR       **'     
                 DISPLAY '**            CSS_DEP_ON_HAND         **'     
                 DISPLAY '**  ACCOUNT NO =' WS-ACCOUNT-NO               
                 DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE              
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF.                                                   
      *                                                                 20480000
       8040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20510000
      ***************************************************************** 20520000
      * 8100-UPDATE-ACCOUNT-AR-BAL                                    * 20530000
      *                                                               * 20540000
      *     UPDATE THE AR BALANCE IN CSS_ACCOUNT TABLE FOR            * 20550000
      *     THE ACCOUNT.                                              * 20560000
      ***************************************************************** 20570000
       8100-UPDATE-ACCOUNT-AR-BAL.                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,        
                      CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20660000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 20680000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8100-UPDATE-ACCOUNT-AR-BAL **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_ACCOUNT            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20800000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20830000
      ***************************************************************** 20840000
      * 8200-UPDATE-AR-CNTL-SUMM                                      * 20850000
      *                                                               * 20860000
      *     UPDATE THE SUMMARY RECORD IN AR-CNTL TABLE FOR THE        * 20870000
      *     DEPOSITS. (PYMT-PRIORITY-LVL = 80 AND ITEM-ID = 0         * 20880000
      ***************************************************************** 20890000
       8200-UPDATE-AR-CNTL-SUMM.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
              SET    LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP(),             
                     AMT_AR_DAY_00     = :SUMM-AMT-AR-DAY-00,           
                     AMT_AR_DAY_30     = :SUMM-AMT-AR-DAY-30,           
                     AMT_AR_DAY_60     = :SUMM-AMT-AR-DAY-60,           
                     AMT_AR_DAY_90     = :SUMM-AMT-AR-DAY-90            
              WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO                 
                AND  PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL         
                AND  ITEM_ID           = 0                              
                AND  LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                   :SUMM-LAST-UPDATE-TS
              )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20920000
MFA-TR*       UPDATE CSS_AR_CNTL                                        20930000
MFA-TR*       SET    LAST_UPDATE_TS    = CURRENT TIMESTAMP,             20940000
MFA-TR*              AMT_AR_DAY_00     = :SUMM-AMT-AR-DAY-00,           20950000
MFA-TR*              AMT_AR_DAY_30     = :SUMM-AMT-AR-DAY-30,           20960000
MFA-TR*              AMT_AR_DAY_60     = :SUMM-AMT-AR-DAY-60,           20970000
MFA-TR*              AMT_AR_DAY_90     = :SUMM-AMT-AR-DAY-90            20980000
MFA-TR*       WHERE  ACCOUNT_NO        = :WS-ACCOUNT-NO                 20990000
MFA-TR*         AND  PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL         21000000
MFA-TR*         AND  ITEM_ID           = 0                              21010000
MFA-TR*         AND  LAST_UPDATE_TS    = :SUMM-LAST-UPDATE-TS           21020000
MFA-TR*    END-EXEC.                                                    21030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8200-UPDATE-AR-CNTL-SUMM   **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21210000
      ******************************************************************21220000
      *   8250-UPDATE-RESTART-TABLE                                    *21230000
      *                                                                *21240000
      *        THE RESTART TABLE IS UPDATED WITH A ROW FOR PROGRAM     *21250000
      *   PCSCA348 WITH PERTINENT INFORMATION NEEDED REPOSITION INPUT  *21260000
      *   FILE AND REBUILD OUTPUT FILES IN CASE A RESTART IS NEEDED.   *21270000
      *   IF A ROW FOR PCSCA348 DOES NOT ALREADY EXIST IN CSS_RESTART, *21280000
      *   A ROW WILL BE INSERTED.  OTHERWISE, THE EXISTING ROW WILL BE *21290000
      *   UPDATED.  THERE WILL ONLY BE ON ROW IN CSS_RESTART AT ANY    *21300000
      *   GIVEN TIME.                                                  *21310000
      ******************************************************************21320000
                                                                        
       8250-UPDATE-RESTART-TABLE.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '** PARA -  8250-UPDATE-RESTART-TABLE  **'        
              DISPLAY '**      ERROR DURING UPDATE FOR       **'        
              DISPLAY '**             CSS_RESTART            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
            EXIT.                                                       
      *                                                                 21590000
      ****************************************************************  21600000
      * 8300-UPDATE-NSF-HIST                                         *  21610000
      *  - THIS MODULE WILL UPDATE DEPOSIT-CERT-NO ON NSF_HIST WHEN  *  21620000
      *    FOR ON DEP_ON_HAND IS DELETED.                            *  21630000
      ****************************************************************  21640000
       8300-UPDATE-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_NSF_HIST                                      
               SET  DEPOSIT_CERT_NO     = 0                             
                WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                
                  AND DEPOSIT_CERT_NO   = :DO-DEPOSIT-CERT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21730000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 21750000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8300-UPDATE-NSF-HIST       **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_NSF_HIST           **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21890000
      ***************************************************************** 21900000
      * 8350-UPDATE-AR-CNTL-TRA-BAL.                                  * 21910000
      *                                                               * 21920000
      *     UPDATE THE TRASACTION BALANCE RECORD IN AR-CNTL           * 21930000
      *     TABLE FOR THE DEPOSITS.                                   * 21940000
      ***************************************************************** 21950000
        8350-UPDATE-AR-CNTL-TRA-BAL.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_AR_CNTL                                       
                  SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,         
                      LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP(),            
                      AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,            
                      AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,            
                      AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,            
                      AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,            
                      AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR             
                WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
                  AND ITEM_ID           = :AC-ITEM-ID                   
                  AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21980000
MFA-TR*        UPDATE CSS_AR_CNTL                                       21990000
MFA-TR*           SET AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE,         22000000
MFA-TR*               LAST_UPDATE_TS    = CURRENT TIMESTAMP,            22010000
MFA-TR*               AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00,            22020000
MFA-TR*               AMT_AR_DAY_30     = :AC-AMT-AR-DAY-30,            22030000
MFA-TR*               AMT_AR_DAY_60     = :AC-AMT-AR-DAY-60,            22040000
MFA-TR*               AMT_AR_DAY_90     = :AC-AMT-AR-DAY-90,            22050000
MFA-TR*               AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR             22060000
MFA-TR*         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                22070000
MFA-TR*           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         22080000
MFA-TR*           AND ITEM_ID           = :AC-ITEM-ID                   22090000
MFA-TR*           AND LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS            22100000
MFA-TR*    END-EXEC                                                     22110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22120000
              MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE     
      *                                                                 22140000
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'     
                 DISPLAY '**  PARA -8350-UPDATE-AR-CNTL-TRA-BAL **'     
                 DISPLAY '**      ERROR DURING SELECT FOR       **'     
                 DISPLAY '**            CSS_AR_CNTL             **'     
                 DISPLAY '**  ACCOUNT NO = ' AC-ACCOUNT-NO              
                 DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE              
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF.                                                   
       8350-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 22271011
      * 8370-RESET-JOB-PARM.                                          * 22272011
      ***************************************************************** 22273011
       8370-RESET-JOB-PARM.                                             
      *                                                                 22275011
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET STATUS       = :G6-STATUS,                        
                      PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND SEQ_NO       = :G6-SEQ-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22279611
           MOVE SQLCODE                  TO  WS-ACTIVE-RETURN-CODE      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8370-RESET-JOB-PARM ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***   PROCESSING TERMINATED ***'                 
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                 22280611
       8370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22280911
      *                                                                 22281000
      *************************************************************     22290000
      * 8400-DELETE-SUMMARY.                                      *     22300000
      * THIS PARA DELETES THE SUMMARY RECORD FROM CSS_AR_CNTL     *     22310000
      *                                                           *     22320000
      *************************************************************     22330000
      *                                                                 22340000
       8400-DELETE-SUMMARY.                                             
                                                                        
            EXEC SQL                                                    
               DELETE                                                   
                 FROM CSS_AR_CNTL                                       
                 WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO AND                
                        PYMT_PRIORITY_LVL = 080      AND                
                        ITEM_ID = 0                                     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8400-DELETE-SUMMARY        **'        
              DISPLAY '**      ERROR DURING DELETE FOR       **'        
              DISPLAY '**             CSS_AR_CNTL            **'        
              DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22610000
      ****************************************************************  22620000
      * 8450-DELETE-DEP-ON-HAND                                      *  22630000
      *  - THIS MODULE WILL DELETE THE CURRENT DEPOSIT FROM CSS_DEP_ *  22640000
      *    ON_HAND.                                                  *  22650000
      ****************************************************************  22660000
      *                                                                 22670000
       8450-DELETE-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_DEP_ON_HAND                             
                WHERE  ACCOUNT_NO       = :DO-ACCOUNT-NO AND            
                       DEPOSIT_CERT_NO  = :DO-DEPOSIT-CERT-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8450-DELETE-DEP-ON-HAND    **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_DEP_ON_HAND        **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22910000
      ****************************************************************  22920000
      * 8500-DELETE-DEP-REQ                                          *  22930000
      *  - THIS MODULE WILL DELETE THE CURRENT DEPOSIT FROM CSS_DEP_ *  22940000
      *    REQ.                                                      *  22950000
      ****************************************************************  22960000
      *                                                                 22970000
       8500-DELETE-DEP-REQ.                                             
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_DEP_REQ                                 
                WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO AND           
                       PYMT_PRIORITY_LVL = :DR-PYMT-PRIORITY-LVL AND    
                       DEP_ITEM_ID       = :DR-DEP-ITEM-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '**  PARA - 8500-DELETE-DEP-REQ        **'        
              DISPLAY '**      ERROR DURING SELECT FOR       **'        
              DISPLAY '**             CSS_DEP_REQ            **'        
              DISPLAY '**  ACCOUNT NO = ' DR-ACCOUNT-NO                 
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23230000
      *************************************************************     23240000
      * 8550-DELETE-DEP-REC.                                      *     23250000
      * THIS PARA DELETES THE DEPOSIT RECORD FROM CSS_AR_CNTL     *     23260000
      *                                                           *     23270000
      *************************************************************     23280000
      *                                                                 23290000
       8550-DELETE-DEP-REC.                                             
               EXEC SQL                                                 
                   DELETE FROM CSS_AR_CNTL                              
                    WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            
                      AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    
                      AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    
                      AND LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :AC-LAST-UPDATE-TS
              )        
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                 23310000
MFA-TR*            DELETE FROM CSS_AR_CNTL                              23320000
MFA-TR*             WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO            23330000
MFA-TR*               AND PYMT_PRIORITY_LVL = :DEP-PYMT-PRIORITY-LVL    23340000
MFA-TR*               AND ITEM_ID           = :WS-DEPOSIT-CERT-NO-NO    23350000
MFA-TR*               AND LAST_UPDATE_TS    = :AC-LAST-UPDATE-TS        23360000
MFA-TR*        END-EXEC                                                 23370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE     
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'    
                  DISPLAY '**  PARA - 8550-DELETE-DEP-REC.       **'    
                  DISPLAY '**      ERROR DURING SELECT FOR       **'    
                  DISPLAY '**            CSS_AR_CNTL             **'    
                  DISPLAY '**  ACCOUNT NO = ' WS-ACCOUNT-NO             
                  DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE             
                  PERFORM 9900-ABEND             THRU 9900-EXIT         
               END-IF.                                                  
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23530000
      ******************************************************************23540000
      *   8600-INSERT-RESTART-TABLE                                    *23550000
      *                                                                *23560000
      *        IF A ROW DOES NOT EXIST IN CSS_RESTART FOR PCSCA348,    *23570000
      *   ONE IS ADDED.                                                *23580000
      ******************************************************************23590000
                                                                        
       8600-INSERT-RESTART-TABLE.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                    (NAME_PROGRAM,                                      
                     PARTITION_NO,                                      
                     DUP_CNTRL_NO,                                      
                     RESTART_DATA)                                      
               VALUES                                                   
                    (:RF-NAME-PROGRAM,                                  
                     :RF-PARTITION-NO,                                  
                     :RF-DUP-CNTRL-NO,                                  
                     :RF-RESTART-DATA)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'       
               DISPLAY '** PARA -  8600-INSERT-RESTART-TABLE  **'       
               DISPLAY '**      ERROR DURING INSERT FOR       **'       
               DISPLAY '**             CSS_RESTART            **'       
               DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       8600-EXIT.                                                       
            EXIT.                                                       
      *                                                                 23910000
      ******************************************************************23920000
      *                                                                *23930000
      * 8700-COMMIT-CHANGES                                            *23940000
      ******************************************************************23950000
       8700-COMMIT-CHANGES.                                             
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           DISPLAY '*** COMMIT POINT # ' WS-RECORD-COUNT ' TAKEN.'      
                  '  KEY OF LAST REC PROCESSED = ' E-FCA347-ACCOUNT-NO  
                    ' ***'.                                             
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24071008
      ******************************************************************24071114
      *                                                                *24071214
      * 8750-WRITE-FCSCA348                                            *24071314
      ******************************************************************24071414
      *                                                                 24071514
       8750-WRITE-FCSCA348.                                             
           WRITE FIOCA348.                                              
      *                                                                 24071814
           ADD 1 TO WS-FCS348-REC-CNTR                                  
                    WS-RESTRT-FCA348R-COUNT.                            
       8750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************24072308
      *   8990-DELETE-RESTART-TABLE                                    *24073008
      *                                                                *24074008
      *        IF PROGRAM REACHES SUCCESSFUL COMPLETION THE ROW FOR    *24075008
      *   PROGRAM PCSCA348 IS DELETED FROM CSS_RESTART TABLE.          *24076008
      ******************************************************************24077008
                                                                        
       8990-DELETE-RESTART-TABLE.                                       
                                                                        
           MOVE 'PCSCA348'                 TO RF-NAME-PROGRAM.          
           MOVE 1                          TO RF-PARTITION-NO.          
           MOVE 1                          TO RF-DUP-CNTRL-NO.          
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RESTART                                  
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                    
                 AND PARTITION_NO = :RF-PARTITION-NO                    
                 AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '**  PROCESSING ERROR IN PGM PCSCA348  **'        
              DISPLAY '** PARA -  8990-DELETE-RESTART-TABLE  **'        
              DISPLAY '**      ERROR DURING DELETE FOR       **'        
              DISPLAY '**             CSS_RESTART            **'        
              DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT
           END-IF.        
                                                                        
       8990-EXIT.                                                       
            EXIT.                                                       
      *                                                                 24081708
      *                                                                 24082000
      ******************************************************************24090000
      *  INCLUDE COPYBOOKS FOR A/R AND CASH DRAWER JOURNALING          *24100000
      ******************************************************************24110000
      *                                                                 24120000
           EXEC SQL                                                     24130000
              INCLUDE CPD00007                                          24140000
           END-EXEC.                                                    24150000
      *                                                                 24160000
           EXEC SQL                                                     24170000
              INCLUDE CPD00008                                          24180000
           END-EXEC.                                                    24190000
      *                                                                 24200000
      ******************************************************************24210000
      *  INCLUDE COPYBOOKS FOR AR LOCKOUT AND AT XREF.                 *24220000
      ******************************************************************24230000
      *                                                                 24240000
           EXEC SQL                                                     24250000
              INCLUDE CPD00075                                          24260000
           END-EXEC.                                                    24270000
      *                                                                 24280000
           EXEC SQL                                                     24290000
              INCLUDE CPD00307                                          24300000
           END-EXEC.                                                    24310000
      *                                                                 24320000
      ***************************************************************** 24330000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                 24370000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA347-FILE.                                         
           IF FCA347-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA348 PROCESSING ERROR   **'           
               DISPLAY '**  FCSCA347-FILE WILL NOT CLOSE  **'           
               DISPLAY '**      PARA - 9000-TERMINATE     **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9600-PROCESS-ABEND        THRU 9600-EXIT         
           END-IF.                                                      
                                                                        
      *                                                                 24720000
       9000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************25110000
      *   9900-SQL-ERROR-ROUTINE                                       *25120000
      ******************************************************************25130000
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
           DISPLAY 'SQLCODE = ' WS-ACTIVE-RETURN-CODE                   
           DISPLAY '**********************************************'.    
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                 25250000
      ******************************************************************25251010
      *   9600-PROCESS-ABEND                                           *25252010
      *                                                                *25253010
      *        THIS ROUTINE IS EXECUTED ONLY FROM 9000-TERMINATE WHEN  *25254010
      *   AN ERROR CONDITION OCCURS.  SINCE 9000-TERMINATE IS          *25255010
      *   EXECUTED FROM 9700-PROCESS-ABEND, THIS PARAGRAPH WAS SETUP   *25255110
      *   TO AVOID LOOP.                                               *25255210
      ******************************************************************25255310
      *                                                                 25256010
       9600-PROCESS-ABEND.                                              
      *                                                                 25258010
           DISPLAY 'PERFORMING 9600-PROCESS-ABEND'.                     
      *                                                                 25259110
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                      

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

                                                                        
           MOVE 12  TO  RETURN-CODE.                                    
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
                                                                        
      *                                                                 25260410
       9600-EXIT.                                                       
           EXIT.                                                        
           IF WS-ABEND-YES                                              
               STOP RUN                                                 
           END-IF.                                                      
      *                                                                 25261010
      ***************************** *********************************** 25262000
      ** 6240-GET-FCA00-COMMON-DATE                                     25270000
      ***************************************************************** 25280000
           COPY CPD00040.                                               25290000
                                                                        
      ***************************************************************** 25310000
      ** 6251-GET-FJC01-DATE.                                        ** 25320000
      ***************************************************************** 25330000
                                                                        
           EXEC SQL                                                     25350000
                INCLUDE CPD00037                                        25360000
           END-EXEC.                                                    25370000
                                                                        
      ****************************************************************  25390000
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *  25400000
      ****************************************************************  25410000
            EXEC SQL                                                    25420000
                INCLUDE CPD00034                                        25430000
            END-EXEC.                                                   25440000
      *                                                                 25450000
      ****************************************************************  25460000
      ****************************************************************  25470000
      **  7600-START-FCSJC01.                                        *  25480000
      ****************************************************************  25490000
                                                                        
           EXEC SQL                                                     25510000
                INCLUDE CPD00038                                        25520000
           END-EXEC.                                                    25530000
                                                                        
      ****************************************************************  25550000
      **  7620-START-FCSCA00.                                        *  25560000
      ****************************************************************  25570000
                                                                        
           EXEC SQL                                                     25590000
                INCLUDE CPD00039                                        25600000
           END-EXEC.                                                    25610000
      *                                                                 25620000
      ******************************************************************25630000
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE       *25640000
      * 9900-ABEND.                                                    *25650000
      ******************************************************************25660000
           EXEC SQL                                                     25670000
               INCLUDE CPD09900                                         25680000
           END-EXEC.                                                    25690000
      *                                                                 25700000
