       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA347.                                        
       DATE-WRITTEN.   AUG 2006.                                        
           DATE-COMPILED.                                               
      ***************************************************************** 00000500
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00000600
      **                     PRICE WATERHOUSE                        ** 00000700
      **                1410 NORTH WESTSHORE BLVD                    ** 00000800
      **                   TAMPA, FLORIDA  33607                     ** 00000900
      **                      (813) 287-9200                         ** 00001000
      **                                                             ** 00001100
      ********            CUSTOMER SERVICE SYSTEM             ********* 00001200
      ********                      DB2                       ********* 00001300
      ******************************************************************00008700
      *                   PROGRAM NARRATIVE                            *00008800
      *                                                                *        
      *                                                                *00010200
      *   THIS PROGRAM  RETRIEVES  DEPOSIT AND ACCOUNT  INFO ON        *00010400
      *   PENDING SEB ACCOUNTS                                         *00010500
      *   THIS IS A NEW PROGRAM WRITTEN FOR SCE&G.                     *00010600
      *                                                                *00010700
      ******************************************************************00011700
      ***************************************************************** 00001400
      **                                                             ** 00001500
      **              PROGRAM  MODIFICATION  LOG                     ** 00001600
      **    DATE    INITIALS     REASON                              ** 00001700
      **    ----    --------     ------                              ** 00001800
      **  08/08/06  COVANSYS    THIS IS A NEW PROGRAM.               ** 00001900
      **            CHENNAI                                          ** 00002100
T35434**  03/14/07  MC95456     REPLACED CSS_MODEL_SQL WITH SET      ** 00002200
      **                        STATEMENTS                           **         
C32909**  12/12/08  CVNS        1)REMOVE THE LINKAGE SECTION         **         
C32909**            CHENNAI     2)ADDING A ADITION CHECK FOR CSR     **         
C32909**                          WHEN E-FCA347-AMT-FULL-BAL AMOUNT IS*         
C32909**                          GREATER THAN ZERO.                 **         
F32909**  01/13/09  SS42021     INCLUDE CHECKS FOR REFUNDED          **         
      **                        AND TRANSFERRED DEPOSITS             **         
      ***************************************************************** 00008500
      *              ---- BASIC BATCH SEQUENCE STRUCTURE ----        ** 00011800
      *             0000 - 0000     MAIN CONTROL PATH                ** 00011900
      *             0100 - 0100     INITIALIZATION                   ** 00012000
      *             1000 - 1000     MAJOR PROCESSING LOOP            ** 00012100
      *             1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR    ** 00012200
      *                             PROCESSING LOOPS                 ** 00012300
      *             5000 - 5999     COMMON PROGRAM MODULES           ** 00012400
      *             6000 - 6999     COMMON SYSTEM MODULES            ** 00012500
      *             7000 - 7999     INPUT MODULES                    ** 00012600
      *             8000 - 8999     OUTPUT MODULES                   ** 00012700
      *             9000 - 9799     TERMINATION MODULES              ** 00012800
      *             9900 - 9999     ABEND/ABORT MODULES              ** 00012900
      *                   ---- PARAGRAPH STRUCTURE ----              ** 00013000
      ***************************************************************** 00013100
HPCCDM*    EJECT                                                        00013200
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA347.                                               00014000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDCA347.                                               00015500
           COPY FIOCA347.                                               00015500
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA347'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                     PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA347 STARTS HERE'.            
                                                                        
       01  WS-WORK-VARIABLE.                                            
           05  WS-ACCOUNT-NO               PIC 9(13) VALUE 0.           
           05  WS-PROCESS-IND              PIC X(01) VALUE SPACES.      
           05  WS-PREV-ACCOUNT-NO          PIC 9(13) VALUE 0.           
           05  WS-ERROR-IND                PIC X(01) VALUE 'N'.         
           05  WS-MULTIPLE-RECS-IND        PIC X(01) VALUE 'N'.         
           05  WS-FIRST-REC-IND            PIC X(01) VALUE 'Y'.         
           05  WS-LOOP-END-IND             PIC X(01) VALUE 'N'.         
C32909     05  WS-OTHER-RECV               PIC X(01) VALUE SPACES.      
           05  WS-RPT-COUNT                PIC 9(05) VALUE 0.           
           05  WS-FCA347-REC-COUNT         PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-TOT-ACCT-COUNT           PIC 9(07) VALUE 0.           
C32909     05  WS-TOTAL-PAYMENTS-NI        PIC S9(04) COMP VALUE 0.     
C32909     05  WS-TOTAL-PAYMENTS         PIC S9(09)V9(2) COMP-3 VALUE 0.
                                                                        
       01  WS-PROG-MISC.                                                
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  PROGRAM-NAME                PIC X(10) VALUE 'PCSCA347'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA347'.  
           05  WS-CURRENT-TS               PIC X(26) VALUE SPACES.      
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
           05  WS-HOLD-TIMESTAMP           PIC X(26) VALUE SPACES.      
           05  WS-COMMON-DATE              PIC X(10) VALUE SPACES.      
           05  WS-C8-DELINQ-VALUE          PIC S9(04) COMP VALUE +0.    
           05  WS-JOB-PARM-DATA.                                        
               10 FILLER                   PIC X(14) VALUE              
                    'LAST RUN DATE='.                                   
               10 WS-LAST-RUN-TS           PIC X(26) VALUE SPACES.      
               10  FILLER                  PIC X(40) VALUE SPACES.      
           05  WS-PROCESS-TS1              PIC X(26) VALUE SPACES.      
           05  WS-PROCESS-TS-2.                                         
               10 WS-PROCESS-DT-2          PIC X(10) VALUE SPACES.      
               10 WS-PROCESS-TM-2          PIC X(16) VALUE              
                     '-00.00.00.000000'.                                
           05  WS-PROCESS-TS2              PIC X(26) VALUE SPACES.      
           05  WS-PROCESS-DT2              PIC X(10).                   
           05  WS-DATABASE                 PIC 9(01) VALUE ZERO.        
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS          PIC X(01) VALUE 'N'.         
               88 NO-MORE-RECORDS                    VALUE 'Y'.         
           05  WS-RECD-NOT-FOUND           PIC X(01) VALUE 'N'.         
               88 RECD-NOT-FOUND                     VALUE 'Y'.         
           05  WS-FCA347-STATUS            PIC X(02).                   
               88  FCA347-SUCCESSFUL                 VALUE '00'.        
                                                                        
       01  WS-LITERALS.                                                 
            05  WS-N                       PIC X(01) VALUE 'N'.         
            05  WS-Y                       PIC X(01) VALUE 'Y'.         
                                                                        
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       00665600
       COPY CWS00303.                                                           
                                                                        
      ******* WS-ABEND-SWITCH     ****************                              
       COPY CWS09900.                                                           
                                                                        
      ******* WS-ABEND WORK AREA  ****************                              
       COPY CWS00010.                                                           
                                                                        
      ******* WS-FCA00-MISC       ****************                              
       COPY CWS00039.                                                           
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                              
        COPY FIOJC01.                                                           
                                                                        
      ******* FCA00-KEY           ****************                              
       COPY FIOCA00.                                                            
                                                                        
      ******* WORKING STORAGE FOR WS-MISC.*********************                 
           EXEC SQL                                                     00682900
              INCLUDE CWS00038                                          00683000
           END-EXEC.                                                    00683100
      *                                                                 00683200
      ****************************************************************          
      ** ===========>  DB2 TABLES INCLUDED IN PROGRAM  <=========== **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                 00683200
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 00683200
C32909*** CSS_DEP_PAY_HST  (DP)                                         03190000
C32909     EXEC SQL                                                     03200000
C32909        INCLUDE TBDEPHST                                          03210000
C32909     END-EXEC.                                                    03220000
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE  'WORKING STORAGE FOR  PCSCA347  ENDS HERE'.           
      *                                                                         
      * DECLARE STATEMENT FOR MAIN PROCESSING CURSOR                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE ACCT_INFO_CSR CURSOR FOR                        
                SELECT  ACCOUNT_NO,                                     
                        CODE_ACCT_STAT,                                 
                        TOTAL_AR_BALANCE                                
C32909                 ,ACCT_XFER_TO                                    
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
                WHERE CODE_ACCT_STAT = 'P' AND                          
                     ACCT_CREATE_DT  <=      CIS.CHAR2TIMESTAMP(
                                                        :WS-PROCESS-TS2
              ) AND        
                    (CIS.SUBSTR3(CODES_DATA_PRESENT,7,1)  = 'A'    OR        
                     CIS.SUBSTR3(CODES_DATA_PRESENT,12,1) = 'A')             
                FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCT_INFO_CSR CURSOR FOR                                
MFA-TR*         SELECT  ACCOUNT_NO,                                     01130011
MFA-TR*                 CODE_ACCT_STAT,                                 01130011
MFA-TR*                 TOTAL_AR_BALANCE                                01140011
MFA-TR*                ,ACCT_XFER_TO                                            
MFA-TR*         FROM CSS_ACCOUNT                                        01150011
MFA-TR*         WHERE CODE_ACCT_STAT = 'P' AND                          01160011
MFA-TR*              ACCT_CREATE_DT  <=      :WS-PROCESS-TS2 AND                
MFA-TR*             (SUBSTR(CODES_DATA_PRESENT,7,1)  = 'A'    OR                
MFA-TR*              SUBSTR(CODES_DATA_PRESENT,12,1) = 'A')                     
MFA-TR*         FOR FETCH  ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                     
                DECLARE DEP_INFO_CSR CURSOR FOR                         
                SELECT  DEPOSIT_CERT_NO,                                
                        AMT_DEPOSIT,                                    
C32909                  TRANSFERRED_FROM                                
C32909                 ,DEPOSIT_STATUS_CD                               
                FROM    CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                       
C32909            AND DATE_TRAN <= IIF(TRY_CONVERT(DATE, :WS-PROCESS-DT2
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DT2
              ) <> 0) OR (LEN(:WS-PROCESS-DT2) <> 10), CIS.CHAR2DATE(
                                                        :WS-PROCESS-DT2
              ), CONVERT(DATE, :WS-PROCESS-DT2) )                      
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DEP_INFO_CSR CURSOR FOR                         01220011
MFA-TR*         SELECT  DEPOSIT_CERT_NO,                                01240011
MFA-TR*                 AMT_DEPOSIT,                                    01250011
MFA-TR*                 TRANSFERRED_FROM                                        
MFA-TR*                ,DEPOSIT_STATUS_CD                                       
MFA-TR*         FROM    CSS_DEP_ON_HAND                                 01320011
MFA-TR*         WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                       01330011
MFA-TR*           AND DATE_TRAN <= :WS-PROCESS-DT2                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * *                                                                       
C32909 PROCEDURE DIVISION.                                              
      * *                                                                       
      *****************************************************************         
      **  0000-MAINLINE ..                                           **         
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                  **         
      **                                                             **         
      *****************************************************************         
       0000-MAINLINE.                                                   
      *                                                                         
            PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.         
            PERFORM 5200-WRITE-BEGIN-CONTROLS   THRU 5200-EXIT.         
            PERFORM 1000-MAIN-PROCESS           THRU 1000-EXIT.         
            PERFORM 7120-CLOSE-ACCT-INFO-CSR    THRU 7120-EXIT.         
            PERFORM 5300-WRITE-END-CONTROLS     THRU 5300-EXIT.         
            PERFORM 5400-UPDATE-LAST-RUN-TS     THRU 5400-EXIT.         
            PERFORM 9000-TERMINATE              THRU 9000-EXIT.         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  0100-INITIALIZATION ..                                     **         
      **       COMMON INITIALIZATION ROUTINE                         **         
      **                                                             **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSCA347-FILE.                                   
      *                                                                         
           IF FCA347-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON CREDIT  OPEN.  STATUS IS '        
                        WS-FCA347-STATUS                                
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
           MOVE 'DATE'                   TO G6-CMND-CODE.               
                                                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           MOVE WS-INPUT-RUN-DATE        TO WS-COMMON-DATE              
                                                                        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE               
              MOVE 'PCSCA347'            TO WS-PGRMNAME                 
           END-IF.                                                      
                                                                        
C32909     MOVE 'DATABASE'             TO C8-DELINQ-CD.                 
C32909     MOVE '01'                   TO C8-COMPANY-NO.                
C32909     PERFORM 6500-GET-DELINQUE-VALUE     THRU 6500-EXIT.          
C32909     MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
           MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.            
           MOVE WS-INPUT-DATE            TO WS-COMMON-DATE.             
           MOVE '01'                     TO G6-COMPANY-NO.              
           MOVE 'PARM'                   TO G6-CMND-CODE.               
           MOVE +10                      TO G6-SEQ-NO.                  
           MOVE 'DAY-REVERSE-DEPOSIT'    TO C8-DELINQ-CD.               
C32909     MOVE  '01'                    TO C8-COMPANY-NO.              
           PERFORM 6500-GET-DELINQUE-VALUE     THRU 6500-EXIT.          
           PERFORM 7000-GET-CURRENT-TS         THRU 7000-EXIT.          
           PERFORM 7010-SELECT-LAST-RUN-DATE   THRU 7010-EXIT.          
              MOVE C8-DELINQ-VALUE       TO  WS-C8-DELINQ-VALUE.        
              MOVE G6-PARM-DATA          TO WS-JOB-PARM-DATA.           
           PERFORM 7050-GET-TIMESTAMP          THRU 7050-EXIT.          
                                                                        
              INITIALIZE                    FIOCA347                    
              MOVE 'N'                   TO E-FCA347-DEP-IND            
              MOVE 'N'                   TO E-FCA347-CIA-IND            
                                                                        
              MOVE SPACES                TO DCLCSS-AR-CNTL              
              MOVE SPACES                TO DCLCSS-ACCOUNT              
              MOVE SPACES                TO DCLCSS-DEP-ON-HAND.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 1000-MAIN-PROCESS ..                                        **         
      **        INPUT PROCESSING CONTROL                             **         
      **                                                             **         
      *****************************************************************         
       1000-MAIN-PROCESS.                                               
      *                                                                         
            PERFORM 7100-OPEN-ACCT-INFO-CSR     THRU 7100-EXIT.         
            PERFORM 7110-FETCH-ACCT-INFO-CSR    THRU 7110-EXIT.         
            PERFORM 2000-PROCESS-DATA           THRU 2000-EXIT          
                UNTIL NO-MORE-RECORDS.                                  
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 2000-PROCESS-DATA ..                                        **         
      **                     OUTPUT PROCESS CONTROL                  **         
      **                                                             **         
      *****************************************************************         
       2000-PROCESS-DATA.                                               
      *                                                                         
C32909      IF AT-ACCT-XFER-TO > 0                                      
C32909         PERFORM 7110-FETCH-ACCT-INFO-CSR                         
C32909            THRU 7110-EXIT                                        
C32909         GO TO 2000-EXIT                                          
C32909      END-IF.                                                     
      *                                                                         
            MOVE AT-ACCOUNT-NO          TO WS-ACCOUNT-NO.               
            MOVE AT-ACCOUNT-NO          TO AC-ACCOUNT-NO.               
            MOVE AT-ACCOUNT-NO          TO DO-ACCOUNT-NO.               
            PERFORM 7400-SELECT-AMT-UNUSED      THRU 7400-EXIT.         
            PERFORM 7200-OPEN-DEP-INFO-CSR      THRU 7200-EXIT.         
            PERFORM 7210-FETCH-DEP-INFO-CSR     THRU 7210-EXIT.         
            PERFORM 2100-PROCESS-DEP-INF        THRU 2100-EXIT          
                   UNTIL RECD-NOT-FOUND.                                
            PERFORM 7220-CLOSE-DEP-INFO-CSR     THRU 7220-EXIT.         
            IF WS-RECD-NOT-FOUND = 'Y'                                  
            MOVE     'N'                TO    WS-RECD-NOT-FOUND         
            END-IF                                                      
            PERFORM 7110-FETCH-ACCT-INFO-CSR    THRU 7110-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 2100-PROCESS-DATA ..                                        **         
      **                     OUTPUT PROCESS CONTROL                  **         
      **                                                             **         
      *****************************************************************         
       2100-PROCESS-DEP-INF.                                            
      *                                                                         
C32909        MOVE 'N'                  TO  WS-OTHER-RECV               
              MOVE 'Y'                  TO  E-FCA347-DEP-IND            
              MOVE  WS-ACCOUNT-NO       TO  E-FCA347-ACCOUNT-NO         
              MOVE  DO-DEPOSIT-CERT-NO  TO  E-FCA347-DEP-ITEM-ID        
            IF DO-AMT-DEPOSIT < 0                                       
              COMPUTE E-FCA347-AMT-DEP  = DO-AMT-DEPOSIT * -1           
              MOVE    '-'               TO  E-FCA347-AMT-DEP-SIGN       
            ELSE                                                        
              MOVE  DO-AMT-DEPOSIT      TO  E-FCA347-AMT-DEP            
            END-IF.                                                     
              MOVE DO-DEPOSIT-CERT-NO   TO  AC-ITEM-ID                  
            PERFORM 7300-SELECT-AMT-TRANS-BAL  THRU 7300-EXIT           
            IF WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND                   
              MOVE ZERO TO E-FCA347-AMT-DEP-BAL                         
            ELSE                                                        
              IF AC-AMT-TRAN-BALANCE < 0                                
                 COMPUTE E-FCA347-AMT-DEP-BAL = AC-AMT-TRAN-BALANCE * -1
                  MOVE  '-'                 TO E-FCA347-AMT-DEP-BAL-SIGN
              ELSE                                                      
                  MOVE AC-AMT-TRAN-BALANCE  TO   E-FCA347-AMT-DEP-BAL   
              END-IF                                                    
            END-IF.                                                     
               MOVE AT-CODE-ACCT-STAT       TO E-FCA347-CODE-ACCT-STAT  
            IF AT-TOTAL-AR-BALANCE < 0                                  
               COMPUTE E-FCA347-AMT-FULL-BAL = AT-TOTAL-AR-BALANCE * -1 
               MOVE   '-'                  TO E-FCA347-AMT-FULL-BAL-SIGN
            ELSE                                                        
               MOVE  AT-TOTAL-AR-BALANCE    TO  E-FCA347-AMT-FULL-BAL   
            END-IF.                                                     
            IF AC-AMT-UNUSED-CR NOT EQUAL ZERO                          
               MOVE 'Y'                     TO E-FCA347-CIA-IND         
            END-IF                                                      
            IF AC-AMT-UNUSED-CR < 0                                     
               COMPUTE  E-FCA347-AMT-CIA  = AC-AMT-UNUSED-CR * -1       
               MOVE '-'                   TO E-FCA347-AMT-CIA-SIGN      
            ELSE                                                        
               MOVE  AC-AMT-UNUSED-CR     TO E-FCA347-AMT-CIA           
            END-IF.                                                     
            IF E-FCA347-AMT-CIA NOT EQUAL ZERO                          
              OR E-FCA347-AMT-DEP NOT EQUAL E-FCA347-AMT-DEP-BAL        
              OR (E-FCA347-AMT-DEP EQUAL ZERO AND                       
                  E-FCA347-AMT-DEP-BAL EQUAL ZERO)                      
C32909        IF CSR-DATABASE                                           
C32909           IF DO-TRANSFERRED-FROM > 0                             
C32909              MOVE 'N' TO WS-PROCESS-IND                          
C32909           ELSE                                                   
C32909              PERFORM 7268-CHK-OTHER-RECEIVABLES  THRU 7268-EXIT  
C32909              IF WS-OTHER-RECV = 'Y'                              
C32909                 MOVE 'N' TO WS-PROCESS-IND                       
C32909              ELSE                                                
C32909                 MOVE DO-ACCOUNT-NO       TO DP-ACCOUNT-NO        
C32909                 MOVE DO-DEPOSIT-CERT-NO  TO DP-DEPOSIT-CERT-NO   
C32909                 PERFORM 7990-SELECT-DEP-PAY-AMT                  
C32909                    THRU 7990-EXIT                                
C32909*                                                                         
C32909                 IF WS-TOTAL-PAYMENTS > ZEROES                    
C32909                    MOVE 'N' TO WS-PROCESS-IND                    
C32909                 ELSE                                             
C32909                    MOVE 'Y' TO WS-PROCESS-IND                    
C32909                 END-IF                                           
C32909              END-IF                                              
C32909           END-IF                                                 
C32909        ELSE                                                      
C32909           MOVE 'N' TO WS-PROCESS-IND                             
C32909        END-IF                                                    
            ELSE                                                        
C32909        IF CSR-DATABASE                                           
C32909           IF DO-TRANSFERRED-FROM > 0                             
C32909              MOVE 'N' TO WS-PROCESS-IND                          
C32909           ELSE                                                   
C32909              PERFORM 7268-CHK-OTHER-RECEIVABLES  THRU 7268-EXIT  
C32909              IF WS-OTHER-RECV = 'Y'                              
C32909                 MOVE 'N' TO WS-PROCESS-IND                       
C32909              ELSE                                                
C32909                 MOVE 'Y' TO WS-PROCESS-IND                       
C32909              END-IF                                              
C32909           END-IF                                                 
C32909        ELSE                                                      
C32909           MOVE 'Y' TO WS-PROCESS-IND                             
C32909        END-IF                                                    
            END-IF.                                                     
C32909      IF DO-DEPOSIT-STATUS-CD = 'R' OR 'T' OR 'P'                 
C32909         MOVE 'N' TO WS-PROCESS-IND                               
C32909      END-IF                                                      
            PERFORM 7210-FETCH-DEP-INFO-CSR     THRU 7210-EXIT          
            IF SQLCODE = SUCCESSFUL-CALL                                
               MOVE '*' TO E-FCA347-MULT-DEP-IND                        
            END-IF                                                      
            IF WS-PROCESS-IND EQUAL 'Y'                                 
            PERFORM 8900-WRITE-FIOCA347         THRU 8900-EXIT          
            END-IF.                                                     
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5200-WRITE-BEGIN-CONTROLS.                                    *         
      *****************************************************************         
       5200-WRITE-BEGIN-CONTROLS.                                       
                                                                        
           INITIALIZE E-FCA347-BEGIN-REC.                               
           MOVE LOW-VALUES                   TO E-FCA347-BEGIN-REC.     
           MOVE WS-COMMON-DATE               TO E-FCA347-RUN-DATE.      
           MOVE WS-LAST-RUN-TS               TO E-FCA347-LAST-RUN-DATE. 
           PERFORM 8900-WRITE-FIOCA347         THRU 8900-EXIT.          
           SUBTRACT 1 FROM WS-FCA347-REC-COUNT.                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 5300-WRITE-END-CONTROLS.                                      *         
      *****************************************************************         
       5300-WRITE-END-CONTROLS.                                         
                                                                        
           INITIALIZE E-FCA347-END-REC.                                 
           MOVE HIGH-VALUES                  TO E-FCA347-END-REC.       
           MOVE WS-FCA347-REC-COUNT          TO E-FCA347-RECORD-COUNT.  
           PERFORM 8900-WRITE-FIOCA347         THRU 8900-EXIT.          
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 5400-UPDATE-LAST-RUN-TS.                                      *         
      *****************************************************************         
       5400-UPDATE-LAST-RUN-TS.                                         
                                                                        
           INITIALIZE                       G6-PARM-DATA.               
           MOVE WS-CURRENT-TS            TO WS-LAST-RUN-TS.             
           MOVE WS-JOB-PARM-DATA         TO G6-PARM-DATA.               
                                                                        
           MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.            
                                                                        
           PERFORM 8100-UPDATE-LAST-RUN-DATE   THRU 8100-EXIT.          
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6500-GET-DELINQUE-VALUE.                                      *         
      *     SELECTS DELINQUE VALUE FROM CSS_DELINQUENCY               *         
      *****************************************************************         
       6500-GET-DELINQUE-VALUE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
               AND   COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*        AND   COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6500' TO WS-ACTIVE-PARAGRAPH                        
              DISPLAY '*************PCSCA347************************'   
              DISPLAY '** 6500-GET-DATABASE      :RETURN CODE ERROR '   
              DISPLAY '** RETURN CODE = ' SQLCODE                       
              DISPLAY '*** ACCOUNT = ' AT-ACCOUNT-NO                    
              DISPLAY '*************PCSCA347************************'   
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       6500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-GET-CURRENT-TS.                                          *         
      *****************************************************************         
       7000-GET-CURRENT-TS.                                             
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04850000
MFA-TR*        SET  :WS-CURRENT-TS   =   CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
             DISPLAY '********** PCSCA347 ABORT **************'         
             DISPLAY '*       7000-GET-CURRENT-TS            *'         
             DISPLAY '* CURRENT TS     : ' WS-CURRENT-TS                
             DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE        
             DISPLAY '* PROGRAM ABORTING...                  *'         
             DISPLAY '********** PCSCA347 ABORT **************'         
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
             EXIT.                                                      
      *************************************************************             
      *                                                                         
      * 7010-SELECT-LAST-RUN-DATE.                                              
      *****************************************************************         
       7010-SELECT-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT  G6.PROGRAM_NAME                                  
                      ,G6.COMPANY_NO                                    
                      ,G6.CMND_CODE                                     
                      ,G6.SEQ_NO                                        
                      ,G6.STATUS                                        
                      ,G6.PARM_DATA                                     
                 INTO  :G6-PROGRAM-NAME                                 
                      ,:G6-COMPANY-NO                                   
                      ,:G6-CMND-CODE                                    
                      ,:G6-SEQ-NO                                       
                      ,:G6-STATUS                                       
                      ,:G6-PARM-DATA                                    
                 FROM CSS_JOB_PARM G6                                   
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSCA347 ABORT **************'       
               DISPLAY '*     7010-SELECT-LAST-RUN-DATE.       *'       
               DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME            
               DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO              
               DISPLAY '* CMD CODE       : ' G6-CMND-CODE               
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA347 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
        7010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-GET-TIMESTAMP.                                           *         
      ***************************************************************** 04900000
       7050-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, -
                                                    :WS-C8-DELINQ-VALUE
              , CIS.CHAR2TIMESTAMP(:WS-LAST-RUN-TS) ), 121), ' ', 
           '-'), ':', '.')
            INTO
              :WS-PROCESS-TS1      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-PROCESS-TS1 =  TIMESTAMP(:WS-LAST-RUN-TS) -              
MFA-TR*                                   :WS-C8-DELINQ-VALUE DAYS              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -:WS-C8-DELINQ-VALUE, IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-PROCESS-DT-2     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-PROCESS-DT-2 =  DATE(:WS-INPUT-DATE) -                   
MFA-TR*                                    :WS-C8-DELINQ-VALUE DAYS             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-PROCESS-DT-2        TO WS-PROCESS-DT2.               
           MOVE WS-PROCESS-TS-2        TO WS-PROCESS-TS2.               
C32909     DISPLAY 'PROCESS DATE 1 ' WS-PROCESS-TS1                     
C32909     DISPLAY 'PROCESS DATE 2 ' WS-PROCESS-TS2                     
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7270-SELECT-TIMESTAMP        **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                  
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **  7100-OPEN-ACCT-INFO-CSR                                    **         
      **                                                             **         
      **  THIS PARAGRAPH OPENS THE ACCT INF CURSOR TO THE PROGRAM.   **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7100-OPEN-ACCT-INFO-CSR.                                         
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT_INFO_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                CONTINUE                                                
           ELSE                                                         
               DISPLAY '*** ABEND IN 7100-OPEN-ACCT-INFO-CSR ***'       
               DISPLAY '*** ACCT-INFO   CURSOR OPEN ERROR    ***'       
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7110-FETCH-ACCT-INFO-CSR                                   **         
      **                                                             **         
      **  THIS PARAGRAPH FETCHES DATA FROM THE ACCT INF CURSOR.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7110-FETCH-ACCT-INFO-CSR.                                        
      *                                                                         
           MOVE '7110' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              FETCH  ACCT_INFO_CSR                                      
              INTO  :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-TOTAL-AR-BALANCE                                
C32909             ,:AT-ACCT-XFER-TO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'          TO   WS-NO-MORE-RECORDS              
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*** ABEND IN 7110-FETCH-ACCT-INFO-CSR ***'      
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7120-CLOSE-DEPOSIT-CSR                                     **         
      **                                                             **         
      **  THIS PARAGRAPH CLOSES THE MAIN PROCESSING CURSOR.          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7120-CLOSE-ACCT-INFO-CSR.                                        
      *                                                                         
           MOVE '7120' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT_INFO_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 7120-CLOSE-ACCT-INFO-CSR ***'       
              DISPLAY '*** ACCT_INFO_CSR CLOSE ERROR         ***'       
              DISPLAY '*** SQLCODE = ' SQLCODE                          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7200-OPEN-DEP-INFO-CSR                                     **         
      **                                                             **         
      **  THIS PARAGRAPH OPENS THE DEP INF CURSOR TO THE PROGRAM.    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7200-OPEN-DEP-INFO-CSR.                                          
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              OPEN DEP_INFO_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                CONTINUE                                                
           ELSE                                                         
               DISPLAY '*** ABEND IN 7200-OPEN-DEP-INFO-CSR ***'        
               DISPLAY '*** DEP_INFO CURSOR OPEN ERROR      ***'        
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7210-FETCH-DEP-INFO-CSR                                     **        
      **                                                             **         
      **  THIS PARAGRAPH FETCHES DATA FROM THE DEPT INF CURSOR.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7210-FETCH-DEP-INFO-CSR.                                         
      *                                                                         
           MOVE '7210' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              FETCH  DEP_INFO_CSR                                       
              INTO  :DO-DEPOSIT-CERT-NO,                                
                    :DO-AMT-DEPOSIT,                                    
C32909              :DO-TRANSFERRED-FROM                                
C32909             ,:DO-DEPOSIT-STATUS-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL  NOT-FOUND                
                  MOVE  'Y'            TO WS-RECD-NOT-FOUND             
               END-IF                                                   
           ELSE                                                         
              DISPLAY '*** ABEND IN 7210-FETCH-DEP-INFO-CSR ***'        
              DISPLAY '*** SQLCODE = ' SQLCODE                          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7220-CLOSE-DEP-INFO_CSR                                    **         
      **                                                             **         
      **  THIS PARAGRAPH CLOSES THE DEPT INF CURSOR.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7220-CLOSE-DEP-INFO-CSR.                                         
      *                                                                         
           MOVE '7220' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE DEP_INFO_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ABEND IN 7220-CLOSE-DEP-INFO-CSR ***'        
              DISPLAY '*** DEP_INFO_CSR CLOSE ERROR         ***'        
              DISPLAY '*** SQLCODE = ' SQLCODE                          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
C32909******************************************************************        
C32909* 7268-CHK-OTHER-RECEIVABLES                                     *        
C32909******************************************************************        
C32909 7268-CHK-OTHER-RECEIVABLES.                                      
C32909                                                                  
C32909     EXEC SQL                                                     
C32909          SELECT TOP(1) 'Y'                                              
C32909            INTO :WS-OTHER-RECV                                   
C32909            FROM CSS_AR_CNTL                                      
C32909           WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                      
C32909             AND PYMT_PRIORITY_LVL <> 80                          
C32909             AND (AMT_AR_DAY_00     <> 0                          
C32909                  OR AMT_AR_DAY_30     <> 0                       
C32909                  OR AMT_AR_DAY_60     <> 0                       
C32909                  OR AMT_AR_DAY_90     <> 0                       
C32909                  OR AMT_UNUSED_CR     <> 0                       
C32909                  OR AMT_TRAN_BALANCE  <> 0                       
C32909                  OR TOT_SUMM_UNBILLED <> 0)                      
C32909                                            
C32909     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-OTHER-RECV                                           
MFA-TR*           FROM CSS_AR_CNTL                                              
MFA-TR*          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                              
MFA-TR*            AND PYMT_PRIORITY_LVL <> 80                                  
MFA-TR*            AND (AMT_AR_DAY_00     <> 0                                  
MFA-TR*                 OR AMT_AR_DAY_30     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_60     <> 0                               
MFA-TR*                 OR AMT_AR_DAY_90     <> 0                               
MFA-TR*                 OR AMT_UNUSED_CR     <> 0                               
MFA-TR*                 OR AMT_TRAN_BALANCE  <> 0                               
MFA-TR*                 OR TOT_SUMM_UNBILLED <> 0)                              
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32909                                                                  
C32909     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C32909                                                                  
C32909     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C32909        NEXT SENTENCE                                             
C32909     ELSE                                                         
C32909         DISPLAY '** ERROR IN 7268-CHK-OTHER-RECEIVABLES**'       
C32909         DISPLAY '**      RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
C32909         DISPLAY 'ACCOUNT NO =' AC-ACCOUNT-NO                     
C32909         DISPLAY '**      PROCESSING IS TERMINATED     **'        
C32909         PERFORM 9900-ABEND                THRU 9900-EXIT         
C32909     END-IF.                                                      
C32909                                                                  
C32909 7268-EXIT.                                                       
C32909     EXIT.                                                        
C32909*                                                                         
      *****************************************************************         
      **  7300-SELECT-AMT-TRANS-BAL.                                 **         
      **                                                             **         
      **  THIS PARAGRAPH SELECTS THE AMOUNT TRANSACTION BALANCE.      **        
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7300-SELECT-AMT-TRANS-BAL.                                       
      *                                                                         
           MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                SELECT  AMT_TRAN_BALANCE                                
                INTO    :AC-AMT-TRAN-BALANCE                            
                FROM    CSS_AR_CNTL                                     
                WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO              
                  AND   PYMT_PRIORITY_LVL = 80                          
                  AND   ITEM_ID           = :AC-ITEM-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                CONTINUE                                                
           ELSE                                                         
               DISPLAY '*** ABEND IN 7300-SELECT-AMT-TRANS-BAL  ***'    
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7400-SELECT-AMT-UNUSED                                     **         
      **                                                             **         
      **  THIS PARAGRAPH SELECTS AMOUNT UNUSED FROM  CSS_AR_CNTL.    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7400-SELECT-AMT-UNUSED.                                          
      *                                                                         
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                SELECT  AMT_UNUSED_CR                                   
                INTO    :AC-AMT-UNUSED-CR                               
                FROM    CSS_AR_CNTL                                     
                WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO              
                  AND   PYMT_PRIORITY_LVL = 70                          
                  AND ITEM_ID             = 0                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                MOVE ZERO TO AC-AMT-UNUSED-CR                           
              END-IF                                                    
           ELSE                                                         
               DISPLAY '*** ABEND IN 7400-SELECT-AMT-UNUSED     ***'    
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
C32909*                                                                         
      ***************************************************************** 19190000
      * 7990-SELECT-DEP-PAY-AMT                                       * 19200000
      *                                                               * 19210000
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 19220000
      ***************************************************************** 19230000
      *                                                                 19240000
C32909 7990-SELECT-DEP-PAY-AMT.                                         
C32909*                                                                 19260000
C32909     EXEC SQL                                                     
C32909        SELECT   SUM(DEP_PAY_AMT)                                 
C32909          INTO   :WS-TOTAL-PAYMENTS :WS-TOTAL-PAYMENTS-NI          
C32909          FROM   CSS_DEP_PAY_HST                                  
C32909         WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
C32909           AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
C32909     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32909*                                                                 19340000
C32909     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C32909*                                                                 19360000
C32909     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C32909        IF  WS-TOTAL-PAYMENTS-NI < 0                              
C32909            MOVE ZEROES TO WS-TOTAL-PAYMENTS                      
C32909                           WS-TOTAL-PAYMENTS-NI                   
C32909        END-IF                                                    
C32909     ELSE                                                         
C32909        DISPLAY '**  PROCESSING ERROR IN PGM PCSCA347  **'        
C32909        DISPLAY '**  PARA - 7990-SELECT-DEP-PAY-AMT    **'        
C32909        DISPLAY '**      ERROR DURING SELECT FOR       **'        
C32909        DISPLAY '**             CSS_DEP_PAY_HST        **'        
C32909        DISPLAY '**  ACCOUNT NO = ' DP-ACCOUNT-NO                 
C32909        DISPLAY '**  DEPSOSIT ID= ' DP-DEPOSIT-CERT-NO            
C32909        DISPLAY '**  RC = ' WS-ACTIVE-RETURN-CODE                 
C32909        PERFORM 9900-ABEND                 THRU 9900-EXIT         
C32909     END-IF.                                                      
C32909*                                                                 19480000
C32909 7990-EXIT.                                                       
C32909     EXIT.                                                        
C32909*                                                                 19511017
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-UPDATE-LAST-RUN-DATE                                     *         
      *****************************************************************         
       8100-UPDATE-LAST-RUN-DATE.                                       
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA     = :G6-PARM-DATA                    
                 WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                 
                   AND CMND_CODE     = :G6-CMND-CODE                    
                   AND SEQ_NO        = :G6-SEQ-NO                       
                   AND COMPANY_NO    = :G6-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA347 ABORT **************'        
              DISPLAY '*     8100-UPDATE-LAST-RUN-DATE        *'        
              DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA347 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      ****                                                                      
      **  WRITES OUT DATA TO FCSCA347 FILE                          **          
      ****************************************************************          
       8900-WRITE-FIOCA347.                                             
      *                                                                         
           WRITE FIOCA347.                                              
      *                                                                         
           IF  FCA347-SUCCESSFUL                                        
               ADD 1                   TO WS-FCA347-REC-COUNT           
               INITIALIZE                 FIOCA347                      
           ELSE                                                         
               DISPLAY  '8900-ERROR ON FIOCA347 WRITE. STATUS IS '      
                         WS-FCA347-STATUS                               
               PERFORM  9900-ABEND  THRU 9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      **  9000-TERMINATE ..                                          **         
      **                    CLOSES INPUT & OUTPUT FILES              **         
      **                                                             **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA347-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
                                                                        
      ***************************** ***********************************         
      ** 6240-GET-FCA00-COMMON-DATE                                             
      *****************************************************************         
           COPY CPD00040.                                                       
                                                                        
      *****************************************************************         
      ** 6251-GET-FJC01-DATE.                                        **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **  7600-START-FCSJC01.                                        *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **  7620-START-FCSCA00.                                        *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
                                                                        
