       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA330.                                        
       DATE-WRITTEN.   06/15/99.                                        
       DATE-COMPILED.                                                   
       AUTHOR.         CBSIMDS                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **           COMPLETE BUSINESS SOLUTIONS INC., MAD             **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE    INITIALS       REASON                               **         
      **________  ________   ______________                          **         
      *****************************************************************         
      *                     PCSCA330   NARRATIVE                     **         
      *                                                              **         
      * THIS PROGRAM ACCEPTS THE REVENUE MONTH FROM SYSIN, VALIDATES **         
      * THE SAME AND THEN UPDATES THE JOB PARM TABLE WITH THIS REV MTH*         
      * IF SYSIN IS SPACES THEN FETCHES ALL THE ROWS WHERE PROGRAM   **         
      * NAME IS REPORTDATE AND COMMAND CODE IS DATE FROM THE JOB PARM**         
      * TABLE AND INCREMENTS THE REVENUE MONTH BY 1 AND THEN UPDATES **         
      * THE TABLE                                                    **         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                7000 - 7999     INPUT MODULES                           
                9900 - 9999     ABEND/ABORT MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA330'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-PARM-DATA.                                                
           05  FILLER                          PIC X(12).               
           05  WS-PARM-YEAR                    PIC 9(04).               
           05  WS-PARM-MONTH                   PIC 9(02).               
      *                                                                         
       01  WS-REVENUE-MONTH.                                            
           05  FILLER                          PIC X(12)  VALUE         
               'REPORT DATE='.                                          
           05  WS-REV-MTH.                                              
               10  WS-REV-CC                   PIC 9(02).               
               10  WS-REV-YY                   PIC 9(02).               
               10  WS-REV-MM                   PIC 9(02).               
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      **                                                                        
      *****************************************************************         
      *    CSS_JOB_PARM.                                                        
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *-- COPY BOOK HAVING SUCCESSFUL-CALL AND NOT-FOUND                        
                                                                        
      *  ABEND SWITCH COPYBOOK                                                  
       COPY CWS09900.                                                           
      *                                                                         
      *****************************************************************         
      ** CURSOR DECLARATION TO SELECT REV MONTH FROM JOB_PARM TABLE  **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE  REVMTH  CURSOR FOR                              
                SELECT  PARM_DATA                                       
                  FROM  CSS_JOB_PARM                                    
                 WHERE  PROGRAM_NAME = 'REPORTDATE'                     
                   AND  CMND_CODE    = 'DATE'                           
                   FOR  UPDATE OF PARM_DATA                             
           END-EXEC.                                                    
      *                                                                         
      *****************************************************************         
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-ACCEPT-SYSIN           THRU 0100-EXIT.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * ACCEPTS REVENUE MONTH FROM SYSIN AND VALIDATES THE SAME                 
      ******************************************************************        
      *                                                                         
       0100-ACCEPT-SYSIN.                                               
      *                                                                         
           ACCEPT WS-REV-MTH   FROM SYSIN.                              
      *                                                                         
           IF  WS-REV-MTH = ' '                                         
               PERFORM 1000-PROCESS-JBPARM     THRU 1000-EXIT           
           ELSE                                                         
               IF  WS-REV-MTH NOT NUMERIC                               
                   DISPLAY '************   PCSCA330  **************'    
                   DISPLAY '** REVENUE MTH MUST BE NUMERIC       **'    
                   DISPLAY '** REV MTH ENTERED IS : ', WS-REV-MTH       
                   DISPLAY '*** FORMAT TO BE ENTERED CCYYMM      **'    
                   DISPLAY '** PROCESS CONTINUING.........       **'    
                   DISPLAY '** REV MTH TAKEN FROM JOB_PARM TABLE **'    
                   DISPLAY '************   PCSCA330  **************'    
                   PERFORM 1000-PROCESS-JBPARM THRU 1000-EXIT           
               ELSE                                                     
                   PERFORM 1100-PROCESS-SYSIN  THRU 1100-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PASSES CONTROL TO OPEN,FETCH AND CLOSE THE  REVMTH CURSOR     **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-JBPARM.                                             
      *                                                                         
           PERFORM 7000-OPEN-REVMTH-CURSOR     THRU 7000-EXIT.          
           PERFORM 7010-FETCH-REVMTH-CURSOR    THRU 7010-EXIT.          
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               DISPLAY '****** PCSCA330 TERMINATING ***********'        
               DISPLAY '* NO RECORDS FETCHED FOR REVMTH CURSOR*'        
               DISPLAY '* PROGRAM TERMINATING                 *'        
               DISPLAY '****** PCSCA330 TERMINATING ***********'        
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
      *                                                                         
               MOVE G6-PARM-DATA               TO WS-PARM-DATA          
               IF  WS-PARM-MONTH = 12                                   
                   MOVE 01                     TO WS-PARM-MONTH         
                   ADD 1                       TO WS-PARM-YEAR          
               ELSE                                                     
                   ADD 1                       TO WS-PARM-MONTH         
               END-IF                                                   
               MOVE WS-PARM-DATA               TO G6-PARM-DATA          
      *                                                                         
               PERFORM 7100-UPDATE-JOBPARM     THRU 7100-EXIT           
      *                                                                         
               PERFORM 7010-FETCH-REVMTH-CURSOR                         
                                               THRU 7010-EXIT           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7020-CLOSE-REVMTH-CURSOR    THRU 7020-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * VALIDATES CENTURY, YEAR AND MONTH OBTAINED FROM SYSIN AND PASSES        
      * APPROPRIATE MESSAGE TO SYSOUT. IF THE REV MTH ENTERED IS CORRECT        
      * UPDATES JOB PARM TABLE WITH THIS REV MTH                                
      ******************************************************************        
      *                                                                         
       1100-PROCESS-SYSIN.                                              
      *                                                                         
           IF  WS-REV-CC = 19 OR 20                                     
               IF  (WS-REV-CC = 19 AND WS-REV-YY >= 90) OR              
                   (WS-REV-CC = 20 AND WS-REV-YY <= 50)                 
                   IF  WS-REV-MM >= 01 AND                              
                       WS-REV-MM <= 12                                  
                       MOVE WS-REVENUE-MONTH   TO G6-PARM-DATA          
                       PERFORM 7200-UPD-PARM   THRU 7200-EXIT           
                   ELSE                                                 
                       DISPLAY '***  PCSCA330 TERMINATING  *******'     
                       DISPLAY 'REV MTH TO BE IN BETWEEN 01 & 12 *'     
                       DISPLAY 'REV MTH ENTERED IS : ', WS-REV-MM       
                       DISPLAY 'FORMAT TO BE ENTERED CCYYMM      *'     
                       DISPLAY '***  PCSCA330 TERMINATING  *******'     
                       PERFORM 9900-ABEND      THRU 9900-EXIT           
                   END-IF                                               
               ELSE                                                     
                   DISPLAY '********  PCSCA330 TERMINATING  ******'     
                   DISPLAY '** REV YEAR TO BE > 90 FOR REV CEN 19*'     
                   DISPLAY '** REV YEAR TO BE < 50 FOR REV CEN 20*'     
                   DISPLAY '*** REV YEAR ENTERED IS : ', WS-REV-YY      
                   DISPLAY '*** REV CENTURY ENT  IS : ', WS-REV-CC      
                   DISPLAY '*** FORMAT TO BE ENTERED CCYYMM      *'     
                   DISPLAY '********  PCSCA330 TERMINATING  ******'     
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           ELSE                                                         
               DISPLAY '**********  PCSCA330 TERMINATING  ********'     
               DISPLAY '***  REV CENTURY SHOULD BE 19 OR 20     **'     
               DISPLAY '***  REV CENTURY ENTERED IS : ', WS-REV-CC      
               DISPLAY '***  FORMAT TO BE ENTERED CCYYMM         *'     
               DISPLAY '**********  PCSCA330 TERMINATING  ********'     
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ******************************************************************        
      *                                                                         
       7000-OPEN-REVMTH-CURSOR.                                         
      *                                                                         
           EXEC SQL                                                     
              OPEN REVMTH                                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA330 ABORT *************'        
               DISPLAY '* 7000-OPEN-REVMTH-CURSOR             *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA330 ABORT *************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCHES REVENUE MONTH FROM CSS_JOB_PARM TABLE                           
      ******************************************************************        
      *                                                                         
       7010-FETCH-REVMTH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              FETCH  REVMTH                                             
               INTO  :G6-PARM-DATA                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA330 ABORT *************'        
               DISPLAY '* 7010-FETCH-REVMTH-CURSOR            *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA330 ABORT *************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7020-CLOSE-REVMTH-CURSOR.                                        
      *                                                                         
           EXEC SQL                                                     
              CLOSE REVMTH                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA330 ABORT *************'        
               DISPLAY '* 7020-CLOSE-REVMTH-CURSOR            *'        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                 *'        
               DISPLAY '********** PCSCA330 ABORT *************'        
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * UPDATES JOB PARM TABLE                                                  
      ******************************************************************        
      *                                                                         
       7100-UPDATE-JOBPARM.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                 SET PARM_DATA = :G6-PARM-DATA                          
               WHERE CURRENT OF REVMTH                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA330 ABORT ************'         
               DISPLAY '* 7100-UPDATE-JOBPARM                *'         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                *'         
               DISPLAY '********** PCSCA330 ABORT ************'         
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-UPD-PARM.                                                   
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = 'REPORTDATE'                       
                  AND CMND_CODE    = 'DATE'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   DISPLAY '************ PCSCA330 ****************'     
                   DISPLAY '* 7200-UPD-PARM                      *'     
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* NO ROWS EXISTS WITH PROGRAM_NAME   *'     
                   DISPLAY '* REPORTDATE & CMND_CODE DATE        *'     
                   DISPLAY '************ PCSCA330 ****************'     
                                                                        
               ELSE                                                     
                   DISPLAY '********** PCSCA330 ABORT ************'     
                   DISPLAY '* 7200-UPDATE-PARM                   *'     
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                *'     
                   DISPLAY '********** PCSCA330 ABORT ************'     
                   PERFORM 9900-ABEND          THRU 9900-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * THIS 9000-TERMINATE IS CODED AS IT IS REQUIRED BY 9900-ABEND.           
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
           CONTINUE.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
