       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA325.                                        
       AUTHOR.         COVANSYS.                                        
       DATE-WRITTEN.   AUG 2007.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      *****************************************************************         
      *              P R O G R A M  S U M M A R Y                     *         
      *****************************************************************         
      **     GENERATES OUTPUT FILE FOR OPTION LETTER PROCESS         **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **  08/2007   VY95550      INITIAL VERSION OF PROGRAM          **         
C36000**  01/2008   VY95550      UPDATE FOR REG ELIGIBLE DREG LETTER **         
C37786**  10/07/08  JC91900      FIX ISSUE WITH EARLY RENEWAL LETTER.**         
P00141**  04/2009   SS97726      ADD START/END DATE TO OPT_ATTR_INCTV**         
P00172**  07/2009   VY95550      REGULATED TRANSITION CHANGES TO     **         
P00172**                         LOOK FOR EVALUATION MONTHS TO       **         
P00172**                         CALCULATE THE GOOD PAYMENT          **         
P00172**  08/2009   VY95550      REMOVED CSS_DHR_HIST TABLE REFERENCE**         
P00172**                         AND MODIFIED THE CODE TO CHECK      **         
P00172**                         DHR_FL OF CSS_CUSTOMER TABLE        **         
PRJ211**  10/2009   MN90523      CHANGES MADE IN 7270- TO DETERMINE  **         
PRJ211**                         FIXED OR VARIABLE RATE CUSTOMER     **         
PRJ211**                         BASED ON ACTIVE OPTION AND REMOVED  **         
PRJ211**                         7260- PARA                          **         
PRJ172**  01/19/10  JC91900      Re-write the logic which determines **         
PRJ172**                         reminder/offer letter timeline using**         
PRJ172**                         account attribute table. Business   **         
PRJ172**                         rules mandate offer letter should   **         
PRJ172**                         go first before sending reminder    **         
PRJ172**                         letter.                             **         
P00473**  05/16/11  SB93596      CHGS INCLUDED TO PULL APPROVED      **         
P00473**                         OPTION attr inctv records.          **         
P00599**  08/16/12  GV7A828      INSERT NOTICES INTO DB2 TABLES      **         
P00599**                         INSTEAD OF WRITING IT TO RP000 FILE **         
A04583**  04/18/13  HA7A338      ADD LOGIC TO SEND DEREG SWITCH OFFER**         
A04583**                         LETTER & REMINDER LETTER TO FIX RATE**         
A04583**                         GROUP-2 CUSTOMERS                   **         
A04583**                         REMOVE LOGIC TO SEND 30-DAY REMINDER**         
A04583**                         LETTER TO VARIABLE RATE GROUP-2 CUST**         
A04527**  08/02/13  AS7C117      INSERT DATA INTO CSS_COMM_DATA      **         
A04527**            ACT124       INSTEAD OF CSS_CUST_COMM_MF TABLE.  **         
A04527**                         CHECK THE DEREG SWITH 30 DAY        **         
A04527**                         OFFER LETTER FLAG WHILE SENDING     **         
A04527**                         DEREG SWITCH OFFER LETTER FOR       **         
A04527**                         VARIABLE RATE ACCOUNTS.             **         
A04880**  01/30/14  AS7C117      Remove unused dclgens.              **         
A04880**            ACT027                                           **         
A05136**  01/23/15  AS7C117      Remove copybook CWS10007            **         
A05136**            ACT021                                           **         
      *****************************************************************         
      *                                                                *00993000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00993100
      *                                                                *00993200
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00993300
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00993400
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00993500
      *  3000 - 4999  NOT USED                                         *00993600
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00993700
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00993800
      *  7000 - 7999  INPUT MODULES                                    *00993900
      *  8000 - 8999  OUTPUT MODULES                                   *00994000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00994100
      *                                                                *00994200
      ******************************************************************00994300
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA325'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40)     VALUE          
             'WORKING STORAGE FOR PCSCA325 STARTS HERE'.                
      *                                                                         
       01  WS-SWITCHES.                                                 
PRJ172     05  WS-NO-MORE-ROWS             PIC X(01) VALUE 'N'.         
PRJ172         88  NO-MORE-ROWS                      VALUE 'Y'.         
PRJ211     05  WS-DREG-SWITCH-TYPE         PIC X(01) VALUE ' '.         
PRJ211         88 DREG-SWITCH-OFFER                  VALUE 'O'.         
PRJ211         88 DREG-SWITCH-REMINDER               VALUE 'R'.         
A04527     05  WS-DREG-30DAY-OFFER-FLAG    PIC X(01) VALUE ' '.         
A04527         88 DREG-30DAY-OFFER-ACTIVE            VALUE 'Y'.         
A04527         88 DREG-30DAY-OFFER-NOT-ACTIVE        VALUE 'N'.         
A04583     05  WS-OPTION-TYPE              PIC X(02) VALUE ' '.         
A04583         88 FIXED-PRICE                        VALUE 'FP'.        
A04583         88 VARIABLE-PRICE                     VALUE 'VP'.        
A04583         88 INCENTIVES-ONLY                    VALUE 'IN'.        
A04583         88 TERM-VARIBALE-PRICE                VALUE 'TV'.        
A04583         88 INTRO-VARIABLE-PRICE               VALUE 'IV'.        
                                                                        
       01  WS-MISC.                                                     
           05  WS-CYC1                     PIC X(2)  VALUE SPACES.      
           05  WS-CYC2                     PIC X(2)  VALUE SPACES.      
           05  WS-CYC3                     PIC X(2)  VALUE SPACES.      
           05  WS-CYC4                     PIC X(2)  VALUE SPACES.      
           05  WS-DAY-NO                   PIC S9(04) COMP.             
           05  WS-NBR-MTHS-DIFF            PIC S9(04) COMP VALUE 0.     
           05  WS-NBR-TERM                 PIC 9(4)  VALUE 0.           
           05  WS-REMAINDER                PIC 9(4)  VALUE 0.           
           05  WS-NBR-MTHS-DREG-REMIND     PIC 9(4).                    
           05  WS-NBR-OF-DAYS              PIC 9(4).                    
           05  WS-DAY-COUNTER              PIC 9(02) VALUE ZEROS.       
           05  WS-RUN-DATE                 PIC X(10) VALUE SPACES.      
           05  WS-RUN-DATE-RED  REDEFINES WS-RUN-DATE.                  
               10 WS-RUN-CCYY              PIC X(04).                   
               10 FILLER                   PIC X(01).                   
               10 WS-RUN-MM                PIC X(02).                   
               10 FILLER                   PIC X(01).                   
               10 WS-RUN-DD                PIC X(02).                   
           05  WS-CURR-REVENUE-MONTH       PIC 9(6).                    
           05  WS-CURR-REVENUE-DT.                                      
               10 WS-CURR-YYYY             PIC X(4).                    
               10 FILLER                   PIC X(1) VALUE '-'.          
               10 WS-CURR-MM               PIC X(2).                    
               10 FILLER                   PIC X(1) VALUE '-'.          
               10 WS-CURR-DD               PIC X(2) VALUE '01'.         
           05  WS-CURR-REVENUE-DT-H        PIC X(10).                   
C36000     05  WS-GRP2-LOW-CSC-QUALIFY     PIC 9(02) VALUE 0.           
PRJ172     05  WS-REV-MTH-LST-NRML         PIC 9(6)  VALUE ZEROES.      
PRJ172     05  WS-DUMMY-DATE               PIC X(10) VALUE SPACES.      
PRJ172     05  WS-RESULT-DATE              PIC X(10) VALUE SPACES.      
PRJ172     05  WS-START-DATE               PIC X(10) VALUE SPACES.      
PRJ172     05  WS-END-DATE                 PIC X(10) VALUE SPACES.      
PRJ172     05  WS-OFFER-DATE               PIC X(10) VALUE SPACES.      
PRJ172     05  WS-REMIND-DATE              PIC X(10) VALUE SPACES.      
PRJ172     05  WS-ADJ-DAY                  PIC S9(4) USAGE COMP.        
PRJ172     05  WS-BUS-DAY-COUNT            PIC S9(4) USAGE COMP.        
PRJ172     05  WS-MNTHLY-REMIND-REV        PIC 9(6) VALUE ZEROES.       
PRJ172     05  WS-YEARLY-REMIND-REV        PIC 9(6) VALUE ZEROES.       
PRJ172     05  WS-START-REV-MONTH.                                      
PRJ172         10 WS-START-YR-N            PIC 9(4).                    
PRJ172         10 WS-START-MTH-N           PIC 9(2).                    
P00599     05  WS-CURRENT-DATE             PIC X(10)    VALUE SPACES.   
P00599     05  WS-CURRENT-TIMESTAMP        PIC X(26)    VALUE SPACES.   
COB305     05 WS-PREV-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
P00599     05  WS-SEQ-NO-COUNT             PIC S9(4) USAGE COMP VALUE 0.
COB305     05 WS-CORRESP-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.    
A04527     05  WS-RED-FL-NULL-IND          PIC S9(04) COMP VALUE +0.    
A04527     05  WS-INITIAL-COMMENT-TX.                                   
A04527         10  WS-INITIAL-COMMENT-TX-LEN  PIC S9(4) USAGE COMP.     
A04527         10  WS-INITIAL-COMMENT-TX-TEXT PIC X(255) VALUE SPACES.  
A04527     05  WS-END-NULL-IND                PIC S9(04) COMP VALUE +0. 
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA325'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA325'.  
           05  WS-COMMON                   PIC X(08) VALUE 'COMMON  '.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-DREG-DELINQ-CD           PIC X(20) VALUE              
                                              'NBR-MONTHS-REMIND'.      
           05  WS-DAYS-DELINQ-CD           PIC X(20) VALUE              
                                              'NBR-DAYS-PCSCA325'.      
PRJ172     05  WS-LOWER-CSC                PIC X(02) VALUE '2L'.        
PRJ172     05  WS-YES                      PIC X(01) VALUE 'Y'.         
PRJ172     05  WS-NO                       PIC X(01) VALUE 'N'.         
PRJ172     05  WS-SWTCH-LTR-ATTRIB         PIC X(17) VALUE              
PRJ172                                        'DREG-SWTCH-LETTER'.      
A04527     05  WS-SWTCH-LTR-ATTRIB-FIX     PIC X(18) VALUE              
A04527                                        'DREG-SWTCH-LTR-FIX'.     
                                                                        
       01  WS-NULL-IND-VARS.                                            
           05 WS-NULL-IND                  PIC S9(04) COMP.             
           05 WS-NULL-IND1                 PIC S9(04) COMP.             
                                                                        
      *                                                                 00800000
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
       COPY CWS00010.                                                           
                                                                        
      *****************************************************************         
      *  CWS00329  - GOOD PAYMENT                                     *         
      *****************************************************************         
       COPY CWS00329.                                                           
                                                                        
P00599*****************************************************************         
P00599*  CWS00350  - CORRESP_COMM vARIABLES                           *         
P00599*****************************************************************         
P00599     EXEC SQL                                                             
P00599          INCLUDE CWS00350                                                
P00599     END-EXEC.                                                            
P00599                                                                  
P00599******************************************************************        
P00599* CORRESP MAIL UID CPYC WS VARIABLES.                            *        
P00599******************************************************************        
P00599     EXEC SQL                                                             
P00599         INCLUDE CWSCA165                                                 
P00599     END-EXEC.                                                            
PRJ172****************************************************************          
PRJ172*  Working storage support for CPD00315 - Business day calc    *          
PRJ172****************************************************************          
PRJ172     EXEC SQL                                                             
PRJ172          INCLUDE CWS00315                                                
PRJ172     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00038.                                                           
                                                                        
      *****************************************************************         
      *  CWS00039  JOB PARM ROUTINE                                   *         
      *****************************************************************         
       COPY CWS00039.                                                           
                                                                        
      *****************************************************************         
      * IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM       *         
      *****************************************************************         
       COPY FIOJC01.                                                            
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
       COPY FIOCA00.                                                            
                                                                        
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
       COPY CWS09900.                                                           
                                                                        
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    DECLARATION FOR SQL COMMAND AREA                           *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCOUNT, AT                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILL_WINDOW, BN                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
P00172*****************************************************************         
P00172*    TABLE : CSS_CUSTOMER, CU                                   *         
P00172*****************************************************************         
P00172     EXEC SQL                                                             
P00172         INCLUDE TBCUST                                                   
P00172     END-EXEC.                                                            
                                                                        
PRJ172*****************************************************************         
PRJ172*    TABLE : CSS_ACCT_ATTRIBUTE, YP                             *         
PRJ172*****************************************************************         
PRJ172     EXEC SQL                                                             
PRJ172         INCLUDE TBACTATT                                                 
PRJ172     END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_RATE_PLAN_DESC, RD                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_UTIL_ENVRNMT, UT                               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_JOB_PARM, G6                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE :  CSS_HOLIDAY, J8                                   *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE :  CSS_CREDIT_PROFILE, CZ                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
C36000*****************************************************************         
C36000*    TABLE : CRM_MKT_TIER_ADJ, 1B                               *         
C36000*****************************************************************         
C36000     EXEC SQL                                                             
C36000         INCLUDE TBMKTTAD                                                 
C36000     END-EXEC.                                                            
C36000                                                                  
C36000******************************************************************        
C36000* CSS_ACCT_RTPK_AGR, DF                                          *        
C36000******************************************************************        
C36000     EXEC SQL                                                             
C36000        INCLUDE TBACCTRG                                                  
C36000     END-EXEC.                                                            
C36000                                                                  
C36000******************************************************************        
C36000*    CSS_SPCL_FCTR, SF                                           *        
C36000******************************************************************        
C36000     EXEC SQL                                                             
C36000         INCLUDE TBSPLFTR                                                 
C36000     END-EXEC.                                                            
A04583                                                                  
A04583******************************************************************        
A04583* CRM_RT_PKG_OPTION,  FI                                         *        
A04583******************************************************************        
A04583     EXEC SQL                                                             
A04583        INCLUDE TBRTPKGO                                                  
A04583     END-EXEC.                                                            
P00599******************************************************************        
P00599* CSS_CORRESP_NOTICE- 1M                                        *         
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORNOT                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************06330000
P00599* CSS_CORRESP_HDR - 1J                                           *06340000
P00599******************************************************************06350000
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORHDR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599******************************************************************06330000
P00599* CSS_CORRESP_VAR - 1K                                           *06340000
P00599******************************************************************06350000
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORVAR                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
P00599                                                                  
P00599******************************************************************        
P00599* CSS_CORRESP_COMM  - 1L                                        *         
P00599******************************************************************        
P00599*                                                                         
P00599     EXEC SQL                                                             
P00599         INCLUDE TBCORCOM                                                 
P00599     END-EXEC.                                                            
P00599*                                                                         
A04527******************************************************************        
A04527* CSS_COMM_DATA     - KO                                        *         
A04527******************************************************************        
A04527*                                                                         
A04527     EXEC SQL                                                             
A04527         INCLUDE TBCOMDAT                                                 
A04527     END-EXEC.                                                            
A04527*                                                                         
      ***************************************************************** 03230000
      **   SQL DECLARE STATEMENTS                                    ** 03240000
      ***************************************************************** 03250000
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET GROUP2 DHR NON-QUALIFIED VARIABLE RATE CUSTOMERS *03260000
      *----------------------------------------------------------------*03260000
           EXEC SQL                                                     
            DECLARE DHR_CUR  CURSOR FOR                                 
             SELECT AT.ACCOUNT_NO                                       
                   ,UT.GAS_BASE_LAST_UPDT                               
C36000             ,UT.IC_NO                                            
C36000             ,RD.MKT_PROGRAM_CD                                   
PRJ172             ,AT.REV_MTH_LST_NRML                                 
PRJ172             ,AT.CUSTOMER_NO                                      
PRJ172             ,AT.COMPANY_NO                                       
PRJ172             ,AT.BILL_CYCLE                                       
PRJ172             ,AT.LOCAL_OFFICE                                     
PRJ172             ,AT.ADDRESS_ID                                       
PRJ172             ,AT.ADDRESS_FORMAT                                   
A04583             ,DF.OPTION_CD                                        
A04527             ,AT.PREMISE_NO                                       
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
                   ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
P00172             ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                       
PRJ172             ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                 
              WHERE AT.CODE_ACCT_STAT     = 'A'                         
                AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO               
                AND UT.CODE_UTIL_TYPE     = 'G'                         
                AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE           
                AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO             
C36000          AND RD.MKT_PROGRAM_CD IN ('2L','2H')                    
                AND RD.REG_GROUP_CD       = '200'                       
P00172          AND CU.CUSTOMER_NO        = AT.CUSTOMER_NO              
P00172          AND CU.DHR_FL             <> 'Y'                        
PRJ172          AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO               
PRJ172          AND UT.COMPANY_NO         = DF.COMPANY_NO               
PRJ172          AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE           
PRJ172          AND UT.IC_NO              = DF.IC_NO                    
PRJ172          AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO        
                AND AT.BILL_CYCLE  IN (:WS-CYC1,:WS-CYC2,               
                                       :WS-CYC3,:WS-CYC4)               
P00599        ORDER BY AT.ACCOUNT_NO                                    
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE DHR_CUR  CURSOR FOR                                         
MFA-TR*      SELECT AT.ACCOUNT_NO                                               
MFA-TR*            ,UT.GAS_BASE_LAST_UPDT                                       
MFA-TR*            ,UT.IC_NO                                                    
MFA-TR*            ,RD.MKT_PROGRAM_CD                                           
MFA-TR*            ,AT.REV_MTH_LST_NRML                                         
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,DF.OPTION_CD                                                
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*            ,CSS_RATE_PLAN_DESC RD                                       
MFA-TR*            ,CSS_CUSTOMER CU                                             
MFA-TR*            ,CSS_ACCT_RTPK_AGR  DF                                       
MFA-TR*       WHERE AT.CODE_ACCT_STAT     = 'A'                                 
MFA-TR*         AND AT.ACCOUNT_NO         = UT.ACCOUNT_NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE     = 'G'                                 
MFA-TR*         AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE                   
MFA-TR*         AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO                     
MFA-TR*         AND RD.MKT_PROGRAM_CD IN ('2L','2H')                            
MFA-TR*         AND RD.REG_GROUP_CD       = '200'                               
MFA-TR*         AND CU.CUSTOMER_NO        = AT.CUSTOMER_NO                      
MFA-TR*         AND CU.DHR_FL             <> 'Y'                                
MFA-TR*         AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO                       
MFA-TR*         AND UT.COMPANY_NO         = DF.COMPANY_NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                   
MFA-TR*         AND UT.IC_NO              = DF.IC_NO                            
MFA-TR*         AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*         AND AT.BILL_CYCLE  IN (:WS-CYC1,:WS-CYC2,                       
MFA-TR*                                :WS-CYC3,:WS-CYC4)                       
MFA-TR*       ORDER BY AT.ACCOUNT_NO                                            
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*03260000
      * CURSOR TO GET OPEN BILL CYCLE ON A GIVEN DATE                  *03260000
      *----------------------------------------------------------------*03260000
      *                                                                         
           EXEC SQL                                                     
            DECLARE BILL_CYC_CUR  CURSOR FOR                            
             SELECT BN.BILL_CYCLE                                       
PRJ172             ,BN.DATE_EXTRACT                                     
               FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                    
PRJ172        WHERE BN.DATE_EXTRACT IN (IIF(TRY_CONVERT(DATE, 
                                                         :WS-OFFER-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFFER-DATE
              ) <> 0) OR (LEN(:WS-OFFER-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-OFFER-DATE
              ), CONVERT(DATE, :WS-OFFER-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-REMIND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REMIND-DATE
              ) <> 0) OR (LEN(:WS-REMIND-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REMIND-DATE
              ), CONVERT(DATE, :WS-REMIND-DATE) ))
                AND BN.DATE_EXTRACT =                                   
             (SELECT MIN(B1.DATE_EXTRACT)                               
               FROM CSS_BILL_WINDOW B1 WITH(READUNCOMMITTED)                    
              WHERE B1.BILL_CYCLE   = BN.BILL_CYCLE                     
                AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BILL_CYC_CUR  CURSOR FOR                                    
MFA-TR*      SELECT BN.BILL_CYCLE                                               
MFA-TR*            ,BN.DATE_EXTRACT                                             
MFA-TR*        FROM CSS_BILL_WINDOW BN                                          
MFA-TR*       WHERE BN.DATE_EXTRACT IN (:WS-OFFER-DATE, :WS-REMIND-DATE)        
MFA-TR*         AND BN.DATE_EXTRACT =                                           
MFA-TR*      (SELECT MIN(B1.DATE_EXTRACT)                                       
MFA-TR*        FROM CSS_BILL_WINDOW B1                                          
MFA-TR*       WHERE B1.BILL_CYCLE   = BN.BILL_CYCLE                             
MFA-TR*         AND B1.REVENUE_MONTH = BN.REVENUE_MONTH)                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
      ***                                                                       
       01  WS-END                      PIC X(40)    VALUE               
             'WORKING STORAGE FOR PCSCA325 ENDS HERE  '.                
      *                                                                         
       PROCEDURE DIVISION.                                              
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PATH OF PROGRAM                         **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT           
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT           
           PERFORM 9000-TERMINATE              THRU 9000-EXIT           
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      *   READ JOBS TABLE TO OBTAIN RUN DATE/COMMON DATE            **          
      *   GETS THE CURRENT AND PREVIOUS BILL CYCLE                  **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
                                                                        
                                                                        
P00599     INITIALIZE WS-CORRESP-COMM-VAR                               
P00599                WS-PREV-ACCOUNT-NO.                               
           MOVE '01'                   TO C8-COMPANY-NO                 
                                          J8-COMPANY-NO                 
           MOVE WS-DREG-DELINQ-CD      TO C8-DELINQ-CD                  
           PERFORM 7000-SELECT-DELINQ-VALUE    THRU 7000-EXIT           
           MOVE C8-DELINQ-VALUE        TO WS-NBR-MTHS-DREG-REMIND       
                                                                        
      * GET THE NUMBER OF BUSINESS DAYS TO BE CALCULATED                        
           MOVE WS-DAYS-DELINQ-CD            TO C8-DELINQ-CD.           
           PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE              TO WS-NBR-OF-DAYS.         
                                                                        
P00599* TO IDENTIFY THE DATA BASE                                               
P00599     MOVE ZERO                            TO WS-CWS350-DATABASE.  
P00599     MOVE 'DATABASE'                      TO C8-DELINQ-CD.        
           PERFORM 7000-SELECT-DELINQ-VALUE     THRU 7000-EXIT.         
P00599     MOVE C8-DELINQ-VALUE                 TO WS-CWS350-DATABASE.  
      * GET CURRENT BILLING CYLCE                                               
           PERFORM 0110-GET-RUN-DATES           THRU 0110-EXIT          
           MOVE WS-INPUT-RUN-DATE            TO WS-RUN-DATE             
PRJ172                                          BN-DATE-EXTRACT         
PRJ172                                          WS-REMIND-DATE          
PRJ172                                          WS-NEW-BUSINESS-DAY.    
                                                                        
      * GET NEXT 5 BUSINESS DAY'S  BILLING CYLCE                                
PRJ172     PERFORM 0230-GET-NEXT-BUSINESS-DAYS  THRU 0230-EXIT          
PRJ172        VARYING WS-ADJ-DAY FROM 1 BY 1                            
PRJ172          UNTIL WS-ADJ-DAY > WS-NBR-OF-DAYS.                      
                                                                        
PRJ172     MOVE WS-NEW-BUSINESS-DAY          TO WS-OFFER-DATE.          
                                                                        
PRJ172     MOVE SPACES                       TO WS-CYC1                 
PRJ172                                          WS-CYC2                 
PRJ172                                          WS-CYC3                 
PRJ172                                          WS-CYC4.                
PRJ172     PERFORM 7200-OPEN-BILL-CYC-CUR       THRU 7200-EXIT.         
PRJ172     PERFORM 7210-FETCH-BILL-CYC-CUR      THRU 7210-EXIT.         
PRJ172     MOVE 'N'                          TO WS-NO-MORE-ROWS.        
           PERFORM 0210-GET-BILL-CYCLE          THRU 0210-EXIT          
                                                UNTIL NO-MORE-ROWS.     
PRJ172     PERFORM 7220-CLOSE-BILL-CYC-CUR      THRU 7220-EXIT.         
                                                                        
      * GET CURRENT REVENUE MONTH                                               
           MOVE WS-RUN-DATE                  TO BN-DATE-EXTRACT         
           PERFORM 7025-SELECT-CURR-REVMTH      THRU 7025-EXIT          
           MOVE WS-CURR-REVENUE-MONTH(1:4)   TO WS-CURR-YYYY            
           MOVE WS-CURR-REVENUE-MONTH(5:2)   TO WS-CURR-MM              
           MOVE WS-CURR-REVENUE-DT           TO WS-CURR-REVENUE-DT-H    
                                                                        
PRJ172     MOVE WS-CURR-REVENUE-MONTH        TO WS-START-REV-MONTH.     
PRJ172                                                                  
P00172* GET GROUP2-LOW-CSC-GOOD-PAY-QTY & WS-HIST-EVAL-MONTHS                   
C36000     PERFORM 7250-SELECT-MIN-GOOD-PAY-QTY THRU 7250-EXIT          
                                                                        
P00172     MOVE 1B-MIN-GOOD-PAY-QTY          TO WS-GRP2-LOW-CSC-QUALIFY 
P00172                                                                  
P00172     MOVE 1B-EVAL-MONTHS-QTY           TO WS-HIST-EVAL-MONTHS.    
P00172                                                                  
PRJ172     DISPLAY '****PCSCA325 INFORMATIONAL MESSAGE******'           
PRJ172     DISPLAY '*                                      *'           
PRJ172     DISPLAY '*   BILL CYCLES USED FOR PROCESSING    *'           
PRJ172     DISPLAY '*   -------------------------------    *'           
PRJ172     DISPLAY '* For sending offer letter(s) : ' WS-CYC3, WS-CYC4  
PRJ172     DISPLAY '* For sending reminder letter(s): ' WS-CYC1, WS-CYC2
PRJ172     DISPLAY '*                                      *'           
PRJ172     DISPLAY '****************************************'.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  0110-GET-RUN-DATES                                        **          
      ****************************************************************          
       0110-GET-RUN-DATES.                                              
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT             
                                                                        
           IF COMMON-DATE-NEEDED                                        
               MOVE WS-COMMON            TO WS-PGRMNAME                 
               MOVE SPACES               TO WS-INPUT-AREA               
               MOVE SPACES               TO WS-INPUT-DATA-BREAKDOWN     
               PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT               
               MOVE PROGRAM-NAME         TO WS-PGRMNAME                 
           END-IF                                                       
           .                                                            
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ172****************************************************************          
PRJ172**  0210-GET-BILL-CYCLE                                       **          
PRJ172**                                                            **          
PRJ172**  At any given point of time, offer or reminder bill cycles **          
PRJ172**  will not have more than two bill cycles. Two bill cycle   **          
PRJ172**  logic is included to handle mainly cycle 20 and 21.       **          
PRJ172****************************************************************          
PRJ172 0210-GET-BILL-CYCLE.                                             
PRJ172                                                                  
PRJ172     IF BN-DATE-EXTRACT EQUAL WS-OFFER-DATE                       
PRJ172        IF WS-CYC3 EQUAL SPACES                                   
PRJ172           MOVE BN-BILL-CYCLE          TO   WS-CYC3               
PRJ172        ELSE                                                      
PRJ172           MOVE BN-BILL-CYCLE          TO   WS-CYC4               
PRJ172        END-IF                                                    
PRJ172     END-IF.                                                      
PRJ172     IF BN-DATE-EXTRACT EQUAL WS-REMIND-DATE                      
PRJ172        IF WS-CYC1 EQUAL SPACES                                   
PRJ172           MOVE BN-BILL-CYCLE          TO   WS-CYC1               
PRJ172        ELSE                                                      
PRJ172           MOVE BN-BILL-CYCLE          TO   WS-CYC2               
PRJ172        END-IF                                                    
PRJ172     END-IF.                                                      
PRJ172                                                                  
PRJ172     PERFORM 7210-FETCH-BILL-CYC-CUR      THRU 7210-EXIT.         
PRJ172                                                                  
PRJ172 0210-EXIT.                                                       
PRJ172     EXIT.                                                        
      *                                                                         
PRJ172******************************************************************        
PRJ172* 0230-GET-NEXT-BUSINESS-DAYS.                                   .        
PRJ172******************************************************************        
PRJ172 0230-GET-NEXT-BUSINESS-DAYS.                                     
PRJ172*                                                                         
PRJ172     MOVE 'N'                   TO WS-NEXT-BUSINESS-DAY.          
PRJ172     PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
PRJ172                           THRU 6500-NEXT-BUSINESS-DAY-EXIT       
PRJ172                                UNTIL NEXT-BUSINESS-DAY-FOUND.    
PRJ172*                                                                         
PRJ172 0230-EXIT.                                                       
PRJ172     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-INPUT                                        **          
      ****************************************************************          
       1000-PROCESS-INPUT.                                              
                                                                        
PRJ172     MOVE 'N'                          TO WS-NO-MORE-ROWS.        
           PERFORM 7100-OPEN-DHR-VAR-CUR        THRU 7100-EXIT.         
           PERFORM 7110-FETCH-DHR-VAR-CUR       THRU 7110-EXIT.         
           PERFORM 2000-PROCESS-DATA            THRU 2000-EXIT          
                                                UNTIL NO-MORE-ROWS.     
           PERFORM 7120-CLOSE-DHR-VAR-CUR       THRU 7120-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  2000-PROCESS-DATA                                         **          
      **                                                            **  03832800
PRJ172**  Criteria to send offer letter                             **  03832800
PRJ172**      (a) Satisfy number of good payment criteria.          **  03832800
PRJ172**      (b) A grp movement happened after last offer went out **  03832800
      **                                                            **  03832800
PRJ172**  Criteria for sending reminder letter.                     **  03832800
PRJ172**      (a) A valid offer letter row identified by acct attrib**  03832800
PRJ172**      (b) No group movements after sending offer letter.    **  03832800
      **                                                            **  03832800
      ****************************************************************          
       2000-PROCESS-DATA.                                               
                                                                        
PRJ172     MOVE SPACES                       TO WS-DREG-SWITCH-TYPE     
PRJ172                                          WS-OPTION-TYPE          
PRJ172                                          YP-STATUS-CD.           
PRJ172     MOVE AT-ACCOUNT-NO                TO YP-ACCOUNT-NO.          
PRJ172                                                                  
PRJ172     IF AT-BILL-CYCLE = WS-CYC3 OR WS-CYC4                        
PRJ172        SET DREG-SWITCH-OFFER          TO TRUE                    
PRJ172     ELSE                                                         
PRJ172        IF RD-MKT-PROGRAM-CD = WS-LOWER-CSC                       
PRJ172           SET DREG-SWITCH-REMINDER    TO TRUE                    
PRJ172        END-IF                                                    
PRJ172     END-IF.                                                      
                                                                        
A04583     IF DREG-SWITCH-OFFER OR DREG-SWITCH-REMINDER                 
A04583        PERFORM 7060-GET-CREDIT-INFO      THRU 7060-EXIT          
A04583        PERFORM 2500-CHECK-GOOD-PYMTS     THRU 2500-EXIT          
A04583                                                                  
A04583        IF WS-NBR-GOOD-PAYMENT >= WS-GRP2-LOW-CSC-QUALIFY         
A04583           PERFORM 7400-SEL-ACCT-ATTRIB   THRU 7400-EXIT          
A04583           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
A04583              IF UT-GAS-BASE-LAST-UPDT > YP-ATTRIBUTE-VALUE-DT    
A04583                 IF DREG-SWITCH-OFFER                             
A04527                    PERFORM 7500-VAR-FIX-CHECK                    
A04527                                          THRU 7500-EXIT          
A04583                    PERFORM 2200-SEND-DREG-LETTER                 
A04583                                          THRU 2200-EXIT          
A04583                    PERFORM 2150-MOVE-ATTRIB-DET                  
A04583                                          THRU 2150-EXIT          
A04583                    PERFORM 8400-UPDATE-ACCT-ATTRIB               
A04583                                          THRU 8400-EXIT          
A04583                    IF FI-OPT-CALC-TYPE-CD = 'FP'                 
A04583                       DISPLAY 'De-reg fix switch offer/upd: '    
A04583                                             AT-ACCOUNT-NO        
A04583                    ELSE                                          
A04583                       DISPLAY 'De-reg var switch offer/upd: '    
A04583                                             AT-ACCOUNT-NO        
A04583                    END-IF                                        
A04583                 END-IF                                           
A04583              ELSE                                                
A04583                 IF DREG-SWITCH-REMINDER                          
A04583                    PERFORM 2100-SEND-REMINDER-LETTER             
A04583                                           THRU 2100-EXIT         
A04583                 END-IF                                           
A04583              END-IF                                              
A04583           ELSE                                                   
A04527              MOVE 'N'            TO WS-DREG-30DAY-OFFER-FLAG     
A04527              PERFORM 7500-VAR-FIX-CHECK           THRU 7500-EXIT 
A04527              IF FI-OPT-CALC-TYPE-CD = 'VP'                       
A04527                 PERFORM 7300-CHK-DREG-30DAY-OFFER THRU 7300-EXIT 
A04527              END-IF                                              
A04527              IF DREG-SWITCH-OFFER AND DREG-30DAY-OFFER-NOT-ACTIVE
A04583                 PERFORM 2200-SEND-DREG-LETTER                    
A04583                                           THRU 2200-EXIT         
A04583                 PERFORM 2150-MOVE-ATTRIB-DET                     
A04583                                           THRU 2150-EXIT         
A04583                 PERFORM 8350-INSERT-ACCT-ATTRIB                  
A04583                                           THRU 8350-EXIT         
A04583                 IF FI-OPT-CALC-TYPE-CD = 'FP'                    
A04583                    DISPLAY 'De-reg fix switch offer: '           
A04583                                                AT-ACCOUNT-NO     
A04583                 ELSE                                             
A04583                    DISPLAY 'De-reg var switch offer: '           
A04583                                                AT-ACCOUNT-NO     
A04583                 END-IF                                           
PRJ172              END-IF                                              
PRJ172           END-IF                                                 
A04583        END-IF                                                    
A04583     END-IF.                                                      
A04583                                                                  
           PERFORM 7110-FETCH-DHR-VAR-CUR       THRU 7110-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 2100-SEND-REMINDER-LETTER                                     * 03832900
      * CHECKS TO REMIND THE CUSTOMER ON MONTHLY AND YEARLY           *         
      ***************************************************************** 03833000
       2100-SEND-REMINDER-LETTER.                                       
                                                                        
PRJ172     MOVE YP-ATTRIBUTE-VALUE-DT(1:4)   TO WS-START-YR-N.          
PRJ172     MOVE YP-ATTRIBUTE-VALUE-DT(6:2)   TO WS-START-MTH-N.         
PRJ172     MOVE ZEROES                       TO WS-NBR-MTHS-DIFF        
PRJ172                                          WS-NBR-TERM             
PRJ172                                          WS-REMAINDER.           
PRJ172     MOVE WS-CURR-REVENUE-DT-H         TO WS-START-DATE.          
PRJ172     MOVE YP-ATTRIBUTE-VALUE-DT        TO WS-END-DATE.            
PRJ172     PERFORM 7050-GET-MTHS-DIFFERENT   THRU 7050-EXIT.            
PRJ172     DIVIDE WS-NBR-MTHS-DIFF BY WS-NBR-MTHS-DREG-REMIND           
PRJ172            GIVING WS-NBR-TERM ROUNDED                            
PRJ172            REMAINDER WS-REMAINDER                                
PRJ172     END-DIVIDE.                                                  
PRJ172     IF WS-NBR-TERM > 0 AND WS-REMAINDER EQUAL ZEROES             
A04527        PERFORM 7500-VAR-FIX-CHECK     THRU 7500-EXIT             
PRJ172        PERFORM 2200-SEND-DREG-LETTER  THRU 2200-EXIT             
A04583        IF FI-OPT-CALC-TYPE-CD = 'FP'                             
A04583           DISPLAY 'Fixed yearly reminder: ' AT-ACCOUNT-NO        
A04583        ELSE                                                      
A04583           DISPLAY 'Variable yearly reminder: ' AT-ACCOUNT-NO     
A04583        END-IF                                                    
PRJ172     END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
PRJ172*                                                                         
PRJ172***************************************************************** 03832700
PRJ172*                                                               *         
PRJ172* 2150-MOVE-ATTRIB-DET.                                         *         
PRJ172***************************************************************** 03833000
PRJ172 2150-MOVE-ATTRIB-DET.                                            
PRJ172                                                                  
PRJ172     IF AT-REV-MTH-LST-NRML GREATER THAN ZEROES                   
PRJ172        MOVE AT-REV-MTH-LST-NRML       TO WS-REV-MTH-LST-NRML     
PRJ172     ELSE                                                         
PRJ172        MOVE WS-CURR-REVENUE-MONTH     TO WS-REV-MTH-LST-NRML     
PRJ172     END-IF.                                                      
PRJ172                                                                  
PRJ172     MOVE WS-REV-MTH-LST-NRML          TO WS-START-REV-MONTH.     
PRJ172     COMPUTE WS-START-MTH-N = WS-START-MTH-N + 1                  
PRJ172     IF WS-START-MTH-N > 12                                       
PRJ172        COMPUTE WS-START-YR-N = WS-START-YR-N + 1                 
PRJ172        MOVE 01                        TO WS-START-MTH-N          
PRJ172     END-IF                                                       
PRJ172     MOVE '-'                       TO YP-ATTRIBUTE-VALUE-DT(5:1) 
PRJ172                                       YP-ATTRIBUTE-VALUE-DT(8:1).
PRJ172     MOVE WS-START-YR-N             TO YP-ATTRIBUTE-VALUE-DT(1:4).
PRJ172     MOVE WS-START-MTH-N            TO YP-ATTRIBUTE-VALUE-DT(6:2).
PRJ172     MOVE '01'                      TO YP-ATTRIBUTE-VALUE-DT(9:2).
PRJ172                                                                  
PRJ172     MOVE WS-SWTCH-LTR-ATTRIB          TO YP-ATTRIBUTE-DESC.      
PRJ172     MOVE SPACES                       TO YP-ATTRIBUTE-VALUE-CD   
PRJ172     MOVE 'A'                          TO YP-STATUS-CD.           
PRJ172                                                                  
PRJ172 2150-EXIT.                                                       
PRJ172     EXIT.                                                        
PRJ172                                                                  
PRJ172***************************************************************** 03832700
PRJ172*                                                               *         
PRJ172* 2200-SEND-DREG-LETTER.                                        *         
PRJ172***************************************************************** 03833000
PRJ172 2200-SEND-DREG-LETTER.                                           
PRJ172                                                                  
PRJ172     PERFORM 2600-FORMAT-NOTICE-INFO      THRU 2600-EXIT.         
P00599     IF WS-CURR-COMM-INSERT-FL= 'Y'                               
PRJ172         PERFORM 2700-WRITE-COMM-INFO     THRU 2700-EXIT          
P00599     END-IF.                                                      
PRJ172                                                                  
PRJ172 2200-EXIT.                                                       
PRJ172     EXIT.                                                        
PRJ172                                                                  
A04527*****************************************************************         
A04527* 7300-CHK-DREG-30DAY-OFFER.                                    *         
A04527* CHECK WHETHER THE PREVIOUS OFFER ISSUED THROUGH 30 DAY LETTER *         
A04527*****************************************************************         
A04527 7300-CHK-DREG-30DAY-OFFER.                                       
A04527                                                                  
A04527     PERFORM 7350-SEL-CURR-ACCT-ATTRIB  THRU 7350-EXIT            
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04527        IF UT-GAS-BASE-LAST-UPDT > YP-ATTRIBUTE-VALUE-DT          
A04527           CONTINUE                                               
A04527        ELSE                                                      
A04527           SET DREG-30DAY-OFFER-ACTIVE TO TRUE                    
A04527        END-IF                                                    
A04527     END-IF.                                                      
A04527                                                                  
A04527 7300-EXIT.                                                       
A04527     EXIT.                                                        
      ***************************************************************** 03832700
      * 2500-CHECK-GOOD-PYMTS                                         * 03832900
      * COUNTS THE NUMBER OF GOOD PAYMENTS                            *         
      ***************************************************************** 03833000
       2500-CHECK-GOOD-PYMTS.                                           
                                                                        
           MOVE  CZ-DISCONNECT-HIST    TO   WS-UTL-CR-HST               
           MOVE  CZ-DISC-EXCEPTN-HIST  TO   WS-UTL-EXP-HST              
           MOVE  CZ-ARREARS-HIST       TO   WS-UTL-ARRS-HST             
           MOVE  CZ-NON-UTL-CR-HST     TO   WS-NON-UTL-CR-HST           
           MOVE  CZ-NON-UTL-CR-HST-EX  TO   WS-NON-UTL-EXP-HST          
           MOVE  CZ-NON-UTL-ARRER-HIST TO   WS-NON-UTL-ARRS-HST         
                                                                        
           IF AT-BILL-CYCLE = WS-CYC1 OR WS-CYC2                        
              MOVE WS-RUN-DATE         TO   WS-REV-YR-MM                
           ELSE                                                         
              MOVE BN-REVENUE-MONTH    TO   WS-REV-YR-MM                
           END-IF                                                       
                                                                        
           MOVE UT-GAS-BASE-LAST-UPDT  TO   WS-GAS-BASE-LAST-UPDT       
                                                                        
           PERFORM 6896-CHECK-PAYMENT-HISTORY  THRU 6896-EXIT           
                                                                        
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 2600-FORMAT-NOTICE-INFO                                       * 03832900
      * ACCUMULATES ALL THE REQUIRED INFORMATION FOR LETTER           *         
      * GENERATION PROCESS                                            *         
      ***************************************************************** 03833000
       2600-FORMAT-NOTICE-INFO.                                         
      *                                                                         
A04583     MOVE FI-OPT-CALC-TYPE-CD          TO WS-OPTION-TYPE          
A04583                                                                  
A04583     EVALUATE TRUE ALSO TRUE                                      
A04583         WHEN DREG-SWITCH-OFFER    ALSO VARIABLE-PRICE            
A04583            MOVE WS-NBR-GOOD-PAYMENT   TO 1K-CORRESP-VAR-NUM      
A04583            MOVE '70747'               TO 1J-CORRESP-MSG-ID       
A04583                                          1L-CORRESP-MSG-ID       
A04583                                          WS-MESSAGE-ID           
A04583         WHEN DREG-SWITCH-REMINDER ALSO VARIABLE-PRICE            
A04583            MOVE ZERO                  TO 1K-CORRESP-VAR-NUM      
A04583            MOVE '70748'               TO 1J-CORRESP-MSG-ID       
A04583                                          1L-CORRESP-MSG-ID       
A04583                                          WS-MESSAGE-ID           
A04583         WHEN DREG-SWITCH-OFFER    ALSO FIXED-PRICE               
A04583            MOVE WS-NBR-GOOD-PAYMENT   TO 1K-CORRESP-VAR-NUM      
A04583            MOVE '70749'               TO 1J-CORRESP-MSG-ID       
A04583                                          1L-CORRESP-MSG-ID       
A04583                                          WS-MESSAGE-ID           
A04583         WHEN DREG-SWITCH-REMINDER ALSO FIXED-PRICE               
A04583            MOVE ZERO                  TO 1K-CORRESP-VAR-NUM      
A04583            MOVE '70749'               TO 1J-CORRESP-MSG-ID       
A04583                                          1L-CORRESP-MSG-ID       
A04583                                          WS-MESSAGE-ID           
A04583     END-EVALUATE                                                 
P00599     IF WS-PREV-ACCOUNT-NO = AT-ACCOUNT-NO                        
P00599        ADD +1                   TO WS-SEQ-NO-COUNT               
P00599     ELSE                                                         
P00599        MOVE ZERO                TO WS-SEQ-NO-COUNT               
P00599     END-IF.                                                      
P00599     MOVE WS-SEQ-NO-COUNT        TO 1J-CORRESP-SEQ-NO.            
P00599     MOVE AT-ACCOUNT-NO          TO 1J-ACCOUNT-NO                 
P00599                                    WS-PREV-ACCOUNT-NO.           
P00599     MOVE AT-COMPANY-NO          TO 1J-CORRESP-COMPANY-NO         
P00599                                    1L-COMPANY-NO.                
P00599     MOVE AT-LOCAL-OFFICE        TO WS-CWS350-LOCAL-OFFICE.       
P00599     MOVE AT-CUSTOMER-NO         TO 1J-CUSTOMER-NO                
P00599     MOVE '200'                  TO 1J-REG-GROUP-CD               
P00599     MOVE 'I'                    TO 1J-CORRESP-STATUS-CD          
P00599     MOVE ZEROES                 TO 1J-GUARNTR-ACCT-NO            
P00599                                    1J-THD-PRTY-ID.               
P00599     MOVE SPACES                 TO 1J-BARCODE-UNIQUE-ID          
P00599     MOVE WS-PGRMNAME            TO 1J-CREATED-BY-PGM-ID          
P00599                                    1J-LAST-UPDATE-PGM-ID         
P00599     MOVE WS-RUN-DATE            TO 1J-CORRESP-STMT-DT            
P00599                                    1L-EFF-TO-DT.                 
P00599     MOVE SPACES                 TO WS-CORRESP-ID-FND             
P00599     PERFORM 5000-CHECK-LOAD-CORRESP-TBL                          
P00599                                           THRU 5000-CPD350-EXIT. 
P00599     MOVE WS-CURR-CORRESP-TYP-CD TO 1J-CORRESP-TYPE-CD            
P00599                                                                  
P00599     PERFORM 5425-GET-CORRESP-ID-VAL       THRU 5425-CPD350-EXIT. 
P00599     PERFORM 5500-LOAD-CORRESP-VAR         THRU 5500-EXIT.        
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03832700
      *                                                               *         
      * 2700-WRITE-COMM-INFO.                                         *         
      ***************************************************************** 03833000
       2700-WRITE-COMM-INFO.                                            
                                                                        
A04527     MOVE AT-ACCOUNT-NO           TO KO-ACCOUNT-NO.               
A04527     MOVE AT-COMPANY-NO           TO KO-COMPANY-NO.               
A04527     MOVE 'N'                     TO KO-RED-FLAG-IND.             
A04527     MOVE SPACES                  TO KO-RED-FLAG-EXPIRE-DT.       
A04527     MOVE -1                      TO WS-RED-FL-NULL-IND.          
A04527     MOVE 'O'                     TO KO-COMM-DIRECTION.           
A04527     MOVE 'L'                     TO KO-COMM-METHOD.              
A04527     MOVE WS-CURR-COMM-TYP-CD     TO KO-COMM-TYPE-CD.             
A04527     MOVE WS-CURR-COMM-SUBTYP-CD  TO KO-COMM-SUBTYPE-CODE.        
A04527     MOVE 'SYSTEM'                TO KO-CONTACT-NAME              
A04527                                     KO-USER-ID-ORIG.             
A04527     MOVE AT-CUSTOMER-NO          TO KO-CUSTOMER-NO.              
A04527     MOVE AT-PREMISE-NO           TO KO-PREMISE-NO.               
A04527     INITIALIZE    WS-INITIAL-COMMENT-TX.                         
A04527     MOVE WS-INITIAL-COMMENT-TX   TO KO-INITIAL-COMMENT-TX.       
A04527     MOVE 0                       TO KO-CALL-ORIGIN-ID            
A04527                                     KO-NUMBER-TRANSFERS          
A04527                                     KO-HOLD-TIME                 
A04527                                     KO-QUEUE-TIME                
A04527                                     KO-TOTAL-CALL-TIME.          
A04527     MOVE 'N'                     TO KO-SCREEN-POP-IND.           
A04527     MOVE SPACES                  TO KO-RESPONSE-REASON-CD        
A04527     MOVE -1                      TO WS-END-NULL-IND.             
A04527     MOVE SPACES                  TO KO-RESPONSE-TYPE-CD.         
A04527     MOVE SPACES                  TO KO-SOLICITATION-CD.          
A04527     MOVE 'C'                     TO KO-COMM-ASSOC-CD.            
A04527     MOVE 'N'                     TO KO-COMPLAINT-FL.             
A04527     MOVE WS-MESSAGE-ID           TO KO-PROMOTION-ID.             
A04527     MOVE 'N'                     TO KO-PSC-COMPLIANCE-IND.       
A04527     MOVE SPACES                  TO KO-DISCOVERY-MTHD-CD.        
A04527     MOVE SPACES                  TO KO-PREV-MARKETER-CD.         
                                                                        
           PERFORM 8300-INSERT-CUST-COMM        THRU 8300-EXIT.         
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599******************************************************************        
P00599* 5000-CHECK-LOAD-CORRESP-TBL.                                   *        
P00599******************************************************************        
P00599      EXEC SQL                                                            
P00599           INCLUDE CPD00350                                               
P00599      END-EXEC.                                                           
P00599                                                                  
P00599*****************************************************************         
P00599*****************************************************************         
P00599******************************************************************        
P00599* 5500-LOAD-CORRESP-VAR.                                         *        
P00599******************************************************************        
P00599  5500-LOAD-CORRESP-VAR.                                          
P00599     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P00599     MOVE 'NUM-VAR-1'              TO 1K-CORRESP-VAR-NM.          
P00599     MOVE 'NBR-GOOD-PAYMENT'       TO 1K-CORRESP-VAR-DATA.        
P00599     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599*                                                                         
P00599     INITIALIZE DCLCSS-CORRESP-VAR.                               
P00599     MOVE WS-CORRESP-ID            TO 1K-CORRESP-ID .             
P00599     MOVE 'NUM-VAR-2'              TO 1K-CORRESP-VAR-NM.          
P00599     MOVE 'GRP2-LOW-CSC-QUALIFY'   TO 1K-CORRESP-VAR-DATA.        
P00599     MOVE WS-GRP2-LOW-CSC-QUALIFY  TO 1K-CORRESP-VAR-NUM.         
P00599     PERFORM 8600-INSERT-CORRESP-VAR       THRU 8600-CPD350-EXIT. 
P00599     INITIALIZE DCLCSS-CORRESP-VAR.                               
P00599                                                                  
P00599  5500-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 6251-GET-FJC01-DATE.                                           *        
      ******************************************************************        
       COPY  CPD00037.                                                          
                                                                        
      *                                                                         
      ******************************************************************        
      * 6896-CHECK-PAYMENT-HISTORY                                     *        
      ******************************************************************        
       COPY CPD00329.                                                           
                                                                        
      ***************************************************************** 03832700
      * 7000-SELECT-DELINQ-VALUE                                      * 03832900
      ***************************************************************** 03833000
       7000-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '7000-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'DELINQ_CD  : ' C8-DELINQ-CD                      
              DISPLAY 'COMPANY_NO : ' C8-COMPANY-NO                     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
      *                                                                         
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *********************************************************                 
      * 7025-SELECT-CURR-REVMTH                                                 
      *********************************************************                 
       7025-SELECT-CURR-REVMTH.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(REVENUE_MONTH)                                 
                INTO :BN-REVENUE-MONTH                                  
                FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
               WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :BN-DATE-EXTRACT                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE BN-REVENUE-MONTH        TO WS-CURR-REVENUE-MONTH     
           ELSE                                                         
              DISPLAY '7025-SELECT RETURN CODE = ' WS-ACTIVE-RETURN-CODE
              DISPLAY 'RUN DATE = ' BN-DATE-EXTRACT                     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
           .                                                            
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7050-GET-MTHS-DIFFERENT                                       * 03832900
      ***************************************************************** 03833000
       7050-GET-MTHS-DIFFERENT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              12 * CIS.DECIMAL2YEAR(                         
PRJ172                                  CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))       
PRJ172                          + CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))
            INTO
              :WS-NBR-MTHS-DIFF       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET:WS-NBR-MTHS-DIFF = 12 * YEAR(                                 
MFA-TR*                                 DATE(:WS-START-DATE)                    
MFA-TR*                                     - DATE(:WS-END-DATE))               
MFA-TR*                         + MONTH(DATE(:WS-START-DATE)                    
MFA-TR*                                     - DATE(:WS-END-DATE))               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*     7050-GET-MTHS-DIFFERENT          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
PRJ172        DISPLAY '* START DATE     : ' WS-START-DATE               
PRJ172        DISPLAY '* END DATE       : ' WS-END-DATE                 
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03832700
      * 7060-GET-CREDIT-INFO                                          * 03832900
      ***************************************************************** 03833000
       7060-GET-CREDIT-INFO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DISCONNECT_HIST                                    
                    ,DISC_EXCEPTN_HIST                                  
                    ,ARREARS_HIST                                       
                    ,NON_UTL_CR_HST                                     
                    ,NON_UTL_CR_HST_EX                                  
                    ,NON_UTL_ARRER_HIST                                 
                INTO :CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                    ,:CZ-ARREARS-HIST                                   
                    ,:CZ-NON-UTL-CR-HST                                 
                    ,:CZ-NON-UTL-CR-HST-EX                              
                    ,:CZ-NON-UTL-ARRER-HIST                             
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISCONNECT_HIST                                            
MFA-TR*             ,DISC_EXCEPTN_HIST                                          
MFA-TR*             ,ARREARS_HIST                                               
MFA-TR*             ,NON_UTL_CR_HST                                             
MFA-TR*             ,NON_UTL_CR_HST_EX                                          
MFA-TR*             ,NON_UTL_ARRER_HIST                                         
MFA-TR*         INTO :CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*             ,:CZ-ARREARS-HIST                                           
MFA-TR*             ,:CZ-NON-UTL-CR-HST                                         
MFA-TR*             ,:CZ-NON-UTL-CR-HST-EX                                      
MFA-TR*             ,:CZ-NON-UTL-ARRER-HIST                                     
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************** PCSCA325 ******************'     
               DISPLAY '** 7060 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '************** PCSCA325 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF                                                       
                                                                        
           .                                                            
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPEN DHR_CUR CURSOR                                          *          
      ******************************************************************        
       7100-OPEN-DHR-VAR-CUR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN DHR_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*     7100-OPEN-DHR-VAR-CUR            *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2        
              DISPLAY '* NEXT 5 BUS CYCLE IN: ' WS-CYC3, WS-CYC4        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7110-FETCH-DHR-VAR-CUR                                        * 03832900
      ***************************************************************** 03833000
       7110-FETCH-DHR-VAR-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
                FETCH DHR_CUR                                           
                 INTO :AT-ACCOUNT-NO                                    
                     ,:UT-GAS-BASE-LAST-UPDT :WS-NULL-IND                
C36000               ,:UT-IC-NO                                         
C36000               ,:RD-MKT-PROGRAM-CD                                
PRJ172               ,:AT-REV-MTH-LST-NRML                              
PRJ172               ,:AT-CUSTOMER-NO                                   
PRJ172               ,:AT-COMPANY-NO                                    
PRJ172               ,:AT-BILL-CYCLE                                    
PRJ172               ,:AT-LOCAL-OFFICE                                  
PRJ172               ,:AT-ADDRESS-ID                                    
PRJ172               ,:AT-ADDRESS-FORMAT                                
A04583               ,:DF-OPTION-CD                                     
A04527               ,:AT-PREMISE-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ172        IF WS-NULL-IND EQUAL -1                                   
PRJ172           MOVE SPACES           TO UT-GAS-BASE-LAST-UPDT         
PRJ172        END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'              TO WS-NO-MORE-ROWS               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*     7110-FETCH-DHR-VAR-CUR           *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* CURR BILL_CYCLE IN : ' WS-CYC1, WS-CYC2        
              DISPLAY '* NEXT 5 BUS CYCLE IN: ' WS-CYC3, WS-CYC4        
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03832700
      * 7120-CLOSE-DHR-VAR-CUR                                        * 03832900
      ***************************************************************** 03833000
       7120-CLOSE-DHR-VAR-CUR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE DHR_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*      7120-CLOSE-DHR-VAR-CUR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * OPEN BILL_CYC_CUR CURSOR                                       *        
      ******************************************************************        
       7200-OPEN-BILL-CYC-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN BILL_CYC_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*    7200-OPEN-BILL-CYC-CUR            *'        
              DISPLAY '* SQLCODE            : ' WS-ACTIVE-RETURN-CODE   
PRJ172        DISPLAY '* WS-OFFER-DATE      : ' WS-OFFER-DATE           
PRJ172        DISPLAY '* WS-REMIND-DATE     : ' WS-REMIND-DATE          
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7210-FETCH-BILL-CYC-CUR                                      *  03832900
      ***************************************************************** 03833000
       7210-FETCH-BILL-CYC-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH BILL_CYC_CUR                                      
                 INTO :BN-BILL-CYCLE :WS-NULL-IND1                       
PRJ172               ,:BN-DATE-EXTRACT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES           TO BN-BILL-CYCLE                 
PRJ172           MOVE 'Y'              TO WS-NO-MORE-ROWS               
              END-IF                                                    
              IF WS-NULL-IND1 EQUAL -1                                  
                 MOVE SPACES           TO BN-BILL-CYCLE                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*     7210-FETCH-BILL-CYC-CUR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* BILL CYCLE     : ' BN-BILL-CYCLE               
PRJ172        DISPLAY '* WS-OFFER-DATE  : ' WS-OFFER-DATE               
PRJ172        DISPLAY '* WS-REMIND-DATE : ' WS-REMIND-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03832700
      * 7220-CLOSE-BILL-CYC-CUR                                       * 03832900
      ***************************************************************** 03833000
       7220-CLOSE-BILL-CYC-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE BILL_CYC_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA325 ABORT **************'        
              DISPLAY '*     7220-CLOSE-BILL-CYC-CUR          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
PRJ172        DISPLAY '* WS-OFFER-DATE  : ' WS-OFFER-DATE               
PRJ172        DISPLAY '* WS-REMIND-DATE : ' WS-REMIND-DATE              
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA325 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
C36000*                                                                         
C36000 7250-SELECT-MIN-GOOD-PAY-QTY.                                    
C36000                                                                  
C36000     EXEC SQL                                                     
C36000         SELECT TOP(1) [1B].MIN_GOOD_PAY_QTY,
              [1B].EVAL_MONTHS_QTY                                
C36000           INTO :1B-MIN-GOOD-PAY-QTY                              
P00172               ,:1B-EVAL-MONTHS-QTY                               
C36000           FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
C36000          WHERE [1B].ADJ_SOURCE_CD      = 'L'                       
C36000            AND [1B].ADJ_TIER_ACCT_TYPE = '2'                       
P00172            AND [1B].APPLICATION_CD NOT IN ('RT','IG')              
P00172            AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
P00172            AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
P00172            AND [1B].MIN_GOOD_PAY_QTY   > 0                         
C36000                                            
C36000                                                           
C36000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.MIN_GOOD_PAY_QTY                                       
MFA-TR*              ,1B.EVAL_MONTHS_QTY                                        
MFA-TR*          INTO :1B-MIN-GOOD-PAY-QTY                                      
MFA-TR*              ,:1B-EVAL-MONTHS-QTY                                       
MFA-TR*          FROM CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE 1B.ADJ_SOURCE_CD      = 'L'                               
MFA-TR*           AND 1B.ADJ_TIER_ACCT_TYPE = '2'                               
MFA-TR*           AND 1B.APPLICATION_CD NOT IN ('RT','IG')                      
MFA-TR*           AND 1B.ADJ_START_DT      <= :WS-RUN-DATE                      
MFA-TR*           AND 1B.ADJ_END_DT        >= :WS-RUN-DATE                      
MFA-TR*           AND 1B.MIN_GOOD_PAY_QTY   > 0                                 
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36000*                                                                         
C36000     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
C36000*                                                                         
C36000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00172        CONTINUE                                                  
C36000     ELSE                                                         
C36000        DISPLAY '********** PCSCA325 ABORT **************'        
C36000        DISPLAY '*   7250-SLECT-MIN-GOOD-PAY-QTY        *'        
C36000        DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
PRJ172        DISPLAY '* RUN DATE          : ' WS-RUN-DATE              
C36000        DISPLAY '* PROGRAM ABORTING...                  *'        
C36000        DISPLAY '********** PCSCA325 ABORT **************'        
C36000        PERFORM 9900-ABEND                     THRU 9900-EXIT     
C36000     END-IF                                                       
C36000     .                                                            
C36000 7250-EXIT.                                                       
C36000     EXIT.                                                        
A04527*****************************************************************         
A04527*                                                               *         
A04527* 7350-SEL-CURR-ACCT-ATTRIB.                                    *         
A04527*****************************************************************         
A04527 7350-SEL-CURR-ACCT-ATTRIB.                                       
A04527                                                                  
A04527     EXEC SQL                                                     
A04527        SELECT TOP(1) YP.ATTRIBUTE_VALUE_DT,
              YP.ATTRIBUTE_DESC                                  
A04527          INTO :YP-ATTRIBUTE-VALUE-DT                             
A04527              ,:YP-ATTRIBUTE-DESC                                 
A04527          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
A04527         WHERE YP.ACCOUNT_NO     = :YP-ACCOUNT-NO                 
A04527           AND YP.ATTRIBUTE_DESC = :WS-SWTCH-LTR-ATTRIB-FIX       
A04527         ORDER BY ATTRIBUTE_VALUE_DT DESC                         
A04527                                            
A04527                                                           
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT YP.ATTRIBUTE_VALUE_DT                                      
MFA-TR*             ,YP.ATTRIBUTE_DESC                                          
MFA-TR*         INTO :YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*             ,:YP-ATTRIBUTE-DESC                                         
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO     = :YP-ACCOUNT-NO                         
MFA-TR*          AND YP.ATTRIBUTE_DESC = :WS-SWTCH-LTR-ATTRIB-FIX               
MFA-TR*        ORDER BY ATTRIBUTE_VALUE_DT DESC                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04527                                                                  
A04527     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04527                                                                  
A04527     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04527        CONTINUE                                                  
A04527     ELSE                                                         
A04527        DISPLAY '********** PCSCA325 ABORT **************'        
A04527        DISPLAY '*      7350-SEL-CURR-ACCT-ATTRIB       *'        
A04527        DISPLAY '* ACCOUNT_NO              : ' YP-ACCOUNT-NO      
A04527        DISPLAY '* WS-SWTCH-LTR-ATTRIB-FIX : '                    
A04527                                         WS-SWTCH-LTR-ATTRIB-FIX  
A04527        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A04527        DISPLAY '*     PROCESSING TERMINATED            *'        
A04527        DISPLAY '********** PCSCA325 ABORT **************'        
A04527        PERFORM 9900-ABEND                     THRU 9900-EXIT     
A04527     END-IF.                                                      
A04527                                                                  
A04527 7350-EXIT.                                                       
A04527     EXIT.                                                        
A04527*                                                                         
PRJ172*                                                                         
PRJ172*****************************************************************         
PRJ172*                                                               *         
PRJ172* 7400-SEL-ACCT-ATTRIB.                                         *         
PRJ172*****************************************************************         
PRJ172 7400-SEL-ACCT-ATTRIB.                                            
PRJ172                                                                  
PRJ172     EXEC SQL                                                     
PRJ172        SELECT TOP(1) YP.ATTRIBUTE_VALUE_DT,
              YP.ATTRIBUTE_DESC                                  
PRJ172          INTO :YP-ATTRIBUTE-VALUE-DT                             
PRJ172              ,:YP-ATTRIBUTE-DESC                                 
PRJ172          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
PRJ172         WHERE YP.ACCOUNT_NO     = :YP-ACCOUNT-NO                 
PRJ172           AND YP.ATTRIBUTE_DESC = :WS-SWTCH-LTR-ATTRIB           
A04527         ORDER BY ATTRIBUTE_VALUE_DT DESC                         
PRJ172                                            
PRJ172                                                           
PRJ172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT YP.ATTRIBUTE_VALUE_DT                                      
MFA-TR*             ,YP.ATTRIBUTE_DESC                                          
MFA-TR*         INTO :YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*             ,:YP-ATTRIBUTE-DESC                                         
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO     = :YP-ACCOUNT-NO                         
MFA-TR*          AND YP.ATTRIBUTE_DESC = :WS-SWTCH-LTR-ATTRIB                   
MFA-TR*        ORDER BY ATTRIBUTE_VALUE_DT DESC                                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ172                                                                  
PRJ172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ172                                                                  
PRJ172     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
PRJ172        CONTINUE                                                  
PRJ172     ELSE                                                         
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        DISPLAY '*      7400-SEL-ACCT-ATTRIB            *'        
PRJ172        DISPLAY '* ACCOUNT_NO              : ' YP-ACCOUNT-NO      
PRJ172        DISPLAY '* WS-SWTCH-LTR-ATTRIB     : ' WS-SWTCH-LTR-ATTRIB
PRJ172        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
PRJ172        DISPLAY '*     PROCESSING TERMINATED            *'        
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        PERFORM 9900-ABEND                     THRU 9900-EXIT     
PRJ172     END-IF.                                                      
PRJ172                                                                  
PRJ172 7400-EXIT.                                                       
PRJ172     EXIT.                                                        
A04583*****************************************************************         
A04583*                                                               *         
A04583* 7500-VAR-FIX-CHECK.                                           *         
A04583*****************************************************************         
A04583 7500-VAR-FIX-CHECK.                                              
A04583                                                                  
A04583     EXEC SQL                                                     
A04583        SELECT TOP(1) OPT_CALC_TYPE_CD                                   
A04583          INTO :FI-OPT-CALC-TYPE-CD                               
A04583          FROM CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)                
A04583         WHERE FI.OPTION_CD           = :DF-OPTION-CD             
A04583           AND FI.COMPANY_NO          = :AT-COMPANY-NO            
A04583           AND FI.OPTION_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
A04583           AND FI.OPTION_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                           :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
A04583           AND CAST(FI.OPT_VSTART_TS AS DATE)<= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
A04583           AND CAST(FI.OPT_VEND_TS AS DATE)  >= 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) )              
A04583           AND FI.PROC_STATUS_CD      = 'AC'                      
A04583         ORDER BY FI.OPT_VRSN_NO   DESC                           
A04583                                            
A04583                                                           
A04583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OPT_CALC_TYPE_CD                                           
MFA-TR*         INTO :FI-OPT-CALC-TYPE-CD                                       
MFA-TR*         FROM CRM_RT_PKG_OPTION  FI                                      
MFA-TR*        WHERE FI.OPTION_CD           = :DF-OPTION-CD                     
MFA-TR*          AND FI.COMPANY_NO          = :AT-COMPANY-NO                    
MFA-TR*          AND FI.OPTION_START_DT    <= :WS-RUN-DATE                      
MFA-TR*          AND FI.OPTION_END_DT      >= :WS-RUN-DATE                      
MFA-TR*          AND DATE(FI.OPT_VSTART_TS)<= :WS-RUN-DATE                      
MFA-TR*          AND DATE(FI.OPT_VEND_TS)  >= :WS-RUN-DATE                      
MFA-TR*          AND FI.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY FI.OPT_VRSN_NO   DESC                                   
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04583                                                                  
A04583     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04583                                                                  
A04583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04583        CONTINUE                                                  
A04583     ELSE                                                         
A04583        DISPLAY '********** PCSCA325 ABORT **************'        
A04583        DISPLAY '*      7500-VAR-FIX-CHECK              *'        
A04583        DISPLAY '* OPTION_CD               : ' DF-OPTION-CD       
A04583        DISPLAY '* COMPANY_NO              : ' AT-COMPANY-NO      
A04583        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
A04583        DISPLAY '*     PROCESSING TERMINATED            *'        
A04583        DISPLAY '********** PCSCA325 ABORT **************'        
A04583        PERFORM 9900-ABEND                     THRU 9900-EXIT     
A04583     END-IF.                                                      
A04583                                                                  
A04583 7500-EXIT.                                                       
A04583     EXIT.                                                        
A04583*                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01.                                            *        
      ******************************************************************        
            EXEC SQL                                                            
                 INCLUDE CPD00038                                               
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *   8300-INSERT-CUST-COMM.                                       *        
      ******************************************************************        
       8300-INSERT-CUST-COMM.                                           
                                                                        
      *                                                                         
A04527     EXEC SQL                                                     
A04527          INSERT INTO CSS_COMM_DATA                               
A04527                  (COMMUNICATION_ID,                              
A04527                   ACCOUNT_NO,                                    
A04527                   CUSTOMER_NO,                                   
A04527                   PREMISE_NO,                                    
A04527                   COMPANY_NO,                                    
A04527                   RED_FLAG_IND,                                  
A04527                   RED_FLAG_EXPIRE_DT,                            
A04527                   COMM_METHOD,                                   
A04527                   COMM_DIRECTION,                                
A04527                   COMM_TYPE_CD,                                  
A04527                   COMM_SUBTYPE_CODE,                             
A04527                   USER_ID_ORIG,                                  
A04527                   CONTACT_NAME,                                  
A04527                   PROMOTION_ID,                                  
A04527                   PSC_COMPLIANCE_IND,                            
A04527                   CALL_ORIGIN_ID,                                
A04527                   CALL_END_TIME,                                 
A04527                   NUMBER_TRANSFERS,                              
A04527                   HOLD_TIME,                                     
A04527                   QUEUE_TIME,                                    
A04527                   SCREEN_POP_IND,                                
A04527                   TOTAL_CALL_TIME,                               
A04527                   INITIAL_COMMENT_TX,                            
A04527                   RESPONSE_REASON_CD,                            
A04527                   RESPONSE_TYPE_CD,                              
A04527                   SOLICITATION_CD,                               
A04527                   COMM_ASSOC_CD,                                 
A04527                   COMPLAINT_FL,                                  
A04527                   DISCOVERY_MTHD_CD,                             
A04527                   PREV_MARKETER_CD)                              
A04527          VALUES   (CIS.CURRENT$TIMESTAMP(),                            
A04527                   :KO-ACCOUNT-NO,                                
A04527                   :KO-CUSTOMER-NO,                               
A04527                   :KO-PREMISE-NO,                                
A04527                   :KO-COMPANY-NO,                                
A04527                   :KO-RED-FLAG-IND,                              
A04527                   CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
A04527                   :KO-COMM-METHOD,                               
A04527                   :KO-COMM-DIRECTION,                            
A04527                   :KO-COMM-TYPE-CD,                              
A04527                   :KO-COMM-SUBTYPE-CODE,                         
A04527                   :KO-USER-ID-ORIG,                              
A04527                   :KO-CONTACT-NAME,                              
A04527                   :KO-PROMOTION-ID,                              
A04527                   :KO-PSC-COMPLIANCE-IND,                        
A04527                   :KO-CALL-ORIGIN-ID,                            
A04527                   CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
A04527                   :KO-NUMBER-TRANSFERS,                          
A04527                   :KO-HOLD-TIME,                                 
A04527                   :KO-QUEUE-TIME,                                
A04527                   :KO-SCREEN-POP-IND,                            
A04527                   :KO-TOTAL-CALL-TIME,                           
A04527                   :KO-INITIAL-COMMENT-TX,                        
A04527                   :KO-RESPONSE-REASON-CD,                        
A04527                   :KO-RESPONSE-TYPE-CD,                          
A04527                   :KO-SOLICITATION-CD,                           
A04527                   :KO-COMM-ASSOC-CD,                             
A04527                   :KO-COMPLAINT-FL,                              
A04527                   :KO-DISCOVERY-MTHD-CD,                         
A04527                   :KO-PREV-MARKETER-CD)                          
A04527     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8300-INSERT-CUST-COMM'                        
A04527         DISPLAY '* CUSTOMER_NO = ' KO-CUSTOMER-NO                
A04527         DISPLAY '* ACCOUNT_NO  = ' KO-ACCOUNT-NO                 
               DISPLAY '* SQL RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ172*****************************************************************         
PRJ172*                                                               *         
PRJ172* 8350-INSERT-ACCT-ATTRIB.                                      *         
PRJ172*****************************************************************         
PRJ172 8350-INSERT-ACCT-ATTRIB.                                         
PRJ172                                                                  
PRJ172     EXEC SQL                                                     
PRJ172         INSERT INTO CSS_ACCT_ATTRIBUTE                           
PRJ172              ( ACCOUNT_NO                                        
PRJ172               ,ATTRIBUTE_DESC                                    
PRJ172               ,ATTRIBUTE_VALUE_CD                                
PRJ172               ,ATTRIBUTE_VALUE_DT                                
PRJ172               ,CREATED_TS                                        
PRJ172               ,STATUS_CD )                                       
PRJ172         VALUES                                                   
PRJ172              (:YP-ACCOUNT-NO                                     
PRJ172              ,:YP-ATTRIBUTE-DESC                                 
PRJ172              ,:YP-ATTRIBUTE-VALUE-CD                             
PRJ172              ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
PRJ172              ,CIS.CURRENT$TIMESTAMP()                                  
PRJ172              ,:YP-STATUS-CD )                                    
PRJ172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,STATUS_CD )                                               
MFA-TR*        VALUES                                                           
MFA-TR*             (:YP-ACCOUNT-NO                                             
MFA-TR*             ,:YP-ATTRIBUTE-DESC                                         
MFA-TR*             ,:YP-ATTRIBUTE-VALUE-CD                                     
MFA-TR*             ,:YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,:YP-STATUS-CD )                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ172                                                                  
PRJ172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ172                                                                  
PRJ172     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ172        NEXT SENTENCE                                             
PRJ172     ELSE                                                         
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        DISPLAY '*       8350-INSERT-ACCT-ATTRIB        *'        
PRJ172        DISPLAY '* ACCOUNT_NO     : ' YP-ACCOUNT-NO               
PRJ172        DISPLAY '* ATTRIB DATE    : ' YP-ATTRIBUTE-VALUE-DT       
PRJ172        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
PRJ172        DISPLAY '*     PROCESSING TERMINATED            *'        
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        PERFORM 9900-ABEND                     THRU 9900-EXIT     
PRJ172     END-IF.                                                      
PRJ172                                                                  
PRJ172 8350-EXIT.                                                       
PRJ172     EXIT.                                                        
PRJ172                                                                  
PRJ172*****************************************************************         
PRJ172*                                                               *         
PRJ172* 8400-UPDATE-ACCT-ATTRIB.                                      *         
PRJ172*****************************************************************         
PRJ172 8400-UPDATE-ACCT-ATTRIB.                                         
PRJ172                                                                  
PRJ172     EXEC SQL                                                     
PRJ172         UPDATE CSS_ACCT_ATTRIBUTE                                
PRJ172            SET ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )       
PRJ172          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
PRJ172            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
PRJ172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT               
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ172                                                                  
PRJ172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
PRJ172                                                                  
PRJ172     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ172        NEXT SENTENCE                                             
PRJ172     ELSE                                                         
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        DISPLAY '*       8400-UPDATE-ACCT-ATTRIB        *'        
PRJ172        DISPLAY '* ACCOUNT_NO     : ' YP-ACCOUNT-NO               
PRJ172        DISPLAY '* ATTRIB DATE    : ' YP-ATTRIBUTE-VALUE-DT       
PRJ172        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
PRJ172        DISPLAY '*     PROCESSING TERMINATED            *'        
PRJ172        DISPLAY '********** PCSCA325 ABORT **************'        
PRJ172        PERFORM 9900-ABEND                     THRU 9900-EXIT     
PRJ172     END-IF.                                                      
PRJ172                                                                  
PRJ172 8400-EXIT.                                                       
PRJ172     EXIT.                                                        
                                                                        
      ***************************************************************** 03832700
      * 9000-TERMINATE                                                * 03832900
      ***************************************************************** 03833000
       9000-TERMINATE.                                                  
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ172****************************************************************          
PRJ172*  6500-GET-NEXT-BUSINESS-DAY.                                 *          
PRJ172****************************************************************          
PRJ172     EXEC SQL                                                             
PRJ172          INCLUDE CPD00315                                                
PRJ172     END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *  9700-PROCESS-ABEND.                                         *          
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      **************************************************************            
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *            
      * 9900-ABEND                                                 *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
