       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA323.                                            
       AUTHOR. JAYANTHI SANTHAPPAN.                                     
       DATE-WRITTEN. OCT-2002.                                          
      *****************************************************************         
      **                                                             **         
      **            SOUTH CAROLINA ELECTRICITY AND GAS               **         
      **          TRANSPORTATION NOMINATION LOAD PROGRAM             **         
      **                                                             **         
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      CIG                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **    ----    --------     ------                              **         
      **  10/16/02   JS83520     ORIGINAL VERSION                    **         
      **  01/23/03   SV85244     MODIFIED TO INCLUDE STD COPYBOOKS   **         
T30138**  01/23/04   VV90387     GENERATE WQ WHEN THERE ARE DUPLICATE**         
T30138**                         TRANSPORTATION CONTRACTS WITH THE   **         
T30138**                         SAME TRANSPORTATION CUSTOMER NUMBER **         
T30138**                         ALSO ADDED ROW IN JOB_PARM FOR      **         
T30138**                         IMPLEMENTING RESTART LOGIC          **         
T30572**  01/23/04   GANESH      WHEN CREATING A TRANSPORTATION BG,  **         
T30572**                         DO NOT PICK UP THE NON-CALC AS THE  **         
T30572**                         BASE RATE BILLING DETAIL ROW.       **         
C34044**  10/10/06   ANAND     1.CHANGED ALL SCPC CUSTOMER NUMBER    **         
C34044**                         REFERENCES TO SCEG ACCOUNT NUMBER.  **         
C34044**                         INCLUDED 'WITH UR' TO ALL THE       **         
C34044**                         SQL STATEMENTS AND REPLACED THE     **         
C34044**                         CSS_MODEL_SQL WITH 'SET' FUNCTION.  **         
C34044**             COVANSYS  2.CHANGED WS-IN-ACCOUNT-NO IN         **         
C34044**                         7100-SELECT-SCEG-ACCT TO THE        **         
C34044**                         CORRESPONDING HOST VARIABLE         **         
C34044**             COVANSYS  3.REMOVED THE REV_RPT_CD = 'T' FROM   **         
C34044**                         THE WHERE CLAUSE IN PARA 7420       **         
C34044**             COVANSYS  4.IN THE ERROR HANDING OF EACH PARA   **         
C34044**                         CHANGED THE PARA NAME TO THE        **         
C34044**                         CORRESPONDING ONE                   **         
C34044**             COVANSYS  5.INCLUDED THE WHERE CLAUSE VARIABLES **         
C34044**                         TO BE DISPLAYED ON THE ERROR        **         
C34044**                         HANDLING PARA                       **         
T36599**  12/06/2007 PG36856     IDENTIFY CUSTOMERS THAT DID NOT HAVE**         
T36599**                         NOMINATIONS POSTED TO CIS AND LIST  **         
T36599**                         ACCOUNT WITH ERRORS ON NEW REPORT.  **         
T36599**                         CLEANED UP THE PROGRAM AND ADDED    **         
T36599**                         PERIODS WHERE NEEDED.               **         
A04860**   03/18/2014   AS7C117  REPLACE CSS_WQ_ITEMS_MF WITH        **         
A04860**                         CSS_WQ_ITEMS.                       **         
PRJ853**   08/15/2016   SS95855  SCPC FILE WILL PROVIDE DELIVERED NOM**         
      *****************************************************************         
       REMARKS.                                                         
      *****************************************************************         
      *   THIS PROGRAM COMPUTES DAILY TRANSPORTATION DELIVERED TO THE *         
      *   CUSTOMER AFTER APPLYING SCEG SHRINKAGE TO THE NOMINATION    *         
      *   PROVIDED BY SCPC. THE DAILY TRANSPORTATION IS LOADED INTO   *         
      *   CSS_VOL_DAILY. THE INPUT NOMINATION FILE IS PROVIDED BY     *         
      *   SCPC BY TRANSFERRING IT FROM THEIR AS400 SYSTEM TO THE CIS  *         
      *   SYSTEM ON A MONTHLY BASIS.                                  *         
      *****************************************************************         
                ------------------------------------------------------- 
                     ---- BASIC BATCH SEQUENCE STRUCTURE -------------  
                    0000 - 0000     MAIN CONTROL PATH                   
                    --------------------------------------------------- 
                    0100 - 0100     INITIALIZE SWITCHES AND COUNTERS    
                                    OPEN FILES                          
HPCCDM*                 0120 - 0120   OVERRIDE REPORT TITLE                     
HPCCDM*                 0140 - 0140   OVERRIDE REPORT HEAD                      
                        0160 - 0160   GET CHECK NUMBER & DATE           
                        0180 - 0180   VALIDATE CHECK NUMBER & DATE      
                    --------------------------------------------------- 
                    1000 - 1000     MAIN PROCESSING LOOP                
                        1100 - 1100                                     
                    --------------------------------------------------- 
                    1400 - 1420     PRINT CONTROL REPORT                
                    --------------------------------------------------- 
                    4000 - 4090     ACCESS CUSTOMER NAME                
                    --------------------------------------------------- 
                    7000 - 7500     INQUIRY CALLS TO DATABASES          
                    --------------------------------------------------- 
                    8000 - 8000     CREATE EXTRACT                      
                    --------------------------------------------------- 
                    9000 - 9000     TERMINATE                           
                    --------------------------------------------------- 
                    9900 - 9900     ABEND                               
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      ******************************************************************        
      *  THE FOLLOWING INPUT FILE IS READ TO LOAD DAILY VOLUMES INTO   *        
      *  CSS_VOL_DAILY TABLE. THE OUTPUT FILE IS TO CREATE A CONTROL   *        
      *  REPORT FOR THE ENTIRE PROCESSING THAT WAS DONE.               *        
      ******************************************************************        
      *                                                                         
           COPY CSSCA323.                                                       
      *                                                                         
           COPY CSSPT33.                                                        
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA323.                                                           
       COPY FIOCA323.                                                           
      *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA323'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE           PIC S9(09) COMP.                
           05  RS-RETURN-CODE-DISP      PIC +Z(04).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26)  VALUE SPACES.        
           05  WS-CURRENT-TIME          PIC 9(08).                      
           05  WS-CURRENT-DT.                                           
               10  WS-CURRENT-YY        PIC 9(02).                      
               10  WS-CURRENT-MM        PIC 9(02).                      
               10  WS-CURRENT-DD        PIC 9(02).                      
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE ZERO.  
C34044     05  WS-IN-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE ZERO.  
           05  WS-CURRENT-TS            PIC X(26).                      
           05  WS-PARM-REVENUE-MONTH.                                   
               10 WS-PARM-REV-YEAR      PIC 9(04).                      
               10 WS-PARM-REV-MONTH     PIC 9(02).                      
           05  WS-PARM-REV-MONTH-N      REDEFINES                       
                 WS-PARM-REVENUE-MONTH  PIC 9(06).                      
T36599     05  WS-PARM-REV-MTH             PIC S9(06)V COMP-3 VALUE +0. 
T36599     05  WS-PARM-REVENUE-MNTH.                                    
T36599         10 WS-PARM-REV-YR        PIC 9(04).                      
T36599         10 WS-PARM-REV-MNTH      PIC 9(02).                      
T36599     05  WS-PARM-REV-MNTH-N      REDEFINES                        
T36599                          WS-PARM-REVENUE-MNTH     PIC 9(06).     
           05  WS-DB2-DATE              PIC X(10).                      
           05  WS-DELINQ-VALUE          PIC ZZZ9.99999.                 
           05  WS-TOT-VOL-DKTHMS        PIC ZZZZZZZZ9.9.                
COB305     05 WS-SHRINKAGE-UNITS        PIC S9(9)V9 COMP-3 VALUE 0.             
COB305     05 WS-NOMINATED-UNITS        PIC S9(9)V9 COMP-3 VALUE 0.             
           05  WS-GAS-TOT-VOL-DKTHMS    PIC 9(10) VALUE ZERO.           
           05  WS-GAS-TOT-VOL-DKTHM-RR  REDEFINES WS-GAS-TOT-VOL-DKTHMS.
               10  WS-GAS-TOT-VOL-DKTHMS-R  PIC 9(9)V9.                 
PRJ853     05  WS-TOT-SCPC-DELV-VOL     PIC S9(9)V9 COMP-3 VALUE ZERO.  
           05  WS-TOT-NOMINATED-VOL     PIC S9(9)V9 COMP-3 VALUE ZERO.  
           05  WS-TOT-NOM-ERROR-VOL     PIC S9(9)V9 COMP-3 VALUE ZERO.  
           05  WS-TOT-DELIVERED-VOL     PIC S9(9)V9 COMP-3 VALUE ZERO.  
PRJ853     05  WS-DEL-VOL-CUSTOMER      PIC S9(9)V9 COMP-3 VALUE ZERO.  
           05  WS-NOM-VOL-CUST-DIS      PIC ZZZZZZZZ9.9.                
           05  WS-SUB                   PIC S9(04) COMP.                
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
T36599     05  WS-PAGE-COUNT            PIC 9(02) VALUE  0.             
T36599     05  WS-RPT-LINE-NO           PIC 9(02) VALUE 50   COMP-3.    
T36599     05  WS-50                    PIC 9(02) VALUE 50   COMP-3.    
T36599     05  WS-RPT-TITLE             PIC X(33) VALUE                 
T36599         'TRNSP NOMINATION LOAD PROGRAM  '.                       
T36599     05  WS-SCEG-COMP-NAME        PIC X(26)  VALUE SPACES.        
           05  WS-ONE                   PIC S9(04)  COMP-3 VALUE +1.    
           05  WS-MULTIPLE-ROWS-FOUND   PIC S9(4)   COMP   VALUE -811.  
           05  WS-MONTHLY-VOLUME-CH.                                    
               10 WS-DAILY-VOLUME-CH    PIC X(10)   OCCURS 31 TIMES.    
           05  WS-MONTHLY-VOLUME.                                       
               10 WS-DAILY-VOLUME       PIC 9(09)V9 OCCURS 31 TIMES.    
           05  WS-DAILY-VOLUME-NUM      PIC 9(10).                      
           05  WS-DAILY-VOL-D     REDEFINES WS-DAILY-VOLUME-NUM.        
               10 WS-DAILY-VOL-DEC      PIC 9(09)V9.                    
           05  WS-TRNSP-OVER-MDQ        PIC 9(07)V9.                    
           05  WS-VOLUME-DATE           PIC X(10)   OCCURS 31 TIMES.    
           05  WS-VOL-FOR-DAY           PIC X(10).                      
           05  WS-MAX-READ-DT           PIC X(10).                      
           05  WS-MIN-READ-DT           PIC X(10).                      
           05  WS-VALID-DATES           PIC X(01).                      
           05  WS-READ-DATE             PIC X(10).                      
           05  WS-DATE-READ             PIC X(10).                      
           05  WS-TRNSP-HOOK-EXISTS     PIC X(01)   VALUE 'N'.          
           05  WS-ACTIVE                PIC X(01)   VALUE 'A'.          
           05  WS-CURRENT               PIC X(01)   VALUE 'C'.          
           05  WS-DEBIT                 PIC X(01)   VALUE 'D'.          
           05  WS-NEG-ONE               PIC S9(04) COMP-3 VALUE -1.     
           05  WS-FCSCA323-STATUS       PIC X(02).                      
               88  E-FCSCA323-SUCCESSFUL                  VALUE '00'.   
               88  E-FCSCA323-EOF                         VALUE '23'.   
           05  WS-RESTART-DATA-LENGTH   PIC S9(04) COMP   VALUE +90.    
           05  WS-CHKP-LUW-LIMIT        PIC 9(04).                      
           05  WS-FLAG-TO-TURN-OFF-COMMITS                              
                                        PIC 9(04)         VALUE 9999.   
           05  WS-CHKP-UPD-LIMIT        PIC 9(04).                      
           05  WS-CHKP-SEQ-NO           PIC 9(05)         VALUE ZERO.   
           05  WS-DEFAULT-RESTART-REQ   PIC X(01)         VALUE 'N'.    
           05  WS-DEFAULT-CHKP-LUW-LIMIT                                
                                        PIC 9(04)         VALUE 5.      
           05  WS-DEFAULT-CHKP-UPD-LIMIT                                
                                        PIC 9(04)         VALUE 20.     
           05  WS-COUNT-UNSUCCESSFUL-ROWS                               
                                        PIC S9(04) COMP-3 VALUE ZERO.   
           05  WS-CHKP-LUW-COUNTER      PIC 9(04)  COMP-3 VALUE ZERO.   
           05  WS-CHKP-UPD-COUNTER      PIC S9(04) COMP-3 VALUE ZERO.   
           05  WS-ERROR-DESCRIPTION     PIC X(40).                      
           05  WS-NO-OF-RECS-INSRTD     PIC S9(04) COMP   VALUE ZERO.   
           05  WS-NO-OF-RECS-INSRTD-DIS PIC ZZZ9.                       
           05  WS-NO-OF-ERR-RECS        PIC S9(04) COMP   VALUE ZERO.   
           05  WS-NO-OF-ERR-RECS-DIS    PIC ZZZ9.                       
           05  WS-INPUT-RECS-READ       PIC 9(04)  COMP   VALUE ZERO.   
           05  WS-INPUT-RECS-READ-DIS   PIC ZZZ9.                       
           05  WS-WORK-QUEUE-COUNT      PIC S9(04) COMP   VALUE ZERO.   
      *                                                                         
T36599 01  WS-MESSAGE-AREA.                                             
T36599     05 WS-MSG-1           PIC X(26)                              
T36599        VALUE 'NOT A VALID ACCOUNT NUMBER'.                       
T36599     05 WS-MSG-2           PIC X(38)                              
T36599        VALUE 'VOLUME DATE MIN OUT OF CONTRACT PERIOD'.           
T36599     05 WS-MSG-3           PIC X(36)                              
T36599        VALUE 'DOES NOT HAVE A VALID TRNSP CONTRACT'.             
T36599     05 WS-MSG-4           PIC X(35)                              
T36599        VALUE 'DOES NOT HAVE VALID NUMERIC VOLUMES'.              
T36599     05 WS-MSG-5           PIC X(29)                              
T36599        VALUE 'DAILY VOLUME GREATER THAN MDQ'.                    
T36599     05 WS-MSG-6           PIC X(55) VALUE                        
T36599       'WARNING - TOTAL DKTHMS NOT EQUAL TO SUM OF DAILY DKTHMS'. 
T36599     05 WS-MSG-7           PIC X(34)                              
T36599        VALUE 'HAS INVALID TOTAL NOMTN DEKATHERMS'.               
T36599     05 WS-MSG-8           PIC X(33)                              
T36599        VALUE 'TRANSPORTATION CONTRACT NOT FOUND'.                
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  BI-DATE-BILLED-NI        PIC S9(4) COMP.                 
           05  BG-DATE-ORIG-BILL-NULL   PIC S9(4) COMP.                 
           05  BG-DATE-LFTM-HI-DMD-NULL PIC S9(4) COMP.                 
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-INPUT-FILE-STATUS     PIC X(02).                      
               88  INPUT-FILE-SUCCESS                     VALUE '00'.   
           05  WS-PRINT-FILE-STATUS     PIC X(02).                      
               88  PRINT-FILE-SUCCESS                     VALUE '00'.   
           05  WS-FCSCA323-EOF-SW       PIC X(01)         VALUE 'N'.    
               88 END-OF-INPUT                            VALUE 'Y'.    
           05  WS-IS-THIS-A-RESTART     PIC X(01)         VALUE 'N'.    
               88 WS-THIS-IS-A-RESTART                    VALUE 'Y'.    
           05  WS-FIRST-RESTART-READ    PIC X(01)         VALUE 'N'.    
               88 FIRST-RESTART-READ                      VALUE 'Y'.    
           05  WS-ACCOUNT-EXISTS-FLAG   PIC X(01)         VALUE 'N'.    
               88 WS-ACCOUNT-NOT-FOUND                    VALUE 'Y'.    
           05  WS-BILL-HOOK-NOT-FOUND   PIC X(01)         VALUE 'N'.    
               88 BILL-HOOK-FOUND                         VALUE 'Y'.    
               88 BILL-HOOK-NOT-FOUND                     VALUE 'N'.    
           05  WS-VALID-CUSTOMER        PIC X(01)         VALUE 'Y'.    
               88 VALID-CUSTOMER                          VALUE 'Y'.    
               88 NOT-VALID-CUSTOMER                      VALUE 'N'.    
           05  WS-OVER-MDQ-FLAG         PIC X(01)         VALUE 'N'.    
               88 OVER-MDQ-CREATED                        VALUE 'Y'.    
               88 OVER-MDQ-NOT-CREATED                    VALUE 'N'.    
           05  WS-RESTART-REQ             PIC X(01).                    
           05  WS-BI-CRSR-FL              PIC X(01) VALUE 'N'.          
               88 END-OF-BI-CRSR                    VALUE 'Y'.          
           05  WS-BIBG-CRSR-FL            PIC X(01) VALUE 'N'.          
               88 END-OF-BIBG-CRSR                  VALUE 'Y'.          
           05  WS-BILLING-DETAILS         PIC X(01) VALUE 'N'.          
               88 BILLING-DTLS-FOUND                VALUE 'Y'.          
               88 BILLING-DTLS-NOT-FOUND            VALUE 'N'.          
T30138     05  WS-WQ-COND                 PIC X(01) VALUE 'N'.          
T30138         88 WS-DUP-WQ                         VALUE 'Y'.          
T30138         88 WS-NO-DUP-WQ                      VALUE 'N'.          
                                                                        
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE      PIC 9(01).                  
           05  WS-RESTART-JOB-COMPLETE      REDEFINES                   
               WS-RESTART-PROCESS-TYPE      PIC X(01).                  
           05  WS-RESTART-JOB-STATUS        PIC X(01).                  
               88  WS-RUN-COMPLETED-NO-PROBLEMS        VALUE 'A'.       
               88  WS-RERUN-COMPLETED                  VALUE 'B'.       
               88  WS-RERUN-PENDING                    VALUE 'C'.       
           05  WS-RESTART-INPUT-DATE        PIC X(10).                  
           05  WS-RESTART-CHKP-SEQ-NO       PIC 9(05)  VALUE ZERO.      
           05  WS-RESTART-RECS-READ         PIC 9(04)  VALUE ZERO.      
           05  WS-RESTART-NO-OF-RECS-INSRTD PIC S9(09) VALUE ZERO.      
           05  WS-RESTART-NO-OF-ERR-RECS    PIC S9(09) VALUE ZERO.      
           05  WS-RESTART-CUSTOMER-NO       PIC S9(13) VALUE ZERO.      
PRJ853     05  WS-RESTART-TOT-SCPC-DELV-VOL PIC 9(09)V9.                
           05  WS-RESTART-TOT-NOMINATED-VOL PIC 9(09)V9.                
           05  WS-RESTART-TOT-NOM-ERROR-VOL PIC 9(09)V9.                
           05  WS-RESTART-TOT-DELIVERED-VOL PIC 9(09)V9.                
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA323'.      
           05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA323'.      
A04860     05  SCSCB077                PIC X(8)  VALUE 'SCSCB077'.      
                                                                        
       01  WS-HEADING-LINES.                                            
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-1        **           
      ***************************************************************           
           05 WS-RPT-TITLE-1.                                           
              10  FILLER                 PIC X(02) VALUE SPACES.        
              10  P-RPT-TITLE-PGNM       PIC X(08).                     
              10  FILLER                 PIC X(43) VALUE SPACES.        
              10  P-RPT-DUMMY            PIC X(31).                     
              10  FILLER                 PIC X(29) VALUE SPACES.        
              10  FILLER                 PIC X(09) VALUE 'RUN-DATE:'.   
              10  P-RPT-RUN-DT           PIC X(10) VALUE SPACES.        
              10  FILLER                 PIC X(03) VALUE SPACES.        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-2        **           
      ***************************************************************           
           05 WS-RPT-TITLE-2.                                           
T36599        10 FILLER                  PIC X(66)  VALUE SPACES.       
T36599        10 P-RPT-PROJ-NAME         PIC X(03)  VALUE 'CIG'.        
              10 FILLER                  PIC X(44)  VALUE SPACES.       
              10 FILLER                  PIC X(09)  VALUE 'RUN TIME:'.  
              10 WS-REP-HH               PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-MIN              PIC X(02).                     
              10 FILLER                  PIC X(01)  VALUE ':'.          
              10 WS-REP-SS               PIC X(02).                     
              10 FILLER                  PIC X(03)  VALUE SPACES.       
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-3        **           
      ***************************************************************           
           05 WS-RPT-TITLE-3.                                           
              10 FILLER                  PIC X(52) VALUE SPACES.        
              10 P-RPT-REP-NAME          PIC X(33).                     
              10 FILLER                  PIC X(28) VALUE SPACES.        
              10 FILLER                  PIC X(10) VALUE 'PAGE    : '.  
              10 P-RPT-PAGE-NO           PIC ZZ,ZZ9.                    
              10 FILLER                  PIC X(05) VALUE SPACES.        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-4        **           
      ***************************************************************           
           05 WS-RPT-TITLE-4.                                           
              10 FILLER                  PIC X(20) VALUE SPACES.        
              10 FILLER                  PIC X(07) VALUE 'ACCOUNT'.     
              10 FILLER                  PIC X(09) VALUE SPACES.        
              10 FILLER                  PIC X(16)                      
                                         VALUE 'TOTAL NOMINATION'.      
              10 FILLER                  PIC X(09) VALUE SPACES.        
              10 FILLER                  PIC X(09) VALUE 'EXCEPTION'.   
              10 FILLER                  PIC X(70) VALUE SPACES.        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR REPORT TITLE-5        **           
      ***************************************************************           
           05 WS-RPT-TITLE-5.                                           
              10 FILLER                  PIC X(21) VALUE SPACES.        
              10 FILLER                  PIC X(07) VALUE 'NUMBER '.     
              10 FILLER                  PIC X(14) VALUE SPACES.        
              10 FILLER                  PIC X(05) VALUE 'UNITS'.       
              10 FILLER                  PIC X(13) VALUE SPACES.        
              10 FILLER                  PIC X(11) VALUE 'DESCRIPTION'. 
              10 FILLER                  PIC X(63) VALUE SPACES.        
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR BLANK LINE            **           
      ***************************************************************           
           05  WS-BLANK-LINE.                                           
               10 FILLER                 PIC X(133) VALUE SPACES.       
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR TOTAL CUSTOMER COUNT  **           
      ***************************************************************           
           05  WS-DETAIL-LINE.                                          
               10 FILLER                  PIC X(20) VALUE SPACES.       
               10 P-TEXT                  PIC X(25).                    
               10 FILLER                  PIC X.                        
               10 P-COLON                 PIC X     VALUE ':'.          
               10 FILLER                  PIC X.                        
               10 P-VALUE                 PIC X(10).                    
      ***************************************************************           
      *           COMMON WORKING STORAGE FOR TOTAL VOLUMES         **           
      ***************************************************************           
           05  WS-VOLUME-LINE.                                          
               10 FILLER                  PIC X(20) VALUE SPACES.       
               10 P-DESC                  PIC X(25).                    
               10 FILLER                  PIC X.                        
               10 P-COL                   PIC X     VALUE ':'.          
               10 FILLER                  PIC X.                        
               10 P-VOLUME                PIC ZZZZZZZZ9.9.              
                                                                        
T36599***************************************************************           
T36599*           COMMON WORKING STORAGE FOR NOMINATION REPORT     **           
T36599***************************************************************           
T36599     05  WS-NOM-LINE.                                             
T36599         10 FILLER                  PIC X(20) VALUE SPACES.       
T36599         10 P-NOM-ACCT              PIC X(13).                    
T36599         10 FILLER                  PIC X(02).                    
T36599         10 P-NOM-UNITS             PIC ZZZZZZZZ9.9.              
T36599         10 FILLER                  PIC X(15).                    
T36599         10 P-NOM-TEXT              PIC X(55).                    
T36599         10 FILLER                  PIC X(15).                    
T36599***************************************************************           
T36599*           COMMON WORKING STORAGE FOR END OF REPORT         **           
T36599***************************************************************           
T36599     05  WS-END-LINE.                                             
T36599         10 FILLER                  PIC X(56) VALUE SPACES.       
T36599         10 FILLER                  PIC X(21)                     
T36599                        VALUE '*** END OF REPORT ***'.            
T36599         10 FILLER                  PIC X(54).                    
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
           COPY CWS00038.                                                       
      *                                                                         
T36599     COPY CWS00114.                                                       
      *                                                                         
           COPY CWS00039.                                                       
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
           COPY FIOCA00.                                                        
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_JOB_PARM  - G6                                                   
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_RESTART - RF                                                     
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_ACCOUNT - AT                                                     
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
T36599*****************************************************************         
T36599* CSS_COMPANY                                                   *         
T36599*****************************************************************         
T36599     EXEC SQL                                                             
T36599          INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_PREMISE - PR                                                     
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_BILLING_HDR - BI                                                 
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_BILLING_DET - BG                                                 
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_VOL_DAILY - ND                                                   
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBVOLDLY                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_UTIL_ENVRNMT - UT                                                
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_BILL_CONTRACT - BK                                               
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBBLCNTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_TRNSP_CONTRACT - TW                                              
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBTRNCNT                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_TRNSP_VOL_BLK - TZ                                               
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBTRNBLK                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_READ_WINDOW - RW                                                 
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
C34044*    CSS_DELINQUENCY - C8                                                 
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE             PIC X(02) VALUE SPACE.        
           05  FILLER REDEFINES           WS-ABEND-SPACE.               
               10  WS-ABEND-NUMERIC       PIC 99.                       
      *                                                                         
      ****************************************                                  
      **  CURSOR DECLARATION -- BIBG_CRSR   **                                  
      ****************************************                                  
      *                                                                         
           EXEC SQL                                                     
             DECLARE BIBG_CRSR CURSOR FOR                               
              SELECT BI.BILL_NO,                                        
                     BG.PREMISE_NO,                                     
                     BG.BILL_NO,                                        
                     BG.CODE_UTIL_TYPE,                                 
                     BG.IC_NO,                                          
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                             
                     BG.DATE_ORIG_BILL,                                 
                     BG.AMT_BILL_ITEM,                                  
                     BG.CODE_BILL_CALC,                                 
                     BG.CODE_BILL_ITM_TYPE,                             
                     BG.CODE_BILL_ITM_IND,                              
                     BG.CODE_DR_CR_CNSMPTN,                             
                     BG.AMT_STATE_TAX,                                  
                     BG.AMT_CITY_TAX,                                   
                     BG.AMT_OTHER_TAX,                                  
                     BG.CODE_REVENUE_CLASS,                             
                     BG.CODE_SIC_NO,                                    
                     BG.RATE_PLAN_NO,                                   
                     BG.CODE_CURTAIL_PRTY,                              
                     BG.CODE_STAT_TAX_XMT,                              
                     BG.CODE_CITY_TAX_XMT,                              
                     BG.CODE_OTHR_TAX_XMT,                              
                     BG.REV_RPT_CD,                                     
                     BG.STANDBY_COMPLIED,                               
                     BG.PRORATE_CD,                                     
                     BG.NEW_RATE_PCT,                                   
                     BG.CODE_SUB_TOTAL,                                 
                     BG.TAX_REFUND_CD,                                  
                     BG.ACCOUNT_NO,                                     
                     BG.COMPANY_NO,                                     
                     BG.DATE_LFTM_HI_DMD,                               
                     BG.LFTM_HI_PEAK_DMD,                               
                     BG.REBILL_IND,                                     
                     BG.ADJ_REASON_CD,                                  
                     BG.REVENUE_MONTH,                                  
                     BG.GAS_BASE_USE,                                   
                     BG.WNA_FACTOR,                                     
                     BG.BTU_FACTOR,                                     
                     BG.NO_OF_CONS_DAYS,                                
                     BG.REV_MTH_ORIG_BILL,                              
                     BG.REV_DISTRICT_CD,                                
                     BG.FUEL_SHIPPER_CD,                                
                     BG.ALTERNATE_FUEL_CD,                              
                     BG.TRNSP_OVER_MDQ_FL                               
                FROM CSS_BILLING_HDR BI
                           WITH(READUNCOMMITTED), CSS_BILLING_DET BG
                           WITH(READUNCOMMITTED)             
               WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                     
                 AND BI.ACCOUNT_NO = BG.ACCOUNT_NO                      
                 AND BI.BILL_NO    = BG.BILL_NO                         
                 AND BG.IC_NO      = :BG-IC-NO                          
                 AND BI.DATE_BILLED IS NULL                             
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'A'                        
C30572           AND BG.CODE_BILL_CALC    <> 'S'                        
                 AND BG.REVENUE_MONTH      = 0                          
                 AND BG.REV_MTH_ORIG_BILL  = 0                          
                 AND BG.CODE_REVENUE_CLASS <> :TZ-CODE-REVENUE-CLASS    
            ORDER BY BILL_ITEM_TIMESTMP DESC                         
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BIBG_CRSR CURSOR FOR                                       
MFA-TR*       SELECT BI.BILL_NO,                                                
MFA-TR*              BG.PREMISE_NO,                                             
MFA-TR*              BG.BILL_NO,                                                
MFA-TR*              BG.CODE_UTIL_TYPE,                                         
MFA-TR*              BG.IC_NO,                                                  
MFA-TR*              BG.BILL_ITEM_TIMESTMP,                                     
MFA-TR*              BG.DATE_ORIG_BILL,                                         
MFA-TR*              BG.AMT_BILL_ITEM,                                          
MFA-TR*              BG.CODE_BILL_CALC,                                         
MFA-TR*              BG.CODE_BILL_ITM_TYPE,                                     
MFA-TR*              BG.CODE_BILL_ITM_IND,                                      
MFA-TR*              BG.CODE_DR_CR_CNSMPTN,                                     
MFA-TR*              BG.AMT_STATE_TAX,                                          
MFA-TR*              BG.AMT_CITY_TAX,                                           
MFA-TR*              BG.AMT_OTHER_TAX,                                          
MFA-TR*              BG.CODE_REVENUE_CLASS,                                     
MFA-TR*              BG.CODE_SIC_NO,                                            
MFA-TR*              BG.RATE_PLAN_NO,                                           
MFA-TR*              BG.CODE_CURTAIL_PRTY,                                      
MFA-TR*              BG.CODE_STAT_TAX_XMT,                                      
MFA-TR*              BG.CODE_CITY_TAX_XMT,                                      
MFA-TR*              BG.CODE_OTHR_TAX_XMT,                                      
MFA-TR*              BG.REV_RPT_CD,                                             
MFA-TR*              BG.STANDBY_COMPLIED,                                       
MFA-TR*              BG.PRORATE_CD,                                             
MFA-TR*              BG.NEW_RATE_PCT,                                           
MFA-TR*              BG.CODE_SUB_TOTAL,                                         
MFA-TR*              BG.TAX_REFUND_CD,                                          
MFA-TR*              BG.ACCOUNT_NO,                                             
MFA-TR*              BG.COMPANY_NO,                                             
MFA-TR*              BG.DATE_LFTM_HI_DMD,                                       
MFA-TR*              BG.LFTM_HI_PEAK_DMD,                                       
MFA-TR*              BG.REBILL_IND,                                             
MFA-TR*              BG.ADJ_REASON_CD,                                          
MFA-TR*              BG.REVENUE_MONTH,                                          
MFA-TR*              BG.GAS_BASE_USE,                                           
MFA-TR*              BG.WNA_FACTOR,                                             
MFA-TR*              BG.BTU_FACTOR,                                             
MFA-TR*              BG.NO_OF_CONS_DAYS,                                        
MFA-TR*              BG.REV_MTH_ORIG_BILL,                                      
MFA-TR*              BG.REV_DISTRICT_CD,                                        
MFA-TR*              BG.FUEL_SHIPPER_CD,                                        
MFA-TR*              BG.ALTERNATE_FUEL_CD,                                      
MFA-TR*              BG.TRNSP_OVER_MDQ_FL                                       
MFA-TR*         FROM CSS_BILLING_HDR BI, CSS_BILLING_DET BG                     
MFA-TR*        WHERE BI.ACCOUNT_NO = :BI-ACCOUNT-NO                             
MFA-TR*          AND BI.ACCOUNT_NO = BG.ACCOUNT_NO                              
MFA-TR*          AND BI.BILL_NO    = BG.BILL_NO                                 
MFA-TR*          AND BG.IC_NO      = :BG-IC-NO                                  
MFA-TR*          AND BI.DATE_BILLED IS NULL                                     
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*          AND BG.CODE_BILL_CALC    <> 'S'                                
MFA-TR*          AND BG.REVENUE_MONTH      = 0                                  
MFA-TR*          AND BG.REV_MTH_ORIG_BILL  = 0                                  
MFA-TR*          AND BG.CODE_REVENUE_CLASS <> :TZ-CODE-REVENUE-CLASS            
MFA-TR*     ORDER BY BG.BILL_ITEM_TIMESTMP DESC                                 
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **    0000-MAINLINE                                           **          
      ****************************************************************          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU  0100-EXIT.         
                                                                        
           PERFORM 7000-READ-GAS-INPUT         THRU  7000-EXIT.         
      *                                                                         
T36599     MOVE '01'                         TO C7-COMPANY-NO.          
      *                                                                         
T36599     PERFORM 7805-GET-COMP-DESC          THRU 7805-EXIT.          
T36599     MOVE C7-COMPANY-NAME              TO WS-SCEG-COMP-NAME.      
      *                                                                         
T36599     PERFORM 8300-PRINT-HEADERS          THRU 8300-EXIT.          
      *                                                                         
           PERFORM 1000-PROCESS-GAS-INPUT THRU  1000-EXIT               
                   UNTIL END-OF-INPUT.                                  
                                                                        
           IF WS-INPUT-RECS-READ       GREATER THAN  ZERO               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '************PCSCA323 PROCESSING ERROR*******'   
               DISPLAY 'INPUT GAS FILE EMPTY '                          
               MOVE SPACES                 TO  WS-RESTART-JOB-COMPLETE  
               PERFORM 8897-WRITE-RSDDR  THRU  8897-EXIT                
               MOVE 03                         TO   RETURN-CODE         
               PERFORM 9000-TERMINATE          THRU 9000-EXIT           
               STOP RUN                                                 
           END-IF.                                                      
T36599*                                                                         
              PERFORM 3000-CONTROL-REPORT     THRU 3000-EXIT            
                                                                        
           MOVE SPACES        TO WS-RESTART-JOB-COMPLETE.               
           IF WS-THIS-IS-A-RESTART                                      
              SET WS-RERUN-COMPLETED           TO TRUE                  
           ELSE                                                         
              SET WS-RUN-COMPLETED-NO-PROBLEMS TO TRUE                  
           END-IF.                                                      
           IF WS-CHKP-LUW-LIMIT     EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8897-WRITE-RSDDR         THRU 8897-EXIT           
           END-IF.                                                      
           IF  WS-RESTART-REQ EQUAL WS-YES                              
               PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT       
           END-IF.                                                      
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  INITIALIZATION ROUTINE                                    **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
T36599     ACCEPT WS-CURRENT-TIME         FROM TIME.                    
T36599     MOVE   WS-CURRENT-TIME(1:2)    TO WS-REP-HH.                 
T36599     MOVE   WS-CURRENT-TIME(3:2)    TO WS-REP-MIN.                
T36599     MOVE   WS-CURRENT-TIME(5:2)    TO WS-REP-SS.                 
T36599*                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT  FCSCA323-FILE.                                   
           IF E-FCSCA323-SUCCESSFUL                                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' '                                              
               DISPLAY '**  PCSCA323 PROCESSING ERROR          **'      
               DISPLAY '**  OPEN ERROR OF FCSCA323   FILE      **'      
               DISPLAY '**  FILE STATUS = ' WS-FCSCA323-STATUS          
               DISPLAY '**  PROCESSING TERMINATED              **'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           PERFORM 7500-GET-CURRENT-TIMESTAMP    THRU 7500-EXIT         
      *                                                                         
T36599     MOVE WS-CURRENT-DATE      TO P-RPT-RUN-DT                    
T36599*                                                                         
           MOVE '01'                             TO C8-COMPANY-NO       
           MOVE 'WQ-CIG-NOM-MAX'                 TO C8-DELINQ-CD        
           PERFORM 7550-GET-MAX-WQ-LIMIT         THRU 7550-EXIT         
      *                                                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT     THRU 6253-EXIT.        
T36599*                                                                         
           INITIALIZE   WS-SYSIPT                                       
T36599*                                                                         
           IF WS-CHKP-LUW-LIMIT    EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
             AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS    
               DISPLAY ' '                                              
               DISPLAY '**  ' WS-PGRMNAME ' INFORMATIONAL MSG      **'  
               DISPLAY '**  CHKP-LUW AND CHKP-UPD PARMS            **'  
               DISPLAY '**  BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS   
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT           **'  
               DISPLAY '**  POINTS SHOULD NOT BE TAKEN.            **'  
               DISPLAY '**  COMPLETE RERUN WILL BE REQUIRED        **'  
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.          **'  
               DISPLAY '**  PROCESSING CONTINUING                  **'  
           END-IF.                                                      
      *                                                                         
      *****************************************************************         
      *    GET THE COMMON-DATE FROM THE JOB_PARM TABLE                *         
      *****************************************************************         
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE            TO WS-INPUT-DATE     
              MOVE 'PCSCA323'                      TO WS-PGRMNAME       
           ELSE                                                         
              MOVE WS-FCA00-COMMON-DATE            TO WS-INPUT-DATE     
           END-IF                                                       
      *                                                                         
T36599********************************************************                  
T36599*     GET REVENUE MONTH FROM JOB_PARM                  *                  
T36599********************************************************                  
      *                                                                         
T36599     PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
      *                                                                         
T36599     IF  END-OF-SYSIPT                                            
T36599         NEXT SENTENCE                                            
T36599     ELSE                                                         
T36599         PERFORM 7611-CLOSE          THRU 7611-EXIT               
T36599     END-IF.                                                      
      *                                                                         
T36599     MOVE WS-PARM-YR                 TO WS-PARM-REV-YR.           
T36599     MOVE WS-PARM-MONTH              TO WS-PARM-REV-MNTH.         
T36599     MOVE WS-PARM-REV-MNTH-N         TO WS-PARM-REV-MTH.          
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ    THRU 6235-EXIT.        
           INITIALIZE   WS-SYSIPT                                       
           PERFORM 0600-PREPARE-FOR-RESTART      THRU 0600-EXIT.        
           PERFORM 0605-VALIDATE-RESTART-REQ     THRU 0605-EXIT.        
           IF  WS-THIS-IS-A-RESTART                                     
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 0610-INITIALIZE-RESTART  THRU 0610-EXIT          
               MOVE WS-INPUT-DATE               TO WS-RESTART-INPUT-DATE
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  0200-GET-MIN-MAX-DATE                                       **        
      ******************************************************************        
       0200-GET-MIN-MAX-DATE.                                           
      *                                                                         
           MOVE WS-ACCOUNT-NO                TO   UT-ACCOUNT-NO.        
           MOVE 'G'                          TO   UT-CODE-UTIL-TYPE.    
           MOVE TW-PRIMARY-IC-NO             TO   UT-IC-NO.             
           PERFORM 7110-GET-READ-CYCLE       THRU 7110-EXIT.            
           MOVE UT-READ-CYCLE                TO   RW-READ-CYCLE.        
           MOVE E-FCSCA323-REVENUE-MONTH     TO   RW-REVENUE-MONTH.     
           PERFORM 7120-SELECT-OPT-READ-DT   THRU 7120-EXIT.            
           MOVE RW-OPTIMUM-READ-DATE         TO   WS-MAX-READ-DT.       
      *                                                                         
           MOVE E-FCSCA323-REVENUE-MONTH     TO WS-PARM-REV-MONTH-N.    
           COMPUTE WS-PARM-REV-MONTH = WS-PARM-REV-MONTH - 1.           
           IF  WS-PARM-REV-MONTH = 0                                    
               COMPUTE WS-PARM-REV-MONTH = 12                           
               COMPUTE WS-PARM-REV-YEAR  = WS-PARM-REV-YEAR - 1         
           END-IF.                                                      
      *                                                                         
           MOVE WS-PARM-REV-MONTH-N          TO RW-REVENUE-MONTH.       
           PERFORM 7120-SELECT-OPT-READ-DT   THRU 7120-EXIT.            
           MOVE RW-OPTIMUM-READ-DATE         TO WS-DB2-DATE.            
           PERFORM 7130-GET-NEXT-DAY         THRU 7130-EXIT.            
           MOVE WS-DB2-DATE                  TO WS-MIN-READ-DT.         
      *                                                                         
           MOVE 'N'                          TO WS-VALID-DATES.         
           MOVE WS-MIN-READ-DT               TO WS-READ-DATE.           
           PERFORM 7040-CHECK-MINMAX-DT      THRU 7040-EXIT.            
           IF WS-VALID-DATES = 'Y'                                      
              MOVE 'N'                       TO WS-VALID-DATES          
              MOVE WS-MAX-READ-DT            TO WS-READ-DATE            
              PERFORM 7040-CHECK-MINMAX-DT   THRU 7040-EXIT             
              IF WS-VALID-DATES = 'Y'                                   
                 CONTINUE                                               
              ELSE                                                      
A04860           MOVE SPACES             TO WS-77-COMMENTS-TEXT         
                 STRING  'DATE' WS-MAX-READ-DT                          
C34044                   ' IS OUT OF CONTRACT PERIOD '                  
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
      *                                                                         
T36599           MOVE WS-IN-ACCOUNT-NO         TO P-NOM-ACCT            
PRJ853           MOVE WS-DEL-VOL-CUSTOMER      TO P-NOM-UNITS           
T36599           MOVE WS-MSG-2                 TO P-NOM-TEXT            
T36599           PERFORM 2500-NOMINAT-REPORT   THRU 2500-EXIT           
                 PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT          
                 SET NOT-VALID-CUSTOMER        TO TRUE                  
              END-IF                                                    
           ELSE                                                         
A04860        MOVE SPACES             TO WS-77-COMMENTS-TEXT            
T36599        STRING  WS-MSG-3                                          
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
      *                                                                         
T36599        MOVE WS-IN-ACCOUNT-NO          TO P-NOM-ACCT              
PRJ853        MOVE WS-DEL-VOL-CUSTOMER       TO P-NOM-UNITS             
T36599        MOVE WS-MSG-3                  TO P-NOM-TEXT              
T36599        PERFORM 2500-NOMINAT-REPORT    THRU 2500-EXIT             
              PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT             
              SET NOT-VALID-CUSTOMER         TO TRUE                    
              MOVE E-FCSCA323-TOT-VOL-DKTHMS TO WS-GAS-TOT-VOL-DKTHMS   
              COMPUTE WS-TOT-NOM-ERROR-VOL =                            
                      WS-TOT-NOM-ERROR-VOL + WS-GAS-TOT-VOL-DKTHMS-R    
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *         0600-PREPARE-FOR-RESTART                              *         
      *****************************************************************         
      *                                                                         
       0600-PREPARE-FOR-RESTART.                                        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
           MOVE WS-ONE                       TO RF-PARTITION-NO.        
           MOVE WS-ONE                       TO RF-DUP-CNTRL-NO.        
           PERFORM 7450-SELECT-RESTART-DATA  THRU 7450-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT     TO WS-RESTART-DATA          
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 MOVE WS-YES  TO WS-IS-THIS-A-RESTART                   
              ELSE                                                      
                 GO TO 0600-EXIT                                        
              END-IF                                                    
           ELSE                                                         
              GO TO 0600-EXIT                                           
           END-IF.                                                      
      *****************************************************************         
      *         REPOSITION INPUT FILE                                 *         
      *****************************************************************         
           PERFORM 7000-READ-GAS-INPUT       THRU 7000-EXIT             
             UNTIL WS-INPUT-RECS-READ EQUAL  WS-RESTART-RECS-READ.      
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF PCSCA323  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-CHKP-SEQ-NO       TO WS-CHKP-SEQ-NO.         
                                                                        
           MOVE WS-RESTART-RECS-READ         TO WS-INPUT-RECS-READ.     
           MOVE WS-RESTART-NO-OF-RECS-INSRTD TO WS-NO-OF-RECS-INSRTD.   
           MOVE WS-RESTART-NO-OF-ERR-RECS    TO WS-NO-OF-ERR-RECS.      
PRJ853     MOVE WS-RESTART-TOT-SCPC-DELV-VOL TO WS-TOT-SCPC-DELV-VOL.   
           MOVE WS-RESTART-TOT-NOMINATED-VOL TO WS-TOT-NOMINATED-VOL.   
           MOVE WS-RESTART-TOT-NOM-ERROR-VOL TO WS-TOT-NOM-ERROR-VOL.   
           MOVE WS-RESTART-TOT-DELIVERED-VOL TO WS-TOT-DELIVERED-VOL.   
                                                                        
           SET FIRST-RESTART-READ            TO TRUE.                   
           MOVE ZERO                         TO WS-RESTART-RECS-READ.   
      *****************************************************************         
      *    THE FOLLOWING CODE COMPARES RUN DATE STORED IN                       
      *    RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:                      
      *****************************************************************         
           IF WS-RESTART-INPUT-DATE   EQUAL WS-INPUT-DATE               
             OR WS-RESTART-INPUT-DATE EQUAL SPACES                      
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    0605-VALIDATE-RESTART                                                
      *****************************************************************         
      *                                                                         
       COPY CPD00030.                                                           
      *                                                                         
      *****************************************************************         
      *    0610-INITIALIZE-RESTART                                    *         
      *****************************************************************         
      *                                                                         
       0610-INITIALIZE-RESTART.                                         
      *                                                                         
           MOVE ZEROS                 TO WS-RESTART-PROCESS-TYPE.       
           MOVE SPACES                TO WS-RESTART-INPUT-DATE.         
           MOVE ZEROS                 TO WS-RESTART-CHKP-SEQ-NO.        
           MOVE ZEROS                 TO WS-INPUT-RECS-READ.            
      *                                                                         
       0610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  PROCESS THE RECONCILIATION OR PRODUCE ERROR REPORT       **           
      ***************************************************************           
      *                                                                         
       1000-PROCESS-GAS-INPUT.                                          
      *                                                                         
A04860     INITIALIZE CWS00077-FIELDS                                   
      *                                                                         
T36599     IF E-FCSCA323-REVENUE-MONTH = WS-PARM-REV-MTH                
T36599        CONTINUE                                                  
T36599     ELSE                                                         
T36599        DISPLAY ' '                                               
T36599        DISPLAY '************PCSCA323 PROCESSING ERROR*******'    
T36599        DISPLAY 'NOMINATIONS ARE BEING POSTED FOR INVALID'        
T36599        DISPLAY 'INPUT REVENUE MONTH = ' E-FCSCA323-REVENUE-MONTH 
T36599        DISPLAY 'PARM REVENUE MONTH  = ' WS-PARM-REV-MTH          
T36599        DISPLAY '************PCSCA323 PROCESSING ERROR*******'    
T36599        DISPLAY ' '                                               
T36599        PERFORM 9900-ABEND THRU 9900-EXIT                         
T36599     END-IF.                                                      
      *                                                                         
           IF E-FCSCA323-TOT-VOL-DKTHMS      IS NUMERIC                 
              MOVE E-FCSCA323-TOT-VOL-DKTHMS TO WS-GAS-TOT-VOL-DKTHMS   
PRJ853        COMPUTE WS-TOT-SCPC-DELV-VOL =                            
PRJ853            WS-TOT-SCPC-DELV-VOL + WS-GAS-TOT-VOL-DKTHMS-R        
           END-IF.                                                      
      *                                                                         
C34044     IF E-FCSCA323-ACCOUNT-NO  IS NUMERIC                         
              CONTINUE                                                  
           ELSE                                                         
A04860        MOVE SPACES            TO WS-77-COMMENTS-TEXT             
C34044        STRING 'ACCT NO : ' E-FCSCA323-ACCOUNT-NO                 
                     ' NOT NUMERIC '                                    
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
              INITIALIZE             WS-ACCOUNT-NO                      
                                             AT-PREMISE-NO              
                                             AT-CUSTOMER-NO             
      *                                                                         
T36599        MOVE E-FCSCA323-ACCOUNT-NO       TO P-NOM-ACCT            
PRJ853        MOVE WS-DEL-VOL-CUSTOMER         TO P-NOM-UNITS           
T36599        MOVE WS-MSG-1                    TO P-NOM-TEXT            
T36599        PERFORM 2500-NOMINAT-REPORT    THRU 2500-EXIT             
              PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT             
              SET NOT-VALID-CUSTOMER         TO TRUE                    
              MOVE E-FCSCA323-TOT-VOL-DKTHMS TO WS-GAS-TOT-VOL-DKTHMS   
              COMPUTE WS-TOT-NOM-ERROR-VOL =                            
                      WS-TOT-NOM-ERROR-VOL + WS-GAS-TOT-VOL-DKTHMS-R    
           END-IF.                                                      
      *                                                                         
           IF VALID-CUSTOMER                                            
C34044        MOVE E-FCSCA323-ACCOUNT-NO      TO WS-IN-ACCOUNT-NO       
C34044                                           TW-ACCOUNT-NO          
              PERFORM 7100-SELECT-SCEG-ACCT THRU 7100-EXIT              
T30138        SET WS-NO-DUP-WQ                TO TRUE                   
              MOVE WS-ACCOUNT-NO              TO AT-ACCOUNT-NO          
              PERFORM 7050-SELECT-ACCOUNT   THRU 7050-EXIT              
              IF VALID-CUSTOMER                                         
                 MOVE WS-ACCOUNT-NO              TO TW-ACCOUNT-NO       
                 MOVE 'G'                        TO TW-CODE-UTIL-TYPE   
                 PERFORM 0200-GET-MIN-MAX-DATE THRU 0200-EXIT           
                                                                        
                 IF VALID-CUSTOMER                                      
                    MOVE WS-MIN-READ-DT               TO WS-DATE-READ   
                    PERFORM 7200-SELECT-TRNSP-CNT   THRU 7200-EXIT      
                    PERFORM 1010-MOVE-DAILY-VOL     THRU 1010-EXIT      
                                                                        
                    PERFORM 2200-POPULATE-VOL-DAILY THRU 2200-EXIT      
                                                                        
                    PERFORM 2300-PROCESS-DAILY-VOL  THRU 2300-EXIT      
                            VARYING WS-SUB  FROM 1 BY 1                 
                            UNTIL WS-SUB > 31 OR                        
                                  WS-DATE-READ = WS-MAX-READ-DT         
                                                                        
                    ADD +1                   TO WS-NO-OF-RECS-INSRTD    
                                                                        
                    PERFORM 2400-CHECK-TOT-VOLUMES THRU 2400-EXIT       
                                                                        
PRJ853              COMPUTE WS-TOT-DELIVERED-VOL =                      
PRJ853                      WS-TOT-DELIVERED-VOL + WS-DEL-VOL-CUSTOMER  
                                                                        
                    ADD WS-ONE                   TO WS-CHKP-LUW-COUNTER 
                    IF (WS-CHKP-LUW-COUNTER   EQUAL WS-CHKP-LUW-LIMIT)  
                      OR (WS-CHKP-UPD-COUNTER EQUAL WS-CHKP-UPD-LIMIT   
                      OR GREATER WS-CHKP-UPD-LIMIT)                     
                       PERFORM 8896-ISSUE-CHKP THRU 8896-EXIT           
                    END-IF                                              
                 ELSE                                                   
                    ADD +1  TO WS-NO-OF-ERR-RECS                        
                 END-IF                                                 
              ELSE                                                      
                 ADD +1     TO WS-NO-OF-ERR-RECS                        
              END-IF                                                    
           ELSE                                                         
              ADD +1        TO WS-NO-OF-ERR-RECS                        
           END-IF.                                                      
      *                                                                         
PRJ853     INITIALIZE WS-DEL-VOL-CUSTOMER.                              
           SET OVER-MDQ-NOT-CREATED         TO TRUE.                    
           SET BILLING-DTLS-NOT-FOUND       TO TRUE.                    
           SET VALID-CUSTOMER               TO TRUE.                    
           PERFORM 7000-READ-GAS-INPUT    THRU 7000-EXIT.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    MOVE INPUT DAILY VOLUMES TO WORKING STORAGE                          
      ******************************************************************        
      *                                                                         
       1010-MOVE-DAILY-VOL.                                             
      *                                                                         
           MOVE E-FCSCA323-DAILY-VOLUME  TO WS-MONTHLY-VOLUME-CH.       
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                   UNTIL WS-SUB > 31                                    
              IF WS-DAILY-VOLUME-CH(WS-SUB) IS NUMERIC                  
                 MOVE WS-DAILY-VOLUME-CH(WS-SUB) TO WS-DAILY-VOLUME-NUM 
                 MOVE WS-DAILY-VOL-DEC     TO WS-DAILY-VOLUME(WS-SUB)   
              ELSE                                                      
                 MOVE 9999999999           TO WS-DAILY-VOLUME-NUM       
                 MOVE WS-DAILY-VOL-DEC     TO WS-DAILY-VOLUME(WS-SUB)   
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           MOVE WS-MIN-READ-DT         TO WS-VOLUME-DATE(1)             
                                          WS-DB2-DATE.                  
           PERFORM VARYING WS-SUB FROM 2 BY 1                           
                   UNTIL WS-SUB > 31 OR                                 
                         WS-VOL-FOR-DAY = WS-MAX-READ-DT                
              PERFORM 7130-GET-NEXT-DAY THRU 7130-EXIT                  
              MOVE WS-DB2-DATE            TO WS-VOLUME-DATE(WS-SUB)     
           END-PERFORM.                                                 
      *                                                                         
       1010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    GET BILL-NO AND BILL-ITEM-TIMESTMP                                   
      ******************************************************************        
                                                                        
       2000-GET-BILLING-DTLS.                                           
                                                                        
           MOVE WS-ACCOUNT-NO                TO BI-ACCOUNT-NO.          
           MOVE TW-PRIMARY-IC-NO             TO BG-IC-NO.               
                                                                        
           PERFORM 7310-OPEN-BIBG-CRSR      THRU 7310-EXIT.             
           PERFORM 7320-FETCH-BIBG-CRSR     THRU 7320-EXIT.             
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               PERFORM 7330-CLOSE-BIBG-CRSR THRU 7330-EXIT              
               SET BILL-HOOK-NOT-FOUND        TO TRUE                   
               GO TO 2000-EXIT                                          
           ELSE                                                         
               SET BILL-HOOK-FOUND            TO TRUE                   
           END-IF.                                                      
           PERFORM 7400-GET-TRNSP-TIMESTMP  THRU 7400-EXIT.             
           MOVE TZ-CODE-REVENUE-CLASS   TO BG-CODE-REVENUE-CLASS.       
           MOVE 'N' TO WS-TRNSP-HOOK-EXISTS.                            
           PERFORM 7420-SELECT-TRNSP-HOOK   THRU 7420-EXIT.             
           IF WS-TRNSP-HOOK-EXISTS = 'N'                                
JSFIX         MOVE 'T'                        TO BG-REV-RPT-CD          
              PERFORM 8100-ISRT-BILLING-DET THRU 8100-EXIT              
           END-IF.                                                      
           PERFORM 7330-CLOSE-BIBG-CRSR     THRU 7330-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    CREATE FUTURE BILL HOOK IF NOT ALREADY PRESENT                       
      ******************************************************************        
      *                                                                         
       2100-CREATE-BILL-HOOK.                                           
                                                                        
           MOVE AT-ACCOUNT-NO                  TO BI-ACCOUNT-NO.        
           MOVE AT-PREMISE-NO                  TO BI-PREMISE-NO.        
           MOVE AT-CUSTOMER-NO                 TO BI-CUSTOMER-NO.       
           MOVE AT-COMPANY-NO                  TO BI-COMPANY-NO.        
           ADD +1                              TO AT-NXT-BILL-NO.       
           MOVE AT-NXT-BILL-NO                 TO BI-BILL-NO.           
           MOVE WS-NEG-ONE                     TO BI-DATE-BILLED-NI.    
           MOVE WS-ACTIVE                      TO BI-CODE-BILL-STATUS   
                                                  BI-CODE-BILL-TYPE     
                                                  BI-CODE-BILL-REASON.  
           MOVE SPACES                         TO BI-CODE-SPCL-BILL.    
           PERFORM 8000-ISRT-BILLING-HDR     THRU 8000-EXIT.            
           PERFORM 8200-UPDATE-ACCOUNT       THRU 8200-EXIT.            
                                                                        
           MOVE WS-ACCOUNT-NO                  TO UT-ACCOUNT-NO.        
           MOVE 'G'                            TO UT-CODE-UTIL-TYPE.    
           PERFORM 7700-SELECT-UTIL-ENVRNMT  THRU 7700-EXIT.            
                                                                        
           MOVE BI-ACCOUNT-NO             TO BG-ACCOUNT-NO.             
           MOVE BI-PREMISE-NO             TO BG-PREMISE-NO.             
           MOVE BI-BILL-NO                TO BG-BILL-NO.                
           MOVE UT-IC-NO                  TO BG-IC-NO.                  
           MOVE WS-CURRENT                TO BG-CODE-BILL-ITM-TYPE.     
           MOVE UT-CODE-UTIL-TYPE         TO BG-CODE-UTIL-TYPE.         
           MOVE WS-ACTIVE                 TO BG-CODE-BILL-ITM-IND       
                                             BG-CODE-BILL-CALC.         
           MOVE WS-DEBIT                  TO BG-CODE-DR-CR-CNSMPTN.     
           MOVE ZEROS                     TO BG-REV-MTH-ORIG-BILL.      
           MOVE UT-RATE-PLAN-NO           TO BG-RATE-PLAN-NO.           
           MOVE UT-CODE-REVENUE-CLASS     TO BG-CODE-REVENUE-CLASS.     
           MOVE UT-CODE-SIC-NO            TO BG-CODE-SIC-NO.            
           MOVE UT-CODE-CURTAIL-PRTY      TO BG-CODE-CURTAIL-PRTY.      
           MOVE WS-NEG-ONE                TO BG-DATE-ORIG-BILL-NULL.    
           MOVE ZEROES                    TO BG-AMT-BILL-ITEM           
                                             BG-AMT-STATE-TAX           
                                             BG-AMT-CITY-TAX            
                                             BG-AMT-OTHER-TAX.          
           MOVE UT-COMPANY-NO             TO BG-COMPANY-NO.             
           MOVE UT-CODE-STAT-TAX-XMT      TO BG-CODE-STAT-TAX-XMT.      
           MOVE UT-CODE-CITY-TAX-XMT      TO BG-CODE-CITY-TAX-XMT.      
           MOVE UT-CODE-OTHR-TAX-XMT      TO BG-CODE-OTHR-TAX-XMT.      
           MOVE WS-CURRENT-TIMESTAMP      TO BG-BILL-ITEM-TIMESTMP.     
           MOVE AT-PREMISE-NO             TO PR-PREMISE-NO.             
           PERFORM 7800-SELECT-PREMISE    THRU 7800-EXIT.               
           MOVE PR-REV-DISTRICT-CD        TO BG-REV-DISTRICT-CD.        
           PERFORM 8100-ISRT-BILLING-DET  THRU 8100-EXIT.               
           PERFORM 7400-GET-TRNSP-TIMESTMP THRU 7400-EXIT.              
           MOVE WS-ACCOUNT-NO             TO TZ-ACCOUNT-NO.             
           MOVE 'G'                       TO TZ-CODE-UTIL-TYPE.         
           MOVE TW-PRIMARY-IC-NO          TO TZ-PRIMARY-IC-NO.          
           MOVE TZ-CODE-REVENUE-CLASS     TO BG-CODE-REVENUE-CLASS.     
JSFIX      MOVE 'T'                       TO BG-REV-RPT-CD.             
           PERFORM 8100-ISRT-BILLING-DET  THRU 8100-EXIT.               
           SET BILL-HOOK-FOUND            TO TRUE.                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    POPULATE THE VALUES TO BE INSERTED IN CSS_VOL_DAILY                  
      ******************************************************************        
       2200-POPULATE-VOL-DAILY.                                         
                                                                        
           MOVE WS-ACCOUNT-NO              TO ND-ACCOUNT-NO.            
           MOVE 'G'                        TO ND-CODE-UTIL-TYPE.        
           MOVE TW-PRIMARY-IC-NO           TO ND-IC-NO.                 
           MOVE 'D'                        TO ND-ENERGY-UNIT-CD.        
           MOVE ZEROES                     TO ND-FIXED-FCTR-SEQ-NO.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    COMPUTE DAILY NOMINATED, SHRINKAGE & DELIVERED VOLUMES               
      ******************************************************************        
      *                                                                         
       2300-PROCESS-DAILY-VOL.                                          
                                                                        
           MOVE WS-VOLUME-DATE(WS-SUB)  TO WS-DATE-READ.                
           MOVE WS-DAILY-VOLUME(WS-SUB) TO WS-DAILY-VOL-DEC.            
           IF WS-DAILY-VOLUME-NUM    EQUAL 9999999999                   
A04860        MOVE SPACES               TO WS-77-COMMENTS-TEXT          
              STRING ' DOES NOT HAVE A VALID NUMERIC VOLUME FOR DAY '   
                      WS-DATE-READ                                      
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
      *                                                                         
T36599        MOVE WS-IN-ACCOUNT-NO        TO P-NOM-ACCT                
PRJ853        MOVE WS-DEL-VOL-CUSTOMER     TO P-NOM-UNITS               
T36599        MOVE WS-MSG-4                TO P-NOM-TEXT                
T36599        PERFORM 2500-NOMINAT-REPORT  THRU 2500-EXIT               
T36599        ADD +1        TO WS-NO-OF-ERR-RECS                        
              PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT             
              SET NOT-VALID-CUSTOMER           TO TRUE                  
           ELSE                                                         
PRJ853        COMPUTE WS-NOMINATED-UNITS ROUNDED                        
PRJ853         = WS-DAILY-VOLUME(WS-SUB) /                              
PRJ853                          ( 1 - (TW-TRNSP-SHRINK-PCT/100.0 ))     
                                                                        
PRJ953        COMPUTE WS-SHRINKAGE-UNITS ROUNDED                        
PRJ853         = WS-NOMINATED-UNITS - WS-DAILY-VOLUME(WS-SUB)           
                                                                        
              MOVE TW-TRNSP-MDQ         TO WS-TRNSP-OVER-MDQ            
PRJ853        IF WS-DAILY-VOLUME(WS-SUB) > WS-TRNSP-OVER-MDQ            
                 AND OVER-MDQ-NOT-CREATED                               
                 DISPLAY 'DAILY VOLUME   : ' WS-DAILY-VOLUME(WS-SUB)    
                 DISPLAY 'TRNSP OVER MDQ : ' WS-TRNSP-OVER-MDQ          
A04860           MOVE SPACES              TO WS-77-COMMENTS-TEXT        
T36599           STRING WS-MSG-5                                        
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
      *                                                                         
T36599           MOVE WS-IN-ACCOUNT-NO        TO P-NOM-ACCT             
PRJ853           MOVE WS-DEL-VOL-CUSTOMER     TO P-NOM-UNITS            
T36599           MOVE WS-MSG-5                TO P-NOM-TEXT             
T36599           PERFORM 2500-NOMINAT-REPORT  THRU 2500-EXIT            
T36599           ADD +1                       TO WS-NO-OF-ERR-RECS      
                 PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT          
                 SET OVER-MDQ-CREATED         TO TRUE                   
              END-IF                                                    
              PERFORM 2350-INSERT-VOL-DAILY     THRU 2350-EXIT          
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    INSERT 3 ROWS IN CSS_VOL_DAILY FOR EACH INPUT RECORD                 
      ******************************************************************        
       2350-INSERT-VOL-DAILY.                                           
                                                                        
           MOVE WS-DATE-READ                 TO ND-DATE-READ.           
                                                                        
           MOVE 'NT'                         TO ND-VOL-TYPE-CD.         
PRJ853     MOVE WS-NOMINATED-UNITS           TO ND-NO-UNITS.            
           IF ND-NO-UNITS > ZEROES                                      
              IF BILLING-DTLS-NOT-FOUND                                 
                 PERFORM 2000-GET-BILLING-DTLS THRU 2000-EXIT           
                 IF BILL-HOOK-NOT-FOUND                                 
                    PERFORM 2100-CREATE-BILL-HOOK THRU 2100-EXIT        
                 END-IF                                                 
                 MOVE BG-BILL-NO             TO ND-BILL-NO              
                 MOVE BG-BILL-ITEM-TIMESTMP  TO ND-BILL-ITEM-TIMESTMP   
                 SET BILLING-DTLS-FOUND      TO TRUE                    
              END-IF                                                    
              PERFORM 7900-INSERT-VOL-DAILY  THRU 7900-EXIT             
           END-IF.                                                      
PRJ853     COMPUTE WS-TOT-NOMINATED-VOL = WS-TOT-NOMINATED-VOL +        
PRJ853                                    WS-NOMINATED-UNITS.           
                                                                        
           MOVE 'ST'                         TO ND-VOL-TYPE-CD.         
           MOVE WS-SHRINKAGE-UNITS           TO ND-NO-UNITS.            
           IF ND-NO-UNITS > ZEROES                                      
              PERFORM 7900-INSERT-VOL-DAILY  THRU 7900-EXIT             
           END-IF.                                                      
                                                                        
           MOVE 'DT'                         TO ND-VOL-TYPE-CD.         
PRJ853     MOVE WS-DAILY-VOLUME(WS-SUB)      TO ND-NO-UNITS.            
           IF ND-NO-UNITS > ZEROES                                      
              PERFORM 7900-INSERT-VOL-DAILY  THRU 7900-EXIT             
           END-IF.                                                      
PRJ853     COMPUTE WS-DEL-VOL-CUSTOMER  = WS-DEL-VOL-CUSTOMER  +        
PRJ853                                    WS-DAILY-VOLUME(WS-SUB).      
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    CHECK IF DAILY VOLUME GREATER THAN MDQ, IF SO CREATE WQ              
      ******************************************************************        
       2400-CHECK-TOT-VOLUMES.                                          
      *                                                                         
           IF E-FCSCA323-TOT-VOL-DKTHMS      IS NUMERIC                 
              MOVE E-FCSCA323-TOT-VOL-DKTHMS TO WS-GAS-TOT-VOL-DKTHMS   
              MOVE WS-GAS-TOT-VOL-DKTHMS-R   TO WS-TOT-VOL-DKTHMS       
PRJ853        IF WS-DEL-VOL-CUSTOMER NOT EQUAL WS-GAS-TOT-VOL-DKTHMS-R  
                 DISPLAY 'CREATE WQ TOT DKTMS <> SUM OF INDV DKTHMS'    
                 DISPLAY 'VOLUMES HAVE BEEN POSTED HOWEVER'             
PRJ853           MOVE WS-DEL-VOL-CUSTOMER TO WS-NOM-VOL-CUST-DIS        
A04860           MOVE SPACES              TO WS-77-COMMENTS-TEXT        
                 STRING 'TOTAL DKTHMS : ' WS-TOT-VOL-DKTHMS             
                    ' NOT EQUAL TO SUM OF DAILY VOLUMES : '             
                      WS-NOM-VOL-CUST-DIS                               
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
      *                                                                         
T36599           MOVE WS-IN-ACCOUNT-NO        TO P-NOM-ACCT             
PRJ853           MOVE WS-DEL-VOL-CUSTOMER     TO P-NOM-UNITS            
T36599           MOVE WS-MSG-6                TO P-NOM-TEXT             
T36599           PERFORM 2500-NOMINAT-REPORT  THRU 2500-EXIT            
                 PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT          
              END-IF                                                    
           ELSE                                                         
A04860        MOVE SPACES             TO WS-77-COMMENTS-TEXT            
T36599        STRING 'ACCT NO : ' E-FCSCA323-ACCOUNT-NO ' ' WS-MSG-7    
A04860        DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT                
      *                                                                         
T36599        MOVE E-FCSCA323-ACCOUNT-NO     TO P-NOM-ACCT              
PRJ853        MOVE WS-DEL-VOL-CUSTOMER       TO P-NOM-UNITS             
T36599        MOVE WS-MSG-7                  TO P-NOM-TEXT              
T36599        PERFORM 2500-NOMINAT-REPORT    THRU 2500-EXIT             
              PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT             
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    NOMINATIONS NOT POSTED                                               
      ******************************************************************        
      *                                                                         
T36599 2500-NOMINAT-REPORT.                                             
      *                                                                         
T36599     IF WS-RPT-LINE-NO > WS-50                                    
T36599        MOVE 0                     TO WS-RPT-LINE-NO              
T36599        PERFORM 8300-PRINT-HEADERS THRU 8300-EXIT                 
T36599     ELSE                                                         
T36599        ADD 1                      TO WS-RPT-LINE-NO              
T36599        MOVE WS-NOM-LINE           TO PRT33-DATA                  
T36599        WRITE PRT33-RECORD                                        
T36599     END-IF.                                                      
      *                                                                         
T36599 2500-EXIT.                                                       
T36599     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    CONTROL REPORT FOR THE PROCESS                                       
      ******************************************************************        
      *                                                                         
       3000-CONTROL-REPORT.                                             
      *                                                                         
T36599     MOVE WS-BLANK-LINE   TO PRT33-DATA.                          
           WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE WS-BLANK-LINE   TO PRT33-DATA.                          
           WRITE PRT33-RECORD.                                          
      *                                                                         
           MOVE 'NO OF INPUT RECORDS READ' TO P-TEXT.                   
           MOVE WS-INPUT-RECS-READ         TO WS-INPUT-RECS-READ-DIS.   
           MOVE WS-INPUT-RECS-READ-DIS     TO P-VALUE.                  
           MOVE WS-DETAIL-LINE             TO PRT33-DATA.               
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE 'NO OF CUSTOMERS INSERTED'     TO P-TEXT.               
           MOVE WS-NO-OF-RECS-INSRTD  TO WS-NO-OF-RECS-INSRTD-DIS.      
           MOVE WS-NO-OF-RECS-INSRTD-DIS       TO P-VALUE.              
           MOVE WS-DETAIL-LINE                 TO PRT33-DATA.           
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE 'NO OF CUSTOMERS IN ERROR'  TO P-TEXT.                  
           MOVE WS-NO-OF-ERR-RECS           TO WS-NO-OF-ERR-RECS-DIS.   
           MOVE WS-NO-OF-ERR-RECS-DIS       TO P-VALUE.                 
           MOVE WS-DETAIL-LINE              TO PRT33-DATA.              
           WRITE PRT33-RECORD.                                          
                                                                        
PRJ853     MOVE 'TOTAL DELIVERED UNITS SCPC'  TO P-DESC.                
PRJ853     MOVE WS-TOT-SCPC-DELV-VOL          TO P-VOLUME.              
           MOVE WS-VOLUME-LINE                TO PRT33-DATA.            
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE 'TOTAL NOMINATED UNITS'       TO P-DESC.                
           MOVE WS-TOT-NOMINATED-VOL          TO P-VOLUME.              
           MOVE WS-VOLUME-LINE                TO PRT33-DATA.            
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE 'TOTAL NOM ERROR UNITS'       TO P-DESC.                
           MOVE WS-TOT-NOM-ERROR-VOL          TO P-VOLUME.              
           MOVE WS-VOLUME-LINE                TO PRT33-DATA.            
           WRITE PRT33-RECORD.                                          
                                                                        
           MOVE 'TOTAL DELIVERED UNITS'       TO P-DESC.                
           MOVE WS-TOT-DELIVERED-VOL          TO P-VOLUME.              
           MOVE WS-VOLUME-LINE                TO PRT33-DATA.            
           WRITE PRT33-RECORD.                                          
                                                                        
T36599     MOVE WS-BLANK-LINE                TO PRT33-DATA.             
T36599     WRITE PRT33-RECORD.                                          
T36599*                                                                         
T36599     MOVE WS-END-LINE                  TO PRT33-DATA.             
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   3300-CREATE-WORK-QUEUE                                    **         
      *****************************************************************         
      *                                                                         
       3300-CREATE-WORK-QUEUE.                                          
      *                                                                         
           IF WS-WORK-QUEUE-COUNT < C8-DELINQ-VALUE                     
A04860        MOVE +142               TO WS-77-CATEGORY-ID              
A04860        MOVE 'H'                TO WS-77-PRIORITY                 
A04860        MOVE '4'                TO WS-77-ROUTE-CATEGORY           
A04860        MOVE ZERO               TO WS-77-SERV-ORDER-NO            
A04860        MOVE WS-CURRENT-TIMESTAMP TO WS-77-DATE-REQUIRED          
A04860        MOVE WS-ACCOUNT-NO      TO WS-77-ACCOUNT-NO               
A04860        IF WS-DUP-WQ                                              
A04860           MOVE +185            TO WS-77-COMMENTS-LEN             
A04860           MOVE ZEROES          TO WS-77-PREMISE-NO               
A04860           MOVE ZEROES          TO WS-77-CUSTOMER-NO              
A04860        ELSE                                                      
A04860           MOVE +125            TO WS-77-COMMENTS-LEN             
A04860           MOVE AT-PREMISE-NO   TO WS-77-PREMISE-NO               
A04860           MOVE AT-CUSTOMER-NO  TO WS-77-CUSTOMER-NO              
A04860        END-IF                                                    
A04860        MOVE SPACES             TO WS-77-LOCAL-OFFICE             
A04860        MOVE SPACES             TO WS-77-RESP-AREA-ID             
A04860        MOVE 'SYSTEM'           TO WS-77-USER-ID-ORIG             
A04860        MOVE ZERO               TO WS-77-FREE-FORM-LEN            
A04860        MOVE LOW-VALUES         TO WS-77-FREE-FORM-TXT            
A04860        MOVE PROGRAM-NAME       TO WS-77-CREATED-BY               
                                                                        
              PERFORM 8895-INSERT-WORK-QUEUE  THRU 8895-EXIT            
                                                                        
              ADD +1                            TO WS-WORK-QUEUE-COUNT  
           ELSE                                                         
              DISPLAY '***  PROGRAM ABEND    ***'                       
              MOVE C8-DELINQ-VALUE        TO WS-DELINQ-VALUE            
              DISPLAY 'NO OF WQS EXCEEDED MAX LIMIT OF '                
                                             WS-DELINQ-VALUE            
              DISPLAY 'THE PROGRAM HAS BEEN FORCED TO ABEND'            
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *   8895-INSERT-WORK-QUEUE                                      *         
      *****************************************************************         
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *****************************************************************         
      *       6235-GET-FJC01-RESTART-REQ.                                       
      *****************************************************************         
      *                                                                         
       COPY CPD00035.                                                           
      *                                                                         
      *****************************************************************         
      *       6240-GET-FCA00-COMMON-DATE.                                       
      *****************************************************************         
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      *****************************************************************         
      *       6251-GET-FJC01-DATE.                                              
      *****************************************************************         
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
      *****************************************************************         
      *       6253-GET-FJC01-CHKP-LIMIT.                                        
      *****************************************************************         
      *                                                                         
       COPY CPD00034.                                                           
      *                                                                         
T36599**********************************************************                
T36599** 6200-GET-PARAMETER-DATE                              **                
T36599**********************************************************                
      *                                                                         
T36599     EXEC SQL                                                             
T36599           INCLUDE CPD00114                                               
T36599     END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      **  READ GAS094  INPUT FILE                                  **           
      ***************************************************************           
      *                                                                         
       7000-READ-GAS-INPUT.                                             
                                                                        
           READ FCSCA323-FILE                                           
              AT END                                                    
                 MOVE WS-Y TO WS-FCSCA323-EOF-SW                        
                 GO TO 7000-EXIT.                                       
                                                                        
           IF E-FCSCA323-SUCCESSFUL                                     
              ADD 1        TO WS-INPUT-RECS-READ                        
           ELSE                                                         
              DISPLAY '  '                                              
              DISPLAY '7000 ERROR ON FCSCA323 READ.  STATUS IS '        
                       WS-FCSCA323-STATUS                               
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  GET READ CYCLE FROM CSS_UTIL_ENVRNMT                     **           
      ***************************************************************           
      *                                                                         
       7110-GET-READ-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT READ_CYCLE                                        
                 INTO :UT-READ-CYCLE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND IC_NO          = :UT-IC-NO                        
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_CYCLE                                                
MFA-TR*          INTO :UT-READ-CYCLE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :UT-IC-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
C34044         DISPLAY '**      ABEND IN PARAGRAPH 7110       **'       
               DISPLAY '**            SQLCODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**         ACCOUNT_NO = ' UT-ACCOUNT-NO         
               DISPLAY '**     CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE     
               DISPLAY '**              IC_NO = ' UT-IC-NO              
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  GET READ CYCLE FROM CSS_UTIL_ENVRNMT                     **           
      ***************************************************************           
       7120-SELECT-OPT-READ-DT.                                         
                                                                        
           EXEC SQL                                                     
               SELECT OPTIMUM_READ_DATE                                 
                 INTO :RW-OPTIMUM-READ-DATE                             
                 FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                     
                WHERE READ_CYCLE    = :RW-READ-CYCLE                    
                  AND REVENUE_MONTH = :RW-REVENUE-MONTH                 
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPTIMUM_READ_DATE                                         
MFA-TR*          INTO :RW-OPTIMUM-READ-DATE                                     
MFA-TR*          FROM CSS_READ_WINDOW                                           
MFA-TR*         WHERE READ_CYCLE    = :RW-READ-CYCLE                            
MFA-TR*           AND REVENUE_MONTH = :RW-REVENUE-MONTH                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
C34044         DISPLAY '**      ABEND IN PARAGRAPH 7120       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**     READ CYCLE = ' RW-READ-CYCLE             
               DISPLAY '**   REVENUE MONTH= ' RW-REVENUE-MONTH          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  SELECT TO ADD ONE DAY TO A DATE                          **           
      ***************************************************************           
       7130-GET-NEXT-DAY.                                               
                                                                        
           EXEC SQL                                                     
C34044            SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DB2-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DB2-DATE
              ) <> 0) OR (LEN(:WS-DB2-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-DB2-DATE
              ), CONVERT(DATE, :WS-DB2-DATE) ) )
            INTO
              :WS-DB2-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SET :WS-DB2-DATE =                                            
MFA-TR*                DATE(:WS-DB2-DATE) + 1 DAY                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF  WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL              
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
C34044         DISPLAY '**      ABEND IN PARAGRAPH 7130       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**       DB2 DATE = ' WS-DB2-DATE               
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  CHECK IF MIN AND MAX DATES ARE VALID                     **           
      ***************************************************************           
       7040-CHECK-MINMAX-DT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-VALID-DATES                                   
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED),              
                      CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                
                WHERE TW.ACCOUNT_NO       = :TW-ACCOUNT-NO              
                  AND TW.CODE_UTIL_TYPE   = :TW-CODE-UTIL-TYPE          
                  AND TW.ACCOUNT_NO       = BK.ACCOUNT_NO               
                  AND TW.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE           
                  AND TW.PRIMARY_IC_NO    = BK.IC_NO                    
                  AND TW.CNTRCT_START_DT  = BK.CNTRCT_START_DT          
                  AND BK.CNTRCT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )               
                  AND TW.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) )               
                  AND TW.CNTRCT_START_DT  =                             
                   (SELECT MAX(T1.CNTRCT_START_DT)                      
                      FROM CSS_TRNSP_CONTRACT T1 WITH(READUNCOMMITTED)          
                     WHERE T1.ACCOUNT_NO       = TW.ACCOUNT_NO          
                       AND T1.CODE_UTIL_TYPE   = TW.CODE_UTIL_TYPE      
                       AND T1.PRIMARY_IC_NO    = TW.PRIMARY_IC_NO       
                       AND T1.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-READ-DATE
              ) <> 0) OR (LEN(:WS-READ-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-READ-DATE
              ), CONVERT(DATE, :WS-READ-DATE) ))         
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-VALID-DATES                                           
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW,                                    
MFA-TR*               CSS_BILL_CONTRACT BK                                      
MFA-TR*         WHERE TW.ACCOUNT_NO       = :TW-ACCOUNT-NO                      
MFA-TR*           AND TW.CODE_UTIL_TYPE   = :TW-CODE-UTIL-TYPE                  
MFA-TR*           AND TW.ACCOUNT_NO       = BK.ACCOUNT_NO                       
MFA-TR*           AND TW.CODE_UTIL_TYPE   = BK.CODE_UTIL_TYPE                   
MFA-TR*           AND TW.PRIMARY_IC_NO    = BK.IC_NO                            
MFA-TR*           AND TW.CNTRCT_START_DT  = BK.CNTRCT_START_DT                  
MFA-TR*           AND BK.CNTRCT_END_DT   >= :WS-READ-DATE                       
MFA-TR*           AND TW.CNTRCT_START_DT <= :WS-READ-DATE                       
MFA-TR*           AND TW.CNTRCT_START_DT  =                                     
MFA-TR*            (SELECT MAX(T1.CNTRCT_START_DT)                              
MFA-TR*               FROM CSS_TRNSP_CONTRACT T1                                
MFA-TR*              WHERE T1.ACCOUNT_NO       = TW.ACCOUNT_NO                  
MFA-TR*                AND T1.CODE_UTIL_TYPE   = TW.CODE_UTIL_TYPE              
MFA-TR*                AND T1.PRIMARY_IC_NO    = TW.PRIMARY_IC_NO               
MFA-TR*                AND T1.CNTRCT_START_DT <= :WS-READ-DATE)                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7040       **'       
               DISPLAY '**          SQLCODE = ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '**         DB2 DATE = ' WS-READ-DATE            
C34044         DISPLAY '**       ACCOUNT_NO = ' TW-ACCOUNT-NO           
C34044         DISPLAY '**  CODE_UTIL_TYPE  = ' TW-CODE-UTIL-TYPE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      **  GET ACCOUNT DETAILS TO INSERT FUTURE BILL HOOK           **           
      ***************************************************************           
       7050-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO,                                       
                      CUSTOMER_NO,                                      
                      CODE_COMPANY_ACCT,                                
                      CODE_ACCT_BILLED,                                 
                      LOCAL_OFFICE,                                     
                      COMPANY_NO,                                       
                      NXT_BILL_NO,                                      
                      CODE_ACCT_STAT,                                   
                      BILL_CYCLE,                                       
                      REV_MTH_LST_NRML                                  
                 INTO :AT-PREMISE-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-CODE-COMPANY-ACCT,                            
                      :AT-CODE-ACCT-BILLED,                             
                      :AT-LOCAL-OFFICE,                                 
                      :AT-COMPANY-NO,                                   
                      :AT-NXT-BILL-NO,                                  
                      :AT-CODE-ACCT-STAT,                               
                      :AT-BILL-CYCLE,                                   
                      :AT-REV-MTH-LST-NRML                              
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               CODE_COMPANY_ACCT,                                        
MFA-TR*               CODE_ACCT_BILLED,                                         
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               NXT_BILL_NO,                                              
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               BILL_CYCLE,                                               
MFA-TR*               REV_MTH_LST_NRML                                          
MFA-TR*          INTO :AT-PREMISE-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-CODE-COMPANY-ACCT,                                    
MFA-TR*               :AT-CODE-ACCT-BILLED,                                     
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-NXT-BILL-NO,                                          
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-BILL-CYCLE,                                           
MFA-TR*               :AT-REV-MTH-LST-NRML                                      
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7050-SELECT-ACCOUNT'                            
               DISPLAY '     SQLCODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY 'ACCOUNT NO   = ' AT-ACCOUNT-NO                  
               PERFORM 9900-ABEND        THRU  9900-EXIT                
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-SCEG-ACCT                                          *        
      *       THIS MODULE OBTAINS THE CIS ACCOUNT NO USING THE SCPC    *        
      *       CUSTOMER NO                                              *        
      ******************************************************************        
       7100-SELECT-SCEG-ACCT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
                     ,PRIMARY_IC_NO                                     
                 INTO :WS-ACCOUNT-NO                                    
                     ,:TW-PRIMARY-IC-NO                                 
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED)               
C34044          WHERE ACCOUNT_NO     = :TW-ACCOUNT-NO                   
                  AND CNTRCT_START_DT =                                 
                             (SELECT MAX(CNTRCT_START_DT)               
                                FROM CSS_TRNSP_CONTRACT T2
                           WITH(READUNCOMMITTED)              
                               WHERE TW.ACCOUNT_NO = T2.ACCOUNT_NO)     
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*              ,PRIMARY_IC_NO                                             
MFA-TR*          INTO :WS-ACCOUNT-NO                                            
MFA-TR*              ,:TW-PRIMARY-IC-NO                                         
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW                                     
MFA-TR*         WHERE ACCOUNT_NO     = :TW-ACCOUNT-NO                           
MFA-TR*           AND CNTRCT_START_DT =                                         
MFA-TR*                      (SELECT MAX(CNTRCT_START_DT)                       
MFA-TR*                         FROM CSS_TRNSP_CONTRACT T2                      
MFA-TR*                        WHERE TW.ACCOUNT_NO = T2.ACCOUNT_NO)             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
T30138                                WS-MULTIPLE-ROWS-FOUND            
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T36599           STRING  WS-MSG-8                                       
A04860           DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT             
      *                                                                         
T36599           MOVE TW-ACCOUNT-NO               TO P-NOM-ACCT         
T36599           MOVE WS-NOM-VOL-CUST-DIS         TO P-NOM-UNITS        
T36599           MOVE WS-MSG-8                    TO P-NOM-TEXT         
T36599           PERFORM 2500-NOMINAT-REPORT      THRU 2500-EXIT        
T36599           ADD +1                           TO WS-NO-OF-ERR-RECS  
                 PERFORM 3300-CREATE-WORK-QUEUE THRU 3300-EXIT          
                 SET NOT-VALID-CUSTOMER           TO TRUE               
              ELSE                                                      
                 DISPLAY '7100-SELECT-SCEG-ACCT'                        
                 DISPLAY '      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
C34044           DISPLAY '   ACCOUNT NO = ' TW-ACCOUNT-NO               
                 PERFORM 9900-ABEND   THRU  9900-EXIT                   
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-TRNSP-CNT                                          *        
      *       THIS MODULE OBTAINS THE SHRINKAGE PERCENTILE FROM        *        
      *       CSS_TRNSP_CONTRACT                                       *        
      ******************************************************************        
       7200-SELECT-TRNSP-CNT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TW.PRIMARY_IC_NO,                                 
                      TW.TRNSP_SHRINK_PCT,                              
                      TW.TRNSP_MDQ,                                     
                      TZ.CODE_REVENUE_CLASS                             
                 INTO :TW-PRIMARY-IC-NO,                                
                      :TW-TRNSP-SHRINK-PCT,                             
                      :TW-TRNSP-MDQ,                                    
                      :TZ-CODE-REVENUE-CLASS                            
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED),              
                      CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)                
                WHERE TW.ACCOUNT_NO       = :TW-ACCOUNT-NO              
                  AND TW.ACCOUNT_NO       = TZ.ACCOUNT_NO               
                  AND TW.CODE_UTIL_TYPE   = :TW-CODE-UTIL-TYPE          
                  AND TW.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE           
                  AND TW.PRIMARY_IC_NO    = TZ.PRIMARY_IC_NO            
                  AND TW.PRIMARY_IC_NO    = TZ.IC_NO                    
                  AND TW.CNTRCT_START_DT  = TZ.CNTRCT_START_DT          
                  AND TZ.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) )               
                  AND TZ.CNTRCT_START_DT  =                             
                      (SELECT MAX(T1.CNTRCT_START_DT)                   
                         FROM CSS_TRNSP_VOL_BLK T1 WITH(READUNCOMMITTED)        
                        WHERE T1.ACCOUNT_NO       = TZ.ACCOUNT_NO       
                          AND T1.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE   
                          AND T1.CNTRCT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ
              ) <> 0) OR (LEN(:WS-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-READ
              ), CONVERT(DATE, :WS-DATE-READ) ))      
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TW.PRIMARY_IC_NO,                                         
MFA-TR*               TW.TRNSP_SHRINK_PCT,                                      
MFA-TR*               TW.TRNSP_MDQ,                                             
MFA-TR*               TZ.CODE_REVENUE_CLASS                                     
MFA-TR*          INTO :TW-PRIMARY-IC-NO,                                        
MFA-TR*               :TW-TRNSP-SHRINK-PCT,                                     
MFA-TR*               :TW-TRNSP-MDQ,                                            
MFA-TR*               :TZ-CODE-REVENUE-CLASS                                    
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW,                                    
MFA-TR*               CSS_TRNSP_VOL_BLK TZ                                      
MFA-TR*         WHERE TW.ACCOUNT_NO       = :TW-ACCOUNT-NO                      
MFA-TR*           AND TW.ACCOUNT_NO       = TZ.ACCOUNT_NO                       
MFA-TR*           AND TW.CODE_UTIL_TYPE   = :TW-CODE-UTIL-TYPE                  
MFA-TR*           AND TW.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE                   
MFA-TR*           AND TW.PRIMARY_IC_NO    = TZ.PRIMARY_IC_NO                    
MFA-TR*           AND TW.PRIMARY_IC_NO    = TZ.IC_NO                            
MFA-TR*           AND TW.CNTRCT_START_DT  = TZ.CNTRCT_START_DT                  
MFA-TR*           AND TZ.CNTRCT_START_DT <= :WS-DATE-READ                       
MFA-TR*           AND TZ.CNTRCT_START_DT  =                                     
MFA-TR*               (SELECT MAX(T1.CNTRCT_START_DT)                           
MFA-TR*                  FROM CSS_TRNSP_VOL_BLK T1                              
MFA-TR*                 WHERE T1.ACCOUNT_NO       = TZ.ACCOUNT_NO               
MFA-TR*                   AND T1.CODE_UTIL_TYPE   = TZ.CODE_UTIL_TYPE           
MFA-TR*                   AND T1.CNTRCT_START_DT <= :WS-DATE-READ)              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7200-SELECT-TRNSP-CNT'                          
               DISPLAY         'SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY      'ACCOUNT_NO = ' TW-ACCOUNT-NO               
C34044         DISPLAY  'CODE_UTIL_TYPE = ' TW-CODE-UTIL-TYPE           
C34044         DISPLAY  'PRIMARY_IC_NO  = ' TZ-PRIMARY-IC-NO            
C34044         DISPLAY 'CNTRCT_START_DT = ' TZ-CNTRCT-START-DT          
C34044         DISPLAY       'DATE-READ = ' WS-DATE-READ                
               PERFORM 9900-ABEND     THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  GET FUTURE BILL HOOK IF IT EXISTS                        **           
      ***************************************************************           
      *                                                                         
       7310-OPEN-BIBG-CRSR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN BIBG_CRSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7310       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C34044         DISPLAY '**        OPEN BIBG_CRSR '                      
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *     7320-FETCH-BIBG-CRSR                                      *         
      *****************************************************************         
       7320-FETCH-BIBG-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH  BIBG_CRSR                                          
               INTO  :BI-BILL-NO                                        
                    ,:BG-PREMISE-NO                                     
                    ,:BG-BILL-NO                                        
                    ,:BG-CODE-UTIL-TYPE                                 
                    ,:BG-IC-NO                                          
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-DATE-ORIG-BILL :BG-DATE-ORIG-BILL-NULL          
                    ,:BG-AMT-BILL-ITEM                                  
                    ,:BG-CODE-BILL-CALC                                 
                    ,:BG-CODE-BILL-ITM-TYPE                             
                    ,:BG-CODE-BILL-ITM-IND                              
                    ,:BG-CODE-DR-CR-CNSMPTN                             
                    ,:BG-AMT-STATE-TAX                                  
                    ,:BG-AMT-CITY-TAX                                   
                    ,:BG-AMT-OTHER-TAX                                  
                    ,:BG-CODE-REVENUE-CLASS                             
                    ,:BG-CODE-SIC-NO                                    
                    ,:BG-RATE-PLAN-NO                                   
                    ,:BG-CODE-CURTAIL-PRTY                              
                    ,:BG-CODE-STAT-TAX-XMT                              
                    ,:BG-CODE-CITY-TAX-XMT                              
                    ,:BG-CODE-OTHR-TAX-XMT                              
                    ,:BG-REV-RPT-CD                                     
                    ,:BG-STANDBY-COMPLIED                               
                    ,:BG-PRORATE-CD                                     
                    ,:BG-NEW-RATE-PCT                                   
                    ,:BG-CODE-SUB-TOTAL                                 
                    ,:BG-TAX-REFUND-CD                                  
                    ,:BG-ACCOUNT-NO                                     
                    ,:BG-COMPANY-NO                                     
                    ,:BG-DATE-LFTM-HI-DMD :BG-DATE-LFTM-HI-DMD-NULL      
                    ,:BG-LFTM-HI-PEAK-DMD                               
                    ,:BG-REBILL-IND                                     
                    ,:BG-ADJ-REASON-CD                                  
                    ,:BG-REVENUE-MONTH                                  
                    ,:BG-GAS-BASE-USE                                   
                    ,:BG-WNA-FACTOR                                     
                    ,:BG-BTU-FACTOR                                     
                    ,:BG-NO-OF-CONS-DAYS                                
                    ,:BG-REV-MTH-ORIG-BILL                              
                    ,:BG-REV-DISTRICT-CD                                
                    ,:BG-FUEL-SHIPPER-CD                                
                    ,:BG-ALTERNATE-FUEL-CD                              
                    ,:BG-TRNSP-OVER-MDQ-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   SET END-OF-BIBG-CRSR     TO TRUE                     
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSCA323 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7320       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
C34044             DISPLAY '**        FETCH  BIBG_CRSR '                
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    7330-CLOSE-BIBG-CRSR                                     **         
      *****************************************************************         
       7330-CLOSE-BIBG-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
               CLOSE  BIBG_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7330       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
C34044         DISPLAY '**        CLOSE  BIBG_CRSR '                    
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    7400-GET-TRNSP-TIMESTMP                                 **          
      *****************************************************************         
       7400-GET-TRNSP-TIMESTMP.                                         
      *                                                                         
           EXEC SQL                                                     
C34044           SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :BG-BILL-ITEM-TIMESTMP,
              :WS-CURRENT-TS                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :BG-BILL-ITEM-TIMESTMP =                                   
MFA-TR*               TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND         
MFA-TR*             ,:WS-CURRENT-TS =                                           
MFA-TR*               CURRENT TIMESTAMP                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7400       **'       
               DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '**       TIMESTMP= ' BG-BILL-ITEM-TIMESTMP      
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **   7420-SELECT-TRNSP-HOOK                                    **         
      *****************************************************************         
       7420-SELECT-TRNSP-HOOK.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-TRNSP-HOOK-EXISTS                              
                FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO              
                  AND BILL_NO             = :BG-BILL-NO                 
                  AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE          
                  AND IC_NO               = :BG-IC-NO                   
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )      
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-TRNSP-HOOK-EXISTS                                      
MFA-TR*         FROM CSS_BILLING_DET                                            
MFA-TR*         WHERE ACCOUNT_NO          = :BG-ACCOUNT-NO                      
MFA-TR*           AND BILL_NO             = :BG-BILL-NO                         
MFA-TR*           AND CODE_UTIL_TYPE      = :BG-CODE-UTIL-TYPE                  
MFA-TR*           AND IC_NO               = :BG-IC-NO                           
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :BG-BILL-ITEM-TIMESTMP              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7420       **'       
               DISPLAY '**             SQLCODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '**             ACCOUNT = ' BG-ACCOUNT-NO        
C34044         DISPLAY '**             BILL_NO = ' BG-BILL-NO           
C34044         DISPLAY '**      CODE_UTIL_TYPE = ' BG-CODE-UTIL-TYPE    
C34044         DISPLAY '**               IC_NO = ' BG-IC-NO             
C34044         DISPLAY '** BILL_ITEM_TIMESTMP  = ' BG-BILL-ITEM-TIMESTMP
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      *       INSERT BILLING HDR INFO                              *            
      **************************************************************            
      *                                                                         
       8000-ISRT-BILLING-HDR.                                           
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILLING_HDR                              
                 (ACCOUNT_NO,                                           
                  PREMISE_NO,                                           
                  BILL_NO,                                              
                  DATE_BILLED,                                          
                  CODE_BILL_REASON,                                     
                  CODE_BILL_STATUS,                                     
                  CODE_BILL_TYPE,                                       
                  COMPANY_NO,                                           
                  CUSTOMER_NO,                                          
                  CODE_SPCL_BILL,                                       
                  PREM_ACCT_SEQ_NO,                                     
                  SMRY_BILL_NO,                                         
                  SMRY_REBILL_NO)                                       
               VALUES                                                   
                 (:BI-ACCOUNT-NO,                                       
                  :BI-PREMISE-NO,                                       
                  :BI-BILL-NO,                                          
                  IIF(TRY_CONVERT(DATE, :BI-DATE-BILLED 
                                        :BI-DATE-BILLED-NI
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED 
                                                     :BI-DATE-BILLED-NI
              ) <> 0) OR (LEN(:BI-DATE-BILLED :BI-DATE-BILLED-NI
              ) <> 10), CIS.CHAR2DATE(:BI-DATE-BILLED 
                                                     :BI-DATE-BILLED-NI
              ), CONVERT(DATE, :BI-DATE-BILLED :BI-DATE-BILLED-NI) ),          
                  :BI-CODE-BILL-REASON,                                 
                  :BI-CODE-BILL-STATUS,                                 
                  :BI-CODE-BILL-TYPE,                                   
                  :BI-COMPANY-NO,                                       
                  :BI-CUSTOMER-NO,                                      
                  :BI-CODE-SPCL-BILL,                                   
                  :BI-PREM-ACCT-SEQ-NO,                                 
                  :BI-SMRY-BILL-NO,                                     
                  :BI-SMRY-REBILL-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILLING_HDR                                      
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           PREMISE_NO,                                                   
MFA-TR*           BILL_NO,                                                      
MFA-TR*           DATE_BILLED,                                                  
MFA-TR*           CODE_BILL_REASON,                                             
MFA-TR*           CODE_BILL_STATUS,                                             
MFA-TR*           CODE_BILL_TYPE,                                               
MFA-TR*           COMPANY_NO,                                                   
MFA-TR*           CUSTOMER_NO,                                                  
MFA-TR*           CODE_SPCL_BILL,                                               
MFA-TR*           PREM_ACCT_SEQ_NO,                                             
MFA-TR*           SMRY_BILL_NO,                                                 
MFA-TR*           SMRY_REBILL_NO)                                               
MFA-TR*        VALUES                                                           
MFA-TR*          (:BI-ACCOUNT-NO,                                               
MFA-TR*           :BI-PREMISE-NO,                                               
MFA-TR*           :BI-BILL-NO,                                                  
MFA-TR*           :BI-DATE-BILLED:BI-DATE-BILLED-NI,                            
MFA-TR*           :BI-CODE-BILL-REASON,                                         
MFA-TR*           :BI-CODE-BILL-STATUS,                                         
MFA-TR*           :BI-CODE-BILL-TYPE,                                           
MFA-TR*           :BI-COMPANY-NO,                                               
MFA-TR*           :BI-CUSTOMER-NO,                                              
MFA-TR*           :BI-CODE-SPCL-BILL,                                           
MFA-TR*           :BI-PREM-ACCT-SEQ-NO,                                         
MFA-TR*           :BI-SMRY-BILL-NO,                                             
MFA-TR*           :BI-SMRY-REBILL-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 8000       **'        
              DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE       
C34044        DISPLAY '**       ACCOUNT = ' BI-ACCOUNT-NO               
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    8100-ISRT-BILLING-DET                                    **         
      *****************************************************************         
       8100-ISRT-BILLING-DET.                                           
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_BILLING_DET                               
                     (PREMISE_NO                                        
                     ,BILL_NO                                           
                     ,CODE_UTIL_TYPE                                    
                     ,IC_NO                                             
                     ,BILL_ITEM_TIMESTMP                                
                     ,DATE_ORIG_BILL                                    
                     ,AMT_BILL_ITEM                                     
                     ,CODE_BILL_CALC                                    
                     ,CODE_BILL_ITM_TYPE                                
                     ,CODE_BILL_ITM_IND                                 
                     ,CODE_DR_CR_CNSMPTN                                
                     ,AMT_STATE_TAX                                     
                     ,AMT_CITY_TAX                                      
                     ,AMT_OTHER_TAX                                     
                     ,CODE_REVENUE_CLASS                                
                     ,CODE_SIC_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_CURTAIL_PRTY                                 
                     ,CODE_STAT_TAX_XMT                                 
                     ,CODE_CITY_TAX_XMT                                 
                     ,CODE_OTHR_TAX_XMT                                 
                     ,ACCOUNT_NO                                        
                     ,COMPANY_NO                                        
                     ,REV_MTH_ORIG_BILL                                 
                     ,REV_DISTRICT_CD                                   
JSFIX                ,REV_RPT_CD)                                       
              VALUES (:BG-PREMISE-NO                                    
                     ,:BG-BILL-NO                                       
                     ,:BG-CODE-UTIL-TYPE                                
                     ,:BG-IC-NO                                         
                     ,CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP)                
                     ,IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                            :BG-DATE-ORIG-BILL-NULL
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                :BG-DATE-ORIG-BILL-NULL
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL 
                                                :BG-DATE-ORIG-BILL-NULL
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                :BG-DATE-ORIG-BILL-NULL
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                                :BG-DATE-ORIG-BILL-NULL
              ) )         
                     ,:BG-AMT-BILL-ITEM                                 
                     ,:BG-CODE-BILL-CALC                                
                     ,:BG-CODE-BILL-ITM-TYPE                            
                     ,:BG-CODE-BILL-ITM-IND                             
                     ,:BG-CODE-DR-CR-CNSMPTN                            
                     ,:BG-AMT-STATE-TAX                                 
                     ,:BG-AMT-CITY-TAX                                  
                     ,:BG-AMT-OTHER-TAX                                 
                     ,:BG-CODE-REVENUE-CLASS                            
                     ,:BG-CODE-SIC-NO                                   
                     ,:BG-RATE-PLAN-NO                                  
                     ,:BG-CODE-CURTAIL-PRTY                             
                     ,:BG-CODE-STAT-TAX-XMT                             
                     ,:BG-CODE-CITY-TAX-XMT                             
                     ,:BG-CODE-OTHR-TAX-XMT                             
                     ,:BG-ACCOUNT-NO                                    
                     ,:BG-COMPANY-NO                                    
                     ,:BG-REV-MTH-ORIG-BILL                             
                     ,:BG-REV-DISTRICT-CD                               
JSFIX                ,:BG-REV-RPT-CD)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BILLING_DET                                       
MFA-TR*              (PREMISE_NO                                                
MFA-TR*              ,BILL_NO                                                   
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,IC_NO                                                     
MFA-TR*              ,BILL_ITEM_TIMESTMP                                        
MFA-TR*              ,DATE_ORIG_BILL                                            
MFA-TR*              ,AMT_BILL_ITEM                                             
MFA-TR*              ,CODE_BILL_CALC                                            
MFA-TR*              ,CODE_BILL_ITM_TYPE                                        
MFA-TR*              ,CODE_BILL_ITM_IND                                         
MFA-TR*              ,CODE_DR_CR_CNSMPTN                                        
MFA-TR*              ,AMT_STATE_TAX                                             
MFA-TR*              ,AMT_CITY_TAX                                              
MFA-TR*              ,AMT_OTHER_TAX                                             
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*              ,CODE_SIC_NO                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,CODE_CURTAIL_PRTY                                         
MFA-TR*              ,CODE_STAT_TAX_XMT                                         
MFA-TR*              ,CODE_CITY_TAX_XMT                                         
MFA-TR*              ,CODE_OTHR_TAX_XMT                                         
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,REV_MTH_ORIG_BILL                                         
MFA-TR*              ,REV_DISTRICT_CD                                           
MFA-TR*              ,REV_RPT_CD)                                               
MFA-TR*       VALUES (:BG-PREMISE-NO                                            
MFA-TR*              ,:BG-BILL-NO                                               
MFA-TR*              ,:BG-CODE-UTIL-TYPE                                        
MFA-TR*              ,:BG-IC-NO                                                 
MFA-TR*              ,:BG-BILL-ITEM-TIMESTMP                                    
MFA-TR*              ,:BG-DATE-ORIG-BILL:BG-DATE-ORIG-BILL-NULL                 
MFA-TR*              ,:BG-AMT-BILL-ITEM                                         
MFA-TR*              ,:BG-CODE-BILL-CALC                                        
MFA-TR*              ,:BG-CODE-BILL-ITM-TYPE                                    
MFA-TR*              ,:BG-CODE-BILL-ITM-IND                                     
MFA-TR*              ,:BG-CODE-DR-CR-CNSMPTN                                    
MFA-TR*              ,:BG-AMT-STATE-TAX                                         
MFA-TR*              ,:BG-AMT-CITY-TAX                                          
MFA-TR*              ,:BG-AMT-OTHER-TAX                                         
MFA-TR*              ,:BG-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:BG-CODE-SIC-NO                                           
MFA-TR*              ,:BG-RATE-PLAN-NO                                          
MFA-TR*              ,:BG-CODE-CURTAIL-PRTY                                     
MFA-TR*              ,:BG-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*              ,:BG-ACCOUNT-NO                                            
MFA-TR*              ,:BG-COMPANY-NO                                            
MFA-TR*              ,:BG-REV-MTH-ORIG-BILL                                     
MFA-TR*              ,:BG-REV-DISTRICT-CD                                       
MFA-TR*              ,:BG-REV-RPT-CD)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
C34044        DISPLAY '**      ABEND IN PARAGRAPH 8100       **'        
              DISPLAY '**           SQLCODE = ' WS-ACTIVE-RETURN-CODE   
C34044        DISPLAY '**           ACCOUNT = ' BG-ACCOUNT-NO           
C34044        DISPLAY '**        PREMISE NO = ' BG-PREMISE-NO           
C34044        DISPLAY '**    CODE UTIL TYPE = ' BG-CODE-UTIL-TYPE       
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    8200-UPDATE-ACCOUNT.                                     **         
      *****************************************************************         
       8200-UPDATE-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET NXT_BILL_NO = :AT-NXT-BILL-NO                     
                WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 8200       **'        
              DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE       
C34044        DISPLAY '**       ACCOUNT = ' AT-ACCOUNT-NO               
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    7700-SELECT-UTIL-ENVRNT                                  **         
      *****************************************************************         
       7700-SELECT-UTIL-ENVRNMT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT IC_NO,                                             
                     CODE_ESTIMATE_OK,                                  
                     CODE_CURTAIL_PRTY,                                 
                     CODE_REVENUE_CLASS,                                
                     RATE_PLAN_NO,                                      
                     CODE_SIC_NO,                                       
                     CODE_MTR_READ_FREQ,                                
                     ACCOUNT_NO,                                        
                     SEASONAL_USE_CODE,                                 
                     READ_CYCLE,                                        
                     COMPANY_NO,                                        
                     CODE_STAT_TAX_XMT,                                 
                     CODE_CITY_TAX_XMT,                                 
                     CODE_OTHR_TAX_XMT                                  
                INTO :UT-IC-NO,                                         
                     :UT-CODE-ESTIMATE-OK,                              
                     :UT-CODE-CURTAIL-PRTY,                             
                     :UT-CODE-REVENUE-CLASS,                            
                     :UT-RATE-PLAN-NO,                                  
                     :UT-CODE-SIC-NO,                                   
                     :UT-CODE-MTR-READ-FREQ,                            
                     :UT-ACCOUNT-NO,                                    
                     :UT-SEASONAL-USE-CODE,                             
                     :UT-READ-CYCLE,                                    
                     :UT-COMPANY-NO,                                    
                     :UT-CODE-STAT-TAX-XMT,                             
                     :UT-CODE-CITY-TAX-XMT,                             
                     :UT-CODE-OTHR-TAX-XMT                              
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                    
                 AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO,                                                     
MFA-TR*              CODE_ESTIMATE_OK,                                          
MFA-TR*              CODE_CURTAIL_PRTY,                                         
MFA-TR*              CODE_REVENUE_CLASS,                                        
MFA-TR*              RATE_PLAN_NO,                                              
MFA-TR*              CODE_SIC_NO,                                               
MFA-TR*              CODE_MTR_READ_FREQ,                                        
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              SEASONAL_USE_CODE,                                         
MFA-TR*              READ_CYCLE,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              CODE_STAT_TAX_XMT,                                         
MFA-TR*              CODE_CITY_TAX_XMT,                                         
MFA-TR*              CODE_OTHR_TAX_XMT                                          
MFA-TR*         INTO :UT-IC-NO,                                                 
MFA-TR*              :UT-CODE-ESTIMATE-OK,                                      
MFA-TR*              :UT-CODE-CURTAIL-PRTY,                                     
MFA-TR*              :UT-CODE-REVENUE-CLASS,                                    
MFA-TR*              :UT-RATE-PLAN-NO,                                          
MFA-TR*              :UT-CODE-SIC-NO,                                           
MFA-TR*              :UT-CODE-MTR-READ-FREQ,                                    
MFA-TR*              :UT-ACCOUNT-NO,                                            
MFA-TR*              :UT-SEASONAL-USE-CODE,                                     
MFA-TR*              :UT-READ-CYCLE,                                            
MFA-TR*              :UT-COMPANY-NO,                                            
MFA-TR*              :UT-CODE-STAT-TAX-XMT,                                     
MFA-TR*              :UT-CODE-CITY-TAX-XMT,                                     
MFA-TR*              :UT-CODE-OTHR-TAX-XMT                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO     = :UT-ACCOUNT-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7700       **'        
              DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**        ACCOUNT = ' UT-ACCOUNT-NO              
              DISPLAY '**             IC = ' UT-IC-NO                   
C34044        DISPLAY '** CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE          
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    7800-SELECT-PREMISE                                 **              
      *****************************************************************         
       7800-SELECT-PREMISE.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     PREMISE_NO,                                        
                     PREM_ACCT_SEQ_NO,                                  
                     REV_DISTRICT_CD                                    
                INTO :PR-LOCAL-OFFICE,                                  
                     :PR-PREMISE-NO,                                    
                     :PR-PREM-ACCT-SEQ-NO,                              
                     :PR-REV-DISTRICT-CD                                
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              PREM_ACCT_SEQ_NO,                                          
MFA-TR*              REV_DISTRICT_CD                                            
MFA-TR*         INTO :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-PREMISE-NO,                                            
MFA-TR*              :PR-PREM-ACCT-SEQ-NO,                                      
MFA-TR*              :PR-REV-DISTRICT-CD                                        
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7800       **'        
              DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PREMISE = ' PR-PREMISE-NO               
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T36599****************************************************************          
T36599*  7805-GET-COMP-DESC                                          *          
T36599****************************************************************          
      *                                                                         
T36599 7805-GET-COMP-DESC.                                              
      *                                                                         
T36599     EXEC SQL                                                     
T36599        SELECT C7.COMPANY_NAME                                    
T36599          INTO :C7-COMPANY-NAME                                   
T36599          FROM CSS_COMPANY C7                                     
T36599         WHERE C7.COMPANY_NO = :C7-COMPANY-NO                     
T36599     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T36599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
T36599     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T36599        CONTINUE                                                  
T36599     ELSE                                                         
T36599        DISPLAY '****************************************'        
T36599        DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
T36599        DISPLAY '**      ABEND IN PARAGRAPH 7805       **'        
T36599        DISPLAY '**       SQLCODE    = ' WS-ACTIVE-RETURN-CODE    
T36599        DISPLAY '**       COMPANY NO = ' C7-COMPANY-NO            
T36599        DISPLAY '****************************************'        
T36599        PERFORM 9900-ABEND               THRU 9900-EXIT           
T36599     END-IF.                                                      
      *                                                                         
T36599 7805-EXIT.                                                       
T36599     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7900-INSERT-VOL-DAILY                                    **         
      *****************************************************************         
      *                                                                         
       7900-INSERT-VOL-DAILY.                                           
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_VOL_DAILY                                 
                    (ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,VOL_TYPE_CD                                        
                    ,ENERGY_UNIT_CD                                     
                    ,DATE_READ                                          
                    ,NO_UNITS)                                          
              VALUES                                                    
                   (:ND-ACCOUNT-NO                                      
                   ,:ND-BILL-NO                                         
                   ,:ND-CODE-UTIL-TYPE                                  
                   ,:ND-IC-NO                                           
                   ,CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP)                  
                   ,:ND-VOL-TYPE-CD                                     
                   ,:ND-ENERGY-UNIT-CD                                  
                   ,IIF(TRY_CONVERT(DATE, :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                                
                   ,:ND-NO-UNITS)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_VOL_DAILY                                         
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,VOL_TYPE_CD                                                
MFA-TR*             ,ENERGY_UNIT_CD                                             
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,NO_UNITS)                                                  
MFA-TR*       VALUES                                                            
MFA-TR*            (:ND-ACCOUNT-NO                                              
MFA-TR*            ,:ND-BILL-NO                                                 
MFA-TR*            ,:ND-CODE-UTIL-TYPE                                          
MFA-TR*            ,:ND-IC-NO                                                   
MFA-TR*            ,:ND-BILL-ITEM-TIMESTMP                                      
MFA-TR*            ,:ND-VOL-TYPE-CD                                             
MFA-TR*            ,:ND-ENERGY-UNIT-CD                                          
MFA-TR*            ,:ND-DATE-READ                                               
MFA-TR*            ,:ND-NO-UNITS)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE          EQUAL ALREADY-EXISTS    
                 PERFORM 7950-UPDATE-VOL-DAILY   THRU 7950-EXIT         
              ELSE                                                      
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA323 PROCESSING ERROR      **'     
                 DISPLAY '**      ABEND IN PARAGRAPH 7900       **'     
                 DISPLAY '**         SQLCODE = ' WS-ACTIVE-RETURN-CODE  
                 DISPLAY '**         ACCOUNT = ' ND-ACCOUNT-NO          
C34044           DISPLAY '**         BILL-NO = ' ND-BILL-NO             
C34044           DISPLAY '**  CODE-UTIL-TYPE = ' ND-CODE-UTIL-TYPE      
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **    7950-UPDATE-VOL-DAILY                                    **         
      *****************************************************************         
       7950-UPDATE-VOL-DAILY.                                           
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_VOL_DAILY                                      
                 SET NO_UNITS  = :ND-NO-UNITS                           
               WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO               
                 AND BILL_NO             = :ND-BILL-NO                  
                 AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE           
                 AND IC_NO               = :ND-IC-NO                    
                 AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )       
                 AND VOL_TYPE_CD         = :ND-VOL-TYPE-CD              
                 AND ENERGY_UNIT_CD      = :ND-ENERGY-UNIT-CD           
                 AND DATE_READ           = IIF(TRY_CONVERT(DATE, 
                                                          :ND-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :ND-DATE-READ
              ) <> 0) OR (LEN(:ND-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :ND-DATE-READ
              ), CONVERT(DATE, :ND-DATE-READ) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_VOL_DAILY                                              
MFA-TR*          SET NO_UNITS  = :ND-NO-UNITS                                   
MFA-TR*        WHERE ACCOUNT_NO          = :ND-ACCOUNT-NO                       
MFA-TR*          AND BILL_NO             = :ND-BILL-NO                          
MFA-TR*          AND CODE_UTIL_TYPE      = :ND-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :ND-IC-NO                            
MFA-TR*          AND BILL_ITEM_TIMESTMP  = :ND-BILL-ITEM-TIMESTMP               
MFA-TR*          AND VOL_TYPE_CD         = :ND-VOL-TYPE-CD                      
MFA-TR*          AND ENERGY_UNIT_CD      = :ND-ENERGY-UNIT-CD                   
MFA-TR*          AND DATE_READ           = :ND-DATE-READ                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**     PCSCA323 PROCESSING ERROR      **'        
              DISPLAY '**      ABEND IN PARAGRAPH 7950       **'        
              DISPLAY '            SQLCODE = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '            ACCOUNT = ' ND-ACCOUNT-NO            
C34044        DISPLAY '            BILL_NO = ' ND-BILL-NO               
C34044        DISPLAY '     CODE_UTIL_TYPE = ' ND-CODE-UTIL-TYPE        
C34044        DISPLAY '              IC_NO = ' ND-IC-NO                 
C34044        DISPLAY ' BILL_ITEM_TIMESTMP = ' ND-BILL-ITEM-TIMESTMP    
C34044        DISPLAY '        VOL_TYPE_CD = ' ND-VOL-TYPE-CD           
C34044        DISPLAY '     ENERGY_UNIT_CD = ' ND-ENERGY-UNIT-CD        
C34044        DISPLAY '          DATE_READ = ' ND-DATE-READ             
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    7600-START-FCSJC01.                                                  
      *    7610-READ-FCSJC01.                                                   
      *    7611-CLOSE.                                                          
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    7620-START-FCSCA00.                                                  
      *    7621-READ-FCSCA00.                                                   
      *    7622-CLOSE-CA00-CSR.                                                 
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
       7450-SELECT-RESTART-DATA.                                        
                                                                        
           MOVE '7450'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                 
                  AND PARTITION_NO   = :RF-PARTITION-NO                 
                  AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                 
C34044                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                         
MFA-TR*           AND PARTITION_NO   = :RF-PARTITION-NO                         
MFA-TR*           AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA323 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7450       **'       
               DISPLAY ' RETURN CODE    = ' WS-ACTIVE-RETURN-CODE       
C34044         DISPLAY ' NAME_PROGRAM   = ' RF-NAME-PROGRAM             
C34044         DISPLAY ' PARTITION_NO   = ' RF-PARTITION-NO             
C34044         DISPLAY ' DUP_CNTRL_NO   = ' RF-DUP-CNTRL-NO             
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
           END-IF.                                                      
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *    7500-GET-CURRENT-TIMESTAMP                              *            
      **************************************************************            
       7500-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
C34044             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*            SET :WS-CURRENT-TIMESTAMP =                                  
MFA-TR*                 CURRENT TIMESTAMP                                       
MFA-TR*               ,:WS-CURRENT-DATE =                                       
MFA-TR*                 CURRENT DATE                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '7500-GET-CURRENT-TIMESTAMP'                      
36599         DISPLAY 'SQLCODE = ' WS-ACTIVE-RETURN-CODE                
36599         DISPLAY 'DATE    = ' WS-CURRENT-DATE                      
36599         DISPLAY 'TIME    = ' WS-CURRENT-TIMESTAMP                 
              PERFORM 9900-ABEND THRU  9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *    7550-GET-MAX-WQ-LIMIT                                   *            
      **************************************************************            
       7550-GET-MAX-WQ-LIMIT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO  :C8-DELINQ-VALUE                                  
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = :C8-DELINQ-CD                        
                 AND  COMPANY_NO = :C8-COMPANY-NO                       
C34044                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO  :C8-DELINQ-VALUE                                          
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*          AND  COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '***********************************************'
               DISPLAY '**        PCSCA323 PROCESSING ERROR          **'
               DISPLAY '**         ABEND IN PARAGRAPH 7550           **'
               DISPLAY '**    ERROR ON SELECT FROM CSS_DELINQUENCY   **'
               DISPLAY '** DELINQ_CD = ' C8-DELINQ-CD '   ; SQLCODE = ' 
                       SQLCODE                                          
               DISPLAY '** DCOMPANY_NO= ' C8-COMPANY-NO ' ; SQLCODE = ' 
                       SQLCODE                                          
               DISPLAY '**  PROCESSING TERMINATED               **'     
               PERFORM 9900-ABEND      THRU  9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T36599****************************************************************          
T36599**   PRINT HEADERS                                            **          
T36599****************************************************************          
      *                                                                         
T36599 8300-PRINT-HEADERS.                                              
      *                                                                         
T36599     ADD 1 TO WS-PAGE-COUNT.                                      
T36599     MOVE WS-PAGE-COUNT TO P-RPT-PAGE-NO.                         
      *                                                                         
T36599     MOVE WS-PGRMNAME             TO P-RPT-TITLE-PGNM.            
T36599     MOVE WS-SCEG-COMP-NAME       TO P-RPT-DUMMY.                 
T36599     MOVE WS-RPT-TITLE            TO P-RPT-REP-NAME.              
      *                                                                         
T36599     MOVE  WS-RPT-TITLE-1         TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD AFTER ADVANCING TOP-OF-PAGE.              
T36599                                                                  
T36599     MOVE  WS-RPT-TITLE-2         TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE  WS-RPT-TITLE-3         TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE  WS-BLANK-LINE          TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE 4                       TO WS-RPT-LINE-NO.              
      *                                                                         
T36599     MOVE  WS-RPT-TITLE-4         TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE  WS-RPT-TITLE-5         TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     MOVE  WS-BLANK-LINE          TO PRT33-DATA.                  
T36599     WRITE PRT33-RECORD.                                          
      *                                                                         
T36599     ADD 3                        TO WS-RPT-LINE-NO.              
      *                                                                         
T36599 8300-EXIT.                                                       
T36599     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8893-RESET-RESTART-REQ-PARM                                   *         
      * 8894-COUNT-RESTART-DATA                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
      *                                                                         
       8896-ISSUE-CHKP.                                                 
      *                                                                         
           MOVE '8896'                 TO ACTIVE-PARAGRAPH.             
           IF WS-CHKP-LUW-LIMIT     EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS   
              GO TO 8896-EXIT                                           
           END-IF.                                                      
           ADD WS-ONE                TO WS-CHKP-SEQ-NO.                 
           MOVE WS-CHKP-SEQ-NO       TO WS-RESTART-CHKP-SEQ-NO.         
                                                                        
C34044     MOVE WS-IN-ACCOUNT-NO     TO WS-RESTART-CUSTOMER-NO.         
           MOVE WS-INPUT-RECS-READ   TO WS-RESTART-RECS-READ.           
           MOVE WS-NO-OF-RECS-INSRTD TO WS-RESTART-NO-OF-RECS-INSRTD.   
           MOVE WS-NO-OF-ERR-RECS    TO WS-RESTART-NO-OF-ERR-RECS.      
PRJ853     MOVE WS-TOT-SCPC-DELV-VOL TO WS-RESTART-TOT-SCPC-DELV-VOL.   
           MOVE WS-TOT-NOMINATED-VOL TO WS-RESTART-TOT-NOMINATED-VOL.   
           MOVE WS-TOT-NOM-ERROR-VOL TO WS-RESTART-TOT-NOM-ERROR-VOL.   
           MOVE WS-TOT-DELIVERED-VOL TO WS-RESTART-TOT-DELIVERED-VOL.   
                                                                        
           PERFORM 8897-WRITE-RSDDR    THRU 8897-EXIT.                  
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
                   'LAST CHECK ENTRY PROCESSED = '                      
                    WS-RESTART-RECS-READ       '/'                      
                   ' ACCOUNT NO = ' WS-IN-ACCOUNT-NO.                   
           MOVE ZERO          TO WS-CHKP-LUW-COUNTER                    
                                 WS-CHKP-UPD-COUNTER.                   
      *                                                                         
       8896-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8897-WRITE-RSDDR.                                                
           MOVE WS-ONE                       TO RF-PARTITION-NO.        
           MOVE PROGRAM-NAME                 TO RF-NAME-PROGRAM.        
           MOVE WS-ONE                       TO RF-DUP-CNTRL-NO.        
           MOVE WS-RESTART-DATA              TO RF-RESTART-DATA-TEXT.   
           MOVE LENGTH OF WS-RESTART-DATA    TO RF-RESTART-DATA-LEN.    
           PERFORM 8898-UPDATE-RESTART     THRU 8898-EXIT.              
           IF WS-ACTIVE-RETURN-CODE       EQUAL NOT-FOUND               
              PERFORM 8899-INSERT-RESTART  THRU 8899-EXIT               
           END-IF.                                                      
       8897-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8898-UPDATE-RESTART.                                             
      *                                                                         
           MOVE '8898'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
                  SET RESTART_DATA = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD WS-ONE              TO WS-CHKP-UPD-COUNTER           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 DISPLAY '*****************************************'    
                 DISPLAY '**     PCSCA323 PROCESSING ERROR       **'    
                 DISPLAY '**      ABEND IN PARAGRAPH 8898        **'    
                 DISPLAY '  RETURN CODE =' WS-ACTIVE-RETURN-CODE        
C34044           DISPLAY ' NAME_PROGRAM =' RF-NAME-PROGRAM              
C34044           DISPLAY ' PARTITION_NO =' RF-PARTITION-NO              
C34044           DISPLAY ' DUP_CNTRL_NO =' RF-DUP-CNTRL-NO              
                 PERFORM 9900-ABEND           THRU 9900-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8899-INSERT-RESTART.                                             
           MOVE '8899'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE      EQUAL SUCCESSFUL-CALL          
               ADD WS-ONE                   TO WS-CHKP-UPD-COUNTER      
           ELSE                                                         
               DISPLAY '*****************************************'      
               DISPLAY '**     PCSCA323 PROCESSING ERROR       **'      
               DISPLAY '**      ABEND IN PARAGRAPH 8899        **'      
               DISPLAY '  RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
C34044         DISPLAY ' NAME_PROGRAM = ' RF-NAME-PROGRAM               
C34044         DISPLAY ' PARTITION_NO = ' RF-PARTITION-NO               
C34044         DISPLAY ' DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO               
C34044         DISPLAY ' RESTART_DATA = ' RF-RESTART-DATA               
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
       8899-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      **  TERMINATION PARAGRAPH                                    **           
      ***************************************************************           
       9000-TERMINATE.                                                  
           CLOSE FCSCA323-FILE.                                         
           CLOSE FCSPT33-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
      ******************************************************************        
      * 9900-ABEND                                                              
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
             END-EXEC.                                                          
